<?php

$session = Bug_Monitor_Helper::$db->get_row(Bug_Monitor_Helper::$db->prepare("SELECT * FROM " . Bug_Monitor_Helper::$db->bug_monitor_sessions. " WHERE hash = %s", $_GET['bm-session']));
list($width, $height) = explode('x', (string)$session->resolution);
$html = base64_encode(Bug_Monitor_Helper::ugz($session->source));
$mutations = Bug_Monitor_Helper::ugz($session->mutations);
$mutations = preg_replace('~<head([^>]*)>~', '<bmhead$1>', $mutations);
?>
<!DOCTYPE html>
<html>
<head>
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
      <meta name="viewport" content="width=device-width,initial-scale=1.0">
      <link rel="stylesheet" href="<?php echo BUG_MONITOR_PLUGIN_URL;?>assets/session.css?ver=<?php echo md5_file(BUG_MONITOR_PLUGIN_DIR . 'assets/session.css');?>">
      <script>
            var seekInterval;
            var sessionTimer = 0;
            var framesTimers = [];
            var bm_cursor, bm_click_circle;
            var is_touch_device = <?php echo (Bug_Monitor_Helper::is_touch_device($session->ua) ? 'true' : 'false');?>;
            var mutations = <?php echo $mutations;?>;
            var session_ajax_url = '<?php echo add_query_arg(array('action' => 'bug_monitor', 'nonce' => wp_create_nonce('bug-monitor-ajax'), 'bmaction' => 'load-session', 'session' => $_GET['bm-session']), admin_url('admin-ajax.php'));?>';
      </script>
</head>
<body>
      <main>
            <div class="video-wrapper" data-width="<?php echo (int)$width;?>" data-height="<?php echo (int)$height;?>">
                  <iframe id="session_frame" style="user-select:none;pointer-events:none;transform-origin:0 0;" width="<?php echo $width;?>" height="<?php echo $height;?>" sandbox="allow-same-origin"></iframe>
            </div>
            <div class="overlay">
                  <div class="details-wrapper">
                        <span class="bm-device-icons"><?php echo Bug_Monitor_Helper::get_device_icons($session->ua);?> (<?php echo esc_html($session->resolution);?>)</span>
                        <span><?php echo date(get_option('date_format') . ' ' . get_option('time_format'), strtotime($session->timestamp));?></span>
                  </div>
                  <div class="controls-wrapper">
                        <div class="seekbar-wrapper" data-action="seek">
                              <div class="seekbar"><div class="seekbar-inner"></div></div>
                        </div>
                        <div class="controls">
                              <img src="<?php echo BUG_MONITOR_PLUGIN_URL?>/images/icons/pause.svg" data-action="pause">
                              <img src="<?php echo BUG_MONITOR_PLUGIN_URL?>/images/icons/play.svg" data-action="start" class="hidden">
                              <img src="<?php echo BUG_MONITOR_PLUGIN_URL?>/images/icons/rewind.svg" data-action="restart">
                              <div class="timer"><span class="actual-time">0:02</span> / <span class="total-time">0:30</span></div>
                        </div>
                  </div>
            </div>
      </main>
      <script src="<?php echo BUG_MONITOR_PLUGIN_URL;?>assets/session.js?ver=<?php echo md5_file(BUG_MONITOR_PLUGIN_DIR . 'assets/session.js');?>"></script>
</body>
</html>