<div class="bug-monitor-tab-inner bug-monitor-filters">
      <label for="bug-monitor-filters-mobile-trigger">
            <h3>Filters</h3>
            <span class="dashicons dashicons-list-view"></span>
      </label>
      <input type="checkbox" id="bug-monitor-filters-mobile-trigger">
      <div class="bug-monitor-controls">
            <h3><?php esc_html_e('Event type', 'bug-monitor');?></h3>
            <fieldset id="bug-monitor-category-filter">
                  <label><input type="checkbox" class="select-all" value="" checked><span class="bug-monitor-checkbox"></span><?php esc_html_e('Select All', 'bug-monitor');?> <span class="bm-count bm-all">0</span></label>
                  <label><input type="checkbox" value="functional" checked><span class="bug-monitor-checkbox"></span><?php esc_html_e('Functional issues', 'bug-monitor');?> <span class="bm-count">0</span></label>
                  <label><input type="checkbox" value="js" checked><span class="bug-monitor-checkbox"></span><?php esc_html_e('JavaScript errors', 'bug-monitor');?> <span class="bm-count">0</span></label>
                  <label><input type="checkbox" value="network" checked><span class="bug-monitor-checkbox"></span><?php esc_html_e('Network errors', 'bug-monitor');?> <span class="bm-count">0</span></label>
                  <label><input type="checkbox" value="seo" checked><span class="bug-monitor-checkbox"></span><?php esc_html_e('SEO problems', 'bug-monitor');?> <span class="bm-count">0</span></label>
                  <label><input type="checkbox" value="ux" checked><span class="bug-monitor-checkbox"></span><?php esc_html_e('UX problems', 'bug-monitor');?> <span class="bm-count">0</span></label>
                  <label><input type="checkbox" value="ui" checked><span class="bug-monitor-checkbox"></span><?php esc_html_e('UI problems', 'bug-monitor');?> <span class="bm-count">0</span></label>
                  <label><input type="checkbox" value="webvitals" checked><span class="bug-monitor-checkbox"></span><?php esc_html_e('WebVitals issues', 'bug-monitor');?> <span class="bm-count">0</span></label>
                  <label><input type="checkbox" value="php" checked><span class="bug-monitor-checkbox"></span><?php esc_html_e('WordPress errors', 'bug-monitor');?> <span class="bm-count">0</span></label>
            </fieldset>

            <h3><?php esc_html_e('Event Level', 'bug-monitor');?></h3>
            <fieldset id="bug-monitor-level-filter">
                  <label><input type="checkbox" value="critical" checked><span class="bug-monitor-checkbox"></span><span class="bug-monitor-filter-dot bm-critical"></span><?php esc_html_e('Critical', 'bug-monitor');?> <span class="bm-count">0</span></label>
                  <label><input type="checkbox" value="error" checked><span class="bug-monitor-checkbox"></span><span class="bug-monitor-filter-dot bm-error"></span><?php esc_html_e('Error', 'bug-monitor');?> <span class="bm-count">0</span></label>
                  <label><input type="checkbox" value="warning" checked><span class="bug-monitor-checkbox"></span><span class="bug-monitor-filter-dot bm-warning"></span><?php esc_html_e('Warning', 'bug-monitor');?> <span class="bm-count">0</span></label>
            </fieldset>

            <h3><?php esc_html_e('Status', 'bug-monitor');?></h3>
            <fieldset id="bug-monitor-status-filter">
                  <label><input type="radio" name="bm-status" value="active" checked><span class="bug-monitor-checkbox"></span><?php esc_html_e('Active', 'bug-monitor');?> <span class="bm-count">0</span></label>
                  <label><input type="radio" name="bm-status" value="ignored"><span class="bug-monitor-checkbox"></span><?php esc_html_e('Ignored', 'bug-monitor');?> <span class="bm-count">0</span></label>
            </fieldset>
      </div>
</div>
<div class="bug-monitor-tab-inner">
      <div id="bug-monitor-pagination-info"><span class="bm-from-to">1-1</span> <?php esc_html_e('of', 'bug-monitor');?><span class="bm-total">0</span></div>
      <div id="bug-monitor-events">
            <?php foreach (Bug_Monitor_Log::get_logs(array('status' => array(-1,1,2))) as $key => $log):?>
                  <div class="bug-monitor-event" data-event-hash="<?php echo esc_attr($key);?>" data-category="<?php echo esc_attr($log['category']);?>" data-type="<?php echo esc_attr($log['type']);?>" data-level="<?php echo esc_attr($log['level']);?>" data-status="<?php echo ($log['status'] == -1 ? 'ignored' : 'active');?>">
                        <a href="#" class="bug-monitor-undo-action"><?php esc_html_e('Undo', 'bug-monitor')?></a>
                        <div class="bug-monitor-event-row">
                              <?php echo Bug_Monitor_Helper::get_template('log-entry', $log);?>
                        </div>
                  </div>
            <?php endforeach; ?>
            <div class="bug-monitor-no-event bm-hidden">
                  <?php esc_html_e('No errors detected! Your site appears to be running smoothly.', 'bug-monitor');?>
            </div>
            <div class="bug-monitor-no-ignored-event bm-hidden">
                  <?php esc_html_e('There are no ignored events', 'bug-monitor');?>
            </div>
      </div>
      <div id="bug-monitor-pagination-wrapper">
            <a id="bug-monitor-prev-page" href="#prev"><?php esc_html_e('Prev', 'bug-monitor');?></a>
            <div id="bug-monitor-pagination"></div>
            <a id="bug-monitor-next-page" href="#next"><?php esc_html_e('Next', 'bug-monitor');?></a>
      </div>
</div>