<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo esc_html($data['title']);?></title>
    <style>
          body {
                font-family: Arial, sans-serif;
                margin: 0;
                padding: 0;
          }

          .container {
                max-width: 600px;
                margin: 0 auto;
                padding: 20px;
                border: 1px solid #e4e4e4;
          }

          .header {
                background-color: #333;
                padding: 20px;
                text-align: center;
          }

          .header img {
                max-width: 150px;
          }

          .body-content {
                padding: 20px;
          }

          .footer {
                background-color: #f4f4f4;
                padding: 20px;
                text-align: center;
                font-size: 12px;
          }

          .bm-critical {
                background: #5936dd;
          }

          .bm-error {
                background: #e94552;
          }

          .bm-warning {
                background: #ffc34f;
          }

          .bug-monitor-event-icon-wrapper {
                width: 100px;
          }

          .btn,
          .btn:hover {
                display: inline-block;
                background: #5936dd;
                padding: 10px 20px;
                color: #fff;
                font-weight: 600;
                font-size: 14px;
                text-decoration: none;
                text-transform: uppercase;
          }

          .btn img {
                height: 12px;
                margin-right: 10px;
          }

          .bug-monitor-event-icon {
                width: 50px;
                height: 50px;
                padding: 20px;
          }

          .bug-monitor-event-icon img {
                width: 35px;
                height: 35px;
          }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header with Logo -->
        <div class="header">
            <img src="<?php echo BUG_MONITOR_SITE_URL;?>images/logo-white.png" alt="Bug Monitor">
        </div>

        <!-- Body Content -->
        <div class="body-content">
            <h2><?php echo esc_html($data['title']);?></h2>
            <p style="color: #888;font-size: .95em;margin-bottom: 40px;"><?php echo esc_html($data['description']);?></p>
            <?php foreach ($data['logs'] as $key => $log):?>
                  <div class="bug-monitor-event" data-event-hash="<?php echo esc_attr($key);?>" data-category="<?php echo esc_attr($log['category']);?>" data-type="<?php echo esc_attr($log['type']);?>" data-level="<?php echo esc_attr($log['level']);?>">
                        <div class="bug-monitor-event-row">
                              <?php echo Bug_Monitor_Helper::get_template('email/event', $log);?>
                        </div>
                  </div>
            <?php endforeach; ?>
        </div>

        <!-- Footer -->
        <div class="footer">
            <?php echo sprintf(esc_html__('This email was auto-generated and sent from %s'), '<a href="' . home_url() .'" target="_blank">' . get_bloginfo('name') . '</a>');?><br>
            <?php echo sprintf(esc_html__('You can disable e-mail notifications in %sBug Monitor settings%s'), '<a href="' . Bug_Monitor_Helper::get_dashbord_url().'" target="_blank">','</a>');?>
        </div>
    </div>
</body>
</html>
