<div id="bug-monitor-head">
      <a href="<?php echo Bug_Monitor_Helper::get_dashbord_url();?>">
            <img id="bug-monitor-logo" src="<?php echo BUG_MONITOR_PLUGIN_URL;?>/images/logo.png">
      </a>
      <div class="bug-monitor-nav">
            <a href="#report" class="bm-hidden">
                  <img src="<?php echo BUG_MONITOR_PLUGIN_URL;?>/images/icons/report.svg">
                  <?php esc_html_e('Report', 'bug-monitor');?>
            </a>
            <a href="#settings">
                  <img src="<?php echo BUG_MONITOR_PLUGIN_URL;?>/images/icons/settings.svg">
                  <?php esc_html_e('Settings', 'bug-monitor');?>
            </a>
      </div>
</div>

<?php foreach (Bug_Monitor_Dashboard::$messages as $message):?>
      <div class="bug-monitor-message">
            <?php echo $message['text'];?>
      </div>
<?php endforeach;?>

<div class="bug-monitor-tab bug-monitor-tab-settings bm-hidden">
      <?php echo Bug_Monitor_Helper::get_template('settings');?>
</div>


<div class="bug-monitor-tab bug-monitor-tab-report">
      <?php echo Bug_Monitor_Helper::get_template('report');?>
</div>

<script id="bug-monitor-popup-template" type="text/template">
      <div class="bug-monitor-popup">
            <a href="#" class="bug-monitor-popup-close">&times;</a>
            <div class="bug-monitor-popup-inner">
                  <div class="bm-loading"></div>
            </div>
      </div>
</script>

<script id="bug-monitor-message-template" type="text/template">
      <div class="bug-monitor-message">
            <div class="bug-monitor-message-inner"></div>
            <a href="#" class="bug-monitor-message-close">&times;</a>
      </div>
</script>

<script id="bug-monitor-notification-endpoint-template" type="text/template">
      <div class="bm-notification-endpoint">
            <div class="bm-notification-endpoint-label"></div>
            <form>
                  <input type="hidden" name="id">
                  <input type="hidden" name="type">
                  <input type="hidden" name="action" value="bug_monitor">
                  <input type="hidden" name="bmaction" value="notifications/remove">
                  <a href="#" class="bm-remove-endpoint bm-btn bm-btn-interactive"><?php esc_html_e('Remove', 'bug-monitor')?></a>
            </form>
      </div>
</script>