<?php

class Bug_Monitor_Cron {

      public static function init(){
            add_filter('cron_schedules', array(__CLASS__, 'add_intervals'));

            add_action('bug_monitor/daily', array('Bug_Monitor_Cron', 'daily'));
            add_action('bug_monitor/five_minutes', array('Bug_Monitor_Cron', 'five_minutes'));

            Bug_Monitor_Cron::schedule();
      }

      public static function schedule(){
            if (!wp_next_scheduled('bug_monitor/daily')) {
                  wp_schedule_event(time() + 60, 'daily', 'bug_monitor/daily');
            }

            if (!wp_next_scheduled('bug_monitor/five_minutes')) {
                  wp_schedule_event(time() + 60, 'five_minutes', 'bug_monitor/five_minutes');
            }
      }

      public static function deschedule(){
            wp_clear_scheduled_hook('bug_monitor/daily');
            wp_clear_scheduled_hook('bug_monitor/five_minutes');
      }

      public static function daily(){
            Bug_Monitor_Log::delete_expired_events();
            Bug_Monitor_Log::clear_abandoned_visuals();
            if (Bug_Monitor::check_option('ux/bounce_rate', 'on')){
                  Bug_Monitor_Log::check_bounce_rate();
            }
            if (Bug_Monitor::check_option('notification/status', 'on')){
                  Bug_Monitor_Notification::daily_notifications();
            }
            Bug_Monitor_Notification::check_endpoints();
      }

      public static function five_minutes(){
            if (Bug_Monitor::check_option('notification/status', 'on')){
                  Bug_Monitor_Notification::five_minutes_notifications();
            }
      }

      public static function add_intervals($schedules){
            $schedules['five_minutes'] = array(
                  'interval' => 300,
                  'display'  => __('Every 5 Minutes', 'bug-monitor'),
            );

            return $schedules;
      }

}