<?php

/**
 * API Class
 */
class Bug_Monitor_Api {
      public static function request($endpoint, $data = NULL){
            $response = wp_remote_post(BUG_MONITOR_API_URL . $endpoint, apply_filters('bug_monitor_api_request_args', array(
                  'headers' => self::get_request_headers(),
                  'body' => $data,
                  'timeout' => 60,
                  'sslverify' => false
            )));
            if (is_wp_error($response)){
                  return false;
            }

            return $response;
      }
      public static function get_request_headers(){
            return array(
                  'x-site' => home_url(),
                  'x-site-key' => self::get_site_key(),
                  'x-license' => (Bug_Monitor::check_option('license-handling', 'v2') ? 'v2' : 'v1')
            );
      }
      public static function get_site_key(){
            return md5((defined('NONCE_SALT') ? NONCE_SALT : ABSPATH) . home_url());
      }

}

?>