<?php
/**
 * Icon manage class
 *
 * @link       https://superwebshare.com
 * @since      2.4
 *
 * @package    Super_Web_Share
 * @subpackage Super_Web_Share/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      2.4
 * @package    Super_Web_Share
 * @subpackage Super_Web_Share/includes
 * @author     SuperWebShare <support@superwebshare.com>
 */
class Super_Web_Share_Icons {

	/**
	 * In-build SVG icons paths.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Super_Web_Share_Icons    $icons    Maintains and registers all hooks for the plugin.
	 */
	protected $icons = array(
		'share-icon-1'   => array(
			'd'           => array(
				'M789.86,323.67c91.79,0,164.25-72.46,164.25-164.25S881.64,0,789.86,0S625.6,72.46,625.6,164.25c0,4.83,0,14.49,0,24.15L306.76,371.98c-24.15-24.15-57.97-33.82-96.62-33.82c-91.79,0-164.25,72.46-164.25,164.25s72.46,164.25,164.25,164.25c38.65,0,72.46-14.49,96.62-33.82L625.6,821.26c0,9.66,0,14.49,0,19.32c0,86.96,72.46,159.42,159.42,159.42s159.42-72.46,159.42-159.42s-67.63-159.42-154.59-159.42c-33.82,0-67.63,9.66-96.62,33.82L374.4,526.57c0-9.66,0-19.32,0-24.15s0-14.49,0-24.15l318.84-188.41C717.39,314.01,751.21,323.67,789.86,323.67z',
			),
			'fill'        => 'currentColor',
			'stock-width' => '0',
			'type'        => 'share',
		),
		'share-icon-2'   => array(
			'd'           => array(
				'M898.84,451.11l-91.15,95.2c0,39.87,0,77.85,0,103.99c0,31.06,0,62.12,0,93.18c0,2.9,0.02,5.79,0,8.69 c0,0.41,0,0.83,0,1.25c-0.03,2.84-0.07,5.68-0.21,8.52c-0.06,1.2-0.99,9.25-1.1,11.25c-0.5,2.44-1.16,5.73-1.12,5.57 c-0.88,4-1.91,7.97-3.07,11.9c-0.77,2.6-1.61,5.18-2.5,7.74c-0.3,0.87-3,6.99-3.1,7.45c-2.39,4.88-4.89,9.69-7.71,14.34 c-1.73,2.85-3.62,5.57-5.42,8.37c-0.7,1.03-1.43,2.03-2.16,3.04c-0.41,0.49-0.92,1.12-1.6,1.95c-4.52,4.88-8.84,9.8-13.72,14.36 c-2.42,2.26-4.94,4.41-7.46,6.56c-0.33,0.28-0.58,0.5-0.78,0.69c-0.33,0.21-0.63,0.41-1.04,0.67c-5.59,3.65-11.07,7.35-16.94,10.54 c-2.65,1.45-5.35,2.78-8.07,4.09c2.57-1.3-5.87,2.41-6.79,2.74c-6.43,2.24-12.99,4.1-19.64,5.57c-0.87,0.19-7.78,1.38-8.14,1.58 c-2.19,0.21-4.38,0.38-6.57,0.52c-4.21,0.26-8.43,0.32-12.65,0.33c-20.09,0.09-40.19,0-60.28,0c-80.15,0-160.3,0-240.45,0 c-32.94,0-65.87,0-98.81,0c-8.27,0-16.55,0.02-24.82,0c-1.5,0-3.01,0.02-4.51,0c-4.29-0.05-8.57-0.14-12.86-0.46 c-1.7-0.13-3.4-0.27-5.11-0.45c1.33-0.02-10.02-2.09-11.49-2.45c-6.62-1.62-13.01-3.81-19.45-6.01c-0.23-0.08-0.4-0.14-0.6-0.21 c-3.52-1.67-7.02-3.37-10.45-5.24c-5.88-3.21-11.34-6.89-16.94-10.54c-0.71-0.47-1.28-0.83-1.76-1.12 c-0.42-0.41-0.92-0.89-1.58-1.5c-2.92-2.7-5.96-5.25-8.8-8.04c-17.43-17.04-28.16-35.22-34.45-58.43 c-1.08-3.97-1.78-8.03-2.79-12.01c-0.2-0.76-0.37-1.41-0.51-1.96c-0.01-0.11-0.02-0.2-0.03-0.32c-0.68-6.34-0.97-12.67-1.04-19.04 c-0.01-1.29,0-2.59,0-3.88c-0.02-7.86,0-15.73,0-23.59c0-135.1-0.31-270.2,0-405.3c0-1.37-0.01-2.74,0-4.12 c0.05-4.29,0.14-8.57,0.46-12.86c0.13-1.7,0.27-3.4,0.45-5.11c0.02,1.32,2.09-10.02,2.45-11.49c1.63-6.62,3.81-13,6.01-19.45 c0.13-0.38,0.22-0.65,0.33-0.98c0.15-0.27,0.33-0.62,0.58-1.13c1.48-3,2.93-6.01,4.53-8.95c3.2-5.88,6.89-11.35,10.54-16.94 c0.47-0.71,0.83-1.28,1.13-1.76c0.41-0.42,0.89-0.92,1.5-1.58c2.71-2.92,5.25-5.95,8.03-8.8c3.78-3.87,7.79-7.49,11.91-11 c0.69-0.43,5.63-4.26,6.34-4.73c2.21-1.48,4.45-2.92,6.73-4.3c3.42-2.08,6.92-4.03,10.47-5.87c-0.16,0.08,3.34-1.57,5.53-2.64 c2.28-0.88,5.96-2.36,5.8-2.3c4.49-1.57,9.05-2.93,13.66-4.12c3.32-0.86,6.71-1.43,10.02-2.28c0.76-0.2,1.41-0.37,1.96-0.51 c0.11-0.01,0.2-0.02,0.32-0.03c6.35-0.69,12.69-0.98,19.07-1.04c2.28-0.02,4.56,0,6.83,0c41.96,0,118.22,0,187.9,0l97.86-91.15 c-78.48,0-200.74,0-256.59,0c-36.9,0-73.84-0.6-109.08,12.63c-65.7,24.66-117.04,77.02-137.14,144.82 c-8.35,28.18-8.75,56.91-8.75,85.89c0,33.27,0,66.54,0,99.81c0,83.36,0,166.73,0,250.09c0,20.44-0.16,40.9,0,61.34 c0.47,58.88,23.19,116.15,65.53,157.54c41.65,40.71,97.61,62.49,155.63,62.72c21.51,0.08,43.02,0,64.53,0 c84.16,0,168.32,0,252.48,0c61.87,0,133.9,8.3,192.25-15.65c64.41-26.43,115.01-81.36,131.78-149.7 c7.48-30.48,6.62-61.21,6.62-92.24C898.84,648.03,898.84,531.73,898.84,451.11z M199.37,871.55 C192.92,869.33,197.32,870.7,199.37,871.55L199.37,871.55z',
				'M878.91,183.25c0,42.78,0,143.52,0,197.13l91.15-94.9c0-64.98,0-131.82,0-177.75c0-11.96,0-23.92,0-35.88 c0-24.64-20.88-45.57-45.57-45.57c-56.15,0-155.79,0-240.48,0l-93.68,91.15c72.14,0,178.74,0,225.51,0 c-31.99,32.12-63.98,64.23-95.97,96.35c-85.14,85.48-170.28,170.96-255.42,256.44c-19.57,19.65-39.14,39.3-58.72,58.95 c-17.37,17.44-17.43,47.02,0,64.45c17.44,17.44,47.03,17.49,64.45,0c53.4-53.62,106.81-107.23,160.21-160.85 C713.23,349.59,796.07,266.42,878.91,183.25z',
			),
			'fill'        => 'currentColor',
			'stock-width' => '0',
			'type'        => 'share',
		),
		'share-icon-3'   => array(
			'd'    => array(
				'M863.85,899.9c0-78.74,0-157.47,0-236.21c0-86.74,0-173.49,0-260.23c0-32.79,3.08-68.99-34.11-85.1
                c-16.75-7.26-36.77-5.03-54.67-5.03c-24.45,0-48.9,0-73.35,0c-13.09,0-26.18,0-39.26,0c-18.61,0-36.44,16.37-35.58,35.58
                c0.86,19.28,15.63,35.58,35.58,35.58c36.52,0,73.04,0,109.57,0c6.89,0,13.78,0,20.66,0c0,70.64,0,141.28,0,211.92
                c0,87.97,0,175.94,0,263.91c0,12.61,0,25.22,0,37.84c0,0.61-0.04,1.35-0.1,2.13c-5.37,0-10.75,0-16.12,0
                c-78.99,0-157.98,0-236.98,0c-89.55,0-179.1,0-268.64,0c-20.87,0-41.73,0-62.6,0c-0.01-0.18-0.01-0.32-0.01-0.41
                c0-75.2,0-150.4,0-225.59c0-86.39,0-172.78,0-259.17c0-10.21,0-20.43,0-30.64c5.83,0,11.67,0,17.5,0c23.42,0,46.85,0,70.27,0
                c12.72,0,25.44,0,38.16,0c18.61,0,36.44-16.37,35.58-35.58c-0.86-19.28-15.63-35.58-35.58-35.58c-38.41,0-76.82,0-115.24,0
                c-22.75,0-46.16-1.79-64.15,15.61c-13.61,13.16-17.7,30.34-17.7,48.37c0,73.04,0,146.07,0,219.11c0,90.62,0,181.24,0,271.86
                c0,18.93-3.16,41.88,1.83,60.52c7.31,27.28,31.59,42.36,58.74,42.66c8.03,0.09,16.06,0,24.09,0c81.86,0,163.72,0,245.59,0
                c91.29,0,182.58,0,273.87,0c21.18,0,42.41,0.41,63.58,0c32.43-0.63,57.88-23.83,59.08-56.77
                C864.02,909.78,863.85,904.82,863.85,899.9z M195.24,384.69c0.03,0,0.06,0.01,0.09,0.01C195.3,384.69,195.27,384.69,195.24,384.69z
                 M208.22,372.74C208.07,369.12,209.05,370.81,208.22,372.74L208.22,372.74z M193.8,900.31c0-0.06,0.25-0.05,0.61,0
                C194.19,900.31,193.8,900.3,193.8,900.31z M792.69,370.29c-0.17,0.13,0.01,1.68,0,1.88c-0.03,0.42-0.04,0.84-0.05,1.26
                C792.01,372.05,791.88,370.89,792.69,370.29z M805.73,900.12c0.36,0.01,0.71,0.07,1.01,0.19
                C806.46,900.19,806.11,900.14,805.73,900.12z',
				'M372.33,243.92c30.85-31.2,61.7-62.4,92.54-93.6c0,36.7,0,73.39,0,110.09c0,93.09,0,186.17,0,279.26
                c0,21.53,0,43.07,0,64.6c0,18.61,16.37,36.44,35.58,35.58c19.28-0.86,35.58-15.63,35.58-35.58c0-58.65,0-117.3,0-175.95
                c0-92.69,0-185.38,0-278.07c24.52,24.77,49.03,49.53,73.55,74.3c6.39,6.46,12.79,12.92,19.18,19.37
                c13.52,13.66,36.78,13.54,50.32,0c13.69-13.69,13.56-36.62,0-50.32c-44.76-45.22-89.52-90.44-134.29-135.66
                c-6.39-6.46-12.79-12.92-19.18-19.37c-13.46-13.6-36.83-13.64-50.32,0C430.59,83.78,385.88,129,341.17,174.22
                c-6.39,6.46-12.77,12.92-19.16,19.37c-13.51,13.66-13.64,36.68,0,50.32C335.58,257.49,358.78,257.62,372.33,243.92z',
			),
			'fill' => 'currentColor',
			'type' => 'share',
		),
		'share-icon-4'   => array(
			'd'    => 'M965.78,468.33L631.5,103.81c-16.66-18.17-46.95-6.38-46.95,18.27v193.59c0,0-206.53-41.31-384.8,103.27C31.34,555.52,27.07,748.36,27.11,895.74c0,8.51,10.51,12.5,16.16,6.13c54.9-61.93,247.51-251.09,542.37-238.35v186.04c0,24.64,30.28,36.43,46.94,18.28l333.19-362.96C975.26,494.54,975.27,478.66,965.78,468.33z',
			'fill' => 'currentColor',
			'type' => 'share',
		),
		'icon-whatsapp'  => array(
			'd'           => array(
				'M332.71,271.94c9.43,0,19.09,1.69,28.47,3.31,5.6.74,10.77,9,13.72,14.95,13.59,31.79,27.19,63.58,38.91,96.11,6.6,17.21-5.5,33.66-30.77,62.08-7.92,9-9.48,17.58-3.58,28.05,39.87,68.44,96,117.8,170.16,147a26.18,26.18,0,0,0,9.3,1.91c6.34,0,11.61-3.09,16.56-9,31.71-38.3,40.74-55,53.59-55,3.21,0,6.66,1,10.75,3.06,99.12,47.5,106.95,49.37,107.25,60.59,2.59,79.64-66.79,110.94-113.78,110.94q-3.66,0-7.12-.25c-96.08-3.36-248.83-79.28-352.52-261.78-36.53-64.69-30.74-138.37,24.25-189.23C308.37,274.84,320.35,271.94,332.71,271.94Z',
				'M984.69,408C1032,680.26,852,938.29,581.63,985.79a510.66,510.66,0,0,1-86.29,7.44c-76.21,0-149.94-17.73-220.77-52.32a47,47,0,0,0-20.41-4.48,41,41,0,0,0-9.85,1.12C113.54,970.45,26.59,994.76,0,1000c5.77-21.32,10.78-40,15.78-58.71C32.69,881.45,50,822,65.76,762.15c2.32-9,1.66-20.57-2.4-28.79C-86.27,444.65,73.09,95,391.54,20.2A507.91,507.91,0,0,1,507.35,6.65C747.3,6.65,945.37,182.76,984.69,408ZM561.3,906.51c223.91-35.9,378.45-245,346.12-467.84C877.38,233,703.56,87.77,504.15,87.77a417.56,417.56,0,0,0-75,6.84C152,145.47,2.67,454,138.42,698.58c15.13,26.93,19.07,49.36,8.38,78.16-12.23,34.78-20,70.68-31.13,109.94C164.76,874,210.1,862.75,255.07,850a45.77,45.77,0,0,1,11.76-1.65c7.53,0,14.37,2.24,21.86,6.51C353.48,892.45,421.92,912,494.19,912a421.64,421.64,0,0,0,67.11-5.47',
			),
			'fill'        => 'currentColor',
			'stock-width' => '0',
		),
		'icon-facebook'  => array(
			'd'           => 'M617,0c26.7,0,53.7,1.5,80.3,2.6c17.4,0.7,34.8,3.2,51.1,5l-1.2,161c-5,0-8.9,0-12.8,0
			c-17.7,0-35.3-0.2-53-0.2c-13.2,0-26.5,0.1-39.8,0.6c-42.7,1.4-74.1,17.4-76.2,70.7c-1.4,38.4-2.3,123.1-2.4,127.6
			c2.2,0,44.4,0.2,86.8,0.2c21.2,0,42,0,56.4-0.2c11,0,22,0,34.5,0c-8.6,61.8-16.6,121.2-25.2,180.9H563l-3.4,451.8H372.3l3.5-452.5
			H222.5l1.4-179.9h153.9l0.1-13.5c0.3-36.3-0.2-72.5,1.2-108.8c0.5-22.7,1.8-46.2,5.9-69c10.4-55.1,36-101.3,82.1-134.4
			c40.4-28.8,86.3-40.9,135-41.9C607,0,612,0,617,0z',
			'fill'        => 'currentColor',
			'stock-width' => '0',
		),
		'icon-copy'      => array(
			'd'           => array(
				'M69.27,395.81c0,97.35-.46,194.69.59,292,.13,12,5,30.12,13.46,34.68,38.83,21,74-1.19,74-44.3.08-179.38.91-358.78-.76-538.15-.35-37.31,9-51,48.74-50.44,150.33,2.13,300.73-.19,451.07,1.54,36,.42,47.28-9.25,48-46.62C705.09,4.19,688.31-.28,654.9,0,499,1.36,343,.35,187.11.78,102.87,1,70.23,32.94,69.52,116.31,68.73,209.47,69.34,302.65,69.27,395.81Z',
				'M930.79,592.19c0,95.94.2,191.87-.1,287.81-.27,86.71-32.11,119.43-117.58,119.67q-223.41.65-446.83-.06c-82.19-.3-116.39-34.43-116.68-117.7q-1-287.8,0-575.61c.35-91.12,33-122.92,123.6-123.13q219.24-.49,438.48,0c90.31.21,118.86,29.47,119.1,121.2C931,400.33,930.82,496.26,930.79,592.19Zm-591.16-.72c0,93.11.71,186.22-.44,279.31-.35,27.88,7.57,39.79,37.67,39.55,143.29-1.13,286.6-.85,429.9-.08,27.06.15,36.63-10.29,36.53-37q-1-281.4,0-562.8c.09-26.29-7.94-37.18-35.86-37q-214.93,1.51-429.89,0c-29.09-.21-38.9,9.6-38.46,38.65C340.48,405.25,339.6,498.37,339.63,591.47Z',
				'M69.31,395.81c0-93.16-.58-186.34.21-279.5C70.23,32.94,102.87,1,187.11.78,343,.35,499,1.36,654.9,0c33.41-.29,50.19,4.18,49.43,44.53-.69,37.37-11.93,47-48,46.62-150.34-1.73-300.74.59-451.07-1.54-39.7-.56-49.09,13.13-48.74,50.44,1.67,179.37.84,358.77.76,538.15,0,43.11-35.16,65.26-74,44.3C74.85,718,70,699.8,69.86,687.83,68.81,590.5,69.27,493.16,69.31,395.81Z',
			),
			'fill'        => 'currentColor',
			'stock-width' => '0',
		),
		'icon-linkedin'  => array(
			'd'           => array(
				'M121.35,0A119.18,119.18,0,0,1,240.82,120.39a121.39,121.39,0,0,1-121.3,120.38A119.46,119.46,0,0,1,.05,120.39C.55,54,55,0,121.35,0Z',
				'M751.64,315.47c210.45,0,248.07,138,246.69,318.1L995.54,1000H788.16l2.47-324.69c.6-77.77-.4-177.51-106.73-177.51-108.08,0-125,84.36-125.65,171.79L555.73,1000H347.91L353,331.72H552l-.7,91.39h3.08C582.5,370.83,650.58,315.47,751.64,315.47Z',
			),
			'points'      => '222.95 331.72 217.86 1000 10.04 1000 15.13 331.72 222.95 331.72',
			'fill'        => 'currentColor',
			'stock-width' => '0',
		),
		'icon-twitter'   => array(
			'd'           => 'M786.9,48.8H940L605.6,431.1l393.6,520.1H691.1L449.7,635.8L173.8,951.2H20.4l357.7-408.8L0.9,48.8h315.9
            l218,288.3L786.9,48.8z M733.2,859.7H818L270.5,135.6h-91.1L733.2,859.7z',
			'fill'        => 'currentColor',
			'stock-width' => '0',
		),
		'icon-pinterest' => array(
			'd'           => 'M500,1000c276.1,0,500-223.9,500-500C1000,223.9,776.1,0,500,0C223.9,0,0,223.9,0,500
			c0,202.9,120.8,377.5,294.4,455.9c0.2-5.4,0.5-10.4,0.7-14.6c0.3-5.8,0.5-10.3,0.5-12.8c0-15,10.2-89.5,10.2-89.5l62.5-256.6
			c-9.6-15.6-16.8-48.7-16.8-73.9c0-116.6,64.9-141.8,104.6-141.8c50.5,0,61.9,54.7,61.9,95c0,21.3-11,54.6-22.4,88.9
			c-12.1,36.4-24.5,73.8-24.5,99.2c0,49.3,48.7,73.9,82.3,73.9c88.9,0,170.7-111.8,170.7-223.6s-52.3-247-223.6-247
			c-171.3,0-248.2,130.4-248.2,230.2c0,67.3,25.2,116.6,37.9,125c3.6,3.2,9.7,13.1,5.4,27c-4.3,13.9-12.2,45.1-15.6,58.9
			c-0.4,3.2-4.2,8.7-16.2,4.8c-15-4.8-110.6-64.9-110.6-215.7c0-150.8,118.4-326.3,347.4-326.3c229,0,346.2,153.8,346.2,343.1
			S693.5,810.1,576.9,810.1c-93.3,0-129.8-41.7-136.4-62.5L405,882.8c-8.4,22.4-24,62.8-43.2,97.8C405.7,993.3,452.1,1000,500,1000z',
			'fill'        => 'currentColor',
			'stock-width' => '1',
		),
		'icon-telegram'  => array(
			'd'           => 'M67.7,443.3C377,307.3,777.2,141.4,832.5,118.4c144.9-60.1,189.4-48.6,167.2,84.5c-15.9,95.6-61.9,412.3-98.5,609.4
			c-21.7,116.9-70.5,130.7-147.1,80.2c-36.9-24.3-222.9-147.4-263.3-176.3c-36.9-26.3-87.7-58-23.9-120.4
			c22.7-22.2,171.4-164.2,287.3-274.8c15.2-14.5-3.9-38.4-21.4-26.7C576.5,398,360,541.7,332.4,560.5c-41.6,28.3-81.6,41.2-153.4,20.6
			c-54.2-15.6-107.2-34.2-127.8-41.2C-28.2,512.6-9.4,477.3,67.7,443.3z',
			'fill'        => 'currentColor',
			'stock-width' => '1',
		),
		'icon-mail'      => array(
			'd'           => 'M124.9,223c-17.2,0-31.2,14-31.2,31.2v43.1l336.6,276.3c40.4,33.2,98.3,33.2,138.7,0l336.4-276.3v-43.1
			c0-17.2-14-31.2-31.2-31.2H124.9z M93.7,418.5v335.2c0,17.2,14,31.2,31.2,31.2h749.2c17.2,0,31.2-14,31.2-31.2V418.5L628.3,646
			c-74.9,61.5-182.8,61.5-257.6,0L93.7,418.5z M0,254.2c0-68.9,56-124.9,124.9-124.9h749.2c68.9,0,124.9,56,124.9,124.9v499.5
			c0,68.9-56,124.9-124.9,124.9H124.9C56,878.5,0,822.5,0,753.7V254.2z',
			'fill'        => 'currentColor',
			'stock-width' => '1',
		),
		'icon-mastodon'  => array(
			'd'           => 'M972.6,221.4C958,113.9,862.8,29.3,750,12.9C731,10.1,658.9,0,491.9,0h-1.2C323.6,0,287.7,10.1,268.7,12.9
			c-109.6,16-209.8,92-234.1,200.8C23,267.2,21.7,326.5,23.9,381c3.1,78.1,3.7,156,10.9,233.8c5,51.7,13.7,102.9,26,153.4
			c23.1,93.2,116.6,170.7,208.2,202.3c98.1,33,203.5,38.5,304.6,15.8c11.1-2.5,22.1-5.5,33-8.9c24.5-7.7,53.3-16.3,74.5-31.4
			c0.3-0.2,0.5-0.5,0.7-0.8c0.2-0.3,0.3-0.7,0.3-1v-75.4c0-0.3-0.1-0.7-0.2-1c-0.1-0.3-0.4-0.6-0.6-0.8c-0.3-0.2-0.6-0.3-0.9-0.4
			c-0.3-0.1-0.7-0.1-1,0c-64.7,15.2-131.1,22.8-197.6,22.7c-114.5,0-145.3-53.5-154.2-75.8c-7.1-19.2-11.6-39.3-13.4-59.7
			c0-0.3,0-0.7,0.2-1c0.1-0.3,0.4-0.6,0.6-0.8c0.3-0.2,0.6-0.4,0.9-0.4c0.3-0.1,0.7-0.1,1,0c63.7,15.1,128.9,22.7,194.4,22.7
			c15.7,0,31.5,0,47.2-0.4c65.9-1.8,135.3-5.1,200.1-17.6c1.6-0.3,3.2-0.6,4.6-1c102.2-19.3,199.5-79.9,209.4-233.5
			c0.4-6,1.3-63.3,1.3-69.6C973.7,431.1,980.6,301.2,972.6,221.4z M815.3,604.5H707.9V345.4c0-54.5-23.1-82.4-70.1-82.4
			c-51.6,0-77.5,32.9-77.5,97.9v141.8H453.5V361c0-65-25.9-97.9-77.5-97.9c-46.7,0-70,27.8-70.1,82.4v259.1H198.5V337.6
			c0-54.5,14.1-97.9,42.4-130c29.2-32,67.5-48.5,115-48.5c55,0,96.6,20.8,124.3,62.4l26.7,44.2l26.8-44.2
			c27.7-41.6,69.3-62.4,124.2-62.4c47.5,0,85.8,16.5,115,48.5c28.3,32.1,42.4,75.4,42.4,130L815.3,604.5z',
			'fill'        => 'currentColor',
			'stock-width' => '1',
		),
	);


	/**
	 * This function will trigger when the icon class been called.
	 *
	 * @param  string $path  The path of the SVG icons.
	 *
	 * @return void
	 */
	public function __construct( $path = '' ) {
	}

	/**
	 * Get the SVG Icons. as array
	 *
	 * @param  string $type type of icon to determine the icons are 'share' icons or others.
	 * @return array
	 */
	public function get_icons( $type = false ) {

		$svg_icons = array();

		foreach ( $this->icons as $name => $icon_prop ) {
			if ( $type && ( empty( $icon_prop['type'] ) || $icon_prop['type'] !== $type ) ) {
				continue;
			}

			if ( empty( $icon_prop['d'] ) ) {
				continue;
			}

			$svg_icons[ $name ] = $this->generate_svg( $icon_prop );
		}

		return $svg_icons;
	}

	/**
	 * To get the icon SVG.
	 *
	 * @since 2.4
	 * @param string $icon_name  if null, will return the icon SVG which is selected by user. if provide the icon name will SVG named.
	 * @param array  $attrs Extra HTML attributes for the SVG.
	 * @return string String of SVG.
	 */
	public function get_icon( $icon_name = '', $attrs = array() ) {

		if ( ! empty( $icon_name ) ) {

			if ( isset( $this->icons[ $icon_name ] ) ) {

				return $this->generate_svg( array_merge( $this->icons[ $icon_name ], $attrs ) );

			}
		} else {
			$settings_appearance = superwebshare_get_settings_appearance();
			$icon_name           = empty( $settings_appearance['superwebshare_appearance_button_icon'] ) ? 'share-icon-1' : $settings_appearance['superwebshare_appearance_button_icon'];
			return $this->get_icon( $icon_name );

		}
	}

	/**
	 * Generate the SVG using the props.
	 *
	 * @param  array $icon_prop Properties of SVG.
	 * @return string
	 */
	private function generate_svg( array $icon_prop ) {

		$d = array();
		if ( ! is_array( $icon_prop['d'] ) ) {
			$d[] = $icon_prop['d'];
		} else {
			$d = $icon_prop['d'];
		}

		$points = array();
		if ( isset( $icon_prop['points'] ) ) {
			if ( ! is_array( $icon_prop['points'] ) ) {
				$points[] = $icon_prop['points'];
			} else {
				$points = $icon_prop['points'];
			}
		}

		$svg_pros = wp_parse_args(
			$icon_prop,
			array(
				'fill'        => 'none',
				'stock-width' => 2,
				'style'       => '',
				'stroke'      => 'currentColor',
			)
		);

		$svg  = '<svg xmlns="http://www.w3.org/2000/svg" class="superwebshare-svg"  fill="' . $svg_pros['fill'] . '" viewBox="0 0 1000 1000" stroke="' . $svg_pros['stroke'] . '" stroke-width="' . $svg_pros['stock-width'] . '">';
		$svg .= implode(
			'',
			array_map(
				function ( $v ) {
					return '<path stroke-linecap="round" stroke-linejoin="round" d="' . $v . '" />';
				},
				$d
			)
		);

		$svg .= implode(
			'',
			array_map(
				function ( $v ) {
					return '<polyline stroke-linecap="round" stroke-linejoin="round" points="' . $v . '" />';
				},
				$points
			)
		);

		$svg .= '</svg>';

		return $svg;
	}
}
