<?php

/**
 * The WordPress tests functions.
 *
 * We are loading this so that we can add our tests filter
 * to load the plugin, using tests_add_filter().
 */
require_once getenv( 'WP_TESTS_DIR' ) . '/includes/functions.php';

/**
 * Manually load the plugin main file.
 *
 * The plugin won't be activated within the test WP environment,
 * that's why we need to load it manually.
 *
 * You will also need to perform any installation necessary after
 * loading your plugin, since it won't be installed.
 */
function _manually_load_plugin() {
	// relative path to plugin
	// we are in    plugin/tests/phpunit/includes/
	// and going to plugin/
	require dirname( __FILE__ ) . '/../../../stop-emails.php';
}
tests_add_filter( 'muplugins_loaded', '_manually_load_plugin' );

/**
 * Sets up the WordPress test environment.
 *
 * We've got our action set up, so we can load this now,
 * and viola, the tests begin.
 */
require getenv( 'WP_TESTS_DIR' ) . '/includes/bootstrap.php';
