<?php

/**
 * Municipalities of Venezuela
 * - 335 municipalities and their capitals
 * 
 * Source:
 * - https://es.wikipedia.org/wiki/Anexo:Municipios_de_Venezuela
 *
 * @author  Yordan Soares <contacto@yordansoar.es> | https://yordansoar.es
 * @version 1.0.0
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */

global $places;

$places['VE'] = array(
  'AM' => array(
    'Municipio Alto Orinoco (La Esmeralda)',
    'Municipio Atabapo (San Fernando de Atabapo)',
    'Municipio Atures (Puerto Ayacucho)',
    'Municipio Autana (Isla Ratón)',
    'Municipio Manapiare (San Juan de Manapiare)',
    'Municipio Maroa (Maroa)',
    'Municipio Río Negro (San Carlos de Río Negro)'
  ),
  'AN' => array(
    'Municipio Anaco (Anaco)',
    'Municipio Aragua (Aragua de Barcelona)',
    'Municipio Bolívar (Barcelona)',
    'Municipio Bruzual (Clarines)',
    'Municipio Cajigal (Onoto)',
    'Municipio Carvajal (Valle de Guanape)',
    'Municipio Diego Bautista Urbaneja (Lechería)',
    'Municipio Freites (Cantaura)',
    'Municipio Guanipa (San José de Guanipa)',
    'Municipio Guanta (Guanta)',
    'Municipio Independencia (Soledad)',
    'Municipio Libertad (San Mateo)',
    'Municipio McGregor (El Chaparro)',
    'Municipio Miranda (Pariaguán',
    'Municipio Monagas (San Diego de Cabrutica',
    'Municipio Peñalver (Puerto Píritu',
    'Municipio Píritu (Píritu)',
    'Municipio San Juan de Capistrano (Boca de Uchire)',
    'Municipio Santa Ana (Santa Ana)',
    'Municipio Simón Rodriguez (El Tigre)',
    'Municipio Sotillo (Puerto La Cruz)'
  ),
  'AP' => array(
    'Municipio Achaguas (Achaguas)',
    'Municipio Biruaca (Biruaca)',
    'Municipio Muñoz (Bruzual)',
    'Municipio Páez (Guasdualito)',
    'Municipio Pedro Camejo (San Juan de Payara)',
    'Municipio Rómulo Gallegos (Elorza)',
    'Municipio San Fernando (San Fernando de Apure)'
  ),
  'AR' => array(
    'Municipio Bolívar (San Mateo)',
    'Municipio Camatagua (Camatagua)',
    'Municipio Francisco Linares Alcántara (Santa Rita)',
    'Municipio Girardot (Maracay)',
    'Municipio José Ángel Lamas (Santa Cruz)',
    'Municipio José Félix Ribas (La Victoria)',
    'Municipio José Rafael Revenga (El Consejo)',
    'Municipio Libertador (Palo Negro)',
    'Municipio Mario Briceño Iragorry (El Limón)',
    'Municipio Ocumare de la Costa de Oro (Ocumare de la Costa)',
    'Municipio San Casimiro (San Casimiro)',
    'Municipio San Sebastián (San Sebastián de los Reyes)',
    'Municipio Santiago Mariño (Turmero)',
    'Municipio Santos Michelena (Las Tejerías)',
    'Municipio Sucre (Cagua)',
    'Municipio Tovar (Colonia Tovar)',
    'Municipio Urdaneta (Barbacoas)',
    'Municipio Zamora (Villa de Cura)'
  ),
  'BA' => array(
    'Municipio Alberto Arvelo Torrealba (Sabaneta)',
    'Municipio Andrés Eloy Blanco (El Cantón)',
    'Municipio Antonio José de Sucre (Socopó)',
    'Municipio Arismendi (Arismendi)',
    'Municipio Barinas (Barinas)',
    'Municipio Bolívar (Barinitas)',
    'Municipio Cruz Paredes (Barrancas)',
    'Municipio Ezequiel Zamora (Santa Bárbara)',
    'Municipio Obispos (Obispos)',
    'Municipio Pedraza (Ciudad Bolivia)',
    'Municipio Rojas (Libertad)',
    'Municipio Sosa (Ciudad de Nutrias)'
  ),
  'BO' => array(
    'Municipio Caroní (Ciudad Guayana)',
    'Municipio Cedeño (Caicara del Orinoco)',
    'Municipio El Callao (El Callao)',
    'Municipio Gran Sabana (Santa Elena de Uairén)',
    'Municipio Heres (Ciudad Bolívar)',
    'Municipio Piar (Upata)',
    'Municipio Raúl Leoni (Ciudad Piar)',
    'Municipio Roscio (Guasipati)',
    'Municipio Sifontes (Tumeremo)',
    'Municipio Sucre (Maripa)',
    'Municipio Padre Pedro Chen (El Palmar)'
  ),
  'CA' => array(
    'Municipio Bejuma (Bejuma)',
    'Municipio Carlos Arvelo (Güigüe)',
    'Municipio Diego Ibarra (Mariara)',
    'Municipio Guacara (Guacara)',
    'Municipio Juan José Mora (Morón)',
    'Municipio Libertador (Tocuyito)',
    'Municipio Los Guayos (Los Guayos)',
    'Municipio Miranda (Miranda)',
    'Municipio Montalbán (Montalbán)',
    'Municipio Naguanagua (Naguanagua)',
    'Municipio Puerto Cabello (Puerto Cabello)',
    'Municipio San Diego (San Diego)',
    'Municipio San Joaquín (San Joaquín)',
    'Municipio Valencia (Valencia)'
  ),
  'CO' => array(
    'Municipio Anzoátegui (Cojedes)',
    'Municipio El Pao de San Juan Bautista (El Pao)',
    'Municipio Falcón (Tinaquillo)',
    'Municipio Girardot (El Baúl)',
    'Municipio Lima Blanco (Macapo)',
    'Municipio Ricaurte (Libertad)',
    'Municipio Rómulo Gallegos (Las Vegas)',
    'Municipio San Carlos de Austria (San Carlos)',
    'Municipio Tinaco (Tinaco)'
  ),
  'DE' => array(
    'Municipio Antonio Díaz Curiapo (Curiapo)',
    'Municipio Casacoima (Sierra Imataca)',
    'Municipio Pedernales (Pedernales)',
    'Municipio Tucupita (Tucupita)'
  ),
  'DC' => array(
    'Municipio Libertador (Caracas)'
  ),
  'FA' => array(
    'Municipio Acosta (San Juan de los Cayos)',
    'Municipio Bolívar (San Luis)',
    'Municipio Buchivacoa (Capatárida)',
    'Municipio Cacique Manaure (Yaracal)',
    'Municipio Carirubana (Punto Fijo)',
    'Municipio Colina (La Vela de Coro)',
    'Municipio Dabajuro (Dabajuro)',
    'Municipio Democracia (Pedregal)',
    'Municipio Falcón (Pueblo Nuevo)',
    'Municipio Federación (Churuguara)',
    'Municipio Jacura (Jacura)',
    'Municipio Los Taques (Santa Cruz de Los Taques)',
    'Municipio Mauroa (Mene de Mauroa)',
    'Municipio Miranda (Santa Ana de Coro)',
    'Municipio Monseñor Iturriza (Chichiriviche)',
    'Municipio Palmasola (Palmasola)',
    'Municipio Petit (Cabure)',
    'Municipio Píritu (Píritu)',
    'Municipio San Francisco (Mirimire)',
    'Municipio Silva (Tucacas)',
    'Municipio Sucre (La Cruz de Taratara)',
    'Municipio Tocópero (Tocópero)',
    'Municipio Unión (Santa Cruz de Bucaral)',
    'Municipio Urumaco (Urumaco)',
    'Municipio Zamora (Puerto Cumarebo)'
  ),
  'GU' => array(
    'Municipio Esteros de Camaguan(Camaguan)',
    'Municipio Chaguaramas(Chaguaramas)',
    'Municipio El Socorro (El Socorro)',
    'Municipio Francisco de Miranda (Calabozo)',
    'Municipio José Félix Ribas (Tucupido)',
    'Municipio José Tadeo Monagas (Altagracia de Orituco)',
    'Municipio Juan Germán Roscio (San Juan de Los Morros)',
    'Municipio Julián Mellado (El Sombrero)',
    'Municipio Las Mercedes (Las Mercedes)',
    'Municipio Leonardo Infante (Valle de La Pascua)',
    'Municipio Pedro Zaraza (Zaraza)',
    'Municipio Ortíz (Ortíz)',
    'Municipio San Gerónimo de Guayabal (Guayabal)',
    'Municipio San José de Guaribe (San José de Guaribe)',
    'Municipio Santa María de Ipire (Santa María de Ipire)'
  ),
  'LA' => array(
    'Municipio Andrés Eloy Blanco (Sanare)',
    'Municipio Crespo (Duaca)',
    'Municipio Iribarren (Barquisimeto)',
    'Municipio Jiménez (Quibor)',
    'Municipio Morán (El Tocuyo)',
    'Municipio Palavecino (Cabudare)',
    'Municipio Simón Planas (Sarare)',
    'Municipio Torres (Carora)',
    'Municipio Urdaneta (Siquisique)'
  ),
  'LG' => array(
    'Municipio Vargas (La Guaira)'
  ),
  'ME' => array(
    'Municipio Alberto Adriani (El Vigía)',
    'Municipio Andrés Bello (La Azulita)',
    'Municipio Antonio Pinto Salinas (Santa Cruz de Mora)',
    'Municipio Aricagua (Aricagua)',
    'Municipio Arzobispo Chacón (Canagua)',
    'Municipio Campo Elías (Ejido)',
    'Municipio Caracciolo Parra Olmedo (Tucani)',
    'Municipio Cardenal Quintero (Santo Domingo)',
    'Municipio Guaraque (Guaraque)',
    'Municipio Julio César Salas (Arapuey)',
    'Municipio Justo Briceño (Torondoy)',
    'Municipio Libertador (Mérida)',
    'Municipio Miranda (Timotes)',
    'Municipio Obispo Ramos de Lora (Santa Elena de Arenales)',
    'Municipio Padre Noguera (Santa María de Caparo)',
    'Municipio Pueblo Llano (Pueblo Llano)',
    'Municipio Rangel (Mucuchíes)',
    'Municipio Rivas Dávila (Bailadores)',
    'Municipio Santos Marquina (Tabay)',
    'Municipio Sucre (Lagunillas)',
    'Municipio Tovar (Tovar)',
    'Municipio Tulio Febres Cordero (Nueva Bolivia)',
    'Municipio Zea (Zea)'
  ),
  'MI' => array(
    'Municipio Acevedo (Caucagua)',
    'Municipio Andrés Bello (San José de Barlovento)',
    'Municipio Baruta (Baruta)',
    'Municipio Brión (Higuerote)',
    'Municipio Buroz (Mamporal)',
    'Municipio Carrizal (Carrizal)',
    'Municipio Chacao (Chacao)',
    'Municipio Cristóbal Rojas (Charallave)',
    'Municipio El Hatillo (El Hatillo)',
    'Municipio Guaicaipuro (Los Teques)',
    'Municipio Independencia (Santa Teresa del Tuy)',
    'Municipio Lander (Ocumare del Tuy)',
    'Municipio Los Salias (San Antonio de los Altos)',
    'Municipio Páez (Río Chico)',
    'Municipio Paz Castillo (Santa Lucía)',
    'Municipio Pedro Gual (Cúpira)',
    'Municipio Plaza (Guarenas)',
    'Municipio Simón Bolívar (San Francisco de Yare)',
    'Municipio Sucre (Petare)',
    'Municipio Urdaneta (Cúa)',
    'Municipio Zamora (Guatire)'
  ),
  'MO' => array(
    'Municipio Acosta (San Antonio de Capayacuar)',
    'Municipio Aguasay (Aguasai)',
    'Municipio Bolíva',
    'Municipio Caripe(Caripe)',
    'Municipio Cedeño (Caicara)',
    'Municipio Ezequiel Zamora (Punta de Mata)',
    'Municipio Libertador (Temblador)',
    'Municipio Maturín (Maturín)',
    'Municipio Piar (Aragua)',
    'Municipio Punceres (Quiriquire)',
    'Municipio Santa Bárbara (Santa Bárbara)',
    'Municipio Sotillo (Barrancas del Orinco)',
    'Municipio Uracoa (Uracoa)'
  ),
  'NE' => array(
    'Municipio Antolín del Campo (La Plaza de Paraguachí)',
    'Municipio Arismendi (La Asunción)',
    'Municipio Díaz (San Juan Bautista)',
    'Municipio García (El Valle del Espíritu Santo)',
    'Municipio Gómez (Santa Ana)',
    'Municipio Maneiro (Pampatar)',
    'Municipio Marcano (Juan Griego)',
    'Municipio Mariño (Porlamar)',
    'Municipio Península de Macanao (Boca de Río)',
    'Municipio Tubores (Punta de Piedras)',
    'Municipio Villalba (San Pedro de Coche)'
  ),
  'PO' => array(
    'Municipio Agua Blanca (Agua Blanca)',
    'Municipio Araure (Araure)',
    'Municipio Esteller (Píritu)',
    'Municipio Guanare (Guanare)',
    'Municipio Guanarito (Guanarito)',
    'Municipio Monseñor José Vicenti de Unda (Chabasquén de Unda)',
    'Municipio Ospino (Ospino)',
    'Municipio Páez (Acarigua)',
    'Municipio Papelón (Papelón)',
    'Municipio San Genaro de Boconoíto (Boconoíto)',
    'Municipio San Rafael de Onoto (San Rafael de Onoto)',
    'Municipio Santa Rosalía (El Playón)',
    'Municipio Sucre (Biscucuy)',
    'Municipio Turén (Villa Bruzual)'
  ),
  'SU' => array(
    'Municipio Andrés Eloy Blanco (Casanay)',
    'Municipio Andrés Mata (San José de Aerocuar)',
    'Municipio Arismendi (Río Caribe)',
    'Municipio Benítez (El Pilar)',
    'Municipio Bermúdez (Carúpano)',
    'Municipio Bolívar (Marigüitar)',
    'Municipio Cajigal (Yaguaraparo)',
    'Municipio Cruz Salmerón Acosta (Araya)',
    'Municipio Libertador (Tunapuy)',
    'Municipio Mariño (Irapa)',
    'Municipio Mejía (San Antonio del Golfo)',
    'Municipio Montes (Cumanacoa)',
    'Municipio Ribero (Cariaco)',
    'Municipio Sucre (Cumaná)',
    'Municipio Valdez (Güiria)'
  ),
  'TA' => array(
    'Municipio Andrés Bello(Cordero)',
    'Municipio Antonio Rómulo Costa (Las Mesas)',
    'Municipio Ayacucho (El Colón)',
    'Municipio Bolívar (San Antonio del Táchira)',
    'Municipio Cárdenas (Táriba)',
    'Municipio Córdoba (Santa Ana de Táchira)',
    'Municipio Fernández Feo (San Rafael del Piñal)',
    'Municipio Francisco de Miranda (San José de Bolívar)',
    'Municipio García de Hevia (La Fría)',
    'Municipio Guásimos (Palmira)',
    'Municipio Independencia (Capacho Nuevo)',
    'Municipio Jáuregui (La Grita)',
    'Municipio José María Vargas (El Cobre)',
    'Municipio Junín (Rubio)',
    'Municipio San Judas Tadeo (Umuquena)',
    'Municipio Libertad (Capacho Viejo)',
    'Municipio Libertador (Abejales)',
    'Municipio Lobatera (Lobatera)',
    'Municipio Michelena (Michelena)',
    'Municipio Panamericano (Coloncito)',
    'Municipio Pedro María Ureña (Ureña)',
    'Municipio Rafael Urdaneta (Delicias)',
    'Municipio Samuel Dario Maldonado (La Tendida)',
    'Municipio San Cristóbal (San Cristóbal)',
    'Municipio Seboruco (Seboruco)',
    'Municipio Simón Rodríguez (San Simon)',
    'Municipio Sucre (Queniquea)',
    'Municipio Torbes (San Josesito)',
    'Municipio Uribante (Pregonero)'
  ),
  'TR' => array(
    'Municipio Andrés Bello (Santa Isabel)',
    'Municipio Boconó (Boconó)',
    'Municipio Bolívar (Sabana Grande)',
    'Municipio Candelaria (Chejendé)',
    'Municipio Carache (Carache)',
    'Municipio Escuque (Escuque)',
    'Municipio José Felipe Márquez Cañizales (El Paradero)',
    'Municipio Juan Vicente Campo Elías (Campo Elías)',
    'Municipio La Ceiba (Santa Apolonia)',
    'Municipio Miranda (El Dividive)',
    'Municipio Monte Carmelo (Monte Carmelo)',
    'Municipio Motatán (Motatán)',
    'Municipio Pampán (Pampán)',
    'Municipio Pampanito (Pampanito)',
    'Municipio Rafael Rangel (Betijoque)',
    'Municipio San Rafael de Carvajal (Carvajal)',
    'Municipio Sucre (Sabana de Mendoza)',
    'Municipio Trujilo (Trujillo)',
    'Municipio Urdaneta (La Quebrada)',
    'Municipio Valera (Valera)'
  ),
  'YA' => array(
    'Municipio Aristides Bastidas (San Pablo)',
    'Municipio Bolívar (Aroa)',
    'Municipio Bruzual (Chivacoa)',
    'Municipio Cocorote (Cocorote)',
    'Municipio Independencia (Independencia)',
    'Municipio José Antonio Páez (Sabana de Parra)',
    'Municipio La Trinidad (Boraure)',
    'Municipio Manuel Monge (Yumare)',
    'Municipio Nirgua (Nirgua)',
    'Municipio Peña (Yaritagua)',
    'Municipio San Felipe',
    'Municipio Sucre (Guama)',
    'Municipio Urachiche (Urachiche)',
    'Municipio Veroes (Farriar)'
  ),
  'ZU' => array(
    'Municipio Almirante Padilla (El Toro)',
    'Municipio Baralt (San Timoteo)',
    'Municipio Cabimas (Cabimas)',
    'Municipio Catatumbo (Encontrados)',
    'Municipio Colón (San Carlos del Zulia)',
    'Municipio Francisco Javier Pulgar (Pueblo Nuevo / El Chivo)',
    'Municipio Jesús Enrique Lossada (La Concepción)',
    'Municipio Jesús María Semprún (Casigua el Cubo)',
    'Municipio La Cañada de Urdaneta (Concepción)',
    'Municipio Lagunillas (Ciudad Ojeda)',
    'Municipio Machiques de Perijá (Machiques)',
    'Municipio Mara (San Rafael del Moján)',
    'Municipio Maracaibo (Maracaibo)',
    'Municipio Miranda (Los Puertos de Altagracia)',
    'Municipio Páez (Sinamaica)',
    'Municipio Rosario de Perijá (La Villa del Rosario)',
    'Municipio San Francisco (San Francisco)',
    'Municipio Santa Rita (Santa Rita)',
    'Municipio Simón Bolívar (Tía Juana)',
    'Municipio Sucre (Bobures)',
    'Municipio Valmore Rodríguez (Bachaquero)'
  ),
);

// Use this filter to handle the Municipalities of Venezuela
$places['VE'] = apply_filters('scpwoo_custom_places_ve', $places['VE']);
