<?php

/**
 * Districts of Turkey
 * - 973 districts
 *
 * Source:
 * - https://en.wikipedia.org/wiki/List_of_districts_in_Turkey
 *
 * @author  Selcuk <selcuk@kokoma.com.tr>
 * @version 1.0.0
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */

global $places;

$places['TR'] = array(
    // Adana
    'ADA' => array(
        __('Aladağ', 'states-cities-and-places-for-woocommerce'),
        __('Ceyhan', 'states-cities-and-places-for-woocommerce'),
        __('Çukurova', 'states-cities-and-places-for-woocommerce'),
        __('Feke', 'states-cities-and-places-for-woocommerce'),
        __('İmamoğlu', 'states-cities-and-places-for-woocommerce'),
        __('Karaisalı', 'states-cities-and-places-for-woocommerce'),
        __('Karataş', 'states-cities-and-places-for-woocommerce'),
        __('Kozan', 'states-cities-and-places-for-woocommerce'),
        __('Pozantı', 'states-cities-and-places-for-woocommerce'),
        __('Saimbeyli', 'states-cities-and-places-for-woocommerce'),
        __('Sarıçam', 'states-cities-and-places-for-woocommerce'),
        __('Seyhan', 'states-cities-and-places-for-woocommerce'),
        __('Tufanbeyli', 'states-cities-and-places-for-woocommerce'),
        __('Yumurtalık', 'states-cities-and-places-for-woocommerce'),
        __('Yüreğir', 'states-cities-and-places-for-woocommerce'),
    ),
    // Adıyaman
    'ADI' => array(
        __('Besni', 'states-cities-and-places-for-woocommerce'),
        __('Çelikhan', 'states-cities-and-places-for-woocommerce'),
        __('Gerger', 'states-cities-and-places-for-woocommerce'),
        __('Gölbaşı', 'states-cities-and-places-for-woocommerce'),
        __('Kahta', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Samsat', 'states-cities-and-places-for-woocommerce'),
        __('Sincik', 'states-cities-and-places-for-woocommerce'),
        __('Tut', 'states-cities-and-places-for-woocommerce'),
    ),
    // Afyonkarahisar
    'AFY' => array(
        __('Başmakçı', 'states-cities-and-places-for-woocommerce'),
        __('Bayat', 'states-cities-and-places-for-woocommerce'),
        __('Bolvadin', 'states-cities-and-places-for-woocommerce'),
        __('Çay', 'states-cities-and-places-for-woocommerce'),
        __('Çobanlar', 'states-cities-and-places-for-woocommerce'),
        __('Dazkırı', 'states-cities-and-places-for-woocommerce'),
        __('Dinar', 'states-cities-and-places-for-woocommerce'),
        __('Emirdağ', 'states-cities-and-places-for-woocommerce'),
        __('Evciler', 'states-cities-and-places-for-woocommerce'),
        __('Hocalar', 'states-cities-and-places-for-woocommerce'),
        __('İhsaniye', 'states-cities-and-places-for-woocommerce'),
        __('İscehisar', 'states-cities-and-places-for-woocommerce'),
        __('Kızılören', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Sandıklı', 'states-cities-and-places-for-woocommerce'),
        __('Sinanpaşa', 'states-cities-and-places-for-woocommerce'),
        __('Sultandağı', 'states-cities-and-places-for-woocommerce'),
        __('Şuhut', 'states-cities-and-places-for-woocommerce'),
    ),
    // Ağrı
    'AGR' => array(
        __('Diyadin', 'states-cities-and-places-for-woocommerce'),
        __('Doğubayazıt', 'states-cities-and-places-for-woocommerce'),
        __('Eleşkirt', 'states-cities-and-places-for-woocommerce'),
        __('Hamur', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Patnos', 'states-cities-and-places-for-woocommerce'),
        __('Taşlıçay', 'states-cities-and-places-for-woocommerce'),
        __('Tutak', 'states-cities-and-places-for-woocommerce'),
    ),
    // Aksaray
    'AKS' => array(
        __('Ağaçören', 'states-cities-and-places-for-woocommerce'),
        __('Eskil', 'states-cities-and-places-for-woocommerce'),
        __('Gülağaç', 'states-cities-and-places-for-woocommerce'),
        __('Güzelyurt', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Ortaköy', 'states-cities-and-places-for-woocommerce'),
        __('Sarıyahşi', 'states-cities-and-places-for-woocommerce'),
        __('Sultanhanı', 'states-cities-and-places-for-woocommerce'),
    ),
    // Amasya
    'AMA' => array(
        __('Göynücek', 'states-cities-and-places-for-woocommerce'),
        __('Gümüşhacıköy', 'states-cities-and-places-for-woocommerce'),
        __('Hamamözü', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Merzifon', 'states-cities-and-places-for-woocommerce'),
        __('Suluova', 'states-cities-and-places-for-woocommerce'),
        __('Taşova', 'states-cities-and-places-for-woocommerce'),
    ),
    // Ankara
    'ANK' => array(
        __('Akyurt', 'states-cities-and-places-for-woocommerce'),
        __('Altındağ', 'states-cities-and-places-for-woocommerce'),
        __('Ayaş', 'states-cities-and-places-for-woocommerce'),
        __('Bala', 'states-cities-and-places-for-woocommerce'),
        __('Beypazarı', 'states-cities-and-places-for-woocommerce'),
        __('Çamlıdere', 'states-cities-and-places-for-woocommerce'),
        __('Çankaya', 'states-cities-and-places-for-woocommerce'),
        __('Çubuk', 'states-cities-and-places-for-woocommerce'),
        __('Elmadağ', 'states-cities-and-places-for-woocommerce'),
        __('Etimesgut', 'states-cities-and-places-for-woocommerce'),
        __('Evren', 'states-cities-and-places-for-woocommerce'),
        __('Gölbaşı', 'states-cities-and-places-for-woocommerce'),
        __('Güdül', 'states-cities-and-places-for-woocommerce'),
        __('Haymana', 'states-cities-and-places-for-woocommerce'),
        __('Kahramankazan', 'states-cities-and-places-for-woocommerce'),
        __('Kalecik', 'states-cities-and-places-for-woocommerce'),
        __('Keçiören', 'states-cities-and-places-for-woocommerce'),
        __('Kızılcahamam', 'states-cities-and-places-for-woocommerce'),
        __('Mamak', 'states-cities-and-places-for-woocommerce'),
        __('Nallıhan', 'states-cities-and-places-for-woocommerce'),
        __('Polatlı', 'states-cities-and-places-for-woocommerce'),
        __('Pursaklar', 'states-cities-and-places-for-woocommerce'),
        __('Sincan', 'states-cities-and-places-for-woocommerce'),
        __('Şereflikoçhisar', 'states-cities-and-places-for-woocommerce'),
        __('Yenimahalle', 'states-cities-and-places-for-woocommerce'),
    ),
    // Antalya
    'ANT' => array(
        __('Akseki', 'states-cities-and-places-for-woocommerce'),
        __('Aksu', 'states-cities-and-places-for-woocommerce'),
        __('Alanya', 'states-cities-and-places-for-woocommerce'),
        __('Demre', 'states-cities-and-places-for-woocommerce'),
        __('Döşemealtı', 'states-cities-and-places-for-woocommerce'),
        __('Elmalı', 'states-cities-and-places-for-woocommerce'),
        __('Finike', 'states-cities-and-places-for-woocommerce'),
        __('Gazipaşa', 'states-cities-and-places-for-woocommerce'),
        __('Gündoğmuş', 'states-cities-and-places-for-woocommerce'),
        __('İbradı', 'states-cities-and-places-for-woocommerce'),
        __('Kaş', 'states-cities-and-places-for-woocommerce'),
        __('Kemer', 'states-cities-and-places-for-woocommerce'),
        __('Kepez', 'states-cities-and-places-for-woocommerce'),
        __('Konyaaltı', 'states-cities-and-places-for-woocommerce'),
        __('Korkuteli', 'states-cities-and-places-for-woocommerce'),
        __('Kumluca', 'states-cities-and-places-for-woocommerce'),
        __('Manavgat', 'states-cities-and-places-for-woocommerce'),
        __('Muratpaşa', 'states-cities-and-places-for-woocommerce'),
        __('Serik', 'states-cities-and-places-for-woocommerce'),
    ),
    // Ardahan
    'ARD' => array(
        __('Çıldır', 'states-cities-and-places-for-woocommerce'),
        __('Damal', 'states-cities-and-places-for-woocommerce'),
        __('Göle', 'states-cities-and-places-for-woocommerce'),
        __('Hanak', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Posof', 'states-cities-and-places-for-woocommerce'),
    ),
    // Artvin
    'ART' => array(
        __('Ardanuç', 'states-cities-and-places-for-woocommerce'),
        __('Arhavi', 'states-cities-and-places-for-woocommerce'),
        __('Borçka', 'states-cities-and-places-for-woocommerce'),
        __('Hopa', 'states-cities-and-places-for-woocommerce'),
        __('Kemalpaşa', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Murgul', 'states-cities-and-places-for-woocommerce'),
        __('Şavşat', 'states-cities-and-places-for-woocommerce'),
        __('Yusufeli', 'states-cities-and-places-for-woocommerce'),
    ),
    // Aydın
    'AYD' => array(
        __('Bozdoğan', 'states-cities-and-places-for-woocommerce'),
        __('Buharkent', 'states-cities-and-places-for-woocommerce'),
        __('Çine', 'states-cities-and-places-for-woocommerce'),
        __('Didim', 'states-cities-and-places-for-woocommerce'),
        __('Efeler', 'states-cities-and-places-for-woocommerce'),
        __('Germencik', 'states-cities-and-places-for-woocommerce'),
        __('İncirliova', 'states-cities-and-places-for-woocommerce'),
        __('Karacasu', 'states-cities-and-places-for-woocommerce'),
        __('Karpuzlu', 'states-cities-and-places-for-woocommerce'),
        __('Koçarlı', 'states-cities-and-places-for-woocommerce'),
        __('Köşk', 'states-cities-and-places-for-woocommerce'),
        __('Kuşadası', 'states-cities-and-places-for-woocommerce'),
        __('Kuyucak', 'states-cities-and-places-for-woocommerce'),
        __('Nazilli', 'states-cities-and-places-for-woocommerce'),
        __('Söke', 'states-cities-and-places-for-woocommerce'),
        __('Sultanhisar', 'states-cities-and-places-for-woocommerce'),
        __('Yenipazar', 'states-cities-and-places-for-woocommerce'),
    ),
    // Balıkesir
    'BAL' => array(
        __('Altıeylül', 'states-cities-and-places-for-woocommerce'),
        __('Ayvalık', 'states-cities-and-places-for-woocommerce'),
        __('Balya', 'states-cities-and-places-for-woocommerce'),
        __('Bandırma', 'states-cities-and-places-for-woocommerce'),
        __('Bigadiç', 'states-cities-and-places-for-woocommerce'),
        __('Burhaniye', 'states-cities-and-places-for-woocommerce'),
        __('Dursunbey', 'states-cities-and-places-for-woocommerce'),
        __('Edremit', 'states-cities-and-places-for-woocommerce'),
        __('Erdek', 'states-cities-and-places-for-woocommerce'),
        __('Gömeç', 'states-cities-and-places-for-woocommerce'),
        __('Gönen', 'states-cities-and-places-for-woocommerce'),
        __('Havran', 'states-cities-and-places-for-woocommerce'),
        __('İvrindi', 'states-cities-and-places-for-woocommerce'),
        __('Karesi', 'states-cities-and-places-for-woocommerce'),
        __('Kepsut', 'states-cities-and-places-for-woocommerce'),
        __('Manyas', 'states-cities-and-places-for-woocommerce'),
        __('Marmara', 'states-cities-and-places-for-woocommerce'),
        __('Savaştepe', 'states-cities-and-places-for-woocommerce'),
        __('Sındırgı', 'states-cities-and-places-for-woocommerce'),
        __('Susurluk', 'states-cities-and-places-for-woocommerce'),
    ),
    // Bartın
    'BAR' => array(
        __('Amasra', 'states-cities-and-places-for-woocommerce'),
        __('Kurucaşile', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Ulus', 'states-cities-and-places-for-woocommerce'),
    ),
    // Batman
    'BAT' => array(
        __('Beşiri', 'states-cities-and-places-for-woocommerce'),
        __('Gercüş', 'states-cities-and-places-for-woocommerce'),
        __('Hasankeyf', 'states-cities-and-places-for-woocommerce'),
        __('Kozluk', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Sason', 'states-cities-and-places-for-woocommerce'),
    ),
    // Bayburt
    'BAY' => array(
        __('Aydıntepe', 'states-cities-and-places-for-woocommerce'),
        __('Demirözü', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
    ),
    // Bilecik
    'BIL' => array(
        __('Bozüyük', 'states-cities-and-places-for-woocommerce'),
        __('Gölpazarı', 'states-cities-and-places-for-woocommerce'),
        __('İnhisar', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Osmaneli', 'states-cities-and-places-for-woocommerce'),
        __('Pazaryeri', 'states-cities-and-places-for-woocommerce'),
        __('Söğüt', 'states-cities-and-places-for-woocommerce'),
        __('Yenipazar', 'states-cities-and-places-for-woocommerce'),
    ),
    // Bingöl
    'BIN' => array(
        __('Adaklı', 'states-cities-and-places-for-woocommerce'),
        __('Genç', 'states-cities-and-places-for-woocommerce'),
        __('Karlıova', 'states-cities-and-places-for-woocommerce'),
        __('Kiğı', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Solhan', 'states-cities-and-places-for-woocommerce'),
        __('Yayladere', 'states-cities-and-places-for-woocommerce'),
        __('Yedisu', 'states-cities-and-places-for-woocommerce'),
    ),
    // Bitlis
    'BIT' => array(
        __('Adilcevaz', 'states-cities-and-places-for-woocommerce'),
        __('Ahlat', 'states-cities-and-places-for-woocommerce'),
        __('Güroymak', 'states-cities-and-places-for-woocommerce'),
        __('Hizan', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Mutki', 'states-cities-and-places-for-woocommerce'),
        __('Tatvan', 'states-cities-and-places-for-woocommerce'),
    ),
    // Bolu
    'BOL' => array(
        __('Dörtdivan', 'states-cities-and-places-for-woocommerce'),
        __('Gerede', 'states-cities-and-places-for-woocommerce'),
        __('Göynük', 'states-cities-and-places-for-woocommerce'),
        __('Kıbrıscık', 'states-cities-and-places-for-woocommerce'),
        __('Mengen', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Mudurnu', 'states-cities-and-places-for-woocommerce'),
        __('Seben', 'states-cities-and-places-for-woocommerce'),
        __('Yeniçağa', 'states-cities-and-places-for-woocommerce'),
    ),
    // Burdur
    'BURD' => array(
        __('Ağlasun', 'states-cities-and-places-for-woocommerce'),
        __('Altınyayla', 'states-cities-and-places-for-woocommerce'),
        __('Bucak', 'states-cities-and-places-for-woocommerce'),
        __('Çavdır', 'states-cities-and-places-for-woocommerce'),
        __('Çeltikçi', 'states-cities-and-places-for-woocommerce'),
        __('Gölhisar', 'states-cities-and-places-for-woocommerce'),
        __('Karamanlı', 'states-cities-and-places-for-woocommerce'),
        __('Kemer', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Tefenni', 'states-cities-and-places-for-woocommerce'),
        __('Yeşilova', 'states-cities-and-places-for-woocommerce'),
    ),
    // Bursa
    'BURS' => array(
        __('Büyükorhan', 'states-cities-and-places-for-woocommerce'),
        __('Gemlik', 'states-cities-and-places-for-woocommerce'),
        __('Gürsu', 'states-cities-and-places-for-woocommerce'),
        __('Harmancık', 'states-cities-and-places-for-woocommerce'),
        __('İnegöl', 'states-cities-and-places-for-woocommerce'),
        __('İznik', 'states-cities-and-places-for-woocommerce'),
        __('Karacabey', 'states-cities-and-places-for-woocommerce'),
        __('Keles', 'states-cities-and-places-for-woocommerce'),
        __('Kestel', 'states-cities-and-places-for-woocommerce'),
        __('Mudanya', 'states-cities-and-places-for-woocommerce'),
        __('Mustafakemalpaşa', 'states-cities-and-places-for-woocommerce'),
        __('Nilüfer', 'states-cities-and-places-for-woocommerce'),
        __('Orhaneli', 'states-cities-and-places-for-woocommerce'),
        __('Orhangazi', 'states-cities-and-places-for-woocommerce'),
        __('Osmangazi', 'states-cities-and-places-for-woocommerce'),
        __('Yenişehir', 'states-cities-and-places-for-woocommerce'),
        __('Yıldırım', 'states-cities-and-places-for-woocommerce'),
    ),
    // Çanakkale
    'CANAK' => array(
        __('Ayvacık', 'states-cities-and-places-for-woocommerce'),
        __('Bayramiç', 'states-cities-and-places-for-woocommerce'),
        __('Biga', 'states-cities-and-places-for-woocommerce'),
        __('Bozcaada', 'states-cities-and-places-for-woocommerce'),
        __('Çan', 'states-cities-and-places-for-woocommerce'),
        __('Eceabat', 'states-cities-and-places-for-woocommerce'),
        __('Ezine', 'states-cities-and-places-for-woocommerce'),
        __('Gelibolu', 'states-cities-and-places-for-woocommerce'),
        __('Gökçeada', 'states-cities-and-places-for-woocommerce'),
        __('Lapseki', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Yenice', 'states-cities-and-places-for-woocommerce'),
    ),
    // Çankırı
    'CANK' => array(
        __('Atkaracalar', 'states-cities-and-places-for-woocommerce'),
        __('Bayramören', 'states-cities-and-places-for-woocommerce'),
        __('Çerkeş', 'states-cities-and-places-for-woocommerce'),
        __('Eldivan', 'states-cities-and-places-for-woocommerce'),
        __('Ilgaz', 'states-cities-and-places-for-woocommerce'),
        __('Kızılırmak', 'states-cities-and-places-for-woocommerce'),
        __('Korgun', 'states-cities-and-places-for-woocommerce'),
        __('Kurşunlu', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Orta', 'states-cities-and-places-for-woocommerce'),
        __('Şabanözü', 'states-cities-and-places-for-woocommerce'),
        __('Yapraklı', 'states-cities-and-places-for-woocommerce'),
    ),
    // Çorum
    'COR' => array(
        __('Alaca', 'states-cities-and-places-for-woocommerce'),
        __('Bayat', 'states-cities-and-places-for-woocommerce'),
        __('Boğazkale', 'states-cities-and-places-for-woocommerce'),
        __('Dodurga', 'states-cities-and-places-for-woocommerce'),
        __('İskilip', 'states-cities-and-places-for-woocommerce'),
        __('Kargı', 'states-cities-and-places-for-woocommerce'),
        __('Laçin', 'states-cities-and-places-for-woocommerce'),
        __('Mecitözü', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Oğuzlar', 'states-cities-and-places-for-woocommerce'),
        __('Ortaköy', 'states-cities-and-places-for-woocommerce'),
        __('Osmancık', 'states-cities-and-places-for-woocommerce'),
        __('Sungurlu', 'states-cities-and-places-for-woocommerce'),
        __('Uğurludağ', 'states-cities-and-places-for-woocommerce'),
    ),
    // Denizli
    'DEN' => array(
        __('Acıpayam', 'states-cities-and-places-for-woocommerce'),
        __('Babadağ', 'states-cities-and-places-for-woocommerce'),
        __('Baklan', 'states-cities-and-places-for-woocommerce'),

        __('Bekilli', 'states-cities-and-places-for-woocommerce'),
        __('Beyağaç', 'states-cities-and-places-for-woocommerce'),
        __('Bozkurt', 'states-cities-and-places-for-woocommerce'),
        __('Buldan', 'states-cities-and-places-for-woocommerce'),
        __('Çal', 'states-cities-and-places-for-woocommerce'),
        __('Çameli', 'states-cities-and-places-for-woocommerce'),
        __('Çardak', 'states-cities-and-places-for-woocommerce'),
        __('Çivril', 'states-cities-and-places-for-woocommerce'),
        __('Güney', 'states-cities-and-places-for-woocommerce'),
        __('Honaz', 'states-cities-and-places-for-woocommerce'),
        __('Kale', 'states-cities-and-places-for-woocommerce'),
        __('Merkezefendi', 'states-cities-and-places-for-woocommerce'),
        __('Pamukkale', 'states-cities-and-places-for-woocommerce'),
        __('Sarayköy', 'states-cities-and-places-for-woocommerce'),
        __('Serinhisar', 'states-cities-and-places-for-woocommerce'),
        __('Tavas', 'states-cities-and-places-for-woocommerce'),
    ),
    // Diyarbakır
    'DIY' => array(
        __('Bağlar', 'states-cities-and-places-for-woocommerce'),
        __('Bismil', 'states-cities-and-places-for-woocommerce'),
        __('Çermik', 'states-cities-and-places-for-woocommerce'),
        __('Çınar', 'states-cities-and-places-for-woocommerce'),
        __('Çüngüş', 'states-cities-and-places-for-woocommerce'),
        __('Dicle', 'states-cities-and-places-for-woocommerce'),
        __('Eğil', 'states-cities-and-places-for-woocommerce'),
        __('Ergani', 'states-cities-and-places-for-woocommerce'),
        __('Hani', 'states-cities-and-places-for-woocommerce'),
        __('Hazro', 'states-cities-and-places-for-woocommerce'),
        __('Kayapınar', 'states-cities-and-places-for-woocommerce'),
        __('Kocaköy', 'states-cities-and-places-for-woocommerce'),
        __('Kulp', 'states-cities-and-places-for-woocommerce'),
        __('Lice', 'states-cities-and-places-for-woocommerce'),
        __('Silvan', 'states-cities-and-places-for-woocommerce'),
        __('Sur', 'states-cities-and-places-for-woocommerce'),
        __('Yenişehir', 'states-cities-and-places-for-woocommerce'),
    ),
    // Düzce
    'DUZ' => array(
        __('Akçakoca', 'states-cities-and-places-for-woocommerce'),
        __('Cumayeri', 'states-cities-and-places-for-woocommerce'),
        __('Çilimli', 'states-cities-and-places-for-woocommerce'),
        __('Gölyaka', 'states-cities-and-places-for-woocommerce'),
        __('Gümüşova', 'states-cities-and-places-for-woocommerce'),
        __('Kaynaşlı', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Yığılca', 'states-cities-and-places-for-woocommerce'),
    ),
    // Edirne
    'EDI' => array(
        __('Enez', 'states-cities-and-places-for-woocommerce'),
        __('Havsa', 'states-cities-and-places-for-woocommerce'),
        __('İpsala', 'states-cities-and-places-for-woocommerce'),
        __('Keşan', 'states-cities-and-places-for-woocommerce'),
        __('Lalapaşa', 'states-cities-and-places-for-woocommerce'),
        __('Meriç', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Süloğlu', 'states-cities-and-places-for-woocommerce'),
        __('Uzunköprü', 'states-cities-and-places-for-woocommerce'),
    ),
    // Elazığ
    'ELA' => array(
        __('Ağın', 'states-cities-and-places-for-woocommerce'),
        __('Alacakaya', 'states-cities-and-places-for-woocommerce'),
        __('Arıcak', 'states-cities-and-places-for-woocommerce'),
        __('Baskil', 'states-cities-and-places-for-woocommerce'),
        __('Karakoçan', 'states-cities-and-places-for-woocommerce'),
        __('Keban', 'states-cities-and-places-for-woocommerce'),
        __('Kovancılar', 'states-cities-and-places-for-woocommerce'),
        __('Maden', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Palu', 'states-cities-and-places-for-woocommerce'),
        __('Sivrice', 'states-cities-and-places-for-woocommerce'),
    ),
    // Erzincan
    'ERZI' => array(
        __('Çayırlı', 'states-cities-and-places-for-woocommerce'),
        __('İliç', 'states-cities-and-places-for-woocommerce'),
        __('Kemah', 'states-cities-and-places-for-woocommerce'),
        __('Kemaliye', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Otlukbeli', 'states-cities-and-places-for-woocommerce'),
        __('Refahiye', 'states-cities-and-places-for-woocommerce'),
        __('Tercan', 'states-cities-and-places-for-woocommerce'),
        __('Üzümlü', 'states-cities-and-places-for-woocommerce'),
    ),
    // Erzurum
    'ERZU' => array(
        __('Aşkale', 'states-cities-and-places-for-woocommerce'),
        __('Aziziye', 'states-cities-and-places-for-woocommerce'),
        __('Çat', 'states-cities-and-places-for-woocommerce'),
        __('Hınıs', 'states-cities-and-places-for-woocommerce'),
        __('Horasan', 'states-cities-and-places-for-woocommerce'),
        __('İspir', 'states-cities-and-places-for-woocommerce'),
        __('Karaçoban', 'states-cities-and-places-for-woocommerce'),
        __('Karayazı', 'states-cities-and-places-for-woocommerce'),
        __('Köprüköy', 'states-cities-and-places-for-woocommerce'),
        __('Narman', 'states-cities-and-places-for-woocommerce'),
        __('Oltu', 'states-cities-and-places-for-woocommerce'),
        __('Olur', 'states-cities-and-places-for-woocommerce'),
        __('Palandöken', 'states-cities-and-places-for-woocommerce'),
        __('Pasinler', 'states-cities-and-places-for-woocommerce'),
        __('Pazaryolu', 'states-cities-and-places-for-woocommerce'),
        __('Şenkaya', 'states-cities-and-places-for-woocommerce'),
        __('Tekman', 'states-cities-and-places-for-woocommerce'),
        __('Tortum', 'states-cities-and-places-for-woocommerce'),
        __('Uzundere', 'states-cities-and-places-for-woocommerce'),
        __('Yakutiye', 'states-cities-and-places-for-woocommerce'),
    ),
    // Eskişehir
    'ESK' => array(
        __('Alpu', 'states-cities-and-places-for-woocommerce'),
        __('Beylikova', 'states-cities-and-places-for-woocommerce'),
        __('Çifteler', 'states-cities-and-places-for-woocommerce'),
        __('Günyüzü', 'states-cities-and-places-for-woocommerce'),
        __('Han', 'states-cities-and-places-for-woocommerce'),
        __('İnönü', 'states-cities-and-places-for-woocommerce'),
        __('Mahmudiye', 'states-cities-and-places-for-woocommerce'),
        __('Mihalgazi', 'states-cities-and-places-for-woocommerce'),
        __('Mihalıççık', 'states-cities-and-places-for-woocommerce'),
        __('Odunpazarı', 'states-cities-and-places-for-woocommerce'),
        __('Sarıcakaya', 'states-cities-and-places-for-woocommerce'),
        __('Seyitgazi', 'states-cities-and-places-for-woocommerce'),
        __('Sivrihisar', 'states-cities-and-places-for-woocommerce'),
        __('Tepebaşı', 'states-cities-and-places-for-woocommerce'),
    ),
    // Gaziantep
    'GAZ' => array(
        __('Araban', 'states-cities-and-places-for-woocommerce'),
        __('İslahiye', 'states-cities-and-places-for-woocommerce'),
        __('Karkamış', 'states-cities-and-places-for-woocommerce'),
        __('Nizip', 'states-cities-and-places-for-woocommerce'),
        __('Nurdağı', 'states-cities-and-places-for-woocommerce'),
        __('Oğuzeli', 'states-cities-and-places-for-woocommerce'),
        __('Şahinbey', 'states-cities-and-places-for-woocommerce'),
        __('Şehitkamil', 'states-cities-and-places-for-woocommerce'),
        __('Yavuzeli', 'states-cities-and-places-for-woocommerce'),
    ),
    // Giresun
    'GIR' => array(
        __('Alucra', 'states-cities-and-places-for-woocommerce'),
        __('Bulancak', 'states-cities-and-places-for-woocommerce'),
        __('Çamoluk', 'states-cities-and-places-for-woocommerce'),
        __('Çanakçı', 'states-cities-and-places-for-woocommerce'),
        __('Dereli', 'states-cities-and-places-for-woocommerce'),
        __('Doğankent', 'states-cities-and-places-for-woocommerce'),
        __('Espiye', 'states-cities-and-places-for-woocommerce'),
        __('Eynesil', 'states-cities-and-places-for-woocommerce'),
        __('Görele', 'states-cities-and-places-for-woocommerce'),
        __('Güce', 'states-cities-and-places-for-woocommerce'),
        __('Keşap', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Piraziz', 'states-cities-and-places-for-woocommerce'),
        __('Şebinkarahisar', 'states-cities-and-places-for-woocommerce'),
        __('Tirebolu', 'states-cities-and-places-for-woocommerce'),
        __('Yağlıdere', 'states-cities-and-places-for-woocommerce'),
    ),
    // Gümüşhane
    'GUM' => array(
        __('Kelkit', 'states-cities-and-places-for-woocommerce'),
        __('Köse', 'states-cities-and-places-for-woocommerce'),
        __('Kürtün', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Şiran', 'states-cities-and-places-for-woocommerce'),
        __('Torul', 'states-cities-and-places-for-woocommerce'),
    ),
    // Hakkari
    'HAK' => array(
        __('Çukurca', 'states-cities-and-places-for-woocommerce'),
        __('Derecik', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Şemdinli', 'states-cities-and-places-for-woocommerce'),
        __('Yüksekova', 'states-cities-and-places-for-woocommerce'),
    ),
    // Hatay
    'HAT' => array(
        __('Altınözü', 'states-cities-and-places-for-woocommerce'),
        __('Antakya', 'states-cities-and-places-for-woocommerce'),
        __('Arsuz', 'states-cities-and-places-for-woocommerce'),
        __('Belen', 'states-cities-and-places-for-woocommerce'),
        __('Defne', 'states-cities-and-places-for-woocommerce'),
        __('Dörtyol', 'states-cities-and-places-for-woocommerce'),
        __('Erzin', 'states-cities-and-places-for-woocommerce'),
        __('Hassa', 'states-cities-and-places-for-woocommerce'),
        __('İskenderun', 'states-cities-and-places-for-woocommerce'),
        __('Kırıkhan', 'states-cities-and-places-for-woocommerce'),
        __('Kumlu', 'states-cities-and-places-for-woocommerce'),
        __('Payas', 'states-cities-and-places-for-woocommerce'),
        __('Reyhanlı', 'states-cities-and-places-for-woocommerce'),
        __('Samandağ', 'states-cities-and-places-for-woocommerce'),
        __('Yayladağı', 'states-cities-and-places-for-woocommerce'),
    ),
    // Iğdır
    'IGD' => array(
        __('Aralık', 'states-cities-and-places-for-woocommerce'),
        __('Karakoyunlu', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Tuzluca', 'states-cities-and-places-for-woocommerce'),
    ),
    // Isparta
    'ISP' => array(
        __('Aksu', 'states-cities-and-places-for-woocommerce'),
        __('Atabey', 'states-cities-and-places-for-woocommerce'),
        __('Eğirdir', 'states-cities-and-places-for-woocommerce'),
        __('Gelendost', 'states-cities-and-places-for-woocommerce'),
        __('Gönen', 'states-cities-and-places-for-woocommerce'),
        __('Keçiborlu', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Senirkent', 'states-cities-and-places-for-woocommerce'),
        __('Sütçüler', 'states-cities-and-places-for-woocommerce'),
        __('Şarkikaraağaç', 'states-cities-and-places-for-woocommerce'),
        __('Uluborlu', 'states-cities-and-places-for-woocommerce'),
        __('Yalvaç', 'states-cities-and-places-for-woocommerce'),
        __('Yenişarbademli', 'states-cities-and-places-for-woocommerce'),
    ),
    // İstanbul
    'IST' => array(
        __('Adalar', 'states-cities-and-places-for-woocommerce'),
        __('Arnavutköy', 'states-cities-and-places-for-woocommerce'),
        __('Ataşehir', 'states-cities-and-places-for-woocommerce'),
        __('Avcılar', 'states-cities-and-places-for-woocommerce'),
        __('Bağcılar', 'states-cities-and-places-for-woocommerce'),
        __('Bahçelievler', 'states-cities-and-places-for-woocommerce'),
        __('Bakırköy', 'states-cities-and-places-for-woocommerce'),
        __('Başakşehir', 'states-cities-and-places-for-woocommerce'),
        __('Bayrampaşa', 'states-cities-and-places-for-woocommerce'),
        __('Beşiktaş', 'states-cities-and-places-for-woocommerce'),
        __('Beykoz', 'states-cities-and-places-for-woocommerce'),
        __('Beylikdüzü', 'states-cities-and-places-for-woocommerce'),
        __('Beyoğlu', 'states-cities-and-places-for-woocommerce'),
        __('Büyükçekmece', 'states-cities-and-places-for-woocommerce'),
        __('Çatalca', 'states-cities-and-places-for-woocommerce'),
        __('Çekmeköy', 'states-cities-and-places-for-woocommerce'),
        __('Esenler', 'states-cities-and-places-for-woocommerce'),
        __('Esenyurt', 'states-cities-and-places-for-woocommerce'),
        __('Eyüpsultan', 'states-cities-and-places-for-woocommerce'),
        __('Fatih', 'states-cities-and-places-for-woocommerce'),
        __('Gaziosmanpaşa', 'states-cities-and-places-for-woocommerce'),
        __('Güngören', 'states-cities-and-places-for-woocommerce'),
        __('Kadıköy', 'states-cities-and-places-for-woocommerce'),
        __('Kağıthane', 'states-cities-and-places-for-woocommerce'),
        __('Kartal', 'states-cities-and-places-for-woocommerce'),
        __('Küçükçekmece', 'states-cities-and-places-for-woocommerce'),
        __('Maltepe', 'states-cities-and-places-for-woocommerce'),
        __('Pendik', 'states-cities-and-places-for-woocommerce'),
        __('Sancaktepe', 'states-cities-and-places-for-woocommerce'),
        __('Sarıyer', 'states-cities-and-places-for-woocommerce'),
        __('Silivri', 'states-cities-and-places-for-woocommerce'),
        __('Sultanbeyli', 'states-cities-and-places-for-woocommerce'),
        __('Sultangazi', 'states-cities-and-places-for-woocommerce'),
        __('Şile', 'states-cities-and-places-for-woocommerce'),
        __('Şişli', 'states-cities-and-places-for-woocommerce'),
        __('Tuzla', 'states-cities-and-places-for-woocommerce'),
        __('Ümraniye', 'states-cities-and-places-for-woocommerce'),
        __('Üsküdar', 'states-cities-and-places-for-woocommerce'),
        __('Zeytinburnu', 'states-cities-and-places-for-woocommerce'),
    ),
    // İzmir
    'IZM' => array(
        __('Aliağa', 'states-cities-and-places-for-woocommerce'),
        __('Balçova', 'states-cities-and-places-for-woocommerce'),
        __('Bayındır', 'states-cities-and-places-for-woocommerce'),
        __('Bayraklı', 'states-cities-and-places-for-woocommerce'),
        __('Bergama', 'states-cities-and-places-for-woocommerce'),
        __('Beydağ', 'states-cities-and-places-for-woocommerce'),
        __('Bornova', 'states-cities-and-places-for-woocommerce'),
        __('Buca', 'states-cities-and-places-for-woocommerce'),
        __('Çeşme', 'states-cities-and-places-for-woocommerce'),
        __('Çiğli', 'states-cities-and-places-for-woocommerce'),
        __('Dikili', 'states-cities-and-places-for-woocommerce'),
        __('Foça', 'states-cities-and-places-for-woocommerce'),
        __('Gaziemir', 'states-cities-and-places-for-woocommerce'),
        __('Güzelbahçe', 'states-cities-and-places-for-woocommerce'),
        __('Karabağlar', 'states-cities-and-places-for-woocommerce'),
        __('Karaburun', 'states-cities-and-places-for-woocommerce'),
        __('Karşıyaka', 'states-cities-and-places-for-woocommerce'),
        __('Kemalpaşa', 'states-cities-and-places-for-woocommerce'),
        __('Kınık', 'states-cities-and-places-for-woocommerce'),
        __('Kiraz', 'states-cities-and-places-for-woocommerce'),
        __('Konak', 'states-cities-and-places-for-woocommerce'),
        __('Menderes', 'states-cities-and-places-for-woocommerce'),
        __('Menemen', 'states-cities-and-places-for-woocommerce'),
        __('Narlıdere', 'states-cities-and-places-for-woocommerce'),
        __('Ödemiş', 'states-cities-and-places-for-woocommerce'),
        __('Seferihisar', 'states-cities-and-places-for-woocommerce'),
        __('Selçuk', 'states-cities-and-places-for-woocommerce'),
        __('Tire', 'states-cities-and-places-for-woocommerce'),
        __('Torbalı', 'states-cities-and-places-for-woocommerce'),
        __('Urla', 'states-cities-and-places-for-woocommerce'),
    ),
    // Kahramanmaraş
    'KAH' => array(
        __('Afşin', 'states-cities-and-places-for-woocommerce'),
        __('Andırın', 'states-cities-and-places-for-woocommerce'),
        __('Çağlayancerit', 'states-cities-and-places-for-woocommerce'),
        __('Dulkadiroğlu', 'states-cities-and-places-for-woocommerce'),
        __('Ekinözü', 'states-cities-and-places-for-woocommerce'),
        __('Elbistan', 'states-cities-and-places-for-woocommerce'),
        __('Göksun', 'states-cities-and-places-for-woocommerce'),
        __('Nurhak', 'states-cities-and-places-for-woocommerce'),
        __('Onikişubat', 'states-cities-and-places-for-woocommerce'),
        __('Pazarcık', 'states-cities-and-places-for-woocommerce'),
        __('Türkoğlu', 'states-cities-and-places-for-woocommerce'),
    ),
    // Karabük
    'KARAB' => array(
        __('Eflani', 'states-cities-and-places-for-woocommerce'),
        __('Eskipazar', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Ovacık', 'states-cities-and-places-for-woocommerce'),
        __('Safranbolu', 'states-cities-and-places-for-woocommerce'),
        __('Yenice', 'states-cities-and-places-for-woocommerce'),
    ),
    // Karaman
    'KARAM' => array(
        __('Ayrancı', 'states-cities-and-places-for-woocommerce'),
        __('Başyayla', 'states-cities-and-places-for-woocommerce'),
        __('Ermenek', 'states-cities-and-places-for-woocommerce'),
        __('Kazımkarabekir', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Sarıveliler', 'states-cities-and-places-for-woocommerce'),
    ),
    // Kars
    'KAR' => array(
        __('Akyaka', 'states-cities-and-places-for-woocommerce'),
        __('Arpaçay', 'states-cities-and-places-for-woocommerce'),
        __('Digor', 'states-cities-and-places-for-woocommerce'),
        __('Kağızman', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Sarıkamış', 'states-cities-and-places-for-woocommerce'),
        __('Selim', 'states-cities-and-places-for-woocommerce'),
        __('Susuz', 'states-cities-and-places-for-woocommerce'),
    ),
    // Kastamonu
    'KAS' => array(
        __('Abana', 'states-cities-and-places-for-woocommerce'),
        __('Ağlı', 'states-cities-and-places-for-woocommerce'),
        __('Araç', 'states-cities-and-places-for-woocommerce'),
        __('Azdavay', 'states-cities-and-places-for-woocommerce'),
        __('Bozkurt', 'states-cities-and-places-for-woocommerce'),
        __('Cide', 'states-cities-and-places-for-woocommerce'),
        __('Çatalzeytin', 'states-cities-and-places-for-woocommerce'),
        __('Daday', 'states-cities-and-places-for-woocommerce'),
        __('Devrekani', 'states-cities-and-places-for-woocommerce'),
        __('Doğanyurt', 'states-cities-and-places-for-woocommerce'),
        __('Hanönü', 'states-cities-and-places-for-woocommerce'),
        __('İhsangazi', 'states-cities-and-places-for-woocommerce'),
        __('İnebolu', 'states-cities-and-places-for-woocommerce'),
        __('Küre', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Pınarbaşı', 'states-cities-and-places-for-woocommerce'),
        __('Seydiler', 'states-cities-and-places-for-woocommerce'),
        __('Şenpazar', 'states-cities-and-places-for-woocommerce'),
        __('Taşköprü', 'states-cities-and-places-for-woocommerce'),
        __('Tosya', 'states-cities-and-places-for-woocommerce'),
    ),
    // Kayseri
    'KAY' => array(
        __('Akkışla', 'states-cities-and-places-for-woocommerce'),
        __('Bünyan', 'states-cities-and-places-for-woocommerce'),
        __('Develi', 'states-cities-and-places-for-woocommerce'),
        __('Felahiye', 'states-cities-and-places-for-woocommerce'),
        __('Hacılar', 'states-cities-and-places-for-woocommerce'),
        __('İncesu', 'states-cities-and-places-for-woocommerce'),
        __('Kocasinan', 'states-cities-and-places-for-woocommerce'),
        __('Melikgazi', 'states-cities-and-places-for-woocommerce'),
        __('Özvatan', 'states-cities-and-places-for-woocommerce'),
        __('Pınarbaşı', 'states-cities-and-places-for-woocommerce'),
        __('Sarıoğlan', 'states-cities-and-places-for-woocommerce'),
        __('Sarız', 'states-cities-and-places-for-woocommerce'),
        __('Talas', 'states-cities-and-places-for-woocommerce'),
        __('Tomarza', 'states-cities-and-places-for-woocommerce'),
        __('Yahyalı', 'states-cities-and-places-for-woocommerce'),
        __('Yeşilhisar', 'states-cities-and-places-for-woocommerce'),
    ),
    // Kırıkkale
    'KIRIK' => array(
        __('Bahşılı', 'states-cities-and-places-for-woocommerce'),
        __('Balışeyh', 'states-cities-and-places-for-woocommerce'),
        __('Çelebi', 'states-cities-and-places-for-woocommerce'),
        __('Delice', 'states-cities-and-places-for-woocommerce'),
        __('Karakeçili', 'states-cities-and-places-for-woocommerce'),
        __('Keskin', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Sulakyurt', 'states-cities-and-places-for-woocommerce'),
        __('Yahşihan', 'states-cities-and-places-for-woocommerce'),
    ),
    // Kırklareli
    'KIRK' => array(
        __('Babaeski', 'states-cities-and-places-for-woocommerce'),
        __('Demirköy', 'states-cities-and-places-for-woocommerce'),
        __('Kofçaz', 'states-cities-and-places-for-woocommerce'),
        __('Lüleburgaz', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Pehlivanköy', 'states-cities-and-places-for-woocommerce'),
        __('Pınarhisar', 'states-cities-and-places-for-woocommerce'),
        __('Vize', 'states-cities-and-places-for-woocommerce'),
    ),
    // Kırşehir
    'KIRS' => array(
        __('Akçakent', 'states-cities-and-places-for-woocommerce'),
        __('Akpınar', 'states-cities-and-places-for-woocommerce'),
        __('Boztepe', 'states-cities-and-places-for-woocommerce'),
        __('Çiçekdağı', 'states-cities-and-places-for-woocommerce'),
        __('Kaman', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Mucur', 'states-cities-and-places-for-woocommerce'),
    ),
    // Kilis
    'KIL' => array(
        __('Elbeyli', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Musabeyli', 'states-cities-and-places-for-woocommerce'),
        __('Polateli', 'states-cities-and-places-for-woocommerce'),
    ),
    // Kocaeli
    'KOC' => array(
        __('Başiskele', 'states-cities-and-places-for-woocommerce'),
        __('Çayırova', 'states-cities-and-places-for-woocommerce'),
        __('Darıca', 'states-cities-and-places-for-woocommerce'),
        __('Derince', 'states-cities-and-places-for-woocommerce'),
        __('Dilovası', 'states-cities-and-places-for-woocommerce'),
        __('Gebze', 'states-cities-and-places-for-woocommerce'),
        __('Gölcük', 'states-cities-and-places-for-woocommerce'),
        __('İzmit', 'states-cities-and-places-for-woocommerce'),
        __('Kandıra', 'states-cities-and-places-for-woocommerce'),
        __('Karamürsel', 'states-cities-and-places-for-woocommerce'),
        __('Kartepe', 'states-cities-and-places-for-woocommerce'),
        __('Körfez', 'states-cities-and-places-for-woocommerce'),
    ),
    // Konya
    'KON' => array(
        __('Ahırlı', 'states-cities-and-places-for-woocommerce'),
        __('Akören', 'states-cities-and-places-for-woocommerce'),
        __('Akşehir', 'states-cities-and-places-for-woocommerce'),
        __('Altınekin', 'states-cities-and-places-for-woocommerce'),
        __('Beyşehir', 'states-cities-and-places-for-woocommerce'),
        __('Bozkır', 'states-cities-and-places-for-woocommerce'),
        __('Cihanbeyli', 'states-cities-and-places-for-woocommerce'),
        __('Çeltik', 'states-cities-and-places-for-woocommerce'),
        __('Çumra', 'states-cities-and-places-for-woocommerce'),
        __('Derbent', 'states-cities-and-places-for-woocommerce'),
        __('Derebucak', 'states-cities-and-places-for-woocommerce'),
        __('Doğanhisar', 'states-cities-and-places-for-woocommerce'),
        __('Emirgazi', 'states-cities-and-places-for-woocommerce'),
        __('Ereğli', 'states-cities-and-places-for-woocommerce'),
        __('Güneysınır', 'states-cities-and-places-for-woocommerce'),
        __('Hadim', 'states-cities-and-places-for-woocommerce'),
        __('Halkapınar', 'states-cities-and-places-for-woocommerce'),
        __('Hüyük', 'states-cities-and-places-for-woocommerce'),
        __('Ilgın', 'states-cities-and-places-for-woocommerce'),
        __('Kadınhanı', 'states-cities-and-places-for-woocommerce'),
        __('Karapınar', 'states-cities-and-places-for-woocommerce'),
        __('Karatay', 'states-cities-and-places-for-woocommerce'),
        __('Kulu', 'states-cities-and-places-for-woocommerce'),
        __('Meram', 'states-cities-and-places-for-woocommerce'),
        __('Sarayönü', 'states-cities-and-places-for-woocommerce'),
        __('Selçuklu', 'states-cities-and-places-for-woocommerce'),
        __('Seydişehir', 'states-cities-and-places-for-woocommerce'),
        __('Taşkent', 'states-cities-and-places-for-woocommerce'),
        __('Tuzlukçu', 'states-cities-and-places-for-woocommerce'),
        __('Yalıhüyük', 'states-cities-and-places-for-woocommerce'),
        __('Yunak', 'states-cities-and-places-for-woocommerce'),
    ),
    // Kütahya
    'KUT' => array(
        __('Altıntaş', 'states-cities-and-places-for-woocommerce'),
        __('Aslanapa', 'states-cities-and-places-for-woocommerce'),
        __('Çavdarhisar', 'states-cities-and-places-for-woocommerce'),
        __('Domaniç', 'states-cities-and-places-for-woocommerce'),
        __('Dumlupınar', 'states-cities-and-places-for-woocommerce'),
        __('Emet', 'states-cities-and-places-for-woocommerce'),
        __('Gediz', 'states-cities-and-places-for-woocommerce'),
        __('Hisarcık', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Pazarlar', 'states-cities-and-places-for-woocommerce'),
        __('Simav', 'states-cities-and-places-for-woocommerce'),
        __('Şaphane', 'states-cities-and-places-for-woocommerce'),
        __('Tavşanlı', 'states-cities-and-places-for-woocommerce'),
    ),
    // Malatya
    'MAL' => array(
        __('Akçadağ', 'states-cities-and-places-for-woocommerce'),
        __('Arapgir', 'states-cities-and-places-for-woocommerce'),
        __('Arguvan', 'states-cities-and-places-for-woocommerce'),
        __('Battalgazi', 'states-cities-and-places-for-woocommerce'),
        __('Darende', 'states-cities-and-places-for-woocommerce'),
        __('Doğanşehir', 'states-cities-and-places-for-woocommerce'),
        __('Doğanyol', 'states-cities-and-places-for-woocommerce'),
        __('Hekimhan', 'states-cities-and-places-for-woocommerce'),
        __('Kale', 'states-cities-and-places-for-woocommerce'),
        __('Kuluncak', 'states-cities-and-places-for-woocommerce'),
        __('Pütürge', 'states-cities-and-places-for-woocommerce'),
        __('Yazıhan', 'states-cities-and-places-for-woocommerce'),
        __('Yeşilyurt', 'states-cities-and-places-for-woocommerce'),
    ),
    // Manisa
    'MAN' => array(
        __('Ahmetli', 'states-cities-and-places-for-woocommerce'),
        __('Akhisar', 'states-cities-and-places-for-woocommerce'),
        __('Alaşehir', 'states-cities-and-places-for-woocommerce'),
        __('Demirci', 'states-cities-and-places-for-woocommerce'),
        __('Gölmarmara', 'states-cities-and-places-for-woocommerce'),
        __('Gördes', 'states-cities-and-places-for-woocommerce'),
        __('Kırkağaç', 'states-cities-and-places-for-woocommerce'),
        __('Köprübaşı', 'states-cities-and-places-for-woocommerce'),
        __('Kula', 'states-cities-and-places-for-woocommerce'),
        __('Salihli', 'states-cities-and-places-for-woocommerce'),
        __('Sarıgöl', 'states-cities-and-places-for-woocommerce'),
        __('Saruhanlı', 'states-cities-and-places-for-woocommerce'),
        __('Selendi', 'states-cities-and-places-for-woocommerce'),
        __('Soma', 'states-cities-and-places-for-woocommerce'),
        __('Şehzadeler', 'states-cities-and-places-for-woocommerce'),
        __('Turgutlu', 'states-cities-and-places-for-woocommerce'),
        __('Yunusemre', 'states-cities-and-places-for-woocommerce'),
    ),
    // Mardin
    'MAR' => array(
        __('Artuklu', 'states-cities-and-places-for-woocommerce'),
        __('Dargeçit', 'states-cities-and-places-for-woocommerce'),
        __('Derik', 'states-cities-and-places-for-woocommerce'),
        __('Kızıltepe', 'states-cities-and-places-for-woocommerce'),
        __('Mazıdağı', 'states-cities-and-places-for-woocommerce'),
        __('Midyat', 'states-cities-and-places-for-woocommerce'),
        __('Nusaybin', 'states-cities-and-places-for-woocommerce'),
        __('Ömerli', 'states-cities-and-places-for-woocommerce'),
        __('Savur', 'states-cities-and-places-for-woocommerce'),
        __('Yeşilli', 'states-cities-and-places-for-woocommerce'),
    ),
    // Mersin
    'MER' => array(
        __('Akdeniz', 'states-cities-and-places-for-woocommerce'),
        __('Anamur', 'states-cities-and-places-for-woocommerce'),
        __('Aydıncık', 'states-cities-and-places-for-woocommerce'),
        __('Bozyazı', 'states-cities-and-places-for-woocommerce'),
        __('Çamlıyayla', 'states-cities-and-places-for-woocommerce'),
        __('Erdemli', 'states-cities-and-places-for-woocommerce'),
        __('Gülnar', 'states-cities-and-places-for-woocommerce'),
        __('Mezitli', 'states-cities-and-places-for-woocommerce'),
        __('Mut', 'states-cities-and-places-for-woocommerce'),
        __('Silifke', 'states-cities-and-places-for-woocommerce'),
        __('Tarsus', 'states-cities-and-places-for-woocommerce'),
        __('Toroslar', 'states-cities-and-places-for-woocommerce'),
        __('Yenişehir', 'states-cities-and-places-for-woocommerce'),
    ),
    // Muğla
    'MUG' => array(
        __('Bodrum', 'states-cities-and-places-for-woocommerce'),
        __('Dalaman', 'states-cities-and-places-for-woocommerce'),
        __('Datça', 'states-cities-and-places-for-woocommerce'),
        __('Fethiye', 'states-cities-and-places-for-woocommerce'),
        __('Kavaklıdere', 'states-cities-and-places-for-woocommerce'),
        __('Köyceğiz', 'states-cities-and-places-for-woocommerce'),
        __('Marmaris', 'states-cities-and-places-for-woocommerce'),
        __('Menteşe', 'states-cities-and-places-for-woocommerce'),
        __('Milas', 'states-cities-and-places-for-woocommerce'),
        __('Ortaca', 'states-cities-and-places-for-woocommerce'),
        __('Seydikemer', 'states-cities-and-places-for-woocommerce'),
        __('Ula', 'states-cities-and-places-for-woocommerce'),
        __('Yatağan', 'states-cities-and-places-for-woocommerce'),
    ),
    // Muş
    'MUS' => array(
        __('Bulanık', 'states-cities-and-places-for-woocommerce'),
        __('Hasköy', 'states-cities-and-places-for-woocommerce'),
        __('Korkut', 'states-cities-and-places-for-woocommerce'),
        __('Malazgirt', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Varto', 'states-cities-and-places-for-woocommerce'),
    ),
    // Nevşehir
    'NEV' => array(
        __('Acıgöl', 'states-cities-and-places-for-woocommerce'),
        __('Avanos', 'states-cities-and-places-for-woocommerce'),
        __('Derinkuyu', 'states-cities-and-places-for-woocommerce'),
        __('Gülşehir', 'states-cities-and-places-for-woocommerce'),
        __('Hacıbektaş', 'states-cities-and-places-for-woocommerce'),
        __('Kozaklı', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Ürgüp', 'states-cities-and-places-for-woocommerce'),
    ),
    // Niğde
    'NIG' => array(
        __('Altunhisar', 'states-cities-and-places-for-woocommerce'),
        __('Bor', 'states-cities-and-places-for-woocommerce'),
        __('Çamardı', 'states-cities-and-places-for-woocommerce'),
        __('Çiftlik', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Ulukışla', 'states-cities-and-places-for-woocommerce'),
    ),
    // Ordu
    'ORD' => array(
        __('Akkuş', 'states-cities-and-places-for-woocommerce'),
        __('Altınordu', 'states-cities-and-places-for-woocommerce'),
        __('Aybastı', 'states-cities-and-places-for-woocommerce'),
        __('Çamaş', 'states-cities-and-places-for-woocommerce'),
        __('Çatalpınar', 'states-cities-and-places-for-woocommerce'),
        __('Çaybaşı', 'states-cities-and-places-for-woocommerce'),
        __('Fatsa', 'states-cities-and-places-for-woocommerce'),
        __('Gölköy', 'states-cities-and-places-for-woocommerce'),
        __('Gülyalı', 'states-cities-and-places-for-woocommerce'),
        __('Gürgentepe', 'states-cities-and-places-for-woocommerce'),
        __('İkizce', 'states-cities-and-places-for-woocommerce'),
        __('Kabadüz', 'states-cities-and-places-for-woocommerce'),
        __('Kabataş', 'states-cities-and-places-for-woocommerce'),
        __('Korgan', 'states-cities-and-places-for-woocommerce'),
        __('Kumru', 'states-cities-and-places-for-woocommerce'),
        __('Mesudiye', 'states-cities-and-places-for-woocommerce'),
        __('Perşembe', 'states-cities-and-places-for-woocommerce'),
        __('Ulubey', 'states-cities-and-places-for-woocommerce'),
        __('Ünye', 'states-cities-and-places-for-woocommerce'),
    ),
    // Osmaniye
    'OSM' => array(
        __('Bahçe', 'states-cities-and-places-for-woocommerce'),
        __('Düziçi', 'states-cities-and-places-for-woocommerce'),
        __('Hasanbeyli', 'states-cities-and-places-for-woocommerce'),
        __('Kadirli', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Sumbas', 'states-cities-and-places-for-woocommerce'),
        __('Toprakkale', 'states-cities-and-places-for-woocommerce'),
    ),
    // Rize
    'RIZ' => array(
        __('Ardeşen', 'states-cities-and-places-for-woocommerce'),
        __('Çamlıhemşin', 'states-cities-and-places-for-woocommerce'),
        __('Çayeli', 'states-cities-and-places-for-woocommerce'),
        __('Derepazarı', 'states-cities-and-places-for-woocommerce'),
        __('Fındıklı', 'states-cities-and-places-for-woocommerce'),
        __('Güneysu', 'states-cities-and-places-for-woocommerce'),
        __('Hemşin', 'states-cities-and-places-for-woocommerce'),
        __('İkizdere', 'states-cities-and-places-for-woocommerce'),
        __('İyidere', 'states-cities-and-places-for-woocommerce'),
        __('Kalkandere', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Pazar', 'states-cities-and-places-for-woocommerce'),
    ),
    // Sakarya
    'SAK' => array(
        __('Adapazarı', 'states-cities-and-places-for-woocommerce'),
        __('Akyazı', 'states-cities-and-places-for-woocommerce'),
        __('Arifiye', 'states-cities-and-places-for-woocommerce'),
        __('Erenler', 'states-cities-and-places-for-woocommerce'),
        __('Ferizli', 'states-cities-and-places-for-woocommerce'),
        __('Geyve', 'states-cities-and-places-for-woocommerce'),
        __('Hendek', 'states-cities-and-places-for-woocommerce'),
        __('Karapürçek', 'states-cities-and-places-for-woocommerce'),
        __('Karasu', 'states-cities-and-places-for-woocommerce'),
        __('Kaynarca', 'states-cities-and-places-for-woocommerce'),
        __('Kocaali', 'states-cities-and-places-for-woocommerce'),
        __('Pamukova', 'states-cities-and-places-for-woocommerce'),
        __('Sapanca', 'states-cities-and-places-for-woocommerce'),
        __('Serdivan', 'states-cities-and-places-for-woocommerce'),
        __('Söğütlü', 'states-cities-and-places-for-woocommerce'),
        __('Taraklı', 'states-cities-and-places-for-woocommerce'),
    ),
    // Samsun
    'SAM' => array(
        __('19 Mayıs', 'states-cities-and-places-for-woocommerce'),
        __('Alaçam', 'states-cities-and-places-for-woocommerce'),
        __('Asarcık', 'states-cities-and-places-for-woocommerce'),
        __('Atakum', 'states-cities-and-places-for-woocommerce'),
        __('Ayvacık', 'states-cities-and-places-for-woocommerce'),
        __('Bafra', 'states-cities-and-places-for-woocommerce'),
        __('Canik', 'states-cities-and-places-for-woocommerce'),
        __('Çarşamba', 'states-cities-and-places-for-woocommerce'),
        __('Havza', 'states-cities-and-places-for-woocommerce'),
        __('İlkadım', 'states-cities-and-places-for-woocommerce'),
        __('Kavak', 'states-cities-and-places-for-woocommerce'),
        __('Ladik', 'states-cities-and-places-for-woocommerce'),
        __('Salıpazarı', 'states-cities-and-places-for-woocommerce'),
        __('Tekkeköy', 'states-cities-and-places-for-woocommerce'),
        __('Terme', 'states-cities-and-places-for-woocommerce'),
        __('Vezirköprü', 'states-cities-and-places-for-woocommerce'),
        __('Yakakent', 'states-cities-and-places-for-woocommerce'),
    ),
    // Siirt
    'SII' => array(
        __('Baykan', 'states-cities-and-places-for-woocommerce'),
        __('Eruh', 'states-cities-and-places-for-woocommerce'),
        __('Kurtalan', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Pervari', 'states-cities-and-places-for-woocommerce'),
        __('Şirvan', 'states-cities-and-places-for-woocommerce'),
        __('Tillo', 'states-cities-and-places-for-woocommerce'),
    ),
    // Sinop
    'SIN' => array(
        __('Ayancık', 'states-cities-and-places-for-woocommerce'),
        __('Boyabat', 'states-cities-and-places-for-woocommerce'),
        __('Dikmen', 'states-cities-and-places-for-woocommerce'),
        __('Durağan', 'states-cities-and-places-for-woocommerce'),
        __('Erfelek', 'states-cities-and-places-for-woocommerce'),
        __('Gerze', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Saraydüzü', 'states-cities-and-places-for-woocommerce'),
        __('Türkeli', 'states-cities-and-places-for-woocommerce'),
    ),
    // Sivas
    'SIV' => array(
        __('Akıncılar', 'states-cities-and-places-for-woocommerce'),
        __('Altınyayla', 'states-cities-and-places-for-woocommerce'),
        __('Divriği', 'states-cities-and-places-for-woocommerce'),
        __('Doğanşar', 'states-cities-and-places-for-woocommerce'),
        __('Gemerek', 'states-cities-and-places-for-woocommerce'),
        __('Gölova', 'states-cities-and-places-for-woocommerce'),
        __('Gürün', 'states-cities-and-places-for-woocommerce'),
        __('Hafik', 'states-cities-and-places-for-woocommerce'),
        __('İmranlı', 'states-cities-and-places-for-woocommerce'),
        __('Kangal', 'states-cities-and-places-for-woocommerce'),
        __('Koyulhisar', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Suşehri', 'states-cities-and-places-for-woocommerce'),
        __('Şarkışla', 'states-cities-and-places-for-woocommerce'),
        __('Ulaş', 'states-cities-and-places-for-woocommerce'),
        __('Yıldızeli', 'states-cities-and-places-for-woocommerce'),
        __('Zara', 'states-cities-and-places-for-woocommerce'),
    ),
    // Şanlıurfa
    'SAN' => array(
        __('Akçakale', 'states-cities-and-places-for-woocommerce'),
        __('Birecik', 'states-cities-and-places-for-woocommerce'),
        __('Bozova', 'states-cities-and-places-for-woocommerce'),
        __('Ceylanpınar', 'states-cities-and-places-for-woocommerce'),
        __('Eyyübiye', 'states-cities-and-places-for-woocommerce'),
        __('Halfeti', 'states-cities-and-places-for-woocommerce'),
        __('Haliliye', 'states-cities-and-places-for-woocommerce'),
        __('Harran', 'states-cities-and-places-for-woocommerce'),
        __('Hilvan', 'states-cities-and-places-for-woocommerce'),
        __('Karaköprü', 'states-cities-and-places-for-woocommerce'),
        __('Siverek', 'states-cities-and-places-for-woocommerce'),
        __('Suruç', 'states-cities-and-places-for-woocommerce'),
        __('Viranşehir', 'states-cities-and-places-for-woocommerce'),
    ),
    // Şırnak
    'SIR' => array(
        __('Beytüşşebap', 'states-cities-and-places-for-woocommerce'),
        __('Cizre', 'states-cities-and-places-for-woocommerce'),
        __('Güçlükonak', 'states-cities-and-places-for-woocommerce'),
        __('İdil', 'states-cities-and-places-for-woocommerce'),
        __('Silopi', 'states-cities-and-places-for-woocommerce'),
        __('Şırnak', 'states-cities-and-places-for-woocommerce'),
        __('Uludere', 'states-cities-and-places-for-woocommerce'),
    ),
    // Tekirdağ
    'TEK' => array(
        __('Çerkezköy', 'states-cities-and-places-for-woocommerce'),
        __('Çorlu', 'states-cities-and-places-for-woocommerce'),
        __('Ergene', 'states-cities-and-places-for-woocommerce'),
        __('Hayrabolu', 'states-cities-and-places-for-woocommerce'),
        __('Kapaklı', 'states-cities-and-places-for-woocommerce'),
        __('Malkara', 'states-cities-and-places-for-woocommerce'),
        __('Marmaraereğlisi', 'states-cities-and-places-for-woocommerce'),
        __('Muratlı', 'states-cities-and-places-for-woocommerce'),
        __('Saray', 'states-cities-and-places-for-woocommerce'),
        __('Süleymanpaşa', 'states-cities-and-places-for-woocommerce'),
        __('Şarköy', 'states-cities-and-places-for-woocommerce'),
    ),
    // Tokat
    'TOK' => array(
        __('Almus', 'states-cities-and-places-for-woocommerce'),
        __('Artova', 'states-cities-and-places-for-woocommerce'),
        __('Başçiftlik', 'states-cities-and-places-for-woocommerce'),
        __('Erbaa', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Niksar', 'states-cities-and-places-for-woocommerce'),
        __('Pazar', 'states-cities-and-places-for-woocommerce'),
        __('Reşadiye', 'states-cities-and-places-for-woocommerce'),
        __('Sulusaray', 'states-cities-and-places-for-woocommerce'),
        __('Turhal', 'states-cities-and-places-for-woocommerce'),
        __('Yeşilyurt', 'states-cities-and-places-for-woocommerce'),
        __('Zile', 'states-cities-and-places-for-woocommerce'),
    ),
    // Trabzon
    'TRA' => array(
        __('Akçaabat', 'states-cities-and-places-for-woocommerce'),
        __('Araklı', 'states-cities-and-places-for-woocommerce'),
        __('Arsin', 'states-cities-and-places-for-woocommerce'),
        __('Beşikdüzü', 'states-cities-and-places-for-woocommerce'),
        __('Çarşıbaşı', 'states-cities-and-places-for-woocommerce'),
        __('Çaykara', 'states-cities-and-places-for-woocommerce'),
        __('Dernekpazarı', 'states-cities-and-places-for-woocommerce'),
        __('Düzköy', 'states-cities-and-places-for-woocommerce'),
        __('Hayrat', 'states-cities-and-places-for-woocommerce'),
        __('Köprübaşı', 'states-cities-and-places-for-woocommerce'),
        __('Maçka', 'states-cities-and-places-for-woocommerce'),
        __('Of', 'states-cities-and-places-for-woocommerce'),
        __('Ortahisar', 'states-cities-and-places-for-woocommerce'),
        __('Sürmene', 'states-cities-and-places-for-woocommerce'),
        __('Şalpazarı', 'states-cities-and-places-for-woocommerce'),
        __('Tonya', 'states-cities-and-places-for-woocommerce'),
        __('Vakfıkebir', 'states-cities-and-places-for-woocommerce'),
        __('Yomra', 'states-cities-and-places-for-woocommerce'),
    ),
    // Tunceli
    'TUN' => array(
        __('Çemişgezek', 'states-cities-and-places-for-woocommerce'),
        __('Hozat', 'states-cities-and-places-for-woocommerce'),
        __('Mazgirt', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Nazımiye', 'states-cities-and-places-for-woocommerce'),
        __('Ovacık', 'states-cities-and-places-for-woocommerce'),
        __('Pertek', 'states-cities-and-places-for-woocommerce'),
        __('Pülümür', 'states-cities-and-places-for-woocommerce'),
    ),
    // Uşak
    'USA' => array(
        __('Banaz', 'states-cities-and-places-for-woocommerce'),
        __('Eşme', 'states-cities-and-places-for-woocommerce'),
        __('Karahallı', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Sivaslı', 'states-cities-and-places-for-woocommerce'),
        __('Ulubey', 'states-cities-and-places-for-woocommerce'),
    ),
    // Van
    'VAN' => array(
        __('Bahçesaray', 'states-cities-and-places-for-woocommerce'),
        __('Başkale', 'states-cities-and-places-for-woocommerce'),
        __('Çaldıran', 'states-cities-and-places-for-woocommerce'),
        __('Çatak', 'states-cities-and-places-for-woocommerce'),
        __('Edremit', 'states-cities-and-places-for-woocommerce'),
        __('Erciş', 'states-cities-and-places-for-woocommerce'),
        __('Gevaş', 'states-cities-and-places-for-woocommerce'),
        __('Gürpınar', 'states-cities-and-places-for-woocommerce'),
        __('İpekyolu', 'states-cities-and-places-for-woocommerce'),
        __('Muradiye', 'states-cities-and-places-for-woocommerce'),
        __('Özalp', 'states-cities-and-places-for-woocommerce'),
        __('Saray', 'states-cities-and-places-for-woocommerce'),
        __('Tuşba', 'states-cities-and-places-for-woocommerce'),
    ),
    // Yalova
    'YAL' => array(
        __('Altınova', 'states-cities-and-places-for-woocommerce'),
        __('Armutlu', 'states-cities-and-places-for-woocommerce'),
        __('Çınarcık', 'states-cities-and-places-for-woocommerce'),
        __('Çiftlikköy', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Termal', 'states-cities-and-places-for-woocommerce'),
    ),
    // Yozgat
    'YOZ' => array(
        __('Akdağmadeni', 'states-cities-and-places-for-woocommerce'),
        __('Aydıncık', 'states-cities-and-places-for-woocommerce'),
        __('Boğazlıyan', 'states-cities-and-places-for-woocommerce'),
        __('Çandır', 'states-cities-and-places-for-woocommerce'),
        __('Çayıralan', 'states-cities-and-places-for-woocommerce'),
        __('Çekerek', 'states-cities-and-places-for-woocommerce'),
        __('Kadışehri', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
        __('Saraykent', 'states-cities-and-places-for-woocommerce'),
        __('Sarıkaya', 'states-cities-and-places-for-woocommerce'),
        __('Sorgun', 'states-cities-and-places-for-woocommerce'),
        __('Şefaatli', 'states-cities-and-places-for-woocommerce'),
        __('Yenifakılı', 'states-cities-and-places-for-woocommerce'),
        __('Yerköy', 'states-cities-and-places-for-woocommerce'),
    ),
    // Zonguldak
    'ZON' => array(
        __('Alaplı', 'states-cities-and-places-for-woocommerce'),
        __('Çaycuma', 'states-cities-and-places-for-woocommerce'),
        __('Devrek', 'states-cities-and-places-for-woocommerce'),
        __('Ereğli', 'states-cities-and-places-for-woocommerce'),
        __('Gökçebey', 'states-cities-and-places-for-woocommerce'),
        __('Kilimli', 'states-cities-and-places-for-woocommerce'),
        __('Kozlu', 'states-cities-and-places-for-woocommerce'),
        __('Merkez', 'states-cities-and-places-for-woocommerce'),
    ),
);

// Use this filter to handle the Districts of Turkey
$places['TR'] = apply_filters('scpwoo_custom_places_tr', $places['TR']);
