<?php

/**
 * Municipalities of El Salvador
 * - 262 municipalities
 *
 * Source:
 * - https://en.wikipedia.org/wiki/List_of_municipalities_of_El_Salvador
 *
 * @author  Guillermo Contreras <guillermojcontreras@gmail.com> | https://binario.com.sv
 * @version 1.0.0
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */

global $places;

$places['SV'] = array(
	'SV-AH' => array(
		'Ahuachapán',
		'Apaneca',
		'Atiquizaya',
		'Concepción de Ataco',
		'El Refugio',
		'Guaymango',
		'Jujutla',
		'San Francisco Menéndez',
		'San Lorenzo',
		'San Pedro Puxtla',
		'Tacuba',
		'Turín',
	),
	'SV-CA' => array(
		'Cinquera',
		'Dolores',
		'Guacotecti',
		'Ilobasco',
		'Jutiapa',
		'San Isidro',
		'Sensuntepeque',
		'Tejutepeque',
		'Victoria',
	),
	'SV-CH' => array(
		'Agua Caliente',
		'Arcatao',
		'Azacualpa',
		'Chalatenango',
		'Citalá',
		'Comalapa',
		'Concepción Quezaltepeque',
		'Dulce Nombre de María',
		'El Carrizal',
		'El Paraíso',
		'La Laguna',
		'La Palma',
		'La Reina',
		'Las Vueltas',
		'Nombre de Jesús',
		'Nueva Concepción',
		'Nueva Trinidad',
		'Ojos de Agua',
		'Potonico',
		'San Antonio de la Cruz (San Antonio La Cruz)',
		'San Antonio Los Ranchos (San Antonio Ranchos)',
		'San Fernando',
		'San Francisco Lempa',
		'San Francisco Morazán',
		'San Ignacio',
		'San Isidro Labrador',
		'San José Cancasque',
		'San José Las Flores',
		'San Luis del Carmen',
		'San Miguel de Mercedes',
		'San Rafael',
		'Santa Rita',
		'Tejutla',
	),
	'SV-CU' => array(
		'Candelaria',
		'Cojutepeque',
		'El Carmen',
		'El Rosario',
		'Monte San Juan',
		'Oratorio de Concepción',
		'San Bartolomé Perulapía',
		'San Cristóbal',
		'San José Guayabal',
		'San Pedro Perulapán',
		'San Rafael Cedros',
		'San Ramón',
		'Santa Cruz Analquito',
		'Santa Cruz Michapa',
		'Suchitoto',
		'Tenancingo',
	),
	'SV-LI' => array(
		'Antiguo Cuscatlán',
		'Chiltiupán',
		'Ciudad Arce',
		'Colón',
		'Comasagua',
		'Huizúcar',
		'Jayaque',
		'Jicalapa',
		'La Libertad',
		'Nuevo Cuscatlán',
		'Opico',
		'Quezaltepeque',
		'Sacacoyo',
		'San José Villanueva',
		'San Matías',
		'San Pablo Tacachico',
		'Santa Tecla',
		'Talnique',
		'Tamanique',
		'Teotepeque',
		'Tepecoyo',
		'Zaragoza',
	),
	'SV-PA' => array(
		'Cuyultitán',
		'El Rosario',
		'Jerusalén',
		'Mercedes La Ceiba',
		'Olocuilta',
		'Paraíso de Osorio',
		'San Antonio Masahuat',
		'San Emigdio',
		'San Francisco Chinameca',
		'San Juan Nonualco',
		'San Juan Talpa',
		'San Juan Tepezontes',
		'San Luis La Herradura',
		'San Luis Talpa',
		'San Miguel Tepezontes',
		'San Pedro Masahuat',
		'San Pedro Nonualco',
		'San Rafael Obrajuelo',
		'Santa María Ostuma',
		'Santiago Nonualco',
		'Tapalhuaca',
		'Zacatecoluca',
	),
	'SV-UN' => array(
		'Anamorós',
		'Bolívar',
		'Concepción de Oriente',
		'Conchagua',
		'El Carmen',
		'El Sauce',
		'Intipucá',
		'La Unión',
		'Lislique',
		'Meanguera del Golfo',
		'Nueva Esparta',
		'Pasaquina',
		'Polorós',
		'San Alejo',
		'San José',
		'Santa Rosa de Lima',
		'Yayantique',
		'Yucuaiquín',
	),
	'SV-MO' => array(
		'Arambala',
		'Cacaopera',
		'Chilanga',
		'Corinto',
		'Delicias de Concepción',
		'El Divisadero',
		'El Rosario',
		'Gualococti',
		'Guatajiagua',
		'Joateca',
		'Jocoaitique',
		'Jocoro',
		'Lolotiquillo',
		'Meanguera',
		'Osicala',
		'Perquín',
		'San Carlos',
		'San Fernando',
		'San Francisco Gotera',
		'San Isidro',
		'San Simón',
		'Sensembra',
		'Sociedad',
		'Torola',
		'Yamabal',
		'Yoloaiquín',
	),
	'SV-SM' => array(
		'Carolina',
		'Chapeltique',
		'Chinameca',
		'Chirilagua',
		'Ciudad Barrios',
		'Comacarán',
		'El Tránsito',
		'Lolotique',
		'Moncagua',
		'Nueva Guadalupe',
		'Nuevo Edén de San Juan',
		'Quelepa',
		'San Antonio',
		'San Gerardo',
		'San Jorge',
		'San Luis de la Reina',
		'San Miguel',
		'San Rafael (San Rafael Oriente)',
		'Sesori',
		'Uluazapa',
	),
	'SV-SS' => array(
		'Aguilares',
		'Apopa',
		'Ayutuxtepeque',
		'Cuscatancingo',
		'Delgado',
		'El Paisnal',
		'Guazapa',
		'Ilopango',
		'Mejicanos',
		'Nejapa',
		'Panchimalco',
		'Rosario de Mora',
		'San Marcos',
		'San Martín',
		'San Salvador',
		'Santiago Texacuangos',
		'Santo Tomás',
		'Soyapango',
		'Tonacatepeque',
	),
	'SV-SV' => array(
		'Apastepeque',
		'Guadalupe',
		'San Cayetano Istepeque',
		'San Esteban Catarina',
		'San Ildefonso',
		'San Lorenzo',
		'San Sebastián',
		'San Vicente',
		'Santa Clara',
		'Santo Domingo',
		'Tecoluca',
		'Tepetitán',
		'Verapaz',
	),
	'SV-SA' => array(
		'Candelaria de la Frontera',
		'Chalchuapa',
		'Coatepeque',
		'El Congo',
		'El Porvenir',
		'Masahuat',
		'Metapán',
		'San Antonio Pajonal',
		'San Sebastián Salitrillo',
		'Santa Ana',
		'Santa Rosa Guachipilín',
		'Santiago de la Frontera',
		'Texistepeque',
	),
	'SV-SO' => array(
		'Acajutla',
		'Armenia',
		'Caluco',
		'Cuisnahuat',
		'Izalco',
		'Juayúa',
		'Nahuizalco',
		'Nahulingo',
		'Salcoatitán',
		'San Antonio del Monte',
		'San Julián',
		'Santa Catarina Masahuat',
		'Santa Isabel Ishuatán',
		'Santo Domingo',
		'Sonsonate',
		'Sonzacate',
	),
	'SV-US' => array(
		'Alegría',
		'Berlín',
		'California',
		'Concepción Batres',
		'El Triunfo',
		'Ereguayquín',
		'Estanzuelas',
		'Jiquilisco',
		'Jucuapa',
		'Jucuarán',
		'Mercedes Umaña',
		'Nueva Granada',
		'Ozatlán',
		'Puerto El Triunfo',
		'San Agustín',
		'San Buenaventura',
		'San Dionisio',
		'San Francisco Javier',
		'Santa Elena',
		'Santa María',
		'Santiago de María',
		'Tecapán',
		'Usulután',
	),
);

// Use this filter to handle the Municipalities of San Salvador
$places['SV'] = apply_filters('scpwoo_custom_places_sv', $places['SV']);
