<?php

/**
 * Governorates of Saudi Arabia
 * - 118 governorates
 * 
 * Source: 
 * - https://en.wikipedia.org/wiki/List_of_governorates_of_Saudi_Arabia
 * - https://www.citypopulation.de/en/saudiarabia/
 * 
 * @author  Yordan Soares <contacto@yordansoar.es> | https://yordansoar.es/
 * @version 1.0.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 */

global $places;

$places['SA'] = array(
  // Riyadh Region
  'SA-01' => array(
    _x('Afif', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Aflaj', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Hariq', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Majma\'ah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Zulfi', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al-Ghat', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al-Kharj', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al-Muzahmiyya', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al-Quway\'iyah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('As Sulayyil', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Dawadmi', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Dhurma', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Diriyah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Hotat Bani Tamim', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Huraymila', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Riyadh', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Rumah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Shuqrah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Thadig', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Wadi ad-Dawasir', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
  ),
  // Makkah Region
  'SA-02' => array(
    _x('Al Jumum', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Kamil', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Khurmah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Lith', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Qunfudhah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Jeddah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Khulays', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Mecca', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Rabigh', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Ranyah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Ta\'if', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Turubah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
  ),
  // Al Madinah Region
  'SA-03' => array(
    _x('Al Hinakiyah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al-ʿUla', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Badr', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Khaybar', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Mahd adh Dhahab', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Medina', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Yanbu', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
  ),
  // Eastern Province Region
  'SA-04' => array(
    _x('Abqaiq', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Ahsa', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Nairyah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Dammam', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Hafar Al-Batin', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Jubail', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Khafji', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Khobar', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Qaryat al-Ulya', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Qatif', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Ras Tanura', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
  ),
  // Al-Qassim Region
  'SA-05' => array(
    _x('Al Badayea', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Bukayriyah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Mithnab', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Nabhaniyah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Shimasiyah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Ar Rass', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Asyah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Buraidah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Riyadh Al Khabra', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Unaizah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Uyun AlJiwa', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
  ),
  // Ha\'il Region
  'SA-06' => array(
    _x('Al Khazaiah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Shinan', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Baqaa', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Ha\'il', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
  ),
  // Tabuk Region
  'SA-07' => array(
    _x('Al Wajh', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Duba', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Haql', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Tabuk', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Tayma', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Umluj', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
  ),
  // Northern Borders Region
  'SA-08' => array(
    _x('Arar', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Rafha', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Turaif', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
  ),
  // Jazan Region
  'SA-09' => array(
    _x('Abu `Arish', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Ahad al Masarihah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Aridhah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Darb', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Dayer', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Edabi', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Harth', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Reeth', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Baish', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Damad', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Farasan', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Jizan', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Sabya', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Samtah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
  ),
  // Najran Region
  'SA-10' => array(
    _x('Al Kharkhir', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Badr Al Janub', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Hubuna', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Khubash', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Najran', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Sharurah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Thar', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Yadamah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
  ),
  // Al-Bahah Region
  'SA-11' => array(
    _x('Al Aqiq', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Bahah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Makhwah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Mandaq', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Qara', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Baljurashi', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Qilwah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
  ),
  // Al-Jawf Region
  'SA-12' => array(
    _x('Dumat al-Jandal', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Qurayyat', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Sakakah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
  ),
  // \'Asir Region
  'SA-14' => array(
    _x('Abha', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Ahad Rafidah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al Majaridah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Al-Namas', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Balqarn', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Bisha', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Dhahran Al Janub', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Khamis Mushait', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Muhayil', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Rojal', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Sarat Abidah', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
    _x('Tathlith', 'Governorates of Saudi Arabia', 'states-cities-and-places-for-woocommerce'),
  ),
);

// Use this filter to handle the Governorates of Saudi Arabia
$places['SA'] = apply_filters('scpwoo_custom_places_sa', $places['SA']);
