<?php

/**
 * Districts of Paraguay
 * - 1 capital district
 * - 257 districts
 *
 * Sources:
 * https://en.wikipedia.org/wiki/Districts_of_Paraguay
 * https://es.wikipedia.org/wiki/Anexo:Municipios_de_Paraguay
 * 
 * @author  Yordan Soares <contacto@yordansoar.es> - https://yordansoar.es/
 * @version 1.0.0
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */
global $places;
$places['PY'] = array(
	// Asunción
	'PY-1' => array(
		'Asunción'
	),
	// Alto Paraguay
	'PY-2' => array(
		'Bahía Negra',
		'Capitán Carmelo Peralta',
		'Puerto Casado',
		'Fuerte Olimpo'
	),
	// Alto Paraná
	'PY-3' => array(
		'Ciudad del Este',
		'Doctor Juan León Mallorquín',
		'Doctor Raúl Peña',
		'Domingo Martínez de Irala',
		'Hernandarias',
		'Iruña',
		'Itakyry',
		'Juan Emilio O\'Leary',
		'Los Cedrales',
		'Mbaracayú',
		'Minga Guazú',
		'Minga Porá',
		'Naranjal',
		'Ñacunday',
		'Presidente Franco',
		'San Alberto',
		'San Cristóbal',
		'Santa Fe del Paraná',
		'Santa Rita',
		'Santa Rosa del Monday',
		'Tavapy',
		'Yguazú'
	),
	// Amambay
	'PY-4' => array(
		'Bella Vista',
		'Capitán Bado',
		'Cerro Corá',
		'Karapaí',
		'Pedro Juan Caballero',
		'Zanja Pytá',
	),
	// Boquerón
	'PY-5' => array(
		'Filadelfia',
		'Loma Plata',
		'Mariscal Estigarribia',
	),
	// Caaguazú
	'PY-6' => array(
		'Caaguazú',
		'Carayaó',
		'Coronel Oviedo',
		'Doctor Cecilio Báez',
		'Doctor J. Eulogio Estigarribia',
		'Doctor Juan Manuel Frutos',
		'José Domingo Ocampos',
		'La Pastora',
		'Mcal. Francisco S. López',
		'Nueva Londres',
		'Nueva Toledo',
		'Raúl Arsenio Oviedo',
		'Repatriación',
		'R. I. Tres Corrales',
		'San Joaquín',
		'San José de los Arroyos',
		'Santa Rosa del Mbutuy',
		'Simón Bolívar',
		'Tembiaporá',
		'Tres de Febrero',
		'Vaquería',
		'Yhú',
	),
	// Caazapá
	'PY-7' => array(
		'Tres de Mayo',
		'Abaí',
		'Buena Vista',
		'Caazapá',
		'Doctor Moisés S. Bertoni',
		'Fulgencio Yegros',
		'General Higinio Morínigo',
		'Maciel',
		'San Juan Nepomuceno',
		'Tavaí',
		'Yuty',
	),
	// Canindeyú
	'PY-8' => array(
		'Corpus Christi',
		'Curuguaty',
		'Gral. Francisco Caballero Álvarez',
		'Itanará',
		'Katueté',
		'La Paloma',
		'Laurel',
		'Maracaná',
		'Nueva Esperanza',
		'Puerto Adela',
		'Salto del Guairá',
		'Villa Ygatimí',
		'Yasy Cañy',
		'Ybyrarovaná',
		'Ypejhú',
		'Yby Pytá',
	),
	// Central
	'PY-9' => array(
		'Areguá',
		'Capiatá',
		'Fernando de la Mora',
		'Guarambaré',
		'Itá',
		'Itauguá',
		'Julián Augusto Saldívar',
		'Lambaré',
		'Limpio',
		'Luque',
		'Mariano Roque Alonso',
		'Ñemby',
		'Nueva Italia',
		'San Antonio',
		'San Lorenzo',
		'Villa Elisa',
		'Villeta',
		'Ypacaraí',
		'Ypané',
	),
	// Concepción
	'PY-10' => array(
		'Arroyito',
		'Azotey',
		'Belén',
		'Concepción',
		'Horqueta',
		'Loreto',
		'Paso Horqueta',
		'San Carlos del Apa',
		'San Lázaro',
		'Yby Yaú',
		'Sargento José Félix López',
		'San Alfredo',
	),
	// Cordillera
	'PY-11' => array(
		'Altos',
		'Arroyos y Esteros',
		'Atyrá',
		'Caacupé',
		'Caraguatay',
		'Emboscada',
		'Eusebio Ayala',
		'Isla Pucú',
		'Itacurubí de la Cordillera',
		'Juan de Mena',
		'Loma Grande',
		'Mbocayaty del Yhaguy',
		'Nueva Colombia',
		'Piribebuy',
		'Primero de Marzo',
		'San Bernardino',
		'San José Obrero',
		'Santa Elena',
		'Tobatí',
		'Valenzuela',
	),
	// Guairá
	'PY-12' => array(
		'Borja',
		'Coronel Martínez',
		'Dr. Bottrell',
		'Fassardi',
		'Félix Pérez Cardozo',
		'Garay',
		'Colonia Independencia',
		'Itapé',
		'Iturbe',
		'Mbocayaty',
		'Natalicio Talavera',
		'Ñumí',
		'Paso Yobái',
		'San Salvador',
		'Tebicuary',
		'Troche',
		'Villarrica',
		'Yataity',
	),
	// Itapúa
	'PY-13' => array(
		'Alto Verá',
		'Bella Vista',
		'Cambyretá',
		'Capitán Meza',
		'Capitán Miranda',
		'Carlos Antonio López',
		'Carmen del Paraná',
		'Coronel Bogado',
		'Edelira',
		'Encarnación',
		'Fram',
		'General Artigas',
		'General Delgado',
		'Hohenau',
		'Itapúa Poty',
		'Jesús',
		'La Paz',
		'José Leandro Oviedo',
		'Mayor Otaño',
		'Natalio',
		'Nueva Alborada',
		'Obligado',
		'Pirapó',
		'San Cosme y Damián',
		'San Juan del Paraná',
		'San Pedro del Paraná',
		'San Rafael del Paraná',
		'Tomás Romero Pereira',
		'Trinidad',
		'Yatytay',
	),
	// Misiones
	'PY-14' => array(
		'Ayolas',
		'San Ignacio',
		'San Juan Bautista.',
		'San Miguel',
		'San Patricio',
		'Santa María',
		'Santa Rosa',
		'Santiago',
		'Villa Florida',
		'Yabebyry',
	),
	// Ñeembucú
	'PY-15' => array(
		'Alberdi',
		'Cerrito',
		'Desmochados',
		'General José Eduvigis Díaz',
		'Guazú Cuá',
		'Humaitá',
		'Isla Umbú',
		'Laureles',
		'Mayor José J. Martínez',
		'Paso de Patria',
		'Pilar',
		'San Juan Bautista del Ñeembucú',
		'Tacuaras',
		'Villa Franca',
		'Villalbín',
		'Villa Oliva',
	),
	// Paraguarí
	'PY-16' => array(
		'Acahay',
		'Caapucú',
		'Carapeguá',
		'Escobar',
		'Gral. Bernardino Caballero',
		'La Colmena',
		'María Antonia',
		'Mbuyapey',
		'Paraguarí',
		'Pirayú',
		'Quiindy',
		'Quyquyhó',
		'San Roque González de Santa Cruz',
		'Sapucai',
		'Tebicuarymí',
		'Yaguarón',
		'Ybycuí',
		'Ybytymí',
	),
	// Presidente Hayes
	'PY-17' => array(
		'Benjamín Aceval',
		'Campo Aceval',
		'Doctor José Falcón',
		'General José María Bruguez',
		'Nanawa',
		'Puerto Pinasco',
		'Teniente Irala Fernández',
		'Teniente Esteban Martínez',
		'Villa Hayes',
	),
	// San Pedro
	'PY-18' => array(
		'Antequera',
		'Capiibary',
		'Choré',
		'General Elizardo Aquino',
		'General Isidoro Resquín',
		'Guayaibí',
		'Itacurubí del Rosario',
		'Liberación',
		'Lima',
		'Nueva Germania',
		'San Estanislao',
		'San Pablo',
		'San Pedro del Ycuamandiyú',
		'San Vicente Pancholo',
		'Santa Rosa del Aguaray',
		'Tacuatí',
		'Unión',
		'Veinticinco de Diciembre',
		'Villa del Rosario',
		'Yataity del Norte',
		'Yrybucuá',
	),
);

// Use this filter to handle the Districts of Paraguay
$places['PY'] = apply_filters('scpwoo_custom_places_py', $places['PY']);
