<?php

/**
 * Districs and Corregimientos of Panama
 * - 81 Districts
 * - 679 Corregimientos
 * 
 * Sources:
 * https://es.wikipedia.org/wiki/Anexo:Distritos_de_Panam%C3%A1
 * https://es.wikipedia.org/wiki/Anexo:Corregimientos_de_Panam%C3%A1
 * 
 * @author  Yordan Soares <contacto@yordansoar.es> | https://yordansoar.es
 * @version 1.0.0
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */

global $places;

$places['PA'] = array(
  'PAN-1' => array(
    'Almirante - Almirante',
    'Almirante - Barriada Guaymí',
    'Almirante - Barrio Francés',
    'Almirante - Nance de Riscó',
    'Almirante - Valle de Aguas Arriba',
    'Almirante - Valle de Riscó',
    'Bocas del Toro - Bastimentos',
    'Bocas del Toro - Bocas del Toro',
    'Bocas del Toro - Cauchero',
    'Bocas del Toro - Punta Laurel',
    'Bocas del Toro - Tierra Oscura',
    'Changuinola - Changuinola',
    'Changuinola - Cochigro',
    'Changuinola - El Empalme',
    'Changuinola - Guabito',
    'Changuinola - La Gloria',
    'Changuinola - Las Delicias',
    'Changuinola - Las Tablas',
    'Changuinola - Barriada 4 de Abril',
    'Changuinola - El Teribe',
    'Changuinola - Finca 30',
    'Changuinola - Finca 60',
    'Changuinola - Finca 6',
    'Changuinola - El Silencio',
    'Chiriquí Grande - Bajo Cedro',
    'Chiriquí Grande - Chiriquí Grande',
    'Chiriquí Grande - Miramar',
    'Chiriquí Grande - Punta Peña',
    'Chiriquí Grande - Punta Robalo',
    'Chiriquí Grande - Rambala'
  ),
  'PAN-2' => array(
    'Aguadulce - Aguadulce',
    'Aguadulce - Barrios Unidos',
    'Aguadulce - El Cristo',
    'Aguadulce - El Roble',
    'Aguadulce - El Hato de San Juan de Dios',
    'Aguadulce - Pocrí',
    'Aguadulce - Pueblos Unidos',
    'Aguadulce - Virgen del Carmen',
    'Antón - Antón',
    'Antón - Caballero',
    'Antón - Cabuya',
    'Antón - El Chirú',
    'Antón - El Retiro',
    'Antón - El Valle',
    'Antón - Juan Díaz',
    'Antón - Río Hato',
    'Antón - San Juan de Dios',
    'Antón - Santa Rita',
    'La Pintada - El Harino',
    'La Pintada - El Potrero',
    'La Pintada - La Pintada',
    'La Pintada - Las Lomas',
    'La Pintada - Llano Grande',
    'La Pintada - Piedras Gordas',
    'La Pintada - Llano Norte',
    'Natá - Capellanía',
    'Natá - El Caño',
    'Natá - Guzmán',
    'Natá - Las Huacas',
    'Natá - Natá',
    'Natá - Toza',
    'Natá - Villarreal',
    'Olá - El Copé',
    'Olá - El Palmar',
    'Olá - El Picacho',
    'Olá - La Pava',
    'Olá - Olá',
    'Penonomé - Cañaveral',
    'Penonomé - Coclé',
    'Penonomé - Chiguirí Arriba',
    'Penonomé - El Coco',
    'Penonomé - Pajonal',
    'Penonomé - Penonomé',
    'Penonomé - Río Grande',
    'Penonomé - Río Indio',
    'Penonomé - Toabré',
    'Penonomé - Tulú'
  ),
  'PAN-3' => array(
    'Colón - Barrio Norte',
    'Colón - Barrio Sur',
    'Colón - Buena Vista',
    'Colón - Cativá',
    'Colón - Ciricito',
    'Colón - Cristóbal',
    'Colón - Cristobal Este',
    'Colón - Escobal',
    'Colón - Limón',
    'Colón - Nueva Providencia',
    'Colón - Puerto Pilón',
    'Colón - Sabanitas',
    'Colón - Salamanca',
    'Colón - San Juan',
    'Colón - Santa Rosa',
    'Chagres - Achiote',
    'Chagres - El Guabo',
    'Chagres - La Encantada',
    'Chagres - Nuevo Chagres',
    'Chagres - Palmas Bellas',
    'Chagres - Piña',
    'Chagres - Salud',
    'Donoso - Coclé del Norte',
    'Donoso - El Guásimo',
    'Donoso - Gobea',
    'Donoso - Miguel de la Borda',
    'Donoso - Río Indio',
    'Portobelo - Cacique',
    'Portobelo - Garrote',
    'Portobelo - Isla Grande',
    'Portobelo - María Chiquita',
    'Portobelo - Portobelo',
    'Santa Isabel - Cuango',
    'Santa Isabel - Miramar',
    'Santa Isabel - Nombre de Dios',
    'Santa Isabel - Palenque',
    'Santa Isabel - Palmira',
    'Santa Isabel - Playa Chiquita',
    'Santa Isabel - Santa Isabel',
    'Santa Isabel - Viento Frío',
    'Omar Torrijos Herrera - San José del General',
    'Omar Torrijos Herrera - San Juan de Turbe',
    'Omar Torrijos Herrera - Nueva Esperanza'
  ),
  'PAN-4' => array(
    'Alanje - Alanje',
    'Alanje - Divalá',
    'Alanje - Canta Gallo',
    'Alanje - El Tejar',
    'Alanje - Guarumal',
    'Alanje - Nuevo México',
    'Alanje - Querévalo',
    'Alanje - Palo Grande',
    'Alanje - Santo Tomás',
    'Barú - Baco',
    'Barú - Limones',
    'Barú - Progreso',
    'Barú - Puerto Armuelles',
    'Barú - Rodolfo Aguilar Delgado',
    'Boquerón - Bágala',
    'Boquerón - Boquerón',
    'Boquerón - Cordillera',
    'Boquerón - Guabal',
    'Boquerón - Guayabal',
    'Boquerón - Paraíso',
    'Boquerón - Pedregal',
    'Boquerón - Tijeras',
    'Boquete - Alto Boquete',
    'Boquete - Bajo Boquete',
    'Boquete - Caldera',
    'Boquete - Jaramillo',
    'Boquete - Los Naranjos',
    'Boquete - Palmira',
    'Bugaba - Aserrío de Gariché',
    'Bugaba - Bugaba',
    'Bugaba - El Bongo',
    'Bugaba - Gómez',
    'Bugaba - La Concepción',
    'Bugaba - La Estrella',
    'Bugaba - San Andrés',
    'Bugaba - Santa Marta',
    'Bugaba - Santa Rosa',
    'Bugaba - Santo Domingo',
    'Bugaba - Sortová',
    'Bugaba - Solano',
    'Bugaba - San Isidro',
    'David - Bijagual',
    'David - Cochea',
    'David - Chiriquí',
    'David - Guacá',
    'David - Las Lomas',
    'David - Pedregal',
    'David - San Carlos',
    'David - David',
    'David - David Este',
    'David - David Sur',
    'David - San Pablo Nuevo',
    'David - San Pablo Viejo',
    'Dolega - Dolega',
    'Dolega - Dos Ríos',
    'Dolega - Los Algarrobos',
    'Dolega - Los Anastacios',
    'Dolega - Potrerillos',
    'Dolega - Potrerillos Abajo',
    'Dolega - Rovira',
    'Dolega - Tinajas',
    'Gualaca - Gualaca',
    'Gualaca - Hornito',
    'Gualaca - Los Angeles',
    'Gualaca - Paja de Sombrero',
    'Gualaca - Rincón',
    'Remedios - El Nancito',
    'Remedios - El Porvenir',
    'Remedios - El Puerto',
    'Remedios - Remedios',
    'Remedios - Santa Lucía',
    'Renacimiento - Breñón',
    'Renacimiento - Cañas Gordas',
    'Renacimiento - Dominical',
    'Renacimiento - Monte Lirio',
    'Renacimiento - Plaza de Caisán',
    'Renacimiento - Río Sereno',
    'Renacimiento - Santa Cruz',
    'Renacimiento - Santa Clara',
    'San Félix - Las Lajas',
    'San Félix - Lajas Adentro',
    'San Félix - Juay',
    'San Félix - San Félix',
    'San Félix - Santa Cruz',
    'San Lorenzo - Boca Chica',
    'San Lorenzo - Boca del Monte',
    'San Lorenzo - Horconcitos',
    'San Lorenzo - San Juan',
    'San Lorenzo - San Lorenzo',
    'Tierras Altas - Volcán',
    'Tierras Altas - Cerro Punta',
    'Tierras Altas - Cuesta de Piedra',
    'Tierras Altas - Nueva California',
    'Tierras Altas - Paso Ancho',
    'Tolé - Bella Vista',
    'Tolé - Cerro Viejo',
    'Tolé - El Cristo',
    'Tolé - Justo Fidel Palacios',
    'Tolé - Lajas de Tolé',
    'Tolé - Potrero de Caña',
    'Tolé - Quebrada de Piedra',
    'Tolé - Tolé',
    'Tolé - Veladero'
  ),
  'PAN-5' => array(
    'Chepigana - Camogantí',
    'Chepigana - Chepigana',
    'Chepigana - Garachiné',
    'Chepigana - Jaqué',
    'Chepigana - La Palma',
    'Chepigana - Puerto Piña',
    'Chepigana - Sambú',
    'Chepigana - Setegantí',
    'Chepigana - Taimatí',
    'Chepigana - Tucutí',
    'Pinogana - Boca de Cupe',
    'Pinogana - El Real de Santa María',
    'Pinogana - Metetí',
    'Pinogana - Paya',
    'Pinogana - Pinogana',
    'Pinogana - Púcuro',
    'Pinogana - Yape',
    'Pinogana - Yaviza',
    'Pinogana - Wargandí',
    'Santa Fe - Agua Fría',
    'Santa Fe - Cucunatí',
    'Santa Fe - Río Congo',
    'Santa Fe - Río Congo Arriba',
    'Santa Fe - Río Iglesias',
    'Santa Fe - Santa Fe',
    'Santa Fe - Zapallal'
  ),
  'PAN-6' => array(
    'Chitré - Chitré',
    'Chitré - La Arena',
    'Chitré - Llano Bonito',
    'Chitré - San Juan Bautista',
    'Chitré - Monagrillo',
    'Las Minas - Chepo',
    'Las Minas - Chumical',
    'Las Minas - El Toro',
    'Las Minas - Las Minas',
    'Las Minas - Leones',
    'Las Minas - Quebrada del Rosario',
    'Las Minas - Quebrada El Ciprián',
    'Los Pozos - El Capurí',
    'Los Pozos - El Calabacito',
    'Los Pozos - El Cedro',
    'Los Pozos - La Arena',
    'Los Pozos - La Pitaloza',
    'Los Pozos - Las Llanas',
    'Los Pozos - Los Cerritos',
    'Los Pozos - Los Cerros de Paja',
    'Los Pozos - Los Pozos',
    'Ocú - Cerro Largo',
    'Ocú - El Tijera',
    'Ocú - Entradero del Castillo',
    'Ocú - Los Llanos',
    'Ocú - Llano Grande',
    'Ocú - Menchaca',
    'Ocú - Peñas Chatas',
    'Ocú - Ocú',
    'Parita - Cabuya',
    'Parita - Los Castillos',
    'Parita - Llano de la Cruz',
    'Parita - París',
    'Parita - Parita',
    'Parita - Portobelillo',
    'Parita - Potuga',
    'Pesé - El Barrero',
    'Pesé - El Pedregoso',
    'Pesé - El Ciruelo',
    'Pesé - El Pájaro',
    'Pesé - Las Cabras',
    'Pesé - Pesé',
    'Pesé - Rincón Hondo',
    'Pesé - Sabanagrande',
    'Santa María - Chupampa',
    'Santa María - El Rincón',
    'Santa María - El Limón',
    'Santa María - Los Canelos',
    'Santa María - Santa María'
  ),
  'PAN-7' => array(
    'Guararé - El Espinal',
    'Guararé - El Hato',
    'Guararé - El Macano',
    'Guararé - Guararé',
    'Guararé - Guararé Arriba',
    'Guararé - La Enea',
    'Guararé - La Pasera',
    'Guararé - Las Trancas',
    'Guararé - Llano Abajo',
    'Guararé - Perales',
    'Las Tablas - Bajo Corral',
    'Las Tablas - Bayano',
    'Las Tablas - El Carate',
    'Las Tablas - El Cocal',
    'Las Tablas - El Manantial',
    'Las Tablas - El Muñoz',
    'Las Tablas - El Pedregoso',
    'Las Tablas - El Sesteadero',
    'Las Tablas - La Laja',
    'Las Tablas - La Miel',
    'Las Tablas - La Palma',
    'Las Tablas - La Tiza',
    'Las Tablas - Las Palmitas',
    'Las Tablas - Las Tablas Abajo',
    'Las Tablas - Nuario',
    'Las Tablas - Palmira',
    'Las Tablas - Peña Blanca',
    'Las Tablas - Río Hondo',
    'Las Tablas - San José',
    'Las Tablas - San Miguel',
    'Las Tablas - Las Tablas',
    'Las Tablas - Santo Domingo',
    'Las Tablas - Valle Rico',
    'Las Tablas - Vallerriquito',
    'Los Santos - El Ejido',
    'Los Santos - El Guásimo',
    'Los Santos - La Colorada',
    'Los Santos - La Espigadilla',
    'Los Santos - La Villa de Los Santos',
    'Los Santos - Las Cruces',
    'Los Santos - Las Guabas',
    'Los Santos - Los Ángeles',
    'Los Santos - Los Olivos',
    'Los Santos - Llano Largo',
    'Los Santos - Sabanagrande',
    'Los Santos - Santa Ana',
    'Los Santos - Tres Quebradas',
    'Los Santos - Villa Lourdes',
    'Los Santos - Agua Buena',
    'Macaracas - Bahía Honda',
    'Macaracas - Bajos de Güera',
    'Macaracas - Corozal',
    'Macaracas - Chupá',
    'Macaracas - El Cedro',
    'Macaracas - Espino Amarillo',
    'Macaracas - La Mesa',
    'Macaracas - Las Palmas',
    'Macaracas - Llano de Piedras',
    'Macaracas - Macaracas',
    'Macaracas - Mogollón',
    'Pedasí - Los Asientos',
    'Pedasí - Mariabé',
    'Pedasí - Oria Arriba',
    'Pedasí - Pedasí',
    'Pedasí - Purio',
    'Pocrí - El Cañafístulo',
    'Pocrí - Lajamina',
    'Pocrí - Paraíso',
    'Pocrí - Paritilla',
    'Pocrí - Pocrí',
    'Tonosí - Altos de Güera',
    'Tonosí - Cambutal',
    'Tonosí - Cañas',
    'Tonosí - El Bebedero',
    'Tonosí - El Cacao',
    'Tonosí - El Cortezo',
    'Tonosí - Flores',
    'Tonosí - Guánico',
    'Tonosí - Isla de Cañas',
    'Tonosí - La Tronosa',
    'Tonosí - Tonosí'
  ),
  'PAN-8' => array(
    'Balboa - La Ensenada',
    'Balboa - La Esmeralda',
    'Balboa - La Guinea',
    'Balboa - Pedro González',
    'Balboa - Saboga',
    'Balboa - San Miguel',
    'Chepo - Cañita',
    'Chepo - Chepillo',
    'Chepo - El Llano',
    'Chepo - Las Margaritas',
    'Chepo - Chepo',
    'Chepo - Santa Cruz de Chinina',
    'Chepo - Tortí',
    'Chepo - Madugandí',
    'Chimán - Brujas',
    'Chimán - Chimán',
    'Chimán - Gonzalo Vásquez',
    'Chimán - Pásiga',
    'Chimán - Unión Santeña',
    'Panamá - 24 de Diciembre',
    'Panamá - Alcalde Díaz',
    'Panamá - Ancón',
    'Panamá - Betania',
    'Panamá - Bella Vista',
    'Panamá - Calidonia',
    'Panamá - Caimitillo',
    'Panamá - Chilibre',
    'Panamá - Curundú',
    'Panamá - Don Bosco',
    'Panamá - El Chorrillo',
    'Panamá - Ernesto Córdoba Campos',
    'Panamá - Juan Díaz',
    'Panamá - Las Cumbres',
    'Panamá - Las Garzas',
    'Panamá - Las Mañanitas',
    'Panamá - Pacora',
    'Panamá - Parque Lefevre',
    'Panamá - Pedregal',
    'Panamá - Pueblo Nuevo',
    'Panamá - Río Abajo',
    'Panamá - San Felipe',
    'Panamá - San Francisco',
    'Panamá - San Martín',
    'Panamá - Santa Ana',
    'Panamá - Tocumen',
    'San Miguelito - Amelia Denis de Icaza',
    'San Miguelito - Arnulfo Arias',
    'San Miguelito - Belisario Frías',
    'San Miguelito - Belisario Porras',
    'San Miguelito - José Domingo Espinar',
    'San Miguelito - Mateo Iturralde',
    'San Miguelito - Omar Torrijos',
    'San Miguelito - Rufina Alfaro',
    'San Miguelito - Victoriano Lorenzo',
    'Taboga - Otoque Occidente',
    'Taboga - Otoque Oriente',
    'Taboga - Taboga'
  ),
  'PAN-9' => array(
    'Arraiján - Arraiján',
    'Arraiján - Burunga',
    'Arraiján - Cerro Silvestre',
    'Arraiján - Juan Demóstenes Arosemena',
    'Arraiján - Nuevo Emperador',
    'Arraiján - Santa Clara',
    'Arraiján - Veracruz',
    'Arraiján - Vista Alegre',
    'Capira - Caimito',
    'Capira - Campana',
    'Capira - Capira',
    'Capira - Cermeño',
    'Capira - Cirí de Los Sotos',
    'Capira - Cirí Grande',
    'Capira - El Cacao',
    'Capira - La Trinidad',
    'Capira - Las Ollas Arriba',
    'Capira - Lídice',
    'Capira - Villa Carmen',
    'Capira - Villa Rosario',
    'Capira - Santa Rosa',
    'Chame - Bejuco',
    'Chame - Buenos Aires',
    'Chame - Cabuya',
    'Chame - Chame',
    'Chame - Chicá',
    'Chame - El Líbano',
    'Chame - Las Lajas',
    'Chame - Nueva Gorgona',
    'Chame - Punta Chame',
    'Chame - Sajalices',
    'Chame - Sorá',
    'La Chorrera - Amador',
    'La Chorrera - Arosemena',
    'La Chorrera - Barrio Balboa',
    'La Chorrera - Barrio Colón',
    'La Chorrera - El Arado',
    'La Chorrera - El Coco',
    'La Chorrera - Feuillet',
    'La Chorrera - Guadalupe',
    'La Chorrera - Herrera',
    'La Chorrera - Hurtado',
    'La Chorrera - Iturralde',
    'La Chorrera - La Represa',
    'La Chorrera - Los Díaz',
    'La Chorrera - Mendoza',
    'La Chorrera - Obaldía',
    'La Chorrera - Playa Leona',
    'La Chorrera - Puerto Caimito',
    'La Chorrera - Santa Rita',
    'San Carlos - El Espino',
    'San Carlos - El Higo',
    'San Carlos - Guayabito',
    'San Carlos - La Ermita',
    'San Carlos - La Laguna',
    'San Carlos - Las Uvas',
    'San Carlos - Los Llanitos',
    'San Carlos - San Carlos',
    'San Carlos - San José'
  ),
  'PAN-10' => array(
    'Atalaya - Atalaya',
    'Atalaya - El Barrito',
    'Atalaya - La Carrillo',
    'Atalaya - La Montañuela',
    'Atalaya - San Antonio',
    'Calobre - Barnizal',
    'Calobre - Calobre',
    'Calobre - Chitra',
    'Calobre - El Cocla',
    'Calobre - El Potrero',
    'Calobre - La Laguna',
    'Calobre - La Raya de Calobre',
    'Calobre - La Tetilla',
    'Calobre - La Yeguada',
    'Calobre - Las Guías',
    'Calobre - Monjarás',
    'Calobre - San José',
    'Cañazas - Cañazas',
    'Cañazas - Cerro de Plata',
    'Cañazas - El Aromillo',
    'Cañazas - El Picador',
    'Cañazas - Las Cruces',
    'Cañazas - Los Valles',
    'Cañazas - San José',
    'Cañazas - San Marcelo',
    'La Mesa - Bisvalles',
    'La Mesa - Boró',
    'La Mesa - El Higo',
    'La Mesa - La Mesa',
    'La Mesa - Los Milagros',
    'La Mesa - Llano Grande',
    'La Mesa - San Bartolo',
    'Las Palmas - Cerro de Casa',
    'Las Palmas - Corozal',
    'Las Palmas - El María',
    'Las Palmas - El Prado',
    'Las Palmas - El Rincón',
    'Las Palmas - Las Palmas',
    'Las Palmas - Lolá',
    'Las Palmas - Manuel E. Amador Terrero',
    'Las Palmas - Pixvae',
    'Las Palmas - Puerto Vidal',
    'Las Palmas - San Martín de Porres',
    'Las Palmas - Viguí',
    'Las Palmas - Zapotillo',
    'Mariato - Arenas',
    'Mariato - El Cacao',
    'Mariato - Mariato',
    'Mariato - Quebro',
    'Mariato - Tebario',
    'Montijo - Cébaco',
    'Montijo - Costa Hermosa',
    'Montijo - Gobernadora',
    'Montijo - La Garceana',
    'Montijo - Leones',
    'Montijo - Montijo',
    'Montijo - Pilón',
    'Montijo - Unión del Norte',
    'Río de Jesús - Catorce de Noviembre',
    'Río de Jesús - Río de Jesús',
    'Río de Jesús - Las Huacas',
    'Río de Jesús - Los Castillos',
    'Río de Jesús - Utira',
    'San Francisco - Corral Falso',
    'San Francisco - Los Hatillos',
    'San Francisco - Remance',
    'San Francisco - San Francisco',
    'San Francisco - San Juan',
    'San Francisco - San José',
    'Santa Fe - Calovébora',
    'Santa Fe - El Alto',
    'Santa Fe - El Cuay',
    'Santa Fe - El Pantano',
    'Santa Fe - Gatuncito',
    'Santa Fe - Río Luis',
    'Santa Fe - Rubén Cantú',
    'Santa Fe - Santa Fe',
    'Santiago - Canto del Llano',
    'Santiago - Carlos Santana Ávila',
    'Santiago - Edwin Fábrega',
    'Santiago - La Colorada',
    'Santiago - La Peña',
    'Santiago - La Raya de Santa María',
    'Santiago - Los Algarrobos',
    'Santiago - Nuevo Santiago',
    'Santiago - Ponuga',
    'Santiago - San Martín de Porres',
    'Santiago - San Pedro del Espino',
    'Santiago - Santiago',
    'Santiago - Santiago Este',
    'Santiago - Santiago Sur',
    'Santiago - Rodrigo Luque',
    'Santiago - Urracá',
    'Soná - Bahía Honda',
    'Soná - Calidonia',
    'Soná - Cativé',
    'Soná - El Marañón',
    'Soná - Guarumal',
    'Soná - Hicaco',
    'Soná - La Soledad',
    'Soná - La Trinchera',
    'Soná - Quebrada de Oro',
    'Soná - Río Grande',
    'Soná - Rodeo Viejo',
    'Soná - Soná'
  ),
  'PAN-EW' => array(
    'Cémaco - Cirilo Guaynora',
    'Cémaco - Lajas Blancas',
    'Cémaco - Manuel Ortega',
    'Sambú - Jingurudó',
    'Sambú - Río Sabalo'
  ),
  'PAN-KY' => array(
    'Ailigandí',
    'Narganá',
    'Puerto Obaldía',
    'Tubualá',
  ),
  'PAN-NB' => array(
    'Besikó - Boca de Balsa',
    'Besikó - Cerro Banco',
    'Besikó - Cerro Patena',
    'Besikó - Camarón Arriba',
    'Besikó - Emplanada de Chorcha',
    'Besikó - Nämnoní',
    'Besikó - Niba',
    'Besikó - Soloy',
    'Kankintú - Bisira',
    'Kankintú - Calante',
    'Kankintú - Kankintú',
    'Kankintú - Guoroní',
    'Kankintú - Mününí',
    'Kankintú - Piedra Roja',
    'Kankintú - Tolote',
    'Kusapín - Bahía Azul',
    'Kusapín - Cañaveral',
    'Kusapín - Kusapín',
    'Kusapín - Río Chiriquí',
    'Kusapín - Tobobé',
    'Mironó - Cascabel',
    'Mironó - Hato Corotú',
    'Mironó - Hato Culantro',
    'Mironó - Hato Pilón',
    'Mironó - Hato Jobo',
    'Mironó - Hato Julí',
    'Mironó - Quebrada de Loro',
    'Mironó - Salto Dupí',
    'Müna - Alto Caballero',
    'Müna - Bakama',
    'Müna - Cerro Caña',
    'Müna - Cerro Puerco',
    'Müna - Chichica',
    'Müna - Krüa',
    'Müna - Maraca',
    'Müna - Nibra',
    'Müna - Peña Blanca',
    'Müna - Roka',
    'Müna - Sitio Prado',
    'Müna - Umaní',
    'Müna - Diko',
    'Müna - Kikari',
    'Müna - Dikeri',
    'Müna - Mreeni',
    'Nole Düima - Cerro Iglesias',
    'Nole Düima - Hato Chamí',
    'Nole Düima - Jädeberi',
    'Nole Düima - Lajero',
    'Nole Düima - Susama',
    'Ñürüm - Agua de Salud',
    'Ñürüm - Alto de Jesús',
    'Ñürüm - Buenos Aires',
    'Ñürüm - Cerro Pelado',
    'Ñürüm - El Bale',
    'Ñürüm - El Paredón',
    'Ñürüm - El Piro',
    'Ñürüm - Guayabito',
    'Ñürüm - Güibale',
    'Ñürüm - El Peñón',
    'Ñürüm - El Piro N°2',
    'Jirondai - Burí',
    'Jirondai - Guariviara',
    'Jirondai - Man Creek',
    'Jirondai - Samboa',
    'Jirondai - Tuwai',
    'Santa Catalina o Calovébora - Alto Bilingüe',
    'Santa Catalina o Calovébora - Loma Yuca',
    'Santa Catalina o Calovébora - San Pedrito',
    'Santa Catalina o Calovébora - Valle Bonito',
    'Santa Catalina o Calovébora - Santa Catalina o Calovébora'
  )
);

// Use this filter to handle the Districs and Corregimientos of Panama
$places['PA'] = apply_filters('scpwoo_custom_places_pa', $places['PA']);
