<?php

/**
* Cities, Towns, and Regions in Mauritius
* - 514 cities, towns and regions
*
* Source:
* - https://en.wikipedia.org/wiki/Districts_of_Mauritius
* - http://nourmedia.com/world/MP/
* - http://www.tageo.com/index-e-mp.htm
*
* @author  Audrey <info@pongo.io> | https://pongo.io
* @version 1.0.0
* @license http://www.gnu.org/licenses/gpl-2.0.html
*/

global $places;

$places['MU'] = array(
    // Black River
    'BL' => array(
        'Albion',
        'Bambous',
        'Barachois',
        'Beaux Songes',
        'Belle Isle',
        'Belle Vue',
        'Cachette',
        'Camp Créoles',
        'Camp Malgache',
        'Canot',
        'Cascavelle',
        'Casela',
        'Chamarel',
        'Clarence',
        'Coromandel',
        'Coteau Raffin',
        'Eau Bonne',
        'Flic en Flac',
        'Grande Case Noyale',
        'Grande Riviere Noire',
        'Gros Cailloux',
        'L’Embrasure',
        'La Crete',
        'La Gaulette',
        'La Mecque',
        'La Mivoie',
        'Labonte',
        'Le Morne',
        'Les Salines',
        'Magenta',
        'Mare Samson',
        'Medine',
        'Mon Repos',
        'Mon Vallon',
        'Palmyre',
        'Petit Verger',
        'Petite Case Noyale',
        'Petite Riviere',
        'Petite Riviere Noire',
        'Pointe aux Sables',
        'Rivière Noire',
        'Saint Martin',
        'Suase',
        'Tamarin',
        'Trois Cavernes',
        'Trou Chenille',
        'Trublet',
        'Walhala',
        'Wolmar',
        'Yemen',
    ),
    // Flacq
    'FL' => array(
        'Argy',
        'Baie Manioc',
        'Baie Mannioc',
        'Beau Champ',
        'Bel Air',
        'Bel Étang',
        'Belle Mare',
        'Belle Rive',
        'Belle Rose',
        'Belle Vue Allendy',
        'Belvedere',
        'Bois d\'Oiseaux',
        'Bon Accueil',
        'Bonne Mere',
        'Bramsthan',
        'Bras d’Eau',
        'Brisee Verdiere',
        'Camp Bonnemère',
        'Camp Bouillon',
        'Camp Garreau',
        'Camp Ithier',
        'Camp Marcelin',
        'Camp Poorun',
        'Camp Sonah',
        'Camp de Masque',
        'Centre de Flacq',
        'Clavet',
        'Clémencia',
        'Constance',
        'Coquinbourg',
        'Deep River',
        'Deux Frères',
        'Ecroignard',
        'Ernest Florent',
        'Flacq',
        'Grand dans Fond',
        'Grande Retraite',
        'Grande Rivière Sud Est',
        'Haut de Flacq',
        'Hermitage',
        'Isidore Rose',
        'L\'Etoile',
        'L\'Unite',
        'La Caroline',
        'La Commune',
        'La Coterie',
        'La Gaiété',
        'La Lucie',
        'La Marre',
        'La Nourrice',
        'Lalmatie',
        'Laventure',
        'Lesur',
        'Mare Jacot',
        'Mare La Chaux',
        'Mare d’Australia',
        'Marie Jeanne',
        'Medine',
        'Olivia',
        'Palmar',
        'Pellegrin',
        'Petit Bois',
        'Petite Cabane',
        'Pointe aux Feuilles',
        'Pont Blanc',
        'Poste de Flacq',
        'Providence',
        'Quatre Cocos',
        'Quatre Soeurs',
        'Queen Victoria',
        'Rich Fund',
        'Saint Julien',
        'Saint Remy',
        'Sebastopol',
        'Trois Îlots',
        'Trou d’Eau Douce',
        'Union Flacq',
    ),
    // Grand Port
    'GP' => array(
        'Anse Jonchee',
        'Astroea',
        'Balisson',
        'Bambous Virieux',
        'Bananes',
        'Beau Fond',
        'Beau Site',
        'Beau Vallon',
        'Bel Air',
        'Belle Vue',
        'Bois des Amourettes',
        'Bois d’Oiseaux',
        'Bémanique',
        'Camp Accacia',
        'Camp Carol',
        'Camp Jardin',
        'Cent Gaulettes',
        'Cluny',
        'Deux Bras',
        'Eau Bleue',
        'Ferney',
        'Grand Bel Air',
        'Grand Sable',
        'Gros Billot',
        'Gros Bois',
        'Joli Bois',
        'La Barraque',
        'La Rampe - Le Moirt',
        'La Rosa',
        'La Sourdine',
        'Le Bouchon',
        'Le Chaland',
        'Le Val',
        'Le Vallon',
        'Ligne Barrin',
        'L’Escalier',
        'Mahebourg',
        'Mare Chicose',
        'Mare Tabac',
        'Mare d’Albert',
        'Marie Jeanie',
        'Mon Désert',
        'Mon Tresor',
        'Mon Trésor - Mon Désert',
        'New Grove',
        'Nouvelle France',
        'Pavillon du Grand Port',
        'Petit Bel Air',
        'Petit Sable',
        'Plaine Magnien',
        'Plaisance',
        'Plein Bois',
        'Pointe aux Roches',
        'Pointe d’Esny',
        'Pont Colville',
        'Providence',
        'Riche en Eau',
        'Rivière des Creoles',
        'Rose Belle',
        'Ruisseau Copeaux',
        'Saint Hilaire',
        'Saint Hubert',
        'Sainte Madeleine',
        'Savinia',
        'Souffleur',
        'Trois Boutiques',
        'Union Park',
        'Union Vale',
        'Vieux Grand Port',
        'Ville Noire',
        'Virginia',
    ),
    // Moka
    'MO' => array(
        'Alma',
        'Bagatelle',
        'Bar le Duc',
        'Beau Bois',
        'Belle Rose',
        'Bonne Veine',
        'Camp Auguste',
        'Camp Thorel',
        'Chantenuy',
        'Circonstance',
        'Cote d\'Or',
        'Dubreuil',
        'Espérance',
        'Helvétia',
        'Hermitage',
        'Hervé',
        'La Dagotiere',
        'La Laura',
        'La Russie',
        'Le Bocage',
        'Les Guibies',
        'L’Agrément',
        'L’Assurance',
        'L’Avenir',
        'L’Escalier',
        'Melrose',
        'Midlands',
        'Minissy',
        'Moka',
        'Mon Désert',
        'Mont Fleury',
        'Montebello',
        'Mount Ory',
        'Nouvelle Découverte',
        'Pailles',
        'Petit Paquet',
        'Petit Verger',
        'Providence',
        'Quartier Militaire',
        'Réduit',
        'Ripailles',
        'Riviere Baptiste',
        'Roselyn Cottage',
        'Saint Pierre',
        'Salazie',
        'Telfair',
        'Valetta',
        'Verdun',
        'Vuillemin',
    ),
    // Pamplemousses
    'PA' => array(
        'Amitié',
        'Arsenal',
        'Baie du Tombeau',
        'Baillache',
        'Beau Plan',
        'Belle Vue Harel',
        'Belle Vue Pilot',
        'Belle-Vue',
        'Belvédère',
        'Bois Mangue',
        'Bois Marchand',
        'Bois Pignolet',
        'Bois Rouge',
        'Bon Air',
        'Calebasses',
        'Camp Bestel',
        'Camp Créole',
        'Camp des Embrevades',
        'Caroline',
        'Choisy',
        'Congomah',
        'Crève Coeur',
        'D’Epinay',
        'Fond du Sac',
        'Grande Pointe aux Piments',
        'Grande Rosalie',
        'Ilot',
        'Khoyratty',
        'La Bergerie',
        'La Cocoterie',
        'Le Goulet',
        'Le Hochet',
        'Le Plessis',
        'Leonbourg',
        'Les Mariannes',
        'Long Mountain',
        'L’Espoir',
        'Madame Cayeux',
        'Maison Blanche',
        'Melotte',
        'Mon Goût',
        'Mon Rocher',
        'Mont Choisy',
        'Morcellemont Saint Andre',
        'Notre Dame',
        'Pamplemousses',
        'Petit Gamin',
        'Petite Julie',
        'Petite Rosalie',
        'Plaine des Papayes',
        'Pointe aux Canonniers',
        'Pont Praslin',
        'Richeterre',
        'Robinson',
        'Roche Bois',
        'Rouge Terre',
        'Ruisseau Rose',
        'Saint Cloud',
        'Solitude',
        'Terre Rouge',
        'The Mount',
        'Trio',
        'Triolet',
        'Trou aux Biches',
        'Valton',
        'Ville Bague',
        'Ville Valio',
    ),
    // Plaines Wilhems
    'PW' => array(
        'Barkly',
        'Beau Bassin',
        'Belle Etoile',
        'Belle Terre',
        'Bonne Terre',
        'Camp Caval',
        'Camp Fouquereaux',
        'Camp La Savanne',
        'Camp Mapou',
        'Camp Roches',
        'Candos',
        'Carreau Laliane',
        'Chébel',
        'Cinq Arpents',
        'Curepipe',
        'Eaux Coulée',
        'Ebene',
        'Engrais Cathan',
        'Floreal',
        'Forest Side',
        'Glen Park',
        'Henrietta',
        'Highlands',
        'Holyrood',
        'La Caverne',
        'La Croisee',
        'La Louise',
        'La Marie',
        'La Source',
        'Le Pétrin',
        'Les Casernes',
        'Malherbes',
        'Mesnil',
        'Midlands',
        'Pellegrin',
        'Petit Camp',
        'Phoenix',
        'Plaine Noel',
        'Plaine Sophie',
        'Plaisance',
        'Quatre Bornes',
        'Quinze Cantons',
        'River Side',
        'Roches Brunes',
        'Rose Hill',
        'Saint Antoine',
        'Seizième Mille',
        'Solferino',
        'Stanley',
        'Trianon',
        'Vacoas',
        'Phoenix',
        'Valentina',
        'Ville d’Apray',
        'Vuillemain',
        'Wooton',
    ),
    // Port Louis
    'PL' => array(
        'Abercrombie',
        'Bain des Dames',
        'Bell Village',
        'Camp Yoloff',
        'Carreau Lalo',
        'Cassis',
        'Champ de Mars',
        'Cite La Cure',
        'Cité Valijée',
        'Grand River North West',
        'Mon Loisir',
        'Plaine Verte',
        'Port Louis',
        'Sainte Croix',
        'Tranquebar',
        'Vallée Pitot',
        'Vallée des Prêtres',
    ),
    // Rivière du Rempart
    'RR' => array(
        'Amaury',
        'Antoinette',
        'Barlow',
        'Beau Manguier',
        'Belle Vue Maurel',
        'Belmont',
        'Bon Espoir',
        'Cap Malheureux',
        'Cottage',
        'Espérance Trébuchet',
        'Forbach',
        'Germain',
        'Gokoola',
        'Goodlands',
        'Grand Baie',
        'Grand Gaube',
        'Haute Rive',
        'Hermitage',
        'Ile d’Ambre',
        'La Clémence',
        'La Morue',
        'Labourdonnais',
        'L’Amitie',
        'L’Espérance',
        'Madame Azor',
        'Mamzelle Jeanne',
        'Mapou',
        'Melville',
        'Mon Piton',
        'Mon Songe',
        'Pavillon',
        'Pereybere',
        'Petit Paquet',
        'Petit Raffray',
        'Piton',
        'Plaines des Roches',
        'Poudre d’Or',
        'Poudre d’Or Hamlet',
        'Ravin',
        'Rivière du Rempart',
        'Roche Terre',
        'Roches Noires',
        'Réunion Maurel',
        'Saint Antoine',
        'Saint Francois',
        'Schoenfeld',
        'The Vale',
    ),
    // Rodrigues
    'RO' => array(
        'Anse aux Anglais',
        'Baie Topaze',
        'Baie aux Huîtres',
        'Bassin Cabri',
        'Brule',
        'Camp du Roi',
        'Chameaux',
        'Citron Donis',
        'Citronelle',
        'Coromandel',
        'Crève Coeur',
        'Eau Vannée',
        'Grand Baie',
        'Grande Montagne',
        'La Ferme',
        'La Fouche',
        'Lataniers',
        'Mangue',
        'Marechal',
        'Mont Lubin',
        'Nouvelle Decouverte',
        'Palissade Ternel',
        'Patate Theophile',
        'Petit Brule',
        'Petit Gabriel',
        'Petit Gravier',
        'Petite Butte',
        'Plaine Corail',
        'Port Mathurin',
        'Port Sud-Est',
        'Quatre Vents',
        'Rivière Cocos',
        'Roche Bon Dieu',
        'Saint Gabriel',
        'Saint Louis',
        'Solitude',
        'Songe',
        'Soupir',
    ),
    // Savanne
    'SA' => array(
        'Baie du Cap',
        'Batimarais',
        'Beau Bois',
        'Beau Champ',
        'Bel Air',
        'Bel Ombre',
        'Bois Chéri',
        'Bois Sec',
        'Bon Courage',
        'Britannia',
        'Bénarès',
        'Camp Berthaud',
        'Camp Diable',
        'Chamouny',
        'Chemin Grenier',
        'Choisy',
        'Fontenelle',
        'Frederica',
        'Grand Bois',
        'La Flora',
        'Le Marres',
        'Luchon',
        'L’Union',
        'Mont Blanc',
        'Pomponnette',
        'Riambel',
        'Riche Bois',
        'Rivière Dragon',
        'Rivière des Anguilles',
        'Ruisseau Creole',
        'Saint Aubin',
        'Saint Avold',
        'Saint Felix',
        'Saint Martin',
        'Sainte-Marie',
        'Savannah',
        'Senneville',
        'Souillac',
        'Surinam',
        'Terracine',
        'Valentina',
        'Valruche',
    ),
);

// Use this filter to handle the Cities, Towns, and Regions in Mauritius
$places['MU'] = apply_filters('scpwoo_custom_places_mu', $places['MU']);
