<?php

/**
 * Municipalities of Honduras
 * 298 municipalities
 *
 * Source:
 * - https://es.wikipedia.org/wiki/Anexo:Municipios_de_Honduras
 * 
 * Updated: April 20, 2020
 * By Jesus Bermudez | https://mintec.co
 * 
 * @author  Jesus Bermudez <jbermudez01@gmail.com> | http://mintec.co
 * @version 1.0.0
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * 
 */

global $places;

$places['HN'] = array(
	'HN1' => array(
		'San Pedro Sula',
		'Choloma',
		'Omoa',
		'Pimienta',
		'Potrerillos',
		'Puerto Cortés',
		'San Antonio de Cortés',
		'San Francisco de Yojoa',
		'San Manuel',
		'Santa Cruz de Yojoa',
		'Villanueva',
		'La Lima'
	),
	'HN2' => array(
		'Tegucigalpa',
		'Comayaguela',
		'Alubarén',
		'Cedros',
		'Curarén',
		'El Porvenir',
		'Guaimaca',
		'La Libertad',
		'La Venta',
		'Lepaterique',
		'Maraita',
		'Marale',
		'Nueva Armenia',
		'Ojojona',
		'Orica',
		'Reitoca',
		'Sabanagrande',
		'San Antonio de Oriente',
		'San Buenaventura',
		'San Ignacio',
		'San Juan de Flores',
		'San Miguelito',
		'Santa Ana',
		'Santa Lucía',
		'Talanga',
		'Tatumbla',
		'Valle de Ángeles',
		'Villa de San Francisco',
		'Vallecillo',
	),
	'HN3' => array(
		'La Ceiba',
		'El Porvenir',
		'Tela',
		'Jutiapa',
		'La Masica',
		'San Francisco',
		'Arizona',
		'Esparta',
	),
	'HN4' => array(
		'Trujillo',
		'Balfate',
		'Iriona',
		'Limón',
		'Sabá',
		'Santa Fe',
		'Santa Rosa de Aguán',
		'Sonaguera',
		'Tocoa',
		'Bonito Oriental',
	),
	'HN5' => array(
		'Puerto Lempira',
		'Brus Laguna',
		'Ahuas',
		'Juan Francisco Bulnes',
		'Ramón Villeda Morales',
		'Wampusirpe',
	),
	'HN6' => array(
		'Santa Rosa de Copán',
		'Cabañas',
		'Concepción',
		'Copán Ruinas',
		'Corquín',
		'Cucuyagua',
		'Dolores',
		'Dulce Nombre',
		'El Paraíso',
		'Florida',
		'La Jigua',
		'La Unión',
		'Nueva Arcadia',
		'San Agustín',
		'San Antonio',
		'San Jerónimo',
		'San José',
		'San Juan de Opoa',
		'San Nicolás',
		'San Pedro',
		'Santa Rita',
		'Trinidad de Copán',
		'Veracruz',
	),
	'HN7' => array(
		'Santa Bárbara',
		'Arada',
		'Atima',
		'Azacualpa',
		'Ceguaca',
		'Concepción del Norte',
		'Concepción del Sur',
		'Chinda',
		'El Níspero',
		'Gualala',
		'Ilama',
		'Las Vegas',
		'Macuelizo',
		'Naranjito',
		'Nuevo Celilac',
		'Nueva Frontera',
		'Petoa',
		'Protección',
		'Quimistán',
		'San Francisco de Ojuera',
		'San José de Colinas',
		'San Luis',
		'San Marcos',
		'San Nicolás',
		'San Pedro Zacapa',
		'San Vicente Centenario',
		'Santa Rita',
		'Trinidad',
	),
	'HN8' => array(
		'Yoro',
		'Arenal',
		'El Negrito',
		'El Progreso',
		'Jocón',
		'Morazán',
		'Olanchito',
		'Santa Rita',
		'Sulaco',
		'Victoria',
		'Yorito',
	),
	'HN9' => array(
		'Juticalpa',
		'Campamento',
		'Catacamas',
		'Concordia',
		'Dulce Nombre de Culmí',
		'El Rosario',
		'Esquipulas del Norte',
		'Gualaco',
		'Guarizama',
		'Guata',
		'Guayape',
		'Jano',
		'La Unión',
		'Mangulile',
		'Manto',
		'Salamá',
		'San Esteban',
		'San Francisco de Becerra',
		'San Francisco de la Paz',
		'Santa María del Real',
		'Silca',
		'Yocón',
		'Patuca',
	),
	'HN10' => array(
		'Ocotepeque',
		'Belén Gualcho',
		'Concepción',
		'Dolores Merendón',
		'Fraternidad',
		'La Encarnación',
		'La Labor',
		'Lucerna',
		'Mercedes',
		'San Fernando',
		'San Francisco del Valle',
		'San Jorge',
		'San Marcos',
		'Santa Fe',
		'Sensenti',
		'Sinuapa',
	),
	'HN11' => array(
		'Gracias',
		'Belén',
		'Candelaria',
		'Cololaca',
		'Erandique',
		'Gualcince',
		'Guarita',
		'La Campa',
		'La Iguala',
		'Las Flores',
		'La Unión',
		'La Virtud',
		'Lepaera',
		'Mapulaca',
		'Piraera',
		'San Andrés',
		'San Francisco',
		'San Juan Guarita',
		'San Manuel Colohete',
		'San Rafael',
		'San Sebastián',
		'Santa Cruz',
		'Talgua',
		'Tambla',
		'Tomalá',
		'Valladolid',
		'Virginia'
	),
	'HN12' => array(
		'La Esperanza',
		'Camasca',
		'Colomoncagua',
		'Concepción',
		'Dolores',
		'Intibucá',
		'Jesús de Otoro',
		'Magdalena',
		'Masaguara',
		'San Antonio',
		'San Isidro',
		'San Juan',
		'San Marcos de la Sierra',
		'San Miguel Guancapla',
		'Santa Lucía',
		'Yamaranguila',
		'San Francisco de Opalaca',
	),
	'HN13' => array(
		'Comayagua',
		'Ajuterique',
		'El Rosario',
		'Esquías',
		'Humuya',
		'La libertad',
		'Lamaní',
		'La Trinidad',
		'Lejamani',
		'Meambar',
		'Minas de Oro',
		'Ojos de Agua',
		'San Jerónimo',
		'San José de Comayagua',
		'San José del Potrero',
		'San Luis',
		'San Sebastián',
		'Siguatepeque',
		'Villa de San Antonio',
		'Las Lajas',
		'Taulabé',
	),
	'HN14' => array(
		'Nacaome',
		'Alianza',
		'Amapala',
		'Aramecina',
		'Caridad',
		'Goascorán',
		'Langue',
		'San Francisco de Coray',
		'San Lorenzo',
	),
	'HN15' => array(
		'La Paz',
		'Aguanqueterique',
		'Cabañas',
		'Cane',
		'Chinacla',
		'Guajiquiro',
		'Lauterique',
		'Marcala',
		'Mercedes de Oriente',
		'Opatoro',
		'San Antonio del Norte',
		'San José',
		'San Juan',
		'San Pedro de Tutule',
		'Santa Ana',
		'Santa Elena',
		'Santa María',
		'Santiago de Puringla',
		'Yarula',
	),
	'HN16' => array(
		'Yuscarán',
		'Alauca',
		'Danlí',
		'El Paraíso',
		'Güinope',
		'Jacaleapa',
		'Liure',
		'Morocelí',
		'Oropolí',
		'Potrerillos',
		'San Antonio de Flores',
		'San Lucas',
		'San Matías',
		'Soledad',
		'Teupasenti',
		'Texiguat',
		'Vado Ancho',
		'Yauyupe',
		'Trojes',
	),
	'HN17' => array(
		'Choluteca',
		'Apacilagua',
		'Concepción de María',
		'Duyure',
		'El Corpus',
		'El Triunfo',
		'Marcovia',
		'Morolica',
		'Namasigue',
		'Orocuina',
		'Pespire',
		'San Antonio de Flores',
		'San Isidro',
		'San José',
		'San Marcos de Colón',
		'Santa Ana de Yusguare',
	),
	'HN18' => array(
		'Roatán',
		'Guanaja',
		'José Santos Guardiola',
		'Utila',
	),
);

// Use this filter to handle the Municipalities of Honduras
$places['HN'] = apply_filters('scpwoo_custom_places_hn', $places['HN']);
