<?php

/**
 * Municipalities of Guatemala
 * - 339 municipalities are listed
 *
 * Source:
 * - https://es.wikipedia.org/wiki/Anexo:Municipios_de_Guatemala
 * 
 * Updated: March 22, 2020
 * By Yordan Soares <contact@yordansoar.es> | https://yordansoar.es
 * 
 * @author  Ronald Montenegro <rodmontgt@gmail.com> | http://espaciogt.wordpress.com
 * @version 1.0.0
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * 
 */

global $places;

$places['GT'] = array(
	'GT-AV' => array(
		'Santa María Cahabón',
		'Chahal',
		'Chisec',
		'Cobán',
		'Fray Bartolomé de las Casas',
		'Lanquín',
		'Panzós',
		'Raxruhá',
		'San Cristóbal Verapaz',
		'San Juan Chamelco',
		'San Pedro Carchá',
		'La Tinta',
		'Santa Cruz Verapaz',
		'Senahú',
		'Tactic',
		'Tamahú',
		'Tucurú',
	),
	'GT-BV' => array(
		'Cubulco',
		'Granados',
		'Purulhá',
		'Rabinal',
		'Salamá',
		'San Jerónimo',
		'San Miguel Chicaj',
		'Santa Cruz el Chol',
	),
	'GT-CM' => array(
		'Acatenango',
		'Chimaltenango',
		'El Tejar',
		'Parramos',
		'Patzicía',
		'Patzún',
		'Pochuta',
		'San Andrés Itzapa',
		'San José Poaquíl',
		'San Juan Comalapa',
		'San Martín Jilotepeque',
		'San Pedro Yepocapa',
		'Santa Apolonia',
		'Santa Cruz Balanyá',
		'Tecpán',
		'Zaragoza',
	),
	'GT-CQ' => array(
		'Camotán',
		'Chiquimula',
		'Concepción Las Minas',
		'Esquipulas',
		'Ipala',
		'Jocotán',
		'Olopa',
		'Quezaltepeque',
		'San Jacinto',
		'San José La Arada',
		'San Juan Ermita'
	),
	'GT-PR' => array(
		'El Jícaro',
		'Guastatoya',
		'Morazán',
		'San Agustín Acasaguastlán',
		'San Antonio La Paz',
		'San Cristóbal Acasaguastlán',
		'Sanarate',
		'Sansare',
	),
	'GT-ES' => array(
		'Escuintla',
		'Guanagazapa',
		'Iztapa',
		'La Democracia',
		'La Gomera',
		'Masagua',
		'Nueva Concepción',
		'Palín',
		'San José',
		'San Vicente Pacaya',
		'Santa Lucía Cotzumalguapa',
		'Sipacate',
		'Siquinaláe',
	),
	'GT-GU' => array(
		'Amatitlán',
		'Chinautla',
		'Chuarrancho',
		'Fraijanes',
		'Ciudad de Guatemala',
		'Mixco',
		'Palencia',
		'San José del Golfo',
		'San José Pinula',
		'San Juan Sacatepéquez',
		'San Miguel Petapa',
		'San Pedro Ayampuc',
		'San Pedro Sacatepéquez',
		'San Raymundo',
		'Santa Catarina Pinula',
		'Villa Canales',
		'Villa Nueva',
	),
	'GT-HU' => array(
		'Aguacatán',
		'Chiantla',
		'Colotenango',
		'Concepción Huista',
		'Cuilco',
		'Huehuetenango',
		'Jacaltenango',
		'La Democracia',
		'La Libertad',
		'Malacatancito',
		'Nentón',
		'Petatán',
		'San Antonio Huista',
		'San Gaspar Ixchil',
		'San Ildefonso Ixtahuacán',
		'San Juan Atitán',
		'San Juan Ixcoy',
		'San Mateo Ixtatán',
		'San Miguel Acatán',
		'San Pedro Necta',
		'San Pedro Soloma',
		'San Rafael La Independencia',
		'San Rafael Petzal',
		'San Sebastián Coatán',
		'San Sebastián Huehuetenango',
		'Santa Ana Huista',
		'Santa Bárbara',
		'Santa Cruz Barillas',
		'Santa Eulalia',
		'Santiago Chimaltenango',
		'Tectitán',
		'Todos Santos Cuchumatán',
		'Unión Cantinil',
	),
	'GT-IZ' => array(
		'El Estor',
		'Livingston',
		'Los Amates',
		'Morales',
		'Puerto Barrios',
	),
	'GT-JA' => array(
		'Jalapa',
		'Mataquescuintla',
		'Monjas',
		'San Carlos Alzatate',
		'San Luis Jilotepeque',
		'San Manuel Chaparrón',
		'San Pedro Pinula',
	),
	'GT-JU' => array(
		'Agua Blanca',
		'Asunción Mita',
		'Atescatempa',
		'Comapa',
		'Conguaco',
		'El Adelanto',
		'El Progreso',
		'Jalpatagua',
		'Jeréz',
		'Jutiapa',
		'Moyuta',
		'Pasaco',
		'Quesada',
		'San José Acatempa',
		'Santa Catarina Mita',
		'Yupiltepeque',
		'Zapotitlán',
	),
	'GT-PE' => array(
		'Dolores',
		'Isla de Flores, Santa Elena de la Cruz',
		'La Libertad',
		'Melchor de Mencos',
		'Poptún',
		'San Andrés',
		'San Benito',
		'San Francisco',
		'San José',
		'San Luis',
		'Santa Ana',
		'Sayaxché',
		'Las Cruces',
		'El Chal',
	),
	'GT-QZ' => array(
		'Almolonga',
		'Cabricán',
		'Cajolá',
		'Cantel',
		'Coatepeque',
		'Colomba Costa Cuca',
		'Concepción Chiquirichapa',
		'El Palmar',
		'Flores Costa Cuca',
		'Génova',
		'Huitán',
		'La Esperanza',
		'Olintepeque',
		'Palestina de Los Altos',
		'Quetzaltenango',
		'Salcajá',
		'San Carlos Sija',
		'San Francisco La Unión',
		'San Juan Ostuncalco',
		'San Martín Sacatepéquez',
		'San Mateo',
		'San Miguel Sigüilá',
		'Sibilia',
		'Zunil',
	),
	'GT-QC' => array(
		'Canillá',
		'Chajul',
		'Chicamán',
		'Chiché',
		'Chichicastenango',
		'Chinique',
		'Cunén',
		'Ixcán',
		'Joyabaj',
		'Nebaj',
		'Pachalum',
		'Patzité',
		'Sacapulas',
		'San Andrés Sajcabajá',
		'San Antonio Ilotenango',
		'San Bartolomé Jocotenango',
		'San Juan Cotzal',
		'San Pedro Jocopilas',
		'Santa Cruz del Quiché',
		'Uspantán',
		'Zacualpa',
	),
	'GT-RE' => array(
		'Champerico',
		'El Asintal',
		'Nuevo San Carlos',
		'Retalhuleu',
		'San Andrés Villa Seca',
		'San Felipe',
		'San Martín Zapotitlán',
		'San Sebastián',
		'Santa Cruz Muluá',
	),
	'GT-SA' => array(
		'Alotenango',
		'Antigua Guatemala',
		'Ciudad Vieja',
		'Jocotenango',
		'Magdalena Milpas Altas',
		'Pastores',
		'San Antonio Aguas Calientes',
		'San Bartolomé Milpas Altas',
		'San Lucas Sacatepéquez',
		'San Miguel Dueñas',
		'Santa Catarina Barahona',
		'Santa Lucía Milpas Altas',
		'Santa María de Jesús',
		'Santiago Sacatepéquez',
		'Santo Domingo Xenacoj',
		'Sumpango',
	),
	'GT-SM' => array(
		'Ayutla',
		'Catarina',
		'Comitancillo',
		'Concepción Tutuapa',
		'El Quetzal',
		'San José El Rodeo',
		'El Tumbador',
		'Esquipulas Palo Gordo',
		'Ixchiguán',
		'La Blanca',
		'La Reforma',
		'Malacatán',
		'Nuevo Progreso',
		'Ocós',
		'Pajapita',
		'Río Blanco',
		'San Antonio Sacatepéquez',
		'San Cristóbal Cucho',
		'San José Ojetenam',
		'San Lorenzo',
		'San Marcos',
		'San Miguel Ixtahuacán',
		'San Pablo',
		'San Pedro Sacatepéquez',
		'San Rafael Pie de la Cuesta',
		'Sibinal',
		'Sipacapa',
		'Tacaná',
		'Tajumulco',
		'Tejutla',
	),
	'GT-SR' => array(
		'Barberena',
		'Casillas',
		'Chiquimulilla',
		'Cuilapa',
		'Guazacapán',
		'Nueva Santa Rosa',
		'Oratorio',
		'Pueblo Nuevo Viñas',
		'San Juan Tecuaco',
		'San Rafaél Las Flores',
		'Santa Cruz Naranjo',
		'Santa María Ixhuatán',
		'Santa Rosa de Lima',
		'Taxisco',
	),
	'GT-SO' => array(
		'Concepción',
		'Nahualá',
		'Panajachel',
		'San Andrés Semetabaj',
		'San Antonio Palopó',
		'San José Chacayá',
		'San Juan La Laguna',
		'San Lucas Tolimán',
		'San Marcos La Laguna',
		'San Pablo La Laguna',
		'San Pedro La Laguna',
		'Santa Catarina Ixtahuacán',
		'Santa Catarina Palopó',
		'Santa Clara La Laguna',
		'Santa Cruz La Laguna',
		'Santa Lucía Utatlán',
		'Santa María Visitación',
		'Santiago Atitlán',
		'Sololá',
	),
	'GT-SU' => array(
		'Chicacao',
		'Cuyotenango',
		'Mazatenango',
		'Patulul',
		'Pueblo Nuevo',
		'Río Bravo',
		'Samayac',
		'San Antonio Suchitepéquez',
		'San Bernardino',
		'San Francisco Zapotitlán',
		'San Gabriel',
		'San José El Ídolo',
		'San José La Máquina',
		'San Juan Bautista',
		'San Lorenzo',
		'San Miguel Panán',
		'San Pablo Jocopilas',
		'Santa Bárbara',
		'Santo Domingo Suchitepéquez',
		'Santo Tomás La Unión',
		'Zunilito',
	),
	'GT-TO' => array(
		'Momostenango',
		'San Andrés Xecul',
		'San Bartolo',
		'San Cristóbal Totonicapán',
		'San Francisco El Alto',
		'Santa Lucía La Reforma',
		'Santa María Chiquimula',
		'Totonicapán'
	),
	'GT-ZA' => array(
		'Cabañas',
		'Estanzuela',
		'Gualán',
		'Huité',
		'La Unión',
		'Río Hondo',
		'San Diego',
		'San Jorge',
		'Teculután',
		'Usumatlán',
		'Zacapa',
	),
);

// Use this filter to handle the Municipalities of Guatemala
$places['GT'] = apply_filters('scpwoo_custom_places_gt', $places['GT']);
