<?php

/**
 * Municipalities of Spain
 *
 * @author  Javier Esteban <correo@javieresteban.org> | https://javieresteban.org
 * @version 1.0.1
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */

global $places;

$places['ES'] = array(
/* Province of La Coruña/A Coruña */
  'C' => array(
    'Abegondo',
    'Ames',
    'Aranga',
    'Ares',
    'Arteixo',
    'Arzúa',
    'Baña, A',
    'Bergondo',
    'Betanzos',
    'Boimorto',
    'Boiro',
    'Boqueixón',
    'Brión',
    'Cabana de Bergantiños',
    'Cabanas',
    'Camariñas',
    'Cambre',
    'Capela, A',
    'Carballo',
    'Cariño',
    'Carnota',
    'Carral',
    'Cedeira',
    'Cee',
    'Cerceda',
    'Cerdido',
    'Coirós',
    'Corcubión',
    'Coristanco',
    'Coruña, A',
    'Culleredo',
    'Curtis',
    'Dodro',
    'Dumbría',
    'Fene',
    'Ferrol',
    'Fisterra',
    'Frades',
    'Irixoa',
    'Laracha, A',
    'Laxe',
    'Lousame',
    'Malpica de Bergantiños',
    'Mañón',
    'Mazaricos',
    'Melide',
    'Mesía',
    'Miño',
    'Moeche',
    'Monfero',
    'Mugardos',
    'Muros',
    'Muxía',
    'Narón',
    'Neda',
    'Negreira',
    'Noia',
    'Oleiros',
    'Ordes',
    'Oroso',
    'Ortigueira',
    'Outes',
    'Oza-Cesuras',
    'Paderne',
    'Padrón',
    'Pino, O',
    'Pobra do Caramiñal, A',
    'Ponteceso',
    'Pontedeume',
    'Pontes de García Rodríguez, As',
    'Porto do Son',
    'Rianxo',
    'Ribeira',
    'Rois',
    'Sada',
    'San Sadurniño',
    'Santa Comba',
    'Santiago de Compostela',
    'Santiso',
    'Sobrado',
    'Somozas, As',
    'Teo',
    'Toques',
    'Tordoia',
    'Touro',
    'Trazo',
    'Val do Dubra',
    'Valdoviño',
    'Vedra',
    'Vilarmaior',
    'Vilasantar',
    'Vimianzo',
    'Zas',
  ),
/* Province of Álava/Araba */
  'VI' => array(
    'Agurain/Salvatierra',
    'Alegría-Dulantzi',
    'Amurrio',
    'Añana',
    'Aramaio',
    'Armiñón',
    'Arraia-Maeztu',
    'Arratzua-Ubarrundia',
    'Artziniega',
    'Asparrena',
    'Ayala/Aiara',
    'Baños de Ebro/Mañueta',
    'Barrundia',
    'Berantevilla',
    'Bernedo',
    'Campezo/Kanpezu',
    'Elburgo/Burgelu',
    'Elciego',
    'Elvillar/Bilar',
    'Erriberabeitia',
    'Erriberagoitia/Ribera Alta',
    'Harana/Valle de Arana',
    'Iruña Oka/Iruña de Oca',
    'Iruraiz-Gauna',
    'Kripan',
    'Kuartango',
    'Labastida/Bastida',
    'Lagrán',
    'Laguardia',
    'Lanciego/Lantziego',
    'Lantarón',
    'Lapuebla de Labarca',
    'Laudio/Llodio',
    'Legutio',
    'Leza',
    'Moreda de Álava/Moreda Araba',
    'Navaridas',
    'Okondo',
    'Oyón-Oion',
    'Peñacerrada-Urizaharra',
    'Samaniego',
    'San Millán/Donemiliaga',
    'Urkabustaiz',
    'Valdegovía/Gaubea',
    'Villabuena de Álava/Eskuernaga',
    'Vitoria-Gasteiz',
    'Yécora/Iekora',
    'Zalduondo',
    'Zambrana',
    'Zigoitia',
    'Zuia',
  ),
/* Province of Albacete */
  'AB' => array(
    'Abengibre',
    'Alatoz',
    'Albacete',
    'Albatana',
    'Alborea',
    'Alcadozo',
    'Alcalá del Júcar',
    'Alcaraz',
    'Almansa',
    'Alpera',
    'Ayna',
    'Balazote',
    'Ballestero, El',
    'Balsa de Ves',
    'Barrax',
    'Bienservida',
    'Bogarra',
    'Bonete',
    'Bonillo, El',
    'Carcelén',
    'Casas de Juan Núñez',
    'Casas de Lázaro',
    'Casas de Ves',
    'Casas-Ibáñez',
    'Caudete',
    'Cenizate',
    'Chinchilla de Monte-Aragón',
    'Corral-Rubio',
    'Cotillas',
    'Elche de la Sierra',
    'Férez',
    'Fuensanta',
    'Fuente-Álamo',
    'Fuentealbilla',
    'Gineta, La',
    'Golosalvo',
    'Hellín',
    'Herrera, La',
    'Higueruela',
    'Hoya-Gonzalo',
    'Jorquera',
    'Letur',
    'Lezuza',
    'Liétor',
    'Madrigueras',
    'Mahora',
    'Masegoso',
    'Minaya',
    'Molinicos',
    'Montalvos',
    'Montealegre del Castillo',
    'Motilleja',
    'Munera',
    'Navas de Jorquera',
    'Nerpio',
    'Ontur',
    'Ossa de Montiel',
    'Paterna del Madera',
    'Peñas de San Pedro',
    'Peñascosa',
    'Pétrola',
    'Povedilla',
    'Pozo Cañada',
    'Pozohondo',
    'Pozo-Lorente',
    'Pozuelo',
    'Recueja, La',
    'Riópar',
    'Robledo',
    'Roda, La',
    'Salobre',
    'San Pedro',
    'Socovos',
    'Tarazona de la Mancha',
    'Tobarra',
    'Valdeganga',
    'Vianos',
    'Villa de Ves',
    'Villalgordo del Júcar',
    'Villamalea',
    'Villapalacios',
    'Villarrobledo',
    'Villatoya',
    'Villavaliente',
    'Villaverde de Guadalimar',
    'Viveros',
    'Yeste',
  ),
/* Province of Alicante/Alacant */
  'A' => array(
    'Agost',
    'Agres',
    'Aigües',
    'Albatera',
    'Alcalalí',
    'Alcocer de Planes',
    'Alcoleja',
    'Alcoy/Alcoi',
    'Alfafara',
    'Alfàs del Pi, L&#8242;',
    'Algorfa',
    'Algueña',
    'Alicante/Alacant',
    'Almoradí',
    'Almudaina',
    'Alqueria d&#8242;Asnar, L&#8242;',
    'Altea',
    'Aspe',
    'Atzúbia, L&#8242;',
    'Balones',
    'Banyeres de Mariola',
    'Benasau',
    'Beneixama',
    'Benejúzar',
    'Benferri',
    'Beniarbeig',
    'Beniardá',
    'Beniarrés',
    'Benidoleig',
    'Benidorm',
    'Benifallim',
    'Benifato',
    'Benigembla',
    'Benijófar',
    'Benilloba',
    'Benillup',
    'Benimantell',
    'Benimarfull',
    'Benimassot',
    'Benimeli',
    'Benissa',
    'Benitachell/Poble Nou de Benitatxell, El',
    'Biar',
    'Bigastro',
    'Bolulla',
    'Busot',
    'Callosa de Segura',
    'Callosa d&#8242;en Sarrià',
    'Calp',
    'Campello, El',
    'Campo de Mirra/Camp de Mirra, El',
    'Cañada',
    'Castalla',
    'Castell de Castells',
    'Castell de Guadalest, El',
    'Catral',
    'Cocentaina',
    'Confrides',
    'Cox',
    'Crevillent',
    'Daya Nueva',
    'Daya Vieja',
    'Dénia',
    'Dolores',
    'Elche/Elx',
    'Elda',
    'Facheca',
    'Famorca',
    'Finestrat',
    'Fondó de les Neus, El/Hondón de las Nieves',
    'Formentera del Segura',
    'Gaianes',
    'Gata de Gorgos',
    'Gorga',
    'Granja de Rocamora',
    'Guardamar del Segura',
    'Hondón de los Frailes',
    'Ibi',
    'Jacarilla',
    'Jávea/Xàbia',
    'Jijona/Xixona',
    'Llíber',
    'Lorcha/Orxa, L&#8242;',
    'Millena',
    'Monforte del Cid',
    'Monóvar/Monòver',
    'Montesinos, Los',
    'Murla',
    'Muro de Alcoy',
    'Mutxamel',
    'Novelda',
    'Nucia, La',
    'Ondara',
    'Onil',
    'Orba',
    'Orihuela',
    'Orxeta',
    'Parcent',
    'Pedreguer',
    'Pego',
    'Penàguila',
    'Petrer',
    'Pilar de la Horadada',
    'Pinós, El/Pinoso',
    'Planes',
    'Poblets, Els',
    'Polop',
    'Quatretondeta',
    'Rafal',
    'Ràfol d&#8242;Almúnia, El',
    'Redován',
    'Relleu',
    'Rojales',
    'Romana, La',
    'Sagra',
    'Salinas',
    'San Fulgencio',
    'San Isidro',
    'San Miguel de Salinas',
    'San Vicente del Raspeig/Sant Vicent del Raspeig',
    'Sanet y Negrals',
    'Sant Joan d&#8242;Alacant',
    'Santa Pola',
    'Sax',
    'Sella',
    'Senija',
    'Tàrbena',
    'Teulada',
    'Tibi',
    'Tollos',
    'Tormos',
    'Torremanzanas/Torre de les Maçanes, La',
    'Torrevieja',
    'Vall d&#8242;Alcalà, La',
    'Vall de Gallinera',
    'Vall de Laguar, La',
    'Vall d&#8242;Ebo, La',
    'Verger, El',
    'Villajoyosa/Vila Joiosa, La',
    'Villena',
    'Xaló',
  ),
/* Province of Almería */
  'AL' => array(
    'Abla',
    'Abrucena',
    'Adra',
    'Albanchez',
    'Alboloduy',
    'Albox',
    'Alcolea',
    'Alcóntar',
    'Alcudia de Monteagud',
    'Alhabia',
    'Alhama de Almería',
    'Alicún',
    'Almería',
    'Almócita',
    'Alsodux',
    'Antas',
    'Arboleas',
    'Armuña de Almanzora',
    'Bacares',
    'Balanegra',
    'Bayárcal',
    'Bayarque',
    'Bédar',
    'Beires',
    'Benahadux',
    'Benitagla',
    'Benizalón',
    'Bentarique',
    'Berja',
    'Canjáyar',
    'Cantoria',
    'Carboneras',
    'Castro de Filabres',
    'Chercos',
    'Chirivel',
    'Cóbdar',
    'Cuevas del Almanzora',
    'Dalías',
    'Ejido, El',
    'Enix',
    'Felix',
    'Fines',
    'Fiñana',
    'Fondón',
    'Gádor',
    'Gallardos, Los',
    'Garrucha',
    'Gérgal',
    'Huécija',
    'Huércal de Almería',
    'Huércal-Overa',
    'Íllar',
    'Instinción',
    'Laroya',
    'Láujar de Andarax',
    'Líjar',
    'Lubrín',
    'Lucainena de las Torres',
    'Lúcar',
    'Macael',
    'María',
    'Mojácar',
    'Mojonera, La',
    'Nacimiento',
    'Níjar',
    'Ohanes',
    'Olula de Castro',
    'Olula del Río',
    'Oria',
    'Padules',
    'Partaloa',
    'Paterna del Río',
    'Pechina',
    'Pulpí',
    'Purchena',
    'Rágol',
    'Rioja',
    'Roquetas de Mar',
    'Santa Cruz de Marchena',
    'Santa Fe de Mondújar',
    'Senés',
    'Serón',
    'Sierro',
    'Somontín',
    'Sorbas',
    'Suflí',
    'Tabernas',
    'Taberno',
    'Tahal',
    'Terque',
    'Tíjola',
    'Tres Villas, Las',
    'Turre',
    'Turrillas',
    'Uleila del Campo',
    'Urrácal',
    'Velefique',
    'Vélez-Blanco',
    'Vélez-Rubio',
    'Vera',
    'Viator',
    'Vícar',
    'Zurgena',
  ),
/* Province of Asturias */
  'O' => array(
    'Allande',
    'Aller',
    'Amieva',
    'Avilés',
    'Belmonte de Miranda',
    'Bimenes',
    'Boal',
    'Cabrales',
    'Cabranes',
    'Candamo',
    'Cangas de Onís',
    'Cangas del Narcea',
    'Caravia',
    'Carreño',
    'Caso',
    'Castrillón',
    'Castropol',
    'Coaña',
    'Colunga',
    'Corvera de Asturias',
    'Cudillero',
    'Degaña',
    'Franco, El',
    'Gijón',
    'Gozón',
    'Grado',
    'Grandas de Salime',
    'Ibias',
    'Illano',
    'Illas',
    'Langreo',
    'Laviana',
    'Lena',
    'Llanera',
    'Llanes',
    'Mieres',
    'Morcín',
    'Muros de Nalón',
    'Nava',
    'Navia',
    'Noreña',
    'Onís',
    'Oviedo',
    'Parres',
    'Peñamellera Alta',
    'Peñamellera Baja',
    'Pesoz',
    'Piloña',
    'Ponga',
    'Pravia',
    'Proaza',
    'Quirós',
    'Regueras, Las',
    'Ribadedeva',
    'Ribadesella',
    'Ribera de Arriba',
    'Riosa',
    'Salas',
    'San Martín de Oscos',
    'San Martín del Rey Aurelio',
    'San Tirso de Abres',
    'Santa Eulalia de Oscos',
    'Santo Adriano',
    'Sariego',
    'Siero',
    'Sobrescobio',
    'Somiedo',
    'Soto del Barco',
    'Tapia de Casariego',
    'Taramundi',
    'Teverga',
    'Tineo',
    'Valdés',
    'Vegadeo',
    'Villanueva de Oscos',
    'Villaviciosa',
    'Villayón',
    'Yernes y Tameza',
  ),
/* Province of Ávila */
  'AV' => array(
    'Adanero',
    'Adrada, La',
    'Albornos',
    'Aldeanueva de Santa Cruz',
    'Aldeaseca',
    'Aldehuela, La',
    'Amavida',
    'Arenal, El',
    'Arenas de San Pedro',
    'Arevalillo',
    'Arévalo',
    'Aveinte',
    'Avellaneda',
    'Ávila',
    'Barco de Ávila, El',
    'Barraco, El',
    'Barromán',
    'Becedas',
    'Becedillas',
    'Bercial de Zapardiel',
    'Berlanas, Las',
    'Bernuy-Zapardiel',
    'Berrocalejo de Aragona',
    'Blascomillán',
    'Blasconuño de Matacabras',
    'Blascosancho',
    'Bohodón, El',
    'Bohoyo',
    'Bonilla de la Sierra',
    'Brabos',
    'Bularros',
    'Burgohondo',
    'Cabezas de Alambre',
    'Cabezas del Pozo',
    'Cabezas del Villar',
    'Cabizuela',
    'Canales',
    'Candeleda',
    'Cantiveros',
    'Cardeñosa',
    'Carrera, La',
    'Casas del Puerto',
    'Casasola',
    'Casavieja',
    'Casillas',
    'Castellanos de Zapardiel',
    'Cebreros',
    'Cepeda la Mora',
    'Chamartín',
    'Cillán',
    'Cisla',
    'Colilla, La',
    'Collado de Contreras',
    'Collado del Mirón',
    'Constanzana',
    'Crespos',
    'Cuevas del Valle',
    'Diego del Carpio',
    'Donjimeno',
    'Donvidas',
    'Espinosa de los Caballeros',
    'Flores de Ávila',
    'Fontiveros',
    'Fresnedilla',
    'Fresno, El',
    'Fuente el Saúz',
    'Fuentes de Año',
    'Gallegos de Altamiros',
    'Gallegos de Sobrinos',
    'Garganta del Villar',
    'Gavilanes',
    'Gemuño',
    'Gil García',
    'Gilbuena',
    'Gimialcón',
    'Gotarrendura',
    'Grandes y San Martín',
    'Guisando',
    'Gutierre-Muñoz',
    'Hernansancho',
    'Herradón de Pinares',
    'Herreros de Suso',
    'Higuera de las Dueñas',
    'Hija de Dios, La',
    'Horcajada, La',
    'Horcajo de las Torres',
    'Hornillo, El',
    'Hoyo de Pinares, El',
    'Hoyocasero',
    'Hoyorredondo',
    'Hoyos de Miguel Muñoz',
    'Hoyos del Collado',
    'Hoyos del Espino',
    'Hurtumpascual',
    'Junciana',
    'Langa',
    'Lanzahíta',
    'Llanos de Tormes, Los',
    'Losar del Barco, El',
    'Madrigal de las Altas Torres',
    'Maello',
    'Malpartida de Corneja',
    'Mamblas',
    'Mancera de Arriba',
    'Manjabálago y Ortigosa de Rioalmar',
    'Marlín',
    'Martiherrero',
    'Martínez',
    'Mediana de Voltoya',
    'Medinilla',
    'Mengamuñoz',
    'Mesegar de Corneja',
    'Mijares',
    'Mingorría',
    'Mirón, El',
    'Mironcillo',
    'Mirueña de los Infanzones',
    'Mombeltrán',
    'Monsalupe',
    'Moraleja de Matacabras',
    'Muñana',
    'Muñico',
    'Muñogalindo',
    'Muñogrande',
    'Muñomer del Peco',
    'Muñopepe',
    'Muñosancho',
    'Muñotello',
    'Narrillos del Álamo',
    'Narrillos del Rebollar',
    'Narros de Saldueña',
    'Narros del Castillo',
    'Narros del Puerto',
    'Nava de Arévalo',
    'Nava del Barco',
    'Navacepedilla de Corneja',
    'Navadijos',
    'Navaescurial',
    'Navahondilla',
    'Navalacruz',
    'Navalmoral',
    'Navalonguilla',
    'Navalosa',
    'Navalperal de Pinares',
    'Navalperal de Tormes',
    'Navaluenga',
    'Navaquesera',
    'Navarredonda de Gredos',
    'Navarredondilla',
    'Navarrevisca',
    'Navas del Marqués, Las',
    'Navatalgordo',
    'Navatejares',
    'Neila de San Miguel',
    'Niharra',
    'Ojos-Albos',
    'Orbita',
    'Oso, El',
    'Padiernos',
    'Pajares de Adaja',
    'Palacios de Goda',
    'Papatrigo',
    'Parral, El',
    'Pascualcobo',
    'Pedro Bernardo',
    'Pedro-Rodríguez',
    'Peguerinos',
    'Peñalba de Ávila',
    'Piedrahíta',
    'Piedralaves',
    'Poveda',
    'Poyales del Hoyo',
    'Pozanco',
    'Pradosegar',
    'Puerto Castilla',
    'Rasueros',
    'Riocabado',
    'Riofrío',
    'Rivilla de Barajas',
    'Salobral',
    'Salvadiós',
    'San Bartolomé de Béjar',
    'San Bartolomé de Corneja',
    'San Bartolomé de Pinares',
    'San Esteban de los Patos',
    'San Esteban de Zapardiel',
    'San Esteban del Valle',
    'San García de Ingelmos',
    'San Juan de Gredos',
    'San Juan de la Encinilla',
    'San Juan de la Nava',
    'San Juan del Molinillo',
    'San Juan del Olmo',
    'San Lorenzo de Tormes',
    'San Martín de la Vega del Alberche',
    'San Martín del Pimpollar',
    'San Miguel de Corneja',
    'San Miguel de Serrezuela',
    'San Pascual',
    'San Pedro del Arroyo',
    'San Vicente de Arévalo',
    'Sanchidrián',
    'Sanchorreja',
    'Santa Cruz de Pinares',
    'Santa Cruz del Valle',
    'Santa María de los Caballeros',
    'Santa María del Arroyo',
    'Santa María del Berrocal',
    'Santa María del Cubillo',
    'Santa María del Tiétar',
    'Santiago del Collado',
    'Santiago del Tormes',
    'Santo Domingo de las Posadas',
    'Santo Tomé de Zabarcos',
    'Serrada, La',
    'Serranillos',
    'Sigeres',
    'Sinlabajos',
    'Solana de Ávila',
    'Solana de Rioalmar',
    'Solosancho',
    'Sotalbo',
    'Sotillo de la Adrada',
    'Tiemblo, El',
    'Tiñosillos',
    'Tolbaños',
    'Tormellas',
    'Tornadizos de Ávila',
    'Torre, La',
    'Tórtoles',
    'Umbrías',
    'Vadillo de la Sierra',
    'Valdecasa',
    'Vega de Santa María',
    'Velayos',
    'Villaflor',
    'Villafranca de la Sierra',
    'Villanueva de Ávila',
    'Villanueva de Gómez',
    'Villanueva del Aceral',
    'Villanueva del Campillo',
    'Villar de Corneja',
    'Villarejo del Valle',
    'Villatoro',
    'Viñegra de Moraña',
    'Vita',
    'Zapardiel de la Cañada',
    'Zapardiel de la Ribera',
  ),
/* Province of Badajoz */
  'BA' => array(
    'Acedera',
    'Aceuchal',
    'Ahillones',
    'Alange',
    'Albuera, La',
    'Alburquerque',
    'Alconchel',
    'Alconera',
    'Aljucén',
    'Almendral',
    'Almendralejo',
    'Arroyo de San Serván',
    'Atalaya',
    'Azuaga',
    'Badajoz',
    'Barcarrota',
    'Baterno',
    'Benquerencia de la Serena',
    'Berlanga',
    'Bienvenida',
    'Bodonal de la Sierra',
    'Burguillos del Cerro',
    'Cabeza del Buey',
    'Cabeza la Vaca',
    'Calamonte',
    'Calera de León',
    'Calzadilla de los Barros',
    'Campanario',
    'Campillo de Llerena',
    'Capilla',
    'Carmonita',
    'Carrascalejo, El',
    'Casas de Don Pedro',
    'Casas de Reina',
    'Castilblanco',
    'Castuera',
    'Cheles',
    'Codosera, La',
    'Cordobilla de Lácara',
    'Coronada, La',
    'Corte de Peleas',
    'Cristina',
    'Don Álvaro',
    'Don Benito',
    'Entrín Bajo',
    'Esparragalejo',
    'Esparragosa de la Serena',
    'Esparragosa de Lares',
    'Feria',
    'Fregenal de la Sierra',
    'Fuenlabrada de los Montes',
    'Fuente de Cantos',
    'Fuente del Arco',
    'Fuente del Maestre',
    'Fuentes de León',
    'Garbayuela',
    'Garlitos',
    'Garrovilla, La',
    'Granja de Torrehermosa',
    'Guadiana del Caudillo',
    'Guareña',
    'Haba, La',
    'Helechosa de los Montes',
    'Herrera del Duque',
    'Higuera de la Serena',
    'Higuera de Llerena',
    'Higuera de Vargas',
    'Higuera la Real',
    'Hinojosa del Valle',
    'Hornachos',
    'Jerez de los Caballeros',
    'Lapa, La',
    'Llera',
    'Llerena',
    'Lobón',
    'Magacela',
    'Maguilla',
    'Malcocinado',
    'Malpartida de la Serena',
    'Manchita',
    'Medellín',
    'Medina de las Torres',
    'Mengabril',
    'Mérida',
    'Mirandilla',
    'Monesterio',
    'Montemolín',
    'Monterrubio de la Serena',
    'Montijo',
    'Morera, La',
    'Nava de Santiago, La',
    'Navalvillar de Pela',
    'Nogales',
    'Oliva de la Frontera',
    'Oliva de Mérida',
    'Olivenza',
    'Orellana de la Sierra',
    'Orellana la Vieja',
    'Palomas',
    'Parra, La',
    'Peñalsordo',
    'Peraleda del Zaucejo',
    'Puebla de Alcocer',
    'Puebla de la Calzada',
    'Puebla de la Reina',
    'Puebla de Obando',
    'Puebla de Sancho Pérez',
    'Puebla del Maestre',
    'Puebla del Prior',
    'Pueblonuevo del Guadiana',
    'Quintana de la Serena',
    'Reina',
    'Rena',
    'Retamal de Llerena',
    'Ribera del Fresno',
    'Risco',
    'Roca de la Sierra, La',
    'Salvaleón',
    'Salvatierra de los Barros',
    'San Pedro de Mérida',
    'San Vicente de Alcántara',
    'Sancti-Spíritus',
    'Santa Amalia',
    'Santa Marta',
    'Santos de Maimona, Los',
    'Segura de León',
    'Siruela',
    'Solana de los Barros',
    'Talarrubias',
    'Talavera la Real',
    'Táliga',
    'Tamurejo',
    'Torre de Miguel Sesmero',
    'Torremayor',
    'Torremejía',
    'Trasierra',
    'Trujillanos',
    'Usagre',
    'Valdecaballeros',
    'Valdelacalzada',
    'Valdetorres',
    'Valencia de las Torres',
    'Valencia del Mombuey',
    'Valencia del Ventoso',
    'Valle de la Serena',
    'Valle de Matamoros',
    'Valle de Santa Ana',
    'Valverde de Burguillos',
    'Valverde de Leganés',
    'Valverde de Llerena',
    'Valverde de Mérida',
    'Villafranca de los Barros',
    'Villagarcía de la Torre',
    'Villagonzalo',
    'Villalba de los Barros',
    'Villanueva de la Serena',
    'Villanueva del Fresno',
    'Villar de Rena',
    'Villar del Rey',
    'Villarta de los Montes',
    'Zafra',
    'Zahínos',
    'Zalamea de la Serena',
    'Zarza, La',
    'Zarza-Capilla',
  ),
/* Province of Islas Baleares/Illes Balears */
  'PM' => array(
    'Alaior',
    'Alaró',
    'Alcúdia',
    'Algaida',
    'Andratx',
    'Ariany',
    'Artà',
    'Banyalbufar',
    'Binissalem',
    'Búger',
    'Bunyola',
    'Calvià',
    'Campanet',
    'Campos',
    'Capdepera',
    'Castell, Es',
    'Ciutadella de Menorca',
    'Consell',
    'Costitx',
    'Deià',
    'Eivissa',
    'Escorca',
    'Esporles',
    'Estellencs',
    'Felanitx',
    'Ferreries',
    'Formentera',
    'Fornalutx',
    'Inca',
    'Lloret de Vistalegre',
    'Lloseta',
    'Llubí',
    'Llucmajor',
    'Manacor',
    'Mancor de la Vall',
    'Maó-Mahón',
    'Maria de la Salut',
    'Marratxí',
    'Mercadal, Es',
    'Migjorn Gran, Es',
    'Montuïri',
    'Muro',
    'Palma	',
    'Petra',
    'Pobla, Sa',
    'Pollença',
    'Porreres',
    'Puigpunyent',
    'Salines, Ses',
    'Sant Antoni de Portmany',
    'Sant Joan',
    'Sant Joan de Labritja',
    'Sant Josep de sa Talaia',
    'Sant Llorenç des Cardassar',
    'Sant Lluís',
    'Santa Eugènia',
    'Santa Eulària des Riu',
    'Santa Margalida',
    'Santa María del Camí',
    'Santanyí',
    'Selva',
    'Sencelles',
    'Sineu',
    'Sóller',
    'Son Servera',
    'Valldemossa',
    'Vilafranca de Bonany',
  ),
/* Province of Barcelona */
  'B' => array(
    'Abrera',
    'Aguilar de Segarra',
    'Aiguafreda',
    'Alella',
    'Alpens',
    'Ametlla del Vallès, L&#8242;',
    'Arenys de Mar',
    'Arenys de Munt',
    'Argençola',
    'Argentona',
    'Artés',
    'Avià',
    'Avinyó',
    'Avinyonet del Penedès',
    'Badalona',
    'Badia del Vallès',
    'Bagà',
    'Balenyà',
    'Balsareny',
    'Barberà del Vallès',
    'Barcelona',
    'Begues',
    'Bellprat',
    'Berga',
    'Bigues i Riells',
    'Borredà',
    'Bruc, El',
    'Brull, El',
    'Cabanyes, Les',
    'Cabrera d&#8242;Anoia',
    'Cabrera de Mar',
    'Cabrils',
    'Calaf',
    'Calders',
    'Caldes de Montbui',
    'Caldes d&#8242;Estrac',
    'Calella',
    'Calldetenes',
    'Callús',
    'Calonge de Segarra',
    'Campins',
    'Canet de Mar',
    'Canovelles',
    'Cànoves i Samalús',
    'Canyelles',
    'Capellades',
    'Capolat',
    'Cardedeu',
    'Cardona',
    'Carme',
    'Casserres',
    'Castell de l&#8242;Areny',
    'Castellar de n&#8242;Hug',
    'Castellar del Riu',
    'Castellar del Vallès',
    'Castellbell i el Vilar',
    'Castellbisbal',
    'Castellcir',
    'Castelldefels',
    'Castellet i la Gornal',
    'Castellfollit de Riubregós',
    'Castellfollit del Boix',
    'Castellgalí',
    'Castellnou de Bages',
    'Castellolí',
    'Castellterçol',
    'Castellví de la Marca',
    'Castellví de Rosanes',
    'Centelles',
    'Cercs',
    'Cerdanyola del Vallès',
    'Cervelló',
    'Collbató',
    'Collsuspina',
    'Copons',
    'Corbera de Llobregat',
    'Cornellà de Llobregat',
    'Cubelles',
    'Dosrius',
    'Esparreguera',
    'Esplugues de Llobregat',
    'Espunyola, L&#8242;',
    'Esquirol, L&#8242;',
    'Estany, L&#8242;',
    'Figaró-Montmany',
    'Fígols',
    'Fogars de la Selva',
    'Fogars de Montclús',
    'Folgueroles',
    'Fonollosa',
    'Font-rubí',
    'Franqueses del Vallès, Les',
    'Gaià',
    'Gallifa',
    'Garriga, La',
    'Gavà',
    'Gelida',
    'Gironella',
    'Gisclareny',
    'Granada, La',
    'Granera',
    'Granollers',
    'Gualba',
    'Guardiola de Berguedà',
    'Gurb',
    'Hospitalet de Llobregat, L&#8242;',
    'Hostalets de Pierola, Els',
    'Igualada',
    'Jorba',
    'Llacuna, La',
    'Llagosta, La',
    'Lliçà d&#8242;Amunt',
    'Lliçà de Vall',
    'Llinars del Vallès',
    'Lluçà',
    'Malgrat de Mar',
    'Malla',
    'Manlleu',
    'Manresa',
    'Marganell',
    'Martorell',
    'Martorelles',
    'Masies de Roda, Les',
    'Masies de Voltregà, Les',
    'Masnou, El',
    'Masquefa',
    'Matadepera',
    'Mataró',
    'Mediona',
    'Moià',
    'Molins de Rei',
    'Mollet del Vallès',
    'Monistrol de Calders',
    'Monistrol de Montserrat',
    'Montcada i Reixac',
    'Montclar',
    'Montesquiu',
    'Montgat',
    'Montmajor',
    'Montmaneu',
    'Montmeló',
    'Montornès del Vallès',
    'Montseny',
    'Muntanyola',
    'Mura',
    'Navarcles',
    'Navàs',
    'Nou de Berguedà, La',
    'Òdena',
    'Olèrdola',
    'Olesa de Bonesvalls',
    'Olesa de Montserrat',
    'Olivella',
    'Olost',
    'Olvan',
    'Orís',
    'Oristà',
    'Orpí',
    'Òrrius',
    'Pacs del Penedès',
    'Palafolls',
    'Palau-solità i Plegamans',
    'Pallejà',
    'Palma de Cervelló, La',
    'Papiol, El',
    'Parets del Vallès',
    'Perafita',
    'Piera',
    'Pineda de Mar',
    'Pla del Penedès, El',
    'Pobla de Claramunt, La',
    'Pobla de Lillet, La',
    'Polinyà',
    'Pont de Vilomara i Rocafort, El',
    'Pontons',
    'Prat de Llobregat, El',
    'Prats de Lluçanès',
    'Prats de Rei, Els',
    'Premià de Dalt',
    'Premià de Mar',
    'Puigdàlber',
    'Puig-reig',
    'Pujalt',
    'Quar, La',
    'Rajadell',
    'Rellinars',
    'Ripollet',
    'Roca del Vallès, La',
    'Roda de Ter',
    'Rubí',
    'Rubió',
    'Rupit i Pruit',
    'Sabadell',
    'Sagàs',
    'Saldes',
    'Sallent',
    'Sant Adrià de Besòs',
    'Sant Agustí de Lluçanès',
    'Sant Andreu de la Barca',
    'Sant Andreu de Llavaneres',
    'Sant Antoni de Vilamajor',
    'Sant Bartomeu del Grau',
    'Sant Boi de Llobregat',
    'Sant Boi de Lluçanès',
    'Sant Cebrià de Vallalta',
    'Sant Celoni',
    'Sant Climent de Llobregat',
    'Sant Cugat del Vallès',
    'Sant Cugat Sesgarrigues',
    'Sant Esteve de Palautordera',
    'Sant Esteve Sesrovires',
    'Sant Feliu de Codines',
    'Sant Feliu de Llobregat',
    'Sant Feliu Sasserra',
    'Sant Fost de Campsentelles',
    'Sant Fruitós de Bages',
    'Sant Hipòlit de Voltregà',
    'Sant Iscle de Vallalta',
    'Sant Jaume de Frontanyà',
    'Sant Joan de Vilatorrada',
    'Sant Joan Despí',
    'Sant Julià de Cerdanyola',
    'Sant Julià de Vilatorta',
    'Sant Just Desvern',
    'Sant Llorenç d&#8242;Hortons',
    'Sant Llorenç Savall',
    'Sant Martí d&#8242;Albars',
    'Sant Martí de Centelles',
    'Sant Martí de Tous',
    'Sant Martí Sarroca',
    'Sant Martí Sesgueioles',
    'Sant Mateu de Bages',
    'Sant Pere de Ribes',
    'Sant Pere de Riudebitlles',
    'Sant Pere de Torelló',
    'Sant Pere de Vilamajor',
    'Sant Pere Sallavinera',
    'Sant Pol de Mar',
    'Sant Quintí de Mediona',
    'Sant Quirze de Besora',
    'Sant Quirze del Vallès',
    'Sant Quirze Safaja',
    'Sant Sadurní d&#8242;Anoia',
    'Sant Sadurní d&#8242;Osormort',
    'Sant Salvador de Guardiola',
    'Sant Vicenç de Castellet',
    'Sant Vicenç de Montalt',
    'Sant Vicenç de Torelló',
    'Sant Vicenç dels Horts',
    'Santa Cecília de Voltregà',
    'Santa Coloma de Cervelló',
    'Santa Coloma de Gramenet',
    'Santa Eugènia de Berga',
    'Santa Eulàlia de Riuprimer',
    'Santa Eulàlia de Ronçana',
    'Santa Fe del Penedès',
    'Santa Margarida de Montbui',
    'Santa Margarida i els Monjos',
    'Santa Maria de Besora',
    'Santa Maria de Martorelles',
    'Santa Maria de Merlès',
    'Santa Maria de Miralles',
    'Santa Maria de Palautordera',
    'Santa Maria d&#8242;Oló',
    'Santa Perpètua de Mogoda',
    'Santa Susanna',
    'Santpedor',
    'Sentmenat',
    'Seva',
    'Sitges',
    'Sobremunt',
    'Sora',
    'Subirats',
    'Súria',
    'Tagamanent',
    'Talamanca',
    'Taradell',
    'Tavèrnoles',
    'Tavertet',
    'Teià',
    'Terrassa',
    'Tiana',
    'Tona',
    'Tordera',
    'Torelló',
    'Torre de Claramunt, La',
    'Torrelavit',
    'Torrelles de Foix',
    'Torrelles de Llobregat',
    'Ullastrell',
    'Vacarisses',
    'Vallbona d&#8242;Anoia',
    'Vallcebre',
    'Vallgorguina',
    'Vallirana',
    'Vallromanes',
    'Veciana',
    'Vic',
    'Vilada',
    'Viladecans',
    'Viladecavalls',
    'Vilafranca del Penedès',
    'Vilalba Sasserra',
    'Vilanova de Sau',
    'Vilanova del Camí',
    'Vilanova del Vallès',
    'Vilanova i la Geltrú',
    'Vilassar de Dalt',
    'Vilassar de Mar',
    'Vilobí del Penedès',
    'Viver i Serrateix',
  ),
/* Province of Burgos */
  'BU' => array(
    'Abajas',
    'Adrada de Haza',
    'Aguas Cándidas',
    'Aguilar de Bureba',
    'Albillos',
    'Alcocero de Mola',
    'Alfoz de Bricia',
    'Alfoz de Quintanadueñas',
    'Alfoz de Santa Gadea',
    'Altable',
    'Altos, Los',
    'Ameyugo',
    'Anguix',
    'Aranda de Duero',
    'Arandilla',
    'Arauzo de Miel',
    'Arauzo de Salce',
    'Arauzo de Torre',
    'Arcos',
    'Arenillas de Riopisuerga',
    'Arija',
    'Arlanzón',
    'Arraya de Oca',
    'Atapuerca',
    'Ausines, Los',
    'Avellanosa de Muñó',
    'Bahabón de Esgueva',
    'Balbases, Los	',
    'Baños de Valdearados',
    'Bañuelos de Bureba',
    'Barbadillo de Herreros',
    'Barbadillo del Mercado',
    'Barbadillo del Pez',
    'Barrio de Muñó',
    'Barrios de Bureba, Los',
    'Barrios de Colina',
    'Basconcillos del Tozo',
    'Bascuñana',
    'Belbimbre',
    'Belorado',
    'Berberana',
    'Berlangas de Roa',
    'Berzosa de Bureba',
    'Bozoó',
    'Brazacorta',
    'Briviesca',
    'Bugedo',
    'Buniel',
    'Burgos',
    'Busto de Bureba',
    'Cabañes de Esgueva',
    'Cabezón de la Sierra',
    'Caleruega',
    'Campillo de Aranda',
    'Campolara',
    'Canicosa de la Sierra',
    'Cantabrana',
    'Carazo',
    'Carcedo de Bureba',
    'Carcedo de Burgos',
    'Cardeñadijo',
    'Cardeñajimeno',
    'Cardeñuela Riopico',
    'Carrias',
    'Cascajares de Bureba',
    'Cascajares de la Sierra',
    'Castellanos de Castro',
    'Castil de Peones',
    'Castildelgado',
    'Castrillo de la Reina',
    'Castrillo de la Vega',
    'Castrillo de Riopisuerga',
    'Castrillo del Val',
    'Castrillo Mota de Judíos',
    'Castrojeriz',
    'Cavia',
    'Cayuela',
    'Cebrecos',
    'Celada del Camino',
    'Cerezo de Río Tirón',
    'Cerratón de Juarros',
    'Ciadoncha',
    'Cillaperlata',
    'Cilleruelo de Abajo',
    'Cilleruelo de Arriba',
    'Ciruelos de Cervera',
    'Cogollos',
    'Condado de Treviño',
    'Contreras',
    'Coruña del Conde',
    'Covarrubias',
    'Cubillo del Campo',
    'Cubo de Bureba',
    'Cueva de Roa, La',
    'Cuevas de San Clemente',
    'Encío',
    'Espinosa de Cervera',
    'Espinosa de los Monteros',
    'Espinosa del Camino',
    'Estépar',
    'Fontioso',
    'Frandovínez',
    'Fresneda de la Sierra Tirón',
    'Fresneña',
    'Fresnillo de las Dueñas',
    'Fresno de Río Tirón',
    'Fresno de Rodilla',
    'Frías',
    'Fuentebureba',
    'Fuentecén',
    'Fuentelcésped',
    'Fuentelisendo',
    'Fuentemolinos',
    'Fuentenebro',
    'Fuentespina',
    'Galbarros',
    'Gallega, La',
    'Grijalba',
    'Grisaleña',
    'Gumiel de Izán',
    'Gumiel de Mercado',
    'Hacinas',
    'Haza',
    'Hontanas',
    'Hontangas',
    'Hontoria de la Cantera',
    'Hontoria de Valdearados',
    'Hontoria del Pinar',
    'Hormazas, Las',
    'Hornillos del Camino',
    'Horra, La',
    'Hortigüela',
    'Hoyales de Roa',
    'Huérmeces',
    'Huerta de Arriba',
    'Huerta de Rey',
    'Humada',
    'Hurones',
    'Ibeas de Juarros',
    'Ibrillos',
    'Iglesiarrubia',
    'Iglesias',
    'Isar',
    'Itero del Castillo',
    'Jaramillo de la Fuente',
    'Jaramillo Quemado',
    'Junta de Traslaloma',
    'Junta de Villalba de Losa',
    'Jurisdicción de Lara',
    'Jurisdicción de San Zadornil',
    'Lerma',
    'Llano de Bureba',
    'Madrigal del Monte',
    'Madrigalejo del Monte',
    'Mahamud',
    'Mambrilla de Castrejón',
    'Mambrillas de Lara',
    'Mamolar',
    'Manciles',
    'Mazuela',
    'Mecerreyes',
    'Medina de Pomar',
    'Melgar de Fernamental',
    'Merindad de Cuesta-Urria',
    'Merindad de Montija',
    'Merindad de Río Ubierna',
    'Merindad de Sotoscueva',
    'Merindad de Valdeporres',
    'Merindad de Valdivielso',
    'Milagros',
    'Miranda de Ebro',
    'Miraveche',
    'Modúbar de la Emparedada',
    'Monasterio de la Sierra',
    'Monasterio de Rodilla',
    'Moncalvillo',
    'Monterrubio de la Demanda',
    'Montorio',
    'Moradillo de Roa',
    'Nava de Roa',
    'Navas de Bureba',
    'Nebreda',
    'Neila',
    'Olmedillo de Roa',
    'Olmillos de Muñó',
    'Oña',
    'Oquillas',
    'Orbaneja Riopico',
    'Padilla de Abajo',
    'Padilla de Arriba',
    'Padrones de Bureba',
    'Palacios de la Sierra',
    'Palacios de Riopisuerga',
    'Palazuelos de la Sierra',
    'Palazuelos de Muñó',
    'Pampliega',
    'Pancorbo',
    'Pardilla',
    'Partido de la Sierra en Tobalina',
    'Pedrosa de Duero',
    'Pedrosa de Río Úrbel',
    'Pedrosa del Páramo',
    'Pedrosa del Príncipe',
    'Peñaranda de Duero',
    'Peral de Arlanza',
    'Piérnigas',
    'Pineda de la Sierra',
    'Pineda Trasmonte',
    'Pinilla de los Barruecos',
    'Pinilla de los Moros',
    'Pinilla Trasmonte',
    'Poza de la Sal',
    'Prádanos de Bureba',
    'Pradoluengo',
    'Presencio',
    'Puebla de Arganzón, La',
    'Puentedura',
    'Quemada',
    'Quintana del Pidio',
    'Quintanabureba',
    'Quintanaélez',
    'Quintanaortuño',
    'Quintanapalla',
    'Quintanar de la Sierra',
    'Quintanavides',
    'Quintanilla de la Mata',
    'Quintanilla del Agua y Tordueles',
    'Quintanilla del Coco',
    'Quintanilla San García',
    'Quintanilla Vivar',
    'Quintanillas, Las',
    'Rabanera del Pinar',
    'Rábanos',
    'Rabé de las Calzadas',
    'Rebolledo de la Torre',
    'Redecilla del Camino',
    'Redecilla del Campo',
    'Regumiel de la Sierra',
    'Reinoso',
    'Retuerta',
    'Revilla del Campo',
    'Revilla Vallejera',
    'Revilla y Ahedo, La',
    'Revillarruz',
    'Rezmondo',
    'Riocavado de la Sierra',
    'Roa',
    'Rojas',
    'Royuela de Río Franco',
    'Rubena',
    'Rublacedo de Abajo',
    'Rucandio',
    'Salas de Bureba',
    'Salas de los Infantes',
    'Saldaña de Burgos',
    'Salinillas de Bureba',
    'San Adrián de Juarros',
    'San Juan del Monte',
    'San Mamés de Burgos',
    'San Martín de Rubiales',
    'San Millán de Lara',
    'San Vicente del Valle',
    'Santa Cecilia',
    'Santa Cruz de la Salceda',
    'Santa Cruz del Valle Urbión',
    'Santa Gadea del Cid',
    'Santa Inés',
    'Santa María del Campo',
    'Santa María del Invierno',
    'Santa María del Mercadillo',
    'Santa María Rivarredonda',
    'Santa Olalla de Bureba',
    'Santibáñez de Esgueva',
    'Santibáñez del Val',
    'Santo Domingo de Silos',
    'Sargentes de la Lora',
    'Sarracín',
    'Sasamón',
    'Sequera de Haza, La',
    'Solarana',
    'Sordillos',
    'Sotillo de la Ribera',
    'Sotragero',
    'Sotresgudo',
    'Susinos del Páramo',
    'Tamarón',
    'Tardajos',
    'Tejada',
    'Terradillos de Esgueva',
    'Tinieblas de la Sierra',
    'Tobar',
    'Tordómar',
    'Torrecilla del Monte',
    'Torregalindo',
    'Torrelara',
    'Torrepadre',
    'Torresandino',
    'Tórtoles de Esgueva',
    'Tosantos',
    'Trespaderne',
    'Tubilla del Agua',
    'Tubilla del Lago',
    'Úrbel del Castillo',
    'Vadocondes',
    'Valdeande',
    'Valdezate',
    'Valdorros',
    'Vallarta de Bureba',
    'Valle de las Navas',
    'Valle de Losa',
    'Valle de Manzanedo',
    'Valle de Mena',
    'Valle de Oca',
    'Valle de Santibáñez',
    'Valle de Sedano',
    'Valle de Tobalina',
    'Valle de Valdebezana',
    'Valle de Valdelaguna',
    'Valle de Valdelucio',
    'Valle de Zamanzas',
    'Vallejera',
    'Valles de Palenzuela',
    'Valluércanes',
    'Valmala',
    'Vid de Bureba, La',
    'Vid y Barrios, La',
    'Vileña',
    'Villadiego',
    'Villaescusa de Roa',
    'Villaescusa la Sombría',
    'Villaespasa',
    'Villafranca Montes de Oca',
    'Villafruela',
    'Villagalijo',
    'Villagonzalo Pedernales',
    'Villahoz',
    'Villalba de Duero',
    'Villalbilla de Burgos',
    'Villalbilla de Gumiel',
    'Villaldemiro',
    'Villalmanzo',
    'Villamayor de los Montes',
    'Villamayor de Treviño',
    'Villambistia',
    'Villamedianilla',
    'Villamiel de la Sierra',
    'Villangómez',
    'Villanueva de Argaño',
    'Villanueva de Carazo',
    'Villanueva de Gumiel',
    'Villanueva de Teba',
    'Villaquirán de la Puebla',
    'Villaquirán de los Infantes',
    'Villarcayo de Merindad de Castilla la Vieja',
    'Villariezo',
    'Villasandino',
    'Villasur de Herreros',
    'Villatuelda',
    'Villaverde del Monte',
    'Villaverde-Mogina',
    'Villayerno Morquillas',
    'Villazopeque',
    'Villegas',
    'Villoruebo',
    'Viloria de Rioja',
    'Vilviestre del Pinar',
    'Vizcaínos',
    'Zael',
    'Zarzosa de Río Pisuerga',
    'Zazuar',
    'Zuñeda',
  ),
/* Province of Cáceres */
  'CC' => array(
    'Abadía',
    'Abertura',
    'Acebo',
    'Acehúche',
    'Aceituna',
    'Ahigal',
    'Alagón del Río',
    'Albalá',
    'Alcántara',
    'Alcollarín',
    'Alcuéscar',
    'Aldea del Cano',
    'Aldea del Obispo, La',
    'Aldeacentenera',
    'Aldeanueva de la Vera',
    'Aldeanueva del Camino',
    'Aldehuela de Jerte',
    'Alía',
    'Aliseda',
    'Almaraz',
    'Almoharín',
    'Arroyo de la Luz',
    'Arroyomolinos',
    'Arroyomolinos de la Vera',
    'Baños de Montemayor',
    'Barrado',
    'Belvís de Monroy',
    'Benquerencia',
    'Berrocalejo',
    'Berzocana',
    'Bohonal de Ibor',
    'Botija',
    'Brozas',
    'Cabañas del Castillo',
    'Cabezabellosa',
    'Cabezuela del Valle',
    'Cabrero',
    'Cáceres',
    'Cachorrilla',
    'Cadalso',
    'Calzadilla',
    'Caminomorisco',
    'Campillo de Deleitosa',
    'Campo Lugar',
    'Cañamero',
    'Cañaveral',
    'Carbajo',
    'Carcaboso',
    'Carrascalejo',
    'Casar de Cáceres',
    'Casar de Palomero',
    'Casares de las Hurdes',
    'Casas de Don Antonio',
    'Casas de Don Gómez',
    'Casas de Millán',
    'Casas de Miravete',
    'Casas del Castañar',
    'Casas del Monte',
    'Casatejada',
    'Casillas de Coria',
    'Castañar de Ibor',
    'Ceclavín',
    'Cedillo',
    'Cerezo',
    'Cilleros',
    'Collado de la Vera',
    'Conquista de la Sierra',
    'Coria',
    'Cuacos de Yuste',
    'Cumbre, La',
    'Deleitosa',
    'Descargamaría',
    'Eljas',
    'Escurial',
    'Fresnedoso de Ibor',
    'Galisteo',
    'Garciaz',
    'Garganta la Olla',
    'Garganta, La',
    'Gargantilla',
    'Gargüera',
    'Garrovillas de Alconétar',
    'Garvín',
    'Gata',
    'Gordo, El',
    'Granja, La',
    'Guadalupe',
    'Guijo de Coria',
    'Guijo de Galisteo',
    'Guijo de Granadilla',
    'Guijo de Santa Bárbara',
    'Herguijuela',
    'Hernán-Pérez',
    'Herrera de Alcántara',
    'Herreruela',
    'Hervás',
    'Higuera',
    'Hinojal',
    'Holguera',
    'Hoyos',
    'Huélaga',
    'Ibahernando',
    'Jaraicejo',
    'Jaraíz de la Vera',
    'Jarandilla de la Vera',
    'Jarilla',
    'Jerte',
    'Ladrillar',
    'Logrosán',
    'Losar de la Vera',
    'Madrigal de la Vera',
    'Madrigalejo',
    'Madroñera',
    'Majadas',
    'Malpartida de Cáceres',
    'Malpartida de Plasencia',
    'Marchagaz',
    'Mata de Alcántara',
    'Membrío',
    'Mesas de Ibor',
    'Miajadas',
    'Millanes',
    'Mirabel',
    'Mohedas de Granadilla',
    'Monroy',
    'Montánchez',
    'Montehermoso',
    'Moraleja',
    'Morcillo',
    'Navaconcejo',
    'Navalmoral de la Mata',
    'Navalvillar de Ibor',
    'Navas del Madroño',
    'Navezuelas',
    'Nuñomoral',
    'Oliva de Plasencia',
    'Palomero',
    'Pasarón de la Vera',
    'Pedroso de Acim',
    'Peraleda de la Mata',
    'Peraleda de San Román',
    'Perales del Puerto',
    'Pescueza',
    'Pesga, La',
    'Piedras Albas',
    'Pinofranqueado',
    'Piornal',
    'Plasencia',
    'Plasenzuela',
    'Portaje',
    'Portezuelo',
    'Pozuelo de Zarzón',
    'Pueblonuevo de Miramontes',
    'Puerto de Santa Cruz',
    'Rebollar',
    'Riolobos',
    'Robledillo de Gata',
    'Robledillo de la Vera',
    'Robledillo de Trujillo',
    'Robledollano',
    'Romangordo',
    'Rosalejo',
    'Ruanes',
    'Salorino',
    'Salvatierra de Santiago',
    'San Martín de Trevejo',
    'Santa Ana',
    'Santa Cruz de la Sierra',
    'Santa Cruz de Paniagua',
    'Santa Marta de Magasca',
    'Santiago de Alcántara',
    'Santiago del Campo',
    'Santibáñez el Alto',
    'Santibáñez el Bajo',
    'Saucedilla',
    'Segura de Toro',
    'Serradilla',
    'Serrejón',
    'Sierra de Fuentes',
    'Talaván',
    'Talaveruela de la Vera',
    'Talayuela',
    'Tejeda de Tiétar',
    'Tiétar',
    'Toril',
    'Tornavacas',
    'Torno, El',
    'Torre de Don Miguel',
    'Torre de Santa María',
    'Torrecilla de los Ángeles',
    'Torrecillas de la Tiesa',
    'Torrejón el Rubio',
    'Torrejoncillo',
    'Torremenga',
    'Torremocha',
    'Torreorgaz',
    'Torrequemada',
    'Trujillo',
    'Valdastillas',
    'Valdecañas de Tajo',
    'Valdefuentes',
    'Valdehúncar',
    'Valdelacasa de Tajo',
    'Valdemorales',
    'Valdeobispo',
    'Valencia de Alcántara',
    'Valverde de la Vera',
    'Valverde del Fresno',
    'Vegaviana',
    'Viandar de la Vera',
    'Villa del Campo',
    'Villa del Rey',
    'Villamesías',
    'Villamiel',
    'Villanueva de la Sierra',
    'Villanueva de la Vera',
    'Villar de Plasencia',
    'Villar del Pedroso',
    'Villasbuenas de Gata',
    'Zarza de Granadilla',
    'Zarza de Montánchez',
    'Zarza la Mayor',
    'Zorita',
  ),
/* Province of Cádiz */
  'CA' => array(
    'Alcalá de los Gazules',
    'Alcalá del Valle',
    'Algar',
    'Algeciras',
    'Algodonales',
    'Arcos de la Frontera',
    'Barbate',
    'Barrios, Los',
    'Benalup-Casas Viejas',
    'Benaocaz',
    'Bornos',
    'Bosque, El',
    'Cádiz',
    'Castellar de la Frontera',
    'Chiclana de la Frontera',
    'Chipiona',
    'Conil de la Frontera',
    'Espera',
    'Gastor, El',
    'Grazalema',
    'Jerez de la Frontera',
    'Jimena de la Frontera',
    'Línea de la Concepción, La',
    'Medina Sidonia',
    'Olvera',
    'Paterna de Rivera',
    'Prado del Rey',
    'Puerto de Santa María, El',
    'Puerto Real',
    'Puerto Serrano',
    'Rota',
    'San Fernando',
    'San José del Valle',
    'San Martín del Tesorillo',
    'San Roque',
    'Sanlúcar de Barrameda',
    'Setenil de las Bodegas',
    'Tarifa',
    'Torre Alháquime',
    'Trebujena',
    'Ubrique',
    'Vejer de la Frontera',
    'Villaluenga del Rosario',
    'Villamartín',
    'Zahara',
  ),
/* Province of Cantabria */
  'S' => array(
    'Alfoz de Lloredo',
    'Ampuero',
    'Anievas',
    'Arenas de Iguña',
    'Argoños',
    'Arnuero',
    'Arredondo',
    'Astillero, El',
    'Bárcena de Cicero',
    'Bárcena de Pie de Concha',
    'Bareyo',
    'Cabezón de la Sal',
    'Cabezón de Liébana',
    'Cabuérniga',
    'Camaleño',
    'Camargo',
    'Campoo de Enmedio',
    'Campoo de Yuso',
    'Cartes',
    'Castañeda',
    'Castro-Urdiales',
    'Cieza',
    'Cillorigo de Liébana',
    'Colindres',
    'Comillas',
    'Corrales de Buelna, Los',
    'Corvera de Toranzo',
    'Entrambasaguas',
    'Escalante',
    'Guriezo',
    'Hazas de Cesto',
    'Hermandad de Campoo de Suso',
    'Herrerías',
    'Lamasón',
    'Laredo',
    'Liendo',
    'Liérganes',
    'Limpias',
    'Luena',
    'Marina de Cudeyo',
    'Mazcuerras',
    'Medio Cudeyo',
    'Meruelo',
    'Miengo',
    'Miera',
    'Molledo',
    'Noja',
    'Penagos',
    'Peñarrubia',
    'Pesaguero',
    'Pesquera',
    'Piélagos',
    'Polaciones',
    'Polanco',
    'Potes',
    'Puente Viesgo',
    'Ramales de la Victoria',
    'Rasines',
    'Reinosa',
    'Reocín',
    'Ribamontán al Mar',
    'Ribamontán al Monte',
    'Rionansa',
    'Riotuerto',
    'Rozas de Valdearroyo, Las',
    'Ruente',
    'Ruesga',
    'Ruiloba',
    'San Felices de Buelna',
    'San Miguel de Aguayo',
    'San Pedro del Romeral',
    'San Roque de Riomiera',
    'San Vicente de la Barquera',
    'Santa Cruz de Bezana',
    'Santa María de Cayón',
    'Santander',
    'Santillana del Mar',
    'Santiurde de Reinosa',
    'Santiurde de Toranzo',
    'Santoña',
    'Saro',
    'Selaya',
    'Soba',
    'Solórzano',
    'Suances',
    'Tojos, Los',
    'Torrelavega',
    'Tresviso',
    'Tudanca',
    'Udías',
    'Val de San Vicente',
    'Valdáliga',
    'Valdeolea',
    'Valdeprado del Río',
    'Valderredible',
    'Valle de Villaverde',
    'Vega de Liébana',
    'Vega de Pas',
    'Villacarriedo',
    'Villaescusa',
    'Villafufre',
    'Voto',
  ),
/* Province of Catellón/Castelló */
  'CS' => array(
    'Aín',
    'Albocàsser',
    'Alcalà de Xivert',
    'Alcora, L&#8242;',
    'Alcudia de Veo',
    'Alfondeguilla',
    'Algimia de Almonacid',
    'Almassora',
    'Almedíjar',
    'Almenara',
    'Alqueries, Les/Alquerías del Niño Perdido',
    'Altura',
    'Arañuel',
    'Ares del Maestrat',
    'Argelita',
    'Artana',
    'Atzeneta del Maestrat',
    'Ayódar',
    'Azuébar',
    'Barracas',
    'Bejís',
    'Benafer',
    'Benafigos',
    'Benassal',
    'Benicarló',
    'Benicasim/Benicàssim',
    'Benlloc',
    'Betxí',
    'Borriana/Burriana',
    'Borriol',
    'Cabanes',
    'Càlig',
    'Canet lo Roig',
    'Castell de Cabres',
    'Castellfort',
    'Castellnovo',
    'Castelló de la Plana',
    'Castillo de Villamalefa',
    'Catí',
    'Caudiel',
    'Cervera del Maestre',
    'Chilches/Xilxes',
    'Chodos/Xodos',
    'Chóvar',
    'Cinctorres',
    'Cirat',
    'Cortes de Arenoso',
    'Costur',
    'Coves de Vinromà, Les',
    'Culla',
    'Eslida',
    'Espadilla',
    'Fanzara',
    'Figueroles',
    'Forcall',
    'Fuente la Reina',
    'Fuentes de Ayódar',
    'Gaibiel',
    'Geldo',
    'Herbés',
    'Higueras',
    'Jana, La',
    'Jérica',
    'Llosa, La',
    'Llucena/Lucena del Cid',
    'Ludiente',
    'Mata de Morella, La',
    'Matet',
    'Moncofa',
    'Montán',
    'Montanejos',
    'Morella',
    'Navajas',
    'Nules',
    'Olocau del Rey',
    'Onda',
    'Oropesa del Mar/Orpesa',
    'Palanques',
    'Pavías',
    'Peníscola/Peñíscola',
    'Pina de Montalgrao',
    'Pobla de Benifassà, La',
    'Pobla Tornesa, La',
    'Portell de Morella',
    'Puebla de Arenoso',
    'Ribesalbes',
    'Rossell',
    'Sacañet',
    'Salzadella, La',
    'San Rafael del Río',
    'Sant Joan de Moró',
    'Sant Jordi/San Jorge',
    'Sant Mateu',
    'Santa Magdalena de Pulpis',
    'Segorbe',
    'Serratella, La',
    'Sierra Engarcerán',
    'Soneja',
    'Sot de Ferrer',
    'Sueras/Suera',
    'Tales',
    'Teresa',
    'Tírig',
    'Todolella',
    'Toga',
    'Torás',
    'Toro, El',
    'Torralba del Pinar',
    'Torre d&#8242;En Besora, La',
    'Torre d&#8242;En Doménec, La',
    'Torreblanca',
    'Torrechiva',
    'Traiguera',
    'Useras/Useres, Les',
    'Vall d&#8242;Alba',
    'Vall de Almonacid',
    'Vall d&#8242;Uixó, La',
    'Vallat',
    'Vallibona',
    'Vilafamés',
    'Vilafranca/Villafranca del Cid',
    'Vilanova d&#8242;Alcolea',
    'Vilar de Canes',
    'Vila-real',
    'Vilavella, La',
    'Villahermosa del Río',
    'Villamalur',
    'Villanueva de Viver',
    'Villores',
    'Vinaròs',
    'Vistabella del Maestrat',
    'Viver',
    'Xert',
    'Zorita del Maestrazgo',
    'Zucaina',
  ),
/* Province of Ceuta */
  'CE' => array(
    'Ceuta',
  ),
/* Province of Ciudad Real */
  'CR' => array(
    'Abenójar',
    'Agudo',
    'Alamillo',
    'Albaladejo',
    'Alcázar de San Juan',
    'Alcoba',
    'Alcolea de Calatrava',
    'Alcubillas',
    'Aldea del Rey',
    'Alhambra',
    'Almadén',
    'Almadenejos',
    'Almagro',
    'Almedina',
    'Almodóvar del Campo',
    'Almuradiel',
    'Anchuras',
    'Arenales de San Gregorio',
    'Arenas de San Juan',
    'Argamasilla de Alba',
    'Argamasilla de Calatrava',
    'Arroba de los Montes',
    'Ballesteros de Calatrava',
    'Bolaños de Calatrava',
    'Brazatortas',
    'Cabezarados',
    'Cabezarrubias del Puerto',
    'Calzada de Calatrava',
    'Campo de Criptana',
    'Cañada de Calatrava',
    'Caracuel de Calatrava',
    'Carrión de Calatrava',
    'Carrizosa',
    'Castellar de Santiago',
    'Chillón',
    'Ciudad Real',
    'Corral de Calatrava',
    'Cortijos, Los',
    'Cózar',
    'Daimiel',
    'Fernán Caballero',
    'Fontanarejo',
    'Fuencaliente',
    'Fuenllana',
    'Fuente el Fresno',
    'Granátula de Calatrava',
    'Guadalmez',
    'Herencia',
    'Hinojosas de Calatrava',
    'Horcajo de los Montes',
    'Labores, Las',
    'Llanos del Caudillo',
    'Luciana',
    'Malagón',
    'Manzanares',
    'Membrilla',
    'Mestanza',
    'Miguelturra',
    'Montiel',
    'Moral de Calatrava',
    'Navalpino',
    'Navas de Estena',
    'Pedro Muñoz',
    'Picón',
    'Piedrabuena',
    'Poblete',
    'Porzuna',
    'Pozuelo de Calatrava',
    'Pozuelos de Calatrava, Los',
    'Puebla de Don Rodrigo',
    'Puebla del Príncipe',
    'Puerto Lápice',
    'Puertollano',
    'Retuerta del Bullaque',
    'Robledo, El',
    'Ruidera',
    'Saceruela',
    'San Carlos del Valle',
    'San Lorenzo de Calatrava',
    'Santa Cruz de los Cáñamos',
    'Santa Cruz de Mudela',
    'Socuéllamos',
    'Solana del Pino',
    'Solana, La',
    'Terrinches',
    'Tomelloso',
    'Torralba de Calatrava',
    'Torre de Juan Abad',
    'Torrenueva',
    'Valdemanco del Esteras',
    'Valdepeñas',
    'Valenzuela de Calatrava',
    'Villahermosa',
    'Villamanrique',
    'Villamayor de Calatrava',
    'Villanueva de la Fuente',
    'Villanueva de los Infantes',
    'Villanueva de San Carlos',
    'Villar del Pozo',
    'Villarrubia de los Ojos',
    'Villarta de San Juan',
    'Viso del Marqués',
  ),
/* Province of Córdoba */
  'CO' => array(
    'Adamuz',
    'Aguilar de la Frontera',
    'Alcaracejos',
    'Almedinilla',
    'Almodóvar del Río',
    'Añora',
    'Baena',
    'Belalcázar',
    'Belmez',
    'Benamejí',
    'Blázquez, Los',
    'Bujalance',
    'Cabra',
    'Cañete de las Torres',
    'Carcabuey',
    'Cardeña',
    'Carlota, La',
    'Carpio, El',
    'Castro del Río',
    'Conquista',
    'Córdoba',
    'Doña Mencía',
    'Dos Torres',
    'Encinas Reales',
    'Espejo',
    'Espiel',
    'Fernán-Núñez',
    'Fuente Carreteros',
    'Fuente la Lancha',
    'Fuente Obejuna',
    'Fuente Palmera',
    'Fuente-Tójar',
    'Granjuela, La',
    'Guadalcázar',
    'Guijarrosa, La',
    'Guijo, El',
    'Hinojosa del Duque',
    'Hornachuelos',
    'Iznájar',
    'Lucena',
    'Luque',
    'Montalbán de Córdoba',
    'Montemayor',
    'Montilla',
    'Montoro',
    'Monturque',
    'Moriles',
    'Nueva Carteya',
    'Obejo',
    'Palenciana',
    'Palma del Río',
    'Pedro Abad',
    'Pedroche',
    'Peñarroya-Pueblonuevo',
    'Posadas',
    'Pozoblanco',
    'Priego de Córdoba',
    'Puente Genil',
    'Rambla, La',
    'Rute',
    'San Sebastián de los Ballesteros',
    'Santa Eufemia',
    'Santaella',
    'Torrecampo',
    'Valenzuela',
    'Valsequillo',
    'Victoria, La',
    'Villa del Río',
    'Villafranca de Córdoba',
    'Villaharta',
    'Villanueva de Córdoba',
    'Villanueva del Duque',
    'Villanueva del Rey',
    'Villaralto',
    'Villaviciosa de Córdoba',
    'Viso, El',
    'Zuheros',
  ),

/* Province of Cuenca */
  'CU' => array(
    'Abia de la Obispalía',
    'Acebrón, El',
    'Alarcón',
    'Albaladejo del Cuende',
    'Albalate de las Nogueras',
    'Albendea',
    'Alberca de Záncara, La',
    'Alcalá de la Vega',
    'Alcantud',
    'Alcázar del Rey',
    'Alcohujate',
    'Alconchel de la Estrella',
    'Algarra',
    'Aliaguilla',
    'Almarcha, La',
    'Almendros',
    'Almodóvar del Pinar',
    'Almonacid del Marquesado',
    'Altarejos',
    'Arandilla del Arroyo',
    'Arcas',
    'Arcos de la Sierra',
    'Arguisuelas',
    'Arrancacepas',
    'Atalaya del Cañavate',
    'Barajas de Melo',
    'Barchín del Hoyo',
    'Bascuñana de San Pedro',
    'Beamud',
    'Belinchón',
    'Belmonte',
    'Belmontejo',
    'Beteta',
    'Boniches',
    'Buciegas',
    'Buenache de Alarcón',
    'Buenache de la Sierra',
    'Buendía',
    'Campillo de Altobuey',
    'Campillos-Paravientos',
    'Campillos-Sierra',
    'Campos del Paraíso',
    'Canalejas del Arroyo',
    'Cañada del Hoyo',
    'Cañada Juncosa',
    'Cañamares',
    'Cañavate, El',
    'Cañaveras',
    'Cañaveruelas',
    'Cañete',
    'Cañizares',
    'Carboneras de Guadazaón',
    'Cardenete',
    'Carrascosa',
    'Carrascosa de Haro',
    'Casas de Benítez',
    'Casas de Fernando Alonso',
    'Casas de Garcimolina',
    'Casas de Guijarro',
    'Casas de Haro',
    'Casas de los Pinos',
    'Casasimarro',
    'Castejón',
    'Castillejo de Iniesta',
    'Castillejo-Sierra',
    'Castillo de Garcimuñoz',
    'Castillo-Albaráñez',
    'Cervera del Llano',
    'Chillarón de Cuenca',
    'Chumillas',
    'Cierva, La',
    'Cuenca',
    'Cueva del Hierro',
    'Enguídanos',
    'Fresneda de Altarejos',
    'Fresneda de la Sierra',
    'Frontera, La',
    'Fuente de Pedro Naharro',
    'Fuentelespino de Haro',
    'Fuentelespino de Moya',
    'Fuentenava de Jábaga',
    'Fuentes',
    'Fuertescusa',
    'Gabaldón',
    'Garaballa',
    'Gascueña',
    'Graja de Campalbo',
    'Graja de Iniesta',
    'Henarejos',
    'Herrumblar, El',
    'Hinojosa, La',
    'Hinojosos, Los',
    'Hito, El',
    'Honrubia',
    'Hontanaya',
    'Hontecillas',
    'Horcajo de Santiago',
    'Huélamo',
    'Huelves',
    'Huérguina',
    'Huerta de la Obispalía',
    'Huerta del Marquesado',
    'Huete',
    'Iniesta',
    'Laguna del Marquesado',
    'Lagunaseca',
    'Landete',
    'Ledaña',
    'Leganiel',
    'Majadas, Las',
    'Mariana',
    'Masegosa',
    'Mesas, Las',
    'Minglanilla',
    'Mira',
    'Monreal del Llano',
    'Montalbanejo',
    'Montalbo',
    'Monteagudo de las Salinas',
    'Mota de Altarejos',
    'Mota del Cuervo',
    'Motilla del Palancar',
    'Moya',
    'Narboneta',
    'Olivares de Júcar',
    'Olmeda de la Cuesta',
    'Olmeda del Rey',
    'Olmedilla de Alarcón',
    'Olmedilla de Eliz',
    'Osa de la Vega',
    'Pajarón',
    'Pajaroncillo',
    'Palomares del Campo',
    'Palomera',
    'Paracuellos',
    'Paredes',
    'Parra de las Vegas, La',
    'Pedernoso, El',
    'Pedroñeras, Las',
    'Peral, El',
    'Peraleja, La',
    'Pesquera, La',
    'Picazo, El',
    'Pinarejo',
    'Pineda de Gigüela',
    'Piqueras del Castillo',
    'Portalrubio de Guadamejud',
    'Portilla',
    'Poyatos',
    'Pozoamargo',
    'Pozorrubielos de la Mancha',
    'Pozorrubio de Santiago',
    'Pozuelo, El',
    'Priego',
    'Provencio, El',
    'Puebla de Almenara',
    'Puebla del Salvador',
    'Quintanar del Rey',
    'Rada de Haro',
    'Reíllo',
    'Rozalén del Monte',
    'Saceda-Trasierra',
    'Saelices',
    'Salinas del Manzano',
    'Salmeroncillos',
    'Salvacañete',
    'San Clemente',
    'San Lorenzo de la Parrilla',
    'San Martín de Boniches',
    'San Pedro Palmiches',
    'Santa Cruz de Moya',
    'Santa María de los Llanos',
    'Santa María del Campo Rus',
    'Santa María del Val',
    'Sisante',
    'Solera de Gabaldón',
    'Sotorribas',
    'Talayuelas',
    'Tarancón',
    'Tébar',
    'Tejadillos',
    'Tinajas',
    'Torralba',
    'Torrejoncillo del Rey',
    'Torrubia del Campo',
    'Torrubia del Castillo',
    'Tragacete',
    'Tresjuncos',
    'Tribaldos',
    'Uclés',
    'Uña',
    'Valdecolmenas, Los',
    'Valdemeca',
    'Valdemorillo de la Sierra',
    'Valdemoro-Sierra',
    'Valdeolivas',
    'Valdetórtola',
    'Valeras, Las',
    'Valhermoso de la Fuente',
    'Valle de Altomira, El',
    'Valsalobre',
    'Valverde de Júcar',
    'Valverdejo',
    'Vara de Rey',
    'Vega del Codorno',
    'Vellisca',
    'Villaconejos de Trabaque',
    'Villaescusa de Haro',
    'Villagarcía del Llano',
    'Villalba de la Sierra',
    'Villalba del Rey',
    'Villalgordo del Marquesado',
    'Villalpardo',
    'Villamayor de Santiago',
    'Villanueva de Guadamejud',
    'Villanueva de la Jara',
    'Villar de Cañas',
    'Villar de Domingo García',
    'Villar de la Encina',
    'Villar de Olalla',
    'Villar del Humo',
    'Villar del Infantado',
    'Villar y Velasco',
    'Villarejo de Fuentes',
    'Villarejo de la Peñuela',
    'Villarejo-Periesteban',
    'Villares del Saz',
    'Villarrubio',
    'Villarta',
    'Villas de la Ventosa',
    'Villaverde y Pasaconsol',
    'Víllora',
    'Vindel',
    'Yémeda',
    'Zafra de Záncara',
    'Zafrilla',
    'Zarza de Tajo',
    'Zarzuela',
  ),
/* Province of Gerona/Girona */
  'GI' => array(
    'Agullana',
    'Aiguaviva',
    'Albanyà',
    'Albons',
    'Alp',
    'Amer',
    'Anglès',
    'Arbúcies',
    'Argelaguer',
    'Armentera, L&#8242;',
    'Avinyonet de Puigventós',
    'Banyoles',
    'Bàscara',
    'Begur',
    'Bellcaire d&#8242;Empordà',
    'Besalú',
    'Bescanó',
    'Beuda',
    'Bisbal d&#8242;Empordà, La',
    'Biure',
    'Blanes',
    'Boadella i les Escaules',
    'Bolvir',
    'Bordils',
    'Borrassà',
    'Breda',
    'Brunyola i Sant Martí Sapresa',
    'Cabanelles',
    'Cabanes',
    'Cadaqués',
    'Caldes de Malavella',
    'Calonge i Sant Antoni',
    'Camós',
    'Campdevànol',
    'Campelles',
    'Campllong',
    'Camprodon',
    'Canet d&#8242;Adri',
    'Cantallops',
    'Capmany',
    'Cassà de la Selva',
    'Castellfollit de la Roca',
    'Castelló d&#8242;Empúries',
    'Castell-Platja d&#8242;Aro',
    'Cellera de Ter, La',
    'Celrà',
    'Cervià de Ter',
    'Cistella',
    'Colera',
    'Colomers',
    'Corçà',
    'Cornellà del Terri',
    'Crespià',
    'Cruïlles, Monells i Sant Sadurní de l&#8242;Heura',
    'Darnius',
    'Das',
    'Escala, L&#8242;',
    'Espinelves',
    'Espolla',
    'Esponellà',
    'Far d&#8242;Empordà, El',
    'Figueres',
    'Flaçà',
    'Foixà',
    'Fontanals de Cerdanya',
    'Fontanilles',
    'Fontcoberta',
    'Forallac',
    'Fornells de la Selva',
    'Fortià',
    'Garrigàs',
    'Garrigoles',
    'Garriguella',
    'Ger',
    'Girona',
    'Gombrèn',
    'Gualta',
    'Guils de Cerdanya',
    'Hostalric',
    'Isòvol',
    'Jafre',
    'Jonquera, La',
    'Juià',
    'Lladó',
    'Llagostera',
    'Llambilles',
    'Llanars',
    'Llançà',
    'Llers',
    'Llívia',
    'Lloret de Mar',
    'Llosses, Les',
    'Maçanet de Cabrenys',
    'Maçanet de la Selva',
    'Madremanya',
    'Maià de Montcal',
    'Masarac',
    'Massanes',
    'Meranges',
    'Mieres',
    'Mollet de Peralada',
    'Molló',
    'Montagut i Oix',
    'Mont-ras',
    'Navata',
    'Ogassa',
    'Olot',
    'Ordis',
    'Osor',
    'Palafrugell',
    'Palamós',
    'Palau de Santa Eulàlia',
    'Palau-sator',
    'Palau-saverdera',
    'Palol de Revardit',
    'Pals',
    'Pardines',
    'Parlavà',
    'Pau',
    'Pedret i Marzà',
    'Pera, La',
    'Peralada',
    'Planes d&#8242;Hostoles, Les',
    'Planoles',
    'Pont de Molins',
    'Pontós',
    'Porqueres',
    'Port de la Selva, El',
    'Portbou',
    'Preses, Les',
    'Puigcerdà',
    'Quart',
    'Queralbs',
    'Rabós',
    'Regencós',
    'Ribes de Freser',
    'Riells i Viabrea',
    'Ripoll',
    'Riudarenes',
    'Riudaura',
    'Riudellots de la Selva',
    'Riumors',
    'Roses',
    'Rupià',
    'Sales de Llierca',
    'Salt',
    'Sant Andreu Salou',
    'Sant Aniol de Finestres',
    'Sant Climent Sescebes',
    'Sant Feliu de Buixalleu',
    'Sant Feliu de Guíxols',
    'Sant Feliu de Pallerols',
    'Sant Ferriol',
    'Sant Gregori',
    'Sant Hilari Sacalm',
    'Sant Jaume de Llierca',
    'Sant Joan de les Abadesses',
    'Sant Joan de Mollet',
    'Sant Joan les Fonts',
    'Sant Jordi Desvalls',
    'Sant Julià de Ramis',
    'Sant Julià del Llor i Bonmatí',
    'Sant Llorenç de la Muga',
    'Sant Martí de Llémena',
    'Sant Martí Vell',
    'Sant Miquel de Campmajor',
    'Sant Miquel de Fluvià',
    'Sant Mori',
    'Sant Pau de Segúries',
    'Sant Pere Pescador',
    'Santa Coloma de Farners',
    'Santa Cristina d&#8242;Aro',
    'Santa Llogaia d&#8242;Àlguema',
    'Santa Pau',
    'Sarrià de Ter',
    'Saus, Camallera i Llampaies',
    'Selva de Mar, La',
    'Serinyà',
    'Serra de Daró',
    'Setcases',
    'Sils',
    'Siurana',
    'Susqueda',
    'Tallada d&#8242;Empordà, La',
    'Terrades',
    'Torrent',
    'Torroella de Fluvià',
    'Torroella de Montgrí',
    'Tortellà',
    'Toses',
    'Tossa de Mar',
    'Ullà',
    'Ullastret',
    'Ultramort',
    'Urús',
    'Vajol, La',
    'Vall de Bianya, La',
    'Vall d&#8242;en Bas, La',
    'Vallfogona de Ripollès',
    'Vall-llobrega',
    'Ventalló',
    'Verges',
    'Vidrà',
    'Vidreres',
    'Vilabertran',
    'Vilablareix',
    'Viladamat',
    'Viladasens',
    'Vilademuls',
    'Viladrau',
    'Vilafant',
    'Vilajuïga',
    'Vilallonga de Ter',
    'Vilamacolum',
    'Vilamalla',
    'Vilamaniscle',
    'Vilanant',
    'Vila-sacra',
    'Vilaür',
    'Vilobí d&#8242;Onyar',
    'Vilopriu',
  ),
/* Province of Granada */
  'GR' => array(
    'Agrón',
    'Alamedilla',
    'Albolote',
    'Albondón',
    'Albuñán',
    'Albuñol',
    'Albuñuelas',
    'Aldeire',
    'Alfacar',
    'Algarinejo',
    'Alhama de Granada',
    'Alhendín',
    'Alicún de Ortega',
    'Almegíjar',
    'Almuñécar',
    'Alpujarra de la Sierra',
    'Alquife',
    'Arenas del Rey',
    'Armilla',
    'Atarfe',
    'Baza',
    'Beas de Granada',
    'Beas de Guadix',
    'Benalúa',
    'Benalúa de las Villas',
    'Benamaurel',
    'Bérchules',
    'Bubión',
    'Busquístar',
    'Cacín',
    'Cádiar',
    'Cájar',
    'Calahorra, La',
    'Calicasas',
    'Campotéjar',
    'Caniles',
    'Cáñar',
    'Capileira',
    'Carataunas',
    'Cástaras',
    'Castilléjar',
    'Castril',
    'Cenes de la Vega',
    'Chauchina',
    'Chimeneas',
    'Churriana de la Vega',
    'Cijuela',
    'Cogollos de Guadix',
    'Cogollos de la Vega',
    'Colomera',
    'Cortes de Baza',
    'Cortes y Graena',
    'Cuevas del Campo',
    'Cúllar',
    'Cúllar Vega',
    'Darro',
    'Dehesas de Guadix',
    'Dehesas Viejas',
    'Deifontes',
    'Diezma',
    'Dílar',
    'Dólar',
    'Domingo Pérez de Granada',
    'Dúdar',
    'Dúrcal',
    'Escúzar',
    'Ferreira',
    'Fonelas',
    'Fornes',
    'Freila',
    'Fuente Vaqueros',
    'Gabias, Las',
    'Galera',
    'Gobernador',
    'Gójar',
    'Gor',
    'Gorafe',
    'Granada',
    'Guadahortuna',
    'Guadix',
    'Guájares, Los',
    'Gualchos',
    'Güéjar Sierra',
    'Güevéjar',
    'Huélago',
    'Huéneja',
    'Huéscar',
    'Huétor de Santillán',
    'Huétor Tájar',
    'Huétor Vega',
    'Íllora',
    'Ítrabo',
    'Iznalloz',
    'Játar',
    'Jayena',
    'Jérez del Marquesado',
    'Jete',
    'Jun',
    'Juviles',
    'Láchar',
    'Lanjarón',
    'Lanteira',
    'Lecrín',
    'Lentegí',
    'Lobras',
    'Loja',
    'Lugros',
    'Lújar',
    'Malahá, La',
    'Maracena',
    'Marchal',
    'Moclín',
    'Molvízar',
    'Monachil',
    'Montefrío',
    'Montejícar',
    'Montillana',
    'Moraleda de Zafayona',
    'Morelábor',
    'Motril',
    'Murtas',
    'Nevada',
    'Nigüelas',
    'Nívar',
    'Ogíjares',
    'Orce',
    'Órgiva',
    'Otívar',
    'Padul',
    'Pampaneira',
    'Pedro Martínez',
    'Peligros',
    'Peza, La',
    'Pinar, El',
    'Pinos Genil',
    'Pinos Puente',
    'Píñar',
    'Polícar',
    'Polopos',
    'Pórtugos',
    'Puebla de Don Fadrique',
    'Pulianas',
    'Purullena',
    'Quéntar',
    'Rubite',
    'Salar',
    'Salobreña',
    'Santa Cruz del Comercio',
    'Santa Fe',
    'Soportújar',
    'Sorvilán',
    'Taha, La',
    'Torre-Cardela',
    'Torrenueva Costa',
    'Torvizcón',
    'Trevélez',
    'Turón',
    'Ugíjar',
    'Valderrubio',
    'Valle del Zalabí',
    'Valle, El',
    'Válor',
    'Vegas del Genil',
    'Vélez de Benaudalla',
    'Ventas de Huelma',
    'Villa de Otura',
    'Villamena',
    'Villanueva de las Torres',
    'Villanueva Mesía',
    'Víznar',
    'Zafarraya',
    'Zagra',
    'Zubia, La',
    'Zújar',
  ),
/* Province of Guadalajara */
  'GU' => array(
    'Abánades',
    'Ablanque',
    'Adobes',
    'Alaminos',
    'Alarilla',
    'Albalate de Zorita',
    'Albares',
    'Albendiego',
    'Alcocer',
    'Alcolea de las Peñas',
    'Alcolea del Pinar',
    'Alcoroches',
    'Aldeanueva de Guadalajara',
    'Algar de Mesa',
    'Algora',
    'Alhóndiga',
    'Alique',
    'Almadrones',
    'Almoguera',
    'Almonacid de Zorita',
    'Alocén',
    'Alovera',
    'Alustante',
    'Angón',
    'Anguita',
    'Anquela del Ducado',
    'Anquela del Pedregal',
    'Aranzueque',
    'Arbancón',
    'Arbeteta',
    'Argecilla',
    'Armallones',
    'Armuña de Tajuña',
    'Arroyo de las Fraguas',
    'Atanzón',
    'Atienza',
    'Auñón',
    'Azuqueca de Henares',
    'Baides',
    'Baños de Tajo',
    'Bañuelos',
    'Barriopedro',
    'Berninches',
    'Bodera, La',
    'Brihuega',
    'Budia',
    'Bujalaro',
    'Bustares',
    'Cabanillas del Campo',
    'Campillo de Dueñas',
    'Campillo de Ranas',
    'Campisábalos',
    'Canredondo',
    'Cantalojas',
    'Cañizar',
    'Cardoso de la Sierra, El',
    'Casa de Uceda',
    'Casar, El',
    'Casas de San Galindo',
    'Caspueñas',
    'Castejón de Henares',
    'Castellar de la Muela',
    'Castilforte',
    'Castilnuevo',
    'Cendejas de Enmedio',
    'Cendejas de la Torre',
    'Centenera',
    'Checa',
    'Chequilla',
    'Chillarón del Rey',
    'Chiloeches',
    'Cifuentes',
    'Cincovillas',
    'Ciruelas',
    'Ciruelos del Pinar',
    'Cobeta',
    'Cogollor',
    'Cogolludo',
    'Condemios de Abajo',
    'Condemios de Arriba',
    'Congostrina',
    'Copernal',
    'Corduente',
    'Cubillo de Uceda, El',
    'Driebes',
    'Durón',
    'Embid',
    'Escamilla',
    'Escariche',
    'Escopete',
    'Espinosa de Henares',
    'Esplegares',
    'Establés',
    'Estriégana',
    'Fontanar',
    'Fuembellida',
    'Fuencemillán',
    'Fuentelahiguera de Albatages',
    'Fuentelencina',
    'Fuentelsaz',
    'Fuentelviejo',
    'Fuentenovilla',
    'Gajanejos',
    'Galápagos',
    'Galve de Sorbe',
    'Gascueña de Bornova',
    'Guadalajara',
    'Henche',
    'Heras de Ayuso',
    'Herrería',
    'Hiendelaencina',
    'Hijes',
    'Hita',
    'Hombrados',
    'Hontoba',
    'Horche',
    'Hortezuela de Océn',
    'Huerce, La',
    'Huérmeces del Cerro',
    'Huertahernando',
    'Hueva',
    'Humanes',
    'Illana',
    'Iniéstola',
    'Inviernas, Las',
    'Irueste',
    'Jadraque',
    'Jirueque',
    'Ledanca',
    'Loranca de Tajuña',
    'Lupiana',
    'Luzaga',
    'Luzón',
    'Majaelrayo',
    'Málaga del Fresno',
    'Malaguilla',
    'Mandayona',
    'Mantiel',
    'Maranchón',
    'Marchamalo',
    'Masegoso de Tajuña',
    'Matarrubia',
    'Matillas',
    'Mazarete',
    'Mazuecos',
    'Medranda',
    'Megina',
    'Membrillera',
    'Miedes de Atienza',
    'Mierla, La',
    'Millana',
    'Milmarcos',
    'Miñosa, La',
    'Mirabueno',
    'Miralrío',
    'Mochales',
    'Mohernando',
    'Molina de Aragón',
    'Monasterio',
    'Mondéjar',
    'Montarrón',
    'Moratilla de los Meleros',
    'Morenilla',
    'Muduex',
    'Navas de Jadraque, Las',
    'Negredo',
    'Ocentejo',
    'Olivar, El',
    'Olmeda de Cobeta',
    'Olmeda de Jadraque, La',
    'Ordial, El',
    'Orea',
    'Pálmaces de Jadraque',
    'Pardos',
    'Paredes de Sigüenza',
    'Pareja',
    'Pastrana',
    'Pedregal, El',
    'Peñalén',
    'Peñalver',
    'Peralejos de las Truchas',
    'Peralveche',
    'Pinilla de Jadraque',
    'Pinilla de Molina',
    'Pioz',
    'Piqueras',
    'Pobo de Dueñas, El',
    'Poveda de la Sierra',
    'Pozo de Almoguera',
    'Pozo de Guadalajara',
    'Prádena de Atienza',
    'Prados Redondos',
    'Puebla de Beleña',
    'Puebla de Valles',
    'Quer',
    'Rebollosa de Jadraque',
    'Recuenco, El',
    'Renera',
    'Retiendas',
    'Riba de Saelices',
    'Rillo de Gallo',
    'Riofrío del Llano',
    'Robledillo de Mohernando',
    'Robledo de Corpes',
    'Romanillos de Atienza',
    'Romanones',
    'Rueda de la Sierra',
    'Sacecorbo',
    'Sacedón',
    'Saelices de la Sal',
    'Salmerón',
    'San Andrés del Congosto',
    'San Andrés del Rey',
    'Santiuste',
    'Saúca',
    'Sayatón',
    'Selas',
    'Semillas',
    'Setiles',
    'Sienes',
    'Sigüenza',
    'Solanillos del Extremo',
    'Somolinos',
    'Sotillo, El',
    'Sotodosos',
    'Tamajón',
    'Taragudo',
    'Taravilla',
    'Tartanedo',
    'Tendilla',
    'Terzaga',
    'Tierzo',
    'Toba, La',
    'Tordellego',
    'Tordelrábano',
    'Tordesilos',
    'Torija',
    'Torre del Burgo',
    'Torrecuadrada de Molina',
    'Torrecuadradilla',
    'Torrejón del Rey',
    'Torremocha de Jadraque',
    'Torremocha del Campo',
    'Torremocha del Pinar',
    'Torremochuela',
    'Torrubia',
    'Tórtola de Henares',
    'Tortuera',
    'Tortuero',
    'Traíd',
    'Trijueque',
    'Trillo',
    'Uceda',
    'Ujados',
    'Utande',
    'Valdarachas',
    'Valdearenas',
    'Valdeavellano',
    'Valdeaveruelo',
    'Valdeconcha',
    'Valdegrudas',
    'Valdelcubo',
    'Valdenuño Fernández',
    'Valdepeñas de la Sierra',
    'Valderrebollo',
    'Valdesotos',
    'Valfermoso de Tajuña',
    'Valhermoso',
    'Valtablado del Río',
    'Valverde de los Arroyos',
    'Viana de Jadraque',
    'Villanueva de Alcorón',
    'Villanueva de Argecilla',
    'Villanueva de la Torre',
    'Villares de Jadraque',
    'Villaseca de Henares',
    'Villaseca de Uceda',
    'Villel de Mesa',
    'Viñuelas',
    'Yebes',
    'Yebra',
    'Yélamos de Abajo',
    'Yélamos de Arriba',
    'Yunquera de Henares',
    'Yunta, La',
    'Zaorejas',
    'Zarzuela de Jadraque',
    'Zorita de los Canes',
  ),
/* Province of Guipúzcoa/Guipuzkoa */
  'SS' => array(
    'Abaltzisketa',
    'Aduna',
    'Aia',
    'Aizarnazabal',
    'Albiztur',
    'Alegia',
    'Alkiza',
    'Altzaga',
    'Altzo',
    'Amezketa',
    'Andoain',
    'Anoeta',
    'Antzuola',
    'Arama',
    'Aretxabaleta',
    'Arrasate/Mondragón',
    'Asteasu',
    'Astigarraga',
    'Ataun',
    'Azkoitia',
    'Azpeitia',
    'Baliarrain',
    'Beasain',
    'Beizama',
    'Belauntza',
    'Berastegi',
    'Bergara',
    'Berrobi',
    'Bidania-Goiatz',
    'Deba',
    'Donostia/San Sebastián',
    'Eibar',
    'Elduain',
    'Elgeta',
    'Elgoibar',
    'Errenteria',
    'Errezil',
    'Eskoriatza',
    'Ezkio-Itsaso',
    'Gabiria',
    'Gaintza',
    'Gaztelu',
    'Getaria',
    'Hernani',
    'Hernialde',
    'Hondarribia',
    'Ibarra',
    'Idiazabal',
    'Ikaztegieta',
    'Irun',
    'Irura',
    'Itsasondo',
    'Larraul',
    'Lasarte-Oria',
    'Lazkao',
    'Leaburu',
    'Legazpi',
    'Legorreta',
    'Leintz-Gatzaga',
    'Lezo',
    'Lizartza',
    'Mendaro',
    'Mutiloa',
    'Mutriku',
    'Oiartzun',
    'Olaberria',
    'Oñati',
    'Ordizia',
    'Orendain',
    'Orexa',
    'Orio',
    'Ormaiztegi',
    'Pasaia',
    'Segura',
    'Soraluze-Placencia de las Armas',
    'Tolosa',
    'Urnieta',
    'Urretxu',
    'Usurbil',
    'Villabona',
    'Zaldibia',
    'Zarautz',
    'Zegama',
    'Zerain',
    'Zestoa',
    'Zizurkil',
    'Zumaia',
    'Zumarraga',
  ),
/* Province of Huelva */
  'H' => array(
    'Alájar',
    'Aljaraque',
    'Almendro, El',
    'Almonaster la Real',
    'Almonte',
    'Alosno',
    'Aracena',
    'Aroche',
    'Arroyomolinos de León',
    'Ayamonte',
    'Beas',
    'Berrocal',
    'Bollullos Par del Condado',
    'Bonares',
    'Cabezas Rubias',
    'Cala',
    'Calañas',
    'Campillo, El',
    'Campofrío',
    'Cañaveral de León',
    'Cartaya',
    'Castaño del Robledo',
    'Cerro de Andévalo, El',
    'Chucena',
    'Corteconcepción',
    'Cortegana',
    'Cortelazor',
    'Cumbres de Enmedio',
    'Cumbres de San Bartolomé',
    'Cumbres Mayores',
    'Encinasola',
    'Escacena del Campo',
    'Fuenteheridos',
    'Galaroza',
    'Gibraleón',
    'Granada de Río-Tinto, La',
    'Granado, El',
    'Higuera de la Sierra',
    'Hinojales',
    'Hinojos',
    'Huelva',
    'Isla Cristina',
    'Jabugo',
    'Lepe',
    'Linares de la Sierra',
    'Lucena del Puerto',
    'Manzanilla',
    'Marines, Los',
    'Minas de Riotinto',
    'Moguer',
    'Nava, La',
    'Nerva',
    'Niebla',
    'Palma del Condado, La',
    'Palos de la Frontera',
    'Paterna del Campo',
    'Paymogo',
    'Puebla de Guzmán',
    'Puerto Moral',
    'Punta Umbría',
    'Rociana del Condado',
    'Rosal de la Frontera',
    'San Bartolomé de la Torre',
    'San Juan del Puerto',
    'San Silvestre de Guzmán',
    'Sanlúcar de Guadiana',
    'Santa Ana la Real',
    'Santa Bárbara de Casa',
    'Santa Olalla del Cala',
    'Trigueros',
    'Valdelarco',
    'Valverde del Camino',
    'Villablanca',
    'Villalba del Alcor',
    'Villanueva de las Cruces',
    'Villanueva de los Castillejos',
    'Villarrasa',
    'Zalamea la Real',
    'Zarza-Perrunal, La',
    'Zufre',
  ),
/* Province of Huesca */
  'HU' => array(
    'Abiego',
    'Abizanda',
    'Adahuesca',
    'Agüero',
    'Aínsa-Sobrarbe',
    'Aisa',
    'Albalate de Cinca',
    'Albalatillo',
    'Albelda',
    'Albero Alto',
    'Albero Bajo',
    'Alberuela de Tubo',
    'Alcalá de Gurrea',
    'Alcalá del Obispo',
    'Alcampell',
    'Alcolea de Cinca',
    'Alcubierre',
    'Alerre',
    'Alfántega',
    'Almudévar',
    'Almunia de San Juan',
    'Almuniente',
    'Alquézar',
    'Altorricón',
    'Angüés',
    'Ansó',
    'Antillón',
    'Aragüés del Puerto',
    'Arén',
    'Argavieso',
    'Arguis',
    'Ayerbe',
    'Azanuy-Alins',
    'Azara',
    'Azlor',
    'Baélls',
    'Bailo',
    'Baldellou',
    'Ballobar',
    'Banastás',
    'Barbastro',
    'Barbués',
    'Barbuñales',
    'Bárcabo',
    'Belver de Cinca',
    'Benabarre',
    'Benasque',
    'Beranuy',
    'Berbegal',
    'Bielsa',
    'Bierge',
    'Biescas',
    'Binaced',
    'Binéfar',
    'Bisaurri',
    'Biscarrués',
    'Blecua y Torres',
    'Boltaña',
    'Bonansa',
    'Borau',
    'Broto',
    'Caldearenas',
    'Campo',
    'Camporrélls',
    'Canal de Berdún',
    'Candasnos',
    'Canfranc',
    'Capdesaso',
    'Capella',
    'Casbas de Huesca',
    'Castejón de Monegros',
    'Castejón de Sos',
    'Castejón del Puente',
    'Castelflorite',
    'Castiello de Jaca',
    'Castigaleu',
    'Castillazuelo',
    'Castillonroy',
    'Chalamera',
    'Chía',
    'Chimillas',
    'Colungo',
    'Esplús',
    'Estada',
    'Estadilla',
    'Estopiñán del Castillo',
    'Fago',
    'Fanlo',
    'Fiscal',
    'Fonz',
    'Foradada del Toscar',
    'Fraga',
    'Fueva, La',
    'Gistaín',
    'Grado, El',
    'Grañén',
    'Graus',
    'Gurrea de Gállego',
    'Hoz de Jaca',
    'Hoz y Costean',
    'Huerto',
    'Huesca',
    'Ibieca',
    'Igriés',
    'Ilche',
    'Isábena',
    'Jaca',
    'Jasa',
    'Labuerda',
    'Laluenga',
    'Lalueza',
    'Lanaja',
    'Laperdiguera',
    'Lascellas-Ponzano',
    'Lascuarre',
    'Laspaúles',
    'Laspuña',
    'Loarre',
    'Loporzano',
    'Loscorrales',
    'Lupiñén-Ortilla',
    'Monesma y Cajigar',
    'Monflorite-Lascasas',
    'Montanuy',
    'Monzón',
    'Naval',
    'Novales',
    'Nueno',
    'Olvena',
    'Ontiñena',
    'Osso de Cinca',
    'Palo',
    'Panticosa',
    'Peñalba',
    'Peñas de Riglos, Las',
    'Peralta de Alcofea',
    'Peralta de Calasanz',
    'Peraltilla',
    'Perarrúa',
    'Pertusa',
    'Piracés',
    'Plan',
    'Poleñino',
    'Pozán de Vero',
    'Puebla de Castro, La',
    'Puente de Montañana',
    'Puente la Reina de Jaca',
    'Puértolas',
    'Pueyo de Araguás, El',
    'Pueyo de Santa Cruz',
    'Quicena',
    'Robres',
    'Sabiñánigo',
    'Sahún',
    'Salas Altas',
    'Salas Bajas',
    'Salillas',
    'Sallent de Gállego',
    'San Esteban de Litera',
    'San Juan de Plan',
    'San Miguel del Cinca',
    'Sangarrén',
    'Santa Cilia',
    'Santa Cruz de la Serós',
    'Santa María de Dulcis',
    'Santaliestra y San Quílez',
    'Sariñena',
    'Secastilla',
    'Seira',
    'Sena',
    'Senés de Alcubierre',
    'Sesa',
    'Sesué',
    'Siétamo',
    'Sopeira',
    'Sotonera, La',
    'Tamarite de Litera',
    'Tardienta',
    'Tella-Sin',
    'Tierz',
    'Tolva',
    'Torla-Ordesa',
    'Torralba de Aragón',
    'Torre la Ribera',
    'Torrente de Cinca',
    'Torres de Alcanadre',
    'Torres de Barbués',
    'Tramaced',
    'Valfarta',
    'Valle de Bardají',
    'Valle de Hecho',
    'Valle de Lierp',
    'Velilla de Cinca',
    'Vencillón',
    'Viacamp y Litera',
    'Vicién',
    'Villanova',
    'Villanúa',
    'Villanueva de Sigena',
    'Yebra de Basa',
    'Yésero',
    'Zaidín',
  ),
/* Province of Jaén */
  'J' => array(
    'Albanchez de Mágina',
    'Alcalá la Real',
    'Alcaudete',
    'Aldeaquemada',
    'Andújar',
    'Arjona',
    'Arjonilla',
    'Arquillos',
    'Arroyo del Ojanco',
    'Baeza',
    'Bailén',
    'Baños de la Encina',
    'Beas de Segura',
    'Bedmar y Garcíez',
    'Begíjar',
    'Bélmez de la Moraleda',
    'Benatae',
    'Cabra del Santo Cristo',
    'Cambil',
    'Campillo de Arenas',
    'Canena',
    'Carboneros',
    'Cárcheles',
    'Carolina, La',
    'Castellar',
    'Castillo de Locubín',
    'Cazalilla',
    'Cazorla',
    'Chiclana de Segura',
    'Chilluévar',
    'Escañuela',
    'Espeluy',
    'Frailes',
    'Fuensanta de Martos',
    'Fuerte del Rey',
    'Génave',
    'Guardia de Jaén, La',
    'Guarromán',
    'Higuera de Calatrava',
    'Hinojares',
    'Hornos',
    'Huelma',
    'Huesa',
    'Ibros',
    'Iruela, La',
    'Iznatoraf',
    'Jabalquinto',
    'Jaén',
    'Jamilena',
    'Jimena',
    'Jódar',
    'Lahiguera',
    'Larva',
    'Linares',
    'Lopera',
    'Lupión',
    'Mancha Real',
    'Marmolejo',
    'Martos',
    'Mengíbar',
    'Montizón',
    'Navas de San Juan',
    'Noalejo',
    'Orcera',
    'Peal de Becerro',
    'Pegalajar',
    'Porcuna',
    'Pozo Alcón',
    'Puente de Génave',
    'Puerta de Segura, La',
    'Quesada',
    'Rus',
    'Sabiote',
    'Santa Elena',
    'Santiago de Calatrava',
    'Santiago-Pontones',
    'Santisteban del Puerto',
    'Santo Tomé',
    'Segura de la Sierra',
    'Siles',
    'Sorihuela del Guadalimar',
    'Torreblascopedro',
    'Torredelcampo',
    'Torredonjimeno',
    'Torreperogil',
    'Torres',
    'Torres de Albánchez',
    'Úbeda',
    'Valdepeñas de Jaén',
    'Vilches',
    'Villacarrillo',
    'Villanueva de la Reina',
    'Villanueva del Arzobispo',
    'Villardompardo',
    'Villares, Los',
    'Villarrodrigo',
    'Villatorres '
  ),
/* Province of La Rioja */
  'LO' => array(
    'Ábalos',
    'Agoncillo',
    'Aguilar del Río Alhama',
    'Ajamil de Cameros',
    'Albelda de Iregua',
    'Alberite',
    'Alcanadre',
    'Aldeanueva de Ebro',
    'Alesanco',
    'Alesón',
    'Alfaro',
    'Almarza de Cameros',
    'Anguciana',
    'Anguiano',
    'Arenzana de Abajo',
    'Arenzana de Arriba',
    'Arnedillo',
    'Arnedo',
    'Arrúbal',
    'Ausejo',
    'Autol',
    'Azofra',
    'Badarán',
    'Bañares',
    'Baños de Río Tobía',
    'Baños de Rioja',
    'Berceo',
    'Bergasa',
    'Bergasillas Bajera',
    'Bezares',
    'Bobadilla',
    'Brieva de Cameros',
    'Briñas',
    'Briones',
    'Cabezón de Cameros',
    'Calahorra',
    'Camprovín',
    'Canales de la Sierra',
    'Canillas de Río Tuerto',
    'Cañas',
    'Cárdenas',
    'Casalarreina',
    'Castañares de Rioja',
    'Castroviejo',
    'Cellorigo',
    'Cenicero',
    'Cervera del Río Alhama',
    'Cidamón',
    'Cihuri',
    'Cirueña',
    'Clavijo',
    'Cordovín',
    'Corera',
    'Cornago',
    'Corporales',
    'Cuzcurrita de Río Tirón',
    'Daroca de Rioja',
    'Enciso',
    'Entrena',
    'Estollo',
    'Ezcaray',
    'Foncea',
    'Fonzaleche',
    'Fuenmayor',
    'Galbárruli',
    'Galilea',
    'Gallinero de Cameros',
    'Gimileo',
    'Grañón',
    'Grávalos',
    'Haro',
    'Herce',
    'Herramélluri',
    'Hervías',
    'Hormilla',
    'Hormilleja',
    'Hornillos de Cameros',
    'Hornos de Moncalvillo',
    'Huércanos',
    'Igea',
    'Jalón de Cameros',
    'Laguna de Cameros',
    'Lagunilla del Jubera',
    'Lardero',
    'Ledesma de la Cogolla',
    'Leiva',
    'Leza de Río Leza',
    'Logroño',
    'Lumbreras',
    'Manjarrés',
    'Mansilla de la Sierra',
    'Manzanares de Rioja',
    'Matute',
    'Medrano',
    'Munilla',
    'Murillo de Río Leza',
    'Muro de Aguas',
    'Muro en Cameros',
    'Nájera',
    'Nalda',
    'Navajún',
    'Navarrete',
    'Nestares',
    'Nieva de Cameros',
    'Ochánduri',
    'Ocón',
    'Ojacastro',
    'Ollauri',
    'Ortigosa de Cameros',
    'Pazuengos',
    'Pedroso',
    'Pinillos',
    'Pradejón',
    'Pradillo',
    'Préjano',
    'Quel',
    'Rabanera',
    'Rasillo de Cameros, El',
    'Redal, El',
    'Ribafrecha',
    'Rincón de Soto',
    'Robres del Castillo',
    'Rodezno',
    'Sajazarra',
    'San Asensio',
    'San Millán de la Cogolla',
    'San Millán de Yécora',
    'San Román de Cameros',
    'San Torcuato',
    'San Vicente de la Sonsierra',
    'Santa Coloma',
    'Santa Engracia del Jubera',
    'Santa Eulalia Bajera',
    'Santo Domingo de la Calzada',
    'Santurde de Rioja',
    'Santurdejo',
    'Sojuela',
    'Sorzano',
    'Sotés',
    'Soto en Cameros',
    'Terroba',
    'Tirgo',
    'Tobía',
    'Tormantos',
    'Torre en Cameros',
    'Torrecilla en Cameros',
    'Torrecilla sobre Alesanco',
    'Torremontalbo',
    'Treviana',
    'Tricio',
    'Tudelilla',
    'Uruñuela',
    'Valdemadera',
    'Valgañón',
    'Ventosa',
    'Ventrosa',
    'Viguera',
    'Villalba de Rioja',
    'Villalobar de Rioja',
    'Villamediana de Iregua',
    'Villanueva de Cameros',
    'Villar de Arnedo, El',
    'Villar de Torre',
    'Villarejo',
    'Villarroya',
    'Villarta-Quintana',
    'Villavelayo',
    'Villaverde de Rioja',
    'Villoslada de Cameros',
    'Viniegra de Abajo',
    'Viniegra de Arriba',
    'Zarratón',
    'Zarzosa',
    'Zorraquín '
  ),
/* Province of Las Palmas */
  'GC' => array(
    'Agaete',
    'Agüimes',
    'Aldea de San Nicolás, La',
    'Antigua',
    'Arrecife',
    'Artenara',
    'Arucas',
    'Betancuria',
    'Firgas',
    'Gáldar',
    'Haría',
    'Ingenio',
    'Mogán',
    'Moya',
    'Oliva, La',
    'Pájara',
    'Palmas de Gran Canaria, Las',
    'Puerto del Rosario',
    'San Bartolomé',
    'San Bartolomé de Tirajana',
    'Santa Brígida',
    'Santa Lucía de Tirajana',
    'Santa María de Guía de Gran Canaria',
    'Teguise',
    'Tejeda',
    'Telde',
    'Teror',
    'Tías',
    'Tinajo',
    'Tuineje',
    'Valleseco',
    'Valsequillo de Gran Canaria',
    'Vega de San Mateo',
    'Yaiza',
  ),
/* Province of León */
  'LE' => array(
    'Acebedo',
    'Algadefe',
    'Alija del Infantado',
    'Almanza',
    'Antigua, La',
    'Ardón',
    'Arganza',
    'Astorga',
    'Balboa',
    'Bañeza, La',
    'Barjas',
    'Barrios de Luna, Los',
    'Bembibre',
    'Benavides',
    'Benuza',
    'Bercianos del Páramo',
    'Bercianos del Real Camino',
    'Berlanga del Bierzo',
    'Boca de Huérgano',
    'Boñar',
    'Borrenes',
    'Brazuelo',
    'Burgo Ranero, El',
    'Burón',
    'Bustillo del Páramo',
    'Cabañas Raras',
    'Cabreros del Río',
    'Cabrillanes',
    'Cacabelos',
    'Calzada del Coto',
    'Campazas',
    'Campo de Villavidel',
    'Camponaraya',
    'Candín',
    'Cármenes',
    'Carracedelo',
    'Carrizo',
    'Carrocera',
    'Carucedo',
    'Castilfalé',
    'Castrillo de Cabrera',
    'Castrillo de la Valduerna',
    'Castrocalbón',
    'Castrocontrigo',
    'Castropodame',
    'Castrotierra de Valmadrigal',
    'Cea',
    'Cebanico',
    'Cebrones del Río',
    'Chozas de Abajo',
    'Cimanes de la Vega',
    'Cimanes del Tejar',
    'Cistierna',
    'Congosto',
    'Corbillos de los Oteros',
    'Corullón',
    'Crémenes',
    'Cuadros',
    'Cubillas de los Oteros',
    'Cubillas de Rueda',
    'Cubillos del Sil',
    'Destriana',
    'Encinedo',
    'Ercina, La',
    'Escobar de Campos',
    'Fabero',
    'Folgoso de la Ribera',
    'Fresno de la Vega',
    'Fuentes de Carbajal',
    'Garrafe de Torío',
    'Gordaliza del Pino',
    'Gordoncillo',
    'Gradefes',
    'Grajal de Campos',
    'Gusendos de los Oteros',
    'Hospital de Órbigo',
    'Igüeña',
    'Izagre',
    'Joarilla de las Matas',
    'Laguna Dalga',
    'Laguna de Negrillos',
    'León',
    'Llamas de la Ribera',
    'Lucillo',
    'Luyego',
    'Magaz de Cepeda',
    'Mansilla de las Mulas',
    'Mansilla Mayor',
    'Maraña',
    'Matadeón de los Oteros',
    'Matallana de Torío',
    'Matanza',
    'Molinaseca',
    'Murias de Paredes',
    'Noceda del Bierzo',
    'Oencia',
    'Omañas, Las',
    'Onzonilla',
    'Oseja de Sajambre',
    'Pajares de los Oteros',
    'Palacios de la Valduerna',
    'Palacios del Sil',
    'Páramo del Sil',
    'Peranzanes',
    'Pobladura de Pelayo García',
    'Pola de Gordón, La',
    'Ponferrada',
    'Posada de Valdeón',
    'Pozuelo del Páramo',
    'Prado de la Guzpeña',
    'Priaranza del Bierzo',
    'Prioro',
    'Puebla de Lillo',
    'Puente de Domingo Flórez',
    'Quintana del Castillo',
    'Quintana del Marco',
    'Quintana y Congosto',
    'Regueras de Arriba',
    'Reyero',
    'Riaño',
    'Riego de la Vega',
    'Riello',
    'Rioseco de Tapia',
    'Robla, La',
    'Roperuelos del Páramo',
    'Sabero',
    'Sahagún',
    'San Adrián del Valle',
    'San Andrés del Rabanedo',
    'San Cristóbal de la Polantera',
    'San Emiliano',
    'San Esteban de Nogales',
    'San Justo de la Vega',
    'San Millán de los Caballeros',
    'San Pedro Bercianos',
    'Sancedo',
    'Santa Colomba de Curueño',
    'Santa Colomba de Somoza',
    'Santa Cristina de Valmadrigal',
    'Santa Elena de Jamuz',
    'Santa María de la Isla',
    'Santa María de Ordás',
    'Santa María del Monte de Cea',
    'Santa María del Páramo',
    'Santa Marina del Rey',
    'Santas Martas',
    'Santiago Millas',
    'Santovenia de la Valdoncina',
    'Sariegos',
    'Sena de Luna',
    'Sobrado',
    'Soto de la Vega',
    'Soto y Amío',
    'Toral de los Guzmanes',
    'Toral de los Vados',
    'Toreno',
    'Torre del Bierzo',
    'Trabadelo',
    'Truchas',
    'Turcia',
    'Urdiales del Páramo',
    'Val de San Lorenzo',
    'Valdefresno',
    'Valdefuentes del Páramo',
    'Valdelugueros',
    'Valdemora',
    'Valdepiélago',
    'Valdepolo',
    'Valderas',
    'Valderrey',
    'Valderrueda',
    'Valdesamario',
    'Valdevimbre',
    'Valencia de Don Juan',
    'Vallecillo',
    'Valverde de la Virgen',
    'Valverde-Enrique',
    'Vecilla, La',
    'Vega de Espinareda',
    'Vega de Infanzones',
    'Vega de Valcarce',
    'Vegacervera',
    'Vegaquemada',
    'Vegas del Condado',
    'Villablino',
    'Villabraz',
    'Villadangos del Páramo',
    'Villademor de la Vega',
    'Villafranca del Bierzo',
    'Villagatón',
    'Villamandos',
    'Villamanín',
    'Villamañán',
    'Villamartín de Don Sancho',
    'Villamejil',
    'Villamol',
    'Villamontán de la Valduerna',
    'Villamoratiel de las Matas',
    'Villanueva de las Manzanas',
    'Villaobispo de Otero',
    'Villaornate y Castro',
    'Villaquejida',
    'Villaquilambre',
    'Villarejo de Órbigo',
    'Villares de Órbigo',
    'Villasabariego',
    'Villaselán',
    'Villaturiel',
    'Villazala',
    'Villazanzo de Valderaduey',
    'Zotes del Páramo',
  ),
/* Province of Lérida/Lleida */
  'L' => array(
    'Abella de la Conca',
    'Àger',
    'Agramunt',
    'Aitona',
    'Alamús, Els',
    'Alàs i Cerc',
    'Albagés, L&#8242;',
    'Albatàrrec',
    'Albesa',
    'Albi, L&#8242;',
    'Alcanó',
    'Alcarràs',
    'Alcoletge',
    'Alfarràs',
    'Alfés',
    'Algerri',
    'Alguaire',
    'Alins',
    'Almacelles',
    'Almatret',
    'Almenar',
    'Alòs de Balaguer',
    'Alpicat',
    'Alt Àneu',
    'Anglesola',
    'Arbeca',
    'Arres',
    'Arsèguel',
    'Artesa de Lleida',
    'Artesa de Segre',
    'Aspa',
    'Avellanes i Santa Linya, Les',
    'Baix Pallars',
    'Balaguer',
    'Barbens',
    'Baronia de Rialb, La',
    'Bassella',
    'Bausen',
    'Belianes',
    'Bellaguarda',
    'Bellcaire d&#8242;Urgell',
    'Bell-lloc d&#8242;Urgell',
    'Bellmunt d&#8242;Urgell',
    'Bellpuig',
    'Bellver de Cerdanya',
    'Bellvís',
    'Benavent de Segrià',
    'Biosca',
    'Bòrdes, Es',
    'Borges Blanques, Les',
    'Bossòst',
    'Bovera',
    'Cabanabona',
    'Cabó',
    'Camarasa',
    'Canejan',
    'Castell de Mur',
    'Castellar de la Ribera',
    'Castelldans',
    'Castellnou de Seana',
    'Castelló de Farfanya',
    'Castellserà',
    'Cava',
    'Cervera',
    'Cervià de les Garrigues',
    'Ciutadilla',
    'Clariana de Cardener',
    'Cogul, El',
    'Coll de Nargó',
    'Coma i la Pedra, La',
    'Conca de Dalt',
    'Corbins',
    'Cubells',
    'Espluga Calba, L&#8242;',
    'Espot',
    'Estamariu',
    'Estaràs',
    'Esterri d&#8242;Àneu',
    'Esterri de Cardós',
    'Farrera',
    'Fígols i Alinyà',
    'Floresta, La',
    'Fondarella',
    'Foradada',
    'Fuliola, La',
    'Fulleda',
    'Gavet de la Conca',
    'Gimenells i el Pla de la Font',
    'Golmés',
    'Gósol',
    'Granadella, La',
    'Granja d&#8242;Escarp, La',
    'Granyanella',
    'Granyena de les Garrigues',
    'Granyena de Segarra',
    'Guimerà',
    'Guingueta d&#8242;Àneu, La',
    'Guissona',
    'Guixers',
    'Isona i Conca Dellà',
    'Ivars de Noguera',
    'Ivars d&#8242;Urgell',
    'Ivorra',
    'Josa i Tuixén',
    'Juncosa',
    'Juneda',
    'Les',
    'Linyola',
    'Lladorre',
    'Lladurs',
    'Llardecans',
    'Llavorsí',
    'Lleida',
    'Lles de Cerdanya',
    'Llimiana',
    'Llobera',
    'Maials',
    'Maldà',
    'Massalcoreig',
    'Massoteres',
    'Menàrguens',
    'Miralcamp',
    'Mollerussa',
    'Molsosa, La',
    'Montellà i Martinet',
    'Montferrer i Castellbò',
    'Montgai',
    'Montoliu de Lleida',
    'Montoliu de Segarra',
    'Montornès de Segarra',
    'Nalec',
    'Naut Aran',
    'Navès',
    'Odèn',
    'Oliana',
    'Oliola',
    'Olius',
    'Oluges, Les',
    'Omellons, Els',
    'Omells de na Gaia, Els',
    'Organyà',
    'Os de Balaguer',
    'Ossó de Sió',
    'Palau d&#8242;Anglesola, El',
    'Penelles',
    'Peramola',
    'Pinell de Solsonès',
    'Pinós',
    'Plans de Sió, Els',
    'Poal, El',
    'Pobla de Cérvoles, La',
    'Pobla de Segur, La',
    'Pont de Bar, El',
    'Pont de Suert, El',
    'Ponts',
    'Portella, La',
    'Prats i Sansor',
    'Preixana',
    'Preixens',
    'Prullans',
    'Puiggròs',
    'Puigverd d&#8242;Agramunt',
    'Puigverd de Lleida',
    'Rialp',
    'Ribera d&#8242;Ondara',
    'Ribera d&#8242;Urgellet',
    'Riner',
    'Riu de Cerdanya',
    'Rosselló',
    'Salàs de Pallars',
    'Sanaüja',
    'Sant Esteve de la Sarga',
    'Sant Guim de Freixenet',
    'Sant Guim de la Plana',
    'Sant Llorenç de Morunys',
    'Sant Martí de Riucorb',
    'Sant Ramon',
    'Sarroca de Bellera',
    'Sarroca de Lleida',
    'Senterada',
    'Sentiu de Sió, La',
    'Seròs',
    'Seu d&#8242;Urgell, La',
    'Sidamon',
    'Soleràs, El',
    'Solsona',
    'Soriguera',
    'Sort',
    'Soses',
    'Sudanell',
    'Sunyer',
    'Talarn',
    'Talavera',
    'Tàrrega',
    'Tarrés',
    'Tarroja de Segarra',
    'Térmens',
    'Tírvia',
    'Tiurana',
    'Torà',
    'Torms, Els',
    'Tornabous',
    'Torre de Cabdella, La',
    'Torrebesses',
    'Torrefarrera',
    'Torrefeta i Florejacs',
    'Torregrossa',
    'Torrelameu',
    'Torres de Segre',
    'Torre-serona',
    'Tremp',
    'Vall de Boí, La',
    'Vall de Cardós',
    'Vallbona de les Monges',
    'Vallfogona de Balaguer',
    'Valls d&#8242;Aguilar, Les',
    'Valls de Valira, Les',
    'Vansa i Fórnols, La',
    'Verdú',
    'Vielha e Mijaran',
    'Vilagrassa',
    'Vilaller',
    'Vilamòs',
    'Vilanova de Bellpuig',
    'Vilanova de la Barca',
    'Vilanova de l&#8242;Aguda',
    'Vilanova de Meià',
    'Vilanova de Segrià',
    'Vila-sana',
    'Vilosell, El',
    'Vinaixa',
  ),
/* Province of Lugo */
  'LU' => array(
    'Abadín',
    'Alfoz',
    'Antas de Ulla',
    'Baleira',
    'Baralla',
    'Barreiros',
    'Becerreá',
    'Begonte',
    'Bóveda',
    'Burela',
    'Carballedo',
    'Castro de Rei',
    'Castroverde',
    'Cervantes',
    'Cervo',
    'Chantada',
    'Corgo, O',
    'Cospeito',
    'Folgoso do Courel',
    'Fonsagrada, A',
    'Foz',
    'Friol',
    'Guitiriz',
    'Guntín',
    'Incio, O',
    'Láncara',
    'Lourenzá',
    'Lugo',
    'Meira',
    'Mondoñedo',
    'Monforte de Lemos',
    'Monterroso',
    'Muras',
    'Navia de Suarna',
    'Negueira de Muñiz',
    'Nogais, As',
    'Ourol',
    'Outeiro de Rei',
    'Palas de Rei',
    'Pantón',
    'Paradela',
    'Páramo, O',
    'Pastoriza, A',
    'Pedrafita do Cebreiro',
    'Pobra do Brollón, A',
    'Pol',
    'Pontenova, A',
    'Portomarín',
    'Quiroga',
    'Rábade',
    'Ribadeo',
    'Ribas de Sil',
    'Ribeira de Piquín',
    'Riotorto',
    'Samos',
    'Sarria',
    'Saviñao, O',
    'Sober',
    'Taboada',
    'Trabada',
    'Triacastela',
    'Valadouro, O',
    'Vicedo, O',
    'Vilalba',
    'Viveiro',
    'Xermade',
    'Xove',
  ),
/* Province of Madrid */
  'M' => array(
    'Acebeda, La',
    'Ajalvir',
    'Alameda del Valle',
    'Álamo, El',
    'Alcalá de Henares',
    'Alcobendas',
    'Alcorcón',
    'Aldea del Fresno',
    'Algete',
    'Alpedrete',
    'Ambite',
    'Anchuelo',
    'Aranjuez',
    'Arganda del Rey',
    'Arroyomolinos',
    'Atazar, El',
    'Batres',
    'Becerril de la Sierra',
    'Belmonte de Tajo',
    'Berrueco, El',
    'Berzosa del Lozoya',
    'Boadilla del Monte',
    'Boalo, El',
    'Braojos',
    'Brea de Tajo',
    'Brunete',
    'Buitrago del Lozoya',
    'Bustarviejo',
    'Cabanillas de la Sierra',
    'Cabrera, La',
    'Cadalso de los Vidrios',
    'Camarma de Esteruelas',
    'Campo Real',
    'Canencia',
    'Carabaña',
    'Casarrubuelos',
    'Cenicientos',
    'Cercedilla',
    'Cervera de Buitrago',
    'Chapinería',
    'Chinchón',
    'Ciempozuelos',
    'Cobeña',
    'Collado Mediano',
    'Collado Villalba',
    'Colmenar de Oreja',
    'Colmenar del Arroyo',
    'Colmenar Viejo',
    'Colmenarejo',
    'Corpa',
    'Coslada',
    'Cubas de la Sagra',
    'Daganzo de Arriba',
    'Escorial, El',
    'Estremera',
    'Fresnedillas de la Oliva',
    'Fresno de Torote',
    'Fuenlabrada',
    'Fuente el Saz de Jarama',
    'Fuentidueña de Tajo',
    'Galapagar',
    'Garganta de los Montes',
    'Gargantilla del Lozoya y Pinilla de Buitrago',
    'Gascones',
    'Getafe',
    'Griñón',
    'Guadalix de la Sierra',
    'Guadarrama',
    'Hiruela, La',
    'Horcajo de la Sierra-Aoslos',
    'Horcajuelo de la Sierra',
    'Hoyo de Manzanares',
    'Humanes de Madrid',
    'Leganés',
    'Loeches',
    'Lozoya',
    'Lozoyuela-Navas-Sieteiglesias',
    'Madarcos',
    'Madrid',
    'Majadahonda',
    'Manzanares el Real',
    'Meco',
    'Mejorada del Campo',
    'Miraflores de la Sierra',
    'Molar, El',
    'Molinos, Los',
    'Montejo de la Sierra',
    'Moraleja de Enmedio',
    'Moralzarzal',
    'Morata de Tajuña',
    'Móstoles',
    'Navacerrada',
    'Navalafuente',
    'Navalagamella',
    'Navalcarnero',
    'Navarredonda y San Mamés',
    'Navas del Rey',
    'Nuevo Baztán',
    'Olmeda de las Fuentes',
    'Orusco de Tajuña',
    'Paracuellos de Jarama',
    'Parla',
    'Patones',
    'Pedrezuela',
    'Pelayos de la Presa',
    'Perales de Tajuña',
    'Pezuela de las Torres',
    'Pinilla del Valle',
    'Pinto',
    'Piñuécar-Gandullas',
    'Pozuelo de Alarcón',
    'Pozuelo del Rey',
    'Prádena del Rincón',
    'Puebla de la Sierra',
    'Puentes Viejas',
    'Quijorna',
    'Rascafría',
    'Redueña',
    'Ribatejada',
    'Rivas-Vaciamadrid',
    'Robledillo de la Jara',
    'Robledo de Chavela',
    'Robregordo',
    'Rozas de Madrid, Las',
    'Rozas de Puerto Real',
    'San Agustín del Guadalix',
    'San Fernando de Henares',
    'San Lorenzo de El Escorial',
    'San Martín de la Vega',
    'San Martín de Valdeiglesias',
    'San Sebastián de los Reyes',
    'Santa María de la Alameda',
    'Santorcaz',
    'Santos de la Humosa, Los',
    'Serna del Monte, La',
    'Serranillos del Valle',
    'Sevilla la Nueva',
    'Somosierra',
    'Soto del Real',
    'Talamanca de Jarama',
    'Tielmes',
    'Titulcia',
    'Torrejón de Ardoz',
    'Torrejón de la Calzada',
    'Torrejón de Velasco',
    'Torrelaguna',
    'Torrelodones',
    'Torremocha de Jarama',
    'Torres de la Alameda',
    'Tres Cantos',
    'Valdaracete',
    'Valdeavero',
    'Valdelaguna',
    'Valdemanco',
    'Valdemaqueda',
    'Valdemorillo',
    'Valdemoro',
    'Valdeolmos-Alalpardo',
    'Valdepiélagos',
    'Valdetorres de Jarama',
    'Valdilecha',
    'Valverde de Alcalá',
    'Velilla de San Antonio',
    'Vellón, El',
    'Venturada',
    'Villa del Prado',
    'Villaconejos',
    'Villalbilla',
    'Villamanrique de Tajo',
    'Villamanta',
    'Villamantilla',
    'Villanueva de la Cañada',
    'Villanueva de Perales',
    'Villanueva del Pardillo',
    'Villar del Olmo',
    'Villarejo de Salvanés',
    'Villaviciosa de Odón',
    'Villavieja del Lozoya',
    'Zarzalejo',
  ),
/* Province of Málaga */
  'MA' => array(
    'Alfarnatejo',
    'Algarrobo',
    'Algatocín',
    'Alhaurín de la Torre',
    'Alhaurín el Grande',
    'Almáchar',
    'Almargen',
    'Almogía',
    'Álora',
    'Alozaina',
    'Alpandeire',
    'Antequera',
    'Árchez',
    'Archidona',
    'Ardales',
    'Arenas',
    'Arriate',
    'Atajate',
    'Benadalid',
    'Benahavís',
    'Benalauría',
    'Benalmádena',
    'Benamargosa',
    'Benamocarra',
    'Benaoján',
    'Benarrabá',
    'Borge, El',
    'Burgo, El',
    'Campillos',
    'Canillas de Aceituno',
    'Canillas de Albaida',
    'Cañete la Real',
    'Carratraca',
    'Cartajima',
    'Cártama',
    'Casabermeja',
    'Casarabonela',
    'Casares',
    'Coín',
    'Colmenar',
    'Comares',
    'Cómpeta',
    'Cortes de la Frontera',
    'Cuevas Bajas',
    'Cuevas de San Marcos',
    'Cuevas del Becerro',
    'Cútar',
    'Estepona',
    'Faraján',
    'Frigiliana',
    'Fuengirola',
    'Fuente de Piedra',
    'Gaucín',
    'Genalguacil',
    'Guaro',
    'Humilladero',
    'Igualeja',
    'Istán',
    'Iznate',
    'Jimera de Líbar',
    'Jubrique',
    'Júzcar',
    'Macharaviaya',
    'Málaga',
    'Manilva',
    'Marbella',
    'Mijas',
    'Moclinejo',
    'Mollina',
    'Monda',
    'Montecorto',
    'Montejaque',
    'Nerja',
    'Ojén',
    'Parauta',
    'Periana',
    'Pizarra',
    'Pujerra',
    'Rincón de la Victoria',
    'Riogordo',
    'Ronda',
    'Salares',
    'Sayalonga',
    'Sedella',
    'Serrato',
    'Sierra de Yeguas',
    'Teba',
    'Tolox',
    'Torremolinos',
    'Torrox',
    'Totalán',
    'Valle de Abdalajís',
    'Vélez-Málaga',
    'Villanueva de Algaidas',
    'Villanueva de la Concepción',
    'Villanueva de Tapia',
    'Villanueva del Rosario',
    'Villanueva del Trabuco',
    'Viñuela',
    'Yunquera',
  ),
/* Province of Melilla */
  'ML' => array(
    'Melilla',
  ),
/* Province of Murcia */
  'MU' => array(
    'Abanilla',
    'Abarán',
    'Águilas',
    'Albudeite',
    'Alcantarilla',
    'Alcázares, Los',
    'Aledo',
    'Alguazas',
    'Alhama de Murcia',
    'Archena',
    'Beniel',
    'Blanca',
    'Bullas',
    'Calasparra',
    'Campos del Río',
    'Caravaca de la Cruz',
    'Cartagena',
    'Cehegín',
    'Ceutí',
    'Cieza',
    'Fortuna',
    'Fuente Álamo de Murcia',
    'Jumilla',
    'Librilla',
    'Lorca',
    'Lorquí',
    'Mazarrón',
    'Molina de Segura',
    'Moratalla',
    'Mula',
    'Murcia',
    'Ojós',
    'Pliego',
    'Puerto Lumbreras',
    'Ricote',
    'San Javier',
    'San Pedro del Pinatar',
    'Santomera',
    'Torre-Pacheco',
    'Torres de Cotillas, Las',
    'Totana',
    'Ulea',
    'Unión, La',
    'Villanueva del Río Segura',
    'Yecla',
  ),
/* Province of Navarra */
  'NA' => array(
    'Abáigar',
    'Abárzuza/Abartzuza',
    'Abaurregaina/Abaurrea Alta',
    'Abaurrepea/Abaurrea Baja',
    'Aberin',
    'Ablitas',
    'Adiós',
    'Aguilar de Codés',
    'Aibar/Oibar',
    'Allín/Allin',
    'Allo',
    'Altsasu/Alsasua',
    'Améscoa Baja',
    'Ancín/Antzin',
    'Andosilla',
    'Ansoáin/Antsoain',
    'Anue',
    'Añorbe',
    'Aoiz/Agoitz',
    'Araitz',
    'Arakil',
    'Aranarache/Aranaratxe',
    'Aranguren',
    'Arano',
    'Arantza',
    'Aras',
    'Arbizu',
    'Arce/Artzi',
    'Arcos, Los',
    'Arellano',
    'Areso',
    'Arguedas',
    'Aria',
    'Aribe',
    'Armañanzas',
    'Arróniz',
    'Arruazu',
    'Artajona',
    'Artazu',
    'Atez/Atetz',
    'Auritz/Burguete',
    'Ayegui/Aiegi',
    'Azagra',
    'Azuelo',
    'Bakaiku',
    'Barañáin/Barañain',
    'Barásoain',
    'Barbarin',
    'Bargota',
    'Barillas',
    'Basaburua',
    'Baztan',
    'Beintza-Labaien',
    'Beire',
    'Belascoáin',
    'Bera',
    'Berbinzana',
    'Beriáin',
    'Berrioplano/Berriobeiti',
    'Berriozar',
    'Bertizarana',
    'Betelu',
    'Bidaurreta',
    'Biurrun-Olcoz',
    'Buñuel',
    'Burgui/Burgi',
    'Burlada/Burlata',
    'Busto, El',
    'Cabanillas',
    'Cabredo',
    'Cadreita',
    'Caparroso',
    'Cárcar',
    'Carcastillo',
    'Cascante',
    'Cáseda',
    'Castejón',
    'Castillonuevo',
    'Cendea de Olza/Oltza Zendea',
    'Cintruénigo',
    'Cirauqui/Zirauki',
    'Ciriza/Ziritza',
    'Cizur',
    'Corella',
    'Cortes',
    'Desojo',
    'Dicastillo',
    'Donamaria',
    'Doneztebe/Santesteban',
    'Echarri/Etxarri',
    'Elgorriaga',
    'Enériz/Eneritz',
    'Eratsun',
    'Ergoiena',
    'Erro',
    'Eslava',
    'Esparza de Salazar/Espartza Zaraitzu',
    'Espronceda',
    'Estella-Lizarra',
    'Esteribar',
    'Etayo',
    'Etxalar',
    'Etxarri Aranatz',
    'Etxauri',
    'Eulate',
    'Ezcabarte',
    'Ezcároz/Ezkaroze',
    'Ezkurra',
    'Ezprogui',
    'Falces',
    'Fitero',
    'Fontellas',
    'Funes',
    'Fustiñana',
    'Galar',
    'Gallipienzo/Galipentzu',
    'Gallués/Galoze',
    'Garaioa',
    'Garde',
    'Garínoain',
    'Garralda',
    'Genevilla',
    'Goizueta',
    'Goñi',
    'Güesa/Gorza',
    'Guesálaz/Gesalatz',
    'Guirguillano',
    'Hiriberri/Villanueva de Aezkoa',
    'Huarte/Uharte',
    'Ibargoiti',
    'Igantzi',
    'Igúzquiza',
    'Imotz',
    'Irañeta',
    'Irurtzun',
    'Isaba/Izaba',
    'Ituren',
    'Iturmendi',
    'Iza/Itza',
    'Izagaondoa',
    'Izalzu/Itzaltzu',
    'Jaurrieta',
    'Javier',
    'Juslapeña',
    'Lakuntza',
    'Lana',
    'Lantz',
    'Lapoblación',
    'Larraga',
    'Larraona',
    'Larraun',
    'Lazagurría',
    'Leache/Leatxe',
    'Legarda',
    'Legaria',
    'Leitza',
    'Lekunberri',
    'Leoz/Leotz',
    'Lerga',
    'Lerín',
    'Lesaka',
    'Lezaun',
    'Liédena',
    'Lizoáin-Arriasgoiti',
    'Lodosa',
    'Lónguida/Longida',
    'Lumbier',
    'Luquin',
    'Luzaide/Valcarlos',
    'Mañeru',
    'Marañón',
    'Marcilla',
    'Mélida',
    'Mendavia',
    'Mendaza',
    'Mendigorria',
    'Metauten',
    'Milagro',
    'Mirafuentes',
    'Miranda de Arga',
    'Monreal/Elo',
    'Monteagudo',
    'Morentin',
    'Mues',
    'Murchante',
    'Murieta',
    'Murillo el Cuende',
    'Murillo el Fruto',
    'Muruzábal',
    'Navascués/Nabaskoze',
    'Nazar',
    'Noáin (Valle de Elorz)/Noain (Elortzibar)',
    'Obanos',
    'Ochagavía/Otsagabia',
    'Oco',
    'Odieta',
    'Oiz',
    'Olaibar',
    'Olazti/Olazagutía',
    'Olejua',
    'Olite/Erriberri',
    'Olóriz/Oloritz',
    'Orbaizeta',
    'Orbara',
    'Orísoain',
    'Orkoien',
    'Oronz/Orontze',
    'Oroz-Betelu/Orotz-Betelu',
    'Orreaga/Roncesvalles',
    'Oteiza',
    'Pamplona/Iruña',
    'Peralta/Azkoien',
    'Petilla de Aragón',
    'Piedramillera',
    'Pitillas',
    'Puente la Reina/Gares',
    'Pueyo',
    'Ribaforada',
    'Romanzado',
    'Roncal/Erronkari',
    'Sada',
    'Saldías',
    'Salinas de Oro/Jaitz',
    'San Adrián',
    'San Martín de Unx',
    'Sangüesa/Zangoza',
    'Sansol',
    'Santacara',
    'Sarriés/Sartze',
    'Sartaguda',
    'Sesma',
    'Sorlada',
    'Sunbilla',
    'Tafalla',
    'Tiebas-Muruarte de Reta',
    'Tirapu',
    'Torralba del Río',
    'Torres del Río',
    'Tudela',
    'Tulebras',
    'Ucar',
    'Uharte Arakil',
    'Ujué/Uxue',
    'Ultzama',
    'Unciti',
    'Unzué/Untzue',
    'Urdazubi/Urdax',
    'Urdiain',
    'Urraul Alto',
    'Urraul Bajo',
    'Urroz',
    'Urroz-Villa',
    'Urzainqui/Urzainki',
    'Uterga',
    'Uztárroz/Uztarroze',
    'Valle de Egüés/Eguesibar',
    'Valle de Ollo/Ollaran',
    'Valle de Yerri/Deierri',
    'Valtierra',
    'Viana',
    'Vidángoz/Bidankoze',
    'Villafranca',
    'Villamayor de Monjardín',
    'Villatuerta',
    'Villava/Atarrabia',
    'Yesa',
    'Zabalza/Zabaltza',
    'Ziordia',
    'Zizur Mayor/Zizur Nagusia',
    'Zubieta',
    'Zugarramurdi',
    'Zúñiga',
  ),
/* Province of Orense/Ourense */
  'OR' => array(
    'Allariz',
    'Amoeiro',
    'Arnoia, A',
    'Avión',
    'Baltar',
    'Bande',
    'Baños de Molgas',
    'Barbadás',
    'Barco de Valdeorras, O',
    'Beade',
    'Beariz',
    'Blancos, Os',
    'Boborás',
    'Bola, A',
    'Bolo, O',
    'Calvos de Randín',
    'Carballeda de Avia',
    'Carballeda de Valdeorras',
    'Carballiño, O',
    'Cartelle',
    'Castrelo de Miño',
    'Castrelo do Val',
    'Castro Caldelas',
    'Celanova',
    'Cenlle',
    'Chandrexa de Queixa',
    'Coles',
    'Cortegada',
    'Cualedro',
    'Entrimo',
    'Esgos',
    'Gomesende',
    'Gudiña, A',
    'Irixo, O',
    'Larouco',
    'Laza',
    'Leiro',
    'Lobeira',
    'Lobios',
    'Maceda',
    'Manzaneda',
    'Maside',
    'Melón',
    'Merca, A',
    'Mezquita, A',
    'Montederramo',
    'Monterrei',
    'Muíños',
    'Nogueira de Ramuín',
    'Oímbra',
    'Ourense',
    'Paderne de Allariz',
    'Padrenda',
    'Parada de Sil',
    'Pereiro de Aguiar, O',
    'Peroxa, A',
    'Petín',
    'Piñor',
    'Pobra de Trives, A',
    'Pontedeva',
    'Porqueira',
    'Punxín',
    'Quintela de Leirado',
    'Rairiz de Veiga',
    'Ramirás',
    'Ribadavia',
    'Riós',
    'Rúa, A',
    'Rubiá',
    'San Amaro',
    'San Cibrao das Viñas',
    'San Cristovo de Cea',
    'San Xoán de Río',
    'Sandiás',
    'Sarreaus',
    'Taboadela',
    'Teixeira, A',
    'Toén',
    'Trasmiras',
    'Veiga, A',
    'Verea',
    'Verín',
    'Viana do Bolo',
    'Vilamarín',
    'Vilamartín de Valdeorras',
    'Vilar de Barrio',
    'Vilar de Santos',
    'Vilardevós',
    'Vilariño de Conso',
    'Xinzo de Limia',
    'Xunqueira de Ambía',
    'Xunqueira de Espadanedo',
  ),
/* Province of Palencia */
  'P' => array(
    'Abarca de Campos',
    'Abia de las Torres',
    'Aguilar de Campoo',
    'Alar del Rey',
    'Alba de Cerrato',
    'Amayuelas de Arriba',
    'Ampudia',
    'Amusco',
    'Antigüedad',
    'Arconada',
    'Astudillo',
    'Autilla del Pino',
    'Autillo de Campos',
    'Ayuela',
    'Baltanás',
    'Baquerín de Campos',
    'Bárcena de Campos',
    'Barruelo de Santullán',
    'Báscones de Ojeda',
    'Becerril de Campos',
    'Belmonte de Campos',
    'Berzosilla',
    'Boada de Campos',
    'Boadilla de Rioseco',
    'Boadilla del Camino',
    'Brañosera',
    'Buenavista de Valdavia',
    'Bustillo de la Vega',
    'Bustillo del Páramo de Carrión',
    'Calahorra de Boedo',
    'Calzada de los Molinos',
    'Capillas',
    'Cardeñosa de Volpejera',
    'Carrión de los Condes',
    'Castil de Vela',
    'Castrejón de la Peña',
    'Castrillo de Don Juan',
    'Castrillo de Onielo',
    'Castrillo de Villavega',
    'Castromocho',
    'Cervatos de la Cueza',
    'Cervera de Pisuerga',
    'Cevico de la Torre',
    'Cevico Navero',
    'Cisneros',
    'Cobos de Cerrato',
    'Collazos de Boedo',
    'Congosto de Valdavia',
    'Cordovilla la Real',
    'Cubillas de Cerrato',
    'Dehesa de Montejo',
    'Dehesa de Romanos',
    'Dueñas',
    'Espinosa de Cerrato',
    'Espinosa de Villagonzalo',
    'Frechilla',
    'Fresno del Río',
    'Frómista',
    'Fuentes de Nava',
    'Fuentes de Valdepero',
    'Grijota',
    'Guardo',
    'Guaza de Campos',
    'Hérmedes de Cerrato',
    'Herrera de Pisuerga',
    'Herrera de Valdecañas',
    'Hontoria de Cerrato',
    'Hornillos de Cerrato',
    'Husillos',
    'Itero de la Vega',
    'Lagartos',
    'Lantadilla',
    'Ledigos',
    'Loma de Ucieza',
    'Lomas',
    'Magaz de Pisuerga',
    'Manquillos',
    'Mantinos',
    'Marcilla de Campos',
    'Mazariegos',
    'Mazuecos de Valdeginate',
    'Melgar de Yuso',
    'Meneses de Campos',
    'Micieces de Ojeda',
    'Monzón de Campos',
    'Moratinos',
    'Mudá',
    'Nogal de las Huertas',
    'Olea de Boedo',
    'Olmos de Ojeda',
    'Osornillo',
    'Osorno la Mayor',
    'Palencia',
    'Palenzuela',
    'Páramo de Boedo',
    'Paredes de Nava',
    'Payo de Ojeda',
    'Pedraza de Campos',
    'Pedrosa de la Vega',
    'Perales',
    'Pernía, La',
    'Pino del Río',
    'Piña de Campos',
    'Población de Arroyo',
    'Población de Campos',
    'Población de Cerrato',
    'Polentinos',
    'Pomar de Valdivia',
    'Poza de la Vega',
    'Pozo de Urama',
    'Prádanos de Ojeda',
    'Puebla de Valdavia, La',
    'Quintana del Puente',
    'Quintanilla de Onsoña',
    'Reinoso de Cerrato',
    'Renedo de la Vega',
    'Requena de Campos',
    'Respenda de la Peña',
    'Revenga de Campos',
    'Revilla de Collazos',
    'Ribas de Campos',
    'Riberos de la Cueza',
    'Saldaña',
    'Salinas de Pisuerga',
    'San Cebrián de Campos',
    'San Cebrián de Mudá',
    'San Cristóbal de Boedo',
    'San Mamés de Campos',
    'San Román de la Cuba',
    'Santa Cecilia del Alcor',
    'Santa Cruz de Boedo',
    'Santervás de la Vega',
    'Santibáñez de Ecla',
    'Santibáñez de la Peña',
    'Santoyo',
    'Serna, La',
    'Soto de Cerrato',
    'Sotobañado y Priorato',
    'Tabanera de Cerrato',
    'Tabanera de Valdavia',
    'Támara de Campos',
    'Tariego de Cerrato',
    'Torquemada',
    'Torremormojón',
    'Triollo',
    'Valbuena de Pisuerga',
    'Valdeolmillos',
    'Valderrábano',
    'Valde-Ucieza',
    'Valle de Cerrato',
    'Valle del Retortillo',
    'Velilla del Río Carrión',
    'Venta de Baños',
    'Vertavillo',
    'Vid de Ojeda, La',
    'Villabasta de Valdavia',
    'Villacidaler',
    'Villaconancio',
    'Villada',
    'Villaeles de Valdavia',
    'Villahán',
    'Villaherreros',
    'Villalaco',
    'Villalba de Guardo',
    'Villalcázar de Sirga',
    'Villalcón',
    'Villalobón',
    'Villaluenga de la Vega',
    'Villamartín de Campos',
    'Villamediana',
    'Villameriel',
    'Villamoronta',
    'Villamuera de la Cueza',
    'Villamuriel de Cerrato',
    'Villanueva del Rebollar',
    'Villanuño de Valdavia',
    'Villaprovedo',
    'Villarmentero de Campos',
    'Villarrabé',
    'Villarramiel',
    'Villasarracino',
    'Villasila de Valdavia',
    'Villaturde',
    'Villaumbrales',
    'Villaviudas',
    'Villerías de Campos',
    'Villodre',
    'Villodrigo',
    'Villoldo',
    'Villota del Páramo',
    'Villovieco',
  ),
/* Province of Pontevedra */
  'PO' => array(
    'Agolada',
    'Arbo',
    'Baiona',
    'Barro',
    'Bueu',
    'Caldas de Reis',
    'Cambados',
    'Campo Lameiro',
    'Cangas',
    'Cañiza, A',
    'Catoira',
    'Cerdedo-Cotobade',
    'Covelo',
    'Crecente',
    'Cuntis',
    'Dozón',
    'Estrada, A',
    'Forcarei',
    'Fornelos de Montes',
    'Gondomar',
    'Grove, O',
    'Guarda, A',
    'Illa de Arousa, A',
    'Lalín',
    'Lama, A',
    'Marín',
    'Meaño',
    'Meis',
    'Moaña',
    'Mondariz',
    'Mondariz-Balneario',
    'Moraña',
    'Mos',
    'Neves, As',
    'Nigrán',
    'Oia',
    'Pazos de Borbén',
    'Poio',
    'Ponte Caldelas',
    'Ponteareas',
    'Pontecesures',
    'Pontevedra',
    'Porriño, O',
    'Portas',
    'Redondela',
    'Ribadumia',
    'Rodeiro',
    'Rosal, O',
    'Salceda de Caselas',
    'Salvaterra de Miño',
    'Sanxenxo',
    'Silleda',
    'Soutomaior',
    'Tomiño',
    'Tui',
    'Valga',
    'Vigo',
    'Vila de Cruces',
    'Vilaboa',
    'Vilagarcía de Arousa',
    'Vilanova de Arousa',
  ),
/* Province of Salamanca */
  'SA' => array(
    'Abusejo',
    'Agallas',
    'Ahigal de los Aceiteros',
    'Ahigal de Villarino',
    'Alameda de Gardón, La',
    'Alamedilla,La	',
    'Alaraz',
    'Alba de Tormes',
    'Alba de Yeltes',
    'Alberca, La',
    'Alberguería de Argañán, La',
    'Alconada',
    'Aldea del Obispo',
    'Aldeacipreste',
    'Aldeadávila de la Ribera',
    'Aldealengua',
    'Aldeanueva de Figueroa',
    'Aldeanueva de la Sierra',
    'Aldearrodrigo',
    'Aldearrubia',
    'Aldeaseca de Alba',
    'Aldeaseca de la Frontera',
    'Aldeatejada',
    'Aldeavieja de Tormes',
    'Aldehuela de la Bóveda',
    'Aldehuela de Yeltes',
    'Almenara de Tormes',
    'Almendra',
    'Anaya de Alba',
    'Añover de Tormes',
    'Arabayona de Mógica',
    'Arapiles',
    'Arcediano',
    'Arco, El',
    'Armenteros',
    'Atalaya, La',
    'Babilafuente',
    'Bañobárez',
    'Barbadillo',
    'Barbalos',
    'Barceo',
    'Barruecopardo',
    'Bastida, La',
    'Béjar',
    'Beleña',
    'Bermellar',
    'Berrocal de Huebra',
    'Berrocal de Salvatierra',
    'Boada',
    'Bodón, El',
    'Bogajo',
    'Bouza, La',
    'Bóveda del Río Almar',
    'Brincones',
    'Buenamadre',
    'Buenavista',
    'Cabaco, El',
    'Cabeza de Béjar, La',
    'Cabeza del Caballo',
    'Cabezabellosa de la Calzada',
    'Cabrerizos',
    'Cabrillas',
    'Calvarrasa de Abajo',
    'Calvarrasa de Arriba',
    'Calzada de Béjar, La',
    'Calzada de Don Diego',
    'Calzada de Valdunciel',
    'Campillo de Azaba',
    'Campo de Peñaranda, El',
    'Candelario',
    'Canillas de Abajo',
    'Cantagallo',
    'Cantalapiedra',
    'Cantalpino',
    'Cantaracillo',
    'Carbajosa de la Sagrada',
    'Carpio de Azaba',
    'Carrascal de Barregas',
    'Carrascal del Obispo',
    'Casafranca',
    'Casas del Conde, Las',
    'Casillas de Flores',
    'Castellanos de Moriscos',
    'Castellanos de Villiquera',
    'Castillejo de Martín Viejo',
    'Castraz',
    'Cepeda',
    'Cereceda de la Sierra',
    'Cerezal de Peñahorcada',
    'Cerralbo',
    'Cerro, El',
    'Cespedosa de Tormes',
    'Chagarcía Medianero',
    'Cilleros de la Bastida',
    'Cipérez',
    'Ciudad Rodrigo',
    'Coca de Alba',
    'Colmenar de Montemayor',
    'Cordovilla',
    'Cristóbal',
    'Cubo de Don Sancho, El',
    'Dios le Guarde',
    'Doñinos de Ledesma',
    'Doñinos de Salamanca',
    'Éjeme',
    'Encina de San Silvestre',
    'Encina, La',
    'Encinas de Abajo',
    'Encinas de Arriba',
    'Encinasola de los Comendadores',
    'Endrinal',
    'Escurial de la Sierra',
    'Espadaña',
    'Espeja',
    'Espino de la Orbada',
    'Florida de Liébana',
    'Forfoleda',
    'Frades de la Sierra',
    'Fregeneda, La',
    'Fresnedoso',
    'Fresno Alhándiga',
    'Fuente de San Esteban, La',
    'Fuenteguinaldo',
    'Fuenteliante',
    'Fuenterroble de Salvatierra',
    'Fuentes de Béjar',
    'Fuentes de Oñoro',
    'Gajates',
    'Galindo y Perahuy',
    'Galinduste',
    'Galisancho',
    'Gallegos de Argañán',
    'Gallegos de Solmirón',
    'Garcibuey',
    'Garcihernández',
    'Garcirrey',
    'Gejuelo del Barro',
    'Golpejas',
    'Gomecello',
    'Guadramiro',
    'Guijo de Ávila',
    'Guijuelo',
    'Herguijuela de Ciudad Rodrigo',
    'Herguijuela de la Sierra',
    'Herguijuela del Campo',
    'Hinojosa de Duero',
    'Horcajo de Montemayor',
    'Horcajo Medianero',
    'Hoya, La',
    'Huerta',
    'Iruelos',
    'Ituero de Azaba',
    'Juzbado',
    'Lagunilla',
    'Larrodrigo',
    'Ledesma',
    'Ledrada',
    'Linares de Riofrío',
    'Lumbrales',
    'Machacón',
    'Macotera',
    'Madroñal',
    'Maíllo, El',
    'Malpartida',
    'Mancera de Abajo',
    'Manzano, El',
    'Martiago',
    'Martín de Yeltes',
    'Martinamor',
    'Masueco',
    'Mata de Ledesma, La',
    'Matilla de los Caños del Río',
    'Maya, La',
    'Membribe de la Sierra',
    'Mieza',
    'Milano, El',
    'Miranda de Azán',
    'Miranda del Castañar',
    'Mogarraz',
    'Molinillo',
    'Monforte de la Sierra',
    'Monleón',
    'Monleras',
    'Monsagro',
    'Montejo',
    'Montemayor del Río',
    'Monterrubio de Armuña',
    'Monterrubio de la Sierra',
    'Morasverdes',
    'Morille',
    'Moríñigo',
    'Moriscos',
    'Moronta',
    'Mozárbez',
    'Narros de Matalayegua',
    'Nava de Béjar',
    'Nava de Francia',
    'Nava de Sotrobal',
    'Navacarros',
    'Navales',
    'Navalmoral de Béjar',
    'Navamorales',
    'Navarredonda de la Rinconada',
    'Navasfrías',
    'Negrilla de Palencia',
    'Olmedo de Camaces',
    'Orbada, La',
    'Pajares de la Laguna',
    'Palacios del Arzobispo',
    'Palaciosrubios',
    'Palencia de Negrilla',
    'Parada de Arriba',
    'Parada de Rubiales',
    'Paradinas de San Juan',
    'Pastores',
    'Payo, El',
    'Pedraza de Alba',
    'Pedrosillo de Alba',
    'Pedrosillo de los Aires',
    'Pedrosillo el Ralo',
    'Pedroso de la Armuña, El',
    'Pelabravo',
    'Pelarrodríguez',
    'Pelayos',
    'Peña, La',
    'Peñacaballera',
    'Peñaparda',
    'Peñaranda de Bracamonte',
    'Peñarandilla',
    'Peralejos de Abajo',
    'Peralejos de Arriba',
    'Pereña de la Ribera',
    'Peromingo',
    'Pinedas',
    'Pino de Tormes, El',
    'Pitiegua',
    'Pizarral',
    'Poveda de las Cintas',
    'Pozos de Hinojo',
    'Puebla de Azaba',
    'Puebla de San Medel',
    'Puebla de Yeltes',
    'Puente del Congosto',
    'Puertas',
    'Puerto de Béjar',
    'Puerto Seguro',
    'Rágama',
    'Redonda, La',
    'Retortillo',
    'Rinconada de la Sierra, La',
    'Robleda',
    'Robliza de Cojos',
    'Rollán',
    'Saelices el Chico',
    'Sagrada, La',
    'Sahugo, El',
    'Salamanca',
    'Saldeana',
    'Salmoral',
    'Salvatierra de Tormes',
    'San Cristóbal de la Cuesta',
    'San Esteban de la Sierra',
    'San Felices de los Gallegos',
    'San Martín del Castañar',
    'San Miguel de Valero',
    'San Miguel del Robledo',
    'San Morales',
    'San Muñoz',
    'San Pedro de Rozados',
    'San Pedro del Valle',
    'San Pelayo de Guareña',
    'Sanchón de la Ribera',
    'Sanchón de la Sagrada',
    'Sanchotello',
    'Sancti-Spíritus',
    'Sando',
    'Santa María de Sando',
    'Santa Marta de Tormes',
    'Santiago de la Puebla',
    'Santibáñez de Béjar',
    'Santibáñez de la Sierra',
    'Santiz',
    'Santos, Los',
    'Sardón de los Frailes',
    'Saucelle',
    'Sepulcro-Hilario',
    'Sequeros',
    'Serradilla del Arroyo',
    'Serradilla del Llano',
    'Sierpe, La',
    'Sieteiglesias de Tormes',
    'Sobradillo',
    'Sorihuela',
    'Sotoserrano',
    'Tabera de Abajo',
    'Tala, La',
    'Tamames',
    'Tarazona de Guareña',
    'Tardáguila',
    'Tejado, El',
    'Tejeda y Segoyuela',
    'Tenebrón',
    'Terradillos',
    'Topas',
    'Tordillos',
    'Tornadizo, El',
    'Torresmenudas',
    'Trabanca',
    'Tremedal de Tormes',
    'Valdecarros',
    'Valdefuentes de Sangusín',
    'Valdehijaderos',
    'Valdelacasa',
    'Valdelageve',
    'Valdelosa',
    'Valdemierque',
    'Valderrodrigo',
    'Valdunciel',
    'Valero',
    'Vallejera de Riofrío',
    'Valsalabroso',
    'Valverde de Valdelacasa',
    'Valverdón',
    'Vecinos',
    'Vega de Tirados',
    'Veguillas, Las',
    'Vellés, La',
    'Ventosa del Río Almar',
    'Vídola, La',
    'Villaflores',
    'Villagonzalo de Tormes',
    'Villalba de los Llanos',
    'Villamayor',
    'Villanueva del Conde',
    'Villar de Argañán',
    'Villar de Ciervo',
    'Villar de Gallimazo',
    'Villar de la Yegua',
    'Villar de Peralonso',
    'Villar de Samaniego',
    'Villares de la Reina',
    'Villares de Yeltes',
    'Villarino de los Aires',
    'Villarmayor',
    'Villarmuerto',
    'Villasbuenas',
    'Villasdardo',
    'Villaseco de los Gamitos',
    'Villaseco de los Reyes',
    'Villasrubias',
    'Villaverde de Guareña',
    'Villavieja de Yeltes',
    'Villoria',
    'Villoruela',
    'Vilvestre',
    'Vitigudino',
    'Yecla de Yeltes',
    'Zamarra',
    'Zamayón',
    'Zarapicos',
    'Zarza de Pumareda, La',
    'Zorita de la Frontera',
  ),
/* Province of Santa Cruz de Tenerife */
  'TF' => array(
    'Adeje',
    'Agulo',
    'Alajeró',
    'Arafo',
    'Arico',
    'Arona',
    'Barlovento',
    'Breña Alta',
    'Breña Baja',
    'Buenavista del Norte',
    'Candelaria',
    'Fasnia',
    'Frontera',
    'Fuencaliente de la Palma',
    'Garachico',
    'Garafía',
    'Granadilla de Abona',
    'Guancha, La',
    'Guía de Isora',
    'Güímar',
    'Hermigua',
    'Icod de los Vinos',
    'Llanos de Aridane, Los',
    'Matanza de Acentejo, La',
    'Orotava, La',
    'Paso, El',
    'Pinar de El Hierro, El',
    'Puerto de la Cruz',
    'Puntagorda',
    'Puntallana',
    'Realejos, Los',
    'Rosario, El',
    'San Andrés y Sauces',
    'San Cristóbal de La Laguna',
    'San Juan de la Rambla',
    'San Miguel de Abona',
    'San Sebastián de la Gomera',
    'Santa Cruz de la Palma',
    'Santa Cruz de Tenerife',
    'Santa Úrsula',
    'Santiago del Teide',
    'Sauzal, El',
    'Silos, Los',
    'Tacoronte',
    'Tanque, El',
    'Tazacorte',
    'Tegueste',
    'Tijarafe',
    'Valle Gran Rey',
    'Vallehermoso',
    'Valverde',
    'Victoria de Acentejo, La',
    'Vilaflor de Chasna',
    'Villa de Mazo',
  ),
/* Province of Segovia */
  'SG' => array(
    'Abades',
    'Adrada de Pirón',
    'Adrados',
    'Aguilafuente',
    'Alconada de Maderuelo',
    'Aldea Real',
    'Aldealcorvo',
    'Aldealengua de Pedraza',
    'Aldealengua de Santa María',
    'Aldeanueva de la Serrezuela',
    'Aldeanueva del Codonal',
    'Aldeasoña',
    'Aldehorno',
    'Aldehuela del Codonal',
    'Aldeonte',
    'Anaya',
    'Añe',
    'Arahuetes',
    'Arcones',
    'Arevalillo de Cega',
    'Armuña',
    'Ayllón',
    'Barbolla',
    'Basardilla',
    'Bercial',
    'Bercimuel',
    'Bernardos',
    'Bernuy de Porreros',
    'Boceguillas',
    'Brieva',
    'Caballar',
    'Cabañas de Polendos',
    'Cabezuela',
    'Calabazas de Fuentidueña',
    'Campo de San Pedro',
    'Cantalejo',
    'Cantimpalos',
    'Carabias',
    'Carbonero el Mayor',
    'Carrascal del Río',
    'Casla',
    'Castillejo de Mesleón',
    'Castro de Fuentidueña',
    'Castrojimeno',
    'Castroserna de Abajo',
    'Castroserracín',
    'Cedillo de la Torre',
    'Cerezo de Abajo',
    'Cerezo de Arriba',
    'Chañe',
    'Cilleruelo de San Mamés',
    'Cobos de Fuentidueña',
    'Coca',
    'Codorniz',
    'Collado Hermoso',
    'Condado de Castilnovo',
    'Corral de Ayllón',
    'Cozuelos de Fuentidueña',
    'Cubillo',
    'Cuéllar',
    'Cuevas de Provanco',
    'Domingo García',
    'Donhierro',
    'Duruelo',
    'Encinas',
    'Encinillas',
    'Escalona del Prado',
    'Escarabajosa de Cabezas',
    'Escobar de Polendos',
    'Espinar, El',
    'Espirdo',
    'Fresneda de Cuéllar',
    'Fresno de Cantespino',
    'Fresno de la Fuente',
    'Frumales',
    'Fuente de Santa Cruz',
    'Fuente el Olmo de Fuentidueña',
    'Fuente el Olmo de Íscar',
    'Fuentepelayo',
    'Fuentepiñel',
    'Fuenterrebollo',
    'Fuentesaúco de Fuentidueña',
    'Fuentesoto',
    'Fuentidueña',
    'Gallegos',
    'Garcillán',
    'Gomezserracín',
    'Grajera',
    'Honrubia de la Cuesta',
    'Hontalbilla',
    'Hontanares de Eresma',
    'Huertos, Los',
    'Ituero y Lama',
    'Juarros de Riomoros',
    'Juarros de Voltoya',
    'Labajos',
    'Laguna de Contreras',
    'Languilla',
    'Lastras de Cuéllar',
    'Lastras del Pozo',
    'Lastrilla, La',
    'Losa, La',
    'Maderuelo',
    'Marazoleja',
    'Marazuela',
    'Martín Miguel',
    'Martín Muñoz de la Dehesa',
    'Martín Muñoz de las Posadas',
    'Marugán',
    'Mata de Cuéllar',
    'Matabuena',
    'Matilla, La',
    'Melque de Cercos',
    'Membibre de la Hoz',
    'Migueláñez',
    'Montejo de Arévalo',
    'Montejo de la Vega de la Serrezuela',
    'Monterrubio',
    'Moral de Hornuez',
    'Mozoncillo',
    'Muñopedro',
    'Muñoveros',
    'Nava de la Asunción',
    'Navafría',
    'Navalilla',
    'Navalmanzano',
    'Navares de Ayuso',
    'Navares de Enmedio',
    'Navares de las Cuevas',
    'Navas de Oro',
    'Navas de Riofrío',
    'Navas de San Antonio',
    'Nieva',
    'Olombrada',
    'Orejana',
    'Ortigosa de Pestaño',
    'Ortigosa del Monte',
    'Otero de Herreros',
    'Pajarejos',
    'Palazuelos de Eresma',
    'Pedraza',
    'Pelayos del Arroyo',
    'Perosillo',
    'Pinarejos',
    'Pinarnegrillo',
    'Prádena',
    'Puebla de Pedraza',
    'Rapariegos',
    'Real Sitio de San Ildefonso',
    'Rebollo',
    'Remondo',
    'Riaguas de San Bartolomé',
    'Riaza',
    'Ribota',
    'Riofrío de Riaza',
    'Roda de Eresma',
    'Sacramenia',
    'Samboal',
    'San Cristóbal de Cuéllar',
    'San Cristóbal de la Vega',
    'San Cristóbal de Segovia',
    'San Martín y Mudrián',
    'San Miguel de Bernuy',
    'San Pedro de Gaíllos',
    'Sanchonuño',
    'Sangarcía',
    'Santa María la Real de Nieva',
    'Santa Marta del Cerro',
    'Santiuste de Pedraza',
    'Santiuste de San Juan Bautista',
    'Santo Domingo de Pirón',
    'Santo Tomé del Puerto',
    'Sauquillo de Cabezas',
    'Sebúlcor',
    'Segovia',
    'Sepúlveda',
    'Sequera de Fresno',
    'Sotillo',
    'Sotosalbos',
    'Tabanera la Luenga',
    'Tolocirio',
    'Torre Val de San Pedro',
    'Torreadrada',
    'Torrecaballeros',
    'Torrecilla del Pinar',
    'Torreiglesias',
    'Trescasas',
    'Turégano',
    'Urueñas',
    'Valdeprados',
    'Valdevacas de Montejo',
    'Valdevacas y Guijar',
    'Valle de Tabladillo',
    'Vallelado',
    'Valleruela de Pedraza',
    'Valleruela de Sepúlveda',
    'Valseca',
    'Valtiendas',
    'Valverde del Majano',
    'Veganzones',
    'Vegas de Matute',
    'Ventosilla y Tejadilla',
    'Villacastín',
    'Villaverde de Íscar',
    'Villaverde de Montejo',
    'Villeguillo',
    'Yanguas de Eresma',
    'Zarzuela del Monte',
    'Zarzuela del Pinar '
  ),
/* Province of Sevilla */
  'SE' => array(
    'Aguadulce',
    'Alanís',
    'Albaida del Aljarafe',
    'Alcalá de Guadaíra',
    'Alcalá del Río',
    'Alcolea del Río',
    'Algaba, La',
    'Algámitas',
    'Almadén de la Plata',
    'Almensilla',
    'Arahal',
    'Aznalcázar',
    'Aznalcóllar',
    'Badolatosa',
    'Benacazón',
    'Bollullos de la Mitación',
    'Bormujos',
    'Brenes',
    'Burguillos',
    'Cabezas de San Juan, Las',
    'Camas',
    'Campana, La',
    'Cantillana',
    'Cañada Rosal',
    'Carmona',
    'Carrión de los Céspedes',
    'Casariche',
    'Castilblanco de los Arroyos',
    'Castilleja de Guzmán',
    'Castilleja de la Cuesta',
    'Castilleja del Campo',
    'Castillo de las Guardas, El',
    'Cazalla de la Sierra',
    'Constantina',
    'Coria del Río',
    'Coripe',
    'Coronil, El',
    'Corrales, Los',
    'Cuervo de Sevilla, El',
    'Dos Hermanas',
    'Écija',
    'Espartinas',
    'Estepa',
    'Fuentes de Andalucía',
    'Garrobo, El',
    'Gelves',
    'Gerena',
    'Gilena',
    'Gines',
    'Guadalcanal',
    'Guillena',
    'Herrera',
    'Huévar del Aljarafe',
    'Isla Mayor',
    'Lantejuela',
    'Lebrija',
    'Lora de Estepa',
    'Lora del Río',
    'Luisiana, La',
    'Madroño, El',
    'Mairena del Alcor',
    'Mairena del Aljarafe',
    'Marchena',
    'Marinaleda',
    'Martín de la Jara',
    'Molares, Los',
    'Montellano',
    'Morón de la Frontera',
    'Navas de la Concepción, Las',
    'Olivares',
    'Osuna',
    'Palacios y Villafranca, Los',
    'Palmar de Troya, El',
    'Palomares del Río',
    'Paradas',
    'Pedrera',
    'Pedroso, El',
    'Peñaflor',
    'Pilas',
    'Pruna',
    'Puebla de Cazalla, La',
    'Puebla de los Infantes, La',
    'Puebla del Río, La',
    'Real de la Jara, El',
    'Rinconada, La',
    'Roda de Andalucía, La',
    'Ronquillo, El',
    'Rubio, El',
    'Salteras',
    'San Juan de Aznalfarache',
    'San Nicolás del Puerto',
    'Sanlúcar la Mayor',
    'Santiponce',
    'Saucejo, El',
    'Sevilla',
    'Tocina',
    'Tomares',
    'Umbrete',
    'Utrera',
    'Valencina de la Concepción',
    'Villamanrique de la Condesa',
    'Villanueva de San Juan',
    'Villanueva del Ariscal',
    'Villanueva del Río y Minas',
    'Villaverde del Río',
    'Viso del Alcor, El '
  ),
/* Province of Soria */
  'SO' => array(
    'Abejar',
    'Adradas',
    'Ágreda',
    'Alconaba',
    'Alcubilla de Avellaneda',
    'Alcubilla de las Peñas',
    'Aldealafuente',
    'Aldealices',
    'Aldealpozo',
    'Aldealseñor',
    'Aldehuela de Periáñez',
    'Aldehuelas, Las',
    'Alentisque',
    'Aliud',
    'Almajano',
    'Almaluez',
    'Almarza',
    'Almazán',
    'Almazul',
    'Almenar de Soria',
    'Alpanseque',
    'Arancón',
    'Arcos de Jalón',
    'Arenillas',
    'Arévalo de la Sierra',
    'Ausejo de la Sierra',
    'Baraona',
    'Barca',
    'Barcones',
    'Bayubas de Abajo',
    'Bayubas de Arriba',
    'Beratón',
    'Berlanga de Duero',
    'Blacos',
    'Bliecos',
    'Borjabad',
    'Borobia',
    'Buberos',
    'Buitrago',
    'Burgo de Osma-Ciudad de Osma',
    'Cabrejas del Campo',
    'Cabrejas del Pinar',
    'Calatañazor',
    'Caltojar',
    'Candilichera',
    'Cañamaque',
    'Carabantes',
    'Caracena',
    'Carrascosa de Abajo',
    'Carrascosa de la Sierra',
    'Casarejos',
    'Castilfrío de la Sierra',
    'Castillejo de Robledo',
    'Castilruiz',
    'Centenera de Andaluz',
    'Cerbón',
    'Cidones',
    'Cigudosa',
    'Cihuela',
    'Ciria',
    'Cirujales del Río',
    'Coscurita',
    'Covaleda',
    'Cubilla',
    'Cubo de la Solana',
    'Cueva de Ágreda',
    'Dévanos',
    'Deza',
    'Duruelo de la Sierra',
    'Escobosa de Almazán',
    'Espeja de San Marcelino',
    'Espejón',
    'Estepa de San Juan',
    'Frechilla de Almazán',
    'Fresno de Caracena',
    'Fuentearmegil',
    'Fuentecambrón',
    'Fuentecantos',
    'Fuentelmonge',
    'Fuentelsaz de Soria',
    'Fuentepinilla',
    'Fuentes de Magaña',
    'Fuentestrún',
    'Garray',
    'Golmayo',
    'Gómara',
    'Gormaz',
    'Herrera de Soria',
    'Hinojosa del Campo',
    'Langa de Duero',
    'Liceras',
    'Losilla, La',
    'Magaña',
    'Maján',
    'Matalebreras',
    'Matamala de Almazán',
    'Medinaceli',
    'Miño de Medinaceli',
    'Miño de San Esteban',
    'Molinos de Duero',
    'Momblona',
    'Monteagudo de las Vicarías',
    'Montejo de Tiermes',
    'Montenegro de Cameros',
    'Morón de Almazán',
    'Muriel de la Fuente',
    'Muriel Viejo',
    'Nafría de Ucero',
    'Narros',
    'Navaleno',
    'Nepas',
    'Nolay',
    'Noviercas',
    'Ólvega',
    'Oncala',
    'Pinilla del Campo',
    'Portillo de Soria',
    'Póveda de Soria, La',
    'Pozalmuro',
    'Quintana Redonda',
    'Quintanas de Gormaz',
    'Quiñonería',
    'Rábanos, Los',
    'Rebollar',
    'Recuerda',
    'Rello',
    'Renieblas',
    'Retortillo de Soria',
    'Reznos',
    'Riba de Escalote, La',
    'Rioseco de Soria',
    'Rollamienta',
    'Royo, El',
    'Salduero',
    'San Esteban de Gormaz',
    'San Felices',
    'San Leonardo de Yagüe',
    'San Pedro Manrique',
    'Santa Cruz de Yanguas',
    'Santa María de Huerta',
    'Santa María de las Hoyas',
    'Serón de Nágima',
    'Soliedra',
    'Soria',
    'Sotillo del Rincón',
    'Suellacabras',
    'Tajahuerce',
    'Tajueco',
    'Talveila',
    'Tardelcuende',
    'Taroda',
    'Tejado',
    'Torlengua',
    'Torreblacos',
    'Torrubia de Soria',
    'Trévago',
    'Ucero',
    'Vadillo',
    'Valdeavellano de Tera',
    'Valdegeña',
    'Valdelagua del Cerro',
    'Valdemaluque',
    'Valdenebro',
    'Valdeprado',
    'Valderrodilla',
    'Valtajeros',
    'Velamazán',
    'Velilla de la Sierra',
    'Velilla de los Ajos',
    'Viana de Duero',
    'Villaciervos',
    'Villanueva de Gormaz',
    'Villar del Ala',
    'Villar del Campo',
    'Villar del Río',
    'Villares de Soria, Los',
    'Villasayas',
    'Villaseca de Arciel',
    'Vinuesa',
    'Vizmanos',
    'Vozmediano',
    'Yanguas',
    'Yelo',
  ),
/* Province of Tarragona */
  'T' => array(
    'Aiguamúrcia',
    'Albinyana',
    'Albiol, L&#8242;',
    'Alcanar',
    'Alcover',
    'Aldea, L&#8242;',
    'Aldover',
    'Aleixar, L&#8242;',
    'Alfara de Carles',
    'Alforja',
    'Alió',
    'Almoster',
    'Altafulla',
    'Ametlla de Mar, L&#8242;',
    'Ampolla, L&#8242;',
    'Amposta',
    'Arboç, L&#8242;',
    'Arbolí',
    'Argentera, L&#8242;',
    'Arnes',
    'Ascó',
    'Banyeres del Penedès',
    'Barberà de la Conca',
    'Batea',
    'Bellmunt del Priorat',
    'Bellvei',
    'Benifallet',
    'Benissanet',
    'Bisbal de Falset, La',
    'Bisbal del Penedès, La',
    'Blancafort',
    'Bonastre',
    'Borges del Camp, Les',
    'Bot',
    'Botarell',
    'Bràfim',
    'Cabacés',
    'Cabra del Camp',
    'Calafell',
    'Camarles',
    'Cambrils',
    'Canonja, La',
    'Capafonts',
    'Capçanes',
    'Caseres',
    'Castellvell del Camp',
    'Catllar, El',
    'Colldejou',
    'Conesa',
    'Constantí',
    'Corbera d&#8242;Ebre',
    'Cornudella de Montsant',
    'Creixell',
    'Cunit',
    'Deltebre',
    'Duesaigües',
    'Espluga de Francolí, L&#8242;',
    'Falset',
    'Fatarella, La',
    'Febró, La',
    'Figuera, La',
    'Figuerola del Camp',
    'Flix',
    'Forès',
    'Freginals',
    'Galera, La',
    'Gandesa',
    'Garcia',
    'Garidells, Els',
    'Ginestar',
    'Godall',
    'Gratallops',
    'Guiamets, Els',
    'Horta de Sant Joan',
    'Lloar, El',
    'Llorac',
    'Llorenç del Penedès',
    'Marçà',
    'Margalef',
    'Mas de Barberans',
    'Masdenverge',
    'Masllorenç',
    'Masó, La',
    'Maspujols',
    'Masroig, El',
    'Milà, El',
    'Miravet',
    'Molar, El',
    'Montblanc',
    'Montbrió del Camp',
    'Montferri',
    'Montmell, El',
    'Mont-ral',
    'Mont-roig del Camp',
    'Móra d&#8242;Ebre',
    'Móra la Nova',
    'Morell, El',
    'Morera de Montsant, La',
    'Nou de Gaià, La',
    'Nulles',
    'Pallaresos, Els',
    'Palma d&#8242;Ebre, La',
    'Passanant i Belltall',
    'Paüls',
    'Perafort',
    'Perelló, El',
    'Piles, Les',
    'Pinell de Brai, El',
    'Pira',
    'Pla de Santa Maria, El',
    'Pobla de Mafumet, La',
    'Pobla de Massaluca, La',
    'Pobla de Montornès, La',
    'Poboleda',
    'Pont d&#8242;Armentera, El',
    'Pontils',
    'Porrera',
    'Pradell de la Teixeta',
    'Prades',
    'Prat de Comte',
    'Pratdip',
    'Puigpelat',
    'Querol',
    'Rasquera',
    'Renau',
    'Reus',
    'Riba, La',
    'Riba-roja d&#8242;Ebre',
    'Riera de Gaià, La',
    'Riudecanyes',
    'Riudecols',
    'Riudoms',
    'Rocafort de Queralt',
    'Roda de Berà',
    'Rodonyà',
    'Roquetes',
    'Rourell, El',
    'Salomó',
    'Salou',
    'Sant Carles de la Ràpita',
    'Sant Jaume dels Domenys',
    'Sant Jaume d&#8242;Enveja',
    'Santa Bàrbara',
    'Santa Coloma de Queralt',
    'Santa Oliva',
    'Sarral',
    'Savallà del Comtat',
    'Secuita, La',
    'Selva del Camp, La',
    'Senan',
    'Sénia, La',
    'Solivella',
    'Tarragona',
    'Tivenys',
    'Tivissa',
    'Torre de Fontaubella, La',
    'Torre de l&#8242;Espanyol, La',
    'Torredembarra',
    'Torroja del Priorat',
    'Tortosa',
    'Ulldecona',
    'Ulldemolins',
    'Vallclara',
    'Vallfogona de Riucorb',
    'Vallmoll',
    'Valls',
    'Vandellòs i l&#8242;Hospitalet de l&#8242;Infant',
    'Vendrell, El',
    'Vespella de Gaià',
    'Vilabella',
    'Vilalba dels Arcs',
    'Vilallonga del Camp',
    'Vilanova de Prades',
    'Vilanova d&#8242;Escornalbou',
    'Vilaplana',
    'Vila-rodona',
    'Vila-seca',
    'Vilaverd',
    'Vilella Alta, La',
    'Vilella Baixa, La',
    'Vimbodí i Poblet',
    'Vinebre',
    'Vinyols i els Arcs',
    'Xerta',
  ),
/* Province of Teruel */
  'TE' => array(
    'Ababuj',
    'Abejuela',
    'Aguatón',
    'Aguaviva',
    'Aguilar del Alfambra',
    'Alacón',
    'Alba',
    'Albalate del Arzobispo',
    'Albarracín',
    'Albentosa',
    'Alcaine',
    'Alcalá de la Selva',
    'Alcañiz',
    'Alcorisa',
    'Alfambra',
    'Aliaga',
    'Allepuz',
    'Alloza',
    'Allueva',
    'Almohaja',
    'Alobras',
    'Alpeñés',
    'Anadón',
    'Andorra',
    'Arcos de las Salinas',
    'Arens de Lledó',
    'Argente',
    'Ariño',
    'Azaila',
    'Bádenas',
    'Báguena',
    'Bañón',
    'Barrachina',
    'Bea',
    'Beceite',
    'Bello',
    'Belmonte de San José',
    'Berge',
    'Bezas',
    'Blancas',
    'Blesa',
    'Bordón',
    'Bronchales',
    'Bueña',
    'Burbáguena',
    'Cabra de Mora',
    'Calaceite',
    'Calamocha',
    'Calanda',
    'Calomarde',
    'Camañas',
    'Camarena de la Sierra',
    'Camarillas',
    'Caminreal',
    'Cantavieja',
    'Cañada de Benatanduz',
    'Cañada de Verich, La',
    'Cañada Vellida',
    'Cañizar del Olivar',
    'Cascante del Río',
    'Castejón de Tornos',
    'Castel de Cabra',
    'Castellar, El',
    'Castellote',
    'Castelnou',
    'Castelserás',
    'Cedrillas',
    'Celadas',
    'Cella',
    'Cerollera, La',
    'Codoñera, La',
    'Corbalán',
    'Cortes de Aragón',
    'Cosa',
    'Cretas',
    'Crivillén',
    'Cuba, La',
    'Cubla',
    'Cucalón',
    'Cuervo, El',
    'Cuevas de Almudén',
    'Cuevas Labradas',
    'Ejulve',
    'Escorihuela',
    'Escucha',
    'Estercuel',
    'Ferreruela de Huerva',
    'Fonfría',
    'Formiche Alto',
    'Fórnoles',
    'Fortanete',
    'Foz-Calanda',
    'Fresneda, La',
    'Frías de Albarracín',
    'Fuenferrada',
    'Fuentes Calientes',
    'Fuentes Claras',
    'Fuentes de Rubielos',
    'Fuentespalda',
    'Galve',
    'Gargallo',
    'Gea de Albarracín',
    'Ginebrosa, La',
    'Griegos',
    'Guadalaviar',
    'Gúdar',
    'Híjar',
    'Hinojosa de Jarque',
    'Hoz de la Vieja, La',
    'Huesa del Común',
    'Iglesuela del Cid, La',
    'Jabaloyas',
    'Jarque de la Val',
    'Jatiel',
    'Jorcas',
    'Josa',
    'Lagueruela',
    'Lanzuela',
    'Libros',
    'Lidón',
    'Linares de Mora',
    'Lledó',
    'Loscos',
    'Maicas',
    'Manzanera',
    'Martín del Río',
    'Mas de las Matas',
    'Mata de los Olmos, La',
    'Mazaleón',
    'Mezquita de Jarque',
    'Mirambel',
    'Miravete de la Sierra',
    'Molinos',
    'Monforte de Moyuela',
    'Monreal del Campo',
    'Monroyo',
    'Montalbán',
    'Monteagudo del Castillo',
    'Monterde de Albarracín',
    'Mora de Rubielos',
    'Moscardón',
    'Mosqueruela',
    'Muniesa',
    'Noguera de Albarracín',
    'Nogueras',
    'Nogueruelas',
    'Obón',
    'Odón',
    'Ojos Negros',
    'Olba',
    'Oliete',
    'Olmos, Los',
    'Orihuela del Tremedal',
    'Orrios',
    'Palomar de Arroyos',
    'Pancrudo',
    'Parras de Castellote, Las',
    'Peñarroya de Tastavins',
    'Peracense',
    'Peralejos',
    'Perales del Alfambra',
    'Pitarque',
    'Plou',
    'Pobo, El',
    'Portellada, La',
    'Pozondón',
    'Pozuel del Campo',
    'Puebla de Híjar, La',
    'Puebla de Valverde, La',
    'Puertomingalvo',
    'Ráfales',
    'Rillo',
    'Riodeva',
    'Ródenas',
    'Royuela',
    'Rubiales',
    'Rubielos de la Cérida',
    'Rubielos de Mora',
    'Salcedillo',
    'Saldón',
    'Samper de Calanda',
    'San Agustín',
    'San Martín del Río',
    'Santa Cruz de Nogueras',
    'Santa Eulalia',
    'Sarrión',
    'Segura de los Baños',
    'Seno',
    'Singra',
    'Terriente',
    'Teruel',
    'Toril y Masegoso',
    'Tormón',
    'Tornos',
    'Torralba de los Sisones',
    'Torre de Arcas',
    'Torre de las Arcas',
    'Torre del Compte',
    'Torre los Negros',
    'Torrecilla de Alcañiz',
    'Torrecilla del Rebollar',
    'Torrelacárcel',
    'Torremocha de Jiloca',
    'Torres de Albarracín',
    'Torrevelilla',
    'Torrijas',
    'Torrijo del Campo',
    'Tramacastiel',
    'Tramacastilla',
    'Tronchón',
    'Urrea de Gaén',
    'Utrillas',
    'Valacloche',
    'Valbona',
    'Valdealgorfa',
    'Valdecuenca',
    'Valdelinares',
    'Valdeltormo',
    'Valderrobres',
    'Valjunquera',
    'Vallecillo, El',
    'Veguillas de la Sierra',
    'Villafranca del Campo',
    'Villahermosa del Campo',
    'Villanueva del Rebollar de la Sierra',
    'Villar del Cobo',
    'Villar del Salz',
    'Villarluengo',
    'Villarquemado',
    'Villarroya de los Pinares',
    'Villastar',
    'Villel',
    'Vinaceite',
    'Visiedo',
    'Vivel del Río Martín',
    'Zoma, La',
  ),
/* Province of Toledo */
  'TO' => array(
    'Ajofrín',
    'Alameda de la Sagra',
    'Albarreal de Tajo',
    'Alcabón',
    'Alcañizo',
    'Alcaudete de la Jara',
    'Alcolea de Tajo',
    'Aldea en Cabo',
    'Aldeanueva de Barbarroya',
    'Aldeanueva de San Bartolomé',
    'Almendral de la Cañada',
    'Almonacid de Toledo',
    'Almorox',
    'Añover de Tajo',
    'Arcicóllar',
    'Argés',
    'Azután',
    'Barcience',
    'Bargas',
    'Belvís de la Jara',
    'Borox',
    'Buenaventura',
    'Burguillos de Toledo',
    'Burujón',
    'Cabañas de la Sagra',
    'Cabañas de Yepes',
    'Cabezamesada',
    'Calera y Chozas',
    'Caleruela',
    'Calzada de Oropesa',
    'Camarena',
    'Camarenilla',
    'Campillo de la Jara, El',
    'Camuñas',
    'Cardiel de los Montes',
    'Carmena',
    'Carpio de Tajo, El',
    'Carranque',
    'Carriches',
    'Casar de Escalona, El',
    'Casarrubios del Monte',
    'Casasbuenas',
    'Castillo de Bayuela',
    'Cazalegas',
    'Cebolla',
    'Cedillo del Condado',
    'Cerralbos, Los',
    'Cervera de los Montes',
    'Chozas de Canales',
    'Chueca',
    'Ciruelos',
    'Cobeja',
    'Cobisa',
    'Consuegra',
    'Corral de Almaguer',
    'Cuerva',
    'Domingo Pérez',
    'Dosbarrios',
    'Erustes',
    'Escalona',
    'Escalonilla',
    'Espinoso del Rey',
    'Esquivias',
    'Estrella, La',
    'Fuensalida',
    'Gálvez',
    'Garciotum',
    'Gerindote',
    'Guadamur',
    'Guardia, La',
    'Herencias, Las',
    'Herreruela de Oropesa',
    'Hinojosa de San Vicente',
    'Hontanar',
    'Hormigos',
    'Huecas',
    'Huerta de Valdecarábanos',
    'Iglesuela del Tiétar, La',
    'Illán de Vacas',
    'Illescas',
    'Lagartera',
    'Layos',
    'Lillo',
    'Lominchar',
    'Lucillos',
    'Madridejos',
    'Magán',
    'Malpica de Tajo',
    'Manzaneque',
    'Maqueda',
    'Marjaliza',
    'Marrupe',
    'Mascaraque',
    'Mata, La',
    'Mazarambroz',
    'Mejorada',
    'Menasalbas',
    'Méntrida',
    'Mesegar de Tajo',
    'Miguel Esteban',
    'Mocejón',
    'Mohedas de la Jara',
    'Montearagón',
    'Montesclaros',
    'Mora',
    'Nambroca',
    'Nava de Ricomalillo, La',
    'Navahermosa',
    'Navalcán',
    'Navalmoralejo',
    'Navalmorales, Los',
    'Navalucillos, Los',
    'Navamorcuende',
    'Noblejas',
    'Noez',
    'Nombela',
    'Novés',
    'Numancia de la Sagra',
    'Nuño Gómez',
    'Ocaña',
    'Olías del Rey',
    'Ontígola',
    'Orgaz',
    'Oropesa',
    'Otero',
    'Palomeque',
    'Pantoja',
    'Paredes de Escalona',
    'Parrillas',
    'Pelahustán',
    'Pepino',
    'Polán',
    'Portillo de Toledo',
    'Puebla de Almoradiel, La',
    'Puebla de Montalbán, La',
    'Pueblanueva, La',
    'Puente del Arzobispo, El',
    'Puerto de San Vicente',
    'Pulgar',
    'Quero',
    'Quintanar de la Orden',
    'Quismondo',
    'Real de San Vicente, El',
    'Recas',
    'Retamoso de la Jara',
    'Rielves',
    'Robledo del Mazo',
    'Romeral, El',
    'San Bartolomé de las Abiertas',
    'San Martín de Montalbán',
    'San Martín de Pusa',
    'San Pablo de los Montes',
    'San Román de los Montes',
    'Santa Ana de Pusa',
    'Santa Cruz de la Zarza',
    'Santa Cruz del Retamar',
    'Santa Olalla',
    'Santo Domingo-Caudilla',
    'Sartajada',
    'Segurilla',
    'Seseña',
    'Sevilleja de la Jara',
    'Sonseca',
    'Sotillo de las Palomas',
    'Talavera de la Reina',
    'Tembleque',
    'Toboso, El',
    'Toledo',
    'Torralba de Oropesa',
    'Torre de Esteban Hambrán, La',
    'Torrecilla de la Jara',
    'Torrico',
    'Torrijos',
    'Totanés',
    'Turleque',
    'Ugena',
    'Urda',
    'Valdeverdeja',
    'Valmojado',
    'Velada',
    'Ventas con Peña Aguilera, Las',
    'Ventas de Retamosa, Las',
    'Ventas de San Julián, Las',
    'Villa de Don Fadrique, La',
    'Villacañas',
    'Villafranca de los Caballeros',
    'Villaluenga de la Sagra',
    'Villamiel de Toledo',
    'Villaminaya',
    'Villamuelas',
    'Villanueva de Alcardete',
    'Villanueva de Bogas',
    'Villarejo de Montalbán',
    'Villarrubia de Santiago',
    'Villaseca de la Sagra',
    'Villasequilla',
    'Villatobas',
    'Viso de San Juan, El',
    'Yébenes, Los',
    'Yeles',
    'Yepes',
    'Yuncler',
    'Yunclillos',
    'Yuncos '
  ),
/* Province of Valencia/València */
  'V' => array(
    'Ademuz',
    'Ador',
    'Agullent',
    'Aielo de Malferit',
    'Aielo de Rugat',
    'Alaquàs',
    'Albaida',
    'Albal',
    'Albalat de la Ribera',
    'Albalat dels Sorells',
    'Albalat dels Tarongers',
    'Alberic',
    'Alborache',
    'Alboraia/Alboraya',
    'Albuixech',
    'Alcàntera de Xúquer',
    'Alcàsser',
    'Alcublas',
    'Alcúdia de Crespins, L&#8242;',
    'Alcúdia, L&#8242;',
    'Aldaia',
    'Alfafar',
    'Alfara de la Baronia',
    'Alfara del Patriarca',
    'Alfarp',
    'Alfarrasí',
    'Alfauir',
    'Algar de Palancia',
    'Algemesí',
    'Algímia d&#8242;Alfara',
    'Alginet',
    'Almàssera',
    'Almiserà',
    'Almoines',
    'Almussafes',
    'Alpuente',
    'Alqueria de la Comtessa, L&#8242;',
    'Alzira',
    'Andilla',
    'Anna',
    'Antella',
    'Aras de los Olmos',
    'Atzeneta d&#8242;Albaida',
    'Ayora',
    'Barx',
    'Barxeta',
    'Bèlgida',
    'Bellreguard',
    'Bellús',
    'Benagéber',
    'Benaguasil',
    'Benavites',
    'Beneixida',
    'Benetússer',
    'Beniarjó',
    'Beniatjar',
    'Benicolet',
    'Benicull de Xúquer',
    'Benifaió',
    'Benifairó de la Valldigna',
    'Benifairó de les Valls',
    'Beniflá',
    'Benigànim',
    'Benimodo',
    'Benimuslem',
    'Beniparrell',
    'Benirredrà',
    'Benissanó',
    'Benissoda',
    'Benissuera',
    'Bétera',
    'Bicorp',
    'Bocairent',
    'Bolbaite',
    'Bonrepòs i Mirambell',
    'Bufali',
    'Bugarra',
    'Buñol',
    'Burjassot',
    'Calles',
    'Camporrobles',
    'Canals',
    'Canet d&#8242;En Berenguer',
    'Carcaixent',
    'Càrcer',
    'Carlet',
    'Carrícola',
    'Casas Altas',
    'Casas Bajas',
    'Casinos',
    'Castelló de Rugat',
    'Castellonet de la Conquesta',
    'Castielfabib',
    'Catadau',
    'Catarroja',
    'Caudete de las Fuentes',
    'Cerdà',
    'Chella',
    'Chelva',
    'Chera',
    'Cheste',
    'Chiva',
    'Chulilla',
    'Cofrentes',
    'Corbera',
    'Cortes de Pallás',
    'Cotes',
    'Cullera',
    'Daimús',
    'Domeño',
    'Dos Aguas',
    'Eliana, L&#8242;',
    'Emperador',
    'Enguera',
    'Ènova, L&#8242;',
    'Estivella',
    'Estubeny',
    'Faura',
    'Favara',
    'Foios',
    'Font de la Figuera, La',
    'Font d&#8242;En Carròs, La',
    'Fontanars dels Alforins',
    'Fortaleny',
    'Fuenterrobles',
    'Gandia',
    'Gátova',
    'Gavarda',
    'Genovés, El',
    'Gestalgar',
    'Gilet',
    'Godella',
    'Godelleta',
    'Granja de la Costera, La',
    'Guadasséquies',
    'Guadassuar',
    'Guardamar de la Safor',
    'Higueruelas',
    'Jalance',
    'Jarafuel',
    'Llanera de Ranes',
    'Llaurí',
    'Llíria',
    'Llocnou de la Corona',
    'Llocnou de Sant Jeroni',
    'Llocnou d&#8242;En Fenollet',
    'Llombai',
    'Llosa de Ranes, La',
    'Llutxent',
    'Loriguilla',
    'Losa del Obispo',
    'Macastre',
    'Manises',
    'Manuel',
    'Marines',
    'Massalavés',
    'Massalfassar',
    'Massamagrell',
    'Massanassa',
    'Meliana',
    'Millares',
    'Miramar',
    'Mislata',
    'Mogente/Moixent',
    'Moncada',
    'Montaverner',
    'Montesa',
    'Montitxelvo/Montichelvo',
    'Montroi/Montroy',
    'Montserrat',
    'Museros',
    'Nàquera/Náquera',
    'Navarrés',
    'Novelé/Novetlè',
    'Oliva',
    'Olleria, L&#8242;',
    'Olocau',
    'Ontinyent',
    'Otos',
    'Paiporta',
    'Palma de Gandía',
    'Palmera',
    'Palomar, El',
    'Paterna',
    'Pedralba',
    'Petrés',
    'Picanya',
    'Picassent',
    'Piles',
    'Pinet',
    'Pobla de Farnals, La',
    'Pobla de Vallbona, La',
    'Pobla del Duc, La',
    'Pobla Llarga, La',
    'Polinyà de Xúquer',
    'Potries',
    'Puçol',
    'Puebla de San Miguel',
    'Puig de Santa Maria, El',
    'Quart de les Valls',
    'Quart de Poblet',
    'Quartell',
    'Quatretonda',
    'Quesa',
    'Rafelbunyol',
    'Rafelcofer',
    'Rafelguaraf',
    'Ráfol de Salem',
    'Real',
    'Real de Gandia, El',
    'Requena',
    'Riba-roja de Túria',
    'Riola',
    'Rocafort',
    'Rotglà i Corberà',
    'Rótova',
    'Rugat',
    'Sagunto/Sagunt',
    'Salem',
    'San Antonio de Benagéber',
    'Sant Joanet',
    'Sedaví',
    'Segart',
    'Sellent',
    'Sempere',
    'Senyera',
    'Serra',
    'Siete Aguas',
    'Silla',
    'Simat de la Valldigna',
    'Sinarcas',
    'Sollana',
    'Sot de Chera',
    'Sueca',
    'Sumacàrcer',
    'Tavernes Blanques',
    'Tavernes de la Valldigna',
    'Teresa de Cofrentes',
    'Terrateig',
    'Titaguas',
    'Torrebaja',
    'Torrella',
    'Torrent',
    'Torres Torres',
    'Tous',
    'Tuéjar',
    'Turís',
    'Utiel',
    'València',
    'Vallada',
    'Vallanca',
    'Vallés',
    'Venta del Moro',
    'Vilallonga/Villalonga',
    'Vilamarxant',
    'Villanueva de Castellón',
    'Villar del Arzobispo',
    'Villargordo del Cabriel',
    'Vinalesa',
    'Xàtiva',
    'Xeraco',
    'Xeresa',
    'Xirivella',
    'Yátova',
    'Yesa, La',
    'Zarra',
  ),
/* Province of Valladolid */
  'VA' => array(
    'Adalia',
    'Aguasal',
    'Aguilar de Campos',
    'Alaejos',
    'Alcazarén',
    'Aldea de San Miguel',
    'Aldeamayor de San Martín',
    'Almenara de Adaja',
    'Amusquillo',
    'Arroyo de la Encomienda',
    'Ataquines',
    'Bahabón',
    'Barcial de la Loma',
    'Barruelo del Valle',
    'Becilla de Valderaduey',
    'Benafarces',
    'Bercero',
    'Berceruelo',
    'Berrueces',
    'Bobadilla del Campo',
    'Bocigas',
    'Bocos de Duero',
    'Boecillo',
    'Bolaños de Campos',
    'Brahojos de Medina',
    'Bustillo de Chaves',
    'Cabezón de Pisuerga',
    'Cabezón de Valderaduey',
    'Cabreros del Monte',
    'Campaspero',
    'Campillo, El',
    'Camporredondo',
    'Canalejas de Peñafiel',
    'Canillas de Esgueva',
    'Carpio',
    'Casasola de Arión',
    'Castrejón de Trabancos',
    'Castrillo de Duero',
    'Castrillo-Tejeriego',
    'Castrobol',
    'Castrodeza',
    'Castromembibre',
    'Castromonte',
    'Castronuevo de Esgueva',
    'Castronuño',
    'Castroponce',
    'Castroverde de Cerrato',
    'Ceinos de Campos',
    'Cervillego de la Cruz',
    'Cigales',
    'Ciguñuela',
    'Cistérniga',
    'Cogeces de Íscar',
    'Cogeces del Monte',
    'Corcos',
    'Corrales de Duero',
    'Cubillas de Santa Marta',
    'Cuenca de Campos',
    'Curiel de Duero',
    'Encinas de Esgueva',
    'Esguevillas de Esgueva',
    'Fombellida',
    'Fompedraza',
    'Fontihoyuelo',
    'Fresno el Viejo',
    'Fuensaldaña',
    'Fuente el Sol',
    'Fuente-Olmedo',
    'Gallegos de Hornija',
    'Gatón de Campos',
    'Geria',
    'Herrín de Campos',
    'Hornillos de Eresma',
    'Íscar',
    'Laguna de Duero',
    'Langayo',
    'Llano de Olmedo',
    'Lomoviejo',
    'Manzanillo',
    'Marzales',
    'Matapozuelos',
    'Matilla de los Caños',
    'Mayorga',
    'Medina de Rioseco',
    'Medina del Campo',
    'Megeces',
    'Melgar de Abajo',
    'Melgar de Arriba',
    'Mojados',
    'Monasterio de Vega',
    'Montealegre de Campos',
    'Montemayor de Pililla',
    'Moral de la Reina',
    'Moraleja de las Panaderas',
    'Morales de Campos',
    'Mota del Marqués',
    'Mucientes',
    'Mudarra, La',
    'Muriel',
    'Nava del Rey',
    'Nueva Villa de las Torres',
    'Olivares de Duero',
    'Olmedo',
    'Olmos de Esgueva',
    'Olmos de Peñafiel',
    'Palazuelo de Vedija',
    'Parrilla, La',
    'Pedraja de Portillo, La',
    'Pedrajas de San Esteban',
    'Pedrosa del Rey',
    'Peñafiel',
    'Peñaflor de Hornija',
    'Pesquera de Duero',
    'Piña de Esgueva',
    'Piñel de Abajo',
    'Piñel de Arriba',
    'Pollos',
    'Portillo',
    'Pozal de Gallinas',
    'Pozaldez',
    'Pozuelo de la Orden',
    'Puras',
    'Quintanilla de Arriba',
    'Quintanilla de Onésimo',
    'Quintanilla de Trigueros',
    'Quintanilla del Molar',
    'Rábano',
    'Ramiro',
    'Renedo de Esgueva',
    'Roales de Campos',
    'Robladillo',
    'Roturas',
    'Rubí de Bracamonte',
    'Rueda',
    'Saelices de Mayorga',
    'Salvador de Zapardiel',
    'San Cebrián de Mazote',
    'San Llorente',
    'San Martín de Valvení',
    'San Miguel del Arroyo',
    'San Miguel del Pino',
    'San Pablo de la Moraleja',
    'San Pedro de Latarce',
    'San Pelayo',
    'San Román de Hornija',
    'San Salvador',
    'San Vicente del Palacio',
    'Santa Eufemia del Arroyo',
    'Santervás de Campos',
    'Santibáñez de Valcorba',
    'Santovenia de Pisuerga',
    'Sardón de Duero',
    'Seca, La',
    'Serrada',
    'Siete Iglesias de Trabancos',
    'Simancas',
    'Tamariz de Campos',
    'Tiedra',
    'Tordehumos',
    'Tordesillas',
    'Torre de Esgueva',
    'Torre de Peñafiel',
    'Torrecilla de la Abadesa',
    'Torrecilla de la Orden',
    'Torrecilla de la Torre',
    'Torrelobatón',
    'Torrescárcela',
    'Traspinedo',
    'Trigueros del Valle',
    'Tudela de Duero',
    'Unión de Campos, La',
    'Urones de Castroponce',
    'Urueña',
    'Valbuena de Duero',
    'Valdearcos de la Vega',
    'Valdenebro de los Valles',
    'Valdestillas',
    'Valdunquillo',
    'Valladolid',
    'Valoria la Buena',
    'Valverde de Campos',
    'Vega de Ruiponce',
    'Vega de Valdetronco',
    'Velascálvaro',
    'Velilla',
    'Velliza',
    'Ventosa de la Cuesta',
    'Viana de Cega',
    'Villabáñez',
    'Villabaruz de Campos',
    'Villabrágima',
    'Villacarralón',
    'Villacid de Campos',
    'Villaco',
    'Villafrades de Campos',
    'Villafranca de Duero',
    'Villafrechós',
    'Villafuerte',
    'Villagarcía de Campos',
    'Villagómez la Nueva',
    'Villalán de Campos',
    'Villalar de los Comuneros',
    'Villalba de la Loma',
    'Villalba de los Alcores',
    'Villalbarba',
    'Villalón de Campos',
    'Villamuriel de Campos',
    'Villán de Tordesillas',
    'Villanubla',
    'Villanueva de Duero',
    'Villanueva de la Condesa',
    'Villanueva de los Caballeros',
    'Villanueva de los Infantes',
    'Villanueva de San Mancio',
    'Villardefrades',
    'Villarmentero de Esgueva',
    'Villasexmir',
    'Villavaquerín',
    'Villavellid',
    'Villaverde de Medina',
    'Villavicencio de los Caballeros',
    'Viloria',
    'Wamba',
    'Zaratán',
    'Zarza, La',
  ),
/* Province of Vizcaya/Bizkaia */
  'BI' => array(
    'Abadiño',
    'Abanto y Ciérvana-Abanto Zierbena',
    'Ajangiz',
    'Alonsotegi',
    'Amorebieta-Etxano',
    'Amoroto',
    'Arakaldo',
    'Arantzazu',
    'Areatza',
    'Arrankudiaga',
    'Arratzu',
    'Arrieta',
    'Arrigorriaga',
    'Artea',
    'Artzentales',
    'Atxondo',
    'Aulesti',
    'Bakio',
    'Balmaseda',
    'Barakaldo',
    'Barrika',
    'Basauri',
    'Bedia',
    'Berango',
    'Bermeo',
    'Berriatua',
    'Berriz',
    'Bilbao',
    'Busturia',
    'Derio',
    'Dima',
    'Durango',
    'Ea',
    'Elantxobe',
    'Elorrio',
    'Erandio',
    'Ereño',
    'Ermua',
    'Errigoiti',
    'Etxebarri',
    'Etxebarria',
    'Forua',
    'Fruiz',
    'Galdakao',
    'Galdames',
    'Gamiz-Fika',
    'Garai',
    'Gatika',
    'Gautegiz Arteaga',
    'Gernika-Lumo',
    'Getxo',
    'Gizaburuaga',
    'Gordexola',
    'Gorliz',
    'Güeñes',
    'Ibarrangelu',
    'Igorre',
    'Ispaster',
    'Iurreta',
    'Izurtza',
    'Karrantza Harana/Valle de Carranza',
    'Kortezubi',
    'Lanestosa',
    'Larrabetzu',
    'Laukiz',
    'Leioa',
    'Lekeitio',
    'Lemoa',
    'Lemoiz',
    'Lezama',
    'Loiu',
    'Mallabia',
    'Mañaria',
    'Markina-Xemein',
    'Maruri-Jatabe',
    'Mendata',
    'Mendexa',
    'Meñaka',
    'Morga',
    'Mundaka',
    'Mungia',
    'Munitibar-Arbatzegi Gerrikaitz',
    'Murueta',
    'Muskiz',
    'Muxika',
    'Nabarniz',
    'Ondarroa',
    'Orozko',
    'Ortuella',
    'Otxandio',
    'Plentzia',
    'Portugalete',
    'Santurtzi',
    'Sestao',
    'Sondika',
    'Sopela',
    'Sopuerta',
    'Sukarrieta',
    'Trucios-Turtzioz',
    'Ubide',
    'Ugao-Miraballes',
    'Urduliz',
    'Urduña/Orduña',
    'Valle de Trápaga-Trapagaran',
    'Zaldibar',
    'Zalla',
    'Zamudio',
    'Zaratamo',
    'Zeanuri',
    'Zeberio',
    'Zierbena',
    'Ziortza-Bolibar '
  ),
/* Province of Zamora */
  'ZA' => array(
    'Abezames',
    'Alcañices',
    'Alcubilla de Nogales',
    'Alfaraz de Sayago',
    'Algodre',
    'Almaraz de Duero',
    'Almeida de Sayago',
    'Andavías',
    'Arcenillas',
    'Arcos de la Polvorosa',
    'Argañín',
    'Argujillo',
    'Arquillinos',
    'Arrabalde',
    'Aspariegos',
    'Asturianos',
    'Ayoó de Vidriales',
    'Barcial del Barco',
    'Belver de los Montes',
    'Benavente',
    'Benegiles',
    'Bermillo de Sayago',
    'Bóveda de Toro, La',
    'Bretó',
    'Bretocino',
    'Brime de Sog',
    'Brime de Urz',
    'Burganes de Valverde',
    'Bustillo del Oro',
    'Cabañas de Sayago',
    'Calzadilla de Tera',
    'Camarzana de Tera',
    'Cañizal',
    'Cañizo',
    'Carbajales de Alba',
    'Carbellino',
    'Casaseca de Campeán',
    'Casaseca de las Chanas',
    'Castrillo de la Guareña',
    'Castrogonzalo',
    'Castronuevo',
    'Castroverde de Campos',
    'Cazurra',
    'Cerecinos de Campos',
    'Cerecinos del Carrizal',
    'Cernadilla',
    'Cobreros',
    'Coomonte',
    'Coreses',
    'Corrales del Vino',
    'Cotanes del Monte',
    'Cubillos',
    'Cubo de Benavente',
    'Cubo de Tierra del Vino, El',
    'Cuelgamures',
    'Entrala',
    'Espadañedo',
    'Faramontanos de Tábara',
    'Fariza',
    'Fermoselle',
    'Ferreras de Abajo',
    'Ferreras de Arriba',
    'Ferreruela',
    'Figueruela de Arriba',
    'Fonfría',
    'Fresno de la Polvorosa',
    'Fresno de la Ribera',
    'Fresno de Sayago',
    'Friera de Valverde',
    'Fuente Encalada',
    'Fuentelapeña',
    'Fuentes de Ropel',
    'Fuentesaúco',
    'Fuentesecas',
    'Fuentespreadas',
    'Galende',
    'Gallegos del Pan',
    'Gallegos del Río',
    'Gamones',
    'Gema',
    'Granja de Moreruela',
    'Granucillo',
    'Guarrate',
    'Hermisende',
    'Hiniesta, La',
    'Jambrina',
    'Justel',
    'Losacino',
    'Losacio',
    'Lubián',
    'Luelmo',
    'Maderal, El',
    'Madridanos',
    'Mahide',
    'Maire de Castroponce',
    'Malva',
    'Manganeses de la Lampreana',
    'Manganeses de la Polvorosa',
    'Manzanal de Arriba',
    'Manzanal de los Infantes',
    'Manzanal del Barco',
    'Matilla de Arzón',
    'Matilla la Seca',
    'Mayalde',
    'Melgar de Tera',
    'Micereces de Tera',
    'Milles de la Polvorosa',
    'Molacillos',
    'Molezuelas de la Carballeda',
    'Mombuey',
    'Monfarracinos',
    'Montamarta',
    'Moral de Sayago',
    'Moraleja de Sayago',
    'Moraleja del Vino',
    'Morales de Rey',
    'Morales de Toro',
    'Morales de Valverde',
    'Morales del Vino',
    'Moralina',
    'Moreruela de los Infanzones',
    'Moreruela de Tábara',
    'Muelas de los Caballeros',
    'Muelas del Pan',
    'Muga de Sayago',
    'Navianos de Valverde',
    'Olmillos de Castro',
    'Otero de Bodas',
    'Pajares de la Lampreana',
    'Palacios de Sanabria',
    'Palacios del Pan',
    'Pedralba de la Pradería',
    'Pego, El',
    'Peleagonzalo',
    'Peleas de Abajo',
    'Peñausende',
    'Peque',
    'Perdigón, El',
    'Pereruela',
    'Perilla de Castro',
    'Pías',
    'Piedrahita de Castro',
    'Pinilla de Toro',
    'Pino del Oro',
    'Piñero, El',
    'Pobladura de Valderaduey',
    'Pobladura del Valle',
    'Porto',
    'Pozoantiguo',
    'Pozuelo de Tábara',
    'Prado',
    'Puebla de Sanabria',
    'Pueblica de Valverde',
    'Quintanilla de Urz',
    'Quintanilla del Monte',
    'Quintanilla del Olmo',
    'Quiruelas de Vidriales',
    'Rabanales',
    'Rábano de Aliste',
    'Requejo',
    'Revellinos',
    'Riofrío de Aliste',
    'Rionegro del Puente',
    'Roales',
    'Robleda-Cervantes',
    'Roelos de Sayago',
    'Rosinos de la Requejada',
    'Salce',
    'Samir de los Caños',
    'San Agustín del Pozo',
    'San Cebrián de Castro',
    'San Cristóbal de Entreviñas',
    'San Esteban del Molar',
    'San Justo',
    'San Martín de Valderaduey',
    'San Miguel de la Ribera',
    'San Miguel del Valle',
    'San Pedro de Ceque',
    'San Pedro de la Nave-Almendra',
    'San Vicente de la Cabeza',
    'San Vitero',
    'Santa Clara de Avedillo',
    'Santa Colomba de las Monjas',
    'Santa Cristina de la Polvorosa',
    'Santa Croya de Tera',
    'Santa Eufemia del Barco',
    'Santa María de la Vega',
    'Santa María de Valverde',
    'Santibáñez de Tera',
    'Santibáñez de Vidriales',
    'Santovenia',
    'Sanzoles',
    'Tábara',
    'Tapioles',
    'Toro',
    'Torre del Valle, La',
    'Torregamones',
    'Torres del Carrizal',
    'Trabazos',
    'Trefacio',
    'Uña de Quintana',
    'Vadillo de la Guareña',
    'Valcabado',
    'Valdefinjas',
    'Valdescorriel',
    'Vallesa de la Guareña',
    'Vega de Tera',
    'Vega de Villalobos',
    'Vegalatrave',
    'Venialbo',
    'Vezdemarbán',
    'Vidayanes',
    'Videmala',
    'Villabrázaro',
    'Villabuena del Puente',
    'Villadepera',
    'Villaescusa',
    'Villafáfila',
    'Villaferrueña',
    'Villageriz',
    'Villalazán',
    'Villalba de la Lampreana',
    'Villalcampo',
    'Villalobos',
    'Villalonso',
    'Villalpando',
    'Villalube',
    'Villamayor de Campos',
    'Villamor de los Escuderos',
    'Villanázar',
    'Villanueva de Azoague',
    'Villanueva de Campeán',
    'Villanueva de las Peras',
    'Villanueva del Campo',
    'Villar de Fallaves',
    'Villar del Buey',
    'Villaralbo',
    'Villardeciervos',
    'Villardiegua de la Ribera',
    'Villárdiga',
    'Villardondiego',
    'Villarrín de Campos',
    'Villaseco del Pan',
    'Villavendimio',
    'Villaveza de Valverde',
    'Villaveza del Agua',
    'Viñas',
    'Zamora',
  ),
/* Province of Zaragoza */
  'Z' => array(
    'Abanto',
    'Acered',
    'Agón',
    'Aguarón',
    'Aguilón',
    'Ainzón',
    'Aladrén',
    'Alagón',
    'Alarba',
    'Alberite de San Juan',
    'Albeta',
    'Alborge',
    'Alcalá de Ebro',
    'Alcalá de Moncayo',
    'Alconchel de Ariza',
    'Aldehuela de Liestos',
    'Alfajarín',
    'Alfamén',
    'Alforque',
    'Alhama de Aragón',
    'Almochuel',
    'Almolda, La',
    'Almonacid de la Cuba',
    'Almonacid de la Sierra',
    'Almunia de Doña Godina, La',
    'Alpartir',
    'Ambel',
    'Anento',
    'Aniñón',
    'Añón de Moncayo',
    'Aranda de Moncayo',
    'Arándiga',
    'Ardisa',
    'Ariza',
    'Artieda',
    'Asín',
    'Atea',
    'Ateca',
    'Azuara',
    'Badules',
    'Bagüés',
    'Balconchán',
    'Bárboles',
    'Bardallur',
    'Belchite',
    'Belmonte de Gracián',
    'Berdejo',
    'Berrueco',
    'Biel',
    'Bijuesca',
    'Biota',
    'Bisimbre',
    'Boquiñeni',
    'Bordalba',
    'Borja',
    'Botorrita',
    'Brea de Aragón',
    'Bubierca',
    'Bujaraloz',
    'Bulbuente',
    'Bureta',
    'Burgo de Ebro, El',
    'Buste, El',
    'Cabañas de Ebro',
    'Cabolafuente',
    'Cadrete',
    'Calatayud',
    'Calatorao',
    'Calcena',
    'Calmarza',
    'Campillo de Aragón',
    'Carenas',
    'Cariñena',
    'Caspe',
    'Castejón de Alarba',
    'Castejón de las Armas',
    'Castejón de Valdejasa',
    'Castiliscar',
    'Cervera de la Cañada',
    'Cerveruela',
    'Cetina',
    'Chiprana',
    'Chodes',
    'Cimballa',
    'Cinco Olivas',
    'Clarés de Ribota',
    'Codo',
    'Codos',
    'Contamina',
    'Cosuenda',
    'Cuarte de Huerva',
    'Cubel',
    'Cuerlas, Las',
    'Daroca',
    'Ejea de los Caballeros',
    'Embid de Ariza',
    'Encinacorba',
    'Épila',
    'Erla',
    'Escatrón',
    'Fabara',
    'Farlete',
    'Fayón',
    'Fayos, Los',
    'Figueruelas',
    'Fombuena',
    'Frago, El',
    'Frasno, El',
    'Fréscano',
    'Fuendejalón',
    'Fuendetodos',
    'Fuentes de Ebro',
    'Fuentes de Jiloca',
    'Gallocanta',
    'Gallur',
    'Gelsa',
    'Godojos',
    'Gotor',
    'Grisel',
    'Grisén',
    'Herrera de los Navarros',
    'Ibdes',
    'Illueca',
    'Isuerre',
    'Jaraba',
    'Jarque de Moncayo',
    'Jaulín',
    'Joyosa, La',
    'Lagata',
    'Langa del Castillo',
    'Layana',
    'Lécera',
    'Lechón',
    'Leciñena',
    'Letux',
    'Litago',
    'Lituénigo',
    'Lobera de Onsella',
    'Longares',
    'Longás',
    'Lucena de Jalón',
    'Luceni',
    'Luesia',
    'Luesma',
    'Lumpiaque',
    'Luna',
    'Maella',
    'Magallón',
    'Mainar',
    'Malanquilla',
    'Maleján',
    'Mallén',
    'Malón',
    'Maluenda',
    'Manchones',
    'Mara',
    'María de Huerva',
    'Marracos',
    'Mediana de Aragón',
    'Mequinenza',
    'Mesones de Isuela',
    'Mezalocha',
    'Mianos',
    'Miedes de Aragón',
    'Monegrillo',
    'Moneva',
    'Monreal de Ariza',
    'Monterde',
    'Montón',
    'Morata de Jalón',
    'Morata de Jiloca',
    'Morés',
    'Moros',
    'Moyuela',
    'Mozota',
    'Muel',
    'Muela, La',
    'Munébrega',
    'Murero',
    'Murillo de Gállego',
    'Navardún',
    'Nigüella',
    'Nombrevilla',
    'Nonaspe',
    'Novallas',
    'Novillas',
    'Nuévalos',
    'Nuez de Ebro',
    'Olvés',
    'Orcajo',
    'Orera',
    'Orés',
    'Oseja',
    'Osera de Ebro',
    'Paniza',
    'Paracuellos de Jiloca',
    'Paracuellos de la Ribera',
    'Pastriz',
    'Pedrola',
    'Pedrosas, Las',
    'Perdiguera',
    'Piedratajada',
    'Pina de Ebro',
    'Pinseque',
    'Pintanos, Los',
    'Plasencia de Jalón',
    'Pleitas',
    'Plenas',
    'Pomer',
    'Pozuel de Ariza',
    'Pozuelo de Aragón',
    'Pradilla de Ebro',
    'Puebla de Albortón',
    'Puebla de Alfindén, La',
    'Puendeluna',
    'Purujosa',
    'Quinto',
    'Remolinos',
    'Retascón',
    'Ricla',
    'Romanos',
    'Rueda de Jalón',
    'Ruesca',
    'Sabiñán',
    'Sádaba',
    'Salillas de Jalón',
    'Salvatierra de Esca',
    'Samper del Salz',
    'San Martín de la Virgen de Moncayo',
    'San Mateo de Gállego',
    'Santa Cruz de Grío',
    'Santa Cruz de Moncayo',
    'Santa Eulalia de Gállego',
    'Santed',
    'Sástago',
    'Sediles',
    'Sestrica',
    'Sierra de Luna',
    'Sigüés',
    'Sisamón',
    'Sobradiel',
    'Sos del Rey Católico',
    'Tabuenca',
    'Talamantes',
    'Tarazona',
    'Tauste',
    'Terrer',
    'Tierga',
    'Tobed',
    'Torralba de los Frailes',
    'Torralba de Ribota',
    'Torralbilla',
    'Torrehermosa',
    'Torrelapaja',
    'Torrellas',
    'Torres de Berrellén',
    'Torrijo de la Cañada',
    'Tosos',
    'Trasmoz',
    'Trasobares',
    'Uncastillo',
    'Undués de Lerda',
    'Urrea de Jalón',
    'Urriés',
    'Used',
    'Utebo',
    'Val de San Martín',
    'Valdehorna',
    'Valmadrid',
    'Valpalmas',
    'Valtorres',
    'Velilla de Ebro',
    'Velilla de Jiloca',
    'Vera de Moncayo',
    'Vierlas',
    'Villadoz',
    'Villafeliche',
    'Villafranca de Ebro',
    'Villalba de Perejil',
    'Villalengua',
    'Villamayor de Gállego',
    'Villanueva de Gállego',
    'Villanueva de Huerva',
    'Villanueva de Jiloca',
    'Villar de los Navarros',
    'Villarreal de Huerva',
    'Villarroya de la Sierra',
    'Villarroya del Campo',
    'Vilueña, La',
    'Vistabella',
    'Zaida, La',
    'Zaragoza',
    'Zuera',
  ),
);

// Use this filter to handle the Municipalities of Spain
$places['ES'] = apply_filters('scpwoo_custom_places_es', $places['ES']);
