<?php

/**
 * Cities of Colombia
 *
 * - Source
 *  - https://en.wikipedia.org/wiki/List_of_cities_and_towns_in_Colombia
 *  - 1119 cities
 *
 * @author  José Ayram <ayramj@gmail.com>
 * @author  José Ayram
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */
global $places;

$places['CO'] = array(
	'AMA' => array(
		'CO-AMA-0001' => 'El Encanto',
		'CO-AMA-0002' => 'La Chorrera',
		'CO-AMA-0003' => 'La Pedrera',
		'CO-AMA-0004' => 'La Victoria',
		'CO-AMA-0005' => 'Leticia',
		'CO-AMA-0006' => 'Mirití-Paraná',
		'CO-AMA-0007' => 'Puerto Alegría',
		'CO-AMA-0008' => 'Puerto Arica',
		'CO-AMA-0009' => 'Puerto Nariño',
		'CO-AMA-0010' => 'Puerto Santander',
		'CO-AMA-0011' => 'Tarapacá',
	),
	'ANT' => array(
		'CO-ANT-0012' => 'Abejorral',
		'CO-ANT-0013' => 'Abriaquí',
		'CO-ANT-0014' => 'Alejandría',
		'CO-ANT-0015' => 'Amagá',
		'CO-ANT-0016' => 'Amalfi',
		'CO-ANT-0017' => 'Andes',
		'CO-ANT-0018' => 'Angelópolis',
		'CO-ANT-0019' => 'Angostura',
		'CO-ANT-0020' => 'Anorí',
		'CO-ANT-0021' => 'Anza',
		'CO-ANT-0022' => 'Apartadó',
		'CO-ANT-0023' => 'Arboletes',
		'CO-ANT-0024' => 'Argelia',
		'CO-ANT-0025' => 'Armenia',
		'CO-ANT-0026' => 'Barbosa',
		'CO-ANT-0027' => 'Bello',
		'CO-ANT-0028' => 'Belmira',
		'CO-ANT-0029' => 'Betania',
		'CO-ANT-0030' => 'Betulia',
		'CO-ANT-0031' => 'Briceño',
		'CO-ANT-0032' => 'Buriticá',
		'CO-ANT-0033' => 'Cáceres',
		'CO-ANT-0034' => 'Caicedo',
		'CO-ANT-0035' => 'Caldas',
		'CO-ANT-0036' => 'Campamento',
		'CO-ANT-0037' => 'Cañasgordas',
		'CO-ANT-0038' => 'Caracolí',
		'CO-ANT-0039' => 'Caramanta',
		'CO-ANT-0040' => 'Carepa',
		'CO-ANT-0041' => 'Carolina',
		'CO-ANT-0042' => 'Caucasia',
		'CO-ANT-0043' => 'Chigorodó',
		'CO-ANT-0044' => 'Cisneros',
		'CO-ANT-0045' => 'Ciudad Bolívar',
		'CO-ANT-0046' => 'Cocorná',
		'CO-ANT-0047' => 'Concepción',
		'CO-ANT-0048' => 'Concordia',
		'CO-ANT-0049' => 'Copacabana',
		'CO-ANT-0050' => 'Dabeiba',
		'CO-ANT-0051' => 'Don Matías',
		'CO-ANT-0052' => 'Ebéjico',
		'CO-ANT-0053' => 'El Bagre',
		'CO-ANT-0054' => 'El Carmen De Viboral',
		'CO-ANT-0055' => 'El Santuario',
		'CO-ANT-0056' => 'Entrerrios',
		'CO-ANT-0057' => 'Envigado',
		'CO-ANT-0058' => 'Fredonia',
		'CO-ANT-0059' => 'Frontino',
		'CO-ANT-0060' => 'Giraldo',
		'CO-ANT-0061' => 'Girardota',
		'CO-ANT-0062' => 'Gómez Plata',
		'CO-ANT-0063' => 'Granada',
		'CO-ANT-0064' => 'Guadalupe',
		'CO-ANT-0065' => 'Guarne',
		'CO-ANT-0066' => 'Guatape',
		'CO-ANT-0067' => 'Heliconia',
		'CO-ANT-0068' => 'Hispania',
		'CO-ANT-0069' => 'Itagui',
		'CO-ANT-0070' => 'Ituango',
		'CO-ANT-0071' => 'Jardín',
		'CO-ANT-0072' => 'Jericó',
		'CO-ANT-0073' => 'La Ceja',
		'CO-ANT-0074' => 'La Estrella',
		'CO-ANT-0075' => 'La Pintada',
		'CO-ANT-0076' => 'La Unión',
		'CO-ANT-0077' => 'Liborina',
		'CO-ANT-0078' => 'Maceo',
		'CO-ANT-0079' => 'Marinilla',
		'CO-ANT-0080' => 'Medellín',
		'CO-ANT-0081' => 'Montebello',
		'CO-ANT-0082' => 'Murindó',
		'CO-ANT-0083' => 'Mutatá',
		'CO-ANT-0084' => 'Nariño',
		'CO-ANT-0085' => 'Nechí',
		'CO-ANT-0086' => 'Necoclí',
		'CO-ANT-0087' => 'Olaya',
		'CO-ANT-0088' => 'Peñol',
		'CO-ANT-0089' => 'Peque',
		'CO-ANT-0090' => 'Pueblorrico',
		'CO-ANT-0091' => 'Puerto Berrío',
		'CO-ANT-0092' => 'Puerto Nare',
		'CO-ANT-0093' => 'Puerto Triunfo',
		'CO-ANT-0094' => 'Remedios',
		'CO-ANT-0095' => 'Retiro',
		'CO-ANT-0096' => 'Rionegro',
		'CO-ANT-0097' => 'Sabanalarga',
		'CO-ANT-0098' => 'Sabaneta',
		'CO-ANT-0099' => 'Salgar',
		'CO-ANT-0100' => 'San Andrés',
		'CO-ANT-0101' => 'San Carlos',
		'CO-ANT-0102' => 'San Francisco',
		'CO-ANT-0103' => 'San Jerónimo',
		'CO-ANT-0104' => 'San José De La Montaña',
		'CO-ANT-0105' => 'San Juan De Urabá',
		'CO-ANT-0106' => 'San Luis',
		'CO-ANT-0107' => 'San Pedro',
		'CO-ANT-0108' => 'San Pedro De Uraba',
		'CO-ANT-0109' => 'San Rafael',
		'CO-ANT-0110' => 'San Roque',
		'CO-ANT-0111' => 'San Vicente',
		'CO-ANT-0112' => 'Santa Bárbara',
		'CO-ANT-0113' => 'Santa Rosa De Osos',
		'CO-ANT-0114' => 'Santafé De Antioquia',
		'CO-ANT-0115' => 'Santo Domingo',
		'CO-ANT-0116' => 'Segovia',
		'CO-ANT-0117' => 'Sonson',
		'CO-ANT-0118' => 'Sopetrán',
		'CO-ANT-0119' => 'Támesis',
		'CO-ANT-0120' => 'Tarazá',
		'CO-ANT-0121' => 'Tarso',
		'CO-ANT-0122' => 'Titiribí',
		'CO-ANT-0123' => 'Toledo',
		'CO-ANT-0124' => 'Turbo',
		'CO-ANT-0125' => 'Uramita',
		'CO-ANT-0126' => 'Urrao',
		'CO-ANT-0127' => 'Valdivia',
		'CO-ANT-0128' => 'Valparaíso',
		'CO-ANT-0129' => 'Vegachí',
		'CO-ANT-0130' => 'Venecia',
		'CO-ANT-0131' => 'Vigía Del Fuerte',
		'CO-ANT-0132' => 'Yalí',
		'CO-ANT-0133' => 'Yarumal',
		'CO-ANT-0134' => 'Yolombó',
		'CO-ANT-0135' => 'Yondó',
		'CO-ANT-0136' => 'Zaragoza',
	),
	'ARA' => array(
		'CO-ARA-0137' => 'Arauca',
		'CO-ARA-0138' => 'Arauquita',
		'CO-ARA-0139' => 'Cravo Norte',
		'CO-ARA-0140' => 'Fortul',
		'CO-ARA-0141' => 'Puerto Rondón',
		'CO-ARA-0142' => 'Saravena',
		'CO-ARA-0143' => 'Tame',
	),
	'ATL' => array(
		'CO-ATL-0144' => 'Baranoa',
		'CO-ATL-0145' => 'Barranquilla',
		'CO-ATL-0146' => 'Campo De La Cruz',
		'CO-ATL-0147' => 'Candelaria',
		'CO-ATL-0148' => 'Galapa',
		'CO-ATL-0149' => 'Juan De Acosta',
		'CO-ATL-0150' => 'Luruaco',
		'CO-ATL-0151' => 'Malambo',
		'CO-ATL-0152' => 'Manatí',
		'CO-ATL-0153' => 'Palmar De Varela',
		'CO-ATL-0154' => 'Piojó',
		'CO-ATL-0155' => 'Polonuevo',
		'CO-ATL-0156' => 'Ponedera',
		'CO-ATL-0157' => 'Puerto Colombia',
		'CO-ATL-0158' => 'Repelón',
		'CO-ATL-0159' => 'Sabanagrande',
		'CO-ATL-0160' => 'Sabanalarga',
		'CO-ATL-0161' => 'Santa Lucía',
		'CO-ATL-0162' => 'Santo Tomás',
		'CO-ATL-0163' => 'Soledad',
		'CO-ATL-0164' => 'Suan',
		'CO-ATL-0165' => 'Tubará',
		'CO-ATL-0166' => 'Usiacurí',
	),
	'DC' => array(
		'CO-DC-0167' => 'Bogotá',
	),
	'BOL' => array(
		'CO-BOL-0168' => 'Achí',
		'CO-BOL-0169' => 'Altos Del Rosario',
		'CO-BOL-0170' => 'Arenal',
		'CO-BOL-0171' => 'Arjona',
		'CO-BOL-0172' => 'Arroyohondo',
		'CO-BOL-0173' => 'Barranco De Loba',
		'CO-BOL-0174' => 'Calamar',
		'CO-BOL-0175' => 'Cantagallo',
		'CO-BOL-0176' => 'Cartagena',
		'CO-BOL-0177' => 'Cicuco',
		'CO-BOL-0178' => 'Clemencia',
		'CO-BOL-0179' => 'Córdoba',
		'CO-BOL-0180' => 'El Carmen De Bolívar',
		'CO-BOL-0181' => 'El Guamo',
		'CO-BOL-0182' => 'El Peñón',
		'CO-BOL-0183' => 'Hatillo De Loba',
		'CO-BOL-0184' => 'Magangué',
		'CO-BOL-0185' => 'Mahates',
		'CO-BOL-0186' => 'Margarita',
		'CO-BOL-0187' => 'María La Baja',
		'CO-BOL-0188' => 'Mompós',
		'CO-BOL-0189' => 'Montecristo',
		'CO-BOL-0190' => 'Morales',
		'CO-BOL-0191' => 'Pinillos',
		'CO-BOL-0192' => 'Regidor',
		'CO-BOL-0193' => 'Río Viejo',
		'CO-BOL-0194' => 'San Cristóbal',
		'CO-BOL-0195' => 'San Estanislao',
		'CO-BOL-0196' => 'San Fernando',
		'CO-BOL-0197' => 'San Jacinto',
		'CO-BOL-0198' => 'San Jacinto Del Cauca',
		'CO-BOL-0199' => 'San Juan Nepomuceno',
		'CO-BOL-0200' => 'San Martín De Loba',
		'CO-BOL-0201' => 'San Pablo',
		'CO-BOL-0202' => 'Santa Catalina',
		'CO-BOL-0203' => 'Santa Rosa',
		'CO-BOL-0204' => 'Santa Rosa Del Sur',
		'CO-BOL-0205' => 'Simití',
		'CO-BOL-0206' => 'Soplaviento',
		'CO-BOL-0207' => 'Talaigua Nuevo',
		'CO-BOL-0208' => 'Tiquisio',
		'CO-BOL-0209' => 'Turbaco',
		'CO-BOL-0210' => 'Turbaná',
		'CO-BOL-0211' => 'Villanueva',
		'CO-BOL-0212' => 'Zambrano',
	),
	'BOY' => array(
		'CO-BOY-0213' => 'Almeida',
		'CO-BOY-0214' => 'Aquitania',
		'CO-BOY-0215' => 'Arcabuco',
		'CO-BOY-0216' => 'Belén',
		'CO-BOY-0217' => 'Berbeo',
		'CO-BOY-0218' => 'Betéitiva',
		'CO-BOY-0219' => 'Boavita',
		'CO-BOY-0220' => 'Boyacá',
		'CO-BOY-0221' => 'Briceño',
		'CO-BOY-0222' => 'Buenavista',
		'CO-BOY-0223' => 'Busbanzá',
		'CO-BOY-0224' => 'Caldas',
		'CO-BOY-0225' => 'Campohermoso',
		'CO-BOY-0226' => 'Cerinza',
		'CO-BOY-0227' => 'Chinavita',
		'CO-BOY-0228' => 'Chiquinquirá',
		'CO-BOY-0229' => 'Chíquiza',
		'CO-BOY-0230' => 'Chiscas',
		'CO-BOY-0231' => 'Chita',
		'CO-BOY-0232' => 'Chitaraque',
		'CO-BOY-0233' => 'Chivatá',
		'CO-BOY-0234' => 'Chivor',
		'CO-BOY-0235' => 'Ciénega',
		'CO-BOY-0236' => 'Cómbita',
		'CO-BOY-0237' => 'Coper',
		'CO-BOY-0238' => 'Corrales',
		'CO-BOY-0239' => 'Covarachía',
		'CO-BOY-0240' => 'Cubará',
		'CO-BOY-0241' => 'Cucaita',
		'CO-BOY-0242' => 'Cuítiva',
		'CO-BOY-0243' => 'Duitama',
		'CO-BOY-0244' => 'El Cocuy',
		'CO-BOY-0245' => 'El Espino',
		'CO-BOY-0246' => 'Firavitoba',
		'CO-BOY-0247' => 'Floresta',
		'CO-BOY-0248' => 'Gachantivá',
		'CO-BOY-0249' => 'Gameza',
		'CO-BOY-0250' => 'Garagoa',
		'CO-BOY-0251' => 'Guacamayas',
		'CO-BOY-0252' => 'Guateque',
		'CO-BOY-0253' => 'Guayatá',
		'CO-BOY-0254' => 'Güicán',
		'CO-BOY-0255' => 'Iza',
		'CO-BOY-0256' => 'Jenesano',
		'CO-BOY-0257' => 'Jericó',
		'CO-BOY-0258' => 'La Capilla',
		'CO-BOY-0259' => 'La Uvita',
		'CO-BOY-0260' => 'La Victoria',
		'CO-BOY-0261' => 'Labranzagrande',
		'CO-BOY-0262' => 'Macanal',
		'CO-BOY-0263' => 'Maripí',
		'CO-BOY-0264' => 'Miraflores',
		'CO-BOY-0265' => 'Mongua',
		'CO-BOY-0266' => 'Monguí',
		'CO-BOY-0267' => 'Moniquirá',
		'CO-BOY-0268' => 'Motavita',
		'CO-BOY-0269' => 'Muzo',
		'CO-BOY-0270' => 'Nobsa',
		'CO-BOY-0271' => 'Nuevo Colón',
		'CO-BOY-0272' => 'Oicatá',
		'CO-BOY-0273' => 'Otanche',
		'CO-BOY-0274' => 'Pachavita',
		'CO-BOY-0275' => 'Páez',
		'CO-BOY-0276' => 'Paipa',
		'CO-BOY-0277' => 'Pajarito',
		'CO-BOY-0278' => 'Panqueba',
		'CO-BOY-0279' => 'Pauna',
		'CO-BOY-0280' => 'Paya',
		'CO-BOY-0281' => 'Paz De Río',
		'CO-BOY-0282' => 'Pesca',
		'CO-BOY-0283' => 'Pisba',
		'CO-BOY-0284' => 'Puerto Boyacá',
		'CO-BOY-0285' => 'Quípama',
		'CO-BOY-0286' => 'Ramiriquí',
		'CO-BOY-0287' => 'Ráquira',
		'CO-BOY-0288' => 'Rondón',
		'CO-BOY-0289' => 'Saboyá',
		'CO-BOY-0290' => 'Sáchica',
		'CO-BOY-0291' => 'Samacá',
		'CO-BOY-0292' => 'San Eduardo',
		'CO-BOY-0293' => 'San José De Pare',
		'CO-BOY-0294' => 'San Luis De Gaceno',
		'CO-BOY-0295' => 'San Mateo',
		'CO-BOY-0296' => 'San Miguel De Sema',
		'CO-BOY-0297' => 'San Pablo De Borbur',
		'CO-BOY-0298' => 'Santa María',
		'CO-BOY-0299' => 'Santa Rosa De Viterbo',
		'CO-BOY-0300' => 'Santa Sofía',
		'CO-BOY-0301' => 'Santana',
		'CO-BOY-0302' => 'Sativanorte',
		'CO-BOY-0303' => 'Sativasur',
		'CO-BOY-0304' => 'Siachoque',
		'CO-BOY-0305' => 'Soatá',
		'CO-BOY-0306' => 'Socha',
		'CO-BOY-0307' => 'Socotá',
		'CO-BOY-0308' => 'Sogamoso',
		'CO-BOY-0309' => 'Somondoco',
		'CO-BOY-0310' => 'Sora',
		'CO-BOY-0311' => 'Soracá',
		'CO-BOY-0312' => 'Sotaquirá',
		'CO-BOY-0313' => 'Susacón',
		'CO-BOY-0314' => 'Sutamarchán',
		'CO-BOY-0315' => 'Sutatenza',
		'CO-BOY-0316' => 'Tasco',
		'CO-BOY-0317' => 'Tenza',
		'CO-BOY-0318' => 'Tibaná',
		'CO-BOY-0319' => 'Tibasosa',
		'CO-BOY-0320' => 'Tinjacá',
		'CO-BOY-0321' => 'Tipacoque',
		'CO-BOY-0322' => 'Toca',
		'CO-BOY-0323' => 'Togüí',
		'CO-BOY-0324' => 'Tópaga',
		'CO-BOY-0325' => 'Tota',
		'CO-BOY-0326' => 'Tunja',
		'CO-BOY-0327' => 'Tununguá',
		'CO-BOY-0328' => 'Turmequé',
		'CO-BOY-0329' => 'Tuta',
		'CO-BOY-0330' => 'Tutazá',
		'CO-BOY-0331' => 'Umbita',
		'CO-BOY-0332' => 'Ventaquemada',
		'CO-BOY-0333' => 'Villa De Leyva',
		'CO-BOY-0334' => 'Viracachá',
		'CO-BOY-0335' => 'Zetaquira',
	),
	'CAL' => array(
		'CO-CAL-0336' => 'Aguadas',
		'CO-CAL-0337' => 'Anserma',
		'CO-CAL-0338' => 'Aranzazu',
		'CO-CAL-0339' => 'Belalcázar',
		'CO-CAL-0340' => 'Chinchiná',
		'CO-CAL-0341' => 'Filadelfia',
		'CO-CAL-0342' => 'La Dorada',
		'CO-CAL-0343' => 'La Merced',
		'CO-CAL-0344' => 'Manizales',
		'CO-CAL-0345' => 'Manzanares',
		'CO-CAL-0346' => 'Marmato',
		'CO-CAL-0347' => 'Marquetalia',
		'CO-CAL-0348' => 'Marulanda',
		'CO-CAL-0349' => 'Neira',
		'CO-CAL-0350' => 'Norcasia',
		'CO-CAL-0351' => 'Pácora',
		'CO-CAL-0352' => 'Palestina',
		'CO-CAL-0353' => 'Pensilvania',
		'CO-CAL-0354' => 'Riosucio',
		'CO-CAL-0355' => 'Risaralda',
		'CO-CAL-0356' => 'Salamina',
		'CO-CAL-0357' => 'Samaná',
		'CO-CAL-0358' => 'San José',
		'CO-CAL-0359' => 'Supía',
		'CO-CAL-0360' => 'Victoria',
		'CO-CAL-0361' => 'Villamaría',
		'CO-CAL-0362' => 'Viterbo',
	),
	'CAQ' => array(
		'CO-CAQ-0363' => 'Albania',
		'CO-CAQ-0364' => 'Belén De Los Andaquies',
		'CO-CAQ-0365' => 'Cartagena Del Chairá',
		'CO-CAQ-0366' => 'Curillo',
		'CO-CAQ-0367' => 'El Doncello',
		'CO-CAQ-0368' => 'El Paujil',
		'CO-CAQ-0369' => 'Florencia',
		'CO-CAQ-0370' => 'La Montañita',
		'CO-CAQ-0371' => 'Milán',
		'CO-CAQ-0372' => 'Morelia',
		'CO-CAQ-0373' => 'Puerto Rico',
		'CO-CAQ-0374' => 'San José Del Fragua',
		'CO-CAQ-0375' => 'San Vicente Del Caguán',
		'CO-CAQ-0376' => 'Solano',
		'CO-CAQ-0377' => 'Solita',
		'CO-CAQ-0378' => 'Valparaíso',
	),
	'CAS' => array(
		'CO-CAS-0379' => 'Aguazul',
		'CO-CAS-0380' => 'Chameza',
		'CO-CAS-0381' => 'Hato Corozal',
		'CO-CAS-0382' => 'La Salina',
		'CO-CAS-0383' => 'Maní',
		'CO-CAS-0384' => 'Monterrey',
		'CO-CAS-0385' => 'Nunchía',
		'CO-CAS-0386' => 'Orocué',
		'CO-CAS-0387' => 'Paz De Ariporo',
		'CO-CAS-0388' => 'Pore',
		'CO-CAS-0389' => 'Recetor',
		'CO-CAS-0390' => 'Sabanalarga',
		'CO-CAS-0391' => 'Sácama',
		'CO-CAS-0392' => 'San Luis De Palenque',
		'CO-CAS-0393' => 'Támara',
		'CO-CAS-0394' => 'Tauramena',
		'CO-CAS-0395' => 'Trinidad',
		'CO-CAS-0396' => 'Villanueva',
		'CO-CAS-0397' => 'Yopal',
	),
	'CAU' => array(
		'CO-CAU-0398' => 'Almaguer',
		'CO-CAU-0399' => 'Argelia',
		'CO-CAU-0400' => 'Balboa',
		'CO-CAU-0401' => 'Bolívar',
		'CO-CAU-0402' => 'Buenos Aires',
		'CO-CAU-0403' => 'Cajibío',
		'CO-CAU-0404' => 'Caldono',
		'CO-CAU-0405' => 'Caloto',
		'CO-CAU-0406' => 'Corinto',
		'CO-CAU-0407' => 'El Tambo',
		'CO-CAU-0408' => 'Florencia',
		'CO-CAU-0409' => 'Guapi',
		'CO-CAU-0410' => 'Inzá',
		'CO-CAU-0411' => 'Jambaló',
		'CO-CAU-0412' => 'La Sierra',
		'CO-CAU-0413' => 'La Vega',
		'CO-CAU-0414' => 'López',
		'CO-CAU-0415' => 'Mercaderes',
		'CO-CAU-0416' => 'Miranda',
		'CO-CAU-0417' => 'Morales',
		'CO-CAU-0418' => 'Padilla',
		'CO-CAU-0419' => 'Paez',
		'CO-CAU-0420' => 'Patía',
		'CO-CAU-0421' => 'Piamonte',
		'CO-CAU-0422' => 'Piendamó',
		'CO-CAU-0423' => 'Popayán',
		'CO-CAU-0424' => 'Puerto Tejada',
		'CO-CAU-0425' => 'Puracé',
		'CO-CAU-0426' => 'Rosas',
		'CO-CAU-0427' => 'San Sebastián',
		'CO-CAU-0428' => 'Santa Rosa',
		'CO-CAU-0429' => 'Santander De Quilichao',
		'CO-CAU-0430' => 'Silvia',
		'CO-CAU-0431' => 'Sotara',
		'CO-CAU-0432' => 'Suárez',
		'CO-CAU-0433' => 'Sucre',
		'CO-CAU-0434' => 'Timbío',
		'CO-CAU-0435' => 'Timbiquí',
		'CO-CAU-0436' => 'Toribio',
		'CO-CAU-0437' => 'Totoró',
		'CO-CAU-0438' => 'Villa Rica',
	),
	'CES' => array(
		'CO-CES-0439' => 'Aguachica',
		'CO-CES-0440' => 'Agustín Codazzi',
		'CO-CES-0441' => 'Astrea',
		'CO-CES-0442' => 'Becerril',
		'CO-CES-0443' => 'Bosconia',
		'CO-CES-0444' => 'Chimichagua',
		'CO-CES-0445' => 'Chiriguaná',
		'CO-CES-0446' => 'Curumaní',
		'CO-CES-0447' => 'El Copey',
		'CO-CES-0448' => 'El Paso',
		'CO-CES-0449' => 'Gamarra',
		'CO-CES-0450' => 'González',
		'CO-CES-0451' => 'La Gloria',
		'CO-CES-0452' => 'La Jagua De Ibirico',
		'CO-CES-0453' => 'La Paz',
		'CO-CES-0454' => 'Manaure',
		'CO-CES-0455' => 'Pailitas',
		'CO-CES-0456' => 'Pelaya',
		'CO-CES-0457' => 'Pueblo Bello',
		'CO-CES-0458' => 'Río De Oro',
		'CO-CES-0459' => 'San Alberto',
		'CO-CES-0460' => 'San Diego',
		'CO-CES-0461' => 'San Martín',
		'CO-CES-0462' => 'Tamalameque',
		'CO-CES-0463' => 'Valledupar',
	),
	'CHO' => array(
		'CO-CHO-0464' => 'Acandí',
		'CO-CHO-0465' => 'Alto Baudo',
		'CO-CHO-0466' => 'Atrato',
		'CO-CHO-0467' => 'Bagadó',
		'CO-CHO-0468' => 'Bahía Solano',
		'CO-CHO-0469' => 'Bajo Baudó',
		'CO-CHO-0470' => 'Belén De Bajirá',
		'CO-CHO-0471' => 'Bojaya',
		'CO-CHO-0472' => 'Carmen Del Darien',
		'CO-CHO-0473' => 'Cértegui',
		'CO-CHO-0474' => 'Condoto',
		'CO-CHO-0475' => 'El Cantón Del San Pablo',
		'CO-CHO-0476' => 'El Carmen De Atrato',
		'CO-CHO-0477' => 'El Litoral Del San Juan',
		'CO-CHO-0478' => 'Istmina',
		'CO-CHO-0479' => 'Juradó',
		'CO-CHO-0480' => 'Lloró',
		'CO-CHO-0481' => 'Medio Atrato',
		'CO-CHO-0482' => 'Medio Baudó',
		'CO-CHO-0483' => 'Medio San Juan',
		'CO-CHO-0484' => 'Nóvita',
		'CO-CHO-0485' => 'Nuquí',
		'CO-CHO-0486' => 'Quibdó',
		'CO-CHO-0487' => 'Río Iro',
		'CO-CHO-0488' => 'Río Quito',
		'CO-CHO-0489' => 'Riosucio',
		'CO-CHO-0490' => 'San José Del Palmar',
		'CO-CHO-0491' => 'Sipí',
		'CO-CHO-0492' => 'Tadó',
		'CO-CHO-0493' => 'Unguía',
		'CO-CHO-0494' => 'Unión Panamericana',
	),
	'COR' => array(
		'CO-COR-0495' => 'Ayapel',
		'CO-COR-0496' => 'Buenavista',
		'CO-COR-0497' => 'Canalete',
		'CO-COR-0498' => 'Cereté',
		'CO-COR-0499' => 'Chimá',
		'CO-COR-0500' => 'Chinú',
		'CO-COR-0501' => 'Ciénaga De Oro',
		'CO-COR-0502' => 'Cotorra',
		'CO-COR-0503' => 'La Apartada',
		'CO-COR-0504' => 'Lorica',
		'CO-COR-0505' => 'Los Córdobas',
		'CO-COR-0506' => 'Momil',
		'CO-COR-0507' => 'Montelíbano',
		'CO-COR-0508' => 'Montería',
		'CO-COR-0509' => 'Moñitos',
		'CO-COR-0510' => 'Planeta Rica',
		'CO-COR-0511' => 'Pueblo Nuevo',
		'CO-COR-0512' => 'Puerto Escondido',
		'CO-COR-0513' => 'Puerto Libertador',
		'CO-COR-0514' => 'Purísima',
		'CO-COR-0515' => 'Sahagún',
		'CO-COR-0516' => 'San Andrés Sotavento',
		'CO-COR-0517' => 'San Antero',
		'CO-COR-0518' => 'San Bernardo Del Viento',
		'CO-COR-0519' => 'San Carlos',
		'CO-COR-0520' => 'San Pelayo',
		'CO-COR-0521' => 'Tierralta',
		'CO-COR-0522' => 'Valencia',
	),
	'CUN' => array(
		'CO-CUN-0523' => 'Agua De Dios',
		'CO-CUN-0524' => 'Albán',
		'CO-CUN-0525' => 'Anapoima',
		'CO-CUN-0526' => 'Anolaima',
		'CO-CUN-0527' => 'Apulo',
		'CO-CUN-0528' => 'Arbeláez',
		'CO-CUN-0529' => 'Beltrán',
		'CO-CUN-0530' => 'Bituima',
		'CO-CUN-0531' => 'Bojacá',
		'CO-CUN-0532' => 'Cabrera',
		'CO-CUN-0533' => 'Cachipay',
		'CO-CUN-0534' => 'Cajicá',
		'CO-CUN-0535' => 'Caparrapí',
		'CO-CUN-0536' => 'Caqueza',
		'CO-CUN-0537' => 'Carmen De Carupa',
		'CO-CUN-0538' => 'Chaguaní',
		'CO-CUN-0539' => 'Chía',
		'CO-CUN-0540' => 'Chipaque',
		'CO-CUN-0541' => 'Choachí',
		'CO-CUN-0542' => 'Chocontá',
		'CO-CUN-0543' => 'Cogua',
		'CO-CUN-0544' => 'Cota',
		'CO-CUN-0545' => 'Cucunubá',
		'CO-CUN-0546' => 'El Colegio',
		'CO-CUN-0547' => 'El Peñón',
		'CO-CUN-0548' => 'El Rosal',
		'CO-CUN-0549' => 'Facatativá',
		'CO-CUN-0550' => 'Fomeque',
		'CO-CUN-0551' => 'Fosca',
		'CO-CUN-0552' => 'Funza',
		'CO-CUN-0553' => 'Fúquene',
		'CO-CUN-0554' => 'Fusagasugá',
		'CO-CUN-0555' => 'Gachala',
		'CO-CUN-0556' => 'Gachancipá',
		'CO-CUN-0557' => 'Gachetá',
		'CO-CUN-0558' => 'Gama',
		'CO-CUN-0559' => 'Girardot',
		'CO-CUN-0560' => 'Granada',
		'CO-CUN-0561' => 'Guachetá',
		'CO-CUN-0562' => 'Guaduas',
		'CO-CUN-0563' => 'Guasca',
		'CO-CUN-0564' => 'Guataquí',
		'CO-CUN-0565' => 'Guatavita',
		'CO-CUN-0566' => 'Guayabal De Siquima',
		'CO-CUN-0567' => 'Guayabetal',
		'CO-CUN-0568' => 'Gutiérrez',
		'CO-CUN-0569' => 'Jerusalén',
		'CO-CUN-0570' => 'Junín',
		'CO-CUN-0571' => 'La Calera',
		'CO-CUN-0572' => 'La Mesa',
		'CO-CUN-0573' => 'La Palma',
		'CO-CUN-0574' => 'La Peña',
		'CO-CUN-0575' => 'La Vega',
		'CO-CUN-0576' => 'Lenguazaque',
		'CO-CUN-0577' => 'Macheta',
		'CO-CUN-0578' => 'Madrid',
		'CO-CUN-0579' => 'Manta',
		'CO-CUN-0580' => 'Medina',
		'CO-CUN-0581' => 'Mosquera',
		'CO-CUN-0582' => 'Nariño',
		'CO-CUN-0583' => 'Nemocón',
		'CO-CUN-0584' => 'Nilo',
		'CO-CUN-0585' => 'Nimaima',
		'CO-CUN-0586' => 'Nocaima',
		'CO-CUN-0587' => 'Pacho',
		'CO-CUN-0588' => 'Paime',
		'CO-CUN-0589' => 'Pandi',
		'CO-CUN-0590' => 'Paratebueno',
		'CO-CUN-0591' => 'Pasca',
		'CO-CUN-0592' => 'Puerto Salgar',
		'CO-CUN-0593' => 'Pulí',
		'CO-CUN-0594' => 'Quebradanegra',
		'CO-CUN-0595' => 'Quetame',
		'CO-CUN-0596' => 'Quipile',
		'CO-CUN-0597' => 'Ricaurte',
		'CO-CUN-0598' => 'San Antonio Del Tequendama',
		'CO-CUN-0599' => 'San Bernardo',
		'CO-CUN-0600' => 'San Cayetano',
		'CO-CUN-0601' => 'San Francisco',
		'CO-CUN-0602' => 'San Juan De Río Seco',
		'CO-CUN-0603' => 'Sasaima',
		'CO-CUN-0604' => 'Sesquilé',
		'CO-CUN-0605' => 'Sibaté',
		'CO-CUN-0606' => 'Silvania',
		'CO-CUN-0607' => 'Simijaca',
		'CO-CUN-0608' => 'Soacha',
		'CO-CUN-0609' => 'Sopó',
		'CO-CUN-0610' => 'Subachoque',
		'CO-CUN-0611' => 'Suesca',
		'CO-CUN-0612' => 'Supatá',
		'CO-CUN-0613' => 'Susa',
		'CO-CUN-0614' => 'Sutatausa',
		'CO-CUN-0615' => 'Tabio',
		'CO-CUN-0616' => 'Tausa',
		'CO-CUN-0617' => 'Tena',
		'CO-CUN-0618' => 'Tenjo',
		'CO-CUN-0619' => 'Tibacuy',
		'CO-CUN-0620' => 'Tibirita',
		'CO-CUN-0621' => 'Tocaima',
		'CO-CUN-0622' => 'Tocancipá',
		'CO-CUN-0623' => 'Topaipí',
		'CO-CUN-0624' => 'Ubalá',
		'CO-CUN-0625' => 'Ubaque',
		'CO-CUN-0626' => 'Une',
		'CO-CUN-0627' => 'Útica',
		'CO-CUN-0628' => 'Venecia',
		'CO-CUN-0629' => 'Vergara',
		'CO-CUN-0630' => 'Vianí',
		'CO-CUN-0631' => 'Villa De San Diego De Ubate',
		'CO-CUN-0632' => 'Villagómez',
		'CO-CUN-0633' => 'Villapinzón',
		'CO-CUN-0634' => 'Villeta',
		'CO-CUN-0635' => 'Viotá',
		'CO-CUN-0636' => 'Yacopí',
		'CO-CUN-0637' => 'Zipacón',
		'CO-CUN-0638' => 'Zipaquirá',
	),
	'GUA' => array(
		'CO-GUA-0639' => 'Barranco Minas',
		'CO-GUA-0640' => 'Cacahual',
		'CO-GUA-0641' => 'Inírida',
		'CO-GUA-0642' => 'La Guadalupe',
		'CO-GUA-0643' => 'Mapiripana',
		'CO-GUA-0644' => 'Morichal',
		'CO-GUA-0645' => 'Pana Pana',
		'CO-GUA-0646' => 'Puerto Colombia',
		'CO-GUA-0647' => 'San Felipe',
	),
	'GUV' => array(
		'CO-GUV-0648' => 'Calamar',
		'CO-GUV-0649' => 'El Retorno',
		'CO-GUV-0650' => 'Miraflores',
		'CO-GUV-0651' => 'San José Del Guaviare',
	),
	'HUI' => array(
		'CO-HUI-0652' => 'Acevedo',
		'CO-HUI-0653' => 'Agrado',
		'CO-HUI-0654' => 'Aipe',
		'CO-HUI-0655' => 'Algeciras',
		'CO-HUI-0656' => 'Altamira',
		'CO-HUI-0657' => 'Baraya',
		'CO-HUI-0658' => 'Campoalegre',
		'CO-HUI-0659' => 'Colombia',
		'CO-HUI-0660' => 'Elías',
		'CO-HUI-0661' => 'Garzón',
		'CO-HUI-0662' => 'Gigante',
		'CO-HUI-0663' => 'Guadalupe',
		'CO-HUI-0664' => 'Hobo',
		'CO-HUI-0665' => 'Iquira',
		'CO-HUI-0666' => 'Isnos',
		'CO-HUI-0667' => 'La Argentina',
		'CO-HUI-0668' => 'La Plata',
		'CO-HUI-0669' => 'Nátaga',
		'CO-HUI-0670' => 'Neiva',
		'CO-HUI-0671' => 'Oporapa',
		'CO-HUI-0672' => 'Paicol',
		'CO-HUI-0673' => 'Palermo',
		'CO-HUI-0674' => 'Palestina',
		'CO-HUI-0675' => 'Pital',
		'CO-HUI-0676' => 'Pitalito',
		'CO-HUI-0677' => 'Rivera',
		'CO-HUI-0678' => 'Saladoblanco',
		'CO-HUI-0679' => 'San Agustín',
		'CO-HUI-0680' => 'Santa María',
		'CO-HUI-0681' => 'Suaza',
		'CO-HUI-0682' => 'Tarqui',
		'CO-HUI-0683' => 'Tello',
		'CO-HUI-0684' => 'Teruel',
		'CO-HUI-0685' => 'Tesalia',
		'CO-HUI-0686' => 'Timaná',
		'CO-HUI-0687' => 'Villavieja',
		'CO-HUI-0688' => 'Yaguará',
	),
	'LAG' => array(
		'CO-LAG-0689' => 'Albania',
		'CO-LAG-0690' => 'Barrancas',
		'CO-LAG-0691' => 'Dibulla',
		'CO-LAG-0692' => 'Distracción',
		'CO-LAG-0693' => 'El Molino',
		'CO-LAG-0694' => 'Fonseca',
		'CO-LAG-0695' => 'Hatonuevo',
		'CO-LAG-0696' => 'La Jagua Del Pilar',
		'CO-LAG-0697' => 'Maicao',
		'CO-LAG-0698' => 'Manaure',
		'CO-LAG-0699' => 'Riohacha',
		'CO-LAG-0700' => 'San Juan Del Cesar',
		'CO-LAG-0701' => 'Uribia',
		'CO-LAG-0702' => 'Urumita',
		'CO-LAG-0703' => 'Villanueva',
	),
	'MAG' => array(
		'CO-MAG-0704' => 'Algarrobo',
		'CO-MAG-0705' => 'Aracataca',
		'CO-MAG-0706' => 'Ariguaní',
		'CO-MAG-0707' => 'Cerro San Antonio',
		'CO-MAG-0708' => 'Chibolo',
		'CO-MAG-0709' => 'Ciénaga',
		'CO-MAG-0710' => 'Concordia',
		'CO-MAG-0711' => 'El Banco',
		'CO-MAG-0712' => 'El Piñon',
		'CO-MAG-0713' => 'El Retén',
		'CO-MAG-0714' => 'Fundación',
		'CO-MAG-0715' => 'Guamal',
		'CO-MAG-0716' => 'Nueva Granada',
		'CO-MAG-0717' => 'Pedraza',
		'CO-MAG-0718' => 'Pijiño Del Carmen',
		'CO-MAG-0719' => 'Pivijay',
		'CO-MAG-0720' => 'Plato',
		'CO-MAG-0721' => 'Puebloviejo',
		'CO-MAG-0722' => 'Remolino',
		'CO-MAG-0723' => 'Sabanas De San Angel',
		'CO-MAG-0724' => 'Salamina',
		'CO-MAG-0725' => 'San Sebastián De Buenavista',
		'CO-MAG-0726' => 'San Zenón',
		'CO-MAG-0727' => 'Santa Ana',
		'CO-MAG-0728' => 'Santa Bárbara De Pinto',
		'CO-MAG-0729' => 'Santa Marta',
		'CO-MAG-0730' => 'Sitionuevo',
		'CO-MAG-0731' => 'Tenerife',
		'CO-MAG-0732' => 'Zapayán',
		'CO-MAG-0733' => 'Zona Bananera',
	),
	'MET' => array(
		'CO-MET-0734' => 'Acacías',
		'CO-MET-0735' => 'Barranca De Upía',
		'CO-MET-0736' => 'Cabuyaro',
		'CO-MET-0737' => 'Castilla La Nueva',
		'CO-MET-0738' => 'Cubarral',
		'CO-MET-0739' => 'Cumaral',
		'CO-MET-0740' => 'El Calvario',
		'CO-MET-0741' => 'El Castillo',
		'CO-MET-0742' => 'El Dorado',
		'CO-MET-0743' => 'Fuente De Oro',
		'CO-MET-0744' => 'Granada',
		'CO-MET-0745' => 'Guamal',
		'CO-MET-0746' => 'La Macarena',
		'CO-MET-0747' => 'Lejanías',
		'CO-MET-0748' => 'Mapiripán',
		'CO-MET-0749' => 'Mesetas',
		'CO-MET-0750' => 'Puerto Concordia',
		'CO-MET-0751' => 'Puerto Gaitán',
		'CO-MET-0752' => 'Puerto Lleras',
		'CO-MET-0753' => 'Puerto López',
		'CO-MET-0754' => 'Puerto Rico',
		'CO-MET-0755' => 'Restrepo',
		'CO-MET-0756' => 'San Carlos De Guaroa',
		'CO-MET-0757' => 'San Juan De Arama',
		'CO-MET-0758' => 'San Juanito',
		'CO-MET-0759' => 'San Martín',
		'CO-MET-0760' => 'Uribe',
		'CO-MET-0761' => 'Villavicencio',
		'CO-MET-0762' => 'Vistahermosa',
	),
	'NAR' => array(
		'CO-NAR-0763' => 'Albán',
		'CO-NAR-0764' => 'Aldana',
		'CO-NAR-0765' => 'Ancuyá',
		'CO-NAR-0766' => 'Arboleda',
		'CO-NAR-0767' => 'Barbacoas',
		'CO-NAR-0768' => 'Belén',
		'CO-NAR-0769' => 'Buesaco',
		'CO-NAR-0770' => 'Chachagüí',
		'CO-NAR-0771' => 'Colón',
		'CO-NAR-0772' => 'Consaca',
		'CO-NAR-0773' => 'Contadero',
		'CO-NAR-0774' => 'Córdoba',
		'CO-NAR-0775' => 'Cuaspud',
		'CO-NAR-0776' => 'Cumbal',
		'CO-NAR-0777' => 'Cumbitara',
		'CO-NAR-0778' => 'El Charco',
		'CO-NAR-0779' => 'El Peñol',
		'CO-NAR-0780' => 'El Rosario',
		'CO-NAR-0781' => 'El Tablón De Gómez',
		'CO-NAR-0782' => 'El Tambo',
		'CO-NAR-0783' => 'Francisco Pizarro',
		'CO-NAR-0784' => 'Funes',
		'CO-NAR-0785' => 'Guachucal',
		'CO-NAR-0786' => 'Guaitarilla',
		'CO-NAR-0787' => 'Gualmatán',
		'CO-NAR-0788' => 'Iles',
		'CO-NAR-0789' => 'Imués',
		'CO-NAR-0790' => 'Ipiales',
		'CO-NAR-0791' => 'La Cruz',
		'CO-NAR-0792' => 'La Florida',
		'CO-NAR-0793' => 'La Llanada',
		'CO-NAR-0794' => 'La Tola',
		'CO-NAR-0795' => 'La Unión',
		'CO-NAR-0796' => 'Leiva',
		'CO-NAR-0797' => 'Linares',
		'CO-NAR-0798' => 'Los Andes',
		'CO-NAR-0799' => 'Magüi',
		'CO-NAR-0800' => 'Mallama',
		'CO-NAR-0801' => 'Mosquera',
		'CO-NAR-0802' => 'Nariño',
		'CO-NAR-0803' => 'Olaya Herrera',
		'CO-NAR-0804' => 'Ospina',
		'CO-NAR-0805' => 'Pasto',
		'CO-NAR-0806' => 'Policarpa',
		'CO-NAR-0807' => 'Potosí',
		'CO-NAR-0808' => 'Providencia',
		'CO-NAR-0809' => 'Puerres',
		'CO-NAR-0810' => 'Pupiales',
		'CO-NAR-0811' => 'Ricaurte',
		'CO-NAR-0812' => 'Roberto Payán',
		'CO-NAR-0813' => 'Samaniego',
		'CO-NAR-0814' => 'San Bernardo',
		'CO-NAR-0815' => 'San Lorenzo',
		'CO-NAR-0816' => 'San Pablo',
		'CO-NAR-0817' => 'San Pedro De Cartago',
		'CO-NAR-0818' => 'Sandoná',
		'CO-NAR-0819' => 'Santa Bárbara',
		'CO-NAR-0820' => 'Santacruz',
		'CO-NAR-0821' => 'Sapuyes',
		'CO-NAR-0822' => 'Taminango',
		'CO-NAR-0823' => 'Tangua',
		'CO-NAR-0824' => 'Tumaco',
		'CO-NAR-0825' => 'Túquerres',
		'CO-NAR-0826' => 'Yacuanquer',
	),
	'NSA' => array(
		'CO-NSA-0827' => 'Abrego',
		'CO-NSA-0828' => 'Arboledas',
		'CO-NSA-0829' => 'Bochalema',
		'CO-NSA-0830' => 'Bucarasica',
		'CO-NSA-0831' => 'Cachirá',
		'CO-NSA-0832' => 'Cácota',
		'CO-NSA-0833' => 'Chinácota',
		'CO-NSA-0834' => 'Chitagá',
		'CO-NSA-0835' => 'Convención',
		'CO-NSA-0836' => 'Cúcuta',
		'CO-NSA-0837' => 'Cucutilla',
		'CO-NSA-0838' => 'Durania',
		'CO-NSA-0839' => 'El Carmen',
		'CO-NSA-0840' => 'El Tarra',
		'CO-NSA-0841' => 'El Zulia',
		'CO-NSA-0842' => 'Gramalote',
		'CO-NSA-0843' => 'Hacarí',
		'CO-NSA-0844' => 'Herrán',
		'CO-NSA-0845' => 'La Esperanza',
		'CO-NSA-0846' => 'La Playa',
		'CO-NSA-0847' => 'Labateca',
		'CO-NSA-0848' => 'Los Patios',
		'CO-NSA-0849' => 'Lourdes',
		'CO-NSA-0850' => 'Mutiscua',
		'CO-NSA-0851' => 'Ocaña',
		'CO-NSA-0852' => 'Pamplona',
		'CO-NSA-0853' => 'Pamplonita',
		'CO-NSA-0854' => 'Puerto Santander',
		'CO-NSA-0855' => 'Ragonvalia',
		'CO-NSA-0856' => 'Salazar',
		'CO-NSA-0857' => 'San Calixto',
		'CO-NSA-0858' => 'San Cayetano',
		'CO-NSA-0859' => 'Santiago',
		'CO-NSA-0860' => 'Sardinata',
		'CO-NSA-0861' => 'Silos',
		'CO-NSA-0862' => 'Teorama',
		'CO-NSA-0863' => 'Tibú',
		'CO-NSA-0864' => 'Toledo',
		'CO-NSA-0865' => 'Villa Caro',
		'CO-NSA-0866' => 'Villa Del Rosario',
	),
	'PUT' => array(
		'CO-PUT-0867' => 'Colón',
		'CO-PUT-0868' => 'Leguízamo',
		'CO-PUT-0869' => 'Mocoa',
		'CO-PUT-0870' => 'Orito',
		'CO-PUT-0871' => 'Puerto Asís',
		'CO-PUT-0872' => 'Puerto Caicedo',
		'CO-PUT-0873' => 'Puerto Guzmán',
		'CO-PUT-0874' => 'San Francisco',
		'CO-PUT-0875' => 'San Miguel',
		'CO-PUT-0876' => 'Santiago',
		'CO-PUT-0877' => 'Sibundoy',
		'CO-PUT-0878' => 'Valle Del Guamuez',
		'CO-PUT-0879' => 'Villagarzón',
	),
	'QUI' => array(
		'CO-QUI-0880' => 'Armenia',
		'CO-QUI-0881' => 'Buenavista',
		'CO-QUI-0882' => 'Calarca',
		'CO-QUI-0883' => 'Circasia',
		'CO-QUI-0884' => 'Córdoba',
		'CO-QUI-0885' => 'Filandia',
		'CO-QUI-0886' => 'Génova',
		'CO-QUI-0887' => 'La Tebaida',
		'CO-QUI-0888' => 'Montenegro',
		'CO-QUI-0889' => 'Pijao',
		'CO-QUI-0890' => 'Quimbaya',
		'CO-QUI-0891' => 'Salento',
	),
	'RIS' => array(
		'CO-RIS-0892' => 'Apía',
		'CO-RIS-0893' => 'Balboa',
		'CO-RIS-0894' => 'Belén De Umbría',
		'CO-RIS-0895' => 'Dosquebradas',
		'CO-RIS-0896' => 'Guática',
		'CO-RIS-0897' => 'La Celia',
		'CO-RIS-0898' => 'La Virginia',
		'CO-RIS-0899' => 'Marsella',
		'CO-RIS-0900' => 'Mistrató',
		'CO-RIS-0901' => 'Pereira',
		'CO-RIS-0902' => 'Pueblo Rico',
		'CO-RIS-0903' => 'Quinchía',
		'CO-RIS-0904' => 'Santa Rosa De Cabal',
		'CO-RIS-0905' => 'Santuario',
	),
	'SAN' => array(
		'CO-SAN-0906' => 'Aguada',
		'CO-SAN-0907' => 'Albania',
		'CO-SAN-0908' => 'Aratoca',
		'CO-SAN-0909' => 'Barbosa',
		'CO-SAN-0910' => 'Barichara',
		'CO-SAN-0911' => 'Barrancabermeja',
		'CO-SAN-0912' => 'Betulia',
		'CO-SAN-0913' => 'Bolívar',
		'CO-SAN-0914' => 'Bucaramanga',
		'CO-SAN-0915' => 'Cabrera',
		'CO-SAN-0916' => 'California',
		'CO-SAN-0917' => 'Capitanejo',
		'CO-SAN-0918' => 'Carcasí',
		'CO-SAN-0919' => 'Cepitá',
		'CO-SAN-0920' => 'Cerrito',
		'CO-SAN-0921' => 'Charalá',
		'CO-SAN-0922' => 'Charta',
		'CO-SAN-0923' => 'Chima',
		'CO-SAN-0924' => 'Chipatá',
		'CO-SAN-0925' => 'Cimitarra',
		'CO-SAN-0926' => 'Concepción',
		'CO-SAN-0927' => 'Confines',
		'CO-SAN-0928' => 'Contratación',
		'CO-SAN-0929' => 'Coromoro',
		'CO-SAN-0930' => 'Curití',
		'CO-SAN-0931' => 'El Carmen De Chucurí',
		'CO-SAN-0932' => 'El Guacamayo',
		'CO-SAN-0933' => 'El Peñón',
		'CO-SAN-0934' => 'El Playón',
		'CO-SAN-0935' => 'Encino',
		'CO-SAN-0936' => 'Enciso',
		'CO-SAN-0937' => 'Florián',
		'CO-SAN-0938' => 'Floridablanca',
		'CO-SAN-0939' => 'Galán',
		'CO-SAN-0940' => 'Gambita',
		'CO-SAN-0941' => 'Girón',
		'CO-SAN-0942' => 'Guaca',
		'CO-SAN-0943' => 'Guadalupe',
		'CO-SAN-0944' => 'Guapotá',
		'CO-SAN-0945' => 'Guavatá',
		'CO-SAN-0946' => 'Güepsa',
		'CO-SAN-0947' => 'Hato',
		'CO-SAN-0948' => 'Jesús María',
		'CO-SAN-0949' => 'Jordán',
		'CO-SAN-0950' => 'La Belleza',
		'CO-SAN-0951' => 'La Paz',
		'CO-SAN-0952' => 'Landázuri',
		'CO-SAN-0953' => 'Lebríja',
		'CO-SAN-0954' => 'Los Santos',
		'CO-SAN-0955' => 'Macaravita',
		'CO-SAN-0956' => 'Málaga',
		'CO-SAN-0957' => 'Matanza',
		'CO-SAN-0958' => 'Mogotes',
		'CO-SAN-0959' => 'Molagavita',
		'CO-SAN-0960' => 'Ocamonte',
		'CO-SAN-0961' => 'Oiba',
		'CO-SAN-0962' => 'Onzaga',
		'CO-SAN-0963' => 'Palmar',
		'CO-SAN-0964' => 'Palmas Del Socorro',
		'CO-SAN-0965' => 'Páramo',
		'CO-SAN-0966' => 'Piedecuesta',
		'CO-SAN-0967' => 'Pinchote',
		'CO-SAN-0968' => 'Puente Nacional',
		'CO-SAN-0969' => 'Puerto Parra',
		'CO-SAN-0970' => 'Puerto Wilches',
		'CO-SAN-0971' => 'Rionegro',
		'CO-SAN-0972' => 'Sabana De Torres',
		'CO-SAN-0973' => 'San Andrés',
		'CO-SAN-0974' => 'San Benito',
		'CO-SAN-0975' => 'San Gil',
		'CO-SAN-0976' => 'San Joaquín',
		'CO-SAN-0977' => 'San José De Miranda',
		'CO-SAN-0978' => 'San Miguel',
		'CO-SAN-0979' => 'San Vicente De Chucurí',
		'CO-SAN-0980' => 'Santa Bárbara',
		'CO-SAN-0981' => 'Santa Helena Del Opón',
		'CO-SAN-0982' => 'Simacota',
		'CO-SAN-0983' => 'Socorro',
		'CO-SAN-0984' => 'Suaita',
		'CO-SAN-0985' => 'Sucre',
		'CO-SAN-0986' => 'Suratá',
		'CO-SAN-0987' => 'Tona',
		'CO-SAN-0988' => 'Valle De San José',
		'CO-SAN-0989' => 'Vélez',
		'CO-SAN-0990' => 'Vetas',
		'CO-SAN-0991' => 'Villanueva',
		'CO-SAN-0992' => 'Zapatoca',
	),
	'SAP' => array(
		'CO-SAP-0993' => 'Providencia',
		'CO-SAP-0994' => 'San Andrés',
	),
	'SUC' => array(
		'CO-SUC-0995' => 'Buenavista',
		'CO-SUC-0996' => 'Caimito',
		'CO-SUC-0997' => 'Chalán',
		'CO-SUC-0998' => 'Coloso',
		'CO-SUC-0999' => 'Corozal',
		'CO-SUC-1000' => 'Coveñas',
		'CO-SUC-1001' => 'El Roble',
		'CO-SUC-1002' => 'Galeras',
		'CO-SUC-1003' => 'Guaranda',
		'CO-SUC-1004' => 'La Unión',
		'CO-SUC-1005' => 'Los Palmitos',
		'CO-SUC-1006' => 'Majagual',
		'CO-SUC-1007' => 'Morroa',
		'CO-SUC-1008' => 'Ovejas',
		'CO-SUC-1009' => 'Palmito',
		'CO-SUC-1010' => 'Sampués',
		'CO-SUC-1011' => 'San Benito Abad',
		'CO-SUC-1012' => 'San Juan De Betulia',
		'CO-SUC-1013' => 'San Marcos',
		'CO-SUC-1014' => 'San Onofre',
		'CO-SUC-1015' => 'San Pedro',
		'CO-SUC-1016' => 'Santiago De Tolú',
		'CO-SUC-1017' => 'Sincé',
		'CO-SUC-1018' => 'Sincelejo',
		'CO-SUC-1019' => 'Sucre',
		'CO-SUC-1020' => 'Tolú Viejo',
	),
	'TOL' => array(
		'CO-TOL-1021' => 'Alpujarra',
		'CO-TOL-1022' => 'Alvarado',
		'CO-TOL-1023' => 'Ambalema',
		'CO-TOL-1024' => 'Anzoátegui',
		'CO-TOL-1025' => 'Armero',
		'CO-TOL-1026' => 'Ataco',
		'CO-TOL-1027' => 'Cajamarca',
		'CO-TOL-1028' => 'Carmen De Apicalá',
		'CO-TOL-1029' => 'Casabianca',
		'CO-TOL-1030' => 'Chaparral',
		'CO-TOL-1031' => 'Coello',
		'CO-TOL-1032' => 'Coyaima',
		'CO-TOL-1033' => 'Cunday',
		'CO-TOL-1034' => 'Dolores',
		'CO-TOL-1035' => 'Espinal',
		'CO-TOL-1036' => 'Falan',
		'CO-TOL-1037' => 'Flandes',
		'CO-TOL-1038' => 'Fresno',
		'CO-TOL-1039' => 'Guamo',
		'CO-TOL-1040' => 'Herveo',
		'CO-TOL-1041' => 'Honda',
		'CO-TOL-1042' => 'Ibagué',
		'CO-TOL-1043' => 'Icononzo',
		'CO-TOL-1044' => 'Lérida',
		'CO-TOL-1045' => 'Líbano',
		'CO-TOL-1046' => 'Mariquita',
		'CO-TOL-1047' => 'Melgar',
		'CO-TOL-1048' => 'Murillo',
		'CO-TOL-1049' => 'Natagaima',
		'CO-TOL-1050' => 'Ortega',
		'CO-TOL-1051' => 'Palocabildo',
		'CO-TOL-1052' => 'Piedras',
		'CO-TOL-1053' => 'Planadas',
		'CO-TOL-1054' => 'Prado',
		'CO-TOL-1055' => 'Purificación',
		'CO-TOL-1056' => 'Rioblanco',
		'CO-TOL-1057' => 'Roncesvalles',
		'CO-TOL-1058' => 'Rovira',
		'CO-TOL-1059' => 'Saldaña',
		'CO-TOL-1060' => 'San Antonio',
		'CO-TOL-1061' => 'San Luis',
		'CO-TOL-1062' => 'Santa Isabel',
		'CO-TOL-1063' => 'Suárez',
		'CO-TOL-1064' => 'Valle De San Juan',
		'CO-TOL-1065' => 'Venadillo',
		'CO-TOL-1066' => 'Villahermosa',
		'CO-TOL-1067' => 'Villarrica',
	),
	'VAC' => array(
		'CO-VAC-1068' => 'Alcalá',
		'CO-VAC-1069' => 'Andalucía',
		'CO-VAC-1070' => 'Ansermanuevo',
		'CO-VAC-1071' => 'Argelia',
		'CO-VAC-1072' => 'Bolívar',
		'CO-VAC-1073' => 'Buenaventura',
		'CO-VAC-1074' => 'Bugalagrande',
		'CO-VAC-1075' => 'Caicedonia',
		'CO-VAC-1076' => 'Cali',
		'CO-VAC-1077' => 'Calima',
		'CO-VAC-1078' => 'Candelaria',
		'CO-VAC-1079' => 'Cartago',
		'CO-VAC-1080' => 'Dagua',
		'CO-VAC-1081' => 'El Águila',
		'CO-VAC-1082' => 'El Cairo',
		'CO-VAC-1083' => 'El Cerrito',
		'CO-VAC-1084' => 'El Dovio',
		'CO-VAC-1085' => 'Florida',
		'CO-VAC-1086' => 'Ginebra',
		'CO-VAC-1087' => 'Guacarí',
		'CO-VAC-1088' => 'Guadalajara De Buga',
		'CO-VAC-1089' => 'Jamundí',
		'CO-VAC-1090' => 'La Cumbre',
		'CO-VAC-1091' => 'La Unión',
		'CO-VAC-1092' => 'La Victoria',
		'CO-VAC-1093' => 'Obando',
		'CO-VAC-1094' => 'Palmira',
		'CO-VAC-1095' => 'Pradera',
		'CO-VAC-1096' => 'Restrepo',
		'CO-VAC-1097' => 'Riofrío',
		'CO-VAC-1098' => 'Roldanillo',
		'CO-VAC-1099' => 'San Pedro',
		'CO-VAC-1100' => 'Sevilla',
		'CO-VAC-1101' => 'Toro',
		'CO-VAC-1102' => 'Trujillo',
		'CO-VAC-1103' => 'Tuluá',
		'CO-VAC-1104' => 'Ulloa',
		'CO-VAC-1105' => 'Versalles',
		'CO-VAC-1106' => 'Vijes',
		'CO-VAC-1107' => 'Yotoco',
		'CO-VAC-1108' => 'Yumbo',
		'CO-VAC-1109' => 'Zarzal',
	),
	'VAU' => array(
		'CO-VAU-1110' => 'Caruru',
		'CO-VAU-1111' => 'Mitú',
		'CO-VAU-1112' => 'Pacoa',
		'CO-VAU-1113' => 'Papunaua',
		'CO-VAU-1114' => 'Taraira',
		'CO-VAU-1115' => 'Yavaraté',
	),
	'VID' => array(
		'CO-VID-1116' => 'Cumaribo',
		'CO-VID-1117' => 'La Primavera',
		'CO-VID-1118' => 'Puerto Carreño',
		'CO-VID-1119' => 'Santa Rosalía',
	),
);

// Use this filter to handle the Cities of Colombia
$places['CO'] = apply_filters('scpwoo_custom_places_co', $places['CO']);
