<?php

/**
 * Municipalities of Bolivia
 * - 340 municipalities
 *
 * Source:
 * - https://es.wikipedia.org/wiki/Anexo:Municipios_de_Bolivia
 *
 * @author  ionixcorp <ionixcorp@outlook.es> | https://github.com/ionixcorp
 * @author  Yordan Soares <contacto@yordansoar.es> | https://yordansoar.es/
 * @version 1.1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 */

global $places;

$places['BO'] = array(
  // Beni
  'H' => array(
    'Baures',
    'Exaltación',
    'Guayaramerín',
    'Huaracaje',
    'Loreto',
    'Magdalena',
    'Puerto Siles',
    'Reyes',
    'Riberalta',
    'Rurrenabaque',
    'San Andrés',
    'San Borja',
    'San Ignacio de Moxos',
    'San Javier',
    'San Joaquín',
    'San Ramón',
    'Santa Ana del Yacuma',
    'Santa Rosa',
    'Trinidad',
  ),
  // Cochabamba
  'C' => array(
    'Alalay',
    'Aiquile',
    'Anzaldo',
    'Arbieto',
    'Arani',
    'Arque',
    'Bolívar',
    'Capinota',
    'Chimoré',
    'Cliza',
    'Cochabamba',
    'Colcapirhua',
    'Colomi',
    'Cocapata',
    'Cuchumuela',
    'Entre Ríos',
    'Independencia',
    'Mizque',
    'Morochata',
    'Omereque',
    'Pasorapa',
    'Pojo',
    'Pocona',
    'Puerto Villarroel',
    'Punata',
    'Quillacollo',
    'San Benito',
    'Sacaba',
    'Sacabamba',
    'Santiváñez',
    'Shinahota',
    'Sicaya',
    'Sipe Sipe',
    'Tacachi',
    'Tacopaya',
    'Tapacarí',
    'Tarata',
    'Tiquipaya',
    'Tiraque',
    'Toco',
    'Tolata',
    'Totora',
    'Vacas',
    'Vinto',
    'Villa Tunari',
    'Villa Rivero',
    'Vila Vila',
  ),
  // Chuquisaca
  'B' => array(
    'Azurduy',
    'Camargo',
    'Camataqui',
    'Culpina',
    'El Villar',
    'Huacareta',
    'Huacaya',
    'Icla',
    'Incahuasi',
    'Las Carreras',
    'Macharetí',
    'Monteagudo',
    'Padilla',
    'Poroma',
    'Presto',
    'San Lucas',
    'Sopachuy',
    'Sucre',
    'Tarabuco',
    'Tarvita',
    'Tomina',
    'Villa Zudáñez2​',
    'Villa Mojocoya2​',
    'Villa Alcalá',
    'Villa Charcas',
    'Villa Serrano',
    'Villa Vaca Guzmán',
    'Yamparáez',
    'Yotala',
  ),
  // La Paz
  'L' => array(
    'Achacachi',
    'Achocalla',
    'Alto Beni',
    'Ancoraimes',
    'Apolo',
    'Aucapata',
    'Ayata',
    'Ayo Ayo',
    'Batallas',
    'Cairoma',
    'Cajuata',
    'Calacoto',
    'Calamarca',
    'Callapa',
    'Caquiaviri',
    'Caranavi',
    'Catacora',
    'Chacarilla',
    'Charaña',
    'Charazani (General Juan José Pérez)',
    'Chua Cocani',
    'Chulumani',
    'Chuma',
    'Colquencha',
    'Colquiri',
    'Collana',
    'Combaya',
    'Comanche',
    'Copacabana',
    'Coripata',
    'Coro Coro',
    'Coroico',
    'Curva',
    'Desaguadero',
    'El Alto',
    'Escoma',
    'Huarina',
    'Humanata',
    'Guanay',
    'Guaqui',
    'Huatajata',
    'Ichoca',
    'Inquisivi',
    'Irupana',
    'Ixiamas',
    'Jesús de Machaca',
    'La Asunta',
    'La Paz',
    'Laja',
    'Licoma Pampa',
    'Luribay',
    'Malla',
    'Mapiri',
    'Mecapaca',
    'Mocomoco',
    'Nazacara de Pacajes',
    'Palca',
    'Papel Pampa',
    'Patacamaya',
    'Pelechuco',
    'Palos Blancos',
    'Pucarani',
    'Puerto Acosta',
    'Puerto Carabuco',
    'Puerto Pérez',
    'San Buenaventura',
    'Santiago de Huata',
    'Santiago de Machaca',
    'San Andrés de Machaca',
    'San Pedro de Curahuara',
    'San Pedro de Tiquina',
    'Sapahaqui',
    'Sica Sica',
    'Sorata',
    'Quiabaya',
    'Quime',
    'Tacacoma',
    'Taraco',
    'Teoponte',
    'Tiwanaku',
    'Tipuani',
    'Tito Yupanqui',
    'Umala',
    'Viacha',
    'Waldo Ballivián',
    'Yaco',
    'Yanacachi',
  ),
  // Pando
  'N' => array(
    'Bella Flor',
    'Bolpebra',
    'Cobija',
    'El Sena',
    'Filadelfia',
    'Ingavi',
    'Nueva Esperanza',
    'Porvenir',
    'Puerto Gonzalo Moreno',
    'Puerto Rico',
    'San Lorenzo',
    'San Pedro',
    'Santa Rosa del Abuná',
    'Santos Mercado',
    'Villa Nueva',
  ),
  // Oruro
  'O' => array(
    'Antequera',
    'Andamarca',
    'Belén de Andamarca',
    'Caracollo',
    'Carangas',
    'Challapata',
    'Chipaya',
    'Choquecota',
    'Coipasa',
    'Corque',
    'Cruz de Machacamarca',
    'Curahuara de Carangas',
    'El Choro',
    'Escara',
    'Esmeralda',
    'Eucaliptus',
    'Huachacalla',
    'Huanuni',
    'Huayllamarca',
    'La Rivera',
    'Machacamarca',
    'Oruro',
    'Pampa Aullagas',
    'Paria',
    'Pazña',
    'Poopó',
    'Quillacas',
    'Sabaya',
    'Salinas de Garci Mendoza',
    'Santiago de Huari',
    'Toledo',
    'Totora',
    'Todos Santos',
    'Turco',
    'Yunguyo de Litoral',
  ),
  // Potosí
  'P' => array(
    'Acasio',
    'Arampampa',
    'Atocha',
    'Betanzos',
    'Caiza D',
    'Ckochas',
    'Chuquihuta',
    'Caripuyo',
    'Chayanta',
    'Chaquí',
    'Colquechaca',
    'Colcha K',
    'Cotagaita',
    'Llallagua',
    'Llica',
    'Mojinete',
    'Pocoata',
    'Porco',
    'Puna',
    'Potosí',
    'Ocurí',
    'Ravelo',
    'Sacaca',
    'San Agustín',
    'San Antonio de Esmoruco',
    'San Pablo de Lípez',
    'San Pedro de Macha1​',
    'San Pedro de Quemes',
    'San Pedro',
    'Tacobamba',
    'Tahua',
    'Tinguipaya',
    'Tomave',
    'Toro Toro',
    'Tupiza',
    'Uncía',
    'Urmiri',
    'Uyuni',
    'Villazón',
    'Vitichi',
    'Yocalla',
  ),
  // Santa Cruz
  'S' => array(
    'Ascensión de Guarayos',
    'Boyuibe',
    'Buena Vista',
    'Cabezas',
    'Camiri',
    'Charagua',
    'Colpa Bélgica',
    'Cotoca',
    'Cuatro Cañadas',
    'Cuevo',
    'Comarapa',
    'Concepción',
    'El Carmen Rivero Tórrez',
    'El Puente',
    'El Torno',
    'Fernández Alonso',
    'General Saavedra',
    'Gutiérrez',
    'Lagunillas',
    'La Guardia',
    'Mairana',
    'Mineros',
    'Montero',
    'Moro Moro',
    'Okinawa Uno',
    'Pailón',
    'Pampagrande',
    'Porongo',
    'Portachuelo',
    'Postrervalle',
    'Pucará',
    'Puerto Quijarro',
    'Puerto Suárez',
    'Quirusillas',
    'Roboré',
    'Saipina',
    'Samaipata',
    'San Antonio de Lomerío',
    'San Carlos',
    'San Ignacio de Velasco',
    'San Javier',
    'San José de Chiquitos',
    'San Julián',
    'San Juan de Yapacaní',
    'San Matías',
    'San Miguel de Velasco',
    'San Pedro',
    'San Rafael de Velasco',
    'San Ramón',
    'Santa Cruz de la Sierra',
    'Santa Rosa del Sara',
    'El Trigal',
    'Urubichá',
    'Vallegrande',
    'Warnes',
    'Yapacaní',
  ),
  // Tarija
  'T' => array(
    'Bermejo',
    'Caraparí',
    'El Puente',
    'Entre Ríos',
    'Padcaya',
    'San Lorenzo',
    'Tarija Ciudad',
    'Uriondo',
    'Villa Montes',
    'Yacuiba',
    'Yunchará',
  ),
);

// Use this filter to handle the Municipalities of Bolivia
$places['BO'] = apply_filters('scpwoo_custom_places_bo', $places['BO']);
