<?php

/**
 * Districts of Bahrain
 * - 115 districts
 * 
 * Source: 
 * - https://en.wikipedia.org/wiki/Governorates_of_Bahrain
 * - https://en.wikipedia.org/wiki/ISO_3166-2:BH
 * - https://en.wikipedia.org/wiki/List_of_cities_in_Bahrain
 * - https://ar.wikipedia.org/wiki/قائمة_مدن_البحرين
 * 
 * @author  Ebrahim Ahmed <ebrahim@alraneenlabs.com> | https://alraneenlabs.com/
 * @version 1.0.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 */

global $places;

$places['BH'] = array(
  //Capital Governorate	محافظة العاصمة
  'BH-13' => array(
    _x('Adhari', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Adliya', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Al Qufool', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Al Salihiyah', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Alfateh', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Bahrain Bay', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Bahrain Financial Harbour', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Bu Ashira', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Bu Ghazal', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Burhama', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Diplomatic Area', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Ghuraifa', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Gudaibiya', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Gufool', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Hillat Abdul Saleh', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Hoora', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Jidali', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Jirdab', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Juffair', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Karbabad', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Mahooz', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Manama Center', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Mina Salman', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Nabih Saleh', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Noaim', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Ras Rumman', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Reef Island', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Sanabis', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Seef', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Seqaya', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Sihla (South)', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Sulmaniya', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Tubli', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Umm Al Hassam', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Zinj', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
  ),
  //Southern Governorate	المحافظة الجنوبية
  'BH-14' => array(
    _x('Al Dur', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Al Safriyah', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Alareen', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Askar', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Awali', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Durrat Al Bahrain', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Eker (East)', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Eker (West)', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Isa Town', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Jary Al Shaikh', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Jaww', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Jazaair Beach', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Maameer', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Nuwaidrat', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Riffa', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Safra', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Sakhir', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Sanad', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Sitra', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Wadi  Alsail', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('West Riffa', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Zallaq', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Zayed Town', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
  ),
  //Muharraq Governorate	محافظة المحرق
  'BH-15' => array(
    _x('Al Dair', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Al Muharraq', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Al Sayh', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Arad', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Busaiteen', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Diyar Al Muharraq', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Galali', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Halat Bu Maher', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Halat Naim', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Halat Seltah', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Hidd', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Hidd Industrial Area', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Samaheej', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
  ),
  //Northern Governorate	المحافظة الشمالية
  'BH-17' => array(
    _x('Aali', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Abu Quwa', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Abu Saiba', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Ain Aldaar', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Al Daih', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Al Hajar', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Al Lawzi', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Al Markh', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Al Musalla', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Al Qadam', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Al Qala', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Bani Jamra', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Barbar', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Bilad Alqadeem', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Boori', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Budaiya', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Buquwa', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Dar Kulaib', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Dumistan', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Duraz', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Hamad Town', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Hamala', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Hoarat Aali', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Jabalat Habshi', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Janabiya', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Jannusan', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Jid Al-Haj', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Jidhafs', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Karrana', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Karzakan', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Khamis', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Malikiya', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Maqaba', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Muqsha', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Northern City', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Qurayya', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Saar', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Sadad', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Salmabad', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Sehla', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Shahrakan', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Shakhura', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Sihla (North)', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
    _x('Tashan', 'District of Bahrain', 'states-cities-and-places-for-woocommerce'),
  ),
);

// Use this filter to handle the Districts of Bahrain
$places['BH'] = apply_filters('scpwoo_custom_places_bh', $places['BH']);
