<?php

/**
 * Cities, Towns and Villages of Barbados
 * 307 Cities, Towns and Villages
 * 
 * Sources: 
 * - https://en.wikipedia.org/wiki/List_of_cities,_towns_and_villages_in_Barbados
 * - https://nominatim.openstreetmap.org/
 * 
 * @author  Damien Alleyne <damien.alleyne@gmail.com>
 * @version 1.0.0
 * @license https://creativecommons.org/licenses/by-sa/2.0/
 * 
 */

global $places;

$places['BB'] = array(
  'BB-01' => array(
    'Adams Castle Estate',
    'Atlantic Shores',
    'Balls',
    'Bannatyne Gardens',
    'Barracks Hill',
    'Boarded Hall',
    'Campaign Castle',
    'Chancery Lane',
    'Charnocks',
    'Country View Estate',
    'Cox Road',
    'Dayrells Road',
    'Durants',
    'Ealing Park',
    'Edey Village',
    'Elizabeth Park',
    'Enterprise',
    'Fairview',
    'Frere Pilgrim',
    'Goodland',
    'Graeme Hall Park',
    'Graeme Hall Terrace',
    'Graeme Hall',
    'Green Garden',
    'Hastings',
    'Hopewell',
    'Inch Marlowe',
    'Kendal Hill',
    'Kent',
    'Kingsland',
    'Lead Vale',
    'Lower Greys',
    'Lowland',
    'Marine Gardens',
    'Maxwell Hill',
    'Maxwell Terrace',
    'Maxwell',
    'Navy Gardens',
    'Newton',
    'Oistins',
    'Parish Land',
    'Providence',
    'Regency Park',
    'Rendezvous Gardens',
    'Rendezvous',
    'Rockley',
    'Sargeants Village',
    'Sayes Court',
    'Scarborough',
    'Searles',
    'Seaview',
    'Sheraton Park',
    'Silver Sands',
    'Skeetes Hill',
    'Small Ridge',
    'South Ridge',
    'St. Davids',
    'St. Lawrence Gap',
    'St. Patrick\'s',
    'Staple Grove',
    'The Ridge',
    'The Villages at Coverley',
    'Thornbury Hill',
    'Thyme Bottom',
    'Tino Terrace',
    'Upton',
    'Vauxhall Gardens',
    'Vauxhall Tenantry',
    'Vauxhall',
    'Warners Gardens',
    'Warners Park',
    'Warners Terrace',
    'Warners',
    'Wilcox',
    'Windsor',
    'Worthing',
  ),
  'BB-02' => array(
    'Barclays Park',
    'Baxters',
    'Belleplaine',
    'Breedy\'s',
    'Bruce Vale',
    'Chalky Mount',
    'Cherry Tree Hill',
    'Greenland',
    'Hillaby',
    'Turner\'s Hall Woods',
    'White Hill',
  ),
  'BB-03' => array(
    'Bairds',
    'Belair',
    'Brighton',
    'Bulkeley',
    'Campaign Castle',
    'Church View',
    'Constant',
    'Dash Valley',
    'Drax Hall',
    'Ellerton',
    'Gun Hill',
    'Stepney',
    'Watts Village',
  ),
  'BB-04' => array(
    'Appleby Gardens',
    'Bagatelle Terrace',
    'Coral Glade',
    'Derricks',
    'Durants',
    'Fitts Village',
    'Greenwich',
    'Halls Village',
    'Haynesville',
    'Holders Hill',
    'Holetown',
    'Hoytes Village',
    'Husbands',
    'Lascelles',
    'Lower Carlton',
    'Mount Standfast',
    'Oakwood Park',
    'Orange Hill',
    'Oxnards',
    'Paynes Bay',
    'Porters',
    'Prior Park',
    'Prospect',
    'Sandy Lane',
    'Seaview',
    'Sion Hill',
    'Sugar Hill',
    'Sunset Crest',
    'The Garden',
    'Thorpes',
    'Trents',
    'Upper Carlton',
    'West Terrace',
    'Westmoreland',
    'Weston',
  ),
  'BB-05' => array(
    'Bath',
    'Bowmanston',
    'Carter',
    'Cherry Grove',
    'Gall Hill',
    'Kendal',
    'Saint Marks',
    'Sherbourne',
    'Spooners',
    'Venture',
  ),
  'BB-06' => array(
    'Airy Hill',
    'Bathsheba',
    'Bissex',
    'Blackmans',
    'Bonwell',
    'Branchbury',
    'Buckden House',
    'Cambridge',
    'Canefield',
    'Castle Grant',
    'Cattlewash',
    'Chimborazo',
    'Hackleton\'s Cliff',
  ),
  'BB-07' => array(
    'Alexandra',
    'Bishops',
    'Cave Hall',
    'Chance Hall',
    'Connell Town',
    'Flatfield',
    'Hope',
    'Jemmotts',
    'Josey Hill',
    'Lamberts',
    'Lowland',
    'Mount View',
    'Pie Corner',
    'Retreat',
    'Rockfield',
    'Rock Hall',
    'Sea View',
    'Upper Salmonds',
    'Well Road',
  ),
  'BB-08' => array(
    'Bank Hall',
    'Bayville',
    'Belfield',
    'Belle',
    'Bibbys Lane',
    'Black Rock',
    'Bridgetown',
    'Brighton',
    'Brittons Hill',
    'Bush Hall',
    'Canewood',
    'Carrington',
    'Cave Hill',
    'Clermont',
    'Codrington',
    'Dayrells',
    'Deacons',
    'Deacons Farm',
    'Eagle Hall',
    'Eden Lodge',
    'Fairfield',
    'Friendship',
    'Friendship Terrace',
    'Goodland',
    'Grazettes',
    'Green Hill',
    'Haggatt Hall',
    'Harmony Hall',
    'Henrys',
    'Highgate',
    'Hothersal Turning',
    'Howells',
    'Ivy',
    'Jackmans',
    'Kew',
    'Lazarette',
    'Lodge Hill',
    'Lower Estate',
    'Mapp Hill',
    'Neils',
    'Prospect',
    'Rock Dundo',
    'Rouen',
    'Spring Garden',
    'Station Hill',
    'St. Barnabas',
    'Two Mile Hill',
    'Upton',
    'Wanstead',
    'Warrens',
    'Waterford',
    'Whitehall',
    'Wildey',
  ),
  'BB-09' => array(
    'Ashburton Grove, The Castle',
    'Ashton Hall',
    'Bakers',
    'Battleys',
    'Black Bess',
    'Boscobelle',
    'The Castle',
    'Diamond Corner',
    'Farley Hill',
    'Fourhill',
    'French Village',
    'Gibbes',
    'Haymans',
    'Indian Ground',
    'Mile and a Quarter',
    'Mangrove Terrace',
    'Mullins Terrace',
    'Portland',
    'Road View',
    'Rock Hall',
    'Rose Hill',
    'Six Mens',
    'Speightstown',
    'Sunbury',
    'The Whim',
  ),
  'BB-10' => array(
    'Apple Hall',
    'Belair',
    'Coles',
    'Coral Haven',
    'Crane',
    'Diamond Valley',
    'Drakes Land',
    'Duncans',
    'Eastbourne',
    'Foul Bay',
    'Gemswick',
    'Greenpoint',
    'Grove',
    'Harmony Lodge',
    'Harrismith',
    'Heddings',
    'Inch Cape Terrace',
    'Kirtons',
    'Long Bay',
    'Long Bay Development',
    'Lucas Street',
    'Lynches',
    'Marchfield',
    'Marley Vale',
    'Merricks',
    'Nursery',
    'Oldbury',
    'Rices',
    'River Land',
    'Ruby',
    'Sealy Hill',
    'Seaview',
    'Six Cross Roads',
    'Skeete\'s Bay',
    'Sterling',
    'Stroude Land',
    'Union',
    'Wellhouse',
    'Workhall',
  ),
  'BB-11' => array(
    'Allen View',
    'Applewhaites',
    'Arch Hall',
    'Arthurs Seat',
    'Bagatelle',
    'Bennetts',
    'Bloomsbury',
    'Blowers',
    'Bridgefield',
    'Carrington',
    'Chapman',
    'Christie',
    'Welchman Hall',
  ),
);

// Use this filter to handle the Cities, Towns and Villages of Barbados
$places['BB'] = apply_filters('scpwoo_custom_places_bb', $places['BB']);
