<?php

namespace Staatic\Vendor\GuzzleHttp\Handler;

use BadMethodCallException;
use Staatic\Vendor\GuzzleHttp\Psr7\Response;
use Staatic\Vendor\GuzzleHttp\Utils;
use Staatic\Vendor\Psr\Http\Message\RequestInterface;
use Staatic\Vendor\Psr\Http\Message\ResponseInterface;
use Staatic\Vendor\Psr\Http\Message\StreamInterface;
final class EasyHandle
{
    public $handle;
    public $sink;
    public $headers = [];
    public $response;
    public $request;
    public $options = [];
    public $errno = 0;
    public $onHeadersException;
    public $createResponseException;
    public function createResponse(): void
    {
        [$ver, $status, $reason, $headers] = HeaderProcessor::parseHeaders($this->headers);
        $normalizedKeys = Utils::normalizeHeaderKeys($headers);
        if (!empty($this->options['decode_content']) && isset($normalizedKeys['content-encoding'])) {
            $headers['x-encoded-content-encoding'] = $headers[$normalizedKeys['content-encoding']];
            unset($headers[$normalizedKeys['content-encoding']]);
            if (isset($normalizedKeys['content-length'])) {
                $headers['x-encoded-content-length'] = $headers[$normalizedKeys['content-length']];
                $bodyLength = (int) $this->sink->getSize();
                if ($bodyLength) {
                    $headers[$normalizedKeys['content-length']] = $bodyLength;
                } else {
                    unset($headers[$normalizedKeys['content-length']]);
                }
            }
        }
        $this->response = new Response($status, $headers, $this->sink, $ver, $reason);
    }
    public function __get($name)
    {
        $msg = $name === 'handle' ? 'The EasyHandle has been released' : 'Invalid property: ' . $name;
        throw new BadMethodCallException($msg);
    }
}
