<?php

declare(strict_types=1);

namespace Staatic\WordPress\Module\Deployer\GithubDeployer;

use Staatic\WordPress\Setting\AbstractSetting;
use Staatic\WordPress\Setting\ComposedSettingInterface;

final class AuthSetting extends AbstractSetting implements ComposedSettingInterface
{
    /**
     * @var TokenSetting
     */
    private $token;

    public function __construct(TokenSetting $token)
    {
        $this->token = $token;
    }

    public function name(): string
    {
        return 'staatic_github_auth';
    }

    public function type(): string
    {
        return self::TYPE_COMPOSED;
    }

    public function label(): string
    {
        return __('Authentication', 'staatic');
    }

    public function description(): ?string
    {
        return sprintf(
            /* translators: 1: Link to Personal Access Token Documentation, 2: Link to App Token Documentation. */
            __('In order to authenticate with a <a href="%1$s" target="blank">personal access token</a> or a <a href="%2$s" target="blank">token generated by an app</a>, supply the token here.<br>Leave empty to use the API in a GitHub Actions workflow.', 'staatic'),
            'https://docs.github.com/en/rest/overview/authenticating-to-the-rest-api?apiVersion=2022-11-28#authenticating-with-a-personal-access-token',
            'https://docs.github.com/en/rest/overview/authenticating-to-the-rest-api?apiVersion=2022-11-28#authenticating-with-a-token-generated-by-an-app'
        );
    }

    /**
     * @param mixed[] $attributes
     */
    public function render($attributes = []): void
    {
        parent::render();
        if ($this->token->value()) {
            echo '<div
                data-staatic-component="GithubStatus"
                data-token="' . esc_attr($this->token->name()) . '"
                style="margin-top: 10px;"
            ></div>';
        }
    }

    public function settings(): array
    {
        return [$this->token];
    }
}
