(function($){"use strict";var ID="hwt";var HighlightWithinTextarea=function($el,config){this.init($el,config)};HighlightWithinTextarea.prototype={init:function($el,config){this.$el=$el;if(this.getType(config)==="function"){config={highlight:config}}if(this.getType(config)==="custom"){this.highlight=config;this.generate()}else{console.error("valid config object not provided")}},getType:function(instance){var type=typeof instance;if(!instance){return"falsey"}else if(Array.isArray(instance)){if(instance.length===2&&typeof instance[0]==="number"&&typeof instance[1]==="number"){return"range"}else{return"array"}}else if(type==="object"){if(instance instanceof RegExp){return"regexp"}else if(instance.hasOwnProperty("highlight")){return"custom"}}else if(type==="function"||type==="string"){return type}return"other"},generate:function(){this.$el.addClass(ID+"-input "+ID+"-content").on("input."+ID,this.handleInput.bind(this)).on("scroll."+ID,this.handleScroll.bind(this));this.$highlights=$("<div>",{class:ID+"-highlights "+ID+"-content"});this.$backdrop=$("<div>",{class:ID+"-backdrop"}).append(this.$highlights);this.$container=$("<div>",{class:ID+"-container"}).insertAfter(this.$el).append(this.$backdrop,this.$el).on("scroll",this.blockContainerScroll.bind(this));this.fixPadding();this.isGenerated=true;this.handleInput()},detectBrowser:function(){var ua=window.navigator.userAgent.toLowerCase();if(ua.indexOf("firefox")!==-1){return"firefox"}else if(!!ua.match(/msie|trident\/7|edge/)){return"ie"}else if(!!ua.match(/ipad|iphone|ipod/)&&ua.indexOf("windows phone")===-1){return"ios"}else{return"other"}},fixPadding:function(){var padding=this.$el.css(["padding-top","padding-right","padding-bottom","padding-left"]);var font=this.$el.css(["line-height","font-size"]);this.$backdrop.css({padding:"0","border-width":"0"});this.$highlights.css({"padding-top":padding["padding-top"],"padding-right":padding["padding-right"],"padding-bottom":padding["padding-bottom"],"padding-left":padding["padding-left"]}).css({"line-height":font["line-height"],"font-size":font["font-size"]});this.$highlights.find("mark").css({"line-height":font["line-height"],"font-size":font["font-size"]})},fixFirefox:function(){var padding=this.$highlights.css(["padding-top","padding-right","padding-bottom","padding-left"]);var border=this.$highlights.css(["border-top-width","border-right-width","border-bottom-width","border-left-width"]);this.$highlights.css({padding:"0","border-width":"0"});this.$backdrop.css({"margin-top":"+="+padding["padding-top"],"margin-right":"+="+padding["padding-right"],"margin-bottom":"+="+padding["padding-bottom"],"margin-left":"+="+padding["padding-left"]}).css({"margin-top":"+="+border["border-top-width"],"margin-right":"+="+border["border-right-width"],"margin-bottom":"+="+border["border-bottom-width"],"margin-left":"+="+border["border-left-width"]})},fixIOS:function(){this.$highlights.css({"padding-left":"+=3px","padding-right":"+=3px"})},handleInput:function(){var input=this.$el.val();var ranges=this.getRanges(input,this.highlight);var unstaggeredRanges=this.removeStaggeredRanges(ranges);var boundaries=this.getBoundaries(unstaggeredRanges);this.renderMarks(boundaries)},getRanges:function(input,highlight){var type=this.getType(highlight);switch(type){case"array":return this.getArrayRanges(input,highlight);case"function":return this.getFunctionRanges(input,highlight);case"regexp":return this.getRegExpRanges(input,highlight);case"string":return this.getStringRanges(input,highlight);case"range":return this.getRangeRanges(input,highlight);case"custom":return this.getCustomRanges(input,highlight);default:if(!highlight){return[]}else{console.error("unrecognized highlight type")}}},getArrayRanges:function(input,arr){var ranges=arr.map(this.getRanges.bind(this,input));return Array.prototype.concat.apply([],ranges)},getFunctionRanges:function(input,func){return this.getRanges(input,func(input))},getRegExpRanges:function(input,regex){var ranges=[];var match;while(match=regex.exec(input),match!==null){ranges.push([match.index,match.index+match[0].length]);if(!regex.global){break}}return ranges},getStringRanges:function(input,str){var ranges=[];var inputLower=input.toLowerCase();var strLower=str.toLowerCase();var index=0;while(index=inputLower.indexOf(strLower,index),index!==-1){ranges.push([index,index+strLower.length]);index+=strLower.length}return ranges},getRangeRanges:function(input,range){return[range]},getCustomRanges:function(input,custom){var ranges=this.getRanges(input,custom.highlight);if(custom.className){ranges.forEach(function(range){if(range.className){range.className=custom.className+" "+range.className}else{range.className=custom.className}})}return ranges},removeStaggeredRanges:function(ranges){var unstaggeredRanges=[];ranges.forEach(function(range){var isStaggered=unstaggeredRanges.some(function(unstaggeredRange){var isStartInside=range[0]>unstaggeredRange[0]&&range[0]<unstaggeredRange[1];var isStopInside=range[1]>unstaggeredRange[0]&&range[1]<unstaggeredRange[1];return isStartInside!==isStopInside});if(!isStaggered){unstaggeredRanges.push(range)}});return unstaggeredRanges},getBoundaries:function(ranges){var boundaries=[];ranges.forEach(function(range){boundaries.push({type:"start",index:range[0],className:range.className});boundaries.push({type:"stop",index:range[1]})});this.sortBoundaries(boundaries);return boundaries},sortBoundaries:function(boundaries){boundaries.sort(function(a,b){if(a.index!==b.index){return b.index-a.index}else if(a.type==="stop"&&b.type==="start"){return 1}else if(a.type==="start"&&b.type==="stop"){return-1}else{return 0}})},renderMarks:function(boundaries){var input=this.$el.val();boundaries.forEach(function(boundary,index){var markup;if(boundary.type==="start"){markup="{{hwt-mark-start|"+index+"}}"}else{markup="{{hwt-mark-stop}}"}input=input.slice(0,boundary.index)+markup+input.slice(boundary.index)});input=input.replace(/\n(\{\{hwt-mark-stop\}\})?$/,"\n\n$1");input=input.replace(/</g,"&lt;").replace(/>/g,"&gt;");if(this.browser==="ie"){input=input.replace(/ /g," <wbr>")}input=input.replace(/\{\{hwt-mark-start\|(\d+)\}\}/g,function(match,submatch){var className=boundaries[+submatch].className;if(className){return'<mark class="'+className+'">'}else{return"<mark>"}});input=input.replace(/\{\{hwt-mark-stop\}\}/g,"</mark>");this.$highlights.html(input);this.fixPadding()},handleScroll:function(){var scrollTop=this.$el.scrollTop();this.$backdrop.scrollTop(scrollTop);var scrollLeft=this.$el.scrollLeft();this.$backdrop.css("transform",scrollLeft>0?"translateX("+-scrollLeft+"px)":"")},blockContainerScroll:function(){this.$container.scrollLeft(0)},destroy:function(){this.$backdrop.remove();this.$el.unwrap().removeClass(ID+"-text "+ID+"-input").off(ID).removeData(ID)}};$.fn.highlightWithinTextarea=function(options){return this.each(function(){var $this=$(this);var plugin=$this.data(ID);if(typeof options==="string"){if(plugin){switch(options){case"update":plugin.handleInput();break;case"destroy":plugin.destroy();break;default:console.error("unrecognized method string")}}else{console.error("plugin must be instantiated first")}}else{if(plugin){plugin.destroy()}plugin=new HighlightWithinTextarea($this,options);if(plugin.isGenerated){$this.data(ID,plugin)}}})}})(jQuery);