window.splitTestForElementor = {};

// TODO@kberlau: Consistent check for variations and tests on save
// TODO@kberlau: Check 100 Percentage on save
// TODO@kberlau: Load combinations
// LOW@kberlau: Variation and Test active validation

window.splitTestForElementor.initInterval = null;

window.splitTestForElementor.start = function (testData, postData, wpNonce) {
	window.splitTestForElementor.wpNonce = wpNonce;
	if(typeof(window.splitTestForElementor.tests) === "undefined") {
		window.splitTestForElementor.tests = JSON.parse(testData);
		window.splitTestForElementor.posts = JSON.parse(postData);
		console.log("Loaded Elementor Data");
	}
};

window.splitTestForElementor.init = function () {

	var initialized = jQuery(".split-test-for-elementor-control-wrapper").attr("data-initialized");
	if (initialized === "true") {
		return;
	}

	jQuery(".split-test-for-elementor-control-wrapper").attr("data-initialized", "true");

	window.splitTestForElementor.fillTestSelect();

	jQuery(".split-test-for-elementor-variation-control").hide();

	jQuery(".split-test-for-elementor-add-new-test-wrapper").hide();
	var addNewTestButton = jQuery(".split-test-for-elementor-add-new-test-wrapper button");
	jQuery(addNewTestButton).text(jQuery(addNewTestButton).data("text"));

	jQuery(".split-test-for-elementor-add-new-variation-wrapper").hide();
	var addNewVariationButton = jQuery(".split-test-for-elementor-add-new-variation-wrapper button");
	jQuery(addNewVariationButton).text(jQuery(addNewVariationButton).data("text"));

	var testId = jQuery(".elementor-control-split_test_control_test_id input").val();
	var variationId = jQuery(".elementor-control-split_test_control_variation_id input").val();

	var test = null;
	jQuery.each(window.splitTestForElementor.tests, function (i, currentTest) {
		if (currentTest.id == testId) {
			test = currentTest;
		}
	});

	if (typeof(testId) !== "undefined" && testId != "" && testId != "null" &&
		typeof(variationId) !== "undefined" && variationId != "" && variationId != "null" && test != null) {

		jQuery("select#split-test-for-elementor-test-selector").val(testId);
		jQuery(".split-test-for-elementor-variation-control").show();
		window.splitTestForElementor.fillVariationSelect(test);
		jQuery("select#split-test-for-elementor-variation-selector").val(variationId);
	}

	jQuery("#external-page-tracking-code").focus(function() {
		jQuery("#external-page-tracking-code").select();
	});

};

window.splitTestForElementor.fillTestSelect = function () {
	var testSelect = jQuery("select#split-test-for-elementor-test-selector");
	jQuery(testSelect).html("");
	jQuery(testSelect).append(jQuery('<option>', {
		value: "null",
		text : "No Test"
	}));
	jQuery.each(window.splitTestForElementor.tests, function (i, test) {
		jQuery(testSelect).append(jQuery('<option>', {
			value: test.id,
			text : test.name
		}));
	});
	jQuery(testSelect).append(jQuery('<option>', {
		value: "add-new-test",
		text : "Add new test"
	}));
	jQuery(testSelect).unbind('change').change(function () {
		window.splitTestForElementor.testSelectorChanged(testSelect);
	});
};

window.splitTestForElementor.fillVariationSelect = function (test) {
	var variationSelect = jQuery("select#split-test-for-elementor-variation-selector");
	jQuery(variationSelect).html("");
	jQuery(variationSelect).append(jQuery('<option>', {
		value: "null",
		text : ""
	}));
	jQuery.each(test.variations, function (i, variation) {
		jQuery(variationSelect).append(jQuery('<option>', {
			value: variation.id,
			text : variation.name
		}));
	});
	jQuery(variationSelect).append(jQuery('<option>', {
		value: "add-new-variation",
		text : "Add new variation"
	}));

	jQuery(variationSelect).unbind('change').change(function () {
		window.splitTestForElementor.variationSelectorChanged(variationSelect);
	});
};

window.splitTestForElementor.testSelectorChanged = function (testSelect) {

	jQuery(".elementor-control-split_test_control_test_id input").val("null");
	jQuery(".elementor-control-split_test_control_variation_id input").val("null");
	jQuery(".split-test-for-elementor-add-new-test-wrapper").hide();
	jQuery(".split-test-for-elementor-add-new-variation-wrapper").hide();
	if (jQuery(testSelect).val() == null || jQuery(testSelect).val() == "null") {
		jQuery(".split-test-for-elementor-variation-control").hide();
		jQuery(".elementor-control-split_test_control_test_id input").trigger("input");
		return;
	}

	if (jQuery(testSelect).val() == "add-new-test") {
		jQuery(".split-test-for-elementor-add-new-test-wrapper").show();
		jQuery(".split-test-for-elementor-variation-control").hide();
		jQuery("#split-test-for-elementor-test-name-input").val("");
		jQuery("#split-test-for-elementor-conversion-type-selector").val("page");
		jQuery(".split-test-for-elementor-add-new-test-wrapper button").unbind("click").click(function () {
			window.splitTestForElementor.addNewTest();
		});

		jQuery("#split-test-for-elementor-conversion-type-selector").unbind('change').change(function () {
			window.splitTestForElementor.conversionTypeSelectorChanged(this);
		});
		jQuery(".split-test-for-elementor-conversion-page-wrapper").show();
		jQuery(".split-test-for-elementor-tracking-code-wrapper").hide();
		jQuery(".split-test-for-elementor-conversion-url-wrapper").hide();

		jQuery(".elementor-control-split_test_control_test_id input").trigger("input");
		return;
	}

	var testId = jQuery(testSelect).val();
	if (isNaN(testId)) {
		// LOW@kberlau: Better error reporting
		alert("Internal Error: The selected test id is not valid");
		return;
	}

	var test = null;
	jQuery.each(window.splitTestForElementor.tests, function (i, currentTest) {
		if (currentTest.id == testId) {
			test = currentTest;
		}
	});

	if (test == null) {
		// LOW@kberlau: Better error reporting
		alert("Internal Error: Test not found");
		return;
	}

	jQuery(".split-test-for-elementor-variation-control").show();
	window.splitTestForElementor.fillVariationSelect(test);

	jQuery(".elementor-control-split_test_control_test_id input").val(test.id);
	jQuery(".elementor-control-split_test_control_test_id input").trigger("input");

};

window.splitTestForElementor.conversionTypeSelectorChanged = function (select) {
	var conversionPageSelector = jQuery(".split-test-for-elementor-conversion-page-wrapper");
	var trackingCodeSelector = jQuery(".split-test-for-elementor-tracking-code-wrapper");
	var conversionUrlSelector = jQuery(".split-test-for-elementor-conversion-url-wrapper");

	if (jQuery(select).val() === "widget") {
		jQuery(conversionPageSelector).slideUp();
		jQuery(trackingCodeSelector).slideUp();
		jQuery(conversionUrlSelector).slideUp();
		jQuery("#split-test-for-elementor-conversion-page-selector").val("null");
		alert("The use of the conersion widget is deprecated. Please do not use this.");
	} else if (jQuery(select).val() === "external_page") {
		jQuery(conversionPageSelector).slideUp();
		jQuery(conversionUrlSelector).slideUp();
		jQuery(trackingCodeSelector).slideDown();
		jQuery("#split-test-for-elementor-conversion-page-selector").val("null");
	} else if (jQuery(select).val() === "url") {
		jQuery(conversionPageSelector).slideUp();
		jQuery(trackingCodeSelector).slideUp();
		jQuery(conversionUrlSelector).slideDown();
	} else {
		jQuery(conversionPageSelector).slideDown();
		jQuery(trackingCodeSelector).slideUp();
		jQuery(conversionUrlSelector).slideUp();
	}
}

window.splitTestForElementor.addNewTest = function () {

	var addNewTestButton = jQuery(".split-test-for-elementor-add-new-test-wrapper button");
	window.splitTestForElementor.setButtonSaveMode(addNewTestButton, "Saving new test ...");

	var test = {
		name: jQuery("#split-test-for-elementor-test-name-input").val(),
		conversionType: jQuery("#split-test-for-elementor-conversion-type-selector").val(),
		conversionPageId: jQuery("#split-test-for-elementor-conversion-page-selector").val(),
		conversionUrl: jQuery("#split-test-for-elementor-conversion-url").val(),
		_wpnonce: window.splitTestForElementor.wpNonce
	};

	if (test.conversionType == "page" && test.conversionPageId == "null") {
		alert("Please select a conversion page");
		window.splitTestForElementor.resetButtonSaveMode(addNewTestButton);
		return;
	}

	jQuery.post("../wp-json/splitTestForElementor/v1/tests/", test, function(result) {
		if (result.success) {
			window.splitTestForElementor.addNewTestCallback(result);
		} else {
			// TODO@kberlau: Add multi error possibility
			alert(result.errors[0].message);
			if (result.errors[0].key === "MAXIMUM_TEST_COUNT_REACHED") {
				jQuery(".split-test-for-elementor-hint").remove();
				jQuery("body").append('<div class="split-test-for-elementor-hint"><a href="' + result.errors[0].payload.link + '" target="_blank">' +
					'To add more tests buy the <span style="text-decoration: underline;">pro version</span>' +
					'</a><span class="close">&times;</span></div>');
				window.splitTestForElementor.handleCloseHintClick();
			}
			window.splitTestForElementor.resetButtonSaveMode(addNewTestButton);
		}
	}).fail(function(result) {
		alert("Error saving new test");
		window.splitTestForElementor.resetButtonSaveMode(addNewTestButton);
	});
};

window.splitTestForElementor.addNewTestCallback = function (result) {

	var addNewTestButton = jQuery(".split-test-for-elementor-add-new-test-wrapper button");
	window.splitTestForElementor.resetButtonSaveMode(addNewTestButton);
	jQuery(".split-test-for-elementor-add-new-test-wrapper").slideUp();

	var newTest = {
		'id': result.id,
		'name': result.name,
		'variations': []
	};
	window.splitTestForElementor.tests.push(newTest);

	window.splitTestForElementor.fillTestSelect();
	window.splitTestForElementor.fillVariationSelect(newTest);
	jQuery(".split-test-for-elementor-variation-control").show();
	var testSelect = jQuery("select#split-test-for-elementor-test-selector");
	jQuery(testSelect).val(result.id);

	jQuery(".elementor-control-split_test_control_test_id input").val(result.id);
	jQuery(".elementor-control-split_test_control_test_id input").trigger("input");

};

window.splitTestForElementor.variationSelectorChanged = function (variationSelect) {
	// TODO@kberlau: Change id in hidden field

	jQuery(".elementor-control-split_test_control_variation_id input").val("null");
	jQuery(".split-test-for-elementor-add-new-variation-wrapper").hide();
	if (jQuery(variationSelect).val() == null || jQuery(variationSelect).val() == "null") {
		return;
	}

	if (jQuery(variationSelect).val() == "add-new-variation") {
		jQuery(".split-test-for-elementor-add-new-variation-wrapper").show();
		jQuery(".split-test-for-elementor-add-new-variation-wrapper button").unbind("click").click(function () {
			window.splitTestForElementor.addNewVariation();
		});
		// TODO@kberlau: Change model
		return;
	}

	var variationId = jQuery(variationSelect).val();
	if (isNaN(variationId)) {
		// LOW@kberlau: Better error reporting
		alert("Internal Error: The selected variation id is not valid");
		return;
	}

	var test = null;
	var testId = jQuery(".elementor-control-split_test_control_test_id input").val();
	jQuery.each(window.splitTestForElementor.tests, function (i, currentTest) {
		if (currentTest.id == testId) {
			test = currentTest;
		}
	});

	if (test == null) {
		// LOW@kberlau: Better error reporting
		alert("Internal Error: Test not found");
		return;
	}

	var variation = null;
	jQuery.each(test.variations, function (i, currentVariation) {
		if (currentVariation.id == variationId) {
			variation = currentVariation;
		}
	});

	if (variation == null) {
		// LOW@kberlau: Better error reporting
		alert("Internal Error: Variation not found");
		return;
	}

	jQuery(".elementor-control-split_test_control_variation_id input").val(variation.id);
	jQuery(".elementor-control-split_test_control_variation_id input").trigger("input");

};

window.splitTestForElementor.addNewVariation = function () {
	var testId = jQuery(".elementor-control-split_test_control_test_id input").val();

	var variationName = jQuery("input#split-test-for-elementor-new-variation-name").val();
	//TODO@kberlau: Validate number
	var variationPercentage = jQuery("input#split-test-for-elementor-new-variation-percentage").val();

	var addNewVariationButton = jQuery(".split-test-for-elementor-add-new-variation-wrapper button");
	window.splitTestForElementor.setButtonSaveMode(addNewVariationButton, "Saving new variation ...");

	var newTestVariation = {
		name: variationName,
		percentage: parseInt(variationPercentage),
		testId: testId,
		_wpnonce: window.splitTestForElementor.wpNonce
	};
	jQuery.post("../wp-json/splitTestForElementor/v1/variations/", newTestVariation, function(result) {
		if (result.success) {
			window.splitTestForElementor.addNewVariationCallback(result);
		} else {
			alert(result.errors[0].message);
			if (result.errors[0].key === "MAXIMUM_VARIATION_COUNT_REACHED") {
				jQuery(".split-test-for-elementor-hint").remove();
				jQuery("body").append('<div class="split-test-for-elementor-hint"><a href="' + result.errors[0].payload.link + '" target="_blank">' +
					'To add more variations buy the <span style="text-decoration: underline;">pro version</span>' +
					'</a><span class="close">&times;</span></div>');
				window.splitTestForElementor.handleCloseHintClick();
			}
			window.splitTestForElementor.resetButtonSaveMode(addNewVariationButton);
		}
	}).fail(function(result) {
		alert("Error saving new variation");
		window.splitTestForElementor.resetButtonSaveMode(addNewVariationButton);
	});
};

window.splitTestForElementor.addNewVariationCallback = function (result) {
	var testId = jQuery(".elementor-control-split_test_control_test_id input").val();

	var addNewTestButton = jQuery(".split-test-for-elementor-add-new-variation-wrapper button");
	window.splitTestForElementor.resetButtonSaveMode(addNewTestButton);
	jQuery(".split-test-for-elementor-add-new-variation-wrapper").slideUp();

	var test = null;
	jQuery.each(window.splitTestForElementor.tests, function (i, currentTest) {
		if (currentTest.id == testId) {
			test = currentTest;
		}
	});

	if (test == null) {
		// LOW@kberlau: Better error reporting
		alert("Internal Error: Test not found");
		return;
	}

	var newVariation = {
		'id': result.id,
		'name': result.name
	};
	test.variations.push(newVariation);
	window.splitTestForElementor.fillVariationSelect(test);

	jQuery(".elementor-control-split_test_control_variation_id input").val(result.id);
	jQuery(".elementor-control-split_test_control_variation_id input").trigger("input");

	var variationSelect = jQuery("select#split-test-for-elementor-variation-selector");
	jQuery(variationSelect).val(result.id);

};

window.splitTestForElementor.setButtonSaveMode = function(button, text) {
	jQuery(button).addClass("elementor-button-default");
	jQuery(button).removeClass("elementor-button-success");
	jQuery(button).text(text);
};

window.splitTestForElementor.resetButtonSaveMode = function(button) {
	jQuery(button).removeClass("elementor-button-default");
	jQuery(button).addClass("elementor-button-success");
	jQuery(button).text(jQuery(button).data("text"));
};

window.splitTestForElementor.handleCloseHintClick = function () {
	jQuery(".split-test-for-elementor-hint .close").click(function () {
		jQuery(".split-test-for-elementor-hint").remove();
	});
}

setInterval(function () {
	if (document.getElementById("split-test-for-elementor-jscode") != null) {
		eval(document.getElementById("split-test-for-elementor-jscode").text)
	}
}, 1000);


// setTimeout(function () {
// 	elementor.hooks.addAction( 'panel/open_editor/widget', function( panel, model, view ) {
// 		console.log("hook!");
// 		if (document.getElementById("split-test-for-elementor-jscode") != null) {
// 			eval(document.getElementById("split-test-for-elementor-jscode").text)
// 		}
// 		// var $element = view.$el.find( '.elementor-selector' );
// 		//
// 		// console.log(view.$el);
// 		// console.log(view);
// 		//
// 		// window.splitTestForElementor.init();
//
// 	} );
// }, 1000);