<?php 
add_action('spiceb_wphester_news_action','spiceb_wphester_news_section');
/* Function for news section*/
function spiceb_wphester_news_section()
{
$newz_animation_speed = get_theme_mod('news_animation_speed', 3000);
$newz_smooth_speed = get_theme_mod('news_smooth_speed', 1000);
$isRTL = (is_rtl()) ? (bool) true : (bool) false;
$newz_slide_layout = get_theme_mod('wphester_homeblog_layout',4);
if($newz_slide_layout==4){
    $newz_slide_items=3;
}elseif($newz_slide_layout==6){
  $newz_slide_items=2;
}
$newz_nav_style = get_theme_mod('news_nav_style', 'bullets');
$newzsettings = array('slide_items' => $newz_slide_items, 'animationSpeed' => $newz_animation_speed, 'smoothSpeed' => $newz_smooth_speed, 'newz_nav_style' => $newz_nav_style, 'rtl' => $isRTL);
wp_register_script('wphester-blog', SPICEB_PLUGIN_URL . 'inc/wphester/js/front-page/blog.js', array('jquery'), SPICEBOX_PLUGIN_VERSION, true);
wp_localize_script('wphester-blog','newz_settings', $newzsettings);
wp_enqueue_script('wphester-blog');
$latest_news_section_enable = get_theme_mod('latest_news_section_enable', true);
if ($latest_news_section_enable != false) {
$btn_icon= is_rtl() ? 'fa fa-long-arrow-left': 'fa fa-long-arrow-right';
?>
    <!-- Latest News section -->
    <section class="section-space blog bg-default-lite home-blog">
        <div class="wphester-newz container">
            <?php
            $home_news_section_title = get_theme_mod('home_news_section_title', __('Vitae Lacinia', 'spicebox'));
            $home_news_section_discription = get_theme_mod('home_news_section_discription', __('Cras Vitae Placerat', 'spicebox'));
            $home_meta_section_settings = get_theme_mod('home_meta_section_settings', true);
            if (($home_news_section_title) || ($home_news_section_discription) != '') {
                ?>
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-xs-12">
                        <div class="section-header">                            
                            <?php if($home_news_section_title){?><h2 class="section-title"><?php echo wp_kses_post($home_news_section_title); ?></h2><?php }
                            if ($home_news_section_discription){?><p class="section-subtitle"><?php echo wp_kses_post($home_news_section_discription); ?></p>
                            <?php } ?>
                        </div>
                    </div>                      
                </div>
                <!-- /Section Title -->
            <?php } ?>
            <div class="row">
                <?php
                $no_of_post = 4;
                $args = array(
                    'post_type'      => 'post',
                    'posts_per_page' => $no_of_post,
                    'ignore_sticky_posts' => 1,
                );
                $query = new WP_Query($args);
                if ($query->have_posts()) { ?>
                    <div id="blog-carousel1" class="owl-carousel owl-theme col-lg-12">
                        <?php while ($query->have_posts()) : $query->the_post(); ?>
                            <div class="item">
                                <article class="post">
                                    <?php if (has_post_thumbnail()) { ?>
                                        <figure class="post-thumbnail">                     
                                            <?php 
                                            $defalt_arg = array('class' => "img-fluid");
                                            the_post_thumbnail('', $defalt_arg); ?>
                                        </figure>
                                    <?php } ?>
                                    <div class="post-content <?php if(!has_post_thumbnail()){ echo 'remove-images';}?>"> 
                                        <?php if ($home_meta_section_settings == true) {?> 
                                            <div class="entry-date <?php if(!has_post_thumbnail()){ echo 'remove-image';}?>">
                                                <a href="<?php echo esc_url(home_url()).'/'.esc_html(gmdate('Y/m', strtotime(get_the_date()))); ?>">
                                                    <span class="date"><?php echo esc_html(get_the_date()); ?></span>
                                                </a>
                                            </div>                                      

                                            <div class="entry-meta">
                                                <i class="fa fa-user"></i><span class="author postauthor"><a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                                                    <?php echo esc_html(get_the_author()); ?></a></span>
                                                <?php
                                                $cat_list = get_the_category_list();
                                                if (!empty($cat_list)) {?>
                                                    <i class="fa fa-folder-open"></i><span class="cat-links postcat"><?php the_category(', '); ?></span>
                                                <?php } 
                                                $commt = get_comments_number();
                                                if (!empty($commt)) {
                                                    ?>
                                                    <i class="fa fa-comment-o"></i><span class="cat-links"><a href="<?php the_permalink();?>"><?php echo esc_html(get_comments_number());?></a></span>
                                                <?php } ?>
                                            </div>  
                                        <?php } ?>

                                        <header class="entry-header">
                                            <h4 class="entry-title">
                                                <a class="home-blog-title" href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                            </h4>
                                        </header>

                                        <div class="entry-content">
                                            <?php the_excerpt(); 
                                            $blog_button = get_theme_mod('home_news_button_title', __('Cras Vitae', 'spicebox'));
                                                if (!empty($blog_button)) {?>
                                                <p>
                                                    <a href="<?php the_permalink(); ?>" class="btn-small more-link"><?php echo esc_html($blog_button); ?>
                                                        <i class="<?php echo esc_attr($btn_icon); ?>"></i>
                                                    </a>
                                                </p>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </article>
                            </div>                        
                            <?php
                        endwhile;?>
                    </div>
                <?php } 
                wp_reset_postdata(); ?>
            </div>
        </div>
    </section>
<?php } 
} ?>