<?php
/**
 * The template used to generate a cache bypass nginx.conf for when a user disables nginx caching.
 *
 * @package SolidWP\Performance
 */

declare( strict_types=1 );

$nginx = <<<RULES
# BEGIN SolidPerformanceNginxBypassRules
# This should be included in the server{} block of your vhost.
# This file is automatically generated. Do no edit. Use the `solidwp/performance/nginx/bypass/rules` filter.

# Deny direct access to the Solid Performance swpsp-nginx.conf.
location ~ swpsp-nginx\.conf$ {
	deny all;
}

# Nginx caching has been disabled via settings, provide a location fallback.
location / {
	try_files \$uri \$uri/ /index.php?\$args;
}
# END SolidPerformanceNginxBypassRules

RULES;

// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped, StellarWP.XSS.EscapeOutput.OutputNotEscaped
echo apply_filters( 'solidwp/performance/nginx/bypass/rules', $nginx );
