<?php

/**
 *
 *
 * @param $name
 * @param $post_url
 * @param $post_title
 * @param $post_image
 * @return mixed|void
 */
function dpsp_get_pro_network_share_link( $name, $post_url, $post_title, $post_image ) {
	// @TODO: This function is depreacated, replace with call to $network->get_share_link() where $network is the Network instance for a particular network
	switch ( $name ) {

		case 'reddit':
			$share_link = sprintf( 'https://www.reddit.com/submit?url=%1$s&title=%2$s', $post_url, $post_title );
			break;

		case 'vkontakte':
			$share_link = sprintf( 'http://vk.com/share.php?url=%1$s', $post_url );
			break;

		case 'whatsapp':
			$share_link = sprintf( 'https://wa.me/?text=%1$s+%2$s', $post_title, $post_url );
			break;

		case 'pocket':
			$share_link = sprintf( 'https://getpocket.com/edit?url=%1$s', $post_url );
			break;

		case 'buffer':
			$share_link = sprintf( 'https://buffer.com/add?url=%1$s&text=%2$s', $post_url, $post_title );
			break;

		case 'tumblr':
			$share_link = sprintf( 'https://www.tumblr.com/widgets/share/tool?canonicalUrl=%1$s', $post_url );
			break;

		case 'xing':
			$share_link = sprintf( 'https://www.xing.com/spi/shares/new?url=%1$s', $post_url );
			break;

		case 'flipboard':
			$share_link = sprintf( 'https://share.flipboard.com/bookmarklet/popout?v=2&url=%1$s&title=%2$s', $post_url, $post_title );
			break;

		case 'telegram':
			$share_link = sprintf( 'https://telegram.me/share/url?url=%1$s&text=%2$s', $post_url, $post_title );
			break;

		case 'mix':
			$share_link = sprintf( 'https://mix.com/add?url=%1$s', $post_url );
			break;

		default:
			$share_link = '';
	}

	return apply_filters( 'dpsp_get_network_share_link', $share_link, $name );
}

/**
 *
 *
 * @param $name
 * @param $network_handle
 * @return mixed|void
 */
function dpsp_get_pro_network_follow_link( $name, $network_handle ) {
	// @TODO: This function is depreacated, replace with call to $network->get_follow_link() where $network is the Network instance for a particular network
	$follow_link = '';
	switch ( $name ) {
		case 'reddit':
			$follow_link = sprintf( 'https://www.reddit.com/user/%1$s', $network_handle );
			break;

		case 'vkontakte':
			$follow_link = sprintf( 'https://vk.com/%1$s', $network_handle );
			break;

		case 'instagram':
			$follow_link = sprintf( 'https://www.instagram.com/%1$s', $network_handle );
			break;

		case 'youtube':
			$follow_link = sprintf( 'https://www.youtube.com/%1$s', $network_handle );
			break;

		case 'vimeo':
			$follow_link = sprintf( 'https://vimeo.com/%1$s', $network_handle );
			break;

		case 'soundcloud':
			$follow_link = sprintf( 'https://soundcloud.com/%1$s', $network_handle );
			break;

		case 'twitch':
			$follow_link = sprintf( 'https://www.twitch.tv/%1$s/profile', $network_handle );
			break;

		case 'behance':
			$follow_link = sprintf( 'https://www.behance.net/%1$s', $network_handle );
			break;

		case 'xing':
			$follow_link = sprintf( 'https://www.xing.com/profile/%1$s', $network_handle );
			break;

		case 'github':
			$follow_link = sprintf( 'https://github.com/%1$s', $network_handle );
			break;

		case 'telegram':
			$follow_link = sprintf( 'https://telegram.me/%1$s', $network_handle );
			break;

		case 'medium':
			$follow_link = sprintf( 'https://medium.com/%1$s', ( strpos( $network_handle, '@' ) === 0 ? $network_handle : '@' . $network_handle ) );
			break;
		
		case 'flipboard':
			$follow_link = sprintf( 'https://flipboard.com/%1$s', ( strpos( $network_handle, '@' ) === 0 ? $network_handle : '@' . $network_handle ) );
			break;
	}

	return apply_filters( 'dpsp_get_network_follow_link', $follow_link, $name );
}

/**
 *
 *
 * @return array[]
 */
function dpsp_get_pro_svg_icon_data() {
	// @TODO: This function is depreacated, replace with call to $network->get_icon() where $network is the Network instance for a particular network
	return [
		'reddit'     => [
			'path'   => 'M0 15.616q0-0.736 0.288-1.408t0.768-1.184 1.152-0.8 1.472-0.288q1.376 0 2.368 0.928 1.888-1.184 4.32-1.888t5.184-0.8l2.56-7.296 6.272 1.504q0.288-0.832 1.056-1.344t1.696-0.544q1.248 0 2.144 0.864t0.896 2.144-0.896 2.112-2.112 0.864-2.144-0.864-0.896-2.112l-5.248-1.248-2.144 5.92q2.688 0.128 5.024 0.864t4.128 1.824q1.056-0.928 2.432-0.928 0.736 0 1.44 0.288t1.184 0.8 0.768 1.184 0.288 1.408q0 0.992-0.48 1.824t-1.28 1.312q0.128 0.544 0.128 1.12 0 1.92-1.12 3.712t-3.104 3.104-4.576 2.048-5.632 0.768q-2.944 0-5.568-0.768t-4.576-2.048-3.104-3.104-1.12-3.712q0-0.32 0.064-0.64 0-0.288 0.064-0.544-0.768-0.512-1.216-1.28t-0.48-1.792zM2.752 19.872q0 1.76 1.024 3.264t2.816 2.688 4.224 1.824 5.152 0.672 5.12-0.672 4.224-1.824 2.848-2.688 1.024-3.264-1.024-3.328-2.848-2.72-4.224-1.792-5.12-0.672-5.152 0.672-4.224 1.792-2.816 2.72-1.024 3.328zM9.12 18.144q0-0.896 0.704-1.6t1.6-0.672 1.6 0.672 0.672 1.6-0.672 1.568-1.6 0.672-1.6-0.672-0.704-1.568zM10.816 23.424q0.384-0.32 1.056 0.256 0.192 0.192 0.416 0.32t0.448 0.224 0.416 0.16 0.448 0.096 0.416 0.096 0.448 0.096 0.448 0.064 0.48 0.032 0.544 0.032q2.432-0.128 4.256-1.12 0.672-0.64 1.12-0.256 0.32 0.576-0.384 1.12-1.856 1.44-4.992 1.44-3.36-0.064-4.864-1.44-0.832-0.608-0.256-1.12zM18.56 18.112q0-0.928 0.672-1.6t1.6-0.64 1.632 0.64 0.672 1.6-0.672 1.6-1.632 0.672-1.6-0.672-0.672-1.6z',
			'width'  => 32,
			'height' => 32,
		],
		'vkontakte'  => [
			'path'   => 'M34.24 9.28q0.416 1.152-2.688 5.248-0.416 0.576-1.152 1.536-0.704 0.896-0.992 1.28t-0.544 0.864-0.224 0.768 0.256 0.608 0.576 0.768 1.024 0.96q0.064 0.032 0.064 0.064 2.528 2.336 3.424 3.936 0.064 0.096 0.128 0.224t0.128 0.48-0.032 0.608-0.448 0.48-1.056 0.224l-4.544 0.096q-0.448 0.064-1.024-0.096t-0.928-0.416l-0.352-0.192q-0.544-0.384-1.248-1.152t-1.216-1.376-1.088-1.056-1.024-0.256q-0.032 0-0.128 0.064t-0.32 0.256-0.384 0.512-0.288 0.928-0.128 1.408q0 0.256-0.064 0.48t-0.128 0.32l-0.064 0.096q-0.32 0.352-0.96 0.384h-2.048q-1.28 0.096-2.592-0.288t-2.368-0.928-1.824-1.184-1.28-1.024l-0.448-0.448q-0.16-0.16-0.48-0.544t-1.28-1.6-1.888-2.72-2.176-3.744-2.336-4.864q-0.128-0.288-0.128-0.48t0.064-0.288l0.064-0.096q0.288-0.352 1.024-0.352l4.896-0.032q0.224 0.032 0.416 0.096t0.288 0.16l0.096 0.064q0.288 0.192 0.416 0.576 0.352 0.896 0.832 1.824t0.736 1.472l0.288 0.512q0.512 1.088 0.992 1.856t0.864 1.216 0.736 0.704 0.608 0.256 0.48-0.096q0.032-0.032 0.096-0.096t0.224-0.384 0.224-0.832 0.16-1.472 0-2.208q-0.032-0.736-0.16-1.312t-0.224-0.832l-0.128-0.192q-0.448-0.608-1.504-0.768-0.256-0.064 0.096-0.448 0.256-0.32 0.672-0.544 0.928-0.448 4.256-0.416 1.472 0.032 2.4 0.224 0.384 0.096 0.608 0.256t0.384 0.416 0.16 0.576 0.064 0.8 0 0.992-0.064 1.28 0 1.472q0 0.192-0.032 0.736t0 0.864 0.064 0.704 0.192 0.704 0.416 0.448q0.128 0.032 0.288 0.064t0.48-0.192 0.672-0.608 0.928-1.216 1.216-1.92q1.056-1.856 1.92-4 0.064-0.192 0.16-0.32t0.192-0.192l0.096-0.064 0.064-0.032t0.256-0.064 0.352 0l5.12-0.032q0.704-0.096 1.152 0.032t0.544 0.32z',
			'width'  => 34,
			'height' => 32,
		],
		'whatsapp'   => [
			'path'   => 'M17.6 17.376q0.224 0 1.728 0.8t1.6 0.96q0.032 0.064 0.032 0.256 0 0.576-0.288 1.344-0.288 0.704-1.28 1.184t-1.824 0.48q-1.024 0-3.392-1.12-1.76-0.8-3.040-2.112t-2.624-3.296q-1.312-1.92-1.28-3.456v-0.16q0.064-1.6 1.312-2.816 0.448-0.384 0.928-0.384 0.128 0 0.32 0.032t0.352 0.032q0.352 0 0.48 0.096t0.256 0.512q0.16 0.352 0.608 1.568t0.448 1.312q0 0.384-0.608 1.056t-0.64 0.832q0 0.096 0.096 0.256 0.608 1.312 1.824 2.432 0.992 0.96 2.688 1.824 0.224 0.128 0.416 0.128 0.256 0 0.96-0.864t0.928-0.896zM13.952 26.848q2.272 0 4.352-0.896t3.584-2.368 2.4-3.584 0.896-4.352-0.896-4.352-2.4-3.584-3.584-2.4-4.352-0.896-4.32 0.896-3.584 2.4-2.4 3.584-0.896 4.352q0 3.616 2.144 6.56l-1.408 4.16 4.32-1.376q2.816 1.856 6.144 1.856zM13.952 2.176q2.752 0 5.248 1.088t4.288 2.848 2.88 4.32 1.056 5.216-1.056 5.216-2.88 4.288-4.288 2.88-5.248 1.088q-3.456 0-6.496-1.696l-7.456 2.4 2.432-7.232q-1.92-3.168-1.92-6.944 0-2.752 1.056-5.216t2.88-4.32 4.288-2.848 5.216-1.088z',
			'width'  => 27,
			'height' => 32,
		],
		'pocket'     => [
			'path'   => 'M0.064 10.56q-0.224-6.88 0.384-8.64 0.128-0.288 0.288-0.512t0.448-0.384 0.448-0.32 0.544-0.32 0.544-0.256q4.352 0 12.352-0.064t10.528-0.064h3.008t1.76 0 1.792 0.096 1.44 0.192 1.056 0.32q0.512 0.288 0.864 0.768t0.512 0.928 0.256 1.28 0.064 1.344-0.032 1.6 0 1.6q0 6.624-0.736 10.464t-3.072 6.816q-2.24 2.816-5.28 4.48t-6.176 1.984-6.4-0.352-5.952-2.336-4.832-4.288-3.072-5.792q-0.48-1.664-0.736-8.544zM7.488 10.496q-0.832 0.896 0.48 2.848t3.328 3.968q0.064 0.064 1.248 1.28t1.728 1.664 1.504 1.12 1.824 0.928q0.352 0.096 0.704 0.096t0.64-0.032 0.608-0.224 0.512-0.224 0.512-0.384 0.384-0.32 0.384-0.352l0.096-0.096q0.288-0.288 1.92-1.792t2.752-2.592 2.176-2.528 1.12-2.4q-0.48-1.28-1.216-1.792t-1.632-0.288-1.792 0.832-1.888 1.536-1.792 1.792-1.568 1.632-1.184 1.056q-0.864-0.512-2.336-1.92t-2.624-2.624-2.336-2.048-1.76-0.448q-0.8 0.48-1.792 1.312z',
			'width'  => 36,
			'height' => 32,
		],
		'yummly'     => [
			'path'   => 'M4.576 0.128c-0.032 0.032-0.16 0.064-0.32 0.064-0.576 0.096-1.216 0.288-1.376 0.384-0.064 0.064-0.128 0.064-0.16 0.032s-0.032 0-0.032 0.064c0 0.064-0.032 0.064-0.064 0.064-0.096-0.096-1.504 0.672-1.888 1.024-0.16 0.16-0.32 0.288-0.32 0.256s-0.096 0.096-0.192 0.288c-0.16 0.256-0.192 0.416-0.192 0.672 0.032 0.224 0.096 0.448 0.16 0.512 0.032 0.064 0.064 0.096 0.032 0.096-0.096 0 0.064 0.288 0.384 0.768 0.16 0.224 0.32 0.416 0.384 0.416 0.032 0 0.096 0.032 0.064 0.064-0.032 0.128 0.384 0.416 0.576 0.416 0.128 0 0.32-0.128 0.544-0.32 0.16-0.192 0.352-0.32 0.352-0.32 0.032 0 0.192-0.096 0.384-0.224 0.704-0.48 1.6-0.608 1.856-0.288 0.064 0.064 0.16 0.128 0.192 0.096 0.064-0.032 0.064-0.032 0.032 0.032s-0.032 0.192 0 0.288c0.032 0.096 0.032 0.352 0 0.576-0.032 0.192-0.096 0.48-0.096 0.576-0.032 0.128-0.096 0.384-0.16 0.544-0.032 0.192-0.096 0.384-0.096 0.448-0.032 0.032-0.096 0.288-0.16 0.544-0.096 0.256-0.16 0.576-0.192 0.704s-0.064 0.256-0.064 0.288c-0.064 0.064-0.128 0.352-0.16 0.672-0.032 0.064-0.064 0.16-0.064 0.256-0.064 0.16-0.256 0.832-0.288 0.992 0 0.064-0.032 0.192-0.064 0.256-0.064 0.128-0.224 0.8-0.256 0.992-0.032 0.064-0.16 0.576-0.288 1.088-0.16 0.512-0.288 1.024-0.288 1.088-0.032 0.096-0.096 0.288-0.128 0.448-0.064 0.192-0.064 0.352-0.064 0.384 0.032 0.032 0.032 0.096-0.032 0.096-0.096 0.032-0.224 0.96-0.192 1.632 0 0.544 0.32 1.696 0.448 1.696 0.032 0 0.096 0.064 0.128 0.16 0.064 0.224 0.64 0.768 1.024 0.992 0.96 0.544 2.752 0.608 4.512 0.224 0.736-0.16 1.888-0.544 1.92-0.64 0-0.032 0.064-0.064 0.096-0.032 0.064 0.064 1.088-0.448 1.312-0.64 0.064-0.032 0.128-0.064 0.16-0.032 0.032 0-0.032 0.416-0.128 0.864-0.096 0.48-0.16 0.896-0.16 0.928 0 0.064-0.032 0.224-0.16 0.672 0 0.096-0.096 0.16-0.16 0.16-0.576 0-2.688 0.512-2.688 0.608 0 0.064-0.032 0.064-0.096 0.032s-1.184 0.384-1.28 0.512c-0.032 0.032-0.064 0.064-0.064 0s-0.672 0.288-0.768 0.384c0 0.032-0.064 0.096-0.096 0.096-0.16 0-0.704 0.352-0.672 0.416s0.032 0.064-0.032 0.032c-0.16-0.096-1.856 1.664-1.696 1.824 0.032 0.032 0 0.032-0.064 0.032-0.128 0-0.832 1.472-0.96 2.112-0.032 0.096-0.128 0.992-0.16 1.216-0.032 0.544 0.128 1.344 0.384 1.92 0.864 1.824 3.040 2.688 5.44 2.176 0.512-0.128 1.568-0.512 1.696-0.64 0.064-0.064 0.16-0.128 0.16-0.096 0.064 0.032 0.192 0 0.32-0.128 0.096-0.096 0.256-0.224 0.352-0.288 0.192-0.128 0.736-0.64 1.088-1.024 0.32-0.352 0.768-1.024 0.736-1.088-0.032-0.032-0.032-0.064 0.032-0.064s0.352-0.512 0.352-0.608c0-0.032 0.032-0.096 0.064-0.128 0.192-0.128 0.832-1.888 1.088-3.008 0.16-0.64 0.32-1.184 0.352-1.248 0.064-0.16 0.384-0.16 1.984 0.032 0.992 0.128 1.152 0.128 1.344 0.16 0.128 0.032 0.544 0.096 0.96 0.192 1.12 0.16 0.992 0.16 2.88 0.544 0.736 0.128 1.376 0.256 1.472 0.288 0.064 0 0.192 0.032 0.288 0.064 0.064 0.032 0.224 0.064 0.352 0.064 0.192 0.032 0.832 0.16 0.896 0.192 0.032 0 0.16 0.032 0.256 0.064 0.224 0.064 2.432 0.512 2.752 0.608 0.128 0 0.512 0.096 0.864 0.16 0.8 0.16 1.12 0.224 1.376 0.256 0.096 0 0.192 0.032 0.192 0.032 0 0.032 0.064 0.064 0.096 0.064 0.128 0 0.768 0.096 1.024 0.16 0.704 0.128 2.144 0.352 2.528 0.416 0.288 0.032 0.512 0.064 0.544 0.096 0.032 0 0.32 0.032 0.672 0.064 0.32 0.032 0.672 0.064 0.768 0.096 0.704 0.128 5.152 0.224 5.984 0.096 0.224-0.032 0.608-0.064 0.896-0.096s0.544-0.128 0.576-0.16c0.032-0.032 0.064-0.032 0.096-0.032 0.256 0.16 3.616-0.992 3.616-1.216 0-0.032 0.032-0.064 0.064-0.064 0.096 0.032 0.576-0.224 1.024-0.544 0.512-0.384 0.768-0.896 0.768-1.504 0-0.544-0.288-1.248-0.672-1.76-0.288-0.416-0.608-0.736-0.608-0.64 0 0.032-0.032 0-0.096-0.032-0.064-0.064-0.352 0.032-1.056 0.384-0.544 0.256-1.12 0.512-1.28 0.576s-0.416 0.16-0.544 0.224c-0.32 0.16-2.336 0.672-2.816 0.736-0.192 0.032-0.448 0.064-0.544 0.096-0.128 0-0.448 0.032-0.768 0.064-0.288 0.064-0.672 0.096-0.832 0.096-0.448 0.064-3.904 0.064-4.512 0-0.288 0-0.768-0.064-1.056-0.096-0.416-0.032-0.768-0.064-1.664-0.16-0.128 0-0.384-0.032-0.576-0.064-1.152-0.16-1.792-0.256-1.952-0.256-0.128-0.032-0.224-0.032-0.224-0.032 0-0.032-0.16-0.064-0.704-0.128-0.224-0.032-0.48-0.064-0.576-0.096-0.128-0.032-0.448-0.096-0.768-0.128-0.288-0.064-0.64-0.128-0.736-0.128-0.128-0.032-0.32-0.064-0.416-0.064-0.256-0.064-2.048-0.384-2.368-0.448-0.192-0.032-0.736-0.128-1.024-0.16-0.096 0-0.16-0.032-0.16-0.032 0-0.032-0.224-0.064-0.672-0.128-0.192 0-0.416-0.064-0.512-0.064-0.096-0.032-0.32-0.064-0.544-0.096-0.192-0.032-0.448-0.096-0.544-0.096-0.096-0.032-0.32-0.064-0.512-0.064-0.16-0.032-0.384-0.064-0.48-0.064-0.096-0.032-0.416-0.096-0.672-0.128-0.288-0.032-0.576-0.064-0.672-0.064-0.096-0.032-0.384-0.064-0.64-0.096-0.224-0.032-0.544-0.064-0.704-0.064-0.48-0.064-1.568-0.16-1.76-0.16-0.16 0.032-0.16 0-0.064-0.512 0.064-0.288 0.128-0.672 0.16-0.896 0.128-0.768 0.256-1.6 0.32-1.92 0.032-0.096 0.096-0.352 0.096-0.48 0.032-0.16 0.096-0.512 0.128-0.736 0.064-0.224 0.096-0.544 0.128-0.704 0-0.128 0.064-0.32 0.064-0.416 0.032-0.064 0.064-0.288 0.096-0.512 0.032-0.192 0.064-0.416 0.096-0.48 0-0.064 0.032-0.256 0.064-0.416s0.064-0.384 0.096-0.512c0.032-0.192 0.128-0.704 0.16-1.056 0.032-0.128 0.064-0.352 0.16-0.832 0.032-0.096 0.064-0.32 0.096-0.544 0.032-0.192 0.064-0.448 0.096-0.544 0.032-0.224 0.096-0.544 0.16-0.896 0.032-0.128 0.096-0.576 0.16-0.928 0.064-0.384 0.128-0.8 0.16-0.96s0.096-0.576 0.16-0.896c0.096-0.32 0.16-0.768 0.16-0.96 0.032-0.224 0.064-0.416 0.096-0.48 0.032-0.032 0.064-0.224 0.096-0.448 0-0.192 0.064-0.416 0.064-0.48 0.032-0.064 0.064-0.288 0.096-0.48 0-0.192 0.032-0.384 0.064-0.416 0.096-0.128 0.16-1.152 0.096-1.536-0.032-0.224-0.128-0.48-0.192-0.544-0.096-0.096-0.16-0.192-0.128-0.224 0.032 0-0.128-0.128-0.32-0.224-0.672-0.352-2.176-0.288-2.912 0.128-0.256 0.16-0.288 0.192-0.256 0.512 0.064 0.832 0.032 1.728-0.096 2.496-0.096 0.448-0.16 0.896-0.192 0.96 0 0.064-0.032 0.288-0.064 0.448-0.032 0.192-0.096 0.416-0.096 0.512-0.032 0.096-0.064 0.256-0.064 0.384-0.032 0.096-0.064 0.32-0.096 0.48s-0.128 0.8-0.256 1.376c-0.096 0.608-0.224 1.248-0.224 1.408-0.032 0.16-0.096 0.48-0.16 0.736-0.032 0.256-0.096 0.544-0.128 0.672 0 0.128-0.032 0.352-0.064 0.512s-0.16 0.768-0.256 1.376c-0.128 0.608-0.192 1.152-0.192 1.184 0 0.096-0.768 0.544-1.312 0.736-0.192 0.064-0.384 0.16-0.384 0.224s0 0.064-0.032 0.032-0.352 0.064-0.736 0.192c-1.632 0.544-3.008 0.608-3.488 0.128-0.192-0.192-0.192-0.256-0.192-0.928 0-0.736 0.032-0.896 0.992-4.448 0.064-0.256 0.096-0.512 0.064-0.512 0-0.032 0.032-0.096 0.064-0.096 0.032-0.032 0.096-0.16 0.128-0.288 0-0.128 0.032-0.256 0.032-0.256 0.032 0 0.064-0.128 0.128-0.48 0.096-0.48 0.096-0.512 0.128-0.544 0 0 0.032-0.032 0.032-0.064s0.064-0.224 0.128-0.448c0.064-0.192 0.128-0.448 0.128-0.544s0.032-0.224 0.064-0.288c0.48-1.344 0.48-3.2 0-4.256-0.352-0.8-1.216-1.408-2.208-1.6-0.416-0.064-1.696-0.096-1.76-0.032zM10.944 23.968c-0.032 0.192-0.128 0.416-0.16 0.544s-0.064 0.256-0.064 0.288c0 0.064 0 0.096-0.352 0.96-0.128 0.288-0.224 0.576-0.192 0.576 0.032 0.032 0 0.064-0.064 0.064s-0.224 0.32-0.192 0.448c0 0.032 0 0.032-0.032 0.032-0.064-0.032-0.16 0.064-0.224 0.224-0.192 0.288-0.608 0.704-0.832 0.768-0.064 0.032-0.128 0.064-0.128 0.096 0 0.096-0.064 0.096-0.704 0.128-0.544 0.032-0.736-0.064-0.96-0.512-0.16-0.224-0.128-0.992 0.032-1.408 0.064-0.16 0.128-0.352 0.128-0.416s0.032-0.096 0.064-0.064c0.064 0.032 0.096-0.032 0.128-0.128 0.064-0.192 0.832-0.928 0.992-0.928 0.032 0 0.032-0.032 0-0.064-0.032-0.064 0-0.096 0.032-0.096 0.096 0.064 0.704-0.256 0.8-0.384 0.032-0.032 0.064-0.032 0.064 0s0.064 0 0.16-0.032c0.16-0.096 1.28-0.416 1.472-0.416 0.064 0 0.064 0.096 0.032 0.32zM38.848 5.952c-0.16 0.032-0.384 0.064-0.512 0.096-0.288 0.064-1.44 0.48-1.504 0.576-0.032 0.064-0.064 0.064-0.064 0.032s-0.16 0.032-0.352 0.096c-0.32 0.192-0.576 0.224-0.544 0.128 0-0.128-0.128-0.352-0.256-0.352-0.064 0-0.096-0.032-0.096-0.064 0-0.16-0.608-0.352-1.312-0.384-0.48-0.064-2.048 0.384-1.92 0.512 0.032 0 0 0.096-0.032 0.128-0.064 0.096-0.064 0.224 0 0.448 0.096 0.416 0.096 1.248 0 1.632-0.064 0.16-0.096 0.416-0.128 0.64s-0.032 0.384-0.032 0.384c-0.032 0-0.064 0.16-0.128 0.576-0.032 0.16-0.064 0.384-0.096 0.48-0.032 0.128-0.064 0.32-0.064 0.48-0.032 0.16-0.064 0.384-0.096 0.512-0.064 0.224-0.448 2.496-0.512 2.816-0.032 0.256-0.096 0.576-0.192 1.184-0.064 0.256-0.128 0.608-0.128 0.768-0.032 0.128-0.064 0.384-0.096 0.48-0.288 1.6 0.032 2.368 1.056 2.592 0.48 0.128 1.728 0.032 1.888-0.096 0.032-0.032 0.128-0.064 0.224-0.064 0.064 0 0.128-0.032 0.128-0.096 0-0.032 0.032-0.064 0.064-0.064 0.352 0.064 0.448-0.224 0.32-0.8-0.128-0.544-0.096-0.896 0.096-1.856 0.064-0.416 0.16-0.864 0.16-0.992 0.032-0.128 0.064-0.352 0.096-0.448 0.096-0.544 0.128-0.64 0.16-0.896 0.032-0.128 0.064-0.352 0.064-0.48 0.032-0.16 0.064-0.384 0.096-0.512 0.224-1.152 0.288-1.568 0.256-1.632-0.032-0.032-0.032-0.096 0.032-0.128 0.032 0 0.064-0.128 0.064-0.256s0.064-0.48 0.128-0.736l0.096-0.512 0.576-0.256c0.64-0.32 0.992-0.416 1.44-0.32 0.544 0.096 0.704 0.704 0.512 1.824-0.032 0.192-0.096 0.416-0.096 0.512-0.032 0.096-0.064 0.256-0.064 0.384-0.032 0.096-0.064 0.32-0.096 0.48s-0.096 0.608-0.16 1.024c-0.064 0.384-0.16 0.832-0.16 1.024-0.032 0.16-0.064 0.32-0.096 0.384-0.032 0.032-0.064 0.224-0.096 0.48 0 0.224-0.064 0.48-0.096 0.608-0.224 1.152-0.288 2.112-0.16 2.56 0.128 0.32 0.608 0.8 0.736 0.768 0.064-0.032 0.192 0 0.32 0.064 0.256 0.16 1.376 0.096 1.984-0.096 0.576-0.16 0.8-0.384 0.736-0.672-0.032-0.128-0.096-0.32-0.096-0.448-0.032-0.128-0.064-0.256-0.064-0.288-0.032-0.064 0.032-0.512 0.128-1.024 0.064-0.512 0.16-1.056 0.192-1.216s0.096-0.448 0.128-0.704c0.096-0.448 0.16-0.896 0.192-1.152 0.032-0.096 0.096-0.544 0.16-0.96 0.096-0.448 0.16-0.896 0.192-0.992 0-0.128 0.064-0.352 0.064-0.512 0.032-0.16 0.128-0.544 0.16-0.864l0.096-0.576 0.544-0.288c0.768-0.384 1.344-0.48 1.664-0.288 0.16 0.096 0.32 0.288 0.352 0.416 0.096 0.256 0.032 1.088-0.128 1.984-0.064 0.288-0.096 0.448-0.288 1.664-0.224 1.312-0.256 1.472-0.32 1.792 0 0.16-0.032 0.352-0.064 0.416 0 0.064-0.064 0.256-0.064 0.384-0.032 0.16-0.096 0.416-0.096 0.544-0.224 1.216-0.224 1.76 0 2.24 0.128 0.224 0.288 0.352 0.576 0.512 0.384 0.192 0.512 0.192 1.216 0.192 0.608 0 0.896-0.032 1.28-0.192 0.608-0.224 0.672-0.352 0.544-0.928-0.096-0.512-0.032-1.408 0.192-2.464 0.032-0.224 0.096-0.576 0.128-0.736 0.032-0.192 0.096-0.608 0.16-0.928 0.064-0.288 0.096-0.576 0.096-0.608s0-0.064 0.032-0.096c0.032-0.096 0.064-0.288 0.096-0.672 0.032-0.224 0.096-0.448 0.096-0.512 0.032-0.064 0.064-0.256 0.096-0.416 0-0.16 0.064-0.384 0.064-0.448 0.032-0.128 0.064-0.32 0.096-0.48s0.064-0.352 0.064-0.448c0.224-1.088 0.32-2.272 0.192-2.848-0.096-0.512-0.128-0.576-0.256-0.832-0.416-0.8-1.12-1.184-2.432-1.248-0.608-0.032-2.464 0.448-2.464 0.64 0 0.064 0 0.064-0.032 0.032s-0.384 0.128-0.736 0.32l-0.704 0.352-0.16-0.224c-0.224-0.416-0.608-0.736-1.088-0.896-0.48-0.192-1.504-0.288-1.952-0.16zM21.536 6.048c0 0.032-0.224 0.064-0.48 0.064-0.544 0.064-1.184 0.224-1.184 0.352 0 0.032-0.032 0.032-0.064 0.032-0.032-0.032-0.128 0-0.224 0.096-0.128 0.16-0.128 0.192 0.032 0.832 0.064 0.224 0.032 0.864-0.064 1.376-0.064 0.288-0.128 0.608-0.128 0.768 0 0.128-0.064 0.416-0.128 0.64-0.032 0.224-0.096 0.544-0.128 0.704-0.064 0.544-0.096 0.704-0.16 0.864 0 0.064-0.064 0.32-0.064 0.544-0.032 0.224-0.064 0.416-0.096 0.448 0 0.032-0.064 0.224-0.096 0.48-0.032 0.224-0.064 0.48-0.064 0.544-0.032 0.064-0.064 0.256-0.096 0.416-0.096 0.544-0.128 0.8-0.16 1.024-0.16 0.896-0.096 2.208 0.096 2.624 0.064 0.096 0.128 0.256 0.192 0.384 0.16 0.352 0.704 0.896 1.056 1.024 0.928 0.384 1.664 0.416 2.784 0.128 0.224-0.064 0.416-0.128 0.448-0.128 0.064 0 0.16-0.064 0.256-0.096 0.704-0.288 1.472-0.544 1.504-0.512 0 0 0.064 0.128 0.128 0.256 0.288 0.608 0.896 0.864 1.888 0.864 0.64-0.032 1.536-0.256 1.632-0.416 0.032-0.032 0.096-0.064 0.128-0.096 0.032 0 0.064-0.16 0.064-0.384-0.096-1.248-0.096-1.472-0.032-1.76 0.032-0.16 0.096-0.416 0.128-0.576 0.064-0.576 0.128-0.96 0.16-1.12 0.032-0.096 0.064-0.288 0.096-0.448s0.064-0.384 0.096-0.48c0-0.096 0.032-0.288 0.064-0.448s0.096-0.576 0.16-0.896c0.064-0.288 0.128-0.576 0.096-0.608s0-0.096 0.032-0.16c0.032-0.096 0.096-0.32 0.128-0.512 0.032-0.224 0.064-0.48 0.096-0.608 0.032-0.192 0.32-1.792 0.416-2.272 0-0.16 0.064-0.352 0.064-0.48 0.128-0.448 0.064-1.312-0.096-1.632-0.128-0.288-0.736-0.768-0.832-0.672-0.032 0.032-0.096 0-0.16-0.032-0.096-0.096-1.088-0.128-1.44-0.032-0.448 0.096-1.056 0.32-1.184 0.416-0.096 0.096-0.096 0.192-0.032 0.544 0.096 0.448 0.096 1.312 0 1.824-0.032 0.16-0.128 0.576-0.192 0.928-0.064 0.32-0.096 0.64-0.096 0.64 0 0.032 0 0.096 0 0.128-0.032 0.064-0.096 0.352-0.128 0.576-0.032 0.192-0.128 0.704-0.192 1.024-0.032 0.096-0.064 0.32-0.064 0.48-0.032 0.16-0.064 0.32-0.064 0.384-0.032 0.032-0.064 0.256-0.096 0.48-0.064 0.224-0.096 0.448-0.096 0.48 0 0-0.064 0.32-0.128 0.704-0.096 0.576-0.128 0.64-0.352 0.736-0.128 0.064-0.224 0.128-0.192 0.128 0.032 0.032-0.032 0.064-0.096 0.064-0.096 0-0.32 0.064-0.512 0.16-0.864 0.32-1.856 0.064-1.92-0.512 0-0.096-0.032-0.224-0.032-0.288 0-0.16 0.16-1.472 0.192-1.472 0 0 0.032-0.064 0.032-0.16s0.032-0.288 0.064-0.416c0.032-0.128 0.096-0.384 0.096-0.512 0.128-0.704 0.192-1.152 0.256-1.44 0.032-0.128 0.064-0.384 0.096-0.544 0.032-0.192 0.128-0.8 0.256-1.344 0.288-1.632 0.16-2.432-0.416-2.784-0.16-0.064-0.288-0.16-0.352-0.16-0.512-0.096-0.864-0.16-0.896-0.16z',
			'width'  => 49,
			'height' => 32,
		],
		'buffer'     => [
			'path'   => 'M0 24.384q0.352-0.48 1.024-0.832t1.568-0.64 1.28-0.48q0.608 0 1.088 0.128t1.056 0.48 0.8 0.416q1.504 0.672 8.32 3.808 0.608 0.128 1.152 0t1.248-0.576 0.768-0.448q0.64-0.288 2.464-1.12t2.784-1.248q0.128-0.064 1.344-0.672t1.92-0.768q0.416-0.064 0.896 0.032t0.736 0.224 0.736 0.416 0.576 0.352 0.512 0.192 0.576 0.256 0.352 0.352q0.096 0.128 0.128 0.448-0.32 0.416-0.992 0.768t-1.632 0.704-1.28 0.512q-1.376 0.64-4.096 1.984t-4.128 1.952q-0.224 0.096-0.672 0.384t-0.736 0.416-0.832 0.352-0.864 0.224-0.96-0.064l-8.448-3.936q-0.192-0.096-1.024-0.448t-1.632-0.704-1.728-0.768-1.472-0.768-0.704-0.512q-0.128-0.128-0.128-0.416zM0 15.808q0.352-0.48 1.024-0.8t1.6-0.64 1.312-0.48q0.608 0 1.088 0.128t1.12 0.48 0.8 0.448q1.344 0.608 4.064 1.856t4.064 1.888q0.608 0.16 1.184 0t1.248-0.544 0.8-0.448q2.176-1.024 5.12-2.304 0.352-0.16 1.024-0.544t1.216-0.608 1.152-0.352q0.512-0.096 1.024 0.032t1.184 0.544 0.736 0.416q0.16 0.096 0.512 0.192t0.576 0.256 0.352 0.352q0.096 0.16 0.128 0.448-0.32 0.448-0.992 0.8t-1.696 0.736-1.312 0.512q-1.536 0.736-4.32 2.080t-3.936 1.888q-0.224 0.096-0.832 0.448t-0.928 0.48-1.024 0.32-1.152 0q-6.848-3.232-8.32-3.904-0.192-0.096-1.408-0.608t-2.208-0.96-1.984-0.96-1.088-0.704q-0.128-0.128-0.128-0.448zM0 7.264q0.32-0.48 1.024-0.864t1.664-0.704 1.312-0.512l11.136-5.184q0.96 0 1.728 0.224t1.792 0.832 1.28 0.704q1.248 0.576 3.744 1.728t3.744 1.76q0.128 0.064 1.184 0.48t1.728 0.768 0.864 0.64q0.096 0.128 0.128 0.416-0.288 0.416-0.832 0.704t-1.376 0.608-1.12 0.448q-1.504 0.704-4.48 2.112t-4.448 2.144q-0.192 0.096-0.64 0.352t-0.736 0.384-0.8 0.352-0.864 0.192-0.896-0.032q-7.84-3.648-8.192-3.808-0.128-0.064-2.016-0.896t-3.264-1.472-1.536-0.96q-0.128-0.128-0.128-0.416z',
			'width'  => 31,
			'height' => 32,
		],
		'tumblr'     => [
			'path'   => 'M16.864 23.744l1.408 4.224q-0.384 0.608-1.952 1.184t-3.168 0.576q-1.856 0.032-3.424-0.48t-2.528-1.312-1.696-1.888-0.992-2.144-0.288-2.112v-9.728h-3.008v-3.84q1.28-0.448 2.304-1.248t1.632-1.6 1.024-1.824 0.608-1.76 0.256-1.568q0.032-0.096 0.096-0.16t0.128-0.064h4.352v7.584h5.952v4.48h-5.952v9.248q0 0.544 0.096 0.992t0.416 0.96 0.896 0.736 1.44 0.256q1.408-0.032 2.4-0.512z',
			'width'  => 18,
			'height' => 32,
		],
		'xing'       => [
			'path'   => 'M0 22.336h7.008l5.536-9.152-4.16-7.328h-7.008l4.16 7.328zM11.584 19.456l11.072-19.456h7.424l-11.040 19.456 7.104 12.544h-7.424z',
			'width'  => 30,
			'height' => 32,
		],
		'flipboard'  => [
			'path'   => 'M0 0h10.272v32h-10.272v-32zM11.328 11.328h10.4v10.4h-10.4v-10.4zM11.328 0h20.672v10.272h-20.672v-10.272z',
			'width'  => 32,
			'height' => 32,
		],
		'telegram'   => [
			'path'   => 'M12.192 27.296c-0.896 0-0.736-0.352-1.056-1.216l-2.688-8.832 20.672-12.288M12.192 27.296c0.704 0 1.024-0.32 1.408-0.704l3.776-3.648-4.704-2.848M12.672 20.096l11.36 8.416c1.312 0.704 2.24 0.352 2.56-1.216l4.64-21.792c0.48-1.888-0.736-2.752-1.952-2.208l-27.168 10.496c-1.856 0.736-1.856 1.76-0.352 2.24l6.976 2.176 16.128-10.176c0.768-0.48 1.472-0.224 0.896 0.288',
			'width'  => 32,
			'height' => 32,
		],
		'mix'        => [
			'path'   => 'M0 4v21.792c0 3.52 5.504 3.648 5.504 0v-14.912c0.48-3.296 5.504-3.136 5.504 0.416v10.944c0 3.648 5.984 3.648 5.984 0v-7.232c0.352-3.424 5.504-3.296 5.504 0.256v1.504c0 3.744 5.504 3.52 5.504 0v-12.768h-28z',
			'width'  => 28,
			'height' => 32,
		],
		'instagram'  => [
			'path'   => 'M18.272 16q0-1.888-1.312-3.232t-3.232-1.344-3.232 1.344-1.344 3.232 1.344 3.232 3.232 1.344 3.232-1.344 1.312-3.232zM20.736 16q0 2.912-2.048 4.992t-4.96 2.048-4.992-2.048-2.048-4.992 2.048-4.992 4.992-2.048 4.96 2.048 2.048 4.992zM22.688 8.672q0 0.672-0.48 1.152t-1.184 0.48-1.152-0.48-0.48-1.152 0.48-1.152 1.152-0.48 1.184 0.48 0.48 1.152zM13.728 4.736q-0.128 0-1.376 0t-1.888 0-1.728 0.064-1.824 0.16-1.28 0.352q-0.896 0.352-1.568 1.024t-1.056 1.568q-0.192 0.512-0.32 1.28t-0.192 1.856-0.032 1.696 0 1.888 0 1.376 0 1.376 0 1.888 0.032 1.696 0.192 1.856 0.32 1.28q0.384 0.896 1.056 1.568t1.568 1.024q0.512 0.192 1.28 0.352t1.824 0.16 1.728 0.064 1.888 0 1.376 0 1.344 0 1.888 0 1.728-0.064 1.856-0.16 1.248-0.352q0.896-0.352 1.6-1.024t1.024-1.568q0.192-0.512 0.32-1.28t0.192-1.856 0.032-1.696 0-1.888 0-1.376 0-1.376 0-1.888-0.032-1.696-0.192-1.856-0.32-1.28q-0.352-0.896-1.024-1.568t-1.6-1.024q-0.512-0.192-1.248-0.352t-1.856-0.16-1.728-0.064-1.888 0-1.344 0zM27.424 16q0 4.096-0.096 5.664-0.16 3.712-2.208 5.76t-5.728 2.208q-1.6 0.096-5.664 0.096t-5.664-0.096q-3.712-0.192-5.76-2.208t-2.208-5.76q-0.096-1.568-0.096-5.664t0.096-5.664q0.16-3.712 2.208-5.76t5.76-2.208q1.568-0.096 5.664-0.096t5.664 0.096q3.712 0.192 5.728 2.208t2.208 5.76q0.096 1.568 0.096 5.664z',
			'width'  => 27,
			'height' => 32,
		],
		'youtube'    => [
			'path'   => 'M12.704 20.128l8.64-4.448-8.64-4.512v8.96zM16 4.736q3.008 0 5.792 0.096t4.096 0.16l1.312 0.064q0 0 0.288 0.032t0.416 0.064 0.416 0.064 0.512 0.16 0.512 0.224 0.544 0.352 0.512 0.48q0.128 0.096 0.288 0.32t0.512 1.056 0.48 1.792q0.128 1.152 0.224 2.432t0.096 2.048v3.136q0.032 2.592-0.32 5.184-0.128 0.96-0.448 1.76t-0.576 1.12l-0.256 0.288q-0.224 0.256-0.512 0.48t-0.544 0.32-0.512 0.224-0.512 0.16-0.416 0.064-0.416 0.064-0.288 0.032q-4.48 0.352-11.2 0.352-3.68-0.064-6.432-0.128t-3.552-0.128l-0.896-0.096-0.64-0.064q-0.64-0.096-0.96-0.16t-0.928-0.384-0.992-0.736q-0.128-0.096-0.288-0.32t-0.512-1.056-0.48-1.792q-0.128-1.152-0.224-2.432t-0.096-2.048v-3.136q-0.032-2.592 0.32-5.184 0.128-0.992 0.448-1.76t0.576-1.12l0.256-0.288q0.256-0.288 0.512-0.48t0.544-0.352 0.512-0.224 0.512-0.16 0.416-0.064 0.416-0.064 0.288-0.032q4.48-0.32 11.2-0.32z',
			'width'  => 32,
			'height' => 32,
		],
		'vimeo'      => [
			'path'   => 'M28.672 9.344q-1.024 5.952-5.472 11.232t-7.84 7.584q-1.344 0.896-2.592 0.544t-2.112-1.216-1.376-1.952q-0.512-1.024-2.496-7.648t-2.368-7.136q-0.512-0.384-1.216-0.16t-1.408 0.672l-0.64 0.448-1.152-1.6q0.576-0.64 1.472-1.664t3.2-2.848 3.968-2.144q0.96-0.192 1.696 0.224t1.152 1.12 0.736 1.92 0.48 2.24 0.384 2.4 0.416 2.144q0.448 1.728 0.672 2.56t0.544 1.728 0.576 1.248 0.576 0.352q1.28 0 4.032-5.312 1.344-2.432 0.192-3.968t-3.584-0.064q0.704-4.032 4.48-6.016 3.328-1.728 5.824-0.256 2.56 1.472 1.856 5.568z',
			'width'  => 29,
			'height' => 32,
		],
		'soundcloud' => [
			'path'   => 'M0 20.128q0-0.512 0.128-1.408t0.288-0.992q0.192 0.096 0.352 1.024t0.128 1.376q0 0.448-0.128 1.344t-0.352 1.024q-0.416-0.224-0.416-2.368zM2.048 20.128q0-0.8 0.16-2.368t0.192-1.952q0-0.192 0.192-0.192 0.128 0 0.192 0.192 0.384 4.128 0.384 4.32 0 0.768-0.16 2.272t-0.224 1.888q-0.064 0.224-0.192 0.224-0.192 0-0.192-0.224-0.032-0.352-0.192-1.888t-0.16-2.272zM4.64 20.128q0-0.768 0.16-2.368t0.16-1.728q0-0.288 0.224-0.288 0.256 0 0.256 0.288 0.352 3.616 0.352 4.096t-0.352 4.352q0 0.256-0.256 0.256-0.224 0-0.224-0.256 0-0.224-0.16-1.888t-0.16-2.464zM7.584 20.128q0-1.216 0.064-2.592t0.128-3.040 0.096-2.592q0-0.32 0.288-0.32 0.32 0 0.32 0.32 0.032 0.512 0.192 3.552t0.128 4.672q0 0.832-0.16 2.464t-0.16 1.856q0 0.32-0.32 0.32-0.288 0-0.288-0.32-0.288-4.224-0.288-4.32zM10.592 20.128q0-1.76 0.096-5.12t0.128-4.096q0.064-0.384 0.384-0.384t0.384 0.384q0.032 1.024 0.16 4.256t0.096 4.96q0 0.8-0.096 2.304t-0.16 1.952q-0.064 0.384-0.384 0.384t-0.384-0.384q0-0.352-0.096-1.888t-0.128-2.368zM13.632 20.128q0-1.28 0.032-2.72t0.096-3.2 0.064-2.72q0.064-0.48 0.448-0.48t0.448 0.48q0.032 0.96 0.096 2.72t0.064 3.2 0.032 2.72q0 0.064-0.192 4.192v-0.032q-0.064 0.48-0.448 0.48t-0.448-0.448q-0.192-4.128-0.192-4.192zM16.672 20.16q0-0.096 0.192-11.232 0.064-0.576 0.512-0.576t0.512 0.576q0.192 11.136 0.192 11.232 0 0.032-0.192 4.064-0.064 0.544-0.512 0.544t-0.512-0.544q-0.192-4.032-0.192-4.064zM19.232 13.344q0-2.624 0.032-4.96-0.032-0.32 0.416-0.576t1.024-0.384 1.12-0.16 0.768-0.064q3.104 0 5.408 2.304t2.56 5.728q0.896-0.416 1.76-0.416 1.856 0 3.2 1.44t1.344 3.552-1.344 3.52-3.2 1.472h-12.576q-0.192 0-0.32-0.192t-0.16-0.416q0-1.76 0-4.992t-0.032-5.856z',
			'width'  => 37,
			'height' => 32,
		],
		'twitch'     => [
			'path'   => 'M16 7.744v7.744h-2.592v-7.744h2.592zM23.104 7.744v7.744h-2.592v-7.744h2.592zM23.104 21.312l4.512-4.512v-14.208h-21.312v18.72h5.824v3.872l3.872-3.872h7.104zM30.208 0v18.080l-7.744 7.744h-5.824l-3.872 3.904h-3.872v-3.904h-7.104v-20.672l1.952-5.152h26.464z',
			'width'  => 32,
			'height' => 32,
		],
		'behance'    => [
			'path'   => 'M32.992 6.048h-9.12v2.208h9.12v-2.208zM28.512 13.664q-1.632 0-2.624 0.928t-1.088 2.56h7.264q-0.32-3.488-3.552-3.488zM28.8 24.096q1.12 0 2.176-0.576t1.344-1.536h3.936q-1.76 5.472-7.616 5.472-3.808 0-6.080-2.336t-2.24-6.208q0-3.712 2.304-6.176t6.016-2.464q2.464 0 4.288 1.216t2.752 3.2 0.896 4.448q0 0.288-0.032 0.832h-11.744q0 1.984 1.024 3.072t2.976 1.056zM4.96 23.2h5.28q3.648 0 3.648-2.976 0-3.2-3.552-3.2h-5.376v6.176zM4.96 13.632h4.992q1.408 0 2.208-0.672t0.832-2.016q0-2.56-3.392-2.56h-4.64v5.248zM0 4.544h10.624q1.536 0 2.752 0.256t2.272 0.832 1.6 1.728 0.544 2.752q0 3.232-3.072 4.704 2.048 0.544 3.072 2.048t1.056 3.648q0 1.312-0.448 2.432t-1.184 1.856-1.76 1.248-2.144 0.768-2.4 0.224h-10.912v-22.496z',
			'width'  => 37,
			'height' => 32,
		],
		'github'     => [
			'path'   => 'M0 15.968q0-3.264 1.28-6.208 2.528-5.952 8.48-8.48 2.944-1.28 6.208-1.28t6.208 1.28q5.888 2.496 8.48 8.48 1.28 3.040 1.28 6.208t-1.28 6.208q-2.592 6.016-8.48 8.544-2.944 1.28-6.208 1.28t-6.208-1.28q-5.952-2.56-8.48-8.544-1.28-2.944-1.28-6.208zM2.496 15.968q0 4.512 2.688 8.064 2.656 3.488 6.944 4.96v-2.56q0-1.92 1.28-2.784-0.64-0.032-1.504-0.224-1.632-0.288-2.784-1.024-2.912-1.76-2.912-6.368 0-2.4 1.6-4.096-0.736-1.888 0.16-4.096h0.64q0.32 0 0.8 0.16 1.248 0.384 2.784 1.408 1.952-0.512 3.84-0.512t3.872 0.512q1.248-0.832 2.336-1.28 1.024-0.384 1.472-0.32l0.384 0.032q0.864 2.208 0.16 4.096 1.6 1.696 1.6 4.096 0 3.584-1.76 5.408-0.96 1.024-2.528 1.6-1.312 0.48-2.912 0.608 1.312 0.928 1.312 2.784v2.56q4.128-1.472 6.816-5.024 2.624-3.52 2.624-8 0-2.72-1.056-5.248-1.024-2.432-2.88-4.288-1.792-1.792-4.288-2.848-2.56-1.088-5.216-1.088-2.624 0-5.248 1.088-2.4 1.024-4.288 2.848-1.792 1.856-2.88 4.288-1.056 2.528-1.056 5.248z',
			'width'  => 32,
			'height' => 32,
		],
		'medium'     => [
			'path'   => 'M4.48 8.896c0.032-0.384-0.128-0.736-0.384-0.992l-2.816-3.392v-0.512h8.768l6.752 14.848 5.952-14.848h8.384v0.512l-2.432 2.304c-0.192 0.16-0.32 0.416-0.256 0.672v16.992c-0.064 0.256 0.064 0.544 0.256 0.672l2.368 2.336v0.512h-11.872v-0.512l2.464-2.368c0.224-0.256 0.224-0.32 0.224-0.672v-13.76l-6.784 17.248h-0.928l-7.904-17.248v11.552c-0.064 0.512 0.096 0.992 0.448 1.344l3.168 3.84v0.512h-8.992v-0.512l3.168-3.84c0.352-0.352 0.48-0.864 0.416-1.344v-13.344z',
			'width'  => 32,
			'height' => 32,
		],
	];
}

/**
 * Get networks with share counts
 *
 * @deprecated Use Networks::get_countable instead
 * @return string[]
 */
function dpsp_get_pro_networks_with_social_count() {
	$networks = \Mediavine\Grow\Networks::get_instance();
	return $networks->make_slug_array( $networks->get_countable() );
}

/**
 *
 *
 * @param string $network_slug
 * @param string $page_url Already Url encoded page url
 * @param array $settings
 * @return string
 * @deprecated
 */
function dpsp_get_pro_url_network_share_count( $network_slug, $page_url, $settings ) {
	$url = '';
	switch ( $network_slug ) {
		case 'twitter':
			$provider = ( ! empty( $settings['twitter_share_counts_provider'] ) ? $settings['twitter_share_counts_provider'] : 'twitcount' );

			if ( 'opensharecount' === $provider ) {
				$url = 'http://opensharecount.com/count.json?url=' . $page_url;
			}

			if ( 'twitcount' === $provider ) {
				$url = 'https://counts.twitcount.com/counts.php?url=' . $page_url;
			}

			break;

		case 'linkedin':
			$url = 'https://www.linkedin.com/countserv/count/share?format=json&url=' . $page_url;
			break;

		case 'reddit':
			$url = 'https://www.reddit.com/api/info.json?url=' . $page_url;
			break;

		case 'vkontakte':
			$url = 'http://vk.com/share.php?act=count&index=1&url=' . $page_url;
			break;

		case 'buffer':
			$url = 'https://api.bufferapp.com/1/links/shares.json?url=' . $page_url;
			break;

		case 'tumblr':
			$url = 'http://api.tumblr.com/v2/share/stats?url=' . $page_url;
			break;

		default:
			$url = '';
			break;
	}
	return $url;
}

/**
 *
 *
 * @param $network_slug
 * @param $body
 * @param $response
 * @return bool|int|mixed
 */
function dpsp_get_pro_url_network_share_count_response( $network_slug, $body, $response ) {
	// @TODO: This functionality should be migrated to the Network class
	switch ( $network_slug ) {
		case 'reddit':
			$share_count = 0;

			if ( isset( $body['data']['children'] ) ) {
				if ( ! empty( $body['data']['children'] ) ) {
					foreach ( $body['data']['children'] as $child ) {
						if ( isset( $child['data']['score'] ) ) {
							$share_count += (int) $child['data']['score'];
						}
					}
				}
			} else {
				$share_count = false;
			}
			break;

		case 'vkontakte':
			$body   = wp_remote_retrieve_body( $response );
			$start  = strpos( $body, '(' );
			$end    = strpos( $body, ')', $start + 1 );
			$length = $end - $start;
			$shares = array_map( 'trim', explode( ',', substr( $body, $start + 1, $length - 1 ) ) );

			$share_count = ( isset( $shares[1] ) ? $shares[1] : false );
			break;

		case 'tumblr':
			$share_count = ( isset( $body['response']['note_count'] ) ? $body['response']['note_count'] : false );
			break;

		case 'buffer':
			$share_count = isset( $body['shares'] ) ? $body['shares'] : false;
			break;
		default:
			$share_count = ( isset( $body['count'] ) ? $body['count'] : false );
	}

	return $share_count;
}
