<?php
/**
 * Events manager helper.
 *
 * PHP version 5
 *
 * @category Handler
 * @package  SMSAlert
 * @author   SMS Alert <support@cozyvision.com>
 * @license  URI: http://www.gnu.org/licenses/gpl-2.0.html
 * @link     https://www.smsalert.co.in/
 */
if (! defined('ABSPATH') ) {
    exit;
}
if (! is_plugin_active('events-manager/events-manager.php') ) {
    return;
}
/**
 * PHP version 5
 *
 * @category Handler
 * @package  SMSAlert
 * @author   SMS Alert <support@cozyvision.com>
 * @license  URI: http://www.gnu.org/licenses/gpl-2.0.html
 * @link     https://www.smsalert.co.in/
 * SmsAlertEMBooking class
 */
class SmsAlertEMBooking
{
    /**
     * Construct function.
     */
    public function __construct()
    {
        include_once WP_PLUGIN_DIR . '/events-manager/classes/em-booking.php';
        add_filter('sAlertDefaultSettings', __CLASS__ . '::add_default_setting', 1);
        add_action('em_bookings_added', array( $this, 'sendSmsWpbcBookingCreated' )); // Booking Hook.
        add_filter('em_booking_set_status', array( $this, 'sendSmsWpbcBookingModify' ), 1, 2); // Changing Status Hook.
        add_action('sa_addTabs', array( $this, 'addTabs' ), 10);
    }

    /**
     * Add tabs to smsalert settings at backend.
     *
     * @param array $tabs tabs.
     *
     * @return array
     */
    public static function addTabs( $tabs = array() )
    {
        $customer_param = array(
        'checkTemplateFor' => 'em_customer',
        'templates'        => self::getCustomerTemplates(),
        );

        $admin_param = array(
        'checkTemplateFor' => 'em_admin',
        'templates'        => self::getAdminTemplates(),
        );

        $tabs['event_manager']['nav']  = 'Event Manager';
        $tabs['event_manager']['icon'] = 'dashicons-admin-users';

        $tabs['event_manager']['inner_nav']['em_customer']['title']        = 'Customer Notifications';
        $tabs['event_manager']['inner_nav']['em_customer']['tab_section']  = 'embkcsttemplates';
        $tabs['event_manager']['inner_nav']['em_customer']['first_active'] = true;
        $tabs['event_manager']['inner_nav']['em_customer']['tabContent']   = $customer_param;
        $tabs['event_manager']['inner_nav']['em_customer']['filePath']     = 'views/message-template.php';

        $tabs['event_manager']['inner_nav']['em_admin']['title']       = 'Admin Notifications';
        $tabs['event_manager']['inner_nav']['em_admin']['tab_section'] = 'embkadmintemplates';
        $tabs['event_manager']['inner_nav']['em_admin']['tabContent']  = $admin_param;
        $tabs['event_manager']['inner_nav']['em_admin']['filePath']    = 'views/message-template.php';
        return $tabs;
    }

    /**
     * Add default settings to savesetting in setting-options.
     *
     * @param array $defaults defaults.
     *
     * @return array
     */
    public static function add_default_setting( $defaults = array() )
    {
        $embk_booking_statuses = self::em_booking_statuses();

        foreach ( $embk_booking_statuses as $ks => $vs ) {
            $defaults['smsalert_embk_general'][ 'embk_admin_notification_' . $vs ] = 'off';
            $defaults['smsalert_embk_general'][ 'embk_order_status_' . $vs ]       = 'off';
            $defaults['smsalert_embk_message'][ 'embk_admin_sms_body_' . $vs ]     = '';
            $defaults['smsalert_embk_message'][ 'embk_sms_body_' . $vs ]           = '';
        }
        return $defaults;
    }

    /**
     * Get customer templates.
     *
     * @return array
     */
    public static function getCustomerTemplates()
    {
        $embk_booking_statuses = self::em_booking_statuses();

        $templates = array();
        foreach ( $embk_booking_statuses as $ks  => $vs ) {

            $ks          = $vs;
            $ks          = str_replace(' ', '_', $ks);
            $current_val = smsalert_get_option('embk_order_status_' . $vs, 'smsalert_embk_general', 'on');

            $checkbox_name_id = 'smsalert_embk_general[embk_order_status_' . $vs . ']';
            $textarea_name_id = 'smsalert_embk_message[embk_sms_body_' . $vs . ']';

            $text_body = smsalert_get_option(
                'embk_sms_body_' . $vs,
                'smsalert_embk_message',
                sprintf(__('Hello %1$s, status of your booking %2$s%3$s with %4$s has been changed to %5$s.%6$sPowered by%7$swww.smsalert.co.in', 'sms-alert'), '[#_BOOKINGNAME]', '[#_BOOKINGID]', '[#_EVENTNAME]', '[store_name]', '[#_BOOKINGSTATUS]', PHP_EOL, PHP_EOL)
            );

            $templates[ $ks ]['title']          = 'When Order is ' . ucwords($vs);
            $templates[ $ks ]['enabled']        = $current_val;
            $templates[ $ks ]['status']         = $ks;
            $templates[ $ks ]['text-body']      = $text_body;
            $templates[ $ks ]['checkboxNameId'] = $checkbox_name_id;
            $templates[ $ks ]['textareaNameId'] = $textarea_name_id;
            $templates[ $ks ]['token']          = self::getEmBookingVariables(true);
        }
        return $templates;
    }

    /**
     * Get admin templates.
     *
     * @return array
     */
    public static function getAdminTemplates()
    {
        $embk_booking_statuses = self::em_booking_statuses();

        $templates = array();
        foreach ( $embk_booking_statuses as $ks  => $vs ) {

            $current_val = smsalert_get_option('embk_admin_notification_' . $vs, 'smsalert_embk_general', 'on');

            $checkbox_name_id = 'smsalert_embk_general[embk_admin_notification_' . $vs . ']';
            $textarea_name_id = 'smsalert_embk_message[embk_admin_sms_body_' . $vs . ']';

            $text_body = smsalert_get_option(
                'embk_admin_sms_body_' . $vs,
                'smsalert_embk_message',
                sprintf(__('%1$s: status of booking %2$s has been changed to %3$s.%4$sPowered by%5$swww.smsalert.co.in', 'sms-alert'), '[store_name]', '[#_BOOKINGID]', '[#_BOOKINGSTATUS]', PHP_EOL, PHP_EOL)
            );

            $templates[ $ks ]['title']          = 'When Order is ' . ucwords($vs);
            $templates[ $ks ]['enabled']        = $current_val;
            $templates[ $ks ]['status']         = $ks;
            $templates[ $ks ]['text-body']      = $text_body;
            $templates[ $ks ]['checkboxNameId'] = $checkbox_name_id;
            $templates[ $ks ]['textareaNameId'] = $textarea_name_id;
            $templates[ $ks ]['token']          = self::getEmBookingVariables(true);
        }
        return $templates;
    }

    /**
     * Get Booking Status.
     *
     * @return array
     */
    public static function em_booking_statuses()
    {
        if (class_exists('EM_Booking') ) {
            $booking = new EM_Booking();
            $status  = $booking->status_array;
            return $status;
        }
    }

    /**
     * Get booking variables.
     *
     * @param boolean $onlyvariable onlyvariable.
     *
     * @return array
     */
    public static function getEmBookingVariables( $onlyvariable = false )
    {
        $variables = array(
        '[#_BOOKINGID]'                    => 'Booking Id',
        '[#_BOOKINGNAME]'                  => 'Booking Person Name',
        '[#_BOOKINGEMAIL]'                 => 'Booking Person EMail',
        '[#_BOOKINGPHONE]'                 => 'Booking Person Phone',
        '[#_BOOKINGSPACES]'                => 'Booking Spaces',
        '[#_BOOKINGDATE]'                  => 'Booking Date',
        '[#_BOOKINGTIME]'                  => 'Booking Time',
        '[#_BOOKINGDATETIME]'              => 'Booking DateTime',
        '[#_BOOKINGLISTURL]'               => 'Booking List URL',
        '[#_BOOKINGCOMMENT]'               => 'Booking Comment',
        '[#_BOOKINGPRICEWITHOUTTAX]'       => 'Booking Price Without Tax',
        '[#_BOOKINGPRICETAX]'              => 'Booking Price Tax',
        '[#_BOOKINGPRICE]'                 => 'Booking Price',
        '[#_BOOKINGTICKETNAME]'            => 'Booking Ticket Name',
        '[#_BOOKINGTICKETDESCRIPTION]'     => 'Booking Ticket Description',
        '[#_BOOKINGTICKETPRICEWITHTAX]'    => 'Booking Ticket With Tax',
        '[#_BOOKINGTICKETPRICEWITHOUTTAX]' => 'Booking Ticket Without Tax',
        '[#_BOOKINGTICKETTAX]'             => 'Booking Ticket Tax',
        '[#_BOOKINGTICKETPRICE]'           => 'Booking Ticket Price',
        '[#_BOOKINGSTATUS]'                => 'Booking Status',
        '[#_EVENTNAME]'                    => 'Event Name',
        '[#_EVENTDATES]'                   => 'Event Date',
        '[#_EVENTTIMES]'                   => 'Event Time',
        );

        if ($onlyvariable ) {
            return $variables;
        } else {
            $ret_string = '';
            foreach ( $variables as $vk => $vv ) {
                $ret_string .= sprintf("<a href='#' val='%s'>%s</a> | ", $vk, $vv);
            }
            return $ret_string;
        }
    }

    /**
     * Send sms to customer and admin on Booking from customer side.
     *
     * @param object $booking booking.
     *
     * @return void
     */
    public static function sendSmsWpbcBookingCreated( $booking )
    {
        if (function_exists('em_get_booking') ) {
            $booking_id         = $booking->booking_id;
            $buyer_sms_data     = array();
            $booking            = em_get_booking($booking_id);
            $booking_status     = $booking->status_array;
            $current_booking    = $booking->booking_status;
            $buyer_phone_number = $booking->get_person()->phone;
            $admin_phone_number = smsalert_get_option('sms_admin_phone', 'smsalert_message', '');

            $is_enabled = smsalert_get_option('embk_order_status_' . $booking_status[ $current_booking ], 'smsalert_embk_general');
            if ('' !== $buyer_phone_number && 'on' === $is_enabled ) {
                $buyer_message = smsalert_get_option('embk_sms_body_' . $booking_status[ $current_booking ], 'smsalert_embk_message', '');

                $buyer_message = str_replace('[#_BOOKINGSTATUS]', $booking_status[ $current_booking ], $buyer_message);
                do_action('sa_send_sms', $buyer_phone_number, self::parseSmsBody($buyer_message, $booking));
            }
            if (smsalert_get_option('embk_admin_notification_' . $booking_status[ $current_booking ], 'smsalert_embk_general') === 'on' && '' !== $admin_phone_number ) {
                $admin_message = smsalert_get_option('embk_admin_sms_body_' . $booking_status[ $current_booking ], 'smsalert_embk_message', '');
                $admin_message = str_replace('[#_BOOKINGSTATUS]', $booking_status[ $current_booking ], $admin_message);
                do_action('sa_send_sms', $admin_phone_number, self::parseSmsBody($admin_message, $booking));
            }
        } else {
            echo 'wpdev_booking not found';
        }
        exit();
    }

    /**
     * Send sms to admin on Change Status from admin side.
     *
     * @param string $result  result.
     * @param object $booking booking.
     *
     * @return void
     */
    public function sendSmsWpbcBookingModify( $result, $booking )
    {
        if (! empty($result) && $booking->previous_status !== $booking->booking_status ) {
            $booking_id         = $booking->booking_id;
            $admin_sms_data     = array();
            $booking            = em_get_booking($booking_id);
            $booking_status     = $booking->status_array;
            $current_booking    = $booking->booking_status;
            $admin_phone_number = smsalert_get_option('sms_admin_phone', 'smsalert_message', '');

            if (smsalert_get_option('embk_admin_notification_' . $booking_status[ $current_booking ], 'smsalert_embk_general') === 'on' && '' !== $admin_phone_number ) {
                $admin_message = smsalert_get_option('embk_admin_sms_body_' . $booking_status[ $current_booking ], 'smsalert_embk_message', '');
                $admin_message = str_replace('[#_BOOKINGSTATUS]', $booking_status[ $current_booking ], $admin_message);
                do_action('sa_send_sms', $admin_phone_number, self::parseSmsBody($admin_message, $booking));
            }
        } else {
            echo 'wpdev_booking not found';
        }
        exit();
    }

    /**
     * Remove brackets and replace value of variables.
     *
     * @param string $sms_content sms_content.
     * @param object $booking     booking.
     *
     * @return string
     */
    public static function parseSmsBody( $sms_content = null, $booking = null )
    {
        $order_variables = self::getEmBookingVariables(true);
        foreach ( $order_variables as $key => $value ) {
            $array_trim_keys[] = trim($key, '[]');
        }
        $sms_content = str_replace(array_keys($order_variables), array_values($array_trim_keys), $sms_content);
        return $booking->output($sms_content);
    }
}
new SmsAlertEMBooking();
