<?php
/**
 * Handles Black Friday campaign for free version.
 *
 * @package SmartCrawl
 */

namespace SmartCrawl\Controllers;

use SmartCrawl\Services\Service;
use SmartCrawl\Singleton;

/**
 * Black_Friday Controller.
 */
class Black_Friday extends Controller {

	use Singleton;

	/**
	 * Initializes the application.
	 *
	 * @return void
	 */
	protected function init() {
		// Only run for free (wp.org) version, not Pro.
		if ( Service::get( Service::SERVICE_SITE )->is_member() ) {
			return;
		}

		$black_friday_path = SMARTCRAWL_PLUGIN_DIR . 'external/wpmudev-black-friday/campaign.php';
		if ( ! file_exists( $black_friday_path ) ) {
			return;
		}

		static $black_friday = null;
		if ( is_null( $black_friday ) ) {
			if ( ! class_exists( '\WPMUDEV\Modules\BlackFriday\Campaign' ) ) {
				require_once $black_friday_path;
				$black_friday = new \WPMUDEV\Modules\BlackFriday\Campaign();
			}
		}
	}
}

