<div id="introduction" class="content-introduction active tab_item">
    <section class="section_full background_free full_width">
        <div class="col_description">
            <h2><?php esc_html_e('Quick Overview', 'smart-phone-field-for-gravity-forms'); ?></h2>
            <p><?php esc_html_e('Elevate your Phone field experience with automatic country code selection, real number validation, and stylish visuals. It is easy to use, smooth, lightweight, customizable and unrivaled performance on both mobile and desktop platforms across all major browsers.', 'smart-phone-field-for-gravity-forms'); ?></p>
        </div>
    </section>

    <div class="content_heading">
        <h2><?php esc_html_e('Never miss a valuable features', 'smart-phone-field-for-gravity-forms'); ?></h2>
        <p><?php esc_html_e('Let\'s explore the awesome features of the plugin', 'smart-phone-field-for-gravity-forms'); ?></p>
    </div>

    <div class="section_wrap">
        <!-- Slider Variation -->
        <section class="section_half">
            <div class="col_description">
                <h3><?php esc_html_e('Live Validation', 'smart-phone-field-for-gravity-forms'); ?></h3>
                <p>
                    <?php
                    esc_html_e('Smart Phone field verifies the validity of the phone number, activating when the user finishes typing or exits the phone field. It displays a message/icon when validation is triggered.', 'smart-phone-field-for-gravity-forms');
                    ?>
                </p>
            </div>
            <div class="col_image">
                <img src="<?php echo esc_url(GF_SMART_PHONE_FIELD_URL . 'admin/images/live_validation.webp'); ?>">
            </div>
        </section>
        <section class="section_half">
            <div class="col_description">
                <h3><?php esc_html_e('Phone meta', 'smart-phone-field-for-gravity-forms'); ?></h3>
                <p>
                    <?php
                    esc_html_e('Within the phone metadata, you can retrieve the phone number dial code, country code, and country name in the different text field.', 'smart-phone-field-for-gravity-forms');
                    ?>
                </p>
            </div>
            <div class="col_image">
                <img src="<?php echo esc_url(GF_SMART_PHONE_FIELD_URL . 'admin/images/meta.webp'); ?>">
            </div>
        </section>
        <!-- Single and dual handle slider -->
        <section class="section_half">
            <div class="col_description">
                <h3><?php esc_html_e('Global Settings', 'smart-phone-field-for-gravity-forms'); ?></h3>
                <p>
                    <?php
                    esc_html_e('In the Global Settings, you can manage all configurations related to the Smart Phone Field. While some options can be modified directly from the Phone Field tab, features like Strict Mode, RTL support, language selection, and other advanced settings are only available in the Global Settings panel.', 'smart-phone-field-for-gravity-forms');
                    ?>
                </p>
            </div>
            <div class="col_image">
                <img src="<?php echo esc_url(GF_SMART_PHONE_FIELD_URL . 'admin/images/settings.webp'); ?>">
            </div>
        </section>
        <!-- Default min & max value -->
        <section class="section_half">
            <div class="col_description">
                <h3><?php esc_html_e('Ensure valid number submission', 'smart-phone-field-for-gravity-forms'); ?></h3>
                <p>
                    <?php
                    esc_html_e('Smart phone field will ensure that submitted phone numbers are real/valid numbers. Client-side validation can be bypassed. So it always performs validation on the server side to ensure data validity. There is an option to enable and disable wrong submissions from the backend field editor.', 'smart-phone-field-for-gravity-forms');
                    ?>
                </p>
            </div>
            <div class="col_image">
                <img src="<?php echo esc_url(GF_SMART_PHONE_FIELD_URL . 'admin/images/invalid_submission.gif'); ?>">
            </div>
        </section>
        <!-- Prefix & postfix -->
        <section class="section_half">
            <div class="col_description">
                <h3><?php esc_html_e('Get user IP information', 'smart-phone-field-for-gravity-forms'); ?></h3>
                <p>
                    <?php
                    esc_html_e('This plugin allows you to access user IP-related details such as city, state, zip code, and more. You can easily incorporate this information into any field using merge tags.', 'smart-phone-field-for-gravity-forms');
                    ?>
                </p>
            </div>
            <div class="col_image">
                <img src="<?php echo esc_url(GF_SMART_PHONE_FIELD_URL . 'admin/images/merge.webp'); ?>">
            </div>
        </section>
        <!-- Tooltip & Pips -->
        <section class="section_half">
            <div class="col_description">
                <h3><?php esc_html_e('Multiple number format', 'smart-phone-field-for-gravity-forms'); ?></h3>
                <p>
                    <?php
                    esc_html_e('It generates four types of number formats that can be received in notifications and sent via any API. By default, the number will be sent in the notification with the raw format.', 'smart-phone-field-for-gravity-forms');
                    ?>
                </p>
            </div>
            <div class="col_image">
                <img src="<?php echo esc_url(GF_SMART_PHONE_FIELD_URL . 'admin/images/notification.webp'); ?>">
            </div>
        </section>
        <!-- RTL support -->
        <section class="section_half">
            <div class="col_description">
                <h3><?php esc_html_e('RTL support', 'smart-phone-field-for-gravity-forms'); ?></h3>
                <p>
                    <?php
                    esc_html_e('RTL (Right to Left) is a key feature for certain languages and countries. You can enable RTL using a checkbox, which is available in the pro version.', 'smart-phone-field-for-gravity-forms');
                    ?>
                </p>
            </div>
            <div class="col_image">
                <img src="<?php echo esc_url(GF_SMART_PHONE_FIELD_URL . 'admin/images/rtl.webp'); ?>">
            </div>
        </section>
        <!-- Calculation Support -->
        <section class="section_half">
            <div class="col_description">
                <h3><?php esc_html_e('Language support', 'smart-phone-field-for-gravity-forms'); ?></h3>
                <p>
                    <?php
                    esc_html_e('Over 30 languages are available in the Global Settings for easy selection. If your preferred language or specific text is not available, you can fully customize or modify all text using filter hooks.', 'smart-phone-field-for-gravity-forms');
                    ?>
                </p>
            </div>
            <div class="col_image">
                <img src="<?php echo esc_url(GF_SMART_PHONE_FIELD_URL . 'admin/images/rtl.webp'); ?>">
            </div>
        </section>
    </div>
</div>