<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Get all default general options parameters in a single array
 *
 * @return array Array of all  default general options
 */
function origincode_gallery_video_get_default_general_options() {
	$video_gallery_default__params = array(
		'origincode_gallery_video_ht_view2_element_linkbutton_text'                 => 'View More',
		'origincode_gallery_video_ht_view2_element_show_linkbutton'                 => 'on',
		'origincode_gallery_video_ht_view2_element_linkbutton_color'                => 'FFFFFF',
		'origincode_gallery_video_ht_view2_element_linkbutton_font_size'            => '14',
		'origincode_gallery_video_ht_view2_element_linkbutton_background_color'     => 'FF2C2C',
		'origincode_gallery_video_ht_view2_show_popup_linkbutton'                   => 'on',
		'origincode_gallery_video_ht_view2_popup_linkbutton_text'                   => 'View More',
		'origincode_gallery_video_ht_view2_popup_linkbutton_background_hover_color' => 'C02121',
		'origincode_gallery_video_ht_view2_popup_linkbutton_background_color'       => 'FF2C2C',
		'origincode_gallery_video_ht_view2_popup_linkbutton_font_hover_color'       => 'FFFFFF',
		'origincode_gallery_video_ht_view2_popup_linkbutton_color'                  => 'FFFFFF',
		'origincode_gallery_video_ht_view2_popup_linkbutton_font_size'              => '14',
		'origincode_gallery_video_ht_view2_description_color'                       => '222222',
		'origincode_gallery_video_ht_view2_description_font_size'                   => '14',
		'origincode_gallery_video_ht_view2_show_description'                        => 'on',
		'origincode_gallery_video_ht_view2_thumbs_width'                            => '75',
		'origincode_gallery_video_ht_view2_thumbs_height'                           => '75',
		'origincode_gallery_video_ht_view2_thumbs_position'                         => 'before',
		'origincode_gallery_video_ht_view2_show_thumbs'                             => 'on',
		'origincode_gallery_video_ht_view2_popup_background_color'                  => 'FFFFFF',
		'origincode_gallery_video_ht_view2_popup_overlay_color'                     => '000000',
		'origincode_gallery_video_ht_view2_popup_overlay_transparency_color'        => '70',
		'origincode_gallery_video_ht_view2_popup_closebutton_style'                 => 'dark',
		'origincode_gallery_video_ht_view2_show_separator_lines'                    => 'on',
		'origincode_gallery_video_ht_view2_show_popup_title'                        => 'on',
		'origincode_gallery_video_ht_view2_element_title_font_size'                 => '18',
		'origincode_gallery_video_ht_view2_element_title_font_color'                => '222222',
		'origincode_gallery_video_ht_view2_popup_title_font_size'                   => '18',
		'origincode_gallery_video_ht_view2_popup_title_font_color'                  => '222222',
		'origincode_gallery_video_ht_view2_element_overlay_color'                   => 'FFFFFF',
		'origincode_gallery_video_ht_view2_element_overlay_transparency'            => '70',
		'origincode_gallery_video_ht_view2_zoombutton_style'                        => 'light',
		'origincode_gallery_video_ht_view2_element_border_width'                    => '1',
		'origincode_gallery_video_ht_view2_element_border_color'                    => 'DEDEDE',
		'origincode_gallery_video_ht_view2_element_background_color'                => 'F9F9F9',
		'origincode_gallery_video_ht_view2_element_width'                           => '277',
		'origincode_gallery_video_ht_view2_element_height'                          => '160',
		'origincode_gallery_video_ht_view5_icons_style'                             => 'dark',
		'origincode_gallery_video_ht_view5_show_separator_lines'                    => 'on',
		'origincode_gallery_video_ht_view5_linkbutton_text'                         => 'View More',
		'origincode_gallery_video_ht_view5_show_linkbutton'                         => 'on',
		'origincode_gallery_video_ht_view5_linkbutton_background_hover_color'       => 'C02121',
		'origincode_gallery_video_ht_view5_linkbutton_background_color'             => 'FF2C2C',
		'origincode_gallery_video_ht_view5_linkbutton_font_hover_color'             => 'FFFFFF',
		'origincode_gallery_video_ht_view5_linkbutton_color'                        => 'FFFFFF',
		'origincode_gallery_video_ht_view5_linkbutton_font_size'                    => '14',
		'origincode_gallery_video_ht_view5_description_color'                       => '555555',
		'origincode_gallery_video_ht_view5_description_font_size'                   => '14',
		'origincode_gallery_video_ht_view5_show_description'                        => 'on',
		'origincode_gallery_video_ht_view5_thumbs_width'                            => '75',
		'origincode_gallery_video_ht_view5_thumbs_height'                           => '75',
		'origincode_gallery_video_ht_view5_show_thumbs'                             => 'on',
		'origincode_gallery_video_ht_view5_title_font_size'                         => '16',
		'origincode_gallery_video_ht_view5_title_font_color'                        => 'C02121',
		'origincode_gallery_video_ht_view5_main_image_width'                        => '275',
		'origincode_gallery_video_ht_view5_slider_tabs_font_color'                  => 'd9d99',
		'origincode_gallery_video_ht_view5_slider_tabs_background_color'            => '555555',
		'origincode_gallery_video_ht_view5_slider_background_color'                 => 'F9F9F9',
		'origincode_gallery_video_ht_view6_title_font_size'                         => '16',
		'origincode_gallery_video_ht_view6_title_font_color'                        => 'C02121',
		'origincode_gallery_video_ht_view6_title_font_hover_color'                  => 'FF2C2C',
		'origincode_gallery_video_ht_view6_title_background_color'                  => '000000',
		'origincode_gallery_video_ht_view6_title_background_transparency'           => '80',
		'origincode_gallery_video_ht_view6_border_radius'                           => '3',
		'origincode_gallery_video_ht_view6_border_width'                            => '0',
		'origincode_gallery_video_ht_view6_border_color'                            => 'EEEEEE',
		'origincode_gallery_video_ht_view6_width'                                   => '275',
		'origincode_gallery_video_light_box_size'                                   => '17',
		'origincode_gallery_video_light_box_width'                                  => '800',
		'origincode_gallery_video_light_box_transition'                             => 'elastic',
		'origincode_gallery_video_light_box_speed'                                  => '800',
		'origincode_gallery_video_light_box_href'                                   => 'False',
		'origincode_gallery_video_light_box_title'                                  => 'false',
		'origincode_gallery_video_light_box_scalephotos'                            => 'true',
		'origincode_gallery_video_light_box_rel'                                    => 'false',
		'origincode_gallery_video_light_box_scrolling'                              => 'false',
		'origincode_gallery_video_light_box_opacity'                                => '20',
		'origincode_gallery_video_light_box_open'                                   => 'false',
		'origincode_gallery_video_light_box_overlayclose'                           => 'true',
		'origincode_gallery_video_light_box_esckey'                                 => 'false',
		'origincode_gallery_video_light_box_arrowkey'                               => 'false',
		'origincode_gallery_video_light_box_loop'                                   => 'true',
		'origincode_gallery_video_light_box_data'                                   => 'false',
		'origincode_gallery_video_light_box_classname'                              => 'false',
		'origincode_gallery_video_light_box_fadeout'                                => '300',
		'origincode_gallery_video_light_box_closebutton'                            => 'true',
		'origincode_gallery_video_light_box_current'                                => 'image',
		'origincode_gallery_video_light_box_previous'                               => 'previous',
		'origincode_gallery_video_light_box_next'                                   => 'next',
		'origincode_gallery_video_light_box_close'                                  => 'close',
		'origincode_gallery_video_light_box_iframe'                                 => 'false',
		'origincode_gallery_video_light_box_inline'                                 => 'false',
		'origincode_gallery_video_light_box_html'                                   => 'false',
		'origincode_gallery_video_light_box_photo'                                  => 'false',
		'origincode_gallery_video_light_box_height'                                 => '600',
		'origincode_gallery_video_light_box_innerwidth'                             => 'false',
		'origincode_gallery_video_light_box_innerheight'                            => 'false',
		'origincode_gallery_video_light_box_initialwidth'                           => '300',
		'origincode_gallery_video_light_box_initialheight'                          => '100',
		'origincode_gallery_video_light_box_maxwidth'                               => '',
		'origincode_gallery_video_light_box_maxheight'                              => '',
		'origincode_gallery_video_light_box_slideshow'                              => 'false',
		'origincode_gallery_video_light_box_slideshowspeed'                         => '2500',
		'origincode_gallery_video_light_box_slideshowauto'                          => 'true',
		'origincode_gallery_video_light_box_slideshowstart'                         => 'start slideshow',
		'origincode_gallery_video_light_box_slideshowstop'                          => 'stop slideshow',
		'origincode_gallery_video_light_box_fixed'                                  => 'true',
		'origincode_gallery_video_light_box_top'                                    => 'false',
		'origincode_gallery_video_light_box_bottom'                                 => 'false',
		'origincode_gallery_video_light_box_left'                                   => 'false',
		'origincode_gallery_video_light_box_right'                                  => 'false',
		'origincode_gallery_video_light_box_reposition'                             => 'false',
		'origincode_gallery_video_light_box_retinaimage'                            => 'true',
		'origincode_gallery_video_light_box_retinaurl'                              => 'false',
		'origincode_gallery_video_light_box_retinasuffix'                           => '@2x.$1',
		'origincode_gallery_video_light_box_returnfocus'                            => 'true',
		'origincode_gallery_video_light_box_trapfocus'                              => 'true',
		'origincode_gallery_video_light_box_fastiframe'                             => 'true',
		'origincode_gallery_video_light_box_preloading'                             => 'true',
		'origincode_gallery_video_lightbox_open_position'                           => '5',
		'origincode_gallery_video_light_box_style'                                  => '1',
		'origincode_gallery_video_light_box_size_fix'                               => 'true',
		'origincode_gallery_video_slider_crop_image'                                => 'resize',
		'origincode_gallery_video_slider_title_color'                               => '000000',
		'origincode_gallery_video_slider_title_font_size'                           => '13',
		'origincode_gallery_video_slider_description_color'                         => 'FFFFFF',
		'origincode_gallery_video_slider_description_font_size'                     => '12',
		'origincode_gallery_video_slider_title_position'                            => 'right-top',
		'origincode_gallery_video_slider_description_position'                      => 'right-bottom',
		'origincode_gallery_video_slider_title_border_size'                         => '0',
		'origincode_gallery_video_slider_title_border_color'                        => 'FFFFFF',
		'origincode_gallery_video_slider_title_border_radius'                       => '4',
		'origincode_gallery_video_slider_description_border_size'                   => '0',
		'origincode_gallery_video_slider_description_border_color'                  => 'FFFFFF',
		'origincode_gallery_video_slider_description_border_radius'                 => '0',
		'origincode_gallery_video_slider_slideshow_border_size'                     => '0',
		'origincode_gallery_video_slider_slideshow_border_color'                    => 'FFFFFF',
		'origincode_gallery_video_slider_slideshow_border_radius'                   => '0',
		'origincode_gallery_video_slider_navigation_type'                           => '1',
		'origincode_gallery_video_slider_navigation_position'                       => 'bottom',
		'origincode_gallery_video_slider_title_background_color'                    => 'FFFFFF',
		'origincode_gallery_video_slider_description_background_color'              => '000000',
		'origincode_gallery_video_slider_title_transparent'                         => 'on',
		'origincode_gallery_video_slider_description_transparent'                   => 'on',
		'origincode_gallery_video_slider_slider_background_color'                   => 'FFFFFF',
		'origincode_gallery_video_slider_dots_position'                             => 'none',
		'origincode_gallery_video_slider_active_dot_color'                          => 'FFFFFF',
		'origincode_gallery_video_slider_dots_color'                                => '000000',
		'origincode_gallery_video_slider_description_width'                         => '70',
		'origincode_gallery_video_slider_description_height'                        => '50',
		'origincode_gallery_video_slider_description_background_transparency'       => '70',
		'origincode_gallery_video_slider_description_text_align'                    => 'justify',
		'origincode_gallery_video_slider_title_width'                               => '30',
		'origincode_gallery_video_slider_title_height'                              => '50',
		'origincode_gallery_video_slider_title_background_transparency'             => '70',
		'origincode_gallery_video_slider_title_text_align'                          => 'right',
		'origincode_gallery_video_slider_title_has_margin'                          => 'off',
		'origincode_gallery_video_slider_description_has_margin'                    => 'off',
		'origincode_gallery_video_slider_show_arrows'                               => 'on',
		'origincode_gallery_video_thumb_image_behavior'                             => 'on',
		'origincode_gallery_video_thumb_image_width'                                => '240',
		'origincode_gallery_video_thumb_image_height'                               => '150',
		'origincode_gallery_video_thumb_image_border_width'                         => '1',
		'origincode_gallery_video_thumb_image_border_color'                         => '444444',
		'origincode_gallery_video_thumb_image_border_radius'                        => '5',
		'origincode_gallery_video_thumb_margin_image'                               => '1',
		'origincode_gallery_video_thumb_title_font_size'                            => '16',
		'origincode_gallery_video_thumb_title_font_color'                           => 'FFFFFF',
		'origincode_gallery_video_thumb_title_background_color'                     => 'CCCCCC',
		'origincode_gallery_video_thumb_title_background_transparency'              => '80',
		'origincode_gallery_video_thumb_box_padding'                                => '28',
		'origincode_gallery_video_thumb_box_background'                             => '333333',
		'origincode_gallery_video_thumb_box_use_shadow'                             => 'on',
		'origincode_gallery_video_thumb_box_has_background'                         => 'on',
		'origincode_gallery_video_thumb_view_text'                                  => 'Watch Video',
		'origincode_gallery_video_ht_view8_element_cssAnimation'                    => 'false',
		'origincode_gallery_video_ht_view8_element_height'                          => '120',
		'origincode_gallery_video_ht_view8_element_maxheight'                       => '155',
		'origincode_gallery_video_ht_view8_element_show_caption'                    => 'true',
		'origincode_gallery_video_ht_view8_element_padding'                         => '0',
		'origincode_gallery_video_ht_view8_element_border_radius'                   => '5',
		'origincode_gallery_video_ht_view8_icons_style'                             => 'dark',
		'origincode_gallery_video_ht_view8_element_title_font_size'                 => '13',
		'origincode_gallery_video_ht_view8_element_title_font_color'                => '3AD6FC',
		'origincode_gallery_video_ht_view8_popup_background_color'                  => '000000',
		'origincode_gallery_video_ht_view8_popup_overlay_transparency_color'        => '0',
		'origincode_gallery_video_ht_view8_popup_closebutton_style'                 => 'dark',
		'origincode_gallery_video_ht_view8_element_title_overlay_transparency'      => '90',
		'origincode_gallery_video_ht_view8_element_size_fix'                        => 'false',
		'origincode_gallery_video_ht_view8_element_title_background_color'          => 'FF1C1C',
		'origincode_gallery_video_ht_view8_element_justify'                         => 'true',
		'origincode_gallery_video_ht_view8_element_randomize'                       => 'false',
		'origincode_gallery_video_ht_view8_element_animation_speed'                 => '2000',
		'origincode_gallery_video_video_ht_view9_title_fontsize'                    => '18',
		'origincode_gallery_video_video_ht_view9_title_color'                       => 'FFFFFF',
		'origincode_gallery_video_video_ht_view9_desc_color'                        => '000000',
		'origincode_gallery_video_video_ht_view9_desc_fontsize'                     => '14',
		'origincode_gallery_video_video_ht_view9_element_title_show'                => 'true',
		'origincode_gallery_video_video_ht_view9_element_desc_show'                 => 'true',
		'origincode_gallery_video_video_ht_view9_general_width'                     => '100',
		'origincode_gallery_video_video_view9_general_position'                     => 'center',
		'origincode_gallery_video_video_view9_title_textalign'                      => 'left',
		'origincode_gallery_video_video_view9_desc_textalign'                       => 'justify',
		'origincode_gallery_video_video_view9_image_position'                       => '2',
		'origincode_gallery_video_video_ht_view9_title_back_color'                  => '000000',
		'origincode_gallery_video_video_ht_view9_title_opacity'                     => '70',
		'origincode_gallery_video_video_ht_view9_desc_opacity'                      => '100',
		'origincode_gallery_video_video_ht_view9_desc_back_color'                   => 'FFFFFF',
		'origincode_gallery_video_video_ht_view9_general_space'                     => '0',
		'origincode_gallery_video_video_ht_view9_general_separator_size'            => '0',
		'origincode_gallery_video_video_ht_view9_general_separator_color'           => '010457',
		'origincode_gallery_video_video_view9_general_separator_style'              => 'dotted',
		'origincode_gallery_video_video_ht_view9_paginator_fontsize'                => '22',
		'origincode_gallery_video_video_ht_view9_paginator_color'                   => '1046B3',
		'origincode_gallery_video_video_ht_view9_paginator_icon_color'              => '1046B3',
		'origincode_gallery_video_video_ht_view9_paginator_icon_size'               => '18',
		'origincode_gallery_video_video_view9_paginator_position'                   => 'center',
		'origincode_gallery_video_video_ht_view9_video_width'                       => '100%',
		'origincode_gallery_video_video_ht_view9_video_height'                      => '100%',
		'origincode_gallery_video_video_view9_video_position'                       => 'center',
		'origincode_gallery_video_video_view9_loadmore_position'                    => 'center',
		'origincode_gallery_video_video_ht_view9_loadmore_fontsize'                 => '19',
		'origincode_gallery_video_video_ht_view9_button_color'                      => '5CADFF',
		'origincode_gallery_video_video_ht_view9_loadmore_font_color'               => 'FFFFFF',
		'origincode_gallery_video_loading_type'                                     => '2',
		'origincode_gallery_video_video_ht_view9_loadmore_text'                     => 'View More',
		'origincode_gallery_video_video_ht_view8_paginator_position'                => 'center',
		'origincode_gallery_video_video_ht_view8_paginator_icon_size'               => '18',
		'origincode_gallery_video_video_ht_view8_paginator_icon_color'              => '26A6FC',
		'origincode_gallery_video_video_ht_view8_paginator_color'                   => '26A6FC',
		'origincode_gallery_video_video_ht_view8_paginator_fontsize'                => '18',
		'origincode_gallery_video_video_ht_view8_loadmore_position'                 => 'center',
		'origincode_gallery_video_video_ht_view8_loadmore_fontsize'                 => '14',
		'origincode_gallery_video_video_ht_view8_button_color'                      => '26A6FC',
		'origincode_gallery_video_video_ht_view8_loadmore_font_color'               => 'FF1C1C',
		'origincode_gallery_video_video_ht_view8_loading_type'                      => '3',
		'origincode_gallery_video_video_ht_view8_loadmore_text'                     => 'View More',
		'origincode_gallery_video_video_ht_view7_paginator_fontsize'                => '22',
		'origincode_gallery_video_video_ht_view7_paginator_color'                   => '0A0202',
		'origincode_gallery_video_video_ht_view7_paginator_icon_color'              => '333333',
		'origincode_gallery_video_video_ht_view7_paginator_icon_size'               => '22',
		'origincode_gallery_video_video_ht_view7_paginator_position'                => 'center',
		'origincode_gallery_video_video_ht_view7_loadmore_position'                 => 'center',
		'origincode_gallery_video_video_ht_view7_loadmore_fontsize'                 => '19',
		'origincode_gallery_video_video_ht_view7_button_color'                      => '333333',
		'origincode_gallery_video_video_ht_view7_loadmore_font_color'               => 'CCCCCC',
		'origincode_gallery_video_video_ht_view7_loading_type'                      => '1',
		'origincode_gallery_video_video_ht_view7_loadmore_text'                     => 'View More',
		'origincode_gallery_video_video_ht_view4_paginator_fontsize'                => '19',
		'origincode_gallery_video_video_ht_view4_paginator_color'                   => 'FF2C2C',
		'origincode_gallery_video_video_ht_view4_paginator_icon_color'              => 'B82020',
		'origincode_gallery_video_video_ht_view4_paginator_icon_size'               => '21',
		'origincode_gallery_video_video_ht_view4_paginator_position'                => 'center',
		'origincode_gallery_video_video_ht_view4_loadmore_position'                 => 'center',
		'origincode_gallery_video_video_ht_view4_loadmore_fontsize'                 => '16',
		'origincode_gallery_video_video_ht_view4_button_color'                      => '5CADFF',
		'origincode_gallery_video_video_ht_view4_loadmore_font_color'               => 'FF0D0D',
		'origincode_gallery_video_video_ht_view4_loading_type'                      => '3',
		'origincode_gallery_video_video_ht_view4_loadmore_text'                     => 'View More',
		'origincode_gallery_video_video_ht_view1_paginator_fontsize'                => '22',
		'origincode_gallery_video_video_ht_view1_paginator_color'                   => '222222',
		'origincode_gallery_video_video_ht_view1_paginator_icon_color'              => 'FF2C2C',
		'origincode_gallery_video_video_ht_view1_paginator_icon_size'               => '22',
		'origincode_gallery_video_video_ht_view1_paginator_position'                => 'left',
		'origincode_gallery_video_video_ht_view1_loadmore_position'                 => 'center',
		'origincode_gallery_video_video_ht_view1_loadmore_fontsize'                 => '22',
		'origincode_gallery_video_video_ht_view1_button_color'                      => 'FF2C2C',
		'origincode_gallery_video_video_ht_view1_loadmore_font_color'               => 'FFFFFF',
		'origincode_gallery_video_video_ht_view1_loading_type'                      => '2',
		'origincode_gallery_video_video_ht_view1_loadmore_text'                     => 'Load More',
		'origincode_gallery_video_video_ht_view9_loadmore_font_color_hover'         => 'D9D9D9',
		'origincode_gallery_video_video_ht_view9_button_color_hover'                => '8F827C',
		'origincode_gallery_video_video_ht_view8_loadmore_font_color_hover'         => 'FF4242',
		'origincode_gallery_video_video_ht_view8_button_color_hover'                => '0FEFFF',
		'origincode_gallery_video_video_ht_view7_loadmore_font_color_hover'         => 'D9D9D9',
		'origincode_gallery_video_video_ht_view7_button_color_hover'                => '8F827C',
		'origincode_gallery_video_video_ht_view4_loadmore_font_color_hover'         => 'FF4040',
		'origincode_gallery_video_video_ht_view4_button_color_hover'                => '99C5FF',
		'origincode_gallery_video_video_ht_view1_loadmore_font_color_hover'         => 'F2F2F2',
		'origincode_gallery_video_video_ht_view1_button_color_hover'                => '991A1A',
		'origincode_gallery_video_ht_view2_content_in_center_popup'                 => 'off',
		'origincode_gallery_video_ht_view2_content_in_center_lightbox'              => 'off',
		'origincode_gallery_video_video_natural_size_thumbnail'                     => 'resize',
		'origincode_gallery_video_video_natural_size_contentpopup'                  => 'resize',
		'origincode_gallery_video_version'                                          => '2.0.4',
        //new options
        'origincode_gallery_video_lightbox_slideAnimationType'                         => 'effect_1',
        'origincode_gallery_video_lightbox_lightboxView'                               => 'view1',
        'origincode_gallery_video_lightbox_speed_new'                                  => '600',
        'origincode_gallery_video_lightbox_width_new'                                  => '100',
        'origincode_gallery_video_lightbox_height_new'                                 => '100',
        'origincode_gallery_video_lightbox_videoMaxWidth'                              => '790',
        'origincode_gallery_video_lightbox_overlayDuration'                            => '150',
        'origincode_gallery_video_lightbox_overlayClose_new'                           => 'true',
        'origincode_gallery_video_lightbox_loop_new'                                   => 'true',
        'origincode_gallery_video_lightbox_escKey_new'                                 => 'true',
        'origincode_gallery_video_lightbox_keyPress_new'                               => 'true',
        'origincode_gallery_video_lightbox_arrows'                                     => 'true',
        'origincode_gallery_video_lightbox_mouseWheel'                                 => 'true',
        'origincode_gallery_video_lightbox_showCounter'                                => 'true',
        'origincode_gallery_video_lightbox_nextHtml'                                   => '',     //not used
        'origincode_gallery_video_lightbox_prevHtml'                                   => '',     //not used
        'origincode_gallery_video_lightbox_sequence_info'                              => 'image',
        'origincode_gallery_video_lightbox_sequenceInfo'                               => 'of',
        'origincode_gallery_video_lightbox_slideshow_new'                              => 'true',
        'origincode_gallery_video_lightbox_slideshow_auto_new'                         => 'false',
        'origincode_gallery_video_lightbox_slideshow_speed_new'                        => '2500',
        'origincode_gallery_video_lightbox_slideshow_start_new'                        => '',     //not used
        'origincode_gallery_video_lightbox_slideshow_stop_new'                         => '',     //not used
        'origincode_gallery_video_lightbox_watermark'                                  => 'false',
        'origincode_gallery_video_lightbox_socialSharing'                              => 'true',
        'origincode_gallery_video_lightbox_facebookButton'                             => 'true',
        'origincode_gallery_video_lightbox_twitterButton'                              => 'true',
        'origincode_gallery_video_lightbox_googleplusButton'                           => 'true',
        'origincode_gallery_video_lightbox_pinterestButton'                            => 'false',
        'origincode_gallery_video_lightbox_linkedinButton'                             => 'false',
        'origincode_gallery_video_lightbox_tumblrButton'                               => 'false',
        'origincode_gallery_video_lightbox_redditButton'                               => 'false',
        'origincode_gallery_video_lightbox_bufferButton'                               => 'false',
        'origincode_gallery_video_lightbox_diggButton'                                 => 'false',
        'origincode_gallery_video_lightbox_vkButton'                                   => 'false',
        'origincode_gallery_video_lightbox_yummlyButton'                               => 'false',
        'origincode_gallery_video_lightbox_watermark_text'                             => 'WaterMark',
        'origincode_gallery_video_lightbox_watermark_textColor'                        => 'ffffff',
        'origincode_gallery_video_lightbox_watermark_textFontSize'                     => '30',
        'origincode_gallery_video_lightbox_watermark_containerBackground'              => '000000',
        'origincode_gallery_video_lightbox_watermark_containerOpacity'                 => '90',
        'origincode_gallery_video_lightbox_watermark_containerWidth'                   => '300',
        'origincode_gallery_video_lightbox_watermark_position_new'                     => '9',
        'origincode_gallery_video_lightbox_watermark_opacity'                          => '70',
        'origincode_gallery_video_lightbox_watermark_margin'                           => '10',
        'origincode_gallery_video_lightbox_watermark_img_src_new'                      => ORIGINCODE_GALLERY_VIDEO_IMAGES_URL . '/admin_images/No-image-found.jpg',
        'origincode_gallery_video_lightbox_type'                                       => 'new_type',
        //// playlist options
        'origincode_gallery_video_ht_view10_container_width'                           =>'650',
        'origincode_gallery_video_ht_view10_thumb_position'                            =>'right',
        'origincode_gallery_video_ht_view10_thumb_scroll'                              =>'on',
        'origincode_gallery_video_ht_view10_search'                                    =>'on',
        'origincode_gallery_video_ht_view10_search_criteria'                           =>'both',
        'origincode_gallery_video_playlist_socialSharing'                              =>'true',
        'origincode_gallery_video_playlist_facebookButton'                             =>'true',
        'origincode_gallery_video_playlist_twitterButton'                              =>'false',
        'origincode_gallery_video_playlist_googleplusButton'                           =>'false'
	);

	return $video_gallery_default__params;
}

/**
 * Get front-end view slug
 *
 * @param $id
 *
 * @return string
 */
function origincode_gallery_video_get_view_slag_by_id( $id ) {
	global $wpdb;
	$query = $wpdb->prepare( "SELECT origincode_sl_effects FROM " . $wpdb->prefix . "origincode_videogallery_galleries WHERE id=%d", $id );
	$view  = $wpdb->get_var( $query );
	switch ( $view ) {
		case 0:
			$slug = 'content-popup';
			break;
		case 1:
			$slug = 'content-slider';
			break;
		case 3:
			$slug = 'slider';
			break;
		case 4:
			$slug = 'thumbnails';
			break;
		case 5:
			$slug = 'lightbox-gallery';
			break;
		case 6:
			$slug = 'justified';
			break;
		case 7:
			$slug = 'blog-style-gallery';
			break;
        case 8:
            $slug = 'playlist';
            break;
	}

	return $slug;
}

/**
 * Get User IP
 * @return mixed
 */
function origincode_gallery_video_get_ip() {
	if ( ! empty( $_SERVER['HTTP_CLIENT_IP'] ) ) {
		$origincode_ip = $_SERVER['HTTP_CLIENT_IP'];
	} elseif ( ! empty( $_SERVER['HTTP_X_FORWARDED_FOR'] ) ) {
		$origincode_ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
	} else {
		$origincode_ip = $_SERVER['REMOTE_ADDR'];
	}

	return $origincode_ip;
}
