<?php

class WDSControllerWidgetSlideshow extends WP_Widget {
  ////////////////////////////////////////////////////////////////////////////////////////
  // Events                                                                             //
  ////////////////////////////////////////////////////////////////////////////////////////
  ////////////////////////////////////////////////////////////////////////////////////////
  // Constants                                                                          //
  ////////////////////////////////////////////////////////////////////////////////////////
  ////////////////////////////////////////////////////////////////////////////////////////
  // Variables                                                                          //
  ////////////////////////////////////////////////////////////////////////////////////////
  private $view;
  private $model;
  ////////////////////////////////////////////////////////////////////////////////////////
  // Constructor & Destructor                                                           //
  ////////////////////////////////////////////////////////////////////////////////////////
  public function __construct() {
    $widget_ops = array(
      'classname' => 'wdslider',
      'description' => __('Add Slider to Your widget area.', WDS()->prefix),
    );
    // Widget Control Settings.
    $control_ops = array('id_base' => 'wdslider');
    // Create the widget.
    parent::__construct('wdslider', __('Slider by 10Web', WDS()->prefix), $widget_ops, $control_ops);
    require_once WDS()->plugin_dir . "/admin/models/WDSModelWidgetSlideshow.php";
    $this->model = new WDSModelWidgetSlideshow();

    require_once WDS()->plugin_dir . "/admin/views/WDSViewWidgetSlideshow.php";
    $this->view = new WDSViewWidgetSlideshow($this->model);
  }
  ////////////////////////////////////////////////////////////////////////////////////////
  // Public Methods                                                                     //
  ////////////////////////////////////////////////////////////////////////////////////////

  public function widget($args, $instance) {
    $this->view->widget($args, $instance);
	}

 	public function form($instance) {
    $this->view->form($instance, parent::get_field_id('title'), parent::get_field_name('title'), parent::get_field_id('id'), parent::get_field_name('id'));
	}

	// Update Settings.
  public function update($new_instance, $old_instance) {
    $instance['title'] = esc_html(strip_tags($new_instance['title']));
    $instance['id'] = intval($new_instance['id']);
    return $instance;
  }

  ////////////////////////////////////////////////////////////////////////////////////////
  // Getters & Setters                                                                  //
  ////////////////////////////////////////////////////////////////////////////////////////
  ////////////////////////////////////////////////////////////////////////////////////////
  // Private Methods                                                                    //
  ////////////////////////////////////////////////////////////////////////////////////////
  ////////////////////////////////////////////////////////////////////////////////////////
  // Listeners                                                                          //
  ////////////////////////////////////////////////////////////////////////////////////////
}