<?php
	add_action( 'wp_ajax_rw_edit_slider', 'rw_edit_slider_callback' );
	add_action( 'wp_ajax_rw_delete_slider', 'rw_delete_slider_callback' );
	add_action( 'wp_ajax_rw_copy_slider', 'rw_copy_slider_callback' );
	add_action( 'wp_ajax_rw_edit_theme', 'rw_edit_theme_callback' );
	add_action( 'wp_ajax_rw_copy_theme', 'rw_copy_theme_callback' );
	add_action( 'wp_ajax_rw_delete_theme', 'rw_delete_theme_callback' );
	add_action( 'wp_ajax_rw_check_theme_name', 'rw_check_theme_name_callback' );
	function rw_edit_slider_callback() {
		if ( ! isset ($_POST['rw_slider_image_nonce']) || $_POST['rw_slider_image_nonce'] === '' || ! wp_verify_nonce( $_POST['rw_slider_image_nonce'], 'rw_slider_image_nonce_field' ) ) {
			wp_send_json_error( 'Slider Image nonce error.' );
		}
		$rw_edit_id = sanitize_text_field($_POST['rw_edit_id']);
		global $wpdb;
		$rw_slider_image_manager = $wpdb->prefix . "rich_web_photo_slider_manager";
		$rw_slider_image_install = $wpdb->prefix . "rich_web_photo_slider_instal";
		$rw_get_slider_info = $wpdb->get_row($wpdb->prepare("SELECT * FROM $rw_slider_image_manager WHERE id=%s", $rw_edit_id),"ARRAY_A");
		$rw_get_slider_items = $wpdb->get_results($wpdb->prepare("SELECT * FROM $rw_slider_image_install WHERE Sl_Number=%d order by id",(int) $rw_edit_id),"ARRAY_A");
		foreach ($rw_get_slider_items as $item_key => $item_value) {
			$rw_get_slider_items[$item_key]["SL_Img_Title"] = html_entity_decode($rw_get_slider_items[$item_key]["SL_Img_Title"]);
			$rw_get_slider_items[$item_key]["Sl_Img_Description"] = html_entity_decode($rw_get_slider_items[$item_key]["Sl_Img_Description"]);
		}
		wp_send_json_success(array(
			"sliderInfo" => $rw_get_slider_info,
			"sliderItems" => $rw_get_slider_items
		));
	}
	function rw_delete_slider_callback() {
		if ( ! isset ($_POST['rw_slider_image_nonce']) || $_POST['rw_slider_image_nonce'] === '' || ! wp_verify_nonce( $_POST['rw_slider_image_nonce'], 'rw_slider_image_nonce_field' ) ) {
			wp_send_json_error( 'Slider Image nonce error.' );
		}
		$rw_delete_id = sanitize_text_field($_POST['rw_delete_id']);
		global $wpdb;
		$rw_slider_image_manager  = $wpdb->prefix . "rich_web_photo_slider_manager";
		$rw_slider_image_install = $wpdb->prefix . "rich_web_photo_slider_instal";
		$wpdb->query($wpdb->prepare("DELETE FROM $rw_slider_image_manager WHERE id=%d", (int) $rw_delete_id));
		$wpdb->query($wpdb->prepare("DELETE FROM $rw_slider_image_install WHERE Sl_Number=%d", (int) $rw_delete_id));
		wp_send_json_success();
	}
	function rw_copy_slider_callback() {
		if ( ! isset ($_POST['rw_slider_image_nonce']) || $_POST['rw_slider_image_nonce'] === '' || ! wp_verify_nonce( $_POST['rw_slider_image_nonce'], 'rw_slider_image_nonce_field' ) ) {
			wp_send_json_error( 'Slider Image nonce error.' );
		}
		$rw_copy_id = sanitize_text_field($_POST['rw_copy_id']);
		global $wpdb;
		$rw_slider_image_manager  = $wpdb->prefix . "rich_web_photo_slider_manager";
		$rw_slider_image_install = $wpdb->prefix . "rich_web_photo_slider_instal";
		$rw_slider_image_table_id = $wpdb->prefix . "rich_web_slider_id";
		$rw_slider_table_effects_data = $wpdb->prefix . "rich_web_slider_effects_data";
		$rw_get_copy_slider = $wpdb->get_row($wpdb->prepare("SELECT * FROM $rw_slider_image_manager WHERE id=%s", $rw_copy_id),"ARRAY_A");
		$rw_get_copy_slider_slides = $wpdb->get_results($wpdb->prepare("SELECT * FROM $rw_slider_image_install WHERE Sl_Number=%d order by id", $rw_copy_id),"ARRAY_A");
		$wpdb->query($wpdb->prepare("INSERT INTO $rw_slider_image_manager (id, Slider_Title, Slider_Type, Slider_IMGS_Quantity) VALUES (%d, %s, %s, %d)", '', $rw_get_copy_slider["Slider_Title"], $rw_get_copy_slider["Slider_Type"], $rw_get_copy_slider["Slider_IMGS_Quantity"]));
		$rw_get_last_id = $wpdb->get_row($wpdb->prepare("SELECT `Slider_ID` FROM $rw_slider_image_table_id WHERE id > %d order by id desc limit 1",0),"ARRAY_A");
		$rw_set_new_id = $rw_get_last_id["Slider_ID"] + 1;
		$wpdb->query($wpdb->prepare("INSERT INTO $rw_slider_image_table_id (id, Slider_ID) VALUES (%d, %d)", '', $rw_set_new_id));
		foreach ($rw_get_copy_slider_slides as $rw_key => $rw_value) {
			$wpdb->query($wpdb->prepare("INSERT INTO $rw_slider_image_install (id, SL_Img_Title, Sl_Img_Description, Sl_Img_Url, Sl_Link_Url, Sl_Link_NewTab, Sl_Number) VALUES (%d, %s, %s, %s, %s, %s, %d)", '', $rw_value["SL_Img_Title"], $rw_value["Sl_Img_Description"], $rw_value["Sl_Img_Url"], $rw_value["Sl_Link_Url"], $rw_value["Sl_Link_NewTab"], $rw_set_new_id));
		}
		$rw_get_copied_slider = $wpdb->get_row($wpdb->prepare("SELECT * FROM $rw_slider_image_manager order by id desc limit 1"),"ARRAY_A");
		$rw_get_copied_slider_type = $wpdb->get_row($wpdb->prepare("SELECT `slider_name` FROM $rw_slider_table_effects_data where id=%d",(int) $rw_get_copied_slider["Slider_Type"]),"ARRAY_A");
		$rw_get_copied_slider["Slider_Type"] = $rw_get_copied_slider_type["slider_name"];
		wp_send_json_success($rw_get_copied_slider);
	}
	function rw_edit_theme_callback() {
		if ( ! isset ($_POST['rw_slider_image_nonce']) || $_POST['rw_slider_image_nonce'] === '' || ! wp_verify_nonce( $_POST['rw_slider_image_nonce'], 'rw_slider_image_nonce_field' ) ) {
			wp_send_json_error( 'Slider Image nonce error.' );
		}
		$rw_edit_id = sanitize_text_field($_POST['rw_edit_id']);
		global $wpdb;
		$rw_themes_tables  = [
			"Slider Navigation" => "rich_web_slider_effect1",
			"Content Slider"	  => "rich_web_slider_effect2",
			"Fashion Slider"	  => "rich_web_slider_effect3",
			"Circle Thumbnails"  => "rich_web_slider_effect4",
			"Slider Carousel"	  => "rich_web_slider_effect5",
			"Flexible Slider"	  => "rich_web_slider_effect6",
			"Dynamic Slider"	  => "rich_web_slider_effect7",
			"Thumbnails Slider & Lightbox"	=> "rich_web_slider_effect8",
			"Accordion Slider"  => "rich_web_slider_effect9",
			"Animation Slider"	  => "rich_web_slider_effect10"
		];
		$rw_edit_slider_type=$wpdb->get_row($wpdb->prepare("SELECT `slider_type` FROM ".RW_SLIDER_IMAGE_EFFECTS_TABLE." WHERE id=%d", $rw_edit_id),ARRAY_A);
		$rw_theme_option_table = esc_sql($wpdb->prefix  . $rw_themes_tables[$rw_edit_slider_type["slider_type"]]);
		$rw_theme_option_loading_table = esc_sql($wpdb->prefix  . $rw_themes_tables[$rw_edit_slider_type["slider_type"]] . "_Loader");
		if ($rw_edit_slider_type["slider_type"] === "Content Slider") {
			$rw_get_theme_options=$wpdb->get_row($wpdb->prepare("SELECT * FROM $rw_theme_option_table WHERE richideo_EN_ID = %s ",$rw_edit_id),ARRAY_A);
		}else{
			$rw_get_theme_options=$wpdb->get_row($wpdb->prepare("SELECT * FROM $rw_theme_option_table WHERE rich_web_slider_ID = %s ",$rw_edit_id),ARRAY_A);
		}
		$rw_get_theme_loading_options=$wpdb->get_row($wpdb->prepare("SELECT * FROM $rw_theme_option_loading_table WHERE rich_web_slider_ID = %s", $rw_edit_id),ARRAY_A);
		wp_send_json_success(
			array(
				"rw_theme_options" => $rw_get_theme_options,
				"rw_theme_loading_options" => $rw_get_theme_loading_options
			)
		);
	}
	function rw_copy_theme_callback() {
		if ( ! isset ($_POST['rw_slider_image_nonce']) || $_POST['rw_slider_image_nonce'] === '' || ! wp_verify_nonce( $_POST['rw_slider_image_nonce'], 'rw_slider_image_nonce_field' ) ) {
			wp_send_json_error( 'Slider Image nonce error.' );
		}
		$rw_copy_id = sanitize_text_field($_POST['rw_copy_id']);
		global $wpdb;
		$rw_slider_image_navigation_loader  = RW_SLIDER_IMAGE_NAVIGATION . "_loader";
		$rw_slider_image_content_loader  = RW_SLIDER_IMAGE_CONTENT . "_loader";
		$rw_slider_image_fashion_loader  = RW_SLIDER_IMAGE_FASHION . "_loader";
		$rw_slider_image_circle_loader  = RW_SLIDER_IMAGE_CIRCLE . "_loader";
		$rw_slider_image_carousel_loader  = RW_SLIDER_IMAGE_CAROUSEL . "_loader";
		$rw_slider_image_flexible_loader  = RW_SLIDER_IMAGE_FLEXIBLE . "_loader";
		$rw_slider_image_dynamic_loader  = RW_SLIDER_IMAGE_DYNAMIC . "_loader";
		$rw_slider_image_lightbox_loader  = RW_SLIDER_IMAGE_LIGHTBOX . "_loader";
		$rw_slider_image_accordion_loader  = RW_SLIDER_IMAGE_ACCORDION . "_loader";
		$rw_slider_image_animation_loader  = RW_SLIDER_IMAGE_ANIMATION . "_loader";
		$rw_get_copy_theme=$wpdb->get_row($wpdb->prepare("SELECT * FROM ".RW_SLIDER_IMAGE_EFFECTS_TABLE." WHERE id=%d", $rw_copy_id),ARRAY_A);
		$rw_get_copy_theme_name = $rw_get_copy_theme["slider_name"];
		for ($i=1; $i < 100; $i++) { 
			$rw_set_copy_theme_name = $rw_get_copy_theme_name.' '.$i;
			$rw_check_name_exists = $wpdb->get_var( $wpdb->prepare( "SELECT COUNT(*) FROM ".RW_SLIDER_IMAGE_EFFECTS_TABLE." WHERE slider_name = %s",$rw_set_copy_theme_name) );
			if($rw_check_name_exists === "0"){
				$rw_get_copy_theme["slider_name"] = $rw_set_copy_theme_name;
				break;
			}
		}
		$wpdb->query($wpdb->prepare("INSERT INTO ".RW_SLIDER_IMAGE_EFFECTS_TABLE." (id, slider_name, slider_type) VALUES (%d, %s, %s)", '', $rw_get_copy_theme["slider_name"], $rw_get_copy_theme["slider_type"]));
		$rw_new_copy_id = $wpdb->insert_id;
		if($rw_get_copy_theme["slider_type"]=='Slider Navigation'){
			$rw_theme_options_object=$wpdb->get_row($wpdb->prepare("SELECT * FROM ".RW_SLIDER_IMAGE_NAVIGATION." WHERE rich_web_slider_ID=%s", $rw_copy_id));
			$wpdb->query($wpdb->prepare("INSERT INTO ".RW_SLIDER_IMAGE_NAVIGATION." (id, rich_web_slider_ID, rich_web_slider_name, rich_web_slider_type, rich_web_Sl1_SlS, rich_web_Sl1_SlSS, rich_web_Sl1_PoH, rich_web_Sl1_W, rich_web_Sl1_H, rich_web_Sl1_BoxS, rich_web_Sl1_BoxSC, rich_web_Sl1_IBW, rich_web_Sl1_IBS, rich_web_Sl1_IBC, rich_web_Sl1_IBR, rich_web_Sl1_TBgC, rich_web_Sl1_TC, rich_web_Sl1_TTA, rich_web_Sl1_TFS, rich_web_Sl1_TFF, rich_web_Sl1_TUp, rich_web_Sl1_ArBgC, rich_web_Sl1_ArOp, rich_web_Sl1_ArType, rich_web_Sl1_ArHBgC, rich_web_Sl1_ArHOp, rich_web_Sl1_ArHEff, rich_web_Sl1_ArBoxW, rich_web_Sl1_NavW, rich_web_Sl1_NavH, rich_web_Sl1_NavPB, rich_web_Sl1_NavBW, rich_web_Sl1_NavBS, rich_web_Sl1_NavBC, rich_web_Sl1_NavBR, rich_web_Sl1_NavCC, rich_web_Sl1_NavHC, rich_web_Sl1_ArPFT, rich_web_Sl1_NavPos) VALUES (%d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", '', $rw_new_copy_id, $rw_get_copy_theme["slider_name"], $rw_theme_options_object->rich_web_slider_type, $rw_theme_options_object->rich_web_Sl1_SlS, $rw_theme_options_object->rich_web_Sl1_SlSS, $rw_theme_options_object->rich_web_Sl1_PoH, $rw_theme_options_object->rich_web_Sl1_W, $rw_theme_options_object->rich_web_Sl1_H, $rw_theme_options_object->rich_web_Sl1_BoxS, $rw_theme_options_object->rich_web_Sl1_BoxSC, $rw_theme_options_object->rich_web_Sl1_IBW, $rw_theme_options_object->rich_web_Sl1_IBS, $rw_theme_options_object->rich_web_Sl1_IBC, $rw_theme_options_object->rich_web_Sl1_IBR, $rw_theme_options_object->rich_web_Sl1_TBgC, $rw_theme_options_object->rich_web_Sl1_TC, $rw_theme_options_object->rich_web_Sl1_TTA, $rw_theme_options_object->rich_web_Sl1_TFS, $rw_theme_options_object->rich_web_Sl1_TFF, $rw_theme_options_object->rich_web_Sl1_TUp, $rw_theme_options_object->rich_web_Sl1_ArBgC, $rw_theme_options_object->rich_web_Sl1_ArOp, $rw_theme_options_object->rich_web_Sl1_ArType, $rw_theme_options_object->rich_web_Sl1_ArHBgC, $rw_theme_options_object->rich_web_Sl1_ArHOp, $rw_theme_options_object->rich_web_Sl1_ArHEff, $rw_theme_options_object->rich_web_Sl1_ArBoxW, $rw_theme_options_object->rich_web_Sl1_NavW, $rw_theme_options_object->rich_web_Sl1_NavH, $rw_theme_options_object->rich_web_Sl1_NavPB, $rw_theme_options_object->rich_web_Sl1_NavBW, $rw_theme_options_object->rich_web_Sl1_NavBS, $rw_theme_options_object->rich_web_Sl1_NavBC, $rw_theme_options_object->rich_web_Sl1_NavBR, $rw_theme_options_object->rich_web_Sl1_NavCC, $rw_theme_options_object->rich_web_Sl1_NavHC, $rw_theme_options_object->rich_web_Sl1_ArPFT, $rw_theme_options_object->rich_web_Sl1_NavPos));
			$rw_theme_options_loader_object=$wpdb->get_row($wpdb->prepare("SELECT * FROM $rw_slider_image_navigation_loader WHERE rich_web_slider_ID=%s", $rw_copy_id));
			$wpdb->query($wpdb->prepare("INSERT INTO $rw_slider_image_navigation_loader (id, rich_web_slider_ID, Rich_Web_NSL_L_Show, Rich_Web_NSL_LT_Show, Rich_Web_NSL_LT, Rich_Web_NSL_L_BgC, Rich_Web_NSL_L_T, Rich_Web_NSL_LT_T, Rich_Web_NSL_LT_FS, Rich_Web_NSL_LT_FF, Rich_Web_NSL_LT_C, Rich_Web_NSL_L_T1_C, Rich_Web_NSL_L_T2_C, Rich_Web_NSL_L_T3_C, Rich_Web_NSL_LT_T2_BC, Rich_Web_NSL_L_C, Rich_Web_NSL_LT_T2_AnC, Rich_Web_NSL_LT_T3_BgC, Rich_Web_NSL_L_S, Rich_Web_NSL_Loading_Show) VALUES (%d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", '', $rw_new_copy_id, $rw_theme_options_loader_object->Rich_Web_NSL_L_Show, $rw_theme_options_loader_object->Rich_Web_NSL_LT_Show, $rw_theme_options_loader_object->Rich_Web_NSL_LT, $rw_theme_options_loader_object->Rich_Web_NSL_L_BgC, $rw_theme_options_loader_object->Rich_Web_NSL_L_T, $rw_theme_options_loader_object->Rich_Web_NSL_LT_T, $rw_theme_options_loader_object->Rich_Web_NSL_LT_FS, $rw_theme_options_loader_object->Rich_Web_NSL_LT_FF, $rw_theme_options_loader_object->Rich_Web_NSL_LT_C, $rw_theme_options_loader_object->Rich_Web_NSL_L_T1_C, $rw_theme_options_loader_object->Rich_Web_NSL_L_T2_C, $rw_theme_options_loader_object->Rich_Web_NSL_L_T3_C, $rw_theme_options_loader_object->Rich_Web_NSL_LT_T2_BC, $rw_theme_options_loader_object->Rich_Web_NSL_L_C, $rw_theme_options_loader_object->Rich_Web_NSL_LT_T2_AnC,  $rw_theme_options_loader_object->Rich_Web_NSL_LT_T3_BgC,  $rw_theme_options_loader_object->Rich_Web_NSL_L_S,  $rw_theme_options_loader_object->Rich_Web_NSL_Loading_Show));
		}else if($rw_get_copy_theme["slider_type"]=='Content Slider'){
			$rw_theme_options_object=$wpdb->get_row($wpdb->prepare("SELECT * FROM ".RW_SLIDER_IMAGE_CONTENT." WHERE richideo_EN_ID=%s", $rw_copy_id));
			$wpdb->query($wpdb->prepare("INSERT INTO ".RW_SLIDER_IMAGE_CONTENT." (id, richideo_EN_ID, rich_web_slider_name, rich_web_slider_type, rich_CS_BIB, rich_CS_P, rich_CS_Loop, rich_CS_SD, rich_CS_AT, rich_CS_Cont_BgC, rich_CS_Cont_BSC, rich_CS_Cont_W, rich_CS_Cont_H, rich_CS_Cont_Op, rich_CS_Cont_BW, rich_CS_Cont_BS, rich_CS_Cont_BC, rich_CS_Cont_BR, rich_CS_Video_TShow, rich_CS_Video_TC, rich_CS_Video_TSC, rich_CS_Video_TFS, rich_CS_Video_TFF, rich_CS_Video_TTA, rich_CS_Video_DShow, rich_CS_Video_DC, rich_CS_Video_DSC, rich_CS_Video_DFS, rich_CS_Video_DFF, rich_CS_Video_DTA, rich_CS_Video_Show, rich_CS_Video_W, rich_CS_Video_H, rich_CS_LFS, rich_CS_LFF, rich_CS_LC, rich_CS_LT, rich_CS_LBgC, rich_CS_LBC, rich_CS_LBR, rich_CS_LPos, rich_CS_LHBgC, rich_CS_LHC, rich_CS_Video_ArrShow, rich_CS_AFS, rich_CS_AC, rich_CS_Icon, rich_CS_Link_BW, rich_CS_Link_BS) VALUES (%d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", '', $rw_new_copy_id, $rw_get_copy_theme["slider_name"], $rw_theme_options_object->rich_web_slider_type, $rw_theme_options_object->rich_CS_BIB, $rw_theme_options_object->rich_CS_P, $rw_theme_options_object->rich_CS_Loop, $rw_theme_options_object->rich_CS_SD, $rw_theme_options_object->rich_CS_AT, $rw_theme_options_object->rich_CS_Cont_BgC, $rw_theme_options_object->rich_CS_Cont_BSC, $rw_theme_options_object->rich_CS_Cont_W, $rw_theme_options_object->rich_CS_Cont_H, $rw_theme_options_object->rich_CS_Cont_Op, $rw_theme_options_object->rich_CS_Cont_BW, $rw_theme_options_object->rich_CS_Cont_BS, $rw_theme_options_object->rich_CS_Cont_BC, $rw_theme_options_object->rich_CS_Cont_BR, $rw_theme_options_object->rich_CS_Video_TShow, $rw_theme_options_object->rich_CS_Video_TC, $rw_theme_options_object->rich_CS_Video_TSC, $rw_theme_options_object->rich_CS_Video_TFS, $rw_theme_options_object->rich_CS_Video_TFF, $rw_theme_options_object->rich_CS_Video_TTA, $rw_theme_options_object->rich_CS_Video_DShow, $rw_theme_options_object->rich_CS_Video_DC, $rw_theme_options_object->rich_CS_Video_DSC, $rw_theme_options_object->rich_CS_Video_DFS, $rw_theme_options_object->rich_CS_Video_DFF, $rw_theme_options_object->rich_CS_Video_DTA, $rw_theme_options_object->rich_CS_Video_Show, $rw_theme_options_object->rich_CS_Video_W, $rw_theme_options_object->rich_CS_Video_H, $rw_theme_options_object->rich_CS_LFS, $rw_theme_options_object->rich_CS_LFF, $rw_theme_options_object->rich_CS_LC, $rw_theme_options_object->rich_CS_LT, $rw_theme_options_object->rich_CS_LBgC, $rw_theme_options_object->rich_CS_LBC, $rw_theme_options_object->rich_CS_LBR, $rw_theme_options_object->rich_CS_LPos, $rw_theme_options_object->rich_CS_LHBgC, $rw_theme_options_object->rich_CS_LHC, $rw_theme_options_object->rich_CS_Video_ArrShow, $rw_theme_options_object->rich_CS_AFS, $rw_theme_options_object->rich_CS_AC, $rw_theme_options_object->rich_CS_Icon, $rw_theme_options_object->rich_CS_Link_BW, $rw_theme_options_object->rich_CS_Link_BS));
			$rw_theme_options_loader_object=$wpdb->get_row($wpdb->prepare("SELECT * FROM $rw_slider_image_content_loader WHERE rich_web_slider_ID=%s", $rw_copy_id));
			$wpdb->query($wpdb->prepare("INSERT INTO $rw_slider_image_content_loader (id, rich_web_slider_ID, Rich_Web_ContSl_L_Show, Rich_Web_ContSl_LT_Show, Rich_Web_ContSl_LT, Rich_Web_ContSl_L_BgC, Rich_Web_ContSl_L_T, Rich_Web_ContSl_LT_T, Rich_Web_ContSl_LT_FS, Rich_Web_ContSl_LT_FF, Rich_Web_ContSl_LT_C, Rich_Web_ContSl_L_T1_C, Rich_Web_ContSl_L_T2_C, Rich_Web_ContSl_L_T3_C, Rich_Web_ContSl_LT_T2_BC, Rich_Web_ContSl_L_C, Rich_Web_ContSl_LT_T2_AnC, Rich_Web_ContSl_LT_T3_BgC, Rich_Web_ContSl_L_S, Rich_Web_ContSl_Loading_Show) VALUES (%d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", '', $rw_new_copy_id, $rw_theme_options_loader_object->Rich_Web_ContSl_L_Show, $rw_theme_options_loader_object->Rich_Web_ContSl_LT_Show, $rw_theme_options_loader_object->Rich_Web_ContSl_LT, $rw_theme_options_loader_object->Rich_Web_ContSl_L_BgC, $rw_theme_options_loader_object->Rich_Web_ContSl_L_T, $rw_theme_options_loader_object->Rich_Web_ContSl_LT_T, $rw_theme_options_loader_object->Rich_Web_ContSl_LT_FS, $rw_theme_options_loader_object->Rich_Web_ContSl_LT_FF, $rw_theme_options_loader_object->Rich_Web_ContSl_LT_C, $rw_theme_options_loader_object->Rich_Web_ContSl_L_T1_C, $rw_theme_options_loader_object->Rich_Web_ContSl_L_T2_C, $rw_theme_options_loader_object->Rich_Web_ContSl_L_T3_C, $rw_theme_options_loader_object->Rich_Web_ContSl_LT_T2_BC, $rw_theme_options_loader_object->Rich_Web_ContSl_L_C, $rw_theme_options_loader_object->Rich_Web_ContSl_LT_T2_AnC,  $rw_theme_options_loader_object->Rich_Web_ContSl_LT_T3_BgC,  $rw_theme_options_loader_object->Rich_Web_ContSl_L_S,  $rw_theme_options_loader_object->Rich_Web_ContSl_Loading_Show));
		}else if($rw_get_copy_theme["slider_type"]=='Fashion Slider'){
			$rw_theme_options_object=$wpdb->get_row($wpdb->prepare("SELECT * FROM ".RW_SLIDER_IMAGE_FASHION." WHERE rich_web_slider_ID=%s", $rw_copy_id));
			$wpdb->query($wpdb->prepare("INSERT INTO ".RW_SLIDER_IMAGE_FASHION." (id, rich_web_slider_ID, rich_web_slider_name, rich_web_slider_type, rich_fsl_animation, rich_fsl_SShow, rich_fsl_SShow_Speed, rich_fsl_Anim_Dur, rich_fsl_Ic_Show, rich_fsl_PPL_Show, rich_fsl_Randomize, rich_fsl_Loop, rich_fsl_Width, rich_fsl_Height, rich_fsl_Border_Width, rich_fsl_Border_Style, rich_fsl_Border_Color, rich_fsl_Box_Shadow, rich_fsl_Shadow_Color, rich_fsl_Desc_Show, rich_fsl_Desc_Size, rich_fsl_Desc_Color, rich_fsl_Desc_Font_Family, rich_fsl_Desc_Text_Align, rich_fsl_Desc_Bg_Color, rich_fsl_Title_Font_Size, rich_fsl_Title_Color, rich_fsl_Title_Text_Shadow, rich_fsl_Title_Font_Family, rich_fsl_Title_Text_Align, rich_fsl_Link_Text, rich_fsl_Link_Border_Width, rich_fsl_Link_Border_Style, rich_fsl_Link_Border_Color, rich_fsl_Link_Font_Size, rich_fsl_Link_Color, rich_fsl_Link_Font_Family, rich_fsl_Link_Bg_Color, rich_fsl_Link_Hover_Border_Color, rich_fsl_Link_Hover_Bg_Color, rich_fsl_Link_Hover_Color, rich_fsl_Icon_Size, rich_fsl_Icon_Type, rich_fsl_Hover_Icon_Type) VALUES (%d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", '', $rw_new_copy_id, $rw_get_copy_theme["slider_name"], $rw_theme_options_object->rich_web_slider_type, $rw_theme_options_object->rich_fsl_animation, $rw_theme_options_object->rich_fsl_SShow, $rw_theme_options_object->rich_fsl_SShow_Speed, $rw_theme_options_object->rich_fsl_Anim_Dur, $rw_theme_options_object->rich_fsl_Ic_Show, $rw_theme_options_object->rich_fsl_PPL_Show, $rw_theme_options_object->rich_fsl_Randomize, $rw_theme_options_object->rich_fsl_Loop, $rw_theme_options_object->rich_fsl_Width, $rw_theme_options_object->rich_fsl_Height, $rw_theme_options_object->rich_fsl_Border_Width, $rw_theme_options_object->rich_fsl_Border_Style, $rw_theme_options_object->rich_fsl_Border_Color, $rw_theme_options_object->rich_fsl_Box_Shadow, $rw_theme_options_object->rich_fsl_Shadow_Color, $rw_theme_options_object->rich_fsl_Desc_Show, $rw_theme_options_object->rich_fsl_Desc_Size, $rw_theme_options_object->rich_fsl_Desc_Color, $rw_theme_options_object->rich_fsl_Desc_Font_Family, $rw_theme_options_object->rich_fsl_Desc_Text_Align, $rw_theme_options_object->rich_fsl_Desc_Bg_Color, $rw_theme_options_object->rich_fsl_Title_Font_Size, $rw_theme_options_object->rich_fsl_Title_Color, $rw_theme_options_object->rich_fsl_Title_Text_Shadow, $rw_theme_options_object->rich_fsl_Title_Font_Family, $rw_theme_options_object->rich_fsl_Title_Text_Align, $rw_theme_options_object->rich_fsl_Link_Text, $rw_theme_options_object->rich_fsl_Link_Border_Width, $rw_theme_options_object->rich_fsl_Link_Border_Style, $rw_theme_options_object->rich_fsl_Link_Border_Color, $rw_theme_options_object->rich_fsl_Link_Font_Size, $rw_theme_options_object->rich_fsl_Link_Color, $rw_theme_options_object->rich_fsl_Link_Font_Family, $rw_theme_options_object->rich_fsl_Link_Bg_Color, $rw_theme_options_object->rich_fsl_Link_Hover_Border_Color, $rw_theme_options_object->rich_fsl_Link_Hover_Bg_Color, $rw_theme_options_object->rich_fsl_Link_Hover_Color, $rw_theme_options_object->rich_fsl_Icon_Size, $rw_theme_options_object->rich_fsl_Icon_Type, $rw_theme_options_object->rich_fsl_Hover_Icon_Type));
			$rw_theme_options_loader_object=$wpdb->get_row($wpdb->prepare("SELECT * FROM $rw_slider_image_fashion_loader WHERE rich_web_slider_ID=%s", $rw_copy_id));
			$wpdb->query($wpdb->prepare("INSERT INTO $rw_slider_image_fashion_loader (id, rich_web_slider_ID, Rich_Web_FSl_L_Show, Rich_Web_FSl_LT_Show, Rich_Web_FSl_LT, Rich_Web_FSl_L_BgC, Rich_Web_FSl_L_T, Rich_Web_FSl_LT_T, Rich_Web_FSl_LT_FS, Rich_Web_FSl_LT_FF, Rich_Web_FSl_LT_C, Rich_Web_FSl_L_T1_C, Rich_Web_FSl_L_T2_C, Rich_Web_FSl_L_T3_C, Rich_Web_FSl_LT_T2_BC, Rich_Web_FSl_L_C, Rich_Web_FSl_LT_T2_AnC, Rich_Web_FSl_LT_T3_BgC, Rich_Web_FSl_L_S, Rich_Web_FSl_Loading_Show) VALUES (%d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", '', $rw_new_copy_id, $rw_theme_options_loader_object->Rich_Web_FSl_L_Show, $rw_theme_options_loader_object->Rich_Web_FSl_LT_Show, $rw_theme_options_loader_object->Rich_Web_FSl_LT, $rw_theme_options_loader_object->Rich_Web_FSl_L_BgC, $rw_theme_options_loader_object->Rich_Web_FSl_L_T, $rw_theme_options_loader_object->Rich_Web_FSl_LT_T, $rw_theme_options_loader_object->Rich_Web_FSl_LT_FS, $rw_theme_options_loader_object->Rich_Web_FSl_LT_FF, $rw_theme_options_loader_object->Rich_Web_FSl_LT_C, $rw_theme_options_loader_object->Rich_Web_FSl_L_T1_C, $rw_theme_options_loader_object->Rich_Web_FSl_L_T2_C, $rw_theme_options_loader_object->Rich_Web_FSl_L_T3_C, $rw_theme_options_loader_object->Rich_Web_FSl_LT_T2_BC, $rw_theme_options_loader_object->Rich_Web_FSl_L_C, $rw_theme_options_loader_object->Rich_Web_FSl_LT_T2_AnC,  $rw_theme_options_loader_object->Rich_Web_FSl_LT_T3_BgC,  $rw_theme_options_loader_object->Rich_Web_FSl_L_S,  $rw_theme_options_loader_object->Rich_Web_FSl_Loading_Show));
		}else if($rw_get_copy_theme["slider_type"]=='Circle Thumbnails'){
			$rw_theme_options_object=$wpdb->get_row($wpdb->prepare("SELECT * FROM ".RW_SLIDER_IMAGE_CIRCLE." WHERE rich_web_slider_ID=%s", $rw_copy_id));
			$wpdb->query($wpdb->prepare("INSERT INTO ".RW_SLIDER_IMAGE_CIRCLE." (id, rich_web_slider_ID, rich_web_slider_name, rich_web_slider_type, Rich_Web_Sl_CT_W, Rich_Web_Sl_CT_H, Rich_Web_Sl_CT_BW, Rich_Web_Sl_CT_BS, Rich_Web_Sl_CT_BC, Rich_Web_Sl_CT_BxSShow, Rich_Web_Sl_CT_BxSType, Rich_Web_Sl_CT_BxS, Rich_Web_Sl_CT_BxC, Rich_Web_Sl_CT_TDABgC, Rich_Web_Sl_CT_TDAPos, Rich_Web_Sl_CT_LBgC, Rich_Web_Sl_CT_TFS, Rich_Web_Sl_CT_TFF, Rich_Web_Sl_CT_TCC, Rich_Web_Sl_CT_TC, Rich_Web_Sl_CT_ArBgC, Rich_Web_Sl_CT_ArBR, Rich_Web_Sl_CT_ArType, Rich_Web_Sl_CT_ArHBC, Rich_Web_Sl_CT_ArHBR, Rich_Web_Sl_CT_ArText, Rich_Web_Sl_CT_ArLeft, Rich_Web_Sl_CT_ArRight, Rich_Web_Sl_CT_ArTextC, Rich_Web_Sl_CT_ArTextFS, Rich_Web_Sl_CT_ArTextFF) VALUES (%d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", '', $rw_new_copy_id, $rw_get_copy_theme["slider_name"], $rw_theme_options_object->rich_web_slider_type, $rw_theme_options_object->Rich_Web_Sl_CT_W, $rw_theme_options_object->Rich_Web_Sl_CT_H, $rw_theme_options_object->Rich_Web_Sl_CT_BW, $rw_theme_options_object->Rich_Web_Sl_CT_BS, $rw_theme_options_object->Rich_Web_Sl_CT_BC, $rw_theme_options_object->Rich_Web_Sl_CT_BxSShow, $rw_theme_options_object->Rich_Web_Sl_CT_BxSType, $rw_theme_options_object->Rich_Web_Sl_CT_BxS, $rw_theme_options_object->Rich_Web_Sl_CT_BxC, $rw_theme_options_object->Rich_Web_Sl_CT_TDABgC, $rw_theme_options_object->Rich_Web_Sl_CT_TDAPos, $rw_theme_options_object->Rich_Web_Sl_CT_LBgC, $rw_theme_options_object->Rich_Web_Sl_CT_TFS, $rw_theme_options_object->Rich_Web_Sl_CT_TFF, $rw_theme_options_object->Rich_Web_Sl_CT_TCC, $rw_theme_options_object->Rich_Web_Sl_CT_TC, $rw_theme_options_object->Rich_Web_Sl_CT_ArBgC, $rw_theme_options_object->Rich_Web_Sl_CT_ArBR, $rw_theme_options_object->Rich_Web_Sl_CT_ArType, $rw_theme_options_object->Rich_Web_Sl_CT_ArHBC, $rw_theme_options_object->Rich_Web_Sl_CT_ArHBR, $rw_theme_options_object->Rich_Web_Sl_CT_ArText, $rw_theme_options_object->Rich_Web_Sl_CT_ArLeft, $rw_theme_options_object->Rich_Web_Sl_CT_ArRight, $rw_theme_options_object->Rich_Web_Sl_CT_ArTextC, $rw_theme_options_object->Rich_Web_Sl_CT_ArTextFS, $rw_theme_options_object->Rich_Web_Sl_CT_ArTextFF));
			$rw_theme_options_loader_object=$wpdb->get_row($wpdb->prepare("SELECT * FROM $rw_slider_image_circle_loader WHERE rich_web_slider_ID=%s", $rw_copy_id));
			$wpdb->query($wpdb->prepare("INSERT INTO $rw_slider_image_circle_loader (id, rich_web_slider_ID, Rich_Web_CircleSl_L_Show, Rich_Web_CircleSl_LT_Show, Rich_Web_CircleSl_LT, Rich_Web_CircleSl_L_BgC, Rich_Web_CircleSl_L_T, Rich_Web_CircleSl_LT_T, Rich_Web_CircleSl_LT_FS, Rich_Web_CircleSl_LT_FF, Rich_Web_CircleSl_LT_C, Rich_Web_CircleSl_L_T1_C, Rich_Web_CircleSl_L_T2_C, Rich_Web_CircleSl_L_T3_C, Rich_Web_CircleSl_LT_T2_BC, Rich_Web_CircleSl_L_C, Rich_Web_CircleSl_LT_T2_AnC, Rich_Web_CircleSl_LT_T3_BgC, Rich_Web_CircleSl_L_S, Rich_Web_CircleSl_Loading_Show) VALUES (%d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", '', $rw_new_copy_id, $rw_theme_options_loader_object->Rich_Web_CircleSl_L_Show, $rw_theme_options_loader_object->Rich_Web_CircleSl_LT_Show, $rw_theme_options_loader_object->Rich_Web_CircleSl_LT, $rw_theme_options_loader_object->Rich_Web_CircleSl_L_BgC, $rw_theme_options_loader_object->Rich_Web_CircleSl_L_T, $rw_theme_options_loader_object->Rich_Web_CircleSl_LT_T, $rw_theme_options_loader_object->Rich_Web_CircleSl_LT_FS, $rw_theme_options_loader_object->Rich_Web_CircleSl_LT_FF, $rw_theme_options_loader_object->Rich_Web_CircleSl_LT_C, $rw_theme_options_loader_object->Rich_Web_CircleSl_L_T1_C, $rw_theme_options_loader_object->Rich_Web_CircleSl_L_T2_C, $rw_theme_options_loader_object->Rich_Web_CircleSl_L_T3_C, $rw_theme_options_loader_object->Rich_Web_CircleSl_LT_T2_BC, $rw_theme_options_loader_object->Rich_Web_CircleSl_L_C, $rw_theme_options_loader_object->Rich_Web_CircleSl_LT_T2_AnC,  $rw_theme_options_loader_object->Rich_Web_CircleSl_LT_T3_BgC,  $rw_theme_options_loader_object->Rich_Web_CircleSl_L_S,  $rw_theme_options_loader_object->Rich_Web_CircleSl_Loading_Show));
		}else if($rw_get_copy_theme["slider_type"]=='Slider Carousel'){
			$rw_theme_options_object=$wpdb->get_row($wpdb->prepare("SELECT * FROM ".RW_SLIDER_IMAGE_CAROUSEL." WHERE rich_web_slider_ID=%s", $rw_copy_id));
			$wpdb->query($wpdb->prepare("INSERT INTO ".RW_SLIDER_IMAGE_CAROUSEL." (id, rich_web_slider_ID, rich_web_slider_name, rich_web_slider_type, Rich_Web_Sl_SC_BW, Rich_Web_Sl_SC_BS, Rich_Web_Sl_SC_BC, Rich_Web_Sl_SC_BoxShShow, Rich_Web_Sl_SC_BoxShType, Rich_Web_Sl_SC_BoxSh, Rich_Web_Sl_SC_BoxShC, Rich_Web_Sl_SC_IW, Rich_Web_Sl_SC_IH, Rich_Web_Sl_SC_IBW, Rich_Web_Sl_SC_IBS, Rich_Web_Sl_SC_IBC, Rich_Web_Sl_SC_IBR, Rich_Web_Sl_SC_ICBW, Rich_Web_Sl_SC_ICBS, Rich_Web_Sl_SC_ICBC, Rich_Web_Sl_SC_TBgC, Rich_Web_Sl_SC_TC, Rich_Web_Sl_SC_TFS, Rich_Web_Sl_SC_TFF, Rich_Web_Sl_SC_THBgC, Rich_Web_Sl_SC_THC, Rich_Web_Sl_SC_Pop_OC, Rich_Web_Sl_SC_Pop_BW, Rich_Web_Sl_SC_Pop_BC, Rich_Web_Sl_SC_Pop_BoxShShow, Rich_Web_Sl_SC_Pop_BoxShType, Rich_Web_Sl_SC_Pop_BoxSh, Rich_Web_Sl_SC_Pop_BoxShC, Rich_Web_Sl_SC_L_BgC, Rich_Web_Sl_SC_L_C, Rich_Web_Sl_SC_L_FS, Rich_Web_Sl_SC_L_BW, Rich_Web_Sl_SC_L_BS, Rich_Web_Sl_SC_L_BC, Rich_Web_Sl_SC_L_BR, Rich_Web_Sl_SC_L_HBgC, Rich_Web_Sl_SC_L_HC, Rich_Web_Sl_SC_L_Type, Rich_Web_Sl_SC_L_Text, Rich_Web_Sl_SC_L_IType, Rich_Web_Sl_SC_L_FF, Rich_Web_Sl_SC_PI_BgC, Rich_Web_Sl_SC_PI_C, Rich_Web_Sl_SC_PI_FS, Rich_Web_Sl_SC_PI_BW, Rich_Web_Sl_SC_PI_BS, Rich_Web_Sl_SC_PI_BC, Rich_Web_Sl_SC_PI_BR, Rich_Web_Sl_SC_PI_HBgC, Rich_Web_Sl_SC_PI_HC, Rich_Web_Sl_SC_PI_Type, Rich_Web_Sl_SC_PI_Text, Rich_Web_Sl_SC_PI_IType, Rich_Web_Sl_SC_PI_FF, Rich_Web_Sl_SC_Arr_BgC, Rich_Web_Sl_SC_Arr_C, Rich_Web_Sl_SC_Arr_FS, Rich_Web_Sl_SC_Arr_BW, Rich_Web_Sl_SC_Arr_BS, Rich_Web_Sl_SC_Arr_BC, Rich_Web_Sl_SC_Arr_BR, Rich_Web_Sl_SC_Arr_HBgC, Rich_Web_Sl_SC_Arr_HC, Rich_Web_Sl_SC_Arr_Type, Rich_Web_Sl_SC_Arr_FF, Rich_Web_Sl_SC_Arr_IType, Rich_Web_Sl_SC_Arr_Next, Rich_Web_Sl_SC_Arr_Prev, Rich_Web_Sl_SC_PCI_FS, Rich_Web_Sl_SC_PCI_C, Rich_Web_Sl_SC_PCI_Type) VALUES (%d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", '', $rw_new_copy_id, $rw_get_copy_theme["slider_name"], $rw_theme_options_object->rich_web_slider_type, $rw_theme_options_object->Rich_Web_Sl_SC_BW, $rw_theme_options_object->Rich_Web_Sl_SC_BS, $rw_theme_options_object->Rich_Web_Sl_SC_BC, $rw_theme_options_object->Rich_Web_Sl_SC_BoxShShow, $rw_theme_options_object->Rich_Web_Sl_SC_BoxShType, $rw_theme_options_object->Rich_Web_Sl_SC_BoxSh, $rw_theme_options_object->Rich_Web_Sl_SC_BoxShC, $rw_theme_options_object->Rich_Web_Sl_SC_IW, $rw_theme_options_object->Rich_Web_Sl_SC_IH, $rw_theme_options_object->Rich_Web_Sl_SC_IBW, $rw_theme_options_object->Rich_Web_Sl_SC_IBS, $rw_theme_options_object->Rich_Web_Sl_SC_IBC, $rw_theme_options_object->Rich_Web_Sl_SC_IBR, $rw_theme_options_object->Rich_Web_Sl_SC_ICBW, $rw_theme_options_object->Rich_Web_Sl_SC_ICBS, $rw_theme_options_object->Rich_Web_Sl_SC_ICBC, $rw_theme_options_object->Rich_Web_Sl_SC_TBgC, $rw_theme_options_object->Rich_Web_Sl_SC_TC, $rw_theme_options_object->Rich_Web_Sl_SC_TFS, $rw_theme_options_object->Rich_Web_Sl_SC_TFF, $rw_theme_options_object->Rich_Web_Sl_SC_THBgC, $rw_theme_options_object->Rich_Web_Sl_SC_THC, $rw_theme_options_object->Rich_Web_Sl_SC_Pop_OC, $rw_theme_options_object->Rich_Web_Sl_SC_Pop_BW, $rw_theme_options_object->Rich_Web_Sl_SC_Pop_BC, $rw_theme_options_object->Rich_Web_Sl_SC_Pop_BoxShShow, $rw_theme_options_object->Rich_Web_Sl_SC_Pop_BoxShType, $rw_theme_options_object->Rich_Web_Sl_SC_Pop_BoxSh, $rw_theme_options_object->Rich_Web_Sl_SC_Pop_BoxShC, $rw_theme_options_object->Rich_Web_Sl_SC_L_BgC, $rw_theme_options_object->Rich_Web_Sl_SC_L_C, $rw_theme_options_object->Rich_Web_Sl_SC_L_FS, $rw_theme_options_object->Rich_Web_Sl_SC_L_BW, $rw_theme_options_object->Rich_Web_Sl_SC_L_BS, $rw_theme_options_object->Rich_Web_Sl_SC_L_BC, $rw_theme_options_object->Rich_Web_Sl_SC_L_BR, $rw_theme_options_object->Rich_Web_Sl_SC_L_HBgC, $rw_theme_options_object->Rich_Web_Sl_SC_L_HC, $rw_theme_options_object->Rich_Web_Sl_SC_L_Type, $rw_theme_options_object->Rich_Web_Sl_SC_L_Text, $rw_theme_options_object->Rich_Web_Sl_SC_L_IType, $rw_theme_options_object->Rich_Web_Sl_SC_L_FF, $rw_theme_options_object->Rich_Web_Sl_SC_PI_BgC, $rw_theme_options_object->Rich_Web_Sl_SC_PI_C, $rw_theme_options_object->Rich_Web_Sl_SC_PI_FS, $rw_theme_options_object->Rich_Web_Sl_SC_PI_BW, $rw_theme_options_object->Rich_Web_Sl_SC_PI_BS, $rw_theme_options_object->Rich_Web_Sl_SC_PI_BC, $rw_theme_options_object->Rich_Web_Sl_SC_PI_BR, $rw_theme_options_object->Rich_Web_Sl_SC_PI_HBgC, $rw_theme_options_object->Rich_Web_Sl_SC_PI_HC, $rw_theme_options_object->Rich_Web_Sl_SC_PI_Type, $rw_theme_options_object->Rich_Web_Sl_SC_PI_Text, $rw_theme_options_object->Rich_Web_Sl_SC_PI_IType, $rw_theme_options_object->Rich_Web_Sl_SC_PI_FF, $rw_theme_options_object->Rich_Web_Sl_SC_Arr_BgC, $rw_theme_options_object->Rich_Web_Sl_SC_Arr_C, $rw_theme_options_object->Rich_Web_Sl_SC_Arr_FS, $rw_theme_options_object->Rich_Web_Sl_SC_Arr_BW, $rw_theme_options_object->Rich_Web_Sl_SC_Arr_BS, $rw_theme_options_object->Rich_Web_Sl_SC_Arr_BC, $rw_theme_options_object->Rich_Web_Sl_SC_Arr_BR, $rw_theme_options_object->Rich_Web_Sl_SC_Arr_HBgC, $rw_theme_options_object->Rich_Web_Sl_SC_Arr_HC, $rw_theme_options_object->Rich_Web_Sl_SC_Arr_Type, $rw_theme_options_object->Rich_Web_Sl_SC_Arr_FF, $rw_theme_options_object->Rich_Web_Sl_SC_Arr_IType, $rw_theme_options_object->Rich_Web_Sl_SC_Arr_Next, $rw_theme_options_object->Rich_Web_Sl_SC_Arr_Prev, $rw_theme_options_object->Rich_Web_Sl_SC_PCI_FS, $rw_theme_options_object->Rich_Web_Sl_SC_PCI_C, $rw_theme_options_object->Rich_Web_Sl_SC_PCI_Type));
			$rw_theme_options_loader_object=$wpdb->get_row($wpdb->prepare("SELECT * FROM $rw_slider_image_carousel_loader WHERE rich_web_slider_ID=%s", $rw_copy_id));
			$wpdb->query($wpdb->prepare("INSERT INTO $rw_slider_image_carousel_loader (id, rich_web_slider_ID, Rich_Web_CarSl_L_Show, Rich_Web_CarSl_LT_Show, Rich_Web_CarSl_LT, Rich_Web_CarSl_L_BgC, Rich_Web_CarSl_L_T, Rich_Web_CarSl_LT_T, Rich_Web_CarSl_LT_FS, Rich_Web_CarSl_LT_FF, Rich_Web_CarSl_LT_C, Rich_Web_CarSl_L_T1_C, Rich_Web_CarSl_L_T2_C, Rich_Web_CarSl_L_T3_C, Rich_Web_CarSl_LT_T2_BC, Rich_Web_CarSl_L_C, Rich_Web_CarSl_LT_T2_AnC, Rich_Web_CarSl_LT_T3_BgC, Rich_Web_CarSl_HT, Rich_Web_CarSl_H_OvC, Rich_Web_CarSl_L_S, Rich_Web_CarSl_Loading_Show) VALUES (%d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", '', $rw_new_copy_id, $rw_theme_options_loader_object->Rich_Web_CarSl_L_Show, $rw_theme_options_loader_object->Rich_Web_CarSl_LT_Show, $rw_theme_options_loader_object->Rich_Web_CarSl_LT, $rw_theme_options_loader_object->Rich_Web_CarSl_L_BgC, $rw_theme_options_loader_object->Rich_Web_CarSl_L_T, $rw_theme_options_loader_object->Rich_Web_CarSl_LT_T, $rw_theme_options_loader_object->Rich_Web_CarSl_LT_FS, $rw_theme_options_loader_object->Rich_Web_CarSl_LT_FF, $rw_theme_options_loader_object->Rich_Web_CarSl_LT_C, $rw_theme_options_loader_object->Rich_Web_CarSl_L_T1_C, $rw_theme_options_loader_object->Rich_Web_CarSl_L_T2_C, $rw_theme_options_loader_object->Rich_Web_CarSl_L_T3_C, $rw_theme_options_loader_object->Rich_Web_CarSl_LT_T2_BC, $rw_theme_options_loader_object->Rich_Web_CarSl_L_C, $rw_theme_options_loader_object->Rich_Web_CarSl_LT_T2_AnC,  $rw_theme_options_loader_object->Rich_Web_CarSl_LT_T3_BgC,  $rw_theme_options_loader_object->Rich_Web_CarSl_HT,  $rw_theme_options_loader_object->Rich_Web_CarSl_H_OvC,  $rw_theme_options_loader_object->Rich_Web_CarSl_L_S,  $rw_theme_options_loader_object->Rich_Web_CarSl_Loading_Show));
		}else if($rw_get_copy_theme["slider_type"]=='Flexible Slider'){
			$rw_theme_options_object=$wpdb->get_row($wpdb->prepare("SELECT * FROM ".RW_SLIDER_IMAGE_FLEXIBLE." WHERE rich_web_slider_ID=%s", $rw_copy_id));
			$wpdb->query($wpdb->prepare("INSERT INTO ".RW_SLIDER_IMAGE_FLEXIBLE." (id, rich_web_slider_ID, rich_web_slider_name, rich_web_slider_type, Rich_Web_Sl_FS_BgC, Rich_Web_Sl_FS_AP, Rich_Web_Sl_FS_TS, Rich_Web_Sl_FS_PT, Rich_Web_Sl_FS_SS, Rich_Web_Sl_FS_SVis, Rich_Web_Sl_FS_CS, Rich_Web_Sl_FS_SLoop, Rich_Web_Sl_FS_SSc, Rich_Web_Sl_FS_SlPos, Rich_Web_Sl_FS_ShNavBut, Rich_Web_Sl_FS_I_W, Rich_Web_Sl_FS_I_H, Rich_Web_Sl_FS_I_BW, Rich_Web_Sl_FS_I_BS, Rich_Web_Sl_FS_I_BC, Rich_Web_Sl_FS_I_BR, Rich_Web_Sl_FS_I_BoxShShow, Rich_Web_Sl_FS_I_BoxShType, Rich_Web_Sl_FS_I_BoxSh, Rich_Web_Sl_FS_I_BoxShC, Rich_Web_Sl_FS_T_C, Rich_Web_Sl_FS_T_FF, Rich_Web_Sl_FS_Nav_Show, Rich_Web_Sl_FS_Nav_W, Rich_Web_Sl_FS_Nav_H, Rich_Web_Sl_FS_Nav_BW, Rich_Web_Sl_FS_Nav_BS, Rich_Web_Sl_FS_Nav_BC, Rich_Web_Sl_FS_Nav_BR, Rich_Web_Sl_FS_Nav_PB, Rich_Web_Sl_FS_Nav_CC, Rich_Web_Sl_FS_Nav_HC, Rich_Web_Sl_FS_Nav_C, Rich_Web_Sl_FS_Arr_Show, Rich_Web_Sl_FS_Arr_Type, Rich_Web_Sl_FS_Arr_S, Rich_Web_Sl_FS_Arr_C) VALUES (%d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", '', $rw_new_copy_id, $rw_get_copy_theme["slider_name"], $rw_theme_options_object->rich_web_slider_type, $rw_theme_options_object->Rich_Web_Sl_FS_BgC, $rw_theme_options_object->Rich_Web_Sl_FS_AP, $rw_theme_options_object->Rich_Web_Sl_FS_TS, $rw_theme_options_object->Rich_Web_Sl_FS_PT, $rw_theme_options_object->Rich_Web_Sl_FS_SS, $rw_theme_options_object->Rich_Web_Sl_FS_SVis, $rw_theme_options_object->Rich_Web_Sl_FS_CS, $rw_theme_options_object->Rich_Web_Sl_FS_SLoop, $rw_theme_options_object->Rich_Web_Sl_FS_SSc, $rw_theme_options_object->Rich_Web_Sl_FS_SlPos, $rw_theme_options_object->Rich_Web_Sl_FS_ShNavBut, $rw_theme_options_object->Rich_Web_Sl_FS_I_W, $rw_theme_options_object->Rich_Web_Sl_FS_I_H, $rw_theme_options_object->Rich_Web_Sl_FS_I_BW, $rw_theme_options_object->Rich_Web_Sl_FS_I_BS, $rw_theme_options_object->Rich_Web_Sl_FS_I_BC, $rw_theme_options_object->Rich_Web_Sl_FS_I_BR, $rw_theme_options_object->Rich_Web_Sl_FS_I_BoxShShow, $rw_theme_options_object->Rich_Web_Sl_FS_I_BoxShType, $rw_theme_options_object->Rich_Web_Sl_FS_I_BoxSh, $rw_theme_options_object->Rich_Web_Sl_FS_I_BoxShC, $rw_theme_options_object->Rich_Web_Sl_FS_T_C, $rw_theme_options_object->Rich_Web_Sl_FS_T_FF, $rw_theme_options_object->Rich_Web_Sl_FS_Nav_Show, $rw_theme_options_object->Rich_Web_Sl_FS_Nav_W, $rw_theme_options_object->Rich_Web_Sl_FS_Nav_H, $rw_theme_options_object->Rich_Web_Sl_FS_Nav_BW, $rw_theme_options_object->Rich_Web_Sl_FS_Nav_BS, $rw_theme_options_object->Rich_Web_Sl_FS_Nav_BC, $rw_theme_options_object->Rich_Web_Sl_FS_Nav_BR, $rw_theme_options_object->Rich_Web_Sl_FS_Nav_PB, $rw_theme_options_object->Rich_Web_Sl_FS_Nav_CC, $rw_theme_options_object->Rich_Web_Sl_FS_Nav_HC, $rw_theme_options_object->Rich_Web_Sl_FS_Nav_C, $rw_theme_options_object->Rich_Web_Sl_FS_Arr_Show, $rw_theme_options_object->Rich_Web_Sl_FS_Arr_Type, $rw_theme_options_object->Rich_Web_Sl_FS_Arr_S, $rw_theme_options_object->Rich_Web_Sl_FS_Arr_C));
			$rw_theme_options_loader_object=$wpdb->get_row($wpdb->prepare("SELECT * FROM $rw_slider_image_flexible_loader WHERE rich_web_slider_ID=%s", $rw_copy_id));
			$wpdb->query($wpdb->prepare("INSERT INTO $rw_slider_image_flexible_loader (id, rich_web_slider_ID, Rich_Web_FlexibleSl_L_Show, Rich_Web_FlexibleSl_LT_Show, Rich_Web_FlexibleSl_LT, Rich_Web_FlexibleSl_L_BgC, Rich_Web_FlexibleSl_L_T, Rich_Web_FlexibleSl_LT_T, Rich_Web_FlexibleSl_LT_FS, Rich_Web_FlexibleSl_LT_FF, Rich_Web_FlexibleSl_LT_C, Rich_Web_FlexibleSl_L_T1_C, Rich_Web_FlexibleSl_L_T2_C, Rich_Web_FlexibleSl_L_T3_C, Rich_Web_FlexibleSl_LT_T2_BC, Rich_Web_FlexibleSl_L_C, Rich_Web_FlexibleSl_LT_T2_AnC, Rich_Web_FlexibleSl_LT_T3_BgC, Rich_Web_FlexibleSl_L_S, Rich_Web_FlexibleSl_Loading_Show) VALUES (%d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", '', $rw_new_copy_id, $rw_theme_options_loader_object->Rich_Web_FlexibleSl_L_Show, $rw_theme_options_loader_object->Rich_Web_FlexibleSl_LT_Show, $rw_theme_options_loader_object->Rich_Web_FlexibleSl_LT, $rw_theme_options_loader_object->Rich_Web_FlexibleSl_L_BgC, $rw_theme_options_loader_object->Rich_Web_FlexibleSl_L_T, $rw_theme_options_loader_object->Rich_Web_FlexibleSl_LT_T, $rw_theme_options_loader_object->Rich_Web_FlexibleSl_LT_FS, $rw_theme_options_loader_object->Rich_Web_FlexibleSl_LT_FF, $rw_theme_options_loader_object->Rich_Web_FlexibleSl_LT_C, $rw_theme_options_loader_object->Rich_Web_FlexibleSl_L_T1_C, $rw_theme_options_loader_object->Rich_Web_FlexibleSl_L_T2_C, $rw_theme_options_loader_object->Rich_Web_FlexibleSl_L_T3_C, $rw_theme_options_loader_object->Rich_Web_FlexibleSl_LT_T2_BC, $rw_theme_options_loader_object->Rich_Web_FlexibleSl_L_C, $rw_theme_options_loader_object->Rich_Web_FlexibleSl_LT_T2_AnC,  $rw_theme_options_loader_object->Rich_Web_FlexibleSl_LT_T3_BgC,  $rw_theme_options_loader_object->Rich_Web_FlexibleSl_L_S,  $rw_theme_options_loader_object->Rich_Web_FlexibleSl_Loading_Show));
		}else if($rw_get_copy_theme["slider_type"]=='Dynamic Slider'){
			$rw_theme_options_object=$wpdb->get_row($wpdb->prepare("SELECT * FROM ".RW_SLIDER_IMAGE_DYNAMIC." WHERE rich_web_slider_ID=%s", $rw_copy_id));
			$wpdb->query($wpdb->prepare("INSERT INTO ".RW_SLIDER_IMAGE_DYNAMIC." (id, rich_web_slider_ID, rich_web_slider_name, rich_web_slider_type, Rich_Web_Sl_DS_AP, Rich_Web_Sl_DS_PT, Rich_Web_Sl_DS_Tr, Rich_Web_Sl_DS_H, Rich_Web_Sl_DS_BW, Rich_Web_Sl_DS_BS, Rich_Web_Sl_DS_BC, Rich_Web_Sl_DS_TFS, Rich_Web_Sl_DS_TFF, Rich_Web_Sl_DS_TC, Rich_Web_Sl_DS_DFS, Rich_Web_Sl_DS_DFF, Rich_Web_Sl_DS_DC, Rich_Web_Sl_DS_LFS, Rich_Web_Sl_DS_LFF, Rich_Web_Sl_DS_LC, Rich_Web_Sl_DS_LBgC, Rich_Web_Sl_DS_LBW, Rich_Web_Sl_DS_LBS, Rich_Web_Sl_DS_LBC, Rich_Web_Sl_DS_LBR, Rich_Web_Sl_DS_LHC, Rich_Web_Sl_DS_LHBgC, Rich_Web_Sl_DS_LT, Rich_Web_Sl_DS_Arr_Show, Rich_Web_Sl_DS_Arr_LT, Rich_Web_Sl_DS_Arr_RT, Rich_Web_Sl_DS_Arr_C, Rich_Web_Sl_DS_Arr_BgC, Rich_Web_Sl_DS_Arr_BW, Rich_Web_Sl_DS_Arr_BS, Rich_Web_Sl_DS_Arr_BC, Rich_Web_Sl_DS_Arr_BR, Rich_Web_Sl_DS_Arr_HC, Rich_Web_Sl_DS_Arr_HBgC, Rich_Web_Sl_DS_Nav_W, Rich_Web_Sl_DS_Nav_H, Rich_Web_Sl_DS_Nav_PB, Rich_Web_Sl_DS_Nav_BW, Rich_Web_Sl_DS_Nav_BS, Rich_Web_Sl_DS_Nav_BC, Rich_Web_Sl_DS_Nav_BR, Rich_Web_Sl_DS_Nav_C, Rich_Web_Sl_DS_Nav_HC, Rich_Web_Sl_DS_Nav_CC) VALUES (%d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", '', $rw_new_copy_id, $rw_get_copy_theme["slider_name"], $rw_theme_options_object->rich_web_slider_type, $rw_theme_options_object->Rich_Web_Sl_DS_AP, $rw_theme_options_object->Rich_Web_Sl_DS_PT, $rw_theme_options_object->Rich_Web_Sl_DS_Tr, $rw_theme_options_object->Rich_Web_Sl_DS_H, $rw_theme_options_object->Rich_Web_Sl_DS_BW, $rw_theme_options_object->Rich_Web_Sl_DS_BS, $rw_theme_options_object->Rich_Web_Sl_DS_BC, $rw_theme_options_object->Rich_Web_Sl_DS_TFS, $rw_theme_options_object->Rich_Web_Sl_DS_TFF, $rw_theme_options_object->Rich_Web_Sl_DS_TC, $rw_theme_options_object->Rich_Web_Sl_DS_DFS, $rw_theme_options_object->Rich_Web_Sl_DS_DFF, $rw_theme_options_object->Rich_Web_Sl_DS_DC, $rw_theme_options_object->Rich_Web_Sl_DS_LFS, $rw_theme_options_object->Rich_Web_Sl_DS_LFF, $rw_theme_options_object->Rich_Web_Sl_DS_LC, $rw_theme_options_object->Rich_Web_Sl_DS_LBgC, $rw_theme_options_object->Rich_Web_Sl_DS_LBW, $rw_theme_options_object->Rich_Web_Sl_DS_LBS, $rw_theme_options_object->Rich_Web_Sl_DS_LBC, $rw_theme_options_object->Rich_Web_Sl_DS_LBR, $rw_theme_options_object->Rich_Web_Sl_DS_LHC, $rw_theme_options_object->Rich_Web_Sl_DS_LHBgC, $rw_theme_options_object->Rich_Web_Sl_DS_LT, $rw_theme_options_object->Rich_Web_Sl_DS_Arr_Show, $rw_theme_options_object->Rich_Web_Sl_DS_Arr_LT, $rw_theme_options_object->Rich_Web_Sl_DS_Arr_RT, $rw_theme_options_object->Rich_Web_Sl_DS_Arr_C, $rw_theme_options_object->Rich_Web_Sl_DS_Arr_BgC, $rw_theme_options_object->Rich_Web_Sl_DS_Arr_BW, $rw_theme_options_object->Rich_Web_Sl_DS_Arr_BS, $rw_theme_options_object->Rich_Web_Sl_DS_Arr_BC, $rw_theme_options_object->Rich_Web_Sl_DS_Arr_BR, $rw_theme_options_object->Rich_Web_Sl_DS_Arr_HC, $rw_theme_options_object->Rich_Web_Sl_DS_Arr_HBgC, $rw_theme_options_object->Rich_Web_Sl_DS_Nav_W, $rw_theme_options_object->Rich_Web_Sl_DS_Nav_H, $rw_theme_options_object->Rich_Web_Sl_DS_Nav_PB, $rw_theme_options_object->Rich_Web_Sl_DS_Nav_BW, $rw_theme_options_object->Rich_Web_Sl_DS_Nav_BS, $rw_theme_options_object->Rich_Web_Sl_DS_Nav_BC, $rw_theme_options_object->Rich_Web_Sl_DS_Nav_BR, $rw_theme_options_object->Rich_Web_Sl_DS_Nav_C, $rw_theme_options_object->Rich_Web_Sl_DS_Nav_HC, $rw_theme_options_object->Rich_Web_Sl_DS_Nav_CC));
			$rw_theme_options_loader_object=$wpdb->get_row($wpdb->prepare("SELECT * FROM $rw_slider_image_dynamic_loader WHERE rich_web_slider_ID=%s", $rw_copy_id));
			$wpdb->query($wpdb->prepare("INSERT INTO $rw_slider_image_dynamic_loader (id, rich_web_slider_ID, Rich_Web_DynamicSl_L_Show, Rich_Web_DynamicSl_LT_Show, Rich_Web_DynamicSl_LT, Rich_Web_DynamicSl_L_BgC, Rich_Web_DynamicSl_L_T, Rich_Web_DynamicSl_LT_T, Rich_Web_DynamicSl_LT_FS, Rich_Web_DynamicSl_LT_FF, Rich_Web_DynamicSl_LT_C, Rich_Web_DynamicSl_L_T1_C, Rich_Web_DynamicSl_L_T2_C, Rich_Web_DynamicSl_L_T3_C, Rich_Web_DynamicSl_LT_T2_BC, Rich_Web_DynamicSl_L_C, Rich_Web_DynamicSl_LT_T2_AnC, Rich_Web_DynamicSl_LT_T3_BgC, Rich_Web_DynamicSl_ImgT, Rich_Web_DynamicSl_L_S, Rich_Web_DynamicSl_Loading_Show) VALUES (%d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", '', $rw_new_copy_id, $rw_theme_options_loader_object->Rich_Web_DynamicSl_L_Show, $rw_theme_options_loader_object->Rich_Web_DynamicSl_LT_Show, $rw_theme_options_loader_object->Rich_Web_DynamicSl_LT, $rw_theme_options_loader_object->Rich_Web_DynamicSl_L_BgC, $rw_theme_options_loader_object->Rich_Web_DynamicSl_L_T, $rw_theme_options_loader_object->Rich_Web_DynamicSl_LT_T, $rw_theme_options_loader_object->Rich_Web_DynamicSl_LT_FS, $rw_theme_options_loader_object->Rich_Web_DynamicSl_LT_FF, $rw_theme_options_loader_object->Rich_Web_DynamicSl_LT_C, $rw_theme_options_loader_object->Rich_Web_DynamicSl_L_T1_C, $rw_theme_options_loader_object->Rich_Web_DynamicSl_L_T2_C, $rw_theme_options_loader_object->Rich_Web_DynamicSl_L_T3_C, $rw_theme_options_loader_object->Rich_Web_DynamicSl_LT_T2_BC, $rw_theme_options_loader_object->Rich_Web_DynamicSl_L_C, $rw_theme_options_loader_object->Rich_Web_DynamicSl_LT_T2_AnC,  $rw_theme_options_loader_object->Rich_Web_DynamicSl_LT_T3_BgC,  $rw_theme_options_loader_object->Rich_Web_DynamicSl_ImgT,  $rw_theme_options_loader_object->Rich_Web_DynamicSl_L_S,  $rw_theme_options_loader_object->Rich_Web_DynamicSl_Loading_Show));
		}else if($rw_get_copy_theme["slider_type"]=='Thumbnails Slider & Lightbox'){
			$rw_theme_options_object=$wpdb->get_row($wpdb->prepare("SELECT * FROM ".RW_SLIDER_IMAGE_LIGHTBOX." WHERE rich_web_slider_ID=%s", $rw_copy_id));
			$wpdb->query($wpdb->prepare("INSERT INTO ".RW_SLIDER_IMAGE_LIGHTBOX." (id, rich_web_slider_ID, rich_web_slider_name, rich_web_slider_type, Rich_Web_Sl_TSL_W, Rich_Web_Sl_TSL_H, Rich_Web_Sl_TSL_BW, Rich_Web_Sl_TSL_BS, Rich_Web_Sl_TSL_BC, Rich_Web_Sl_TSL_BR, Rich_Web_Sl_TSL_BoxShShow, Rich_Web_Sl_TSL_BoxShType, Rich_Web_Sl_TSL_BoxSh, Rich_Web_Sl_TSL_BoxShC, Rich_Web_Sl_TSL_CM, Rich_Web_Sl_TSL_TA, Rich_Web_Sl_TSL_AP, Rich_Web_Sl_TSL_PH, Rich_Web_Sl_TSL_Loop, Rich_Web_Sl_TSL_PT, Rich_Web_Sl_TSL_CS, Rich_Web_Sl_TSL_Nav_Show, Rich_Web_Sl_TSL_Nav_W, Rich_Web_Sl_TSL_Nav_H, Rich_Web_Sl_TSL_Nav_PB, Rich_Web_Sl_TSL_Nav_BC, Rich_Web_Sl_TSL_Nav_BR, Rich_Web_Sl_TSL_Nav_CBC, Rich_Web_Sl_TSL_Nav_HBC, Rich_Web_Sl_TSL_Nav_Pos, Rich_Web_Sl_TSL_SS_Show, Rich_Web_Sl_TSL_SS_W, Rich_Web_Sl_TSL_SS_H, Rich_Web_Sl_TSL_SS_BC, Rich_Web_Sl_TSL_SS_BR, Rich_Web_Sl_TSL_SS_StC, Rich_Web_Sl_TSL_SS_SpC, Rich_Web_Sl_TSL_Arr_Show, Rich_Web_Sl_TSL_Arr_Type, Rich_Web_Sl_TSL_Arr_S, Rich_Web_Sl_TSL_Arr_C, Rich_Web_Sl_TSL_Pop_OvC, Rich_Web_Sl_TSL_Pop_BW, Rich_Web_Sl_TSL_Pop_BS, Rich_Web_Sl_TSL_Pop_BC, Rich_Web_Sl_TSL_Pop_BR, Rich_Web_Sl_TSL_Pop_BgC, Rich_Web_Sl_TSL_TFS, Rich_Web_Sl_TSL_TFF, Rich_Web_Sl_TSL_TC, Rich_Web_Sl_TSL_Pop_ArrType, Rich_Web_Sl_TSL_Pop_ArrS, Rich_Web_Sl_TSL_Pop_ArrC, Rich_Web_Sl_TSL_CIT, Rich_Web_Sl_TSL_CIS, Rich_Web_Sl_TSL_CIC) VALUES (%d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", '', $rw_new_copy_id, $rw_get_copy_theme["slider_name"], $rw_theme_options_object->rich_web_slider_type, $rw_theme_options_object->Rich_Web_Sl_TSL_W, $rw_theme_options_object->Rich_Web_Sl_TSL_H, $rw_theme_options_object->Rich_Web_Sl_TSL_BW, $rw_theme_options_object->Rich_Web_Sl_TSL_BS, $rw_theme_options_object->Rich_Web_Sl_TSL_BC, $rw_theme_options_object->Rich_Web_Sl_TSL_BR, $rw_theme_options_object->Rich_Web_Sl_TSL_BoxShShow, $rw_theme_options_object->Rich_Web_Sl_TSL_BoxShType, $rw_theme_options_object->Rich_Web_Sl_TSL_BoxSh, $rw_theme_options_object->Rich_Web_Sl_TSL_BoxShC, $rw_theme_options_object->Rich_Web_Sl_TSL_CM, $rw_theme_options_object->Rich_Web_Sl_TSL_TA, $rw_theme_options_object->Rich_Web_Sl_TSL_AP, $rw_theme_options_object->Rich_Web_Sl_TSL_PH, $rw_theme_options_object->Rich_Web_Sl_TSL_Loop, $rw_theme_options_object->Rich_Web_Sl_TSL_PT, $rw_theme_options_object->Rich_Web_Sl_TSL_CS, $rw_theme_options_object->Rich_Web_Sl_TSL_Nav_Show, $rw_theme_options_object->Rich_Web_Sl_TSL_Nav_W, $rw_theme_options_object->Rich_Web_Sl_TSL_Nav_H, $rw_theme_options_object->Rich_Web_Sl_TSL_Nav_PB, $rw_theme_options_object->Rich_Web_Sl_TSL_Nav_BC, $rw_theme_options_object->Rich_Web_Sl_TSL_Nav_BR, $rw_theme_options_object->Rich_Web_Sl_TSL_Nav_CBC, $rw_theme_options_object->Rich_Web_Sl_TSL_Nav_HBC, $rw_theme_options_object->Rich_Web_Sl_TSL_Nav_Pos, $rw_theme_options_object->Rich_Web_Sl_TSL_SS_Show, $rw_theme_options_object->Rich_Web_Sl_TSL_SS_W, $rw_theme_options_object->Rich_Web_Sl_TSL_SS_H, $rw_theme_options_object->Rich_Web_Sl_TSL_SS_BC, $rw_theme_options_object->Rich_Web_Sl_TSL_SS_BR, $rw_theme_options_object->Rich_Web_Sl_TSL_SS_StC, $rw_theme_options_object->Rich_Web_Sl_TSL_SS_SpC, $rw_theme_options_object->Rich_Web_Sl_TSL_Arr_Show, $rw_theme_options_object->Rich_Web_Sl_TSL_Arr_Type, $rw_theme_options_object->Rich_Web_Sl_TSL_Arr_S, $rw_theme_options_object->Rich_Web_Sl_TSL_Arr_C, $rw_theme_options_object->Rich_Web_Sl_TSL_Pop_OvC, $rw_theme_options_object->Rich_Web_Sl_TSL_Pop_BW, $rw_theme_options_object->Rich_Web_Sl_TSL_Pop_BS, $rw_theme_options_object->Rich_Web_Sl_TSL_Pop_BC, $rw_theme_options_object->Rich_Web_Sl_TSL_Pop_BR, $rw_theme_options_object->Rich_Web_Sl_TSL_Pop_BgC, $rw_theme_options_object->Rich_Web_Sl_TSL_TFS, $rw_theme_options_object->Rich_Web_Sl_TSL_TFF, $rw_theme_options_object->Rich_Web_Sl_TSL_TC, $rw_theme_options_object->Rich_Web_Sl_TSL_Pop_ArrType, $rw_theme_options_object->Rich_Web_Sl_TSL_Pop_ArrS, $rw_theme_options_object->Rich_Web_Sl_TSL_Pop_ArrC, $rw_theme_options_object->Rich_Web_Sl_TSL_CIT, $rw_theme_options_object->Rich_Web_Sl_TSL_CIS, $rw_theme_options_object->Rich_Web_Sl_TSL_CIC));
			$rw_theme_options_loader_object=$wpdb->get_row($wpdb->prepare("SELECT * FROM $rw_slider_image_lightbox_loader WHERE rich_web_slider_ID=%s", $rw_copy_id));
			$wpdb->query($wpdb->prepare("INSERT INTO $rw_slider_image_lightbox_loader (id, rich_web_slider_ID, Rich_Web_ThSl_L_Show, Rich_Web_ThSl_LT_Show, Rich_Web_ThSl_LT, Rich_Web_ThSl_L_BgC, Rich_Web_ThSl_L_T, Rich_Web_ThSl_LT_T, Rich_Web_ThSl_LT_FS, Rich_Web_ThSl_LT_FF, Rich_Web_ThSl_LT_C, Rich_Web_ThSl_L_T1_C, Rich_Web_ThSl_L_T2_C, Rich_Web_ThSl_L_T3_C, Rich_Web_ThSl_LT_T2_BC, Rich_Web_ThSl_L_C, Rich_Web_ThSl_LT_T2_AnC, Rich_Web_ThSl_LT_T3_BgC, Rich_Web_ThSl_L_S, Rich_Web_ThSl_Loading_Show) VALUES (%d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", '', $rw_new_copy_id, $rw_theme_options_loader_object->Rich_Web_ThSl_L_Show, $rw_theme_options_loader_object->Rich_Web_ThSl_LT_Show, $rw_theme_options_loader_object->Rich_Web_ThSl_LT, $rw_theme_options_loader_object->Rich_Web_ThSl_L_BgC, $rw_theme_options_loader_object->Rich_Web_ThSl_L_T, $rw_theme_options_loader_object->Rich_Web_ThSl_LT_T, $rw_theme_options_loader_object->Rich_Web_ThSl_LT_FS, $rw_theme_options_loader_object->Rich_Web_ThSl_LT_FF, $rw_theme_options_loader_object->Rich_Web_ThSl_LT_C, $rw_theme_options_loader_object->Rich_Web_ThSl_L_T1_C, $rw_theme_options_loader_object->Rich_Web_ThSl_L_T2_C, $rw_theme_options_loader_object->Rich_Web_ThSl_L_T3_C, $rw_theme_options_loader_object->Rich_Web_ThSl_LT_T2_BC, $rw_theme_options_loader_object->Rich_Web_ThSl_L_C, $rw_theme_options_loader_object->Rich_Web_ThSl_LT_T2_AnC,  $rw_theme_options_loader_object->Rich_Web_ThSl_LT_T3_BgC,  $rw_theme_options_loader_object->Rich_Web_ThSl_L_S,  $rw_theme_options_loader_object->Rich_Web_ThSl_Loading_Show));
		}else if($rw_get_copy_theme["slider_type"]=='Accordion Slider'){
			$rw_theme_options_object=$wpdb->get_row($wpdb->prepare("SELECT * FROM ".RW_SLIDER_IMAGE_ACCORDION." WHERE rich_web_slider_ID=%s", $rw_copy_id));
			$wpdb->query($wpdb->prepare("INSERT INTO ".RW_SLIDER_IMAGE_ACCORDION." (id, rich_web_slider_ID, rich_web_slider_name, rich_web_slider_type, Rich_Web_AcSL_W, Rich_Web_AcSL_H, Rich_Web_AcSL_BW, Rich_Web_AcSL_BS, Rich_Web_AcSL_BC, Rich_Web_AcSL_BSh, Rich_Web_AcSL_BShC, Rich_Web_AcSL_Img_W, Rich_Web_AcSL_Img_BSh, Rich_Web_AcSL_Img_BShC, Rich_Web_AcSL_Title_FS, Rich_Web_AcSL_Title_FF, Rich_Web_AcSL_Title_C, Rich_Web_AcSL_Title_TSh, Rich_Web_AcSL_Title_TShC, Rich_Web_AcSL_Title_BgC, Rich_Web_AcSL_Link_FS, Rich_Web_AcSL_Link_FF, Rich_Web_AcSL_Link_C, Rich_Web_AcSL_Link_TSh, Rich_Web_AcSL_Link_TShC, Rich_Web_AcSL_Link_BgC, Rich_Web_AcSL_Link_Text) VALUES (%d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", '', $rw_new_copy_id, $rw_get_copy_theme["slider_name"], $rw_theme_options_object->rich_web_slider_type, $rw_theme_options_object->Rich_Web_AcSL_W, $rw_theme_options_object->Rich_Web_AcSL_H, $rw_theme_options_object->Rich_Web_AcSL_BW, $rw_theme_options_object->Rich_Web_AcSL_BS, $rw_theme_options_object->Rich_Web_AcSL_BC, $rw_theme_options_object->Rich_Web_AcSL_BSh, $rw_theme_options_object->Rich_Web_AcSL_BShC, $rw_theme_options_object->Rich_Web_AcSL_Img_W, $rw_theme_options_object->Rich_Web_AcSL_Img_BSh, $rw_theme_options_object->Rich_Web_AcSL_Img_BShC, $rw_theme_options_object->Rich_Web_AcSL_Title_FS, $rw_theme_options_object->Rich_Web_AcSL_Title_FF, $rw_theme_options_object->Rich_Web_AcSL_Title_C, $rw_theme_options_object->Rich_Web_AcSL_Title_TSh, $rw_theme_options_object->Rich_Web_AcSL_Title_TShC, $rw_theme_options_object->Rich_Web_AcSL_Title_BgC, $rw_theme_options_object->Rich_Web_AcSL_Link_FS, $rw_theme_options_object->Rich_Web_AcSL_Link_FF, $rw_theme_options_object->Rich_Web_AcSL_Link_C, $rw_theme_options_object->Rich_Web_AcSL_Link_TSh, $rw_theme_options_object->Rich_Web_AcSL_Link_TShC, $rw_theme_options_object->Rich_Web_AcSL_Link_BgC, $rw_theme_options_object->Rich_Web_AcSL_Link_Text));
			$rw_theme_options_loader_object=$wpdb->get_row($wpdb->prepare("SELECT * FROM $rw_slider_image_accordion_loader WHERE rich_web_slider_ID=%s", $rw_copy_id));
			$wpdb->query($wpdb->prepare("INSERT INTO $rw_slider_image_accordion_loader (id, rich_web_slider_ID, Rich_Web_AccSl_L_Show, Rich_Web_AccSl_LT_Show, Rich_Web_AccSl_LT, Rich_Web_AccSl_L_BgC, Rich_Web_AccSl_L_T, Rich_Web_AccSl_LT_T, Rich_Web_AccSl_LT_FS, Rich_Web_AccSl_LT_FF, Rich_Web_AccSl_LT_C, Rich_Web_AccSl_L_T1_C, Rich_Web_AccSl_L_T2_C, Rich_Web_AccSl_L_T3_C, Rich_Web_AccSl_LT_T2_BC, Rich_Web_AccSl_L_C, Rich_Web_AccSl_LT_T2_AnC, Rich_Web_AccSl_LT_T3_BgC, Rich_Web_AccSl_L_S, Rich_Web_AccSl_Loading_Show) VALUES (%d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", '', $rw_new_copy_id, $rw_theme_options_loader_object->Rich_Web_AccSl_L_Show, $rw_theme_options_loader_object->Rich_Web_AccSl_LT_Show, $rw_theme_options_loader_object->Rich_Web_AccSl_LT, $rw_theme_options_loader_object->Rich_Web_AccSl_L_BgC, $rw_theme_options_loader_object->Rich_Web_AccSl_L_T, $rw_theme_options_loader_object->Rich_Web_AccSl_LT_T, $rw_theme_options_loader_object->Rich_Web_AccSl_LT_FS, $rw_theme_options_loader_object->Rich_Web_AccSl_LT_FF, $rw_theme_options_loader_object->Rich_Web_AccSl_LT_C, $rw_theme_options_loader_object->Rich_Web_AccSl_L_T1_C, $rw_theme_options_loader_object->Rich_Web_AccSl_L_T2_C, $rw_theme_options_loader_object->Rich_Web_AccSl_L_T3_C, $rw_theme_options_loader_object->Rich_Web_AccSl_LT_T2_BC, $rw_theme_options_loader_object->Rich_Web_AccSl_L_C, $rw_theme_options_loader_object->Rich_Web_AccSl_LT_T2_AnC,  $rw_theme_options_loader_object->Rich_Web_AccSl_LT_T3_BgC,  $rw_theme_options_loader_object->Rich_Web_AccSl_L_S,  $rw_theme_options_loader_object->Rich_Web_AccSl_Loading_Show));
		}else if($rw_get_copy_theme["slider_type"]=='Animation Slider'){
			$rw_theme_options_object=$wpdb->get_row($wpdb->prepare("SELECT * FROM ".RW_SLIDER_IMAGE_ANIMATION." WHERE rich_web_slider_ID=%s", $rw_copy_id));
			$wpdb->query($wpdb->prepare("INSERT INTO ".RW_SLIDER_IMAGE_ANIMATION." (id, rich_web_slider_ID, rich_web_slider_name, rich_web_slider_type, Rich_Web_AnSL_W, Rich_Web_AnSL_H, Rich_Web_AnSL_BW, Rich_Web_AnSL_BS, Rich_Web_AnSL_BC, Rich_Web_AnSL_BR, Rich_Web_AnSL_BSh, Rich_Web_AnSL_ShC, Rich_Web_AnSL_ET, Rich_Web_AnSL_SSh, Rich_Web_AnSL_SShChT, Rich_Web_AnSL_T_FS, Rich_Web_AnSL_T_FF, Rich_Web_AnSL_T_C, Rich_Web_AnSL_T_BgC, Rich_Web_AnSL_T_TA, Rich_Web_AnSL_T_Sh, Rich_Web_AnSL_T_ShC, Rich_Web_AnSL_N_Sh, Rich_Web_AnSL_N_S, Rich_Web_AnSL_N_BW, Rich_Web_AnSL_N_BC, Rich_Web_AnSL_N_BgC, Rich_Web_AnSL_N_BS, Rich_Web_AnSL_N_HBgC, Rich_Web_AnSL_N_CC, Rich_Web_AnSL_N_M, Rich_Web_AnSL_Ic_Sh, Rich_Web_AnSL_Ic_T, Rich_Web_AnSL_Ic_S, Rich_Web_AnSL_Ic_C, Rich_Web_AnSL_L_BgC, Rich_Web_AnSL_L_T, Rich_Web_AnSL_L_FS, Rich_Web_AnSL_L_FF, Rich_Web_AnSL_L_C, Rich_Web_AnSL_L1_T, Rich_Web_AnSL_L2_T, Rich_Web_AnSL_L3_T) VALUES (%d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", '', $rw_new_copy_id, $rw_get_copy_theme["slider_name"], $rw_theme_options_object->rich_web_slider_type, $rw_theme_options_object->Rich_Web_AnSL_W, $rw_theme_options_object->Rich_Web_AnSL_H, $rw_theme_options_object->Rich_Web_AnSL_BW, $rw_theme_options_object->Rich_Web_AnSL_BS, $rw_theme_options_object->Rich_Web_AnSL_BC, $rw_theme_options_object->Rich_Web_AnSL_BR, $rw_theme_options_object->Rich_Web_AnSL_BSh, $rw_theme_options_object->Rich_Web_AnSL_ShC, $rw_theme_options_object->Rich_Web_AnSL_ET, $rw_theme_options_object->Rich_Web_AnSL_SSh, $rw_theme_options_object->Rich_Web_AnSL_SShChT, $rw_theme_options_object->Rich_Web_AnSL_T_FS, $rw_theme_options_object->Rich_Web_AnSL_T_FF, $rw_theme_options_object->Rich_Web_AnSL_T_C, $rw_theme_options_object->Rich_Web_AnSL_T_BgC, $rw_theme_options_object->Rich_Web_AnSL_T_TA, $rw_theme_options_object->Rich_Web_AnSL_T_Sh, $rw_theme_options_object->Rich_Web_AnSL_T_ShC, $rw_theme_options_object->Rich_Web_AnSL_N_Sh, $rw_theme_options_object->Rich_Web_AnSL_N_S, $rw_theme_options_object->Rich_Web_AnSL_N_BW, $rw_theme_options_object->Rich_Web_AnSL_N_BC, $rw_theme_options_object->Rich_Web_AnSL_N_BgC, $rw_theme_options_object->Rich_Web_AnSL_N_BS, $rw_theme_options_object->Rich_Web_AnSL_N_HBgC, $rw_theme_options_object->Rich_Web_AnSL_N_CC, $rw_theme_options_object->Rich_Web_AnSL_N_M, $rw_theme_options_object->Rich_Web_AnSL_Ic_Sh, $rw_theme_options_object->Rich_Web_AnSL_Ic_T, $rw_theme_options_object->Rich_Web_AnSL_Ic_S, $rw_theme_options_object->Rich_Web_AnSL_Ic_C, $rw_theme_options_object->Rich_Web_AnSL_L_BgC, $rw_theme_options_object->Rich_Web_AnSL_L_T, $rw_theme_options_object->Rich_Web_AnSL_L_FS, $rw_theme_options_object->Rich_Web_AnSL_L_FF, $rw_theme_options_object->Rich_Web_AnSL_L_C, $rw_theme_options_object->Rich_Web_AnSL_L1_T, $rw_theme_options_object->Rich_Web_AnSL_L2_T, $rw_theme_options_object->Rich_Web_AnSL_L3_T));
			$rw_theme_options_loader_object=$wpdb->get_row($wpdb->prepare("SELECT * FROM $rw_slider_image_animation_loader WHERE rich_web_slider_ID=%s", $rw_copy_id));
			$wpdb->query($wpdb->prepare("INSERT INTO $rw_slider_image_animation_loader (id, rich_web_slider_ID, Rich_Web_AnimSl_L_Show, Rich_Web_AnimSl_LT_Show, Rich_Web_AnimSl_LT, Rich_Web_AnimSl_L_BgC, Rich_Web_AnimSl_L_T, Rich_Web_AnimSl_LT_T, Rich_Web_AnimSl_LT_FS, Rich_Web_AnimSl_LT_FF, Rich_Web_AnimSl_LT_C, Rich_Web_AnimSl_L_T1_C, Rich_Web_AnimSl_L_T2_C, Rich_Web_AnimSl_L_T3_C, Rich_Web_AnimSl_LT_T2_BC, Rich_Web_AnimSl_L_C, Rich_Web_AnimSl_LT_T2_AnC, Rich_Web_AnimSl_LT_T3_BgC, Rich_Web_AnimSl_L_S, Rich_Web_AnimSl_Loading_Show) VALUES (%d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", '', $rw_new_copy_id, $rw_theme_options_loader_object->Rich_Web_AnimSl_L_Show, $rw_theme_options_loader_object->Rich_Web_AnimSl_LT_Show, $rw_theme_options_loader_object->Rich_Web_AnimSl_LT, $rw_theme_options_loader_object->Rich_Web_AnimSl_L_BgC, $rw_theme_options_loader_object->Rich_Web_AnimSl_L_T, $rw_theme_options_loader_object->Rich_Web_AnimSl_LT_T, $rw_theme_options_loader_object->Rich_Web_AnimSl_LT_FS, $rw_theme_options_loader_object->Rich_Web_AnimSl_LT_FF, $rw_theme_options_loader_object->Rich_Web_AnimSl_LT_C, $rw_theme_options_loader_object->Rich_Web_AnimSl_L_T1_C, $rw_theme_options_loader_object->Rich_Web_AnimSl_L_T2_C, $rw_theme_options_loader_object->Rich_Web_AnimSl_L_T3_C, $rw_theme_options_loader_object->Rich_Web_AnimSl_LT_T2_BC, $rw_theme_options_loader_object->Rich_Web_AnimSl_L_C, $rw_theme_options_loader_object->Rich_Web_AnimSl_LT_T2_AnC,  $rw_theme_options_loader_object->Rich_Web_AnimSl_LT_T3_BgC,  $rw_theme_options_loader_object->Rich_Web_AnimSl_L_S,  $rw_theme_options_loader_object->Rich_Web_AnimSl_Loading_Show));
		}
		wp_send_json_success();
	}
	function rw_delete_theme_callback() {
		if ( ! isset ($_POST['rw_slider_image_nonce']) || $_POST['rw_slider_image_nonce'] === '' || ! wp_verify_nonce( $_POST['rw_slider_image_nonce'], 'rw_slider_image_nonce_field' ) ) {
			wp_send_json_error( 'Slider Image nonce error.' );
		}
		$rw_delete_id = sanitize_text_field($_POST['rw_delete_id']);
		global $wpdb;
		$rw_delete_slider_type = $wpdb->get_row($wpdb->prepare("SELECT `slider_type` FROM ".RW_SLIDER_IMAGE_EFFECTS_TABLE." WHERE id=%d", $rw_delete_id),ARRAY_A);
		$wpdb->query($wpdb->prepare("DELETE FROM ".RW_SLIDER_IMAGE_EFFECTS_TABLE." WHERE id=%d", $rw_delete_id));
		$rw_themes_tables  = [
			"Slider Navigation" => "rich_web_slider_effect1",
			"Content Slider"	  => "rich_web_slider_effect2",
			"Fashion Slider"	  => "rich_web_slider_effect3",
			"Circle Thumbnails"  => "rich_web_slider_effect4",
			"Slider Carousel"	  => "rich_web_slider_effect5",
			"Flexible Slider"	  => "rich_web_slider_effect6",
			"Dynamic Slider"	  => "rich_web_slider_effect7",
			"Thumbnails Slider & Lightbox"	=> "rich_web_slider_effect8",
			"Accordion Slider"  => "rich_web_slider_effect9",
			"Animation Slider"	  => "rich_web_slider_effect10"
		];
		$rw_theme_option_table = esc_sql($wpdb->prefix  . $rw_themes_tables[$rw_delete_slider_type["slider_type"]]);
		$rw_theme_option_loading_table = esc_sql($wpdb->prefix  . $rw_themes_tables[$rw_delete_slider_type["slider_type"]] . "_Loader");
		if ($rw_delete_slider_type["slider_type"] === "Content Slider") {
			$wpdb->query($wpdb->prepare("DELETE FROM $rw_theme_option_table WHERE richideo_EN_ID = %s", $rw_delete_id));
		}else{
			$wpdb->query($wpdb->prepare("DELETE FROM $rw_theme_option_table WHERE rich_web_slider_ID = %s", $rw_delete_id));
		}
		$wpdb->query($wpdb->prepare("DELETE FROM $rw_theme_option_loading_table WHERE rich_web_slider_ID = %s", $rw_delete_id));
		wp_send_json_success();
	}
	function rw_check_theme_name_callback() {
		if ( ! isset ($_POST['rw_slider_image_nonce']) || $_POST['rw_slider_image_nonce'] === '' || ! wp_verify_nonce( $_POST['rw_slider_image_nonce'], 'rw_slider_image_nonce_field' ) ) {
			wp_send_json_error( 'Slider Image nonce error.' );
		}
		global $wpdb;
		$rw_theme_name = sanitize_text_field($_POST['rw_theme_name']);
		$rw_theme_id = sanitize_text_field($_POST['rw_theme_id']);
		$rw_check_theme = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM ".RW_SLIDER_IMAGE_EFFECTS_TABLE." WHERE id != %s AND slider_name = %s", $rw_theme_id, $rw_theme_name));
		$rw_check_theme === "0" ? wp_send_json_success() : wp_send_json_error();
	}
?>