<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;


/**
 * Returns an array with the country codes and their names
 *
 * @return array
 *
 */
function slicewp_get_countries() {

	return array(
		'AF' => __( 'Afghanistan', 'slicewp' ),
		'AX' => __( 'Åland Islands', 'slicewp' ),
		'AL' => __( 'Albania', 'slicewp' ),
		'DZ' => __( 'Algeria', 'slicewp' ),
		'AS' => __( 'American Samoa', 'slicewp' ),
		'AD' => __( 'Andorra', 'slicewp' ),
		'AO' => __( 'Angola', 'slicewp' ),
		'AI' => __( 'Anguilla', 'slicewp' ),
		'AQ' => __( 'Antarctica', 'slicewp' ),
		'AG' => __( 'Antigua and Barbuda', 'slicewp' ),
		'AR' => __( 'Argentina', 'slicewp' ),
		'AM' => __( 'Armenia', 'slicewp' ),
		'AW' => __( 'Aruba', 'slicewp' ),
		'AU' => __( 'Australia', 'slicewp' ),
		'AT' => __( 'Austria', 'slicewp' ),
		'AZ' => __( 'Azerbaijan', 'slicewp' ),
		'BS' => __( 'Bahamas', 'slicewp' ),
		'BH' => __( 'Bahrain', 'slicewp' ),
		'BD' => __( 'Bangladesh', 'slicewp' ),
		'BB' => __( 'Barbados', 'slicewp' ),
		'BY' => __( 'Belarus', 'slicewp' ),
		'BE' => __( 'Belgium', 'slicewp' ),
		'PW' => __( 'Belau', 'slicewp' ),
		'BZ' => __( 'Belize', 'slicewp' ),
		'BJ' => __( 'Benin', 'slicewp' ),
		'BM' => __( 'Bermuda', 'slicewp' ),
		'BT' => __( 'Bhutan', 'slicewp' ),
		'BO' => __( 'Bolivia', 'slicewp' ),
		'BQ' => __( 'Bonaire, Saint Eustatius and Saba', 'slicewp' ),
		'BA' => __( 'Bosnia and Herzegovina', 'slicewp' ),
		'BW' => __( 'Botswana', 'slicewp' ),
		'BV' => __( 'Bouvet Island', 'slicewp' ),
		'BR' => __( 'Brazil', 'slicewp' ),
		'IO' => __( 'British Indian Ocean Territory', 'slicewp' ),
		'BN' => __( 'Brunei', 'slicewp' ),
		'BG' => __( 'Bulgaria', 'slicewp' ),
		'BF' => __( 'Burkina Faso', 'slicewp' ),
		'BI' => __( 'Burundi', 'slicewp' ),
		'KH' => __( 'Cambodia', 'slicewp' ),
		'CM' => __( 'Cameroon', 'slicewp' ),
		'CA' => __( 'Canada', 'slicewp' ),
		'CV' => __( 'Cape Verde', 'slicewp' ),
		'KY' => __( 'Cayman Islands', 'slicewp' ),
		'CF' => __( 'Central African Republic', 'slicewp' ),
		'TD' => __( 'Chad', 'slicewp' ),
		'CL' => __( 'Chile', 'slicewp' ),
		'CN' => __( 'China', 'slicewp' ),
		'CX' => __( 'Christmas Island', 'slicewp' ),
		'CC' => __( 'Cocos (Keeling) Islands', 'slicewp' ),
		'CO' => __( 'Colombia', 'slicewp' ),
		'KM' => __( 'Comoros', 'slicewp' ),
		'CG' => __( 'Congo (Brazzaville)', 'slicewp' ),
		'CD' => __( 'Congo (Kinshasa)', 'slicewp' ),
		'CK' => __( 'Cook Islands', 'slicewp' ),
		'CR' => __( 'Costa Rica', 'slicewp' ),
		'HR' => __( 'Croatia', 'slicewp' ),
		'CU' => __( 'Cuba', 'slicewp' ),
		'CW' => __( 'Cura&ccedil;ao', 'slicewp' ),
		'CY' => __( 'Cyprus', 'slicewp' ),
		'CZ' => __( 'Czech Republic', 'slicewp' ),
		'DK' => __( 'Denmark', 'slicewp' ),
		'DJ' => __( 'Djibouti', 'slicewp' ),
		'DM' => __( 'Dominica', 'slicewp' ),
		'DO' => __( 'Dominican Republic', 'slicewp' ),
		'EC' => __( 'Ecuador', 'slicewp' ),
		'EG' => __( 'Egypt', 'slicewp' ),
		'SV' => __( 'El Salvador', 'slicewp' ),
		'GQ' => __( 'Equatorial Guinea', 'slicewp' ),
		'ER' => __( 'Eritrea', 'slicewp' ),
		'EE' => __( 'Estonia', 'slicewp' ),
		'ET' => __( 'Ethiopia', 'slicewp' ),
		'FK' => __( 'Falkland Islands', 'slicewp' ),
		'FO' => __( 'Faroe Islands', 'slicewp' ),
		'FJ' => __( 'Fiji', 'slicewp' ),
		'FI' => __( 'Finland', 'slicewp' ),
		'FR' => __( 'France', 'slicewp' ),
		'GF' => __( 'French Guiana', 'slicewp' ),
		'PF' => __( 'French Polynesia', 'slicewp' ),
		'TF' => __( 'French Southern Territories', 'slicewp' ),
		'GA' => __( 'Gabon', 'slicewp' ),
		'GM' => __( 'Gambia', 'slicewp' ),
		'GE' => __( 'Georgia', 'slicewp' ),
		'DE' => __( 'Germany', 'slicewp' ),
		'GH' => __( 'Ghana', 'slicewp' ),
		'GI' => __( 'Gibraltar', 'slicewp' ),
		'GR' => __( 'Greece', 'slicewp' ),
		'GL' => __( 'Greenland', 'slicewp' ),
		'GD' => __( 'Grenada', 'slicewp' ),
		'GP' => __( 'Guadeloupe', 'slicewp' ),
		'GU' => __( 'Guam', 'slicewp' ),
		'GT' => __( 'Guatemala', 'slicewp' ),
		'GG' => __( 'Guernsey', 'slicewp' ),
		'GN' => __( 'Guinea', 'slicewp' ),
		'GW' => __( 'Guinea-Bissau', 'slicewp' ),
		'GY' => __( 'Guyana', 'slicewp' ),
		'HT' => __( 'Haiti', 'slicewp' ),
		'HM' => __( 'Heard Island and McDonald Islands', 'slicewp' ),
		'HN' => __( 'Honduras', 'slicewp' ),
		'HK' => __( 'Hong Kong', 'slicewp' ),
		'HU' => __( 'Hungary', 'slicewp' ),
		'IS' => __( 'Iceland', 'slicewp' ),
		'IN' => __( 'India', 'slicewp' ),
		'ID' => __( 'Indonesia', 'slicewp' ),
		'IR' => __( 'Iran', 'slicewp' ),
		'IQ' => __( 'Iraq', 'slicewp' ),
		'IE' => __( 'Ireland', 'slicewp' ),
		'IM' => __( 'Isle of Man', 'slicewp' ),
		'IL' => __( 'Israel', 'slicewp' ),
		'IT' => __( 'Italy', 'slicewp' ),
		'CI' => __( 'Ivory Coast', 'slicewp' ),
		'JM' => __( 'Jamaica', 'slicewp' ),
		'JP' => __( 'Japan', 'slicewp' ),
		'JE' => __( 'Jersey', 'slicewp' ),
		'JO' => __( 'Jordan', 'slicewp' ),
		'KZ' => __( 'Kazakhstan', 'slicewp' ),
		'KE' => __( 'Kenya', 'slicewp' ),
		'KI' => __( 'Kiribati', 'slicewp' ),
		'KW' => __( 'Kuwait', 'slicewp' ),
		'KG' => __( 'Kyrgyzstan', 'slicewp' ),
		'LA' => __( 'Laos', 'slicewp' ),
		'LV' => __( 'Latvia', 'slicewp' ),
		'LB' => __( 'Lebanon', 'slicewp' ),
		'LS' => __( 'Lesotho', 'slicewp' ),
		'LR' => __( 'Liberia', 'slicewp' ),
		'LY' => __( 'Libya', 'slicewp' ),
		'LI' => __( 'Liechtenstein', 'slicewp' ),
		'LT' => __( 'Lithuania', 'slicewp' ),
		'LU' => __( 'Luxembourg', 'slicewp' ),
		'MO' => __( 'Macao', 'slicewp' ),
		'MK' => __( 'North Macedonia', 'slicewp' ),
		'MG' => __( 'Madagascar', 'slicewp' ),
		'MW' => __( 'Malawi', 'slicewp' ),
		'MY' => __( 'Malaysia', 'slicewp' ),
		'MV' => __( 'Maldives', 'slicewp' ),
		'ML' => __( 'Mali', 'slicewp' ),
		'MT' => __( 'Malta', 'slicewp' ),
		'MH' => __( 'Marshall Islands', 'slicewp' ),
		'MQ' => __( 'Martinique', 'slicewp' ),
		'MR' => __( 'Mauritania', 'slicewp' ),
		'MU' => __( 'Mauritius', 'slicewp' ),
		'YT' => __( 'Mayotte', 'slicewp' ),
		'MX' => __( 'Mexico', 'slicewp' ),
		'FM' => __( 'Micronesia', 'slicewp' ),
		'MD' => __( 'Moldova', 'slicewp' ),
		'MC' => __( 'Monaco', 'slicewp' ),
		'MN' => __( 'Mongolia', 'slicewp' ),
		'ME' => __( 'Montenegro', 'slicewp' ),
		'MS' => __( 'Montserrat', 'slicewp' ),
		'MA' => __( 'Morocco', 'slicewp' ),
		'MZ' => __( 'Mozambique', 'slicewp' ),
		'MM' => __( 'Myanmar', 'slicewp' ),
		'NA' => __( 'Namibia', 'slicewp' ),
		'NR' => __( 'Nauru', 'slicewp' ),
		'NP' => __( 'Nepal', 'slicewp' ),
		'NL' => __( 'Netherlands', 'slicewp' ),
		'NC' => __( 'New Caledonia', 'slicewp' ),
		'NZ' => __( 'New Zealand', 'slicewp' ),
		'NI' => __( 'Nicaragua', 'slicewp' ),
		'NE' => __( 'Niger', 'slicewp' ),
		'NG' => __( 'Nigeria', 'slicewp' ),
		'NU' => __( 'Niue', 'slicewp' ),
		'NF' => __( 'Norfolk Island', 'slicewp' ),
		'MP' => __( 'Northern Mariana Islands', 'slicewp' ),
		'KP' => __( 'North Korea', 'slicewp' ),
		'NO' => __( 'Norway', 'slicewp' ),
		'OM' => __( 'Oman', 'slicewp' ),
		'PK' => __( 'Pakistan', 'slicewp' ),
		'PS' => __( 'Palestinian Territory', 'slicewp' ),
		'PA' => __( 'Panama', 'slicewp' ),
		'PG' => __( 'Papua New Guinea', 'slicewp' ),
		'PY' => __( 'Paraguay', 'slicewp' ),
		'PE' => __( 'Peru', 'slicewp' ),
		'PH' => __( 'Philippines', 'slicewp' ),
		'PN' => __( 'Pitcairn', 'slicewp' ),
		'PL' => __( 'Poland', 'slicewp' ),
		'PT' => __( 'Portugal', 'slicewp' ),
		'PR' => __( 'Puerto Rico', 'slicewp' ),
		'QA' => __( 'Qatar', 'slicewp' ),
		'RE' => __( 'Reunion', 'slicewp' ),
		'RO' => __( 'Romania', 'slicewp' ),
		'RU' => __( 'Russia', 'slicewp' ),
		'RW' => __( 'Rwanda', 'slicewp' ),
		'BL' => __( 'Saint Barth&eacute;lemy', 'slicewp' ),
		'SH' => __( 'Saint Helena', 'slicewp' ),
		'KN' => __( 'Saint Kitts and Nevis', 'slicewp' ),
		'LC' => __( 'Saint Lucia', 'slicewp' ),
		'MF' => __( 'Saint Martin (French part)', 'slicewp' ),
		'SX' => __( 'Saint Martin (Dutch part)', 'slicewp' ),
		'PM' => __( 'Saint Pierre and Miquelon', 'slicewp' ),
		'VC' => __( 'Saint Vincent and the Grenadines', 'slicewp' ),
		'SM' => __( 'San Marino', 'slicewp' ),
		'ST' => __( 'S&atilde;o Tom&eacute; and Pr&iacute;ncipe', 'slicewp' ),
		'SA' => __( 'Saudi Arabia', 'slicewp' ),
		'SN' => __( 'Senegal', 'slicewp' ),
		'RS' => __( 'Serbia', 'slicewp' ),
		'SC' => __( 'Seychelles', 'slicewp' ),
		'SL' => __( 'Sierra Leone', 'slicewp' ),
		'SG' => __( 'Singapore', 'slicewp' ),
		'SK' => __( 'Slovakia', 'slicewp' ),
		'SI' => __( 'Slovenia', 'slicewp' ),
		'SB' => __( 'Solomon Islands', 'slicewp' ),
		'SO' => __( 'Somalia', 'slicewp' ),
		'ZA' => __( 'South Africa', 'slicewp' ),
		'GS' => __( 'South Georgia/Sandwich Islands', 'slicewp' ),
		'KR' => __( 'South Korea', 'slicewp' ),
		'SS' => __( 'South Sudan', 'slicewp' ),
		'ES' => __( 'Spain', 'slicewp' ),
		'LK' => __( 'Sri Lanka', 'slicewp' ),
		'SD' => __( 'Sudan', 'slicewp' ),
		'SR' => __( 'Suriname', 'slicewp' ),
		'SJ' => __( 'Svalbard and Jan Mayen', 'slicewp' ),
		'SZ' => __( 'Swaziland', 'slicewp' ),
		'SE' => __( 'Sweden', 'slicewp' ),
		'CH' => __( 'Switzerland', 'slicewp' ),
		'SY' => __( 'Syria', 'slicewp' ),
		'TW' => __( 'Taiwan', 'slicewp' ),
		'TJ' => __( 'Tajikistan', 'slicewp' ),
		'TZ' => __( 'Tanzania', 'slicewp' ),
		'TH' => __( 'Thailand', 'slicewp' ),
		'TL' => __( 'Timor-Leste', 'slicewp' ),
		'TG' => __( 'Togo', 'slicewp' ),
		'TK' => __( 'Tokelau', 'slicewp' ),
		'TO' => __( 'Tonga', 'slicewp' ),
		'TT' => __( 'Trinidad and Tobago', 'slicewp' ),
		'TN' => __( 'Tunisia', 'slicewp' ),
		'TR' => __( 'Turkey', 'slicewp' ),
		'TM' => __( 'Turkmenistan', 'slicewp' ),
		'TC' => __( 'Turks and Caicos Islands', 'slicewp' ),
		'TV' => __( 'Tuvalu', 'slicewp' ),
		'UG' => __( 'Uganda', 'slicewp' ),
		'UA' => __( 'Ukraine', 'slicewp' ),
		'AE' => __( 'United Arab Emirates', 'slicewp' ),
		'GB' => __( 'United Kingdom (UK)', 'slicewp' ),
		'US' => __( 'United States (US)', 'slicewp' ),
		'UM' => __( 'United States (US) Minor Outlying Islands', 'slicewp' ),
		'UY' => __( 'Uruguay', 'slicewp' ),
		'UZ' => __( 'Uzbekistan', 'slicewp' ),
		'VU' => __( 'Vanuatu', 'slicewp' ),
		'VA' => __( 'Vatican', 'slicewp' ),
		'VE' => __( 'Venezuela', 'slicewp' ),
		'VN' => __( 'Vietnam', 'slicewp' ),
		'VG' => __( 'Virgin Islands (British)', 'slicewp' ),
		'VI' => __( 'Virgin Islands (US)', 'slicewp' ),
		'WF' => __( 'Wallis and Futuna', 'slicewp' ),
		'EH' => __( 'Western Sahara', 'slicewp' ),
		'WS' => __( 'Samoa', 'slicewp' ),
		'YE' => __( 'Yemen', 'slicewp' ),
		'ZM' => __( 'Zambia', 'slicewp' ),
		'ZW' => __( 'Zimbabwe', 'slicewp' )
	);

}


/**
 * Returns an array with all the countries and their states.
 * If the $country_code is passed, will return only the states for the given country.
 *
 * Countries that have no states are set as empty arrays.
 * Countries that are not set contain states, but we don't know them.
 *
 * @param string $country_code
 *
 * @return array|null
 *
 */
function slicewp_get_country_states( $country_code = '' ) {

	$country_states = array(
		'AF' => array(),
		'AO' => array( // Angola states.
			'BGO' => __( 'Bengo', 'slicewp' ),
			'BLU' => __( 'Benguela', 'slicewp' ),
			'BIE' => __( 'Bié', 'slicewp' ),
			'CAB' => __( 'Cabinda', 'slicewp' ),
			'CNN' => __( 'Cunene', 'slicewp' ),
			'HUA' => __( 'Huambo', 'slicewp' ),
			'HUI' => __( 'Huíla', 'slicewp' ),
			'CCU' => __( 'Kuando Kubango', 'slicewp' ),
			'CNO' => __( 'Kwanza-Norte', 'slicewp' ),
			'CUS' => __( 'Kwanza-Sul', 'slicewp' ),
			'LUA' => __( 'Luanda', 'slicewp' ),
			'LNO' => __( 'Lunda-Norte', 'slicewp' ),
			'LSU' => __( 'Lunda-Sul', 'slicewp' ),
			'MAL' => __( 'Malanje', 'slicewp' ),
			'MOX' => __( 'Moxico', 'slicewp' ),
			'NAM' => __( 'Namibe', 'slicewp' ),
			'UIG' => __( 'Uíge', 'slicewp' ),
			'ZAI' => __( 'Zaire', 'slicewp' ),
		),
		'AR' => array( // Argentinian provinces.
			'C' => __( 'Ciudad Autónoma de Buenos Aires', 'slicewp' ),
			'B' => __( 'Buenos Aires', 'slicewp' ),
			'K' => __( 'Catamarca', 'slicewp' ),
			'H' => __( 'Chaco', 'slicewp' ),
			'U' => __( 'Chubut', 'slicewp' ),
			'X' => __( 'Córdoba', 'slicewp' ),
			'W' => __( 'Corrientes', 'slicewp' ),
			'E' => __( 'Entre Ríos', 'slicewp' ),
			'P' => __( 'Formosa', 'slicewp' ),
			'Y' => __( 'Jujuy', 'slicewp' ),
			'L' => __( 'La Pampa', 'slicewp' ),
			'F' => __( 'La Rioja', 'slicewp' ),
			'M' => __( 'Mendoza', 'slicewp' ),
			'N' => __( 'Misiones', 'slicewp' ),
			'Q' => __( 'Neuquén', 'slicewp' ),
			'R' => __( 'Río Negro', 'slicewp' ),
			'A' => __( 'Salta', 'slicewp' ),
			'J' => __( 'San Juan', 'slicewp' ),
			'D' => __( 'San Luis', 'slicewp' ),
			'Z' => __( 'Santa Cruz', 'slicewp' ),
			'S' => __( 'Santa Fe', 'slicewp' ),
			'G' => __( 'Santiago del Estero', 'slicewp' ),
			'V' => __( 'Tierra del Fuego', 'slicewp' ),
			'T' => __( 'Tucumán', 'slicewp' ),
		),
		'AT' => array(),
		'AU' => array( // Australian states.
			'ACT' => __( 'Australian Capital Territory', 'slicewp' ),
			'NSW' => __( 'New South Wales', 'slicewp' ),
			'NT'  => __( 'Northern Territory', 'slicewp' ),
			'QLD' => __( 'Queensland', 'slicewp' ),
			'SA'  => __( 'South Australia', 'slicewp' ),
			'TAS' => __( 'Tasmania', 'slicewp' ),
			'VIC' => __( 'Victoria', 'slicewp' ),
			'WA'  => __( 'Western Australia', 'slicewp' ),
		),
		'AX' => array(),
		'BD' => array( // Bangladeshi states (districts).
			'BD-05' => __( 'Bagerhat', 'slicewp' ),
			'BD-01' => __( 'Bandarban', 'slicewp' ),
			'BD-02' => __( 'Barguna', 'slicewp' ),
			'BD-06' => __( 'Barishal', 'slicewp' ),
			'BD-07' => __( 'Bhola', 'slicewp' ),
			'BD-03' => __( 'Bogura', 'slicewp' ),
			'BD-04' => __( 'Brahmanbaria', 'slicewp' ),
			'BD-09' => __( 'Chandpur', 'slicewp' ),
			'BD-10' => __( 'Chattogram', 'slicewp' ),
			'BD-12' => __( 'Chuadanga', 'slicewp' ),
			'BD-11' => __( "Cox's Bazar", 'slicewp' ),
			'BD-08' => __( 'Cumilla', 'slicewp' ),
			'BD-13' => __( 'Dhaka', 'slicewp' ),
			'BD-14' => __( 'Dinajpur', 'slicewp' ),
			'BD-15' => __( 'Faridpur ', 'slicewp' ),
			'BD-16' => __( 'Feni', 'slicewp' ),
			'BD-19' => __( 'Gaibandha', 'slicewp' ),
			'BD-18' => __( 'Gazipur', 'slicewp' ),
			'BD-17' => __( 'Gopalganj', 'slicewp' ),
			'BD-20' => __( 'Habiganj', 'slicewp' ),
			'BD-21' => __( 'Jamalpur', 'slicewp' ),
			'BD-22' => __( 'Jashore', 'slicewp' ),
			'BD-25' => __( 'Jhalokati', 'slicewp' ),
			'BD-23' => __( 'Jhenaidah', 'slicewp' ),
			'BD-24' => __( 'Joypurhat', 'slicewp' ),
			'BD-29' => __( 'Khagrachhari', 'slicewp' ),
			'BD-27' => __( 'Khulna', 'slicewp' ),
			'BD-26' => __( 'Kishoreganj', 'slicewp' ),
			'BD-28' => __( 'Kurigram', 'slicewp' ),
			'BD-30' => __( 'Kushtia', 'slicewp' ),
			'BD-31' => __( 'Lakshmipur', 'slicewp' ),
			'BD-32' => __( 'Lalmonirhat', 'slicewp' ),
			'BD-36' => __( 'Madaripur', 'slicewp' ),
			'BD-37' => __( 'Magura', 'slicewp' ),
			'BD-33' => __( 'Manikganj ', 'slicewp' ),
			'BD-39' => __( 'Meherpur', 'slicewp' ),
			'BD-38' => __( 'Moulvibazar', 'slicewp' ),
			'BD-35' => __( 'Munshiganj', 'slicewp' ),
			'BD-34' => __( 'Mymensingh', 'slicewp' ),
			'BD-48' => __( 'Naogaon', 'slicewp' ),
			'BD-43' => __( 'Narail', 'slicewp' ),
			'BD-40' => __( 'Narayanganj', 'slicewp' ),
			'BD-42' => __( 'Narsingdi', 'slicewp' ),
			'BD-44' => __( 'Natore', 'slicewp' ),
			'BD-45' => __( 'Nawabganj', 'slicewp' ),
			'BD-41' => __( 'Netrakona', 'slicewp' ),
			'BD-46' => __( 'Nilphamari', 'slicewp' ),
			'BD-47' => __( 'Noakhali', 'slicewp' ),
			'BD-49' => __( 'Pabna', 'slicewp' ),
			'BD-52' => __( 'Panchagarh', 'slicewp' ),
			'BD-51' => __( 'Patuakhali', 'slicewp' ),
			'BD-50' => __( 'Pirojpur', 'slicewp' ),
			'BD-53' => __( 'Rajbari', 'slicewp' ),
			'BD-54' => __( 'Rajshahi', 'slicewp' ),
			'BD-56' => __( 'Rangamati', 'slicewp' ),
			'BD-55' => __( 'Rangpur', 'slicewp' ),
			'BD-58' => __( 'Satkhira', 'slicewp' ),
			'BD-62' => __( 'Shariatpur', 'slicewp' ),
			'BD-57' => __( 'Sherpur', 'slicewp' ),
			'BD-59' => __( 'Sirajganj', 'slicewp' ),
			'BD-61' => __( 'Sunamganj', 'slicewp' ),
			'BD-60' => __( 'Sylhet', 'slicewp' ),
			'BD-63' => __( 'Tangail', 'slicewp' ),
			'BD-64' => __( 'Thakurgaon', 'slicewp' ),
		),
		'BE' => array(),
		'BG' => array( // Bulgarian states.
			'BG-01' => __( 'Blagoevgrad', 'slicewp' ),
			'BG-02' => __( 'Burgas', 'slicewp' ),
			'BG-08' => __( 'Dobrich', 'slicewp' ),
			'BG-07' => __( 'Gabrovo', 'slicewp' ),
			'BG-26' => __( 'Haskovo', 'slicewp' ),
			'BG-09' => __( 'Kardzhali', 'slicewp' ),
			'BG-10' => __( 'Kyustendil', 'slicewp' ),
			'BG-11' => __( 'Lovech', 'slicewp' ),
			'BG-12' => __( 'Montana', 'slicewp' ),
			'BG-13' => __( 'Pazardzhik', 'slicewp' ),
			'BG-14' => __( 'Pernik', 'slicewp' ),
			'BG-15' => __( 'Pleven', 'slicewp' ),
			'BG-16' => __( 'Plovdiv', 'slicewp' ),
			'BG-17' => __( 'Razgrad', 'slicewp' ),
			'BG-18' => __( 'Ruse', 'slicewp' ),
			'BG-27' => __( 'Shumen', 'slicewp' ),
			'BG-19' => __( 'Silistra', 'slicewp' ),
			'BG-20' => __( 'Sliven', 'slicewp' ),
			'BG-21' => __( 'Smolyan', 'slicewp' ),
			'BG-23' => __( 'Sofia', 'slicewp' ),
			'BG-22' => __( 'Sofia-Grad', 'slicewp' ),
			'BG-24' => __( 'Stara Zagora', 'slicewp' ),
			'BG-25' => __( 'Targovishte', 'slicewp' ),
			'BG-03' => __( 'Varna', 'slicewp' ),
			'BG-04' => __( 'Veliko Tarnovo', 'slicewp' ),
			'BG-05' => __( 'Vidin', 'slicewp' ),
			'BG-06' => __( 'Vratsa', 'slicewp' ),
			'BG-28' => __( 'Yambol', 'slicewp' ),
		),
		'BH' => array(),
		'BI' => array(),
		'BJ' => array( // Benin states.
			'AL' => __( 'Alibori', 'slicewp' ),
			'AK' => __( 'Atakora', 'slicewp' ),
			'AQ' => __( 'Atlantique', 'slicewp' ),
			'BO' => __( 'Borgou', 'slicewp' ),
			'CO' => __( 'Collines', 'slicewp' ),
			'KO' => __( 'Kouffo', 'slicewp' ),
			'DO' => __( 'Donga', 'slicewp' ),
			'LI' => __( 'Littoral', 'slicewp' ),
			'MO' => __( 'Mono', 'slicewp' ),
			'OU' => __( 'Ouémé', 'slicewp' ),
			'PL' => __( 'Plateau', 'slicewp' ),
			'ZO' => __( 'Zou', 'slicewp' ),
		),
		'BO' => array( // Bolivian states.
			'B' => __( 'Chuquisaca', 'slicewp' ),
			'H' => __( 'Beni', 'slicewp' ),
			'C' => __( 'Cochabamba', 'slicewp' ),
			'L' => __( 'La Paz', 'slicewp' ),
			'O' => __( 'Oruro', 'slicewp' ),
			'N' => __( 'Pando', 'slicewp' ),
			'P' => __( 'Potosí', 'slicewp' ),
			'S' => __( 'Santa Cruz', 'slicewp' ),
			'T' => __( 'Tarija', 'slicewp' ),
		),
		'BR' => array( // Brazillian states.
			'AC' => __( 'Acre', 'slicewp' ),
			'AL' => __( 'Alagoas', 'slicewp' ),
			'AP' => __( 'Amapá', 'slicewp' ),
			'AM' => __( 'Amazonas', 'slicewp' ),
			'BA' => __( 'Bahia', 'slicewp' ),
			'CE' => __( 'Ceará', 'slicewp' ),
			'DF' => __( 'Distrito Federal', 'slicewp' ),
			'ES' => __( 'Espírito Santo', 'slicewp' ),
			'GO' => __( 'Goiás', 'slicewp' ),
			'MA' => __( 'Maranhão', 'slicewp' ),
			'MT' => __( 'Mato Grosso', 'slicewp' ),
			'MS' => __( 'Mato Grosso do Sul', 'slicewp' ),
			'MG' => __( 'Minas Gerais', 'slicewp' ),
			'PA' => __( 'Pará', 'slicewp' ),
			'PB' => __( 'Paraíba', 'slicewp' ),
			'PR' => __( 'Paraná', 'slicewp' ),
			'PE' => __( 'Pernambuco', 'slicewp' ),
			'PI' => __( 'Piauí', 'slicewp' ),
			'RJ' => __( 'Rio de Janeiro', 'slicewp' ),
			'RN' => __( 'Rio Grande do Norte', 'slicewp' ),
			'RS' => __( 'Rio Grande do Sul', 'slicewp' ),
			'RO' => __( 'Rondônia', 'slicewp' ),
			'RR' => __( 'Roraima', 'slicewp' ),
			'SC' => __( 'Santa Catarina', 'slicewp' ),
			'SP' => __( 'São Paulo', 'slicewp' ),
			'SE' => __( 'Sergipe', 'slicewp' ),
			'TO' => __( 'Tocantins', 'slicewp' ),
		),
		'CA' => array( // Canadian states.
			'AB' => __( 'Alberta', 'slicewp' ),
			'BC' => __( 'British Columbia', 'slicewp' ),
			'MB' => __( 'Manitoba', 'slicewp' ),
			'NB' => __( 'New Brunswick', 'slicewp' ),
			'NL' => __( 'Newfoundland and Labrador', 'slicewp' ),
			'NT' => __( 'Northwest Territories', 'slicewp' ),
			'NS' => __( 'Nova Scotia', 'slicewp' ),
			'NU' => __( 'Nunavut', 'slicewp' ),
			'ON' => __( 'Ontario', 'slicewp' ),
			'PE' => __( 'Prince Edward Island', 'slicewp' ),
			'QC' => __( 'Quebec', 'slicewp' ),
			'SK' => __( 'Saskatchewan', 'slicewp' ),
			'YT' => __( 'Yukon Territory', 'slicewp' ),
		),
		'CH' => array( // Cantons of Switzerland.
			'AG' => __( 'Aargau', 'slicewp' ),
			'AR' => __( 'Appenzell Ausserrhoden', 'slicewp' ),
			'AI' => __( 'Appenzell Innerrhoden', 'slicewp' ),
			'BL' => __( 'Basel-Landschaft', 'slicewp' ),
			'BS' => __( 'Basel-Stadt', 'slicewp' ),
			'BE' => __( 'Bern', 'slicewp' ),
			'FR' => __( 'Fribourg', 'slicewp' ),
			'GE' => __( 'Geneva', 'slicewp' ),
			'GL' => __( 'Glarus', 'slicewp' ),
			'GR' => __( 'Graubünden', 'slicewp' ),
			'JU' => __( 'Jura', 'slicewp' ),
			'LU' => __( 'Luzern', 'slicewp' ),
			'NE' => __( 'Neuchâtel', 'slicewp' ),
			'NW' => __( 'Nidwalden', 'slicewp' ),
			'OW' => __( 'Obwalden', 'slicewp' ),
			'SH' => __( 'Schaffhausen', 'slicewp' ),
			'SZ' => __( 'Schwyz', 'slicewp' ),
			'SO' => __( 'Solothurn', 'slicewp' ),
			'SG' => __( 'St. Gallen', 'slicewp' ),
			'TG' => __( 'Thurgau', 'slicewp' ),
			'TI' => __( 'Ticino', 'slicewp' ),
			'UR' => __( 'Uri', 'slicewp' ),
			'VS' => __( 'Valais', 'slicewp' ),
			'VD' => __( 'Vaud', 'slicewp' ),
			'ZG' => __( 'Zug', 'slicewp' ),
			'ZH' => __( 'Zürich', 'slicewp' ),
		),
		'CN' => array( // Chinese states.
			'CN1'  => __( 'Yunnan / 云南', 'slicewp' ),
			'CN2'  => __( 'Beijing / 北京', 'slicewp' ),
			'CN3'  => __( 'Tianjin / 天津', 'slicewp' ),
			'CN4'  => __( 'Hebei / 河北', 'slicewp' ),
			'CN5'  => __( 'Shanxi / 山西', 'slicewp' ),
			'CN6'  => __( 'Inner Mongolia / 內蒙古', 'slicewp' ),
			'CN7'  => __( 'Liaoning / 辽宁', 'slicewp' ),
			'CN8'  => __( 'Jilin / 吉林', 'slicewp' ),
			'CN9'  => __( 'Heilongjiang / 黑龙江', 'slicewp' ),
			'CN10' => __( 'Shanghai / 上海', 'slicewp' ),
			'CN11' => __( 'Jiangsu / 江苏', 'slicewp' ),
			'CN12' => __( 'Zhejiang / 浙江', 'slicewp' ),
			'CN13' => __( 'Anhui / 安徽', 'slicewp' ),
			'CN14' => __( 'Fujian / 福建', 'slicewp' ),
			'CN15' => __( 'Jiangxi / 江西', 'slicewp' ),
			'CN16' => __( 'Shandong / 山东', 'slicewp' ),
			'CN17' => __( 'Henan / 河南', 'slicewp' ),
			'CN18' => __( 'Hubei / 湖北', 'slicewp' ),
			'CN19' => __( 'Hunan / 湖南', 'slicewp' ),
			'CN20' => __( 'Guangdong / 广东', 'slicewp' ),
			'CN21' => __( 'Guangxi Zhuang / 广西壮族', 'slicewp' ),
			'CN22' => __( 'Hainan / 海南', 'slicewp' ),
			'CN23' => __( 'Chongqing / 重庆', 'slicewp' ),
			'CN24' => __( 'Sichuan / 四川', 'slicewp' ),
			'CN25' => __( 'Guizhou / 贵州', 'slicewp' ),
			'CN26' => __( 'Shaanxi / 陕西', 'slicewp' ),
			'CN27' => __( 'Gansu / 甘肃', 'slicewp' ),
			'CN28' => __( 'Qinghai / 青海', 'slicewp' ),
			'CN29' => __( 'Ningxia Hui / 宁夏', 'slicewp' ),
			'CN30' => __( 'Macao / 澳门', 'slicewp' ),
			'CN31' => __( 'Tibet / 西藏', 'slicewp' ),
			'CN32' => __( 'Xinjiang / 新疆', 'slicewp' ),
		),
		'CZ' => array(),
		'DE' => array(),
		'DK' => array(),
		'DZ' => array(
			'DZ-01' => __( 'Adrar', 'slicewp' ),
			'DZ-02' => __( 'Chlef', 'slicewp' ),
			'DZ-03' => __( 'Laghouat', 'slicewp' ),
			'DZ-04' => __( 'Oum El Bouaghi', 'slicewp' ),
			'DZ-05' => __( 'Batna', 'slicewp' ),
			'DZ-06' => __( 'Béjaïa', 'slicewp' ),
			'DZ-07' => __( 'Biskra', 'slicewp' ),
			'DZ-08' => __( 'Béchar', 'slicewp' ),
			'DZ-09' => __( 'Blida', 'slicewp' ),
			'DZ-10' => __( 'Bouira', 'slicewp' ),
			'DZ-11' => __( 'Tamanghasset', 'slicewp' ),
			'DZ-12' => __( 'Tébessa', 'slicewp' ),
			'DZ-13' => __( 'Tlemcen', 'slicewp' ),
			'DZ-14' => __( 'Tiaret', 'slicewp' ),
			'DZ-15' => __( 'Tizi Ouzou', 'slicewp' ),
			'DZ-16' => __( 'Algiers', 'slicewp' ),
			'DZ-17' => __( 'Djelfa', 'slicewp' ),
			'DZ-18' => __( 'Jijel', 'slicewp' ),
			'DZ-19' => __( 'Sétif', 'slicewp' ),
			'DZ-20' => __( 'Saïda', 'slicewp' ),
			'DZ-21' => __( 'Skikda', 'slicewp' ),
			'DZ-22' => __( 'Sidi Bel Abbès', 'slicewp' ),
			'DZ-23' => __( 'Annaba', 'slicewp' ),
			'DZ-24' => __( 'Guelma', 'slicewp' ),
			'DZ-25' => __( 'Constantine', 'slicewp' ),
			'DZ-26' => __( 'Médéa', 'slicewp' ),
			'DZ-27' => __( 'Mostaganem', 'slicewp' ),
			'DZ-28' => __( 'M’Sila', 'slicewp' ),
			'DZ-29' => __( 'Mascara', 'slicewp' ),
			'DZ-30' => __( 'Ouargla', 'slicewp' ),
			'DZ-31' => __( 'Oran', 'slicewp' ),
			'DZ-32' => __( 'El Bayadh', 'slicewp' ),
			'DZ-33' => __( 'Illizi', 'slicewp' ),
			'DZ-34' => __( 'Bordj Bou Arréridj', 'slicewp' ),
			'DZ-35' => __( 'Boumerdès', 'slicewp' ),
			'DZ-36' => __( 'El Tarf', 'slicewp' ),
			'DZ-37' => __( 'Tindouf', 'slicewp' ),
			'DZ-38' => __( 'Tissemsilt', 'slicewp' ),
			'DZ-39' => __( 'El Oued', 'slicewp' ),
			'DZ-40' => __( 'Khenchela', 'slicewp' ),
			'DZ-41' => __( 'Souk Ahras', 'slicewp' ),
			'DZ-42' => __( 'Tipasa', 'slicewp' ),
			'DZ-43' => __( 'Mila', 'slicewp' ),
			'DZ-44' => __( 'Aïn Defla', 'slicewp' ),
			'DZ-45' => __( 'Naama', 'slicewp' ),
			'DZ-46' => __( 'Aïn Témouchent', 'slicewp' ),
			'DZ-47' => __( 'Ghardaïa', 'slicewp' ),
			'DZ-48' => __( 'Relizane', 'slicewp' ),
		),
		'EE' => array(),
		'EG' => array( // Egypt states.
			'EGALX' => __( 'Alexandria', 'slicewp' ),
			'EGASN' => __( 'Aswan', 'slicewp' ),
			'EGAST' => __( 'Asyut', 'slicewp' ),
			'EGBA'  => __( 'Red Sea', 'slicewp' ),
			'EGBH'  => __( 'Beheira', 'slicewp' ),
			'EGBNS' => __( 'Beni Suef', 'slicewp' ),
			'EGC'   => __( 'Cairo', 'slicewp' ),
			'EGDK'  => __( 'Dakahlia', 'slicewp' ),
			'EGDT'  => __( 'Damietta', 'slicewp' ),
			'EGFYM' => __( 'Faiyum', 'slicewp' ),
			'EGGH'  => __( 'Gharbia', 'slicewp' ),
			'EGGZ'  => __( 'Giza', 'slicewp' ),
			'EGIS'  => __( 'Ismailia', 'slicewp' ),
			'EGJS'  => __( 'South Sinai', 'slicewp' ),
			'EGKB'  => __( 'Qalyubia', 'slicewp' ),
			'EGKFS' => __( 'Kafr el-Sheikh', 'slicewp' ),
			'EGKN'  => __( 'Qena', 'slicewp' ),
			'EGLX'  => __( 'Luxor', 'slicewp' ),
			'EGMN'  => __( 'Minya', 'slicewp' ),
			'EGMNF' => __( 'Monufia', 'slicewp' ),
			'EGMT'  => __( 'Matrouh', 'slicewp' ),
			'EGPTS' => __( 'Port Said', 'slicewp' ),
			'EGSHG' => __( 'Sohag', 'slicewp' ),
			'EGSHR' => __( 'Al Sharqia', 'slicewp' ),
			'EGSIN' => __( 'North Sinai', 'slicewp' ),
			'EGSUZ' => __( 'Suez', 'slicewp' ),
			'EGWAD' => __( 'New Valley', 'slicewp' ),
		),
		'ES' => array( // Spanish states.
			'C'  => __( 'A Coruña', 'slicewp' ),
			'VI' => __( 'Araba/Álava', 'slicewp' ),
			'AB' => __( 'Albacete', 'slicewp' ),
			'A'  => __( 'Alicante', 'slicewp' ),
			'AL' => __( 'Almería', 'slicewp' ),
			'O'  => __( 'Asturias', 'slicewp' ),
			'AV' => __( 'Ávila', 'slicewp' ),
			'BA' => __( 'Badajoz', 'slicewp' ),
			'PM' => __( 'Baleares', 'slicewp' ),
			'B'  => __( 'Barcelona', 'slicewp' ),
			'BU' => __( 'Burgos', 'slicewp' ),
			'CC' => __( 'Cáceres', 'slicewp' ),
			'CA' => __( 'Cádiz', 'slicewp' ),
			'S'  => __( 'Cantabria', 'slicewp' ),
			'CS' => __( 'Castellón', 'slicewp' ),
			'CE' => __( 'Ceuta', 'slicewp' ),
			'CR' => __( 'Ciudad Real', 'slicewp' ),
			'CO' => __( 'Córdoba', 'slicewp' ),
			'CU' => __( 'Cuenca', 'slicewp' ),
			'GI' => __( 'Girona', 'slicewp' ),
			'GR' => __( 'Granada', 'slicewp' ),
			'GU' => __( 'Guadalajara', 'slicewp' ),
			'SS' => __( 'Gipuzkoa', 'slicewp' ),
			'H'  => __( 'Huelva', 'slicewp' ),
			'HU' => __( 'Huesca', 'slicewp' ),
			'J'  => __( 'Jaén', 'slicewp' ),
			'LO' => __( 'La Rioja', 'slicewp' ),
			'GC' => __( 'Las Palmas', 'slicewp' ),
			'LE' => __( 'León', 'slicewp' ),
			'L'  => __( 'Lleida', 'slicewp' ),
			'LU' => __( 'Lugo', 'slicewp' ),
			'M'  => __( 'Madrid', 'slicewp' ),
			'MA' => __( 'Málaga', 'slicewp' ),
			'ML' => __( 'Melilla', 'slicewp' ),
			'MU' => __( 'Murcia', 'slicewp' ),
			'NA' => __( 'Navarra', 'slicewp' ),
			'OR' => __( 'Ourense', 'slicewp' ),
			'P'  => __( 'Palencia', 'slicewp' ),
			'PO' => __( 'Pontevedra', 'slicewp' ),
			'SA' => __( 'Salamanca', 'slicewp' ),
			'TF' => __( 'Santa Cruz de Tenerife', 'slicewp' ),
			'SG' => __( 'Segovia', 'slicewp' ),
			'SE' => __( 'Sevilla', 'slicewp' ),
			'SO' => __( 'Soria', 'slicewp' ),
			'T'  => __( 'Tarragona', 'slicewp' ),
			'TE' => __( 'Teruel', 'slicewp' ),
			'TO' => __( 'Toledo', 'slicewp' ),
			'V'  => __( 'Valencia', 'slicewp' ),
			'VA' => __( 'Valladolid', 'slicewp' ),
			'BI' => __( 'Biscay', 'slicewp' ),
			'ZA' => __( 'Zamora', 'slicewp' ),
			'Z'  => __( 'Zaragoza', 'slicewp' ),
		),
		'FI' => array(),
		'FR' => array(),
		'GH' => array( // Ghanaian Regions.
			'AF' => __( 'Ahafo', 'slicewp' ),
			'AH' => __( 'Ashanti', 'slicewp' ),
			'BA' => __( 'Brong-Ahafo', 'slicewp' ),
			'BO' => __( 'Bono', 'slicewp' ),
			'BE' => __( 'Bono East', 'slicewp' ),
			'CP' => __( 'Central', 'slicewp' ),
			'EP' => __( 'Eastern', 'slicewp' ),
			'AA' => __( 'Greater Accra', 'slicewp' ),
			'NE' => __( 'North East', 'slicewp' ),
			'NP' => __( 'Northern', 'slicewp' ),
			'OT' => __( 'Oti', 'slicewp' ),
			'SV' => __( 'Savannah', 'slicewp' ),
			'UE' => __( 'Upper East', 'slicewp' ),
			'UW' => __( 'Upper West', 'slicewp' ),
			'TV' => __( 'Volta', 'slicewp' ),
			'WP' => __( 'Western', 'slicewp' ),
			'WN' => __( 'Western North', 'slicewp' ),
		),
		'GP' => array(),
		'GR' => array( // Greek Regions.
			'I' => __( 'Attica', 'slicewp' ),
			'A' => __( 'East Macedonia and Thrace', 'slicewp' ),
			'B' => __( 'Central Macedonia', 'slicewp' ),
			'C' => __( 'West Macedonia', 'slicewp' ),
			'D' => __( 'Epirus', 'slicewp' ),
			'E' => __( 'Thessaly', 'slicewp' ),
			'F' => __( 'Ionian Islands', 'slicewp' ),
			'G' => __( 'West Greece', 'slicewp' ),
			'H' => __( 'Central Greece', 'slicewp' ),
			'J' => __( 'Peloponnese', 'slicewp' ),
			'K' => __( 'North Aegean', 'slicewp' ),
			'L' => __( 'South Aegean', 'slicewp' ),
			'M' => __( 'Crete', 'slicewp' ),
		),
		'GF' => array(),
		'HK' => array( // Hong Kong states.
			'HONG KONG'       => __( 'Hong Kong Island', 'slicewp' ),
			'KOWLOON'         => __( 'Kowloon', 'slicewp' ),
			'NEW TERRITORIES' => __( 'New Territories', 'slicewp' ),
		),
		'HU' => array( // Hungary states.
			'BK' => __( 'Bács-Kiskun', 'slicewp' ),
			'BE' => __( 'Békés', 'slicewp' ),
			'BA' => __( 'Baranya', 'slicewp' ),
			'BZ' => __( 'Borsod-Abaúj-Zemplén', 'slicewp' ),
			'BU' => __( 'Budapest', 'slicewp' ),
			'CS' => __( 'Csongrád-Csanád', 'slicewp' ),
			'FE' => __( 'Fejér', 'slicewp' ),
			'GS' => __( 'Győr-Moson-Sopron', 'slicewp' ),
			'HB' => __( 'Hajdú-Bihar', 'slicewp' ),
			'HE' => __( 'Heves', 'slicewp' ),
			'JN' => __( 'Jász-Nagykun-Szolnok', 'slicewp' ),
			'KE' => __( 'Komárom-Esztergom', 'slicewp' ),
			'NO' => __( 'Nógrád', 'slicewp' ),
			'PE' => __( 'Pest', 'slicewp' ),
			'SO' => __( 'Somogy', 'slicewp' ),
			'SZ' => __( 'Szabolcs-Szatmár-Bereg', 'slicewp' ),
			'TO' => __( 'Tolna', 'slicewp' ),
			'VA' => __( 'Vas', 'slicewp' ),
			'VE' => __( 'Veszprém', 'slicewp' ),
			'ZA' => __( 'Zala', 'slicewp' ),
		),
		'ID' => array( // Indonesia Provinces.
			'AC' => __( 'Daerah Istimewa Aceh', 'slicewp' ),
			'SU' => __( 'Sumatera Utara', 'slicewp' ),
			'SB' => __( 'Sumatera Barat', 'slicewp' ),
			'RI' => __( 'Riau', 'slicewp' ),
			'KR' => __( 'Kepulauan Riau', 'slicewp' ),
			'JA' => __( 'Jambi', 'slicewp' ),
			'SS' => __( 'Sumatera Selatan', 'slicewp' ),
			'BB' => __( 'Bangka Belitung', 'slicewp' ),
			'BE' => __( 'Bengkulu', 'slicewp' ),
			'LA' => __( 'Lampung', 'slicewp' ),
			'JK' => __( 'DKI Jakarta', 'slicewp' ),
			'JB' => __( 'Jawa Barat', 'slicewp' ),
			'BT' => __( 'Banten', 'slicewp' ),
			'JT' => __( 'Jawa Tengah', 'slicewp' ),
			'JI' => __( 'Jawa Timur', 'slicewp' ),
			'YO' => __( 'Daerah Istimewa Yogyakarta', 'slicewp' ),
			'BA' => __( 'Bali', 'slicewp' ),
			'NB' => __( 'Nusa Tenggara Barat', 'slicewp' ),
			'NT' => __( 'Nusa Tenggara Timur', 'slicewp' ),
			'KB' => __( 'Kalimantan Barat', 'slicewp' ),
			'KT' => __( 'Kalimantan Tengah', 'slicewp' ),
			'KI' => __( 'Kalimantan Timur', 'slicewp' ),
			'KS' => __( 'Kalimantan Selatan', 'slicewp' ),
			'KU' => __( 'Kalimantan Utara', 'slicewp' ),
			'SA' => __( 'Sulawesi Utara', 'slicewp' ),
			'ST' => __( 'Sulawesi Tengah', 'slicewp' ),
			'SG' => __( 'Sulawesi Tenggara', 'slicewp' ),
			'SR' => __( 'Sulawesi Barat', 'slicewp' ),
			'SN' => __( 'Sulawesi Selatan', 'slicewp' ),
			'GO' => __( 'Gorontalo', 'slicewp' ),
			'MA' => __( 'Maluku', 'slicewp' ),
			'MU' => __( 'Maluku Utara', 'slicewp' ),
			'PA' => __( 'Papua', 'slicewp' ),
			'PB' => __( 'Papua Barat', 'slicewp' ),
		),
		'IE' => array( // Republic of Ireland.
			'CW' => __( 'Carlow', 'slicewp' ),
			'CN' => __( 'Cavan', 'slicewp' ),
			'CE' => __( 'Clare', 'slicewp' ),
			'CO' => __( 'Cork', 'slicewp' ),
			'DL' => __( 'Donegal', 'slicewp' ),
			'D'  => __( 'Dublin', 'slicewp' ),
			'G'  => __( 'Galway', 'slicewp' ),
			'KY' => __( 'Kerry', 'slicewp' ),
			'KE' => __( 'Kildare', 'slicewp' ),
			'KK' => __( 'Kilkenny', 'slicewp' ),
			'LS' => __( 'Laois', 'slicewp' ),
			'LM' => __( 'Leitrim', 'slicewp' ),
			'LK' => __( 'Limerick', 'slicewp' ),
			'LD' => __( 'Longford', 'slicewp' ),
			'LH' => __( 'Louth', 'slicewp' ),
			'MO' => __( 'Mayo', 'slicewp' ),
			'MH' => __( 'Meath', 'slicewp' ),
			'MN' => __( 'Monaghan', 'slicewp' ),
			'OY' => __( 'Offaly', 'slicewp' ),
			'RN' => __( 'Roscommon', 'slicewp' ),
			'SO' => __( 'Sligo', 'slicewp' ),
			'TA' => __( 'Tipperary', 'slicewp' ),
			'WD' => __( 'Waterford', 'slicewp' ),
			'WH' => __( 'Westmeath', 'slicewp' ),
			'WX' => __( 'Wexford', 'slicewp' ),
			'WW' => __( 'Wicklow', 'slicewp' ),
		),
		'IN' => array( // Indian states.
			'AP' => __( 'Andhra Pradesh', 'slicewp' ),
			'AR' => __( 'Arunachal Pradesh', 'slicewp' ),
			'AS' => __( 'Assam', 'slicewp' ),
			'BR' => __( 'Bihar', 'slicewp' ),
			'CT' => __( 'Chhattisgarh', 'slicewp' ),
			'GA' => __( 'Goa', 'slicewp' ),
			'GJ' => __( 'Gujarat', 'slicewp' ),
			'HR' => __( 'Haryana', 'slicewp' ),
			'HP' => __( 'Himachal Pradesh', 'slicewp' ),
			'JK' => __( 'Jammu and Kashmir', 'slicewp' ),
			'JH' => __( 'Jharkhand', 'slicewp' ),
			'KA' => __( 'Karnataka', 'slicewp' ),
			'KL' => __( 'Kerala', 'slicewp' ),
			'MP' => __( 'Madhya Pradesh', 'slicewp' ),
			'MH' => __( 'Maharashtra', 'slicewp' ),
			'MN' => __( 'Manipur', 'slicewp' ),
			'ML' => __( 'Meghalaya', 'slicewp' ),
			'MZ' => __( 'Mizoram', 'slicewp' ),
			'NL' => __( 'Nagaland', 'slicewp' ),
			'OR' => __( 'Orissa', 'slicewp' ),
			'PB' => __( 'Punjab', 'slicewp' ),
			'RJ' => __( 'Rajasthan', 'slicewp' ),
			'SK' => __( 'Sikkim', 'slicewp' ),
			'TN' => __( 'Tamil Nadu', 'slicewp' ),
			'TS' => __( 'Telangana', 'slicewp' ),
			'TR' => __( 'Tripura', 'slicewp' ),
			'UK' => __( 'Uttarakhand', 'slicewp' ),
			'UP' => __( 'Uttar Pradesh', 'slicewp' ),
			'WB' => __( 'West Bengal', 'slicewp' ),
			'AN' => __( 'Andaman and Nicobar Islands', 'slicewp' ),
			'CH' => __( 'Chandigarh', 'slicewp' ),
			'DN' => __( 'Dadra and Nagar Haveli', 'slicewp' ),
			'DD' => __( 'Daman and Diu', 'slicewp' ),
			'DL' => __( 'Delhi', 'slicewp' ),
			'LD' => __( 'Lakshadeep', 'slicewp' ),
			'PY' => __( 'Pondicherry (Puducherry)', 'slicewp' ),
		),
		'IR' => array( // Iran States.
			'KHZ' => __( 'Khuzestan  (خوزستان)', 'slicewp' ),
			'THR' => __( 'Tehran  (تهران)', 'slicewp' ),
			'ILM' => __( 'Ilaam (ایلام)', 'slicewp' ),
			'BHR' => __( 'Bushehr (بوشهر)', 'slicewp' ),
			'ADL' => __( 'Ardabil (اردبیل)', 'slicewp' ),
			'ESF' => __( 'Isfahan (اصفهان)', 'slicewp' ),
			'YZD' => __( 'Yazd (یزد)', 'slicewp' ),
			'KRH' => __( 'Kermanshah (کرمانشاه)', 'slicewp' ),
			'KRN' => __( 'Kerman (کرمان)', 'slicewp' ),
			'HDN' => __( 'Hamadan (همدان)', 'slicewp' ),
			'GZN' => __( 'Ghazvin (قزوین)', 'slicewp' ),
			'ZJN' => __( 'Zanjan (زنجان)', 'slicewp' ),
			'LRS' => __( 'Luristan (لرستان)', 'slicewp' ),
			'ABZ' => __( 'Alborz (البرز)', 'slicewp' ),
			'EAZ' => __( 'East Azarbaijan (آذربایجان شرقی)', 'slicewp' ),
			'WAZ' => __( 'West Azarbaijan (آذربایجان غربی)', 'slicewp' ),
			'CHB' => __( 'Chaharmahal and Bakhtiari (چهارمحال و بختیاری)', 'slicewp' ),
			'SKH' => __( 'South Khorasan (خراسان جنوبی)', 'slicewp' ),
			'RKH' => __( 'Razavi Khorasan (خراسان رضوی)', 'slicewp' ),
			'NKH' => __( 'North Khorasan (خراسان شمالی)', 'slicewp' ),
			'SMN' => __( 'Semnan (سمنان)', 'slicewp' ),
			'FRS' => __( 'Fars (فارس)', 'slicewp' ),
			'QHM' => __( 'Qom (قم)', 'slicewp' ),
			'KRD' => __( 'Kurdistan / کردستان)', 'slicewp' ),
			'KBD' => __( 'Kohgiluyeh and BoyerAhmad (کهگیلوییه و بویراحمد)', 'slicewp' ),
			'GLS' => __( 'Golestan (گلستان)', 'slicewp' ),
			'GIL' => __( 'Gilan (گیلان)', 'slicewp' ),
			'MZN' => __( 'Mazandaran (مازندران)', 'slicewp' ),
			'MKZ' => __( 'Markazi (مرکزی)', 'slicewp' ),
			'HRZ' => __( 'Hormozgan (هرمزگان)', 'slicewp' ),
			'SBN' => __( 'Sistan and Baluchestan (سیستان و بلوچستان)', 'slicewp' ),
		),
		'IS' => array(),
		'IT' => array( // Italy Provinces.
			'AG' => __( 'Agrigento', 'slicewp' ),
			'AL' => __( 'Alessandria', 'slicewp' ),
			'AN' => __( 'Ancona', 'slicewp' ),
			'AO' => __( 'Aosta', 'slicewp' ),
			'AR' => __( 'Arezzo', 'slicewp' ),
			'AP' => __( 'Ascoli Piceno', 'slicewp' ),
			'AT' => __( 'Asti', 'slicewp' ),
			'AV' => __( 'Avellino', 'slicewp' ),
			'BA' => __( 'Bari', 'slicewp' ),
			'BT' => __( 'Barletta-Andria-Trani', 'slicewp' ),
			'BL' => __( 'Belluno', 'slicewp' ),
			'BN' => __( 'Benevento', 'slicewp' ),
			'BG' => __( 'Bergamo', 'slicewp' ),
			'BI' => __( 'Biella', 'slicewp' ),
			'BO' => __( 'Bologna', 'slicewp' ),
			'BZ' => __( 'Bolzano', 'slicewp' ),
			'BS' => __( 'Brescia', 'slicewp' ),
			'BR' => __( 'Brindisi', 'slicewp' ),
			'CA' => __( 'Cagliari', 'slicewp' ),
			'CL' => __( 'Caltanissetta', 'slicewp' ),
			'CB' => __( 'Campobasso', 'slicewp' ),
			'CE' => __( 'Caserta', 'slicewp' ),
			'CT' => __( 'Catania', 'slicewp' ),
			'CZ' => __( 'Catanzaro', 'slicewp' ),
			'CH' => __( 'Chieti', 'slicewp' ),
			'CO' => __( 'Como', 'slicewp' ),
			'CS' => __( 'Cosenza', 'slicewp' ),
			'CR' => __( 'Cremona', 'slicewp' ),
			'KR' => __( 'Crotone', 'slicewp' ),
			'CN' => __( 'Cuneo', 'slicewp' ),
			'EN' => __( 'Enna', 'slicewp' ),
			'FM' => __( 'Fermo', 'slicewp' ),
			'FE' => __( 'Ferrara', 'slicewp' ),
			'FI' => __( 'Firenze', 'slicewp' ),
			'FG' => __( 'Foggia', 'slicewp' ),
			'FC' => __( 'Forlì-Cesena', 'slicewp' ),
			'FR' => __( 'Frosinone', 'slicewp' ),
			'GE' => __( 'Genova', 'slicewp' ),
			'GO' => __( 'Gorizia', 'slicewp' ),
			'GR' => __( 'Grosseto', 'slicewp' ),
			'IM' => __( 'Imperia', 'slicewp' ),
			'IS' => __( 'Isernia', 'slicewp' ),
			'SP' => __( 'La Spezia', 'slicewp' ),
			'AQ' => __( "L'Aquila", 'slicewp' ),
			'LT' => __( 'Latina', 'slicewp' ),
			'LE' => __( 'Lecce', 'slicewp' ),
			'LC' => __( 'Lecco', 'slicewp' ),
			'LI' => __( 'Livorno', 'slicewp' ),
			'LO' => __( 'Lodi', 'slicewp' ),
			'LU' => __( 'Lucca', 'slicewp' ),
			'MC' => __( 'Macerata', 'slicewp' ),
			'MN' => __( 'Mantova', 'slicewp' ),
			'MS' => __( 'Massa-Carrara', 'slicewp' ),
			'MT' => __( 'Matera', 'slicewp' ),
			'ME' => __( 'Messina', 'slicewp' ),
			'MI' => __( 'Milano', 'slicewp' ),
			'MO' => __( 'Modena', 'slicewp' ),
			'MB' => __( 'Monza e della Brianza', 'slicewp' ),
			'NA' => __( 'Napoli', 'slicewp' ),
			'NO' => __( 'Novara', 'slicewp' ),
			'NU' => __( 'Nuoro', 'slicewp' ),
			'OR' => __( 'Oristano', 'slicewp' ),
			'PD' => __( 'Padova', 'slicewp' ),
			'PA' => __( 'Palermo', 'slicewp' ),
			'PR' => __( 'Parma', 'slicewp' ),
			'PV' => __( 'Pavia', 'slicewp' ),
			'PG' => __( 'Perugia', 'slicewp' ),
			'PU' => __( 'Pesaro e Urbino', 'slicewp' ),
			'PE' => __( 'Pescara', 'slicewp' ),
			'PC' => __( 'Piacenza', 'slicewp' ),
			'PI' => __( 'Pisa', 'slicewp' ),
			'PT' => __( 'Pistoia', 'slicewp' ),
			'PN' => __( 'Pordenone', 'slicewp' ),
			'PZ' => __( 'Potenza', 'slicewp' ),
			'PO' => __( 'Prato', 'slicewp' ),
			'RG' => __( 'Ragusa', 'slicewp' ),
			'RA' => __( 'Ravenna', 'slicewp' ),
			'RC' => __( 'Reggio Calabria', 'slicewp' ),
			'RE' => __( 'Reggio Emilia', 'slicewp' ),
			'RI' => __( 'Rieti', 'slicewp' ),
			'RN' => __( 'Rimini', 'slicewp' ),
			'RM' => __( 'Roma', 'slicewp' ),
			'RO' => __( 'Rovigo', 'slicewp' ),
			'SA' => __( 'Salerno', 'slicewp' ),
			'SS' => __( 'Sassari', 'slicewp' ),
			'SV' => __( 'Savona', 'slicewp' ),
			'SI' => __( 'Siena', 'slicewp' ),
			'SR' => __( 'Siracusa', 'slicewp' ),
			'SO' => __( 'Sondrio', 'slicewp' ),
			'SU' => __( 'Sud Sardegna', 'slicewp' ),
			'TA' => __( 'Taranto', 'slicewp' ),
			'TE' => __( 'Teramo', 'slicewp' ),
			'TR' => __( 'Terni', 'slicewp' ),
			'TO' => __( 'Torino', 'slicewp' ),
			'TP' => __( 'Trapani', 'slicewp' ),
			'TN' => __( 'Trento', 'slicewp' ),
			'TV' => __( 'Treviso', 'slicewp' ),
			'TS' => __( 'Trieste', 'slicewp' ),
			'UD' => __( 'Udine', 'slicewp' ),
			'VA' => __( 'Varese', 'slicewp' ),
			'VE' => __( 'Venezia', 'slicewp' ),
			'VB' => __( 'Verbano-Cusio-Ossola', 'slicewp' ),
			'VC' => __( 'Vercelli', 'slicewp' ),
			'VR' => __( 'Verona', 'slicewp' ),
			'VV' => __( 'Vibo Valentia', 'slicewp' ),
			'VI' => __( 'Vicenza', 'slicewp' ),
			'VT' => __( 'Viterbo', 'slicewp' ),
		),
		'IL' => array(),
		'IM' => array(),
		'JM' => array( // Jamaica's Parishes. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:JM.
			'JM-01' => __( 'Kingston', 'slicewp' ),
			'JM-02' => __( 'Saint Andrew', 'slicewp' ),
			'JM-03' => __( 'Saint Thomas', 'slicewp' ),
			'JM-04' => __( 'Portland', 'slicewp' ),
			'JM-05' => __( 'Saint Mary', 'slicewp' ),
			'JM-06' => __( 'Saint Ann', 'slicewp' ),
			'JM-07' => __( 'Trelawny', 'slicewp' ),
			'JM-08' => __( 'Saint James', 'slicewp' ),
			'JM-09' => __( 'Hanover', 'slicewp' ),
			'JM-10' => __( 'Westmoreland', 'slicewp' ),
			'JM-11' => __( 'Saint Elizabeth', 'slicewp' ),
			'JM-12' => __( 'Manchester', 'slicewp' ),
			'JM-13' => __( 'Clarendon', 'slicewp' ),
			'JM-14' => __( 'Saint Catherine', 'slicewp' ),
		),

		/**
		 * Japan States.
		 *
		 * English notation of prefectures conform to the notation of Japan Post.
		 * The suffix corresponds with the Japanese translation file.
		 */
		'JP' => array(
			'JP01' => __( 'Hokkaido', 'slicewp' ),
			'JP02' => __( 'Aomori', 'slicewp' ),
			'JP03' => __( 'Iwate', 'slicewp' ),
			'JP04' => __( 'Miyagi', 'slicewp' ),
			'JP05' => __( 'Akita', 'slicewp' ),
			'JP06' => __( 'Yamagata', 'slicewp' ),
			'JP07' => __( 'Fukushima', 'slicewp' ),
			'JP08' => __( 'Ibaraki', 'slicewp' ),
			'JP09' => __( 'Tochigi', 'slicewp' ),
			'JP10' => __( 'Gunma', 'slicewp' ),
			'JP11' => __( 'Saitama', 'slicewp' ),
			'JP12' => __( 'Chiba', 'slicewp' ),
			'JP13' => __( 'Tokyo', 'slicewp' ),
			'JP14' => __( 'Kanagawa', 'slicewp' ),
			'JP15' => __( 'Niigata', 'slicewp' ),
			'JP16' => __( 'Toyama', 'slicewp' ),
			'JP17' => __( 'Ishikawa', 'slicewp' ),
			'JP18' => __( 'Fukui', 'slicewp' ),
			'JP19' => __( 'Yamanashi', 'slicewp' ),
			'JP20' => __( 'Nagano', 'slicewp' ),
			'JP21' => __( 'Gifu', 'slicewp' ),
			'JP22' => __( 'Shizuoka', 'slicewp' ),
			'JP23' => __( 'Aichi', 'slicewp' ),
			'JP24' => __( 'Mie', 'slicewp' ),
			'JP25' => __( 'Shiga', 'slicewp' ),
			'JP26' => __( 'Kyoto', 'slicewp' ),
			'JP27' => __( 'Osaka', 'slicewp' ),
			'JP28' => __( 'Hyogo', 'slicewp' ),
			'JP29' => __( 'Nara', 'slicewp' ),
			'JP30' => __( 'Wakayama', 'slicewp' ),
			'JP31' => __( 'Tottori', 'slicewp' ),
			'JP32' => __( 'Shimane', 'slicewp' ),
			'JP33' => __( 'Okayama', 'slicewp' ),
			'JP34' => __( 'Hiroshima', 'slicewp' ),
			'JP35' => __( 'Yamaguchi', 'slicewp' ),
			'JP36' => __( 'Tokushima', 'slicewp' ),
			'JP37' => __( 'Kagawa', 'slicewp' ),
			'JP38' => __( 'Ehime', 'slicewp' ),
			'JP39' => __( 'Kochi', 'slicewp' ),
			'JP40' => __( 'Fukuoka', 'slicewp' ),
			'JP41' => __( 'Saga', 'slicewp' ),
			'JP42' => __( 'Nagasaki', 'slicewp' ),
			'JP43' => __( 'Kumamoto', 'slicewp' ),
			'JP44' => __( 'Oita', 'slicewp' ),
			'JP45' => __( 'Miyazaki', 'slicewp' ),
			'JP46' => __( 'Kagoshima', 'slicewp' ),
			'JP47' => __( 'Okinawa', 'slicewp' ),
		),
		'KE' => array( // Kenya counties.
			'KE01' => __( 'Baringo', 'slicewp' ),
			'KE02' => __( 'Bomet', 'slicewp' ),
			'KE03' => __( 'Bungoma', 'slicewp' ),
			'KE04' => __( 'Busia', 'slicewp' ),
			'KE05' => __( 'Elgeyo-Marakwet', 'slicewp' ),
			'KE06' => __( 'Embu', 'slicewp' ),
			'KE07' => __( 'Garissa', 'slicewp' ),
			'KE08' => __( 'Homa Bay', 'slicewp' ),
			'KE09' => __( 'Isiolo', 'slicewp' ),
			'KE10' => __( 'Kajiado', 'slicewp' ),
			'KE11' => __( 'Kakamega', 'slicewp' ),
			'KE12' => __( 'Kericho', 'slicewp' ),
			'KE13' => __( 'Kiambu', 'slicewp' ),
			'KE14' => __( 'Kilifi', 'slicewp' ),
			'KE15' => __( 'Kirinyaga', 'slicewp' ),
			'KE16' => __( 'Kisii', 'slicewp' ),
			'KE17' => __( 'Kisumu', 'slicewp' ),
			'KE18' => __( 'Kitui', 'slicewp' ),
			'KE19' => __( 'Kwale', 'slicewp' ),
			'KE20' => __( 'Laikipia', 'slicewp' ),
			'KE21' => __( 'Lamu', 'slicewp' ),
			'KE22' => __( 'Machakos', 'slicewp' ),
			'KE23' => __( 'Makueni', 'slicewp' ),
			'KE24' => __( 'Mandera', 'slicewp' ),
			'KE25' => __( 'Marsabit', 'slicewp' ),
			'KE26' => __( 'Meru', 'slicewp' ),
			'KE27' => __( 'Migori', 'slicewp' ),
			'KE28' => __( 'Mombasa', 'slicewp' ),
			'KE29' => __( 'Murang’a', 'slicewp' ),
			'KE30' => __( 'Nairobi County', 'slicewp' ),
			'KE31' => __( 'Nakuru', 'slicewp' ),
			'KE32' => __( 'Nandi', 'slicewp' ),
			'KE33' => __( 'Narok', 'slicewp' ),
			'KE34' => __( 'Nyamira', 'slicewp' ),
			'KE35' => __( 'Nyandarua', 'slicewp' ),
			'KE36' => __( 'Nyeri', 'slicewp' ),
			'KE37' => __( 'Samburu', 'slicewp' ),
			'KE38' => __( 'Siaya', 'slicewp' ),
			'KE39' => __( 'Taita-Taveta', 'slicewp' ),
			'KE40' => __( 'Tana River', 'slicewp' ),
			'KE41' => __( 'Tharaka-Nithi', 'slicewp' ),
			'KE42' => __( 'Trans Nzoia', 'slicewp' ),
			'KE43' => __( 'Turkana', 'slicewp' ),
			'KE44' => __( 'Uasin Gishu', 'slicewp' ),
			'KE45' => __( 'Vihiga', 'slicewp' ),
			'KE46' => __( 'Wajir', 'slicewp' ),
			'KE47' => __( 'West Pokot', 'slicewp' ),
		),
		'KR' => array(),
		'KW' => array(),
		'LA' => array(
			'AT' => __( 'Attapeu', 'slicewp' ),
			'BK' => __( 'Bokeo', 'slicewp' ),
			'BL' => __( 'Bolikhamsai', 'slicewp' ),
			'CH' => __( 'Champasak', 'slicewp' ),
			'HO' => __( 'Houaphanh', 'slicewp' ),
			'KH' => __( 'Khammouane', 'slicewp' ),
			'LM' => __( 'Luang Namtha', 'slicewp' ),
			'LP' => __( 'Luang Prabang', 'slicewp' ),
			'OU' => __( 'Oudomxay', 'slicewp' ),
			'PH' => __( 'Phongsaly', 'slicewp' ),
			'SL' => __( 'Salavan', 'slicewp' ),
			'SV' => __( 'Savannakhet', 'slicewp' ),
			'VI' => __( 'Vientiane Province', 'slicewp' ),
			'VT' => __( 'Vientiane', 'slicewp' ),
			'XA' => __( 'Sainyabuli', 'slicewp' ),
			'XE' => __( 'Sekong', 'slicewp' ),
			'XI' => __( 'Xiangkhouang', 'slicewp' ),
			'XS' => __( 'Xaisomboun', 'slicewp' ),
		),
		'LB' => array(),
		'LR' => array( // Liberia provinces.
			'BM' => __( 'Bomi', 'slicewp' ),
			'BN' => __( 'Bong', 'slicewp' ),
			'GA' => __( 'Gbarpolu', 'slicewp' ),
			'GB' => __( 'Grand Bassa', 'slicewp' ),
			'GC' => __( 'Grand Cape Mount', 'slicewp' ),
			'GG' => __( 'Grand Gedeh', 'slicewp' ),
			'GK' => __( 'Grand Kru', 'slicewp' ),
			'LO' => __( 'Lofa', 'slicewp' ),
			'MA' => __( 'Margibi', 'slicewp' ),
			'MY' => __( 'Maryland', 'slicewp' ),
			'MO' => __( 'Montserrado', 'slicewp' ),
			'NM' => __( 'Nimba', 'slicewp' ),
			'RV' => __( 'Rivercess', 'slicewp' ),
			'RG' => __( 'River Gee', 'slicewp' ),
			'SN' => __( 'Sinoe', 'slicewp' ),
		),
		'LU' => array(),
		'MD' => array( // Moldova states.
			'C'  => __( 'Chișinău', 'slicewp' ),
			'BL' => __( 'Bălți', 'slicewp' ),
			'AN' => __( 'Anenii Noi', 'slicewp' ),
			'BS' => __( 'Basarabeasca', 'slicewp' ),
			'BR' => __( 'Briceni', 'slicewp' ),
			'CH' => __( 'Cahul', 'slicewp' ),
			'CT' => __( 'Cantemir', 'slicewp' ),
			'CL' => __( 'Călărași', 'slicewp' ),
			'CS' => __( 'Căușeni', 'slicewp' ),
			'CM' => __( 'Cimișlia', 'slicewp' ),
			'CR' => __( 'Criuleni', 'slicewp' ),
			'DN' => __( 'Dondușeni', 'slicewp' ),
			'DR' => __( 'Drochia', 'slicewp' ),
			'DB' => __( 'Dubăsari', 'slicewp' ),
			'ED' => __( 'Edineț', 'slicewp' ),
			'FL' => __( 'Fălești', 'slicewp' ),
			'FR' => __( 'Florești', 'slicewp' ),
			'GE' => __( 'UTA Găgăuzia', 'slicewp' ),
			'GL' => __( 'Glodeni', 'slicewp' ),
			'HN' => __( 'Hîncești', 'slicewp' ),
			'IL' => __( 'Ialoveni', 'slicewp' ),
			'LV' => __( 'Leova', 'slicewp' ),
			'NS' => __( 'Nisporeni', 'slicewp' ),
			'OC' => __( 'Ocnița', 'slicewp' ),
			'OR' => __( 'Orhei', 'slicewp' ),
			'RZ' => __( 'Rezina', 'slicewp' ),
			'RS' => __( 'Rîșcani', 'slicewp' ),
			'SG' => __( 'Sîngerei', 'slicewp' ),
			'SR' => __( 'Soroca', 'slicewp' ),
			'ST' => __( 'Strășeni', 'slicewp' ),
			'SD' => __( 'Șoldănești', 'slicewp' ),
			'SV' => __( 'Ștefan Vodă', 'slicewp' ),
			'TR' => __( 'Taraclia', 'slicewp' ),
			'TL' => __( 'Telenești', 'slicewp' ),
			'UN' => __( 'Ungheni', 'slicewp' ),
		),
		'MQ' => array(),
		'MT' => array(),
		'MX' => array( // Mexico States.
			'DF' => __( 'Ciudad de México', 'slicewp' ),
			'JA' => __( 'Jalisco', 'slicewp' ),
			'NL' => __( 'Nuevo León', 'slicewp' ),
			'AG' => __( 'Aguascalientes', 'slicewp' ),
			'BC' => __( 'Baja California', 'slicewp' ),
			'BS' => __( 'Baja California Sur', 'slicewp' ),
			'CM' => __( 'Campeche', 'slicewp' ),
			'CS' => __( 'Chiapas', 'slicewp' ),
			'CH' => __( 'Chihuahua', 'slicewp' ),
			'CO' => __( 'Coahuila', 'slicewp' ),
			'CL' => __( 'Colima', 'slicewp' ),
			'DG' => __( 'Durango', 'slicewp' ),
			'GT' => __( 'Guanajuato', 'slicewp' ),
			'GR' => __( 'Guerrero', 'slicewp' ),
			'HG' => __( 'Hidalgo', 'slicewp' ),
			'MX' => __( 'Estado de México', 'slicewp' ),
			'MI' => __( 'Michoacán', 'slicewp' ),
			'MO' => __( 'Morelos', 'slicewp' ),
			'NA' => __( 'Nayarit', 'slicewp' ),
			'OA' => __( 'Oaxaca', 'slicewp' ),
			'PU' => __( 'Puebla', 'slicewp' ),
			'QT' => __( 'Querétaro', 'slicewp' ),
			'QR' => __( 'Quintana Roo', 'slicewp' ),
			'SL' => __( 'San Luis Potosí', 'slicewp' ),
			'SI' => __( 'Sinaloa', 'slicewp' ),
			'SO' => __( 'Sonora', 'slicewp' ),
			'TB' => __( 'Tabasco', 'slicewp' ),
			'TM' => __( 'Tamaulipas', 'slicewp' ),
			'TL' => __( 'Tlaxcala', 'slicewp' ),
			'VE' => __( 'Veracruz', 'slicewp' ),
			'YU' => __( 'Yucatán', 'slicewp' ),
			'ZA' => __( 'Zacatecas', 'slicewp' ),
		),
		'MY' => array( // Malaysian states.
			'JHR' => __( 'Johor', 'slicewp' ),
			'KDH' => __( 'Kedah', 'slicewp' ),
			'KTN' => __( 'Kelantan', 'slicewp' ),
			'LBN' => __( 'Labuan', 'slicewp' ),
			'MLK' => __( 'Malacca (Melaka)', 'slicewp' ),
			'NSN' => __( 'Negeri Sembilan', 'slicewp' ),
			'PHG' => __( 'Pahang', 'slicewp' ),
			'PNG' => __( 'Penang (Pulau Pinang)', 'slicewp' ),
			'PRK' => __( 'Perak', 'slicewp' ),
			'PLS' => __( 'Perlis', 'slicewp' ),
			'SBH' => __( 'Sabah', 'slicewp' ),
			'SWK' => __( 'Sarawak', 'slicewp' ),
			'SGR' => __( 'Selangor', 'slicewp' ),
			'TRG' => __( 'Terengganu', 'slicewp' ),
			'PJY' => __( 'Putrajaya', 'slicewp' ),
			'KUL' => __( 'Kuala Lumpur', 'slicewp' ),
		),
		'MZ' => array( // Mozambique provinces.
			'MZP'   => __( 'Cabo Delgado', 'slicewp' ),
			'MZG'   => __( 'Gaza', 'slicewp' ),
			'MZI'   => __( 'Inhambane', 'slicewp' ),
			'MZB'   => __( 'Manica', 'slicewp' ),
			'MZL'   => __( 'Maputo Province', 'slicewp' ),
			'MZMPM' => __( 'Maputo', 'slicewp' ),
			'MZN'   => __( 'Nampula', 'slicewp' ),
			'MZA'   => __( 'Niassa', 'slicewp' ),
			'MZS'   => __( 'Sofala', 'slicewp' ),
			'MZT'   => __( 'Tete', 'slicewp' ),
			'MZQ'   => __( 'Zambézia', 'slicewp' ),
		),
		'NA' => array( // Namibia regions.
			'ER' => __( 'Erongo', 'slicewp' ),
			'HA' => __( 'Hardap', 'slicewp' ),
			'KA' => __( 'Karas', 'slicewp' ),
			'KE' => __( 'Kavango East', 'slicewp' ),
			'KW' => __( 'Kavango West', 'slicewp' ),
			'KH' => __( 'Khomas', 'slicewp' ),
			'KU' => __( 'Kunene', 'slicewp' ),
			'OW' => __( 'Ohangwena', 'slicewp' ),
			'OH' => __( 'Omaheke', 'slicewp' ),
			'OS' => __( 'Omusati', 'slicewp' ),
			'ON' => __( 'Oshana', 'slicewp' ),
			'OT' => __( 'Oshikoto', 'slicewp' ),
			'OD' => __( 'Otjozondjupa', 'slicewp' ),
			'CA' => __( 'Zambezi', 'slicewp' ),
		),
		'NG' => array( // Nigerian provinces.
			'AB' => __( 'Abia', 'slicewp' ),
			'FC' => __( 'Abuja', 'slicewp' ),
			'AD' => __( 'Adamawa', 'slicewp' ),
			'AK' => __( 'Akwa Ibom', 'slicewp' ),
			'AN' => __( 'Anambra', 'slicewp' ),
			'BA' => __( 'Bauchi', 'slicewp' ),
			'BY' => __( 'Bayelsa', 'slicewp' ),
			'BE' => __( 'Benue', 'slicewp' ),
			'BO' => __( 'Borno', 'slicewp' ),
			'CR' => __( 'Cross River', 'slicewp' ),
			'DE' => __( 'Delta', 'slicewp' ),
			'EB' => __( 'Ebonyi', 'slicewp' ),
			'ED' => __( 'Edo', 'slicewp' ),
			'EK' => __( 'Ekiti', 'slicewp' ),
			'EN' => __( 'Enugu', 'slicewp' ),
			'GO' => __( 'Gombe', 'slicewp' ),
			'IM' => __( 'Imo', 'slicewp' ),
			'JI' => __( 'Jigawa', 'slicewp' ),
			'KD' => __( 'Kaduna', 'slicewp' ),
			'KN' => __( 'Kano', 'slicewp' ),
			'KT' => __( 'Katsina', 'slicewp' ),
			'KE' => __( 'Kebbi', 'slicewp' ),
			'KO' => __( 'Kogi', 'slicewp' ),
			'KW' => __( 'Kwara', 'slicewp' ),
			'LA' => __( 'Lagos', 'slicewp' ),
			'NA' => __( 'Nasarawa', 'slicewp' ),
			'NI' => __( 'Niger', 'slicewp' ),
			'OG' => __( 'Ogun', 'slicewp' ),
			'ON' => __( 'Ondo', 'slicewp' ),
			'OS' => __( 'Osun', 'slicewp' ),
			'OY' => __( 'Oyo', 'slicewp' ),
			'PL' => __( 'Plateau', 'slicewp' ),
			'RI' => __( 'Rivers', 'slicewp' ),
			'SO' => __( 'Sokoto', 'slicewp' ),
			'TA' => __( 'Taraba', 'slicewp' ),
			'YO' => __( 'Yobe', 'slicewp' ),
			'ZA' => __( 'Zamfara', 'slicewp' ),
		),
		'NL' => array(),
		'NO' => array(),
		'NP' => array( // Nepal states (Zones).
			'BAG' => __( 'Bagmati', 'slicewp' ),
			'BHE' => __( 'Bheri', 'slicewp' ),
			'DHA' => __( 'Dhaulagiri', 'slicewp' ),
			'GAN' => __( 'Gandaki', 'slicewp' ),
			'JAN' => __( 'Janakpur', 'slicewp' ),
			'KAR' => __( 'Karnali', 'slicewp' ),
			'KOS' => __( 'Koshi', 'slicewp' ),
			'LUM' => __( 'Lumbini', 'slicewp' ),
			'MAH' => __( 'Mahakali', 'slicewp' ),
			'MEC' => __( 'Mechi', 'slicewp' ),
			'NAR' => __( 'Narayani', 'slicewp' ),
			'RAP' => __( 'Rapti', 'slicewp' ),
			'SAG' => __( 'Sagarmatha', 'slicewp' ),
			'SET' => __( 'Seti', 'slicewp' ),
		),
		'NZ' => array( // New Zealand States.
			'NL' => __( 'Northland', 'slicewp' ),
			'AK' => __( 'Auckland', 'slicewp' ),
			'WA' => __( 'Waikato', 'slicewp' ),
			'BP' => __( 'Bay of Plenty', 'slicewp' ),
			'TK' => __( 'Taranaki', 'slicewp' ),
			'GI' => __( 'Gisborne', 'slicewp' ),
			'HB' => __( 'Hawke’s Bay', 'slicewp' ),
			'MW' => __( 'Manawatu-Wanganui', 'slicewp' ),
			'WE' => __( 'Wellington', 'slicewp' ),
			'NS' => __( 'Nelson', 'slicewp' ),
			'MB' => __( 'Marlborough', 'slicewp' ),
			'TM' => __( 'Tasman', 'slicewp' ),
			'WC' => __( 'West Coast', 'slicewp' ),
			'CT' => __( 'Canterbury', 'slicewp' ),
			'OT' => __( 'Otago', 'slicewp' ),
			'SL' => __( 'Southland', 'slicewp' ),
		),
		'PE' => array( // Peru states.
			'CAL' => __( 'El Callao', 'slicewp' ),
			'LMA' => __( 'Municipalidad Metropolitana de Lima', 'slicewp' ),
			'AMA' => __( 'Amazonas', 'slicewp' ),
			'ANC' => __( 'Ancash', 'slicewp' ),
			'APU' => __( 'Apurímac', 'slicewp' ),
			'ARE' => __( 'Arequipa', 'slicewp' ),
			'AYA' => __( 'Ayacucho', 'slicewp' ),
			'CAJ' => __( 'Cajamarca', 'slicewp' ),
			'CUS' => __( 'Cusco', 'slicewp' ),
			'HUV' => __( 'Huancavelica', 'slicewp' ),
			'HUC' => __( 'Huánuco', 'slicewp' ),
			'ICA' => __( 'Ica', 'slicewp' ),
			'JUN' => __( 'Junín', 'slicewp' ),
			'LAL' => __( 'La Libertad', 'slicewp' ),
			'LAM' => __( 'Lambayeque', 'slicewp' ),
			'LIM' => __( 'Lima', 'slicewp' ),
			'LOR' => __( 'Loreto', 'slicewp' ),
			'MDD' => __( 'Madre de Dios', 'slicewp' ),
			'MOQ' => __( 'Moquegua', 'slicewp' ),
			'PAS' => __( 'Pasco', 'slicewp' ),
			'PIU' => __( 'Piura', 'slicewp' ),
			'PUN' => __( 'Puno', 'slicewp' ),
			'SAM' => __( 'San Martín', 'slicewp' ),
			'TAC' => __( 'Tacna', 'slicewp' ),
			'TUM' => __( 'Tumbes', 'slicewp' ),
			'UCA' => __( 'Ucayali', 'slicewp' ),
		),

		/**
		 * Philippine Provinces.
		 */
		'PH' => array(
			'ABR' => __( 'Abra', 'slicewp' ),
			'AGN' => __( 'Agusan del Norte', 'slicewp' ),
			'AGS' => __( 'Agusan del Sur', 'slicewp' ),
			'AKL' => __( 'Aklan', 'slicewp' ),
			'ALB' => __( 'Albay', 'slicewp' ),
			'ANT' => __( 'Antique', 'slicewp' ),
			'APA' => __( 'Apayao', 'slicewp' ),
			'AUR' => __( 'Aurora', 'slicewp' ),
			'BAS' => __( 'Basilan', 'slicewp' ),
			'BAN' => __( 'Bataan', 'slicewp' ),
			'BTN' => __( 'Batanes', 'slicewp' ),
			'BTG' => __( 'Batangas', 'slicewp' ),
			'BEN' => __( 'Benguet', 'slicewp' ),
			'BIL' => __( 'Biliran', 'slicewp' ),
			'BOH' => __( 'Bohol', 'slicewp' ),
			'BUK' => __( 'Bukidnon', 'slicewp' ),
			'BUL' => __( 'Bulacan', 'slicewp' ),
			'CAG' => __( 'Cagayan', 'slicewp' ),
			'CAN' => __( 'Camarines Norte', 'slicewp' ),
			'CAS' => __( 'Camarines Sur', 'slicewp' ),
			'CAM' => __( 'Camiguin', 'slicewp' ),
			'CAP' => __( 'Capiz', 'slicewp' ),
			'CAT' => __( 'Catanduanes', 'slicewp' ),
			'CAV' => __( 'Cavite', 'slicewp' ),
			'CEB' => __( 'Cebu', 'slicewp' ),
			'COM' => __( 'Compostela Valley', 'slicewp' ),
			'NCO' => __( 'Cotabato', 'slicewp' ),
			'DAV' => __( 'Davao del Norte', 'slicewp' ),
			'DAS' => __( 'Davao del Sur', 'slicewp' ),
			'DAC' => __( 'Davao Occidental', 'slicewp' ),
			'DAO' => __( 'Davao Oriental', 'slicewp' ),
			'DIN' => __( 'Dinagat Islands', 'slicewp' ),
			'EAS' => __( 'Eastern Samar', 'slicewp' ),
			'GUI' => __( 'Guimaras', 'slicewp' ),
			'IFU' => __( 'Ifugao', 'slicewp' ),
			'ILN' => __( 'Ilocos Norte', 'slicewp' ),
			'ILS' => __( 'Ilocos Sur', 'slicewp' ),
			'ILI' => __( 'Iloilo', 'slicewp' ),
			'ISA' => __( 'Isabela', 'slicewp' ),
			'KAL' => __( 'Kalinga', 'slicewp' ),
			'LUN' => __( 'La Union', 'slicewp' ),
			'LAG' => __( 'Laguna', 'slicewp' ),
			'LAN' => __( 'Lanao del Norte', 'slicewp' ),
			'LAS' => __( 'Lanao del Sur', 'slicewp' ),
			'LEY' => __( 'Leyte', 'slicewp' ),
			'MAG' => __( 'Maguindanao', 'slicewp' ),
			'MAD' => __( 'Marinduque', 'slicewp' ),
			'MAS' => __( 'Masbate', 'slicewp' ),
			'MSC' => __( 'Misamis Occidental', 'slicewp' ),
			'MSR' => __( 'Misamis Oriental', 'slicewp' ),
			'MOU' => __( 'Mountain Province', 'slicewp' ),
			'NEC' => __( 'Negros Occidental', 'slicewp' ),
			'NER' => __( 'Negros Oriental', 'slicewp' ),
			'NSA' => __( 'Northern Samar', 'slicewp' ),
			'NUE' => __( 'Nueva Ecija', 'slicewp' ),
			'NUV' => __( 'Nueva Vizcaya', 'slicewp' ),
			'MDC' => __( 'Occidental Mindoro', 'slicewp' ),
			'MDR' => __( 'Oriental Mindoro', 'slicewp' ),
			'PLW' => __( 'Palawan', 'slicewp' ),
			'PAM' => __( 'Pampanga', 'slicewp' ),
			'PAN' => __( 'Pangasinan', 'slicewp' ),
			'QUE' => __( 'Quezon', 'slicewp' ),
			'QUI' => __( 'Quirino', 'slicewp' ),
			'RIZ' => __( 'Rizal', 'slicewp' ),
			'ROM' => __( 'Romblon', 'slicewp' ),
			'WSA' => __( 'Samar', 'slicewp' ),
			'SAR' => __( 'Sarangani', 'slicewp' ),
			'SIQ' => __( 'Siquijor', 'slicewp' ),
			'SOR' => __( 'Sorsogon', 'slicewp' ),
			'SCO' => __( 'South Cotabato', 'slicewp' ),
			'SLE' => __( 'Southern Leyte', 'slicewp' ),
			'SUK' => __( 'Sultan Kudarat', 'slicewp' ),
			'SLU' => __( 'Sulu', 'slicewp' ),
			'SUN' => __( 'Surigao del Norte', 'slicewp' ),
			'SUR' => __( 'Surigao del Sur', 'slicewp' ),
			'TAR' => __( 'Tarlac', 'slicewp' ),
			'TAW' => __( 'Tawi-Tawi', 'slicewp' ),
			'ZMB' => __( 'Zambales', 'slicewp' ),
			'ZAN' => __( 'Zamboanga del Norte', 'slicewp' ),
			'ZAS' => __( 'Zamboanga del Sur', 'slicewp' ),
			'ZSI' => __( 'Zamboanga Sibugay', 'slicewp' ),
			'00'  => __( 'Metro Manila', 'slicewp' ),
		),
		'PK' => array( // Pakistan's states.
			'JK' => __( 'Azad Kashmir', 'slicewp' ),
			'BA' => __( 'Balochistan', 'slicewp' ),
			'TA' => __( 'FATA', 'slicewp' ),
			'GB' => __( 'Gilgit Baltistan', 'slicewp' ),
			'IS' => __( 'Islamabad Capital Territory', 'slicewp' ),
			'KP' => __( 'Khyber Pakhtunkhwa', 'slicewp' ),
			'PB' => __( 'Punjab', 'slicewp' ),
			'SD' => __( 'Sindh', 'slicewp' ),
		),
		'PL' => array(),
		'PR' => array(),
		'PT' => array(),
		'PY' => array( // Paraguay states.
			'PY-ASU' => __( 'Asunción', 'slicewp' ),
			'PY-1'   => __( 'Concepción', 'slicewp' ),
			'PY-2'   => __( 'San Pedro', 'slicewp' ),
			'PY-3'   => __( 'Cordillera', 'slicewp' ),
			'PY-4'   => __( 'Guairá', 'slicewp' ),
			'PY-5'   => __( 'Caaguazú', 'slicewp' ),
			'PY-6'   => __( 'Caazapá', 'slicewp' ),
			'PY-7'   => __( 'Itapúa', 'slicewp' ),
			'PY-8'   => __( 'Misiones', 'slicewp' ),
			'PY-9'   => __( 'Paraguarí', 'slicewp' ),
			'PY-10'  => __( 'Alto Paraná', 'slicewp' ),
			'PY-11'  => __( 'Central', 'slicewp' ),
			'PY-12'  => __( 'Ñeembucú', 'slicewp' ),
			'PY-13'  => __( 'Amambay', 'slicewp' ),
			'PY-14'  => __( 'Canindeyú', 'slicewp' ),
			'PY-15'  => __( 'Presidente Hayes', 'slicewp' ),
			'PY-16'  => __( 'Alto Paraguay', 'slicewp' ),
			'PY-17'  => __( 'Boquerón', 'slicewp' ),
		),
		'RE' => array(),
		'RO' => array( // Romania states.
			'AB' => __( 'Alba', 'slicewp' ),
			'AR' => __( 'Arad', 'slicewp' ),
			'AG' => __( 'Argeș', 'slicewp' ),
			'BC' => __( 'Bacău', 'slicewp' ),
			'BH' => __( 'Bihor', 'slicewp' ),
			'BN' => __( 'Bistrița-Năsăud', 'slicewp' ),
			'BT' => __( 'Botoșani', 'slicewp' ),
			'BR' => __( 'Brăila', 'slicewp' ),
			'BV' => __( 'Brașov', 'slicewp' ),
			'B'  => __( 'București', 'slicewp' ),
			'BZ' => __( 'Buzău', 'slicewp' ),
			'CL' => __( 'Călărași', 'slicewp' ),
			'CS' => __( 'Caraș-Severin', 'slicewp' ),
			'CJ' => __( 'Cluj', 'slicewp' ),
			'CT' => __( 'Constanța', 'slicewp' ),
			'CV' => __( 'Covasna', 'slicewp' ),
			'DB' => __( 'Dâmbovița', 'slicewp' ),
			'DJ' => __( 'Dolj', 'slicewp' ),
			'GL' => __( 'Galați', 'slicewp' ),
			'GR' => __( 'Giurgiu', 'slicewp' ),
			'GJ' => __( 'Gorj', 'slicewp' ),
			'HR' => __( 'Harghita', 'slicewp' ),
			'HD' => __( 'Hunedoara', 'slicewp' ),
			'IL' => __( 'Ialomița', 'slicewp' ),
			'IS' => __( 'Iași', 'slicewp' ),
			'IF' => __( 'Ilfov', 'slicewp' ),
			'MM' => __( 'Maramureș', 'slicewp' ),
			'MH' => __( 'Mehedinți', 'slicewp' ),
			'MS' => __( 'Mureș', 'slicewp' ),
			'NT' => __( 'Neamț', 'slicewp' ),
			'OT' => __( 'Olt', 'slicewp' ),
			'PH' => __( 'Prahova', 'slicewp' ),
			'SJ' => __( 'Sălaj', 'slicewp' ),
			'SM' => __( 'Satu Mare', 'slicewp' ),
			'SB' => __( 'Sibiu', 'slicewp' ),
			'SV' => __( 'Suceava', 'slicewp' ),
			'TR' => __( 'Teleorman', 'slicewp' ),
			'TM' => __( 'Timiș', 'slicewp' ),
			'TL' => __( 'Tulcea', 'slicewp' ),
			'VL' => __( 'Vâlcea', 'slicewp' ),
			'VS' => __( 'Vaslui', 'slicewp' ),
			'VN' => __( 'Vrancea', 'slicewp' ),
		),
		'RS' => array(),
		'SG' => array(),
		'SK' => array(),
		'SI' => array(),
		'TH' => array( // Thailand states.
			'TH-37' => __( 'Amnat Charoen', 'slicewp' ),
			'TH-15' => __( 'Ang Thong', 'slicewp' ),
			'TH-14' => __( 'Ayutthaya', 'slicewp' ),
			'TH-10' => __( 'Bangkok', 'slicewp' ),
			'TH-38' => __( 'Bueng Kan', 'slicewp' ),
			'TH-31' => __( 'Buri Ram', 'slicewp' ),
			'TH-24' => __( 'Chachoengsao', 'slicewp' ),
			'TH-18' => __( 'Chai Nat', 'slicewp' ),
			'TH-36' => __( 'Chaiyaphum', 'slicewp' ),
			'TH-22' => __( 'Chanthaburi', 'slicewp' ),
			'TH-50' => __( 'Chiang Mai', 'slicewp' ),
			'TH-57' => __( 'Chiang Rai', 'slicewp' ),
			'TH-20' => __( 'Chonburi', 'slicewp' ),
			'TH-86' => __( 'Chumphon', 'slicewp' ),
			'TH-46' => __( 'Kalasin', 'slicewp' ),
			'TH-62' => __( 'Kamphaeng Phet', 'slicewp' ),
			'TH-71' => __( 'Kanchanaburi', 'slicewp' ),
			'TH-40' => __( 'Khon Kaen', 'slicewp' ),
			'TH-81' => __( 'Krabi', 'slicewp' ),
			'TH-52' => __( 'Lampang', 'slicewp' ),
			'TH-51' => __( 'Lamphun', 'slicewp' ),
			'TH-42' => __( 'Loei', 'slicewp' ),
			'TH-16' => __( 'Lopburi', 'slicewp' ),
			'TH-58' => __( 'Mae Hong Son', 'slicewp' ),
			'TH-44' => __( 'Maha Sarakham', 'slicewp' ),
			'TH-49' => __( 'Mukdahan', 'slicewp' ),
			'TH-26' => __( 'Nakhon Nayok', 'slicewp' ),
			'TH-73' => __( 'Nakhon Pathom', 'slicewp' ),
			'TH-48' => __( 'Nakhon Phanom', 'slicewp' ),
			'TH-30' => __( 'Nakhon Ratchasima', 'slicewp' ),
			'TH-60' => __( 'Nakhon Sawan', 'slicewp' ),
			'TH-80' => __( 'Nakhon Si Thammarat', 'slicewp' ),
			'TH-55' => __( 'Nan', 'slicewp' ),
			'TH-96' => __( 'Narathiwat', 'slicewp' ),
			'TH-39' => __( 'Nong Bua Lam Phu', 'slicewp' ),
			'TH-43' => __( 'Nong Khai', 'slicewp' ),
			'TH-12' => __( 'Nonthaburi', 'slicewp' ),
			'TH-13' => __( 'Pathum Thani', 'slicewp' ),
			'TH-94' => __( 'Pattani', 'slicewp' ),
			'TH-82' => __( 'Phang Nga', 'slicewp' ),
			'TH-93' => __( 'Phatthalung', 'slicewp' ),
			'TH-56' => __( 'Phayao', 'slicewp' ),
			'TH-67' => __( 'Phetchabun', 'slicewp' ),
			'TH-76' => __( 'Phetchaburi', 'slicewp' ),
			'TH-66' => __( 'Phichit', 'slicewp' ),
			'TH-65' => __( 'Phitsanulok', 'slicewp' ),
			'TH-54' => __( 'Phrae', 'slicewp' ),
			'TH-83' => __( 'Phuket', 'slicewp' ),
			'TH-25' => __( 'Prachin Buri', 'slicewp' ),
			'TH-77' => __( 'Prachuap Khiri Khan', 'slicewp' ),
			'TH-85' => __( 'Ranong', 'slicewp' ),
			'TH-70' => __( 'Ratchaburi', 'slicewp' ),
			'TH-21' => __( 'Rayong', 'slicewp' ),
			'TH-45' => __( 'Roi Et', 'slicewp' ),
			'TH-27' => __( 'Sa Kaeo', 'slicewp' ),
			'TH-47' => __( 'Sakon Nakhon', 'slicewp' ),
			'TH-11' => __( 'Samut Prakan', 'slicewp' ),
			'TH-74' => __( 'Samut Sakhon', 'slicewp' ),
			'TH-75' => __( 'Samut Songkhram', 'slicewp' ),
			'TH-19' => __( 'Saraburi', 'slicewp' ),
			'TH-91' => __( 'Satun', 'slicewp' ),
			'TH-17' => __( 'Sing Buri', 'slicewp' ),
			'TH-33' => __( 'Sisaket', 'slicewp' ),
			'TH-90' => __( 'Songkhla', 'slicewp' ),
			'TH-64' => __( 'Sukhothai', 'slicewp' ),
			'TH-72' => __( 'Suphan Buri', 'slicewp' ),
			'TH-84' => __( 'Surat Thani', 'slicewp' ),
			'TH-32' => __( 'Surin', 'slicewp' ),
			'TH-63' => __( 'Tak', 'slicewp' ),
			'TH-92' => __( 'Trang', 'slicewp' ),
			'TH-23' => __( 'Trat', 'slicewp' ),
			'TH-34' => __( 'Ubon Ratchathani', 'slicewp' ),
			'TH-41' => __( 'Udon Thani', 'slicewp' ),
			'TH-61' => __( 'Uthai Thani', 'slicewp' ),
			'TH-53' => __( 'Uttaradit', 'slicewp' ),
			'TH-95' => __( 'Yala', 'slicewp' ),
			'TH-35' => __( 'Yasothon', 'slicewp' ),
		),
		'TR' => array( // Turkey States.
			'TR01' => __( 'Adana', 'slicewp' ),
			'TR02' => __( 'Adıyaman', 'slicewp' ),
			'TR03' => __( 'Afyon', 'slicewp' ),
			'TR04' => __( 'Ağrı', 'slicewp' ),
			'TR05' => __( 'Amasya', 'slicewp' ),
			'TR06' => __( 'Ankara', 'slicewp' ),
			'TR07' => __( 'Antalya', 'slicewp' ),
			'TR08' => __( 'Artvin', 'slicewp' ),
			'TR09' => __( 'Aydın', 'slicewp' ),
			'TR10' => __( 'Balıkesir', 'slicewp' ),
			'TR11' => __( 'Bilecik', 'slicewp' ),
			'TR12' => __( 'Bingöl', 'slicewp' ),
			'TR13' => __( 'Bitlis', 'slicewp' ),
			'TR14' => __( 'Bolu', 'slicewp' ),
			'TR15' => __( 'Burdur', 'slicewp' ),
			'TR16' => __( 'Bursa', 'slicewp' ),
			'TR17' => __( 'Çanakkale', 'slicewp' ),
			'TR18' => __( 'Çankırı', 'slicewp' ),
			'TR19' => __( 'Çorum', 'slicewp' ),
			'TR20' => __( 'Denizli', 'slicewp' ),
			'TR21' => __( 'Diyarbakır', 'slicewp' ),
			'TR22' => __( 'Edirne', 'slicewp' ),
			'TR23' => __( 'Elazığ', 'slicewp' ),
			'TR24' => __( 'Erzincan', 'slicewp' ),
			'TR25' => __( 'Erzurum', 'slicewp' ),
			'TR26' => __( 'Eskişehir', 'slicewp' ),
			'TR27' => __( 'Gaziantep', 'slicewp' ),
			'TR28' => __( 'Giresun', 'slicewp' ),
			'TR29' => __( 'Gümüşhane', 'slicewp' ),
			'TR30' => __( 'Hakkari', 'slicewp' ),
			'TR31' => __( 'Hatay', 'slicewp' ),
			'TR32' => __( 'Isparta', 'slicewp' ),
			'TR33' => __( 'İçel', 'slicewp' ),
			'TR34' => __( 'İstanbul', 'slicewp' ),
			'TR35' => __( 'İzmir', 'slicewp' ),
			'TR36' => __( 'Kars', 'slicewp' ),
			'TR37' => __( 'Kastamonu', 'slicewp' ),
			'TR38' => __( 'Kayseri', 'slicewp' ),
			'TR39' => __( 'Kırklareli', 'slicewp' ),
			'TR40' => __( 'Kırşehir', 'slicewp' ),
			'TR41' => __( 'Kocaeli', 'slicewp' ),
			'TR42' => __( 'Konya', 'slicewp' ),
			'TR43' => __( 'Kütahya', 'slicewp' ),
			'TR44' => __( 'Malatya', 'slicewp' ),
			'TR45' => __( 'Manisa', 'slicewp' ),
			'TR46' => __( 'Kahramanmaraş', 'slicewp' ),
			'TR47' => __( 'Mardin', 'slicewp' ),
			'TR48' => __( 'Muğla', 'slicewp' ),
			'TR49' => __( 'Muş', 'slicewp' ),
			'TR50' => __( 'Nevşehir', 'slicewp' ),
			'TR51' => __( 'Niğde', 'slicewp' ),
			'TR52' => __( 'Ordu', 'slicewp' ),
			'TR53' => __( 'Rize', 'slicewp' ),
			'TR54' => __( 'Sakarya', 'slicewp' ),
			'TR55' => __( 'Samsun', 'slicewp' ),
			'TR56' => __( 'Siirt', 'slicewp' ),
			'TR57' => __( 'Sinop', 'slicewp' ),
			'TR58' => __( 'Sivas', 'slicewp' ),
			'TR59' => __( 'Tekirdağ', 'slicewp' ),
			'TR60' => __( 'Tokat', 'slicewp' ),
			'TR61' => __( 'Trabzon', 'slicewp' ),
			'TR62' => __( 'Tunceli', 'slicewp' ),
			'TR63' => __( 'Şanlıurfa', 'slicewp' ),
			'TR64' => __( 'Uşak', 'slicewp' ),
			'TR65' => __( 'Van', 'slicewp' ),
			'TR66' => __( 'Yozgat', 'slicewp' ),
			'TR67' => __( 'Zonguldak', 'slicewp' ),
			'TR68' => __( 'Aksaray', 'slicewp' ),
			'TR69' => __( 'Bayburt', 'slicewp' ),
			'TR70' => __( 'Karaman', 'slicewp' ),
			'TR71' => __( 'Kırıkkale', 'slicewp' ),
			'TR72' => __( 'Batman', 'slicewp' ),
			'TR73' => __( 'Şırnak', 'slicewp' ),
			'TR74' => __( 'Bartın', 'slicewp' ),
			'TR75' => __( 'Ardahan', 'slicewp' ),
			'TR76' => __( 'Iğdır', 'slicewp' ),
			'TR77' => __( 'Yalova', 'slicewp' ),
			'TR78' => __( 'Karabük', 'slicewp' ),
			'TR79' => __( 'Kilis', 'slicewp' ),
			'TR80' => __( 'Osmaniye', 'slicewp' ),
			'TR81' => __( 'Düzce', 'slicewp' ),
		),
		'TZ' => array( // Tanzania States.
			'TZ01' => __( 'Arusha', 'slicewp' ),
			'TZ02' => __( 'Dar es Salaam', 'slicewp' ),
			'TZ03' => __( 'Dodoma', 'slicewp' ),
			'TZ04' => __( 'Iringa', 'slicewp' ),
			'TZ05' => __( 'Kagera', 'slicewp' ),
			'TZ06' => __( 'Pemba North', 'slicewp' ),
			'TZ07' => __( 'Zanzibar North', 'slicewp' ),
			'TZ08' => __( 'Kigoma', 'slicewp' ),
			'TZ09' => __( 'Kilimanjaro', 'slicewp' ),
			'TZ10' => __( 'Pemba South', 'slicewp' ),
			'TZ11' => __( 'Zanzibar South', 'slicewp' ),
			'TZ12' => __( 'Lindi', 'slicewp' ),
			'TZ13' => __( 'Mara', 'slicewp' ),
			'TZ14' => __( 'Mbeya', 'slicewp' ),
			'TZ15' => __( 'Zanzibar West', 'slicewp' ),
			'TZ16' => __( 'Morogoro', 'slicewp' ),
			'TZ17' => __( 'Mtwara', 'slicewp' ),
			'TZ18' => __( 'Mwanza', 'slicewp' ),
			'TZ19' => __( 'Coast', 'slicewp' ),
			'TZ20' => __( 'Rukwa', 'slicewp' ),
			'TZ21' => __( 'Ruvuma', 'slicewp' ),
			'TZ22' => __( 'Shinyanga', 'slicewp' ),
			'TZ23' => __( 'Singida', 'slicewp' ),
			'TZ24' => __( 'Tabora', 'slicewp' ),
			'TZ25' => __( 'Tanga', 'slicewp' ),
			'TZ26' => __( 'Manyara', 'slicewp' ),
			'TZ27' => __( 'Geita', 'slicewp' ),
			'TZ28' => __( 'Katavi', 'slicewp' ),
			'TZ29' => __( 'Njombe', 'slicewp' ),
			'TZ30' => __( 'Simiyu', 'slicewp' ),
		),
		'LK' => array(),
		'RS' => array( // Serbia districts Ref: https://github.com/unicode-org/cldr/blob/release-37/common/subdivisions/en.xml#L4251-L4283.
			'RS00' => _x( 'Belgrade', 'district', 'slicewp' ),
			'RS14' => _x( 'Bor', 'district', 'slicewp' ),
			'RS11' => _x( 'Braničevo', 'district', 'slicewp' ),
			'RS02' => _x( 'Central Banat', 'district', 'slicewp' ),
			'RS10' => _x( 'Danube', 'district', 'slicewp' ),
			'RS23' => _x( 'Jablanica', 'district', 'slicewp' ),
			'RS09' => _x( 'Kolubara', 'district', 'slicewp' ),
			'RS08' => _x( 'Mačva', 'district', 'slicewp' ),
			'RS17' => _x( 'Morava', 'district', 'slicewp' ),
			'RS20' => _x( 'Nišava', 'district', 'slicewp' ),
			'RS01' => _x( 'North Bačka', 'district', 'slicewp' ),
			'RS03' => _x( 'North Banat', 'district', 'slicewp' ),
			'RS24' => _x( 'Pčinja', 'district', 'slicewp' ),
			'RS22' => _x( 'Pirot', 'district', 'slicewp' ),
			'RS13' => _x( 'Pomoravlje', 'district', 'slicewp' ),
			'RS19' => _x( 'Rasina', 'district', 'slicewp' ),
			'RS18' => _x( 'Raška', 'district', 'slicewp' ),
			'RS06' => _x( 'South Bačka', 'district', 'slicewp' ),
			'RS04' => _x( 'South Banat', 'district', 'slicewp' ),
			'RS07' => _x( 'Srem', 'district', 'slicewp' ),
			'RS12' => _x( 'Šumadija', 'district', 'slicewp' ),
			'RS21' => _x( 'Toplica', 'district', 'slicewp' ),
			'RS05' => _x( 'West Bačka', 'district', 'slicewp' ),
			'RS15' => _x( 'Zaječar', 'district', 'slicewp' ),
			'RS16' => _x( 'Zlatibor', 'district', 'slicewp' ),
			'RS25' => _x( 'Kosovo', 'district', 'slicewp' ),
			'RS26' => _x( 'Peć', 'district', 'slicewp' ),
			'RS27' => _x( 'Prizren', 'district', 'slicewp' ),
			'RS28' => _x( 'Kosovska Mitrovica', 'district', 'slicewp' ),
			'RS29' => _x( 'Kosovo-Pomoravlje', 'district', 'slicewp' ),
			'RSKM' => _x( 'Kosovo-Metohija', 'district', 'slicewp' ),
			'RSVO' => _x( 'Vojvodina', 'district', 'slicewp' ),
		),
		'SE' => array(),
		'UG' => array( // Uganda districts. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:UG.
			'UG314' => __( 'Abim', 'slicewp' ),
			'UG301' => __( 'Adjumani', 'slicewp' ),
			'UG322' => __( 'Agago', 'slicewp' ),
			'UG323' => __( 'Alebtong', 'slicewp' ),
			'UG315' => __( 'Amolatar', 'slicewp' ),
			'UG324' => __( 'Amudat', 'slicewp' ),
			'UG216' => __( 'Amuria', 'slicewp' ),
			'UG316' => __( 'Amuru', 'slicewp' ),
			'UG302' => __( 'Apac', 'slicewp' ),
			'UG303' => __( 'Arua', 'slicewp' ),
			'UG217' => __( 'Budaka', 'slicewp' ),
			'UG218' => __( 'Bududa', 'slicewp' ),
			'UG201' => __( 'Bugiri', 'slicewp' ),
			'UG235' => __( 'Bugweri', 'slicewp' ),
			'UG420' => __( 'Buhweju', 'slicewp' ),
			'UG117' => __( 'Buikwe', 'slicewp' ),
			'UG219' => __( 'Bukedea', 'slicewp' ),
			'UG118' => __( 'Bukomansimbi', 'slicewp' ),
			'UG220' => __( 'Bukwa', 'slicewp' ),
			'UG225' => __( 'Bulambuli', 'slicewp' ),
			'UG416' => __( 'Buliisa', 'slicewp' ),
			'UG401' => __( 'Bundibugyo', 'slicewp' ),
			'UG430' => __( 'Bunyangabu', 'slicewp' ),
			'UG402' => __( 'Bushenyi', 'slicewp' ),
			'UG202' => __( 'Busia', 'slicewp' ),
			'UG221' => __( 'Butaleja', 'slicewp' ),
			'UG119' => __( 'Butambala', 'slicewp' ),
			'UG233' => __( 'Butebo', 'slicewp' ),
			'UG120' => __( 'Buvuma', 'slicewp' ),
			'UG226' => __( 'Buyende', 'slicewp' ),
			'UG317' => __( 'Dokolo', 'slicewp' ),
			'UG121' => __( 'Gomba', 'slicewp' ),
			'UG304' => __( 'Gulu', 'slicewp' ),
			'UG403' => __( 'Hoima', 'slicewp' ),
			'UG417' => __( 'Ibanda', 'slicewp' ),
			'UG203' => __( 'Iganga', 'slicewp' ),
			'UG418' => __( 'Isingiro', 'slicewp' ),
			'UG204' => __( 'Jinja', 'slicewp' ),
			'UG318' => __( 'Kaabong', 'slicewp' ),
			'UG404' => __( 'Kabale', 'slicewp' ),
			'UG405' => __( 'Kabarole', 'slicewp' ),
			'UG213' => __( 'Kaberamaido', 'slicewp' ),
			'UG427' => __( 'Kagadi', 'slicewp' ),
			'UG428' => __( 'Kakumiro', 'slicewp' ),
			'UG101' => __( 'Kalangala', 'slicewp' ),
			'UG222' => __( 'Kaliro', 'slicewp' ),
			'UG122' => __( 'Kalungu', 'slicewp' ),
			'UG102' => __( 'Kampala', 'slicewp' ),
			'UG205' => __( 'Kamuli', 'slicewp' ),
			'UG413' => __( 'Kamwenge', 'slicewp' ),
			'UG414' => __( 'Kanungu', 'slicewp' ),
			'UG206' => __( 'Kapchorwa', 'slicewp' ),
			'UG236' => __( 'Kapelebyong', 'slicewp' ),
			'UG126' => __( 'Kasanda', 'slicewp' ),
			'UG406' => __( 'Kasese', 'slicewp' ),
			'UG207' => __( 'Katakwi', 'slicewp' ),
			'UG112' => __( 'Kayunga', 'slicewp' ),
			'UG407' => __( 'Kibaale', 'slicewp' ),
			'UG103' => __( 'Kiboga', 'slicewp' ),
			'UG227' => __( 'Kibuku', 'slicewp' ),
			'UG432' => __( 'Kikuube', 'slicewp' ),
			'UG419' => __( 'Kiruhura', 'slicewp' ),
			'UG421' => __( 'Kiryandongo', 'slicewp' ),
			'UG408' => __( 'Kisoro', 'slicewp' ),
			'UG305' => __( 'Kitgum', 'slicewp' ),
			'UG319' => __( 'Koboko', 'slicewp' ),
			'UG325' => __( 'Kole', 'slicewp' ),
			'UG306' => __( 'Kotido', 'slicewp' ),
			'UG208' => __( 'Kumi', 'slicewp' ),
			'UG333' => __( 'Kwania', 'slicewp' ),
			'UG228' => __( 'Kween', 'slicewp' ),
			'UG123' => __( 'Kyankwanzi', 'slicewp' ),
			'UG422' => __( 'Kyegegwa', 'slicewp' ),
			'UG415' => __( 'Kyenjojo', 'slicewp' ),
			'UG125' => __( 'Kyotera', 'slicewp' ),
			'UG326' => __( 'Lamwo', 'slicewp' ),
			'UG307' => __( 'Lira', 'slicewp' ),
			'UG229' => __( 'Luuka', 'slicewp' ),
			'UG104' => __( 'Luwero', 'slicewp' ),
			'UG124' => __( 'Lwengo', 'slicewp' ),
			'UG114' => __( 'Lyantonde', 'slicewp' ),
			'UG223' => __( 'Manafwa', 'slicewp' ),
			'UG320' => __( 'Maracha', 'slicewp' ),
			'UG105' => __( 'Masaka', 'slicewp' ),
			'UG409' => __( 'Masindi', 'slicewp' ),
			'UG214' => __( 'Mayuge', 'slicewp' ),
			'UG209' => __( 'Mbale', 'slicewp' ),
			'UG410' => __( 'Mbarara', 'slicewp' ),
			'UG423' => __( 'Mitooma', 'slicewp' ),
			'UG115' => __( 'Mityana', 'slicewp' ),
			'UG308' => __( 'Moroto', 'slicewp' ),
			'UG309' => __( 'Moyo', 'slicewp' ),
			'UG106' => __( 'Mpigi', 'slicewp' ),
			'UG107' => __( 'Mubende', 'slicewp' ),
			'UG108' => __( 'Mukono', 'slicewp' ),
			'UG334' => __( 'Nabilatuk', 'slicewp' ),
			'UG311' => __( 'Nakapiripirit', 'slicewp' ),
			'UG116' => __( 'Nakaseke', 'slicewp' ),
			'UG109' => __( 'Nakasongola', 'slicewp' ),
			'UG230' => __( 'Namayingo', 'slicewp' ),
			'UG234' => __( 'Namisindwa', 'slicewp' ),
			'UG224' => __( 'Namutumba', 'slicewp' ),
			'UG327' => __( 'Napak', 'slicewp' ),
			'UG310' => __( 'Nebbi', 'slicewp' ),
			'UG231' => __( 'Ngora', 'slicewp' ),
			'UG424' => __( 'Ntoroko', 'slicewp' ),
			'UG411' => __( 'Ntungamo', 'slicewp' ),
			'UG328' => __( 'Nwoya', 'slicewp' ),
			'UG331' => __( 'Omoro', 'slicewp' ),
			'UG329' => __( 'Otuke', 'slicewp' ),
			'UG321' => __( 'Oyam', 'slicewp' ),
			'UG312' => __( 'Pader', 'slicewp' ),
			'UG332' => __( 'Pakwach', 'slicewp' ),
			'UG210' => __( 'Pallisa', 'slicewp' ),
			'UG110' => __( 'Rakai', 'slicewp' ),
			'UG429' => __( 'Rubanda', 'slicewp' ),
			'UG425' => __( 'Rubirizi', 'slicewp' ),
			'UG431' => __( 'Rukiga', 'slicewp' ),
			'UG412' => __( 'Rukungiri', 'slicewp' ),
			'UG111' => __( 'Sembabule', 'slicewp' ),
			'UG232' => __( 'Serere', 'slicewp' ),
			'UG426' => __( 'Sheema', 'slicewp' ),
			'UG215' => __( 'Sironko', 'slicewp' ),
			'UG211' => __( 'Soroti', 'slicewp' ),
			'UG212' => __( 'Tororo', 'slicewp' ),
			'UG113' => __( 'Wakiso', 'slicewp' ),
			'UG313' => __( 'Yumbe', 'slicewp' ),
			'UG330' => __( 'Zombo', 'slicewp' ),
		),
		'UM' => array(
			'81' => __( 'Baker Island', 'slicewp' ),
			'84' => __( 'Howland Island', 'slicewp' ),
			'86' => __( 'Jarvis Island', 'slicewp' ),
			'67' => __( 'Johnston Atoll', 'slicewp' ),
			'89' => __( 'Kingman Reef', 'slicewp' ),
			'71' => __( 'Midway Atoll', 'slicewp' ),
			'76' => __( 'Navassa Island', 'slicewp' ),
			'95' => __( 'Palmyra Atoll', 'slicewp' ),
			'79' => __( 'Wake Island', 'slicewp' ),
		),
		'US' => array( // United States.
			'AL' => __( 'Alabama', 'slicewp' ),
			'AK' => __( 'Alaska', 'slicewp' ),
			'AZ' => __( 'Arizona', 'slicewp' ),
			'AR' => __( 'Arkansas', 'slicewp' ),
			'CA' => __( 'California', 'slicewp' ),
			'CO' => __( 'Colorado', 'slicewp' ),
			'CT' => __( 'Connecticut', 'slicewp' ),
			'DE' => __( 'Delaware', 'slicewp' ),
			'DC' => __( 'District Of Columbia', 'slicewp' ),
			'FL' => __( 'Florida', 'slicewp' ),
			'GA' => _x( 'Georgia', 'US state of Georgia', 'slicewp' ),
			'HI' => __( 'Hawaii', 'slicewp' ),
			'ID' => __( 'Idaho', 'slicewp' ),
			'IL' => __( 'Illinois', 'slicewp' ),
			'IN' => __( 'Indiana', 'slicewp' ),
			'IA' => __( 'Iowa', 'slicewp' ),
			'KS' => __( 'Kansas', 'slicewp' ),
			'KY' => __( 'Kentucky', 'slicewp' ),
			'LA' => __( 'Louisiana', 'slicewp' ),
			'ME' => __( 'Maine', 'slicewp' ),
			'MD' => __( 'Maryland', 'slicewp' ),
			'MA' => __( 'Massachusetts', 'slicewp' ),
			'MI' => __( 'Michigan', 'slicewp' ),
			'MN' => __( 'Minnesota', 'slicewp' ),
			'MS' => __( 'Mississippi', 'slicewp' ),
			'MO' => __( 'Missouri', 'slicewp' ),
			'MT' => __( 'Montana', 'slicewp' ),
			'NE' => __( 'Nebraska', 'slicewp' ),
			'NV' => __( 'Nevada', 'slicewp' ),
			'NH' => __( 'New Hampshire', 'slicewp' ),
			'NJ' => __( 'New Jersey', 'slicewp' ),
			'NM' => __( 'New Mexico', 'slicewp' ),
			'NY' => __( 'New York', 'slicewp' ),
			'NC' => __( 'North Carolina', 'slicewp' ),
			'ND' => __( 'North Dakota', 'slicewp' ),
			'OH' => __( 'Ohio', 'slicewp' ),
			'OK' => __( 'Oklahoma', 'slicewp' ),
			'OR' => __( 'Oregon', 'slicewp' ),
			'PA' => __( 'Pennsylvania', 'slicewp' ),
			'RI' => __( 'Rhode Island', 'slicewp' ),
			'SC' => __( 'South Carolina', 'slicewp' ),
			'SD' => __( 'South Dakota', 'slicewp' ),
			'TN' => __( 'Tennessee', 'slicewp' ),
			'TX' => __( 'Texas', 'slicewp' ),
			'UT' => __( 'Utah', 'slicewp' ),
			'VT' => __( 'Vermont', 'slicewp' ),
			'VA' => __( 'Virginia', 'slicewp' ),
			'WA' => __( 'Washington', 'slicewp' ),
			'WV' => __( 'West Virginia', 'slicewp' ),
			'WI' => __( 'Wisconsin', 'slicewp' ),
			'WY' => __( 'Wyoming', 'slicewp' ),
			'AA' => __( 'Armed Forces (AA)', 'slicewp' ),
			'AE' => __( 'Armed Forces (AE)', 'slicewp' ),
			'AP' => __( 'Armed Forces (AP)', 'slicewp' ),
		),
		'VN' => array(),
		'YT' => array(),
		'ZA' => array( // South African states.
			'EC'  => __( 'Eastern Cape', 'slicewp' ),
			'FS'  => __( 'Free State', 'slicewp' ),
			'GP'  => __( 'Gauteng', 'slicewp' ),
			'KZN' => __( 'KwaZulu-Natal', 'slicewp' ),
			'LP'  => __( 'Limpopo', 'slicewp' ),
			'MP'  => __( 'Mpumalanga', 'slicewp' ),
			'NC'  => __( 'Northern Cape', 'slicewp' ),
			'NW'  => __( 'North West', 'slicewp' ),
			'WC'  => __( 'Western Cape', 'slicewp' ),
		),
		'ZM' => array( // Zambia's Provinces. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:ZM.
			'ZM-01' => __( 'Western', 'slicewp' ),
			'ZM-02' => __( 'Central', 'slicewp' ),
			'ZM-03' => __( 'Eastern', 'slicewp' ),
			'ZM-04' => __( 'Luapula', 'slicewp' ),
			'ZM-05' => __( 'Northern', 'slicewp' ),
			'ZM-06' => __( 'North-Western', 'slicewp' ),
			'ZM-07' => __( 'Southern', 'slicewp' ),
			'ZM-08' => __( 'Copperbelt', 'slicewp' ),
			'ZM-09' => __( 'Lusaka', 'slicewp' ),
			'ZM-10' => __( 'Muchinga', 'slicewp' ),
		),
	);
	
	/**
	 * Filter states before returning them
	 *
	 */
	$country_states = apply_filters( 'slicewp_country_states', $country_states );

	// Return
	return ( ! empty( $country_code ) ? ( isset( $country_states[$country_code] ) ? $country_states[$country_code] : null ) : $country_states );

}