<?php
/**
 * Admin: meta
 * PHP version 7
 *
 * @category Admin_Meta
 * @package  Sky_Login_Redirect
 * @author   Utopique <support@utopique.net>
 * @license  GPL https://utopique.net
 * @link     https://utopique.net
 */

namespace SkyLoginRedirect\Admin\Meta;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

use function SkyLoginRedirect\Sky_Login_Redirect_fs as Sky_Login_Redirect_fs;

/**
 * Add settings link to plugins page
 *
 * @param array $links The existing links underneath the plugin name.
 *
 * @return array Filtered links array.
 */
function Slr_Settings_link( $links ) {
    $settings_link = sprintf(
        '<a href="%s">%s</a>',
        esc_url( admin_url( 'admin.php?page=sky-login-redirect' ) ),
        esc_html__( 'Settings', 'sky-login-redirect' )
    );
    array_unshift( $links, $settings_link ); // or array_push
    return (array) $links;
}

$plugin_dir_path = plugin_dir_path( dirname( __FILE__, 2 ) );
$plugin          = plugin_basename( $plugin_dir_path . '/sky-login-redirect.php' );

add_filter(
    "plugin_action_links_{$plugin}",
    __NAMESPACE__ . '\\Slr_Settings_link',
    10,
    1
);

/**
 * Add additional useful links to plugins page
 *
 * @param array  $links The links array.
 * @param string $file  The plugin file.
 *
 * @return array Filtered links array.
 */
function Slr_Row_meta( $links, $file ) {
    $plugin_dir_path = plugin_dir_path( dirname( __FILE__, 2 ) );
    //if ($file === plugin_basename(__FILE__)) {
    if ( $file === plugin_basename( $plugin_dir_path . '/sky-login-redirect.php' ) ) {
        $support = 'https://wordpress.org/support/plugin/sky-login-redirect/';
        $row_meta = array(
            'docs'    => '<a href="' . esc_url(
                apply_filters( 'slr_docs_url', 'https://utopique.net/docs/' )
            ) . '" title="' . esc_attr(
                __( 'View Documentation', 'sky-login-redirect' )
            ) . '">' . esc_html__( 'Docs', 'sky-login-redirect' ) . '</a>',
            'support' => '<a href="' . esc_url(
                apply_filters(
                    'slr_support_url',
                    $support
                )
            ) . '" title="' . esc_attr(
                __( 'Contact support', 'sky-login-redirect' )
            ) . '">' . esc_html__( 'Support', 'sky-login-redirect' ) . '</a>',
            'rate' => '<a href="' . esc_url(
                apply_filters(
                    'slr_rate',
                    $support . 'reviews/?rate=5#new-post'
                )
            ) . '" target="_blank" title="' . esc_attr(
                __( 'Rate Sky Login Redirect', 'sky-login-redirect' )
            ) . '">' . esc_html__( 'Rate us', 'sky-login-redirect' ) . '</a>',
        );
        return array_merge( (array) $links, $row_meta );
    }
    return (array) $links;
}
add_filter( 'plugin_row_meta', __NAMESPACE__ . '\\Slr_Row_meta', 10, 2 );

/**
 * Show credits line
 *
 * @param string $footer_text the footer text
 *
 * @return mixed
 */
function Slr_Admin_credits( $footer_text ) {
    $current_screen = get_current_screen();
    if ( ! $current_screen ) {
        return $footer_text;
    }
    $hook = $current_screen->id;
    $array = [
        'toplevel_page_sky-login-redirect',
        'login-redirect_page_sky-login-redirect-account',
        'login-redirect_page_sky-login-redirect-contact',
    ];
    if ( ! in_array( $hook, $array, true ) ) {
        return $footer_text;
    }

    $footer_text = wp_kses(
        sprintf(
            /* translators: 1: Product URL, 2: Product name */
            __( 'Thank you for using <a href="%1$s" target="_blank" rel="noopener noreferrer">%2$s</a>', 'sky-login-redirect' ),
            'https://utopique.net/products/sky-login-redirect-premium/',
            esc_html__( 'Sky Login Redirect', 'sky-login-redirect' )
        ),
        [
            'a' => [
                'href'   => [],
                'target' => [],
                'rel'    => [],
            ],
        ]
    );

    $footer_text .= ' &bull; ' . wp_kses(
        sprintf(
            /* translators: 1: Documentation URL, 2: Link label */
            __( 'Check out the <a href="%1$s" target="_blank" rel="noopener noreferrer">%2$s</a>', 'sky-login-redirect' ),
            'https://utopique.net/docs-category/login-redirect-pro/',
            esc_html__( 'documentation', 'sky-login-redirect' )
        ),
        [
            'a' => [
                'href'   => [],
                'target' => [],
                'rel'    => [],
            ],
        ]
    );

    $Sky_Login_Redirect_fs = Sky_Login_Redirect_fs();
    if ( $Sky_Login_Redirect_fs->is_not_paying()
        || $Sky_Login_Redirect_fs->is_free_plan()
    ) {
        $upgrade_link = sprintf(
            '<strong><a href="%1$s" target="_blank" rel="noopener noreferrer">%2$s</a></strong>',
            esc_url( $Sky_Login_Redirect_fs->get_upgrade_url() ),
            esc_html__( 'Go Pro', 'sky-login-redirect' )
        );
        $footer_text .= ' &bull; ' . wp_kses(
            $upgrade_link,
            [
                'a' => [
                    'href'   => [],
                    'target' => [],
                    'rel'    => [],
                ],
                'strong' => [],
            ]
        );
    }

    return $footer_text;
}
add_filter( 'admin_footer_text', __NAMESPACE__ . '\\Slr_Admin_credits' );
