<?php
/**
 * Login Customizer
 * PHP version 7
 *
 * @category Login_Customizer
 * @package  Sky_Login_Redirect
 * @author   Utopique <support@utopique.net>
 * @license  GPL https://utopique.net
 * @link     https://utopique.net
 */

namespace SkyLoginRedirect\LoginCustomizer;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

/**
 * Define carbonade()
 */
use function SkyLoginRedirect\carbonade as carbonade;

/**
 * Define custom Login URL
 *
 * This allows to filter login_url
 *
 * @param $url          is the current URL
 * @param $redirect     is the redirect URL
 * @param $force_reauth is the force_reauth GET var that can get appended
 *
 * @return $url
 */
function Slr_Custom_Login_page( $url, $redirect, $force_reauth ) {
    if ( is_admin() ) {
        return $url;
    }
    $page = carbonade( 'slr_custom_login_url' );
    if ( $page ) {
        // get slug
        $slug = trailingslashit( basename( (string) parse_url( (string) $page, PHP_URL_PATH ) ) );
        $url  = site_url( $slug );

        if ( ! empty( $redirect ) ) {
            $safe = wp_validate_redirect( (string) $redirect, $url );
            $url  = add_query_arg( 'redirect_to', rawurlencode( $safe ), $url );
        }
        if ( $force_reauth ) {
            $url = add_query_arg( 'reauth', '1', $url );
        }
    }
    return $url;
}
add_filter( 'login_url', __NAMESPACE__ . '\\Slr_Custom_Login_page', 10, 3 );

/**
 * Custom Register URL
 */

/*
add_filter( 'register_url', __NAMESPACE__ . '\\slr_custom_register_page', 10, 1 );
function slr_custom_register_page( $url ) {
if( is_admin() ) {
    return $url;
            }
            $page = carbonade( 'slr_custom_register_url' );
            if ( $page ) :
            // get slug
            $page = trailingslashit( basename( parse_url( $page, PHP_URL_PATH ) ) );
            $url  = site_url( $page );
        endif;
        return $url;
    }
    */



/**
 * Login customizer: logo LINK
 * Change logo link from wordpress.org to our domain
 *
 * @param $url is the default wordpress.org link
 *
 * @return $url
 */
function Slr_Login_Logo_url( $url ) {
    $slr_logo_link = carbonade( 'slr_logo_link' );
    if ( $slr_logo_link == 'yes' ) {
        return home_url( '/' );
    }
}
add_filter( 'login_headerurl', __NAMESPACE__ . '\\Slr_Login_Logo_url', 10, 1 );

/**
 * Login customizer: logo header text
 * Change logo header text
 *
 * @return mixed the site's name
 */
function Slr_Login_Logo_title() {
    $slr_logo_text = carbonade( 'slr_logo_text' );
    if ( $slr_logo_text == 'yes' ) {
        return get_bloginfo( 'name' );
    }
}
add_filter( 'login_headertext', __NAMESPACE__ . '\\Slr_Login_Logo_title' );

/**
 * Login preview
 *
 * @param $hook the current admin hook
 *
 * @return mixed
 */
function Slr_Login_preview( $hook ) {
    if ( 'toplevel_page_sky-login-redirect' !== $hook ) {
        return;
    } ?>
<div id="slr-login-iframe" style="width:100%;border:0;display:none">
<h3 style="margin-left: 1.4rem;font-weight: 400;">
    <?php esc_html_e( 'Save your settings first to see changes &#8623;', 'sky-login-redirect' ); ?>
</h3>
<iframe src="<?php echo esc_url( home_url( '/wp-login.php' ) ); ?>" height="540px" width="100%" sandbox="allow-same-origin"></iframe>
</div>
        <?php
        //sandbox="allow-same-origin allow-scripts allow-popups"
}
add_action( 'admin_enqueue_scripts', __NAMESPACE__ . '\\Slr_Login_preview', 20 );

/**
 * Language switcher
 */
if ( carbonade( 'slr_hide_language_switcher' ) === 'yes' ) {
    add_filter(
        'login_display_language_dropdown',
        function () {
            return false;
        }
    );
}

/**
 * Customizer CSS
 *
 * Compile all the styles from the customizer into a single style tag.
 *
 * @return mixed the styles created in the customizer
 */
function Slr_Customizer_css() {
    $style = '';

    // back to blog
    if ( carbonade( 'slr_hide_backtoblog' ) == 'yes' ) {
        $style .= 'p#backtoblog a { display: none; }';
    }

    // privacy policy
    if ( carbonade( 'slr_hide_privacy_policy' ) == 'yes' ) {
        $style .= '.login .privacy-policy-page-link { display: none; }';
    }

    /* custom login logo */
    $slr_logo = carbonade( 'slr_custom_logo' );
    if ( ! empty( $slr_logo ) ) {
        $logo_url   = $slr_logo;
        $logo_h     = 0;

        // If a numeric value is stored, treat it as an attachment ID
        if ( is_numeric( $slr_logo ) ) {
            $attachment_id = (int) $slr_logo;
            $src = wp_get_attachment_image_src( $attachment_id, 'full' );
            if ( $src && is_array( $src ) ) {
                $logo_url = $src[0];
                // $src[1] width, $src[2] height
                $logo_h   = isset( $src[2] ) ? (int) $src[2] : 0;
            }
        } else {
            // Attempt to map URL to attachment ID only for local uploads host
            $uploads   = wp_get_upload_dir();
            $logo_host = (string) wp_parse_url( (string) $slr_logo, PHP_URL_HOST );
            $upl_host  = (string) wp_parse_url( (string) $uploads['baseurl'], PHP_URL_HOST );
            if ( $logo_host && $upl_host && strcasecmp( $logo_host, $upl_host ) === 0 ) {
                $attachment_id = attachment_url_to_postid( (string) $slr_logo );
                if ( $attachment_id ) {
                    $src = wp_get_attachment_image_src( $attachment_id, 'full' );
                    if ( $src && is_array( $src ) ) {
                        $logo_url = $src[0];
                        $logo_h   = isset( $src[2] ) ? (int) $src[2] : 0;
                    }
                }
            }
        }

        // Height CSS: use metadata height if available, otherwise a safe default
        $logo_height = $logo_h > 0 ? $logo_h : 80;

        $logo_url_css = esc_url( $logo_url );

        $style .= ".login h1 {
                margin: 0 auto 24px;
                text-align: center;
            }
            .login h1 a{
                background-image: url('{$logo_url_css}') !important;
                background-size: contain;
                background-position: center center;
                background-repeat: no-repeat;
                color: #444;
                font-size: 20px;
                font-weight: 400;
                line-height: 1.3;
                margin: 0 auto;
                padding: 0;
                text-decoration: none;
                text-indent: -9999px;
                outline: 0;
                overflow: hidden;
                display: block;
                width: 100%;
                max-width: 320px;
                height: {$logo_height}px;
            }";
    }

    /* page background color */
    $slr_page_background_color = carbonade( 'slr_page_background_color' );
    if ( ! empty( $slr_page_background_color ) ) {
        $style .= 'body.login { background: ' . sanitize_text_field( $slr_page_background_color ) . ' }';
    }

    /* page background image */
    $slr_page_background_image = carbonade( 'slr_page_background_image' );
    if ( ! empty( $slr_page_background_image ) ) {
        $bg_url = esc_url( $slr_page_background_image );
        $style .= "body.login {
                background-image: url('{$bg_url}');
                background-repeat: no-repeat;
                background-position: center center;
                background-size: cover;
            }";
    }

    /* Login form background color */
    $slr_form_background_color = carbonade( 'slr_form_background_color' );
    if ( ! empty( $slr_form_background_color ) ) {
        $style .= 'body.login #loginform { background: ' . sanitize_text_field( $slr_form_background_color ) . ' }';
    }

    /* Login page background image */
    $slr_form_background_image = carbonade( 'slr_form_background_image' );
    if ( ! empty( $slr_form_background_image ) ) {
        $form_bg_url = esc_url( $slr_form_background_image );
        $style .= "body.login #loginform {
                background-image: url('{$form_bg_url}');
                background-repeat: no-repeat;
                background-position: center center;
            }";
    }

    // Modern login layout: center the login card and apply a subtle card look.
    $style .= "body.login {
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            padding: 4vh 16px;
            box-sizing: border-box;
        }
        body.login #login {
            width: 100%;
            max-width: 380px;
            padding: 0;
            box-sizing: border-box;
        }
        body.login form#loginform {
            box-shadow: 0 8px 24px rgba(15, 23, 42, 0.12);
            border-radius: 8px;
            border: 1px solid rgba(148, 163, 184, 0.35);
            padding: 24px 24px 28px;
            backdrop-filter: blur(6px);
            box-sizing: border-box;
        }
        @media (max-width: 480px) {
            body.login {
                align-items: flex-start;
                padding-top: 8vh;
            }
            body.login form#loginform {
                padding: 20px 18px 24px;
                box-shadow: 0 4px 16px rgba(15, 23, 42, 0.16);
            }
        }";

    /* label colors */
    $slr_form_labels_color = carbonade( 'slr_form_labels_color' );
    if ( ! empty( $slr_form_labels_color ) ) {
        $style .= "body.login div#login form#loginform label {
            color: " . sanitize_text_field( $slr_form_labels_color ) . '
        }';
    }

    /* nav links color */
    $slr_form_nav_color = carbonade( 'slr_form_nav_color' );
    if ( ! empty( $slr_form_nav_color ) ) {
        $style .= 'body.login #nav a { color: ' . sanitize_text_field( $slr_form_nav_color ) . ' }';
    }

    /* back to blog link */
    $slr_form_backtoblog_color = carbonade( 'slr_form_backtoblog_color' );
    if ( ! empty( $slr_form_backtoblog_color ) ) {
        $style .= 'body.login #backtoblog a { color: ' . sanitize_text_field( $slr_form_backtoblog_color ) . ' }';
    }

    /* privacy-policy-page-link */
    $slr_form_privacy_color = carbonade( 'slr_form_privacy_color' );
    if ( ! empty( $slr_form_privacy_color ) ) {
        $style .= "body.login .privacy-policy-page-link a {
            color: " . sanitize_text_field( $slr_form_privacy_color ) . '
        }';
    }

    /* submit button */

    // active
    $submit_bg_color = carbonade( 'slr_form_submit_background_color' );
    $submit_text_color = carbonade( 'slr_form_submit_text_color' );

    $submit_border_color = carbonade( 'slr_form_submit_border_color' );
    $submit_border_radius = carbonade( 'slr_form_submit_radius' );
    $submit_border_width = carbonade( 'slr_form_submit_border_width' );

    $submit_bg_color = ( $submit_bg_color ? 'background:' . sanitize_text_field( $submit_bg_color ) . ';' : '' );
    $submit_text_color = ( $submit_text_color ? 'color:' . sanitize_text_field( $submit_text_color ) . ';' : '' );

    $submit_border_color = ( $submit_border_color ? 'border-color:' . sanitize_text_field( $submit_border_color ) . ';' : '' );
    $submit_border_width = ( $submit_border_width ? 'border-width:' . (int) $submit_border_width . 'px;' : '' );
    $submit_border_style = ( $submit_border_width ? 'border-style: solid' . ';' : '' );
    $submit_border_radius = ( $submit_border_radius ? 'border-radius:' . (int) $submit_border_radius . 'px;' : '' );

    // hover
    $submit_bg_color_hover = carbonade( 'slr_form_submit_background_color_hover' );
    $submit_text_color_hover = carbonade( 'slr_form_submit_text_color_hover' );
    $submit_bg_color_hover = ( $submit_bg_color_hover ? 'background:' . sanitize_text_field( $submit_bg_color_hover ) . ';' : '' );
    $submit_text_color_hover = ( $submit_text_color_hover ? 'color:' . sanitize_text_field( $submit_text_color_hover ) . ';' : '' );

    // align
    $submit_align = carbonade( 'slr_form_submit_align' );
    if ( $submit_align && $submit_align !== 'default' ) {
        $justify = 'flex-start';
        if ( 'center' === $submit_align ) {
            $justify = 'center';
        } elseif ( 'end' === $submit_align ) {
            $justify = 'flex-end';
        }

        $style .= "body.login #login form p.submit {
            display: flex;
            justify-content: {$justify};
            gap: 8px;
        }";
    }

    // size
    $submit_size = carbonade( 'slr_form_submit_size' );

    if ( 'custom' === $submit_size ) {
        $width = carbonade( 'slr_form_submit_size_width' );
        $height = carbonade( 'slr_form_submit_size_height' );

        $width = ( $width ? 'width:' . (int) $width . 'px;' : '' );
        $height = ( $height ? 'height:' . (int) $height . 'px;' : '' );
    } elseif ( 'full-width' === $submit_size ) {
        $width = 'width:100%;';
        $height = 'height:100%;';
    } else {
        $width = '';
        $height = '';
    }

    if ( $submit_bg_color || $submit_text_color || $submit_border_color
        || ( $submit_border_width && $submit_border_style )
        ||  $submit_border_radius || $height || $width
    ) {
        $style .= "body.login #wp-submit {
            {$submit_bg_color} {$submit_text_color}
            {$submit_border_color} {$submit_border_width}
            {$submit_border_style} {$submit_border_radius}
            {$height} {$width}
        }";
    }

    if ( $submit_bg_color_hover || $submit_text_color_hover ) {
        $style .= "body.login #wp-submit:hover {
            {$submit_bg_color_hover} {$submit_text_color_hover}
        }";
    }

	if ( '' === trim( $style ) ) {
        return;
    }

    // echo!
    if ( ! empty( $style ) ) {
        // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Intentional inline CSS generated from constrained admin options.
        echo "<style>{$style}</style>";
    }
}
add_filter( 'login_head', __NAMESPACE__ . '\\Slr_Customizer_css', 50 );

/**
 * WP and WC : Hide "Remember Me" checkbox
 *
 * @return mixed the styles to hide the "Remember Me" checkbox
 */
function Slr_Hide_Remember_me() {
    $style = '';
    $slr_hide_remember_me = carbonade( 'slr_hide_remember_me' );

    if ( $slr_hide_remember_me == 'yes' ) {
        // WordPress
        $style .= 'p.forgetmenot {display:none}';
        // WooCommerce
        $style .= 'label.woocommerce-form__label.woocommerce-form__label-for-checkbox.woocommerce-form-login__rememberme {display:none}';
    }
    // echo!
    if ( ! empty( $style ) ) {
        // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Intentional inline CSS for hiding Remember Me checkbox.
        echo "<style>{$style}</style>";
    }
}
add_filter( 'login_head', __NAMESPACE__ . '\\Slr_Hide_Remember_me', 50 );
add_action(
    'woocommerce_login_form_start',
    __NAMESPACE__ . '\\Slr_Hide_Remember_me',
    10
);

/**
 * EDD : Hide "Remember Me" checkbox
 *
 * @param $var the existing code
 *
 * @return mixed the styles to hide the "Remember Me" checkbox
 */
function Slr_Edd_Hide_Remember_me( $var ) {
    $style = '';
    $slr_hide_remember_me = carbonade( 'slr_hide_remember_me' );

    if ( $slr_hide_remember_me == 'yes' ) {
        $style .= 'p.edd-login-remember { display: none; }'; // EDD
    }
    // echo!
    if ( ! empty( $style ) ) {
        return $var . "<style>{$style}</style>";
    }

    // default return
    return $var;
}
add_filter( 'edd_login_form', __NAMESPACE__ . '\\Slr_Edd_Hide_Remember_me', 10, 1 );


/**
 * WP and WC : check "Remember Me" checkbox
 *
 * @return mixed the script to check the "Remember Me" checkbox
 */
function Slr_Check_Remember_me() {
    $slr_check_remember_me = carbonade( 'slr_check_remember_me' );
    if ( $slr_check_remember_me == 'yes' ) {
        // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Intentional inline JS to set checkbox state.
        echo "<script>document.addEventListener('DOMContentLoaded', function() {
        const rememberme = document.getElementById('rememberme');
        if(rememberme){ rememberme.checked = true; }
		});
        </script>";
    }
}
add_action( 'login_footer', __NAMESPACE__ . '\\slr_check_remember_me', 10 );
add_action(
    'woocommerce_login_form_end',
    __NAMESPACE__ . '\\Slr_Check_Remember_me',
    10
);

/**
 * EDD : check the "Remember Me" checkbox
 *
 * @param $var the existing code
 *
 * @return mixed the styles to check the "Remember Me" checkbox
 */
function Slr_Edd_Check_Remember_me( $var ) {
    $slr_check_remember_me = carbonade( 'slr_check_remember_me' );
    if ( $slr_check_remember_me == 'yes' ) {
        // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Intentional inline JS to set checkbox state.
        $var .= "<script>document.addEventListener('DOMContentLoaded', function() {
        const rememberme = document.getElementById('rememberme');
        if(rememberme){ rememberme.checked = true; }
        });</script>";
    }
    // default return
    return $var;
}
add_filter(
    'edd_login_form',
    __NAMESPACE__ . '\\Slr_Edd_Check_Remember_me',
    10,
    1
);
