<?php

use LassoLite\Classes\Setting;
use LassoLite\Classes\Enum;
$lasso_options = Setting::get_settings();
$email_support = $lasso_options[ Enum::EMAIL_SUPPORT ] ?? '';
if ( empty( $email_support ) ) {
    $email_support = get_option( 'admin_email' );
}
$share_diagnostics = $lasso_options[ Enum::SHARE_DIAGNOSTICS ] ?? '';
if ( empty( $share_diagnostics ) ) {
    $share_diagnostics = 0;
}
?>

<div id="activate" class="tab-item text-center d-none" data-step="connect-lasso">
	<div class="progressbar_container">
		<ul class="progressbar">
			<li class="step-get-started complete">Welcome</li>
			<li class="step-display-design complete" data-step="display">Display Designer</li>
			<li class="step-amazon-info complete" data-step="amazon">Amazon Associates</li>
			<li class="step-connect-lasso active" data-step="connect-lasso">Connect to Lasso</li>
			<?php if ( $should_show_import_step ) : ?>
				<li class="step-import">Imports</li>
			<?php endif; ?>
		</ul>
	</div>

	<div class="onboarding_header text-center">
		<h1 class="font-weight-bold">Get the Best Lasso Experience</h1>
		<p>Turn on diagnostics and add your email address so we can improve performance and help with any questions or issues.</p>
	</div>

	<div id="enable-support-wrapper" class="mt-4">
		<div class="form-group mb-3 text-center">
			<input type="email" id="email" class="form-control w-50 d-block-center" value="<?php echo esc_attr( $email_support ); ?>" placeholder="Enter your email address">
		</div>

		<div class="form-group mb-1 text-center">
			<label class="m-0">
				<input type="checkbox" id="share_diagnostics" name="share_diagnostics" <?php checked( $share_diagnostics, 1 ); ?>> <span class="ml-1">Share anonymous diagnostics</span>
			</label>
		</div>
		<div class="text-center mb-3">
			<a href="https://support.getlasso.co/en/articles/6465196-does-lasso-collect-data-from-lasso-lite-users" target="_blank" class="underline">Learn what we collect.</a>
		</div>

		<div class="js-error red" style="display:none"></div>
	</div>

	<div class="row align-items-center">
		<div class="col-lg text-lg-right text-center">
			<button id="btn-connect-for-free" class="btn next-step">Continue</button>
		</div>
	</div>
</div>
