<?php
/*
Copyright 2023-2025 Marcin Pietrzak (marcin@iworks.pl)
this program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License, version 2, as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

 */
defined( 'ABSPATH' ) || exit;


abstract class iWorks_Orphans_Integration {

	/**
	 * iWorks Orphans Object
	 *
	 * @since 3.2.7
	 */
	protected $orphans;


	/**
	 * Is key turned on?
	 *
	 * @param string $key Settings key.
	 *
	 * @return boolean Is this key setting turned on?
	 */
	protected function is_on( $key ) {
		return $this->orphans->is_on( $key );
	}
}
