/**
 * SideMenuLite
 * A JavaScript class for creating customizable side menus.
 *
 * @version 1.0.0
 * @license MIT License
 * @author Dmytro Lobov
 * @url https://wow-estore.com/item/side-menu-pro/
 */
"use strict";class SideMenuLite{constructor(t){this.settings={showAfterTimer:!1,hideAfterTimer:!1,showAfterPosition:!1,hideAfterPosition:!1,touch:!1,mobile:!1,mobileStyle:{},mobileHide:!1,desktopHide:!1,style:{},items:{},scrollSpyOffset:50,...t},this.element=document.getElementById(this.settings.element)}touchThis(){if(this.settings.touch)return;document.querySelector("#"+this.settings.element).addEventListener("touchstart",(function(){this.classList.add("sm-open")}));Array.from(this.element.querySelectorAll(".sm-link")).forEach((t=>{t.addEventListener("touchend",this.toggleItemOpen.bind(this,t))}))}toggleItemOpen(t,e){const s=t.closest(".sm-item"),{classList:i}=s;i.contains("sm-open")||(e.preventDefault(),i.add("sm-open"),this.touchAnyWhere(t,i))}touchAnyWhere(t,e){document.addEventListener("touchstart",(function(s){t.contains(s.target)||e.remove("sm-open")}))}displayMenu(){this.settings.showAfterTimer||this.settings.showAfterPosition||this.showMenu(),this.settings.showAfterTimer&&this.showAfterTimer(this.settings.showAfterTimer),this.settings.hideAfterTimer&&this.hideAfterTimer(this.settings.hideAfterTimer),this.settings.hideAfterPosition&&this.hideAfterPosition(this.settings.hideAfterPosition),this.settings.showAfterPosition&&this.showAfterPosition(this.settings.showAfterPosition)}showMenu(){this.element.classList.remove("is-hidden"),this.subMenuWidth()}hideMenu(){this.element.classList.add("is-hidden")}showAfterTimer(){setTimeout((()=>this.showMenu()),1e3*this.settings.showAfterTimer)}hideAfterTimer(){setTimeout((()=>this.element.classList.add("is-hidden")),1e3*this.settings.hideAfterTimer)}showAfterPosition(){window.addEventListener("scroll",(()=>{window.scrollY<=this.settings.showAfterPosition?this.hideMenu():this.showMenu()}))}hideAfterPosition(){window.addEventListener("scroll",(()=>{window.scrollY>this.settings.hideAfterPosition?this.hideMenu():this.showMenu()}))}actionServices(){this.element.addEventListener("click",(t=>{const e=t.target.closest("[data-btn-action]");if(!e)return;t.preventDefault();const s=e.getAttribute("data-btn-action");this.handleAction(s,e)}))}handleAction(t,e){const s={print:()=>window.print(),goback:()=>window.history.back(),goforward:()=>window.history.forward(),scroll:()=>{const t=e.getAttribute("href");document.querySelector(t).scrollIntoView({behavior:"smooth",block:"start",inline:"nearest"})},totop:()=>window.scrollTo({top:0,behavior:"smooth"}),tobottom:()=>window.scrollTo({top:document.body.scrollHeight,behavior:"smooth"})}[t];s&&s()}toggleMenu(){const t=this.element.querySelectorAll("[data-smmenu-target]");if(!t)return!1;this.element.classList.contains("sm-connected")&&t.forEach((t=>{t.addEventListener("click",(()=>{"close"===t.getAttribute("data-smmenu-target")&&this.element.classList.remove("sm-open")})),t.addEventListener("touchend",(()=>{"close"===t.getAttribute("data-smmenu-target")&&this.element.classList.remove("sm-open")}))}))}run(){this.style(),this.itemStyle(),this.touchThis(),this.displayMenu(),this.actionServices(),this.scrollSpy(),this.toggleMenu()}scrollSpy(){const t=[...this.element.querySelectorAll('.sm-link[data-btn-action="scrollSpy"]')];if(t.length<1)return!1;const e=t.map((t=>document.querySelector(t.getAttribute("href"))));t.forEach((e=>{e.addEventListener("click",(()=>{const s=e.closest(".sm-item"),i=e.getAttribute("href"),n=document.querySelector(i);n&&(n.scrollIntoView({behavior:"smooth",block:"start",inline:"nearest"}),t.forEach((t=>{e.closest(".sm-item").classList.remove("sm-open")})),s.classList.add("sm-open"))}))})),window.addEventListener("scroll",(()=>{const s=window.pageYOffset;e.forEach((e=>{if(null===e)return;const i=e.offsetTop,n=e.offsetHeight;if(s>=i-this.settings.scrollSpyOffset&&s<i+n){!function(e){t.forEach((t=>{const s=t.closest(".sm-item");t.getAttribute("href")===`#${e}`?s.classList.add("sm-open"):s.classList.remove("sm-open")}))}(e.getAttribute("id"))}}))}))}style(){const t=this.settings.style,e=Object.entries(t).map((([t,e])=>`${t}: ${e};`)).join("");let s="";if(this.settings.mobile){const t=this.settings.mobileStyle,e=Object.entries(t).map((([t,e])=>`${t}: ${e};`)).join("");s=`@media only screen and (max-width: ${this.settings.mobile}px){ #${this.settings.element} {${e}}}`}let i="";this.settings.mobileHide&&(i=`@media only screen and (max-width: ${this.settings.mobileHide}px){#${this.settings.element} {display:none;}}`);let n="";this.settings.desktopHide&&(n=`@media only screen and (min-width: ${this.settings.desktopHide}px){#${this.settings.element} {display:none;}}`);const o=document.getElementById("side-menu-css"),r=document.createElement("style");r.setAttribute("id","side-menu-js-css"),r.innerHTML=`#${this.settings.element} {${e}} ${s} ${i} ${n}`,o?o.parentNode.insertBefore(r,o.nextSibling):document.body.appendChild(r)}itemStyle(){const t=this.settings.items,e=Array.from(this.element.querySelectorAll(".sm-item"));Object.entries(t).forEach((([t,s])=>{for(const i in s)s.hasOwnProperty(i)&&e[t].style.setProperty(i,s[i])}))}subMenuWidth(){this.element.querySelectorAll(".sm-has-submenu").forEach((t=>{const e=t.clientWidth,s=t.querySelector(".sm-sub-menu"),i=s.clientWidth;if(e<i){t.querySelector(".sm-link").style.width=`${i}px`}else{s.querySelectorAll(".sm-link").forEach((t=>{t.style.width=`${e}px`}))}}))}static initialize(t){const e=new SideMenuLite(t);return e.run(),e}}document.addEventListener("DOMContentLoaded",(function(){for(let t in window)if(t.indexOf("SideMenuLite_")>=0){const e=window[t];new SideMenuLite(e),SideMenuLite.initialize(e)}}));