<?php

/**
 * Class Settings_Helper
 *
 * This class contains helper methods for retrieving menu item types, share services,
 * and translation options.
 *
 * @package    FloatMenuPro
 * @subpackage Admin
 * @author     Dmytro Lobov <dev@wow-company.com>, Wow-Company
 * @copyright  2024 Dmytro Lobov
 * @license    GPL-2.0+
 */

namespace SideMenuLite;

defined( 'ABSPATH' ) || exit;

class Settings_Helper {

	public static function item_type(): array {
		return [
			'link'          => __( 'Link', 'side-menu-lite' ),
		];
	}

	public static function share_services(): array {
		return [
			'Facebook'         => __( 'Facebook', 'side-menu-lite' ),
			'Twitter'          => __( 'Twitter', 'side-menu-lite' ),
			'Linkedin'         => __( 'Linkedin', 'side-menu-lite' ),
			'Pinterest'        => __( 'Pinterest', 'side-menu-lite' ),
			'stumbleupon'      => __( 'StumbleUpon', 'side-menu-lite' ),
			'buffer'           => __( 'Buffer', 'side-menu-lite' ),
			'email'            => __( 'Email', 'side-menu-lite' ),
			'xing'             => __( 'XING', 'side-menu-lite' ),
			'myspace'          => __( 'Myspace', 'side-menu-lite' ),
			'weibo'            => __( 'Weibo', 'side-menu-lite' ),
			'reddit'           => __( 'Reddit', 'side-menu-lite' ),
			'tumblr'           => __( 'Tumblr', 'side-menu-lite' ),
			'blogger'          => __( 'Blogger', 'side-menu-lite' ),
			'livejournal'      => __( 'LiveJournal', 'side-menu-lite' ),
			'pocket'           => __( 'Pocket', 'side-menu-lite' ),
			'telegram'         => __( 'Telegram', 'side-menu-lite' ),
			'skype'            => __( 'Skype', 'side-menu-lite' ),
			'draugiem'         => __( 'Draugiem', 'side-menu-lite' ),
			'whatsapp'         => __( 'Whatsapp', 'side-menu-lite' ),
			'diaspora'         => __( 'Diaspora', 'side-menu-lite' ),
			'digg'             => __( 'Digg', 'side-menu-lite' ),
			'douban'           => __( 'Douban', 'side-menu-lite' ),
			'evernote'         => __( 'Evernote', 'side-menu-lite' ),
			'flipboard'        => __( 'Flipboard', 'side-menu-lite' ),
			'google-bookmarks' => __( 'Google Bookmarks', 'side-menu-lite' ),
			'hacker-news'      => __( 'Hacker News', 'side-menu-lite' ),
			'instapaper'       => __( 'Instapaper', 'side-menu-lite' ),
			'line'             => __( 'Line', 'side-menu-lite' ),
			'qzone'            => __( 'Qzone', 'side-menu-lite' ),
			'renren'           => __( 'Renren', 'side-menu-lite' ),
			'Google'           => __( 'Google', 'side-menu-lite' ),
			'VK'               => __( 'VK', 'side-menu-lite' ),
			'Odnoklassniki'    => __( 'Odnoklassniki', 'side-menu-lite' ),
		];
	}

	public static function gtranslate(): array {
		return [
			'af'  => __( 'Afrikaans', 'side-menu-lite' ),
			'sq'  => __( 'Albanian', 'side-menu-lite' ),
			'am'  => __( 'Amharic', 'side-menu-lite' ),
			'ar'  => __( 'Arabic', 'side-menu-lite' ),
			'hy'  => __( 'Armenian', 'side-menu-lite' ),
			'az'  => __( 'Azerbaijani', 'side-menu-lite' ),
			'eu'  => __( 'Basque', 'side-menu-lite' ),
			'be'  => __( 'Belarusian', 'side-menu-lite' ),
			'bn'  => __( 'Bengali', 'side-menu-lite' ),
			'bs'  => __( 'Bosnian', 'side-menu-lite' ),
			'bg'  => __( 'Bulgarian', 'side-menu-lite' ),
			'ca'  => __( 'Catalan', 'side-menu-lite' ),
			'ceb' => __( 'Cebuano', 'side-menu-lite' ),
			'ny'  => __( 'Chichewa', 'side-menu-lite' ),
			'co'  => __( 'Corsican', 'side-menu-lite' ),
			'hr'  => __( 'Croatian', 'side-menu-lite' ),
			'cs'  => __( 'Czech', 'side-menu-lite' ),
			'da'  => __( 'Danish', 'side-menu-lite' ),
			'nl'  => __( 'Dutch', 'side-menu-lite' ),
			'en'  => __( 'English', 'side-menu-lite' ),
			'eo'  => __( 'Esperanto', 'side-menu-lite' ),
			'et'  => __( 'Estonian', 'side-menu-lite' ),
			'tl'  => __( 'Filipino', 'side-menu-lite' ),
			'fi'  => __( 'Finnish', 'side-menu-lite' ),
			'fr'  => __( 'French', 'side-menu-lite' ),
			'fy'  => __( 'Frisian', 'side-menu-lite' ),
			'gl'  => __( 'Galician', 'side-menu-lite' ),
			'ka'  => __( 'Georgian', 'side-menu-lite' ),
			'de'  => __( 'German', 'side-menu-lite' ),
			'el'  => __( 'Greek', 'side-menu-lite' ),
			'gu'  => __( 'Gujarati', 'side-menu-lite' ),
			'ht'  => __( 'Haitian Creole', 'side-menu-lite' ),
			'ha'  => __( 'Hausa', 'side-menu-lite' ),
			'haw' => __( 'Hawaiian', 'side-menu-lite' ),
			'iw'  => __( 'Hebrew', 'side-menu-lite' ),
			'hi'  => __( 'Hindi', 'side-menu-lite' ),
			'hmn' => __( 'Hmong', 'side-menu-lite' ),
			'hu'  => __( 'Hungarian', 'side-menu-lite' ),
			'is'  => __( 'Icelandic', 'side-menu-lite' ),
			'ig'  => __( 'Igbo', 'side-menu-lite' ),
			'id'  => __( 'Indonesian', 'side-menu-lite' ),
			'ga'  => __( 'Irish', 'side-menu-lite' ),
			'it'  => __( 'Italian', 'side-menu-lite' ),
			'ja'  => __( 'Japanese', 'side-menu-lite' ),
			'jw'  => __( 'Javanese', 'side-menu-lite' ),
			'kn'  => __( 'Kannada', 'side-menu-lite' ),
			'kk'  => __( 'Kazakh', 'side-menu-lite' ),
			'km'  => __( 'Khmer', 'side-menu-lite' ),
			'ko'  => __( 'Korean', 'side-menu-lite' ),
			'ku'  => __( 'Kurdish (Kurmanji)', 'side-menu-lite' ),
			'ky'  => __( 'Kyrgyz', 'side-menu-lite' ),
			'lo'  => __( 'Lao', 'side-menu-lite' ),
			'la'  => __( 'Latin', 'side-menu-lite' ),
			'lv'  => __( 'Latvian', 'side-menu-lite' ),
			'lb'  => __( 'Luxembourgish', 'side-menu-lite' ),
			'mk'  => __( 'Macedonian', 'side-menu-lite' ),
			'mg'  => __( 'Malagasy', 'side-menu-lite' ),
			'ms'  => __( 'Malay', 'side-menu-lite' ),
			'ml'  => __( 'Malayalam', 'side-menu-lite' ),
			'mt'  => __( 'Maltese', 'side-menu-lite' ),
			'mi'  => __( 'Maori', 'side-menu-lite' ),
			'mr'  => __( 'Marathi', 'side-menu-lite' ),
			'mn'  => __( 'Mongolian', 'side-menu-lite' ),
			'my'  => __( 'Myanmar (Burmese)', 'side-menu-lite' ),
			'ne'  => __( 'Nepali', 'side-menu-lite' ),
			'no'  => __( 'Norwegian', 'side-menu-lite' ),
			'ps'  => __( 'Pashto', 'side-menu-lite' ),
			'fa'  => __( 'Persian', 'side-menu-lite' ),
			'pl'  => __( 'Polish', 'side-menu-lite' ),
			'pt'  => __( 'Portuguese', 'side-menu-lite' ),
			'pa'  => __( 'Punjabi', 'side-menu-lite' ),
			'ro'  => __( 'Romanian', 'side-menu-lite' ),
			'ru'  => __( 'Russian', 'side-menu-lite' ),
			'sm'  => __( 'Samoan', 'side-menu-lite' ),
			'gd'  => __( 'Scottish Gaelic', 'side-menu-lite' ),
			'sr'  => __( 'Serbian', 'side-menu-lite' ),
			'st'  => __( 'Sesotho', 'side-menu-lite' ),
			'sn'  => __( 'Shona', 'side-menu-lite' ),
			'sd'  => __( 'Sindhi', 'side-menu-lite' ),
			'si'  => __( 'Sinhala', 'side-menu-lite' ),
			'sk'  => __( 'Slovak', 'side-menu-lite' ),
			'sl'  => __( 'Slovenian', 'side-menu-lite' ),
			'so'  => __( 'Somali', 'side-menu-lite' ),
			'es'  => __( 'Spanish', 'side-menu-lite' ),
			'su'  => __( 'Sudanese', 'side-menu-lite' ),
			'sw'  => __( 'Swahili', 'side-menu-lite' ),
			'sv'  => __( 'Swedish', 'side-menu-lite' ),
			'tg'  => __( 'Tajik', 'side-menu-lite' ),
			'ta'  => __( 'Tamil', 'side-menu-lite' ),
			'te'  => __( 'Telugu', 'side-menu-lite' ),
			'th'  => __( 'Thai', 'side-menu-lite' ),
			'tr'  => __( 'Turkish', 'side-menu-lite' ),
			'uk'  => __( 'Ukrainian', 'side-menu-lite' ),
			'ur'  => __( 'Urdu', 'side-menu-lite' ),
			'uz'  => __( 'Uzbek', 'side-menu-lite' ),
			'vi'  => __( 'Vietnamese', 'side-menu-lite' ),
			'cy'  => __( 'Welsh', 'side-menu-lite' ),
			'xh'  => __( 'Xhosa', 'side-menu-lite' ),
			'yi'  => __( 'Yiddish', 'side-menu-lite' ),
			'yo'  => __( 'Yoruba', 'side-menu-lite' ),
			'zu'  => __( 'Zulu', 'side-menu-lite' ),
		];
	}

	public static function languages(): array {
		return [
			'af'             => 'Afrikaans',
			'ar'             => 'العربية',
			'ary'            => 'العربية المغربية',
			'as'             => 'অসমীয়া',
			'az'             => 'Azərbaycan dili',
			'azb'            => 'گؤنئی آذربایجان',
			'bel'            => 'Беларуская мова',
			'bg_BG'          => 'Български',
			'bn_BD'          => 'বাংলা',
			'bo'             => 'བོད་ཡིག',
			'bs_BA'          => 'Bosanski',
			'ca'             => 'Català',
			'ceb'            => 'Cebuano',
			'cs_CZ'          => 'Čeština',
			'cy'             => 'Cymraeg',
			'da_DK'          => 'Dansk',
			'de_DE'          => 'Deutsch',
			'de_CH_informal' => 'Deutsch (Schweiz, Du)',
			'de_CH'          => 'Deutsch (Schweiz)',
			'de_DE_formal'   => 'Deutsch (Sie)',
			'de_AT'          => 'Deutsch (Österreich)',
			'dzo'            => 'རྫོང་ཁ',
			'el'             => 'Ελληνικά',
			'en_US'          => 'English (United States)',
			'en_GB'          => 'English (UK)',
			'en_AU'          => 'English (Australia)',
			'en_NZ'          => 'English (New Zealand)',
			'en_CA'          => 'English (Canada)',
			'en_ZA'          => 'English (South Africa)',
			'eo'             => 'Esperanto',
			'es_ES'          => 'Español',
			'es_VE'          => 'Español de Venezuela',
			'es_GT'          => 'Español de Guatemala',
			'es_CR'          => 'Español de Costa Rica',
			'es_MX'          => 'Español de México',
			'es_CO'          => 'Español de Colombia',
			'es_PE'          => 'Español de Perú',
			'es_CL'          => 'Español de Chile',
			'es_AR'          => 'Español de Argentina',
			'et'             => 'Eesti',
			'eu'             => 'Euskara',
			'fa_IR'          => 'فارسی',
			'fi'             => 'Suomi',
			'fr_FR'          => 'Français',
			'fr_CA'          => 'Français du Canada',
			'fr_BE'          => 'Français de Belgique',
			'fur'            => 'Friulian',
			'gd'             => 'Gàidhlig',
			'gl_ES'          => 'Galego',
			'gu'             => 'ગુજરાતી',
			'haz'            => 'هزاره گی',
			'he_IL'          => 'עִבְרִית',
			'hi_IN'          => 'हिन्दी',
			'hr'             => 'Hrvatski',
			'hu_HU'          => 'Magyar',
			'hy'             => 'Հայերեն',
			'id_ID'          => 'Bahasa Indonesia',
			'is_IS'          => 'Íslenska',
			'it_IT'          => 'Italiano',
			'ja'             => '日本語',
			'jv_ID'          => 'Basa Jawa',
			'ka_GE'          => 'ქართული',
			'kab'            => 'Taqbaylit',
			'kk'             => 'Қазақ тілі',
			'km'             => 'ភាសាខ្មែរ',
			'kn'             => 'ಕನ್ನಡ',
			'ko_KR'          => '한국어',
			'ckb'            => 'كوردی‎',
			'lo'             => 'ພາສາລາວ',
			'lt_LT'          => 'Lietuvių kalba',
			'lv'             => 'Latviešu valoda',
			'mk_MK'          => 'Македонски јазик',
			'ml_IN'          => 'മലയാളം',
			'mn'             => 'Монгол',
			'mr'             => 'मराठी',
			'ms_MY'          => 'Bahasa Melayu',
			'my_MM'          => 'ဗမာစာ',
			'nb_NO'          => 'Norsk bokmål',
			'ne_NP'          => 'नेपाली',
			'nl_NL'          => 'Nederlands',
			'nl_NL_formal'   => 'Nederlands (Formeel)',
			'nl_BE'          => 'Nederlands (België)',
			'nn_NO'          => 'Norsk nynorsk',
			'oci'            => 'Occitan',
			'pa_IN'          => 'ਪੰਜਾਬੀ',
			'pl_PL'          => 'Polski',
			'ps'             => 'پښتو',
			'pt_PT'          => 'Português',
			'pt_AO'          => 'Português de Angola',
			'pt_PT_ao90'     => 'Português (AO90)',
			'pt_BR'          => 'Português do Brasil',
			'rhg'            => 'Ruáinga',
			'ro_RO'          => 'Română',
			'ru_RU'          => 'Русский',
			'sah'            => 'Сахалыы',
			'si_LK'          => 'සිංහල',
			'sk_SK'          => 'Slovenčina',
			'skr'            => 'سرائیکی',
			'sl_SI'          => 'Slovenščina',
			'sq'             => 'Shqip',
			'sr_RS'          => 'Српски језик',
			'sv_SE'          => 'Svenska',
			'szl'            => 'Ślōnskŏ gŏdka',
			'ta_IN'          => 'தமிழ்',
			'te'             => 'తెలుగు',
			'th'             => 'ไทย',
			'tl'             => 'Tagalog',
			'tr_TR'          => 'Türkçe',
			'tt_RU'          => 'Татар теле',
			'tah'            => 'Reo Tahiti',
			'ug_CN'          => 'ئۇيغۇرچە',
			'uk'             => 'Українська',
			'ur'             => 'اردو',
			'uz_UZ'          => 'O‘zbekcha',
			'vi'             => 'Tiếng Việt',
			'zh_CN'          => '简体中文',
			'zh_TW'          => '繁體中文',
			'zh_HK'          => '香港中文版',
			'custom'         => 'Custom'
		];
	}

	public static function icon_anim(): array {
		return [
			''             => __( 'None', 'side-menu-lite' ),
			'fa-beat'      => __( 'Beat', 'side-menu-lite' ),
			'fa-fade'      => __( 'Fade', 'side-menu-lite' ),
			'fa-beat-fade' => __( 'Beat-Fade', 'side-menu-lite' ),
			'fa-bounce'    => __( 'Bounce', 'side-menu-lite' ),
			'fa-flip'      => __( 'Flip', 'side-menu-lite' ),
			'fa-shake'     => __( 'Shake', 'side-menu-lite' ),
			'fa-spin'      => __( 'Spin', 'side-menu-lite' ),
		];
	}


	public static function user_roles(): array {
		$editable_role = array_reverse( get_editable_roles() );
		$users_arr     = array();
		foreach ( $editable_role as $role => $details ) {
			$name = translate_user_role( $details['name'] );
			$val  = [
				'type'  => 'checkbox',
				'title' => $name,
				'label' => __( 'Enable', 'side-menu-lite' ),

			];

			$users_arr[ 'user_' . $role ] = $val;
		}

		return $users_arr;
	}

}
