<?php
// define a template to display a post


/* Example template

%post_wrap%
%post_format%

%post_entry_header%
    %post_title_wrap%
        %post_title_link%<span style="float:right;">%comment_bubble%</span>
        <div style="clear:both;></div>
        %entry_meta%
    %/post_title_wrap%
%/post_entry_header%

%post_excerpt_wrap%
    %fi_thumb_left%
    %the_excerpt%
%/post_excerpt_wrap%

%entry_utility%%post_edit%

%/post_wrap%


/*

/* WP API

    %site_title% || %site_title_link% : site title, site title wrapped in link to site home page

    %site_tagline% : the site tagline

    %the_ID% : the ID of the current post
    %post_class% : class="classes generated by WP post_class() function"
                    will also add 'atw-post'; will add 'sticky' if the post is sticky
    %post_permalink% : Full URL of post ( WP the_permalink() )
    %post_time% : Time the post was published ( get_the_time() )
    %post_datetime% : The full date and time the post was published ( get_the_date('c') )
    %post_date% : The date the post was published ( get_the_date() )

    %theme_url%
    %theme_child_url%
    %upload_url%
    %site_url%

    %post_custom_field:name%


    %the_author% : Author of the post ( get_the_author() )
    %the_author_url% : URL to the Author page

    ICONS


    %icon_author%   : default aughor icon
    %icon_category% : icon for category
    %icon_date%     : default date icon
    %icon_edit%     : edit icon
    %icon_permalink% : permalink icon
    %icon_reply%    : icon for reply link
    %icon_star%     : star icon
    %icon_tag%      : icon for tag

    %comment_bubble%, %comment_bubble_rtl% : comment bubbles

    OTHER

    %author_avatar%, %author_avatar_link%

    %fi_(thumb/medium/large/full)_(left/center/right/none)_(link/attachment/post/none)%


	%fi_media_link% , %/fi_media_link'
	%fi_attachement_link%
	%fi_title%
	%fi_caption%
	%fi_description%

	%the_first_imgage% - first image in the post || 'the_first_image_link% - first image in the post linked to attachment or media



*/

 /*

    %post_wrap%, %/post_wrap'
        Required unless you use your own wrapper using %the_ID% and %post_class%. Wraps the entire post.
        : <article id="post-%the_ID%" %post_class%> ... </article>

    %post_entry_header%, %/post_entry_header%
        Wraps the post "header" - the title and the top meta line
        :   <header class="atw-entry-header">
                ... add title + entry-meta ...
            </header>

    %post_title_wrap%, %/post_title_wrap%
        Adds a wrap around the title
        :   <hgroup class="atw-entry-hdr">
                <h2 class="atw-entry-title">
                    ... the title ...
                </h2>
            </hgroup>

    %post_title%
        Just the post title, using WP the_title().

    %post_title_link%
        The post title wrapped in an <a> ... </a>. Includes post permalink (%the_permalink%)
        and title descriptive attribute (%the_title_attribute%)

    %post_format%, %post_format_name%, %post_format_icon%




    %post_excerpt_wrap%
        %post_excerpt%
    %/post_excerpt_wrap%

	%post_content_wrap%
        %post_content% : filtered through shortcode
    %/post_content_wrap%


    %entry_meta%
        Complete, default entry-meta line using icons
        :   <div class="atw-entry-meta">
                <div class="atw-entry-meta-icons">
                    <span class="entry-date">
                        <a href="%the_permalink%" title="%post_time" rel="bookmark">
                            <time datetime="%post_datetime" pubdate>%post_date%
                            </time>
                        </a>
                    </span>
                    <span class="by-author">
                        <span class="author vcard">
                            <a href="%the_author_url" title="Posts by " rel="author">
                                %the_author%
                            </a>
                        </span>
                    </span>
                </div>
            </div>

    %entry_meta_wrap%, %/entry_meta_wrap%
        Just the "atw-entry-meta" div - no icons displayed - manual entry of meta descriptors required

    %entry_meta_wrap_icons%, %/entry_meta_wrap_icons%
        Both he "atw-entry-meta" and "atw-entry-meta-icons" divs - will show icons for items


    %entry_utility%
        Complete, defaule entry-utiltiy line, using icons
        :   <footer class="atw-entry-utility">
                <div class="atw-entry-meta-icons">
                    %post_category_links%
                    %post_tag_links%
                    %post_comments_links%
                    %post_comments_link%
                </div>
            </footer>


    %entry_utility_wrap%, %/entry_utility_wrap%
        The atw-entry-utility and atw-entry-meta-icons blocks

    %post_edit%


 */
 // ====================================== >>> atw_posts_do_template <<< ======================================

function atw_posts_do_template( $slider, $template ) {

    $text = $template;

    // $simple - replacement id, call function with supplied args, return value
    $calls = array(
        '%edit_post%' => array('atw_posts_edit_post', array() ),

        '%entry_meta%'      => array( 'atw_posts_entry_meta', array() ),
        '%entry_meta_wrap%' => array( 'atw_posts_argval', array( ' <div class="atw-entry-meta">' ) ),
        '%/entry_meta_wrap%'=> array( 'atw_posts_argval', array( ' </div>') ),
        '%entry_meta_wrap_icons%' => array( 'atw_posts_argval', array( ' <div class="atw-entry-meta"> <div class="atw-entry-meta-icons">' ) ),
        '%/entry_meta_wrap_icons%'=> array( 'atw_posts_argval', array( ' </div> </div>')),

        '%entry_utility%'   =>  array( 'atw_posts_entry_utility', array() ),


        '%post_excerpt_wrap%'  => array( 'atw_posts_argval', array(' <div class="atw-entry-summary atw-cf">') ),
        '%/post_excerpt_wrap%' => array( 'atw_posts_argval', array("\n </div><!-- .atw-entry-summary -->") ),
        '%post_excerpt%'       => array( 'atw_posts_post_excerpt', array() ),

        '%post_content_wrap%'  => array( 'atw_posts_argval', array(' <div class="atw-entry-content atw-cf">') ),
        '%/post_content_wrap%' => array( 'atw_posts_argval', array("\n </div><!-- .atw-entry-content -->") ),
        '%post_content%'       => array( 'apply_filters', array('the_content', get_the_content() ) ),

        '%post_permalink%'  => array( 'esc_url', array( get_permalink() ) ),

        '%post_title%'      => array( 'get_the_title',array()),
        '%post_title_link%' => array( 'atw_posts_post_title_link', array() ),

        '%post_title_wrap%'  => array( 'atw_posts_argval', array(' <hgroup class="atw-entry-hdr">
  <h2 class="atw-entry-title">') ),
        '%/post_title_wrap%' => array( 'atw_posts_argval', array('  </h2>
 </hgroup>') ),

        '%post_wrap%'    =>  array( 'atw_posts_post_wrap', array() ),
        '%/post_wrap%'   =>  array( 'atw_posts_argval', array( '</article> <!-- #post -->' ) ),

        '%site_title%'   =>  array( 'get_bloginfo', array( 'name' ) ),
        '%the_ID%'       =>  array( 'get_the_ID', array() ),

    );

    $linked = array(
        '%site_title_link%' => array('get_bloginfo',array('name'),'site_url',array()),
    );


    foreach ($calls as $pattern => $vals) {
        if ( strpos( $text, $pattern ) !== false) {
            $rep = call_user_func_array( $vals[0], $vals[1]);
            if ( $rep ) {
                $text = str_replace( $pattern, $rep, $text);
            }
        }
    }

    foreach ($linked as $pattern => $vals) {
        if ( strpos( $text, $pattern ) !== false) {
            $rep = call_user_func_array( $vals[0], $vals[1] );

            if ( $rep ) {
                $link = call_user_func_array( $vals[2], $vals[3]);
                $rep = '<a href="' . $link . '" ref="' . $rep . '">' . $rep . '</a>';
                $text = str_replace( $pattern, $rep, $text);
            }
        }
    }

    echo do_shortcode($text);
}

// ====================================== >>> atw_posts_argval <<< ======================================

function atw_posts_argval( $arg ) {
    return $arg;
}

// ====================================== >>> atw_posts_edit_post <<< ======================================

function atw_posts_edit_post() {
    $link = get_edit_post_link();
    return'<span class="atw-edit-link"><a class="post-edit-link" href="' . esc_html($link) . '">' .  esc_html__( 'Edit','show-posts') . '</a></span>';
}

// ====================================== >>> atw_posts_entry_meta <<< ======================================

function atw_posts_entry_meta() {

    $val = ' <div class="atw-entry-meta"> <div class="atw-entry-meta-icons">';

    $val .= sprintf( __(
'   <span class="entry-date">
    <a href="%1$s" title="%2$s" rel="bookmark"><time datetime="%3$s" pubdate>%4$s</time></a>
   </span>
   <span class="by-author">
    <span class="author vcard">
     <a class="url fn n" href="%5$s" title="%6$s" rel="author">%7$s</a>
    </span>
   </span>','show-posts'),
		esc_url( get_permalink() ),
		esc_attr( get_the_time() ),
		esc_attr( get_the_date( 'c' ) ),
		esc_html( get_the_date() ),
		esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
		sprintf( esc_attr(__( 'View all posts by %s','show-posts')), get_the_author() ),
		esc_html( get_the_author() )
	);

    $val .= ' </div> </div>';
    return $val;
}

// ====================================== >>> atw_posts_entry_utility <<< ======================================

function atw_posts_entry_utility(  ) {

    $val =
        ' <footer class="atw-entry-utility"> <div class="atw-entry-meta-icons">' . "\n";

    $categories_list = get_the_category_list( esc_html__( ', ','show-posts') );
    if ( $categories_list ) {
        $val .= '  <span class="cat-links">' . $categories_list . " </span>\n";
    } // End if categories

    $tags_list = get_the_tag_list( '', esc_html__( ', ','show-posts') );
    if ( $tags_list ) {
        $val .= '  <span class="tag-links">' . $tags_list . "  </span>\n";
    } // End if $tags_list

    if ( comments_open() ) {
		$val .= ' <span class="comments-link">';
        $val .= wp_kses_post(atw_posts_get_comments_popup_link( __( 'Leave a reply','show-posts'),
                __( '<b>1</b> Reply','show-posts'),
                __( '<b>%</b> Replies','show-posts'),
                'leave-reply'));

		$val .= ' </span><div style="clear:both;"></div>';
    } // End if comments_open()

    $val .= '
 </div><!-- .entry-meta-icons --> </footer><!-- .atw-entry-utility -->';

    return $val;
}

// ====================================== >>> atw_posts_post_excerpt <<< ======================================

function atw_posts_post_excerpt() {

    return '<p>' . get_the_excerpt() . '</p>';
}

// ====================================== >>> atw_posts_post_title_link <<< ======================================

function atw_posts_post_title_link() {
    return '<a href="' . esc_url(get_permalink()) . '" title="' . esc_attr(sprintf( __( 'Permalink to %s','show-posts'),
	   the_title_attribute( 'echo=0' ) )) . '" rel="bookmark">' .  get_the_title() . '</a>';
}

// ====================================== >>> atw_posts_post_wrap <<< ======================================

function atw_posts_post_wrap() {

    $add_class = array('atw-post');
    $post_id = get_the_ID();
    $sticky = is_sticky( $post_id );
    if ( $sticky ) {
        $add_class[] = 'sticky';
    }

    $classes = implode(' ', get_post_class( $add_class ));
    return "\n" . '<article id="post-' . $post_id . '" class="' . $classes . '">';
}

// ====================================== >>> atw_posts_get_info_arg <<< ======================================

function atw_posts_get_info_arg( $name, $text) {
    // get the value
    $out = $text;
    $start = strpos($out, '%'. $name .':');
    if ($start === false) {
        return '';              // nothing to do
    }
    $rest = substr($out,$start + strlen($name) + 2 );   // rest of the string
    $endmark = strpos($rest,'%');               // where the % ends
    $string = substr($rest,0,$endmark);         // the string
    return $string;
}

// ====================================== >>> atw_posts_get_comments_popup_link <<< ======================================

function atw_posts_get_comments_popup_link( $zero = false, $one = false, $more = false, $css_class = '', $none = false ) {
	global $wpcommentspopupfile, $wpcommentsjavascript;

	$id = get_the_ID();
    $val = '';

	if ( false === $zero ) $zero = esc_html__( 'No Comments' );
	if ( false === $one ) $one = esc_html__( '1 Comment' );
	if ( false === $more ) $more = esc_html__( '% Comments' );
	if ( false === $none ) $none = esc_html__( 'Comments Off' );

	$number = get_comments_number( $id );

	if ( 0 == $number && !comments_open() && !pings_open() ) {
		return '<span' . ((!empty($css_class)) ? ' class="' . esc_attr( $css_class ) . '"' : '') . '>' . $none . '</span>';
	}

	if ( post_password_required() ) {
		return esc_html__('Enter your password to view comments.');
	}

	$val .= '<a href="';
	if ( $wpcommentsjavascript ) {
		if ( empty( $wpcommentspopupfile ) )
			$home = home_url();
		else
			$home = get_option('siteurl');
		$val .= $home . '/' . $wpcommentspopupfile . '?comments_popup=' . $id;
		$val .= '" onclick="wpopen(this.href); return false"';
	} else { // if comments_popup_script() is not in the template, display simple comment link
		if ( 0 == $number )
			$val .= get_permalink() . '#respond';
		else
			$val .= get_comments_link();
		$val .= '"';
	}

	if ( !empty( $css_class ) ) {
		$val .= ' class="'.$css_class.'" ';
	}
	$title = the_title_attribute( array('echo' => 0 ) );

	$val .= ' title="' . esc_attr( sprintf( __('Comment on %s'), $title ) ) . '">';

    $number = get_comments_number();

	if ( $number > 1 )
		$val .= str_replace('%', number_format_i18n($number), $more);
	elseif ( $number == 0 )
		$val .= $zero;
	else // must be one
		$val .= $one;

	$val .= '</a>';
    return $val;
}

