var Backbone = require('backbone'),
	insertShortcodeList = require('sui-views/insert-shortcode-list'),
	EditShortcodeForm = require('sui-views/edit-shortcode-form'),
	Toolbar = require('sui-views/media-toolbar'),
	SearchShortcode = require('sui-views/search-shortcode'),
	sui = require('sui-utils/sui'),
	$ = require('jquery');

var Shortcode_UI = Backbone.View.extend({

	events: {
		"click .add-shortcode-list li":      "select",
		"click .edit-shortcode-form-cancel": "cancelSelect"
	},

	initialize: function(options) {
		this.controller = options.controller.state();
		//toolbar model looks for controller.state()
		this.toolbar_controller = options.controller;
	},

	createToolbar: function(options) {
		toolbarOptions = {
			controller: this.toolbar_controller
		};

		this.toolbar = new Toolbar( toolbarOptions );

		this.views.add( this.toolbar );

		this.toolbar.set( 'search', new SearchShortcode({
			controller:    this.controller,
			model:         this.controller.props,
			shortcodeList: this.shortcodeList,
			priority:   60
		}).render() );

	},

	render: function() {

		this.$el.html('');

		switch( this.controller.props.get('action') ) {
			case 'select' :
				this.renderSelectShortcodeView();
				break;
			case 'update' :
			case 'insert' :
				this.renderEditShortcodeView();
				break;
		}

	},

	renderSelectShortcodeView: function() {
		this.views.unset();
		this.shortcodeList = new insertShortcodeList( { shortcodes: sui.shortcodes } );
		this.createToolbar();
		this.views.add('', this.shortcodeList);
	},

	renderEditShortcodeView: function() {
		var shortcode = this.controller.props.get( 'currentShortcode' );
		var view = new EditShortcodeForm({ model: shortcode });
		this.$el.append( view.render().el );

		if ( this.controller.props.get('action') === 'update' ) {
			this.$el.find( '.edit-shortcode-form-cancel' ).remove();
		}

		return this;

	},

	cancelSelect: function( e ) {
		e.preventDefault();

		this.controller.props.set( 'action', 'select' );
		this.controller.props.set( 'currentShortcode', null );
		this.render();
	},

	select: function(e) {

		var target    = $(e.currentTarget).closest( '.shortcode-list-item' );
		var shortcode = sui.shortcodes.findWhere( { shortcode_tag: target.attr( 'data-shortcode' ) } );

		if ( ! shortcode ) {
			return;
		}

		this.controller.props.set( 'action', 'insert' );
		this.controller.props.set( 'currentShortcode', shortcode.clone() );

		this.render();

		/* Trigger render_new */
		/*
		 * Action run after a new shortcode overlay is rendered.
		 *
		 * Called as `shortcode-ui.render_new`.
		 *
		 * @param shortcodeModel (object)
		 *           Reference to the shortcode model used in this overlay.
		 */
		var hookName = 'shortcode-ui.render_new';
		var shortcodeModel = this.controller.props.get( 'currentShortcode' );
		wp.shortcake.hooks.doAction( hookName, shortcodeModel );

	},

});

module.exports = Shortcode_UI;
