export const DashboardIcon = (
	<svg
		width="18"
		height="18"
		viewBox="0 0 18 18"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M1 10H7C7.26522 10 7.51957 9.89464 7.70711 9.70711C7.89464 9.51957 8 9.26522 8 9V1C8 0.734784 7.89464 0.48043 7.70711 0.292893C7.51957 0.105357 7.26522 0 7 0H1C0.734784 0 0.48043 0.105357 0.292893 0.292893C0.105357 0.48043 0 0.734784 0 1V9C0 9.26522 0.105357 9.51957 0.292893 9.70711C0.48043 9.89464 0.734784 10 1 10ZM0 17C0 17.2652 0.105357 17.5196 0.292893 17.7071C0.48043 17.8946 0.734784 18 1 18H7C7.26522 18 7.51957 17.8946 7.70711 17.7071C7.89464 17.5196 8 17.2652 8 17V13C8 12.7348 7.89464 12.4804 7.70711 12.2929C7.51957 12.1054 7.26522 12 7 12H1C0.734784 12 0.48043 12.1054 0.292893 12.2929C0.105357 12.4804 0 12.7348 0 13V17ZM10 17C10 17.2652 10.1054 17.5196 10.2929 17.7071C10.4804 17.8946 10.7348 18 11 18H17C17.2652 18 17.5196 17.8946 17.7071 17.7071C17.8946 17.5196 18 17.2652 18 17V10C18 9.73478 17.8946 9.48043 17.7071 9.29289C17.5196 9.10536 17.2652 9 17 9H11C10.7348 9 10.4804 9.10536 10.2929 9.29289C10.1054 9.48043 10 9.73478 10 10V17ZM11 7H17C17.2652 7 17.5196 6.89464 17.7071 6.70711C17.8946 6.51957 18 6.26522 18 6V1C18 0.734784 17.8946 0.48043 17.7071 0.292893C17.5196 0.105357 17.2652 0 17 0H11C10.7348 0 10.4804 0.105357 10.2929 0.292893C10.1054 0.48043 10 0.734784 10 1V6C10 6.26522 10.1054 6.51957 10.2929 6.70711C10.4804 6.89464 10.7348 7 11 7Z"
			fill="url(#paint0_linear_1465_730)"
		/>
		<defs>
			<linearGradient
				id="paint0_linear_1465_730"
				x1="9"
				y1="0"
				x2="9"
				y2="18"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#0EBC57" />
				<stop offset="1" stop-color="#03933F" />
			</linearGradient>
		</defs>
	</svg>
);
export const TabPRObtn = (
	<svg width="52" height="19" viewBox="0 0 52 19" fill="none" xmlns="http://www.w3.org/2000/svg">
	<rect width="52" height="19" rx="9.5" fill="white"/>
	<path d="M10.2236 11.207V14H8.95068V6.29785H11.2871C12.1715 6.29785 12.8573 6.50374 13.3442 6.91553C13.8312 7.32731 14.0747 7.90739 14.0747 8.65576C14.0747 9.40413 13.8205 10.0164 13.312 10.4927C12.8035 10.9689 12.116 11.207 11.2495 11.207H10.2236ZM10.2236 7.35059V10.165H11.0508C11.5986 10.165 12.0158 10.0379 12.3022 9.78369C12.5887 9.52946 12.7319 9.17139 12.7319 8.70947C12.7319 7.80355 12.2056 7.35059 11.1528 7.35059H10.2236ZM21.3364 14H19.8433L18.6133 11.9375C18.5023 11.7477 18.3931 11.5866 18.2856 11.4541C18.1818 11.318 18.0744 11.207 17.9634 11.1211C17.856 11.0352 17.7378 10.9725 17.6089 10.9331C17.48 10.8937 17.335 10.874 17.1738 10.874H16.6582V14H15.3853V6.29785H17.9204C18.2821 6.29785 18.6151 6.34082 18.9194 6.42676C19.2238 6.5127 19.4888 6.64339 19.7144 6.81885C19.9399 6.99072 20.1154 7.20736 20.2407 7.46875C20.3696 7.72656 20.4341 8.02913 20.4341 8.37646C20.4341 8.6486 20.3929 8.89925 20.3105 9.12842C20.2318 9.354 20.1172 9.55632 19.9668 9.73535C19.82 9.91081 19.641 10.0612 19.4297 10.1865C19.222 10.3118 18.9875 10.4085 18.7261 10.4766V10.498C18.8657 10.5768 18.9875 10.6646 19.0913 10.7612C19.1951 10.8543 19.2936 10.951 19.3867 11.0513C19.4798 11.1515 19.5711 11.2661 19.6606 11.395C19.7537 11.5203 19.8558 11.6672 19.9668 11.8354L21.3364 14ZM16.6582 7.33447V9.8374H17.7217C17.9186 9.8374 18.0994 9.80697 18.2642 9.74609C18.4325 9.68522 18.5775 9.59749 18.6992 9.48291C18.821 9.36833 18.9159 9.22868 18.9839 9.06396C19.0519 8.89925 19.0859 8.71484 19.0859 8.51074C19.0859 8.14193 18.9696 7.85368 18.7368 7.646C18.5041 7.43831 18.1693 7.33447 17.7324 7.33447H16.6582ZM25.3057 14.1289C24.1956 14.1289 23.3058 13.769 22.6362 13.0493C21.9702 12.3296 21.6372 11.3932 21.6372 10.2402C21.6372 9.0013 21.9774 8.01302 22.6577 7.27539C23.3381 6.53776 24.2619 6.16895 25.4292 6.16895C26.5106 6.16895 27.3807 6.52702 28.0396 7.24316C28.702 7.95931 29.0332 8.89567 29.0332 10.0522C29.0332 11.3091 28.6948 12.3027 28.0181 13.0332C27.3413 13.7637 26.4372 14.1289 25.3057 14.1289ZM25.3647 7.2915C24.6593 7.2915 24.0846 7.55469 23.6406 8.08105C23.2002 8.60742 22.98 9.30029 22.98 10.1597C22.98 11.0155 23.1948 11.7048 23.6245 12.2275C24.0542 12.7503 24.6164 13.0117 25.311 13.0117C26.0487 13.0117 26.6305 12.7629 27.0566 12.2651C27.4827 11.7674 27.6958 11.071 27.6958 10.1758C27.6958 9.25553 27.4881 8.54476 27.0728 8.04346C26.661 7.54215 26.0916 7.2915 25.3647 7.2915Z" fill="#8836ED"/>
	<path d="M33.9497 6.12103L36.1255 7.86105L38.0639 5.69175C38.1182 5.6311 38.1868 5.58237 38.2647 5.54917C38.3426 5.51598 38.4277 5.49918 38.5137 5.50003C38.5997 5.50088 38.6844 5.51935 38.7615 5.55408C38.8385 5.5888 38.906 5.63888 38.9588 5.70058L40.8086 7.86053L43.0547 6.09557C43.1429 6.0264 43.2522 5.98337 43.3681 5.97223C43.4839 5.96109 43.6007 5.98238 43.7029 6.03325C43.8051 6.08412 43.8877 6.16214 43.9398 6.25687C43.9918 6.3516 44.0108 6.45852 43.9941 6.56332L43.1364 11.9408H33.8771L33.0063 6.58774C32.989 6.48236 33.0077 6.3747 33.06 6.27933C33.1122 6.18395 33.1955 6.10549 33.2985 6.05456C33.4014 6.00362 33.5191 5.98269 33.6356 5.99458C33.7521 6.00647 33.8618 6.05061 33.9497 6.12103ZM33.9217 12.4606H43.0707V12.9803C43.0707 13.1181 43.0104 13.2503 42.9032 13.3478C42.796 13.4452 42.6505 13.5 42.4989 13.5H34.4935C34.3419 13.5 34.1964 13.4452 34.0892 13.3478C33.982 13.2503 33.9217 13.1181 33.9217 12.9803V12.4606Z" fill="#8836ED"/>
	</svg>


);
export const HelpDoc1 = (
	<svg width="45" height="42" viewBox="0 0 45 42" fill="none" xmlns="http://www.w3.org/2000/svg">
		<path d="M13.8984 21C11.3672 21.0781 9.29688 22.0781 7.6875 24H4.54688C3.26562 24 2.1875 23.6836 1.3125 23.0508C0.4375 22.418 0 21.4922 0 20.2734C0 14.7578 0.96875 12 2.90625 12C3 12 3.33984 12.1641 3.92578 12.4922C4.51172 12.8203 5.27344 13.1523 6.21094 13.4883C7.14844 13.8242 8.07812 13.9922 9 13.9922C10.0469 13.9922 11.0859 13.8125 12.1172 13.4531C12.0391 14.0312 12 14.5469 12 15C12 17.1719 12.6328 19.1719 13.8984 21ZM39 35.9297C39 37.8047 38.4297 39.2852 37.2891 40.3711C36.1484 41.457 34.6328 42 32.7422 42H12.2578C10.3672 42 8.85156 41.457 7.71094 40.3711C6.57031 39.2852 6 37.8047 6 35.9297C6 35.1016 6.02734 34.293 6.08203 33.5039C6.13672 32.7148 6.24609 31.8633 6.41016 30.9492C6.57422 30.0352 6.78125 29.1875 7.03125 28.4062C7.28125 27.625 7.61719 26.8633 8.03906 26.1211C8.46094 25.3789 8.94531 24.7461 9.49219 24.2227C10.0391 23.6992 10.707 23.2812 11.4961 22.9688C12.2852 22.6562 13.1562 22.5 14.1094 22.5C14.2656 22.5 14.6016 22.668 15.1172 23.0039C15.6328 23.3398 16.2031 23.7148 16.8281 24.1289C17.4531 24.543 18.2891 24.918 19.3359 25.2539C20.3828 25.5898 21.4375 25.7578 22.5 25.7578C23.5625 25.7578 24.6172 25.5898 25.6641 25.2539C26.7109 24.918 27.5469 24.543 28.1719 24.1289C28.7969 23.7148 29.3672 23.3398 29.8828 23.0039C30.3984 22.668 30.7344 22.5 30.8906 22.5C31.8438 22.5 32.7148 22.6562 33.5039 22.9688C34.293 23.2812 34.9609 23.6992 35.5078 24.2227C36.0547 24.7461 36.5391 25.3789 36.9609 26.1211C37.3828 26.8633 37.7188 27.625 37.9688 28.4062C38.2188 29.1875 38.4258 30.0352 38.5898 30.9492C38.7539 31.8633 38.8633 32.7148 38.918 33.5039C38.9727 34.293 39 35.1016 39 35.9297ZM15 6C15 7.65625 14.4141 9.07031 13.2422 10.2422C12.0703 11.4141 10.6562 12 9 12C7.34375 12 5.92969 11.4141 4.75781 10.2422C3.58594 9.07031 3 7.65625 3 6C3 4.34375 3.58594 2.92969 4.75781 1.75781C5.92969 0.585938 7.34375 0 9 0C10.6562 0 12.0703 0.585938 13.2422 1.75781C14.4141 2.92969 15 4.34375 15 6ZM31.5 15C31.5 17.4844 30.6211 19.6055 28.8633 21.3633C27.1055 23.1211 24.9844 24 22.5 24C20.0156 24 17.8945 23.1211 16.1367 21.3633C14.3789 19.6055 13.5 17.4844 13.5 15C13.5 12.5156 14.3789 10.3945 16.1367 8.63672C17.8945 6.87891 20.0156 6 22.5 6C24.9844 6 27.1055 6.87891 28.8633 8.63672C30.6211 10.3945 31.5 12.5156 31.5 15ZM45 20.2734C45 21.4922 44.5625 22.418 43.6875 23.0508C42.8125 23.6836 41.7344 24 40.4531 24H37.3125C35.7031 22.0781 33.6328 21.0781 31.1016 21C32.3672 19.1719 33 17.1719 33 15C33 14.5469 32.9609 14.0312 32.8828 13.4531C33.9141 13.8125 34.9531 13.9922 36 13.9922C36.9219 13.9922 37.8516 13.8242 38.7891 13.4883C39.7266 13.1523 40.4883 12.8203 41.0742 12.4922C41.6602 12.1641 42 12 42.0938 12C44.0312 12 45 14.7578 45 20.2734ZM42 6C42 7.65625 41.4141 9.07031 40.2422 10.2422C39.0703 11.4141 37.6562 12 36 12C34.3438 12 32.9297 11.4141 31.7578 10.2422C30.5859 9.07031 30 7.65625 30 6C30 4.34375 30.5859 2.92969 31.7578 1.75781C32.9297 0.585938 34.3438 0 36 0C37.6562 0 39.0703 0.585938 40.2422 1.75781C41.4141 2.92969 42 4.34375 42 6Z" fill="#848684"/>
		</svg>

);
export const HelpDoc2 = (
	<svg width="42" height="42" viewBox="0 0 42 42" fill="none" xmlns="http://www.w3.org/2000/svg">
		<path d="M27.9883 11.6396C35.0729 11.6396 38.6176 11.6397 40.6084 13.7119C42.5991 15.7845 42.131 18.985 41.1924 25.3896L40.3066 31.4609C39.5717 36.4814 39.2037 38.9926 37.3203 40.4961C35.4368 41.9996 32.6566 42 27.1006 42H14.8994C9.34119 42 6.56536 41.9996 4.67969 40.4961C2.79618 38.9926 2.42828 36.4815 1.69336 31.4609L0.807617 25.3877C-0.13103 18.9852 -0.600029 15.7845 1.39062 13.7119C3.38133 11.6393 6.92666 11.6396 14.0117 11.6396H27.9883ZM19.3408 21.2441C18.2006 20.5369 16.7998 21.457 16.7998 22.9121V31.6895C16.7998 33.1447 18.2006 34.062 19.3408 33.3564L26.4199 28.9678C27.5934 28.2412 27.5934 26.3604 26.4199 25.6338L19.3408 21.2441ZM33.3086 5.71777C36.2296 5.71777 38.6239 7.482 39.4219 9.82129L39.4697 9.96777C38.634 9.71373 37.7647 9.54991 36.8828 9.43652C34.6128 9.14464 31.7464 9.14551 28.416 9.14551H13.9434C10.613 9.14551 7.74441 9.14464 5.47656 9.43652C4.59678 9.54781 3.72534 9.71582 2.88965 9.96777L2.94043 9.82129C3.73841 7.48203 6.13195 5.71777 9.05078 5.71777H33.3086ZM28.3281 0C28.8152 1.41215e-09 29.1891 -0.000242011 29.5166 0.03125C31.8432 0.260202 33.7472 1.65942 34.5557 3.54297H7.44238C8.25084 1.65936 10.1557 0.260139 12.4824 0.03125C12.8057 -0.000205169 13.1797 0 13.6709 0H28.3281Z" fill="#848684"/>
		</svg>

);
export const HelpDoc3 = (
	<svg width="44" height="44" viewBox="0 0 44 44" fill="none" xmlns="http://www.w3.org/2000/svg">
		<path d="M44 6C44 7.5913 43.3679 9.11742 42.2426 10.2426C41.1174 11.3679 39.5913 12 38 12C36.4087 12 34.8826 11.3679 33.7574 10.2426C32.6321 9.11742 32 7.5913 32 6C32 4.4087 32.6321 2.88258 33.7574 1.75736C34.8826 0.632141 36.4087 0 38 0C39.5913 0 41.1174 0.632141 42.2426 1.75736C43.3679 2.88258 44 4.4087 44 6Z" fill="#848684"/>
		<path d="M29.9992 0.0241998C28.6242 -1.80304e-07 27.0732 0 25.3 0H18.7C11.4994 0 7.898 0 5.2536 1.6214C3.77343 2.52789 2.52879 3.77178 1.6214 5.2514C0 7.898 0 11.5016 0 18.7V20.9C0 26.026 2.6226e-07 28.589 0.836 30.6086C1.38906 31.9434 2.19965 33.1562 3.22149 34.1776C4.24334 35.1991 5.4564 36.0092 6.7914 36.5618C8.2434 37.1646 9.9748 37.3318 12.738 37.3802C14.608 37.4132 15.543 37.4286 16.2866 37.862C17.028 38.2932 17.4922 39.0742 18.4162 40.6384L19.6086 42.6536C20.6712 44.4488 23.3266 44.4488 24.3914 42.6536L25.5838 40.6384C26.5078 39.0764 26.9698 38.2932 27.7134 37.862C28.457 37.4286 29.392 37.4132 31.262 37.3802C34.0252 37.334 35.7566 37.1646 37.2086 36.5618C38.5432 36.009 39.7558 35.1987 40.7773 34.1773C41.7987 33.1558 42.609 31.9432 43.1618 30.6086C44 28.589 44 26.026 44 20.9V18.7C44 16.929 44 15.3758 43.9758 14.0008C42.0886 15.6785 39.6317 16.5717 37.1077 16.4975C34.5836 16.4234 32.1833 15.3877 30.3978 13.6022C28.6123 11.8167 27.5766 9.41635 27.5025 6.89234C27.4284 4.36832 28.3215 1.91139 29.9992 0.0241998Z" fill="#848684"/>
		</svg>


);
export const HelpDoc4 = (
	<svg width="33" height="42" viewBox="0 0 33 42" fill="none" xmlns="http://www.w3.org/2000/svg">
		<path d="M6.08234 42H26.9177C30.9793 42 33 39.943 33 35.8684V18.0813H18.7953C16.284 18.0813 15.1071 16.8861 15.1071 14.3786V0H6.08234C2.04084 0 0 2.07618 0 6.15164V35.8684C0 39.9623 2.04084 42 6.08234 42ZM18.8548 15.3975H32.784C32.6467 14.5943 32.0775 13.8103 31.1559 12.8507L20.3255 1.86137C19.4231 0.921075 18.5994 0.352716 17.7749 0.214806V14.3402C17.7749 15.0448 18.1482 15.3975 18.8548 15.3975ZM8.94688 26.5641C8.14243 26.5641 7.57321 25.9957 7.57321 25.2318C7.57321 24.467 8.14243 23.8995 8.94605 23.8995H24.0724C24.8576 23.8995 25.4661 24.4678 25.4661 25.2309C25.4661 25.9957 24.8576 26.5632 24.0732 26.5632L8.94688 26.5641ZM8.94688 34.0271C8.14243 34.0271 7.57321 33.4587 7.57321 32.6948C7.57321 31.9309 8.14243 31.3625 8.94605 31.3625H24.0724C24.8576 31.3625 25.4661 31.9309 25.4661 32.6948C25.4661 33.4587 24.8576 34.0271 24.0732 34.0271H8.94688Z" fill="#5C605D"/>
	</svg>


);
export const getstartCheckmark = (
	<svg width="13" height="10" viewBox="0 0 13 10" fill="none" xmlns="http://www.w3.org/2000/svg">
		<path d="M4.34855 7.21543L11.3173 0.246682C11.4818 0.0822273 11.6736 0 11.8929 0C12.1122 0 12.304 0.0822273 12.4685 0.246682C12.6329 0.411136 12.7152 0.606562 12.7152 0.832961C12.7152 1.05936 12.6329 1.25451 12.4685 1.41842L4.92414 8.98332C4.75969 9.14777 4.56782 9.23 4.34855 9.23C4.12928 9.23 3.93742 9.14777 3.77296 8.98332L0.237194 5.44755C0.0727395 5.2831 -0.00619866 5.08794 0.00037951 4.86209C0.00695768 4.63624 0.0927478 4.44081 0.25775 4.27581C0.422753 4.11081 0.61818 4.02858 0.84403 4.02913C1.06988 4.02968 1.26503 4.11191 1.42949 4.27581L4.34855 7.21543Z" fill="#008717"/>
	</svg>


);
export const YTiconmini = (
	<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
		<path fill-rule="evenodd" clip-rule="evenodd" d="M8 16C10.1217 16 12.1566 15.1571 13.6569 13.6569C15.1571 12.1566 16 10.1217 16 8C16 5.87827 15.1571 3.84344 13.6569 2.34315C12.1566 0.842855 10.1217 0 8 0C5.87827 0 3.84344 0.842855 2.34315 2.34315C0.842855 3.84344 0 5.87827 0 8C0 10.1217 0.842855 12.1566 2.34315 13.6569C3.84344 15.1571 5.87827 16 8 16ZM7.555 5.168C7.4044 5.06752 7.22935 5.00981 7.04852 5.00103C6.86769 4.99224 6.68786 5.03272 6.52823 5.11813C6.3686 5.20354 6.23516 5.33068 6.14213 5.48599C6.04909 5.6413 5.99997 5.81896 6 6V10C5.99997 10.181 6.04909 10.3587 6.14213 10.514C6.23516 10.6693 6.3686 10.7965 6.52823 10.8819C6.68786 10.9673 6.86769 11.0078 7.04852 10.999C7.22935 10.9902 7.4044 10.9325 7.555 10.832L10.555 8.832C10.692 8.74068 10.8043 8.61696 10.8819 8.47182C10.9596 8.32668 11.0002 8.16461 11.0002 8C11.0002 7.83539 10.9596 7.67332 10.8819 7.52818C10.8043 7.38304 10.692 7.25932 10.555 7.168L7.555 5.168Z" fill="#3858E9"/>
	</svg>
);
export const GetProrightdesign = (
	<svg width="263" height="202" viewBox="0 0 263 202" fill="none" xmlns="http://www.w3.org/2000/svg">
		<g opacity="0.4">
		<path d="M101.844 13.3072C104.472 10.9776 107.344 7.09352 110.274 2.81668C108.364 2.54485 106.738 2.1011 105.858 1.19807C103.816 5.67394 101.64 8.47588 98.3846 12.068C99.7222 11.618 100.586 12.894 101.844 13.3072Z" fill="#C6EAE9"/>
		<path d="M210.929 123.523C213.298 121.423 215.88 117.925 218.522 114.076C216.8 113.831 215.337 113.43 214.543 112.619C212.704 116.648 210.745 119.172 207.813 122.409C209.02 121.999 209.797 123.147 210.929 123.523Z" fill="#FBD682"/>
		<path d="M213.03 77.1006C211.971 74.7188 210.005 71.9349 207.812 69.0554C207.401 70.5249 206.918 71.7473 206.26 72.3228C208.689 74.5299 210.094 76.6197 211.834 79.6669C211.736 78.5463 212.617 78.0359 213.03 77.1006Z" fill="#FBD682"/>
		<path d="M126.83 144.341C125.652 141.696 123.472 138.608 121.035 135.407C120.577 137.039 120.042 138.398 119.312 139.035C122.011 141.485 123.57 143.805 125.499 147.19C125.392 145.95 126.37 145.383 126.83 144.341Z" fill="#EE6F57"/>
		<path d="M61.2935 11.857C60.1156 9.21174 57.9326 6.1235 55.4984 2.92312C55.0407 4.55433 54.5059 5.91346 53.7763 6.55069C56.4746 9.00058 58.0339 11.3201 59.9632 14.7053C59.8562 13.4652 60.8341 12.8984 61.2935 11.857Z" fill="#1DA857"/>
		<path d="M186.182 155.375C187.204 152.977 189.127 150.163 191.275 147.25C191.709 148.713 192.211 149.928 192.878 150.493C190.483 152.738 189.111 154.849 187.418 157.923C187.498 156.804 186.609 156.307 186.182 155.375Z" fill="#1DA857"/>
		<path d="M172.956 47.7468C174.093 45.0836 176.225 41.9621 178.612 38.7245C179.095 40.3484 179.651 41.6991 180.39 42.325C177.73 44.8163 176.207 47.1596 174.33 50.5742C174.418 49.3325 173.431 48.7781 172.956 47.7468Z" fill="#78847D"/>
		<path d="M60.2158 47.8117C63.5355 48.5819 68.1677 48.8967 73.1302 49.1004C72.1935 47.7721 71.5581 46.5583 71.7096 45.6418C67.1277 46.0862 63.7226 45.7925 59.0792 45.1161C60.2196 45.7945 59.7742 46.8441 60.2158 47.8117Z" fill="#F5C7BE"/>
		<path d="M205.563 12.4117C202.588 13.5309 198.422 14.0472 193.956 14.4155C194.777 12.5701 195.326 10.8853 195.174 9.62328C199.307 10.1562 202.367 9.69016 206.538 8.67578C205.524 9.62961 205.942 11.0704 205.563 12.4117Z" fill="#C6EAE9"/>
		<path d="M145.418 8.21122C148.789 10.1746 153.672 11.6699 158.936 13.0511C158.25 10.6775 157.858 8.55199 158.239 7.08275C153.229 6.84598 149.655 5.641 144.845 3.54964C145.902 4.90205 145.177 6.53254 145.418 8.21122Z" fill="#EE6F57"/>
		<path d="M89.0552 120.079C86.5614 121.779 83.7134 124.797 80.7761 128.148C82.4073 128.614 83.7752 129.196 84.4553 130.084C86.6393 126.452 88.7844 124.288 91.9409 121.57C90.7379 121.799 90.1081 120.588 89.0552 120.079Z" fill="#C6EAE9"/>
		<path d="M169.755 126.071C167.261 127.771 164.413 130.789 161.476 134.14C163.107 134.606 164.475 135.188 165.155 136.076C167.339 132.445 169.484 130.28 172.641 127.562C171.438 127.791 170.808 126.583 169.755 126.071Z" fill="#FBD682"/>
		<path d="M228.263 23.8843C225.456 25.798 222.249 29.195 218.942 32.9656C220.777 33.4912 222.318 34.147 223.083 35.1456C225.541 31.0588 227.957 28.6223 231.509 25.5621C230.159 25.8229 229.45 24.4595 228.263 23.8843Z" fill="#F5C7BE"/>
		<path d="M65.0694 93.7579C62.9678 91.8459 60.7883 88.4822 58.5893 84.7541C60.2856 84.2764 61.75 83.6669 62.5995 82.7087C64.0023 86.7268 65.6653 89.1429 68.2068 92.1839C67.075 91.9088 66.2087 93.2204 65.0694 93.7579Z" fill="#F5C7BE"/>
		<path d="M260.302 62.919C259.243 60.5371 257.277 57.7533 255.084 54.8738C254.673 56.3433 254.19 57.5657 253.532 58.1411C255.961 60.3483 257.366 62.4381 259.106 65.4852C259.008 64.3675 259.889 63.8571 260.302 62.919Z" fill="#EE6F57"/>
		<path d="M261.072 16.7436C260.457 19.272 259.037 22.3825 257.415 25.6364C256.768 24.3115 256.095 23.2371 255.363 22.8282C257.326 20.1726 258.324 17.85 259.48 14.5356C259.575 15.6311 260.512 15.9327 261.072 16.7436Z" fill="#78847D"/>
		<path d="M19.3601 18.1799C22.1959 20.05 25.4548 23.3971 28.8196 27.1161C26.9931 27.67 25.4624 28.3496 24.7106 29.3598C22.1892 25.3115 19.7361 22.9126 16.1376 19.9076C17.4944 20.1448 18.1822 18.7733 19.3601 18.1799Z" fill="#FBD682"/>
		<path d="M126.461 29.5588C129.297 31.4289 132.556 34.776 135.921 38.495C134.094 39.0489 132.564 39.7285 131.812 40.7387C129.29 36.6904 126.837 34.2915 123.239 31.2865C124.596 31.5237 125.283 30.1522 126.461 29.5588Z" fill="#FBD682"/>
		</g>
		<path d="M245.202 107.738H168.387C164.845 107.738 161.974 110.61 161.974 114.152V186.554C161.974 190.096 164.845 192.968 168.387 192.968H245.202C248.744 192.968 251.615 190.096 251.615 186.554V114.152C251.615 110.61 248.744 107.738 245.202 107.738Z" fill="#EDF0F2"/>
		<path d="M205.632 173.664C218.433 173.664 228.809 163.288 228.809 150.487C228.809 137.687 218.433 127.311 205.632 127.311C192.832 127.311 182.456 137.687 182.456 150.487C182.456 163.288 192.832 173.664 205.632 173.664Z" fill="white"/>
		<path d="M214.574 162.801H197.438C196.346 162.801 195.461 161.916 195.461 160.824V137.098C195.461 136.006 196.346 135.121 197.438 135.121H209.96L216.551 141.712V160.824C216.551 161.916 215.666 162.801 214.574 162.801Z" fill="#43A047"/>
		<path d="M216.55 141.712H209.959V135.121L216.55 141.712Z" fill="#C8E6C9"/>
		<path d="M209.959 141.715L216.55 148.305V141.715H209.959Z" fill="#2E7D32"/>
		<path d="M210.62 148.301H201.393H200.075V149.619V150.937V152.255V153.573V154.891V156.209V157.528H211.938V156.209V154.891V153.573V152.255V150.937V149.619V148.301H210.62ZM201.393 149.619H204.029V150.937H201.393V149.619ZM201.393 152.255H204.029V153.573H201.393V152.255ZM201.393 154.891H204.029V156.209H201.393V154.891ZM210.62 156.209H205.347V154.891H210.62V156.209ZM210.62 153.573H205.347V152.255H210.62V153.573ZM210.62 150.937H205.347V149.619H210.62V150.937Z" fill="#E8F5E9"/>
		<path d="M190.679 115.564H167.874V120.952H190.679V115.564Z" fill="white"/>
		<path d="M190.679 124.02H167.874V129.407H190.679V124.02Z" fill="white"/>
		<path d="M8.0791 54.5127L166.97 55.5596C170.965 55.5861 174.189 58.832 174.189 62.8271V192.485C174.189 196.489 170.951 199.74 166.947 199.754L8.26074 200.312C4.24111 200.327 0.973049 197.074 0.966797 193.055L0.762695 61.792C0.756416 57.7547 4.04189 54.4861 8.0791 54.5127Z" fill="white" stroke="#E2E5F1" stroke-width="1.49673"/>
		<path opacity="0.8" d="M16.4512 118.84V130.33L46.6123 129.843V118.84H16.4512Z" fill="#BAC6F2"/>
		<path opacity="0.8" d="M53.7959 118.84V130.33L111.246 129.843V118.84H53.7959Z" fill="#BAC6F2"/>
		<path opacity="0.8" d="M116.988 118.84V130.33L164.384 129.843V118.84H116.988Z" fill="#BAC6F2"/>
		<g opacity="0.6">
		<path opacity="0.3" d="M16.4487 136.076V146.13L46.6099 145.704V136.076H16.4487Z" fill="#BAC6F2"/>
		<path opacity="0.8" d="M16.4487 151.875V161.929L46.6099 161.503V151.875H16.4487Z" fill="#BAC6F2"/>
		<path opacity="0.3" d="M16.4487 167.674V177.728L46.6099 177.302V167.674H16.4487Z" fill="#BAC6F2"/>
		<path opacity="0.8" d="M16.4487 183.473V193.526L46.6099 193.1V183.473H16.4487Z" fill="#BAC6F2"/>
		<path opacity="0.3" d="M53.792 136.076V146.13L111.242 145.704V136.076H53.792Z" fill="#BAC6F2"/>
		<path opacity="0.8" d="M53.792 151.875V161.929L111.242 161.503V151.875H53.792Z" fill="#BAC6F2"/>
		<path opacity="0.3" d="M53.792 167.674V177.728L111.242 177.302V167.674H53.792Z" fill="#BAC6F2"/>
		<path opacity="0.8" d="M53.792 183.473V193.526L111.242 193.1V183.473H53.792Z" fill="#BAC6F2"/>
		<path opacity="0.3" d="M116.987 136.076V146.13L164.383 145.704V136.076H116.987Z" fill="#BAC6F2"/>
		<path opacity="0.8" d="M116.987 151.875V161.929L164.383 161.503V151.875H116.987Z" fill="#BAC6F2"/>
		<path opacity="0.3" d="M116.987 167.674V177.728L164.383 177.302V167.674H116.987Z" fill="#BAC6F2"/>
		<path opacity="0.8" d="M116.987 183.473V193.526L164.383 193.1V183.473H116.987Z" fill="#BAC6F2"/>
		</g>
		<path d="M117.178 91.5603C120.351 91.5603 122.923 88.9882 122.923 85.8153C122.923 82.6424 120.351 80.0703 117.178 80.0703C114.005 80.0703 111.433 82.6424 111.433 85.8153C111.433 88.9882 114.005 91.5603 117.178 91.5603Z" fill="#BAC6F2"/>
		<path d="M132.977 91.5603C136.15 91.5603 138.722 88.9882 138.722 85.8153C138.722 82.6424 136.15 80.0703 132.977 80.0703C129.804 80.0703 127.232 82.6424 127.232 85.8153C127.232 88.9882 129.804 91.5603 132.977 91.5603Z" fill="#BAC6F2"/>
		<path d="M148.776 91.5603C151.949 91.5603 154.521 88.9882 154.521 85.8153C154.521 82.6424 151.949 80.0703 148.776 80.0703C145.603 80.0703 143.031 82.6424 143.031 85.8153C143.031 88.9882 145.603 91.5603 148.776 91.5603Z" fill="#BAC6F2"/>
		<path d="M85.7171 64.4941H16.7773V106.145H85.7171V64.4941Z" fill="#E9EDFA"/>
		<path d="M19.6504 96.3853C19.6504 96.3853 24.3415 86.1206 28.8003 87.2353C33.2592 88.3501 34.3739 93.0411 37.718 91.0439C41.0622 89.0467 43.2452 80.9651 46.4964 79.6646C51.1411 77.8531 52.6738 79.8503 58.9441 83.4267C65.2143 87.0031 67.8618 86.2135 70.4163 83.5661C72.7851 81.1509 77.1511 74.6019 81.9815 71.6758" stroke="#BAC6F2" stroke-width="1.55549" stroke-linecap="round" stroke-linejoin="round"/>
	</svg>


);

export const LoaderIcon = (
	<svg
		width="20"
		height="20"
		viewBox="0 0 20 20"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<circle
			cx="10"
			cy="10"
			r="8"
			stroke="#E5E7EB"
			strokeWidth="3"
			strokeLinecap="round"
		/>
		<circle
			cx="10"
			cy="10"
			r="8"
			stroke="#008717"
			strokeWidth="3"
			strokeLinecap="round"
			strokeDasharray="50.27"
			strokeDashoffset="37.7"
		>
			<animateTransform
				attributeName="transform"
				type="rotate"
				from="0 10 10"
				to="360 10 10"
				dur="1s"
				repeatCount="indefinite"
			/>
		</circle>
	</svg>
);
export const KeyboardArrowDown = (
	<svg
		width="24"
		height="24"
		viewBox="0 0 24 24"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			fill="#000000"
			d="M7.41 8.59L12 13.17l4.59-4.58L18 10l-6 6l-6-6l1.41-1.41z"
		/>
	</svg>
);
export const lockpro = (
	<svg
		width="8"
		height="10"
		viewBox="0 0 8 10"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			fill-rule="evenodd"
			clip-rule="evenodd"
			d="M4 0.5C2.75736 0.5 1.75 1.50736 1.75 2.75V4.5H1.5C0.947715 4.5 0.5 4.94772 0.5 5.5V8.5C0.5 9.05228 0.947715 9.5 1.5 9.5H6.5C7.05228 9.5 7.5 9.05228 7.5 8.5V5.5C7.5 4.94772 7.05228 4.5 6.5 4.5H6.25V2.75C6.25 1.50736 5.24264 0.5 4 0.5ZM5.5 4.5V2.75C5.5 1.92157 4.82843 1.25 4 1.25C3.17157 1.25 2.5 1.92157 2.5 2.75V4.5H5.5Z"
			fill="white"
		/>
	</svg>
);
export const lockBTN = (
	<svg
		width="100"
		height="26"
		viewBox="0 0 100 26"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<rect width="100" height="26" rx="5" fill="#8836ED" />
		<path
			fill-rule="evenodd"
			clip-rule="evenodd"
			d="M13 8.5C11.7574 8.5 10.75 9.50736 10.75 10.75V12.5H10.5C9.94772 12.5 9.5 12.9477 9.5 13.5V16.5C9.5 17.0523 9.94772 17.5 10.5 17.5H15.5C16.0523 17.5 16.5 17.0523 16.5 16.5V13.5C16.5 12.9477 16.0523 12.5 15.5 12.5H15.25V10.75C15.25 9.50736 14.2426 8.5 13 8.5ZM14.5 12.5V10.75C14.5 9.92157 13.8284 9.25 13 9.25C12.1716 9.25 11.5 9.92157 11.5 10.75V12.5H14.5Z"
			fill="white"
		/>
		<path
			d="M28.875 13.8848C28.875 16.0475 27.8509 17.1289 25.8027 17.1289C23.8405 17.1289 22.8594 16.0887 22.8594 14.0083V9.29785H24.1377V13.7451C24.1377 15.2562 24.7249 16.0117 25.8994 16.0117C27.0309 16.0117 27.5967 15.283 27.5967 13.8257V9.29785H28.875V13.8848ZM31.813 16.189H31.7915V19.5298H30.5454V11.5H31.7915V12.4668H31.813C32.2391 11.7363 32.8621 11.3711 33.6821 11.3711C34.3804 11.3711 34.9246 11.6164 35.3149 12.1069C35.7052 12.5975 35.9004 13.2563 35.9004 14.0835C35.9004 15.0002 35.6802 15.7342 35.2397 16.2856C34.7993 16.8371 34.1978 17.1128 33.4351 17.1128C32.7332 17.1128 32.1925 16.8049 31.813 16.189ZM31.7808 14.019V14.7012C31.7808 15.1022 31.9079 15.4424 32.1621 15.7217C32.4199 16.001 32.7458 16.1406 33.1396 16.1406C33.6016 16.1406 33.9632 15.9616 34.2246 15.6035C34.4896 15.2419 34.6221 14.7388 34.6221 14.0942C34.6221 13.5535 34.4985 13.131 34.2515 12.8267C34.008 12.5187 33.6768 12.3647 33.2578 12.3647C32.8138 12.3647 32.4557 12.5223 32.1836 12.8374C31.915 13.1525 31.7808 13.5464 31.7808 14.019ZM42.1792 16.5596C42.1792 18.5791 41.1641 19.5889 39.1338 19.5889C38.4176 19.5889 37.7928 19.4689 37.2593 19.229V18.0903C37.8608 18.4341 38.432 18.606 38.9727 18.606C40.2796 18.606 40.9331 17.9632 40.9331 16.6777V16.0762H40.9116C40.4998 16.778 39.8804 17.1289 39.0532 17.1289C38.3836 17.1289 37.8429 16.8854 37.4312 16.3984C37.0229 15.9079 36.8188 15.2508 36.8188 14.4272C36.8188 13.4927 37.0391 12.7497 37.4795 12.1982C37.9199 11.6468 38.5251 11.3711 39.2949 11.3711C40.0218 11.3711 40.5607 11.6683 40.9116 12.2627H40.9331V11.5H42.1792V16.5596ZM40.9438 14.481V13.7666C40.9438 13.3799 40.8149 13.0505 40.5571 12.7783C40.3029 12.5026 39.9842 12.3647 39.6011 12.3647C39.1284 12.3647 38.7578 12.5402 38.4893 12.8911C38.2243 13.2384 38.0918 13.7254 38.0918 14.3521C38.0918 14.8927 38.2189 15.326 38.4731 15.6519C38.731 15.9741 39.0711 16.1353 39.4937 16.1353C39.9233 16.1353 40.2725 15.9813 40.541 15.6733C40.8096 15.3618 40.9438 14.9644 40.9438 14.481ZM46.9917 12.687C46.8413 12.5688 46.6247 12.5098 46.3418 12.5098C45.973 12.5098 45.665 12.6763 45.418 13.0093C45.1709 13.3423 45.0474 13.7952 45.0474 14.3682V17H43.8013V11.5H45.0474V12.6333H45.0688C45.1906 12.2466 45.3768 11.9458 45.6274 11.731C45.8817 11.5125 46.1646 11.4033 46.4761 11.4033C46.7017 11.4033 46.8735 11.4373 46.9917 11.5054V12.687ZM52.0942 17H50.8857V16.1406H50.8643C50.4847 16.7995 49.9279 17.1289 49.1938 17.1289C48.6532 17.1289 48.2288 16.9821 47.9209 16.6885C47.6165 16.3949 47.4644 16.0063 47.4644 15.5229C47.4644 14.4845 48.0623 13.8794 49.2583 13.7075L50.8911 13.4766C50.8911 12.6924 50.5187 12.3003 49.7739 12.3003C49.1187 12.3003 48.5278 12.5259 48.0015 12.9771V11.8867C48.5815 11.543 49.2511 11.3711 50.0103 11.3711C51.3996 11.3711 52.0942 12.055 52.0942 13.4229V17ZM50.8911 14.2983L49.7363 14.4595C49.3783 14.506 49.1079 14.5938 48.9253 14.7227C48.7463 14.848 48.6567 15.07 48.6567 15.3887C48.6567 15.6214 48.7391 15.813 48.9038 15.9634C49.0721 16.1102 49.2959 16.1836 49.5752 16.1836C49.9548 16.1836 50.2681 16.0511 50.5151 15.7861C50.7658 15.5176 50.8911 15.181 50.8911 14.7764V14.2983ZM58.6201 17H57.374V16.0654H57.3525C56.9515 16.7744 56.3338 17.1289 55.4995 17.1289C54.8228 17.1289 54.2803 16.8836 53.8721 16.3931C53.4674 15.8989 53.2651 15.2275 53.2651 14.3789C53.2651 13.4694 53.4889 12.7407 53.9365 12.1929C54.3877 11.645 54.9875 11.3711 55.7358 11.3711C56.4771 11.3711 57.016 11.6683 57.3525 12.2627H57.374V8.85742H58.6201V17ZM57.3901 14.4863V13.7666C57.3901 13.3763 57.263 13.0451 57.0088 12.7729C56.7546 12.5008 56.4305 12.3647 56.0366 12.3647C55.5711 12.3647 55.2041 12.5384 54.9355 12.8857C54.6706 13.2331 54.5381 13.7147 54.5381 14.3306C54.5381 14.8892 54.6652 15.3314 54.9194 15.6572C55.1772 15.9795 55.5228 16.1406 55.9561 16.1406C56.3822 16.1406 56.7277 15.9849 56.9927 15.6733C57.2576 15.3582 57.3901 14.9626 57.3901 14.4863ZM64.9043 14.5884H61.1553C61.1696 15.0968 61.3254 15.4889 61.6226 15.7646C61.9233 16.0404 62.3351 16.1782 62.8579 16.1782C63.4451 16.1782 63.984 16.0028 64.4746 15.6519V16.6562C63.9733 16.9714 63.3109 17.1289 62.4873 17.1289C61.6781 17.1289 61.0425 16.88 60.5806 16.3823C60.1222 15.881 59.8931 15.1774 59.8931 14.2715C59.8931 13.4157 60.1455 12.7192 60.6504 12.1821C61.1589 11.6414 61.7891 11.3711 62.541 11.3711C63.293 11.3711 63.8748 11.6128 64.2866 12.0962C64.6984 12.5796 64.9043 13.251 64.9043 14.1104V14.5884ZM63.7012 13.7075C63.6976 13.2599 63.592 12.9126 63.3843 12.6655C63.1766 12.4149 62.8901 12.2896 62.5249 12.2896C62.1668 12.2896 61.8625 12.4202 61.6118 12.6816C61.3647 12.943 61.2126 13.285 61.1553 13.7075H63.7012ZM75.7915 17H74.395L70.7158 11.3389C70.6227 11.1956 70.5457 11.047 70.4849 10.8931H70.4526C70.4813 11.0578 70.4956 11.4105 70.4956 11.9512V17H69.2603V9.29785H70.748L74.3037 14.8247C74.4541 15.0539 74.5508 15.2114 74.5938 15.2974H74.6152C74.5794 15.0933 74.5615 14.7477 74.5615 14.2607V9.29785H75.7915V17ZM80.0024 17.1289C79.1538 17.1289 78.4753 16.8729 77.9668 16.3608C77.4619 15.8452 77.2095 15.1631 77.2095 14.3145C77.2095 13.3906 77.4727 12.6691 77.999 12.1499C78.529 11.6307 79.2415 11.3711 80.1367 11.3711C80.9961 11.3711 81.6657 11.6235 82.1455 12.1284C82.6253 12.6333 82.8652 13.3333 82.8652 14.2285C82.8652 15.1058 82.6056 15.8094 82.0864 16.3394C81.5708 16.8657 80.8761 17.1289 80.0024 17.1289ZM80.0615 12.3647C79.5745 12.3647 79.1896 12.5348 78.9067 12.875C78.6239 13.2152 78.4824 13.6842 78.4824 14.2822C78.4824 14.8587 78.6257 15.3135 78.9121 15.6465C79.1986 15.9759 79.5817 16.1406 80.0615 16.1406C80.5521 16.1406 80.9281 15.9777 81.1895 15.6519C81.4544 15.326 81.5869 14.8623 81.5869 14.2607C81.5869 13.6556 81.4544 13.1883 81.1895 12.8589C80.9281 12.5295 80.5521 12.3647 80.0615 12.3647ZM91.5342 11.5L89.9121 17H88.6069L87.6079 13.2725C87.5685 13.1292 87.5435 12.9681 87.5327 12.7891H87.5112C87.5041 12.9108 87.4718 13.0684 87.4146 13.2617L86.3296 17H85.0513L83.4346 11.5H84.7236L85.7227 15.4639C85.7549 15.582 85.7764 15.7396 85.7871 15.9365H85.8247C85.8354 15.7861 85.8641 15.625 85.9106 15.4531L87.0225 11.5H88.1934L89.1816 15.48C89.2139 15.6053 89.2371 15.7629 89.2515 15.9526H89.2891C89.2962 15.8201 89.3231 15.6626 89.3696 15.48L90.3472 11.5H91.5342Z"
			fill="white"
		/>
	</svg>
);

export const editOnhoverDot = (
	<svg
		width="3"
		height="12"
		viewBox="0 0 3 12"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M0.700195 10.35C0.700195 10.045 0.821356 9.75249 1.03702 9.53683C1.25269 9.32116 1.5452 9.2 1.8502 9.2C2.15519 9.2 2.4477 9.32116 2.66337 9.53683C2.87903 9.75249 3.0002 10.045 3.0002 10.35C3.0002 10.655 2.87903 10.9475 2.66337 11.1632C2.4477 11.3788 2.15519 11.5 1.8502 11.5C1.5452 11.5 1.25269 11.3788 1.03702 11.1632C0.821356 10.9475 0.700195 10.655 0.700195 10.35ZM0.700195 5.75C0.700195 5.445 0.821356 5.15249 1.03702 4.93683C1.25269 4.72116 1.5452 4.6 1.8502 4.6C2.15519 4.6 2.4477 4.72116 2.66337 4.93683C2.87903 5.15249 3.0002 5.445 3.0002 5.75C3.0002 6.055 2.87903 6.34751 2.66337 6.56317C2.4477 6.77884 2.15519 6.9 1.8502 6.9C1.5452 6.9 1.25269 6.77884 1.03702 6.56317C0.821356 6.34751 0.700195 6.055 0.700195 5.75ZM0.700195 1.15C0.700195 0.845001 0.821356 0.552494 1.03702 0.336827C1.25269 0.12116 1.5452 0 1.8502 0C2.15519 0 2.4477 0.12116 2.66337 0.336827C2.87903 0.552494 3.0002 0.845001 3.0002 1.15C3.0002 1.455 2.87903 1.74751 2.66337 1.96317C2.4477 2.17884 2.15519 2.3 1.8502 2.3C1.5452 2.3 1.25269 2.17884 1.03702 1.96317C0.821356 1.74751 0.700195 1.455 0.700195 1.15Z"
			fill="#828282"
		/>
	</svg>
);
export const ThemeReset = (
	<svg
		width="15"
		height="15"
		viewBox="0 0 21 21"
		xmlns="http://www.w3.org/2000/svg"
		fill="#787878"
	>
		<g id="SVGRepo_bgCarrier" stroke-width="0" />
		<g
			id="SVGRepo_tracerCarrier"
			stroke-linecap="round"
			stroke-linejoin="round"
		/>
		<g id="SVGRepo_iconCarrier">
			{ ' ' }
			<g
				fill="none"
				fill-rule="evenodd"
				stroke="#787878"
				stroke-linecap="round"
				stroke-linejoin="round"
				transform="matrix(0 1 1 0 2.5 2.5)"
			>
				{ ' ' }
				<path d="m3.98652376 1.07807068c-2.38377179 1.38514556-3.98652376 3.96636605-3.98652376 6.92192932 0 4.418278 3.581722 8 8 8s8-3.581722 8-8-3.581722-8-8-8" />{ ' ' }
				<path d="m4 1v4h-4" transform="matrix(1 0 0 -1 0 6)" />{ ' ' }
			</g>{ ' ' }
		</g>
	</svg>
);

export const DragIcon = (
	<svg
		xmlns="http://www.w3.org/2000/svg"
		height="30px"
		width="30px"
		viewBox="0 -960 960 960"
		fill="#D9D9D9"
	>
		<path d="M360-160q-33 0-56.5-23.5T280-240q0-33 23.5-56.5T360-320q33 0 56.5 23.5T440-240q0 33-23.5 56.5T360-160Zm240 0q-33 0-56.5-23.5T520-240q0-33 23.5-56.5T600-320q33 0 56.5 23.5T680-240q0 33-23.5 56.5T600-160ZM360-400q-33 0-56.5-23.5T280-480q0-33 23.5-56.5T360-560q33 0 56.5 23.5T440-480q0 33-23.5 56.5T360-400Zm240 0q-33 0-56.5-23.5T520-480q0-33 23.5-56.5T600-560q33 0 56.5 23.5T680-480q0 33-23.5 56.5T600-400ZM360-640q-33 0-56.5-23.5T280-720q0-33 23.5-56.5T360-800q33 0 56.5 23.5T440-720q0 33-23.5 56.5T360-640Zm240 0q-33 0-56.5-23.5T520-720q0-33 23.5-56.5T600-800q33 0 56.5 23.5T680-720q0 33-23.5 56.5T600-640Z" />
	</svg>
);

export const wppoollogo = (
	<svg
		width="144"
		height="25"
		viewBox="0 0 144 25"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<g clip-path="url(#clip0_2377_37074)">
			<path
				d="M47.1367 5.46099H49.3466C49.5974 5.46029 49.847 5.49552 50.088 5.56565C50.3216 5.63351 50.5438 5.73695 50.7468 5.87244C50.948 6.00695 51.1304 6.16843 51.289 6.3525C51.4469 6.5346 51.5745 6.74161 51.6668 6.96537C52.1976 8.27437 52.7329 9.57182 53.2726 10.8577C53.8124 12.1436 54.3522 13.4411 54.892 14.7501C54.9846 14.9634 55.0491 15.1881 55.0841 15.4185C55.1116 15.6231 55.1299 15.804 55.1389 15.9614C55.1628 15.6535 55.2227 15.3496 55.3174 15.0562C55.4311 14.6964 55.5639 14.3431 55.7152 13.9979L58.6387 6.95094C58.7207 6.74169 58.8415 6.55031 58.9944 6.38715C59.1617 6.20409 59.3507 6.04283 59.5572 5.9071C59.7689 5.76714 59.9972 5.65486 60.2367 5.57288C60.4685 5.49103 60.712 5.44858 60.9574 5.44727H63.1673L61.602 9.22123L63.3452 13.4269C63.5283 13.8634 63.7067 14.2929 63.8803 14.7154C64.0432 15.0927 64.1407 15.4956 64.1684 15.9065C64.1774 15.8324 64.1888 15.7465 64.2026 15.6488C64.2163 15.5511 64.2414 15.4282 64.278 15.2799C64.324 15.1008 64.3791 14.9242 64.443 14.7508C64.5161 14.5468 64.6166 14.296 64.7447 13.9986L67.6718 6.95164C67.7532 6.74341 67.8719 6.55227 68.0218 6.38788C68.1855 6.20378 68.3723 6.04237 68.5775 5.90782C68.7893 5.76789 69.0176 5.65558 69.257 5.57359C69.4888 5.49173 69.7323 5.44931 69.9777 5.44799H72.1876L66.1207 20.0847H62.2225L60.1221 14.6815C60.0491 14.4866 59.9851 14.2871 59.9301 14.0831C59.8751 13.8789 59.8473 13.6681 59.8475 13.4565C59.8459 13.2529 59.8784 13.0506 59.9436 12.858C59.7695 13.3595 59.447 14.2089 58.9759 15.4063C58.5049 16.6036 57.8757 18.1633 57.0883 20.0855H53.1901L47.1367 5.46099Z"
				fill="#1F2937"
			/>
			<path
				d="M73.1486 5.45885H76.0842C76.1316 5.45885 76.2004 5.58638 76.2906 5.84144C76.4052 6.19768 76.4879 6.56374 76.5374 6.9351C76.6313 6.64924 76.8084 6.39901 77.0454 6.21754C77.3169 5.99962 77.6173 5.8215 77.9377 5.6884C78.2763 5.54459 78.628 5.43506 78.9878 5.36139C79.306 5.29205 79.6301 5.25482 79.9555 5.25023H80.0102C80.9886 5.24223 81.9575 5.44626 82.8519 5.84867C83.7119 6.23488 84.4902 6.78588 85.1443 7.47144C86.4935 8.89861 87.2451 10.8007 87.2412 12.7782C87.2374 14.7557 86.4784 16.6548 85.1237 18.0765C84.4623 18.7592 83.6768 19.3053 82.8107 19.6849C81.9101 20.0823 80.9375 20.2839 79.9555 20.2768C79.3861 20.275 78.8207 20.1809 78.2806 19.9981C77.7155 19.8086 77.1961 19.5001 76.7566 19.0929V24.803H73.1465L73.1486 5.45885ZM79.9433 8.88487C79.3156 8.88178 78.6964 9.03234 78.1383 9.32378C77.5911 9.60273 77.118 10.011 76.7587 10.5141V14.9984C77.125 15.507 77.6042 15.9208 78.1575 16.2063C78.7108 16.4919 79.3226 16.6412 79.9433 16.6422C80.4488 16.6473 80.9495 16.5427 81.4119 16.3353C81.8513 16.1378 82.2479 15.854 82.5787 15.5001C82.9113 15.1425 83.1744 14.7245 83.3542 14.2679C83.7294 13.2989 83.7294 12.2217 83.3542 11.2526C83.1765 10.795 82.9132 10.3765 82.5787 10.0204C82.2463 9.67015 81.85 9.3887 81.4119 9.19166C80.9494 8.98514 80.4487 8.88128 79.9433 8.88703V8.88487Z"
				fill="#1F2937"
			/>
			<path
				d="M92.31 5.45867C92.3593 5.56594 92.4141 5.67051 92.4743 5.77196C92.5714 5.95821 92.6187 6.16704 92.6116 6.37762V7.21282C92.6977 6.96547 92.8387 6.74149 93.0236 6.55809C93.2218 6.3596 93.4458 6.18957 93.6895 6.05277C93.9502 5.90497 94.2236 5.78151 94.5064 5.6839C94.7878 5.58517 95.0742 5.50155 95.3644 5.4334C95.6245 5.37174 95.888 5.32523 96.1534 5.29408C96.3629 5.26856 96.5735 5.25457 96.7845 5.2522C97.76 5.24382 98.7261 5.44559 99.6191 5.84415C100.472 6.22432 101.242 6.77359 101.884 7.45971C102.527 8.15502 103.034 8.96779 103.378 9.85489C104.101 11.7332 104.101 13.8187 103.378 15.697C103.033 16.5817 102.526 17.3921 101.884 18.0857C101.243 18.7719 100.472 19.3212 99.6191 19.7013C98.4175 20.233 97.093 20.4115 95.7963 20.2167C95.4346 20.1608 95.0802 20.064 94.7397 19.928C94.3582 19.7754 93.9963 19.5767 93.6618 19.336C93.2701 19.0523 92.9169 18.7173 92.6116 18.3398V24.997H90.374V5.45867H92.31ZM96.7845 18.0626C97.4698 18.0709 98.1489 17.9309 98.7767 17.6519C99.3666 17.3881 99.8967 17.0041 100.334 16.5236C100.776 16.0333 101.121 15.4613 101.35 14.8387C101.835 13.5038 101.835 12.0373 101.35 10.7024C101.121 10.0799 100.776 9.50785 100.334 9.01751C99.8966 8.53715 99.3665 8.15312 98.7767 7.88923C98.1489 7.61031 97.4698 7.47029 96.7845 7.47848C96.0078 7.47835 95.2393 7.63951 94.5262 7.95203C93.8085 8.26116 93.1579 8.71078 92.6116 9.27522V15.9042C92.8573 16.2455 93.1442 16.5542 93.4654 16.8232C93.779 17.088 94.1222 17.3145 94.4879 17.4981C94.8491 17.6792 95.2289 17.8194 95.6205 17.9161C96.0012 18.0127 96.392 18.0626 96.7845 18.0648V18.0626Z"
				fill="#1F2937"
			/>
			<path
				d="M105.83 12.7718C105.825 11.7688 106.023 10.7755 106.414 9.85398C107.169 8.04782 108.587 6.60986 110.367 5.84324C111.279 5.45299 112.258 5.25195 113.248 5.25195C114.238 5.25195 115.218 5.45299 116.13 5.84324C117.91 6.60974 119.327 8.04773 120.083 9.85398C120.468 10.7792 120.666 11.7733 120.666 12.7776C120.666 13.7818 120.468 14.7759 120.083 15.7012C119.328 17.5075 117.91 18.9455 116.13 19.7119C115.218 20.1022 114.238 20.3033 113.248 20.3033C112.258 20.3033 111.279 20.1022 110.367 19.7119C108.586 18.9454 107.169 17.5074 106.414 15.7012C106.023 14.7758 105.824 13.7786 105.83 12.7718ZM108.027 12.7718C108.022 13.4826 108.162 14.1867 108.439 14.84C108.702 15.4689 109.082 16.0408 109.558 16.5248C110.032 17.0056 110.594 17.3888 111.212 17.6531C111.857 17.9244 112.549 18.0639 113.247 18.0639C113.945 18.0639 114.637 17.9244 115.282 17.6531C116.395 17.1801 117.312 16.3299 117.877 15.2476C118.442 14.1652 118.619 12.9176 118.378 11.7175C118.138 10.5173 117.495 9.439 116.558 8.66623C115.622 7.89347 114.45 7.47414 113.243 7.47973C112.546 7.4746 111.854 7.61438 111.212 7.89047C110.594 8.15497 110.032 8.53811 109.558 9.01878C109.082 9.50288 108.702 10.0748 108.439 10.7036C108.162 11.3569 108.022 12.061 108.027 12.7718Z"
				fill="#1F2937"
			/>
			<path
				d="M122.658 12.7718C122.653 11.7688 122.851 10.7755 123.242 9.85398C123.997 8.04782 125.415 6.60986 127.195 5.84324C128.107 5.45299 129.087 5.25195 130.076 5.25195C131.066 5.25195 132.046 5.45299 132.958 5.84324C134.738 6.60974 136.156 8.04773 136.911 9.85398C137.296 10.7793 137.494 11.7734 137.494 12.7776C137.494 13.7818 137.296 14.7759 136.911 15.7012C136.156 17.5075 134.738 18.9455 132.958 19.7119C132.046 20.1022 131.066 20.3033 130.076 20.3033C129.087 20.3033 128.107 20.1022 127.195 19.7119C125.415 18.9454 123.997 17.5074 123.242 15.7012C122.851 14.7758 122.652 13.7786 122.658 12.7718ZM124.855 12.7718C124.85 13.4826 124.99 14.1867 125.267 14.84C125.53 15.4688 125.91 16.0407 126.385 16.5248C126.86 17.0056 127.422 17.3887 128.039 17.6531C128.682 17.9293 129.373 18.0691 130.071 18.0639C130.929 18.0637 131.773 17.8489 132.53 17.4386C133.286 17.0283 133.931 16.4352 134.408 15.7116C134.885 14.9881 135.178 14.1564 135.263 13.2903C135.347 12.4242 135.22 11.5503 134.892 10.746C134.565 9.94167 134.047 9.23171 133.384 8.67895C132.721 8.12619 131.935 7.74768 131.093 7.5769C130.252 7.40612 129.383 7.44833 128.561 7.69983C127.74 7.95132 126.993 8.40435 126.385 9.01878C125.91 9.50297 125.53 10.0748 125.267 10.7036C124.99 11.3569 124.85 12.061 124.855 12.7718Z"
				fill="#1F2937"
			/>
			<path
				d="M143.015 0.126953V20.0839H140.777V0.126953H143.015Z"
				fill="#1F2937"
			/>
			<path
				d="M19.2036 10.8364L11.6476 3.1701C10.368 1.87189 8.63255 1.14258 6.82298 1.14258C5.01341 1.14258 3.27795 1.87189 1.99836 3.1701C0.718829 4.46837 0 6.22916 0 8.06515C0 9.90113 0.718829 11.6619 1.99836 12.9602L9.5544 20.6265C10.834 21.9247 12.5694 22.654 14.379 22.654C16.1886 22.654 17.924 21.9247 19.2036 20.6265C20.4832 19.3282 21.202 17.5674 21.202 15.7315C21.202 13.8955 20.4832 12.1347 19.2036 10.8364Z"
				fill="#5CC9F6"
			/>
			<path
				d="M41.2319 8.08809C39.9523 6.78988 38.2169 6.06055 36.4073 6.06055C34.5977 6.06055 32.8623 6.78988 31.5827 8.08809C30.949 8.73094 30.4464 9.49412 30.1034 10.3341C29.7605 11.174 29.584 12.0743 29.584 12.9835C29.584 13.8927 29.7605 14.7929 30.1034 15.6329C30.4464 16.4728 30.949 17.236 31.5827 17.8789C32.8623 19.1771 34.5977 19.9064 36.4073 19.9064C38.2169 19.9064 39.9523 19.1771 41.2319 17.8789C41.8656 17.236 42.3683 16.4728 42.7112 15.6329C43.0541 14.7929 43.2307 13.8927 43.2307 12.9835C43.2307 12.0743 43.0541 11.174 42.7112 10.3341C42.3683 9.49412 41.8656 8.73094 41.2319 8.08809Z"
				fill="#FA8807"
			/>
			<path
				d="M12.3435 8.0684L9.52247 10.9306L9.51037 10.9176C8.40772 12.0077 6.97417 12.6875 5.44263 12.8464C3.91109 13.0054 2.37157 12.6342 1.07422 11.7933C1.34016 12.2148 1.65028 12.606 1.99915 12.9598L5.04434 16.0495L5.07493 16.0379L9.59077 20.6197L21.9615 8.0684C21.33 7.42752 20.5803 6.91912 19.7552 6.57227C18.93 6.22541 18.0457 6.04688 17.1525 6.04688C16.2593 6.04688 15.3749 6.22541 14.5498 6.57227C13.7247 6.91912 12.975 7.42752 12.3435 8.0684Z"
				fill="#00AEEB"
			/>
			<path
				d="M36.3776 3.23084L36.3712 3.22434C35.7479 2.57083 35.0017 2.05078 34.1769 1.69489C33.352 1.33901 32.4652 1.15452 31.5689 1.15236C30.6725 1.15021 29.7848 1.33042 28.9583 1.68234C28.1318 2.03425 27.3832 2.55075 26.7569 3.20125L14.3926 15.746C13.189 16.9662 11.5796 17.6862 9.8799 17.7648C8.18021 17.8433 6.51293 17.2747 5.20508 16.1705L9.59071 20.6201L9.59568 20.6158C10.8737 21.9124 12.607 22.6408 14.4143 22.6408C16.2216 22.6408 17.9549 21.9124 19.2328 20.6158L31.2748 8.39804L31.2947 8.40381C31.3879 8.29698 31.4833 8.19158 31.5843 8.08907C32.4253 7.23487 33.472 6.61885 34.6203 6.30225C35.7686 5.98565 36.9786 5.97949 38.13 6.28438C37.8175 5.12926 37.2135 4.07677 36.3776 3.23084Z"
				fill="#0080CA"
			/>
			<path
				d="M38.1258 6.28476C36.9743 5.97987 35.7643 5.98603 34.616 6.30263C33.4677 6.61923 32.421 7.23525 31.58 8.08945C31.479 8.19196 31.3837 8.29735 31.2905 8.40419L31.2712 8.39842L19.2293 20.6162C19.2072 20.6385 19.1844 20.6587 19.1631 20.6804L19.1709 20.6891C20.4505 21.9873 22.186 22.7166 23.9955 22.7166C25.8051 22.7166 27.5406 21.9873 28.8202 20.6891L36.3762 13.0227C37.2297 12.1573 37.8413 11.0775 38.1487 9.8937C38.4561 8.70987 38.4482 7.46447 38.1258 6.28476Z"
				fill="#EE5913"
			/>
			<path
				d="M17.804 5.44238C18.4044 5.44238 18.8911 4.94854 18.8911 4.33935C18.8911 3.73017 18.4044 3.23633 17.804 3.23633C17.2035 3.23633 16.7168 3.73017 16.7168 4.33935C16.7168 4.94854 17.2035 5.44238 17.804 5.44238Z"
				fill="#5CC9F6"
			/>
			<path
				d="M15.4033 3.29769C15.7884 3.29769 16.1006 2.98096 16.1006 2.59025C16.1006 2.19954 15.7884 1.88281 15.4033 1.88281C15.0182 1.88281 14.7061 2.19954 14.7061 2.59025C14.7061 2.98096 15.0182 3.29769 15.4033 3.29769Z"
				fill="#5CC9F6"
			/>
			<path
				d="M16.9434 1.41488C17.3284 1.41488 17.6406 1.09815 17.6406 0.707438C17.6406 0.316731 17.3284 0 16.9434 0C16.5583 0 16.2461 0.316731 16.2461 0.707438C16.2461 1.09815 16.5583 1.41488 16.9434 1.41488Z"
				fill="#5CC9F6"
			/>
		</g>
		<defs>
			<clipPath id="clip0_2377_37074">
				<rect width="143.015" height="25" fill="white" />
			</clipPath>
		</defs>
	</svg>
);

export const Unlock = (
	<svg
		width="15"
		height="17"
		viewBox="0 0 15 17"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M4.82143 6.375H12.8571C14.0391 6.375 15 7.32793 15 8.5V14.875C15 16.0471 14.0391 17 12.8571 17H2.14286C0.959263 17 0 16.0471 0 14.875V8.5C0 7.32793 0.959263 6.375 2.14286 6.375H2.67857V4.78125C2.67857 2.14061 4.83817 0 7.5 0C9.42522 0 11.0826 1.11861 11.856 2.73162C12.1105 3.26154 11.8828 3.89473 11.3203 4.14707C10.7846 4.39941 10.1752 4.17363 9.92076 3.64238C9.48884 2.74357 8.56808 2.125 7.5 2.125C6.02009 2.125 4.82143 3.31434 4.82143 4.78125V6.375Z"
			fill="url(#paint0_linear_1398_730)"
		/>
		<defs>
			<linearGradient
				id="paint0_linear_1398_730"
				x1="-9.83593e-07"
				y1="-13.5"
				x2="15"
				y2="26"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#005AE0" />
				<stop offset="1" stop-color="#E000A1" />
			</linearGradient>
		</defs>
	</svg>
);
export const Thunder = (
	<svg width="17" height="19" viewBox="0 0 17 19" fill="none" xmlns="http://www.w3.org/2000/svg">
		<path fill-rule="evenodd" clip-rule="evenodd" d="M10.9699 0.0859085C11.2544 0.237856 11.3941 0.55609 11.3084 0.857136L9.42738 7.46429H16.2917C16.5737 7.46429 16.8289 7.6246 16.9413 7.87242C17.0537 8.12024 17.0019 8.40833 16.8095 8.60586L6.89283 18.7844C6.67058 19.0125 6.31459 19.066 6.03008 18.9141C5.74558 18.7621 5.60593 18.4439 5.69163 18.1429L7.57262 11.5357H0.708348C0.426292 11.5357 0.171116 11.3754 0.0587028 11.1276C-0.05371 10.8798 -0.00193399 10.5917 0.190518 10.3941L10.1072 0.215592C10.3294 -0.0125275 10.6854 -0.0660392 10.9699 0.0859085Z" fill="url(#paint0_linear_6513_6702)"/>
		<defs>
		<linearGradient id="paint0_linear_6513_6702" x1="-1.11474e-06" y1="-15.0882" x2="16.5901" y2="29.2123" gradientUnits="userSpaceOnUse">
		<stop stop-color="#575757"/>
		<stop offset="1" stop-color="#575757"/>
		</linearGradient>
		</defs>
	</svg>
);
export const YTTutorial = (
	<svg width="20" height="16" viewBox="0 0 20 16" fill="none" xmlns="http://www.w3.org/2000/svg">
		<path fill-rule="evenodd" clip-rule="evenodd" d="M10 0C10.855 0 11.732 0.0220001 12.582 0.0580001L13.586 0.106L14.547 0.163L15.447 0.224L16.269 0.288C17.1612 0.355891 18.0008 0.736434 18.64 1.3626C19.2791 1.98877 19.6768 2.8204 19.763 3.711L19.803 4.136L19.878 5.046C19.948 5.989 20 7.017 20 8C20 8.983 19.948 10.011 19.878 10.954L19.803 11.864L19.763 12.289C19.6768 13.1798 19.2789 14.0115 18.6396 14.6377C18.0002 15.2639 17.1604 15.6443 16.268 15.712L15.448 15.775L14.548 15.837L13.586 15.894L12.582 15.942C11.7218 15.9793 10.861 15.9986 10 16C9.13902 15.9986 8.27817 15.9793 7.418 15.942L6.414 15.894L5.453 15.837L4.553 15.775L3.731 15.712C2.83881 15.6441 1.9992 15.2636 1.36004 14.6374C0.720888 14.0112 0.323191 13.1796 0.237 12.289L0.197 11.864L0.122 10.954C0.0458327 9.97112 0.00513964 8.98581 0 8C0 7.017 0.052 5.989 0.122 5.046L0.197 4.136L0.237 3.711C0.323157 2.82055 0.720712 1.98905 1.35966 1.36291C1.99861 0.736759 2.83799 0.356116 3.73 0.288L4.551 0.224L5.451 0.163L6.413 0.106L7.417 0.0580001C8.2775 0.0207272 9.13869 0.00138958 10 0ZM8 5.575V10.425C8 10.887 8.5 11.175 8.9 10.945L13.1 8.52C13.1914 8.46739 13.2673 8.39162 13.3201 8.30033C13.3729 8.20904 13.4007 8.10545 13.4007 8C13.4007 7.89455 13.3729 7.79096 13.3201 7.69967C13.2673 7.60838 13.1914 7.53261 13.1 7.48L8.9 5.056C8.80876 5.00332 8.70526 4.9756 8.5999 4.97562C8.49455 4.97563 8.39106 5.00339 8.29983 5.0561C8.20861 5.1088 8.13287 5.1846 8.08024 5.27587C8.02761 5.36713 7.99993 5.47065 8 5.576V5.575Z" fill="url(#paint0_linear_6513_6705)"/>
		<defs>
		<linearGradient id="paint0_linear_6513_6705" x1="10" y1="-2.85714" x2="20.0076" y2="18.4873" gradientUnits="userSpaceOnUse">
		<stop stop-color="#575757"/>
		<stop offset="1" stop-color="#575757"/>
		</linearGradient>
		</defs>
	</svg>

);
export const HelpIcon = (
	<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
		<path d="M7.96 12.8C8.24 12.8 8.4768 12.7032 8.67039 12.5096C8.864 12.316 8.96053 12.0795 8.95999 11.8C8.95946 11.5205 8.86293 11.2837 8.67039 11.0896C8.47786 10.8955 8.24106 10.7989 7.96 10.8C7.67893 10.8011 7.4424 10.8979 7.2504 11.0904C7.0584 11.2829 6.9616 11.5195 6.96 11.8C6.9584 12.0805 7.0552 12.3173 7.2504 12.5104C7.4456 12.7035 7.68213 12.8 7.96 12.8ZM8 16C6.89333 16 5.85333 15.7899 4.88 15.3696C3.90667 14.9493 3.06 14.3795 2.34 13.66C1.62 12.9405 1.05013 12.0939 0.630401 11.12C0.210668 10.1461 0.000534346 9.10613 1.01266e-06 8C-0.00053232 6.89386 0.209601 5.85387 0.630401 4.88C1.0512 3.90613 1.62107 3.05947 2.34 2.34C3.05893 1.62053 3.9056 1.05067 4.88 0.6304C5.8544 0.210133 6.8944 0 8 0C9.10559 0 10.1456 0.210133 11.12 0.6304C12.0944 1.05067 12.9411 1.62053 13.66 2.34C14.3789 3.05947 14.9491 3.90613 15.3704 4.88C15.7917 5.85387 16.0016 6.89386 16 8C15.9984 9.10613 15.7883 10.1461 15.3696 11.12C14.9509 12.0939 14.3811 12.9405 13.66 13.66C12.9389 14.3795 12.0923 14.9496 11.12 15.3704C10.1477 15.7912 9.10773 16.0011 8 16ZM8.08 4.56C8.41333 4.56 8.70346 4.66667 8.95039 4.88C9.19733 5.09333 9.32053 5.36 9.31999 5.68C9.31999 5.97333 9.23013 6.23333 9.0504 6.46C8.87066 6.68666 8.6672 6.9 8.44 7.1C8.13333 7.36666 7.86346 7.66 7.6304 7.98C7.39733 8.3 7.28053 8.66 7.28 9.06C7.28 9.24666 7.35013 9.40346 7.4904 9.5304C7.63066 9.65733 7.79386 9.72053 7.98 9.72C8.18 9.72 8.35013 9.65333 8.4904 9.52C8.63066 9.38666 8.72053 9.22 8.75999 9.02C8.81333 8.74 8.93333 8.49013 9.11999 8.2704C9.30666 8.05066 9.50666 7.84053 9.71999 7.64C10.0267 7.34666 10.2901 7.02667 10.5104 6.68C10.7307 6.33333 10.8405 5.94666 10.84 5.52C10.84 4.84 10.5635 4.28347 10.0104 3.8504C9.45733 3.41733 8.81386 3.20053 8.08 3.2C7.57333 3.2 7.09013 3.30667 6.6304 3.52C6.17066 3.73333 5.82053 4.06 5.58 4.5C5.48666 4.66 5.4568 4.83013 5.4904 5.0104C5.524 5.19066 5.61386 5.3272 5.76 5.42C5.94666 5.52666 6.14 5.56 6.34 5.52C6.54 5.48 6.70666 5.36667 6.84 5.18C6.98666 4.98 7.17013 4.82667 7.3904 4.72C7.61066 4.61333 7.84053 4.56 8.08 4.56Z" fill="#575757"/>
	</svg>
);
export const PlayerRound = (
	<svg width="83" height="83" viewBox="0 0 83 83" fill="none" xmlns="http://www.w3.org/2000/svg">
		<path fill-rule="evenodd" clip-rule="evenodd" d="M41.2639 82.5277C52.2077 82.5277 62.7033 78.1803 70.4418 70.4418C78.1803 62.7033 82.5277 52.2077 82.5277 41.2638C82.5277 30.32 78.1803 19.8244 70.4418 12.0859C62.7033 4.34743 52.2077 0 41.2639 0C30.32 0 19.8244 4.34743 12.0859 12.0859C4.34743 19.8244 0 30.32 0 41.2638C0 52.2077 4.34743 62.7033 12.0859 70.4418C19.8244 78.1803 30.32 82.5277 41.2639 82.5277ZM38.9686 26.6564C38.1918 26.1382 37.2888 25.8405 36.3561 25.7952C35.4234 25.7499 34.4959 25.9586 33.6725 26.3992C32.8491 26.8397 32.1608 27.4955 31.681 28.2966C31.2011 29.0977 30.9477 30.0141 30.9479 30.9479V51.5798C30.9477 52.5136 31.2011 53.43 31.681 54.231C32.1608 55.0321 32.8491 55.6879 33.6725 56.1285C34.4959 56.569 35.4234 56.7778 36.3561 56.7325C37.2888 56.6872 38.1918 56.3895 38.9686 55.8712L54.4425 45.5553C55.1489 45.0842 55.7281 44.4461 56.1287 43.6975C56.5294 42.9488 56.739 42.1129 56.739 41.2638C56.739 40.4148 56.5294 39.5788 56.1287 38.8302C55.7281 38.0816 55.1489 37.4434 54.4425 36.9724L38.9686 26.6564Z" fill="white"/>
		</svg>

);

export const RedHeart = (
	<svg
		width="18"
		height="16"
		viewBox="0 0 18 16"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M17.5645 3.27888C17.2852 2.63724 16.8825 2.0558 16.379 1.56709C15.875 1.07693 15.2808 0.6874 14.6288 0.419693C13.9526 0.140996 13.2274 -0.0016576 12.4952 1.45314e-05C11.468 1.45314e-05 10.4658 0.279111 9.59485 0.806293C9.38649 0.932404 9.18855 1.07092 9.00103 1.22184C8.81351 1.07092 8.61557 0.932404 8.40721 0.806293C7.53628 0.279111 6.53408 1.45314e-05 5.50688 1.45314e-05C4.76721 1.45314e-05 4.05046 0.140597 3.3733 0.419693C2.71906 0.688453 2.12941 1.07505 1.6231 1.56709C1.11887 2.05524 0.716078 2.63683 0.43755 3.27888C0.147934 3.94665 0 4.65576 0 5.38554C0 6.07398 0.141683 6.79136 0.422965 7.52115C0.658409 8.13103 0.995947 8.76365 1.42725 9.40247C2.11066 10.4134 3.05035 11.4678 4.21715 12.5366C6.1507 14.3084 8.06551 15.5323 8.14677 15.5819L8.64057 15.8961C8.85935 16.0346 9.14063 16.0346 9.35941 15.8961L9.85321 15.5819C9.93447 15.5302 11.8472 14.3084 13.7828 12.5366C14.9496 11.4678 15.8893 10.4134 16.5727 9.40247C17.004 8.76365 17.3437 8.13103 17.577 7.52115C17.8583 6.79136 18 6.07398 18 5.38554C18.0021 4.65576 17.8541 3.94665 17.5645 3.27888Z"
			fill="url(#paint0_linear_1465_710)"
		/>
		<defs>
			<linearGradient
				id="paint0_linear_1465_710"
				x1="9"
				y1="0"
				x2="9"
				y2="16"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#575757" />
				<stop offset="1" stop-color="#575757" />
			</linearGradient>
		</defs>
	</svg>
);

export const DesktopComputers = (
	<svg
		width="336"
		height="235"
		viewBox="0 0 336 235"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			opacity="0.6"
			d="M300.668 206.428C285.276 229.523 251.658 197.268 227.053 209.429C220.007 212.907 214.358 202.071 207.164 205.174C202.162 207.332 197.136 209.409 192.081 211.429L29.4462 213.55C27.5986 211.511 23.667 207.301 21.9383 205.174C5.89889 185.432 -4.42575 162.036 1.87121 135.044C8.3048 107.476 31.5026 84.9686 58.5617 78.9821C76.8823 74.9285 96.5098 78.0313 113.945 70.85C134.333 62.4551 147.177 42.0685 163.584 27.0428C180.604 11.4604 202.596 1.25772 225.217 0.106714C247.839 -1.05055 270.87 7.23171 286.428 23.6336C297.359 35.1499 304.363 50.2256 307.63 66.002C313.137 92.6065 315.876 183.602 300.668 206.428Z"
			fill="url(#paint0_linear_1403_2569)"
		/>
		<path
			d="M147.1 30.0213C143.737 30.0096 141.008 32.7373 141.018 36.0997L141.224 106.37C141.233 109.715 143.951 112.419 147.296 112.413L319.193 112.092C322.536 112.086 325.242 109.374 325.242 106.031V36.6841C325.242 33.3451 322.542 30.6352 319.203 30.6235L147.1 30.0213Z"
			fill="url(#paint1_linear_1403_2569)"
		/>
		<path
			opacity="0.8"
			d="M152.873 36.6445V47.2754L175.27 46.825V36.6445H152.873Z"
			fill="#BAC6F2"
		/>
		<path
			opacity="0.3"
			d="M152.873 52.5908V61.8929L175.27 61.4987V52.5908H152.873Z"
			fill="#BAC6F2"
		/>
		<path
			opacity="0.8"
			d="M152.873 67.2081V76.5102L175.27 76.1161V67.2081H152.873Z"
			fill="#BAC6F2"
		/>
		<path
			opacity="0.3"
			d="M152.873 81.8259V91.128L175.27 90.7338V81.8259H152.873Z"
			fill="#BAC6F2"
		/>
		<path
			opacity="0.8"
			d="M152.873 96.4435V105.746L175.27 105.351V96.4435H152.873Z"
			fill="#BAC6F2"
		/>
		<path
			opacity="0.8"
			d="M180.602 36.6445V47.2754L223.263 46.825V36.6445H180.602Z"
			fill="#BAC6F2"
		/>
		<path
			opacity="0.3"
			d="M180.602 52.5908V61.8929L223.262 61.4987V52.5908H180.602Z"
			fill="#BAC6F2"
		/>
		<path
			opacity="0.8"
			d="M180.602 67.2081V76.5102L223.262 76.1161V67.2081H180.602Z"
			fill="#BAC6F2"
		/>
		<path
			opacity="0.3"
			d="M180.602 81.8259V91.128L223.262 90.7338V81.8259H180.602Z"
			fill="#BAC6F2"
		/>
		<path
			opacity="0.8"
			d="M180.602 96.4435V105.746L223.262 105.351V96.4435H180.602Z"
			fill="#BAC6F2"
		/>
		<path
			opacity="0.8"
			d="M227.528 36.6445V47.2754L262.723 46.825V36.6445H227.528Z"
			fill="#BAC6F2"
		/>
		<path
			opacity="0.3"
			d="M227.528 52.5908V61.8929L262.723 61.4987V52.5908H227.528Z"
			fill="#BAC6F2"
		/>
		<path
			opacity="0.8"
			d="M227.528 67.2081V76.5102L262.723 76.1161V67.2081H227.528Z"
			fill="#BAC6F2"
		/>
		<path
			opacity="0.3"
			d="M227.528 81.8259V91.128L262.723 90.7338V81.8259H227.528Z"
			fill="#BAC6F2"
		/>
		<path
			opacity="0.8"
			d="M227.528 96.4435V105.746L262.723 105.351V96.4435H227.528Z"
			fill="#BAC6F2"
		/>
		<path
			d="M284.053 60.5641C286.409 60.5641 288.319 58.1843 288.319 55.2486C288.319 52.313 286.409 49.9332 284.053 49.9332C281.697 49.9332 279.787 52.313 279.787 55.2486C279.787 58.1843 281.697 60.5641 284.053 60.5641Z"
			fill="#BAC6F2"
		/>
		<path
			d="M295.785 60.5641C298.141 60.5641 300.051 58.1843 300.051 55.2486C300.051 52.313 298.141 49.9332 295.785 49.9332C293.429 49.9332 291.519 52.313 291.519 55.2486C291.519 58.1843 293.429 60.5641 295.785 60.5641Z"
			fill="#BAC6F2"
		/>
		<path
			d="M307.516 60.5641C309.872 60.5641 311.782 58.1843 311.782 55.2486C311.782 52.313 309.872 49.9332 307.516 49.9332C305.16 49.9332 303.25 52.313 303.25 55.2486C303.25 58.1843 305.16 60.5641 307.516 60.5641Z"
			fill="#BAC6F2"
		/>
		<path
			d="M321.381 67.2082H270.189V105.745H321.381V67.2082Z"
			fill="#E9EDFA"
		/>
		<path
			d="M272.321 96.7148C272.321 96.7148 275.805 87.2176 279.116 88.249C282.427 89.2803 283.254 93.6207 285.738 91.7728C288.221 89.9249 289.842 82.4475 292.256 81.2442C295.705 79.5682 296.843 81.4161 301.499 84.7251C306.155 88.0341 308.121 87.3035 310.018 84.854C311.777 82.6194 315.019 76.56 318.606 73.8527"
			stroke="#BAC6F2"
			stroke-width="1.17596"
			stroke-linecap="round"
			stroke-linejoin="round"
		/>
		<path
			d="M163.5 223C237.23 223 297 218.747 297 213.5C297 208.253 237.23 204 163.5 204C89.77 204 30 208.253 30 213.5C30 218.747 89.77 223 163.5 223Z"
			fill="url(#paint2_linear_1403_2569)"
		/>
		<path
			d="M64.0675 186.604H218.078C218.078 186.604 223.842 186.324 223.842 180.161V167.928H58.0002V182.775C58.8091 185.11 61.2361 186.697 64.0675 186.604Z"
			fill="url(#paint3_linear_1403_2569)"
		/>
		<path
			d="M58.1011 75.404L58 172.517L223.943 171.116V72.6027C223.943 72.6027 224.954 67 218.482 67H64.3708C64.3708 67 57.3933 67 58.1011 75.404Z"
			fill="url(#paint4_linear_1403_2569)"
		/>
		<path
			d="M127.877 212.575V185.589L152.146 186.523V210.241L127.877 212.575Z"
			fill="url(#paint5_linear_1403_2569)"
		/>
		<path
			d="M89.3484 209.868H190.168L190.269 214.537H89.3484V209.868Z"
			fill="url(#paint6_linear_1403_2569)"
		/>
		<path
			d="M139.505 174.478C142.235 174.478 144.359 176.438 144.359 178.96C144.359 181.481 142.235 183.442 139.505 183.442C136.774 183.442 134.651 181.481 134.651 178.96C134.651 176.438 136.876 174.478 139.505 174.478Z"
			fill="white"
		/>
		<path
			d="M218.886 71.6683H63.157V165.98H218.886V71.6683Z"
			fill="#F8F8FF"
		/>
		<path
			d="M70.9441 76.5247C72.2587 76.5247 73.371 77.5518 73.371 78.7657C73.371 79.9797 72.2587 81.0068 70.9441 81.0068C69.6295 81.0068 68.5171 79.9797 68.5171 78.7657C68.5171 77.5518 69.6295 76.5247 70.9441 76.5247Z"
			fill="#FA5F5D"
		/>
		<path
			d="M79.2363 76.5247C80.5509 76.5247 81.6632 77.5518 81.6632 78.7657C81.6632 79.9797 80.5509 81.0068 79.2363 81.0068C77.9217 81.0068 76.8093 79.9797 76.8093 78.7657C76.8093 77.5518 77.9217 76.5247 79.2363 76.5247Z"
			fill="#FDBC4E"
		/>
		<path
			d="M87.9325 76.5247C89.2471 76.5247 90.3594 77.5518 90.3594 78.7657C90.3594 79.9797 89.2471 81.0068 87.9325 81.0068C86.6179 81.0068 85.5056 79.9797 85.5056 78.7657C85.5056 77.5518 86.6179 76.5247 87.9325 76.5247Z"
			fill="#37CD58"
		/>
		<path
			d="M121.808 92.9585C121.707 94.1724 120.595 95.1062 119.28 95.0129H89.4491C87.9323 95.0129 86.4154 94.0791 86.4154 92.9585V88.7565C86.4154 87.636 87.8312 86.6089 89.4491 86.6089H119.179C120.494 86.5155 121.707 87.4492 121.808 88.6632V88.7565V92.9585Z"
			fill="url(#paint7_linear_1403_2569)"
		/>
		<path
			d="M156.473 120.778C156.406 122.093 155.602 123.127 154.664 123.033H87.4899C86.4853 123.033 85.4807 121.999 85.4807 120.778V99.9232C85.4807 98.7019 86.4853 97.6686 87.4899 97.6686H154.664C155.602 97.5747 156.406 98.608 156.473 99.9232V120.778Z"
			fill="#DFE4F7"
		/>
		<path
			d="M119.786 138.527C119.786 139.741 118.674 140.768 117.359 140.768H89.4491C87.8312 140.768 86.4154 139.741 86.4154 138.527V127.135C86.4154 125.921 87.9323 124.894 89.4491 124.894H117.157C118.471 124.801 119.685 125.734 119.786 127.042V127.135V138.527Z"
			fill="#DFE4F7"
		/>
		<path
			d="M156.191 138.527C156.191 139.741 155.078 140.768 153.764 140.768H125.854C124.236 140.768 122.82 139.741 122.82 138.527V127.135C122.82 125.921 124.337 124.894 125.854 124.894H153.562C154.876 124.801 156.09 125.734 156.191 127.042V127.135V138.527Z"
			fill="#DFE4F7"
		/>
		<path
			d="M193.606 138.527C193.505 139.834 192.291 140.862 190.875 140.768H163.168C161.794 140.853 160.67 140.019 160.319 138.89C160.246 138.653 160.235 138.402 160.235 138.154V127.135C160.336 125.734 161.651 124.801 163.168 124.894H190.875C192.291 124.801 193.606 125.828 193.707 127.135L193.606 138.527Z"
			fill="#DFE4F7"
		/>
		<path
			d="M156.191 144.97C155.989 145.437 155.584 145.717 155.078 145.811C154.977 145.811 154.977 145.811 154.876 145.437H124.337C123.73 145.811 122.82 145.437 122.82 144.97V144.597C122.82 144.13 123.73 143.663 124.337 143.57H154.876C155.382 143.663 155.685 144.037 155.786 144.41C155.786 144.503 155.786 144.503 156.09 144.597L156.191 144.97Z"
			fill="#E9EDFB"
		/>
		<path
			d="M156.191 148.612C155.989 149.079 155.584 149.453 155.078 149.546C155.078 149.546 154.977 149.546 154.977 149.172H124.337C123.73 149.546 122.82 149.172 122.82 148.612V148.239C122.82 147.772 123.73 147.398 124.337 147.305H154.876C155.382 147.398 155.887 147.772 156.09 148.239L156.191 148.612Z"
			fill="#E9EDFB"
		/>
		<path
			d="M156.191 152.347C155.989 152.907 155.483 153.281 154.977 153.374C154.977 153.187 154.977 153.094 154.977 152.907H124.337C123.831 153.187 123.225 153.094 122.921 152.627C122.82 152.534 122.82 152.44 122.82 152.347V151.974C122.82 151.507 123.73 151.226 124.337 151.04H154.876C155.382 151.133 155.887 151.507 156.09 151.974L156.191 152.347Z"
			fill="#E9EDFB"
		/>
		<path
			d="M156.191 155.988C155.887 156.549 155.483 157.109 154.977 157.576H124.337C123.73 157.109 122.82 156.549 122.82 155.988V155.615C122.82 155.148 123.73 154.588 124.337 154.775H154.876C155.281 154.681 155.685 154.961 155.786 155.335C155.786 155.428 155.786 155.522 155.786 155.615C155.786 155.615 155.786 155.615 156.09 155.708L156.191 155.988Z"
			fill="#E9EDFB"
		/>
		<path
			d="M139.202 159.724C139.202 160.191 138.899 160.378 138.292 160.378H124.236C123.629 160.378 122.82 160.191 122.82 159.724V159.35C122.82 158.884 123.629 158.51 124.236 158.51H138.292C138.798 158.51 139.202 158.884 139.202 159.35V159.724Z"
			fill="#E9EDFB"
		/>
		<path
			d="M193.606 144.97C193 145.437 193.101 145.811 192.494 145.437H161.955C161.449 145.811 160.944 145.531 160.944 145.064C160.944 145.064 160.944 145.064 161.247 144.97V144.597C160.944 144.13 161.348 143.663 161.955 143.57H192.494C193.101 143.756 193 144.13 193.606 144.597V144.97Z"
			fill="#E9EDFB"
		/>
		<path
			d="M193.607 148.612C193 149.079 193.101 149.546 192.494 149.172H161.955C161.348 149.546 160.944 149.172 161.247 148.612V148.239C160.944 147.772 161.348 147.398 161.955 147.305H192.494C193.101 147.492 193 147.772 193.607 148.239V148.612Z"
			fill="#E9EDFB"
		/>
		<path
			d="M193.607 152.347C193 152.814 193.101 153.374 192.494 152.907H161.955C161.348 153.281 160.944 152.907 161.247 152.347V151.974C160.944 151.507 161.348 151.226 161.955 151.04H192.494C193.101 151.226 193 151.507 193.607 151.974V152.347Z"
			fill="#E9EDFB"
		/>
		<path
			d="M193.606 155.989C192.999 156.456 193.1 157.11 192.494 157.576H161.954C161.348 157.016 160.943 156.549 161.247 155.989V155.616C161.044 155.429 161.044 155.055 161.247 154.869C161.449 154.775 161.651 154.682 161.853 154.775H192.494C193.1 154.588 192.999 155.149 193.606 155.616V155.989Z"
			fill="#E9EDFB"
		/>
		<path
			d="M176.82 159.724C176.82 160.191 176.82 160.378 176.315 160.378H162.157C161.551 160.378 161.247 160.191 161.247 159.724V159.35C161.247 158.884 161.652 158.51 162.157 158.51H176.213C176.82 158.51 176.719 158.884 176.719 159.35L176.82 159.724Z"
			fill="#E9EDFB"
		/>
		<path
			d="M118.775 144.97C119.179 145.437 118.977 145.811 118.37 145.437H87.73C87.3255 145.717 86.8199 145.624 86.6177 145.344C86.5166 145.25 86.5166 145.157 86.4154 144.97V144.597C86.6177 144.037 87.1233 143.663 87.73 143.57H118.269C118.876 143.756 119.078 144.13 118.674 144.597L118.775 144.97Z"
			fill="#E9EDFB"
		/>
		<path
			d="M118.775 148.612C119.179 149.079 118.977 149.546 118.37 149.172H87.73C87.1233 149.639 86.6177 149.172 86.4154 148.612V148.239C86.5166 147.772 87.1233 147.398 87.73 147.305H118.269C118.876 147.492 119.078 147.772 118.674 148.239L118.775 148.612Z"
			fill="#E9EDFB"
		/>
		<path
			d="M118.775 152.347C119.179 152.814 118.977 153.374 118.37 152.907H87.73C87.1233 153.374 86.6177 152.907 86.4154 152.347V151.974C86.5166 151.507 87.1233 151.226 87.73 151.04H118.269C118.876 151.226 119.078 151.507 118.674 151.974L118.775 152.347Z"
			fill="#E9EDFB"
		/>
		<path
			d="M109.674 154.775H118.37C118.977 154.588 119.179 155.148 118.775 155.615V155.988C119.179 156.455 118.977 157.109 118.37 157.576H87.73C87.1233 157.202 86.7188 156.642 86.4154 155.988V155.615C86.5166 155.055 87.1233 154.681 87.73 154.775H109.674Z"
			fill="#E9EDFB"
		/>
		<path
			d="M103.606 159.724C103.606 160.191 103.303 160.378 102.696 160.378H87.5278C86.9211 160.378 86.4154 160.191 86.4154 159.724V159.35C86.5166 158.884 87.0222 158.51 87.5278 158.51H102.696C103.202 158.51 103.606 158.884 103.606 159.257C103.606 159.257 103.606 159.257 103.606 159.35V159.724Z"
			fill="#E9EDFB"
		/>
		<path
			d="M186.727 118.812H164.558C163.145 118.812 162 117.667 162 116.254V85.5582C162 84.1454 163.145 83.0002 164.558 83.0002H180.759L189.285 91.5269V116.254C189.285 117.667 188.14 118.812 186.727 118.812Z"
			fill="#43A047"
		/>
		<path d="M189.285 91.5266H180.759V83L189.285 91.5266Z" fill="#C8E6C9" />
		<path
			d="M180.759 91.528L189.285 100.055V91.528H180.759Z"
			fill="#2E7D32"
		/>
		<path
			d="M181.611 100.052H169.674H167.968V101.757V103.463V105.168V106.873V108.579V110.284V111.989H183.316V110.284V108.579V106.873V105.168V103.463V101.757V100.052H181.611ZM169.674 101.757H173.084V103.463H169.674V101.757ZM169.674 105.168H173.084V106.873H169.674V105.168ZM169.674 108.579H173.084V110.284H169.674V108.579ZM181.611 110.284H174.79V108.579H181.611V110.284ZM181.611 106.873H174.79V105.168H181.611V106.873ZM181.611 103.463H174.79V101.757H181.611V103.463Z"
			fill="#E8F5E9"
		/>
		<path
			d="M278.576 196.671C278.576 196.671 281.468 180.962 266.219 172.549C251.003 164.136 250.28 164.235 247.257 163.282C245.515 162.69 243.74 163.939 245.745 166.437C247.75 168.967 246.599 169.592 250.609 170.709C254.618 171.826 255.21 176.69 257.214 177.906C259.219 179.122 260.961 179.451 267.073 182.08C272.627 184.479 277.36 191.249 277.36 193.615C277.36 195.981 282.782 196.803 282.782 196.803L278.576 196.671Z"
			fill="url(#paint8_linear_1403_2569)"
		/>
		<g filter="url(#filter0_d_1403_2569)">
			<path
				d="M278.381 194.469C278.214 194.469 278.089 194.316 278.124 194.153C278.596 191.995 280.763 179.326 268.585 172.188C255.242 164.366 250.609 164.465 247.947 163.512C246.435 162.953 250.576 164.859 252.318 167.16C254.059 169.493 253.632 168.967 256.754 170.676C260.369 172.681 261.881 174.62 264.017 175.014C267.106 175.606 266.186 178.826 271.543 181.225C276.374 183.427 276.998 189.31 276.998 191.511C276.998 192.368 277.693 193.002 278.551 193.459C278.828 193.607 278.696 194.469 278.381 194.469Z"
				fill="url(#paint9_linear_1403_2569)"
			/>
		</g>
		<g filter="url(#filter1_d_1403_2569)">
			<path
				d="M291.458 192.333L292.97 190.887C293.693 190.23 294.58 189.737 295.533 189.474C300.232 188.225 315.054 183.591 321.199 172.385C321.258 172.297 321.212 172.182 321.131 172.135C321.112 172.125 321.09 172.122 321.068 172.122C321.019 172.122 320.981 172.087 320.933 172.084C318.735 171.923 308.263 171.891 294.317 183.788C294.054 183.986 293.824 184.249 293.627 184.479C293.265 184.972 292.674 185.826 292.411 186.253C292.049 186.911 292.772 187.995 291.787 188.948C291.185 189.529 290.156 190.649 289.444 191.433C289.024 191.897 289.1 192.621 289.604 192.992C290.056 193.324 290.687 193.249 291.048 192.82L291.458 192.333Z"
				fill="url(#paint10_linear_1403_2569)"
			/>
		</g>
		<path
			d="M283.439 191.413C283.439 191.413 287.482 155.23 276.439 143.86C266.285 133.409 266.12 143.005 266.153 144.648C266.153 144.813 266.219 144.911 266.252 145.043C268.651 149.512 269.472 154.672 268.618 159.667C267.566 164.892 275.059 164.202 275.716 169.362C276.374 174.521 278.97 182.474 278.707 186.122C278.444 189.77 278.411 193.319 278.411 193.319L282.486 193.45L283.439 191.413Z"
			fill="url(#paint11_linear_1403_2569)"
		/>
		<g filter="url(#filter2_d_1403_2569)">
			<path
				d="M283.406 191.512C283.439 191.446 283.472 191.347 283.472 191.249C283.735 188.882 287.12 154.803 276.472 143.827C266.383 133.409 266.219 142.841 266.285 144.55C266.318 144.747 266.416 144.944 266.515 145.108C267.271 146.193 270.59 150.925 273.547 150.399C281.73 148.953 274.501 158.78 278.937 164.038C282.486 168.179 281.303 182.507 281.04 186.188C280.876 188.258 280.515 190.296 279.989 192.3C279.894 192.803 280.221 193.276 280.681 193.402C280.723 193.414 280.81 193.418 280.81 193.418C280.876 193.418 280.942 193.451 281.007 193.451H281.763C282.223 193.483 282.618 193.253 282.815 192.859L283.406 191.512Z"
				fill="url(#paint12_linear_1403_2569)"
			/>
		</g>
		<g filter="url(#filter3_d_1403_2569)">
			<path
				d="M285.476 192.979C286.443 193.301 287.475 192.63 287.64 191.624C288.17 188.389 289.717 181.908 293.956 177.479C295.599 175.803 297.669 174.653 299.937 174.127C301.645 173.74 304.429 172.373 306.892 167.886C306.988 167.71 307.09 167.541 307.209 167.38C308.098 166.171 312.27 160.722 316.467 158.944C320.094 157.371 318.123 156.875 317.034 156.731C316.658 156.681 316.283 156.711 315.913 156.793C313.292 157.371 301.952 160.189 294.35 167.127C293.791 167.62 293.233 168.08 292.608 168.474C290.423 169.984 284.438 175.515 284.417 191.515C284.416 192.178 284.846 192.769 285.476 192.979Z"
				fill="url(#paint13_linear_1403_2569)"
			/>
		</g>
		<g filter="url(#filter4_d_1403_2569)">
			<path
				d="M298.93 193.529C299.041 193.058 299.193 192.53 298.924 192.127C298.748 191.863 298.389 191.628 297.669 191.643C296.269 191.708 272.894 191.515 272.469 191.512C272.456 191.511 272.457 191.511 272.444 191.512C272.296 191.517 271.351 191.578 271.411 192.366C271.477 193.22 275.092 213.037 275.421 213.431C275.585 213.694 275.815 213.891 276.111 213.957C276.53 214.077 290.406 214.006 292.888 213.992C293.142 213.991 293.407 213.993 293.62 213.853C293.706 213.797 293.781 213.725 293.84 213.643C294.01 213.405 294.022 213.101 294.094 212.817C294.742 210.267 298.163 196.78 298.93 193.529Z"
				fill="url(#paint14_linear_1403_2569)"
			/>
		</g>
		<defs>
			<filter
				id="filter0_d_1403_2569"
				x="233.237"
				y="155.023"
				width="59.8491"
				height="59.8238"
				filterUnits="userSpaceOnUse"
				color-interpolation-filters="sRGB"
			>
				<feFlood flood-opacity="0" result="BackgroundImageFix" />
				<feColorMatrix
					in="SourceAlpha"
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
					result="hardAlpha"
				/>
				<feOffset dy="5.99338" />
				<feGaussianBlur stdDeviation="7.19205" />
				<feComposite in2="hardAlpha" operator="out" />
				<feColorMatrix
					type="matrix"
					values="0 0 0 0 0.191667 0 0 0 0 0.575 0 0 0 0 0.35307 0 0 0 0.2 0"
				/>
				<feBlend
					mode="normal"
					in2="BackgroundImageFix"
					result="effect1_dropShadow_1403_2569"
				/>
				<feBlend
					mode="normal"
					in="SourceGraphic"
					in2="effect1_dropShadow_1403_2569"
					result="shape"
				/>
			</filter>
			<filter
				id="filter1_d_1403_2569"
				x="274.788"
				y="163.66"
				width="60.822"
				height="49.9158"
				filterUnits="userSpaceOnUse"
				color-interpolation-filters="sRGB"
			>
				<feFlood flood-opacity="0" result="BackgroundImageFix" />
				<feColorMatrix
					in="SourceAlpha"
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
					result="hardAlpha"
				/>
				<feOffset dy="5.99338" />
				<feGaussianBlur stdDeviation="7.19205" />
				<feComposite in2="hardAlpha" operator="out" />
				<feColorMatrix
					type="matrix"
					values="0 0 0 0 0.191667 0 0 0 0 0.575 0 0 0 0 0.35307 0 0 0 0.2 0"
				/>
				<feBlend
					mode="normal"
					in2="BackgroundImageFix"
					result="effect1_dropShadow_1403_2569"
				/>
				<feBlend
					mode="normal"
					in="SourceGraphic"
					in2="effect1_dropShadow_1403_2569"
					result="shape"
				/>
			</filter>
			<filter
				id="filter2_d_1403_2569"
				x="251.893"
				y="130.609"
				width="46.6792"
				height="83.2218"
				filterUnits="userSpaceOnUse"
				color-interpolation-filters="sRGB"
			>
				<feFlood flood-opacity="0" result="BackgroundImageFix" />
				<feColorMatrix
					in="SourceAlpha"
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
					result="hardAlpha"
				/>
				<feOffset dy="5.99338" />
				<feGaussianBlur stdDeviation="7.19205" />
				<feComposite in2="hardAlpha" operator="out" />
				<feColorMatrix
					type="matrix"
					values="0 0 0 0 0.191667 0 0 0 0 0.575 0 0 0 0 0.35307 0 0 0 0.2 0"
				/>
				<feBlend
					mode="normal"
					in2="BackgroundImageFix"
					result="effect1_dropShadow_1403_2569"
				/>
				<feBlend
					mode="normal"
					in="SourceGraphic"
					in2="effect1_dropShadow_1403_2569"
					result="shape"
				/>
			</filter>
			<filter
				id="filter3_d_1403_2569"
				x="270.033"
				y="148.316"
				width="62.9067"
				height="65.122"
				filterUnits="userSpaceOnUse"
				color-interpolation-filters="sRGB"
			>
				<feFlood flood-opacity="0" result="BackgroundImageFix" />
				<feColorMatrix
					in="SourceAlpha"
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
					result="hardAlpha"
				/>
				<feOffset dy="5.99338" />
				<feGaussianBlur stdDeviation="7.19205" />
				<feComposite in2="hardAlpha" operator="out" />
				<feColorMatrix
					type="matrix"
					values="0 0 0 0 0.191667 0 0 0 0 0.575 0 0 0 0 0.35307 0 0 0 0.2 0"
				/>
				<feBlend
					mode="normal"
					in2="BackgroundImageFix"
					result="effect1_dropShadow_1403_2569"
				/>
				<feBlend
					mode="normal"
					in="SourceGraphic"
					in2="effect1_dropShadow_1403_2569"
					result="shape"
				/>
			</filter>
			<filter
				id="filter4_d_1403_2569"
				x="257.024"
				y="183.121"
				width="56.4343"
				height="51.2822"
				filterUnits="userSpaceOnUse"
				color-interpolation-filters="sRGB"
			>
				<feFlood flood-opacity="0" result="BackgroundImageFix" />
				<feColorMatrix
					in="SourceAlpha"
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
					result="hardAlpha"
				/>
				<feOffset dy="5.99338" />
				<feGaussianBlur stdDeviation="7.19205" />
				<feComposite in2="hardAlpha" operator="out" />
				<feColorMatrix
					type="matrix"
					values="0 0 0 0 0.191667 0 0 0 0 0.575 0 0 0 0 0.35307 0 0 0 0.2 0"
				/>
				<feBlend
					mode="normal"
					in2="BackgroundImageFix"
					result="effect1_dropShadow_1403_2569"
				/>
				<feBlend
					mode="normal"
					in="SourceGraphic"
					in2="effect1_dropShadow_1403_2569"
					result="shape"
				/>
			</filter>
			<linearGradient
				id="paint0_linear_1403_2569"
				x1="191.411"
				y1="218.772"
				x2="181.434"
				y2="-19.4039"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#0BB352" stop-opacity="0.28" />
				<stop offset="1" stop-color="#24B670" stop-opacity="0" />
			</linearGradient>
			<linearGradient
				id="paint1_linear_1403_2569"
				x1="141.007"
				y1="71.1962"
				x2="325.408"
				y2="71.1962"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#4B45BD" />
				<stop offset="1" stop-color="#58CAEA" />
			</linearGradient>
			<linearGradient
				id="paint2_linear_1403_2569"
				x1="163.5"
				y1="204"
				x2="165.026"
				y2="236.151"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#9CE8C6" />
				<stop offset="1" stop-color="#ABEBCE" stop-opacity="0" />
			</linearGradient>
			<linearGradient
				id="paint3_linear_1403_2569"
				x1="58.0068"
				y1="177.264"
				x2="223.991"
				y2="177.264"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#4B45BD" />
				<stop offset="1" stop-color="#58CAEA" />
			</linearGradient>
			<linearGradient
				id="paint4_linear_1403_2569"
				x1="58.0067"
				y1="119.738"
				x2="224.15"
				y2="119.738"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#4B45BD" />
				<stop offset="1" stop-color="#58CAEA" />
			</linearGradient>
			<linearGradient
				id="paint5_linear_1403_2569"
				x1="127.878"
				y1="199.077"
				x2="152.168"
				y2="199.077"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#4B45BD" />
				<stop offset="1" stop-color="#58CAEA" />
			</linearGradient>
			<linearGradient
				id="paint6_linear_1403_2569"
				x1="89.3525"
				y1="212.202"
				x2="190.36"
				y2="212.202"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#4B45BD" />
				<stop offset="1" stop-color="#58CAEA" />
			</linearGradient>
			<linearGradient
				id="paint7_linear_1403_2569"
				x1="86.3907"
				y1="90.7944"
				x2="121.784"
				y2="90.7944"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#96BAE4" />
				<stop offset="1" stop-color="#96CDFF" />
			</linearGradient>
			<linearGradient
				id="paint8_linear_1403_2569"
				x1="244.901"
				y1="179.94"
				x2="282.857"
				y2="179.94"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#93FD93" />
				<stop offset="0.51" stop-color="#21C2C1" />
				<stop offset="1" stop-color="#84F599" />
			</linearGradient>
			<linearGradient
				id="paint9_linear_1403_2569"
				x1="264.676"
				y1="163.414"
				x2="264.676"
				y2="194.469"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#0EBC57" />
				<stop offset="1" stop-color="#03933F" />
			</linearGradient>
			<linearGradient
				id="paint10_linear_1403_2569"
				x1="304.945"
				y1="172.051"
				x2="304.945"
				y2="193.582"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#0EBC57" />
				<stop offset="1" stop-color="#03933F" />
			</linearGradient>
			<linearGradient
				id="paint11_linear_1403_2569"
				x1="291.41"
				y1="186.201"
				x2="265.944"
				y2="153.962"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#93FD93" />
				<stop offset="0.51" stop-color="#21C2C1" />
				<stop offset="1" stop-color="#84F599" />
			</linearGradient>
			<linearGradient
				id="paint12_linear_1403_2569"
				x1="275.233"
				y1="139"
				x2="275.233"
				y2="193.454"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#0EBC57" />
				<stop offset="1" stop-color="#03933F" />
			</linearGradient>
			<linearGradient
				id="paint13_linear_1403_2569"
				x1="301.486"
				y1="156.676"
				x2="301.486"
				y2="193.615"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#0EBC57" />
				<stop offset="1" stop-color="#03933F" />
			</linearGradient>
			<linearGradient
				id="paint14_linear_1403_2569"
				x1="285.249"
				y1="191.511"
				x2="285.249"
				y2="214.026"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#0EBC57" />
				<stop offset="1" stop-color="#03933F" />
			</linearGradient>
		</defs>
	</svg>
);

export const CopyIcon = (
	<svg
		width="14"
		height="14"
		viewBox="0 0 14 14"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M12.6 0H5.6C4.8279 0 4.2 0.6279 4.2 1.4V4.2H1.4C0.6279 4.2 0 4.8279 0 5.6V12.6C0 13.3721 0.6279 14 1.4 14H8.4C9.1721 14 9.8 13.3721 9.8 12.6V9.8H12.6C13.3721 9.8 14 9.1721 14 8.4V1.4C14 0.6279 13.3721 0 12.6 0ZM1.4 12.6V5.6H8.4L8.4014 12.6H1.4ZM12.6 8.4H9.8V5.6C9.8 4.8279 9.1721 4.2 8.4 4.2H5.6V1.4H12.6V8.4Z"
			fill="#666873"
		/>
	</svg>
);

export const EditIcon = (
	<svg
		width="16"
		height="15"
		viewBox="0 0 16 15"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M14.5011 3.08825L11.923 0.510192C11.5865 0.194141 11.1456 0.0127958 10.6842 0.000651813C10.2227 -0.0114921 9.77286 0.146413 9.42023 0.444329L0.952174 8.91239C0.648045 9.21909 0.458679 9.62108 0.415864 10.0509L0.0112788 13.9744C-0.00139608 14.1122 0.016486 14.2511 0.0636501 14.3812C0.110814 14.5113 0.186099 14.6294 0.284138 14.7271C0.372056 14.8143 0.476322 14.8833 0.590959 14.9301C0.705595 14.977 0.828346 15.0007 0.952174 15H1.03686L4.96039 14.6424C5.39019 14.5996 5.79217 14.4103 6.09887 14.1061L14.5669 5.63807C14.8956 5.29085 15.0732 4.8275 15.0609 4.34955C15.0485 3.8716 14.8472 3.41804 14.5011 3.08825ZM4.79103 12.7607L1.96834 13.0241L2.22238 10.2014L7.53844 4.95122L10.0789 7.49164L4.79103 12.7607ZM11.302 6.23084L8.78043 3.70924L10.6152 1.82745L13.1838 4.39609L11.302 6.23084Z"
			fill="#7E8AA2"
		/>
	</svg>
);

export const DeleteIcon = (
	<svg
		width="17"
		height="18"
		viewBox="0 0 17 18"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M12.75 2.25C12.9489 2.25 13.1397 2.32902 13.2803 2.46967C13.421 2.61032 13.5 2.80109 13.5 3C13.5 3.19891 13.421 3.38968 13.2803 3.53033C13.1397 3.67098 12.9489 3.75 12.75 3.75H12L11.9977 3.80325L11.298 13.6065C11.2711 13.9849 11.1017 14.3391 10.8241 14.5977C10.5465 14.8563 10.1811 15 9.80175 15H3.6975C3.3181 15 2.9528 14.8563 2.67516 14.5977C2.39753 14.3391 2.22819 13.9849 2.20125 13.6065L1.5015 3.804C1.50036 3.78602 1.49986 3.76801 1.5 3.75H0.75C0.551088 3.75 0.360322 3.67098 0.21967 3.53033C0.0790176 3.38968 0 3.19891 0 3C0 2.80109 0.0790176 2.61032 0.21967 2.46967C0.360322 2.32902 0.551088 2.25 0.75 2.25H12.75ZM10.4977 3.75H3.00225L3.69825 13.5H9.80175L10.4977 3.75ZM8.25 0C8.44891 0 8.63968 0.0790176 8.78033 0.21967C8.92098 0.360322 9 0.551088 9 0.75C9 0.948912 8.92098 1.13968 8.78033 1.28033C8.63968 1.42098 8.44891 1.5 8.25 1.5H5.25C5.05109 1.5 4.86032 1.42098 4.71967 1.28033C4.57902 1.13968 4.5 0.948912 4.5 0.75C4.5 0.551088 4.57902 0.360322 4.71967 0.21967C4.86032 0.0790176 5.05109 0 5.25 0H8.25Z"
			fill="#7E8AA2"
		/>
	</svg>
);

export const WhitePlusIcon = (
	<svg
		width="19"
		height="19"
		viewBox="0 0 19 19"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M17.2689 7.71154H11.2876V1.73023C11.2876 -0.576213 7.7107 -0.576213 7.7107 1.73023V7.71154H1.72939C-0.576462 7.71154 -0.576462 11.2884 1.72939 11.2884H7.7107V17.2698C7.7107 19.5762 11.2876 19.5762 11.2876 17.2698V11.2884H17.2689C19.5751 11.2884 19.5751 7.71154 17.2689 7.71154Z"
			fill="white"
		/>
	</svg>
);
export const BluePlusIcon = (
	<svg
		width="10"
		height="10"
		viewBox="0 0 10 10"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M4.09103 9.5V5.64286H0.233887V4.35714H4.09103V0.5H5.37674V4.35714H9.23389V5.64286H5.37674V9.5H4.09103Z"
			fill="#465868"
		/>
	</svg>
);

export const GrayPlusIcon = (
	<svg
		width="17"
		height="19"
		viewBox="0 0 17 19"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M7.75874 0.604637H9.2413C9.37308 0.604637 9.43898 0.670529 9.43898 0.802312V18.1977C9.43898 18.3295 9.37308 18.3954 9.2413 18.3954H7.75874C7.62696 18.3954 7.56107 18.3295 7.56107 18.1977V0.802312C7.56107 0.670529 7.62696 0.604637 7.75874 0.604637Z"
			fill="#939393"
		/>
		<path
			d="M0.197675 8.56104H16.8024C16.9341 8.56104 17 8.62693 17 8.75872V10.2413C17 10.3731 16.9341 10.439 16.8024 10.439H0.197675C0.0658916 10.439 0 10.3731 0 10.2413V8.75872C0 8.62693 0.0658916 8.56104 0.197675 8.56104Z"
			fill="#939393"
		/>
	</svg>
);
export const WhitenewPlusIcon = (
	<svg
		width="17"
		height="19"
		viewBox="0 0 17 19"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M7.75874 0.604637H9.2413C9.37308 0.604637 9.43898 0.670529 9.43898 0.802312V18.1977C9.43898 18.3295 9.37308 18.3954 9.2413 18.3954H7.75874C7.62696 18.3954 7.56107 18.3295 7.56107 18.1977V0.802312C7.56107 0.670529 7.62696 0.604637 7.75874 0.604637Z"
			fill="#ffffff"
		/>
		<path
			d="M0.197675 8.56104H16.8024C16.9341 8.56104 17 8.62693 17 8.75872V10.2413C17 10.3731 16.9341 10.439 16.8024 10.439H0.197675C0.0658916 10.439 0 10.3731 0 10.2413V8.75872C0 8.62693 0.0658916 8.56104 0.197675 8.56104Z"
			fill="#ffffff"
		/>
	</svg>
);


export const OrangeCopyIcon = (
	<svg
		width="19"
		height="19"
		viewBox="0 0 19 19"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M17.1 0H7.6C6.55215 0 5.7 0.85215 5.7 1.9V5.7H1.9C0.85215 5.7 0 6.55215 0 7.6V17.1C0 18.1479 0.85215 19 1.9 19H11.4C12.4479 19 13.3 18.1479 13.3 17.1V13.3H17.1C18.1479 13.3 19 12.4479 19 11.4V1.9C19 0.85215 18.1479 0 17.1 0ZM1.9 17.1V7.6H11.4L11.4019 17.1H1.9ZM17.1 11.4H13.3V7.6C13.3 6.55215 12.4479 5.7 11.4 5.7H7.6V1.9H17.1V11.4Z"
			fill="#FF7E47"
		/>
	</svg>
);
export const searchIcon = (
	<svg
		width="17"
		height="17"
		viewBox="0 0 17 17"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M16 16L12.4584 12.4521L16 16ZM14.4211 7.71053C14.4211 9.49027 13.7141 11.1971 12.4556 12.4556C11.1971 13.7141 9.49027 14.4211 7.71053 14.4211C5.93078 14.4211 4.22394 13.7141 2.96547 12.4556C1.707 11.1971 1 9.49027 1 7.71053C1 5.93078 1.707 4.22394 2.96547 2.96547C4.22394 1.707 5.93078 1 7.71053 1C9.49027 1 11.1971 1.707 12.4556 2.96547C13.7141 4.22394 14.4211 5.93078 14.4211 7.71053V7.71053Z"
			stroke="#AFB0B8"
			stroke-width="2"
			stroke-linecap="round"
		/>
	</svg>
);
export const sortIcon = (
	<svg
		fill="#93A1C0"
		height="12px"
		width="12px"
		version="1.1"
		id="Capa_1"
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 489.389 489.389"
	>
		<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
		<g
			id="SVGRepo_tracerCarrier"
			stroke-linecap="round"
			stroke-linejoin="round"
		></g>
		<g id="SVGRepo_iconCarrier">
			{ ' ' }
			<g>
				{ ' ' }
				<g>
					{ ' ' }
					<path d="M261.294,326.102c-8.3-7.3-21.8-6.2-29.1,2.1l-77,86.8v-346.9c0-11.4-9.4-20.8-20.8-20.8s-20.8,9.4-20.8,20.8v346.9 l-77-86.8c-8.3-8.3-20.8-9.4-29.1-2.1c-8.3,8.3-9.4,20.8-2.1,29.1l113.4,126.9c8.5,10.5,23.5,8.9,30.2,0l114.4-126.9 C270.694,347.002,269.694,333.402,261.294,326.102z"></path>{ ' ' }
					<path d="M483.994,134.702l-112.4-126.9c-10-10.1-22.5-10.7-31.2,0l-114.4,126.9c-7.3,8.3-6.2,21.8,2.1,29.1 c12.8,10.2,25.7,3.2,29.1-2.1l77-86.8v345.9c0,11.4,9.4,20.8,20.8,20.8s20.8-8.3,20.8-19.8v-346.8l77,86.8 c8.3,8.3,20.8,9.4,29.1,2.1C490.194,155.502,491.294,143.002,483.994,134.702z"></path>{ ' ' }
				</g>{ ' ' }
			</g>{ ' ' }
		</g>
	</svg>
);

export const arrowTop = (
	<svg
		height="18px"
		width="18px"
		viewBox="0 0 24 24"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M6.4569 9.73276C6.17123 10.0327 6.18281 10.5074 6.48276 10.7931C6.78271 11.0788 7.25744 11.0672 7.5431 10.7672L6.4569 9.73276ZM12.5431 5.51724C12.8288 5.21729 12.8172 4.74256 12.5172 4.4569C12.2173 4.17123 11.7426 4.18281 11.4569 4.48276L12.5431 5.51724ZM12.5431 4.48276C12.2574 4.18281 11.7827 4.17123 11.4828 4.4569C11.1828 4.74256 11.1712 5.21729 11.4569 5.51724L12.5431 4.48276ZM16.4569 10.7672C16.7426 11.0672 17.2173 11.0788 17.5172 10.7931C17.8172 10.5074 17.8288 10.0327 17.5431 9.73276L16.4569 10.7672ZM12.75 5C12.75 4.58579 12.4142 4.25 12 4.25C11.5858 4.25 11.25 4.58579 11.25 5H12.75ZM11.25 19C11.25 19.4142 11.5858 19.75 12 19.75C12.4142 19.75 12.75 19.4142 12.75 19H11.25ZM7.5431 10.7672L12.5431 5.51724L11.4569 4.48276L6.4569 9.73276L7.5431 10.7672ZM11.4569 5.51724L16.4569 10.7672L17.5431 9.73276L12.5431 4.48276L11.4569 5.51724ZM11.25 5V19H12.75V5H11.25Z"
			fill="#93A1C0"
		/>
	</svg>
);

export const arrowBottom = (
	<svg
		height="22px"
		width="22px"
		viewBox="0 0 24 24"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			fill-rule="evenodd"
			clip-rule="evenodd"
			d="M16.4929 12.3464C16.8051 12.6186 16.8375 13.0924 16.5653 13.4046L12.5653 17.9929C12.4229 18.1562 12.2168 18.25 12 18.25C11.7833 18.25 11.5771 18.1562 11.4347 17.9929L7.43468 13.4046C7.16249 13.0924 7.19494 12.6186 7.50716 12.3464C7.81938 12.0742 8.29315 12.1067 8.56534 12.4189L11.25 15.4984L11.25 6.5C11.25 6.08579 11.5858 5.75 12 5.75C12.4142 5.75 12.75 6.08579 12.75 6.5L12.75 15.4984L15.4347 12.4189C15.7069 12.1067 16.1806 12.0742 16.4929 12.3464Z"
			fill="#93A1C0"
		/>
	</svg>
);

export const infoIcon = (
	<svg
		width="18"
		height="19"
		viewBox="0 0 18 19"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			fill-rule="evenodd"
			clip-rule="evenodd"
			d="M9.88217 0.543305C11.9587 0.747916 13.8957 1.66711 15.3526 3.13937C16.9398 4.72812 17.8783 6.83682 17.989 9.06351C18.0997 11.2902 17.3749 13.4792 15.9529 15.2132C14.645 16.8151 12.8096 17.9157 10.7646 18.3243C8.71973 18.7329 6.59418 18.4238 4.75625 17.4505C2.91439 16.4562 1.47652 14.8668 0.684753 12.9501C-0.110552 11.0236 -0.216408 8.88767 0.38461 6.89395C0.984337 4.908 2.26109 3.18674 3.99937 2.02071C5.72304 0.862073 7.80594 0.338973 9.88217 0.543305ZM10.4981 17.0648C12.2505 16.7146 13.8241 15.7733 14.9481 14.4031C16.1651 12.9128 16.7843 11.034 16.688 9.12343C16.5918 7.21291 15.7869 5.40372 14.4261 4.03944C13.1797 2.78578 11.5257 2.00363 9.75338 1.8297C7.98104 1.65578 6.20303 2.10114 4.73015 3.08794C3.6215 3.84065 2.72624 4.85979 2.12919 6.04882C1.53214 7.23785 1.25306 8.55739 1.31841 9.88243C1.38375 11.2075 1.79135 12.4941 2.50258 13.6205C3.21382 14.7469 4.20514 15.6757 5.38264 16.319C6.94642 17.1506 8.75695 17.4145 10.4981 17.0648ZM8.32534 6.93253H9.95655V5.64671H8.32534V6.93253ZM9.95655 8.21834V13.3616H8.32534V8.21834H9.95655Z"
			fill="#555555"
		/>
	</svg>
);
export const ProIcon = (
	<svg width="11" height="8" viewBox="0 0 11 8" fill="none" xmlns="http://www.w3.org/2000/svg">
	<path d="M0.949745 0.621035L3.12548 2.36105L5.06391 0.191747C5.11819 0.131101 5.18682 0.0823669 5.2647 0.0491731C5.34257 0.0159793 5.42768 -0.000818507 5.51369 3.0664e-05C5.5997 0.000879835 5.68439 0.0193541 5.76145 0.0540776C5.83852 0.0888011 5.90597 0.138879 5.95879 0.200582L7.80859 2.36053L10.0547 0.595569C10.1429 0.526399 10.2522 0.483367 10.3681 0.47223C10.4839 0.461094 10.6007 0.482384 10.7029 0.533253C10.8051 0.584122 10.8877 0.662142 10.9398 0.756871C10.9918 0.8516 11.0108 0.958518 10.9941 1.06332L10.1364 6.44084H0.877125L0.00626076 1.08774C-0.011038 0.982362 0.00771585 0.874695 0.0599824 0.779325C0.112249 0.683955 0.195502 0.60549 0.298467 0.554557C0.401431 0.503624 0.519131 0.482685 0.635624 0.494576C0.752117 0.506467 0.861775 0.550613 0.949745 0.621035ZM0.921726 6.96056H10.0707V7.48028C10.0707 7.61812 10.0104 7.75031 9.90319 7.84778C9.79595 7.94524 9.65051 8 9.49886 8H1.49353C1.34188 8 1.19644 7.94524 1.08921 7.84778C0.98197 7.75031 0.921726 7.61812 0.921726 7.48028V6.96056Z" fill="#8836ED"/>
	</svg>


);


export const hintIcon = (
	<svg
		width="23"
		height="22"
		viewBox="0 0 23 22"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M5.5 20H9.5C9.5 21.1 8.6 22 7.5 22C6.4 22 5.5 21.1 5.5 20ZM3.5 19H11.5V17H3.5V19ZM15 9.5C15 13.32 12.34 15.36 11.23 16H3.77C2.66 15.36 0 13.32 0 9.5C0 5.36 3.36 2 7.5 2C11.64 2 15 5.36 15 9.5ZM19.87 7.37L18.5 8L19.87 8.63L20.5 10L21.13 8.63L22.5 8L21.13 7.37L20.5 6L19.87 7.37ZM17.5 6L18.44 3.94L20.5 3L18.44 2.06L17.5 0L16.56 2.06L14.5 3L16.56 3.94L17.5 6Z"
			fill="#FC7E2A"
		/>
	</svg>
);
export const swapIcon = (
	<svg
		width="13"
		height="15"
		viewBox="0 0 13 15"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M4 7.5L1 10.5L4 13.5M11.5 10.5H1M8.5 1L11.5 4L8.5 7M1 4H11.5"
			stroke="#008717"
			stroke-width="1.5"
			stroke-linecap="round"
			stroke-linejoin="round"
		/>
	</svg>
);
export const infoIconWithQuestionMark = (
	<svg
		width="13"
		height="13"
		viewBox="0 0 13 13"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			fill-rule="evenodd"
			clip-rule="evenodd"
			d="M6.5 1.18182C3.56285 1.18182 1.18182 3.56285 1.18182 6.5C1.18182 9.43715 3.56285 11.8182 6.5 11.8182C9.43715 11.8182 11.8182 9.43715 11.8182 6.5C11.8182 3.56285 9.43715 1.18182 6.5 1.18182ZM0 6.5C0 2.91015 2.91015 0 6.5 0C10.0899 0 13 2.91015 13 6.5C13 10.0899 10.0899 13 6.5 13C2.91015 13 0 10.0899 0 6.5Z"
			fill="#666873"
		/>
		<path
			fill-rule="evenodd"
			clip-rule="evenodd"
			d="M6.16534 4.22792C6.08221 4.2937 5.98139 4.42072 5.84603 4.68874C5.69891 4.98004 5.34349 5.09693 5.05218 4.9498C4.76088 4.80268 4.644 4.44726 4.79112 4.15596C4.95121 3.83897 5.14586 3.52754 5.43204 3.30111C5.73884 3.05838 6.09643 2.95453 6.50039 2.95453C7.6037 2.95453 8.27312 3.84572 8.27312 4.71426C8.27312 5.13439 8.15711 5.49132 7.87557 5.82545C7.68041 6.05707 7.41156 6.26882 7.0913 6.49006V7.09089C7.0913 7.41724 6.82674 7.6818 6.50039 7.6818C6.17404 7.6818 5.90948 7.41724 5.90948 7.09089V5.85757L6.1749 5.6824C6.62347 5.38634 6.84945 5.20915 6.97181 5.06394C7.05959 4.95976 7.0913 4.87853 7.0913 4.71426C7.0913 4.41397 6.86963 4.13635 6.50039 4.13635C6.31345 4.13635 6.22786 4.17845 6.16534 4.22792ZM6.50039 8.56817C6.82674 8.56817 7.0913 8.83272 7.0913 9.15907V9.45453C7.0913 9.78088 6.82674 10.0454 6.50039 10.0454C6.17404 10.0454 5.90948 9.78088 5.90948 9.45453V9.15907C5.90948 8.83272 6.17404 8.56817 6.50039 8.56817Z"
			fill="#666873"
		/>
	</svg>
);
export const arrowRightIcon = (
	<svg
		width="17"
		height="17"
		viewBox="0 0 18 19"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M6.87141 16.3713L12.4446 10.7982H6.29425e-05V8.2018H12.4446L6.87141 2.62865L8.70706 0.792999L17.4141 9.5L8.70706 18.207L6.87141 16.3713Z"
			fill="white"
		/>
	</svg>
);

export const ssgslogo = (
	<svg
		width="99"
		height="94"
		viewBox="0 0 99 94"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			fill-rule="evenodd"
			clip-rule="evenodd"
			d="M94.2673 47C94.2673 72.9574 73.2247 94 47.2673 94C21.31 94 0.267334 72.9574 0.267334 47C0.267334 21.0426 21.31 0 47.2673 0C73.2247 0 94.2673 21.0426 94.2673 47Z"
			fill="url(#paint0_linear_2907_852)"
		/>
		<path
			d="M38.9768 18.3627C39.3662 16.9092 40.8602 16.0466 42.3138 16.4361L66.4279 22.8974C67.8814 23.2869 68.744 24.7809 68.3545 26.2344L61.7913 50.7285C61.4019 52.182 59.9078 53.0446 58.4543 52.6551L34.3402 46.1938C32.8867 45.8043 32.0241 44.3103 32.4136 42.8568L38.9768 18.3627Z"
			fill="#F8F3FF"
		/>
		<path
			d="M41.4148 22.0536C41.7432 20.828 43.003 20.1007 44.2285 20.4291L62.9371 25.442C64.1627 25.7704 64.8901 27.0302 64.5617 28.2558L59.0922 48.6682C58.7638 49.8938 57.504 50.6211 56.2784 50.2927L37.5698 45.2798C36.3442 44.9514 35.6169 43.6916 35.9453 42.466L41.4148 22.0536Z"
			fill="#34A853"
		/>
		<path
			fill-rule="evenodd"
			clip-rule="evenodd"
			d="M49.1748 38.919C49.2118 38.9333 49.2499 38.9457 49.2891 38.9562C49.3283 38.9667 49.3675 38.975 49.4067 38.9812L55.685 40.6635C56.2462 40.8138 56.823 40.4808 56.9733 39.9196C57.0027 39.8101 57.0136 39.6999 57.008 39.5924L58.1638 35.2791C58.1771 35.2445 58.1887 35.2088 58.1985 35.1723C58.2083 35.1357 58.2161 35.099 58.2218 35.0624L59.389 30.7066C59.4023 30.6721 59.4139 30.6364 59.4237 30.5999C59.4378 30.5471 59.4477 30.4942 59.4535 30.4415C59.5341 29.918 59.2092 29.4068 58.6858 29.2665C58.5832 29.2391 58.4802 29.2277 58.3793 29.231L45.9788 25.9083C45.4177 25.7579 44.8409 26.091 44.6905 26.6521L44.6882 26.6608L43.4675 31.2164L43.4653 31.2245L43.4632 31.2326L42.1948 35.9664C42.0444 36.5276 42.3775 37.1044 42.9386 37.2547C42.9768 37.2649 43.015 37.2729 43.0532 37.2788L49.1748 38.919ZM57.1136 31.0699L56.4329 33.6101L52.2049 32.4772L52.8856 29.937L57.1136 31.0699ZM48.7345 36.623L44.5009 35.4886L45.2253 32.7851L49.4589 33.9195L48.7345 36.623ZM55.164 38.3458L55.8884 35.6423L51.6604 34.5094L50.936 37.2129L55.164 38.3458ZM50.6841 29.3471L46.4504 28.2127L45.7698 30.753L50.0034 31.8874L50.6841 29.3471Z"
			fill="white"
		/>
		<g filter="url(#filter0_i_2907_852)">
			<path
				d="M39.5636 74.9534C39.5636 76.8375 37.9939 78.3647 36.0576 78.3647C34.1212 78.3647 32.5515 76.8375 32.5515 74.9534C32.5515 73.0694 34.1212 71.5422 36.0576 71.5422C37.9939 71.5422 39.5636 73.0694 39.5636 74.9534Z"
				fill="#FBFBFB"
			/>
		</g>
		<g filter="url(#filter1_i_2907_852)">
			<path
				d="M60.0314 74.9534C60.0314 76.8375 58.4617 78.3647 56.5253 78.3647C54.589 78.3647 53.0193 76.8375 53.0193 74.9534C53.0193 73.0694 54.589 71.5422 56.5253 71.5422C58.4617 71.5422 60.0314 73.0694 60.0314 74.9534Z"
				fill="#FBFBFB"
			/>
		</g>
		<path
			d="M67.521 48.4816L65.4626 60.2314C65.2087 61.5293 64.1694 62.3186 62.9708 62.3334H32.9614L32.3656 65.675H60.9666C62.4726 65.7889 63.4942 66.8504 63.5126 68.2082C63.403 69.7036 62.3363 70.7228 60.9666 70.7414H29.3321C27.6212 70.5883 26.601 69.2313 26.7861 67.7231L28.1404 60.393L26.0819 39.804L20.2317 37.9716C18.8021 37.4068 18.2186 36.1199 18.5525 34.7916C19.1077 33.4072 20.438 32.7747 21.7485 33.1208L29.2237 35.4923C30.2308 35.8679 30.8101 36.6881 30.9571 37.6482L31.3905 41.7444L65.3 45.5173C66.8581 45.8531 67.7039 47.081 67.521 48.4816Z"
			fill="white"
		/>
		<path
			d="M69.7117 71.0683C69.7117 63.7416 75.6511 57.8022 82.9778 57.8022H86.9576C94.2843 57.8022 100.224 63.7416 100.224 71.0683V75.8062C100.224 83.1329 94.2843 89.0723 86.9576 89.0723H82.9778C75.6511 89.0723 69.7117 83.1329 69.7117 75.8062V71.0683Z"
			fill="url(#paint1_linear_2907_852)"
		/>
		<path
			fill-rule="evenodd"
			clip-rule="evenodd"
			d="M86.9576 59.6973H82.9778C76.6978 59.6973 71.6068 64.7883 71.6068 71.0683V75.8062C71.6068 82.0862 76.6978 87.1772 82.9778 87.1772H86.9576C93.2376 87.1772 98.3286 82.0862 98.3286 75.8062V71.0683C98.3286 64.7883 93.2376 59.6973 86.9576 59.6973ZM82.9778 57.8022C75.6511 57.8022 69.7117 63.7416 69.7117 71.0683V75.8062C69.7117 83.1329 75.6511 89.0723 82.9778 89.0723H86.9576C94.2843 89.0723 100.224 83.1329 100.224 75.8062V71.0683C100.224 63.7416 94.2843 57.8022 86.9576 57.8022H82.9778Z"
			fill="white"
		/>
		<path
			d="M88.4306 69.7323C87.487 68.8487 86.2624 68.3644 84.9632 68.3655C82.6252 68.3676 80.6067 69.9707 80.0494 72.1945C80.0088 72.3564 79.8646 72.4707 79.6977 72.4707H77.968C77.7417 72.4707 77.5697 72.2652 77.6116 72.0428C78.2647 68.5745 81.3098 65.9507 84.9678 65.9507C86.9736 65.9507 88.795 66.7396 90.139 68.024L91.217 66.9459C91.6734 66.4895 92.4537 66.8128 92.4537 67.4582V71.5048C92.4537 71.9049 92.1294 72.2292 91.7293 72.2292H87.6827C87.0373 72.2292 86.7141 71.4489 87.1704 70.9925L88.4306 69.7323ZM78.2064 74.644H82.2529C82.8984 74.644 83.2216 75.4243 82.7652 75.8807L81.505 77.1409C82.4486 78.0245 83.6733 78.5089 84.9725 78.5077C87.3094 78.5056 89.3287 76.9036 89.8863 74.6788C89.9268 74.5169 90.0711 74.4026 90.2379 74.4026H91.9677C92.194 74.4026 92.3659 74.6081 92.3241 74.8305C91.6709 78.2987 88.6259 80.9225 84.9678 80.9225C82.9621 80.9225 81.1406 80.1336 79.7967 78.8492L78.7186 79.9273C78.2622 80.3837 77.4819 80.0604 77.4819 79.415V75.3684C77.4819 74.9683 77.8063 74.644 78.2064 74.644Z"
			fill="white"
		/>
		<defs>
			<filter
				id="filter0_i_2907_852"
				x="32.5515"
				y="71.5422"
				width="7.01221"
				height="6.82259"
				filterUnits="userSpaceOnUse"
				color-interpolation-filters="sRGB"
			>
				<feFlood flood-opacity="0" result="BackgroundImageFix" />
				<feBlend
					mode="normal"
					in="SourceGraphic"
					in2="BackgroundImageFix"
					result="shape"
				/>
				<feColorMatrix
					in="SourceAlpha"
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
					result="hardAlpha"
				/>
				<feOffset />
				<feGaussianBlur stdDeviation="4.74217" />
				<feComposite
					in2="hardAlpha"
					operator="arithmetic"
					k2="-1"
					k3="1"
				/>
				<feColorMatrix
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.13 0"
				/>
				<feBlend
					mode="normal"
					in2="shape"
					result="effect1_innerShadow_2907_852"
				/>
			</filter>
			<filter
				id="filter1_i_2907_852"
				x="53.0193"
				y="71.5422"
				width="7.01221"
				height="6.82259"
				filterUnits="userSpaceOnUse"
				color-interpolation-filters="sRGB"
			>
				<feFlood flood-opacity="0" result="BackgroundImageFix" />
				<feBlend
					mode="normal"
					in="SourceGraphic"
					in2="BackgroundImageFix"
					result="shape"
				/>
				<feColorMatrix
					in="SourceAlpha"
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
					result="hardAlpha"
				/>
				<feOffset />
				<feGaussianBlur stdDeviation="4.74217" />
				<feComposite
					in2="hardAlpha"
					operator="arithmetic"
					k2="-1"
					k3="1"
				/>
				<feColorMatrix
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.13 0"
				/>
				<feBlend
					mode="normal"
					in2="shape"
					result="effect1_innerShadow_2907_852"
				/>
			</filter>
			<linearGradient
				id="paint0_linear_2907_852"
				x1="47.2673"
				y1="-25.2688"
				x2="48.7834"
				y2="138.264"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#B38BE2" />
				<stop offset="1" stop-color="#5C1BAB" />
			</linearGradient>
			<linearGradient
				id="paint1_linear_2907_852"
				x1="84.9677"
				y1="57.8022"
				x2="84.9677"
				y2="89.0723"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#25CD52" />
				<stop offset="1" stop-color="#34A853" />
			</linearGradient>
		</defs>
	</svg>
);
export const ctaAddImg = (
	<svg
		width="164"
		height="136"
		viewBox="0 0 164 136"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<rect
			x="0.579102"
			width="104.437"
			height="115.744"
			rx="0.69228"
			fill="white"
		/>
		<path
			d="M0.579102 26.509H19.6536L19.6536 115.744H2.10212C1.26098 115.744 0.579102 115.062 0.579102 114.221L0.579102 26.509Z"
			fill="#EFEFEF"
		/>
		<path
			d="M0.579102 26.4969L22.9968 26.4969C23.3792 26.4969 23.6891 26.8069 23.6891 27.1892L23.6891 115.057C23.6891 115.439 23.3792 115.749 22.9968 115.749H1.27138C0.889046 115.749 0.579102 115.439 0.579102 115.057L0.579102 26.4969Z"
			fill="#EFEFEF"
		/>
		<path
			d="M29.3589 29.6793L91.6225 29.6793C92.0049 29.6793 92.3148 29.9893 92.3148 30.3716V36.182C92.3148 36.5643 92.0049 36.8743 91.6225 36.8743L30.0512 36.8743C29.6688 36.8743 29.3589 36.5643 29.3589 36.182V29.6793Z"
			fill="#EFEFEF"
		/>
		<path
			d="M29.3589 43.1699L75.4339 43.1699C75.8162 43.1699 76.1261 43.4799 76.1261 43.8622V49.6726C76.1261 50.0549 75.8162 50.3649 75.4339 50.3649H30.0512C29.6688 50.3649 29.3589 50.0549 29.3589 49.6726V43.1699Z"
			fill="#EFEFEF"
		/>
		<path
			d="M29.3589 54.8616H53.849C54.2313 54.8616 54.5413 55.1716 54.5413 55.5539V61.3643C54.5413 61.7467 54.2313 62.0566 53.849 62.0566H30.0512C29.6688 62.0566 29.3589 61.7467 29.3589 61.3643V54.8616Z"
			fill="#EFEFEF"
		/>
		<path
			d="M29.3589 66.5535H69.1383C69.5206 66.5535 69.8305 66.8634 69.8305 67.2457V73.0561C69.8305 73.4385 69.5206 73.7484 69.1383 73.7484H30.0512C29.6688 73.7484 29.3589 73.4385 29.3589 73.0561V66.5535Z"
			fill="#EFEFEF"
		/>
		<path
			d="M29.3589 78.2452H87.1257C87.508 78.2452 87.8179 78.5552 87.8179 78.9375V84.7479C87.8179 85.1303 87.508 85.4402 87.1257 85.4402H30.0512C29.6688 85.4402 29.3589 85.1303 29.3589 84.7479V78.2452Z"
			fill="#EFEFEF"
		/>
		<path
			d="M29.3589 93.5346H75.4339C75.8162 93.5346 76.1261 93.8446 76.1261 94.2269V100.037C76.1261 100.42 75.8162 100.73 75.4339 100.73H30.0512C29.6688 100.73 29.3589 100.42 29.3589 100.037V93.5346Z"
			fill="#EFEFEF"
		/>
		<path
			d="M29.3589 106.126H83.5282C83.9105 106.126 84.2205 106.436 84.2205 106.818V112.628C84.2205 113.011 83.9105 113.321 83.5282 113.321H30.0512C29.6688 113.321 29.3589 113.011 29.3589 112.628V106.126Z"
			fill="#EFEFEF"
		/>
		<line
			x1="0.579102"
			y1="26.4744"
			x2="105.016"
			y2="26.4744"
			stroke="#ABABAB"
			stroke-width="0.069228"
		/>
		<line
			x1="0.579102"
			y1="39.7292"
			x2="105.016"
			y2="39.7292"
			stroke="#ABABAB"
			stroke-width="0.069228"
		/>
		<line
			x1="0.579102"
			y1="52.2367"
			x2="105.016"
			y2="52.2367"
			stroke="#ABABAB"
			stroke-width="0.069228"
		/>
		<line
			x1="0.579102"
			y1="64.7448"
			x2="105.016"
			y2="64.7448"
			stroke="#ABABAB"
			stroke-width="0.069228"
		/>
		<line
			x1="0.579102"
			y1="77.9993"
			x2="105.016"
			y2="77.9993"
			stroke="#ABABAB"
			stroke-width="0.069228"
		/>
		<line
			x1="0.579102"
			y1="90.6937"
			x2="105.016"
			y2="90.6937"
			stroke="#ABABAB"
			stroke-width="0.069228"
		/>
		<line
			x1="0.579102"
			y1="103.201"
			x2="105.016"
			y2="103.201"
			stroke="#ABABAB"
			stroke-width="0.069228"
		/>
		<line
			x1="23.6726"
			y1="26.509"
			x2="23.6726"
			y2="115.744"
			stroke="#ABABAB"
			stroke-width="0.069228"
		/>
		<path
			d="M0.579102 0.69228C0.579102 0.309944 0.889046 0 1.27138 0L104.973 0V26.4968L0.579102 26.4968L0.579102 0.69228Z"
			fill="#F5F5F5"
		/>
		<path
			d="M18.4811 21.7569H8.04543C7.38035 21.7569 6.84131 21.2179 6.84131 20.5528L6.84131 6.10341C6.84131 5.43834 7.38035 4.89929 8.04543 4.89929L15.6715 4.89929L19.6852 8.91302V20.5528C19.6852 21.2179 19.1462 21.7569 18.4811 21.7569Z"
			fill="#43A047"
		/>
		<path
			d="M19.6854 8.91314H15.6716V4.89941L19.6854 8.91314Z"
			fill="#C8E6C9"
		/>
		<path
			d="M15.6716 8.91302L19.6854 12.9268V8.91302H15.6716Z"
			fill="#2E7D32"
		/>
		<path
			d="M16.0728 12.926H10.4536H9.65088V13.7288V14.5315V15.3343V16.137V16.9398V17.7425V18.5452H16.8756V17.7425V16.9398V16.137V15.3343V14.5315V13.7288V12.926H16.0728ZM10.4536 13.7288H12.0591V14.5315H10.4536V13.7288ZM10.4536 15.3343H12.0591V16.137H10.4536V15.3343ZM10.4536 16.9398H12.0591V17.7425H10.4536V16.9398ZM16.0728 17.7425H12.8619V16.9398H16.0728V17.7425ZM16.0728 16.137H12.8619V15.3343H16.0728V16.137ZM16.0728 14.5315H12.8619V13.7288H16.0728V14.5315Z"
			fill="#E8F5E9"
		/>
		<path
			d="M25.4461 17.692H26.4298V15.527H27.8043C29.0471 15.527 29.9078 14.6794 29.9078 13.441V13.4322C29.9078 12.1895 29.0471 11.3551 27.8043 11.3551H25.4461V17.692ZM27.5584 12.1851C28.4147 12.1851 28.9066 12.6462 28.9066 13.4366V13.4454C28.9066 14.2403 28.4147 14.7014 27.5584 14.7014H26.4298V12.1851H27.5584ZM30.6544 17.692H31.6029V14.9385C31.6029 14.2491 31.9806 13.8494 32.591 13.8494C32.7755 13.8494 32.9423 13.8714 33.017 13.9021V13.0194C32.9423 13.0063 32.8238 12.9843 32.6876 12.9843C32.1607 12.9843 31.7742 13.3225 31.6249 13.8626H31.6029V13.0721H30.6544V17.692ZM35.3884 17.7842C36.7102 17.7842 37.5797 16.8708 37.5797 15.382V15.3733C37.5797 13.8933 36.7014 12.9843 35.384 12.9843C34.0709 12.9843 33.197 13.8977 33.197 15.3733V15.382C33.197 16.8664 34.0622 17.7842 35.3884 17.7842ZM35.3928 16.9893C34.6506 16.9893 34.1676 16.4053 34.1676 15.382V15.3733C34.1676 14.3632 34.655 13.7792 35.384 13.7792C36.1261 13.7792 36.6092 14.3632 36.6092 15.3733V15.382C36.6092 16.4009 36.1349 16.9893 35.3928 16.9893ZM40.0389 17.7842C40.702 17.7842 41.2115 17.4504 41.4881 16.9103H41.5057V17.692H42.4586V11.3551H41.5057V13.8582H41.4881C41.2115 13.3137 40.6845 12.9843 40.0301 12.9843C38.8708 12.9843 38.1067 13.9065 38.1067 15.3777V15.382C38.1067 16.8532 38.862 17.7842 40.0389 17.7842ZM40.2892 16.9674C39.5383 16.9674 39.0772 16.3657 39.0772 15.382V15.3777C39.0772 14.4028 39.5427 13.7967 40.2892 13.7967C41.0007 13.7967 41.5101 14.4203 41.5101 15.3777V15.382C41.5101 16.3438 41.0051 16.9674 40.2892 16.9674ZM45.0057 17.7842C45.7083 17.7842 46.1782 17.4636 46.4197 16.9981H46.4417V17.692H47.3946V13.0721H46.4417V15.7685C46.4417 16.4887 46.0113 16.9674 45.3438 16.9674C44.6851 16.9674 44.3601 16.5809 44.3601 15.8827V13.0721H43.4116V16.0671C43.4116 17.1298 43.9912 17.7842 45.0057 17.7842ZM50.3193 17.7842C51.4304 17.7842 52.2033 17.0728 52.3043 16.1462L52.3087 16.1154H51.3952L51.3908 16.1506C51.2767 16.6512 50.9034 16.9893 50.3193 16.9893C49.586 16.9893 49.0985 16.3965 49.0985 15.3864V15.382C49.0985 14.394 49.5772 13.7792 50.3149 13.7792C50.9341 13.7792 51.2855 14.1612 51.3865 14.6135L51.3952 14.6487H52.2999L52.2955 14.6179C52.2164 13.7484 51.4962 12.9843 50.3062 12.9843C48.9887 12.9843 48.128 13.9109 48.128 15.3733V15.3777C48.128 16.8576 48.9712 17.7842 50.3193 17.7842ZM54.601 17.7842C54.7942 17.7842 54.9743 17.7622 55.0841 17.7447V17.0113C55.0138 17.0201 54.9304 17.0288 54.8294 17.0288C54.4297 17.0288 54.2189 16.8883 54.2189 16.4184V13.8275H55.0841V13.0721H54.2189V11.8689H53.2484V13.0721H52.5853V13.8275H53.2484V16.4755C53.2484 17.3977 53.6876 17.7842 54.601 17.7842ZM57.6004 17.7842C58.6894 17.7842 59.4799 17.2045 59.4799 16.3613V16.357C59.4799 15.6938 59.1198 15.3206 58.1756 15.101L57.4247 14.9297C56.9285 14.8112 56.7396 14.6179 56.7396 14.3325V14.3281C56.7396 13.9592 57.0602 13.7177 57.5696 13.7177C58.1054 13.7177 58.4216 13.9987 58.4787 14.4028L58.483 14.4335H59.3745L59.3701 14.3808C59.3218 13.5947 58.6631 12.9843 57.5696 12.9843C56.5069 12.9843 55.7867 13.5508 55.7867 14.3764V14.3808C55.7867 15.0527 56.2214 15.4743 57.0997 15.6763L57.8551 15.8475C58.3513 15.9661 58.5182 16.1374 58.5182 16.436V16.4404C58.5182 16.8137 58.1756 17.0508 57.6048 17.0508C57.0207 17.0508 56.7045 16.8005 56.6167 16.3745L56.6079 16.3306H55.6681L55.6725 16.3701C55.7691 17.2133 56.4454 17.7842 57.6004 17.7842Z"
			fill="#216124"
		/>
		<rect
			opacity="0.1"
			x="61.1611"
			y="38.2885"
			width="102.34"
			height="97.0648"
			fill="#1B815C"
		/>
		<rect
			x="62.8809"
			y="38.2885"
			width="101.119"
			height="96.8163"
			rx="5.68346"
			fill="#FBFFFD"
		/>
		<path
			d="M96.2078 50.5121C96.2078 46.2767 99.6412 42.8433 103.877 42.8433H120.91C125.146 42.8433 128.579 46.2767 128.579 50.5121V54.6217C128.579 57.0822 126.572 59.0701 124.111 59.0461L118.788 58.994C118.083 58.9871 117.606 59.7083 117.887 60.3542C118.252 61.1938 117.36 62.0269 116.547 61.6051L112.296 59.399C111.916 59.202 111.495 59.099 111.067 59.0988L103.872 59.0944C99.6384 59.0918 96.2078 55.6592 96.2078 51.4256V50.5121Z"
			fill="white"
		/>
		<path
			fill-rule="evenodd"
			clip-rule="evenodd"
			d="M124.764 43.549H100.185C98.6298 43.549 97.3706 44.795 97.3829 46.3073V55.5016C97.3829 57.0259 98.6421 58.2599 100.198 58.2599H111.839L117.16 61.1634L115.95 58.2599H124.764C126.32 58.2599 127.579 57.0259 127.579 55.5016V46.3073C127.579 44.7829 126.32 43.549 124.764 43.549ZM99.6668 45.6782C99.3211 45.7024 99.0619 45.8233 98.8891 46.0532C98.7162 46.271 98.6545 46.5492 98.6915 46.8638C99.4199 51.4005 100.099 54.4612 100.728 56.046C100.975 56.6267 101.259 56.905 101.593 56.8808C102.111 56.8445 102.728 56.1428 103.457 54.7758C103.839 54.0015 104.432 52.8401 105.234 51.2916C105.901 53.578 106.815 55.296 107.963 56.4453C108.284 56.7719 108.617 56.9171 108.938 56.8929C109.222 56.8687 109.444 56.7235 109.592 56.4573C109.716 56.2275 109.765 55.9613 109.74 55.6589C109.666 54.558 109.777 53.0216 110.086 51.0496C110.407 49.0172 110.802 47.5533 111.284 46.6823C111.382 46.5008 111.419 46.3194 111.407 46.1016C111.382 45.8233 111.259 45.5935 111.024 45.412C110.79 45.2306 110.53 45.1459 110.247 45.1701C109.889 45.1943 109.617 45.3636 109.432 45.7024C108.666 47.0694 108.123 49.2833 107.802 52.3562C107.333 51.1948 106.938 49.8277 106.629 48.2187C106.494 47.505 106.16 47.1662 105.617 47.2025C105.247 47.2267 104.938 47.4687 104.691 47.9284L101.988 52.9732C101.543 51.219 101.124 49.0777 100.741 46.5492C100.654 45.9201 100.296 45.6298 99.6668 45.6782ZM123.456 46.5493C124.332 46.7307 124.987 47.1904 125.431 47.9526C125.826 48.6059 126.024 49.3923 126.024 50.3359C126.024 51.5819 125.703 52.7191 125.061 53.7596C124.32 54.9694 123.357 55.5742 122.16 55.5742C121.95 55.5742 121.728 55.55 121.493 55.5016C120.616 55.3202 119.962 54.8605 119.518 54.0983C119.123 53.4329 118.925 52.6345 118.925 51.7029C118.925 50.4569 119.246 49.3197 119.888 48.2913C120.641 47.0816 121.604 46.4767 122.789 46.4767C122.999 46.4767 123.221 46.5009 123.456 46.5493ZM122.937 53.0942C123.394 52.695 123.703 52.1021 123.876 51.3037C123.925 51.0255 123.962 50.723 123.962 50.4085C123.962 50.0576 123.888 49.6826 123.74 49.3076C123.555 48.8357 123.308 48.5817 123.011 48.5212C122.567 48.4365 122.135 48.6785 121.728 49.2713C121.394 49.731 121.184 50.2149 121.073 50.7109C121.011 50.9892 120.987 51.2916 120.987 51.5941C120.987 51.9449 121.061 52.3199 121.209 52.695C121.394 53.1668 121.641 53.4208 121.937 53.4813C122.246 53.5418 122.579 53.4087 122.937 53.0942ZM117.691 47.9526C117.246 47.1904 116.58 46.7307 115.715 46.5493C115.481 46.5009 115.259 46.4767 115.049 46.4767C113.864 46.4767 112.901 47.0816 112.148 48.2913C111.506 49.3197 111.185 50.4569 111.185 51.7029C111.185 52.6345 111.382 53.4329 111.777 54.0983C112.222 54.8605 112.876 55.3202 113.753 55.5016C113.987 55.55 114.209 55.5742 114.419 55.5742C115.617 55.5742 116.58 54.9694 117.32 53.7596C117.962 52.7191 118.283 51.5819 118.283 50.3359C118.283 49.3923 118.086 48.6059 117.691 47.9526ZM116.135 51.3037C115.962 52.1021 115.654 52.695 115.197 53.0942C114.839 53.4087 114.506 53.5418 114.197 53.4813C113.901 53.4208 113.654 53.1668 113.469 52.695C113.32 52.3199 113.246 51.9449 113.246 51.5941C113.246 51.2916 113.271 50.9892 113.333 50.7109C113.444 50.2149 113.654 49.731 113.987 49.2713C114.395 48.6785 114.827 48.4365 115.271 48.5212C115.567 48.5817 115.814 48.8357 115.999 49.3076C116.148 49.6826 116.222 50.0576 116.222 50.4085C116.222 50.723 116.197 51.0255 116.135 51.3037Z"
			fill="#7F54B3"
		/>
		<rect
			opacity="0.3"
			x="82.6426"
			y="64.7105"
			width="27.7361"
			height="27.3894"
			fill="#C4C4C4"
		/>
		<rect
			opacity="0.3"
			x="118.7"
			y="98.3411"
			width="27.7361"
			height="27.3894"
			fill="#C4C4C4"
		/>
		<rect
			x="82.7921"
			y="98.4907"
			width="27.4369"
			height="27.0902"
			rx="1.34608"
			fill="#FFF2F3"
			stroke="#FF919F"
			stroke-width="0.299129"
		/>
		<rect
			x="118.849"
			y="64.8604"
			width="27.4369"
			height="27.0902"
			rx="1.34608"
			fill="#EAFAFF"
			stroke="#71DCFF"
			stroke-width="0.299129"
		/>
		<path
			d="M137.583 82.8183C135.448 86.7337 135.48 87.0573 134.477 86.4749C133.474 85.8924 133.086 85.3747 135.254 81.4916C137.422 77.6086 138.036 77.6409 139.04 78.2234C140.01 78.7735 139.719 78.9353 137.583 82.8183Z"
			fill="#454749"
		/>
		<path
			d="M139.59 83.983C138.231 86.4746 136.548 87.6719 135.739 87.2189C134.736 86.6364 135.254 86.6364 137.389 82.721C139.525 78.8056 139.266 78.3526 140.269 78.935C141.078 79.388 140.949 81.4914 139.59 83.983Z"
			fill="#258399"
		/>
		<path
			d="M127.552 82.8183C129.688 86.7337 129.655 87.0573 130.658 86.4749C131.662 85.8924 132.05 85.3747 129.882 81.4916C127.714 77.6086 127.099 77.6409 126.096 78.2234C125.125 78.7735 125.416 78.9353 127.552 82.8183Z"
			fill="#454749"
		/>
		<path
			d="M125.546 83.983C126.905 86.4746 128.588 87.6719 129.397 87.2189C130.4 86.6364 129.882 86.6364 127.746 82.721C125.611 78.8056 125.869 78.3526 124.866 78.935C124.057 79.388 124.187 81.4914 125.546 83.983Z"
			fill="#258399"
		/>
		<path
			d="M125.87 86.8955C125.87 86.8955 127.617 87.3485 127.747 86.8955C128.555 84.2744 124.058 82.7212 124.058 79.7442C124.058 74.9551 127.876 71.072 132.568 71.072C137.26 71.072 141.078 74.9551 141.078 79.7442C141.078 82.7212 136.58 84.2744 137.389 86.8955C137.519 87.3485 139.266 86.8955 139.266 86.8955C141.111 85.0834 142.276 82.5594 142.276 79.7442C142.276 74.2756 137.94 69.8424 132.568 69.8424C127.196 69.8424 122.86 74.2756 122.86 79.7442C122.86 82.5594 124.025 85.0834 125.87 86.8955Z"
			fill="#3BAACF"
		/>
		<path
			d="M127.035 73.9192C128.167 73.6927 129.623 72.0748 132.568 72.0748C135.513 72.0748 137.001 73.7251 138.101 73.9192C138.554 74.0163 139.331 73.3044 139.331 73.3044C137.551 71.2658 135.448 70.2303 132.568 70.2303C129.688 70.2303 127.585 71.2658 125.805 73.3044C125.805 73.3368 126.582 74.0163 127.035 73.9192Z"
			fill="#454749"
		/>
		<path
			d="M97.0759 109.045C97.0759 108.892 97.015 108.745 96.9066 108.636C96.7982 108.528 96.6511 108.467 96.4977 108.467C96.3444 108.467 96.1973 108.528 96.0889 108.636C95.9804 108.745 95.9195 108.892 95.9195 109.045V111.936H94.1849C94.0315 111.936 93.8845 111.997 93.776 112.106C93.6676 112.214 93.6067 112.361 93.6067 112.515C93.6067 112.668 93.6676 112.815 93.776 112.923C93.8845 113.032 94.0315 113.093 94.1849 113.093H96.4977C96.6511 113.093 96.7982 113.032 96.9066 112.923C97.015 112.815 97.0759 112.668 97.0759 112.515V109.045Z"
			fill="#DD2E44"
		/>
		<path
			d="M93.7997 121.766C92.7358 121.766 91.8719 120.903 91.8719 119.838V117.687C91.1433 117.037 90.5605 116.24 90.1619 115.348C89.7633 114.457 89.5579 113.491 89.5591 112.514C89.5591 110.459 90.4518 108.613 91.8719 107.343V105.191C91.8719 104.127 92.7346 103.263 93.7997 103.263H99.1955C100.259 103.263 101.123 104.126 101.123 105.191V107.342C102.299 108.392 103.081 109.811 103.341 111.366C103.424 111.353 103.509 111.357 103.589 111.38C103.67 111.402 103.745 111.442 103.809 111.496C103.873 111.55 103.924 111.618 103.96 111.694C103.995 111.77 104.014 111.852 104.014 111.936V113.093C104.014 113.177 103.996 113.259 103.961 113.336C103.925 113.412 103.874 113.479 103.81 113.534C103.746 113.588 103.671 113.627 103.59 113.65C103.509 113.672 103.424 113.676 103.341 113.663C103.081 115.217 102.299 116.637 101.123 117.687V119.838C101.123 120.902 100.261 121.766 99.1955 121.766H93.7997ZM102.28 112.514C102.28 110.981 101.67 109.51 100.586 108.426C99.5018 107.341 98.0311 106.732 96.4976 106.732C94.9641 106.732 93.4934 107.341 92.409 108.426C91.3247 109.51 90.7155 110.981 90.7155 112.514C90.7155 114.048 91.3247 115.519 92.409 116.603C93.4934 117.687 94.9641 118.296 96.4976 118.296C98.0311 118.296 99.5018 117.687 100.586 116.603C101.67 115.519 102.28 114.048 102.28 112.514Z"
			fill="#DD2E44"
		/>
		<path
			d="M48.5005 55.5531C48.5005 49.5143 53.3998 44.6188 59.4435 44.6188H62.7264C68.77 44.6188 73.6693 49.5143 73.6693 55.5531V59.4583C73.6693 65.4972 68.77 70.3926 62.7264 70.3926H59.4435C53.3998 70.3926 48.5005 65.4972 48.5005 59.4583V55.5531Z"
			fill="url(#paint0_linear_132_140)"
		/>
		<path
			d="M63.9397 54.4519C63.1618 53.7235 62.1522 53.3242 61.0812 53.3251C59.1538 53.3268 57.4898 54.6484 57.0304 56.4816C56.9969 56.6151 56.878 56.7093 56.7404 56.7093H55.3145C55.1279 56.7093 54.9862 56.54 55.0207 56.3566C55.5591 53.4974 58.0694 51.3344 61.085 51.3344C62.7385 51.3344 64.2401 51.9848 65.348 53.0436L66.2367 52.1548C66.613 51.7786 67.2562 52.0451 67.2562 52.5771V55.9131C67.2562 56.2429 66.9889 56.5103 66.659 56.5103H63.3231C62.791 56.5103 62.5246 55.867 62.9008 55.4907L63.9397 54.4519ZM55.511 58.501H58.8469C59.379 58.501 59.6455 59.1443 59.2692 59.5205L58.2303 60.5594C59.0083 61.2878 60.0179 61.6871 61.0889 61.6861C63.0154 61.6844 64.68 60.3637 65.1397 58.5296C65.1731 58.3962 65.292 58.302 65.4296 58.302H66.8556C67.0421 58.302 67.1839 58.4713 67.1494 58.6547C66.6109 61.5138 64.1006 63.6768 61.085 63.6768C59.4315 63.6768 57.93 63.0265 56.822 61.9677L55.9333 62.8564C55.5571 63.2326 54.9138 62.9662 54.9138 62.4341V59.0982C54.9138 58.7684 55.1812 58.501 55.511 58.501Z"
			fill="white"
		/>
		<defs>
			<linearGradient
				id="paint0_linear_132_140"
				x1="61.0849"
				y1="44.6188"
				x2="61.0849"
				y2="70.3926"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#25CD52" />
				<stop offset="1" stop-color="#34A853" />
			</linearGradient>
		</defs>
	</svg>
);

export const book = (
	<svg
		width="59"
		height="46"
		viewBox="0 0 59 46"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M44.2701 0.486084C39.0382 0.486084 33.4038 1.5593 29.5134 4.51064C25.623 1.5593 19.9886 0.486084 14.7567 0.486084C10.8663 0.486084 6.73442 1.07635 3.27331 2.60568C1.31469 3.49109 0 5.39604 0 7.5693V37.834C0 41.3219 3.27331 43.8976 6.65393 43.0391C9.28331 42.3683 12.0737 42.0732 14.7567 42.0732C18.9422 42.0732 23.3961 42.7708 26.9914 44.5416C28.6012 45.3465 30.4256 45.3465 32.0086 44.5416C35.6039 42.7439 40.0578 42.0732 44.2433 42.0732C46.9263 42.0732 49.7167 42.3683 52.3461 43.0391C55.7267 43.9245 59 41.3487 59 37.834V7.5693C59 5.39604 57.6853 3.49109 55.7267 2.60568C52.2924 1.07635 48.1605 0.486084 44.2701 0.486084ZM53.6608 34.6412C53.6608 36.3315 52.1046 37.5657 50.4411 37.2705C48.4288 36.8949 46.3361 36.7339 44.2701 36.7339C39.709 36.7339 33.1355 38.4779 29.5134 40.7585V9.87672C33.1355 7.59613 39.709 5.85216 44.2701 5.85216C46.7385 5.85216 49.1801 6.09363 51.5143 6.60341C52.7485 6.87171 53.6608 7.97176 53.6608 9.23279V34.6412Z"
			fill="url(#paint0_linear_2854_839)"
		/>
		<path
			d="M34.8258 17.9527C33.9673 17.9527 33.1892 17.4161 32.9209 16.5575C32.5721 15.5111 33.1624 14.3574 34.2087 14.0354C38.3406 12.6939 43.6799 12.2646 48.5898 12.8281C49.6899 12.9622 50.4948 13.955 50.3606 15.055C50.2265 16.155 49.2338 16.96 48.1337 16.8258C43.7872 16.316 39.0382 16.7185 35.4429 17.8722C35.2283 17.899 35.0137 17.9527 34.8258 17.9527ZM34.8258 25.0896C33.9673 25.0896 33.1892 24.553 32.9209 23.6944C32.5721 22.648 33.1624 21.4943 34.2087 21.1723C38.3138 19.8308 43.6799 19.4015 48.5898 19.965C49.6899 20.0991 50.4948 21.0918 50.3606 22.1919C50.2265 23.2919 49.2338 24.0968 48.1337 23.9627C43.7872 23.4529 39.0382 23.8554 35.4429 25.0091C35.2412 25.0605 35.034 25.0875 34.8258 25.0896ZM34.8258 32.2264C33.9673 32.2264 33.1892 31.6898 32.9209 30.8313C32.5721 29.7849 33.1624 28.6312 34.2087 28.3092C38.3138 26.9677 43.6799 26.5384 48.5898 27.1018C49.6899 27.236 50.4948 28.2287 50.3606 29.3288C50.2265 30.4288 49.2338 31.2069 48.1337 31.0996C43.7872 30.5898 39.0382 30.9922 35.4429 32.146C35.2412 32.1974 35.034 32.2244 34.8258 32.2264Z"
			fill="url(#paint1_linear_2854_839)"
		/>
		<defs>
			<linearGradient
				id="paint0_linear_2854_839"
				x1="-52.4316"
				y1="-20.099"
				x2="2.48406"
				y2="80.5656"
				gradientUnits="userSpaceOnUse"
			>
				<stop offset="0.00359712" stop-color="#514EFF" />
				<stop offset="1" stop-color="#9571F6" />
			</linearGradient>
			<linearGradient
				id="paint1_linear_2854_839"
				x1="17.2199"
				y1="3.53352"
				x2="45.2894"
				y2="38.3454"
				gradientUnits="userSpaceOnUse"
			>
				<stop offset="0.00359712" stop-color="#514EFF" />
				<stop offset="1" stop-color="#9571F6" />
			</linearGradient>
		</defs>
	</svg>
);

export const videoPlay = (
	<svg
		width="55"
		height="45"
		viewBox="0 0 55 45"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M50.6334 3.16432C50.3251 1.95336 48.8279 0.965332 47.3032 0.965332H7.69951C6.17206 0.965332 4.67487 1.95336 4.36938 3.16432L3.8162 6.46967H51.1838L50.6334 3.16432ZM53.4048 9.22184H1.5952C1.3729 9.22199 1.15308 9.26857 0.949829 9.35859C0.746575 9.44861 0.564365 9.5801 0.414871 9.74462C0.265376 9.90914 0.151893 10.1031 0.08169 10.314C0.0114874 10.5249 -0.0138866 10.7482 0.00719339 10.9695L2.54745 43.0845C2.59805 43.6087 2.84198 44.0952 3.23171 44.4493C3.62143 44.8034 4.12903 44.9998 4.65561 45.0001H50.3444C50.871 44.9998 51.3786 44.8034 51.7683 44.4493C52.158 44.0952 52.4019 43.6087 52.4525 43.0845L54.9928 10.9695C55.0139 10.7482 54.9885 10.5249 54.9183 10.314C54.8481 10.1031 54.7346 9.90914 54.5851 9.74462C54.4356 9.5801 54.2534 9.44861 54.0502 9.35859C53.8469 9.26857 53.6271 9.22199 53.4048 9.22184ZM21.997 33.9914V20.2305L34.0598 27.111L21.997 33.9914Z"
			fill="url(#paint0_linear_2854_832)"
		/>
		<defs>
			<linearGradient
				id="paint0_linear_2854_832"
				x1="-33.6368"
				y1="-9.06092"
				x2="-16.1758"
				y2="39.2147"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#A737D5" />
				<stop offset="1" stop-color="#EF497A" />
			</linearGradient>
		</defs>
	</svg>
);

export const support = (
	<svg
		width="78"
		height="78"
		viewBox="0 0 78 78"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<circle cx="39" cy="39" r="39" fill="white" />
		<path
			d="M37.8821 19C35.3236 19 32.8699 20.0164 31.0607 21.8255C29.2516 23.6346 28.2352 26.0884 28.2352 28.6469C28.2352 31.2054 29.2516 33.6591 31.0607 35.4683C32.8699 37.2774 35.3236 38.2938 37.8821 38.2938C40.4407 38.2938 42.8944 37.2774 44.7036 35.4683C46.5127 33.6591 47.5291 31.2054 47.5291 28.6469C47.5291 26.0884 46.5127 23.6346 44.7036 21.8255C42.8944 20.0164 40.4407 19 37.8821 19ZM25.8452 40.7055C25.21 40.7029 24.5806 40.8258 23.993 41.067C23.4054 41.3083 22.8713 41.6631 22.4211 42.1113C21.971 42.5594 21.6137 43.0919 21.3699 43.6784C21.126 44.2649 21.0003 44.8938 21 45.5289C21 49.6071 23.009 52.6821 26.1491 54.6862C29.2409 56.6566 33.4084 57.5875 37.8821 57.5875C40.0045 57.5875 42.0569 57.3777 43.9597 56.9484C43.815 55.9041 43.9983 54.8189 44.5096 53.8687L44.5385 53.8156L44.7387 53.4852L46.1544 51.4087C46.6747 50.6309 47.4155 50.0262 48.2818 49.6721C49.148 49.3181 50.1003 49.2308 51.0164 49.4214L51.084 49.4359L51.4554 49.5372L52.7432 49.9665C53.134 49.5437 53.4761 49.0786 53.7634 48.5798C54.0649 48.0588 54.2843 47.5572 54.4387 47.0676L53.2811 45.9703C52.6422 45.357 52.1778 44.5849 51.9354 43.7331C51.693 42.8814 51.6813 41.9805 51.9016 41.1227C51.2846 40.8474 50.6165 40.7052 49.9408 40.7055H25.8452ZM54.3639 41.3446L55.3286 39.0752C55.7796 38.0092 56.8601 37.4304 57.9212 37.6522L58.1479 37.7101L59.3538 38.096C60.55 38.4795 61.4641 39.502 61.7607 40.7875C62.4625 43.8431 61.6208 47.5644 59.2308 51.9489C56.8456 56.3286 54.2337 58.9598 51.3903 59.8473C50.2857 60.1922 49.0991 59.9438 48.2068 59.1937L47.9728 58.9767L47.0564 58.0578C46.6714 57.6614 46.4227 57.1527 46.3463 56.6054C46.27 56.0582 46.37 55.5008 46.6319 55.0142L46.767 54.7923L48.1465 52.7665C48.3973 52.3841 48.7571 52.0857 49.1793 51.9098C49.6014 51.734 50.0667 51.6888 50.5148 51.7801L50.756 51.8452L53.3052 52.6966C54.3205 51.9248 55.1695 50.9601 55.8472 49.7904C56.4284 48.7896 56.8118 47.7766 56.9879 46.7493L57.0603 46.2331L54.9403 44.2194C54.5982 43.8859 54.3549 43.4643 54.2374 43.0013C54.12 42.5382 54.1329 42.0516 54.2747 41.5954L54.3639 41.3446Z"
			fill="#3FA3FF"
		/>
	</svg>
);

export const AdsProducts = (
	<svg
		width="214"
		height="187"
		viewBox="0 0 214 187"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<g opacity="0.1" filter="url(#filter0_f_2907_877)">
			<rect
				x="26.0232"
				y="26.3068"
				width="104.45"
				height="115.001"
				fill="#1B815C"
			/>
		</g>
		<rect
			x="25.5792"
			y="26.0001"
			width="104.437"
			height="115.744"
			rx="0.69228"
			fill="white"
		/>
		<path
			d="M25.5792 52.5092H44.6537L44.6537 141.744H27.1022C26.2611 141.744 25.5792 141.062 25.5792 140.221L25.5792 52.5092Z"
			fill="#EFEFEF"
		/>
		<path
			d="M25.5792 52.4971H47.9969C48.3793 52.4971 48.6892 52.807 48.6892 53.1894L48.6892 141.057C48.6892 141.44 48.3793 141.749 47.9969 141.749H26.2715C25.8892 141.749 25.5792 141.44 25.5792 141.057L25.5792 52.4971Z"
			fill="#EFEFEF"
		/>
		<path
			d="M54.359 55.6794L116.623 55.6794C117.005 55.6794 117.315 55.9894 117.315 56.3717V62.1821C117.315 62.5645 117.005 62.8744 116.623 62.8744L55.0513 62.8744C54.669 62.8744 54.359 62.5645 54.359 62.1821V55.6794Z"
			fill="#EFEFEF"
		/>
		<path
			d="M54.359 69.17H100.434C100.816 69.17 101.126 69.48 101.126 69.8623V75.6727C101.126 76.0551 100.816 76.365 100.434 76.365H55.0513C54.669 76.365 54.359 76.0551 54.359 75.6727V69.17Z"
			fill="#EFEFEF"
		/>
		<path
			d="M54.359 80.8617H78.8491C79.2314 80.8617 79.5414 81.1716 79.5414 81.554V87.3644C79.5414 87.7467 79.2314 88.0567 78.8491 88.0567H55.0513C54.669 88.0567 54.359 87.7467 54.359 87.3644V80.8617Z"
			fill="#EFEFEF"
		/>
		<path
			d="M54.359 92.5536H94.1384C94.5207 92.5536 94.8307 92.8635 94.8307 93.2459V99.0563C94.8307 99.4386 94.5207 99.7485 94.1384 99.7485H55.0513C54.669 99.7485 54.359 99.4386 54.359 99.0563V92.5536Z"
			fill="#EFEFEF"
		/>
		<path
			d="M54.359 104.245H112.126C112.508 104.245 112.818 104.555 112.818 104.938V110.748C112.818 111.13 112.508 111.44 112.126 111.44H55.0513C54.669 111.44 54.359 111.13 54.359 110.748V104.245Z"
			fill="#EFEFEF"
		/>
		<path
			d="M54.359 119.535H100.434C100.816 119.535 101.126 119.845 101.126 120.227V126.037C101.126 126.42 100.816 126.73 100.434 126.73H55.0513C54.669 126.73 54.359 126.42 54.359 126.037V119.535Z"
			fill="#EFEFEF"
		/>
		<path
			d="M54.359 132.126H108.528C108.911 132.126 109.221 132.436 109.221 132.818V138.629C109.221 139.011 108.911 139.321 108.528 139.321H55.0513C54.669 139.321 54.359 139.011 54.359 138.629V132.126Z"
			fill="#EFEFEF"
		/>
		<line
			x1="25.5792"
			y1="52.4745"
			x2="130.017"
			y2="52.4745"
			stroke="#ABABAB"
			stroke-width="0.069228"
		/>
		<line
			x1="25.5792"
			y1="65.7293"
			x2="130.017"
			y2="65.7293"
			stroke="#ABABAB"
			stroke-width="0.069228"
		/>
		<line
			x1="25.5792"
			y1="78.2369"
			x2="130.017"
			y2="78.2369"
			stroke="#ABABAB"
			stroke-width="0.069228"
		/>
		<line
			x1="25.5792"
			y1="90.7449"
			x2="130.017"
			y2="90.7449"
			stroke="#ABABAB"
			stroke-width="0.069228"
		/>
		<line
			x1="25.5792"
			y1="103.999"
			x2="130.017"
			y2="103.999"
			stroke="#ABABAB"
			stroke-width="0.069228"
		/>
		<line
			x1="25.5792"
			y1="116.694"
			x2="130.017"
			y2="116.694"
			stroke="#ABABAB"
			stroke-width="0.069228"
		/>
		<line
			x1="25.5792"
			y1="129.201"
			x2="130.017"
			y2="129.201"
			stroke="#ABABAB"
			stroke-width="0.069228"
		/>
		<line
			x1="48.6728"
			y1="52.5092"
			x2="48.6727"
			y2="141.744"
			stroke="#ABABAB"
			stroke-width="0.069228"
		/>
		<path
			d="M25.5792 26.6924C25.5792 26.3101 25.8892 26.0001 26.2715 26.0001L129.973 26.0001V52.4969H25.5792V26.6924Z"
			fill="#F5F5F5"
		/>
		<path
			d="M43.4813 47.7571H33.0457C32.3806 47.7571 31.8415 47.218 31.8415 46.5529V32.1035C31.8415 31.4385 32.3806 30.8994 33.0457 30.8994H40.6717L44.6855 34.9131V46.5529C44.6855 47.218 44.1464 47.7571 43.4813 47.7571Z"
			fill="#43A047"
		/>
		<path
			d="M44.6856 34.9133H40.6719V30.8995L44.6856 34.9133Z"
			fill="#C8E6C9"
		/>
		<path
			d="M40.6719 34.9132L44.6856 38.9269V34.9132H40.6719Z"
			fill="#2E7D32"
		/>
		<path
			d="M41.0732 38.9261H35.454H34.6512V39.7289V40.5316V41.3344V42.1371V42.9399V43.7426V44.5454H41.8759V43.7426V42.9399V42.1371V41.3344V40.5316V39.7289V38.9261H41.0732ZM35.454 39.7289H37.0594V40.5316H35.454V39.7289ZM35.454 41.3344H37.0594V42.1371H35.454V41.3344ZM35.454 42.9399H37.0594V43.7426H35.454V42.9399ZM41.0732 43.7426H37.8622V42.9399H41.0732V43.7426ZM41.0732 42.1371H37.8622V41.3344H41.0732V42.1371ZM41.0732 40.5316H37.8622V39.7289H41.0732V40.5316Z"
			fill="#E8F5E9"
		/>
		<path
			d="M50.4462 43.692H51.4299V41.527H52.8044C54.0472 41.527 54.9079 40.6795 54.9079 39.4411V39.4323C54.9079 38.1895 54.0472 37.3551 52.8044 37.3551H50.4462V43.692ZM52.5585 38.1851C53.4149 38.1851 53.9067 38.6462 53.9067 39.4367V39.4455C53.9067 40.2403 53.4149 40.7014 52.5585 40.7014H51.4299V38.1851H52.5585ZM55.6545 43.692H56.6031V40.9386C56.6031 40.2491 56.9807 39.8495 57.5911 39.8495C57.7756 39.8495 57.9424 39.8714 58.0171 39.9022V39.0195C57.9424 39.0063 57.8239 38.9844 57.6877 38.9844C57.1608 38.9844 56.7743 39.3225 56.625 39.8627H56.6031V39.0722H55.6545V43.692ZM60.3885 43.7842C61.7103 43.7842 62.5798 42.8708 62.5798 41.3821V41.3733C62.5798 39.8934 61.7015 38.9844 60.3841 38.9844C59.071 38.9844 58.1971 39.8978 58.1971 41.3733V41.3821C58.1971 42.8664 59.0623 43.7842 60.3885 43.7842ZM60.3929 42.9894C59.6507 42.9894 59.1677 42.4053 59.1677 41.3821V41.3733C59.1677 40.3633 59.6551 39.7792 60.3841 39.7792C61.1263 39.7792 61.6093 40.3633 61.6093 41.3733V41.3821C61.6093 42.4009 61.135 42.9894 60.3929 42.9894ZM65.039 43.7842C65.7021 43.7842 66.2116 43.4505 66.4882 42.9103H66.5058V43.692H67.4587V37.3551H66.5058V39.8583H66.4882C66.2116 39.3137 65.6846 38.9844 65.0303 38.9844C63.8709 38.9844 63.1068 39.9066 63.1068 41.3777V41.3821C63.1068 42.8532 63.8621 43.7842 65.039 43.7842ZM65.2894 42.9674C64.5384 42.9674 64.0773 42.3658 64.0773 41.3821V41.3777C64.0773 40.4028 64.5428 39.7968 65.2894 39.7968C66.0008 39.7968 66.5102 40.4204 66.5102 41.3777V41.3821C66.5102 42.3438 66.0052 42.9674 65.2894 42.9674ZM70.0058 43.7842C70.7084 43.7842 71.1783 43.4637 71.4198 42.9982H71.4418V43.692H72.3947V39.0722H71.4418V41.7686C71.4418 42.4888 71.0114 42.9674 70.3439 42.9674C69.6852 42.9674 69.3602 42.581 69.3602 41.8827V39.0722H68.4117V42.0672C68.4117 43.1299 68.9913 43.7842 70.0058 43.7842ZM75.3194 43.7842C76.4305 43.7842 77.2034 43.0728 77.3044 42.1462L77.3088 42.1155H76.3953L76.391 42.1506C76.2768 42.6512 75.9035 42.9894 75.3194 42.9894C74.5861 42.9894 74.0986 42.3965 74.0986 41.3865V41.3821C74.0986 40.394 74.5773 39.7792 75.315 39.7792C75.9342 39.7792 76.2856 40.1613 76.3866 40.6136L76.3953 40.6487H77.3L77.2956 40.618C77.2165 39.7485 76.4963 38.9844 75.3063 38.9844C73.9888 38.9844 73.1281 39.911 73.1281 41.3733V41.3777C73.1281 42.8576 73.9713 43.7842 75.3194 43.7842ZM79.6011 43.7842C79.7943 43.7842 79.9744 43.7623 80.0842 43.7447V43.0113C80.0139 43.0201 79.9305 43.0289 79.8295 43.0289C79.4298 43.0289 79.219 42.8884 79.219 42.4185V39.8275H80.0842V39.0722H79.219V37.8689H78.2485V39.0722H77.5854V39.8275H78.2485V42.4756C78.2485 43.3978 78.6877 43.7842 79.6011 43.7842ZM82.6005 43.7842C83.6896 43.7842 84.48 43.2046 84.48 42.3614V42.357C84.48 41.6939 84.1199 41.3206 83.1758 41.1011L82.4248 40.9298C81.9286 40.8112 81.7397 40.618 81.7397 40.3326V40.3282C81.7397 39.9593 82.0603 39.7177 82.5697 39.7177C83.1055 39.7177 83.4217 39.9988 83.4788 40.4028L83.4832 40.4336H84.3746L84.3702 40.3809C84.3219 39.5948 83.6632 38.9844 82.5697 38.9844C81.507 38.9844 80.7868 39.5509 80.7868 40.3765V40.3809C80.7868 41.0528 81.2216 41.4743 82.0998 41.6763L82.8552 41.8476C83.3514 41.9662 83.5183 42.1374 83.5183 42.4361V42.4405C83.5183 42.8137 83.1758 43.0509 82.6049 43.0509C82.0208 43.0509 81.7046 42.8006 81.6168 42.3746L81.608 42.3307H80.6682L80.6726 42.3702C80.7692 43.2133 81.4455 43.7842 82.6005 43.7842Z"
			fill="#216124"
		/>
		<g opacity="0.1" filter="url(#filter1_f_2907_877)">
			<rect
				x="86.1611"
				y="64.2886"
				width="102.34"
				height="97.0648"
				fill="#1B815C"
			/>
		</g>
		<rect
			x="87.8808"
			y="64.2886"
			width="101.119"
			height="96.8163"
			rx="5.68346"
			fill="#FBFFFD"
		/>
		<path
			d="M121.208 76.5122C121.208 72.2768 124.641 68.8434 128.876 68.8434H145.91C150.146 68.8434 153.579 72.2768 153.579 76.5122V80.6218C153.579 83.0824 151.572 85.0703 149.111 85.0462L143.788 84.9941C143.083 84.9872 142.605 85.7084 142.887 86.3543C143.252 87.194 142.36 88.027 141.547 87.6053L137.296 85.3991C136.916 85.2021 136.495 85.0992 136.067 85.0989L128.872 85.0945C124.638 85.092 121.208 81.6593 121.208 77.4257V76.5122Z"
			fill="white"
		/>
		<path
			fill-rule="evenodd"
			clip-rule="evenodd"
			d="M149.764 69.5491H125.185C123.63 69.5491 122.37 70.7951 122.383 72.3074V81.5018C122.383 83.0261 123.642 84.2601 125.197 84.2601H136.839L142.16 87.1635L140.95 84.2601H149.764C151.32 84.2601 152.579 83.0261 152.579 81.5018V72.3074C152.579 70.783 151.32 69.5491 149.764 69.5491ZM124.667 71.6783C124.321 71.7025 124.062 71.8235 123.889 72.0533C123.716 72.2711 123.654 72.5493 123.691 72.8639C124.42 77.4006 125.099 80.4613 125.728 82.0462C125.975 82.6268 126.259 82.9051 126.592 82.881C127.111 82.8446 127.728 82.143 128.457 80.7759C128.839 80.0016 129.432 78.8403 130.234 77.2917C130.901 79.5782 131.814 81.2961 132.962 82.4454C133.283 82.772 133.617 82.9172 133.938 82.893C134.222 82.8688 134.444 82.7236 134.592 82.4575C134.715 82.2276 134.765 81.9614 134.74 81.659C134.666 80.5581 134.777 79.0217 135.086 77.0497C135.407 75.0173 135.802 73.5535 136.283 72.6824C136.382 72.5009 136.419 72.3195 136.407 72.1017C136.382 71.8235 136.259 71.5936 136.024 71.4121C135.79 71.2307 135.53 71.146 135.246 71.1702C134.888 71.1944 134.617 71.3637 134.432 71.7025C133.666 73.0695 133.123 75.2835 132.802 78.3563C132.333 77.1949 131.938 75.8279 131.629 74.2188C131.493 73.5051 131.16 73.1663 130.617 73.2026C130.247 73.2268 129.938 73.4688 129.691 73.9285L126.987 78.9733C126.543 77.2191 126.123 75.0778 125.741 72.5493C125.654 71.9203 125.296 71.6299 124.667 71.6783ZM148.456 72.5494C149.332 72.7308 149.986 73.1906 150.431 73.9527C150.826 74.606 151.023 75.3924 151.023 76.336C151.023 77.5821 150.702 78.7193 150.06 79.7597C149.32 80.9695 148.357 81.5744 147.159 81.5744C146.95 81.5744 146.727 81.5502 146.493 81.5018C145.616 81.3203 144.962 80.8606 144.517 80.0985C144.122 79.4331 143.925 78.6346 143.925 77.703C143.925 76.457 144.246 75.3198 144.888 74.2915C145.641 73.0817 146.604 72.4768 147.789 72.4768C147.999 72.4768 148.221 72.501 148.456 72.5494ZM147.937 79.0943C148.394 78.6951 148.703 78.1023 148.875 77.3038C148.925 77.0256 148.962 76.7231 148.962 76.4086C148.962 76.0578 148.888 75.6827 148.74 75.3077C148.554 74.8359 148.307 74.5818 148.011 74.5213C147.567 74.4366 147.135 74.6786 146.727 75.2714C146.394 75.7311 146.184 76.215 146.073 76.711C146.011 76.9893 145.987 77.2918 145.987 77.5942C145.987 77.945 146.061 78.32 146.209 78.6951C146.394 79.1669 146.641 79.4209 146.937 79.4815C147.246 79.5419 147.579 79.4089 147.937 79.0943ZM142.69 73.9527C142.246 73.1906 141.579 72.7308 140.715 72.5494C140.481 72.501 140.258 72.4768 140.049 72.4768C138.863 72.4768 137.901 73.0817 137.147 74.2915C136.505 75.3198 136.185 76.457 136.185 77.703C136.185 78.6346 136.382 79.4331 136.777 80.0985C137.222 80.8606 137.876 81.3203 138.752 81.5018C138.987 81.5502 139.209 81.5744 139.419 81.5744C140.616 81.5744 141.579 80.9695 142.32 79.7597C142.962 78.7193 143.283 77.5821 143.283 76.336C143.283 75.3924 143.085 74.606 142.69 73.9527ZM141.135 77.3038C140.962 78.1023 140.653 78.6951 140.197 79.0943C139.839 79.4089 139.505 79.5419 139.197 79.4815C138.9 79.4209 138.654 79.1669 138.468 78.6951C138.32 78.32 138.246 77.945 138.246 77.5942C138.246 77.2918 138.271 76.9893 138.333 76.711C138.444 76.215 138.654 75.7311 138.987 75.2714C139.394 74.6786 139.826 74.4366 140.271 74.5213C140.567 74.5818 140.814 74.8359 140.999 75.3077C141.147 75.6827 141.221 76.0578 141.221 76.4086C141.221 76.7231 141.197 77.0256 141.135 77.3038Z"
			fill="#7F54B3"
		/>
		<rect
			opacity="0.3"
			x="107.643"
			y="90.7106"
			width="27.7361"
			height="27.3894"
			fill="#C4C4C4"
		/>
		<rect
			opacity="0.3"
			x="143.7"
			y="124.341"
			width="27.7361"
			height="27.3894"
			fill="#C4C4C4"
		/>
		<rect
			x="107.792"
			y="124.491"
			width="27.4369"
			height="27.0902"
			rx="1.34608"
			fill="#FFF2F3"
			stroke="#FF919F"
			stroke-width="0.299129"
		/>
		<rect
			x="143.849"
			y="90.8605"
			width="27.4369"
			height="27.0902"
			rx="1.34608"
			fill="#EAFAFF"
			stroke="#71DCFF"
			stroke-width="0.299129"
		/>
		<path
			d="M162.583 108.818C160.448 112.734 160.48 113.057 159.477 112.475C158.474 111.892 158.085 111.375 160.253 107.492C162.421 103.609 163.036 103.641 164.039 104.223C165.01 104.774 164.719 104.935 162.583 108.818Z"
			fill="#454749"
		/>
		<path
			d="M164.589 109.983C163.23 112.475 161.548 113.672 160.739 113.219C159.736 112.637 160.253 112.637 162.389 108.721C164.525 104.806 164.266 104.353 165.269 104.935C166.078 105.388 165.948 107.492 164.589 109.983Z"
			fill="#258399"
		/>
		<path
			d="M152.552 108.818C154.688 112.734 154.655 113.057 155.658 112.475C156.661 111.892 157.05 111.375 154.882 107.492C152.714 103.609 152.099 103.641 151.096 104.223C150.125 104.774 150.416 104.935 152.552 108.818Z"
			fill="#454749"
		/>
		<path
			d="M150.546 109.983C151.905 112.475 153.587 113.672 154.396 113.219C155.399 112.637 154.882 112.637 152.746 108.721C150.61 104.806 150.869 104.353 149.866 104.935C149.057 105.388 149.187 107.492 150.546 109.983Z"
			fill="#258399"
		/>
		<path
			d="M150.869 112.896C150.869 112.896 152.617 113.349 152.746 112.896C153.555 110.275 149.057 108.721 149.057 105.744C149.057 100.955 152.876 97.0722 157.568 97.0722C162.26 97.0722 166.078 100.955 166.078 105.744C166.078 108.721 161.58 110.275 162.389 112.896C162.519 113.349 164.266 112.896 164.266 112.896C166.11 111.084 167.275 108.56 167.275 105.744C167.275 100.276 162.939 95.8425 157.568 95.8425C152.196 95.8425 147.86 100.276 147.86 105.744C147.86 108.56 149.025 111.084 150.869 112.896Z"
			fill="#3BAACF"
		/>
		<path
			d="M152.034 99.9194C153.167 99.6929 154.623 98.0749 157.568 98.0749C160.512 98.0749 162.001 99.7252 163.101 99.9194C163.554 100.016 164.331 99.3045 164.331 99.3045C162.551 97.2659 160.448 96.2305 157.568 96.2305C154.688 96.2305 152.584 97.2659 150.805 99.3045C150.805 99.3369 151.581 100.016 152.034 99.9194Z"
			fill="#454749"
		/>
		<path
			d="M122.076 135.045C122.076 134.892 122.015 134.745 121.906 134.637C121.798 134.528 121.651 134.467 121.498 134.467C121.344 134.467 121.197 134.528 121.089 134.637C120.98 134.745 120.919 134.892 120.919 135.045V137.936H119.185C119.031 137.936 118.884 137.997 118.776 138.106C118.667 138.214 118.607 138.361 118.607 138.515C118.607 138.668 118.667 138.815 118.776 138.923C118.884 139.032 119.031 139.093 119.185 139.093H121.498C121.651 139.093 121.798 139.032 121.906 138.923C122.015 138.815 122.076 138.668 122.076 138.515V135.045Z"
			fill="#DD2E44"
		/>
		<path
			d="M118.8 147.766C117.736 147.766 116.872 146.903 116.872 145.838V143.687C116.143 143.037 115.56 142.24 115.162 141.348C114.763 140.457 114.558 139.491 114.559 138.515C114.559 136.46 115.452 134.613 116.872 133.343V131.191C116.872 130.127 117.734 129.263 118.8 129.263H124.195C125.259 129.263 126.123 130.126 126.123 131.191V133.342C127.299 134.392 128.081 135.811 128.341 137.366C128.424 137.353 128.509 137.358 128.589 137.38C128.67 137.402 128.745 137.442 128.809 137.496C128.873 137.551 128.924 137.618 128.96 137.694C128.995 137.77 129.014 137.853 129.014 137.936V139.093C129.014 139.177 128.996 139.26 128.961 139.336C128.925 139.412 128.874 139.479 128.81 139.534C128.746 139.588 128.671 139.628 128.59 139.65C128.509 139.672 128.424 139.677 128.341 139.663C128.081 141.218 127.299 142.637 126.123 143.687V145.838C126.123 146.902 125.26 147.766 124.195 147.766H118.8ZM127.28 138.515C127.28 136.981 126.67 135.51 125.586 134.426C124.502 133.342 123.031 132.732 121.497 132.732C119.964 132.732 118.493 133.342 117.409 134.426C116.325 135.51 115.715 136.981 115.715 138.515C115.715 140.048 116.325 141.519 117.409 142.603C118.493 143.687 119.964 144.297 121.497 144.297C123.031 144.297 124.502 143.687 125.586 142.603C126.67 141.519 127.28 140.048 127.28 138.515Z"
			fill="#DD2E44"
		/>
		<path
			d="M73.5005 81.5533C73.5005 75.5144 78.3999 70.6189 84.4435 70.6189H87.7264C93.77 70.6189 98.6694 75.5144 98.6694 81.5533V85.4584C98.6694 91.4973 93.77 96.3928 87.7264 96.3928H84.4435C78.3999 96.3928 73.5005 91.4973 73.5005 85.4584V81.5533Z"
			fill="url(#paint0_linear_2907_877)"
		/>
		<path
			d="M88.9397 80.4521C88.1618 79.7236 87.1522 79.3244 86.0812 79.3253C84.1538 79.327 82.4898 80.6486 82.0303 82.4818C81.9969 82.6153 81.878 82.7095 81.7404 82.7095H80.3145C80.1279 82.7095 79.9862 82.5401 80.0207 82.3568C80.5591 79.4976 83.0694 77.3346 86.085 77.3346C87.7385 77.3346 89.2401 77.985 90.348 79.0437L91.2367 78.155C91.6129 77.7788 92.2562 78.0453 92.2562 78.5773V81.9132C92.2562 82.2431 91.9888 82.5104 91.659 82.5104H88.3231C87.791 82.5104 87.5246 81.8672 87.9008 81.4909L88.9397 80.4521ZM80.511 84.5012H83.8469C84.379 84.5012 84.6454 85.1444 84.2692 85.5207L83.2303 86.5596C84.0082 87.288 85.0179 87.6873 86.0889 87.6863C88.0153 87.6846 89.68 86.3639 90.1397 84.5298C90.1731 84.3964 90.292 84.3021 90.4296 84.3021H91.8555C92.0421 84.3021 92.1838 84.4715 92.1493 84.6549C91.6109 87.514 89.1006 89.677 86.085 89.677C84.4315 89.677 82.9299 89.0266 81.822 87.9679L80.9333 88.8566C80.5571 89.2328 79.9138 88.9664 79.9138 88.4343V85.0984C79.9138 84.7685 80.1812 84.5012 80.511 84.5012Z"
			fill="white"
		/>
		<defs>
			<filter
				id="filter0_f_2907_877"
				x="0.701912"
				y="0.985512"
				width="155.093"
				height="165.643"
				filterUnits="userSpaceOnUse"
				color-interpolation-filters="sRGB"
			>
				<feFlood flood-opacity="0" result="BackgroundImageFix" />
				<feBlend
					mode="normal"
					in="SourceGraphic"
					in2="BackgroundImageFix"
					result="shape"
				/>
				<feGaussianBlur
					stdDeviation="12.6606"
					result="effect1_foregroundBlur_2907_877"
				/>
			</filter>
			<filter
				id="filter1_f_2907_877"
				x="60.8399"
				y="38.9673"
				width="152.983"
				height="147.707"
				filterUnits="userSpaceOnUse"
				color-interpolation-filters="sRGB"
			>
				<feFlood flood-opacity="0" result="BackgroundImageFix" />
				<feBlend
					mode="normal"
					in="SourceGraphic"
					in2="BackgroundImageFix"
					result="shape"
				/>
				<feGaussianBlur
					stdDeviation="12.6606"
					result="effect1_foregroundBlur_2907_877"
				/>
			</filter>
			<linearGradient
				id="paint0_linear_2907_877"
				x1="86.0849"
				y1="70.6189"
				x2="86.0849"
				y2="96.3928"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#25CD52" />
				<stop offset="1" stop-color="#34A853" />
			</linearGradient>
		</defs>
	</svg>
);

export const TrashCan = (
	<svg
		width="133"
		height="131"
		viewBox="0 0 133 131"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			fill-rule="evenodd"
			clip-rule="evenodd"
			d="M61.2003 0.0460557C90.3852 -0.886378 120.219 12.3367 129.638 39.9755C139.418 68.6725 125.74 99.465 101.106 117.137C76.9495 134.466 44.0949 136.321 20.444 118.309C-1.81872 101.354 -4.10116 70.414 5.01657 43.9571C13.5787 19.1124 34.9351 0.885209 61.2003 0.0460557Z"
			fill="#FAFAFA"
		/>
		<path
			d="M34.6494 50.915L39.8253 102.482C40.1121 104.662 50.5768 111.828 65.7285 111.838C80.8896 111.828 91.3543 104.662 91.6364 102.482L96.817 50.915C88.9003 55.3683 77.0676 57.472 65.7285 57.472C54.3988 57.472 42.5614 55.3683 34.6494 50.915ZM80.6216 24.427L76.5834 19.9312C75.0226 17.6951 73.3302 17.2886 70.0347 17.2886H61.427C58.1362 17.2886 56.4391 17.6951 54.883 19.9312L50.8448 24.427C38.7629 26.5497 30 32.1801 30 36.3355V37.1392C30 44.4526 45.9979 50.3808 65.7285 50.3808C85.4638 50.3808 101.462 44.4526 101.462 37.1392V36.3355C101.462 32.1801 92.7035 26.5497 80.6216 24.427ZM75.4598 37.8058L70.4296 31.471H61.0274L56.0066 37.8058H48.0147C48.0147 37.8058 56.7682 27.3061 57.9387 25.8831C58.832 24.7958 59.744 24.3798 60.9287 24.3798H70.533C71.7224 24.3798 72.6344 24.7958 73.5276 25.8831C74.6935 27.3061 83.4517 37.8058 83.4517 37.8058H75.4598Z"
			fill="#EBECEE"
		/>
	</svg>
);

export const Cross = (
	<svg
		width="17"
		height="17"
		viewBox="0 0 17 17"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M8.5 8.5L16 16M1 16L8.5 8.5L1 16ZM16 1L8.49857 8.5L16 1ZM8.49857 8.5L1 1L8.49857 8.5Z"
			stroke="#575757"
			stroke-width="1.5"
			stroke-linecap="round"
			stroke-linejoin="round"
		/>
	</svg>
);

export const Backbtn = (
	<svg
		width="10"
		height="19"
		viewBox="0 0 10 19"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M9.37659 18.25C9.53474 18.25 9.69658 18.1913 9.81795 18.0772C10.0607 17.8492 10.0607 17.476 9.81795 17.2479L1.50975 9.44212L9.69658 1.75034C9.93932 1.52229 9.93932 1.1491 9.69658 0.921043C9.45384 0.692985 9.05664 0.692985 8.8139 0.921043L0.182052 9.02747C-0.0606845 9.25553 -0.0606845 9.62871 0.182052 9.85677L8.93159 18.0772C9.05664 18.1947 9.21477 18.25 9.37659 18.25Z"
			fill="black"
		/>
	</svg>
);

export const Cloud = (
	<svg
		width="123"
		height="116"
		viewBox="0 0 123 116"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M9.1579 97.6842C11.5867 97.6842 13.9161 98.6491 15.6335 100.367C17.351 102.084 18.3158 104.413 18.3158 106.842C18.3158 109.271 17.351 111.6 15.6335 113.318C13.9161 115.035 11.5867 116 9.1579 116C6.72907 116 4.39973 115.035 2.68229 113.318C0.964848 111.6 0 109.271 0 106.842C0 104.413 0.964848 102.084 2.68229 100.367C4.39973 98.6491 6.72907 97.6842 9.1579 97.6842ZM39.6842 79.3685C43.7323 79.3685 47.6145 80.9765 50.4769 83.8389C53.3393 86.7013 54.9474 90.5836 54.9474 94.6316C54.9474 98.6797 53.3393 102.562 50.4769 105.424C47.6145 108.287 43.7323 109.895 39.6842 109.895C35.6362 109.895 31.7539 108.287 28.8915 105.424C26.0291 102.562 24.4211 98.6797 24.4211 94.6316C24.4211 90.5836 26.0291 86.7013 28.8915 83.8389C31.7539 80.9765 35.6362 79.3685 39.6842 79.3685ZM76.3158 73.2632C69.0506 73.2632 62.4569 70.2106 58 65.0211C53.5432 70.2106 46.9495 73.2632 39.6842 73.2632C27.7179 73.2632 17.7663 64.6548 15.6905 53.36C11.0798 51.5769 7.11504 48.4431 4.31535 44.3688C1.51565 40.2945 0.0115481 35.4698 0 30.5263C0 24.0495 2.57293 17.8379 7.15276 13.258C11.7326 8.67819 17.9442 6.10527 24.4211 6.10527C26.0084 6.10527 27.4737 6.28842 29.1221 6.53264C33.579 2.50316 39.379 0 45.7895 0C53.0548 0 59.6484 3.05263 64.1053 8.24211C68.5621 3.05263 75.1558 0 82.4211 0C94.3874 0 104.339 8.60843 106.415 19.9032C111.025 21.6862 114.99 24.8201 117.79 28.8944C120.59 32.9686 122.094 37.7934 122.105 42.7369C122.105 49.2137 119.532 55.4253 114.953 60.0052C110.373 64.585 104.161 67.1579 97.6842 67.1579L92.9832 66.7306C88.5264 70.76 82.7263 73.2632 76.3158 73.2632Z"
			fill="#DDE4E8"
		/>
	</svg>
);

export const Merge = (
	<svg
		fill="#c2c2c2"
		width="65px"
		height="65px"
		viewBox="0 0 1920 1920"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M1740 0c99.24 0 180 80.76 180 180v1560c0 99.24-80.76 180-180 180H180c-99.24 0-180-80.76-180-180V180C0 80.76 80.76 0 180 0h1560Zm60 600V180c0-33-27-60-60-60h-420v480h480Zm0 1065V720H720v1080h945c74.25 0 135-60.75 135-135ZM720 600h480V120H720v480Zm-120 0V120H180c-33 0-60 27-60 60v420h480Zm-480 600h480V720H120v480Zm480 600v-480H120v420c0 33 27 60 60 60h420Z"
			fill-rule="evenodd"
		/>
	</svg>
);

export const createTable = (
	<svg
		width="175"
		height="116"
		viewBox="0 0 175 116"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<rect
			x="49.5375"
			width="41.7838"
			height="17.8277"
			rx="2.46577"
			fill="#D0DAE0"
		/>
		<path
			d="M49.5375 1.67135C49.5375 0.748287 50.2858 0 51.2089 0H89.65C90.573 0 91.3213 0.748289 91.3213 1.67135V17.8277H49.5375V1.67135Z"
			fill="#C3D1DA"
		/>
		<rect
			x="25.5907"
			width="41.7838"
			height="17.8277"
			rx="2.46577"
			fill="#C4D2DA"
		/>
		<path
			d="M25.5907 1.67135C25.5907 0.748287 26.339 0 27.262 0H65.7031C66.6261 0 67.3744 0.748289 67.3744 1.67135V17.8277H25.5907V1.67135Z"
			fill="#D0DAE0"
		/>
		<path
			d="M0 1.67135C0 0.748287 0.748289 0 1.67135 0H40.1124C41.0355 0 41.7838 0.748289 41.7838 1.67135V17.8277H0V1.67135Z"
			fill="#DDE4E8"
		/>
		<path
			fill-rule="evenodd"
			clip-rule="evenodd"
			d="M164.385 16.4385H0V113.425C0 114.333 0.735975 115.069 1.64385 115.069H164.385C165.293 115.069 166.029 114.333 166.029 113.425V18.0823C166.029 17.1745 165.293 16.4385 164.385 16.4385ZM159.453 23.0139H5.75348V107.672C5.75348 108.58 6.48945 109.316 7.39732 109.316H159.453C160.361 109.316 161.097 108.58 161.097 107.672V24.6577C161.097 23.7499 160.361 23.0139 159.453 23.0139Z"
			fill="#DDE4E8"
		/>
		<rect
			opacity="0.2"
			x="11.6526"
			y="29.8599"
			width="54.6215"
			height="13.8374"
			rx="1.45657"
			fill="#D0DAE0"
		/>
		<rect
			opacity="0.2"
			x="72.8287"
			y="29.8599"
			width="82.2964"
			height="13.8374"
			rx="1.45657"
			fill="#D0DAE0"
		/>
		<rect
			opacity="0.2"
			x="11.6526"
			y="49.5234"
			width="54.6215"
			height="13.8374"
			rx="1.45657"
			fill="#D0DAE0"
		/>
		<rect
			opacity="0.2"
			x="72.8287"
			y="49.5234"
			width="82.2964"
			height="13.8374"
			rx="1.45657"
			fill="#D0DAE0"
		/>
		<rect
			opacity="0.2"
			x="11.6526"
			y="69.1875"
			width="54.6215"
			height="13.8374"
			rx="1.45657"
			fill="#D0DAE0"
		/>
		<rect
			opacity="0.2"
			x="72.8287"
			y="69.1875"
			width="82.2964"
			height="13.8374"
			rx="1.45657"
			fill="#D0DAE0"
		/>
		<rect
			opacity="0.2"
			x="11.6526"
			y="88.8511"
			width="54.6215"
			height="13.8374"
			rx="1.45657"
			fill="#D0DAE0"
		/>
		<rect
			opacity="0.2"
			x="72.8287"
			y="88.8511"
			width="82.2964"
			height="13.8374"
			rx="1.45657"
			fill="#D0DAE0"
		/>
		<circle cx="151" cy="32" r="24" fill="white" />
		<path
			d="M162.025 30.2815H154.05V22.3064C154.05 19.2312 149.281 19.2312 149.281 22.3064V30.2815H141.306C138.231 30.2815 138.231 35.0507 141.306 35.0507H149.281V43.0258C149.281 46.1011 154.05 46.1011 154.05 43.0258V35.0507H162.025C165.1 35.0507 165.1 30.2815 162.025 30.2815Z"
			fill="#DDE4E8"
		/>
	</svg>
);

export const Desktop = (
	<svg
		width="353"
		height="192"
		viewBox="0 0 353 192"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<mask
			id="mask0_2828_1824"
			maskUnits="userSpaceOnUse"
			x="0"
			y="0"
			width="353"
			height="192"
		>
			<rect width="353" height="192" fill="#D9D9D9" />
		</mask>
		<g mask="url(#mask0_2828_1824)">
			<path
				opacity="0.2"
				d="M51 170.904L51.5033 182.536L307.698 183.562L308 170.562L51 170.904Z"
				fill="#3EA9CE"
			/>
			<path
				d="M17 164.562L342 165.229V171.562L17.5682 171.229L17 164.562Z"
				fill="#6CC9E9"
			/>
			<path
				d="M110.417 149.903H184.379C184.379 149.903 187.147 149.758 187.147 146.552V140.191H107.503V147.912C107.892 149.126 109.057 149.952 110.417 149.903Z"
				fill="#56B0E2"
			/>
			<path
				d="M107.503 92.1131L107.455 142.619L187.147 141.89V90.6562C187.147 90.6562 187.632 87.7424 184.524 87.7424H110.514C110.514 87.7424 107.163 87.7424 107.503 92.1131Z"
				fill="#4F75CD"
			/>
			<path
				d="M141.012 163.452V149.417L152.667 149.903V162.238L141.012 163.452Z"
				fill="#517CD0"
			/>
			<path
				d="M122.509 162.044H170.927L170.975 164.472H122.509V162.044Z"
				fill="#4F75CD"
			/>
			<path
				d="M146.597 143.639C147.908 143.639 148.928 144.658 148.928 145.97C148.928 147.281 147.908 148.301 146.597 148.301C145.285 148.301 144.266 147.281 144.266 145.97C144.266 144.658 145.334 143.639 146.597 143.639Z"
				fill="white"
			/>
			<path
				d="M184.719 90.17H109.931V139.219H184.719V90.17Z"
				fill="#F8F8FF"
			/>
			<path
				d="M113.671 92.6957C114.302 92.6957 114.836 93.2299 114.836 93.8612C114.836 94.4925 114.302 95.0267 113.671 95.0267C113.039 95.0267 112.505 94.4925 112.505 93.8612C112.505 93.2299 113.039 92.6957 113.671 92.6957Z"
				fill="#FA5F5D"
			/>
			<path
				d="M117.653 92.6957C118.284 92.6957 118.819 93.2299 118.819 93.8612C118.819 94.4925 118.284 95.0267 117.653 95.0267C117.022 95.0267 116.488 94.4925 116.488 93.8612C116.488 93.2299 117.022 92.6957 117.653 92.6957Z"
				fill="#FDBC4E"
			/>
			<path
				d="M121.829 92.6957C122.461 92.6957 122.995 93.2299 122.995 93.8612C122.995 94.4925 122.461 95.0267 121.829 95.0267C121.198 95.0267 120.664 94.4925 120.664 93.8612C120.664 93.2299 121.198 92.6957 121.829 92.6957Z"
				fill="#37CD58"
			/>
			<path
				d="M138.098 101.243C138.049 101.874 137.515 102.36 136.884 102.311H122.557C121.829 102.311 121.101 101.825 121.101 101.243V99.0573C121.101 98.4745 121.78 97.9404 122.557 97.9404H136.835C137.466 97.8918 138.049 98.3774 138.098 99.0087V99.0573V101.243Z"
				fill="url(#paint0_linear_2828_1824)"
			/>
			<path
				d="M172.236 115.906C172.187 116.585 171.604 117.12 170.925 117.071H122.216C121.487 117.071 120.759 116.537 120.759 115.906V105.125C120.759 104.493 121.487 103.959 122.216 103.959H170.925C171.604 103.91 172.187 104.445 172.236 105.125V115.906Z"
				fill="#DFE4F7"
			/>
			<path
				d="M137.126 124.942C137.126 125.573 136.592 126.107 135.961 126.107H122.557C121.78 126.107 121.101 125.573 121.101 124.942V119.017C121.101 118.386 121.829 117.851 122.557 117.851H135.864C136.495 117.803 137.078 118.289 137.126 118.968V119.017V124.942Z"
				fill="#DFE4F7"
			/>
			<path
				d="M154.609 124.942C154.609 125.573 154.075 126.107 153.444 126.107H140.04C139.263 126.107 138.583 125.573 138.583 124.942V119.017C138.583 118.386 139.312 117.851 140.04 117.851H153.347C153.978 117.803 154.561 118.289 154.609 118.968V119.017V124.942Z"
				fill="#DFE4F7"
			/>
			<path
				d="M172.578 124.942C172.529 125.622 171.946 126.156 171.266 126.107H157.96C157.341 126.149 156.827 125.769 156.627 125.236C156.556 125.046 156.552 124.84 156.552 124.637V119.017C156.6 118.289 157.232 117.803 157.96 117.851H171.266C171.946 117.803 172.578 118.337 172.626 119.017L172.578 124.942Z"
				fill="#DFE4F7"
			/>
			<path
				d="M154.609 128.293C154.512 128.535 154.318 128.681 154.075 128.73C154.027 128.73 154.027 128.73 153.978 128.535H139.312C139.021 128.73 138.583 128.535 138.583 128.293V128.098C138.583 127.855 139.021 127.613 139.312 127.564H153.978C154.221 127.613 154.367 127.807 154.415 128.001C154.415 128.05 154.415 128.05 154.561 128.098L154.609 128.293Z"
				fill="#E9EDFB"
			/>
			<path
				d="M154.609 130.186C154.512 130.429 154.318 130.623 154.075 130.672C154.075 130.672 154.027 130.672 154.027 130.478H139.312C139.021 130.672 138.583 130.478 138.583 130.186V129.992C138.583 129.749 139.021 129.555 139.312 129.506H153.978C154.221 129.555 154.464 129.749 154.561 129.992L154.609 130.186Z"
				fill="#E9EDFB"
			/>
			<path
				d="M154.609 132.129C154.512 132.42 154.269 132.615 154.027 132.663C154.027 132.566 154.027 132.517 154.027 132.42H139.312C139.069 132.566 138.778 132.517 138.632 132.275C138.583 132.226 138.583 132.178 138.583 132.129V131.935C138.583 131.692 139.021 131.546 139.312 131.449H153.978C154.221 131.498 154.464 131.692 154.561 131.935L154.609 132.129Z"
				fill="#E9EDFB"
			/>
			<path
				d="M154.609 134.022C154.464 134.314 154.269 134.605 154.027 134.848H139.312C139.021 134.605 138.583 134.314 138.583 134.022V133.828C138.583 133.585 139.021 133.294 139.312 133.391H153.978C154.172 133.343 154.367 133.488 154.415 133.683C154.415 133.731 154.415 133.78 154.415 133.828C154.415 133.828 154.415 133.828 154.561 133.877L154.609 134.022Z"
				fill="#E9EDFB"
			/>
			<path
				d="M146.451 135.965C146.451 136.208 146.305 136.305 146.014 136.305H139.263C138.972 136.305 138.583 136.208 138.583 135.965V135.771C138.583 135.528 138.972 135.334 139.263 135.334H146.014C146.256 135.334 146.451 135.528 146.451 135.771V135.965Z"
				fill="#E9EDFB"
			/>
			<path
				d="M172.578 128.293C172.286 128.535 172.335 128.73 172.044 128.535H157.377C157.135 128.73 156.892 128.584 156.892 128.341C156.892 128.341 156.892 128.341 157.038 128.293V128.098C156.892 127.855 157.086 127.613 157.377 127.564H172.044C172.335 127.661 172.286 127.855 172.578 128.098V128.293Z"
				fill="#E9EDFB"
			/>
			<path
				d="M172.578 130.186C172.286 130.429 172.335 130.672 172.044 130.478H157.378C157.086 130.672 156.892 130.478 157.038 130.186V129.992C156.892 129.749 157.086 129.555 157.378 129.506H172.044C172.335 129.604 172.286 129.749 172.578 129.992V130.186Z"
				fill="#E9EDFB"
			/>
			<path
				d="M172.578 132.129C172.286 132.372 172.335 132.663 172.044 132.42H157.378C157.086 132.615 156.892 132.42 157.038 132.129V131.935C156.892 131.692 157.086 131.546 157.378 131.449H172.044C172.335 131.546 172.286 131.692 172.578 131.935V132.129Z"
				fill="#E9EDFB"
			/>
			<path
				d="M172.578 134.023C172.287 134.266 172.335 134.606 172.044 134.848H157.378C157.086 134.557 156.892 134.314 157.038 134.023V133.829C156.941 133.732 156.941 133.537 157.038 133.44C157.135 133.392 157.232 133.343 157.329 133.392H172.044C172.335 133.294 172.287 133.586 172.578 133.829V134.023Z"
				fill="#E9EDFB"
			/>
			<path
				d="M164.516 135.965C164.516 136.208 164.516 136.305 164.273 136.305H157.474C157.183 136.305 157.037 136.208 157.037 135.965V135.771C157.037 135.528 157.232 135.334 157.474 135.334H164.225C164.516 135.334 164.468 135.528 164.468 135.771L164.516 135.965Z"
				fill="#E9EDFB"
			/>
			<path
				d="M136.641 128.293C136.835 128.535 136.738 128.73 136.447 128.535H121.732C121.538 128.681 121.295 128.632 121.198 128.487C121.149 128.438 121.149 128.39 121.101 128.293V128.098C121.198 127.807 121.441 127.613 121.732 127.564H136.398C136.689 127.661 136.786 127.855 136.592 128.098L136.641 128.293Z"
				fill="#E9EDFB"
			/>
			<path
				d="M136.641 130.186C136.835 130.429 136.738 130.672 136.447 130.478H121.732C121.441 130.721 121.198 130.478 121.101 130.186V129.992C121.149 129.749 121.441 129.555 121.732 129.506H136.398C136.689 129.604 136.786 129.749 136.592 129.992L136.641 130.186Z"
				fill="#E9EDFB"
			/>
			<path
				d="M136.641 132.129C136.835 132.372 136.738 132.663 136.447 132.42H121.732C121.441 132.663 121.198 132.42 121.101 132.129V131.935C121.149 131.692 121.441 131.546 121.732 131.449H136.398C136.689 131.546 136.786 131.692 136.592 131.935L136.641 132.129Z"
				fill="#E9EDFB"
			/>
			<path
				d="M132.27 133.391H136.447C136.738 133.294 136.835 133.585 136.641 133.828V134.022C136.835 134.265 136.738 134.605 136.447 134.848H121.732C121.441 134.654 121.246 134.362 121.101 134.022V133.828C121.149 133.537 121.441 133.343 121.732 133.391H132.27Z"
				fill="#E9EDFB"
			/>
			<path
				d="M129.356 135.965C129.356 136.208 129.211 136.305 128.919 136.305H121.635C121.343 136.305 121.101 136.208 121.101 135.965V135.771C121.149 135.528 121.392 135.334 121.635 135.334H128.919C129.162 135.334 129.356 135.528 129.356 135.723C129.356 135.723 129.356 135.723 129.356 135.771V135.965Z"
				fill="#E9EDFB"
			/>
			<path
				d="M209.734 44.7208C209.729 42.0234 211.924 39.8394 214.622 39.8572L334.377 40.6462C337.046 40.6638 339.201 42.8328 339.201 45.5022V143.447C339.201 146.123 337.037 148.294 334.362 148.303L214.761 148.724C212.075 148.734 209.892 146.561 209.888 143.876L209.734 44.7208Z"
				fill="white"
				stroke="#E2E5F1"
			/>
			<path
				opacity="0.8"
				d="M221.494 87.899V96.4688L243.99 96.1057V87.899H221.494Z"
				fill="#BAC6F2"
			/>
			<path
				opacity="0.8"
				d="M249.346 87.899V96.4688L292.195 96.1057V87.899H249.346Z"
				fill="#BAC6F2"
			/>
			<path
				opacity="0.8"
				d="M296.479 87.8992V96.4689L331.83 96.1058V87.8992H296.479Z"
				fill="#BAC6F2"
			/>
			<g opacity="0.6">
				<path
					opacity="0.3"
					d="M221.494 100.754V108.253L243.989 107.935V100.754H221.494Z"
					fill="#BAC6F2"
				/>
				<path
					opacity="0.8"
					d="M221.494 112.538V120.036L243.989 119.719V112.538H221.494Z"
					fill="#BAC6F2"
				/>
				<path
					opacity="0.3"
					d="M221.494 124.321V131.819L243.989 131.501V124.321H221.494Z"
					fill="#BAC6F2"
				/>
				<path
					opacity="0.8"
					d="M221.494 136.104V143.603L243.989 143.285V136.104H221.494Z"
					fill="#BAC6F2"
				/>
				<path
					opacity="0.3"
					d="M249.345 100.754V108.253L292.194 107.935V100.754H249.345Z"
					fill="#BAC6F2"
				/>
				<path
					opacity="0.8"
					d="M249.345 112.538V120.036L292.194 119.719V112.538H249.345Z"
					fill="#BAC6F2"
				/>
				<path
					opacity="0.3"
					d="M249.345 124.321V131.819L292.194 131.501V124.321H249.345Z"
					fill="#BAC6F2"
				/>
				<path
					opacity="0.8"
					d="M249.345 136.104V143.603L292.194 143.285V136.104H249.345Z"
					fill="#BAC6F2"
				/>
				<path
					opacity="0.3"
					d="M296.479 100.754V108.253L331.829 107.935V100.754H296.479Z"
					fill="#BAC6F2"
				/>
				<path
					opacity="0.8"
					d="M296.479 112.538V120.036L331.829 119.719V112.538H296.479Z"
					fill="#BAC6F2"
				/>
				<path
					opacity="0.3"
					d="M296.479 124.321V131.819L331.829 131.501V124.321H296.479Z"
					fill="#BAC6F2"
				/>
				<path
					opacity="0.8"
					d="M296.479 136.104V143.603L331.829 143.285V136.104H296.479Z"
					fill="#BAC6F2"
				/>
			</g>
			<path
				d="M296.621 67.5521C298.988 67.5521 300.906 65.6337 300.906 63.2672C300.906 60.9007 298.988 58.9823 296.621 58.9823C294.255 58.9823 292.336 60.9007 292.336 63.2672C292.336 65.6337 294.255 67.5521 296.621 67.5521Z"
				fill="#BAC6F2"
			/>
			<path
				d="M308.405 67.5521C310.771 67.5521 312.69 65.6337 312.69 63.2672C312.69 60.9007 310.771 58.9823 308.405 58.9823C306.038 58.9823 304.12 60.9007 304.12 63.2672C304.12 65.6337 306.038 67.5521 308.405 67.5521Z"
				fill="#BAC6F2"
			/>
			<path
				d="M320.188 67.5521C322.555 67.5521 324.473 65.6337 324.473 63.2672C324.473 60.9007 322.555 58.9823 320.188 58.9823C317.822 58.9823 315.903 60.9007 315.903 63.2672C315.903 65.6337 317.822 67.5521 320.188 67.5521Z"
				fill="#BAC6F2"
			/>
			<path
				d="M273.155 47.3646H221.736V78.43H273.155V47.3646Z"
				fill="#E9EDFA"
			/>
			<path
				d="M223.879 71.1501C223.879 71.1501 227.377 63.4943 230.703 64.3257C234.029 65.1571 234.86 68.6559 237.354 67.1663C239.849 65.6767 241.477 59.649 243.902 58.679C247.366 57.328 248.509 58.8176 253.186 61.485C257.862 64.1524 259.837 63.5635 261.742 61.5889C263.509 59.7876 266.765 54.903 270.368 52.7206"
				stroke="#BAC6F2"
				stroke-width="1.03926"
				stroke-linecap="round"
				stroke-linejoin="round"
			/>
			<path
				d="M84.0225 43.967H25.7331C23.3667 43.967 21.4482 45.8854 21.4482 48.2519V103.25C21.4482 105.617 23.3667 107.535 25.7331 107.535H84.0225C86.3889 107.535 88.3074 105.617 88.3074 103.25V48.2519C88.3074 45.8854 86.3889 43.967 84.0225 43.967Z"
				fill="#0CB352"
			/>
			<path
				d="M54.0117 99.7412C63.5587 99.7412 71.2981 92.0018 71.2981 82.4548C71.2981 72.9078 63.5587 65.1685 54.0117 65.1685C44.4647 65.1685 36.7253 72.9078 36.7253 82.4548C36.7253 92.0018 44.4647 99.7412 54.0117 99.7412Z"
				fill="white"
			/>
			<path
				d="M60.68 91.6412H47.8996C47.0851 91.6412 46.4249 90.981 46.4249 90.1665V72.4705C46.4249 71.656 47.0851 70.9958 47.8996 70.9958H57.2392L62.1547 75.9114V90.1665C62.1547 90.981 61.4946 91.6412 60.68 91.6412Z"
				fill="#43A047"
			/>
			<path
				d="M62.1544 75.9109H57.2389V70.9954L62.1544 75.9109Z"
				fill="#C8E6C9"
			/>
			<path
				d="M57.2389 75.9115L62.1544 80.8271V75.9115H57.2389Z"
				fill="#2E7D32"
			/>
			<path
				d="M57.7302 80.8258H50.8485H49.8654V81.8089V82.792V83.7751V84.7582V85.7414V86.7245V87.7076H58.7134V86.7245V85.7414V84.7582V83.7751V82.792V81.8089V80.8258H57.7302ZM50.8485 81.8089H52.8147V82.792H50.8485V81.8089ZM50.8485 83.7751H52.8147V84.7582H50.8485V83.7751ZM50.8485 85.7414H52.8147V86.7245H50.8485V85.7414ZM57.7302 86.7245H53.7978V85.7414H57.7302V86.7245ZM57.7302 84.7582H53.7978V83.7751H57.7302V84.7582ZM57.7302 82.792H53.7978V81.8089H57.7302V82.792Z"
				fill="#E8F5E9"
			/>
			<path
				d="M42.857 49.475H25.8478V53.4934H42.857V49.475Z"
				fill="white"
			/>
			<path
				d="M42.857 55.7802H25.8478V59.7986H42.857V55.7802Z"
				fill="white"
			/>
			<path
				d="M201.413 65.3921L199.669 59.4583L195.402 63.9353L201.413 65.3921ZM100.721 51.1921C100.996 51.0818 101.129 50.7699 101.019 50.4954C100.908 50.2209 100.596 50.0878 100.322 50.198L100.721 51.1921ZM104.29 48.7157C104.011 48.8128 103.863 49.118 103.96 49.3974C104.057 49.6769 104.363 49.8246 104.642 49.7275L104.29 48.7157ZM108.635 48.4325C108.918 48.3469 109.079 48.048 108.993 47.7649C108.907 47.4817 108.608 47.3215 108.325 47.4071L108.635 48.4325ZM112.417 46.2551C112.131 46.33 111.959 46.6226 112.034 46.9088C112.109 47.195 112.402 47.3663 112.688 47.2915L112.417 46.2551ZM116.766 46.3026C117.055 46.238 117.237 45.9517 117.172 45.663C117.108 45.3743 116.821 45.1927 116.533 45.2572L116.766 46.3026ZM120.688 44.4038C120.397 44.4582 120.205 44.7381 120.26 45.0288C120.314 45.3196 120.594 45.5111 120.885 45.4567L120.688 44.4038ZM125.036 44.7539C125.328 44.7096 125.53 44.4366 125.485 44.1442C125.441 43.8517 125.168 43.6505 124.875 43.6948L125.036 44.7539ZM129.073 43.1342C128.779 43.1682 128.568 43.4339 128.602 43.7278C128.636 44.0216 128.902 44.2323 129.196 44.1983L129.073 43.1342ZM133.378 43.7897C133.673 43.7663 133.893 43.5082 133.87 43.2133C133.846 42.9184 133.588 42.6984 133.293 42.7219L133.378 43.7897ZM137.53 42.4627C137.234 42.4753 137.005 42.7251 137.018 43.0206C137.03 43.3162 137.28 43.5456 137.575 43.5329L137.53 42.4627ZM141.779 43.4332C142.075 43.4319 142.313 43.191 142.312 42.8952C142.311 42.5994 142.07 42.3607 141.774 42.362L141.779 43.4332ZM146.013 42.4255C145.718 42.4152 145.47 42.6465 145.459 42.9422C145.449 43.2378 145.68 43.4858 145.976 43.4961L146.013 42.4255ZM150.168 43.7275C150.463 43.7499 150.72 43.5289 150.743 43.2339C150.765 42.939 150.544 42.6817 150.249 42.6593L150.168 43.7275ZM154.474 43.0704C154.18 43.0354 153.914 43.2452 153.879 43.5389C153.844 43.8327 154.053 44.0991 154.347 44.1341L154.474 43.0704ZM158.504 44.7227C158.796 44.7707 159.071 44.573 159.119 44.2812C159.167 43.9893 158.97 43.7137 158.678 43.6657L158.504 44.7227ZM162.852 44.452C162.563 44.3904 162.278 44.5751 162.217 44.8644C162.155 45.1538 162.34 45.4382 162.629 45.4998L162.852 44.452ZM166.712 46.4714C166.998 46.5469 167.291 46.3762 167.367 46.0902C167.442 45.8042 167.272 45.5111 166.986 45.4357L166.712 46.4714ZM171.064 46.6216C170.783 46.5318 170.481 46.6876 170.392 46.9695C170.302 47.2513 170.458 47.5526 170.739 47.6423L171.064 46.6216ZM174.7 49.0166C174.977 49.1209 175.286 48.981 175.39 48.7041C175.494 48.4273 175.354 48.1184 175.077 48.0141L174.7 49.0166ZM179.012 49.6166C178.741 49.4977 178.425 49.6209 178.306 49.8918C178.188 50.1627 178.311 50.4786 178.582 50.5975L179.012 49.6166ZM182.372 52.3858C182.636 52.5193 182.958 52.4135 183.091 52.1496C183.225 51.8856 183.119 51.5634 182.855 51.4299L182.372 52.3858ZM186.593 53.4528C186.337 53.3048 186.009 53.3924 185.861 53.6486C185.713 53.9047 185.801 54.2323 186.057 54.3803L186.593 53.4528ZM189.625 56.5777C189.872 56.7399 190.204 56.6707 190.366 56.4233C190.528 56.1759 190.459 55.8439 190.212 55.6818L189.625 56.5777ZM193.7 58.1109C193.462 57.935 193.127 57.9854 192.951 58.2233C192.775 58.4611 192.825 58.7965 193.063 58.9723L193.7 58.1109ZM196.362 61.5563C196.589 61.7452 196.927 61.7137 197.116 61.486C197.305 61.2583 197.273 60.9207 197.046 60.7318L196.362 61.5563ZM200.24 63.5344C200.023 63.3333 199.684 63.3461 199.483 63.563C199.282 63.7799 199.295 64.1188 199.512 64.3199L200.24 63.5344ZM98.7893 51.9992C99.4069 51.7306 100.051 51.4612 100.721 51.1921L100.322 50.198C99.643 50.4708 98.9893 50.7441 98.3621 51.0168L98.7893 51.9992ZM104.642 49.7275C105.911 49.2866 107.244 48.8531 108.635 48.4325L108.325 47.4071C106.92 47.8318 105.573 48.2699 104.29 48.7157L104.642 49.7275ZM112.688 47.2915C114.008 46.9463 115.368 46.6154 116.766 46.3026L116.533 45.2572C115.122 45.5728 113.749 45.9067 112.417 46.2551L112.688 47.2915ZM120.885 45.4567C122.241 45.2027 123.626 44.9674 125.036 44.7539L124.875 43.6948C123.453 43.9102 122.056 44.1475 120.688 44.4038L120.885 45.4567ZM129.196 44.1983C130.571 44.0391 131.966 43.9021 133.378 43.7897L133.293 42.7219C131.868 42.8353 130.461 42.9736 129.073 43.1342L129.196 44.1983ZM137.575 43.5329C138.964 43.4737 140.366 43.4397 141.779 43.4332L141.774 42.362C140.347 42.3686 138.932 42.4029 137.53 42.4627L137.575 43.5329ZM145.976 43.4961C147.366 43.5444 148.764 43.6209 150.168 43.7275L150.249 42.6593C148.83 42.5516 147.418 42.4744 146.013 42.4255L145.976 43.4961ZM154.347 44.1341C155.73 44.2988 157.116 44.4943 158.504 44.7227L158.678 43.6657C157.274 43.4347 155.872 43.2369 154.474 43.0704L154.347 44.1341ZM162.629 45.4998C163.992 45.7896 165.353 46.1128 166.712 46.4714L166.986 45.4357C165.609 45.0725 164.231 44.7453 162.852 44.452L162.629 45.4998ZM170.739 47.6423C172.065 48.0641 173.385 48.5217 174.7 49.0166L175.077 48.0141C173.745 47.5125 172.407 47.0489 171.064 46.6216L170.739 47.6423ZM178.582 50.5975C179.853 51.1556 181.117 51.7511 182.372 52.3858L182.855 51.4299C181.583 50.7863 180.301 50.1824 179.012 49.6166L178.582 50.5975ZM186.057 54.3803C187.257 55.0738 188.447 55.8057 189.625 56.5777L190.212 55.6818C189.017 54.8987 187.81 54.1562 186.593 53.4528L186.057 54.3803ZM193.063 58.9723C194.176 59.7945 195.276 60.6554 196.362 61.5563L197.046 60.7318C195.944 59.8181 194.828 58.9449 193.7 58.1109L193.063 58.9723Z"
				fill="#21846C"
			/>
		</g>
		<defs>
			<linearGradient
				id="paint0_linear_2828_1824"
				x1="121.089"
				y1="100.117"
				x2="138.086"
				y2="100.117"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#96BAE4" />
				<stop offset="1" stop-color="#96CDFF" />
			</linearGradient>
		</defs>
	</svg>
);

export const success = (
	<svg
		width="298"
		height="225"
		viewBox="0 0 298 225"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M118.078 14.8548C121.012 12.2541 124.218 7.9182 127.489 3.14382C125.356 2.84037 123.541 2.345 122.558 1.33692C120.28 6.33348 117.85 9.46138 114.216 13.4714C115.709 12.9691 116.674 14.3935 118.078 14.8548Z"
			fill="#C6EAE9"
		/>
		<path
			d="M239.854 137.892C242.498 135.548 245.381 131.643 248.329 127.347C246.408 127.073 244.774 126.626 243.888 125.719C241.835 130.217 239.649 133.036 236.375 136.649C237.722 136.191 238.59 137.473 239.854 137.892Z"
			fill="#FBD682"
		/>
		<path
			d="M242.198 86.0684C241.015 83.4095 238.82 80.3018 236.373 77.0873C235.913 78.7277 235.374 80.0923 234.64 80.7347C237.352 83.1986 238.92 85.5315 240.862 88.9332C240.753 87.6823 241.737 87.1125 242.198 86.0684Z"
			fill="#FBD682"
		/>
		<path
			d="M145.969 161.132C144.654 158.179 142.221 154.731 139.5 151.159C138.989 152.98 138.392 154.497 137.578 155.208C140.59 157.943 142.331 160.532 144.484 164.311C144.365 162.927 145.456 162.294 145.969 161.132Z"
			fill="#EE6F57"
		/>
		<path
			d="M72.8088 13.2362C71.4939 10.2832 69.057 6.83567 66.3396 3.26298C65.8287 5.08395 65.2317 6.6012 64.4172 7.31256C67.4294 10.0475 69.1701 12.6369 71.3238 16.4158C71.2044 15.0314 72.296 14.3987 72.8088 13.2362Z"
			fill="#1DA857"
		/>
		<path
			d="M212.227 173.45C213.368 170.773 215.515 167.632 217.912 164.38C218.397 166.013 218.957 167.369 219.701 168C217.028 170.505 215.496 172.862 213.606 176.294C213.696 175.044 212.704 174.49 212.227 173.45Z"
			fill="#1DA857"
		/>
		<path
			d="M197.462 53.3004C198.732 50.3274 201.112 46.8427 203.777 43.2285C204.316 45.0413 204.936 46.5492 205.762 47.2479C202.792 50.029 201.091 52.6449 198.996 56.4567C199.094 55.0706 197.993 54.4517 197.462 53.3004Z"
			fill="#78847D"
		/>
		<path
			d="M71.6057 53.3717C75.3116 54.2314 80.4828 54.5828 86.0226 54.8103C84.9768 53.3275 84.2675 51.9725 84.4366 50.9493C79.3217 51.4454 75.5205 51.1175 70.3369 50.3624C71.6101 51.1198 71.1128 52.2915 71.6057 53.3717Z"
			fill="#F5C7BE"
		/>
		<path
			d="M233.861 13.8549C230.541 15.1044 225.89 15.6807 220.905 16.0919C221.821 14.0318 222.434 12.151 222.264 10.7422C226.878 11.3371 230.294 10.8168 234.95 9.68445C233.819 10.7492 234.285 12.3577 233.861 13.8549Z"
			fill="#C6EAE9"
		/>
		<path
			d="M166.721 9.16442C170.484 11.3562 175.936 13.0255 181.812 14.5673C181.046 11.9176 180.608 9.54484 181.034 7.90467C175.441 7.64037 171.451 6.2952 166.082 3.96055C167.261 5.47029 166.452 7.29046 166.721 9.16442Z"
			fill="#EE6F57"
		/>
		<path
			d="M103.801 134.048C101.017 135.945 97.8379 139.315 94.5589 143.055C96.3799 143.575 97.9069 144.225 98.6662 145.216C101.104 141.163 103.499 138.746 107.023 135.712C105.68 135.968 104.977 134.616 103.801 134.048Z"
			fill="#C6EAE9"
		/>
		<path
			d="M193.89 140.735C191.106 142.633 187.926 146.003 184.647 149.743C186.468 150.263 187.995 150.913 188.755 151.904C191.193 147.85 193.587 145.434 197.111 142.4C195.768 142.656 195.065 141.307 193.89 140.735Z"
			fill="#FBD682"
		/>
		<path
			d="M259.203 26.6623C256.07 28.7986 252.49 32.5907 248.798 36.7999C250.847 37.3867 252.567 38.1189 253.42 39.2335C256.165 34.6713 258.862 31.9514 262.827 28.5352C261.319 28.8264 260.528 27.3043 259.203 26.6623Z"
			fill="#F5C7BE"
		/>
		<path
			d="M77.0257 104.663C74.6796 102.529 72.2466 98.7738 69.7917 94.612C71.6854 94.0787 73.3201 93.3983 74.2685 92.3287C75.8344 96.8141 77.6909 99.5114 80.5281 102.906C79.2647 102.599 78.2976 104.063 77.0257 104.663Z"
			fill="#F5C7BE"
		/>
		<path
			d="M294.971 70.2391C293.789 67.5801 291.594 64.4724 289.146 61.2579C288.687 62.8984 288.147 64.263 287.413 64.9054C290.125 67.3693 291.693 69.7022 293.636 73.1038C293.527 71.8561 294.51 71.2863 294.971 70.2391Z"
			fill="#EE6F57"
		/>
		<path
			d="M0.412196 55.6634C1.41091 59.5009 3.64634 64.2079 6.19404 69.1331C7.15051 67.0974 8.15032 65.4466 9.25421 64.8045C6.19804 60.8027 4.62409 57.2895 2.78067 52.2626C2.66313 53.9346 1.24426 54.4114 0.412196 55.6634Z"
			fill="#78847D"
		/>
		<path
			d="M295.83 18.6921C295.144 21.5146 293.558 24.9869 291.748 28.6194C291.025 27.1403 290.273 25.941 289.456 25.4845C291.648 22.52 292.761 19.9271 294.053 16.2272C294.159 17.4502 295.205 17.7869 295.83 18.6921Z"
			fill="#78847D"
		/>
		<path
			d="M25.998 20.2943C29.1636 22.382 32.8017 26.1184 36.5579 30.2701C34.5189 30.8884 32.8102 31.6471 31.971 32.7748C29.1562 28.2555 26.4177 25.5775 22.4006 22.223C23.9153 22.4877 24.6831 20.9567 25.998 20.2943Z"
			fill="#FBD682"
		/>
		<path
			d="M145.56 32.9961C148.725 35.0838 152.363 38.8202 156.119 42.9719C154.08 43.5902 152.372 44.3488 151.532 45.4766C148.718 40.9573 145.979 38.2793 141.962 34.9248C143.477 35.1895 144.245 33.6585 145.56 32.9961Z"
			fill="#FBD682"
		/>
		<path
			d="M278.859 120.269H191.615C188.073 120.269 185.202 123.141 185.202 126.682V209C185.202 212.542 188.073 215.413 191.615 215.413H278.859C282.401 215.413 285.272 212.542 285.272 209V126.682C285.272 123.141 282.401 120.269 278.859 120.269Z"
			fill="#EDF0F2"
		/>
		<path
			d="M233.941 193.865C248.23 193.865 259.814 182.282 259.814 167.992C259.814 153.703 248.23 142.119 233.941 142.119C219.652 142.119 208.068 153.703 208.068 167.992C208.068 182.282 219.652 193.865 233.941 193.865Z"
			fill="white"
		/>
		<path
			d="M243.921 181.742H224.792C223.573 181.742 222.585 180.754 222.585 179.535V153.049C222.585 151.83 223.573 150.842 224.792 150.842H238.771L246.128 158.199V179.535C246.128 180.754 245.14 181.742 243.921 181.742Z"
			fill="#43A047"
		/>
		<path
			d="M246.128 158.198H238.771V150.841L246.128 158.198Z"
			fill="#C8E6C9"
		/>
		<path
			d="M238.771 158.2L246.128 165.557V158.2H238.771Z"
			fill="#2E7D32"
		/>
		<path
			d="M239.506 165.555H229.206H227.734V167.026V168.498V169.969V171.44V172.912V174.383V175.855H240.977V174.383V172.912V171.44V169.969V168.498V167.026V165.555H239.506ZM229.206 167.026H232.149V168.498H229.206V167.026ZM229.206 169.969H232.149V171.44H229.206V169.969ZM229.206 172.912H232.149V174.383H229.206V172.912ZM239.506 174.383H233.62V172.912H239.506V174.383ZM239.506 171.44H233.62V169.969H239.506V171.44ZM239.506 168.498H233.62V167.026H239.506V168.498Z"
			fill="#E8F5E9"
		/>
		<path
			d="M217.245 129.007H191.787V135.022H217.245V129.007Z"
			fill="white"
		/>
		<path
			d="M217.245 138.445H191.787V144.459H217.245V138.445Z"
			fill="white"
		/>
		<path
			d="M5.14692 68.0372C5.14064 63.9999 8.42587 60.7312 12.4631 60.7578L191.704 61.9387C195.7 61.9651 198.925 65.2114 198.925 69.2069V215.804C198.925 219.808 195.686 223.058 191.682 223.072L12.6716 223.702C8.65189 223.716 5.38401 220.465 5.37776 216.445L5.14692 68.0372Z"
			fill="white"
			stroke="#E2E5F1"
			stroke-width="1.49673"
		/>
		<path
			opacity="0.8"
			d="M22.75 132.663V145.49L56.4199 144.946V132.663H22.75Z"
			fill="#BAC6F2"
		/>
		<path
			opacity="0.8"
			d="M64.436 132.663V145.49L128.569 144.946V132.663H64.436Z"
			fill="#BAC6F2"
		/>
		<path
			opacity="0.8"
			d="M134.982 132.664V145.491L187.892 144.947V132.664H134.982Z"
			fill="#BAC6F2"
		/>
		<g opacity="0.6">
			<path
				opacity="0.3"
				d="M22.7483 151.904V163.127L56.4182 162.652V151.904H22.7483Z"
				fill="#BAC6F2"
			/>
			<path
				opacity="0.8"
				d="M22.748 169.541V180.765L56.418 180.289V169.541H22.748Z"
				fill="#BAC6F2"
			/>
			<path
				opacity="0.3"
				d="M22.748 187.177V198.4L56.418 197.925V187.177H22.748Z"
				fill="#BAC6F2"
			/>
			<path
				opacity="0.8"
				d="M22.748 204.814V216.038L56.418 215.562V204.814H22.748Z"
				fill="#BAC6F2"
			/>
			<path
				opacity="0.3"
				d="M64.4348 151.904V163.127L128.568 162.652V151.904H64.4348Z"
				fill="#BAC6F2"
			/>
			<path
				opacity="0.8"
				d="M64.4348 169.541V180.765L128.568 180.289V169.541H64.4348Z"
				fill="#BAC6F2"
			/>
			<path
				opacity="0.3"
				d="M64.4348 187.177V198.4L128.568 197.925V187.177H64.4348Z"
				fill="#BAC6F2"
			/>
			<path
				opacity="0.8"
				d="M64.4348 204.814V216.038L128.568 215.562V204.814H64.4348Z"
				fill="#BAC6F2"
			/>
			<path
				opacity="0.3"
				d="M134.982 151.904V163.127L187.892 162.652V151.904H134.982Z"
				fill="#BAC6F2"
			/>
			<path
				opacity="0.8"
				d="M134.982 169.541V180.765L187.892 180.289V169.541H134.982Z"
				fill="#BAC6F2"
			/>
			<path
				opacity="0.3"
				d="M134.982 187.177V198.4L187.892 197.925V187.177H134.982Z"
				fill="#BAC6F2"
			/>
			<path
				opacity="0.8"
				d="M134.982 204.814V216.038L187.892 215.562V204.814H134.982Z"
				fill="#BAC6F2"
			/>
		</g>
		<path
			d="M135.195 102.21C138.737 102.21 141.608 99.3382 141.608 95.7963C141.608 92.2543 138.737 89.3829 135.195 89.3829C131.653 89.3829 128.781 92.2543 128.781 95.7963C128.781 99.3382 131.653 102.21 135.195 102.21Z"
			fill="#BAC6F2"
		/>
		<path
			d="M152.831 102.21C156.373 102.21 159.244 99.3382 159.244 95.7963C159.244 92.2543 156.373 89.3829 152.831 89.3829C149.289 89.3829 146.418 92.2543 146.418 95.7963C146.418 99.3382 149.289 102.21 152.831 102.21Z"
			fill="#BAC6F2"
		/>
		<path
			d="M170.468 102.21C174.01 102.21 176.881 99.3382 176.881 95.7963C176.881 92.2543 174.01 89.3829 170.468 89.3829C166.926 89.3829 164.054 92.2543 164.054 95.7963C164.054 99.3382 166.926 102.21 170.468 102.21Z"
			fill="#BAC6F2"
		/>
		<path
			d="M100.072 71.9945H23.1118V118.491H100.072V71.9945Z"
			fill="#E9EDFA"
		/>
		<path
			d="M26.3181 107.595C26.3181 107.595 31.5549 96.1363 36.5325 97.3807C41.5101 98.625 42.7545 103.862 46.4877 101.632C50.2208 99.4028 52.6578 90.3809 56.2873 88.9291C61.4722 86.907 63.1833 89.1365 70.183 93.129C77.1827 97.1214 80.1382 96.24 82.9899 93.2845C85.6342 90.5883 90.5081 83.2775 95.9005 80.011"
			stroke="#BAC6F2"
			stroke-width="1.55549"
			stroke-linecap="round"
			stroke-linejoin="round"
		/>
		<circle cx="243.761" cy="79.7709" r="28.0133" fill="#74D27D" />
		<path
			d="M254.064 71.0045C254.212 70.8531 254.389 70.7327 254.585 70.6506C254.78 70.5684 254.99 70.5261 255.202 70.5261C255.414 70.5261 255.624 70.5684 255.82 70.6506C256.016 70.7327 256.193 70.8531 256.341 71.0045C256.963 71.6332 256.972 72.6491 256.363 73.2886L243.5 88.4938C243.354 88.6541 243.177 88.783 242.98 88.8725C242.782 88.9621 242.568 89.0103 242.352 89.0144C242.135 89.0185 241.919 88.9783 241.718 88.8962C241.518 88.8142 241.336 88.692 241.184 88.5373L233.357 80.6062C233.055 80.2984 232.886 79.8845 232.886 79.4533C232.886 79.0222 233.055 78.6083 233.357 78.3004C233.506 78.1489 233.683 78.0286 233.878 77.9465C234.074 77.8643 234.284 77.822 234.496 77.822C234.708 77.822 234.918 77.8643 235.114 77.9465C235.309 78.0286 235.486 78.1489 235.635 78.3004L242.274 85.0286L254.02 71.0524C254.034 71.0356 254.048 71.0196 254.064 71.0045Z"
			fill="white"
		/>
	</svg>
);

export const lockWhite = (
	<svg
		width="19"
		height="25"
		viewBox="0 0 19 25"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<path
			d="M17.3714 9.5H14.9286V6.24286C14.9286 2.31121 13.1168 0 9.5 0C5.88186 0 4.07143 2.31121 4.07143 6.24286V6.78571H6.78571V5.69864C6.78571 3.73757 7.86736 2.71429 9.5 2.71429C11.1326 2.71429 12.2143 3.73757 12.2143 5.69864V9.5H1.35714C0.606643 9.5 0 10.3767 0 11.1272V21.7143C0 22.4594 0.580857 23.2601 1.29064 23.4881L2.91514 24.0133C3.77679 24.2645 4.66711 24.404 5.56429 24.4286H13.4357C14.3326 24.4042 15.2225 24.2642 16.0835 24.0119L17.7066 23.4867C18.4178 23.2601 19 22.4594 19 21.7143V11.1272C19 10.3767 18.1206 9.5 17.3714 9.5Z"
			fill="white"
		/>
	</svg>
);
export const SpinLoader = (
	<svg className="circular-loader" viewBox="25 25 50 50">
		<circle
			className="loader-path"
			cx="50"
			cy="50"
			r="20"
			fill="none"
			stroke="white"
			stroke-width="2"
		/>
	</svg>
);

export const promoThumbnail = (
	<svg
		width="359"
		height="224"
		viewBox="0 0 359 224"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
	>
		<mask
			id="mask0_2907_1029"
			maskUnits="userSpaceOnUse"
			x="0"
			y="0"
			width="359"
			height="224"
		>
			<rect width="359" height="224" fill="#D9D9D9" />
		</mask>
		<g mask="url(#mask0_2907_1029)">
			<path
				d="M38.0904 121.877C33.74 112.461 32.4901 101.461 34.6293 91.0556C40.7102 61.563 52.1174 24.0452 103.467 17.1121C159.138 3.21572 191.687 9.1742 207.373 6.50449C220.829 3.69282 273.176 11.9001 292.789 49.808C301.297 62.9001 317.911 62.9634 314.737 124.535C317.911 157.244 326.114 173.689 326.955 195.066C328.319 238.333 298.365 234.187 265.388 234.838C232.412 235.488 37.1595 233.972 37.1595 233.972C37.1595 233.972 17.0114 174.754 36.48 156.968C48.5217 145.941 43.1138 132.764 38.0904 121.877Z"
				fill="#F4F7FA"
			/>
			<path
				opacity="0.2"
				d="M48 194.905L48.5033 206.536L304.698 207.563L305 194.562L48 194.905Z"
				fill="#3EA9CE"
			/>
			<path
				d="M14 188.562L339 189.229V195.562L14.5682 195.229L14 188.562Z"
				fill="#6CC9E9"
			/>
			<path
				d="M107.418 173.903H181.379C181.379 173.903 184.147 173.757 184.147 170.552V164.19H104.504V171.912C104.892 173.126 106.058 173.952 107.418 173.903Z"
				fill="#56B0E2"
			/>
			<path
				d="M104.504 116.113L104.455 166.619L184.147 165.89V114.656C184.147 114.656 184.633 111.742 181.525 111.742H107.515C107.515 111.742 104.164 111.742 104.504 116.113Z"
				fill="#4F75CD"
			/>
			<path
				d="M138.013 187.452V173.417L149.668 173.903V186.238L138.013 187.452Z"
				fill="#517CD0"
			/>
			<path
				d="M119.51 186.043H167.927L167.976 188.471H119.51V186.043Z"
				fill="#4F75CD"
			/>
			<path
				d="M143.597 167.639C144.908 167.639 145.928 168.658 145.928 169.97C145.928 171.281 144.908 172.301 143.597 172.301C142.285 172.301 141.266 171.281 141.266 169.97C141.266 168.658 142.334 167.639 143.597 167.639Z"
				fill="white"
			/>
			<path
				d="M181.719 114.17H106.932V163.219H181.719V114.17Z"
				fill="#F8F8FF"
			/>
			<path
				d="M110.671 116.695C111.303 116.695 111.837 117.23 111.837 117.861C111.837 118.492 111.303 119.026 110.671 119.026C110.04 119.026 109.506 118.492 109.506 117.861C109.506 117.23 110.04 116.695 110.671 116.695Z"
				fill="#FA5F5D"
			/>
			<path
				d="M114.654 116.695C115.285 116.695 115.819 117.23 115.819 117.861C115.819 118.492 115.285 119.026 114.654 119.026C114.022 119.026 113.488 118.492 113.488 117.861C113.488 117.23 114.022 116.695 114.654 116.695Z"
				fill="#FDBC4E"
			/>
			<path
				d="M118.83 116.695C119.461 116.695 119.995 117.23 119.995 117.861C119.995 118.492 119.461 119.026 118.83 119.026C118.198 119.026 117.664 118.492 117.664 117.861C117.664 117.23 118.198 116.695 118.83 116.695Z"
				fill="#37CD58"
			/>
			<path
				d="M135.099 125.242C135.05 125.873 134.516 126.359 133.885 126.311H119.558C118.83 126.311 118.102 125.825 118.102 125.242V123.057C118.102 122.474 118.781 121.94 119.558 121.94H133.836C134.467 121.891 135.05 122.377 135.099 123.008V123.057V125.242Z"
				fill="url(#paint0_linear_2907_1029)"
			/>
			<path
				d="M169.236 139.906C169.187 140.586 168.604 141.12 167.925 141.071H119.216C118.487 141.071 117.759 140.537 117.759 139.906V129.125C117.759 128.493 118.487 127.959 119.216 127.959H167.925C168.604 127.911 169.187 128.445 169.236 129.125V139.906Z"
				fill="#DFE4F7"
			/>
			<path
				d="M134.127 148.941C134.127 149.573 133.593 150.107 132.962 150.107H119.558C118.781 150.107 118.102 149.573 118.102 148.941V143.017C118.102 142.385 118.83 141.851 119.558 141.851H132.865C133.496 141.802 134.079 142.288 134.127 142.968V143.017V148.941Z"
				fill="#DFE4F7"
			/>
			<path
				d="M151.61 148.941C151.61 149.573 151.076 150.107 150.444 150.107H137.041C136.264 150.107 135.584 149.573 135.584 148.941V143.017C135.584 142.385 136.312 141.851 137.041 141.851H150.347C150.979 141.802 151.561 142.288 151.61 142.968V143.017V148.941Z"
				fill="#DFE4F7"
			/>
			<path
				d="M169.579 148.941C169.53 149.621 168.947 150.155 168.267 150.107H154.961C154.342 150.148 153.828 149.768 153.628 149.236C153.557 149.046 153.553 148.839 153.553 148.637V143.017C153.601 142.288 154.233 141.802 154.961 141.851H168.267C168.947 141.802 169.579 142.337 169.627 143.017L169.579 148.941Z"
				fill="#DFE4F7"
			/>
			<path
				d="M151.61 152.292C151.513 152.535 151.318 152.68 151.076 152.729C151.027 152.729 151.027 152.729 150.979 152.535H136.312C136.021 152.729 135.584 152.535 135.584 152.292V152.098C135.584 151.855 136.021 151.612 136.312 151.563H150.979C151.221 151.612 151.367 151.806 151.416 152.001C151.416 152.049 151.416 152.049 151.561 152.098L151.61 152.292Z"
				fill="#E9EDFB"
			/>
			<path
				d="M151.61 154.186C151.513 154.429 151.318 154.623 151.076 154.671C151.076 154.671 151.027 154.671 151.027 154.477H136.312C136.021 154.671 135.584 154.477 135.584 154.186V153.991C135.584 153.749 136.021 153.554 136.312 153.506H150.979C151.221 153.554 151.464 153.749 151.561 153.991L151.61 154.186Z"
				fill="#E9EDFB"
			/>
			<path
				d="M151.61 156.129C151.513 156.42 151.27 156.615 151.027 156.663C151.027 156.566 151.027 156.518 151.027 156.42H136.312C136.07 156.566 135.778 156.518 135.633 156.275C135.584 156.226 135.584 156.178 135.584 156.129V155.935C135.584 155.692 136.021 155.546 136.312 155.449H150.979C151.221 155.498 151.464 155.692 151.561 155.935L151.61 156.129Z"
				fill="#E9EDFB"
			/>
			<path
				d="M151.61 158.023C151.464 158.314 151.27 158.605 151.027 158.848H136.312C136.021 158.605 135.584 158.314 135.584 158.023V157.828C135.584 157.585 136.021 157.294 136.312 157.391H150.979C151.173 157.343 151.367 157.488 151.416 157.683C151.416 157.731 151.416 157.78 151.416 157.828C151.416 157.828 151.416 157.828 151.561 157.877L151.61 158.023Z"
				fill="#E9EDFB"
			/>
			<path
				d="M143.451 159.965C143.451 160.208 143.306 160.305 143.014 160.305H136.264C135.972 160.305 135.584 160.208 135.584 159.965V159.771C135.584 159.528 135.972 159.334 136.264 159.334H143.014C143.257 159.334 143.451 159.528 143.451 159.771V159.965Z"
				fill="#E9EDFB"
			/>
			<path
				d="M169.578 152.292C169.287 152.535 169.336 152.729 169.044 152.535H154.378C154.135 152.729 153.893 152.583 153.893 152.34C153.893 152.34 153.893 152.34 154.038 152.292V152.098C153.893 151.855 154.087 151.612 154.378 151.563H169.044C169.336 151.661 169.287 151.855 169.578 152.098V152.292Z"
				fill="#E9EDFB"
			/>
			<path
				d="M169.578 154.186C169.287 154.429 169.335 154.671 169.044 154.477H154.378C154.086 154.671 153.892 154.477 154.038 154.186V153.991C153.892 153.749 154.086 153.554 154.378 153.506H169.044C169.335 153.603 169.287 153.749 169.578 153.991V154.186Z"
				fill="#E9EDFB"
			/>
			<path
				d="M169.578 156.129C169.287 156.372 169.335 156.663 169.044 156.42H154.378C154.086 156.615 153.892 156.42 154.038 156.129V155.935C153.892 155.692 154.086 155.546 154.378 155.449H169.044C169.335 155.546 169.287 155.692 169.578 155.935V156.129Z"
				fill="#E9EDFB"
			/>
			<path
				d="M169.578 158.023C169.287 158.265 169.335 158.605 169.044 158.848H154.378C154.086 158.557 153.892 158.314 154.038 158.023V157.828C153.941 157.731 153.941 157.537 154.038 157.44C154.135 157.391 154.232 157.343 154.329 157.391H169.044C169.335 157.294 169.287 157.585 169.578 157.828V158.023Z"
				fill="#E9EDFB"
			/>
			<path
				d="M161.517 159.965C161.517 160.208 161.517 160.305 161.274 160.305H154.475C154.184 160.305 154.038 160.208 154.038 159.965V159.771C154.038 159.528 154.232 159.334 154.475 159.334H161.225C161.517 159.334 161.468 159.528 161.468 159.771L161.517 159.965Z"
				fill="#E9EDFB"
			/>
			<path
				d="M133.642 152.292C133.836 152.535 133.739 152.729 133.448 152.535H118.733C118.539 152.68 118.296 152.632 118.199 152.486C118.15 152.438 118.15 152.389 118.102 152.292V152.098C118.199 151.806 118.441 151.612 118.733 151.563H133.399C133.69 151.661 133.787 151.855 133.593 152.098L133.642 152.292Z"
				fill="#E9EDFB"
			/>
			<path
				d="M133.642 154.186C133.836 154.429 133.739 154.671 133.448 154.477H118.733C118.441 154.72 118.199 154.477 118.102 154.186V153.991C118.15 153.749 118.441 153.554 118.733 153.506H133.399C133.69 153.603 133.787 153.749 133.593 153.991L133.642 154.186Z"
				fill="#E9EDFB"
			/>
			<path
				d="M133.642 156.129C133.836 156.372 133.739 156.663 133.448 156.42H118.733C118.441 156.663 118.199 156.42 118.102 156.129V155.935C118.15 155.692 118.441 155.546 118.733 155.449H133.399C133.69 155.546 133.787 155.692 133.593 155.935L133.642 156.129Z"
				fill="#E9EDFB"
			/>
			<path
				d="M129.271 157.391H133.448C133.739 157.294 133.836 157.585 133.642 157.828V158.023C133.836 158.265 133.739 158.605 133.448 158.848H118.733C118.441 158.654 118.247 158.362 118.102 158.023V157.828C118.15 157.537 118.441 157.343 118.733 157.391H129.271Z"
				fill="#E9EDFB"
			/>
			<path
				d="M126.357 159.965C126.357 160.208 126.212 160.305 125.92 160.305H118.636C118.344 160.305 118.102 160.208 118.102 159.965V159.771C118.15 159.528 118.393 159.334 118.636 159.334H125.92C126.163 159.334 126.357 159.528 126.357 159.722C126.357 159.722 126.357 159.722 126.357 159.771V159.965Z"
				fill="#E9EDFB"
			/>
			<path
				d="M206.734 68.7204C206.73 66.023 208.925 63.8391 211.622 63.8569L331.377 64.6459C334.047 64.6635 336.202 66.8324 336.202 69.5019V167.447C336.202 170.122 334.038 172.294 331.362 172.303L211.761 172.724C209.076 172.733 206.892 170.561 206.888 167.875L206.734 68.7204Z"
				fill="white"
				stroke="#E2E5F1"
			/>
			<path
				opacity="0.8"
				d="M218.494 111.898V120.468L240.99 120.105V111.898H218.494Z"
				fill="#BAC6F2"
			/>
			<path
				opacity="0.8"
				d="M246.347 111.898V120.468L289.196 120.105V111.898H246.347Z"
				fill="#BAC6F2"
			/>
			<path
				opacity="0.8"
				d="M293.48 111.898V120.468L328.831 120.105V111.898H293.48Z"
				fill="#BAC6F2"
			/>
			<g opacity="0.6">
				<path
					opacity="0.3"
					d="M218.494 124.753V132.251L240.99 131.934V124.753H218.494Z"
					fill="#BAC6F2"
				/>
				<path
					opacity="0.8"
					d="M218.494 136.536V144.035L240.99 143.717V136.536H218.494Z"
					fill="#BAC6F2"
				/>
				<path
					opacity="0.3"
					d="M218.494 148.319V155.818L240.99 155.5V148.319H218.494Z"
					fill="#BAC6F2"
				/>
				<path
					opacity="0.8"
					d="M218.494 160.104V167.602L240.99 167.284V160.104H218.494Z"
					fill="#BAC6F2"
				/>
				<path
					opacity="0.3"
					d="M246.346 124.753V132.251L289.195 131.934V124.753H246.346Z"
					fill="#BAC6F2"
				/>
				<path
					opacity="0.8"
					d="M246.346 136.536V144.035L289.195 143.717V136.536H246.346Z"
					fill="#BAC6F2"
				/>
				<path
					opacity="0.3"
					d="M246.346 148.319V155.818L289.195 155.5V148.319H246.346Z"
					fill="#BAC6F2"
				/>
				<path
					opacity="0.8"
					d="M246.346 160.104V167.602L289.195 167.284V160.104H246.346Z"
					fill="#BAC6F2"
				/>
				<path
					opacity="0.3"
					d="M293.479 124.753V132.251L328.83 131.934V124.753H293.479Z"
					fill="#BAC6F2"
				/>
				<path
					opacity="0.8"
					d="M293.479 136.536V144.035L328.83 143.717V136.536H293.479Z"
					fill="#BAC6F2"
				/>
				<path
					opacity="0.3"
					d="M293.479 148.319V155.818L328.83 155.5V148.319H293.479Z"
					fill="#BAC6F2"
				/>
				<path
					opacity="0.8"
					d="M293.479 160.104V167.602L328.83 167.284V160.104H293.479Z"
					fill="#BAC6F2"
				/>
			</g>
			<path
				d="M293.622 91.5512C295.988 91.5512 297.907 89.6328 297.907 87.2663C297.907 84.8999 295.988 82.9814 293.622 82.9814C291.255 82.9814 289.337 84.8999 289.337 87.2663C289.337 89.6328 291.255 91.5512 293.622 91.5512Z"
				fill="#BAC6F2"
			/>
			<path
				d="M305.405 91.5512C307.771 91.5512 309.69 89.6328 309.69 87.2663C309.69 84.8999 307.771 82.9814 305.405 82.9814C303.039 82.9814 301.12 84.8999 301.12 87.2663C301.12 89.6328 303.039 91.5512 305.405 91.5512Z"
				fill="#BAC6F2"
			/>
			<path
				d="M317.188 91.5512C319.555 91.5512 321.473 89.6328 321.473 87.2663C321.473 84.8999 319.555 82.9814 317.188 82.9814C314.822 82.9814 312.903 84.8999 312.903 87.2663C312.903 89.6328 314.822 91.5512 317.188 91.5512Z"
				fill="#BAC6F2"
			/>
			<path
				d="M270.155 71.3643H218.736V102.43H270.155V71.3643Z"
				fill="#E9EDFA"
			/>
			<path
				d="M220.879 95.1493C220.879 95.1493 224.378 87.4934 227.703 88.3248C231.029 89.1562 231.86 92.6551 234.355 91.1654C236.849 89.6758 238.477 83.6481 240.902 82.6781C244.366 81.3271 245.509 82.8167 250.186 85.4842C254.863 88.1516 256.837 87.5627 258.743 85.5881C260.509 83.7867 263.766 78.9022 267.368 76.7197"
				stroke="#BAC6F2"
				stroke-width="1.03926"
				stroke-linecap="round"
				stroke-linejoin="round"
			/>
			<path
				d="M81.0225 67.9668H22.7331C20.3667 67.9668 18.4482 69.8852 18.4482 72.2517V127.25C18.4482 129.617 20.3667 131.535 22.7331 131.535H81.0225C83.3889 131.535 85.3074 129.617 85.3074 127.25V72.2517C85.3074 69.8852 83.3889 67.9668 81.0225 67.9668Z"
				fill="#0CB352"
			/>
			<path
				d="M51.012 123.741C60.559 123.741 68.2983 116.001 68.2983 106.454C68.2983 96.9073 60.559 89.168 51.012 89.168C41.465 89.168 33.7256 96.9073 33.7256 106.454C33.7256 116.001 41.465 123.741 51.012 123.741Z"
				fill="white"
			/>
			<path
				d="M57.6799 115.64H44.8995C44.085 115.64 43.4248 114.98 43.4248 114.166V96.4698C43.4248 95.6553 44.085 94.9951 44.8995 94.9951H54.239L59.1546 99.9107V114.166C59.1546 114.98 58.4944 115.64 57.6799 115.64Z"
				fill="#43A047"
			/>
			<path
				d="M59.1548 99.9107H54.2393V94.9951L59.1548 99.9107Z"
				fill="#C8E6C9"
			/>
			<path
				d="M54.2393 99.9111L59.1548 104.827V99.9111H54.2393Z"
				fill="#2E7D32"
			/>
			<path
				d="M54.7301 104.825H47.8483H46.8652V105.808V106.791V107.775V108.758V109.741V110.724V111.707H55.7132V110.724V109.741V108.758V107.775V106.791V105.808V104.825H54.7301ZM47.8483 105.808H49.8146V106.791H47.8483V105.808ZM47.8483 107.775H49.8146V108.758H47.8483V107.775ZM47.8483 109.741H49.8146V110.724H47.8483V109.741ZM54.7301 110.724H50.7977V109.741H54.7301V110.724ZM54.7301 108.758H50.7977V107.775H54.7301V108.758ZM54.7301 106.791H50.7977V105.808H54.7301V106.791Z"
				fill="#E8F5E9"
			/>
			<path
				d="M39.8569 73.4746H22.8477V77.4931H39.8569V73.4746Z"
				fill="white"
			/>
			<path
				d="M39.8569 79.7803H22.8477V83.7987H39.8569V79.7803Z"
				fill="white"
			/>
			<path
				d="M198.413 89.3921L196.67 83.4583L192.403 87.9353L198.413 89.3921ZM97.7216 75.1921C97.9961 75.0818 98.1293 74.7699 98.019 74.4954C97.9087 74.2209 97.5968 74.0878 97.3223 74.198L97.7216 75.1921ZM101.291 72.7157C101.011 72.8128 100.864 73.118 100.961 73.3974C101.058 73.6769 101.363 73.8246 101.642 73.7275L101.291 72.7157ZM105.636 72.4325C105.919 72.3469 106.079 72.048 105.993 71.7649C105.908 71.4817 105.609 71.3215 105.326 71.4071L105.636 72.4325ZM109.417 70.2551C109.131 70.33 108.96 70.6226 109.035 70.9088C109.11 71.195 109.402 71.3663 109.688 71.2915L109.417 70.2551ZM113.767 70.3026C114.056 70.238 114.237 69.9517 114.173 69.663C114.108 69.3743 113.822 69.1927 113.533 69.2572L113.767 70.3026ZM117.688 68.4038C117.397 68.4582 117.206 68.7381 117.26 69.0288C117.315 69.3196 117.595 69.5111 117.885 69.4567L117.688 68.4038ZM122.036 68.7539C122.329 68.7096 122.53 68.4366 122.486 68.1442C122.441 67.8517 122.168 67.6505 121.876 67.6948L122.036 68.7539ZM126.073 67.1342C125.779 67.1682 125.569 67.4339 125.603 67.7278C125.637 68.0216 125.903 68.2323 126.196 68.1983L126.073 67.1342ZM130.379 67.7897C130.674 67.7663 130.894 67.5082 130.87 67.2133C130.847 66.9184 130.589 66.6984 130.294 66.7219L130.379 67.7897ZM134.53 66.4627C134.235 66.4753 134.005 66.7251 134.018 67.0206C134.031 67.3162 134.28 67.5456 134.576 67.5329L134.53 66.4627ZM138.779 67.4332C139.075 67.4319 139.314 67.191 139.312 66.8952C139.311 66.5994 139.07 66.3607 138.774 66.362L138.779 67.4332ZM143.014 66.4255C142.718 66.4152 142.47 66.6465 142.46 66.9422C142.449 67.2378 142.681 67.4858 142.976 67.4961L143.014 66.4255ZM147.169 67.7275C147.464 67.7499 147.721 67.5289 147.743 67.2339C147.766 66.939 147.545 66.6817 147.25 66.6593L147.169 67.7275ZM151.474 67.0704C151.181 67.0354 150.914 67.2452 150.879 67.5389C150.844 67.8327 151.054 68.0991 151.348 68.1341L151.474 67.0704ZM155.504 68.7227C155.796 68.7707 156.072 68.573 156.12 68.2812C156.168 67.9893 155.97 67.7137 155.678 67.6657L155.504 68.7227ZM159.853 68.452C159.563 68.3904 159.279 68.5751 159.217 68.8644C159.156 69.1538 159.34 69.4382 159.63 69.4998L159.853 68.452ZM163.713 70.4714C163.999 70.5469 164.292 70.3762 164.367 70.0902C164.443 69.8042 164.272 69.5111 163.986 69.4357L163.713 70.4714ZM168.065 70.6216C167.783 70.5318 167.482 70.6876 167.392 70.9695C167.302 71.2513 167.458 71.5526 167.74 71.6423L168.065 70.6216ZM171.7 73.0166C171.977 73.1209 172.286 72.981 172.39 72.7041C172.495 72.4273 172.355 72.1184 172.078 72.0141L171.7 73.0166ZM176.013 73.6166C175.742 73.4977 175.426 73.6209 175.307 73.8918C175.188 74.1627 175.311 74.4786 175.582 74.5975L176.013 73.6166ZM179.372 76.3858C179.636 76.5193 179.958 76.4135 180.092 76.1496C180.225 75.8856 180.12 75.5634 179.856 75.4299L179.372 76.3858ZM183.593 77.4528C183.337 77.3048 183.01 77.3924 182.862 77.6486C182.714 77.9047 182.801 78.2323 183.057 78.3803L183.593 77.4528ZM186.625 80.5777C186.873 80.7399 187.205 80.6707 187.367 80.4233C187.529 80.1759 187.46 79.8439 187.212 79.6818L186.625 80.5777ZM190.7 82.1109C190.462 81.935 190.127 81.9854 189.951 82.2233C189.775 82.4611 189.826 82.7965 190.064 82.9723L190.7 82.1109ZM193.362 85.5563C193.59 85.7452 193.928 85.7137 194.116 85.486C194.305 85.2583 194.274 84.9207 194.046 84.7318L193.362 85.5563ZM197.241 87.5344C197.024 87.3333 196.685 87.3461 196.484 87.563C196.282 87.7799 196.295 88.1188 196.512 88.3199L197.241 87.5344ZM95.7898 75.9992C96.4074 75.7306 97.0518 75.4612 97.7216 75.1921L97.3223 74.198C96.6435 74.4708 95.9898 74.7441 95.3626 75.0168L95.7898 75.9992ZM101.642 73.7275C102.911 73.2866 104.244 72.8531 105.636 72.4325L105.326 71.4071C103.92 71.8318 102.573 72.2699 101.291 72.7157L101.642 73.7275ZM109.688 71.2915C111.008 70.9463 112.369 70.6154 113.767 70.3026L113.533 69.2572C112.123 69.5728 110.749 69.9067 109.417 70.2551L109.688 71.2915ZM117.885 69.4567C119.242 69.2027 120.626 68.9674 122.036 68.7539L121.876 67.6948C120.454 67.9102 119.057 68.1475 117.688 68.4038L117.885 69.4567ZM126.196 68.1983C127.572 68.0391 128.967 67.9021 130.379 67.7897L130.294 66.7219C128.869 66.8353 127.461 66.9736 126.073 67.1342L126.196 68.1983ZM134.576 67.5329C135.965 67.4737 137.367 67.4397 138.779 67.4332L138.774 66.362C137.348 66.3686 135.932 66.4029 134.53 66.4627L134.576 67.5329ZM142.976 67.4961C144.367 67.5444 145.765 67.6209 147.169 67.7275L147.25 66.6593C145.831 66.5516 144.418 66.4744 143.014 66.4255L142.976 67.4961ZM151.348 68.1341C152.731 68.2988 154.117 68.4943 155.504 68.7227L155.678 67.6657C154.275 67.4347 152.873 67.2369 151.474 67.0704L151.348 68.1341ZM159.63 69.4998C160.992 69.7896 162.354 70.1128 163.713 70.4714L163.986 69.4357C162.61 69.0725 161.231 68.7453 159.853 68.452L159.63 69.4998ZM167.74 71.6423C169.065 72.0641 170.386 72.5217 171.7 73.0166L172.078 72.0141C170.746 71.5125 169.407 71.0489 168.065 70.6216L167.74 71.6423ZM175.582 74.5975C176.854 75.1556 178.118 75.7511 179.372 76.3858L179.856 75.4299C178.583 74.7863 177.302 74.1824 176.013 73.6166L175.582 74.5975ZM183.057 78.3803C184.258 79.0738 185.447 79.8057 186.625 80.5777L187.212 79.6818C186.018 78.8987 184.811 78.1562 183.593 77.4528L183.057 78.3803ZM190.064 82.9723C191.176 83.7945 192.276 84.6554 193.362 85.5563L194.046 84.7318C192.945 83.8181 191.829 82.9449 190.7 82.1109L190.064 82.9723Z"
				fill="#21846C"
			/>
		</g>
		<defs>
			<linearGradient
				id="paint0_linear_2907_1029"
				x1="118.09"
				y1="124.117"
				x2="135.087"
				y2="124.117"
				gradientUnits="userSpaceOnUse"
			>
				<stop stop-color="#96BAE4" />
				<stop offset="1" stop-color="#96CDFF" />
			</linearGradient>
		</defs>
	</svg>
);
