import React from 'react';
import { ThemeReset } from '../icons';
import { getStrings, isProActive } from './../Helpers';

const Pagination = ({
	customTheme,
	handlePaginationModeChange,
	handleCustomThemeChange,
}) => {
	return (
		<div className="border-styles pagination-fields">
			<div className={`edit-form-group pagination-section`}>
				<h3 className="pagination-title-text">{getStrings('sel-pagination')}</h3>
				<div
					className={`utility-checkbox-wrapper pagination-selections`}
				>
					<div className="pagination-model">
						<br />

						<label
							className={`utility-checkboxees${customTheme.defaultPagination ? ' active' : ''
								}`}
							htmlFor="default_pagination"
						>
							<input
								type="checkbox"
								id="default_pagination"
								name="defaultPagination"
								checked={
									customTheme.defaultPagination &&
									customTheme.paginationStyle ==
									'default_pagination'
								}
								onChange={handlePaginationModeChange}
							/>
							<span>{getStrings('df-pagination')} </span>
							<div
								className={`control__indicator${customTheme.defaultPagination
									? ' active'
									: ''
									}`}
							></div>
						</label>
						<div className="icon">
							<svg
								onClick={() =>
									document.getElementById('default_pagination').click()
								}
								width="260"
								height="33"
								viewBox="0 0 260 33"
								fill="none"
								xmlns="http://www.w3.org/2000/svg"
							>
								<mask id="path-1-inside-1_1_13642" fill="white">
									<path d="M0 2C0 0.895431 0.895431 0 2 0H77V33H2C0.895431 33 0 32.1046 0 31V2Z" />
								</mask>
								<path
									d="M-1 2C-1 0.343146 0.343146 -1 2 -1H77V1H2C1.44772 1 1 1.44772 1 2H-1ZM77 34H2C0.343146 34 -1 32.6569 -1 31H1C1 31.5523 1.44772 32 2 32H77V34ZM2 34C0.343146 34 -1 32.6569 -1 31V2C-1 0.343146 0.343146 -1 2 -1V1C1.44772 1 1 1.44772 1 2V31C1 31.5523 1.44772 32 2 32V34ZM77 0V33V0Z"
									fill="#E0E0E0"
									mask="url(#path-1-inside-1_1_13642)"
								/>
								<path
									d="M14.916 18.2949V22H13.7676V12.1973H16.4609C17.5091 12.1973 18.3203 12.4525 18.8945 12.9629C19.4733 13.4733 19.7627 14.1934 19.7627 15.123C19.7627 16.0527 19.4414 16.8138 18.7988 17.4062C18.1608 17.9987 17.2972 18.2949 16.208 18.2949H14.916ZM14.916 13.2363V17.2559H16.1191C16.9121 17.2559 17.516 17.0758 17.9307 16.7158C18.3499 16.3512 18.5596 15.8385 18.5596 15.1777C18.5596 13.8835 17.7939 13.2363 16.2627 13.2363H14.916ZM25.1152 16.1348C24.9193 15.9844 24.6367 15.9092 24.2676 15.9092C23.7891 15.9092 23.388 16.1348 23.0645 16.5859C22.7454 17.0371 22.5859 17.6523 22.5859 18.4316V22H21.4648V15H22.5859V16.4424H22.6133C22.7728 15.9502 23.0166 15.5674 23.3447 15.2939C23.6729 15.016 24.0397 14.877 24.4453 14.877C24.737 14.877 24.9603 14.9089 25.1152 14.9727V16.1348ZM31.7666 18.7803H26.8242C26.8424 19.5596 27.0521 20.1611 27.4531 20.585C27.8542 21.0088 28.4056 21.2207 29.1074 21.2207C29.8958 21.2207 30.6204 20.9609 31.2812 20.4414V21.4941C30.666 21.9408 29.8525 22.1641 28.8408 22.1641C27.8519 22.1641 27.0749 21.8473 26.5098 21.2139C25.9447 20.5758 25.6621 19.6803 25.6621 18.5273C25.6621 17.4382 25.9697 16.5518 26.585 15.8682C27.2048 15.18 27.9727 14.8359 28.8887 14.8359C29.8047 14.8359 30.5133 15.1322 31.0146 15.7246C31.516 16.3171 31.7666 17.1396 31.7666 18.1924V18.7803ZM30.6182 17.8301C30.6136 17.1829 30.4564 16.6794 30.1465 16.3193C29.8411 15.9593 29.415 15.7793 28.8682 15.7793C28.3395 15.7793 27.8906 15.9684 27.5215 16.3467C27.1523 16.7249 26.9245 17.2194 26.8379 17.8301H30.6182ZM38.9717 15L36.1826 22H35.082L32.4297 15H33.6602L35.4375 20.0859C35.5697 20.4596 35.6517 20.7855 35.6836 21.0635H35.7109C35.7565 20.7126 35.8294 20.3958 35.9297 20.1133L37.7891 15H38.9717ZM40.7559 13.2227C40.5553 13.2227 40.3844 13.1543 40.2432 13.0176C40.1019 12.8809 40.0312 12.7077 40.0312 12.498C40.0312 12.2884 40.1019 12.1152 40.2432 11.9785C40.3844 11.8372 40.5553 11.7666 40.7559 11.7666C40.9609 11.7666 41.1341 11.8372 41.2754 11.9785C41.4212 12.1152 41.4941 12.2884 41.4941 12.498C41.4941 12.6986 41.4212 12.8695 41.2754 13.0107C41.1341 13.152 40.9609 13.2227 40.7559 13.2227ZM41.3027 22H40.1816V15H41.3027V22ZM46.498 22.1641C45.4635 22.1641 44.6364 21.8382 44.0166 21.1865C43.4014 20.5303 43.0938 19.6621 43.0938 18.582C43.0938 17.4062 43.415 16.488 44.0576 15.8271C44.7002 15.1663 45.5684 14.8359 46.6621 14.8359C47.7057 14.8359 48.5192 15.1572 49.1025 15.7998C49.6904 16.4424 49.9844 17.3333 49.9844 18.4727C49.9844 19.5892 49.6676 20.4847 49.0342 21.1592C48.4053 21.8291 47.5599 22.1641 46.498 22.1641ZM46.5801 15.7793C45.86 15.7793 45.2904 16.0254 44.8711 16.5176C44.4518 17.0052 44.2422 17.6797 44.2422 18.541C44.2422 19.3704 44.4541 20.0244 44.8779 20.5029C45.3018 20.9814 45.8691 21.2207 46.5801 21.2207C47.3047 21.2207 47.8607 20.986 48.248 20.5166C48.64 20.0472 48.8359 19.3796 48.8359 18.5137C48.8359 17.6387 48.64 16.9642 48.248 16.4902C47.8607 16.0163 47.3047 15.7793 46.5801 15.7793ZM57.4355 22H56.3145V20.8926H56.2871C55.8223 21.7402 55.1022 22.1641 54.127 22.1641C52.459 22.1641 51.625 21.1706 51.625 19.1836V15H52.7393V19.0059C52.7393 20.4824 53.3044 21.2207 54.4346 21.2207C54.9814 21.2207 55.4303 21.0202 55.7812 20.6191C56.1367 20.2135 56.3145 19.6849 56.3145 19.0332V15H57.4355V22ZM59.2812 21.7471V20.5439C59.8919 20.9951 60.5641 21.2207 61.2979 21.2207C62.2822 21.2207 62.7744 20.8926 62.7744 20.2363C62.7744 20.0495 62.7311 19.8923 62.6445 19.7646C62.5625 19.6325 62.4486 19.5163 62.3027 19.416C62.1615 19.3158 61.9928 19.2269 61.7969 19.1494C61.6055 19.0674 61.3981 18.9831 61.1748 18.8965C60.8649 18.7734 60.5915 18.6504 60.3545 18.5273C60.1221 18.3997 59.9261 18.2585 59.7666 18.1035C59.6117 17.944 59.4932 17.764 59.4111 17.5635C59.3337 17.363 59.2949 17.1283 59.2949 16.8594C59.2949 16.5312 59.3701 16.2419 59.5205 15.9912C59.6709 15.736 59.8714 15.5241 60.1221 15.3555C60.3727 15.1823 60.6576 15.0524 60.9766 14.9658C61.3001 14.8792 61.6328 14.8359 61.9746 14.8359C62.5807 14.8359 63.123 14.9408 63.6016 15.1504V16.2852C63.0866 15.9479 62.4941 15.7793 61.8242 15.7793C61.6146 15.7793 61.4255 15.8044 61.2568 15.8545C61.0882 15.9001 60.9424 15.9661 60.8193 16.0527C60.7008 16.1393 60.6074 16.2441 60.5391 16.3672C60.4753 16.4857 60.4434 16.6178 60.4434 16.7637C60.4434 16.946 60.4753 17.0986 60.5391 17.2217C60.6074 17.3447 60.7054 17.4541 60.833 17.5498C60.9606 17.6455 61.1156 17.7321 61.2979 17.8096C61.4801 17.887 61.6875 17.9714 61.9199 18.0625C62.2298 18.181 62.5078 18.304 62.7539 18.4316C63 18.5547 63.2096 18.696 63.3828 18.8555C63.556 19.0104 63.6882 19.1904 63.7793 19.3955C63.875 19.6006 63.9229 19.8444 63.9229 20.127C63.9229 20.4733 63.8454 20.7741 63.6904 21.0293C63.54 21.2845 63.3372 21.4964 63.082 21.665C62.8268 21.8337 62.5329 21.959 62.2002 22.041C61.8675 22.123 61.5189 22.1641 61.1543 22.1641C60.4342 22.1641 59.8099 22.0251 59.2812 21.7471Z"
									fill="#828282"
								/>
								<mask id="path-4-inside-2_1_13642" fill="white">
									<path d="M77 0H109V33H77V0Z" />
								</mask>
								<path
									d="M77 0V-1H76V0H77ZM77 33H76V34H77V33ZM77 1H109V-1H77V1ZM109 32H77V34H109V32ZM78 33V0H76V33H78Z"
									fill="#E0E0E0"
									mask="url(#path-4-inside-2_1_13642)"
								/>
								<path
									d="M95.9736 22H90.4297V21.0156H92.6445V13.4004L90.375 14.0771V13.0107L93.7656 11.9785V21.0156H95.9736V22Z"
									fill="#1E1E1E"
								/>
								<rect
									width="32"
									height="33"
									transform="translate(109)"
									fill={
										customTheme.paginationAciveBtnColor ||
										'#2F80ED'
									}
								/>
								<path
									d="M127.933 22H121.78V21.2412C121.78 20.9313 121.824 20.6419 121.91 20.373C121.997 20.0996 122.113 19.8444 122.259 19.6074C122.405 19.3659 122.576 19.1403 122.771 18.9307C122.967 18.7165 123.177 18.5114 123.4 18.3154C123.624 18.1149 123.852 17.9235 124.084 17.7412C124.316 17.5544 124.544 17.3675 124.768 17.1807C124.977 17.0029 125.169 16.8298 125.342 16.6611C125.515 16.488 125.663 16.3102 125.786 16.1279C125.909 15.9456 126.005 15.7542 126.073 15.5537C126.142 15.3486 126.176 15.1276 126.176 14.8906C126.176 14.6309 126.135 14.4053 126.053 14.2139C125.975 14.0179 125.864 13.8561 125.718 13.7285C125.576 13.5964 125.408 13.4984 125.212 13.4346C125.016 13.3662 124.802 13.332 124.569 13.332C124.168 13.332 123.76 13.4255 123.346 13.6123C122.931 13.7992 122.532 14.0794 122.149 14.4531V12.9287C122.35 12.7783 122.553 12.6484 122.758 12.5391C122.963 12.4251 123.175 12.3317 123.394 12.2588C123.612 12.1813 123.842 12.1243 124.084 12.0879C124.326 12.0514 124.583 12.0332 124.856 12.0332C125.299 12.0332 125.7 12.0924 126.06 12.2109C126.42 12.3249 126.727 12.4958 126.982 12.7236C127.238 12.9469 127.434 13.2272 127.57 13.5645C127.712 13.9017 127.782 14.2891 127.782 14.7266C127.782 15.123 127.732 15.4808 127.632 15.7998C127.536 16.1143 127.397 16.4082 127.215 16.6816C127.037 16.9551 126.821 17.2148 126.565 17.4609C126.31 17.707 126.025 17.96 125.711 18.2197C125.447 18.4339 125.182 18.6436 124.918 18.8486C124.658 19.0492 124.424 19.2474 124.214 19.4434C124.004 19.6348 123.833 19.8285 123.701 20.0244C123.574 20.2158 123.51 20.4095 123.51 20.6055V20.6396H127.933V22Z"
									fill="white"
								/>
								<mask id="path-8-inside-3_1_13642" fill="white">
									<path d="M141 0H173V33H141V0Z" />
								</mask>
								<path
									d="M141 1H173V-1H141V1ZM173 32H141V34H173V32Z"
									fill="#E0E0E0"
									mask="url(#path-8-inside-3_1_13642)"
								/>
								<path
									d="M154.122 21.6377V20.4277C154.792 20.9564 155.549 21.2207 156.392 21.2207C157.075 21.2207 157.62 21.0498 158.025 20.708C158.436 20.3662 158.641 19.9059 158.641 19.3271C158.641 18.0465 157.731 17.4062 155.913 17.4062H155.1V16.4561H155.872C157.49 16.4561 158.299 15.8545 158.299 14.6514C158.299 13.5394 157.681 12.9834 156.446 12.9834C155.758 12.9834 155.109 13.2181 154.498 13.6875V12.5938C155.127 12.2201 155.87 12.0332 156.727 12.0332C157.551 12.0332 158.21 12.252 158.702 12.6895C159.199 13.127 159.447 13.6875 159.447 14.3711C159.447 15.6608 158.791 16.4902 157.479 16.8594V16.8867C158.185 16.9551 158.745 17.2035 159.16 17.6318C159.579 18.0557 159.789 18.5866 159.789 19.2246C159.789 20.1042 159.472 20.8151 158.839 21.3574C158.21 21.8952 157.378 22.1641 156.344 22.1641C155.414 22.1641 154.674 21.9886 154.122 21.6377Z"
									fill="#1E1E1E"
								/>
								<mask
									id="path-11-inside-4_1_13642"
									fill="white"
								>
									<path d="M173 0H207V33H173V0Z" />
								</mask>
								<path
									d="M173 0V-1H172V0H173ZM173 33H172V34H173V33ZM173 1H207V-1H173V1ZM207 32H173V34H207V32ZM174 33V0H172V33H174Z"
									fill="#E0E0E0"
									mask="url(#path-11-inside-4_1_13642)"
								/>
								<path
									d="M186.972 22.1504C186.762 22.1504 186.582 22.0752 186.432 21.9248C186.286 21.7744 186.213 21.5944 186.213 21.3848C186.213 21.1751 186.286 20.9951 186.432 20.8447C186.582 20.6898 186.762 20.6123 186.972 20.6123C187.186 20.6123 187.368 20.6898 187.519 20.8447C187.669 20.9951 187.744 21.1751 187.744 21.3848C187.744 21.5944 187.669 21.7744 187.519 21.9248C187.368 22.0752 187.186 22.1504 186.972 22.1504ZM190.007 22.1504C189.797 22.1504 189.617 22.0752 189.467 21.9248C189.321 21.7744 189.248 21.5944 189.248 21.3848C189.248 21.1751 189.321 20.9951 189.467 20.8447C189.617 20.6898 189.797 20.6123 190.007 20.6123C190.221 20.6123 190.403 20.6898 190.554 20.8447C190.704 20.9951 190.779 21.1751 190.779 21.3848C190.779 21.5944 190.704 21.7744 190.554 21.9248C190.403 22.0752 190.221 22.1504 190.007 22.1504ZM193.042 22.1504C192.832 22.1504 192.652 22.0752 192.502 21.9248C192.356 21.7744 192.283 21.5944 192.283 21.3848C192.283 21.1751 192.356 20.9951 192.502 20.8447C192.652 20.6898 192.832 20.6123 193.042 20.6123C193.256 20.6123 193.438 20.6898 193.589 20.8447C193.739 20.9951 193.814 21.1751 193.814 21.3848C193.814 21.5944 193.739 21.7744 193.589 21.9248C193.438 22.0752 193.256 22.1504 193.042 22.1504Z"
									fill="#1E1E1E"
								/>
								<path
									d="M207.5 0.5H258C258.828 0.5 259.5 1.17157 259.5 2V31C259.5 31.8284 258.828 32.5 258 32.5H207.5V0.5Z"
									stroke="#E0E0E0"
								/>
								<path
									d="M228.202 22H226.794L221.749 14.1865C221.621 13.9906 221.517 13.7855 221.435 13.5713H221.394C221.43 13.7809 221.448 14.2298 221.448 14.918V22H220.3V12.1973H221.79L226.698 19.8877C226.903 20.2067 227.035 20.4255 227.095 20.5439H227.122C227.076 20.2614 227.054 19.7806 227.054 19.1016V12.1973H228.202V22ZM236.248 18.7803H231.306C231.324 19.5596 231.534 20.1611 231.935 20.585C232.336 21.0088 232.887 21.2207 233.589 21.2207C234.377 21.2207 235.102 20.9609 235.763 20.4414V21.4941C235.147 21.9408 234.334 22.1641 233.322 22.1641C232.333 22.1641 231.556 21.8473 230.991 21.2139C230.426 20.5758 230.144 19.6803 230.144 18.5273C230.144 17.4382 230.451 16.5518 231.066 15.8682C231.686 15.18 232.454 14.8359 233.37 14.8359C234.286 14.8359 234.995 15.1322 235.496 15.7246C235.997 16.3171 236.248 17.1396 236.248 18.1924V18.7803ZM235.1 17.8301C235.095 17.1829 234.938 16.6794 234.628 16.3193C234.323 15.9593 233.896 15.7793 233.35 15.7793C232.821 15.7793 232.372 15.9684 232.003 16.3467C231.634 16.7249 231.406 17.2194 231.319 17.8301H235.1ZM243.063 15L240.712 18.541L243.022 22H241.717L240.343 19.7305C240.256 19.5892 240.154 19.4115 240.035 19.1973H240.008C239.985 19.2383 239.878 19.416 239.687 19.7305L238.285 22H236.993L239.379 18.5684L237.096 15H238.401L239.755 17.3926C239.855 17.5703 239.953 17.7526 240.049 17.9395H240.076L241.826 15H243.063ZM247.623 21.9316C247.359 22.0775 247.01 22.1504 246.577 22.1504C245.351 22.1504 244.738 21.4668 244.738 20.0996V15.957H243.535V15H244.738V13.291L245.859 12.9287V15H247.623V15.957H245.859V19.9014C245.859 20.3708 245.939 20.7057 246.099 20.9062C246.258 21.1068 246.522 21.207 246.892 21.207C247.174 21.207 247.418 21.1296 247.623 20.9746V21.9316Z"
									fill="#1E1E1E"
								/>
							</svg>
						</div>

						{ /* Modern pagination */}
						{ /* <h4 className='pagination-name'>Modern pagination{' '}</h4> */}
						<label
							className={`utility-checkboxees${customTheme.modernPagination ? ' active' : ''
								}`}
							htmlFor="modern_pagination"
						>
							<input
								type="checkbox"
								id="modern_pagination"
								name="modernPagination"
								checked={
									customTheme.modernPagination &&
									customTheme.paginationStyle ==
									'modern_pagination'
								}
								onChange={handlePaginationModeChange}
							/>
							<span>{getStrings('md-pagination')} </span>
							<div
								className={`control__indicator${customTheme.modernPagination
									? ' active'
									: ''
									}`}
							></div>
						</label>
						<div className="icon">
							<svg
								onClick={() =>
									document
										.getElementById('modern_pagination')
										.click()
								}
								width="264"
								height="21"
								viewBox="0 0 264 21"
								fill="none"
								xmlns="http://www.w3.org/2000/svg"
							>
								<path
									fill-rule="evenodd"
									clip-rule="evenodd"
									d="M4.841 7.77545C4.97348 7.63328 5.0456 7.44523 5.04217 7.25093C5.03875 7.05663 4.96003 6.87124 4.82262 6.73383C4.68521 6.59642 4.49982 6.51771 4.30552 6.51428C4.11122 6.51085 3.92318 6.58297 3.781 6.71545L0.53 9.96545L0 10.4955L0.53 11.0255L3.78 14.2755C3.92139 14.4121 4.1108 14.4878 4.30745 14.4862C4.5041 14.4846 4.69225 14.4058 4.83137 14.2668C4.97049 14.1278 5.04946 13.9398 5.05126 13.7431C5.05306 13.5465 4.97755 13.357 4.841 13.2155L2.871 11.2455H13.25C13.4489 11.2455 13.6397 11.1664 13.7803 11.0258C13.921 10.8851 14 10.6944 14 10.4955C14 10.2965 13.921 10.1058 13.7803 9.96512C13.6397 9.82447 13.4489 9.74545 13.25 9.74545H2.871L4.841 7.77545Z"
									fill="#A4A4A4"
								/>
								<path
									d="M20.8307 12.2949V16H19.6822V6.19727H22.3756C23.4238 6.19727 24.235 6.45247 24.8092 6.96289C25.388 7.47331 25.6773 8.19336 25.6773 9.12305C25.6773 10.0527 25.3561 10.8138 24.7135 11.4062C24.0755 11.9987 23.2118 12.2949 22.1227 12.2949H20.8307ZM20.8307 7.23633V11.2559H22.0338C22.8268 11.2559 23.4306 11.0758 23.8453 10.7158C24.2646 10.3512 24.4742 9.83854 24.4742 9.17773C24.4742 7.88346 23.7086 7.23633 22.1773 7.23633H20.8307ZM35.9572 16H34.59L32.9494 13.252C32.799 12.9967 32.6532 12.7803 32.5119 12.6025C32.3706 12.4202 32.2248 12.2721 32.0744 12.1582C31.9286 12.0443 31.7691 11.9622 31.5959 11.9121C31.4273 11.8574 31.2359 11.8301 31.0217 11.8301H30.0783V16H28.9299V6.19727H31.8557C32.284 6.19727 32.6783 6.25195 33.0383 6.36133C33.4029 6.46615 33.7173 6.62793 33.9816 6.84668C34.2505 7.06543 34.4602 7.33887 34.6105 7.66699C34.7609 7.99056 34.8361 8.37109 34.8361 8.80859C34.8361 9.15039 34.7837 9.46484 34.6789 9.75195C34.5786 10.0345 34.4328 10.2874 34.2414 10.5107C34.0546 10.734 33.8267 10.9255 33.5578 11.085C33.2935 11.2399 32.995 11.3607 32.6623 11.4473V11.4746C32.8264 11.5475 32.9676 11.6318 33.0861 11.7275C33.2092 11.8187 33.3254 11.9281 33.4348 12.0557C33.5441 12.1833 33.6512 12.3291 33.7561 12.4932C33.8654 12.6527 33.9862 12.8395 34.1184 13.0537L35.9572 16ZM30.0783 7.23633V10.791H31.6369C31.924 10.791 32.1883 10.7477 32.4299 10.6611C32.676 10.5745 32.8879 10.4515 33.0656 10.292C33.2434 10.1279 33.3824 9.92969 33.4826 9.69727C33.5829 9.46029 33.633 9.19596 33.633 8.9043C33.633 8.38021 33.4621 7.97233 33.1203 7.68066C32.7831 7.38444 32.2932 7.23633 31.6506 7.23633H30.0783ZM43.9061 16H38.7107V6.19727H43.6873V7.23633H39.8592V10.4971H43.4002V11.5293H39.8592V14.9609H43.9061V16ZM54.4799 6.19727L50.85 16H49.5854L46.0307 6.19727H47.309L50.0229 13.9697C50.1094 14.2204 50.1755 14.5098 50.2211 14.8379H50.2484C50.2849 14.5645 50.3601 14.2705 50.474 13.9561L53.2426 6.19727H54.4799Z"
									fill="#A4A4A4"
								/>
								<rect
									x="65"
									width="20"
									height="21"
									rx="10"
									fill={
										customTheme.paginationAciveBtnColor ||
										'#2F80ED'
									}
								/>
								<path
									d="M76.3877 5.97852V16H74.8018V7.91992C74.5146 8.125 74.2048 8.30046 73.8721 8.44629C73.5439 8.58757 73.168 8.71289 72.7441 8.82227V7.46875C73.0085 7.38216 73.2637 7.29102 73.5098 7.19531C73.7559 7.09961 73.9974 6.99251 74.2344 6.87402C74.4759 6.75553 74.7174 6.62337 74.959 6.47754C75.2051 6.33171 75.458 6.16536 75.7178 5.97852H76.3877Z"
									fill="white"
								/>
								<path
									d="M105.789 16H99.8828V15.002L102.74 12.1377C103.469 11.4085 103.989 10.8024 104.299 10.3193C104.613 9.83171 104.771 9.31217 104.771 8.76074C104.771 8.19564 104.609 7.75814 104.285 7.44824C103.962 7.13835 103.501 6.9834 102.904 6.9834C102.029 6.9834 101.191 7.3571 100.389 8.10449V6.92871C101.154 6.33171 102.045 6.0332 103.062 6.0332C103.937 6.0332 104.625 6.27018 105.126 6.74414C105.627 7.2181 105.878 7.85384 105.878 8.65137C105.878 9.28027 105.705 9.89551 105.358 10.4971C105.012 11.0941 104.39 11.8369 103.492 12.7256L101.229 14.9609V14.9883H105.789V16Z"
									fill="#1E1E1E"
								/>
								<path
									d="M128.122 15.6377V14.4277C128.792 14.9564 129.549 15.2207 130.392 15.2207C131.075 15.2207 131.62 15.0498 132.025 14.708C132.436 14.3662 132.641 13.9059 132.641 13.3271C132.641 12.0465 131.731 11.4062 129.913 11.4062H129.1V10.4561H129.872C131.49 10.4561 132.299 9.85449 132.299 8.65137C132.299 7.53939 131.681 6.9834 130.446 6.9834C129.758 6.9834 129.109 7.2181 128.498 7.6875V6.59375C129.127 6.22005 129.87 6.0332 130.727 6.0332C131.551 6.0332 132.21 6.25195 132.702 6.68945C133.199 7.12695 133.447 7.6875 133.447 8.37109C133.447 9.66081 132.791 10.4902 131.479 10.8594V10.8867C132.185 10.9551 132.745 11.2035 133.16 11.6318C133.579 12.0557 133.789 12.5866 133.789 13.2246C133.789 14.1042 133.472 14.8151 132.839 15.3574C132.21 15.8952 131.378 16.1641 130.344 16.1641C129.414 16.1641 128.674 15.9886 128.122 15.6377Z"
									fill="#1E1E1E"
								/>
								<path
									d="M156.972 16.1504C156.762 16.1504 156.582 16.0752 156.432 15.9248C156.286 15.7744 156.213 15.5944 156.213 15.3848C156.213 15.1751 156.286 14.9951 156.432 14.8447C156.582 14.6898 156.762 14.6123 156.972 14.6123C157.186 14.6123 157.368 14.6898 157.519 14.8447C157.669 14.9951 157.744 15.1751 157.744 15.3848C157.744 15.5944 157.669 15.7744 157.519 15.9248C157.368 16.0752 157.186 16.1504 156.972 16.1504ZM160.007 16.1504C159.797 16.1504 159.617 16.0752 159.467 15.9248C159.321 15.7744 159.248 15.5944 159.248 15.3848C159.248 15.1751 159.321 14.9951 159.467 14.8447C159.617 14.6898 159.797 14.6123 160.007 14.6123C160.221 14.6123 160.403 14.6898 160.554 14.8447C160.704 14.9951 160.779 15.1751 160.779 15.3848C160.779 15.5944 160.704 15.7744 160.554 15.9248C160.403 16.0752 160.221 16.1504 160.007 16.1504ZM163.042 16.1504C162.832 16.1504 162.652 16.0752 162.502 15.9248C162.356 15.7744 162.283 15.5944 162.283 15.3848C162.283 15.1751 162.356 14.9951 162.502 14.8447C162.652 14.6898 162.832 14.6123 163.042 14.6123C163.256 14.6123 163.438 14.6898 163.589 14.8447C163.739 14.9951 163.814 15.1751 163.814 15.3848C163.814 15.5944 163.739 15.7744 163.589 15.9248C163.438 16.0752 163.256 16.1504 163.042 16.1504Z"
									fill="#1E1E1E"
								/>
								<path
									d="M188.029 10.8594V10.832C186.854 10.2852 186.266 9.49219 186.266 8.45312C186.266 7.74674 186.535 7.16797 187.072 6.7168C187.61 6.26107 188.303 6.0332 189.15 6.0332C189.916 6.0332 190.545 6.24512 191.037 6.66895C191.529 7.09277 191.775 7.63737 191.775 8.30273C191.775 9.38737 191.169 10.2305 189.957 10.832V10.8594C191.388 11.3698 192.104 12.2539 192.104 13.5117C192.104 14.3229 191.812 14.9678 191.229 15.4463C190.645 15.9248 189.834 16.1641 188.795 16.1641C187.956 16.1641 187.266 15.9271 186.724 15.4531C186.181 14.9792 185.91 14.3639 185.91 13.6074C185.91 12.3496 186.617 11.4336 188.029 10.8594ZM190.627 8.43945C190.627 7.98828 190.486 7.63281 190.203 7.37305C189.921 7.11328 189.535 6.9834 189.048 6.9834C188.592 6.9834 188.205 7.12012 187.886 7.39355C187.571 7.66243 187.414 8.00651 187.414 8.42578C187.414 9.27799 187.945 9.92057 189.007 10.3535C190.087 9.9069 190.627 9.26888 190.627 8.43945ZM188.932 11.3926C187.683 11.8893 187.059 12.6094 187.059 13.5527C187.059 14.0404 187.239 14.4414 187.599 14.7559C187.963 15.0658 188.442 15.2207 189.034 15.2207C189.599 15.2207 190.06 15.068 190.415 14.7627C190.775 14.4528 190.955 14.0632 190.955 13.5938C190.955 12.6094 190.281 11.8757 188.932 11.3926Z"
									fill="#1E1E1E"
								/>
								<path
									d="M218.367 16H216.959L211.914 8.18652C211.786 7.99056 211.681 7.78548 211.599 7.57129H211.558C211.595 7.78092 211.613 8.22982 211.613 8.91797V16H210.464V6.19727H211.955L216.863 13.8877C217.068 14.2067 217.2 14.4255 217.259 14.5439H217.287C217.241 14.2614 217.218 13.7806 217.218 13.1016V6.19727H218.367V16ZM227.532 16H222.337V6.19727H227.314V7.23633H223.486V10.4971H227.027V11.5293H223.486V14.9609H227.532V16ZM237.641 16H236.24L233.984 12.2471C233.916 12.1331 233.841 11.9714 233.759 11.7617H233.731C233.686 11.8665 233.608 12.0283 233.499 12.2471L231.175 16H229.766L233.048 11.0713L230.026 6.19727H231.434L233.437 9.64258C233.569 9.87044 233.686 10.0983 233.786 10.3262H233.813C233.959 10.0254 234.087 9.78841 234.196 9.61523L236.281 6.19727H237.6L234.517 11.0576L237.641 16ZM246.561 7.23633H243.731V16H242.582V7.23633H239.759V6.19727H246.561V7.23633Z"
									fill="#333333"
								/>
								<path
									fill-rule="evenodd"
									clip-rule="evenodd"
									d="M259.159 7.77545C259.027 7.63328 258.954 7.44523 258.958 7.25093C258.961 7.05663 259.04 6.87124 259.177 6.73383C259.315 6.59642 259.5 6.51771 259.694 6.51428C259.889 6.51085 260.077 6.58297 260.219 6.71545L263.47 9.96545L264 10.4955L263.47 11.0255L260.22 14.2755C260.079 14.4121 259.889 14.4878 259.693 14.4862C259.496 14.4846 259.308 14.4058 259.169 14.2668C259.03 14.1278 258.951 13.9398 258.949 13.7431C258.947 13.5465 259.022 13.357 259.159 13.2155L261.129 11.2455H250.75C250.551 11.2455 250.36 11.1664 250.22 11.0258C250.079 10.8851 250 10.6944 250 10.4955C250 10.2965 250.079 10.1058 250.22 9.96512C250.36 9.82447 250.551 9.74545 250.75 9.74545H261.129L259.159 7.77545Z"
									fill="#333333"
								/>
							</svg>
						</div>

						{ /* Simple/Minimal pagination  */}
						{ /* <h4 className='pagination-name'>Minimal pagination{' '}</h4> */}
						<label
							className={`utility-checkboxees${customTheme.simplePagination ? ' active' : ''
								}`}
							htmlFor="simple_pagination"
						>
							<input
								type="checkbox"
								id="simple_pagination"
								name="simplePagination"
								checked={
									customTheme.simplePagination &&
									customTheme.paginationStyle ==
									'simple_pagination'
								}
								onChange={handlePaginationModeChange}
							/>
							<span>{getStrings('minimal-pagination')} </span>
							<div
								className={`control__indicator${customTheme.simplePagination
									? ' active'
									: ''
									}`}
							></div>
						</label>
						<div className="icon">
							<svg
								onClick={() =>
									document
										.getElementById('simple_pagination')
										.click()
								}
								width="192"
								height="21"
								viewBox="0 0 192 21"
								fill="none"
								xmlns="http://www.w3.org/2000/svg"
							>
								<path
									d="M12.7706 14.8019C12.9175 14.675 13 14.5029 13 14.3235C13 14.1441 12.9175 13.972 12.7706 13.8452L8.89154 10.4959L12.7706 7.14667C12.9133 7.01906 12.9923 6.84814 12.9905 6.67074C12.9887 6.49333 12.9063 6.32363 12.761 6.19818C12.6157 6.07273 12.4192 6.00157 12.2137 6.00003C12.0082 5.99848 11.8103 6.06668 11.6625 6.18993L7.22944 10.0175C7.08253 10.1444 7 10.3165 7 10.4959C7 10.6753 7.08253 10.8474 7.22944 10.9743L11.6625 14.8019C11.8094 14.9287 12.0087 15 12.2165 15C12.4243 15 12.6236 14.9287 12.7706 14.8019Z"
									fill="#A4A4A4"
								/>
								<rect
									x="30"
									width="20"
									height="21"
									rx="4"
									fill={
										customTheme.paginationAciveBtnColor ||
										'#2F80ED'
									}
								/>
								<path
									d="M41.3877 5.97852V16H39.8018V7.91992C39.5146 8.125 39.2048 8.30046 38.8721 8.44629C38.5439 8.58757 38.168 8.71289 37.7441 8.82227V7.46875C38.0085 7.38216 38.2637 7.29102 38.5098 7.19531C38.7559 7.09961 38.9974 6.99251 39.2344 6.87402C39.4759 6.75553 39.7174 6.62337 39.959 6.47754C40.2051 6.33171 40.458 6.16536 40.7178 5.97852H41.3877Z"
									fill="white"
								/>
								<path
									d="M70.7891 16H64.8828V15.002L67.7402 12.1377C68.4694 11.4085 68.9889 10.8024 69.2988 10.3193C69.6133 9.83171 69.7705 9.31217 69.7705 8.76074C69.7705 8.19564 69.6087 7.75814 69.2852 7.44824C68.9616 7.13835 68.5013 6.9834 67.9043 6.9834C67.0293 6.9834 66.1908 7.3571 65.3887 8.10449V6.92871C66.1543 6.33171 67.0452 6.0332 68.0615 6.0332C68.9365 6.0332 69.6247 6.27018 70.126 6.74414C70.6273 7.2181 70.8779 7.85384 70.8779 8.65137C70.8779 9.28027 70.7048 9.89551 70.3584 10.4971C70.012 11.0941 69.39 11.8369 68.4922 12.7256L66.2295 14.9609V14.9883H70.7891V16Z"
									fill="#1E1E1E"
								/>
								<path
									d="M93.1221 15.6377V14.4277C93.792 14.9564 94.5485 15.2207 95.3916 15.2207C96.0752 15.2207 96.6198 15.0498 97.0254 14.708C97.4355 14.3662 97.6406 13.9059 97.6406 13.3271C97.6406 12.0465 96.7314 11.4062 94.9131 11.4062H94.0996V10.4561H94.8721C96.4899 10.4561 97.2988 9.85449 97.2988 8.65137C97.2988 7.53939 96.6813 6.9834 95.4463 6.9834C94.7581 6.9834 94.1087 7.2181 93.498 7.6875V6.59375C94.127 6.22005 94.8698 6.0332 95.7266 6.0332C96.5514 6.0332 97.21 6.25195 97.7021 6.68945C98.1989 7.12695 98.4473 7.6875 98.4473 8.37109C98.4473 9.66081 97.791 10.4902 96.4785 10.8594V10.8867C97.1849 10.9551 97.7454 11.2035 98.1602 11.6318C98.5794 12.0557 98.7891 12.5866 98.7891 13.2246C98.7891 14.1042 98.4723 14.8151 97.8389 15.3574C97.21 15.8952 96.3783 16.1641 95.3438 16.1641C94.4141 16.1641 93.6735 15.9886 93.1221 15.6377Z"
									fill="#1E1E1E"
								/>
								<path
									d="M121.972 16.1504C121.762 16.1504 121.582 16.0752 121.432 15.9248C121.286 15.7744 121.213 15.5944 121.213 15.3848C121.213 15.1751 121.286 14.9951 121.432 14.8447C121.582 14.6898 121.762 14.6123 121.972 14.6123C122.186 14.6123 122.368 14.6898 122.519 14.8447C122.669 14.9951 122.744 15.1751 122.744 15.3848C122.744 15.5944 122.669 15.7744 122.519 15.9248C122.368 16.0752 122.186 16.1504 121.972 16.1504ZM125.007 16.1504C124.797 16.1504 124.617 16.0752 124.467 15.9248C124.321 15.7744 124.248 15.5944 124.248 15.3848C124.248 15.1751 124.321 14.9951 124.467 14.8447C124.617 14.6898 124.797 14.6123 125.007 14.6123C125.221 14.6123 125.403 14.6898 125.554 14.8447C125.704 14.9951 125.779 15.1751 125.779 15.3848C125.779 15.5944 125.704 15.7744 125.554 15.9248C125.403 16.0752 125.221 16.1504 125.007 16.1504ZM128.042 16.1504C127.832 16.1504 127.652 16.0752 127.502 15.9248C127.356 15.7744 127.283 15.5944 127.283 15.3848C127.283 15.1751 127.356 14.9951 127.502 14.8447C127.652 14.6898 127.832 14.6123 128.042 14.6123C128.256 14.6123 128.438 14.6898 128.589 14.8447C128.739 14.9951 128.814 15.1751 128.814 15.3848C128.814 15.5944 128.739 15.7744 128.589 15.9248C128.438 16.0752 128.256 16.1504 128.042 16.1504Z"
									fill="#1E1E1E"
								/>
								<path
									d="M153.029 10.8594V10.832C151.854 10.2852 151.266 9.49219 151.266 8.45312C151.266 7.74674 151.535 7.16797 152.072 6.7168C152.61 6.26107 153.303 6.0332 154.15 6.0332C154.916 6.0332 155.545 6.24512 156.037 6.66895C156.529 7.09277 156.775 7.63737 156.775 8.30273C156.775 9.38737 156.169 10.2305 154.957 10.832V10.8594C156.388 11.3698 157.104 12.2539 157.104 13.5117C157.104 14.3229 156.812 14.9678 156.229 15.4463C155.645 15.9248 154.834 16.1641 153.795 16.1641C152.956 16.1641 152.266 15.9271 151.724 15.4531C151.181 14.9792 150.91 14.3639 150.91 13.6074C150.91 12.3496 151.617 11.4336 153.029 10.8594ZM155.627 8.43945C155.627 7.98828 155.486 7.63281 155.203 7.37305C154.921 7.11328 154.535 6.9834 154.048 6.9834C153.592 6.9834 153.205 7.12012 152.886 7.39355C152.571 7.66243 152.414 8.00651 152.414 8.42578C152.414 9.27799 152.945 9.92057 154.007 10.3535C155.087 9.9069 155.627 9.26888 155.627 8.43945ZM153.932 11.3926C152.683 11.8893 152.059 12.6094 152.059 13.5527C152.059 14.0404 152.239 14.4414 152.599 14.7559C152.963 15.0658 153.442 15.2207 154.034 15.2207C154.599 15.2207 155.06 15.068 155.415 14.7627C155.775 14.4528 155.955 14.0632 155.955 13.5938C155.955 12.6094 155.281 11.8757 153.932 11.3926Z"
									fill="#1E1E1E"
								/>
								<path
									d="M179.229 14.8019C179.083 14.675 179 14.5029 179 14.3235C179 14.1441 179.083 13.972 179.229 13.8452L183.108 10.4959L179.229 7.14667C179.087 7.01906 179.008 6.84814 179.009 6.67074C179.011 6.49333 179.094 6.32363 179.239 6.19818C179.384 6.07273 179.581 6.00157 179.786 6.00003C179.992 5.99848 180.19 6.06668 180.338 6.18993L184.771 10.0175C184.917 10.1444 185 10.3165 185 10.4959C185 10.6753 184.917 10.8474 184.771 10.9743L180.338 14.8019C180.191 14.9287 179.991 15 179.783 15C179.576 15 179.376 14.9287 179.229 14.8019Z"
									fill="#2A2A2A"
								/>
							</svg>
						</div>

						{ /* Tailwind pagination  */}
						{ /* <h4 className='pagination-name'>Tailwind pagination{' '}</h4> */}
						<label
							className={`utility-checkboxees${customTheme.tailwindPagination ? ' active' : ''
								}`}
							htmlFor="tailwind_pagination"
						>
							<input
								type="checkbox"
								id="tailwind_pagination"
								name="tailwindPagination"
								checked={
									customTheme.tailwindPagination &&
									customTheme.paginationStyle ==
									'tailwind_pagination'
								}
								onChange={handlePaginationModeChange}
							/>
							<span>
								{getStrings('tailwind-pagination')}{' '}
							</span>
							<div
								className={`control__indicator${customTheme.tailwindPagination
									? ' active'
									: ''
									}`}
							></div>
						</label>
						<div className="icon">
							<svg
								onClick={() =>
									document
										.getElementById('tailwind_pagination')
										.click()
								}
								width="199"
								height="21"
								viewBox="0 0 199 21"
								fill="none"
								xmlns="http://www.w3.org/2000/svg"
							>
								<path
									fill-rule="evenodd"
									clip-rule="evenodd"
									d="M9.35416 6.85402C9.40065 6.80753 9.43753 6.75234 9.46268 6.6916C9.48784 6.63087 9.50079 6.56577 9.50079 6.50002C9.50079 6.43428 9.48784 6.36918 9.46268 6.30844C9.43753 6.2477 9.40065 6.19251 9.35416 6.14602C9.30767 6.09953 9.25248 6.06266 9.19174 6.0375C9.13101 6.01234 9.06591 5.99939 9.00016 5.99939C8.93442 5.99939 8.86932 6.01234 8.80858 6.0375C8.74784 6.06266 8.69265 6.09953 8.64616 6.14602L4.64616 10.146C4.5996 10.1925 4.56266 10.2476 4.53745 10.3084C4.51224 10.3691 4.49927 10.4343 4.49927 10.5C4.49927 10.5658 4.51224 10.6309 4.53745 10.6917C4.56266 10.7524 4.5996 10.8076 4.64616 10.854L8.64616 14.854C8.74005 14.9479 8.86739 15.0007 9.00016 15.0007C9.13294 15.0007 9.26027 14.9479 9.35416 14.854C9.44805 14.7601 9.50079 14.6328 9.50079 14.5C9.50079 14.3672 9.44805 14.2399 9.35416 14.146L5.70716 10.5L9.35416 6.85402ZM15.3542 6.85402C15.4006 6.80753 15.4375 6.75234 15.4627 6.6916C15.4878 6.63087 15.5008 6.56577 15.5008 6.50002C15.5008 6.43428 15.4878 6.36918 15.4627 6.30844C15.4375 6.2477 15.4006 6.19251 15.3542 6.14602C15.3077 6.09953 15.2525 6.06266 15.1917 6.0375C15.131 6.01234 15.0659 5.99939 15.0002 5.99939C14.9344 5.99939 14.8693 6.01234 14.8086 6.0375C14.7478 6.06266 14.6926 6.09953 14.6462 6.14602L10.6462 10.146C10.5996 10.1925 10.5627 10.2476 10.5374 10.3084C10.5122 10.3691 10.4993 10.4343 10.4993 10.5C10.4993 10.5658 10.5122 10.6309 10.5374 10.6917C10.5627 10.7524 10.5996 10.8076 10.6462 10.854L14.6462 14.854C14.74 14.9479 14.8674 15.0007 15.0002 15.0007C15.1329 15.0007 15.2603 14.9479 15.3542 14.854C15.448 14.7601 15.5008 14.6328 15.5008 14.5C15.5008 14.3672 15.448 14.2399 15.3542 14.146L11.7072 10.5L15.3542 6.85402Z"
									fill="#A4A4A4"
								/>
								<rect
									x="30"
									width="20"
									height="21"
									rx="4"
									fill={
										customTheme.paginationAciveBtnColor ||
										'#2F80ED'
									}
									fill-opacity="0.15"
								/>
								<path
									d="M41.3877 5.97852V16H39.8018V7.91992C39.5146 8.125 39.2048 8.30046 38.8721 8.44629C38.5439 8.58757 38.168 8.71289 37.7441 8.82227V7.46875C38.0085 7.38216 38.2637 7.29102 38.5098 7.19531C38.7559 7.09961 38.9974 6.99251 39.2344 6.87402C39.4759 6.75553 39.7174 6.62337 39.959 6.47754C40.2051 6.33171 40.458 6.16536 40.7178 5.97852H41.3877Z"
									fill={
										customTheme.paginationAciveBtnColor ||
										'#2F80ED'
									}
								/>
								<path
									d="M70.7891 16H64.8828V15.002L67.7402 12.1377C68.4694 11.4085 68.9889 10.8024 69.2988 10.3193C69.6133 9.83171 69.7705 9.31217 69.7705 8.76074C69.7705 8.19564 69.6087 7.75814 69.2852 7.44824C68.9616 7.13835 68.5013 6.9834 67.9043 6.9834C67.0293 6.9834 66.1908 7.3571 65.3887 8.10449V6.92871C66.1543 6.33171 67.0452 6.0332 68.0615 6.0332C68.9365 6.0332 69.6247 6.27018 70.126 6.74414C70.6273 7.2181 70.8779 7.85384 70.8779 8.65137C70.8779 9.28027 70.7048 9.89551 70.3584 10.4971C70.012 11.0941 69.39 11.8369 68.4922 12.7256L66.2295 14.9609V14.9883H70.7891V16Z"
									fill="#1E1E1E"
								/>
								<path
									d="M93.1221 15.6377V14.4277C93.792 14.9564 94.5485 15.2207 95.3916 15.2207C96.0752 15.2207 96.6198 15.0498 97.0254 14.708C97.4355 14.3662 97.6406 13.9059 97.6406 13.3271C97.6406 12.0465 96.7314 11.4062 94.9131 11.4062H94.0996V10.4561H94.8721C96.4899 10.4561 97.2988 9.85449 97.2988 8.65137C97.2988 7.53939 96.6813 6.9834 95.4463 6.9834C94.7581 6.9834 94.1087 7.2181 93.498 7.6875V6.59375C94.127 6.22005 94.8698 6.0332 95.7266 6.0332C96.5514 6.0332 97.21 6.25195 97.7021 6.68945C98.1989 7.12695 98.4473 7.6875 98.4473 8.37109C98.4473 9.66081 97.791 10.4902 96.4785 10.8594V10.8867C97.1849 10.9551 97.7454 11.2035 98.1602 11.6318C98.5794 12.0557 98.7891 12.5866 98.7891 13.2246C98.7891 14.1042 98.4723 14.8151 97.8389 15.3574C97.21 15.8952 96.3783 16.1641 95.3438 16.1641C94.4141 16.1641 93.6735 15.9886 93.1221 15.6377Z"
									fill="#1E1E1E"
								/>
								<path
									d="M121.972 16.1504C121.762 16.1504 121.582 16.0752 121.432 15.9248C121.286 15.7744 121.213 15.5944 121.213 15.3848C121.213 15.1751 121.286 14.9951 121.432 14.8447C121.582 14.6898 121.762 14.6123 121.972 14.6123C122.186 14.6123 122.368 14.6898 122.519 14.8447C122.669 14.9951 122.744 15.1751 122.744 15.3848C122.744 15.5944 122.669 15.7744 122.519 15.9248C122.368 16.0752 122.186 16.1504 121.972 16.1504ZM125.007 16.1504C124.797 16.1504 124.617 16.0752 124.467 15.9248C124.321 15.7744 124.248 15.5944 124.248 15.3848C124.248 15.1751 124.321 14.9951 124.467 14.8447C124.617 14.6898 124.797 14.6123 125.007 14.6123C125.221 14.6123 125.403 14.6898 125.554 14.8447C125.704 14.9951 125.779 15.1751 125.779 15.3848C125.779 15.5944 125.704 15.7744 125.554 15.9248C125.403 16.0752 125.221 16.1504 125.007 16.1504ZM128.042 16.1504C127.832 16.1504 127.652 16.0752 127.502 15.9248C127.356 15.7744 127.283 15.5944 127.283 15.3848C127.283 15.1751 127.356 14.9951 127.502 14.8447C127.652 14.6898 127.832 14.6123 128.042 14.6123C128.256 14.6123 128.438 14.6898 128.589 14.8447C128.739 14.9951 128.814 15.1751 128.814 15.3848C128.814 15.5944 128.739 15.7744 128.589 15.9248C128.438 16.0752 128.256 16.1504 128.042 16.1504Z"
									fill="#1E1E1E"
								/>
								<path
									fill-rule="evenodd"
									clip-rule="evenodd"
									d="M154.646 6.85402C154.599 6.80753 154.562 6.75234 154.537 6.6916C154.512 6.63087 154.499 6.56577 154.499 6.50002C154.499 6.43428 154.512 6.36918 154.537 6.30844C154.562 6.2477 154.599 6.19251 154.646 6.14602C154.692 6.09953 154.748 6.06266 154.808 6.0375C154.869 6.01234 154.934 5.99939 155 5.99939C155.066 5.99939 155.131 6.01234 155.191 6.0375C155.252 6.06266 155.307 6.09953 155.354 6.14602L159.354 10.146C159.4 10.1925 159.437 10.2476 159.463 10.3084C159.488 10.3691 159.501 10.4343 159.501 10.5C159.501 10.5658 159.488 10.6309 159.463 10.6917C159.437 10.7524 159.4 10.8076 159.354 10.854L155.354 14.854C155.26 14.9479 155.133 15.0007 155 15.0007C154.867 15.0007 154.74 14.9479 154.646 14.854C154.552 14.7601 154.499 14.6328 154.499 14.5C154.499 14.3672 154.552 14.2399 154.646 14.146L158.293 10.5L154.646 6.85402ZM148.646 6.85402C148.599 6.80753 148.562 6.75234 148.537 6.6916C148.512 6.63087 148.499 6.56577 148.499 6.50002C148.499 6.43428 148.512 6.36918 148.537 6.30844C148.562 6.2477 148.599 6.19251 148.646 6.14602C148.692 6.09953 148.748 6.06266 148.808 6.0375C148.869 6.01234 148.934 5.99939 149 5.99939C149.066 5.99939 149.131 6.01234 149.191 6.0375C149.252 6.06266 149.307 6.09953 149.354 6.14602L153.354 10.146C153.4 10.1925 153.437 10.2476 153.463 10.3084C153.488 10.3691 153.501 10.4343 153.501 10.5C153.501 10.5658 153.488 10.6309 153.463 10.6917C153.437 10.7524 153.4 10.8076 153.354 10.854L149.354 14.854C149.26 14.9479 149.133 15.0007 149 15.0007C148.867 15.0007 148.74 14.9479 148.646 14.854C148.552 14.7601 148.499 14.6328 148.499 14.5C148.499 14.3672 148.552 14.2399 148.646 14.146L152.293 10.5L148.646 6.85402Z"
									fill="#333333"
								/>
							</svg>
						</div>

						{ /* Outline pagination  */}
						{ /* <h4 className='pagination-name'>Outlined pagination{' '}</h4> */}
						<label
							className={`utility-checkboxees${customTheme.outlinedPagination ? ' active' : ''
								}`}
							htmlFor="outlined_pagination"
						>
							<input
								type="checkbox"
								id="outlined_pagination"
								name="outlinedPagination"
								checked={
									customTheme.outlinedPagination &&
									customTheme.paginationStyle ==
									'outlined_pagination'
								}
								onChange={handlePaginationModeChange}
							/>
							<span>{getStrings('outline-pagination')} </span>
							<div
								className={`control__indicator${customTheme.outlinedPagination
									? ' active'
									: ''
									}`}
							></div>
						</label>
						<div className="icon">
							<svg
								onClick={() =>
									document
										.getElementById('outlined_pagination')
										.click()
								}
								width="192"
								height="21"
								viewBox="0 0 192 21"
								fill="none"
								xmlns="http://www.w3.org/2000/svg"
							>
								<rect
									width="20"
									height="21"
									rx="4"
									fill="#F2F2F2"
								/>
								<path
									d="M11.9851 6.57194C12.0358 6.53081 12.1157 6.4993 12.21 6.50001C12.3058 6.50073 12.3854 6.53445 12.4342 6.57663C12.4809 6.61691 12.4903 6.65468 12.4905 6.67577C12.4907 6.69633 12.4826 6.73245 12.4396 6.77181L8.56478 10.1175L8.12646 10.4959L8.56478 10.8744L12.4437 14.2236C12.4438 14.2236 12.4438 14.2236 12.4438 14.2236C12.4909 14.2643 12.5 14.3024 12.5 14.3235C12.5 14.3447 12.4909 14.3827 12.4439 14.4234L11.9851 6.57194ZM11.9851 6.57194L7.55626 10.3959C7.50913 10.4367 7.5 10.4748 7.5 10.4959C7.5 10.5171 7.50913 10.5552 7.55626 10.5959L11.9892 14.4234C11.9892 14.4234 11.9892 14.4234 11.9893 14.4234C12.0387 14.4661 12.1196 14.5 12.2165 14.5C12.3134 14.5 12.3943 14.4661 12.4437 14.4235L11.9851 6.57194Z"
									stroke="#BDBDBD"
								/>
								<path
									d="M40.9736 16H35.4297V15.0156H37.6445V7.40039L35.375 8.07715V7.01074L38.7656 5.97852V15.0156H40.9736V16Z"
									fill="#1E1E1E"
								/>
								<rect
									x="56.5"
									y="0.5"
									width="21"
									height="20"
									rx="3.5"
									stroke={
										customTheme.paginationAciveBtnColor ||
										'#2F80ED'
									}
								/>
								<path
									d="M69.9326 16H63.7803V15.2412C63.7803 14.9313 63.8236 14.6419 63.9102 14.373C63.9967 14.0996 64.113 13.8444 64.2588 13.6074C64.4046 13.3659 64.5755 13.1403 64.7715 12.9307C64.9674 12.7165 65.1771 12.5114 65.4004 12.3154C65.6237 12.1149 65.8516 11.9235 66.084 11.7412C66.3164 11.5544 66.5443 11.3675 66.7676 11.1807C66.9772 11.0029 67.1686 10.8298 67.3418 10.6611C67.515 10.488 67.6631 10.3102 67.7861 10.1279C67.9092 9.94564 68.0049 9.75423 68.0732 9.55371C68.1416 9.34863 68.1758 9.1276 68.1758 8.89062C68.1758 8.63086 68.1348 8.40527 68.0527 8.21387C67.9753 8.0179 67.8636 7.85612 67.7178 7.72852C67.5765 7.59635 67.4079 7.49837 67.2119 7.43457C67.016 7.36621 66.8018 7.33203 66.5693 7.33203C66.1683 7.33203 65.7604 7.42546 65.3457 7.6123C64.931 7.79915 64.5322 8.07943 64.1494 8.45312V6.92871C64.3499 6.77832 64.5527 6.64844 64.7578 6.53906C64.9629 6.42513 65.1748 6.33171 65.3936 6.25879C65.6123 6.18132 65.8424 6.12435 66.084 6.08789C66.3255 6.05143 66.583 6.0332 66.8564 6.0332C67.2985 6.0332 67.6995 6.09245 68.0596 6.21094C68.4196 6.32487 68.7272 6.49577 68.9824 6.72363C69.2376 6.94694 69.4336 7.22721 69.5703 7.56445C69.7116 7.90169 69.7822 8.28906 69.7822 8.72656C69.7822 9.12305 69.7321 9.48079 69.6318 9.7998C69.5361 10.1143 69.3971 10.4082 69.2148 10.6816C69.0371 10.9551 68.8206 11.2148 68.5654 11.4609C68.3102 11.707 68.0254 11.96 67.7109 12.2197C67.4466 12.4339 67.1823 12.6436 66.918 12.8486C66.6582 13.0492 66.4235 13.2474 66.2139 13.4434C66.0042 13.6348 65.8333 13.8285 65.7012 14.0244C65.5736 14.2158 65.5098 14.4095 65.5098 14.6055V14.6396H69.9326V16Z"
									fill={
										customTheme.paginationAciveBtnColor ||
										'#2F80ED'
									}
								/>
								<path
									d="M93.1221 15.6377V14.4277C93.792 14.9564 94.5485 15.2207 95.3916 15.2207C96.0752 15.2207 96.6198 15.0498 97.0254 14.708C97.4355 14.3662 97.6406 13.9059 97.6406 13.3271C97.6406 12.0465 96.7314 11.4062 94.9131 11.4062H94.0996V10.4561H94.8721C96.4899 10.4561 97.2988 9.85449 97.2988 8.65137C97.2988 7.53939 96.6813 6.9834 95.4463 6.9834C94.7581 6.9834 94.1087 7.2181 93.498 7.6875V6.59375C94.127 6.22005 94.8698 6.0332 95.7266 6.0332C96.5514 6.0332 97.21 6.25195 97.7021 6.68945C98.1989 7.12695 98.4473 7.6875 98.4473 8.37109C98.4473 9.66081 97.791 10.4902 96.4785 10.8594V10.8867C97.1849 10.9551 97.7454 11.2035 98.1602 11.6318C98.5794 12.0557 98.7891 12.5866 98.7891 13.2246C98.7891 14.1042 98.4723 14.8151 97.8389 15.3574C97.21 15.8952 96.3783 16.1641 95.3438 16.1641C94.4141 16.1641 93.6735 15.9886 93.1221 15.6377Z"
									fill="#1E1E1E"
								/>
								<path
									d="M121.972 16.1504C121.762 16.1504 121.582 16.0752 121.432 15.9248C121.286 15.7744 121.213 15.5944 121.213 15.3848C121.213 15.1751 121.286 14.9951 121.432 14.8447C121.582 14.6898 121.762 14.6123 121.972 14.6123C122.186 14.6123 122.368 14.6898 122.519 14.8447C122.669 14.9951 122.744 15.1751 122.744 15.3848C122.744 15.5944 122.669 15.7744 122.519 15.9248C122.368 16.0752 122.186 16.1504 121.972 16.1504ZM125.007 16.1504C124.797 16.1504 124.617 16.0752 124.467 15.9248C124.321 15.7744 124.248 15.5944 124.248 15.3848C124.248 15.1751 124.321 14.9951 124.467 14.8447C124.617 14.6898 124.797 14.6123 125.007 14.6123C125.221 14.6123 125.403 14.6898 125.554 14.8447C125.704 14.9951 125.779 15.1751 125.779 15.3848C125.779 15.5944 125.704 15.7744 125.554 15.9248C125.403 16.0752 125.221 16.1504 125.007 16.1504ZM128.042 16.1504C127.832 16.1504 127.652 16.0752 127.502 15.9248C127.356 15.7744 127.283 15.5944 127.283 15.3848C127.283 15.1751 127.356 14.9951 127.502 14.8447C127.652 14.6898 127.832 14.6123 128.042 14.6123C128.256 14.6123 128.438 14.6898 128.589 14.8447C128.739 14.9951 128.814 15.1751 128.814 15.3848C128.814 15.5944 128.739 15.7744 128.589 15.9248C128.438 16.0752 128.256 16.1504 128.042 16.1504Z"
									fill="#1E1E1E"
								/>
								<path
									d="M151.402 15.8359V14.7559C151.949 15.0658 152.528 15.2207 153.139 15.2207C154.027 15.2207 154.718 14.863 155.21 14.1475C155.707 13.432 155.955 12.4157 155.955 11.0986C155.946 11.1032 155.937 11.1032 155.928 11.0986C155.508 11.9417 154.779 12.3633 153.74 12.3633C152.902 12.3633 152.214 12.0785 151.676 11.5088C151.138 10.9391 150.869 10.2054 150.869 9.30762C150.869 8.35059 151.163 7.56673 151.751 6.95605C152.343 6.34082 153.1 6.0332 154.021 6.0332C154.987 6.0332 155.739 6.41602 156.276 7.18164C156.819 7.94271 157.09 9.05241 157.09 10.5107C157.09 12.32 156.739 13.7145 156.037 14.6943C155.335 15.6742 154.36 16.1641 153.111 16.1641C152.455 16.1641 151.885 16.0547 151.402 15.8359ZM153.918 6.9834C153.376 6.9834 152.922 7.18848 152.558 7.59863C152.198 8.00423 152.018 8.52148 152.018 9.15039C152.018 9.83854 152.195 10.3809 152.551 10.7773C152.906 11.1693 153.387 11.3652 153.993 11.3652C154.522 11.3652 154.968 11.1852 155.333 10.8252C155.702 10.4652 155.887 10.0254 155.887 9.50586C155.887 8.76302 155.704 8.1569 155.34 7.6875C154.975 7.2181 154.501 6.9834 153.918 6.9834Z"
									fill="#1E1E1E"
								/>
								<rect
									width="20"
									height="21"
									rx="4"
									transform="matrix(-1 0 0 1 192 0)"
									fill={
										customTheme.paginationAciveBtnColor ||
										'#2F80ED'
									}
								/>
								<path
									d="M179.229 14.8019C179.083 14.675 179 14.5029 179 14.3235C179 14.1441 179.083 13.972 179.229 13.8452L183.108 10.4959L179.229 7.14667C179.087 7.01906 179.008 6.84814 179.009 6.67074C179.011 6.49333 179.094 6.32363 179.239 6.19818C179.384 6.07273 179.581 6.00157 179.786 6.00003C179.992 5.99848 180.19 6.06668 180.338 6.18993L184.771 10.0175C184.917 10.1444 185 10.3165 185 10.4959C185 10.6753 184.917 10.8474 184.771 10.9743L180.338 14.8019C180.191 14.9287 179.991 15 179.783 15C179.576 15 179.376 14.9287 179.229 14.8019Z"
									fill="white"
								/>
							</svg>
						</div>
					</div>

					<div className="pagination-colors">
						<h4 className="pagination-color-title">
							{getStrings('color-picker')}{' '}
						</h4>
						<p className="pagination-color-content">
							{getStrings('pagination-color-will')}{' '}
						</p>
						<div className="theme-colors__scheme paginations-color-fields">
							<input
								className="color-picker paginations-colors paginationAciveBtnColor"
								type="color"
								name="paginationAciveBtnColor"
								id="color-picker-paginationAciveBtnColor"
								value={customTheme.paginationAciveBtnColor}
								onChange={handleCustomThemeChange}
							/>
						</div>
					</div>
				</div>
			</div>
		</div>
	);
};

export default Pagination;
