/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./assets/src/scripts/Chunk/Frontend/common_func.js":
/*!**********************************************************!*\
  !*** ./assets/src/scripts/Chunk/Frontend/common_func.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Global_Table_Config)
/* harmony export */ });
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Frontend Data table design and other config applied like pagination, shorting and so on 
var Global_Table_Config = /*#__PURE__*/function () {
  function Global_Table_Config() {
    var _this = this;

    _classCallCheck(this, Global_Table_Config);

    _defineProperty(this, "getPaginateSettings", function (tableSettings) {
      var _tableSettings$import;

      var theme = (tableSettings === null || tableSettings === void 0 ? void 0 : tableSettings.table_style) || "default-style";
      var themePageStyles = (tableSettings === null || tableSettings === void 0 ? void 0 : (_tableSettings$import = tableSettings.import_styles_theme_colors) === null || _tableSettings$import === void 0 ? void 0 : _tableSettings$import[theme]) || {};
      var PageStyles = themePageStyles.paginationStyle || 'default_pagination';
      console.log(front_end_data.strings['first']);
      console.log(front_end_data.strings['previous']);
      console.log(front_end_data.strings['next']);
      console.log(front_end_data.strings['last']);

      if (PageStyles === 'default_pagination') {
        return {
          first: "<span class='paging-first-".concat(PageStyles, "'>").concat(front_end_data.strings['first'], "</span>"),
          previous: "<span class='paging-backward-".concat(PageStyles, "'>").concat(front_end_data.strings['previous'], "</span>"),
          next: "<span class='paging-forward-".concat(PageStyles, "'>").concat(front_end_data.strings['next'], "</span>"),
          last: "<span class='paging-last-".concat(PageStyles, "'>").concat(front_end_data.strings['last'], "</span>")
        };
      } else if (PageStyles === 'modern_pagination') {
        return {
          first: "<span class='paging-first-".concat(PageStyles, "'>").concat(front_end_data.strings['first'], "</span>"),
          previous: "<span class='paging-backward-".concat(PageStyles, "'>\u2190 ").concat(front_end_data.strings['previous2'].toUpperCase(), "</span>"),
          next: "<span class='paging-forward-".concat(PageStyles, "'>").concat(front_end_data.strings['next2'].toUpperCase(), " \u2192</span>"),
          last: "<span class='paging-last-".concat(PageStyles, "'>").concat(front_end_data.strings['last'], "</span>")
        };
      } else if (PageStyles === 'tailwind_pagination') {
        return {
          first: "<span class='paging-first-".concat(PageStyles, "'>").concat(front_end_data.strings['first'], "</span>"),
          previous: "<span class='paging-backward-".concat(PageStyles, "'>").concat(_this.PaginationTailwindBack2, "</span>"),
          next: "<span class='paging-forward-".concat(PageStyles, "'>").concat(_this.PaginationTainwildNext2, "</span>"),
          last: "<span class='paging-last-".concat(PageStyles, "'>").concat(front_end_data.strings['last'], "</span>")
        };
      } else if (PageStyles === 'outlined_pagination') {
        return {
          first: "<span class='paging-first-".concat(PageStyles, "'>").concat(front_end_data.strings['first'], "</span>"),
          previous: "<span class='paging-backward-".concat(PageStyles, "'>").concat(_this.PaginationTailwindBack1, "</span>"),
          next: "<span class='paging-forward-".concat(PageStyles, "'>").concat(_this.PaginationTainwildNext1, "</span>"),
          last: "<span class='paging-last-".concat(PageStyles, "'>").concat(front_end_data.strings['last'], "</span>")
        };
      } else if (PageStyles === 'simple_pagination') {
        return {
          first: "<span class='paging-first-".concat(PageStyles, "'>").concat(front_end_data.strings['first'], "</span>"),
          previous: "<span class='paging-backward-".concat(PageStyles, "'>").concat(_this.PaginationTailwindBack1, "</span>"),
          next: "<span class='paging-forward-".concat(PageStyles, "'>").concat(_this.PaginationTainwildNext1, "</span>"),
          last: "<span class='paging-last-".concat(PageStyles, "'>").concat(front_end_data.strings['last'], "</span>")
        };
      } else {
        return {
          first: "<span class='paging-first-".concat(PageStyles, "'>").concat(front_end_data.strings['first'], "</span>"),
          previous: "<span class='paging-backward-".concat(PageStyles, "'>").concat(front_end_data.strings['previous'], "</span>"),
          next: "<span class='paging-forward-".concat(PageStyles, "'>").concat(front_end_data.strings['next'], "</span>"),
          last: "<span class='paging-last-".concat(PageStyles, "'>").concat(front_end_data.strings['last'], "</span>")
        };
      }
    });

    this.PaginationTailwindBack1 = "\n        <svg width=\"6\" height=\"9\" viewBox=\"0 0 6 9\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n        <path d=\"M5.77056 8.8019C5.91747 8.67501 6 8.50294 6 8.32353C6 8.14411 5.91747 7.97205 5.77056 7.84516L1.89154 4.49592L5.77056 1.14667C5.91331 1.01906 5.99229 0.848143 5.99051 0.670736C5.98872 0.49333 5.90631 0.323626 5.76101 0.198175C5.61572 0.0727263 5.41917 0.00156787 5.21371 2.57836e-05C5.00824 -0.00151535 4.81029 0.0666838 4.66249 0.189935L0.229439 4.01755C0.0825293 4.14443 -2.04722e-07 4.3165 -1.9688e-07 4.49592C-1.89037e-07 4.67533 0.0825294 4.8474 0.229439 4.97428L4.66249 8.8019C4.80945 8.92874 5.00873 9 5.21653 9C5.42432 9 5.62361 8.92874 5.77056 8.8019Z\" fill=\"#FFFFFF\"/>\n        </svg>\n\n        ";
    this.PaginationTainwildNext1 = "\n        <svg width=\"6\" height=\"9\" viewBox=\"0 0 6 9\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n        <path d=\"M0.229439 8.8019C0.0825295 8.67501 2.1727e-08 8.50294 2.95695e-08 8.32353C3.74119e-08 8.14411 0.0825296 7.97205 0.229439 7.84516L4.10846 4.49592L0.22944 1.14667C0.0866933 1.01906 0.00770646 0.848143 0.00949193 0.670736C0.0112774 0.49333 0.0936922 0.323626 0.238986 0.198175C0.384279 0.0727263 0.580825 0.00156787 0.786293 2.57836e-05C0.991761 -0.00151535 1.18971 0.0666838 1.33751 0.189935L5.77056 4.01755C5.91747 4.14443 6 4.3165 6 4.49592C6 4.67533 5.91747 4.8474 5.77056 4.97428L1.33751 8.8019C1.19055 8.92874 0.991266 9 0.783473 9C0.57568 9 0.376394 8.92874 0.229439 8.8019Z\" fill=\"#FFFFFF\"/>\n        </svg>\n\n        ";
    this.PaginationTailwindBack2 = "\n        <svg width=\"12\" height=\"9\" viewBox=\"0 0 12 9\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n        <path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M5.35416 0.854143C5.40065 0.807655 5.43753 0.752466 5.46268 0.691727C5.48784 0.630987 5.50079 0.565887 5.50079 0.500143C5.50079 0.434399 5.48784 0.369299 5.46268 0.30856C5.43753 0.24782 5.40065 0.192631 5.35416 0.146143C5.30767 0.0996553 5.25248 0.0627792 5.19174 0.0376201C5.13101 0.012461 5.06591 -0.000488282 5.00016 -0.000488281C4.93442 -0.00048828 4.86932 0.012461 4.80858 0.0376201C4.74784 0.0627792 4.69265 0.0996553 4.64616 0.146143L0.646161 4.14614C0.599598 4.19259 0.562655 4.24776 0.537449 4.30851C0.512242 4.36926 0.499268 4.43438 0.499268 4.50014C0.499268 4.56591 0.512242 4.63103 0.537449 4.69178C0.562655 4.75252 0.599598 4.8077 0.646161 4.85414L4.64616 8.85414C4.74005 8.94803 4.86739 9.00077 5.00016 9.00077C5.13294 9.00077 5.26027 8.94803 5.35416 8.85414C5.44805 8.76026 5.50079 8.63292 5.50079 8.50014C5.50079 8.36737 5.44805 8.24003 5.35416 8.14614L1.70716 4.50014L5.35416 0.854143ZM11.3542 0.854143C11.4006 0.807655 11.4375 0.752466 11.4627 0.691727C11.4878 0.630987 11.5008 0.565887 11.5008 0.500143C11.5008 0.434399 11.4878 0.369299 11.4627 0.30856C11.4375 0.24782 11.4006 0.192631 11.3542 0.146143C11.3077 0.0996553 11.2525 0.0627792 11.1917 0.0376201C11.131 0.012461 11.0659 -0.000488281 11.0002 -0.000488281C10.9344 -0.000488281 10.8693 0.012461 10.8086 0.0376201C10.7478 0.0627792 10.6926 0.0996553 10.6462 0.146143L6.64616 4.14614C6.5996 4.19259 6.56266 4.24776 6.53745 4.30851C6.51224 4.36926 6.49927 4.43438 6.49927 4.50014C6.49927 4.56591 6.51224 4.63103 6.53745 4.69178C6.56266 4.75252 6.5996 4.8077 6.64616 4.85414L10.6462 8.85414C10.74 8.94803 10.8674 9.00077 11.0002 9.00077C11.1329 9.00077 11.2603 8.94803 11.3542 8.85414C11.448 8.76026 11.5008 8.63292 11.5008 8.50014C11.5008 8.36737 11.448 8.24003 11.3542 8.14614L7.70716 4.50014L11.3542 0.854143Z\" fill=\"#333333\"/>\n        </svg>\n        ";
    this.PaginationTainwildNext2 = "\n        <svg width=\"12\" height=\"9\" viewBox=\"0 0 12 9\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n        <path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M6.64587 0.854143C6.59938 0.807655 6.5625 0.752466 6.53735 0.691727C6.51219 0.630987 6.49924 0.565887 6.49924 0.500143C6.49924 0.434399 6.51219 0.369299 6.53735 0.30856C6.5625 0.24782 6.59938 0.192631 6.64587 0.146143C6.69236 0.0996553 6.74755 0.0627792 6.80829 0.0376201C6.86903 0.012461 6.93413 -0.000488282 6.99987 -0.000488281C7.06561 -0.00048828 7.13071 0.012461 7.19145 0.0376201C7.25219 0.0627792 7.30738 0.0996553 7.35387 0.146143L11.3539 4.14614C11.4004 4.19259 11.4374 4.24776 11.4626 4.30851C11.4878 4.36926 11.5008 4.43438 11.5008 4.50014C11.5008 4.56591 11.4878 4.63103 11.4626 4.69178C11.4374 4.75252 11.4004 4.8077 11.3539 4.85414L7.35387 8.85414C7.25998 8.94803 7.13265 9.00077 6.99987 9.00077C6.86709 9.00077 6.73976 8.94803 6.64587 8.85414C6.55198 8.76026 6.49924 8.63292 6.49924 8.50014C6.49924 8.36737 6.55198 8.24003 6.64587 8.14614L10.2929 4.50014L6.64587 0.854143ZM0.645869 0.854143C0.599381 0.807655 0.562505 0.752466 0.537346 0.691727C0.512187 0.630987 0.499238 0.565887 0.499238 0.500143C0.499238 0.434399 0.512187 0.369299 0.537346 0.30856C0.562505 0.24782 0.599381 0.192631 0.645869 0.146143C0.692357 0.0996553 0.747546 0.0627792 0.808286 0.0376201C0.869025 0.012461 0.934126 -0.000488281 0.999869 -0.000488281C1.06561 -0.000488281 1.13071 0.012461 1.19145 0.0376201C1.25219 0.0627792 1.30738 0.0996553 1.35387 0.146143L5.35387 4.14614C5.40043 4.19259 5.43738 4.24776 5.46258 4.30851C5.48779 4.36926 5.50076 4.43438 5.50076 4.50014C5.50076 4.56591 5.48779 4.63103 5.46258 4.69178C5.43738 4.75252 5.40043 4.8077 5.35387 4.85414L1.35387 8.85414C1.25998 8.94803 1.13264 9.00077 0.999869 9.00077C0.867094 9.00077 0.739756 8.94803 0.645869 8.85414C0.551983 8.76026 0.499238 8.63292 0.499238 8.50014C0.499238 8.36737 0.551983 8.24003 0.645869 8.14614L4.29287 4.50014L0.645869 0.854143Z\" fill=\"#333333\"/>\n        </svg>\n        ";
  }

  _createClass(Global_Table_Config, [{
    key: "table_configuration",
    value: function table_configuration($, i, elem, table_name, table_settings, sheetUrl) {
      var dom = "<\"filtering_input filtering_input_".concat(i, "\"").concat(table_settings !== null && table_settings !== void 0 && table_settings.show_x_entries ? "l" : "").concat(table_settings !== null && table_settings !== void 0 && table_settings.search_bar ? "f" : "", ">rt<\"bottom_options bottom_options_").concat(i, "\"").concat(table_settings !== null && table_settings !== void 0 && table_settings.show_info_block ? "i" : "").concat(table_settings !== null && table_settings !== void 0 && table_settings.pagination ? "p" : "", ">");

      if (this.isProPluginActive()) {
        dom = "B<\"filtering_input filtering_input_".concat(i, "\"").concat(table_settings !== null && table_settings !== void 0 && table_settings.show_x_entries ? "l" : "").concat(table_settings !== null && table_settings !== void 0 && table_settings.search_bar ? "f" : "", ">rt<\"bottom_options bottom_options_").concat(i, "\"").concat(table_settings !== null && table_settings !== void 0 && table_settings.show_info_block ? "i" : "").concat(table_settings !== null && table_settings !== void 0 && table_settings.pagination ? "p" : "", ">"); // change the cell format according to feature saved at database

        this.changeRedirectionType(table_settings === null || table_settings === void 0 ? void 0 : table_settings.redirection_type, $(elem).find("#create_tables a"), $);
      } // For free it need to use without pro checked


      this.changeCellFormat(table_settings === null || table_settings === void 0 ? void 0 : table_settings.cell_format, $(elem).find("#create_tables th, td"), $);

      if (table_settings.table_view_mode === 'default-mode') {
        // Without search 
        if ($.fn.DataTable && $(elem).find("#create_tables").length) {
          $(elem).find("#create_tables").DataTable(this.table_obj($, table_name, table_settings, dom));
        }
      } else if (table_settings.table_view_mode === 'search-only-mode') {
        if ($.fn.DataTable && $(elem).find("#create_tables").length) {
          // Initialize DataTable and capture the instance
          var table = $(elem).find("#create_tables").DataTable(this.table_obj($, table_name, table_settings, dom)); // Implement Custom Search using table-specific approach instead of global

          this.setupCustomSearch(table, table_settings, elem, $);
        }
      } else {
        // Without search 
        if ($.fn.DataTable && $(elem).find("#create_tables").length) {
          $(elem).find("#create_tables").DataTable(this.table_obj($, table_name, table_settings, dom));
        }
      }

      this.setPdfUrl(sheetUrl, $(elem).find(".dt-buttons"));

      if (this.isProPluginActive()) {
        this.reveal_export_btns($, elem, table_settings);
      }

      this.swap_input_filter($, i, table_settings);
      this.swap_bottom_options($, i, table_settings); // Store table settings globally for AI features to access later

      if (!window.swptlsTableSettings) {
        window.swptlsTableSettings = {};
      } // Store by both table name and table ID for compatibility


      var tableId = $(elem).attr('id');
      window.swptlsTableSettings[table_name] = table_settings;

      if (tableId) {
        window.swptlsTableSettings[tableId] = table_settings;
      } // Initialize AI features after DataTable is ready (with delay to ensure full initialization)


      setTimeout(function () {
        try {
          // Initialize Table Prompt if enabled
          if (table_settings.show_table_prompt_fields && window.swptlsTablePrompt) {
            window.swptlsTablePrompt.initializeForTable(tableId || table_name, table_settings);
          } // Initialize AI Summary if enabled


          if (table_settings.show_ai_summary_button && window.swptlsAISummary) {
            window.swptlsAISummary.initializeForTable(tableId || table_name, table_settings);
          }
        } catch (e) {
          console.warn('Error initializing AI features:', e);
        }
      }, 100);
    }
  }, {
    key: "setupCustomSearch",
    value: function setupCustomSearch(table, table_settings, elem, $) {
      // Only setup custom search if column specific search is enabled
      if (!table_settings.enable_column_specific_search) {
        return; // Let DataTable handle default search
      } // Create a unique search function for this specific table


      var tableNode = table.table().node();
      var tableId = $(elem).attr('id');

      var searchFunction = function searchFunction(settings, data, dataIndex) {
        // Only apply to this specific table
        if (settings.nTable !== tableNode) {
          return true;
        } // Get the search term for this specific table


        var searchTerm = $(elem).find("#create_tables_filter input").val();

        if (!searchTerm) {
          return true;
        }

        searchTerm = searchTerm.toLowerCase(); // If table_search_column is specified, search only in those columns

        if (table_settings.table_search_column && table_settings.table_search_column.length > 0) {
          for (var i = 0; i < table_settings.table_search_column.length; i++) {
            var colIndex = table_settings.table_search_column[i];

            if (data[colIndex] && data[colIndex].toLowerCase().includes(searchTerm)) {
              return true;
            }
          }

          return false;
        } else {
          // Search across all columns
          for (var _i = 0; _i < data.length; _i++) {
            if (data[_i] && data[_i].toLowerCase().includes(searchTerm)) {
              return true;
            }
          }

          return false;
        }
      }; // Add the search function only if not already added


      if (!$.fn.dataTable.ext.search.includes(searchFunction)) {
        $.fn.dataTable.ext.search.push(searchFunction);
      } // Store reference for cleanup


      if (!window.swptlsSearchFunctions) {
        window.swptlsSearchFunctions = new Map();
      }

      window.swptlsSearchFunctions.set(tableId, searchFunction);
    }
  }, {
    key: "changeRedirectionType",
    value: function changeRedirectionType(type, links, $) {
      if (!links.length) return;
      $.each(links, function (i, link) {
        $(link).attr("target", type);
      });
    }
  }, {
    key: "changeCellFormat",
    value: function changeCellFormat(formatStyle, tableCell, $) {
      switch (formatStyle) {
        case "wrap":
          $.each(tableCell, function (i, cell) {
            $(cell).removeClass("clip_style");
            $(cell).removeClass("expanded_style");
            $(cell).addClass("wrap_style");
          });
          break;

        case "clip":
          $.each(tableCell, function (i, cell) {
            $(cell).removeClass("wrap_style");
            $(cell).removeClass("expanded_style");
            $(cell).addClass("clip_style");
          });
          break;

        case "expand":
          $.each(tableCell, function (i, cell) {
            $(cell).removeClass("clip_style");
            $(cell).removeClass("wrap_style");
            $(cell).addClass("expanded_style");
          });
          break;

        default:
          break;
      }
    } // Cleanup method to remove table-specific search functions

  }, {
    key: "cleanupTableSearchFunctions",
    value: function cleanupTableSearchFunctions() {
      if (window.swptlsSearchFunctions) {
        window.swptlsSearchFunctions.forEach(function (searchFunction, tableId) {
          // Remove the search function from global array
          var index = $.fn.dataTable.ext.search.indexOf(searchFunction);

          if (index > -1) {
            $.fn.dataTable.ext.search.splice(index, 1);
          }
        });
        window.swptlsSearchFunctions.clear();
      }
    }
  }, {
    key: "isProPluginActive",
    value: function isProPluginActive() {
      if (front_end_data.isProActive || front_end_data.isProActive != '') {
        return true;
      } else {
        return false;
      }
    }
  }, {
    key: "getSpreadsheetID",
    value: function getSpreadsheetID(url) {
      if (!url || url == "") return;
      var sheetID = null;
      sheetID = url.split(/\//)[5];
      if (sheetID) return sheetID;
      return null;
    }
  }, {
    key: "getGridID",
    value: function getGridID(url) {
      if (!url || url == "") return;
      var gridID = null;
      gridID = url.match(/gid=(\w+)/);

      if (gridID != null) {
        gridID = gridID[1];
      }

      if (gridID) {
        return gridID;
      }

      return null;
    } //PDF Export as PDF

  }, {
    key: "setPdfUrl",
    value: function setPdfUrl(url, elem) {
      var spreadsheetID = this.getSpreadsheetID(url);
      var gridID = this.getGridID(url);
      var pdfUrl = "https://docs.google.com/spreadsheets/d/".concat(spreadsheetID, "/export?format=pdf&id=").concat(spreadsheetID, "&gid=").concat(gridID); // Forntend part design `<a class="ui dt-button inverted button transition pdf_btn"

      elem.append("<a class=\"ui inverted button export_btns pdf_btn\"\n                href=\"".concat(pdfUrl, "\"\n                download\n                title=\"").concat(front_end_data.strings['export-pdf'], "\"\n                >\n                <span>\n                    <img src=\"").concat(front_end_data.iconsURL.filePdf, "\" />\n                </span>\n            </a>"));
    }
  }, {
    key: "table_obj",
    value: function table_obj($, table_name, table_settings, dom) {
      // Register the date format with DataTables
      if (table_settings.allow_sorting && $.fn.dataTable && $.fn.dataTable.moment) {
        $.fn.dataTable.moment('dd, MM, YYYY');
        $.fn.dataTable.moment('HH:mm MMM D, YY');
        $.fn.dataTable.moment('dddd, MMMM Do, YYYY');
        $.fn.dataTable.moment('D.M.YYYY');
        $.fn.dataTable.moment('DD/MM/YYYY');
        $.fn.dataTable.moment('DD-MM-YYYY');
        $.fn.dataTable.moment('D-MMM-YY');
        $.fn.dataTable.moment('D-MMM-YYYY');
        $.fn.dataTable.moment('MM/DD/YYYY');
        $.fn.dataTable.moment('MM-DD-YYYY');
        $.fn.dataTable.moment('D MMM YYYY');
        $.fn.dataTable.moment('YYYY/MM/DD');
        $.fn.dataTable.moment('YYYY-MM-DD');
        $.fn.dataTable.moment('YYYY-MM-DD');
        $.fn.dataTable.moment('Do MMMM YYYY');
        $.fn.dataTable.moment('D MMMM YYYY');
        $.fn.dataTable.moment('MMMM Do, YYYY');
        $.fn.dataTable.moment('dddd, MMMM D, YYYY');
        $.fn.dataTable.moment('ddd, MMM D, YYYY');
        $.fn.dataTable.moment('MMMM D, YYYY');
      }

      var table_object = {
        dom: dom,
        // order: [[2, 'desc']],
        order: table_settings.allow_singleshort ? [[table_settings.columnnumber ? table_settings.columnnumber : 0, table_settings.sorting_mode ? table_settings.sorting_mode : 'desc']] : table_settings.allow_sorting ? [] : [],
        responsive: true,
        lengthMenu: [[1, 5, 10, 15, 30, 50], [front_end_data.strings['1'], front_end_data.strings['5'], front_end_data.strings['10'], front_end_data.strings['15'], front_end_data.strings['30'], front_end_data.strings['50']]],
        language: {
          search: front_end_data.strings['search'],
          searchPlaceholder: front_end_data.strings['search-items'],
          lengthMenu: front_end_data.strings['filtering_show'] + " _MENU_ " + front_end_data.strings['filtering_entries'],
          info: front_end_data.strings['dataTables_info_showing'] + " _START_ " + front_end_data.strings['dataTables_info_to'] + " _END_ " + front_end_data.strings['dataTables_info_of'] + " _TOTAL_ " + front_end_data.strings['filtering_entries'],
          emptyTable: front_end_data.strings['data-empty-notice'],
          zeroRecords: front_end_data.strings['data-empty-notice'],
          paginate: this.getPaginateSettings(table_settings)
        },
        pagingType: 'simple_numbers',
        // simple_numbers // simple // numbers // full  // first_last_numbers // full_numbers
        pageLength: parseInt(table_settings.default_rows_per_page),
        lengthChange: true,
        ordering: table_settings.allow_sorting,
        destroy: true,
        scrollX: true
      };
      $('.gswpts_tables_container').each(function () {
        var numberOfColumns = $(this).find('thead th').length;
        var table_object = {
          order: []
        };

        for (var i = 0; i < numberOfColumns; i++) {
          // table_object.order.push([i, 'asc']);
          table_object.order.push([i, '']);
        }
      });

      if (this.isProPluginActive()) {
        table_object.buttons = [{
          text: "<img src=\"".concat(front_end_data.iconsURL.curlyBrackets, "\" />"),
          className: "ui inverted button export_btns json_btn",
          action: function action(e, dt, button, config) {
            var data = dt.buttons.exportData();
            $.fn.dataTable.fileSave(new Blob([JSON.stringify(data)]), "".concat(table_name, ".json"));
          },
          titleAttr: front_end_data.strings['export-json']
        }, {
          text: "<img src=\"".concat(front_end_data.iconsURL.fileCSV, "\" />"),
          extend: "csv",
          className: "ui inverted button export_btns csv_btn",
          title: "".concat(table_name),
          // titleAttr: "Export as CSV",
          titleAttr: front_end_data.strings['export-csv']
        }, {
          text: "<img src=\"".concat(front_end_data.iconsURL.fileExcel, "\" />"),
          extend: "excel",
          className: "ui inverted button export_btns excel_btn",
          title: "".concat(table_name),
          titleAttr: front_end_data.strings['export-excel']
        }, {
          text: "<img src=\"".concat(front_end_data.iconsURL.printIcon, "\" />"),
          extend: "print",
          className: "ui inverted button export_btns print_btn",
          title: "".concat(table_name),
          titleAttr: front_end_data.strings['print']
        }, {
          text: "<img src=\"".concat(front_end_data.iconsURL.copySolid, "\" />"),
          extend: "copy",
          className: "ui inverted button export_btns copy_btn",
          title: "".concat(table_name),
          titleAttr: front_end_data.strings['copy']
        }];
        table_object.lengthMenu = [[1, 5, 10, 15, 30, 50, 100, -1], [front_end_data.strings['1'], front_end_data.strings['5'], front_end_data.strings['10'], front_end_data.strings['15'], front_end_data.strings['30'], front_end_data.strings['50'], front_end_data.strings['100'], front_end_data.strings['All']]]; //Column is needed to hide and backend code is not used actually to hide.

        if (table_settings !== null && table_settings !== void 0 && table_settings.hide_on_desktop_col && this.screenSize() === "desktop" || table_settings !== null && table_settings !== void 0 && table_settings.hide_on_mobile_col && this.screenSize() === "mobile") {
          if (this.screenSize() === "desktop" && table_settings.hide_column) {
            table_object.columnDefs = this.hideColumnByScreen(table_settings.hide_column);
          } else if (this.screenSize() === "mobile" && table_settings.hide_column_mobile) {
            table_object.columnDefs = this.hideColumnByScreen(table_settings.hide_column_mobile);
          }
        }
      } // Table height 


      if (table_settings.vertical_scrolling) {
        table_object.scrollY = "".concat(table_settings.vertical_scrolling, "px");
      }

      return table_object;
    } // Return an array that will define the columns to hide

  }, {
    key: "hideColumnByScreen",
    value: function hideColumnByScreen(arrayValues) {
      return [{
        targets: this.convertArrayStringToInteger(arrayValues),
        visible: false,
        searchable: false
      }];
    } // get the current screen size of user if greater than 740 return desktop or return mobile

  }, {
    key: "screenSize",
    value: function screenSize() {
      // Desktop screen size
      if (screen.width > 740) {
        return "desktop";
      } else {
        return "mobile";
      }
    } // convert string to integer from arrays

  }, {
    key: "convertArrayStringToInteger",
    value: function convertArrayStringToInteger(arr) {
      if (!arr) return [];
      return arr.map(function (val) {
        return parseInt(val);
      });
    }
  }, {
    key: "reveal_export_btns",
    value: function reveal_export_btns($, elem, table_settings) {
      if (!table_settings) return;
      var export_btns = table_settings.table_export;

      if (export_btns != "empty" && export_btns) {
        export_btns.forEach(function (btn) {
          $(elem).find("." + btn + "_btn").removeClass("export_btns");
        });
      }
    }
  }, {
    key: "swap_input_filter",
    value: function swap_input_filter($, i, table_settings) {
      /* If checkbox is checked then swap filter */
      if (table_settings !== null && table_settings !== void 0 && table_settings.swap_filter_inputs) {
        $(".filtering_input_" + i + "").css("flex-direction", "row-reverse");
        $(".filtering_input_" + i + " > #create_tables_length").css({
          "margin-right": "0",
          "margin-left": "auto"
        });
        $(".filtering_input_" + i + " > #create_tables_filter").css({
          "margin-left": "0",
          "margin-right": "auto"
        });
      } else {
        /* Set back to default position */
        $(".filtering_input_" + i + "").css("flex-direction", "row");
        $(".filtering_input_" + i + " > #create_tables_length").css({
          "margin-right": "auto",
          "margin-left": "0"
        });
        $(".filtering_input_" + i + " > #create_tables_filter").css({
          "margin-left": "auto",
          "margin-right": "0"
        });
      }
    }
  }, {
    key: "swap_bottom_options",
    value: function swap_bottom_options($, i, table_settings) {
      var style = {
        flex_direction: "row-reverse",
        table_info_style: {
          margin_left: "auto",
          margin_right: 0
        },
        table_paginate_style: {
          margin_left: 0,
          margin_right: "auto"
        }
      };

      if (table_settings !== null && table_settings !== void 0 && table_settings.swap_bottom_options) {
        this.bottom_option_style($, style, i);
      } else {
        style["flex_direction"] = "row";
        style.table_info_style["margin_left"] = 0;
        style.table_info_style["margin_right"] = "auto";
        style.table_paginate_style["margin_left"] = "auto";
        style.table_paginate_style["margin_right"] = 0;
        this.bottom_option_style($, style, i);
      }
    }
  }, {
    key: "bottom_option_style",
    value: function bottom_option_style($, $arg, i) {
      $(".bottom_options_" + i + "").css("flex-direction", $arg["flex_direction"]);
      $(".bottom_options_" + i + " > #create_tables_info").css({
        "margin-left": $arg["table_info_style"]["margin_left"],
        "margin-right": $arg["table_info_style"]["margin_right"]
      });
      $(".bottom_options_" + i + " > #create_tables_paginate").css({
        "margin-left": $arg["table_paginate_style"]["margin_left"],
        "margin-right": $arg["table_paginate_style"]["margin_right"]
      });
    }
    /**
     * Header merge 
     */

  }, {
    key: "handleHeaderMergedCells",
    value: function handleHeaderMergedCells($, elem) {
      var tableHeaders = $(elem).find('.thead-item[data-merge]');

      if (tableHeaders) {
        tableHeaders.each(function (index, header) {
          // Check if the current header has the data-merge attribute.
          var dataMerge = $(header).attr('data-merge');

          if (dataMerge) {
            dataMerge = JSON.parse(dataMerge);
            var startCol = dataMerge[0];
            var numCols = dataMerge[1]; // Add parentCellstart class to the starting cell

            $(header).addClass('parentCellstart');
            $(header).css({
              'text-align': 'center'
            }); // Update colspan attribute

            $(header).attr('colspan', numCols); // Get the next cell in the row

            var nextCell = $(header).next(); // Loop through numCols starting from 1

            for (var i = 1; i < numCols; i++) {
              if (nextCell && nextCell.length) {
                $(nextCell).addClass('childCell'); // nextCell.style.display = 'none'; 

                nextCell = $(nextCell).next();
              }
            }

            $(elem).find('.childCell').css('display', 'none');
          }
        });
      }
    }
    /**
     * Table body merge
     * @param {* table body merge} $ 
     * @param {*} elem 
     */

  }, {
    key: "handleMergedCells",
    value: function handleMergedCells($, elem) {
      var tableRows = $(elem).find('.gswpts_rows');
      tableRows.each(function () {
        var cells = $(this).find('td');
        cells.each(function () {
          if ($(this).hasClass('parentCellstart')) {
            // Apply the logic from the previous conversation here
            var dataMerge = JSON.parse($(this).attr('data-merge'));
            var dataIndex = JSON.parse($(this).attr('data-index'));

            for (var i = 0; i < dataMerge[0]; i++) {
              for (var j = 0; j < dataMerge[1]; j++) {
                var targetIndex = [dataIndex[0] + i, dataIndex[1] + j];
                var targetCell = $(elem).find('[data-index="[' + targetIndex.join(',') + ']"]');

                if (targetCell) {
                  var cellDivContent = targetCell.find('.cell_div').text().trim();

                  if (cellDivContent === '') {
                    targetCell.addClass('merged-cell');
                    targetCell.hide();

                    if ($(this).hasClass('parentCellstart')) {
                      $(this).css({
                        'text-align': 'center',
                        'vertical-align': 'middle'
                      });
                    }
                  } else {
                    targetCell.addClass('normal-cell');
                  }
                }
              }
            }
          }
        });
      });
    }
    /**
     * 
     * @param {Calculate the width and fixed the header issues, zoom in/out issues} $ 
     * @param {*} Add dynamic table width in header from body td calculated on tr
     * @returns 
     */

  }, {
    key: "handleTableWidth",
    value: function handleTableWidth($, elem) {
      // Store the original table widths to prevent continuous reduction.
      if (!window.originalTableWidths) {
        window.originalTableWidths = {};
      }

      function setConsistentTableWidth(container) {
        var tableId = $(container).attr('id') || 'table-' + Math.random().toString(36).substring(2, 10);
        var table = $(container).find(".ui.celled.display.table.gswpts_tables.dataTable.no-footer"); // Get container width as a fallback.

        var containerWidth = $(container).width(); // Get the first visible row.

        var row = $(container).find("tr.gswpts_rows:visible").first();

        if (row.length > 0) {
          var rect = row[0].getBoundingClientRect();
          var rowWidth = rect.width; // Check if this is the first time we're setting width for this table.

          if (!window.originalTableWidths[tableId]) {
            // For tables with 4 or fewer columns, use container width instead of row width
            if ($(row).find('td, th').length <= 4) {
              window.originalTableWidths[tableId] = containerWidth;
            } else {
              window.originalTableWidths[tableId] = rowWidth;
            }
          } // Use the stored original width


          var targetWidth = window.originalTableWidths[tableId]; // Make sure the width is never less than the container

          if (targetWidth < containerWidth * 0.95) {
            targetWidth = containerWidth;
          } // Apply the width to the table


          table.css('width', targetWidth + "px"); // Ensure headers have proper width

          var headers = table.find("th");

          if (headers.length > 0) {
            headers.each(function () {
              var headerWidth = $(this).width();

              if (headerWidth === 0) {
                $(this).css('width', 'auto');
              }
            });
          }
        } else {
          // If no visible rows, use container width
          table.css('width', containerWidth + "px");
        }
      }

      if (elem.prevObject && elem.prevObject.length > 0) {
        elem = elem.prevObject;
      }

      if (elem.length === 0) {
        return;
      } // Apply width setting to each table container


      elem.each(function (index, container) {
        setConsistentTableWidth(container);
      }); // Handle resize events

      $(window).off('resize.tableWidth').on('resize.tableWidth', function () {
        elem.each(function (index, container) {
          setConsistentTableWidth(container);
        });
      });
    }
    /**
     * Handle paginations
     */

  }, {
    key: "handlePaginations",
    value: function handlePaginations($, elem) {
      // Store reference to 'this' for use inside nested functions
      var self = this;

      function updatePaginationContent(container, style) {
        // Find the previous/next buttons and check if they have the correct span structure
        var prevButton = container.find('.paginate_button.previous');
        var nextButton = container.find('.paginate_button.next'); // Handle Previous button

        if (prevButton.length) {
          var prevSpan = prevButton.find('span[class*="paging-backward-"]'); // If span doesn't exist or lost its class, recreate it

          if (!prevSpan.length || prevSpan.text() === 'Previous' || prevSpan.text() === 'Next') {
            var content = '';

            if (style === 'simple_pagination') {
              content = self.PaginationTailwindBack1;
            } else if (style === 'modern_pagination') {
              content = '← ' + front_end_data.strings['previous'].toUpperCase();
            } else if (style === 'tailwind_pagination') {
              content = self.PaginationTailwindBack2;
            } else if (style === 'outlined_pagination') {
              content = self.PaginationTailwindBack1;
            } else {
              content = front_end_data.strings['previous'];
            }

            prevButton.html("<span class='paging-backward-".concat(style, "'>").concat(content, "</span>"));
          }
        } // Handle Next button


        if (nextButton.length) {
          var nextSpan = nextButton.find('span[class*="paging-forward-"]'); // If span doesn't exist or lost its class, recreate it

          if (!nextSpan.length || nextSpan.text() === 'Next' || nextSpan.text() === 'Previous') {
            var content = '';

            if (style === 'simple_pagination') {
              content = self.PaginationTainwildNext1;
            } else if (style === 'modern_pagination') {
              content = front_end_data.strings['next'].toUpperCase() + ' →';
            } else if (style === 'tailwind_pagination') {
              content = self.PaginationTainwildNext2;
            } else if (style === 'outlined_pagination') {
              content = self.PaginationTainwildNext1;
            } else {
              content = front_end_data.strings['next'];
            }

            nextButton.html("<span class='paging-forward-".concat(style, "'>").concat(content, "</span>"));
          }
        }
      } // Find the pagination containers within the specified element


      var tablePage = $(elem).find('.dataTables_paginate.paging_simple_numbers');

      if (tablePage.length) {
        tablePage.each(function () {
          var container = $(this); // console.log(container)

          var style = ''; // Variable to store the detected style
          // Check for simple pagination

          if (container.find('.paging-forward-simple_pagination, .paging-backward-simple_pagination, .paging-first-simple_pagination, .paging-last-simple_pagination').length) {
            container.addClass('simple-pagination-active');
            style = 'simple_pagination';
          } else if (container.find('.paging-forward-modern_pagination, .paging-backward-modern_pagination, .paging-first-modern_pagination, .paging-last-modern_pagination').length) {
            container.addClass('modern-pagination-active');
            style = 'modern_pagination';
          } else if (container.find('.paging-forward-tailwind_pagination, .paging-backward-tailwind_pagination, .paging-first-tailwind_pagination, .paging-last-tailwind_pagination').length) {
            container.addClass('tailwind-pagination-active');
            style = 'tailwind_pagination';
          } else if (container.find('.paging-forward-outlined_pagination, .paging-backward-outlined_pagination, .paging-first-outlined_pagination, .paging-last-outlined_pagination').length) {
            container.addClass('outlined-pagination-active');
            style = 'outlined_pagination';
          } else if (container.find('.paging-forward-default_pagination, .paging-backward-default_pagination, .paging-first-default_pagination, .paging-last-default_pagination').length) {
            container.addClass('default-pagination-active');
            style = 'default_pagination';
          } else if (container.find('.paging-forward-undefined, .paging-backward-undefined, .paging-first-undefined, .paging-last-undefined').length) {
            container.addClass('default-preset-pagination-active');
            style = 'default_preset_pagination';
          } // Initial update of the pagination content


          updatePaginationContent(container, style); // Attach event listener to update content on pagination click

          container.on('click', function () {
            updatePaginationContent(container, style);
          }); // Trigger pagination design 

          var sortingElements = document.querySelectorAll('.sorting');
          var dataTablesLength = document.querySelectorAll('.dataTables_length');
          var dataTables_filter = document.querySelectorAll('.dataTables_filter');
          var createTablesFilterInputs = document.querySelectorAll('.dataTables_filter input');
          sortingElements.forEach(function (sortingElement) {
            sortingElement.addEventListener('click', function () {
              updatePaginationContent(container, style);
            });
          }); // Add a click event listener to each dataTablesLength element

          dataTablesLength.forEach(function (LengthElement) {
            LengthElement.addEventListener('click', function () {
              updatePaginationContent(container, style);
            });
          }); // Add a click event listener to each dataTables_filter element

          dataTables_filter.forEach(function (FilterElement) {
            FilterElement.addEventListener('click', function () {
              updatePaginationContent(container, style);
            });
          });
          createTablesFilterInputs.forEach(function (createTablesFilterInput) {
            createTablesFilterInput.addEventListener('input', function () {
              updatePaginationContent(container, style);
            });
          });
        });
      }
    }
    /**
     * Generate and load theme style into head
     * @param {string} themeName - The theme name to be used in the CSS class names.
     */

  }, {
    key: "loadThemeStyle",
    value: function loadThemeStyle($, elem) {
      var themeName = '';
      var classList = $(elem).attr('class').split(/\s+/);
      var gswptsCount = 0;

      var _iterator = _createForOfIteratorHelper(classList),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var className = _step.value;

          if (className.startsWith('gswpts_')) {
            gswptsCount++;

            if (gswptsCount === 3) {
              themeName = className.replace('gswpts_', '');
              break;
            }
          }
        } // Check if the themeName is a default style

      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      if (['default-style', 'style-1', 'style-2', 'style-3', 'style-4', 'style-5', 'style-6', 'style-7', 'style-8'].includes(themeName)) {
        var getCustomPropertyValue = function getCustomPropertyValue(styleString, propertyName) {
          var regex = new RegExp("".concat(propertyName, ":\\s*([^;]+);?"), 'i');
          var match = styleString.match(regex);
          return match ? match[1].trim() : null;
        };

        // Find the table element within the provided elem
        var tableElem = $(elem).find('table.ui.celled.display.table.gswpts_tables');

        if (tableElem.length === 0) {
          console.error('Table element not found');
          return;
        }

        var tableStyles = tableElem.attr('style');
        var paginationColors = getCustomPropertyValue(tableStyles, '--pagination-colors');

        var hexToRgba = function hexToRgba(hex, opacity) {
          var bigint = parseInt(hex.slice(1), 16);
          var r = bigint >> 16 & 255;
          var g = bigint >> 8 & 255;
          var b = bigint & 255;
          return "rgba(".concat(r, ", ").concat(g, ", ").concat(b, ", ").concat(opacity, ")");
        };

        var backgroundColor;
        var textColor;

        if (paginationColors) {
          backgroundColor = hexToRgba(paginationColors, 0.1);
          textColor = hexToRgba(paginationColors, 0.9);
        }

        var defaultPaginationColor = paginationColors || '#828282';
        var simplePaginationColor = paginationColors || '#000';
        var styleContent = "\n                .gswpts_".concat(themeName, " .dataTables_paginate a.paginate_button.item {\n                    color: #000;\n                }\n\n                .gswpts_").concat(themeName, " .dataTables_paginate.default-pagination-active .paginate_button.item.active {\n                    background-color: ").concat(defaultPaginationColor, " !important;\n                    color: #ffffff !important;\n                }\n\n                // Simple pagination free -------------------\n                .gswpts_").concat(themeName, " .simple-pagination-active .paginate_button, \n                .gswpts_").concat(themeName, " .simple-pagination-active .paginate_button.disabled, \n                .gswpts_").concat(themeName, " .simple-pagination-active .ellipsis{\n\n                    font-size: 14px;\n                    border: none;\n                    // margin: 0;\n                    // padding: 9px 16px;\n                    margin: 5px;\n                    padding: 5px 11px 4px 11px;\n\n                    font-weight: bold;\n                    display: flex;\n                    justify-content: center;\n                    align-items: center;\n                    flex-wrap: wrap;\n\n                }\n\n                .gswpts_").concat(themeName, " .simple-pagination-active .pagination.menu a{\n                    text-decoration: none;\n                }\n\n                .gswpts_").concat(themeName, " .dataTables_paginate.simple-pagination-active .paginate_button.item.active {\n                    background-color: ").concat(simplePaginationColor, " !important;\n                    color: #ffffff !important;\n                }\n\n                    \n                // Tailwind -----------------------------------------\n                .gswpts_").concat(themeName, " .tailwind-pagination-active .paginate_button.item.previous.disabled,\n                .gswpts_").concat(themeName, " .tailwind-pagination-active .paginate_button.item.next.disabled{\n                    border: unset !important;\n                    box-shadow: unset !important;\n                }\n\n                .gswpts_").concat(themeName, " .dataTables_paginate.tailwind-pagination-active .paginate_button.item.active {\n                    background-color: ").concat(backgroundColor, " !important;\n                    color: ").concat(textColor, " !important;\n                    border-radius: 5px !important;\n                }\n\n                .gswpts_").concat(themeName, " .dataTables_paginate.modern-pagination-active .paginate_button.item.active {\n                    background-color: ").concat(paginationColors, " !important;\n                    color: #ffffff !important;\n                }\n\n                // outlined\n               \n\n                .gswpts_").concat(themeName, " .outlined-pagination-active .paginate_button.item.previous.disabled,\n                .gswpts_").concat(themeName, " .outlined-pagination-active .paginate_button.item.next.disabled{\n                    border: unset !important;\n                    box-shadow: unset !important;\n                }\n\n                .gswpts_").concat(themeName, " .dataTables_paginate.outlined-pagination-active .paginate_button.item.active {\n                    background-color: #fff !important;\n                    border: 1px solid ").concat(paginationColors, " !important;\n                    color: ").concat(paginationColors, " !important;\n                }\n\n                .gswpts_").concat(themeName, " .dataTables_paginate.outlined-pagination-active .pagination.menu .previous\n                {\n                    background-color: ").concat(paginationColors, " !important;\n                    color: #fff !important;\n                }\n\n                .gswpts_").concat(themeName, " .dataTables_paginate.outlined-pagination-active .pagination.menu .previous.disabled\n                {\n                    background-color: #F2F2F2 !important;\n                    color: #666 !important;\n                     svg path {\n                        fill: #666 !important\n                    }\n                }\n\n                .gswpts_").concat(themeName, " .dataTables_paginate.outlined-pagination-active .pagination.menu .next\n                {\n                    background-color: ").concat(paginationColors, " !important;\n                    color: #fff !important;\n                }\n\n                .gswpts_").concat(themeName, " .dataTables_paginate.outlined-pagination-active .pagination.menu .next.disabled\n                {\n                    background-color: #F2F2F2 !important;\n                    color: #666 !important;\n                     svg path {\n                        fill: #666 !important;\n                    }\n                }\n\n                \n\n            ");

        if (tableStyles.includes('--pagination_center: 1;')) {
          // console.log("Found");
          styleContent += "\n                    .gswpts_".concat(themeName, " #create_tables_paginate#create_tables_paginate {\n                        margin-left: 40% !important;\n                        position: absolute;\n                        margin-top: 30px;\n                        margin-right: 28% !important;\n                    }\n                    \n                ");
        } // Create a <style> element and append it to the head


        var styleElement = document.createElement('style');
        styleElement.id = "swptls-default-theme-pagination-".concat(themeName);
        styleElement.textContent = styleContent;
        document.head.appendChild(styleElement); // return;
      } else {
        var _getCustomPropertyValue = function _getCustomPropertyValue(styleString, propertyName) {
          // Create a regular expression to find the property name followed by its value
          var regex = new RegExp("".concat(propertyName, ":\\s*([^;]+);?"), 'i');
          var match = styleString.match(regex);
          return match ? match[1].trim() : null;
        };

        // Find the table element within the provided elem
        var _tableElem = $(elem).find('table.ui.celled.display.table.gswpts_tables');

        if (_tableElem.length === 0) {
          console.error('Table element not found');
          return;
        }

        var _tableStyles = _tableElem.attr('style');

        var _paginationColors = _getCustomPropertyValue(_tableStyles, '--pagination-colors');

        var _hexToRgba = function _hexToRgba(hex, opacity) {
          var bigint = parseInt(hex.slice(1), 16);
          var r = bigint >> 16 & 255;
          var g = bigint >> 8 & 255;
          var b = bigint & 255;
          return "rgba(".concat(r, ", ").concat(g, ", ").concat(b, ", ").concat(opacity, ")");
        };

        var _backgroundColor;

        var _textColor;

        _backgroundColor = _hexToRgba(_paginationColors, 0.1);
        _textColor = _hexToRgba(_paginationColors, 0.9);

        var _styleContent = "\n                \n                .gswpts_".concat(themeName, " table.ui.celled.display {\n                    border: none;\n                    border-collapse: unset;\n                }   \n                    \n                // Pagination \n                // Default pagination -------------------------------------------//\n\n                .gswpts_").concat(themeName, " .default-pagination-active .paginate_button.item.previous.disabled,\n                .gswpts_").concat(themeName, " .default-pagination-active .paginate_button.item.next.disabled\n                {\n                    border: 1px solid rgba(169,161,161,0.23922) !important;\n                    box-shadow: unset !important;\n                }\n\n                .gswpts_").concat(themeName, " .dataTables_paginate.default-pagination-active{\n                --pagination-colors: ").concat(_paginationColors, ";\n                    a.paginate_button.item.active {\n                        background-color: var(--pagination-colors) !important;\n                        color: #ffffff !important;\n                    }\n                }\n\n                // Modern pagination -------------------------------------------//\n                \n                .gswpts_").concat(themeName, " .modern-pagination-active .paginate_button.item.previous.disabled,\n                .gswpts_").concat(themeName, " .modern-pagination-active .paginate_button.item.next.disabled{\n                    border: unset !important;\n                    box-shadow: unset !important;\n                }\n                \n                .gswpts_").concat(themeName, " .dataTables_paginate.modern-pagination-active{\n                --pagination-colors: ").concat(_paginationColors, ";\n                    a.paginate_button.item.active {\n                        background-color: var(--pagination-colors) !important;\n                        color: #ffffff !important;\n                        border-radius: 50%;\n                        border: transparent;\n\n                    }\n                }\n\n                .paginate_button.previous.disabled {\n                    opacity: 0.5;\n                }\n\n                .paginate_button.next.disabled .paging-forward-modern_pagination{\n                    opacity: 0.5;\n                }\n\n                .gswpts_").concat(themeName, " .dataTables_paginate.modern-pagination-active .paginate_button{\n                    box-sizing: border-box;\n                    display: inline-block;\n                    min-width: 1.5em;\n                    padding: .5em 1em;\n                    margin-left: 2px;\n                    text-align: center;\n                    text-decoration: none !important;\n                    cursor: pointer;\n                    color: inherit !important;\n                    border: 1px solid transparent;\n                    border-radius: 2px;\n                    background: transparent;\n\n                }\n\n                // Simple pagination -------------------------------------------//\n                \n                .gswpts_").concat(themeName, " .simple-pagination-active .paginate_button.item.previous.disabled,\n                .gswpts_").concat(themeName, " .simple-pagination-active .paginate_button.item.next.disabled{\n                    border: unset !important;\n                    box-shadow: unset !important;\n                }\n                \n                .gswpts_").concat(themeName, " .dataTables_paginate.simple-pagination-active{\n                --pagination-colors: ").concat(_paginationColors, ";\n                    a.paginate_button.item.active {\n                        background-color: var(--pagination-colors) !important;\n                        color: #ffffff !important;\n                        border-radius: 4px;\n                        border: transparent;\n\n                    }\n                }\n\n                .paginate_button.previous.disabled {\n                    opacity: 0.5;\n                }\n\n                .paginate_button.next.disabled .paging-forward-simple_pagination{\n                    opacity: 0.5;\n                }\n\n                .gswpts_").concat(themeName, " .dataTables_paginate.simple-pagination-active .paginate_button{\n                    box-sizing: border-box;\n                    display: inline-block;\n                    min-width: 1.5em;\n                    padding: .5em 1em;\n                    margin-left: 2px;\n                    text-align: center;\n                    text-decoration: none !important;\n                    cursor: pointer;\n                    color: inherit !important;\n                    border: 1px solid transparent;\n                    border-radius: 2px;\n                    background: transparent;\n\n                }\n\n                // Tailwind pagination -------------------------------------------//\n                \n                .gswpts_").concat(themeName, " .tailwind-pagination-active .paginate_button.item.previous.disabled,\n                .gswpts_").concat(themeName, " .tailwind-pagination-active .paginate_button.item.next.disabled{\n                    border: unset !important;\n                    box-shadow: unset !important;\n                }\n                \n                .gswpts_").concat(themeName, " .dataTables_paginate.tailwind-pagination-active{\n                --pagination-colors: ").concat(_paginationColors, ";\n                    a.paginate_button.item.active {\n                        background-color: ").concat(_backgroundColor, " !important;\n                        color: ").concat(_textColor, " !important;\n                        border-radius: 4px;\n                        border: transparent;\n\n                    }\n                }\n\n                .paginate_button.previous.disabled {\n                    opacity: 0.5;\n                }\n\n                .paginate_button.next.disabled .paging-forward-tailwind_pagination{\n                    opacity: 0.5;\n                }\n\n                .gswpts_").concat(themeName, " .dataTables_paginate.tailwind-pagination-active .paginate_button{\n                    box-sizing: border-box;\n                    display: inline-block;\n                    min-width: 1.5em;\n                    padding: .5em 1em;\n                    margin-left: 2px;\n                    text-align: center;\n                    text-decoration: none !important;\n                    cursor: pointer;\n                    color: inherit !important;\n                    border: 1px solid transparent;\n                    border-radius: 2px;\n                    background: transparent;\n\n                }\n\n                // Outline pagination -------------------------------------------//\n                \n                .gswpts_").concat(themeName, " .outlined-pagination-active .paginate_button.item.previous.disabled,\n                .gswpts_").concat(themeName, " .outlined-pagination-active .paginate_button.item.next.disabled{\n                    border: unset !important;\n                    box-shadow: unset !important;\n                }\n                \n                .gswpts_").concat(themeName, " .dataTables_paginate.outlined-pagination-active{\n                --pagination-colors: ").concat(_paginationColors, ";\n                    a.paginate_button.item.active {\n                        background-color: #ffffff !important;\n                        color: var(--pagination-colors) !important;\n                        border: 1px solid var(--pagination-colors) !important;\n                        border-radius: 5px !important;\n\n                    }\n\n                    span.paging-forward-outlined_pagination{\n                        background-color: var(--pagination-colors) !important;\n                        color: #ffffff !important;\n                        border-radius: 5px !important;\n                        padding: 10px 18px;\n                    }\n\n                    .paginate_button.previous{\n                        background-color: var(--pagination-colors) !important;\n                        border-radius: 5px !important;\n                        \n                        svg path {\n                            fill: #ffffff !important;\n                        }\n                    }\n\n                    .paginate_button.previous.disabled {\n                        background-color: #F2F2F2 !important;\n                        color: #666 !important; \n                        svg path {\n                            fill: #666 !important;\n                        }\n                    }\n\n                    .paginate_button.next.disabled .paging-forward-outlined_pagination{\n                        background-color: #F2F2F2 !important;\n                        color: #666 !important; \n                        svg path {\n                            fill: #666 !important;\n                        }\n                    }\n                }\n                    \n                .gswpts_").concat(themeName, " .dataTables_paginate.outlined-pagination-active .paginate_button{\n                    box-sizing: border-box;\n                    display: inline-block;\n                    min-width: 1.5em;\n                    padding: .5em 1em;\n                    margin-left: 2px;\n                    text-align: center;\n                    text-decoration: none !important;\n                    cursor: pointer;\n                    color: inherit !important;\n                    border: 1px solid transparent;\n                    border-radius: 2px;\n                    background: transparent;\n\n                }\n                   \n            "); // Check for border type


        if (_tableStyles.includes('--border-type: rounded;')) {
          _styleContent += "\n                    .gswpts_".concat(themeName, " thead th:first-child {\n                        border-radius: var(--border-radius) 0 0 0 !important\n                    }\n                    .gswpts_").concat(themeName, " thead th:last-child {\n                        border-radius: 0 var(--border-radius) 0 0 !important\n                    }\n                    .gswpts_").concat(themeName, " tr:last-child td:first-child {\n                        border-radius: 0 0 0 var(--border-radius) !important\n                    }\n                    .gswpts_").concat(themeName, " tr:last-child td:last-child {\n                        border-radius: 0 0 var(--border-radius) 0 !important\n                    }\n                ");
        } // Outside border 


        _styleContent += "\n                /* .gswpts_".concat(themeName, " tbody tr td:first-child {\n                    border-left: 1px solid var(--outside-border-color) !important;\n                }\n\n                .gswpts_").concat(themeName, "  tbody tr td:last-child {\n                    border-right: 1px solid var(--outside-border-color) !important;\n                } */\n\n                .gswpts_").concat(themeName, " tbody tr:last-child td {\n                    border-bottom: 1px solid var(--outside-border-color) !important;\n                }\n\n            "); // Roundeed border 

        if (_tableStyles.includes('--border-type: rounded;')) {
          _styleContent += "\n                    .gswpts_".concat(themeName, " thead th:first-child {\n                        border-radius: var(--border-radius) 0 0 0 !important;\n                        border-right: none !important;\n                    }\n\n                    .gswpts_").concat(themeName, " thead th:last-child {\n                        border-radius: 0 var(--border-radius) 0 0 !important;\n                        border-left: none !important;\n                    }\n\n                    .gswpts_").concat(themeName, " tr:last-child td:first-child {\n                        border-radius: 0 0 0 var(--border-radius) !important;\n                    }\n\n                    .gswpts_").concat(themeName, " tr:last-child td:last-child {\n                        border-radius: 0 0 var(--border-radius) 0 !important;\n                    }\n                ");
        } // Check for column color activation


        if (_tableStyles.includes('--active-row-column-mode: 1;') && _tableStyles.includes('--column-color-active: 1;')) {
          _styleContent += "\n                    .gswpts_".concat(themeName, " tbody td:nth-child(odd) {\n                        background-color: var(--body-bg-color-odd) !important;\n                    }\n                    .gswpts_").concat(themeName, " tbody td:nth-child(even) {\n                        background-color: var(--body-bg-color-even) !important;\n                    }\n                ");
        } // Check for row color activation


        if (_tableStyles.includes('--active-row-column-mode: 1;') && _tableStyles.includes('--row-color-active: 1;')) {
          _styleContent += "\n                    .gswpts_".concat(themeName, " tbody tr:nth-child(even) > td {\n                        background-color: var(--body-bg-color-even) !important;\n                    }\n                    .gswpts_").concat(themeName, " tbody tr:nth-child(odd) > td {\n                        background-color: var(--body-bg-color-odd) !important;\n                    }\n                ");
        } // Hover 
        // Check for column hover activation


        if (_tableStyles.includes('--hover-mode-row: 1;')) {
          _styleContent += "\n                    .gswpts_".concat(themeName, " tbody tr:hover td,\n                    .gswpts_").concat(themeName, " tbody tr:hover th {\n                        background-color: var(--hover-bg-color) !important;\n                        color: var(--hover-text-color) !important;\n                    }\n                ");
        }

        if (_tableStyles.includes('--hover-mode-col: 1;')) {
          _styleContent += "\n                    .gswpts_".concat(themeName, " table {\n                        overflow: hidden;\n                    }\n                    .gswpts_").concat(themeName, " td, th{\n                        border: 1px solid #999;\n                        padding: 10px;\n                        position: relative;\n                    }\n                    .gswpts_").concat(themeName, " td:hover::after { \n                        background-color: var(--hover-bg-color) !important;\n                        opacity: 0.2; \n                        content: '';  \n                        height: 10000px;    \n                        left: 0;\n                        position: absolute;  \n                        top: -5000px;\n                        width: 100%;\n                        z-index: 1;     \n                        transition: 300ms;  \n                    }\n                ");
        }

        if (_tableStyles.includes('--hover-mode-none: 1;')) {
          _styleContent += "\n                    .gswpts_".concat(themeName, " tbody td:hover,\n                    .gswpts_").concat(themeName, " tbody th:hover {\n                        background-color: var(--body-bg-color);\n                            color: var(--body-text-color);\n                    }\n                ");
        }

        if (_tableStyles.includes('--pagination_center: 1;')) {
          // console.log("Found");
          _styleContent += "\n                    .gswpts_".concat(themeName, " #create_tables_paginate#create_tables_paginate {\n                        margin-left: 40% !important;\n                    }\n                    \n                ");
        } // Create a <style> element and append it to the head


        var _styleElement = document.createElement('style');

        _styleElement.id = "swptls-custom-theme-style-".concat(themeName);
        _styleElement.textContent = _styleContent;
        document.head.appendChild(_styleElement);
      }
    }
    /**
     * Sort disable and hide from table
     * @returns 
     */

  }, {
    key: "handleSortingDisable",
    value: function handleSortingDisable($, elem) {
      // Check if elem has a prevObject, and use it if present
      if (elem.prevObject && elem.prevObject.length > 0) {
        elem = elem.prevObject;
      } // Check if the element exists


      if (elem.length === 0) {
        console.log("No element found within the given object.");
        return;
      } // Iterate over the table containers


      elem.each(function (index, container) {
        var wrapper = $(container).find("#create_tables_wrapper");
        var sortingHeaders = wrapper.find("th.thead-item, th.sorting_asc, th.sorting_desc"); // to hide full sorting 
        // Disable click and pointer events

        sortingHeaders.css({
          "pointer-events": "none",
          "cursor": "default"
        }); // Add a class to hide the sorting icon

        sortingHeaders.each(function () {
          var element = $(this); // Add class to hide ::after icons

          element.addClass("sorting-icon-hidden");
        });
      });
    } // Updaet one with fix empty search click issues 

    /**
     * Search wise table show and hide 
     * @returns 
     */

  }, {
    key: "handleSearchoptions",
    value: function handleSearchoptions($, elem, search_by) {
      if (elem.prevObject && elem.prevObject.length > 0) {
        elem = elem.prevObject;
      }

      if (elem.length === 0) {
        console.log("No element found within the given object.");
        return;
      }

      elem.each(function (index, container) {
        var wrapper = $(container).find("#create_tables_wrapper");
        var searchInput = wrapper.find("#create_tables_filter input[type='search']");
        var tableContainer = wrapper.find(".dataTables_scroll");
        var paginationContainer = wrapper.find(".bottom_options.bottom_options_0");

        if (searchInput.length === 0) {
          console.log('Search input not found inside #create_tables_filter for container:', container);
          return;
        }

        if (tableContainer.length === 0) {
          console.log('Table container not found for container:', container);
          return;
        }

        wrapper.find(".dataTables_length").hide();

        function toggleTableVisibility() {
          var searchTerm = searchInput.val(); // Condition for search-by-typing

          if (search_by === 'search-by-typing') {
            if (!searchTerm || searchTerm.length < 1) {
              tableContainer.hide();
              paginationContainer.hide(); // Hide pagination when table is hidden
            } else {
              tableContainer.show();
              paginationContainer.show(); // Show pagination when table is visible
            }
          } // Condition for search-by-press
          else if (search_by === 'search-by-press') {
            tableContainer.hide(); // Initially hide the table

            paginationContainer.hide(); // Initially hide pagination
            // Wait for the button click or Enter key event to show the table

            $(document).on('keypress', function (event) {
              if (event.which == 13) {
                // Enter key press
                var searchTerm = searchInput.val(); // Check the value again

                if (searchTerm && searchTerm.length >= 1) {
                  tableContainer.show(); // Show the table only if search term is valid

                  paginationContainer.show(); // Show pagination when table is visible
                } else {
                  tableContainer.hide(); // Keep table hidden if search is empty

                  paginationContainer.hide(); // Keep pagination hidden

                  console.log("Search is empty. Table will not be shown.");
                }
              }
            });
          }
        }

        toggleTableVisibility();
        searchInput.on('input', function () {
          toggleTableVisibility();
        });
        wrapper.find("#create_tables_filter").css({
          width: '100%'
        });
      });
    }
    /**
    * Sticky header and column 
    * @returns 
    */

  }, {
    key: "handleSticky",
    value: function handleSticky($, elem, enable_fixed_columns, left_columns, right_columns, enable_fixed_headers, header_offset) {
      if (elem.prevObject && elem.prevObject.length > 0) {
        elem = elem.prevObject;
      }

      if (elem.length === 0) {
        console.log("No element found within the given object.");
        return;
      } // Find the table and scroll elements


      var tableElem = $(elem).find('div.dataTables_scrollHead thead th');
      var bodyElem = $(elem).find('div.dataTables_scrollBody tbody td');
      var scrollElem = $(elem).find('div.dataTables_scroll');

      if (tableElem.length === 0) {
        console.error('Table element not found');
        return;
      } // Enable fixed headers


      if (enable_fixed_headers) {
        $(elem).find('div.dataTables_scrollHead').addClass('fixed-header-active').css({
          position: 'sticky',
          top: "".concat(header_offset, "px"),
          zIndex: 100,
          boxShadow: '0px 2px 5px rgba(0,0,0,0.1)'
        });
      } // Handle left sticky columns


      if (enable_fixed_columns && left_columns > 0) {
        var leftWidth = 0;
        $(tableElem).each(function (index) {
          if (index < left_columns) {
            var columnWidth = $(this).outerWidth();
            leftWidth += columnWidth; // Apply sticky position for headers and add a class

            $(this).addClass("sticky-applied-lft sticky-left-head sticky-left-col-".concat(index + 1)).css({
              position: 'sticky',
              left: "".concat(leftWidth - columnWidth, "px"),
              zIndex: 2,
              boxShadow: '2px 0px 5px rgba(0,0,0,0.1)'
            }); // Apply sticky position for body cells and add a class

            $(bodyElem).each(function () {
              var cell = $(this).parent().children(":nth-child(".concat(index + 1, ")"));
              cell.addClass("sticky-applied-lft sticky-left-body sticky-left-col-".concat(index + 1)).css({
                position: 'sticky',
                left: "".concat(leftWidth - columnWidth, "px"),
                zIndex: 1,
                boxShadow: '2px 0px 5px rgba(0,0,0,0.1)'
              });
            });
          }
        });
      } // Handle right sticky columns


      if (enable_fixed_columns && right_columns > 0) {
        var rightWidth = 0;
        $(tableElem.get().reverse()).each(function (reverseIndex) {
          var totalColumns = tableElem.length;
          var columnIndex = totalColumns - reverseIndex - 1;

          if (reverseIndex < right_columns) {
            var columnWidth = $(this).outerWidth();
            rightWidth += columnWidth; // Apply sticky position for headers and add a class

            $(this).addClass("sticky-applied-rgt sticky-right-head sticky-right-col-".concat(reverseIndex + 1)).css({
              position: 'sticky',
              right: "".concat(rightWidth - columnWidth, "px"),
              zIndex: 2,
              boxShadow: '-2px 0px 5px rgba(0,0,0,0.1)'
            }); // Apply sticky position for body cells and add a class

            $(bodyElem).each(function () {
              var cell = $(this).parent().children(":nth-child(".concat(columnIndex + 1, ")"));
              cell.addClass("sticky-applied-rgt sticky-right-body sticky-right-col-".concat(reverseIndex + 1)).css({
                position: 'sticky',
                right: "".concat(rightWidth - columnWidth, "px"),
                zIndex: 1,
                boxShadow: '-2px 0px 5px rgba(0,0,0,0.1)'
              });
            });
          }
        });
      } // Add fixed columns class for easier styling


      if (enable_fixed_columns) {
        scrollElem.addClass('fixed-col-active');
      }
    }
    /**
     * Create search button and disable the search auto and serch using search button
     * @returns Search button empty press issue fix 
     */

  }, {
    key: "CreateSearchoptions",
    value: function CreateSearchoptions($, elem, search_by) {
      if (elem.prevObject && elem.prevObject.length > 0) {
        elem = elem.prevObject;
      }

      if (elem.length === 0) {
        console.log("No element found within the given object.");
        return;
      }

      elem.each(function (index, container) {
        var table = $(container).find('#create_tables').DataTable();
        var filter_input = $(container).find('#create_tables_filter input[type="search"]').unbind();
        var wrapper = $(container).find("#create_tables_wrapper");
        var tableContainer = $(container).find(".dataTables_scroll");
        var paginationContainer = $(container).find(".bottom_options.bottom_options_0"); // Check if search_by is 'search-by-press' and add the class

        if (search_by === 'search-by-press') {
          $(container).find('#create_tables_filter').addClass('searchBypress');
        } // Create Search button front_end_data.strings['search']


        var search_button = $('<button type="button" class="ui button search-by-press search-btn"></button>').text(front_end_data.strings['search-btn']).click(function () {
          var searchTerm = filter_input.val(); // Ensure the search only triggers if there is a valid input

          if (searchTerm && searchTerm.trim().length > 0) {
            table.search(searchTerm).draw(); // Show table and pagination if there is valid input

            if (search_by === 'search-by-press') {
              tableContainer.show();
              paginationContainer.show(); // Show pagination when showing table
            }
          } else {
            // Keep the table and pagination hidden if search input is empty
            tableContainer.hide();
            paginationContainer.hide(); // Hide pagination when hiding table

            /* console.log("Search input is empty. Table will not be shown."); */
          }
        }); // Create Clear button front_end_data.strings['clear']

        var clear_button = $('<button type="button" class="ui button search-by-press clear-btn"></button>').text(front_end_data.strings['clear-btn']).click(function () {
          filter_input.val('');
          table.search('').draw(); // Hide table and pagination when cleared

          if (search_by === 'search-by-press') {
            tableContainer.hide();
            paginationContainer.hide(); // Hide pagination when hiding table
          } else if (search_by === 'search-by-typing') {
            tableContainer.hide();
            paginationContainer.hide(); // Also handle the typing case for clear button
          }
        }); // Append the search and clear buttons

        $(container).find('#create_tables_filter').append(search_button, clear_button); // Handle Enter keypress event

        $(document).keypress(function (event) {
          if (event.which == 13) {
            // Enter key is pressed
            search_button.click();
          }
        });
      });
    }
  }, {
    key: "html_loader",
    value: function html_loader() {
      var loader = "\n               <div class=\"ui segment gswpts_table_loader\">\n                        <div class=\"ui active inverted dimmer\">\n                            <div class=\"ui large text loader\">Loading</div>\n                        </div>\n                        <p></p>\n                        <p></p>\n                        <p></p>\n                </div>\n            ";
      return loader;
    }
  }, {
    key: "clearOverflow",
    value: function clearOverflow() {
      if (/Android|webOS|iPhone|iPad|Mac|Macintosh|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {
        if (this.detectBrowser() == "Chrome" || this.detectBrowser() == "Safari" || this.detectBrowser() == "MSIE") {
          var tableScrollBody = document.querySelectorAll(".gswpts_tables_container .dataTables_scrollBody");

          if (tableScrollBody) {
            tableScrollBody.forEach(function (element) {
              if (element.parentElement.parentElement.parentElement.parentElement.classList.contains("collapse_style")) {
                element.style.overflow = "unset";
                element.style.height = "unset";
                element.style.maxHeight = "unset";
              }
            });
          } // this.hideEmptyCell();

        }
      }
    }
  }, {
    key: "detectBrowser",
    value: function detectBrowser() {
      if ((navigator.userAgent.indexOf("Opera") || navigator.userAgent.indexOf("OPR")) != -1) {
        return "Opera";
      } else if (navigator.userAgent.indexOf("Chrome") != -1) {
        return "Chrome";
      } else if (navigator.userAgent.indexOf("Safari") != -1) {
        return "Safari";
      } else if (navigator.userAgent.indexOf("Firefox") != -1) {
        return "Firefox";
      } else if (navigator.userAgent.indexOf("MSIE") != -1 || !!document.documentMode == true) {
        return "IE"; //crap
      } else {
        return "Unknown";
      }
    }
  }, {
    key: "hideEmptyCell",
    value: function hideEmptyCell() {
      var tableCells = document.querySelectorAll(".gswpts_tables_container td");
      if (!tableCells) return;
      tableCells.forEach(function (element) {
        if (element.innerText == "") {
          // element.style.display = "none";
          element.innerText = "No data";
        }
      });
    }
  }, {
    key: "bindDragScroll",
    value: function bindDragScroll($container, $scroller) {
      var $window = jQuery(window);
      var x = 0;
      var y = 0;
      var x2 = 0;
      var y2 = 0;
      var t = 0;
      $container.on("mousedown", down);
      $container.on("click", preventDefault);
      $scroller.on("mousewheel", horizontalMouseWheel); // prevent macbook trigger prev/next page while scrolling

      function down(evt) {
        if (evt.button === 0) {
          t = Date.now();
          x = x2 = evt.pageX;
          y = y2 = evt.pageY;
          $container.addClass("down");
          $window.on("mousemove", move);
          $window.on("mouseup", up);
          evt.preventDefault();
        }
      }

      function move(evt) {
        // alert("move");
        if ($container.hasClass("down")) {
          var _x = evt.pageX;
          var _y = evt.pageY;
          var deltaX = _x - x;
          var deltaY = _y - y;
          $scroller[0].scrollLeft -= deltaX;
          x = _x;
          y = _y;
        }
      }

      function up(evt) {
        $window.off("mousemove", move);
        $window.off("mouseup", up);
        var deltaT = Date.now() - t;
        var deltaX = evt.pageX - x2;
        var deltaY = evt.pageY - y2;

        if (deltaT <= 300) {
          $scroller.stop().animate({
            scrollTop: "-=" + deltaY * 3,
            scrollLeft: "-=" + deltaX * 3
          }, 500, function (x, t, b, c, d) {
            // easeOutCirc function from http://gsgd.co.uk/sandbox/jquery/easing/
            return c * Math.sqrt(1 - (t = t / d - 1) * t) + b;
          });
        }

        t = 0;
        $container.removeClass("down");
      }

      function preventDefault(evt) {
        if (x2 !== evt.pageX || y2 !== evt.pageY) {
          evt.preventDefault();
          return false;
        }
      }

      function horizontalMouseWheel(evt) {
        evt = evt.originalEvent;
        var x = $scroller.scrollLeft();
        var max = $scroller[0].scrollWidth - $scroller[0].offsetWidth;
        var dir = evt.deltaX || evt.wheelDeltaX;
        var stop = dir > 0 ? x >= max : x <= 0;

        if (stop && dir) {
          evt.preventDefault();
        }
      }
    }
  }, {
    key: "addGrabCursonOnMouseDown",
    value: function addGrabCursonOnMouseDown(elem) {
      elem.mousedown(function (e) {
        elem.css({
          cursor: "grab"
        });
      });
      elem.mouseup(function (e) {
        elem.css({
          cursor: "auto"
        });
      });
    }
  }]);

  return Global_Table_Config;
}();



/***/ }),

/***/ "./assets/src/scripts/Chunk/Frontend/create_tab.js":
/*!*********************************************************!*\
  !*** ./assets/src/scripts/Chunk/Frontend/create_tab.js ***!
  \*********************************************************/
/***/ (() => {

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

jQuery(document).ready(function ($) {
  var ManageTab = /*#__PURE__*/function () {
    function ManageTab() {
      _classCallCheck(this, ManageTab);

      this.events();
      this.showFirstTabContent();
    }

    _createClass(ManageTab, [{
      key: "events",
      value: function events() {
        var buttons = $('.tab_hidden_input');
        buttons.each(function () {
          $(this).on("click", function (e) {
            var target = e.currentTarget;
            $(target).parents(".tabs_container").find(".tab_contents .tab-content").removeClass("active");
            var inputID = $(target).data("id");
            $("#".concat(inputID)).addClass('active');
          });
        });
      }
    }, {
      key: "showContent",
      value: function showContent(e) {
        target.parents(".tab_bottom_side").find(".tab_contents .tab-content").removeClass("active");
        var inputID = target.attr("id").match(/(\d+)/)[0];
        target.parents(".tab_bottom_side").find(".tab_contents #tab-content".concat(inputID)).addClass("active");
      } // Add checked in tabs and get the design.

    }, {
      key: "showFirstTabContent",
      value: function showFirstTabContent() {
        $(".tabs_container").each(function () {
          $(this).find(".tab_hidden_input:first").prop("checked", true);
        });
      }
    }]);

    return ManageTab;
  }();

  new ManageTab();
});

/***/ }),

/***/ "./assets/src/scripts/Chunk/Frontend/data_table_default.js":
/*!*****************************************************************!*\
  !*** ./assets/src/scripts/Chunk/Frontend/data_table_default.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _common_func__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./common_func */ "./assets/src/scripts/Chunk/Frontend/common_func.js");
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }


jQuery(document).ready(function ($) {
  var Data_Tables_Default = /*#__PURE__*/function () {
    function Data_Tables_Default() {
      _classCallCheck(this, Data_Tables_Default);

      this.frontend_table = $(".gswpts_tables_container");

      if (front_end_data.asynchronous_loading == "off") {
        this.events();
      } else {
        return;
      }
    }

    _createClass(Data_Tables_Default, [{
      key: "events",
      value: function events() {
        this.get_frontend_table();
      }
    }, {
      key: "get_frontend_table",
      value: function get_frontend_table() {
        $.each(this.frontend_table, function (i, elem) {
          var table_settings = JSON.parse($(elem).attr("data-table_settings"));
          var table_name = $(elem).attr("data-table_name");
          var sheetUrl = $(elem).attr("data-url");
          var table_obj = new _common_func__WEBPACK_IMPORTED_MODULE_0__["default"]();
          table_obj.table_configuration($, i, elem, table_name, table_settings, sheetUrl);
          var scrollerContainer = $(elem).find(".dataTables_scroll");
          var scrollerElement = $(elem).find(".dataTables_scrollBody"); // Fix extra header when clicking the sort icon and has header merge

          if (scrollerElement) {
            //Extra header issue fix it how it was before when click the sort icon and has header merge
            var handleCommonActions = function handleCommonActions(theadElement) {
              console.clear(); // Clearing a few basic logs that are not needed to show

              if (theadElement) {
                // Select all tr elements within theadElement
                var trElements = theadElement.querySelectorAll('tr'); // Iterate through each trElement

                trElements.forEach(function (trElement) {
                  // Apply height style to each trElement
                  trElement.style.height = '0px'; // Select all th elements within theadElement

                  var thElements = trElement.querySelectorAll('th'); // Iterate through each thElement

                  thElements.forEach(function (thElement) {
                    // Create a new div element with the required styles
                    var divElement = document.createElement('div');
                    divElement.className = 'dataTables_sizing';
                    divElement.style.height = '0px';
                    divElement.style.overflow = 'hidden';
                    divElement.innerText = thElement.innerText; // Copy the text content
                    // Empty the thElement and append the divElement

                    thElement.innerHTML = '';
                    thElement.appendChild(divElement); // Apply styles to each thElement

                    thElement.style.paddingTop = '0px';
                    thElement.style.paddingBottom = '0px';
                    thElement.style.borderTopWidth = '0px';
                    thElement.style.borderBottomWidth = '0px';
                    thElement.style.height = '0px';
                    thElement.style.textAlign = 'center'; // thElement.style.display = 'none';
                  });
                });
              }
            };

            var handlePagination = function handlePagination() {
              var createTablesPaginate = document.getElementById('create_tables_paginate');

              if (createTablesPaginate) {
                var container = createTablesPaginate.closest(".gswpts_tables_container");
                var scrollBody = container.querySelector('.dataTables_scrollBody');
                var thead = scrollBody.querySelector('thead');
                handleCommonActions(thead);
              }
            };

            var tableHeaders = document.querySelectorAll('.thead-item[data-merge]');
            tableHeaders.forEach(function (header) {
              // Check if the current header has the data-merge attribute.
              var dataMerge = header.getAttribute('data-merge');

              if (dataMerge) {
                var sortingElements = document.querySelectorAll('.sorting');
                var dataTablesLength = document.querySelectorAll('.dataTables_length');
                var dataTables_filter = document.querySelectorAll('.dataTables_filter');
                var createTablesFilterInputs = document.querySelectorAll('.dataTables_filter input');
                var paginateContainer = document.getElementById('create_tables_paginate'); // Add a click event listener to each sorting element

                sortingElements.forEach(function (sortingElement) {
                  sortingElement.addEventListener('click', function () {
                    // Find the .dataTables_scrollBody element within the same container
                    var container = sortingElement.closest(".gswpts_tables_container");
                    var scrollBody = container.querySelector('.dataTables_scrollBody'); // Find the <thead> element within the .dataTables_scrollBody

                    var thead = scrollBody.querySelector('thead');
                    handleCommonActions(thead);
                  });
                }); // Add a click event listener to each dataTablesLength element

                dataTablesLength.forEach(function (LengthElement) {
                  LengthElement.addEventListener('click', function () {
                    var container = LengthElement.closest(".gswpts_tables_container");
                    var scrollBody = container.querySelector('.dataTables_scrollBody');
                    var thead = scrollBody.querySelector('thead');
                    handleCommonActions(thead); // console.log("click on dataTablesLength");
                  });
                }); // Add a click event listener to each dataTables_filter element

                dataTables_filter.forEach(function (FilterElement) {
                  FilterElement.addEventListener('click', function () {
                    var container = FilterElement.closest(".gswpts_tables_container");
                    var scrollBody = container.querySelector('.dataTables_scrollBody');
                    var thead = scrollBody.querySelector('thead');
                    handleCommonActions(thead); // console.log("click on dataTables_filter");
                  });
                });
                createTablesFilterInputs.forEach(function (createTablesFilterInput) {
                  createTablesFilterInput.addEventListener('input', function () {
                    var container = createTablesFilterInput.closest(".gswpts_tables_container");
                    var scrollBody = container.querySelector('.dataTables_scrollBody');
                    var thead = scrollBody.querySelector('thead');
                    handleCommonActions(thead); // console.log("click on handleSearchFilter");
                  });
                });

                if (paginateContainer) {
                  paginateContainer.addEventListener('click', function (event) {
                    // Check if the clicked element is a paginate button
                    if (event.target.classList.contains('paginate_button')) {
                      handlePagination(); // console.log("click on paginate");
                    }
                  });
                }
              }
            });
          }

          if (front_end_data.isProActive) {
            if ((table_settings === null || table_settings === void 0 ? void 0 : table_settings.cursor_behavior) == "left_right") {
              // Add functionality of scrolling the table.
              table_obj.bindDragScroll(scrollerContainer, scrollerElement);
            }

            table_obj.addGrabCursonOnMouseDown($(elem).find("#create_tables"));
          } // Additional code for handling merged cells and text alignment


          table_obj.handleMergedCells($, elem);
          table_obj.loadThemeStyle($, elem); // table_obj.defaultThemepaginationStyle($, elem);

          table_obj.handleHeaderMergedCells($, elem);
          /* if (table_settings?.merged_support) {
              table_obj.handleTableWidth($, $(elem).find(".gswpts_tables_container"));
          } */

          setInterval(function () {
            table_obj.handleTableWidth($, $(elem).find(".gswpts_tables_container"));
          }, 600);
          /* $(window).on('resize', function () {
              table_obj.handleTableWidth($, $(elem).find(".gswpts_tables_container"));
          }); */

          table_obj.handlePaginations($, elem); // Disable sorting from the table

          if (table_settings !== null && table_settings !== void 0 && table_settings.hide_sorting_icon) {
            table_obj.handleSortingDisable($, $(elem).find(".gswpts_tables_container"));
          }

          if ((table_settings === null || table_settings === void 0 ? void 0 : table_settings.table_view_mode) === 'search-only-mode') {
            table_obj.handleSearchoptions($, $(elem).find(".gswpts_tables_container"), table_settings.search_by);
          } // Condition to load the search button and disable search in type and show search value once search button click or enter press        


          if ((table_settings === null || table_settings === void 0 ? void 0 : table_settings.table_view_mode) === 'search-only-mode' && (table_settings === null || table_settings === void 0 ? void 0 : table_settings.search_by) === 'search-by-press') {
            table_obj.CreateSearchoptions($, $(elem).find(".gswpts_tables_container"), table_settings.search_by);
          } // Sticky feature development


          if (table_obj.isProPluginActive()) {
            if (table_settings !== null && table_settings !== void 0 && table_settings.enable_fixed_columns || table_settings !== null && table_settings !== void 0 && table_settings.fixed_headers) {
              table_obj.handleSticky($, $(elem).find(".gswpts_tables_container"), table_settings.enable_fixed_columns, table_settings.left_columns, table_settings.right_columns, table_settings.fixed_headers, table_settings.header_offset);
            }
          }

          table_obj.clearOverflow();
        });
      }
    }]);

    return Data_Tables_Default;
  }();

  new Data_Tables_Default();
});

/***/ }),

/***/ "./assets/src/scripts/Chunk/Frontend/data_tables_async.js":
/*!****************************************************************!*\
  !*** ./assets/src/scripts/Chunk/Frontend/data_tables_async.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _common_func__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./common_func */ "./assets/src/scripts/Chunk/Frontend/common_func.js");
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }


jQuery(document).ready(function ($) {
  var Data_Tables_Async = /*#__PURE__*/function () {
    function Data_Tables_Async() {
      _classCallCheck(this, Data_Tables_Async);

      this.frontend_table = $(".gswpts_tables_container");

      if (front_end_data.asynchronous_loading == "on") {
        this.events();
      } else {
        return;
      }
    }

    _createClass(Data_Tables_Async, [{
      key: "events",
      value: function events() {
        this.get_frontend_table();
      }
    }, {
      key: "get_frontend_table",
      value: function get_frontend_table() {
        $.each(this.frontend_table, function (i, elem) {
          var _window, _window$front_end_dat;

          var id = $(elem).attr("id");
          $.ajax({
            url: front_end_data.admin_ajax,
            data: {
              action: "gswpts_sheet_fetch",
              id: id,
              nonce: (_window = window) === null || _window === void 0 ? void 0 : (_window$front_end_dat = _window.front_end_data) === null || _window$front_end_dat === void 0 ? void 0 : _window$front_end_dat.nonce
            },
            type: "post",
            success: function success(res) {
              var tableClass = new _common_func__WEBPACK_IMPORTED_MODULE_0__["default"]();
              var table_settings = res.data.table_settings; // if (tableClass.isProPluginActive()) {

              if (table_settings !== null && table_settings !== void 0 && table_settings.responsive_style) {
                $(elem).addClass(table_settings === null || table_settings === void 0 ? void 0 : table_settings.responsive_style);
              }

              if (table_settings !== null && table_settings !== void 0 && table_settings.import_styles) {
                $(elem).addClass("gswpts_default-style");
              } else {
                $(elem).addClass("gswpts_".concat(table_settings !== null && table_settings !== void 0 && table_settings.table_style ? table_settings === null || table_settings === void 0 ? void 0 : table_settings.table_style : "default-style"));
              }

              $(elem).addClass("gswpts_default-style"); // }

              if ((table_settings === null || table_settings === void 0 ? void 0 : table_settings.show_title) == "true") {
                $(elem).find("h3").html(res.data.table_name);
              }

              $(elem).find(".gswpts_tables_content").html(res.data.output);
              var table_name = res.data.name;
              var sheetUrl = res.data.source_url;
              tableClass.table_configuration($, i, elem, table_name, table_settings, sheetUrl);
              var scrollerContainer = $(elem).find(".dataTables_scroll");
              var scrollerElement = $(elem).find(".dataTables_scrollBody");

              if (scrollerElement) {
                //Extra header issue fix it how it was before when click the sort icon and has header merge
                var handleCommonActions = function handleCommonActions(theadElement) {
                  console.clear(); // Clearing a few basic logs that are not needed to show

                  if (theadElement) {
                    // Select all tr elements within theadElement
                    var trElements = theadElement.querySelectorAll('tr'); // Iterate through each trElement

                    trElements.forEach(function (trElement) {
                      // Apply height style to each trElement
                      trElement.style.height = '0px'; // Select all th elements within theadElement

                      var thElements = trElement.querySelectorAll('th'); // Iterate through each thElement

                      thElements.forEach(function (thElement) {
                        // Create a new div element with the required styles
                        var divElement = document.createElement('div');
                        divElement.className = 'dataTables_sizing';
                        divElement.style.height = '0px';
                        divElement.style.overflow = 'hidden';
                        divElement.innerText = thElement.innerText; // Copy the text content
                        // Empty the thElement and append the divElement

                        thElement.innerHTML = '';
                        thElement.appendChild(divElement); // Apply styles to each thElement

                        thElement.style.paddingTop = '0px';
                        thElement.style.paddingBottom = '0px';
                        thElement.style.borderTopWidth = '0px';
                        thElement.style.borderBottomWidth = '0px';
                        thElement.style.height = '0px';
                        thElement.style.textAlign = 'center'; // thElement.style.display = 'none';
                      });
                    });
                  }
                };

                var handlePagination = function handlePagination() {
                  var createTablesPaginate = document.getElementById('create_tables_paginate');

                  if (createTablesPaginate) {
                    var container = createTablesPaginate.closest(".gswpts_tables_container");
                    var scrollBody = container.querySelector('.dataTables_scrollBody');
                    var thead = scrollBody.querySelector('thead');
                    handleCommonActions(thead);
                  }
                };

                var tableHeaders = document.querySelectorAll('.thead-item[data-merge]');
                tableHeaders.forEach(function (header) {
                  // Check if the current header has the data-merge attribute.
                  var dataMerge = header.getAttribute('data-merge');

                  if (dataMerge) {
                    var sortingElements = document.querySelectorAll('.sorting');
                    var dataTablesLength = document.querySelectorAll('.dataTables_length');
                    var dataTables_filter = document.querySelectorAll('.dataTables_filter');
                    var createTablesFilterInputs = document.querySelectorAll('.dataTables_filter input');
                    var paginateContainer = document.getElementById('create_tables_paginate'); // Add a click event listener to each sorting element

                    sortingElements.forEach(function (sortingElement) {
                      sortingElement.addEventListener('click', function () {
                        // Find the .dataTables_scrollBody element within the same container
                        var container = sortingElement.closest(".gswpts_tables_container");
                        var scrollBody = container.querySelector('.dataTables_scrollBody'); // Find the <thead> element within the .dataTables_scrollBody

                        var thead = scrollBody.querySelector('thead');
                        handleCommonActions(thead);
                      });
                    }); // Add a click event listener to each dataTablesLength element

                    dataTablesLength.forEach(function (LengthElement) {
                      LengthElement.addEventListener('click', function () {
                        var container = LengthElement.closest(".gswpts_tables_container");
                        var scrollBody = container.querySelector('.dataTables_scrollBody');
                        var thead = scrollBody.querySelector('thead');
                        handleCommonActions(thead); // console.log("click on dataTablesLength");
                      });
                    }); // Add a click event listener to each dataTables_filter element

                    dataTables_filter.forEach(function (FilterElement) {
                      FilterElement.addEventListener('click', function () {
                        var container = FilterElement.closest(".gswpts_tables_container");
                        var scrollBody = container.querySelector('.dataTables_scrollBody');
                        var thead = scrollBody.querySelector('thead');
                        handleCommonActions(thead); // console.log("click on dataTables_filter");
                      });
                    });
                    createTablesFilterInputs.forEach(function (createTablesFilterInput) {
                      createTablesFilterInput.addEventListener('input', function () {
                        var container = createTablesFilterInput.closest(".gswpts_tables_container");
                        var scrollBody = container.querySelector('.dataTables_scrollBody');
                        var thead = scrollBody.querySelector('thead');
                        handleCommonActions(thead); // console.log("click on handleSearchFilter");
                      });
                    });

                    if (paginateContainer) {
                      paginateContainer.addEventListener('click', function (event) {
                        // Check if the clicked element is a paginate button
                        if (event.target.classList.contains('paginate_button')) {
                          handlePagination(); // console.log("click on paginate");
                        }
                      });
                    }
                  }
                });
              } // END 
              // Additional code for handling merged cells and text alignment


              tableClass.handleMergedCells($, elem); //Additional code for handling header merged cells and text alignment

              tableClass.handleHeaderMergedCells($, elem);
              tableClass.loadThemeStyle($, elem);

              if (front_end_data.isProActive) {
                if ((table_settings === null || table_settings === void 0 ? void 0 : table_settings.cursor_behavior) == "left_right") {
                  // Add functionality of scrolling the table.
                  tableClass.bindDragScroll(scrollerContainer, scrollerElement);
                }

                tableClass.addGrabCursonOnMouseDown($(elem).find("#create_tables"));
              } // table width fixing 

              /* if (table_settings?.merged_support) {
                  tableClass.handleTableWidth($, $(elem).find(".gswpts_tables_container"));
              } */


              setInterval(function () {
                tableClass.handleTableWidth($, $(elem).find(".gswpts_tables_container"));
              }, 600);
              tableClass.handlePaginations($, elem); // tableClass.defaultThemepaginationStyle($, elem);
              // Disable sorting from the table

              if (table_settings !== null && table_settings !== void 0 && table_settings.hide_sorting_icon) {
                tableClass.handleSortingDisable($, $(elem).find(".gswpts_tables_container"));
              } // Makes the table hide and unhide


              if ((table_settings === null || table_settings === void 0 ? void 0 : table_settings.table_view_mode) === 'search-only-mode') {
                tableClass.handleSearchoptions($, $(elem).find(".gswpts_tables_container"), table_settings.search_by);
              } // Condition to load the search button and disable search in type and show search value once search button click or enter press        


              if ((table_settings === null || table_settings === void 0 ? void 0 : table_settings.table_view_mode) === 'search-only-mode' && (table_settings === null || table_settings === void 0 ? void 0 : table_settings.search_by) === 'search-by-press') {
                tableClass.CreateSearchoptions($, $(elem).find(".gswpts_tables_container"), table_settings.search_by);
              }

              if (tableClass.isProPluginActive()) {
                if (table_settings !== null && table_settings !== void 0 && table_settings.enable_fixed_columns || table_settings !== null && table_settings !== void 0 && table_settings.fixed_headers) {
                  tableClass.handleSticky($, $(elem).find(".gswpts_tables_container"), table_settings.enable_fixed_columns, table_settings.left_columns, table_settings.right_columns, table_settings.fixed_headers, table_settings.header_offset);
                }
              }

              tableClass.clearOverflow();
              /**
               * FE Sorting fix by disable the sorting when has vertical merge 
               */

              var tableRows = document.querySelectorAll('.gswpts_rows');
              var verticalMergeFound = false;

              if (tableRows) {
                tableRows.forEach(function (row) {
                  var cells = row.querySelectorAll('td');
                  cells.forEach(function (cell, index) {
                    var rowspan = cell.getAttribute('rowspan');

                    if (rowspan && parseInt(rowspan) > 1) {
                      verticalMergeFound = true;
                    }
                  });
                });
              }

              if (verticalMergeFound) {
                var _window2, _window2$front_end_da;

                $.ajax({
                  url: front_end_data.admin_ajax,
                  data: {
                    action: "swptls_update_sorting_fe",
                    id: id,
                    nonce: (_window2 = window) === null || _window2 === void 0 ? void 0 : (_window2$front_end_da = _window2.front_end_data) === null || _window2$front_end_da === void 0 ? void 0 : _window2$front_end_da.nonce,
                    allow_sorting: false
                  },
                  type: "post",
                  success: function success(res) {},
                  error: function error(err) {}
                });
              } // END 

            },
            error: function error(err) {
              alert("Something went wrong");
              console.error(err);
              $(elem).find(".gswpts_tables_content").html("<strong>Table could not be loaded. Try again</strong>");
            }
          });
        });
      }
    }]);

    return Data_Tables_Async;
  }();

  new Data_Tables_Async();
});

/***/ }),

/***/ "./assets/src/scripts/chunk/frontend/ai_summary.js":
/*!*********************************************************!*\
  !*** ./assets/src/scripts/chunk/frontend/ai_summary.js ***!
  \*********************************************************/
/***/ (() => {

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

/**
 * AI Summary functionality for SWPTLS tables
 * Handles AI-powered table summaries with server-side pagination support
 * ES6 Module Version
 */
// Define AISummary class outside jQuery ready block
var AISummary = /*#__PURE__*/function () {
  function AISummary() {
    _classCallCheck(this, AISummary);

    this.isGenerating = false;
    this.summaryCache = new Map();
    this.$ = jQuery; // Store jQuery reference

    this.init();
  }

  _createClass(AISummary, [{
    key: "init",
    value: function init() {
      this.bindEvents();
    }
  }, {
    key: "bindEvents",
    value: function bindEvents() {
      var _this = this;

      var $ = this.$; // Handle AI summary button clicks

      $(document).on('click', '.swptls-ai-summary-btn', function (e) {
        e.preventDefault();
        var tableId = $(e.currentTarget).data('table-id');
        var tableElement = $(e.currentTarget).closest('.gswpts_tables_container').find('table');

        if (tableId && tableElement.length) {
          _this.generateSummary(tableId, tableElement);
        }
      }); // Handle summary modal close

      $(document).on('click', '.ai-summary-modal .close-modal, .ai-summary-modal .modal-overlay', function (e) {
        if (e.target === e.currentTarget) {
          _this.closeSummaryModal();
        }
      }); // Handle ESC key to close modal

      $(document).on('keydown', function (e) {
        if (e.key === 'Escape') {
          _this.closeSummaryModal();
        }
      }); // Handle regenerate summary

      $(document).on('click', '.regenerate-summary-btn', function (e) {
        e.preventDefault();
        var tableId = $(e.currentTarget).data('table-id');
        var button = $(e.currentTarget); // Show regenerating state

        _this.showRegeneratingState(button); // Try multiple ways to find the table element


        var tableElement = $(".gswpts_tables_container[id=\"".concat(tableId, "\"] table"));

        if (tableElement.length === 0) {
          tableElement = $(".gswpts_table_".concat(tableId, " table"));
        }

        if (tableElement.length === 0) {
          tableElement = $("#".concat(tableId, " table"));
        }

        if (tableElement.length === 0) {
          tableElement = $('.gswpts_tables_container table').first();
        }

        if (tableElement.length > 0) {
          // Show regenerating message in modal
          _this.showRegeneratingInModal();

          _this.generateSummary(tableId, tableElement, true); // Force regenerate

        } else {
          console.error('Could not find table element for regeneration');

          _this.showSummaryError(tableId, 'Could not find table data for regeneration.');

          _this.hideRegeneratingState(button);
        }
      });
    }
  }, {
    key: "addSummaryButton",
    value: function addSummaryButton(container, tableId) {// No longer needed - AI Summary buttons are now rendered on the backend
      // console.log("AI Summary button rendering is now handled by backend");
    }
  }, {
    key: "generateSummary",
    value: function generateSummary(tableId, tableElement) {
      var _this2 = this;

      var forceRegenerate = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

      if (this.isGenerating) {
        return;
      } // Check if caching is enabled for this table


      var enableCache = this.getTableSpecificSetting(tableId, 'enable_ai_cache'); // console.log(`AI Summary cache setting for table ${tableId}:`, enableCache);
      // Generate cache key

      var cacheKey = this.generateCacheKey(tableId, tableElement); // console.log(`Generated cache key: ${cacheKey}`);
      // If forcing regenerate, clear ALL related cache entries

      if (forceRegenerate) {
        // console.log('Force regenerating - clearing all caches for table:', tableId);
        // Clear existing cache entry
        this.summaryCache["delete"](cacheKey); // Clear any regenerate cache entries that might exist

        var cacheKeys = Array.from(this.summaryCache.keys());
        cacheKeys.forEach(function (key) {
          if (key.startsWith("ai_summary_".concat(tableId, "_"))) {
            // console.log('Clearing frontend cache key:', key);
            _this2.summaryCache["delete"](key);
          }
        }); // Add timestamp to make cache key unique for regeneration

        cacheKey = cacheKey + '_regenerate_' + Date.now();
      } else if (enableCache && this.summaryCache.has(cacheKey)) {
        // Check cache first (only if caching is enabled and not forcing regenerate)
        // console.log('Using cached summary for key:', cacheKey);
        this.showSummaryModal(this.summaryCache.get(cacheKey), tableId);
        return;
      } else if (!enableCache) {// console.log('Caching disabled for table, bypassing cache check');
      }

      this.isGenerating = true;
      this.showGeneratingProgress(tableId);

      try {
        // Try to get all data from DataTable API first
        var tableData = this.collectAllTableDataFromDataTable(tableElement); // Get table settings - prefer stored settings from table configuration
        // First try to get from global window.swptlsTableSettings (set by gswpts_sheet_fetch)

        var table_settings = null;

        if (window.swptlsTableSettings && window.swptlsTableSettings[tableId]) {
          table_settings = window.swptlsTableSettings[tableId]; // console.log('Using table settings from window.swptlsTableSettings:', table_settings);
        } else {// console.log('No table settings found in window.swptlsTableSettings for table:', tableId);
        }

        var tableSettings = this.getTableSettings(tableId, table_settings); // console.log('Final table settings for AI summary:', tableSettings);
        // Send to backend for AI processing

        this.requestAISummary(tableId, tableData, tableSettings, cacheKey, forceRegenerate);
      } catch (error) {
        console.error('AI Summary Error:', error);
        this.showSummaryError(tableId, 'Failed to prepare table data for AI summary.');
        this.isGenerating = false;
      }
    }
  }, {
    key: "collectAllTableDataFromDataTable",
    value: function collectAllTableDataFromDataTable(tableElement) {
      var _this3 = this;

      var $ = this.$;
      var data = {
        headers: [],
        rows: [],
        title: '',
        totalVisibleRows: 0,
        tableStructure: {}
      }; // Get table title

      var titleElement = tableElement.closest('.gswpts_tables_container').find('.table-title, h2, h3');

      if (titleElement.length) {
        data.title = titleElement.first().text().trim();
      } // Try to get DataTable instance with better error handling


      var dataTable = null;
      var isDataTableReady = false;

      try {
        // Check if DataTable is initialized and ready
        if ($.fn.DataTable.isDataTable(tableElement)) {
          dataTable = $(tableElement).DataTable(); // Test if DataTable is fully functional

          dataTable.rows().count();
          isDataTableReady = true; // console.log('AI Summary: DataTable instance found and ready');
        }
      } catch (e) {
        // console.log('AI Summary: DataTable not ready or accessible, using DOM parsing:', e.message);
        isDataTableReady = false;
      } // Get headers with column information


      var headerCells = tableElement.find('thead tr:first th, thead tr:first td');
      headerCells.each(function (index, element) {
        var headerText = $(element).text().trim();

        if (headerText) {
          data.headers.push({
            index: index,
            text: headerText,
            type: _this3.detectColumnType(tableElement, index)
          });
        }
      });

      if (dataTable && isDataTableReady) {
        // Use DataTable API to get ALL data (not just visible)
        try {
          var allData = dataTable.rows().data();
          data.totalVisibleRows = allData.length; // Process all rows from DataTable

          allData.each(function (rowData) {
            var row = [];

            for (var i = 0; i < rowData.length; i++) {
              var cellText = ''; // Handle different data types from DataTable

              if (typeof rowData[i] === 'string') {
                cellText = rowData[i];
              } else if (rowData[i] && rowData[i].innerHTML) {
                cellText = rowData[i].innerHTML;
              } else if (rowData[i] && rowData[i].textContent) {
                cellText = rowData[i].textContent;
              } else {
                cellText = String(rowData[i] || '');
              } // Clean up HTML and extract text content


              var $temp = $('<div>').html(cellText); // Handle special content types

              var img = $temp.find('img');

              if (img.length) {
                var altText = img.attr('alt') || 'Image';
                cellText = "[Image: ".concat(altText, "]");
              } else {
                var link = $temp.find('a');

                if (link.length && !cellText.trim()) {
                  cellText = "[Link: ".concat(link.text().trim() || 'URL', "]");
                } else {
                  cellText = $temp.text().trim();
                }
              } // Limit cell content length to prevent token overflow


              if (cellText.length > 100) {
                cellText = cellText.substring(0, 97) + '...';
              }

              row.push(cellText || '');
            }

            if (row.length > 0) {
              data.rows.push(row);
            }
          }); // console.log(`AI Summary: Collected ${data.rows.length} rows from DataTable API`);
        } catch (e) {
          // console.log('AI Summary: Error accessing DataTable data, falling back to DOM parsing:', e);
          // Fallback to DOM parsing
          return this.collectCurrentTableData(tableElement);
        }
      } else {
        // Fallback to DOM parsing if DataTable not available
        // console.log('AI Summary: Using DOM parsing as fallback');
        return this.collectCurrentTableData(tableElement);
      } // Add table structure information


      data.tableStructure = {
        totalColumns: data.headers.length,
        totalVisibleRows: data.totalVisibleRows,
        sampleSize: data.rows.length,
        hasImages: tableElement.find('img').length > 0,
        hasLinks: tableElement.find('a').length > 0,
        hasPagination: tableElement.closest('.gswpts_tables_container').find('.pagination, .load-more-btn').length > 0
      };
      return data;
    }
  }, {
    key: "collectCurrentTableData",
    value: function collectCurrentTableData(tableElement) {
      var _this4 = this;

      var $ = this.$;
      var data = {
        headers: [],
        rows: [],
        title: '',
        totalVisibleRows: 0,
        tableStructure: {}
      }; // Get table title

      var titleElement = tableElement.closest('.gswpts_tables_container').find('.table-title, h2, h3');

      if (titleElement.length) {
        data.title = titleElement.first().text().trim();
      } // Get headers with column information


      var headerCells = tableElement.find('thead tr:first th, thead tr:first td');
      headerCells.each(function (index, element) {
        var headerText = $(element).text().trim();

        if (headerText) {
          data.headers.push({
            index: index,
            text: headerText,
            type: _this4.detectColumnType(tableElement, index)
          });
        }
      }); // Get currently visible rows (respects pagination and filters)

      var visibleRows = tableElement.find('tbody tr:visible');
      data.totalVisibleRows = visibleRows.length; // Collect ALL visible rows for AI analysis - no artificial limits
      // The backend will handle token limits and chunking if needed

      var sampleRows = visibleRows;
      sampleRows.each(function (index, element) {
        var row = [];
        $(element).find('td').each(function (cellIndex, cellElement) {
          var cellText = $(cellElement).text().trim(); // Handle special content types

          var img = $(cellElement).find('img');

          if (img.length) {
            var altText = img.attr('alt') || 'Image';
            cellText = "[Image: ".concat(altText, "]");
          }

          var link = $(cellElement).find('a');

          if (link.length && !cellText) {
            cellText = "[Link: ".concat(link.text().trim() || 'URL', "]");
          } // Limit cell content length to prevent token overflow


          if (cellText.length > 100) {
            cellText = cellText.substring(0, 97) + '...';
          }

          row.push(cellText || '');
        });

        if (row.length > 0) {
          data.rows.push(row);
        }
      }); // Add table structure information

      data.tableStructure = {
        totalColumns: data.headers.length,
        totalVisibleRows: data.totalVisibleRows,
        sampleSize: data.rows.length,
        hasImages: tableElement.find('img').length > 0,
        hasLinks: tableElement.find('a').length > 0,
        hasPagination: tableElement.closest('.gswpts_tables_container').find('.pagination, .load-more-btn').length > 0
      };
      return data;
    }
  }, {
    key: "detectColumnType",
    value: function detectColumnType(tableElement, columnIndex) {
      var _this5 = this;

      var $ = this.$; // Analyze first few cells to detect column type

      var cells = tableElement.find("tbody tr:visible td:nth-child(".concat(columnIndex + 1, ")")).slice(0, 5);
      var hasNumbers = 0;
      var hasDates = 0;
      var hasImages = 0;
      var hasLinks = 0;
      cells.each(function (index, element) {
        var text = $(element).text().trim();
        if ($(element).find('img').length > 0) hasImages++;
        if ($(element).find('a').length > 0) hasLinks++;
        if (!isNaN(parseFloat(text)) && isFinite(text)) hasNumbers++;
        if (_this5.isDateString(text)) hasDates++;
      });
      if (hasImages > 0) return 'image';
      if (hasLinks > 0) return 'link';
      if (hasNumbers >= cells.length * 0.6) return 'number';
      if (hasDates >= cells.length * 0.6) return 'date';
      return 'text';
    }
  }, {
    key: "isDateString",
    value: function isDateString(str) {
      return !isNaN(Date.parse(str)) && str.match(/\d{1,4}[-\/]\d{1,2}[-\/]\d{1,4}/);
    }
  }, {
    key: "sampleRows",
    value: function sampleRows(rows, maxRows) {
      var $ = this.$;

      if (rows.length <= maxRows) {
        return rows;
      } // Intelligent sampling: take first few, last few, and some from middle


      var firstRows = Math.floor(maxRows * 0.4);
      var lastRows = Math.floor(maxRows * 0.3);
      var middleRows = maxRows - firstRows - lastRows;
      var sampled = []; // First rows

      for (var i = 0; i < firstRows && i < rows.length; i++) {
        sampled.push(rows[i]);
      } // Middle rows (evenly distributed)


      if (middleRows > 0 && rows.length > firstRows + lastRows) {
        var middleStart = firstRows;
        var middleEnd = rows.length - lastRows;
        var step = Math.floor((middleEnd - middleStart) / middleRows);

        for (var _i = 0; _i < middleRows; _i++) {
          var index = middleStart + _i * step;

          if (index < middleEnd) {
            sampled.push(rows[index]);
          }
        }
      } // Last rows


      for (var _i2 = Math.max(0, rows.length - lastRows); _i2 < rows.length; _i2++) {
        sampled.push(rows[_i2]);
      }

      return $(sampled);
    }
  }, {
    key: "getTableSettings",
    value: function getTableSettings(tableId) {
      var table_settings = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      var $ = this.$;
      var container = $(".gswpts_tables_container table[id*=\"".concat(tableId, "\"]")).closest('.gswpts_tables_container'); // Default AI settings

      var defaultAISettings = {
        show_table_prompt_fields: false,
        ask_ai_placeholder: 'Ask anything about this table… e.g., Top 5 products by sales',
        ask_ai_button_label: 'Ask AI',
        backend_ai_summary: '',
        backend_summary_exists: false,
        show_regenerate_button: false,
        enable_backend_ai_trigger: false,
        edit_summary_content: false,
        show_summary_in_table: false,
        summary_prompt: 'Give a short summary of this table (max 50 words), highlighting key takeaways and trends.',
        enable_ai_cache: true,
        enable_ai_summary: false
      }; // If table_settings are provided as parameter (from gswpts_sheet_fetch response), use them

      var tableSpecificSettings = _objectSpread({}, defaultAISettings);

      if (table_settings) {
        // Merge provided settings with defaults, giving priority to provided settings
        tableSpecificSettings = _objectSpread(_objectSpread({}, defaultAISettings), table_settings);
      } else {
        // Fallback: Try to get from global window.swptlsTableSettings first
        if (window.swptlsTableSettings && window.swptlsTableSettings[tableId]) {
          tableSpecificSettings = _objectSpread(_objectSpread({}, defaultAISettings), window.swptlsTableSettings[tableId]);
        } else {
          // Last resort: Get table-specific AI settings from data-table_settings attribute
          try {
            var tableSettingsJson = container.attr('data-table_settings');

            if (tableSettingsJson) {
              var tableSettings = JSON.parse(tableSettingsJson);
              tableSpecificSettings = _objectSpread(_objectSpread({}, defaultAISettings), tableSettings);
            }
          } catch (e) {
            console.warn('Failed to parse table settings for table:', tableId, e);
          }
        }
      } // Debug log to verify prompt is being captured


      if (tableSpecificSettings.summary_prompt !== defaultAISettings.summary_prompt) {
        console.log('Custom prompt detected:', tableSpecificSettings.summary_prompt);
      }

      return {
        tableId: tableId,
        hasTitle: container.find('.table-title').length > 0,
        hasPagination: container.find('.pagination, .load-more-btn').length > 0,
        hasFilters: container.find('.dataTables_filter, .search-input').length > 0,
        theme: function () {
          var className = container.attr('class');

          if (className && className.match(/gswpts_style-\d+/)) {
            var match = className.match(/gswpts_style-(\d+)/);
            return match ? match[1] : 'default';
          }

          return 'default';
        }(),
        // Include table-specific AI settings with defaults
        ai_settings: tableSpecificSettings
      };
    }
  }, {
    key: "getTableSpecificSetting",
    value: function getTableSpecificSetting(tableId, settingKey) {
      var $ = this.$; // Default AI settings

      var defaults = {
        show_table_prompt_fields: false,
        ask_ai_placeholder: 'Ask anything about this table… e.g., Top 5 products by sales',
        ask_ai_button_label: 'Ask AI',
        backend_ai_summary: '',
        backend_summary_exists: false,
        show_regenerate_button: false,
        enable_backend_ai_trigger: false,
        edit_summary_content: false,
        show_summary_in_table: false,
        summary_prompt: 'Give a short summary of this table (max 50 words), highlighting key takeaways and trends.',
        enable_ai_cache: true,
        enable_ai_summary: false
      }; // First try to get from stored table settings (preferred method)

      if (window.swptlsTableSettings && window.swptlsTableSettings[tableId]) {
        var table_settings = window.swptlsTableSettings[tableId];

        if (table_settings.hasOwnProperty(settingKey)) {
          return table_settings[settingKey];
        }
      } // Fallback to parsing from DOM attribute


      var container = $(".gswpts_tables_container table[id*=\"".concat(tableId, "\"]")).closest('.gswpts_tables_container');

      try {
        var tableSettingsJson = container.attr('data-table_settings');

        if (tableSettingsJson) {
          var tableSettings = JSON.parse(tableSettingsJson); // Return table-specific setting if it exists

          if (tableSettings.hasOwnProperty(settingKey)) {
            return tableSettings[settingKey];
          }
        }
      } catch (e) {
        console.warn('Failed to parse table settings for table:', tableId, e);
      } // Return default value


      return defaults[settingKey] !== undefined ? defaults[settingKey] : null;
    }
  }, {
    key: "requestAISummary",
    value: function requestAISummary(tableId, tableData, tableSettings, cacheKey) {
      var _front_end_data,
          _front_end_data2,
          _this6 = this;

      var forceRegenerate = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
      var formData = new FormData();
      formData.append('action', 'gswpts_generate_ai_summary');
      formData.append('table_id', tableId);
      formData.append('table_data', JSON.stringify(tableData));
      formData.append('table_settings', JSON.stringify(tableSettings));
      formData.append('cache_key', cacheKey);
      formData.append('force_regenerate', forceRegenerate ? '1' : '0'); // Check if swptls_ajax exists (it might be different in your setup)

      var nonce = (_front_end_data = front_end_data) === null || _front_end_data === void 0 ? void 0 : _front_end_data.nonce;
      var ajaxUrl = (_front_end_data2 = front_end_data) === null || _front_end_data2 === void 0 ? void 0 : _front_end_data2.admin_ajax;

      if (nonce) {
        formData.append('nonce', nonce);
      }

      fetch(ajaxUrl, {
        method: 'POST',
        body: formData
      }).then(function (response) {
        // Check if response is ok before parsing JSON
        if (!response.ok) {
          throw new Error("HTTP ".concat(response.status, ": ").concat(response.statusText));
        }

        return response.json();
      }).then(function (data) {
        // console.log('AI Summary Response:', data); // Debug log
        if (data.success && data.data.summary) {
          // Check if caching is enabled before storing in frontend cache
          var enableCache = _this6.getTableSpecificSetting(tableId, 'enable_ai_cache');

          if (enableCache) {
            // Cache the summary only if caching is enabled
            // console.log('Storing summary in frontend cache with key:', cacheKey);
            _this6.summaryCache.set(cacheKey, data.data); // If this was a regeneration, also update the original cache key
            // so future requests get the latest data


            if (forceRegenerate && cacheKey.includes('_regenerate_')) {
              var tableElement = _this6.findTableElement(tableId);

              if (tableElement && tableElement.length > 0) {
                var originalCacheKey = _this6.generateCacheKey(tableId, tableElement); // console.log('Updating original cache key after regeneration:', originalCacheKey);


                _this6.summaryCache.set(originalCacheKey, data.data);
              }
            }
          } else {// console.log('Caching disabled, not storing summary in frontend cache');
          } // Always show the summary


          _this6.showSummaryModal(data.data, tableId);
        } else {
          // Handle error response - data.data now contains error information
          _this6.showSummaryError(tableId, data.data || {
            message: 'Failed to generate AI summary.',
            error_type: 'general_error'
          });
        }
      })["catch"](function (error) {
        console.error('AI Summary Generation Error:', error); // Check if it's a network error or a parsing error

        var errorMessage = 'Network error while generating summary.';

        if (error.name === 'SyntaxError') {
          errorMessage = 'Server returned an invalid response. Please try again.';
        } else if (error.message && error.message.includes('fetch')) {
          errorMessage = 'Unable to connect to the server. Please check your internet connection.';
        }

        _this6.showSummaryError(tableId, {
          message: errorMessage,
          error_type: 'network_error'
        });
      })["finally"](function () {
        _this6.isGenerating = false;

        _this6.hideGeneratingProgress(tableId);
      });
    }
  }, {
    key: "generateCacheKey",
    value: function generateCacheKey(tableId, tableElement) {
      // Generate a cache key based on current table state
      var visibleRows = tableElement.find('tbody tr:visible').length;
      var tableContent = tableElement.find('tbody').text().substring(0, 100);
      var contentHash = this.simpleHash(tableContent);
      return "ai_summary_".concat(tableId, "_").concat(visibleRows, "_").concat(contentHash);
    }
  }, {
    key: "findTableElement",
    value: function findTableElement(tableId) {
      var $ = this.$; // Try multiple ways to find the table element

      var tableElement = $(".gswpts_tables_container[id=\"".concat(tableId, "\"] table"));

      if (tableElement.length === 0) {
        tableElement = $(".gswpts_table_".concat(tableId, " table"));
      }

      if (tableElement.length === 0) {
        tableElement = $("#".concat(tableId, " table"));
      }

      if (tableElement.length === 0) {
        tableElement = $(".gswpts_tables_container table[id*=\"".concat(tableId, "\"]"));
      }

      if (tableElement.length === 0) {
        tableElement = $('.gswpts_tables_container table').first();
      }

      return tableElement;
    }
  }, {
    key: "simpleHash",
    value: function simpleHash(str) {
      var hash = 0;

      for (var i = 0; i < str.length; i++) {
        var _char = str.charCodeAt(i);

        hash = (hash << 5) - hash + _char;
        hash = hash & hash; // Convert to 32-bit integer
      }

      return Math.abs(hash).toString(36);
    }
  }, {
    key: "showGeneratingProgress",
    value: function showGeneratingProgress(tableId) {
      var $ = this.$;
      var button = $(".swptls-ai-summary-btn[data-table-id=\"".concat(tableId, "\"]")); // Store the original button HTML for restoration later

      if (!button.data('original-html')) {
        button.data('original-html', button.html());
      }

      button.prop('disabled', true).addClass('generating').html("\n                    <span class=\"ai-icon\">\n                            <svg class=\"fWWlmf JzISke\" height=\"24\" width=\"24\" aria-hidden=\"true\" viewBox=\"0 0 471 471\" xmlns=\"http://www.w3.org/2000/svg\"><path fill=\"var(--m3c23)\" d=\"M235.5 471C235.5 438.423 229.22 407.807 216.66 379.155C204.492 350.503 187.811 325.579 166.616 304.384C145.421 283.189 120.498 266.508 91.845 254.34C63.1925 241.78 32.5775 235.5 0 235.5C32.5775 235.5 63.1925 229.416 91.845 217.249C120.498 204.689 145.421 187.811 166.616 166.616C187.811 145.421 204.492 120.497 216.66 91.845C229.22 63.1925 235.5 32.5775 235.5 0C235.5 32.5775 241.584 63.1925 253.751 91.845C266.311 120.497 283.189 145.421 304.384 166.616C325.579 187.811 350.503 204.689 379.155 217.249C407.807 229.416 438.423 235.5 471 235.5C438.423 235.5 407.807 241.78 379.155 254.34C350.503 266.508 325.579 283.189 304.384 304.384C283.189 325.579 266.311 350.503 253.751 379.155C241.584 407.807 235.5 438.423 235.5 471Z\"></path>\n                            </svg>\n                        </span>\n                    <span class=\"button-text\">Generating...</span>\n                ");
    }
  }, {
    key: "hideGeneratingProgress",
    value: function hideGeneratingProgress(tableId) {
      var $ = this.$;
      var button = $(".swptls-ai-summary-btn[data-table-id=\"".concat(tableId, "\"]")); // Restore the original button HTML if it was stored

      var originalHtml = button.data('original-html');

      if (originalHtml) {
        button.prop('disabled', false).removeClass('generating').html(originalHtml);
      } else {
        // Fallback to default if original HTML wasn't stored
        button.prop('disabled', false).removeClass('generating').html("\n                        <span class=\"ai-icon\">\n                                <svg class=\"fWWlmf JzISke\" height=\"24\" width=\"24\" aria-hidden=\"true\" viewBox=\"0 0 471 471\" xmlns=\"http://www.w3.org/2000/svg\"><path fill=\"var(--m3c23)\" d=\"M235.5 471C235.5 438.423 229.22 407.807 216.66 379.155C204.492 350.503 187.811 325.579 166.616 304.384C145.421 283.189 120.498 266.508 91.845 254.34C63.1925 241.78 32.5775 235.5 0 235.5C32.5775 235.5 63.1925 229.416 91.845 217.249C120.498 204.689 145.421 187.811 166.616 166.616C187.811 145.421 204.492 120.497 216.66 91.845C229.22 63.1925 235.5 32.5775 235.5 0C235.5 32.5775 241.584 63.1925 253.751 91.845C266.311 120.497 283.189 145.421 304.384 166.616C325.579 187.811 350.503 204.689 379.155 217.249C407.807 229.416 438.423 235.5 471 235.5C438.423 235.5 407.807 241.78 379.155 254.34C350.503 266.508 325.579 283.189 304.384 304.384C283.189 325.579 266.311 350.503 253.751 379.155C241.584 407.807 235.5 438.423 235.5 471Z\"></path>\n                                </svg>\n                            </span>\n                        <span class=\"button-text hint-icon\" title=\"Click to generate an intelligent summary of the table data using AI\">AI Summary</span>\n                    ");
      }
    }
  }, {
    key: "showSummaryModal",
    value: function showSummaryModal(summaryData, tableId) {
      var $ = this.$; // Check if modal already exists (for regeneration)

      var existingModal = $('.ai-summary-modal');

      if (existingModal.length > 0) {
        // Update existing modal content
        this.updateModalContent(summaryData, tableId); // Reset regenerate button state

        var regenerateBtn = existingModal.find('.regenerate-summary-btn');
        this.hideRegeneratingState(regenerateBtn);
      } else {
        // Create new modal
        var modal = this.createSummaryModal(summaryData, tableId);
        $('body').append(modal); // Show modal with animation

        setTimeout(function () {
          $('.ai-summary-modal').addClass('show');
        }, 100);
      }
    }
  }, {
    key: "createSummaryModal",
    value: function createSummaryModal(summaryData, tableId) {
      var summary = summaryData.summary,
          metadata = summaryData.metadata,
          generated_at = summaryData.generated_at,
          tokens_used = summaryData.tokens_used,
          model_used = summaryData.model_used; // Get table-specific show_regenerate_button setting

      var showRegenerateButton = this.getTableSpecificSetting(tableId, 'show_regenerate_button'); // console.log('AI Summary Show rege (table-specific):', showRegenerateButton);

      return "\n                <div class=\"ai-summary-modal\">\n                    <div class=\"modal-overlay\"></div>\n                    <div class=\"modal-content\">\n                        <div class=\"modal-header\">\n                            <h3>Table Summary</h3>\n                            <button class=\"close-modal\">&times;</button>\n                        </div>\n                        \n                        <div class=\"modal-body\">\n                            <div class=\"summary-content\">\n                                ".concat(this.formatSummary(summary), "\n                            </div>\n                        </div>\n                        \n                        <div class=\"modal-footer\">\n                            ").concat(showRegenerateButton ? "\n                            <button class=\"regenerate-summary-btn\" data-table-id=\"".concat(tableId, "\">\n                                Regenerate\n                            </button>\n                            ") : '', "\n                        </div>\n                    </div>\n                </div>\n            ");
    }
  }, {
    key: "formatSummary",
    value: function formatSummary(summary) {
      // Convert markdown-like formatting to HTML
      return summary.replace(/\*\*(.*?)\*\*/g, '<strong>$1</strong>').replace(/\*(.*?)\*/g, '<em>$1</em>').replace(/\n\n/g, '</p><p>').replace(/\n/g, '<br>').replace(/^/, '<p>').replace(/$/, '</p>');
    }
  }, {
    key: "formatDate",
    value: function formatDate(dateString) {
      if (!dateString) return 'Just now';
      var date = new Date(dateString);
      var now = new Date();
      var diffMs = now - date;
      var diffMins = Math.floor(diffMs / 60000);
      if (diffMins < 1) return 'Just now';
      if (diffMins < 60) return "".concat(diffMins, " minutes ago");
      if (diffMins < 1440) return "".concat(Math.floor(diffMins / 60), " hours ago");
      return date.toLocaleDateString();
    }
  }, {
    key: "closeSummaryModal",
    value: function closeSummaryModal() {
      var $ = this.$;
      $('.ai-summary-modal').removeClass('show');
      setTimeout(function () {
        $('.ai-summary-modal').remove();
      }, 300);
    }
  }, {
    key: "showSummaryError",
    value: function showSummaryError(tableId, errorData) {
      var message = '';
      var errorType = 'error'; // Handle different error data formats

      if (typeof errorData === 'string') {
        message = errorData;
      } else if (errorData && _typeof(errorData) === 'object') {
        message = errorData.message || 'Failed to generate AI summary.';
        errorType = errorData.error_type || 'error';
      } else {
        message = 'Failed to generate AI summary.';
      } // Customize message and type based on error type


      switch (errorType) {
        case 'rate_limit':
          this.showNotification(message, 'warning', 8000); // Show longer for rate limit

          break;

        case 'quota_exceeded':
          this.showNotification(message, 'warning', 6000);
          break;

        case 'invalid_api_key':
          this.showNotification(message, 'error', 6000);
          break;

        case 'token_limit':
          this.showNotification(message, 'warning', 5000);
          break;

        case 'network_error':
          this.showNotification(message, 'error', 4000);
          break;

        default:
          this.showNotification(message, 'error');
          break;
      }
    }
  }, {
    key: "showNotification",
    value: function showNotification(message) {
      var _this7 = this;

      var type = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'info';
      var duration = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 5000;
      var $ = this.$; // Create appropriate icon based on type

      var icon = '';

      switch (type) {
        case 'warning':
          icon = '⚠️';
          break;

        case 'error':
          icon = '❌';
          break;

        case 'success':
          icon = '✅';
          break;

        default:
          icon = 'ℹ️';
          break;
      } // Reuse notification system from PDF export or create new one


      var notification = $("\n                <div class=\"swptls-notification swptls-notification-".concat(type, "\">\n                    <div class=\"swptls-notification-content\">\n                        <span class=\"swptls-notification-icon\">").concat(icon, "</span>\n                        <span class=\"swptls-notification-message\">").concat(message, "</span>\n                        <button class=\"swptls-notification-close\">&times;</button>\n                    </div>\n                </div>\n            "));
      $('body').append(notification);
      setTimeout(function () {
        notification.addClass('show');
      }, 100); // Auto-hide after specified duration

      setTimeout(function () {
        _this7.hideNotification(notification);
      }, duration); // Manual close button

      notification.find('.swptls-notification-close').on('click', function () {
        _this7.hideNotification(notification);
      });
    }
  }, {
    key: "hideNotification",
    value: function hideNotification(notification) {
      notification.removeClass('show');
      setTimeout(function () {
        notification.remove();
      }, 300);
    }
  }, {
    key: "showRegeneratingState",
    value: function showRegeneratingState(button) {
      button.prop('disabled', true).addClass('regenerating').html("\n                    <svg class=\"spinner\" width=\"16\" height=\"16\" viewBox=\"0 0 24 24\">\n                        <circle cx=\"12\" cy=\"12\" r=\"10\" stroke=\"currentColor\" stroke-width=\"2\" fill=\"none\" stroke-dasharray=\"31.416\" stroke-dashoffset=\"31.416\">\n                            <animate attributeName=\"stroke-dasharray\" dur=\"2s\" values=\"0 31.416;15.708 15.708;0 31.416\" repeatCount=\"indefinite\"/>\n                            <animate attributeName=\"stroke-dashoffset\" dur=\"2s\" values=\"0;-15.708;-31.416\" repeatCount=\"indefinite\"/>\n                        </circle>\n                    </svg>\n                    \uD83D\uDD04 Regenerating...\n                ");
    }
  }, {
    key: "hideRegeneratingState",
    value: function hideRegeneratingState(button) {
      button.prop('disabled', false).removeClass('regenerating').html('🔄 Regenerate Summary');
    }
  }, {
    key: "showRegeneratingInModal",
    value: function showRegeneratingInModal() {
      var $ = this.$;
      var summaryContent = $('.ai-summary-modal .summary-content');

      if (summaryContent.length) {
        summaryContent.html("\n                    <div class=\"regenerating-message\">\n                        <h3> Regenerating AI Summary...</h3>\n                        <p>Analyzing current table data and generating a fresh summary. This may take a few moments.</p>\n                        <div class=\"regenerating-dots\">\n                            <span>.</span><span>.</span><span>.</span>\n                        </div>\n                    </div>\n                ");
      }
    }
  }, {
    key: "updateModalContent",
    value: function updateModalContent(summaryData, tableId) {
      var $ = this.$;
      var summary = summaryData.summary,
          metadata = summaryData.metadata,
          generated_at = summaryData.generated_at,
          tokens_used = summaryData.tokens_used,
          model_used = summaryData.model_used; // Update summary content

      $('.ai-summary-modal .summary-content').html(this.formatSummary(summary)); // Update metadata

      /* const metadataGrid = $('.ai-summary-modal .metadata-grid');
      if (metadataGrid.length) {
          metadataGrid.html(`
                  <div class="metadata-item">
                      <span class="label">📊 Rows Analyzed:</span>
                      <span class="value">${metadata.rows_analyzed || 'N/A'}</span>
                  </div>
                  ${metadata.total_rows_in_dataset && metadata.total_rows_in_dataset !== metadata.rows_analyzed ? `
                  <div class="metadata-item">
                      <span class="label">📈 Total Rows:</span>
                      <span class="value">${metadata.total_rows_in_dataset}</span>
                  </div>
                  ` : ''}
                  
                  <div class="metadata-item">
                      <span class="label">🤖 Provider:</span>
                      <span class="value">${metadata.provider || 'AI'}</span>
                  </div>
                  <div class="metadata-item">
                      <span class="label">🎯 Model:</span>
                      <span class="value">${model_used || 'N/A'}</span>
                  </div>
                 
              `);
      } */
    } // Method to integrate with table configuration (following common_func.js pattern)
    // This should be called from table_configuration() method

  }, {
    key: "initializeForTable",
    value: function initializeForTable(tableId, table_settings) {
      // console.log(table_settings); 
      var $ = this.$;
      var container = $(".gswpts_tables_container[id=\"".concat(tableId, "\"]")); // Check if AI summary is enabled and summary_source is 'generate_on_click'

      var aiSummaryEnabled = table_settings === null || table_settings === void 0 ? void 0 : table_settings.enable_ai_summary;
      var summarySource = (table_settings === null || table_settings === void 0 ? void 0 : table_settings.summary_source) || 'generate_on_click';

      if (tableId && aiSummaryEnabled && summarySource === 'generate_on_click') {
        // Store table settings for this table to avoid re-parsing
        if (!window.swptlsTableSettings) {
          window.swptlsTableSettings = {};
        }

        window.swptlsTableSettings[tableId] = table_settings; // Note: AI Summary buttons are now rendered on the backend
        // This method now only stores settings for frontend functionality
        // console.log('AI Summary (Generate on Click) initialized for table:', tableId, 'with settings:', table_settings);
      } else if (tableId && aiSummaryEnabled && summarySource === 'instant_summary') {
        // For instant summary, we don't need frontend button but store settings for potential future use
        if (!window.swptlsTableSettings) {
          window.swptlsTableSettings = {};
        }

        window.swptlsTableSettings[tableId] = table_settings; // Initialize collapsed functionality if needed

        var summaryDisplay = (table_settings === null || table_settings === void 0 ? void 0 : table_settings.summary_display) || 'always_show';

        if (summaryDisplay === 'collapsed') {
          this.initializeCollapsedSummary(container);
        } // console.log('AI Summary (Instant Summary) initialized for table:', tableId, '- backend summary will be displayed');

      }
    }
  }, {
    key: "initializeCollapsedSummary",
    value: function initializeCollapsedSummary(container) {
      var $ = this.$;

      if (!container || !container.length) {
        console.warn('AI Summary: Invalid container provided for collapsed summary initialization');
        return;
      } // Find collapsed summary elements in this container


      var collapsedSummaries = container.find('.swptls-backend-ai-summary.collapsed');

      if (collapsedSummaries.length === 0) {
        // console.log('AI Summary: No collapsed summaries found in container');
        return;
      }

      collapsedSummaries.each(function () {
        var summaryElement = $(this);
        var header = summaryElement.find('.summary-header.clickable');
        var content = summaryElement.find('.summary-content.collapsible');
        var expandIcon = summaryElement.find('.expand-icon');

        if (header.length === 0) {
          console.warn('AI Summary: No clickable header found for collapsed summary');
          return;
        } // Add click handler for expand/collapse


        header.off('click.collapsedSummary').on('click.collapsedSummary', function (e) {
          e.preventDefault(); // Toggle the expanded state

          var isExpanded = summaryElement.hasClass('expanded');

          if (isExpanded) {
            // Collapse
            summaryElement.removeClass('expanded');
            content.slideUp(300); // Icon rotation handled by CSS
          } else {
            // Expand
            summaryElement.addClass('expanded');
            content.slideDown(300); // Icon rotation handled by CSS
          }
        }); // Add keyboard support for accessibility

        header.attr('tabindex', '0').off('keydown.collapsedSummary').on('keydown.collapsedSummary', function (e) {
          if (e.key === 'Enter' || e.key === ' ') {
            e.preventDefault();
            header.click(); // Trigger the click handler
          }
        }); // Initialize in collapsed state

        content.hide(); // Icon state handled by CSS
      }); // console.log(`AI Summary: Initialized ${collapsedSummaries.length} collapsed summaries`);
    }
  }]);

  return AISummary;
}(); // Initialize the AI Summary system outside jQuery ready block


var aiSummary = new AISummary(); // Make it globally available for other scripts

window.swptlsAISummary = aiSummary; // Add global click handler as fallback for collapsed summaries

jQuery(document).on('click', '.swptls-backend-ai-summary.collapsed .summary-header.clickable', function (e) {
  e.preventDefault(); // console.log('AI Summary: Global click handler triggered!');

  var header = jQuery(this);
  var summaryElement = header.closest('.swptls-backend-ai-summary');
  var content = summaryElement.find('.summary-content.collapsible');
  var expandIcon = summaryElement.find('.expand-icon');
  var isExpanded = summaryElement.hasClass('expanded'); // console.log('AI Summary: Global handler - current state expanded:', isExpanded);

  if (isExpanded) {
    // Collapse
    summaryElement.removeClass('expanded');
    content.slideUp(300); // Icon state handled by CSS
    // console.log('AI Summary: Global handler - collapsing...');
  } else {
    // Expand
    summaryElement.addClass('expanded');
    content.slideDown(300); // Icon rotation handled by CSS
    // console.log('AI Summary: Global handler - expanding...');
  }

  if (window.swptlsBatchLoader) {
    var originalAppendBatchData = window.swptlsBatchLoader.appendBatchData;

    window.swptlsBatchLoader.appendBatchData = function (data) {
      originalAppendBatchData.call(this, data); // Re-initialize AI features after batch loading

      setTimeout(function () {
        $('.gswpts_tables_container').each(function () {
          var _window$swptlsTableSe;

          var container = $(this);
          var tableId = container.attr('id');
          var tableSettings = (_window$swptlsTableSe = window.swptlsTableSettings) === null || _window$swptlsTableSe === void 0 ? void 0 : _window$swptlsTableSe[tableId];

          if (tableId && tableSettings && tableSettings.show_ai_summary_button) {
            aiSummary.initializeForTable(tableId, tableSettings);
          }
        });
      }, 500);
    };
  }
}); // Add method to initialize AI Summary for a specific table

aiSummary.initializeForTable = function (tableId, tableSettings) {
  var $ = jQuery;
  var container = $(".gswpts_tables_container[id=\"".concat(tableId, "\"]")); // Check if AI summary is enabled for this table

  var showAISummaryButton = tableSettings === null || tableSettings === void 0 ? void 0 : tableSettings.show_ai_summary_button;

  if (tableId && (showAISummaryButton === 'true' || showAISummaryButton === true)) {
    // Store table settings for this table
    if (!window.swptlsTableSettings) {
      window.swptlsTableSettings = {};
    }

    window.swptlsTableSettings[tableId] = tableSettings; // console.log('AI Summary initialized for table:', tableId, 'with settings:', tableSettings);
  }
};

/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[1].use[3]!./assets/src/Styles/Frontend/ai-summary.scss":
/*!***************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[1].use[3]!./assets/src/Styles/Frontend/ai-summary.scss ***!
  \***************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, "/**\n * AI Summary Styles for SWPTLS Tables\n */\n/* AI Summary Button */\n.swptls-ai-summary-controls {\n  display: flex;\n  justify-content: flex-start;\n}\n\n.swptls-ai-summary-btn {\n  display: inline-flex;\n  align-items: center;\n  gap: 8px;\n  padding: 8px 16px;\n  background: unset;\n  box-shadow: 0 2px 8px rgba(208, 208, 208, 0.3);\n  color: #080808;\n  border: none;\n  border-radius: 6px;\n  cursor: pointer;\n  font-size: 14px;\n  font-weight: 500;\n  text-decoration: none;\n  transition: all 0.3s ease;\n  position: relative;\n}\n\n.swptls-ai-summary-btn.above {\n  bottom: -5px;\n  left: 0px;\n}\n\n.swptls-ai-summary-btn.below {\n  bottom: 5px;\n  left: 0px;\n}\n\n.swptls-ai-summary-btn:hover {\n  background: unset;\n  color: #080808;\n  box-shadow: 0 2px 8px rgba(208, 208, 208, 0.3);\n  transform: translateY(-2px);\n}\n\n.swptls-ai-summary-btn:active {\n  transform: translateY(0);\n}\n\n.swptls-ai-summary-btn:disabled {\n  background: unset;\n  cursor: not-allowed;\n  transform: none;\n  box-shadow: none;\n}\n\n/* AI Icon Animation */\n.swptls-ai-summary-btn .ai-icon {\n  font-size: 16px;\n  fill: #3179ed;\n  -webkit-animation: pulse 2s infinite;\n          animation: pulse 2s infinite;\n}\n\n/* Hint Icon */\n.swptls-ai-summary-btn .hint-icon {\n  font-size: 12px;\n  opacity: 0.8;\n  margin-left: 4px;\n  -webkit-animation: hint-pulse 3s infinite;\n          animation: hint-pulse 3s infinite;\n}\n\n@-webkit-keyframes pulse {\n  0%, 100% {\n    transform: scale(1);\n  }\n  50% {\n    transform: scale(1.1);\n  }\n}\n\n@keyframes pulse {\n  0%, 100% {\n    transform: scale(1);\n  }\n  50% {\n    transform: scale(1.1);\n  }\n}\n@-webkit-keyframes hint-pulse {\n  0%, 80%, 100% {\n    opacity: 0.8;\n    transform: scale(1);\n  }\n  90% {\n    opacity: 1;\n    transform: scale(1.2);\n  }\n}\n@keyframes hint-pulse {\n  0%, 80%, 100% {\n    opacity: 0.8;\n    transform: scale(1);\n  }\n  90% {\n    opacity: 1;\n    transform: scale(1.2);\n  }\n}\n/* Loading State */\n.swptls-ai-summary-btn.generating {\n  color: #191919;\n  box-shadow: 0 2px 8px rgba(208, 208, 208, 0.3);\n  cursor: wait;\n}\n\n.swptls-ai-summary-btn.generating .ai-icon {\n  -webkit-animation: bounce 1s infinite;\n          animation: bounce 1s infinite;\n}\n\n@-webkit-keyframes bounce {\n  0%, 20%, 50%, 80%, 100% {\n    transform: translateY(0);\n  }\n  40% {\n    transform: translateY(-3px);\n  }\n  60% {\n    transform: translateY(-1px);\n  }\n}\n\n@keyframes bounce {\n  0%, 20%, 50%, 80%, 100% {\n    transform: translateY(0);\n  }\n  40% {\n    transform: translateY(-3px);\n  }\n  60% {\n    transform: translateY(-1px);\n  }\n}\n/* AI Summary Modal */\n.ai-summary-modal {\n  position: fixed;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  z-index: 10000;\n  opacity: 0;\n  visibility: hidden;\n  transition: all 0.3s ease;\n}\n\n.ai-summary-modal.show {\n  opacity: 1;\n  visibility: visible;\n}\n\n.ai-summary-modal .modal-overlay {\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  background: rgba(0, 0, 0, 0.7);\n  -webkit-backdrop-filter: blur(4px);\n          backdrop-filter: blur(4px);\n}\n\n.ai-summary-modal .modal-content {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  transform: translate(-50%, -50%) scale(0.9);\n  background: white;\n  border-radius: 12px;\n  box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);\n  max-width: 800px;\n  width: 90%;\n  max-height: 80vh;\n  overflow: hidden;\n  transition: transform 0.3s ease;\n}\n\n.ai-summary-modal.show .modal-content {\n  transform: translate(-50%, -50%) scale(1);\n}\n\n/* Modal Header */\n.ai-summary-modal .modal-header {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  padding: 20px 24px;\n  background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);\n  color: white;\n}\n\n.ai-summary-modal .modal-header h3 {\n  margin: 0;\n  font-size: 20px;\n  font-weight: 600;\n  color: #ffffff;\n}\n\n.ai-summary-modal .close-modal {\n  background: none;\n  border: none;\n  color: white;\n  font-size: 24px;\n  cursor: pointer;\n  padding: 0;\n  width: 32px;\n  height: 32px;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  border-radius: 50%;\n  transition: background-color 0.2s ease;\n}\n\n.ai-summary-modal .close-modal:hover {\n  background: rgba(255, 255, 255, 0.2);\n}\n\n/* Modal Body */\n.ai-summary-modal .modal-body {\n  padding: 24px;\n  max-height: 60vh;\n  overflow-y: auto;\n}\n\n.ai-summary-modal .summary-content {\n  font-size: 16px;\n  line-height: 1.6;\n  color: #374151;\n  margin-bottom: 24px;\n}\n\n.ai-summary-modal .summary-content p {\n  margin-bottom: 16px;\n}\n\n.ai-summary-modal .summary-content p:last-child {\n  margin-bottom: 0;\n}\n\n.ai-summary-modal .summary-content strong {\n  color: #1f2937;\n  font-weight: 600;\n}\n\n.ai-summary-modal .summary-content em {\n  color: #6b7280;\n  font-style: italic;\n}\n\n/* Modal Footer */\n.ai-summary-modal .modal-footer {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  padding: 20px 24px;\n  background: #f9fafb;\n  border-top: 1px solid #e5e7eb;\n}\n\n.ai-summary-modal .regenerate-summary-btn {\n  background: linear-gradient(135deg, #10b981 0%, #059669 100%);\n  color: white;\n  border: none;\n  padding: 10px 20px;\n  border-radius: 6px;\n  cursor: pointer;\n  font-size: 14px;\n  font-weight: 500;\n  transition: all 0.2s ease;\n}\n\n.ai-summary-modal .regenerate-summary-btn:hover {\n  background: linear-gradient(135deg, #059669 0%, #047857 100%);\n  transform: translateY(-1px);\n}\n\n.ai-summary-modal .modal-footer .secondary {\n  background: #6b7280;\n  color: white;\n  border: none;\n  padding: 10px 20px;\n  border-radius: 6px;\n  cursor: pointer;\n  font-size: 14px;\n  font-weight: 500;\n  transition: all 0.2s ease;\n}\n\n.ai-summary-modal .modal-footer .secondary:hover {\n  background: #4b5563;\n}\n\n/* AI Settings Styles */\n.ai-settings-container {\n  background: white;\n  border-radius: 8px;\n  padding: 24px;\n  box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);\n}\n\n.ai-settings-header h3 {\n  margin: 0 0 8px 0;\n  color: #1f2937;\n  font-size: 24px;\n}\n\n.ai-settings-header p {\n  margin: 0 0 24px 0;\n  color: #6b7280;\n  font-size: 16px;\n}\n\n.ai-settings-form .edit-form-group {\n  margin-bottom: 20px;\n}\n\n.ai-settings-form label {\n  display: block;\n  margin-bottom: 8px;\n  font-weight: 600;\n  color: #374151;\n  font-size: 14px;\n}\n\n.ai-settings-form input[type=text],\n.ai-settings-form input[type=password],\n.ai-settings-form select,\n.ai-settings-form textarea {\n  width: 100%;\n  padding: 10px 12px;\n  border: 1px solid #d1d5db;\n  border-radius: 6px;\n  font-size: 14px;\n  transition: border-color 0.2s ease;\n}\n\n.ai-settings-form input[type=text]:focus,\n.ai-settings-form input[type=password]:focus,\n.ai-settings-form select:focus,\n.ai-settings-form textarea:focus {\n  outline: none;\n  border-color: #667eea;\n  box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);\n}\n\n/* API Key Input Group */\n.api-key-input-group {\n  display: flex;\n  gap: 8px;\n  align-items: center;\n}\n\n.api-key-input {\n  flex: 1;\n}\n\n.toggle-api-key,\n.test-api-btn {\n  padding: 10px 12px;\n  border: 1px solid #d1d5db;\n  border-radius: 6px;\n  background: white;\n  cursor: pointer;\n  font-size: 14px;\n  transition: all 0.2s ease;\n}\n\n.toggle-api-key:hover,\n.test-api-btn:hover {\n  background: #f3f4f6;\n  border-color: #9ca3af;\n}\n\n.test-api-btn:disabled {\n  background: #f9fafb;\n  color: #9ca3af;\n  cursor: not-allowed;\n}\n\n/* Range Inputs */\n.ai-settings-form input[type=range] {\n  width: 100%;\n  margin: 8px 0;\n}\n\n.range-labels {\n  display: flex;\n  justify-content: space-between;\n  font-size: 12px;\n  color: #6b7280;\n}\n\n/* Test Result */\n.test-result {\n  padding: 12px 16px;\n  border-radius: 6px;\n  margin: 16px 0;\n  font-size: 14px;\n  font-weight: 500;\n}\n\n.test-result.success {\n  background: #d1fae5;\n  color: #065f46;\n  border: 1px solid #a7f3d0;\n}\n\n.test-result.error {\n  background: #fee2e2;\n  color: #991b1b;\n  border: 1px solid #fca5a5;\n}\n\n.test-result.info {\n  background: #dbeafe;\n  color: #1e40af;\n  border: 1px solid #93c5fd;\n}\n\n/* Save Button */\n.save-ai-settings {\n  background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);\n  color: white;\n  border: none;\n  padding: 12px 24px;\n  border-radius: 6px;\n  cursor: pointer;\n  font-size: 16px;\n  font-weight: 600;\n  transition: all 0.2s ease;\n}\n\n.save-ai-settings:hover {\n  background: linear-gradient(135deg, #5a67d8 0%, #6b46c1 100%);\n  transform: translateY(-1px);\n}\n\n.save-ai-settings:disabled {\n  background: #9ca3af;\n  cursor: not-allowed;\n  transform: none;\n}\n\n/* Info Section */\n.ai-settings-info {\n  margin-top: 32px;\n  padding: 20px;\n  background: #f0f9ff;\n  border-radius: 8px;\n  border: 1px solid #bae6fd;\n}\n\n.ai-settings-info h4 {\n  margin: 0 0 16px 0;\n  color: #0c4a6e;\n  font-size: 18px;\n}\n\n.ai-settings-info ul {\n  margin: 0;\n  padding-left: 20px;\n}\n\n.ai-settings-info li {\n  margin-bottom: 8px;\n  color: #0f172a;\n  line-height: 1.5;\n}\n\n.ai-settings-info a {\n  color: #0ea5e9;\n  text-decoration: none;\n}\n\n.ai-settings-info a:hover {\n  text-decoration: underline;\n}\n\n/* Responsive Design */\n@media (max-width: 768px) {\n  .ai-summary-modal .modal-content {\n    width: 95%;\n    max-height: 90vh;\n  }\n\n  .ai-summary-modal .modal-header,\n.ai-summary-modal .modal-body,\n.ai-summary-modal .modal-footer {\n    padding: 16px;\n  }\n\n  .ai-summary-modal .metadata-grid {\n    grid-template-columns: 1fr;\n  }\n\n  .api-key-input-group {\n    flex-direction: column;\n  }\n\n  .api-key-input {\n    width: 100%;\n  }\n\n  .swptls-ai-summary-controls {\n    margin: 12px 0;\n  }\n\n  .swptls-ai-summary-btn {\n    width: 100%;\n    justify-content: center;\n  }\n}\n/* Dark Mode Support */\n@media (color-index: 48) {\n  .ai-summary-modal .modal-content {\n    background: #1f2937;\n    color: #f9fafb;\n  }\n\n  .ai-summary-modal .summary-content {\n    color: #d1d5db;\n  }\n\n  .ai-summary-modal .modal-footer {\n    background: #374151;\n    border-color: #4b5563;\n  }\n\n  .ai-settings-container {\n    background: #1f2937;\n    color: #f9fafb;\n  }\n\n  .ai-settings-form input,\n.ai-settings-form select,\n.ai-settings-form textarea {\n    background: #374151;\n    border-color: #4b5563;\n    color: #f9fafb;\n  }\n}\n@media (color: 48842621) {\n  .ai-summary-modal .modal-content {\n    background: #1f2937;\n    color: #f9fafb;\n  }\n\n  .ai-summary-modal .summary-content {\n    color: #d1d5db;\n  }\n\n  .ai-summary-modal .modal-footer {\n    background: #374151;\n    border-color: #4b5563;\n  }\n\n  .ai-settings-container {\n    background: #1f2937;\n    color: #f9fafb;\n  }\n\n  .ai-settings-form input,\n.ai-settings-form select,\n.ai-settings-form textarea {\n    background: #374151;\n    border-color: #4b5563;\n    color: #f9fafb;\n  }\n}\n@media (prefers-color-scheme: dark) {\n  .ai-summary-modal .modal-content {\n    background: #1f2937;\n    color: #f9fafb;\n  }\n\n  .ai-summary-modal .summary-content {\n    color: #d1d5db;\n  }\n\n  .ai-summary-modal .modal-footer {\n    background: #374151;\n    border-color: #4b5563;\n  }\n\n  .ai-settings-container {\n    background: #1f2937;\n    color: #f9fafb;\n  }\n\n  .ai-settings-form input,\n.ai-settings-form select,\n.ai-settings-form textarea {\n    background: #374151;\n    border-color: #4b5563;\n    color: #f9fafb;\n  }\n}\n.regenerate-summary-btn.regenerating {\n  background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);\n  cursor: not-allowed;\n  transform: none;\n}\n\n.regenerating-message h3 {\n  margin: 0 0 12px 0;\n  color: #1f2937;\n  font-size: 20px;\n}\n\n.regenerating-message p {\n  margin: 0 0 20px 0;\n  color: #6b7280;\n  font-size: 16px;\n  line-height: 1.5;\n}\n\n.regenerating-dots {\n  display: flex;\n  justify-content: center;\n  gap: 4px;\n}\n\n.regenerating-dots span {\n  width: 8px;\n  height: 8px;\n  background: #667eea;\n  border-radius: 50%;\n  -webkit-animation: bounce 1.4s ease-in-out infinite both;\n          animation: bounce 1.4s ease-in-out infinite both;\n}\n\n.regenerating-dots span:nth-child(1) {\n  -webkit-animation-delay: -0.32s;\n          animation-delay: -0.32s;\n}\n\n.regenerating-dots span:nth-child(2) {\n  -webkit-animation-delay: -0.16s;\n          animation-delay: -0.16s;\n}\n\n@-webkit-keyframes spin {\n  0% {\n    transform: rotate(0deg);\n  }\n  100% {\n    transform: rotate(360deg);\n  }\n}\n\n@keyframes spin {\n  0% {\n    transform: rotate(0deg);\n  }\n  100% {\n    transform: rotate(360deg);\n  }\n}\n@keyframes bounce {\n  0%, 80%, 100% {\n    transform: scale(0);\n  }\n  40% {\n    transform: scale(1);\n  }\n}\n/* Backend AI Summary Display Styles */\n.swptls-backend-ai-summary {\n  border: 1px solid #e2e8f0;\n  box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);\n  margin: 10px 15px 25px 10px;\n  background-color: rgba(15,115,248,0.14902);\n  color: #525252;\n  border-radius: 1.5rem;\n  flex-flow: column;\n  justify-content: flex-start;\n  align-items: flex-start;\n  padding: 1.5rem;\n  display: flex;\n}\n\n.swptls-backend-ai-summary .summary-header {\n  display: flex;\n  align-items: center;\n  padding-bottom: 10px;\n  gap: 5px;\n}\n\n.swptls-backend-ai-summary .summary-title {\n  margin: 0;\n  color: #1e293b;\n  font-size: 18px;\n  font-weight: 600;\n  display: flex;\n  align-items: center;\n  gap: 8px;\n}\n\n.swptls-backend-ai-summary .ai-icon {\n  font-size: 16px;\n  fill: #3179ed;\n  -webkit-animation: pulse 2s infinite;\n          animation: pulse 2s infinite;\n  margin-top: 8px;\n}\n\n.swptls-backend-ai-summary .summary-content {\n  color: #334155;\n  font-size: 15px;\n  line-height: 1.7;\n}\n\n.swptls-backend-ai-summary .summary-content p {\n  margin: 0 0 12px 0;\n}\n\n.swptls-backend-ai-summary .summary-content p:last-child {\n  margin-bottom: 0;\n}\n\n.swptls-backend-ai-summary .summary-content strong {\n  color: #1e293b;\n  font-weight: 600;\n}\n\n.swptls-backend-ai-summary .summary-content em {\n  color: #64748b;\n  font-style: italic;\n}\n\n.swptls-backend-ai-summary .summary-content ol {\n  margin: 12px 0;\n  padding-left: 24px;\n  list-style-type: decimal;\n  list-style-position: outside;\n}\n\n.swptls-backend-ai-summary .summary-content ul {\n  margin: 12px 0;\n  padding-left: 24px;\n  list-style-type: disc;\n  list-style-position: outside;\n}\n\n.swptls-backend-ai-summary .summary-content ol li,\n.swptls-backend-ai-summary .summary-content ul li {\n  color: #475569;\n  line-height: 1.6;\n  display: list-item;\n  list-style-position: outside;\n}\n\n.swptls-backend-ai-summary .summary-content li strong {\n  color: #1e293b;\n}\n\n/* Responsive Design for Backend Summary */\n@media (max-width: 768px) {\n  .swptls-backend-ai-summary {\n    padding: 16px;\n    margin: 12px 0;\n  }\n\n  .swptls-backend-ai-summary .summary-title {\n    font-size: 16px;\n  }\n\n  .swptls-backend-ai-summary .summary-content {\n    font-size: 14px;\n  }\n}\n/* Backend AI Summary Collapsed Mode - Enhanced UX */\n.swptls-backend-ai-summary.collapsed {\n  background: transparent;\n  border: none;\n  box-shadow: none;\n  padding: 0;\n  margin: 20px 0;\n}\n.swptls-backend-ai-summary.collapsed .summary-header.clickable {\n  cursor: pointer;\n  -webkit-user-select: none;\n     -moz-user-select: none;\n      -ms-user-select: none;\n          user-select: none;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  transition: all 0.2s ease;\n  border-radius: 0;\n  padding: 12px 0;\n  margin: 0;\n  background: transparent;\n}\n.swptls-backend-ai-summary.collapsed .summary-header.clickable:hover {\n  color: #374151;\n}\n.swptls-backend-ai-summary.collapsed .summary-header.clickable:hover .expand-icon {\n  color: #6b7280;\n  transform: scale(1.05);\n}\n.swptls-backend-ai-summary.collapsed .summary-header.clickable:focus {\n  outline: 2px solid #3b82f6;\n  outline-offset: 2px;\n  border-radius: 4px;\n}\n.swptls-backend-ai-summary.collapsed .summary-header .summary-title {\n  font-size: 16px;\n  font-weight: 500;\n  color: #111827;\n  margin: 0;\n  display: flex;\n  align-items: center;\n  gap: 0;\n}\n.swptls-backend-ai-summary.collapsed .summary-header .ai-icon {\n  display: none;\n}\n.swptls-backend-ai-summary.collapsed .summary-header .expand-icon {\n  font-size: 14px;\n  transition: all 0.3s ease;\n  color: #6b7280;\n  font-weight: normal;\n  display: flex;\n  align-items: center;\n  margin-left: 8px;\n}\n.swptls-backend-ai-summary.collapsed .summary-header .expand-icon svg {\n  width: 16px;\n  height: 16px;\n  transition: transform 0.3s ease;\n  fill: currentColor;\n}\n.swptls-backend-ai-summary.collapsed .summary-content.collapsible {\n  max-height: 0;\n  overflow: hidden;\n  transition: all 0.3s ease;\n  padding: 0;\n  opacity: 0;\n  font-size: 14px;\n  line-height: 1.6;\n  color: #374151;\n}\n.swptls-backend-ai-summary.collapsed .summary-content.collapsible p {\n  margin: 0 0 12px 0;\n  color: #374151;\n  line-height: 1.6;\n}\n.swptls-backend-ai-summary.collapsed .summary-content.collapsible p:last-child {\n  margin-bottom: 0;\n}\n.swptls-backend-ai-summary.collapsed .summary-content.collapsible ul,\n.swptls-backend-ai-summary.collapsed .summary-content.collapsible ol {\n  margin: 0 0 12px 0;\n  padding-left: 20px;\n}\n.swptls-backend-ai-summary.collapsed .summary-content.collapsible li {\n  margin-bottom: 4px;\n  color: #374151;\n}\n.swptls-backend-ai-summary.collapsed .summary-content.collapsible strong {\n  font-weight: 600;\n  color: #111827;\n}\n.swptls-backend-ai-summary.collapsed .summary-content.collapsible em {\n  font-style: italic;\n  color: #4b5563;\n}\n.swptls-backend-ai-summary.collapsed.expanded .summary-header .expand-icon svg {\n  transform: rotate(90deg);\n}\n.swptls-backend-ai-summary.collapsed.expanded .summary-content.collapsible {\n  max-height: 1000px;\n  padding-top: 16px;\n  opacity: 1;\n}\n\n/* Animation for smooth expand/collapse */\n@-webkit-keyframes expandContent {\n  from {\n    max-height: 0;\n    opacity: 0;\n  }\n  to {\n    max-height: 1000px;\n    opacity: 1;\n  }\n}\n@keyframes expandContent {\n  from {\n    max-height: 0;\n    opacity: 0;\n  }\n  to {\n    max-height: 1000px;\n    opacity: 1;\n  }\n}\n@-webkit-keyframes collapseContent {\n  from {\n    max-height: 1000px;\n    opacity: 1;\n  }\n  to {\n    max-height: 0;\n    opacity: 0;\n  }\n}\n@keyframes collapseContent {\n  from {\n    max-height: 1000px;\n    opacity: 1;\n  }\n  to {\n    max-height: 0;\n    opacity: 0;\n  }\n}\n/* Enhanced accessibility and interaction states */\n.swptls-backend-ai-summary.collapsed .summary-header.clickable.focus-visible {\n  outline: 2px solid #3b82f6;\n  outline-offset: 2px;\n  border-radius: 4px;\n}\n.swptls-backend-ai-summary.collapsed .summary-header.clickable:focus-visible {\n  outline: 2px solid #3b82f6;\n  outline-offset: 2px;\n  border-radius: 4px;\n}\n.swptls-backend-ai-summary.collapsed .summary-header.clickable * {\n  transition: all 0.2s ease;\n}\n\n/* Smooth animations for expand/collapse */\n.swptls-backend-ai-summary.collapsed .summary-content.collapsible {\n  max-height: 0;\n  overflow: hidden;\n  transition: max-height 0.3s ease, padding-top 0.3s ease, opacity 0.3s ease;\n  opacity: 0;\n}\n.swptls-backend-ai-summary.collapsed.expanded .summary-content.collapsible {\n  max-height: -webkit-max-content;\n  max-height: -moz-max-content;\n  max-height: max-content;\n  opacity: 1;\n  height: 400px;\n  overflow-y: scroll;\n  scrollbar-width: thin;\n  scrollbar-color: #d1d5db #ffffff;\n}\n\n/* Mobile responsive adjustments for collapsed mode */\n@media (max-width: 768px) {\n  .swptls-backend-ai-summary.collapsed {\n    margin: 16px 0;\n  }\n  .swptls-backend-ai-summary.collapsed .summary-header.clickable {\n    padding: 16px 0;\n  }\n  .swptls-backend-ai-summary.collapsed .summary-header.clickable .summary-title {\n    font-size: 15px;\n  }\n  .swptls-backend-ai-summary.collapsed .expand-icon::before {\n    width: 18px;\n    height: 18px;\n  }\n  .swptls-backend-ai-summary.collapsed .summary-content.collapsible {\n    font-size: 13px;\n  }\n  .swptls-backend-ai-summary.collapsed .summary-content.collapsible.expanded {\n    padding-top: 12px;\n  }\n}\n/* High contrast mode support */\n@media (prefers-contrast: high) {\n  .swptls-backend-ai-summary.collapsed .summary-header.clickable .summary-title {\n    color: #000;\n    font-weight: 600;\n  }\n  .swptls-backend-ai-summary.collapsed .summary-header.clickable .expand-icon svg {\n    stroke: #000;\n    stroke-width: 3;\n  }\n  .swptls-backend-ai-summary.collapsed .summary-content.collapsible {\n    color: #000;\n  }\n  .swptls-backend-ai-summary.collapsed .summary-content.collapsible strong {\n    color: #000;\n  }\n}\n/* Reduced motion support */\n@media (prefers-reduced-motion: reduce) {\n  .swptls-backend-ai-summary.collapsed .summary-header.clickable,\n.swptls-backend-ai-summary.collapsed .summary-content.collapsible,\n.swptls-backend-ai-summary.collapsed .expand-icon::before {\n    transition: none;\n  }\n}\n/* AI Sum\nmary Notification Styles */\n.swptls-notification {\n  position: fixed;\n  top: 20px;\n  right: 20px;\n  z-index: 10000;\n  max-width: 400px;\n  min-width: 300px;\n  opacity: 0;\n  transform: translateX(100%);\n  transition: all 0.3s ease;\n  border-radius: 8px;\n  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);\n}\n.swptls-notification.show {\n  opacity: 1;\n  transform: translateX(0);\n}\n.swptls-notification .swptls-notification-content {\n  display: flex;\n  align-items: center;\n  padding: 16px;\n  gap: 12px;\n}\n.swptls-notification .swptls-notification-content .swptls-notification-icon {\n  font-size: 18px;\n  flex-shrink: 0;\n}\n.swptls-notification .swptls-notification-content .swptls-notification-message {\n  flex: 1;\n  font-size: 14px;\n  line-height: 1.4;\n  color: inherit;\n}\n.swptls-notification .swptls-notification-content .swptls-notification-close {\n  background: none;\n  border: none;\n  font-size: 18px;\n  cursor: pointer;\n  padding: 0;\n  width: 24px;\n  height: 24px;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  border-radius: 50%;\n  transition: background-color 0.2s ease;\n  color: inherit;\n}\n.swptls-notification .swptls-notification-content .swptls-notification-close:hover {\n  background-color: rgba(0, 0, 0, 0.1);\n}\n.swptls-notification.swptls-notification-error {\n  background-color: #fee;\n  border-left: 4px solid #dc3545;\n  color: #721c24;\n}\n.swptls-notification.swptls-notification-warning {\n  background-color: #fff3cd;\n  border-left: 4px solid #ffc107;\n  color: #856404;\n}\n.swptls-notification.swptls-notification-success {\n  background-color: #d4edda;\n  border-left: 4px solid #28a745;\n  color: #155724;\n}\n.swptls-notification.swptls-notification-info {\n  background-color: #d1ecf1;\n  border-left: 4px solid #17a2b8;\n  color: #0c5460;\n}\n\n/* Responsive adjustments */\n@media (max-width: 768px) {\n  .swptls-notification {\n    top: 10px;\n    right: 10px;\n    left: 10px;\n    max-width: none;\n    min-width: auto;\n  }\n}", "",{"version":3,"sources":["webpack://./assets/src/Styles/Frontend/ai-summary.scss"],"names":[],"mappings":"AAAA;;EAAA;AAIA,sBAAA;AACA;EACI,aAAA;EACA,2BAAA;AAAJ;;AAGA;EACI,oBAAA;EACA,mBAAA;EACA,QAAA;EACA,iBAAA;EACA,iBAAA;EACA,8CAAA;EACA,cAAA;EACA,YAAA;EACA,kBAAA;EACA,eAAA;EACA,eAAA;EACA,gBAAA;EACA,qBAAA;EACA,yBAAA;EACA,kBAAA;AAAJ;;AAKA;EACI,YAAA;EACA,SAAA;AAFJ;;AAKA;EACI,WAAA;EACA,SAAA;AAFJ;;AAKA;EACI,iBAAA;EACA,cAAA;EACA,8CAAA;EACA,2BAAA;AAFJ;;AAKA;EACI,wBAAA;AAFJ;;AAKA;EACI,iBAAA;EACA,mBAAA;EACA,eAAA;EACA,gBAAA;AAFJ;;AAKA,sBAAA;AACA;EACI,eAAA;EACA,aAAA;EACA,oCAAA;UAAA,4BAAA;AAFJ;;AAKA,cAAA;AACA;EACI,eAAA;EACA,YAAA;EACA,gBAAA;EACA,yCAAA;UAAA,iCAAA;AAFJ;;AAKA;EAEI;IAEI,mBAAA;EAJN;EAOE;IACI,qBAAA;EALN;AACF;;AAJA;EAEI;IAEI,mBAAA;EAJN;EAOE;IACI,qBAAA;EALN;AACF;AAQA;EAEI;IAGI,YAAA;IACA,mBAAA;EATN;EAYE;IACI,UAAA;IACA,qBAAA;EAVN;AACF;AAFA;EAEI;IAGI,YAAA;IACA,mBAAA;EATN;EAYE;IACI,UAAA;IACA,qBAAA;EAVN;AACF;AAaA,kBAAA;AACA;EACI,cAAA;EACA,8CAAA;EACA,YAAA;AAXJ;;AAcA;EACI,qCAAA;UAAA,6BAAA;AAXJ;;AAcA;EAEI;IAKI,wBAAA;EAhBN;EAmBE;IACI,2BAAA;EAjBN;EAoBE;IACI,2BAAA;EAlBN;AACF;;AAEA;EAEI;IAKI,wBAAA;EAhBN;EAmBE;IACI,2BAAA;EAjBN;EAoBE;IACI,2BAAA;EAlBN;AACF;AAqBA,qBAAA;AACA;EACI,eAAA;EACA,MAAA;EACA,OAAA;EACA,WAAA;EACA,YAAA;EACA,cAAA;EACA,UAAA;EACA,kBAAA;EACA,yBAAA;AAnBJ;;AAsBA;EACI,UAAA;EACA,mBAAA;AAnBJ;;AAsBA;EACI,kBAAA;EACA,MAAA;EACA,OAAA;EACA,WAAA;EACA,YAAA;EACA,8BAAA;EACA,kCAAA;UAAA,0BAAA;AAnBJ;;AAsBA;EACI,kBAAA;EACA,QAAA;EACA,SAAA;EACA,2CAAA;EACA,iBAAA;EACA,mBAAA;EACA,0CAAA;EACA,gBAAA;EACA,UAAA;EACA,gBAAA;EACA,gBAAA;EACA,+BAAA;AAnBJ;;AAsBA;EACI,yCAAA;AAnBJ;;AAsBA,iBAAA;AACA;EACI,aAAA;EACA,8BAAA;EACA,mBAAA;EACA,kBAAA;EACA,6DAAA;EACA,YAAA;AAnBJ;;AAsBA;EACI,SAAA;EACA,eAAA;EACA,gBAAA;EACA,cAAA;AAnBJ;;AAsBA;EACI,gBAAA;EACA,YAAA;EACA,YAAA;EACA,eAAA;EACA,eAAA;EACA,UAAA;EACA,WAAA;EACA,YAAA;EACA,aAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,sCAAA;AAnBJ;;AAsBA;EACI,oCAAA;AAnBJ;;AAsBA,eAAA;AACA;EACI,aAAA;EACA,gBAAA;EACA,gBAAA;AAnBJ;;AAsBA;EACI,eAAA;EACA,gBAAA;EACA,cAAA;EACA,mBAAA;AAnBJ;;AAsBA;EACI,mBAAA;AAnBJ;;AAsBA;EACI,gBAAA;AAnBJ;;AAsBA;EACI,cAAA;EACA,gBAAA;AAnBJ;;AAsBA;EACI,cAAA;EACA,kBAAA;AAnBJ;;AAsBA,iBAAA;AACA;EACI,aAAA;EACA,8BAAA;EACA,mBAAA;EACA,kBAAA;EACA,mBAAA;EACA,6BAAA;AAnBJ;;AAsBA;EACI,6DAAA;EACA,YAAA;EACA,YAAA;EACA,kBAAA;EACA,kBAAA;EACA,eAAA;EACA,eAAA;EACA,gBAAA;EACA,yBAAA;AAnBJ;;AAsBA;EACI,6DAAA;EACA,2BAAA;AAnBJ;;AAsBA;EACI,mBAAA;EACA,YAAA;EACA,YAAA;EACA,kBAAA;EACA,kBAAA;EACA,eAAA;EACA,eAAA;EACA,gBAAA;EACA,yBAAA;AAnBJ;;AAsBA;EACI,mBAAA;AAnBJ;;AAsBA,uBAAA;AACA;EACI,iBAAA;EACA,kBAAA;EACA,aAAA;EACA,wCAAA;AAnBJ;;AAsBA;EACI,iBAAA;EACA,cAAA;EACA,eAAA;AAnBJ;;AAsBA;EACI,kBAAA;EACA,cAAA;EACA,eAAA;AAnBJ;;AAsBA;EACI,mBAAA;AAnBJ;;AAsBA;EACI,cAAA;EACA,kBAAA;EACA,gBAAA;EACA,cAAA;EACA,eAAA;AAnBJ;;AAsBA;;;;EAII,WAAA;EACA,kBAAA;EACA,yBAAA;EACA,kBAAA;EACA,eAAA;EACA,kCAAA;AAnBJ;;AAsBA;;;;EAII,aAAA;EACA,qBAAA;EACA,8CAAA;AAnBJ;;AAsBA,wBAAA;AACA;EACI,aAAA;EACA,QAAA;EACA,mBAAA;AAnBJ;;AAsBA;EACI,OAAA;AAnBJ;;AAsBA;;EAEI,kBAAA;EACA,yBAAA;EACA,kBAAA;EACA,iBAAA;EACA,eAAA;EACA,eAAA;EACA,yBAAA;AAnBJ;;AAsBA;;EAEI,mBAAA;EACA,qBAAA;AAnBJ;;AAsBA;EACI,mBAAA;EACA,cAAA;EACA,mBAAA;AAnBJ;;AAsBA,iBAAA;AACA;EACI,WAAA;EACA,aAAA;AAnBJ;;AAsBA;EACI,aAAA;EACA,8BAAA;EACA,eAAA;EACA,cAAA;AAnBJ;;AAsBA,gBAAA;AACA;EACI,kBAAA;EACA,kBAAA;EACA,cAAA;EACA,eAAA;EACA,gBAAA;AAnBJ;;AAsBA;EACI,mBAAA;EACA,cAAA;EACA,yBAAA;AAnBJ;;AAsBA;EACI,mBAAA;EACA,cAAA;EACA,yBAAA;AAnBJ;;AAsBA;EACI,mBAAA;EACA,cAAA;EACA,yBAAA;AAnBJ;;AAsBA,gBAAA;AACA;EACI,6DAAA;EACA,YAAA;EACA,YAAA;EACA,kBAAA;EACA,kBAAA;EACA,eAAA;EACA,eAAA;EACA,gBAAA;EACA,yBAAA;AAnBJ;;AAsBA;EACI,6DAAA;EACA,2BAAA;AAnBJ;;AAsBA;EACI,mBAAA;EACA,mBAAA;EACA,eAAA;AAnBJ;;AAsBA,iBAAA;AACA;EACI,gBAAA;EACA,aAAA;EACA,mBAAA;EACA,kBAAA;EACA,yBAAA;AAnBJ;;AAsBA;EACI,kBAAA;EACA,cAAA;EACA,eAAA;AAnBJ;;AAsBA;EACI,SAAA;EACA,kBAAA;AAnBJ;;AAsBA;EACI,kBAAA;EACA,cAAA;EACA,gBAAA;AAnBJ;;AAsBA;EACI,cAAA;EACA,qBAAA;AAnBJ;;AAsBA;EACI,0BAAA;AAnBJ;;AAsBA,sBAAA;AACA;EACI;IACI,UAAA;IACA,gBAAA;EAnBN;;EAsBE;;;IAGI,aAAA;EAnBN;;EAsBE;IACI,0BAAA;EAnBN;;EAsBE;IACI,sBAAA;EAnBN;;EAsBE;IACI,WAAA;EAnBN;;EAsBE;IACI,cAAA;EAnBN;;EAsBE;IACI,WAAA;IACA,uBAAA;EAnBN;AACF;AAsBA,sBAAA;AACA;EACI;IACI,mBAAA;IACA,cAAA;EApBN;;EAuBE;IACI,cAAA;EApBN;;EAuBE;IACI,mBAAA;IACA,qBAAA;EApBN;;EAuBE;IACI,mBAAA;IACA,cAAA;EApBN;;EAuBE;;;IAGI,mBAAA;IACA,qBAAA;IACA,cAAA;EApBN;AACF;AANA;EACI;IACI,mBAAA;IACA,cAAA;EApBN;;EAuBE;IACI,cAAA;EApBN;;EAuBE;IACI,mBAAA;IACA,qBAAA;EApBN;;EAuBE;IACI,mBAAA;IACA,cAAA;EApBN;;EAuBE;;;IAGI,mBAAA;IACA,qBAAA;IACA,cAAA;EApBN;AACF;AANA;EACI;IACI,mBAAA;IACA,cAAA;EApBN;;EAuBE;IACI,cAAA;EApBN;;EAuBE;IACI,mBAAA;IACA,qBAAA;EApBN;;EAuBE;IACI,mBAAA;IACA,cAAA;EApBN;;EAuBE;;;IAGI,mBAAA;IACA,qBAAA;IACA,cAAA;EApBN;AACF;AAwBA;EACI,6DAAA;EACA,mBAAA;EACA,eAAA;AAtBJ;;AAyBA;EACI,kBAAA;EACA,cAAA;EACA,eAAA;AAtBJ;;AAyBA;EACI,kBAAA;EACA,cAAA;EACA,eAAA;EACA,gBAAA;AAtBJ;;AAyBA;EACI,aAAA;EACA,uBAAA;EACA,QAAA;AAtBJ;;AAyBA;EACI,UAAA;EACA,WAAA;EACA,mBAAA;EACA,kBAAA;EACA,wDAAA;UAAA,gDAAA;AAtBJ;;AAyBA;EACI,+BAAA;UAAA,uBAAA;AAtBJ;;AAyBA;EACI,+BAAA;UAAA,uBAAA;AAtBJ;;AAyBA;EACI;IACI,uBAAA;EAtBN;EAyBE;IACI,yBAAA;EAvBN;AACF;;AAgBA;EACI;IACI,uBAAA;EAtBN;EAyBE;IACI,yBAAA;EAvBN;AACF;AA0BA;EAEI;IAGI,mBAAA;EA3BN;EA8BE;IACI,mBAAA;EA5BN;AACF;AA+BA,sCAAA;AACA;EACI,yBAAA;EACA,wCAAA;EACA,2BAAA;EACA,0CAAA;EACA,cAAA;EACA,qBAAA;EACA,iBAAA;EACA,2BAAA;EACA,uBAAA;EACA,eAAA;EACA,aAAA;AA7BJ;;AAgCA;EACI,aAAA;EACA,mBAAA;EACA,oBAAA;EACA,QAAA;AA7BJ;;AAgCA;EACI,SAAA;EACA,cAAA;EACA,eAAA;EACA,gBAAA;EACA,aAAA;EACA,mBAAA;EACA,QAAA;AA7BJ;;AAgCA;EACI,eAAA;EACA,aAAA;EACA,oCAAA;UAAA,4BAAA;EACA,eAAA;AA7BJ;;AAgCA;EACI,cAAA;EACA,eAAA;EACA,gBAAA;AA7BJ;;AAgCA;EACI,kBAAA;AA7BJ;;AAgCA;EACI,gBAAA;AA7BJ;;AAgCA;EACI,cAAA;EACA,gBAAA;AA7BJ;;AAgCA;EACI,cAAA;EACA,kBAAA;AA7BJ;;AAgCA;EACI,cAAA;EACA,kBAAA;EACA,wBAAA;EACA,4BAAA;AA7BJ;;AAgCA;EACI,cAAA;EACA,kBAAA;EACA,qBAAA;EACA,4BAAA;AA7BJ;;AAgCA;;EAEI,cAAA;EACA,gBAAA;EACA,kBAAA;EACA,4BAAA;AA7BJ;;AAgCA;EACI,cAAA;AA7BJ;;AAgCA,0CAAA;AACA;EACI;IACI,aAAA;IACA,cAAA;EA7BN;;EAgCE;IACI,eAAA;EA7BN;;EAgCE;IACI,eAAA;EA7BN;AACF;AAgCA,oDAAA;AACA;EAEI,uBAAA;EACA,YAAA;EACA,gBAAA;EACA,UAAA;EACA,cAAA;AA/BJ;AAkCQ;EACI,eAAA;EACA,yBAAA;KAAA,sBAAA;MAAA,qBAAA;UAAA,iBAAA;EACA,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,yBAAA;EACA,gBAAA;EACA,eAAA;EACA,SAAA;EAEA,uBAAA;AAjCZ;AAmCY;EACI,cAAA;AAjChB;AAmCgB;EACI,cAAA;EACA,sBAAA;AAjCpB;AAqCY;EACI,0BAAA;EACA,mBAAA;EACA,kBAAA;AAnChB;AAuCQ;EACI,eAAA;EACA,gBAAA;EACA,cAAA;EACA,SAAA;EACA,aAAA;EACA,mBAAA;EACA,MAAA;AArCZ;AAwCQ;EACI,aAAA;AAtCZ;AAyCQ;EACI,eAAA;EACA,yBAAA;EACA,cAAA;EACA,mBAAA;EACA,aAAA;EACA,mBAAA;EACA,gBAAA;AAvCZ;AA0CY;EACI,WAAA;EACA,YAAA;EACA,+BAAA;EACA,kBAAA;AAxChB;AA8CI;EACI,aAAA;EACA,gBAAA;EACA,yBAAA;EACA,UAAA;EACA,UAAA;EAGA,eAAA;EACA,gBAAA;EACA,cAAA;AA9CR;AAgDQ;EACI,kBAAA;EACA,cAAA;EACA,gBAAA;AA9CZ;AAiDQ;EACI,gBAAA;AA/CZ;AAkDQ;;EAEI,kBAAA;EACA,kBAAA;AAhDZ;AAmDQ;EACI,kBAAA;EACA,cAAA;AAjDZ;AAoDQ;EACI,gBAAA;EACA,cAAA;AAlDZ;AAqDQ;EACI,kBAAA;EACA,cAAA;AAnDZ;AA0DgB;EACI,wBAAA;AAxDpB;AA6DQ;EACI,kBAAA;EACA,iBAAA;EACA,UAAA;AA3DZ;;AAgEA,yCAAA;AACA;EACI;IACI,aAAA;IACA,UAAA;EA7DN;EAgEE;IACI,kBAAA;IACA,UAAA;EA9DN;AACF;AAqDA;EACI;IACI,aAAA;IACA,UAAA;EA7DN;EAgEE;IACI,kBAAA;IACA,UAAA;EA9DN;AACF;AAiEA;EACI;IACI,kBAAA;IACA,UAAA;EA/DN;EAkEE;IACI,aAAA;IACA,UAAA;EAhEN;AACF;AAuDA;EACI;IACI,kBAAA;IACA,UAAA;EA/DN;EAkEE;IACI,aAAA;IACA,UAAA;EAhEN;AACF;AAmEA,kDAAA;AAGQ;EACI,0BAAA;EACA,mBAAA;EACA,kBAAA;AAnEZ;AAgEQ;EACI,0BAAA;EACA,mBAAA;EACA,kBAAA;AAnEZ;AAuEQ;EACI,yBAAA;AArEZ;;AA0EA,0CAAA;AAEI;EACI,aAAA;EACA,gBAAA;EACA,0EAAA;EACA,UAAA;AAxER;AA2EI;EACI,+BAAA;EAAA,4BAAA;EAAA,uBAAA;EACA,UAAA;EACA,aAAA;EACA,kBAAA;EACA,qBAAA;EACA,gCAAA;AAzER;;AA6EA,qDAAA;AACA;EACI;IACI,cAAA;EA1EN;EA4EM;IACI,eAAA;EA1EV;EA4EU;IACI,eAAA;EA1Ed;EA8EM;IACI,WAAA;IACA,YAAA;EA5EV;EA+EM;IACI,eAAA;EA7EV;EA+EU;IACI,iBAAA;EA7Ed;AACF;AAkFA,+BAAA;AACA;EAKY;IACI,WAAA;IACA,gBAAA;EApFd;EAuFU;IACI,YAAA;IACA,eAAA;EArFd;EAyFM;IACI,WAAA;EAvFV;EAyFU;IACI,WAAA;EAvFd;AACF;AA4FA,2BAAA;AACA;EAGQ;;;IAGI,gBAAA;EA5FV;AACF;AAgGA;0BAAA;AAEA;EACI,eAAA;EACA,SAAA;EACA,WAAA;EACA,cAAA;EACA,gBAAA;EACA,gBAAA;EACA,UAAA;EACA,2BAAA;EACA,yBAAA;EACA,kBAAA;EACA,0CAAA;AA9FJ;AAgGI;EACI,UAAA;EACA,wBAAA;AA9FR;AAiGI;EACI,aAAA;EACA,mBAAA;EACA,aAAA;EACA,SAAA;AA/FR;AAiGQ;EACI,eAAA;EACA,cAAA;AA/FZ;AAkGQ;EACI,OAAA;EACA,eAAA;EACA,gBAAA;EACA,cAAA;AAhGZ;AAmGQ;EACI,gBAAA;EACA,YAAA;EACA,eAAA;EACA,eAAA;EACA,UAAA;EACA,WAAA;EACA,YAAA;EACA,aAAA;EACA,mBAAA;EACA,uBAAA;EACA,kBAAA;EACA,sCAAA;EACA,cAAA;AAjGZ;AAmGY;EACI,oCAAA;AAjGhB;AAsGI;EACI,sBAAA;EACA,8BAAA;EACA,cAAA;AApGR;AAuGI;EACI,yBAAA;EACA,8BAAA;EACA,cAAA;AArGR;AAwGI;EACI,yBAAA;EACA,8BAAA;EACA,cAAA;AAtGR;AAyGI;EACI,yBAAA;EACA,8BAAA;EACA,cAAA;AAvGR;;AA2GA,2BAAA;AACA;EACI;IACI,SAAA;IACA,WAAA;IACA,UAAA;IACA,eAAA;IACA,eAAA;EAxGN;AACF","sourcesContent":["/**\r\n * AI Summary Styles for SWPTLS Tables\r\n */\r\n\r\n/* AI Summary Button */\r\n.swptls-ai-summary-controls {\r\n    display: flex;\r\n    justify-content: flex-start;\r\n}\r\n\r\n.swptls-ai-summary-btn {\r\n    display: inline-flex;\r\n    align-items: center;\r\n    gap: 8px;\r\n    padding: 8px 16px;\r\n    background: unset;\r\n    box-shadow: 0 2px 8px rgba(208, 208, 208, 0.3);\r\n    color: rgb(8, 8, 8);\r\n    border: none;\r\n    border-radius: 6px;\r\n    cursor: pointer;\r\n    font-size: 14px;\r\n    font-weight: 500;\r\n    text-decoration: none;\r\n    transition: all 0.3s ease;\r\n    position: relative;\r\n    // bottom: -58px;\r\n    // left: 175px;\r\n}\r\n\r\n.swptls-ai-summary-btn.above {\r\n    bottom: -5px;\r\n    left: 0px;\r\n}\r\n\r\n.swptls-ai-summary-btn.below {\r\n    bottom: 5px;\r\n    left: 0px;\r\n}\r\n\r\n.swptls-ai-summary-btn:hover {\r\n    background: unset;\r\n    color: rgb(8, 8, 8);\r\n    box-shadow: 0 2px 8px rgba(208, 208, 208, 0.3);\r\n    transform: translateY(-2px);\r\n}\r\n\r\n.swptls-ai-summary-btn:active {\r\n    transform: translateY(0);\r\n}\r\n\r\n.swptls-ai-summary-btn:disabled {\r\n    background: unset;\r\n    cursor: not-allowed;\r\n    transform: none;\r\n    box-shadow: none;\r\n}\r\n\r\n/* AI Icon Animation */\r\n.swptls-ai-summary-btn .ai-icon {\r\n    font-size: 16px;\r\n    fill: #3179ed;\r\n    animation: pulse 2s infinite;\r\n}\r\n\r\n/* Hint Icon */\r\n.swptls-ai-summary-btn .hint-icon {\r\n    font-size: 12px;\r\n    opacity: 0.8;\r\n    margin-left: 4px;\r\n    animation: hint-pulse 3s infinite;\r\n}\r\n\r\n@keyframes pulse {\r\n\r\n    0%,\r\n    100% {\r\n        transform: scale(1);\r\n    }\r\n\r\n    50% {\r\n        transform: scale(1.1);\r\n    }\r\n}\r\n\r\n@keyframes hint-pulse {\r\n\r\n    0%,\r\n    80%,\r\n    100% {\r\n        opacity: 0.8;\r\n        transform: scale(1);\r\n    }\r\n\r\n    90% {\r\n        opacity: 1;\r\n        transform: scale(1.2);\r\n    }\r\n}\r\n\r\n/* Loading State */\r\n.swptls-ai-summary-btn.generating {\r\n    color: #191919;\r\n    box-shadow: 0 2px 8px rgba(208, 208, 208, 0.3);\r\n    cursor: wait;\r\n}\r\n\r\n.swptls-ai-summary-btn.generating .ai-icon {\r\n    animation: bounce 1s infinite;\r\n}\r\n\r\n@keyframes bounce {\r\n\r\n    0%,\r\n    20%,\r\n    50%,\r\n    80%,\r\n    100% {\r\n        transform: translateY(0);\r\n    }\r\n\r\n    40% {\r\n        transform: translateY(-3px);\r\n    }\r\n\r\n    60% {\r\n        transform: translateY(-1px);\r\n    }\r\n}\r\n\r\n/* AI Summary Modal */\r\n.ai-summary-modal {\r\n    position: fixed;\r\n    top: 0;\r\n    left: 0;\r\n    width: 100%;\r\n    height: 100%;\r\n    z-index: 10000;\r\n    opacity: 0;\r\n    visibility: hidden;\r\n    transition: all 0.3s ease;\r\n}\r\n\r\n.ai-summary-modal.show {\r\n    opacity: 1;\r\n    visibility: visible;\r\n}\r\n\r\n.ai-summary-modal .modal-overlay {\r\n    position: absolute;\r\n    top: 0;\r\n    left: 0;\r\n    width: 100%;\r\n    height: 100%;\r\n    background: rgba(0, 0, 0, 0.7);\r\n    backdrop-filter: blur(4px);\r\n}\r\n\r\n.ai-summary-modal .modal-content {\r\n    position: absolute;\r\n    top: 50%;\r\n    left: 50%;\r\n    transform: translate(-50%, -50%) scale(0.9);\r\n    background: white;\r\n    border-radius: 12px;\r\n    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);\r\n    max-width: 800px;\r\n    width: 90%;\r\n    max-height: 80vh;\r\n    overflow: hidden;\r\n    transition: transform 0.3s ease;\r\n}\r\n\r\n.ai-summary-modal.show .modal-content {\r\n    transform: translate(-50%, -50%) scale(1);\r\n}\r\n\r\n/* Modal Header */\r\n.ai-summary-modal .modal-header {\r\n    display: flex;\r\n    justify-content: space-between;\r\n    align-items: center;\r\n    padding: 20px 24px;\r\n    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);\r\n    color: white;\r\n}\r\n\r\n.ai-summary-modal .modal-header h3 {\r\n    margin: 0;\r\n    font-size: 20px;\r\n    font-weight: 600;\r\n    color: #ffffff;\r\n}\r\n\r\n.ai-summary-modal .close-modal {\r\n    background: none;\r\n    border: none;\r\n    color: white;\r\n    font-size: 24px;\r\n    cursor: pointer;\r\n    padding: 0;\r\n    width: 32px;\r\n    height: 32px;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    border-radius: 50%;\r\n    transition: background-color 0.2s ease;\r\n}\r\n\r\n.ai-summary-modal .close-modal:hover {\r\n    background: rgba(255, 255, 255, 0.2);\r\n}\r\n\r\n/* Modal Body */\r\n.ai-summary-modal .modal-body {\r\n    padding: 24px;\r\n    max-height: 60vh;\r\n    overflow-y: auto;\r\n}\r\n\r\n.ai-summary-modal .summary-content {\r\n    font-size: 16px;\r\n    line-height: 1.6;\r\n    color: #374151;\r\n    margin-bottom: 24px;\r\n}\r\n\r\n.ai-summary-modal .summary-content p {\r\n    margin-bottom: 16px;\r\n}\r\n\r\n.ai-summary-modal .summary-content p:last-child {\r\n    margin-bottom: 0;\r\n}\r\n\r\n.ai-summary-modal .summary-content strong {\r\n    color: #1f2937;\r\n    font-weight: 600;\r\n}\r\n\r\n.ai-summary-modal .summary-content em {\r\n    color: #6b7280;\r\n    font-style: italic;\r\n}\r\n\r\n/* Modal Footer */\r\n.ai-summary-modal .modal-footer {\r\n    display: flex;\r\n    justify-content: space-between;\r\n    align-items: center;\r\n    padding: 20px 24px;\r\n    background: #f9fafb;\r\n    border-top: 1px solid #e5e7eb;\r\n}\r\n\r\n.ai-summary-modal .regenerate-summary-btn {\r\n    background: linear-gradient(135deg, #10b981 0%, #059669 100%);\r\n    color: white;\r\n    border: none;\r\n    padding: 10px 20px;\r\n    border-radius: 6px;\r\n    cursor: pointer;\r\n    font-size: 14px;\r\n    font-weight: 500;\r\n    transition: all 0.2s ease;\r\n}\r\n\r\n.ai-summary-modal .regenerate-summary-btn:hover {\r\n    background: linear-gradient(135deg, #059669 0%, #047857 100%);\r\n    transform: translateY(-1px);\r\n}\r\n\r\n.ai-summary-modal .modal-footer .secondary {\r\n    background: #6b7280;\r\n    color: white;\r\n    border: none;\r\n    padding: 10px 20px;\r\n    border-radius: 6px;\r\n    cursor: pointer;\r\n    font-size: 14px;\r\n    font-weight: 500;\r\n    transition: all 0.2s ease;\r\n}\r\n\r\n.ai-summary-modal .modal-footer .secondary:hover {\r\n    background: #4b5563;\r\n}\r\n\r\n/* AI Settings Styles */\r\n.ai-settings-container {\r\n    background: white;\r\n    border-radius: 8px;\r\n    padding: 24px;\r\n    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);\r\n}\r\n\r\n.ai-settings-header h3 {\r\n    margin: 0 0 8px 0;\r\n    color: #1f2937;\r\n    font-size: 24px;\r\n}\r\n\r\n.ai-settings-header p {\r\n    margin: 0 0 24px 0;\r\n    color: #6b7280;\r\n    font-size: 16px;\r\n}\r\n\r\n.ai-settings-form .edit-form-group {\r\n    margin-bottom: 20px;\r\n}\r\n\r\n.ai-settings-form label {\r\n    display: block;\r\n    margin-bottom: 8px;\r\n    font-weight: 600;\r\n    color: #374151;\r\n    font-size: 14px;\r\n}\r\n\r\n.ai-settings-form input[type=\"text\"],\r\n.ai-settings-form input[type=\"password\"],\r\n.ai-settings-form select,\r\n.ai-settings-form textarea {\r\n    width: 100%;\r\n    padding: 10px 12px;\r\n    border: 1px solid #d1d5db;\r\n    border-radius: 6px;\r\n    font-size: 14px;\r\n    transition: border-color 0.2s ease;\r\n}\r\n\r\n.ai-settings-form input[type=\"text\"]:focus,\r\n.ai-settings-form input[type=\"password\"]:focus,\r\n.ai-settings-form select:focus,\r\n.ai-settings-form textarea:focus {\r\n    outline: none;\r\n    border-color: #667eea;\r\n    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);\r\n}\r\n\r\n/* API Key Input Group */\r\n.api-key-input-group {\r\n    display: flex;\r\n    gap: 8px;\r\n    align-items: center;\r\n}\r\n\r\n.api-key-input {\r\n    flex: 1;\r\n}\r\n\r\n.toggle-api-key,\r\n.test-api-btn {\r\n    padding: 10px 12px;\r\n    border: 1px solid #d1d5db;\r\n    border-radius: 6px;\r\n    background: white;\r\n    cursor: pointer;\r\n    font-size: 14px;\r\n    transition: all 0.2s ease;\r\n}\r\n\r\n.toggle-api-key:hover,\r\n.test-api-btn:hover {\r\n    background: #f3f4f6;\r\n    border-color: #9ca3af;\r\n}\r\n\r\n.test-api-btn:disabled {\r\n    background: #f9fafb;\r\n    color: #9ca3af;\r\n    cursor: not-allowed;\r\n}\r\n\r\n/* Range Inputs */\r\n.ai-settings-form input[type=\"range\"] {\r\n    width: 100%;\r\n    margin: 8px 0;\r\n}\r\n\r\n.range-labels {\r\n    display: flex;\r\n    justify-content: space-between;\r\n    font-size: 12px;\r\n    color: #6b7280;\r\n}\r\n\r\n/* Test Result */\r\n.test-result {\r\n    padding: 12px 16px;\r\n    border-radius: 6px;\r\n    margin: 16px 0;\r\n    font-size: 14px;\r\n    font-weight: 500;\r\n}\r\n\r\n.test-result.success {\r\n    background: #d1fae5;\r\n    color: #065f46;\r\n    border: 1px solid #a7f3d0;\r\n}\r\n\r\n.test-result.error {\r\n    background: #fee2e2;\r\n    color: #991b1b;\r\n    border: 1px solid #fca5a5;\r\n}\r\n\r\n.test-result.info {\r\n    background: #dbeafe;\r\n    color: #1e40af;\r\n    border: 1px solid #93c5fd;\r\n}\r\n\r\n/* Save Button */\r\n.save-ai-settings {\r\n    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);\r\n    color: white;\r\n    border: none;\r\n    padding: 12px 24px;\r\n    border-radius: 6px;\r\n    cursor: pointer;\r\n    font-size: 16px;\r\n    font-weight: 600;\r\n    transition: all 0.2s ease;\r\n}\r\n\r\n.save-ai-settings:hover {\r\n    background: linear-gradient(135deg, #5a67d8 0%, #6b46c1 100%);\r\n    transform: translateY(-1px);\r\n}\r\n\r\n.save-ai-settings:disabled {\r\n    background: #9ca3af;\r\n    cursor: not-allowed;\r\n    transform: none;\r\n}\r\n\r\n/* Info Section */\r\n.ai-settings-info {\r\n    margin-top: 32px;\r\n    padding: 20px;\r\n    background: #f0f9ff;\r\n    border-radius: 8px;\r\n    border: 1px solid #bae6fd;\r\n}\r\n\r\n.ai-settings-info h4 {\r\n    margin: 0 0 16px 0;\r\n    color: #0c4a6e;\r\n    font-size: 18px;\r\n}\r\n\r\n.ai-settings-info ul {\r\n    margin: 0;\r\n    padding-left: 20px;\r\n}\r\n\r\n.ai-settings-info li {\r\n    margin-bottom: 8px;\r\n    color: #0f172a;\r\n    line-height: 1.5;\r\n}\r\n\r\n.ai-settings-info a {\r\n    color: #0ea5e9;\r\n    text-decoration: none;\r\n}\r\n\r\n.ai-settings-info a:hover {\r\n    text-decoration: underline;\r\n}\r\n\r\n/* Responsive Design */\r\n@media (max-width: 768px) {\r\n    .ai-summary-modal .modal-content {\r\n        width: 95%;\r\n        max-height: 90vh;\r\n    }\r\n\r\n    .ai-summary-modal .modal-header,\r\n    .ai-summary-modal .modal-body,\r\n    .ai-summary-modal .modal-footer {\r\n        padding: 16px;\r\n    }\r\n\r\n    .ai-summary-modal .metadata-grid {\r\n        grid-template-columns: 1fr;\r\n    }\r\n\r\n    .api-key-input-group {\r\n        flex-direction: column;\r\n    }\r\n\r\n    .api-key-input {\r\n        width: 100%;\r\n    }\r\n\r\n    .swptls-ai-summary-controls {\r\n        margin: 12px 0;\r\n    }\r\n\r\n    .swptls-ai-summary-btn {\r\n        width: 100%;\r\n        justify-content: center;\r\n    }\r\n}\r\n\r\n/* Dark Mode Support */\r\n@media (prefers-color-scheme: dark) {\r\n    .ai-summary-modal .modal-content {\r\n        background: #1f2937;\r\n        color: #f9fafb;\r\n    }\r\n\r\n    .ai-summary-modal .summary-content {\r\n        color: #d1d5db;\r\n    }\r\n\r\n    .ai-summary-modal .modal-footer {\r\n        background: #374151;\r\n        border-color: #4b5563;\r\n    }\r\n\r\n    .ai-settings-container {\r\n        background: #1f2937;\r\n        color: #f9fafb;\r\n    }\r\n\r\n    .ai-settings-form input,\r\n    .ai-settings-form select,\r\n    .ai-settings-form textarea {\r\n        background: #374151;\r\n        border-color: #4b5563;\r\n        color: #f9fafb;\r\n    }\r\n}\r\n\r\n// Regenerating Styles\r\n.regenerate-summary-btn.regenerating {\r\n    background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);\r\n    cursor: not-allowed;\r\n    transform: none;\r\n}\r\n\r\n.regenerating-message h3 {\r\n    margin: 0 0 12px 0;\r\n    color: #1f2937;\r\n    font-size: 20px;\r\n}\r\n\r\n.regenerating-message p {\r\n    margin: 0 0 20px 0;\r\n    color: #6b7280;\r\n    font-size: 16px;\r\n    line-height: 1.5;\r\n}\r\n\r\n.regenerating-dots {\r\n    display: flex;\r\n    justify-content: center;\r\n    gap: 4px;\r\n}\r\n\r\n.regenerating-dots span {\r\n    width: 8px;\r\n    height: 8px;\r\n    background: #667eea;\r\n    border-radius: 50%;\r\n    animation: bounce 1.4s ease-in-out infinite both;\r\n}\r\n\r\n.regenerating-dots span:nth-child(1) {\r\n    animation-delay: -0.32s;\r\n}\r\n\r\n.regenerating-dots span:nth-child(2) {\r\n    animation-delay: -0.16s;\r\n}\r\n\r\n@keyframes spin {\r\n    0% {\r\n        transform: rotate(0deg);\r\n    }\r\n\r\n    100% {\r\n        transform: rotate(360deg);\r\n    }\r\n}\r\n\r\n@keyframes bounce {\r\n\r\n    0%,\r\n    80%,\r\n    100% {\r\n        transform: scale(0);\r\n    }\r\n\r\n    40% {\r\n        transform: scale(1);\r\n    }\r\n}\r\n\r\n/* Backend AI Summary Display Styles */\r\n.swptls-backend-ai-summary {\r\n    border: 1px solid #e2e8f0;\r\n    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);\r\n    margin: 10px 15px 25px 10px;\r\n    background-color: #0f73f826;\r\n    color: #525252;\r\n    border-radius: 1.5rem;\r\n    flex-flow: column;\r\n    justify-content: flex-start;\r\n    align-items: flex-start;\r\n    padding: 1.5rem;\r\n    display: flex;\r\n}\r\n\r\n.swptls-backend-ai-summary .summary-header {\r\n    display: flex;\r\n    align-items: center;\r\n    padding-bottom: 10px;\r\n    gap: 5px;\r\n}\r\n\r\n.swptls-backend-ai-summary .summary-title {\r\n    margin: 0;\r\n    color: #1e293b;\r\n    font-size: 18px;\r\n    font-weight: 600;\r\n    display: flex;\r\n    align-items: center;\r\n    gap: 8px;\r\n}\r\n\r\n.swptls-backend-ai-summary .ai-icon {\r\n    font-size: 16px;\r\n    fill: #3179ed;\r\n    animation: pulse 2s infinite;\r\n    margin-top: 8px;\r\n}\r\n\r\n.swptls-backend-ai-summary .summary-content {\r\n    color: #334155;\r\n    font-size: 15px;\r\n    line-height: 1.7;\r\n}\r\n\r\n.swptls-backend-ai-summary .summary-content p {\r\n    margin: 0 0 12px 0;\r\n}\r\n\r\n.swptls-backend-ai-summary .summary-content p:last-child {\r\n    margin-bottom: 0;\r\n}\r\n\r\n.swptls-backend-ai-summary .summary-content strong {\r\n    color: #1e293b;\r\n    font-weight: 600;\r\n}\r\n\r\n.swptls-backend-ai-summary .summary-content em {\r\n    color: #64748b;\r\n    font-style: italic;\r\n}\r\n\r\n.swptls-backend-ai-summary .summary-content ol {\r\n    margin: 12px 0;\r\n    padding-left: 24px;\r\n    list-style-type: decimal;\r\n    list-style-position: outside;\r\n}\r\n\r\n.swptls-backend-ai-summary .summary-content ul {\r\n    margin: 12px 0;\r\n    padding-left: 24px;\r\n    list-style-type: disc;\r\n    list-style-position: outside;\r\n}\r\n\r\n.swptls-backend-ai-summary .summary-content ol li,\r\n.swptls-backend-ai-summary .summary-content ul li {\r\n    color: #475569;\r\n    line-height: 1.6;\r\n    display: list-item;\r\n    list-style-position: outside;\r\n}\r\n\r\n.swptls-backend-ai-summary .summary-content li strong {\r\n    color: #1e293b;\r\n}\r\n\r\n/* Responsive Design for Backend Summary */\r\n@media (max-width: 768px) {\r\n    .swptls-backend-ai-summary {\r\n        padding: 16px;\r\n        margin: 12px 0;\r\n    }\r\n\r\n    .swptls-backend-ai-summary .summary-title {\r\n        font-size: 16px;\r\n    }\r\n\r\n    .swptls-backend-ai-summary .summary-content {\r\n        font-size: 14px;\r\n    }\r\n}\r\n\r\n/* Backend AI Summary Collapsed Mode - Enhanced UX */\r\n.swptls-backend-ai-summary.collapsed {\r\n    // Remove the heavy background styling for collapsed mode\r\n    background: transparent;\r\n    border: none;\r\n    box-shadow: none;\r\n    padding: 0;\r\n    margin: 20px 0;\r\n\r\n    .summary-header {\r\n        &.clickable {\r\n            cursor: pointer;\r\n            user-select: none;\r\n            display: flex;\r\n            align-items: center;\r\n            justify-content: space-between;\r\n            transition: all 0.2s ease;\r\n            border-radius: 0;\r\n            padding: 12px 0;\r\n            margin: 0;\r\n            // border-bottom: 1px solid #e5e7eb;\r\n            background: transparent;\r\n\r\n            &:hover {\r\n                color: #374151;\r\n\r\n                .expand-icon {\r\n                    color: #6b7280;\r\n                    transform: scale(1.05);\r\n                }\r\n            }\r\n\r\n            &:focus {\r\n                outline: 2px solid #3b82f6;\r\n                outline-offset: 2px;\r\n                border-radius: 4px;\r\n            }\r\n        }\r\n\r\n        .summary-title {\r\n            font-size: 16px;\r\n            font-weight: 500;\r\n            color: #111827;\r\n            margin: 0;\r\n            display: flex;\r\n            align-items: center;\r\n            gap: 0;\r\n        }\r\n\r\n        .ai-icon {\r\n            display: none; // Hide the AI icon in collapsed mode for cleaner look\r\n        }\r\n\r\n        .expand-icon {\r\n            font-size: 14px;\r\n            transition: all 0.3s ease;\r\n            color: #6b7280;\r\n            font-weight: normal;\r\n            display: flex;\r\n            align-items: center;\r\n            margin-left: 8px;\r\n\r\n            // Handle actual SVG elements (from PRO version)\r\n            svg {\r\n                width: 16px;\r\n                height: 16px;\r\n                transition: transform 0.3s ease;\r\n                fill: currentColor;\r\n            }\r\n\r\n        }\r\n    }\r\n\r\n    .summary-content.collapsible {\r\n        max-height: 0;\r\n        overflow: hidden;\r\n        transition: all 0.3s ease;\r\n        padding: 0;\r\n        opacity: 0;\r\n\r\n        // Clean styling for content when expanded\r\n        font-size: 14px;\r\n        line-height: 1.6;\r\n        color: #374151;\r\n\r\n        p {\r\n            margin: 0 0 12px 0;\r\n            color: #374151;\r\n            line-height: 1.6;\r\n        }\r\n\r\n        p:last-child {\r\n            margin-bottom: 0;\r\n        }\r\n\r\n        ul,\r\n        ol {\r\n            margin: 0 0 12px 0;\r\n            padding-left: 20px;\r\n        }\r\n\r\n        li {\r\n            margin-bottom: 4px;\r\n            color: #374151;\r\n        }\r\n\r\n        strong {\r\n            font-weight: 600;\r\n            color: #111827;\r\n        }\r\n\r\n        em {\r\n            font-style: italic;\r\n            color: #4b5563;\r\n        }\r\n    }\r\n\r\n    &.expanded {\r\n        .summary-header {\r\n            .expand-icon {\r\n                svg {\r\n                    transform: rotate(90deg);\r\n                }\r\n            }\r\n        }\r\n\r\n        .summary-content.collapsible {\r\n            max-height: 1000px;\r\n            padding-top: 16px;\r\n            opacity: 1;\r\n        }\r\n    }\r\n}\r\n\r\n/* Animation for smooth expand/collapse */\r\n@keyframes expandContent {\r\n    from {\r\n        max-height: 0;\r\n        opacity: 0;\r\n    }\r\n\r\n    to {\r\n        max-height: 1000px;\r\n        opacity: 1;\r\n    }\r\n}\r\n\r\n@keyframes collapseContent {\r\n    from {\r\n        max-height: 1000px;\r\n        opacity: 1;\r\n    }\r\n\r\n    to {\r\n        max-height: 0;\r\n        opacity: 0;\r\n    }\r\n}\r\n\r\n/* Enhanced accessibility and interaction states */\r\n.swptls-backend-ai-summary.collapsed {\r\n    .summary-header.clickable {\r\n        &:focus-visible {\r\n            outline: 2px solid #3b82f6;\r\n            outline-offset: 2px;\r\n            border-radius: 4px;\r\n        }\r\n\r\n        // Smooth transition for all interactive states\r\n        * {\r\n            transition: all 0.2s ease;\r\n        }\r\n    }\r\n}\r\n\r\n/* Smooth animations for expand/collapse */\r\n.swptls-backend-ai-summary.collapsed {\r\n    .summary-content.collapsible {\r\n        max-height: 0;\r\n        overflow: hidden;\r\n        transition: max-height 0.3s ease, padding-top 0.3s ease, opacity 0.3s ease;\r\n        opacity: 0;\r\n    }\r\n\r\n    &.expanded .summary-content.collapsible {\r\n        max-height: max-content;\r\n        opacity: 1;\r\n        height: 400px;\r\n        overflow-y: scroll;\r\n        scrollbar-width: thin;\r\n        scrollbar-color: #d1d5db #ffffff;\r\n    }\r\n}\r\n\r\n/* Mobile responsive adjustments for collapsed mode */\r\n@media (max-width: 768px) {\r\n    .swptls-backend-ai-summary.collapsed {\r\n        margin: 16px 0;\r\n\r\n        .summary-header.clickable {\r\n            padding: 16px 0;\r\n\r\n            .summary-title {\r\n                font-size: 15px;\r\n            }\r\n        }\r\n\r\n        .expand-icon::before {\r\n            width: 18px;\r\n            height: 18px;\r\n        }\r\n\r\n        .summary-content.collapsible {\r\n            font-size: 13px;\r\n\r\n            &.expanded {\r\n                padding-top: 12px;\r\n            }\r\n        }\r\n    }\r\n}\r\n\r\n/* High contrast mode support */\r\n@media (prefers-contrast: high) {\r\n    .swptls-backend-ai-summary.collapsed {\r\n        .summary-header.clickable {\r\n            // border-bottom: 2px solid #000;\r\n\r\n            .summary-title {\r\n                color: #000;\r\n                font-weight: 600;\r\n            }\r\n\r\n            .expand-icon svg {\r\n                stroke: #000;\r\n                stroke-width: 3;\r\n            }\r\n        }\r\n\r\n        .summary-content.collapsible {\r\n            color: #000;\r\n\r\n            strong {\r\n                color: #000;\r\n            }\r\n        }\r\n    }\r\n}\r\n\r\n/* Reduced motion support */\r\n@media (prefers-reduced-motion: reduce) {\r\n    .swptls-backend-ai-summary.collapsed {\r\n\r\n        .summary-header.clickable,\r\n        .summary-content.collapsible,\r\n        .expand-icon::before {\r\n            transition: none;\r\n        }\r\n    }\r\n}\r\n\r\n/* AI Sum\r\nmary Notification Styles */\r\n.swptls-notification {\r\n    position: fixed;\r\n    top: 20px;\r\n    right: 20px;\r\n    z-index: 10000;\r\n    max-width: 400px;\r\n    min-width: 300px;\r\n    opacity: 0;\r\n    transform: translateX(100%);\r\n    transition: all 0.3s ease;\r\n    border-radius: 8px;\r\n    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);\r\n\r\n    &.show {\r\n        opacity: 1;\r\n        transform: translateX(0);\r\n    }\r\n\r\n    .swptls-notification-content {\r\n        display: flex;\r\n        align-items: center;\r\n        padding: 16px;\r\n        gap: 12px;\r\n\r\n        .swptls-notification-icon {\r\n            font-size: 18px;\r\n            flex-shrink: 0;\r\n        }\r\n\r\n        .swptls-notification-message {\r\n            flex: 1;\r\n            font-size: 14px;\r\n            line-height: 1.4;\r\n            color: inherit;\r\n        }\r\n\r\n        .swptls-notification-close {\r\n            background: none;\r\n            border: none;\r\n            font-size: 18px;\r\n            cursor: pointer;\r\n            padding: 0;\r\n            width: 24px;\r\n            height: 24px;\r\n            display: flex;\r\n            align-items: center;\r\n            justify-content: center;\r\n            border-radius: 50%;\r\n            transition: background-color 0.2s ease;\r\n            color: inherit;\r\n\r\n            &:hover {\r\n                background-color: rgba(0, 0, 0, 0.1);\r\n            }\r\n        }\r\n    }\r\n\r\n    &.swptls-notification-error {\r\n        background-color: #fee;\r\n        border-left: 4px solid #dc3545;\r\n        color: #721c24;\r\n    }\r\n\r\n    &.swptls-notification-warning {\r\n        background-color: #fff3cd;\r\n        border-left: 4px solid #ffc107;\r\n        color: #856404;\r\n    }\r\n\r\n    &.swptls-notification-success {\r\n        background-color: #d4edda;\r\n        border-left: 4px solid #28a745;\r\n        color: #155724;\r\n    }\r\n\r\n    &.swptls-notification-info {\r\n        background-color: #d1ecf1;\r\n        border-left: 4px solid #17a2b8;\r\n        color: #0c5460;\r\n    }\r\n}\r\n\r\n/* Responsive adjustments */\r\n@media (max-width: 768px) {\r\n    .swptls-notification {\r\n        top: 10px;\r\n        right: 10px;\r\n        left: 10px;\r\n        max-width: none;\r\n        min-width: auto;\r\n    }\r\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[1].use[3]!./assets/src/Styles/Frontend/frontend.scss":
/*!*************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[1].use[3]!./assets/src/Styles/Frontend/frontend.scss ***!
  \*************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ "./node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, "@charset \"UTF-8\";\n/* End of mixin */\n.create_tab_content {\n  /* .tab_page_name {\n      text-transform: capitalize;\n  } */\n}\n.create_tab_content .tabs {\n  position: relative;\n  list-style: none;\n  padding-left: 0;\n  display: flex;\n  flex-wrap: wrap;\n}\n.create_tab_content .tabs input[type=radio] {\n  position: absolute;\n  top: 0;\n  left: -9999px;\n}\n.create_tab_content .tabs label {\n  display: block;\n  padding: 8px 21px;\n  border-radius: 5px 5px 0 0;\n  border-bottom: 2px solid #2ecc40;\n  font-size: 1.2rem;\n  font-weight: bold;\n  background: #fff;\n  cursor: pointer;\n  position: relative;\n  top: 4px;\n  transition: all 0.2s ease-in-out;\n}\n.create_tab_content .tabs label:hover {\n  background: #e7ebd9;\n}\n.create_tab_content .tabs [id^=tab]:checked + label {\n  top: 4px;\n  padding-top: 7px;\n  background: #2ecc40;\n  color: #fff;\n}\n.create_tab_content .tab-content {\n  visibility: hidden;\n  opacity: 0;\n  width: 100%;\n  transition: all 0.1s ease-in;\n  height: 0;\n}\n.create_tab_content .tab-content .gswpts_tables_container {\n  margin: 0;\n  padding: 0;\n}\n.create_tab_content .tab-content.active {\n  visibility: visible;\n  opacity: 1;\n  height: auto;\n}\n.create_tab_content .unselectable {\n  -webkit-user-select: none;\n     -moz-user-select: none;\n      -ms-user-select: none;\n          user-select: none;\n}\n.create_tab_content .hidden_tab_name {\n  display: none;\n  width: 110px !important;\n  padding: 6px 4px !important;\n}\n.create_tab_content .tab_name_label.active {\n  padding: 8px 5px;\n  transition: none;\n}\n.create_tab_content .tab_name_label.active .tab_page_name {\n  display: none;\n}\n.create_tab_content .tab_name_label.active .hidden_tab_name {\n  display: block;\n}\n.create_tab_content .tab_name_label.active_transition {\n  transition: all 0.2s ease-in-out;\n}\n.create_tab_content .tab_name_label.deactivate_transition {\n  transition: none;\n}\n.create_tab_content .tab_name_box {\n  margin-bottom: 1rem;\n}\n.create_tab_content .tabs_container.reverse {\n  display: flex;\n  flex-direction: column-reverse;\n}\n.create_tab_content .tabs_container.reverse .tabs {\n  margin-bottom: 0;\n  margin-top: 1rem;\n}\n.create_tab_content .tabs_container.reverse .tabs li {\n  margin-bottom: 0;\n  margin-top: 6px;\n}\n.create_tab_content .tabs_container.reverse .tabs .tab_name_label {\n  margin-bottom: 0;\n  margin-top: 0.5rem;\n}\n@media screen and (max-width: 770px) {\n  .create_tab_content .tab_right_side {\n    margin-top: 1.5rem;\n    padding-left: 0 !important;\n  }\n}\n@media screen and (max-width: 680px) {\n  .create_tab_content .tabs {\n    grid-row-gap: 10px;\n  }\n  .create_tab_content .tabs li {\n    flex: 1 1 100px;\n  }\n  .create_tab_content .tab_right_side {\n    margin-top: 1.5rem;\n    padding-left: 0 !important;\n  }\n}\n\n.gswpts_tables_container {\n  /*******************************\n              States\n  *******************************/\n  /*--------------\n        Hover\n  ---------------*/\n  /*--------------\n        Focus\n  ---------------*/\n  /*--------------\n        Down\n  ---------------*/\n  /*--------------\n       Active\n  ---------------*/\n  /*--------------\n      Loading\n  ---------------*/\n  /* Specificity hack */\n  /*-------------------\n        Disabled\n  --------------------*/\n  /* Basic Group With Disabled */\n  /*******************************\n               Types\n  *******************************/\n  /*-------------------\n         Animated\n  --------------------*/\n  /* Horizontal */\n  /* Vertical */\n  /* Fade */\n  /*-------------------\n         Inverted\n  --------------------*/\n  /* Group */\n  /* States */\n  /* Hover */\n  /* Active / Focus */\n  /* Active Focus */\n  /*-------------------\n      Labeled Button\n  --------------------*/\n  /* Tag */\n  /* Right */\n  /* Left Side */\n  /*-------------------\n         Social\n  --------------------*/\n  /* Facebook */\n  /* Twitter */\n  /* Google Plus */\n  /* Linked In */\n  /* YouTube */\n  /* Instagram */\n  /* Pinterest */\n  /* VK */\n  /*--------------\n       Icon\n  ---------------*/\n  /*******************************\n             Variations\n  *******************************/\n  /*-------------------\n         Floated\n  --------------------*/\n  /*-------------------\n         Compact\n  --------------------*/\n  /*-------------------\n          Sizes\n  --------------------*/\n  /*--------------\n      Icon Only\n  ---------------*/\n  /*-------------------\n          Basic\n  --------------------*/\n  /* Vertical */\n  /* Standard Basic Inverted */\n  /* Basic Group */\n  /*--------------\n    Labeled Icon\n  ---------------*/\n  /* Left Labeled */\n  /* Left Labeled */\n  /* Right Labeled */\n  /* Fluid Labeled */\n  /*--------------\n       Toggle\n  ---------------*/\n  /* Toggle (Modifies active state to give affordances) */\n  /*--------------\n      Circular\n  ---------------*/\n  /*-------------------\n        Or Buttons\n  --------------------*/\n  /* Fluid Or */\n  /*-------------------\n         Attached\n  --------------------*/\n  /* Singular */\n  /* Top / Bottom */\n  /* Left / Right */\n  /* Plural */\n  /* Top / Bottom */\n  /* Left / Right */\n  /*-------------------\n          Fluid\n  --------------------*/\n  /* Fluid Vertical Buttons */\n  /*-------------------\n         Colors\n  --------------------*/\n  /*--- Black ---*/\n  /* Basic */\n  /* Inverted */\n  /* Inverted Basic */\n  /*--- Grey ---*/\n  /* Basic */\n  /* Inverted */\n  /* Inverted Basic */\n  /*--- Brown ---*/\n  /* Basic */\n  /* Inverted */\n  /* Inverted Basic */\n  /*--- Blue ---*/\n  /* Basic */\n  /* Inverted */\n  /* Inverted Basic */\n  /*--- Green ---*/\n  /* Basic */\n  /* Inverted */\n  /* Inverted Basic */\n  /*--- Orange ---*/\n  /* Basic */\n  /* Inverted */\n  /* Inverted Basic */\n  /*--- Pink ---*/\n  /* Basic */\n  /* Inverted */\n  /* Inverted Basic */\n  /*--- Violet ---*/\n  /* Basic */\n  /* Inverted */\n  /* Inverted Basic */\n  /*--- Purple ---*/\n  /* Basic */\n  /* Inverted */\n  /* Inverted Basic */\n  /*--- Red ---*/\n  /* Basic */\n  /* Inverted */\n  /* Inverted Basic */\n  /*--- Teal ---*/\n  /* Basic */\n  /* Inverted */\n  /* Inverted Basic */\n  /*--- Olive ---*/\n  /* Basic */\n  /* Inverted */\n  /* Inverted Basic */\n  /*--- Yellow ---*/\n  /* Basic */\n  /* Inverted */\n  /* Inverted Basic */\n  /*-------------------\n         Primary\n  --------------------*/\n  /*--- Standard ---*/\n  /* Basic */\n  /* Inverted */\n  /* Inverted Basic */\n  /*-------------------\n        Secondary\n  --------------------*/\n  /* Standard */\n  /* Basic */\n  /* Inverted */\n  /* Inverted Basic */\n  /*---------------\n      Positive\n  ----------------*/\n  /* Standard */\n  /* Basic */\n  /*---------------\n       Negative\n  ----------------*/\n  /* Standard */\n  /* Basic */\n  /*******************************\n              Groups\n  *******************************/\n  /* Clearfix */\n  /* Standard Group */\n  /* Vertical  Style */\n  /*--------------------\n        Placeholder\n  ---------------------*/\n  /* browsers require these rules separate */\n  /*******************************\n              States\n  *******************************/\n  /*--------------------\n          Disabled\n  ---------------------*/\n  /*--------------------\n          Active\n  ---------------------*/\n  /*--------------------\n         Loading\n  ---------------------*/\n  /*--------------------\n          Focus\n  ---------------------*/\n  /*--------------------\n          Error\n  ---------------------*/\n  /* Error Placeholder */\n  /* Focused Error Placeholder */\n  /*******************************\n             Variations\n  *******************************/\n  /*--------------------\n        Transparent\n  ---------------------*/\n  /* Transparent Icon */\n  /* Transparent Inverted */\n  /*--------------------\n           Icon\n  ---------------------*/\n  /* Left Icon Input */\n  /* Focus */\n  /*--------------------\n          Labeled\n  ---------------------*/\n  /* Adjacent Label */\n  /* Regular Label on Left */\n  /* Regular Label on Right */\n  /* Corner Label */\n  /* Spacing with corner label */\n  /* Left Labeled */\n  /* Corner Label Position  */\n  /*--------------------\n          Action\n  ---------------------*/\n  /* Button on Right */\n  /* Input Focus */\n  /* Button on Left */\n  /* Input Focus */\n  /*--------------------\n         Inverted\n  ---------------------*/\n  /* Standard */\n  /*--------------------\n          Fluid\n  ---------------------*/\n  /*--------------------\n          Size\n  ---------------------*/\n  /*\n  * Styling for DataTables with Semantic UI\n  */\n  /* Manual add : - Hide sorting and its icons for th and td elements */\n  /* Standard Size */\n  /* Static Shape */\n  /* Active Shape */\n  /* Active Animation */\n  /* Sizes */\n  /*-------------------\n        Coupling\n  --------------------*/\n  /* Show inside active dimmer */\n  /* Black Dimmer */\n  /* White Dimmer (Inverted) */\n  /*******************************\n               Types\n  *******************************/\n  /*-------------------\n          Text\n  --------------------*/\n  /*******************************\n              States\n  *******************************/\n  /*******************************\n              Variations\n  *******************************/\n  /*-------------------\n          Sizes\n  --------------------*/\n  /* Loader */\n  /* Text Loader */\n  /*-------------------\n         Inverted\n  --------------------*/\n  /*-------------------\n         Inline\n  --------------------*/\n  /* Centered Inline */\n  margin: 30px 0;\n  position: relative;\n  padding: 30px 0px !important;\n  /* .dt-buttons {\n      display: flex;\n      justify-content: flex-end;\n      margin-top: 5px;\n      gap: 10px;\n\n      button {\n          font-size: 13px !important;\n          margin: 0 6px;\n          margin-right: 5px;\n\n          &:hover img {\n              filter: brightness(0.1);\n          }\n      }\n\n      span {\n          display: flex;\n          justify-content: center;\n          align-items: center;\n          height: 21px;\n          white-space: nowrap;\n      }\n\n      .export_btns {\n          display: none;\n      }\n  } */\n}\n.gswpts_tables_container .ui.button {\n  cursor: pointer;\n  display: inline-block;\n  min-height: 1em;\n  outline: none;\n  border: none;\n  vertical-align: baseline;\n  background: #e0e1e2 none;\n  color: rgba(0, 0, 0, 0.6);\n  font-family: \"Lato\", \"Helvetica Neue\", Arial, Helvetica, sans-serif;\n  margin: 0em 0.25em 0em 0em;\n  padding: 3px 3px;\n  text-transform: none;\n  text-shadow: none;\n  font-weight: bold;\n  line-height: 1em;\n  font-style: normal;\n  text-align: center;\n  text-decoration: none;\n  border-radius: 0.28571429rem;\n  box-shadow: 0px 0px 0px 1px transparent inset, 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n  -webkit-user-select: none;\n  -moz-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n  transition: opacity 0.1s ease, background-color 0.1s ease, color 0.1s ease, box-shadow 0.1s ease, background 0.1s ease;\n  will-change: \"\";\n  -webkit-tap-highlight-color: transparent;\n}\n.gswpts_tables_container .ui.button:hover {\n  background-color: #cacbcd;\n  background-image: none;\n  box-shadow: 0px 0px 0px 1px transparent inset, 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n  color: rgba(0, 0, 0, 0.8);\n}\n.gswpts_tables_container .ui.button:hover .icon {\n  opacity: 0.85;\n}\n.gswpts_tables_container .ui.button:focus {\n  background-color: #cacbcd;\n  color: rgba(0, 0, 0, 0.8);\n  background-image: \"\" !important;\n  box-shadow: \"\" !important;\n}\n.gswpts_tables_container .ui.button:focus .icon {\n  opacity: 0.85;\n}\n.gswpts_tables_container .ui.button:active,\n.gswpts_tables_container .ui.active.button:active {\n  background-color: #babbbc;\n  background-image: \"\";\n  color: rgba(0, 0, 0, 0.9);\n  box-shadow: 0px 0px 0px 1px transparent inset, none;\n}\n.gswpts_tables_container .ui.active.button {\n  background-color: #c0c1c2;\n  background-image: none;\n  box-shadow: 0px 0px 0px 1px transparent inset;\n  color: rgba(0, 0, 0, 0.95);\n}\n.gswpts_tables_container .ui.active.button:hover {\n  background-color: #c0c1c2;\n  background-image: none;\n  color: rgba(0, 0, 0, 0.95);\n}\n.gswpts_tables_container .ui.active.button:active {\n  background-color: #c0c1c2;\n  background-image: none;\n}\n.gswpts_tables_container .ui.loading.loading.loading.loading.loading.loading.button {\n  position: relative;\n  cursor: default;\n  text-shadow: none !important;\n  color: transparent !important;\n  opacity: 1;\n  pointer-events: auto;\n  transition: all 0s linear, opacity 0.1s ease;\n}\n.gswpts_tables_container .ui.loading.button:before {\n  position: absolute;\n  content: \"\";\n  top: 50%;\n  left: 50%;\n  margin: -0.64285714em 0em 0em -0.64285714em;\n  width: 1.28571429em;\n  height: 1.28571429em;\n  border-radius: 500rem;\n  border: 0.2em solid rgba(0, 0, 0, 0.15);\n}\n.gswpts_tables_container .ui.loading.button:after {\n  position: absolute;\n  content: \"\";\n  top: 50%;\n  left: 50%;\n  margin: -0.64285714em 0em 0em -0.64285714em;\n  width: 1.28571429em;\n  height: 1.28571429em;\n  -webkit-animation: button-spin 0.6s linear;\n  animation: button-spin 0.6s linear;\n  -webkit-animation-iteration-count: infinite;\n  animation-iteration-count: infinite;\n  border-radius: 500rem;\n  border-color: #ffffff transparent transparent;\n  border-style: solid;\n  border-width: 0.2em;\n  box-shadow: 0px 0px 0px 1px transparent;\n}\n.gswpts_tables_container .ui.labeled.icon.loading.button .icon {\n  background-color: transparent;\n  box-shadow: none;\n}\n@-webkit-keyframes button-spin {\n  from {\n    transform: rotate(0deg);\n  }\n  to {\n    transform: rotate(360deg);\n  }\n}\n@keyframes button-spin {\n  from {\n    transform: rotate(0deg);\n  }\n  to {\n    transform: rotate(360deg);\n  }\n}\n.gswpts_tables_container .ui.basic.loading.button:not(.inverted):before {\n  border-color: rgba(0, 0, 0, 0.1);\n}\n.gswpts_tables_container .ui.basic.loading.button:not(.inverted):after {\n  border-top-color: #767676;\n}\n.gswpts_tables_container .ui.buttons .disabled.button,\n.gswpts_tables_container .ui.disabled.button,\n.gswpts_tables_container .ui.button:disabled,\n.gswpts_tables_container .ui.disabled.button:hover,\n.gswpts_tables_container .ui.disabled.active.button {\n  cursor: default;\n  opacity: 0.45 !important;\n  background-image: none !important;\n  box-shadow: none !important;\n  pointer-events: none !important;\n}\n.gswpts_tables_container .ui.basic.buttons .ui.disabled.button {\n  border-color: rgba(34, 36, 38, 0.5);\n}\n.gswpts_tables_container .ui.animated.button {\n  position: relative;\n  overflow: hidden;\n  padding-right: 0em !important;\n  vertical-align: middle;\n  z-index: 1;\n}\n.gswpts_tables_container .ui.animated.button .content {\n  will-change: transform, opacity;\n}\n.gswpts_tables_container .ui.animated.button .visible.content {\n  position: relative;\n  margin-right: 1.5em;\n}\n.gswpts_tables_container .ui.animated.button .hidden.content {\n  position: absolute;\n  width: 100%;\n}\n.gswpts_tables_container .ui.animated.button .visible.content,\n.gswpts_tables_container .ui.animated.button .hidden.content {\n  transition: right 0.3s ease 0s;\n}\n.gswpts_tables_container .ui.animated.button .visible.content {\n  left: auto;\n  right: 0%;\n}\n.gswpts_tables_container .ui.animated.button .hidden.content {\n  top: 50%;\n  left: auto;\n  right: -100%;\n  margin-top: -0.5em;\n}\n.gswpts_tables_container .ui.animated.button:focus .visible.content,\n.gswpts_tables_container .ui.animated.button:hover .visible.content {\n  left: auto;\n  right: 200%;\n}\n.gswpts_tables_container .ui.animated.button:focus .hidden.content,\n.gswpts_tables_container .ui.animated.button:hover .hidden.content {\n  left: auto;\n  right: 0%;\n}\n.gswpts_tables_container .ui.vertical.animated.button .visible.content,\n.gswpts_tables_container .ui.vertical.animated.button .hidden.content {\n  transition: top 0.3s ease, transform 0.3s ease;\n}\n.gswpts_tables_container .ui.vertical.animated.button .visible.content {\n  transform: translateY(0%);\n  right: auto;\n}\n.gswpts_tables_container .ui.vertical.animated.button .hidden.content {\n  top: -50%;\n  left: 0%;\n  right: auto;\n}\n.gswpts_tables_container .ui.vertical.animated.button:focus .visible.content,\n.gswpts_tables_container .ui.vertical.animated.button:hover .visible.content {\n  transform: translateY(200%);\n  right: auto;\n}\n.gswpts_tables_container .ui.vertical.animated.button:focus .hidden.content,\n.gswpts_tables_container .ui.vertical.animated.button:hover .hidden.content {\n  top: 50%;\n  right: auto;\n}\n.gswpts_tables_container .ui.fade.animated.button .visible.content,\n.gswpts_tables_container .ui.fade.animated.button .hidden.content {\n  transition: opacity 0.3s ease, transform 0.3s ease;\n}\n.gswpts_tables_container .ui.fade.animated.button .visible.content {\n  left: auto;\n  right: auto;\n  opacity: 1;\n  transform: scale(1);\n}\n.gswpts_tables_container .ui.fade.animated.button .hidden.content {\n  opacity: 0;\n  left: 0%;\n  right: auto;\n  transform: scale(1.5);\n}\n.gswpts_tables_container .ui.fade.animated.button:focus .visible.content,\n.gswpts_tables_container .ui.fade.animated.button:hover .visible.content {\n  left: auto;\n  right: auto;\n  opacity: 0;\n  transform: scale(0.75);\n}\n.gswpts_tables_container .ui.fade.animated.button:focus .hidden.content,\n.gswpts_tables_container .ui.fade.animated.button:hover .hidden.content {\n  left: 0%;\n  right: auto;\n  opacity: 1;\n  transform: scale(1);\n}\n.gswpts_tables_container .ui.inverted.button {\n  box-shadow: 0px 0px 0px 2px #ffffff inset !important;\n  background: transparent none;\n  color: #ffffff;\n  text-shadow: none !important;\n}\n.gswpts_tables_container .ui.inverted.buttons .button {\n  margin: 0px 0px 0px -2px;\n}\n.gswpts_tables_container .ui.inverted.buttons .button:first-child {\n  margin-left: 0em;\n}\n.gswpts_tables_container .ui.inverted.vertical.buttons .button {\n  margin: 0px 0px -2px 0px;\n}\n.gswpts_tables_container .ui.inverted.vertical.buttons .button:first-child {\n  margin-top: 0em;\n}\n.gswpts_tables_container .ui.inverted.button:hover {\n  background: #ffffff;\n  box-shadow: 0px 0px 0px 2px #ffffff inset !important;\n  color: rgba(0, 0, 0, 0.8);\n}\n.gswpts_tables_container .ui.inverted.button:focus,\n.gswpts_tables_container .ui.inverted.button.active {\n  background: #ffffff;\n  box-shadow: 0px 0px 0px 2px #ffffff inset !important;\n  color: rgba(0, 0, 0, 0.8);\n}\n.gswpts_tables_container .ui.inverted.button.active:focus {\n  background: #dcddde;\n  box-shadow: 0px 0px 0px 2px #dcddde inset !important;\n  color: rgba(0, 0, 0, 0.8);\n}\n.gswpts_tables_container .ui.labeled.button:not(.icon) {\n  display: inline-flex;\n  flex-direction: row;\n  background: none !important;\n  padding: 0px !important;\n  border: none !important;\n  box-shadow: none !important;\n}\n.gswpts_tables_container .ui.labeled.button > .button {\n  margin: 0px;\n}\n.gswpts_tables_container .ui.labeled.button > .label {\n  display: flex;\n  align-items: center;\n  margin: 0px 0px 0px -1px !important;\n  padding: \"\";\n  font-size: 1em;\n  border-color: rgba(34, 36, 38, 0.15);\n}\n.gswpts_tables_container .ui.labeled.button > .tag.label:before {\n  width: 1.85em;\n  height: 1.85em;\n}\n.gswpts_tables_container .ui.labeled.button:not([class*=\"left labeled\"]) > .button {\n  border-top-right-radius: 0px;\n  border-bottom-right-radius: 0px;\n}\n.gswpts_tables_container .ui.labeled.button:not([class*=\"left labeled\"]) > .label {\n  border-top-left-radius: 0px;\n  border-bottom-left-radius: 0px;\n}\n.gswpts_tables_container .ui[class*=\"left labeled\"].button > .button {\n  border-top-left-radius: 0px;\n  border-bottom-left-radius: 0px;\n}\n.gswpts_tables_container .ui[class*=\"left labeled\"].button > .label {\n  border-top-right-radius: 0px;\n  border-bottom-right-radius: 0px;\n}\n.gswpts_tables_container .ui.facebook.button {\n  background-color: #3b5998;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.facebook.button:hover {\n  background-color: #304d8a;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.facebook.button:active {\n  background-color: #2d4373;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.twitter.button {\n  background-color: #55acee;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.twitter.button:hover {\n  background-color: #35a2f4;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.twitter.button:active {\n  background-color: #2795e9;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.google.plus.button {\n  background-color: #dd4b39;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.google.plus.button:hover {\n  background-color: #e0321c;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.google.plus.button:active {\n  background-color: #c23321;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.linkedin.button {\n  background-color: #1f88be;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.linkedin.button:hover {\n  background-color: #147baf;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.linkedin.button:active {\n  background-color: #186992;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.youtube.button {\n  background-color: #ff0000;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.youtube.button:hover {\n  background-color: #e60000;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.youtube.button:active {\n  background-color: #cc0000;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.instagram.button {\n  background-color: #49769c;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.instagram.button:hover {\n  background-color: #3d698e;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.instagram.button:active {\n  background-color: #395c79;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.pinterest.button {\n  background-color: #bd081c;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.pinterest.button:hover {\n  background-color: #ac0013;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.pinterest.button:active {\n  background-color: #8c0615;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.vk.button {\n  background-color: #4d7198;\n  color: #ffffff;\n  background-image: none;\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.vk.button:hover {\n  background-color: #41648a;\n  color: #ffffff;\n}\n.gswpts_tables_container .ui.vk.button:active {\n  background-color: #3c5876;\n  color: #ffffff;\n}\n.gswpts_tables_container .ui.button > .icon:not(.button) {\n  height: 0.85714286em;\n  opacity: 0.8;\n  margin: 0em 0.42857143em 0em -0.21428571em;\n  transition: opacity 0.1s ease;\n  vertical-align: \"\";\n  color: \"\";\n}\n.gswpts_tables_container .ui.button:not(.icon) > .icon:not(.button):not(.dropdown) {\n  margin: 0em 0.42857143em 0em -0.21428571em;\n}\n.gswpts_tables_container .ui.button:not(.icon) > .right.icon:not(.button):not(.dropdown) {\n  margin: 0em -0.21428571em 0em 0.42857143em;\n}\n.gswpts_tables_container .ui[class*=\"left floated\"].buttons,\n.gswpts_tables_container .ui[class*=\"left floated\"].button {\n  float: left;\n  margin-left: 0em;\n  margin-right: 0.25em;\n}\n.gswpts_tables_container .ui[class*=\"right floated\"].buttons,\n.gswpts_tables_container .ui[class*=\"right floated\"].button {\n  float: right;\n  margin-right: 0em;\n  margin-left: 0.25em;\n}\n.gswpts_tables_container .ui.compact.buttons .button,\n.gswpts_tables_container .ui.compact.button {\n  padding: 0.58928571em 1.125em 0.58928571em;\n}\n.gswpts_tables_container .ui.compact.icon.buttons .button,\n.gswpts_tables_container .ui.compact.icon.button {\n  padding: 0.58928571em 0.58928571em 0.58928571em;\n}\n.gswpts_tables_container .ui.compact.labeled.icon.buttons .button,\n.gswpts_tables_container .ui.compact.labeled.icon.button {\n  padding: 0.58928571em 3.69642857em 0.58928571em;\n}\n.gswpts_tables_container .ui.mini.buttons .button,\n.gswpts_tables_container .ui.mini.buttons .or,\n.gswpts_tables_container .ui.mini.button {\n  font-size: 0.78571429rem;\n}\n.gswpts_tables_container .ui.tiny.buttons .button,\n.gswpts_tables_container .ui.tiny.buttons .or,\n.gswpts_tables_container .ui.tiny.button {\n  font-size: 0.85714286rem;\n}\n.gswpts_tables_container .ui.small.buttons .button,\n.gswpts_tables_container .ui.small.buttons .or,\n.gswpts_tables_container .ui.small.button {\n  font-size: 0.92857143rem;\n}\n.gswpts_tables_container .ui.buttons .button,\n.gswpts_tables_container .ui.buttons .or,\n.gswpts_tables_container .ui.button {\n  font-size: 1rem;\n}\n.gswpts_tables_container .ui.large.buttons .button,\n.gswpts_tables_container .ui.large.buttons .or,\n.gswpts_tables_container .ui.large.button {\n  font-size: 1.14285714rem;\n}\n.gswpts_tables_container .ui.big.buttons .button,\n.gswpts_tables_container .ui.big.buttons .or,\n.gswpts_tables_container .ui.big.button {\n  font-size: 1.28571429rem;\n}\n.gswpts_tables_container .ui.huge.buttons .button,\n.gswpts_tables_container .ui.huge.buttons .or,\n.gswpts_tables_container .ui.huge.button {\n  font-size: 1.42857143rem;\n}\n.gswpts_tables_container .ui.massive.buttons .button,\n.gswpts_tables_container .ui.massive.buttons .or,\n.gswpts_tables_container .ui.massive.button {\n  font-size: 1.71428571rem;\n}\n.gswpts_tables_container .ui.icon.buttons .button,\n.gswpts_tables_container .ui.icon.button {\n  padding: 0.78571429em 0.78571429em 0.78571429em;\n}\n.gswpts_tables_container .ui.icon.buttons .button > .icon,\n.gswpts_tables_container .ui.icon.button > .icon {\n  opacity: 0.9;\n  margin: 0em !important;\n  vertical-align: top;\n}\n.gswpts_tables_container .ui.basic.buttons .button,\n.gswpts_tables_container .ui.basic.button {\n  background: transparent none !important;\n  color: rgba(0, 0, 0, 0.6) !important;\n  font-weight: normal;\n  border-radius: 0.28571429rem;\n  text-transform: none;\n  text-shadow: none !important;\n  box-shadow: 0px 0px 0px 1px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.basic.buttons {\n  box-shadow: none;\n  border: 1px solid rgba(34, 36, 38, 0.15);\n  border-radius: 0.28571429rem;\n}\n.gswpts_tables_container .ui.basic.buttons .button {\n  border-radius: 0em;\n}\n.gswpts_tables_container .ui.basic.buttons .button:hover,\n.gswpts_tables_container .ui.basic.button:hover {\n  background: #ffffff !important;\n  color: rgba(0, 0, 0, 0.8) !important;\n  box-shadow: 0px 0px 0px 1px rgba(34, 36, 38, 0.35) inset, 0px 0px 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.basic.buttons .button:focus,\n.gswpts_tables_container .ui.basic.button:focus {\n  background: #ffffff !important;\n  color: rgba(0, 0, 0, 0.8) !important;\n  box-shadow: 0px 0px 0px 1px rgba(34, 36, 38, 0.35) inset, 0px 0px 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.basic.buttons .button:active,\n.gswpts_tables_container .ui.basic.button:active {\n  background: #f8f8f8 !important;\n  color: rgba(0, 0, 0, 0.9) !important;\n  box-shadow: 0px 0px 0px 1px rgba(0, 0, 0, 0.15) inset, 0px 1px 4px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.basic.buttons .active.button,\n.gswpts_tables_container .ui.basic.active.button {\n  background: rgba(0, 0, 0, 0.05) !important;\n  box-shadow: \"\" !important;\n  color: rgba(0, 0, 0, 0.95) !important;\n}\n.gswpts_tables_container .ui.basic.buttons .active.button:hover,\n.gswpts_tables_container .ui.basic.active.button:hover {\n  background-color: rgba(0, 0, 0, 0.05);\n}\n.gswpts_tables_container .ui.basic.buttons .button:hover {\n  box-shadow: 0px 0px 0px 1px rgba(34, 36, 38, 0.35) inset, 0px 0px 0px 0px rgba(34, 36, 38, 0.15) inset inset;\n}\n.gswpts_tables_container .ui.basic.buttons .button:active {\n  box-shadow: 0px 0px 0px 1px rgba(0, 0, 0, 0.15) inset, 0px 1px 4px 0px rgba(34, 36, 38, 0.15) inset inset;\n}\n.gswpts_tables_container .ui.basic.buttons .active.button {\n  box-shadow: \"\" !important;\n}\n.gswpts_tables_container .ui.basic.inverted.buttons .button,\n.gswpts_tables_container .ui.basic.inverted.button {\n  background-color: transparent !important;\n  color: #f9fafb !important;\n  box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\n}\n.gswpts_tables_container .ui.basic.inverted.buttons .button:hover,\n.gswpts_tables_container .ui.basic.inverted.button:hover {\n  color: #ffffff !important;\n  box-shadow: 0px 0px 0px 2px #ffffff inset !important;\n}\n.gswpts_tables_container .ui.basic.inverted.buttons .button:focus,\n.gswpts_tables_container .ui.basic.inverted.button:focus {\n  color: #ffffff !important;\n  box-shadow: 0px 0px 0px 2px #ffffff inset !important;\n}\n.gswpts_tables_container .ui.basic.inverted.buttons .button:active,\n.gswpts_tables_container .ui.basic.inverted.button:active {\n  background-color: rgba(255, 255, 255, 0.08) !important;\n  color: #ffffff !important;\n  box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.9) inset !important;\n}\n.gswpts_tables_container .ui.basic.inverted.buttons .active.button,\n.gswpts_tables_container .ui.basic.inverted.active.button {\n  background-color: rgba(255, 255, 255, 0.08);\n  color: #ffffff;\n  text-shadow: none;\n  box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.7) inset;\n}\n.gswpts_tables_container .ui.basic.inverted.buttons .active.button:hover,\n.gswpts_tables_container .ui.basic.inverted.active.button:hover {\n  background-color: rgba(255, 255, 255, 0.15);\n  box-shadow: 0px 0px 0px 2px #ffffff inset !important;\n}\n.gswpts_tables_container .ui.basic.buttons .button {\n  border-left: 1px solid rgba(34, 36, 38, 0.15);\n  box-shadow: none;\n}\n.gswpts_tables_container .ui.basic.vertical.buttons .button {\n  border-left: none;\n}\n.gswpts_tables_container .ui.basic.vertical.buttons .button {\n  border-left-width: 0px;\n  border-top: 1px solid rgba(34, 36, 38, 0.15);\n}\n.gswpts_tables_container .ui.basic.vertical.buttons .button:first-child {\n  border-top-width: 0px;\n}\n.gswpts_tables_container .ui.labeled.icon.buttons .button,\n.gswpts_tables_container .ui.labeled.icon.button {\n  position: relative;\n  padding-left: 4.07142857em !important;\n  padding-right: 1.5em !important;\n}\n.gswpts_tables_container .ui.labeled.icon.buttons > .button > .icon,\n.gswpts_tables_container .ui.labeled.icon.button > .icon {\n  position: absolute;\n  height: 100%;\n  line-height: 1;\n  border-radius: 0px;\n  border-top-left-radius: inherit;\n  border-bottom-left-radius: inherit;\n  text-align: center;\n  margin: 0em;\n  width: 2.57142857em;\n  background-color: rgba(0, 0, 0, 0.05);\n  color: \"\";\n  box-shadow: -1px 0px 0px 0px transparent inset;\n}\n.gswpts_tables_container .ui.labeled.icon.buttons > .button > .icon,\n.gswpts_tables_container .ui.labeled.icon.button > .icon {\n  top: 0em;\n  left: 0em;\n}\n.gswpts_tables_container .ui[class*=\"right labeled\"].icon.button {\n  padding-right: 4.07142857em !important;\n  padding-left: 1.5em !important;\n}\n.gswpts_tables_container .ui[class*=\"right labeled\"].icon.button > .icon {\n  left: auto;\n  right: 0em;\n  border-radius: 0px;\n  border-top-right-radius: inherit;\n  border-bottom-right-radius: inherit;\n  box-shadow: 1px 0px 0px 0px transparent inset;\n}\n.gswpts_tables_container .ui.labeled.icon.buttons > .button > .icon:before,\n.gswpts_tables_container .ui.labeled.icon.button > .icon:before,\n.gswpts_tables_container .ui.labeled.icon.buttons > .button > .icon:after,\n.gswpts_tables_container .ui.labeled.icon.button > .icon:after {\n  display: block;\n  position: absolute;\n  width: 100%;\n  top: 50%;\n  text-align: center;\n  transform: translateY(-50%);\n}\n.gswpts_tables_container .ui.labeled.icon.buttons .button > .icon {\n  border-radius: 0em;\n}\n.gswpts_tables_container .ui.labeled.icon.buttons .button:first-child > .icon {\n  border-top-left-radius: 0.28571429rem;\n  border-bottom-left-radius: 0.28571429rem;\n}\n.gswpts_tables_container .ui.labeled.icon.buttons .button:last-child > .icon {\n  border-top-right-radius: 0.28571429rem;\n  border-bottom-right-radius: 0.28571429rem;\n}\n.gswpts_tables_container .ui.vertical.labeled.icon.buttons .button:first-child > .icon {\n  border-radius: 0em;\n  border-top-left-radius: 0.28571429rem;\n}\n.gswpts_tables_container .ui.vertical.labeled.icon.buttons .button:last-child > .icon {\n  border-radius: 0em;\n  border-bottom-left-radius: 0.28571429rem;\n}\n.gswpts_tables_container .ui.fluid[class*=\"left labeled\"].icon.button,\n.gswpts_tables_container .ui.fluid[class*=\"right labeled\"].icon.button {\n  padding-left: 1.5em !important;\n  padding-right: 1.5em !important;\n}\n.gswpts_tables_container .ui.toggle.buttons .active.button,\n.gswpts_tables_container .ui.buttons .button.toggle.active,\n.gswpts_tables_container .ui.button.toggle.active {\n  background-color: #21ba45 !important;\n  box-shadow: none !important;\n  text-shadow: none;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.button.toggle.active:hover {\n  background-color: #16ab39 !important;\n  text-shadow: none;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.circular.button {\n  border-radius: 10em;\n}\n.gswpts_tables_container .ui.circular.button > .icon {\n  width: 1em;\n  vertical-align: baseline;\n}\n.gswpts_tables_container .ui.buttons .or {\n  position: relative;\n  width: 0.3em;\n  height: 2.57142857em;\n  z-index: 3;\n}\n.gswpts_tables_container .ui.buttons .or:before {\n  position: absolute;\n  text-align: center;\n  border-radius: 500rem;\n  content: \"or\";\n  top: 50%;\n  left: 50%;\n  background-color: #ffffff;\n  text-shadow: none;\n  margin-top: -0.89285714em;\n  margin-left: -0.89285714em;\n  width: 1.78571429em;\n  height: 1.78571429em;\n  line-height: 1.78571429em;\n  color: rgba(0, 0, 0, 0.4);\n  font-style: normal;\n  font-weight: bold;\n  box-shadow: 0px 0px 0px 1px transparent inset;\n}\n.gswpts_tables_container .ui.buttons .or[data-text]:before {\n  content: attr(data-text);\n}\n.gswpts_tables_container .ui.fluid.buttons .or {\n  width: 0em !important;\n}\n.gswpts_tables_container .ui.fluid.buttons .or:after {\n  display: none;\n}\n.gswpts_tables_container .ui.attached.button {\n  position: relative;\n  display: block;\n  margin: 0em;\n  border-radius: 0em;\n  box-shadow: 0px 0px 0px 1px rgba(34, 36, 38, 0.15) !important;\n}\n.gswpts_tables_container .ui.attached.top.button {\n  border-radius: 0.28571429rem 0.28571429rem 0em 0em;\n}\n.gswpts_tables_container .ui.attached.bottom.button {\n  border-radius: 0em 0em 0.28571429rem 0.28571429rem;\n}\n.gswpts_tables_container .ui.left.attached.button {\n  display: inline-block;\n  border-left: none;\n  text-align: right;\n  padding-right: 0.75em;\n  border-radius: 0.28571429rem 0em 0em 0.28571429rem;\n}\n.gswpts_tables_container .ui.right.attached.button {\n  display: inline-block;\n  text-align: left;\n  padding-left: 0.75em;\n  border-radius: 0em 0.28571429rem 0.28571429rem 0em;\n}\n.gswpts_tables_container .ui.attached.buttons {\n  position: relative;\n  display: flex;\n  border-radius: 0em;\n  width: auto !important;\n  z-index: 2;\n  margin-left: -1px;\n  margin-right: -1px;\n}\n.gswpts_tables_container .ui.attached.buttons .button {\n  margin: 0em;\n}\n.gswpts_tables_container .ui.attached.buttons .button:first-child {\n  border-radius: 0em;\n}\n.gswpts_tables_container .ui.attached.buttons .button:last-child {\n  border-radius: 0em;\n}\n.gswpts_tables_container .ui[class*=\"top attached\"].buttons {\n  margin-bottom: -1px;\n  border-radius: 0.28571429rem 0.28571429rem 0em 0em;\n}\n.gswpts_tables_container .ui[class*=\"top attached\"].buttons .button:first-child {\n  border-radius: 0.28571429rem 0em 0em 0em;\n}\n.gswpts_tables_container .ui[class*=\"top attached\"].buttons .button:last-child {\n  border-radius: 0em 0.28571429rem 0em 0em;\n}\n.gswpts_tables_container .ui[class*=\"bottom attached\"].buttons {\n  margin-top: -1px;\n  border-radius: 0em 0em 0.28571429rem 0.28571429rem;\n}\n.gswpts_tables_container .ui[class*=\"bottom attached\"].buttons .button:first-child {\n  border-radius: 0em 0em 0em 0.28571429rem;\n}\n.gswpts_tables_container .ui[class*=\"bottom attached\"].buttons .button:last-child {\n  border-radius: 0em 0em 0.28571429rem 0em;\n}\n.gswpts_tables_container .ui[class*=\"left attached\"].buttons {\n  display: inline-flex;\n  margin-right: 0em;\n  margin-left: -1px;\n  border-radius: 0em 0.28571429rem 0.28571429rem 0em;\n}\n.gswpts_tables_container .ui[class*=\"left attached\"].buttons .button:first-child {\n  margin-left: -1px;\n  border-radius: 0em 0.28571429rem 0em 0em;\n}\n.gswpts_tables_container .ui[class*=\"left attached\"].buttons .button:last-child {\n  margin-left: -1px;\n  border-radius: 0em 0em 0.28571429rem 0em;\n}\n.gswpts_tables_container .ui[class*=\"right attached\"].buttons {\n  display: inline-flex;\n  margin-left: 0em;\n  margin-right: -1px;\n  border-radius: 0.28571429rem 0em 0em 0.28571429rem;\n}\n.gswpts_tables_container .ui[class*=\"right attached\"].buttons .button:first-child {\n  margin-left: -1px;\n  border-radius: 0.28571429rem 0em 0em 0em;\n}\n.gswpts_tables_container .ui[class*=\"right attached\"].buttons .button:last-child {\n  margin-left: -1px;\n  border-radius: 0em 0em 0em 0.28571429rem;\n}\n.gswpts_tables_container .ui.fluid.buttons,\n.gswpts_tables_container .ui.fluid.button {\n  width: 100%;\n}\n.gswpts_tables_container .ui.fluid.button {\n  display: block;\n}\n.gswpts_tables_container .ui.two.buttons {\n  width: 100%;\n}\n.gswpts_tables_container .ui.two.buttons > .button {\n  width: 50%;\n}\n.gswpts_tables_container .ui.three.buttons {\n  width: 100%;\n}\n.gswpts_tables_container .ui.three.buttons > .button {\n  width: 33.333%;\n}\n.gswpts_tables_container .ui.four.buttons {\n  width: 100%;\n}\n.gswpts_tables_container .ui.four.buttons > .button {\n  width: 25%;\n}\n.gswpts_tables_container .ui.five.buttons {\n  width: 100%;\n}\n.gswpts_tables_container .ui.five.buttons > .button {\n  width: 20%;\n}\n.gswpts_tables_container .ui.six.buttons {\n  width: 100%;\n}\n.gswpts_tables_container .ui.six.buttons > .button {\n  width: 16.666%;\n}\n.gswpts_tables_container .ui.seven.buttons {\n  width: 100%;\n}\n.gswpts_tables_container .ui.seven.buttons > .button {\n  width: 14.285%;\n}\n.gswpts_tables_container .ui.eight.buttons {\n  width: 100%;\n}\n.gswpts_tables_container .ui.eight.buttons > .button {\n  width: 12.5%;\n}\n.gswpts_tables_container .ui.nine.buttons {\n  width: 100%;\n}\n.gswpts_tables_container .ui.nine.buttons > .button {\n  width: 11.11%;\n}\n.gswpts_tables_container .ui.ten.buttons {\n  width: 100%;\n}\n.gswpts_tables_container .ui.ten.buttons > .button {\n  width: 10%;\n}\n.gswpts_tables_container .ui.eleven.buttons {\n  width: 100%;\n}\n.gswpts_tables_container .ui.eleven.buttons > .button {\n  width: 9.09%;\n}\n.gswpts_tables_container .ui.twelve.buttons {\n  width: 100%;\n}\n.gswpts_tables_container .ui.twelve.buttons > .button {\n  width: 8.3333%;\n}\n.gswpts_tables_container .ui.fluid.vertical.buttons,\n.gswpts_tables_container .ui.fluid.vertical.buttons > .button {\n  display: flex;\n  width: auto;\n}\n.gswpts_tables_container .ui.two.vertical.buttons > .button {\n  height: 50%;\n}\n.gswpts_tables_container .ui.three.vertical.buttons > .button {\n  height: 33.333%;\n}\n.gswpts_tables_container .ui.four.vertical.buttons > .button {\n  height: 25%;\n}\n.gswpts_tables_container .ui.five.vertical.buttons > .button {\n  height: 20%;\n}\n.gswpts_tables_container .ui.six.vertical.buttons > .button {\n  height: 16.666%;\n}\n.gswpts_tables_container .ui.seven.vertical.buttons > .button {\n  height: 14.285%;\n}\n.gswpts_tables_container .ui.eight.vertical.buttons > .button {\n  height: 12.5%;\n}\n.gswpts_tables_container .ui.nine.vertical.buttons > .button {\n  height: 11.11%;\n}\n.gswpts_tables_container .ui.ten.vertical.buttons > .button {\n  height: 10%;\n}\n.gswpts_tables_container .ui.eleven.vertical.buttons > .button {\n  height: 9.09%;\n}\n.gswpts_tables_container .ui.twelve.vertical.buttons > .button {\n  height: 8.3333%;\n}\n.gswpts_tables_container .ui.black.buttons .button,\n.gswpts_tables_container .ui.black.button {\n  background-color: #1b1c1d;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n}\n.gswpts_tables_container .ui.black.button {\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.black.buttons .button:hover,\n.gswpts_tables_container .ui.black.button:hover {\n  background-color: #27292a;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.black.buttons .button:focus,\n.gswpts_tables_container .ui.black.button:focus {\n  background-color: #2f3032;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.black.buttons .button:active,\n.gswpts_tables_container .ui.black.button:active {\n  background-color: #343637;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.black.buttons .active.button,\n.gswpts_tables_container .ui.black.buttons .active.button:active,\n.gswpts_tables_container .ui.black.active.button,\n.gswpts_tables_container .ui.black.button .active.button:active {\n  background-color: #0f0f10;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.basic.black.buttons .button,\n.gswpts_tables_container .ui.basic.black.button {\n  box-shadow: 0px 0px 0px 1px #1b1c1d inset !important;\n  color: #1b1c1d !important;\n}\n.gswpts_tables_container .ui.basic.black.buttons .button:hover,\n.gswpts_tables_container .ui.basic.black.button:hover {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #27292a inset !important;\n  color: #27292a !important;\n}\n.gswpts_tables_container .ui.basic.black.buttons .button:focus,\n.gswpts_tables_container .ui.basic.black.button:focus {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #2f3032 inset !important;\n  color: #27292a !important;\n}\n.gswpts_tables_container .ui.basic.black.buttons .active.button,\n.gswpts_tables_container .ui.basic.black.active.button {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #0f0f10 inset !important;\n  color: #343637 !important;\n}\n.gswpts_tables_container .ui.basic.black.buttons .button:active,\n.gswpts_tables_container .ui.basic.black.button:active {\n  box-shadow: 0px 0px 0px 1px #343637 inset !important;\n  color: #343637 !important;\n}\n.gswpts_tables_container .ui.buttons:not(.vertical) > .basic.black.button:not(:first-child) {\n  margin-left: -1px;\n}\n.gswpts_tables_container .ui.inverted.black.buttons .button,\n.gswpts_tables_container .ui.inverted.black.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px #d4d4d5 inset !important;\n  color: #ffffff;\n}\n.gswpts_tables_container .ui.inverted.black.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.black.button:hover,\n.gswpts_tables_container .ui.inverted.black.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.black.button:focus,\n.gswpts_tables_container .ui.inverted.black.buttons .button.active,\n.gswpts_tables_container .ui.inverted.black.button.active,\n.gswpts_tables_container .ui.inverted.black.buttons .button:active,\n.gswpts_tables_container .ui.inverted.black.button:active {\n  box-shadow: none !important;\n  color: #ffffff;\n}\n.gswpts_tables_container .ui.inverted.black.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.black.button:hover {\n  background-color: #000000;\n}\n.gswpts_tables_container .ui.inverted.black.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.black.button:focus {\n  background-color: #000000;\n}\n.gswpts_tables_container .ui.inverted.black.buttons .active.button,\n.gswpts_tables_container .ui.inverted.black.active.button {\n  background-color: #000000;\n}\n.gswpts_tables_container .ui.inverted.black.buttons .button:active,\n.gswpts_tables_container .ui.inverted.black.button:active {\n  background-color: #000000;\n}\n.gswpts_tables_container .ui.inverted.black.basic.buttons .button,\n.gswpts_tables_container .ui.inverted.black.buttons .basic.button,\n.gswpts_tables_container .ui.inverted.black.basic.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.inverted.black.basic.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.black.buttons .basic.button:hover,\n.gswpts_tables_container .ui.inverted.black.basic.button:hover {\n  box-shadow: 0px 0px 0px 2px #000000 inset !important;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.inverted.black.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.black.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.black.basic.button:focus {\n  box-shadow: 0px 0px 0px 2px #000000 inset !important;\n  color: #545454 !important;\n}\n.gswpts_tables_container .ui.inverted.black.basic.buttons .active.button,\n.gswpts_tables_container .ui.inverted.black.buttons .basic.active.button,\n.gswpts_tables_container .ui.inverted.black.basic.active.button {\n  box-shadow: 0px 0px 0px 2px #000000 inset !important;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.inverted.black.basic.buttons .button:active,\n.gswpts_tables_container .ui.inverted.black.buttons .basic.button:active,\n.gswpts_tables_container .ui.inverted.black.basic.button:active {\n  box-shadow: 0px 0px 0px 2px #000000 inset !important;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.grey.buttons .button,\n.gswpts_tables_container .ui.grey.button {\n  background-color: #767676;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n}\n.gswpts_tables_container .ui.grey.button {\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.grey.buttons .button:hover,\n.gswpts_tables_container .ui.grey.button:hover {\n  background-color: #838383;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.grey.buttons .button:focus,\n.gswpts_tables_container .ui.grey.button:focus {\n  background-color: #8a8a8a;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.grey.buttons .button:active,\n.gswpts_tables_container .ui.grey.button:active {\n  background-color: #909090;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.grey.buttons .active.button,\n.gswpts_tables_container .ui.grey.buttons .active.button:active,\n.gswpts_tables_container .ui.grey.active.button,\n.gswpts_tables_container .ui.grey.button .active.button:active {\n  background-color: #696969;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.basic.grey.buttons .button,\n.gswpts_tables_container .ui.basic.grey.button {\n  box-shadow: 0px 0px 0px 1px #767676 inset !important;\n  color: #767676 !important;\n}\n.gswpts_tables_container .ui.basic.grey.buttons .button:hover,\n.gswpts_tables_container .ui.basic.grey.button:hover {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #838383 inset !important;\n  color: #838383 !important;\n}\n.gswpts_tables_container .ui.basic.grey.buttons .button:focus,\n.gswpts_tables_container .ui.basic.grey.button:focus {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #8a8a8a inset !important;\n  color: #838383 !important;\n}\n.gswpts_tables_container .ui.basic.grey.buttons .active.button,\n.gswpts_tables_container .ui.basic.grey.active.button {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #696969 inset !important;\n  color: #909090 !important;\n}\n.gswpts_tables_container .ui.basic.grey.buttons .button:active,\n.gswpts_tables_container .ui.basic.grey.button:active {\n  box-shadow: 0px 0px 0px 1px #909090 inset !important;\n  color: #909090 !important;\n}\n.gswpts_tables_container .ui.buttons:not(.vertical) > .basic.grey.button:not(:first-child) {\n  margin-left: -1px;\n}\n.gswpts_tables_container .ui.inverted.grey.buttons .button,\n.gswpts_tables_container .ui.inverted.grey.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px #d4d4d5 inset !important;\n  color: #ffffff;\n}\n.gswpts_tables_container .ui.inverted.grey.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.grey.button:hover,\n.gswpts_tables_container .ui.inverted.grey.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.grey.button:focus,\n.gswpts_tables_container .ui.inverted.grey.buttons .button.active,\n.gswpts_tables_container .ui.inverted.grey.button.active,\n.gswpts_tables_container .ui.inverted.grey.buttons .button:active,\n.gswpts_tables_container .ui.inverted.grey.button:active {\n  box-shadow: none !important;\n  color: rgba(0, 0, 0, 0.6);\n}\n.gswpts_tables_container .ui.inverted.grey.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.grey.button:hover {\n  background-color: #cfd0d2;\n}\n.gswpts_tables_container .ui.inverted.grey.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.grey.button:focus {\n  background-color: #c7c9cb;\n}\n.gswpts_tables_container .ui.inverted.grey.buttons .active.button,\n.gswpts_tables_container .ui.inverted.grey.active.button {\n  background-color: #cfd0d2;\n}\n.gswpts_tables_container .ui.inverted.grey.buttons .button:active,\n.gswpts_tables_container .ui.inverted.grey.button:active {\n  background-color: #c2c4c5;\n}\n.gswpts_tables_container .ui.inverted.grey.basic.buttons .button,\n.gswpts_tables_container .ui.inverted.grey.buttons .basic.button,\n.gswpts_tables_container .ui.inverted.grey.basic.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.inverted.grey.basic.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.grey.buttons .basic.button:hover,\n.gswpts_tables_container .ui.inverted.grey.basic.button:hover {\n  box-shadow: 0px 0px 0px 2px #cfd0d2 inset !important;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.inverted.grey.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.grey.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.grey.basic.button:focus {\n  box-shadow: 0px 0px 0px 2px #c7c9cb inset !important;\n  color: #dcddde !important;\n}\n.gswpts_tables_container .ui.inverted.grey.basic.buttons .active.button,\n.gswpts_tables_container .ui.inverted.grey.buttons .basic.active.button,\n.gswpts_tables_container .ui.inverted.grey.basic.active.button {\n  box-shadow: 0px 0px 0px 2px #cfd0d2 inset !important;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.inverted.grey.basic.buttons .button:active,\n.gswpts_tables_container .ui.inverted.grey.buttons .basic.button:active,\n.gswpts_tables_container .ui.inverted.grey.basic.button:active {\n  box-shadow: 0px 0px 0px 2px #c2c4c5 inset !important;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.brown.buttons .button,\n.gswpts_tables_container .ui.brown.button {\n  background-color: #a5673f;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n}\n.gswpts_tables_container .ui.brown.button {\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.brown.buttons .button:hover,\n.gswpts_tables_container .ui.brown.button:hover {\n  background-color: #975b33;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.brown.buttons .button:focus,\n.gswpts_tables_container .ui.brown.button:focus {\n  background-color: #90532b;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.brown.buttons .button:active,\n.gswpts_tables_container .ui.brown.button:active {\n  background-color: #805031;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.brown.buttons .active.button,\n.gswpts_tables_container .ui.brown.buttons .active.button:active,\n.gswpts_tables_container .ui.brown.active.button,\n.gswpts_tables_container .ui.brown.button .active.button:active {\n  background-color: #995a31;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.basic.brown.buttons .button,\n.gswpts_tables_container .ui.basic.brown.button {\n  box-shadow: 0px 0px 0px 1px #a5673f inset !important;\n  color: #a5673f !important;\n}\n.gswpts_tables_container .ui.basic.brown.buttons .button:hover,\n.gswpts_tables_container .ui.basic.brown.button:hover {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #975b33 inset !important;\n  color: #975b33 !important;\n}\n.gswpts_tables_container .ui.basic.brown.buttons .button:focus,\n.gswpts_tables_container .ui.basic.brown.button:focus {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #90532b inset !important;\n  color: #975b33 !important;\n}\n.gswpts_tables_container .ui.basic.brown.buttons .active.button,\n.gswpts_tables_container .ui.basic.brown.active.button {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #995a31 inset !important;\n  color: #805031 !important;\n}\n.gswpts_tables_container .ui.basic.brown.buttons .button:active,\n.gswpts_tables_container .ui.basic.brown.button:active {\n  box-shadow: 0px 0px 0px 1px #805031 inset !important;\n  color: #805031 !important;\n}\n.gswpts_tables_container .ui.buttons:not(.vertical) > .basic.brown.button:not(:first-child) {\n  margin-left: -1px;\n}\n.gswpts_tables_container .ui.inverted.brown.buttons .button,\n.gswpts_tables_container .ui.inverted.brown.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px #d67c1c inset !important;\n  color: #d67c1c;\n}\n.gswpts_tables_container .ui.inverted.brown.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.brown.button:hover,\n.gswpts_tables_container .ui.inverted.brown.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.brown.button:focus,\n.gswpts_tables_container .ui.inverted.brown.buttons .button.active,\n.gswpts_tables_container .ui.inverted.brown.button.active,\n.gswpts_tables_container .ui.inverted.brown.buttons .button:active,\n.gswpts_tables_container .ui.inverted.brown.button:active {\n  box-shadow: none !important;\n  color: #ffffff;\n}\n.gswpts_tables_container .ui.inverted.brown.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.brown.button:hover {\n  background-color: #c86f11;\n}\n.gswpts_tables_container .ui.inverted.brown.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.brown.button:focus {\n  background-color: #c16808;\n}\n.gswpts_tables_container .ui.inverted.brown.buttons .active.button,\n.gswpts_tables_container .ui.inverted.brown.active.button {\n  background-color: #cc6f0d;\n}\n.gswpts_tables_container .ui.inverted.brown.buttons .button:active,\n.gswpts_tables_container .ui.inverted.brown.button:active {\n  background-color: #a96216;\n}\n.gswpts_tables_container .ui.inverted.brown.basic.buttons .button,\n.gswpts_tables_container .ui.inverted.brown.buttons .basic.button,\n.gswpts_tables_container .ui.inverted.brown.basic.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.inverted.brown.basic.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.brown.buttons .basic.button:hover,\n.gswpts_tables_container .ui.inverted.brown.basic.button:hover {\n  box-shadow: 0px 0px 0px 2px #c86f11 inset !important;\n  color: #d67c1c !important;\n}\n.gswpts_tables_container .ui.inverted.brown.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.brown.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.brown.basic.button:focus {\n  box-shadow: 0px 0px 0px 2px #c16808 inset !important;\n  color: #d67c1c !important;\n}\n.gswpts_tables_container .ui.inverted.brown.basic.buttons .active.button,\n.gswpts_tables_container .ui.inverted.brown.buttons .basic.active.button,\n.gswpts_tables_container .ui.inverted.brown.basic.active.button {\n  box-shadow: 0px 0px 0px 2px #cc6f0d inset !important;\n  color: #d67c1c !important;\n}\n.gswpts_tables_container .ui.inverted.brown.basic.buttons .button:active,\n.gswpts_tables_container .ui.inverted.brown.buttons .basic.button:active,\n.gswpts_tables_container .ui.inverted.brown.basic.button:active {\n  box-shadow: 0px 0px 0px 2px #a96216 inset !important;\n  color: #d67c1c !important;\n}\n.gswpts_tables_container .ui.blue.buttons .button,\n.gswpts_tables_container .ui.blue.button {\n  background-color: #2185d0;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n}\n.gswpts_tables_container .ui.blue.button {\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.blue.buttons .button:hover,\n.gswpts_tables_container .ui.blue.button:hover {\n  background-color: #1678c2;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.blue.buttons .button:focus,\n.gswpts_tables_container .ui.blue.button:focus {\n  background-color: #0d71bb;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.blue.buttons .button:active,\n.gswpts_tables_container .ui.blue.button:active {\n  background-color: #1a69a4;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.blue.buttons .active.button,\n.gswpts_tables_container .ui.blue.buttons .active.button:active,\n.gswpts_tables_container .ui.blue.active.button,\n.gswpts_tables_container .ui.blue.button .active.button:active {\n  background-color: #1279c6;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.basic.blue.buttons .button,\n.gswpts_tables_container .ui.basic.blue.button {\n  box-shadow: 0px 0px 0px 1px #2185d0 inset !important;\n  color: #2185d0 !important;\n}\n.gswpts_tables_container .ui.basic.blue.buttons .button:hover,\n.gswpts_tables_container .ui.basic.blue.button:hover {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #1678c2 inset !important;\n  color: #1678c2 !important;\n}\n.gswpts_tables_container .ui.basic.blue.buttons .button:focus,\n.gswpts_tables_container .ui.basic.blue.button:focus {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #0d71bb inset !important;\n  color: #1678c2 !important;\n}\n.gswpts_tables_container .ui.basic.blue.buttons .active.button,\n.gswpts_tables_container .ui.basic.blue.active.button {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #1279c6 inset !important;\n  color: #1a69a4 !important;\n}\n.gswpts_tables_container .ui.basic.blue.buttons .button:active,\n.gswpts_tables_container .ui.basic.blue.button:active {\n  box-shadow: 0px 0px 0px 1px #1a69a4 inset !important;\n  color: #1a69a4 !important;\n}\n.gswpts_tables_container .ui.buttons:not(.vertical) > .basic.blue.button:not(:first-child) {\n  margin-left: -1px;\n}\n.gswpts_tables_container .ui.inverted.blue.buttons .button,\n.gswpts_tables_container .ui.inverted.blue.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px #54c8ff inset !important;\n  color: #54c8ff;\n}\n.gswpts_tables_container .ui.inverted.blue.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.blue.button:hover,\n.gswpts_tables_container .ui.inverted.blue.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.blue.button:focus,\n.gswpts_tables_container .ui.inverted.blue.buttons .button.active,\n.gswpts_tables_container .ui.inverted.blue.button.active,\n.gswpts_tables_container .ui.inverted.blue.buttons .button:active,\n.gswpts_tables_container .ui.inverted.blue.button:active {\n  box-shadow: none !important;\n  color: #ffffff;\n}\n.gswpts_tables_container .ui.inverted.blue.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.blue.button:hover {\n  background-color: #3ac0ff;\n}\n.gswpts_tables_container .ui.inverted.blue.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.blue.button:focus {\n  background-color: #2bbbff;\n}\n.gswpts_tables_container .ui.inverted.blue.buttons .active.button,\n.gswpts_tables_container .ui.inverted.blue.active.button {\n  background-color: #3ac0ff;\n}\n.gswpts_tables_container .ui.inverted.blue.buttons .button:active,\n.gswpts_tables_container .ui.inverted.blue.button:active {\n  background-color: #21b8ff;\n}\n.gswpts_tables_container .ui.inverted.blue.basic.buttons .button,\n.gswpts_tables_container .ui.inverted.blue.buttons .basic.button,\n.gswpts_tables_container .ui.inverted.blue.basic.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.inverted.blue.basic.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.blue.buttons .basic.button:hover,\n.gswpts_tables_container .ui.inverted.blue.basic.button:hover {\n  box-shadow: 0px 0px 0px 2px #3ac0ff inset !important;\n  color: #54c8ff !important;\n}\n.gswpts_tables_container .ui.inverted.blue.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.blue.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.blue.basic.button:focus {\n  box-shadow: 0px 0px 0px 2px #2bbbff inset !important;\n  color: #54c8ff !important;\n}\n.gswpts_tables_container .ui.inverted.blue.basic.buttons .active.button,\n.gswpts_tables_container .ui.inverted.blue.buttons .basic.active.button,\n.gswpts_tables_container .ui.inverted.blue.basic.active.button {\n  box-shadow: 0px 0px 0px 2px #3ac0ff inset !important;\n  color: #54c8ff !important;\n}\n.gswpts_tables_container .ui.inverted.blue.basic.buttons .button:active,\n.gswpts_tables_container .ui.inverted.blue.buttons .basic.button:active,\n.gswpts_tables_container .ui.inverted.blue.basic.button:active {\n  box-shadow: 0px 0px 0px 2px #21b8ff inset !important;\n  color: #54c8ff !important;\n}\n.gswpts_tables_container .ui.green.buttons .button,\n.gswpts_tables_container .ui.green.button {\n  background-color: #21ba45;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n}\n.gswpts_tables_container .ui.green.button {\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.green.buttons .button:hover,\n.gswpts_tables_container .ui.green.button:hover {\n  background-color: #16ab39;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.green.buttons .button:focus,\n.gswpts_tables_container .ui.green.button:focus {\n  background-color: #0ea432;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.green.buttons .button:active,\n.gswpts_tables_container .ui.green.button:active {\n  background-color: #198f35;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.green.buttons .active.button,\n.gswpts_tables_container .ui.green.buttons .active.button:active,\n.gswpts_tables_container .ui.green.active.button,\n.gswpts_tables_container .ui.green.button .active.button:active {\n  background-color: #13ae38;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.basic.green.buttons .button,\n.gswpts_tables_container .ui.basic.green.button {\n  box-shadow: 0px 0px 0px 1px #21ba45 inset !important;\n  color: #21ba45 !important;\n}\n.gswpts_tables_container .ui.basic.green.buttons .button:hover,\n.gswpts_tables_container .ui.basic.green.button:hover {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #16ab39 inset !important;\n  color: #16ab39 !important;\n}\n.gswpts_tables_container .ui.basic.green.buttons .button:focus,\n.gswpts_tables_container .ui.basic.green.button:focus {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #0ea432 inset !important;\n  color: #16ab39 !important;\n}\n.gswpts_tables_container .ui.basic.green.buttons .active.button,\n.gswpts_tables_container .ui.basic.green.active.button {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #13ae38 inset !important;\n  color: #198f35 !important;\n}\n.gswpts_tables_container .ui.basic.green.buttons .button:active,\n.gswpts_tables_container .ui.basic.green.button:active {\n  box-shadow: 0px 0px 0px 1px #198f35 inset !important;\n  color: #198f35 !important;\n}\n.gswpts_tables_container .ui.buttons:not(.vertical) > .basic.green.button:not(:first-child) {\n  margin-left: -1px;\n}\n.gswpts_tables_container .ui.inverted.green.buttons .button,\n.gswpts_tables_container .ui.inverted.green.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px #2ecc40 inset !important;\n  color: #2ecc40;\n}\n.gswpts_tables_container .ui.inverted.green.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.green.button:hover,\n.gswpts_tables_container .ui.inverted.green.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.green.button:focus,\n.gswpts_tables_container .ui.inverted.green.buttons .button.active,\n.gswpts_tables_container .ui.inverted.green.button.active,\n.gswpts_tables_container .ui.inverted.green.buttons .button:active,\n.gswpts_tables_container .ui.inverted.green.button:active {\n  box-shadow: none !important;\n  color: #ffffff;\n}\n.gswpts_tables_container .ui.inverted.green.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.green.button:hover {\n  background-color: #22be34;\n}\n.gswpts_tables_container .ui.inverted.green.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.green.button:focus {\n  background-color: #19b82b;\n}\n.gswpts_tables_container .ui.inverted.green.buttons .active.button,\n.gswpts_tables_container .ui.inverted.green.active.button {\n  background-color: #1fc231;\n}\n.gswpts_tables_container .ui.inverted.green.buttons .button:active,\n.gswpts_tables_container .ui.inverted.green.button:active {\n  background-color: #25a233;\n}\n.gswpts_tables_container .ui.inverted.green.basic.buttons .button,\n.gswpts_tables_container .ui.inverted.green.buttons .basic.button,\n.gswpts_tables_container .ui.inverted.green.basic.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.inverted.green.basic.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.green.buttons .basic.button:hover,\n.gswpts_tables_container .ui.inverted.green.basic.button:hover {\n  box-shadow: 0px 0px 0px 2px #22be34 inset !important;\n  color: #2ecc40 !important;\n}\n.gswpts_tables_container .ui.inverted.green.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.green.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.green.basic.button:focus {\n  box-shadow: 0px 0px 0px 2px #19b82b inset !important;\n  color: #2ecc40 !important;\n}\n.gswpts_tables_container .ui.inverted.green.basic.buttons .active.button,\n.gswpts_tables_container .ui.inverted.green.buttons .basic.active.button,\n.gswpts_tables_container .ui.inverted.green.basic.active.button {\n  box-shadow: 0px 0px 0px 2px #1fc231 inset !important;\n  color: #2ecc40 !important;\n}\n.gswpts_tables_container .ui.inverted.green.basic.buttons .button:active,\n.gswpts_tables_container .ui.inverted.green.buttons .basic.button:active,\n.gswpts_tables_container .ui.inverted.green.basic.button:active {\n  box-shadow: 0px 0px 0px 2px #25a233 inset !important;\n  color: #2ecc40 !important;\n}\n.gswpts_tables_container .ui.orange.buttons .button,\n.gswpts_tables_container .ui.orange.button {\n  background-color: #f2711c;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n}\n.gswpts_tables_container .ui.orange.button {\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.orange.buttons .button:hover,\n.gswpts_tables_container .ui.orange.button:hover {\n  background-color: #f26202;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.orange.buttons .button:focus,\n.gswpts_tables_container .ui.orange.button:focus {\n  background-color: #e55b00;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.orange.buttons .button:active,\n.gswpts_tables_container .ui.orange.button:active {\n  background-color: #cf590c;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.orange.buttons .active.button,\n.gswpts_tables_container .ui.orange.buttons .active.button:active,\n.gswpts_tables_container .ui.orange.active.button,\n.gswpts_tables_container .ui.orange.button .active.button:active {\n  background-color: #f56100;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.basic.orange.buttons .button,\n.gswpts_tables_container .ui.basic.orange.button {\n  box-shadow: 0px 0px 0px 1px #f2711c inset !important;\n  color: #f2711c !important;\n}\n.gswpts_tables_container .ui.basic.orange.buttons .button:hover,\n.gswpts_tables_container .ui.basic.orange.button:hover {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #f26202 inset !important;\n  color: #f26202 !important;\n}\n.gswpts_tables_container .ui.basic.orange.buttons .button:focus,\n.gswpts_tables_container .ui.basic.orange.button:focus {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #e55b00 inset !important;\n  color: #f26202 !important;\n}\n.gswpts_tables_container .ui.basic.orange.buttons .active.button,\n.gswpts_tables_container .ui.basic.orange.active.button {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #f56100 inset !important;\n  color: #cf590c !important;\n}\n.gswpts_tables_container .ui.basic.orange.buttons .button:active,\n.gswpts_tables_container .ui.basic.orange.button:active {\n  box-shadow: 0px 0px 0px 1px #cf590c inset !important;\n  color: #cf590c !important;\n}\n.gswpts_tables_container .ui.buttons:not(.vertical) > .basic.orange.button:not(:first-child) {\n  margin-left: -1px;\n}\n.gswpts_tables_container .ui.inverted.orange.buttons .button,\n.gswpts_tables_container .ui.inverted.orange.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px #ff851b inset !important;\n  color: #ff851b;\n}\n.gswpts_tables_container .ui.inverted.orange.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.orange.button:hover,\n.gswpts_tables_container .ui.inverted.orange.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.orange.button:focus,\n.gswpts_tables_container .ui.inverted.orange.buttons .button.active,\n.gswpts_tables_container .ui.inverted.orange.button.active,\n.gswpts_tables_container .ui.inverted.orange.buttons .button:active,\n.gswpts_tables_container .ui.inverted.orange.button:active {\n  box-shadow: none !important;\n  color: #ffffff;\n}\n.gswpts_tables_container .ui.inverted.orange.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.orange.button:hover {\n  background-color: #ff7701;\n}\n.gswpts_tables_container .ui.inverted.orange.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.orange.button:focus {\n  background-color: #f17000;\n}\n.gswpts_tables_container .ui.inverted.orange.buttons .active.button,\n.gswpts_tables_container .ui.inverted.orange.active.button {\n  background-color: #ff7701;\n}\n.gswpts_tables_container .ui.inverted.orange.buttons .button:active,\n.gswpts_tables_container .ui.inverted.orange.button:active {\n  background-color: #e76b00;\n}\n.gswpts_tables_container .ui.inverted.orange.basic.buttons .button,\n.gswpts_tables_container .ui.inverted.orange.buttons .basic.button,\n.gswpts_tables_container .ui.inverted.orange.basic.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.inverted.orange.basic.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.orange.buttons .basic.button:hover,\n.gswpts_tables_container .ui.inverted.orange.basic.button:hover {\n  box-shadow: 0px 0px 0px 2px #ff7701 inset !important;\n  color: #ff851b !important;\n}\n.gswpts_tables_container .ui.inverted.orange.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.orange.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.orange.basic.button:focus {\n  box-shadow: 0px 0px 0px 2px #f17000 inset !important;\n  color: #ff851b !important;\n}\n.gswpts_tables_container .ui.inverted.orange.basic.buttons .active.button,\n.gswpts_tables_container .ui.inverted.orange.buttons .basic.active.button,\n.gswpts_tables_container .ui.inverted.orange.basic.active.button {\n  box-shadow: 0px 0px 0px 2px #ff7701 inset !important;\n  color: #ff851b !important;\n}\n.gswpts_tables_container .ui.inverted.orange.basic.buttons .button:active,\n.gswpts_tables_container .ui.inverted.orange.buttons .basic.button:active,\n.gswpts_tables_container .ui.inverted.orange.basic.button:active {\n  box-shadow: 0px 0px 0px 2px #e76b00 inset !important;\n  color: #ff851b !important;\n}\n.gswpts_tables_container .ui.pink.buttons .button,\n.gswpts_tables_container .ui.pink.button {\n  background-color: #e03997;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n}\n.gswpts_tables_container .ui.pink.button {\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.pink.buttons .button:hover,\n.gswpts_tables_container .ui.pink.button:hover {\n  background-color: #e61a8d;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.pink.buttons .button:focus,\n.gswpts_tables_container .ui.pink.button:focus {\n  background-color: #e10f85;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.pink.buttons .button:active,\n.gswpts_tables_container .ui.pink.button:active {\n  background-color: #c71f7e;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.pink.buttons .active.button,\n.gswpts_tables_container .ui.pink.buttons .active.button:active,\n.gswpts_tables_container .ui.pink.active.button,\n.gswpts_tables_container .ui.pink.button .active.button:active {\n  background-color: #ea158d;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.basic.pink.buttons .button,\n.gswpts_tables_container .ui.basic.pink.button {\n  box-shadow: 0px 0px 0px 1px #e03997 inset !important;\n  color: #e03997 !important;\n}\n.gswpts_tables_container .ui.basic.pink.buttons .button:hover,\n.gswpts_tables_container .ui.basic.pink.button:hover {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #e61a8d inset !important;\n  color: #e61a8d !important;\n}\n.gswpts_tables_container .ui.basic.pink.buttons .button:focus,\n.gswpts_tables_container .ui.basic.pink.button:focus {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #e10f85 inset !important;\n  color: #e61a8d !important;\n}\n.gswpts_tables_container .ui.basic.pink.buttons .active.button,\n.gswpts_tables_container .ui.basic.pink.active.button {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #ea158d inset !important;\n  color: #c71f7e !important;\n}\n.gswpts_tables_container .ui.basic.pink.buttons .button:active,\n.gswpts_tables_container .ui.basic.pink.button:active {\n  box-shadow: 0px 0px 0px 1px #c71f7e inset !important;\n  color: #c71f7e !important;\n}\n.gswpts_tables_container .ui.buttons:not(.vertical) > .basic.pink.button:not(:first-child) {\n  margin-left: -1px;\n}\n.gswpts_tables_container .ui.inverted.pink.buttons .button,\n.gswpts_tables_container .ui.inverted.pink.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px #ff8edf inset !important;\n  color: #ff8edf;\n}\n.gswpts_tables_container .ui.inverted.pink.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.pink.button:hover,\n.gswpts_tables_container .ui.inverted.pink.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.pink.button:focus,\n.gswpts_tables_container .ui.inverted.pink.buttons .button.active,\n.gswpts_tables_container .ui.inverted.pink.button.active,\n.gswpts_tables_container .ui.inverted.pink.buttons .button:active,\n.gswpts_tables_container .ui.inverted.pink.button:active {\n  box-shadow: none !important;\n  color: #ffffff;\n}\n.gswpts_tables_container .ui.inverted.pink.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.pink.button:hover {\n  background-color: #ff74d8;\n}\n.gswpts_tables_container .ui.inverted.pink.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.pink.button:focus {\n  background-color: #ff65d3;\n}\n.gswpts_tables_container .ui.inverted.pink.buttons .active.button,\n.gswpts_tables_container .ui.inverted.pink.active.button {\n  background-color: #ff74d8;\n}\n.gswpts_tables_container .ui.inverted.pink.buttons .button:active,\n.gswpts_tables_container .ui.inverted.pink.button:active {\n  background-color: #ff5bd1;\n}\n.gswpts_tables_container .ui.inverted.pink.basic.buttons .button,\n.gswpts_tables_container .ui.inverted.pink.buttons .basic.button,\n.gswpts_tables_container .ui.inverted.pink.basic.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.inverted.pink.basic.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.pink.buttons .basic.button:hover,\n.gswpts_tables_container .ui.inverted.pink.basic.button:hover {\n  box-shadow: 0px 0px 0px 2px #ff74d8 inset !important;\n  color: #ff8edf !important;\n}\n.gswpts_tables_container .ui.inverted.pink.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.pink.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.pink.basic.button:focus {\n  box-shadow: 0px 0px 0px 2px #ff65d3 inset !important;\n  color: #ff8edf !important;\n}\n.gswpts_tables_container .ui.inverted.pink.basic.buttons .active.button,\n.gswpts_tables_container .ui.inverted.pink.buttons .basic.active.button,\n.gswpts_tables_container .ui.inverted.pink.basic.active.button {\n  box-shadow: 0px 0px 0px 2px #ff74d8 inset !important;\n  color: #ff8edf !important;\n}\n.gswpts_tables_container .ui.inverted.pink.basic.buttons .button:active,\n.gswpts_tables_container .ui.inverted.pink.buttons .basic.button:active,\n.gswpts_tables_container .ui.inverted.pink.basic.button:active {\n  box-shadow: 0px 0px 0px 2px #ff5bd1 inset !important;\n  color: #ff8edf !important;\n}\n.gswpts_tables_container .ui.violet.buttons .button,\n.gswpts_tables_container .ui.violet.button {\n  background-color: #6435c9;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n}\n.gswpts_tables_container .ui.violet.button {\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.violet.buttons .button:hover,\n.gswpts_tables_container .ui.violet.button:hover {\n  background-color: #5829bb;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.violet.buttons .button:focus,\n.gswpts_tables_container .ui.violet.button:focus {\n  background-color: #4f20b5;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.violet.buttons .button:active,\n.gswpts_tables_container .ui.violet.button:active {\n  background-color: #502aa1;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.violet.buttons .active.button,\n.gswpts_tables_container .ui.violet.buttons .active.button:active,\n.gswpts_tables_container .ui.violet.active.button,\n.gswpts_tables_container .ui.violet.button .active.button:active {\n  background-color: #5626bf;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.basic.violet.buttons .button,\n.gswpts_tables_container .ui.basic.violet.button {\n  box-shadow: 0px 0px 0px 1px #6435c9 inset !important;\n  color: #6435c9 !important;\n}\n.gswpts_tables_container .ui.basic.violet.buttons .button:hover,\n.gswpts_tables_container .ui.basic.violet.button:hover {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #5829bb inset !important;\n  color: #5829bb !important;\n}\n.gswpts_tables_container .ui.basic.violet.buttons .button:focus,\n.gswpts_tables_container .ui.basic.violet.button:focus {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #4f20b5 inset !important;\n  color: #5829bb !important;\n}\n.gswpts_tables_container .ui.basic.violet.buttons .active.button,\n.gswpts_tables_container .ui.basic.violet.active.button {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #5626bf inset !important;\n  color: #502aa1 !important;\n}\n.gswpts_tables_container .ui.basic.violet.buttons .button:active,\n.gswpts_tables_container .ui.basic.violet.button:active {\n  box-shadow: 0px 0px 0px 1px #502aa1 inset !important;\n  color: #502aa1 !important;\n}\n.gswpts_tables_container .ui.buttons:not(.vertical) > .basic.violet.button:not(:first-child) {\n  margin-left: -1px;\n}\n.gswpts_tables_container .ui.inverted.violet.buttons .button,\n.gswpts_tables_container .ui.inverted.violet.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px #a291fb inset !important;\n  color: #a291fb;\n}\n.gswpts_tables_container .ui.inverted.violet.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.violet.button:hover,\n.gswpts_tables_container .ui.inverted.violet.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.violet.button:focus,\n.gswpts_tables_container .ui.inverted.violet.buttons .button.active,\n.gswpts_tables_container .ui.inverted.violet.button.active,\n.gswpts_tables_container .ui.inverted.violet.buttons .button:active,\n.gswpts_tables_container .ui.inverted.violet.button:active {\n  box-shadow: none !important;\n  color: #ffffff;\n}\n.gswpts_tables_container .ui.inverted.violet.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.violet.button:hover {\n  background-color: #8a73ff;\n}\n.gswpts_tables_container .ui.inverted.violet.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.violet.button:focus {\n  background-color: #7d64ff;\n}\n.gswpts_tables_container .ui.inverted.violet.buttons .active.button,\n.gswpts_tables_container .ui.inverted.violet.active.button {\n  background-color: #8a73ff;\n}\n.gswpts_tables_container .ui.inverted.violet.buttons .button:active,\n.gswpts_tables_container .ui.inverted.violet.button:active {\n  background-color: #7860f9;\n}\n.gswpts_tables_container .ui.inverted.violet.basic.buttons .button,\n.gswpts_tables_container .ui.inverted.violet.buttons .basic.button,\n.gswpts_tables_container .ui.inverted.violet.basic.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.inverted.violet.basic.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.violet.buttons .basic.button:hover,\n.gswpts_tables_container .ui.inverted.violet.basic.button:hover {\n  box-shadow: 0px 0px 0px 2px #8a73ff inset !important;\n  color: #a291fb !important;\n}\n.gswpts_tables_container .ui.inverted.violet.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.violet.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.violet.basic.button:focus {\n  box-shadow: 0px 0px 0px 2px #7d64ff inset !important;\n  color: #a291fb !important;\n}\n.gswpts_tables_container .ui.inverted.violet.basic.buttons .active.button,\n.gswpts_tables_container .ui.inverted.violet.buttons .basic.active.button,\n.gswpts_tables_container .ui.inverted.violet.basic.active.button {\n  box-shadow: 0px 0px 0px 2px #8a73ff inset !important;\n  color: #a291fb !important;\n}\n.gswpts_tables_container .ui.inverted.violet.basic.buttons .button:active,\n.gswpts_tables_container .ui.inverted.violet.buttons .basic.button:active,\n.gswpts_tables_container .ui.inverted.violet.basic.button:active {\n  box-shadow: 0px 0px 0px 2px #7860f9 inset !important;\n  color: #a291fb !important;\n}\n.gswpts_tables_container .ui.purple.buttons .button,\n.gswpts_tables_container .ui.purple.button {\n  background-color: #a333c8;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n}\n.gswpts_tables_container .ui.purple.button {\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.purple.buttons .button:hover,\n.gswpts_tables_container .ui.purple.button:hover {\n  background-color: #9627ba;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.purple.buttons .button:focus,\n.gswpts_tables_container .ui.purple.button:focus {\n  background-color: #8f1eb4;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.purple.buttons .button:active,\n.gswpts_tables_container .ui.purple.button:active {\n  background-color: #82299f;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.purple.buttons .active.button,\n.gswpts_tables_container .ui.purple.buttons .active.button:active,\n.gswpts_tables_container .ui.purple.active.button,\n.gswpts_tables_container .ui.purple.button .active.button:active {\n  background-color: #9724be;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.basic.purple.buttons .button,\n.gswpts_tables_container .ui.basic.purple.button {\n  box-shadow: 0px 0px 0px 1px #a333c8 inset !important;\n  color: #a333c8 !important;\n}\n.gswpts_tables_container .ui.basic.purple.buttons .button:hover,\n.gswpts_tables_container .ui.basic.purple.button:hover {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #9627ba inset !important;\n  color: #9627ba !important;\n}\n.gswpts_tables_container .ui.basic.purple.buttons .button:focus,\n.gswpts_tables_container .ui.basic.purple.button:focus {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #8f1eb4 inset !important;\n  color: #9627ba !important;\n}\n.gswpts_tables_container .ui.basic.purple.buttons .active.button,\n.gswpts_tables_container .ui.basic.purple.active.button {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #9724be inset !important;\n  color: #82299f !important;\n}\n.gswpts_tables_container .ui.basic.purple.buttons .button:active,\n.gswpts_tables_container .ui.basic.purple.button:active {\n  box-shadow: 0px 0px 0px 1px #82299f inset !important;\n  color: #82299f !important;\n}\n.gswpts_tables_container .ui.buttons:not(.vertical) > .basic.purple.button:not(:first-child) {\n  margin-left: -1px;\n}\n.gswpts_tables_container .ui.inverted.purple.buttons .button,\n.gswpts_tables_container .ui.inverted.purple.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px #dc73ff inset !important;\n  color: #dc73ff;\n}\n.gswpts_tables_container .ui.inverted.purple.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.purple.button:hover,\n.gswpts_tables_container .ui.inverted.purple.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.purple.button:focus,\n.gswpts_tables_container .ui.inverted.purple.buttons .button.active,\n.gswpts_tables_container .ui.inverted.purple.button.active,\n.gswpts_tables_container .ui.inverted.purple.buttons .button:active,\n.gswpts_tables_container .ui.inverted.purple.button:active {\n  box-shadow: none !important;\n  color: #ffffff;\n}\n.gswpts_tables_container .ui.inverted.purple.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.purple.button:hover {\n  background-color: #d65aff;\n}\n.gswpts_tables_container .ui.inverted.purple.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.purple.button:focus {\n  background-color: #d24aff;\n}\n.gswpts_tables_container .ui.inverted.purple.buttons .active.button,\n.gswpts_tables_container .ui.inverted.purple.active.button {\n  background-color: #d65aff;\n}\n.gswpts_tables_container .ui.inverted.purple.buttons .button:active,\n.gswpts_tables_container .ui.inverted.purple.button:active {\n  background-color: #cf40ff;\n}\n.gswpts_tables_container .ui.inverted.purple.basic.buttons .button,\n.gswpts_tables_container .ui.inverted.purple.buttons .basic.button,\n.gswpts_tables_container .ui.inverted.purple.basic.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.inverted.purple.basic.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.purple.buttons .basic.button:hover,\n.gswpts_tables_container .ui.inverted.purple.basic.button:hover {\n  box-shadow: 0px 0px 0px 2px #d65aff inset !important;\n  color: #dc73ff !important;\n}\n.gswpts_tables_container .ui.inverted.purple.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.purple.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.purple.basic.button:focus {\n  box-shadow: 0px 0px 0px 2px #d24aff inset !important;\n  color: #dc73ff !important;\n}\n.gswpts_tables_container .ui.inverted.purple.basic.buttons .active.button,\n.gswpts_tables_container .ui.inverted.purple.buttons .basic.active.button,\n.gswpts_tables_container .ui.inverted.purple.basic.active.button {\n  box-shadow: 0px 0px 0px 2px #d65aff inset !important;\n  color: #dc73ff !important;\n}\n.gswpts_tables_container .ui.inverted.purple.basic.buttons .button:active,\n.gswpts_tables_container .ui.inverted.purple.buttons .basic.button:active,\n.gswpts_tables_container .ui.inverted.purple.basic.button:active {\n  box-shadow: 0px 0px 0px 2px #cf40ff inset !important;\n  color: #dc73ff !important;\n}\n.gswpts_tables_container .ui.red.buttons .button,\n.gswpts_tables_container .ui.red.button {\n  background-color: #db2828;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n}\n.gswpts_tables_container .ui.red.button {\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.red.buttons .button:hover,\n.gswpts_tables_container .ui.red.button:hover {\n  background-color: #d01919;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.red.buttons .button:focus,\n.gswpts_tables_container .ui.red.button:focus {\n  background-color: #ca1010;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.red.buttons .button:active,\n.gswpts_tables_container .ui.red.button:active {\n  background-color: #b21e1e;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.red.buttons .active.button,\n.gswpts_tables_container .ui.red.buttons .active.button:active,\n.gswpts_tables_container .ui.red.active.button,\n.gswpts_tables_container .ui.red.button .active.button:active {\n  background-color: #d41515;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.basic.red.buttons .button,\n.gswpts_tables_container .ui.basic.red.button {\n  box-shadow: 0px 0px 0px 1px #db2828 inset !important;\n  color: #db2828 !important;\n}\n.gswpts_tables_container .ui.basic.red.buttons .button:hover,\n.gswpts_tables_container .ui.basic.red.button:hover {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #d01919 inset !important;\n  color: #d01919 !important;\n}\n.gswpts_tables_container .ui.basic.red.buttons .button:focus,\n.gswpts_tables_container .ui.basic.red.button:focus {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #ca1010 inset !important;\n  color: #d01919 !important;\n}\n.gswpts_tables_container .ui.basic.red.buttons .active.button,\n.gswpts_tables_container .ui.basic.red.active.button {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #d41515 inset !important;\n  color: #b21e1e !important;\n}\n.gswpts_tables_container .ui.basic.red.buttons .button:active,\n.gswpts_tables_container .ui.basic.red.button:active {\n  box-shadow: 0px 0px 0px 1px #b21e1e inset !important;\n  color: #b21e1e !important;\n}\n.gswpts_tables_container .ui.buttons:not(.vertical) > .basic.red.button:not(:first-child) {\n  margin-left: -1px;\n}\n.gswpts_tables_container .ui.inverted.red.buttons .button,\n.gswpts_tables_container .ui.inverted.red.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px #ff695e inset !important;\n  color: #ff695e;\n}\n.gswpts_tables_container .ui.inverted.red.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.red.button:hover,\n.gswpts_tables_container .ui.inverted.red.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.red.button:focus,\n.gswpts_tables_container .ui.inverted.red.buttons .button.active,\n.gswpts_tables_container .ui.inverted.red.button.active,\n.gswpts_tables_container .ui.inverted.red.buttons .button:active,\n.gswpts_tables_container .ui.inverted.red.button:active {\n  box-shadow: none !important;\n  color: #ffffff;\n}\n.gswpts_tables_container .ui.inverted.red.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.red.button:hover {\n  background-color: #ff5144;\n}\n.gswpts_tables_container .ui.inverted.red.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.red.button:focus {\n  background-color: #ff4335;\n}\n.gswpts_tables_container .ui.inverted.red.buttons .active.button,\n.gswpts_tables_container .ui.inverted.red.active.button {\n  background-color: #ff5144;\n}\n.gswpts_tables_container .ui.inverted.red.buttons .button:active,\n.gswpts_tables_container .ui.inverted.red.button:active {\n  background-color: #ff392b;\n}\n.gswpts_tables_container .ui.inverted.red.basic.buttons .button,\n.gswpts_tables_container .ui.inverted.red.buttons .basic.button,\n.gswpts_tables_container .ui.inverted.red.basic.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.inverted.red.basic.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.red.buttons .basic.button:hover,\n.gswpts_tables_container .ui.inverted.red.basic.button:hover {\n  box-shadow: 0px 0px 0px 2px #ff5144 inset !important;\n  color: #ff695e !important;\n}\n.gswpts_tables_container .ui.inverted.red.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.red.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.red.basic.button:focus {\n  box-shadow: 0px 0px 0px 2px #ff4335 inset !important;\n  color: #ff695e !important;\n}\n.gswpts_tables_container .ui.inverted.red.basic.buttons .active.button,\n.gswpts_tables_container .ui.inverted.red.buttons .basic.active.button,\n.gswpts_tables_container .ui.inverted.red.basic.active.button {\n  box-shadow: 0px 0px 0px 2px #ff5144 inset !important;\n  color: #ff695e !important;\n}\n.gswpts_tables_container .ui.inverted.red.basic.buttons .button:active,\n.gswpts_tables_container .ui.inverted.red.buttons .basic.button:active,\n.gswpts_tables_container .ui.inverted.red.basic.button:active {\n  box-shadow: 0px 0px 0px 2px #ff392b inset !important;\n  color: #ff695e !important;\n}\n.gswpts_tables_container .ui.teal.buttons .button,\n.gswpts_tables_container .ui.teal.button {\n  background-color: #00b5ad;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n}\n.gswpts_tables_container .ui.teal.button {\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.teal.buttons .button:hover,\n.gswpts_tables_container .ui.teal.button:hover {\n  background-color: #009c95;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.teal.buttons .button:focus,\n.gswpts_tables_container .ui.teal.button:focus {\n  background-color: #008c86;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.teal.buttons .button:active,\n.gswpts_tables_container .ui.teal.button:active {\n  background-color: #00827c;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.teal.buttons .active.button,\n.gswpts_tables_container .ui.teal.buttons .active.button:active,\n.gswpts_tables_container .ui.teal.active.button,\n.gswpts_tables_container .ui.teal.button .active.button:active {\n  background-color: #009c95;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.basic.teal.buttons .button,\n.gswpts_tables_container .ui.basic.teal.button {\n  box-shadow: 0px 0px 0px 1px #00b5ad inset !important;\n  color: #00b5ad !important;\n}\n.gswpts_tables_container .ui.basic.teal.buttons .button:hover,\n.gswpts_tables_container .ui.basic.teal.button:hover {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #009c95 inset !important;\n  color: #009c95 !important;\n}\n.gswpts_tables_container .ui.basic.teal.buttons .button:focus,\n.gswpts_tables_container .ui.basic.teal.button:focus {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #008c86 inset !important;\n  color: #009c95 !important;\n}\n.gswpts_tables_container .ui.basic.teal.buttons .active.button,\n.gswpts_tables_container .ui.basic.teal.active.button {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #009c95 inset !important;\n  color: #00827c !important;\n}\n.gswpts_tables_container .ui.basic.teal.buttons .button:active,\n.gswpts_tables_container .ui.basic.teal.button:active {\n  box-shadow: 0px 0px 0px 1px #00827c inset !important;\n  color: #00827c !important;\n}\n.gswpts_tables_container .ui.buttons:not(.vertical) > .basic.teal.button:not(:first-child) {\n  margin-left: -1px;\n}\n.gswpts_tables_container .ui.inverted.teal.buttons .button,\n.gswpts_tables_container .ui.inverted.teal.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px #6dffff inset !important;\n  color: #6dffff;\n}\n.gswpts_tables_container .ui.inverted.teal.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.teal.button:hover,\n.gswpts_tables_container .ui.inverted.teal.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.teal.button:focus,\n.gswpts_tables_container .ui.inverted.teal.buttons .button.active,\n.gswpts_tables_container .ui.inverted.teal.button.active,\n.gswpts_tables_container .ui.inverted.teal.buttons .button:active,\n.gswpts_tables_container .ui.inverted.teal.button:active {\n  box-shadow: none !important;\n  color: rgba(0, 0, 0, 0.6);\n}\n.gswpts_tables_container .ui.inverted.teal.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.teal.button:hover {\n  background-color: #54ffff;\n}\n.gswpts_tables_container .ui.inverted.teal.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.teal.button:focus {\n  background-color: #44ffff;\n}\n.gswpts_tables_container .ui.inverted.teal.buttons .active.button,\n.gswpts_tables_container .ui.inverted.teal.active.button {\n  background-color: #54ffff;\n}\n.gswpts_tables_container .ui.inverted.teal.buttons .button:active,\n.gswpts_tables_container .ui.inverted.teal.button:active {\n  background-color: #3affff;\n}\n.gswpts_tables_container .ui.inverted.teal.basic.buttons .button,\n.gswpts_tables_container .ui.inverted.teal.buttons .basic.button,\n.gswpts_tables_container .ui.inverted.teal.basic.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.inverted.teal.basic.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.teal.buttons .basic.button:hover,\n.gswpts_tables_container .ui.inverted.teal.basic.button:hover {\n  box-shadow: 0px 0px 0px 2px #54ffff inset !important;\n  color: #6dffff !important;\n}\n.gswpts_tables_container .ui.inverted.teal.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.teal.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.teal.basic.button:focus {\n  box-shadow: 0px 0px 0px 2px #44ffff inset !important;\n  color: #6dffff !important;\n}\n.gswpts_tables_container .ui.inverted.teal.basic.buttons .active.button,\n.gswpts_tables_container .ui.inverted.teal.buttons .basic.active.button,\n.gswpts_tables_container .ui.inverted.teal.basic.active.button {\n  box-shadow: 0px 0px 0px 2px #54ffff inset !important;\n  color: #6dffff !important;\n}\n.gswpts_tables_container .ui.inverted.teal.basic.buttons .button:active,\n.gswpts_tables_container .ui.inverted.teal.buttons .basic.button:active,\n.gswpts_tables_container .ui.inverted.teal.basic.button:active {\n  box-shadow: 0px 0px 0px 2px #3affff inset !important;\n  color: #6dffff !important;\n}\n.gswpts_tables_container .ui.olive.buttons .button,\n.gswpts_tables_container .ui.olive.button {\n  background-color: #b5cc18;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n}\n.gswpts_tables_container .ui.olive.button {\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.olive.buttons .button:hover,\n.gswpts_tables_container .ui.olive.button:hover {\n  background-color: #a7bd0d;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.olive.buttons .button:focus,\n.gswpts_tables_container .ui.olive.button:focus {\n  background-color: #a0b605;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.olive.buttons .button:active,\n.gswpts_tables_container .ui.olive.button:active {\n  background-color: #8d9e13;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.olive.buttons .active.button,\n.gswpts_tables_container .ui.olive.buttons .active.button:active,\n.gswpts_tables_container .ui.olive.active.button,\n.gswpts_tables_container .ui.olive.button .active.button:active {\n  background-color: #aac109;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.basic.olive.buttons .button,\n.gswpts_tables_container .ui.basic.olive.button {\n  box-shadow: 0px 0px 0px 1px #b5cc18 inset !important;\n  color: #b5cc18 !important;\n}\n.gswpts_tables_container .ui.basic.olive.buttons .button:hover,\n.gswpts_tables_container .ui.basic.olive.button:hover {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #a7bd0d inset !important;\n  color: #a7bd0d !important;\n}\n.gswpts_tables_container .ui.basic.olive.buttons .button:focus,\n.gswpts_tables_container .ui.basic.olive.button:focus {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #a0b605 inset !important;\n  color: #a7bd0d !important;\n}\n.gswpts_tables_container .ui.basic.olive.buttons .active.button,\n.gswpts_tables_container .ui.basic.olive.active.button {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #aac109 inset !important;\n  color: #8d9e13 !important;\n}\n.gswpts_tables_container .ui.basic.olive.buttons .button:active,\n.gswpts_tables_container .ui.basic.olive.button:active {\n  box-shadow: 0px 0px 0px 1px #8d9e13 inset !important;\n  color: #8d9e13 !important;\n}\n.gswpts_tables_container .ui.buttons:not(.vertical) > .basic.olive.button:not(:first-child) {\n  margin-left: -1px;\n}\n.gswpts_tables_container .ui.inverted.olive.buttons .button,\n.gswpts_tables_container .ui.inverted.olive.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px #d9e778 inset !important;\n  color: #d9e778;\n}\n.gswpts_tables_container .ui.inverted.olive.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.olive.button:hover,\n.gswpts_tables_container .ui.inverted.olive.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.olive.button:focus,\n.gswpts_tables_container .ui.inverted.olive.buttons .button.active,\n.gswpts_tables_container .ui.inverted.olive.button.active,\n.gswpts_tables_container .ui.inverted.olive.buttons .button:active,\n.gswpts_tables_container .ui.inverted.olive.button:active {\n  box-shadow: none !important;\n  color: rgba(0, 0, 0, 0.6);\n}\n.gswpts_tables_container .ui.inverted.olive.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.olive.button:hover {\n  background-color: #d8ea5c;\n}\n.gswpts_tables_container .ui.inverted.olive.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.olive.button:focus {\n  background-color: #daef47;\n}\n.gswpts_tables_container .ui.inverted.olive.buttons .active.button,\n.gswpts_tables_container .ui.inverted.olive.active.button {\n  background-color: #daed59;\n}\n.gswpts_tables_container .ui.inverted.olive.buttons .button:active,\n.gswpts_tables_container .ui.inverted.olive.button:active {\n  background-color: #cddf4d;\n}\n.gswpts_tables_container .ui.inverted.olive.basic.buttons .button,\n.gswpts_tables_container .ui.inverted.olive.buttons .basic.button,\n.gswpts_tables_container .ui.inverted.olive.basic.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.inverted.olive.basic.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.olive.buttons .basic.button:hover,\n.gswpts_tables_container .ui.inverted.olive.basic.button:hover {\n  box-shadow: 0px 0px 0px 2px #d8ea5c inset !important;\n  color: #d9e778 !important;\n}\n.gswpts_tables_container .ui.inverted.olive.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.olive.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.olive.basic.button:focus {\n  box-shadow: 0px 0px 0px 2px #daef47 inset !important;\n  color: #d9e778 !important;\n}\n.gswpts_tables_container .ui.inverted.olive.basic.buttons .active.button,\n.gswpts_tables_container .ui.inverted.olive.buttons .basic.active.button,\n.gswpts_tables_container .ui.inverted.olive.basic.active.button {\n  box-shadow: 0px 0px 0px 2px #daed59 inset !important;\n  color: #d9e778 !important;\n}\n.gswpts_tables_container .ui.inverted.olive.basic.buttons .button:active,\n.gswpts_tables_container .ui.inverted.olive.buttons .basic.button:active,\n.gswpts_tables_container .ui.inverted.olive.basic.button:active {\n  box-shadow: 0px 0px 0px 2px #cddf4d inset !important;\n  color: #d9e778 !important;\n}\n.gswpts_tables_container .ui.yellow.buttons .button,\n.gswpts_tables_container .ui.yellow.button {\n  background-color: #fbbd08;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n}\n.gswpts_tables_container .ui.yellow.button {\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.yellow.buttons .button:hover,\n.gswpts_tables_container .ui.yellow.button:hover {\n  background-color: #eaae00;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.yellow.buttons .button:focus,\n.gswpts_tables_container .ui.yellow.button:focus {\n  background-color: #daa300;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.yellow.buttons .button:active,\n.gswpts_tables_container .ui.yellow.button:active {\n  background-color: #cd9903;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.yellow.buttons .active.button,\n.gswpts_tables_container .ui.yellow.buttons .active.button:active,\n.gswpts_tables_container .ui.yellow.active.button,\n.gswpts_tables_container .ui.yellow.button .active.button:active {\n  background-color: #eaae00;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.basic.yellow.buttons .button,\n.gswpts_tables_container .ui.basic.yellow.button {\n  box-shadow: 0px 0px 0px 1px #fbbd08 inset !important;\n  color: #fbbd08 !important;\n}\n.gswpts_tables_container .ui.basic.yellow.buttons .button:hover,\n.gswpts_tables_container .ui.basic.yellow.button:hover {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #eaae00 inset !important;\n  color: #eaae00 !important;\n}\n.gswpts_tables_container .ui.basic.yellow.buttons .button:focus,\n.gswpts_tables_container .ui.basic.yellow.button:focus {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #daa300 inset !important;\n  color: #eaae00 !important;\n}\n.gswpts_tables_container .ui.basic.yellow.buttons .active.button,\n.gswpts_tables_container .ui.basic.yellow.active.button {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #eaae00 inset !important;\n  color: #cd9903 !important;\n}\n.gswpts_tables_container .ui.basic.yellow.buttons .button:active,\n.gswpts_tables_container .ui.basic.yellow.button:active {\n  box-shadow: 0px 0px 0px 1px #cd9903 inset !important;\n  color: #cd9903 !important;\n}\n.gswpts_tables_container .ui.buttons:not(.vertical) > .basic.yellow.button:not(:first-child) {\n  margin-left: -1px;\n}\n.gswpts_tables_container .ui.inverted.yellow.buttons .button,\n.gswpts_tables_container .ui.inverted.yellow.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px #ffe21f inset !important;\n  color: #ffe21f;\n}\n.gswpts_tables_container .ui.inverted.yellow.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.yellow.button:hover,\n.gswpts_tables_container .ui.inverted.yellow.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.yellow.button:focus,\n.gswpts_tables_container .ui.inverted.yellow.buttons .button.active,\n.gswpts_tables_container .ui.inverted.yellow.button.active,\n.gswpts_tables_container .ui.inverted.yellow.buttons .button:active,\n.gswpts_tables_container .ui.inverted.yellow.button:active {\n  box-shadow: none !important;\n  color: rgba(0, 0, 0, 0.6);\n}\n.gswpts_tables_container .ui.inverted.yellow.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.yellow.button:hover {\n  background-color: #ffdf05;\n}\n.gswpts_tables_container .ui.inverted.yellow.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.yellow.button:focus {\n  background-color: #f5d500;\n}\n.gswpts_tables_container .ui.inverted.yellow.buttons .active.button,\n.gswpts_tables_container .ui.inverted.yellow.active.button {\n  background-color: #ffdf05;\n}\n.gswpts_tables_container .ui.inverted.yellow.buttons .button:active,\n.gswpts_tables_container .ui.inverted.yellow.button:active {\n  background-color: #ebcd00;\n}\n.gswpts_tables_container .ui.inverted.yellow.basic.buttons .button,\n.gswpts_tables_container .ui.inverted.yellow.buttons .basic.button,\n.gswpts_tables_container .ui.inverted.yellow.basic.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.inverted.yellow.basic.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.yellow.buttons .basic.button:hover,\n.gswpts_tables_container .ui.inverted.yellow.basic.button:hover {\n  box-shadow: 0px 0px 0px 2px #ffdf05 inset !important;\n  color: #ffe21f !important;\n}\n.gswpts_tables_container .ui.inverted.yellow.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.yellow.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.yellow.basic.button:focus {\n  box-shadow: 0px 0px 0px 2px #f5d500 inset !important;\n  color: #ffe21f !important;\n}\n.gswpts_tables_container .ui.inverted.yellow.basic.buttons .active.button,\n.gswpts_tables_container .ui.inverted.yellow.buttons .basic.active.button,\n.gswpts_tables_container .ui.inverted.yellow.basic.active.button {\n  box-shadow: 0px 0px 0px 2px #ffdf05 inset !important;\n  color: #ffe21f !important;\n}\n.gswpts_tables_container .ui.inverted.yellow.basic.buttons .button:active,\n.gswpts_tables_container .ui.inverted.yellow.buttons .basic.button:active,\n.gswpts_tables_container .ui.inverted.yellow.basic.button:active {\n  box-shadow: 0px 0px 0px 2px #ebcd00 inset !important;\n  color: #ffe21f !important;\n}\n.gswpts_tables_container .ui.primary.buttons .button,\n.gswpts_tables_container .ui.primary.button {\n  background-color: #2185d0;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n}\n.gswpts_tables_container .ui.primary.button {\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.primary.buttons .button:hover,\n.gswpts_tables_container .ui.primary.button:hover {\n  background-color: #1678c2;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.primary.buttons .button:focus,\n.gswpts_tables_container .ui.primary.button:focus {\n  background-color: #0d71bb;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.primary.buttons .button:active,\n.gswpts_tables_container .ui.primary.button:active {\n  background-color: #1a69a4;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.primary.buttons .active.button,\n.gswpts_tables_container .ui.primary.buttons .active.button:active,\n.gswpts_tables_container .ui.primary.active.button,\n.gswpts_tables_container .ui.primary.button .active.button:active {\n  background-color: #1279c6;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.basic.primary.buttons .button,\n.gswpts_tables_container .ui.basic.primary.button {\n  box-shadow: 0px 0px 0px 1px #2185d0 inset !important;\n  color: #2185d0 !important;\n}\n.gswpts_tables_container .ui.basic.primary.buttons .button:hover,\n.gswpts_tables_container .ui.basic.primary.button:hover {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #1678c2 inset !important;\n  color: #1678c2 !important;\n}\n.gswpts_tables_container .ui.basic.primary.buttons .button:focus,\n.gswpts_tables_container .ui.basic.primary.button:focus {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #0d71bb inset !important;\n  color: #1678c2 !important;\n}\n.gswpts_tables_container .ui.basic.primary.buttons .active.button,\n.gswpts_tables_container .ui.basic.primary.active.button {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #1279c6 inset !important;\n  color: #1a69a4 !important;\n}\n.gswpts_tables_container .ui.basic.primary.buttons .button:active,\n.gswpts_tables_container .ui.basic.primary.button:active {\n  box-shadow: 0px 0px 0px 1px #1a69a4 inset !important;\n  color: #1a69a4 !important;\n}\n.gswpts_tables_container .ui.buttons:not(.vertical) > .basic.primary.button:not(:first-child) {\n  margin-left: -1px;\n}\n.gswpts_tables_container .ui.inverted.primary.buttons .button,\n.gswpts_tables_container .ui.inverted.primary.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px #54c8ff inset !important;\n  color: #54c8ff;\n}\n.gswpts_tables_container .ui.inverted.primary.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.primary.button:hover,\n.gswpts_tables_container .ui.inverted.primary.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.primary.button:focus,\n.gswpts_tables_container .ui.inverted.primary.buttons .button.active,\n.gswpts_tables_container .ui.inverted.primary.button.active,\n.gswpts_tables_container .ui.inverted.primary.buttons .button:active,\n.gswpts_tables_container .ui.inverted.primary.button:active {\n  box-shadow: none !important;\n  color: #ffffff;\n}\n.gswpts_tables_container .ui.inverted.primary.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.primary.button:hover {\n  background-color: #3ac0ff;\n}\n.gswpts_tables_container .ui.inverted.primary.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.primary.button:focus {\n  background-color: #2bbbff;\n}\n.gswpts_tables_container .ui.inverted.primary.buttons .active.button,\n.gswpts_tables_container .ui.inverted.primary.active.button {\n  background-color: #3ac0ff;\n}\n.gswpts_tables_container .ui.inverted.primary.buttons .button:active,\n.gswpts_tables_container .ui.inverted.primary.button:active {\n  background-color: #21b8ff;\n}\n.gswpts_tables_container .ui.inverted.primary.basic.buttons .button,\n.gswpts_tables_container .ui.inverted.primary.buttons .basic.button,\n.gswpts_tables_container .ui.inverted.primary.basic.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.inverted.primary.basic.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.primary.buttons .basic.button:hover,\n.gswpts_tables_container .ui.inverted.primary.basic.button:hover {\n  box-shadow: 0px 0px 0px 2px #3ac0ff inset !important;\n  color: #54c8ff !important;\n}\n.gswpts_tables_container .ui.inverted.primary.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.primary.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.primary.basic.button:focus {\n  box-shadow: 0px 0px 0px 2px #2bbbff inset !important;\n  color: #54c8ff !important;\n}\n.gswpts_tables_container .ui.inverted.primary.basic.buttons .active.button,\n.gswpts_tables_container .ui.inverted.primary.buttons .basic.active.button,\n.gswpts_tables_container .ui.inverted.primary.basic.active.button {\n  box-shadow: 0px 0px 0px 2px #3ac0ff inset !important;\n  color: #54c8ff !important;\n}\n.gswpts_tables_container .ui.inverted.primary.basic.buttons .button:active,\n.gswpts_tables_container .ui.inverted.primary.buttons .basic.button:active,\n.gswpts_tables_container .ui.inverted.primary.basic.button:active {\n  box-shadow: 0px 0px 0px 2px #21b8ff inset !important;\n  color: #54c8ff !important;\n}\n.gswpts_tables_container .ui.secondary.buttons .button,\n.gswpts_tables_container .ui.secondary.button {\n  background-color: #1b1c1d;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n}\n.gswpts_tables_container .ui.secondary.button {\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.secondary.buttons .button:hover,\n.gswpts_tables_container .ui.secondary.button:hover {\n  background-color: #27292a;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.secondary.buttons .button:focus,\n.gswpts_tables_container .ui.secondary.button:focus {\n  background-color: #2e3032;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.secondary.buttons .button:active,\n.gswpts_tables_container .ui.secondary.button:active {\n  background-color: #343637;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.secondary.buttons .active.button,\n.gswpts_tables_container .ui.secondary.buttons .active.button:active,\n.gswpts_tables_container .ui.secondary.active.button,\n.gswpts_tables_container .ui.secondary.button .active.button:active {\n  background-color: #27292a;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.basic.secondary.buttons .button,\n.gswpts_tables_container .ui.basic.secondary.button {\n  box-shadow: 0px 0px 0px 1px #1b1c1d inset !important;\n  color: #1b1c1d !important;\n}\n.gswpts_tables_container .ui.basic.secondary.buttons .button:hover,\n.gswpts_tables_container .ui.basic.secondary.button:hover {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #27292a inset !important;\n  color: #27292a !important;\n}\n.gswpts_tables_container .ui.basic.secondary.buttons .button:focus,\n.gswpts_tables_container .ui.basic.secondary.button:focus {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #2e3032 inset !important;\n  color: #27292a !important;\n}\n.gswpts_tables_container .ui.basic.secondary.buttons .active.button,\n.gswpts_tables_container .ui.basic.secondary.active.button {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #27292a inset !important;\n  color: #343637 !important;\n}\n.gswpts_tables_container .ui.basic.secondary.buttons .button:active,\n.gswpts_tables_container .ui.basic.secondary.button:active {\n  box-shadow: 0px 0px 0px 1px #343637 inset !important;\n  color: #343637 !important;\n}\n.gswpts_tables_container .ui.buttons:not(.vertical) > .basic.primary.button:not(:first-child) {\n  margin-left: -1px;\n}\n.gswpts_tables_container .ui.inverted.secondary.buttons .button,\n.gswpts_tables_container .ui.inverted.secondary.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px #545454 inset !important;\n  color: #545454;\n}\n.gswpts_tables_container .ui.inverted.secondary.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.secondary.button:hover,\n.gswpts_tables_container .ui.inverted.secondary.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.secondary.button:focus,\n.gswpts_tables_container .ui.inverted.secondary.buttons .button.active,\n.gswpts_tables_container .ui.inverted.secondary.button.active,\n.gswpts_tables_container .ui.inverted.secondary.buttons .button:active,\n.gswpts_tables_container .ui.inverted.secondary.button:active {\n  box-shadow: none !important;\n  color: #ffffff;\n}\n.gswpts_tables_container .ui.inverted.secondary.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.secondary.button:hover {\n  background-color: #616161;\n}\n.gswpts_tables_container .ui.inverted.secondary.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.secondary.button:focus {\n  background-color: #686868;\n}\n.gswpts_tables_container .ui.inverted.secondary.buttons .active.button,\n.gswpts_tables_container .ui.inverted.secondary.active.button {\n  background-color: #616161;\n}\n.gswpts_tables_container .ui.inverted.secondary.buttons .button:active,\n.gswpts_tables_container .ui.inverted.secondary.button:active {\n  background-color: #6e6e6e;\n}\n.gswpts_tables_container .ui.inverted.secondary.basic.buttons .button,\n.gswpts_tables_container .ui.inverted.secondary.buttons .basic.button,\n.gswpts_tables_container .ui.inverted.secondary.basic.button {\n  background-color: transparent;\n  box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\n  color: #ffffff !important;\n}\n.gswpts_tables_container .ui.inverted.secondary.basic.buttons .button:hover,\n.gswpts_tables_container .ui.inverted.secondary.buttons .basic.button:hover,\n.gswpts_tables_container .ui.inverted.secondary.basic.button:hover {\n  box-shadow: 0px 0px 0px 2px #616161 inset !important;\n  color: #545454 !important;\n}\n.gswpts_tables_container .ui.inverted.secondary.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.secondary.basic.buttons .button:focus,\n.gswpts_tables_container .ui.inverted.secondary.basic.button:focus {\n  box-shadow: 0px 0px 0px 2px #686868 inset !important;\n  color: #545454 !important;\n}\n.gswpts_tables_container .ui.inverted.secondary.basic.buttons .active.button,\n.gswpts_tables_container .ui.inverted.secondary.buttons .basic.active.button,\n.gswpts_tables_container .ui.inverted.secondary.basic.active.button {\n  box-shadow: 0px 0px 0px 2px #616161 inset !important;\n  color: #545454 !important;\n}\n.gswpts_tables_container .ui.inverted.secondary.basic.buttons .button:active,\n.gswpts_tables_container .ui.inverted.secondary.buttons .basic.button:active,\n.gswpts_tables_container .ui.inverted.secondary.basic.button:active {\n  box-shadow: 0px 0px 0px 2px #6e6e6e inset !important;\n  color: #545454 !important;\n}\n.gswpts_tables_container .ui.positive.buttons .button,\n.gswpts_tables_container .ui.positive.button {\n  background-color: #21ba45;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n}\n.gswpts_tables_container .ui.positive.button {\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.positive.buttons .button:hover,\n.gswpts_tables_container .ui.positive.button:hover {\n  background-color: #16ab39;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.positive.buttons .button:focus,\n.gswpts_tables_container .ui.positive.button:focus {\n  background-color: #0ea432;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.positive.buttons .button:active,\n.gswpts_tables_container .ui.positive.button:active {\n  background-color: #198f35;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.positive.buttons .active.button,\n.gswpts_tables_container .ui.positive.buttons .active.button:active,\n.gswpts_tables_container .ui.positive.active.button,\n.gswpts_tables_container .ui.positive.button .active.button:active {\n  background-color: #13ae38;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.basic.positive.buttons .button,\n.gswpts_tables_container .ui.basic.positive.button {\n  box-shadow: 0px 0px 0px 1px #21ba45 inset !important;\n  color: #21ba45 !important;\n}\n.gswpts_tables_container .ui.basic.positive.buttons .button:hover,\n.gswpts_tables_container .ui.basic.positive.button:hover {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #16ab39 inset !important;\n  color: #16ab39 !important;\n}\n.gswpts_tables_container .ui.basic.positive.buttons .button:focus,\n.gswpts_tables_container .ui.basic.positive.button:focus {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #0ea432 inset !important;\n  color: #16ab39 !important;\n}\n.gswpts_tables_container .ui.basic.positive.buttons .active.button,\n.gswpts_tables_container .ui.basic.positive.active.button {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #13ae38 inset !important;\n  color: #198f35 !important;\n}\n.gswpts_tables_container .ui.basic.positive.buttons .button:active,\n.gswpts_tables_container .ui.basic.positive.button:active {\n  box-shadow: 0px 0px 0px 1px #198f35 inset !important;\n  color: #198f35 !important;\n}\n.gswpts_tables_container .ui.buttons:not(.vertical) > .basic.primary.button:not(:first-child) {\n  margin-left: -1px;\n}\n.gswpts_tables_container .ui.negative.buttons .button,\n.gswpts_tables_container .ui.negative.button {\n  background-color: #db2828;\n  color: #ffffff;\n  text-shadow: none;\n  background-image: none;\n}\n.gswpts_tables_container .ui.negative.button {\n  box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.negative.buttons .button:hover,\n.gswpts_tables_container .ui.negative.button:hover {\n  background-color: #d01919;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.negative.buttons .button:focus,\n.gswpts_tables_container .ui.negative.button:focus {\n  background-color: #ca1010;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.negative.buttons .button:active,\n.gswpts_tables_container .ui.negative.button:active {\n  background-color: #b21e1e;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.negative.buttons .active.button,\n.gswpts_tables_container .ui.negative.buttons .active.button:active,\n.gswpts_tables_container .ui.negative.active.button,\n.gswpts_tables_container .ui.negative.button .active.button:active {\n  background-color: #d41515;\n  color: #ffffff;\n  text-shadow: none;\n}\n.gswpts_tables_container .ui.basic.negative.buttons .button,\n.gswpts_tables_container .ui.basic.negative.button {\n  box-shadow: 0px 0px 0px 1px #db2828 inset !important;\n  color: #db2828 !important;\n}\n.gswpts_tables_container .ui.basic.negative.buttons .button:hover,\n.gswpts_tables_container .ui.basic.negative.button:hover {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #d01919 inset !important;\n  color: #d01919 !important;\n}\n.gswpts_tables_container .ui.basic.negative.buttons .button:focus,\n.gswpts_tables_container .ui.basic.negative.button:focus {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #ca1010 inset !important;\n  color: #d01919 !important;\n}\n.gswpts_tables_container .ui.basic.negative.buttons .active.button,\n.gswpts_tables_container .ui.basic.negative.active.button {\n  background: transparent !important;\n  box-shadow: 0px 0px 0px 1px #d41515 inset !important;\n  color: #b21e1e !important;\n}\n.gswpts_tables_container .ui.basic.negative.buttons .button:active,\n.gswpts_tables_container .ui.basic.negative.button:active {\n  box-shadow: 0px 0px 0px 1px #b21e1e inset !important;\n  color: #b21e1e !important;\n}\n.gswpts_tables_container .ui.buttons:not(.vertical) > .basic.primary.button:not(:first-child) {\n  margin-left: -1px;\n}\n.gswpts_tables_container .ui.buttons {\n  display: inline-flex;\n  flex-direction: row;\n  font-size: 0em;\n  vertical-align: baseline;\n  margin: 0em 0.25em 0em 0em;\n}\n.gswpts_tables_container .ui.buttons:not(.basic):not(.inverted) {\n  box-shadow: none;\n}\n.gswpts_tables_container .ui.buttons:after {\n  content: \".\";\n  display: block;\n  height: 0;\n  clear: both;\n  visibility: hidden;\n}\n.gswpts_tables_container .ui.buttons .button {\n  flex: 1 0 auto;\n  margin: 0em;\n  border-radius: 0em;\n  margin: 0px 0px 0px 0px;\n}\n.gswpts_tables_container .ui.buttons > .ui.button:not(.basic):not(.inverted),\n.gswpts_tables_container .ui.buttons:not(.basic):not(.inverted) > .button {\n  box-shadow: 0px 0px 0px 1px transparent inset, 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\n}\n.gswpts_tables_container .ui.buttons .button:first-child {\n  border-left: none;\n  margin-left: 0em;\n  border-top-left-radius: 0.28571429rem;\n  border-bottom-left-radius: 0.28571429rem;\n}\n.gswpts_tables_container .ui.buttons .button:last-child {\n  border-top-right-radius: 0.28571429rem;\n  border-bottom-right-radius: 0.28571429rem;\n}\n.gswpts_tables_container .ui.vertical.buttons {\n  display: inline-flex;\n  flex-direction: column;\n}\n.gswpts_tables_container .ui.vertical.buttons .button {\n  display: block;\n  float: none;\n  width: 100%;\n  margin: 0px 0px 0px 0px;\n  box-shadow: none;\n  border-radius: 0em;\n}\n.gswpts_tables_container .ui.vertical.buttons .button:first-child {\n  border-top-left-radius: 0.28571429rem;\n  border-top-right-radius: 0.28571429rem;\n}\n.gswpts_tables_container .ui.vertical.buttons .button:last-child {\n  margin-bottom: 0px;\n  border-bottom-left-radius: 0.28571429rem;\n  border-bottom-right-radius: 0.28571429rem;\n}\n.gswpts_tables_container .ui.vertical.buttons .button:only-child {\n  border-radius: 0.28571429rem;\n}\n.gswpts_tables_container .ui.input {\n  position: relative;\n  font-weight: normal;\n  font-style: normal;\n  display: inline-flex;\n  color: rgba(0, 0, 0, 0.87);\n}\n.gswpts_tables_container .ui.input > input {\n  margin: 0em;\n  max-width: 100%;\n  flex: 1 0 auto;\n  outline: none;\n  -webkit-tap-highlight-color: rgba(255, 255, 255, 0);\n  text-align: left;\n  line-height: 1.21428571em;\n  font-family: \"Lato\", \"Helvetica Neue\", Arial, Helvetica, sans-serif;\n  padding: 0.67857143em 1em;\n  background: #ffffff;\n  border: 1px solid rgba(34, 36, 38, 0.15);\n  color: rgba(0, 0, 0, 0.87);\n  border-radius: 0.28571429rem;\n  transition: box-shadow 0.1s ease, border-color 0.1s ease;\n  box-shadow: none;\n}\n.gswpts_tables_container .ui.input > input::-webkit-input-placeholder {\n  color: rgba(191, 191, 191, 0.87);\n}\n.gswpts_tables_container .ui.input > input::-moz-placeholder {\n  color: rgba(191, 191, 191, 0.87);\n}\n.gswpts_tables_container .ui.input > input:-ms-input-placeholder {\n  color: rgba(191, 191, 191, 0.87);\n}\n.gswpts_tables_container .ui.disabled.input,\n.gswpts_tables_container .ui.input:not(.disabled) input[disabled] {\n  opacity: 0.45;\n}\n.gswpts_tables_container .ui.disabled.input > input,\n.gswpts_tables_container .ui.input:not(.disabled) input[disabled] {\n  pointer-events: none;\n}\n.gswpts_tables_container .ui.input > input:active,\n.gswpts_tables_container .ui.input.down input {\n  border-color: rgba(0, 0, 0, 0.3);\n  background: #fafafa;\n  color: rgba(0, 0, 0, 0.87);\n  box-shadow: none;\n}\n.gswpts_tables_container .ui.loading.loading.input > i.icon:before {\n  position: absolute;\n  content: \"\";\n  top: 50%;\n  left: 50%;\n  margin: -0.64285714em 0em 0em -0.64285714em;\n  width: 1.28571429em;\n  height: 1.28571429em;\n  border-radius: 500rem;\n  border: 0.2em solid rgba(0, 0, 0, 0.1);\n}\n.gswpts_tables_container .ui.loading.loading.input > i.icon:after {\n  position: absolute;\n  content: \"\";\n  top: 50%;\n  left: 50%;\n  margin: -0.64285714em 0em 0em -0.64285714em;\n  width: 1.28571429em;\n  height: 1.28571429em;\n  -webkit-animation: button-spin 0.6s linear;\n  animation: button-spin 0.6s linear;\n  -webkit-animation-iteration-count: infinite;\n  animation-iteration-count: infinite;\n  border-radius: 500rem;\n  border-color: #767676 transparent transparent;\n  border-style: solid;\n  border-width: 0.2em;\n  box-shadow: 0px 0px 0px 1px transparent;\n}\n.gswpts_tables_container .ui.input.focus > input,\n.gswpts_tables_container .ui.input > input:focus {\n  border-color: #85b7d9;\n  background: #ffffff;\n  color: rgba(0, 0, 0, 0.8);\n  box-shadow: none;\n}\n.gswpts_tables_container .ui.input.focus > input::-webkit-input-placeholder,\n.gswpts_tables_container .ui.input > input:focus::-webkit-input-placeholder {\n  color: rgba(115, 115, 115, 0.87);\n}\n.gswpts_tables_container .ui.input.focus > input::-moz-placeholder,\n.gswpts_tables_container .ui.input > input:focus::-moz-placeholder {\n  color: rgba(115, 115, 115, 0.87);\n}\n.gswpts_tables_container .ui.input.focus > input:-ms-input-placeholder,\n.gswpts_tables_container .ui.input > input:focus:-ms-input-placeholder {\n  color: rgba(115, 115, 115, 0.87);\n}\n.gswpts_tables_container .ui.input.error > input {\n  background-color: #fff6f6;\n  border-color: #e0b4b4;\n  color: #9f3a38;\n  box-shadow: none;\n}\n.gswpts_tables_container .ui.input.error > input::-webkit-input-placeholder {\n  color: #e7bdbc;\n}\n.gswpts_tables_container .ui.input.error > input::-moz-placeholder {\n  color: #e7bdbc;\n}\n.gswpts_tables_container .ui.input.error > input:-ms-input-placeholder {\n  color: #e7bdbc !important;\n}\n.gswpts_tables_container .ui.input.error > input:focus::-webkit-input-placeholder {\n  color: #da9796;\n}\n.gswpts_tables_container .ui.input.error > input:focus::-moz-placeholder {\n  color: #da9796;\n}\n.gswpts_tables_container .ui.input.error > input:focus:-ms-input-placeholder {\n  color: #da9796 !important;\n}\n.gswpts_tables_container .ui.transparent.input > input {\n  border-color: transparent !important;\n  background-color: transparent !important;\n  padding: 0em !important;\n  box-shadow: none !important;\n  border-radius: 0px !important;\n}\n.gswpts_tables_container .ui.transparent.icon.input > i.icon {\n  width: 1.1em;\n}\n.gswpts_tables_container .ui.transparent.icon.input > input {\n  padding-left: 0em !important;\n  padding-right: 2em !important;\n}\n.gswpts_tables_container .ui.transparent[class*=\"left icon\"].input > input {\n  padding-left: 2em !important;\n  padding-right: 0em !important;\n}\n.gswpts_tables_container .ui.transparent.inverted.input {\n  color: #ffffff;\n}\n.gswpts_tables_container .ui.transparent.inverted.input > input {\n  color: inherit;\n}\n.gswpts_tables_container .ui.transparent.inverted.input > input::-webkit-input-placeholder {\n  color: rgba(255, 255, 255, 0.5);\n}\n.gswpts_tables_container .ui.transparent.inverted.input > input::-moz-placeholder {\n  color: rgba(255, 255, 255, 0.5);\n}\n.gswpts_tables_container .ui.transparent.inverted.input > input:-ms-input-placeholder {\n  color: rgba(255, 255, 255, 0.5);\n}\n.gswpts_tables_container .ui.icon.input > i.icon {\n  cursor: default;\n  position: absolute;\n  line-height: 1;\n  text-align: center;\n  top: 0px;\n  right: 0px;\n  margin: 0em;\n  height: 100%;\n  width: 2.67142857em;\n  opacity: 0.5;\n  border-radius: 0em 0.28571429rem 0.28571429rem 0em;\n  transition: opacity 0.3s ease;\n}\n.gswpts_tables_container .ui.icon.input > i.icon:not(.link) {\n  pointer-events: none;\n}\n.gswpts_tables_container .ui.icon.input > input {\n  padding-right: 2.67142857em !important;\n}\n.gswpts_tables_container .ui.icon.input > i.icon:before,\n.gswpts_tables_container .ui.icon.input > i.icon:after {\n  left: 0;\n  position: absolute;\n  text-align: center;\n  top: 50%;\n  width: 100%;\n  margin-top: -0.5em;\n}\n.gswpts_tables_container .ui.icon.input > i.link.icon {\n  cursor: pointer;\n}\n.gswpts_tables_container .ui.icon.input > i.circular.icon {\n  top: 0.35em;\n  right: 0.5em;\n}\n.gswpts_tables_container .ui[class*=\"left icon\"].input > i.icon {\n  right: auto;\n  left: 1px;\n  border-radius: 0.28571429rem 0em 0em 0.28571429rem;\n}\n.gswpts_tables_container .ui[class*=\"left icon\"].input > i.circular.icon {\n  right: auto;\n  left: 0.5em;\n}\n.gswpts_tables_container .ui[class*=\"left icon\"].input > input {\n  padding-left: 2.67142857em !important;\n  padding-right: 1em !important;\n}\n.gswpts_tables_container .ui.icon.input > input:focus ~ i.icon {\n  opacity: 1;\n}\n.gswpts_tables_container .ui.labeled.input > .label {\n  flex: 0 0 auto;\n  margin: 0;\n  font-size: 1em;\n}\n.gswpts_tables_container .ui.labeled.input > .label:not(.corner) {\n  padding-top: 0.78571429em;\n  padding-bottom: 0.78571429em;\n}\n.gswpts_tables_container .ui.labeled.input:not([class*=\"corner labeled\"]) .label:first-child {\n  border-top-right-radius: 0px;\n  border-bottom-right-radius: 0px;\n}\n.gswpts_tables_container .ui.labeled.input:not([class*=\"corner labeled\"]) .label:first-child + input {\n  border-top-left-radius: 0px;\n  border-bottom-left-radius: 0px;\n  border-left-color: transparent;\n}\n.gswpts_tables_container .ui.labeled.input:not([class*=\"corner labeled\"]) .label:first-child + input:focus {\n  border-left-color: #85b7d9;\n}\n.gswpts_tables_container .ui[class*=\"right labeled\"].input > input {\n  border-top-right-radius: 0px !important;\n  border-bottom-right-radius: 0px !important;\n  border-right-color: transparent !important;\n}\n.gswpts_tables_container .ui[class*=\"right labeled\"].input > input + .label {\n  border-top-left-radius: 0px;\n  border-bottom-left-radius: 0px;\n}\n.gswpts_tables_container .ui[class*=\"right labeled\"].input > input:focus {\n  border-right-color: #85b7d9 !important;\n}\n.gswpts_tables_container .ui.labeled.input .corner.label {\n  top: 1px;\n  right: 1px;\n  font-size: 0.64285714em;\n  border-radius: 0em 0.28571429rem 0em 0em;\n}\n.gswpts_tables_container .ui[class*=\"corner labeled\"]:not([class*=\"left corner labeled\"]).labeled.input > input {\n  padding-right: 2.5em !important;\n}\n.gswpts_tables_container .ui[class*=\"corner labeled\"].icon.input:not([class*=\"left corner labeled\"]) > input {\n  padding-right: 3.25em !important;\n}\n.gswpts_tables_container .ui[class*=\"corner labeled\"].icon.input:not([class*=\"left corner labeled\"]) > .icon {\n  margin-right: 1.25em;\n}\n.gswpts_tables_container .ui[class*=\"left corner labeled\"].labeled.input > input {\n  padding-left: 2.5em !important;\n}\n.gswpts_tables_container .ui[class*=\"left corner labeled\"].icon.input > input {\n  padding-left: 3.25em !important;\n}\n.gswpts_tables_container .ui[class*=\"left corner labeled\"].icon.input > .icon {\n  margin-left: 1.25em;\n}\n.gswpts_tables_container .ui.input > .ui.corner.label {\n  top: 1px;\n  right: 1px;\n}\n.gswpts_tables_container .ui.input > .ui.left.corner.label {\n  right: auto;\n  left: 1px;\n}\n.gswpts_tables_container .ui.action.input > .button,\n.gswpts_tables_container .ui.action.input > .buttons {\n  display: flex;\n  align-items: center;\n  flex: 0 0 auto;\n}\n.gswpts_tables_container .ui.action.input > .button,\n.gswpts_tables_container .ui.action.input > .buttons > .button {\n  padding-top: 0.78571429em;\n  padding-bottom: 0.78571429em;\n  margin: 0;\n}\n.gswpts_tables_container .ui.action.input:not([class*=\"left action\"]) > input {\n  border-top-right-radius: 0px !important;\n  border-bottom-right-radius: 0px !important;\n  border-right-color: transparent !important;\n}\n.gswpts_tables_container .ui.action.input:not([class*=\"left action\"]) > .dropdown:not(:first-child),\n.gswpts_tables_container .ui.action.input:not([class*=\"left action\"]) > .button:not(:first-child),\n.gswpts_tables_container .ui.action.input:not([class*=\"left action\"]) > .buttons:not(:first-child) > .button {\n  border-radius: 0px;\n}\n.gswpts_tables_container .ui.action.input:not([class*=\"left action\"]) > .dropdown:last-child,\n.gswpts_tables_container .ui.action.input:not([class*=\"left action\"]) > .button:last-child,\n.gswpts_tables_container .ui.action.input:not([class*=\"left action\"]) > .buttons:last-child > .button {\n  border-radius: 0px 0.28571429rem 0.28571429rem 0px;\n}\n.gswpts_tables_container .ui.action.input:not([class*=\"left action\"]) > input:focus {\n  border-right-color: #85b7d9 !important;\n}\n.gswpts_tables_container .ui[class*=\"left action\"].input > input {\n  border-top-left-radius: 0px !important;\n  border-bottom-left-radius: 0px !important;\n  border-left-color: transparent !important;\n}\n.gswpts_tables_container .ui[class*=\"left action\"].input > .dropdown,\n.gswpts_tables_container .ui[class*=\"left action\"].input > .button,\n.gswpts_tables_container .ui[class*=\"left action\"].input > .buttons > .button {\n  border-radius: 0px;\n}\n.gswpts_tables_container .ui[class*=\"left action\"].input > .dropdown:first-child,\n.gswpts_tables_container .ui[class*=\"left action\"].input > .button:first-child,\n.gswpts_tables_container .ui[class*=\"left action\"].input > .buttons:first-child > .button {\n  border-radius: 0.28571429rem 0px 0px 0.28571429rem;\n}\n.gswpts_tables_container .ui[class*=\"left action\"].input > input:focus {\n  border-left-color: #85b7d9 !important;\n}\n.gswpts_tables_container .ui.inverted.input > input {\n  border: none;\n}\n.gswpts_tables_container .ui.fluid.input {\n  display: flex;\n}\n.gswpts_tables_container .ui.fluid.input > input {\n  width: 0px !important;\n}\n.gswpts_tables_container .ui.mini.input {\n  font-size: 0.78571429em;\n}\n.gswpts_tables_container .ui.small.input {\n  font-size: 0.92857143em;\n}\n.gswpts_tables_container .ui.input {\n  font-size: 1em;\n}\n.gswpts_tables_container .ui.large.input {\n  font-size: 1.14285714em;\n}\n.gswpts_tables_container .ui.big.input {\n  font-size: 1.28571429em;\n}\n.gswpts_tables_container .ui.huge.input {\n  font-size: 1.42857143em;\n}\n.gswpts_tables_container .ui.massive.input {\n  font-size: 1.71428571em;\n}\n.gswpts_tables_container table.dataTable.table {\n  margin: 0;\n}\n.gswpts_tables_container table.dataTable.table thead th,\n.gswpts_tables_container table.dataTable.table thead td {\n  position: relative;\n}\n.gswpts_tables_container table.dataTable.table thead th.sorting,\n.gswpts_tables_container table.dataTable.table thead th.sorting_asc,\n.gswpts_tables_container table.dataTable.table thead th.sorting_desc,\n.gswpts_tables_container table.dataTable.table thead td.sorting,\n.gswpts_tables_container table.dataTable.table thead td.sorting_asc,\n.gswpts_tables_container table.dataTable.table thead td.sorting_desc {\n  padding-right: 30px;\n}\n.gswpts_tables_container table.dataTable.table thead th.sorting:after,\n.gswpts_tables_container table.dataTable.table thead th.sorting_asc:after,\n.gswpts_tables_container table.dataTable.table thead th.sorting_desc:after,\n.gswpts_tables_container table.dataTable.table thead td.sorting:after,\n.gswpts_tables_container table.dataTable.table thead td.sorting_asc:after,\n.gswpts_tables_container table.dataTable.table thead td.sorting_desc:after {\n  position: absolute;\n  right: 8px;\n  display: block;\n  font-family: Icons;\n  top: 50%;\n  transform: translateY(-50%);\n}\n.gswpts_tables_container table.dataTable.table thead th.sorting:after,\n.gswpts_tables_container table.dataTable.table thead td.sorting:after {\n  content: \" ⇅\";\n  color: rgba(93,91,95,0.56078);\n  font-size: 0.8em;\n}\n.gswpts_tables_container table.dataTable.table thead th.sorting_asc:after,\n.gswpts_tables_container table.dataTable.table thead td.sorting_asc:after {\n  content: \" ▲\";\n  font-size: 0.9em;\n}\n.gswpts_tables_container table.dataTable.table thead th.sorting_desc:after,\n.gswpts_tables_container table.dataTable.table thead td.sorting_desc:after {\n  content: \" ▼\";\n  font-size: 0.9em;\n}\n.gswpts_tables_container table.dataTable.table thead th.sorting-icon-hidden::after,\n.gswpts_tables_container table.dataTable.table thead td.sorting-icon-hidden::after {\n  display: none;\n}\n.gswpts_tables_container table.dataTable.table thead th.sorting-icon-hidden.sorting_asc::after,\n.gswpts_tables_container table.dataTable.table thead td.sorting-icon-hidden.sorting_asc::after {\n  display: none;\n}\n.gswpts_tables_container table.dataTable.table thead th.sorting-icon-hidden.sorting_desc::after,\n.gswpts_tables_container table.dataTable.table thead td.sorting-icon-hidden.sorting_desc::after {\n  display: none;\n}\n.gswpts_tables_container table.dataTable.table td,\n.gswpts_tables_container table.dataTable.table th {\n  box-sizing: content-box;\n}\n.gswpts_tables_container table.dataTable.table td.dataTables_empty,\n.gswpts_tables_container table.dataTable.table th.dataTables_empty {\n  text-align: center;\n}\n.gswpts_tables_container table.dataTable.table.nowrap th,\n.gswpts_tables_container table.dataTable.table.nowrap td {\n  white-space: nowrap;\n}\n.gswpts_tables_container div.dataTables_wrapper div.dataTables_length select {\n  vertical-align: middle;\n  min-height: 2.7142em;\n}\n.gswpts_tables_container div.dataTables_wrapper div.dataTables_length .ui.selection.dropdown {\n  min-width: 0;\n}\n.gswpts_tables_container div.dataTables_wrapper div.dataTables_filter span.input {\n  margin-left: 0.5em;\n}\n.gswpts_tables_container div.dataTables_wrapper div.dataTables_info {\n  padding-top: 13px;\n  white-space: nowrap;\n}\n.gswpts_tables_container div.dataTables_wrapper div.dataTables_processing {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  width: 200px;\n  margin-left: -100px;\n  text-align: center;\n}\n.gswpts_tables_container div.dataTables_wrapper div.row.dt-table {\n  padding: 0;\n}\n.gswpts_tables_container div.dataTables_wrapper div.dataTables_scrollHead table.dataTable {\n  border-bottom-right-radius: 0;\n  border-bottom-left-radius: 0;\n  border-bottom: none;\n}\n.gswpts_tables_container div.dataTables_wrapper div.dataTables_scrollBody thead .sorting:after,\n.gswpts_tables_container div.dataTables_wrapper div.dataTables_scrollBody thead .sorting_asc:after,\n.gswpts_tables_container div.dataTables_wrapper div.dataTables_scrollBody thead .sorting_desc:after {\n  display: none;\n}\n.gswpts_tables_container div.dataTables_wrapper div.dataTables_scrollBody table.dataTable {\n  border-radius: 0;\n  border-top: none;\n  border-bottom-width: 0;\n}\n.gswpts_tables_container div.dataTables_wrapper div.dataTables_scrollBody table.dataTable.no-footer {\n  border-bottom-width: 1px;\n}\n.gswpts_tables_container div.dataTables_wrapper div.dataTables_scrollFoot table.dataTable {\n  border-top-right-radius: 0;\n  border-top-left-radius: 0;\n  border-top: none;\n}\n.gswpts_tables_container .ui.loader {\n  display: none;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  margin: 0px;\n  text-align: center;\n  z-index: 1000;\n  transform: translateX(-50%) translateY(-50%);\n}\n.gswpts_tables_container .ui.loader:before {\n  position: absolute;\n  content: \"\";\n  top: 0%;\n  left: 50%;\n  width: 100%;\n  height: 100%;\n  border-radius: 500rem;\n  border: 0.2em solid rgba(0, 0, 0, 0.1);\n}\n.gswpts_tables_container .ui.loader:after {\n  position: absolute;\n  content: \"\";\n  top: 0%;\n  left: 50%;\n  width: 100%;\n  height: 100%;\n  -webkit-animation: loader 0.6s linear;\n  animation: loader 0.6s linear;\n  -webkit-animation-iteration-count: infinite;\n  animation-iteration-count: infinite;\n  border-radius: 500rem;\n  border-color: #767676 transparent transparent;\n  border-style: solid;\n  border-width: 0.2em;\n  box-shadow: 0px 0px 0px 1px transparent;\n}\n@-webkit-keyframes loader {\n  from {\n    transform: rotate(0deg);\n  }\n  to {\n    transform: rotate(360deg);\n  }\n}\n@keyframes loader {\n  from {\n    transform: rotate(0deg);\n  }\n  to {\n    transform: rotate(360deg);\n  }\n}\n.gswpts_tables_container .ui.mini.loader:before,\n.gswpts_tables_container .ui.mini.loader:after {\n  width: 1rem;\n  height: 1rem;\n  margin: 0em 0em 0em -0.5rem;\n}\n.gswpts_tables_container .ui.tiny.loader:before,\n.gswpts_tables_container .ui.tiny.loader:after {\n  width: 1.14285714rem;\n  height: 1.14285714rem;\n  margin: 0em 0em 0em -0.57142857rem;\n}\n.gswpts_tables_container .ui.small.loader:before,\n.gswpts_tables_container .ui.small.loader:after {\n  width: 1.71428571rem;\n  height: 1.71428571rem;\n  margin: 0em 0em 0em -0.85714286rem;\n}\n.gswpts_tables_container .ui.loader:before,\n.gswpts_tables_container .ui.loader:after {\n  width: 2.28571429rem;\n  height: 2.28571429rem;\n  margin: 0em 0em 0em -1.14285714rem;\n}\n.gswpts_tables_container .ui.large.loader:before,\n.gswpts_tables_container .ui.large.loader:after {\n  width: 3.42857143rem;\n  height: 3.42857143rem;\n  margin: 0em 0em 0em -1.71428571rem;\n}\n.gswpts_tables_container .ui.big.loader:before,\n.gswpts_tables_container .ui.big.loader:after {\n  width: 3.71428571rem;\n  height: 3.71428571rem;\n  margin: 0em 0em 0em -1.85714286rem;\n}\n.gswpts_tables_container .ui.huge.loader:before,\n.gswpts_tables_container .ui.huge.loader:after {\n  width: 4.14285714rem;\n  height: 4.14285714rem;\n  margin: 0em 0em 0em -2.07142857rem;\n}\n.gswpts_tables_container .ui.massive.loader:before,\n.gswpts_tables_container .ui.massive.loader:after {\n  width: 4.57142857rem;\n  height: 4.57142857rem;\n  margin: 0em 0em 0em -2.28571429rem;\n}\n.gswpts_tables_container .ui.dimmer .loader {\n  display: block;\n}\n.gswpts_tables_container .ui.dimmer .ui.loader {\n  color: rgba(255, 255, 255, 0.9);\n}\n.gswpts_tables_container .ui.dimmer .ui.loader:before {\n  border-color: rgba(255, 255, 255, 0.15);\n}\n.gswpts_tables_container .ui.dimmer .ui.loader:after {\n  border-color: #ffffff transparent transparent;\n}\n.gswpts_tables_container .ui.inverted.dimmer .ui.loader {\n  color: rgba(0, 0, 0, 0.87);\n}\n.gswpts_tables_container .ui.inverted.dimmer .ui.loader:before {\n  border-color: rgba(0, 0, 0, 0.1);\n}\n.gswpts_tables_container .ui.inverted.dimmer .ui.loader:after {\n  border-color: #767676 transparent transparent;\n}\n.gswpts_tables_container .ui.text.loader {\n  width: auto !important;\n  height: auto !important;\n  text-align: center;\n  font-style: normal;\n}\n.gswpts_tables_container .ui.indeterminate.loader:after {\n  animation-direction: reverse;\n  -webkit-animation-duration: 1.2s;\n  animation-duration: 1.2s;\n}\n.gswpts_tables_container .ui.loader.active,\n.gswpts_tables_container .ui.loader.visible {\n  display: block;\n}\n.gswpts_tables_container .ui.loader.disabled,\n.gswpts_tables_container .ui.loader.hidden {\n  display: none;\n}\n.gswpts_tables_container .ui.inverted.dimmer .ui.mini.loader,\n.gswpts_tables_container .ui.mini.loader {\n  width: 1rem;\n  height: 1rem;\n  font-size: 0.78571429em;\n}\n.gswpts_tables_container .ui.inverted.dimmer .ui.tiny.loader,\n.gswpts_tables_container .ui.tiny.loader {\n  width: 1.14285714rem;\n  height: 1.14285714rem;\n  font-size: 0.85714286em;\n}\n.gswpts_tables_container .ui.inverted.dimmer .ui.small.loader,\n.gswpts_tables_container .ui.small.loader {\n  width: 1.71428571rem;\n  height: 1.71428571rem;\n  font-size: 0.92857143em;\n}\n.gswpts_tables_container .ui.inverted.dimmer .ui.loader,\n.gswpts_tables_container .ui.loader {\n  width: 2.28571429rem;\n  height: 2.28571429rem;\n  font-size: 1em;\n}\n.gswpts_tables_container .ui.inverted.dimmer .ui.large.loader,\n.gswpts_tables_container .ui.large.loader {\n  width: 3.42857143rem;\n  height: 3.42857143rem;\n  font-size: 1.14285714em;\n}\n.gswpts_tables_container .ui.inverted.dimmer .ui.big.loader,\n.gswpts_tables_container .ui.big.loader {\n  width: 3.71428571rem;\n  height: 3.71428571rem;\n  font-size: 1.28571429em;\n}\n.gswpts_tables_container .ui.inverted.dimmer .ui.huge.loader,\n.gswpts_tables_container .ui.huge.loader {\n  width: 4.14285714rem;\n  height: 4.14285714rem;\n  font-size: 1.42857143em;\n}\n.gswpts_tables_container .ui.inverted.dimmer .ui.massive.loader,\n.gswpts_tables_container .ui.massive.loader {\n  width: 4.57142857rem;\n  height: 4.57142857rem;\n  font-size: 1.71428571em;\n}\n.gswpts_tables_container .ui.mini.text.loader {\n  min-width: 1rem;\n  padding-top: 1.78571429rem;\n}\n.gswpts_tables_container .ui.tiny.text.loader {\n  min-width: 1.14285714rem;\n  padding-top: 1.92857143rem;\n}\n.gswpts_tables_container .ui.small.text.loader {\n  min-width: 1.71428571rem;\n  padding-top: 2.5rem;\n}\n.gswpts_tables_container .ui.text.loader {\n  min-width: 2.28571429rem;\n  padding-top: 3.07142857rem;\n}\n.gswpts_tables_container .ui.large.text.loader {\n  min-width: 3.42857143rem;\n  padding-top: 4.21428571rem;\n}\n.gswpts_tables_container .ui.big.text.loader {\n  min-width: 3.71428571rem;\n  padding-top: 4.5rem;\n}\n.gswpts_tables_container .ui.huge.text.loader {\n  min-width: 4.14285714rem;\n  padding-top: 4.92857143rem;\n}\n.gswpts_tables_container .ui.massive.text.loader {\n  min-width: 4.57142857rem;\n  padding-top: 5.35714286rem;\n}\n.gswpts_tables_container .ui.inverted.loader {\n  color: rgba(255, 255, 255, 0.9);\n}\n.gswpts_tables_container .ui.inverted.loader:before {\n  border-color: rgba(255, 255, 255, 0.15);\n}\n.gswpts_tables_container .ui.inverted.loader:after {\n  border-top-color: #ffffff;\n}\n.gswpts_tables_container .ui.inline.loader {\n  position: relative;\n  vertical-align: middle;\n  margin: 0em;\n  left: 0em;\n  top: 0em;\n  transform: none;\n}\n.gswpts_tables_container .ui.inline.loader.active,\n.gswpts_tables_container .ui.inline.loader.visible {\n  display: inline-block;\n}\n.gswpts_tables_container .ui.centered.inline.loader.active,\n.gswpts_tables_container .ui.centered.inline.loader.visible {\n  display: block;\n  margin-left: auto;\n  margin-right: auto;\n}\n.gswpts_tables_container .gswpts_table_loader {\n  width: 100%;\n  min-height: 200px;\n}\n.gswpts_tables_container select {\n  width: 65px;\n  padding: 1px 2px;\n  border-radius: 5px;\n  border: 1px solid rgba(0,0,0,0.2) !important;\n  background: transparent !important;\n}\n.gswpts_tables_container .dt-buttons {\n  display: flex;\n  justify-content: flex-end;\n  margin-top: 5px;\n  gap: 10px;\n}\n.gswpts_tables_container .dt-buttons button,\n.gswpts_tables_container .dt-buttons a {\n  font-size: 13px !important;\n  margin: 0 6px;\n  margin-right: 5px;\n}\n.gswpts_tables_container .dt-buttons button img,\n.gswpts_tables_container .dt-buttons a img {\n  transition: filter 0.3s ease;\n}\n.gswpts_tables_container .dt-buttons .json_btn:hover img {\n  filter: invert(42%) sepia(96%) saturate(1808%) hue-rotate(192deg) brightness(99%) contrast(101%);\n}\n.gswpts_tables_container .dt-buttons .csv_btn:hover img {\n  filter: invert(56%) sepia(88%) saturate(1486%) hue-rotate(141deg) brightness(94%) contrast(101%);\n}\n.gswpts_tables_container .dt-buttons .excel_btn:hover img {\n  filter: invert(48%) sepia(79%) saturate(2476%) hue-rotate(133deg) brightness(91%) contrast(97%);\n}\n.gswpts_tables_container .dt-buttons .print_btn:hover img {\n  filter: invert(40%) sepia(97%) saturate(1809%) hue-rotate(201deg) brightness(96%) contrast(96%);\n}\n.gswpts_tables_container .dt-buttons .copy_btn:hover img {\n  filter: invert(26%) sepia(96%) saturate(3668%) hue-rotate(265deg) brightness(85%) contrast(107%);\n}\n.gswpts_tables_container .dt-buttons .pdf_btn:hover img {\n  filter: invert(43%) sepia(84%) saturate(1644%) hue-rotate(347deg) brightness(95%) contrast(91%);\n}\n.gswpts_tables_container .dt-buttons span {\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  height: 21px;\n  white-space: nowrap;\n}\n.gswpts_tables_container .dt-buttons .export_btns {\n  display: none;\n}\n.gswpts_tables_container table {\n  width: 100%;\n}\n.gswpts_tables_container .filtering_input {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  margin: 15px 0 25px 0;\n}\n.gswpts_tables_container .filtering_input #create_tables_length {\n  margin-right: auto;\n}\n.gswpts_tables_container .filtering_input #create_tables_filter {\n  margin-left: auto;\n}\n.gswpts_tables_container .filtering_input .searchBypress {\n  display: flex;\n  gap: 10px;\n}\n.gswpts_tables_container .filtering_input .searchBypress button.ui.button.search-by-press {\n  padding: 10px 15px;\n}\n.gswpts_tables_container .filtering_input input {\n  background: transparent !important;\n}\n@media screen and (max-width: 540px) {\n  .gswpts_tables_container .filtering_input {\n    align-items: flex-start !important;\n  }\n}\n.gswpts_tables_container .bottom_options {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  margin-top: 20px;\n}\n.gswpts_tables_container .bottom_options .dataTables_info {\n  padding-top: 0 !important;\n  margin-right: auto;\n}\n.gswpts_tables_container .gswpts_tables_content table {\n  width: 100%;\n}\n.gswpts_tables_container .gswpts_tables_content .filtering_input {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  margin: 15px 0 25px 0;\n}\n.gswpts_tables_container .gswpts_tables_content .filtering_input #create_tables_length {\n  margin-right: auto;\n}\n.gswpts_tables_container .gswpts_tables_content .filtering_input #create_tables_filter {\n  margin-left: auto;\n}\n.gswpts_tables_container .gswpts_tables_content .filtering_input input {\n  background: transparent !important;\n}\n.gswpts_tables_container .gswpts_tables_content input.flexsync-checkbox {\n  cursor: none;\n  pointer-events: none;\n}\n.gswpts_tables_container .gswpts_tables_content .bottom_options {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  margin-top: 10px;\n  /* .default-pagination-active,\n  .default-preset-pagination-active {\n      .pagination.menu {\n          padding: 0 !important;\n          font-size: 14px;\n          background: transparent !important;\n          display: flex;\n          justify-content: center;\n          align-items: center;\n          flex-wrap: wrap;\n          border: none;\n          margin: 0 5px;\n\n          &>* {\n              padding: 9px 16px;\n              border: 1px solid #a9a1a13d;\n\n              &:first-child {\n                  border-radius: 0.28571429rem 0px 0px 0.28571429rem;\n              }\n\n              &:last-child {\n                  border-radius: 0px 0.28571429rem 0.28571429rem 0px 0px;\n              }\n\n              font-weight: bold;\n              color: rgba(56, 13, 13, 0.787);\n\n              &:hover {\n                  background-color: rgba(0, 0, 0, 0.03);\n              }\n\n              @media screen and (max-width: 991px) {\n                  padding: 4px 12px !important;\n              }\n\n              @media screen and (max-width: 770px) {\n                  padding: 2px 9px !important;\n              }\n\n              @media screen and (max-width: 420px) {\n                  padding: 1px 6px !important;\n                  font-size: 12px;\n              }\n          }\n\n          a {\n              text-decoration: none;\n          }\n\n          .active {\n              // background-color: #b3b3b35c;\n              background-color: #2F80ED;\n              color: #fff;\n          }\n      }\n  } */\n  /* .modern-pagination-active,\n  .simple-pagination-active,\n  .tailwind-pagination-active,\n  .outlined-pagination-active {\n      .pagination.menu {\n          padding: 0 !important;\n          font-size: 14px;\n          background: transparent !important;\n          display: flex;\n          justify-content: center;\n          align-items: center;\n          flex-wrap: wrap;\n          border: none;\n          margin: 0 5px;\n\n          &>* {\n              padding: 9px 16px;\n\n              &:first-child {\n                  border-radius: 0.28571429rem 0px 0px 0.28571429rem;\n              }\n\n              &:last-child {\n                  border-radius: 0px 0.28571429rem 0.28571429rem 0px 0px;\n              }\n\n              font-weight: bold;\n              color: rgba(56, 13, 13, 0.787);\n\n              &:hover {\n                  background-color: rgba(0, 0, 0, 0.03);\n              }\n\n              @media screen and (max-width: 991px) {\n                  padding: 4px 12px !important;\n              }\n\n              @media screen and (max-width: 770px) {\n                  padding: 2px 9px !important;\n              }\n\n              @media screen and (max-width: 420px) {\n                  padding: 1px 6px !important;\n                  font-size: 12px;\n              }\n          }\n\n          a {\n              text-decoration: none;\n          }\n\n          .active {\n              background-color: #b3b3b35c;\n          }\n      }\n  } */\n}\n.gswpts_tables_container .gswpts_tables_content .bottom_options .dataTables_info {\n  padding-top: 0 !important;\n  margin-right: auto;\n}\n.gswpts_tables_container .gswpts_tables_content .bottom_options #create_tables_paginate {\n  margin-left: auto;\n  padding: 0 5px;\n}\n@media screen and (max-width: 540px) {\n  .gswpts_tables_container .dt-buttons {\n    display: flex;\n    flex-wrap: wrap;\n    justify-content: space-between;\n  }\n  .gswpts_tables_container .dt-buttons button {\n    font-size: 10px !important;\n    margin: 10px 0;\n  }\n  .gswpts_tables_container .filtering_input {\n    flex-direction: column !important;\n    align-items: flex-start !important;\n    justify-content: center !important;\n  }\n  .gswpts_tables_container .filtering_input div {\n    margin: 10px 0 !important;\n    padding: 0 !important;\n  }\n  .gswpts_tables_container .gswpts_tables_content .dataTables_wrapper .filtering_input {\n    align-items: flex-start !important;\n  }\n}\n@media screen and (max-width: 700px) {\n  .gswpts_tables_container .dt-buttons {\n    display: flex;\n    flex-wrap: wrap;\n    justify-content: space-between;\n  }\n  .gswpts_tables_container .dt-buttons button {\n    font-size: 12px !important;\n    margin: 10px 0;\n  }\n  .gswpts_tables_container .bottom_options {\n    flex-direction: column !important;\n    justify-content: center !important;\n    align-items: center !important;\n  }\n  .gswpts_tables_container .bottom_options .dataTables_info {\n    padding-top: 0 !important;\n    margin: 0 !important;\n  }\n  .gswpts_tables_container .bottom_options #create_tables_paginate {\n    margin: 0 !important;\n    margin-top: 8px !important;\n  }\n}\n@media screen and (max-width: 768px) {\n  .gswpts_tables_container.collapse_style table .expanded_style {\n    white-space: normal;\n  }\n}\n\n/* .gswpts_tables_container,\n.gswpts_tables_container {\n    .gswpts_tables {\n        .hidden-row {\n            display: none;\n        }\n\n        .hidden-cell {\n            .cell_div {\n                visibility: hidden;\n            }\n        }\n    }\n} */\n/* .gswpts_tables_container,\n.gswpts_tables_container {\n    .gswpts_tables {\n        .hidden-row {\n            display: none;\n        }\n\n        .hidden-cell {\n            .cell_div {\n                visibility: hidden;\n            }\n        }\n    }\n\n    // Use to hide row and cell in mobile \n    @media screen and (max-width: 540px) {\n\n        .gswpts_rows.hidden-row-mobile {\n            display: none;\n        }\n\n        .gswpts_rows.hidden-cell-mobile {\n            .cell_div {\n                visibility: hidden;\n            }\n        }\n    }\n} */\n@media screen and (min-width: 541px) {\n  .gswpts_tables_container .gswpts_tables .hidden-row,\n.gswpts_tables_container .gswpts_tables .hidden-row {\n    display: none;\n  }\n  .gswpts_tables_container .gswpts_tables .hidden-cell .cell_div,\n.gswpts_tables_container .gswpts_tables .hidden-cell .cell_div {\n    visibility: hidden;\n  }\n}\n@media screen and (max-width: 540px) {\n  .gswpts_tables_container .gswpts_tables .hidden-row-mobile,\n.gswpts_tables_container .gswpts_tables .hidden-row-mobile {\n    display: none;\n  }\n  .gswpts_tables_container .gswpts_tables .gswpts_rows.hidden-row-mobile,\n.gswpts_tables_container .gswpts_tables .gswpts_rows.hidden-row-mobile {\n    display: none;\n  }\n  .gswpts_tables_container .gswpts_tables tr.gswpts_rows.hidden-row-mobile,\n.gswpts_tables_container .gswpts_tables tr.gswpts_rows.hidden-row-mobile {\n    display: none;\n  }\n  .gswpts_tables_container .gswpts_tables .hidden-cell-mobile .cell_div,\n.gswpts_tables_container .gswpts_tables .hidden-cell-mobile .cell_div {\n    visibility: hidden;\n  }\n  .gswpts_tables_container .gswpts_tables .gswpts_rows td.hidden-cell-mobile .cell_div,\n.gswpts_tables_container .gswpts_tables .gswpts_rows td.hidden-cell-mobile .cell_div {\n    visibility: hidden;\n  }\n}\n\n.swptls-table-title.hidden {\n  display: none;\n}\n\ntable.dataTable.table.gswpts_tables {\n  width: 100%;\n}\ntable.dataTable.table.gswpts_tables th,\ntable.dataTable.table.gswpts_tables td {\n  max-width: 200px;\n  word-wrap: break-word;\n  min-height: 25px;\n}\ntable.dataTable.table.gswpts_tables th img,\ntable.dataTable.table.gswpts_tables td img {\n  max-width: unset;\n}\ntable.dataTable.table.gswpts_tables .expanded_style {\n  max-width: unset;\n  word-wrap: unset;\n  white-space: nowrap;\n  overflow-x: unset;\n}\ntable.dataTable.table.gswpts_tables .clip_style {\n  max-width: 200px;\n  word-wrap: unset;\n  white-space: nowrap;\n  overflow-x: overlay;\n  height: 30px;\n}\ntable.dataTable.table.gswpts_tables .wrap_style {\n  max-width: 200px;\n  word-wrap: break-word;\n  white-space: normal;\n  overflow-x: unset;\n}\ntable.dataTable.table.gswpts_tables .wrap_style img {\n  max-width: 100%;\n}\ntable.dataTable.table.gswpts_tables th:focus {\n  outline: none;\n}\n\n.pdf_btn.button.dt-button:hover img,\n.gswpts_tables_container .ui.inverted.red.button.pdf_btn:hover img {\n  filter: brightness(0);\n}\n\n.pdf_btn.button:hover img {\n  filter: brightness(0);\n}\n\n.gswpts_default-style.gswpts_default-style {\n  --header-bg-color: #ffffff;\n  --header-text-color: #000000;\n  --header-text-alignment: left;\n  --body-bg-color: #ffffff;\n  --body-text-color-col-1: #333333;\n  --body-text-color-rest: #6B7280;\n  --border-color: #e0e5f6;\n  --pagination-colors: #828282;\n}\n.gswpts_default-style.gswpts_default-style th.thead-item {\n  text-align: left;\n}\n.gswpts_default-style.gswpts_default-style th,\n.gswpts_default-style.gswpts_default-style td {\n  border: none;\n  border-bottom: 2px solid var(--border-color);\n  background-color: var(--body-bg-color);\n}\n.gswpts_default-style.gswpts_default-style table.ui.celled.display {\n  border: none;\n}\n.gswpts_default-style.gswpts_default-style .sorting.sorting.sorting::after {\n  color: #a1a1a1;\n}\n@media screen and (max-width: 768px) {\n  .gswpts_default-style.gswpts_default-style.collapse_style .sorting.sorting.sorting::after {\n    margin-right: 8px;\n  }\n}\n.gswpts_default-style.gswpts_default-style #create_tables_paginate {\n  margin-left: auto;\n  padding: 0 5px;\n}\n.gswpts_default-style.gswpts_default-style .default-pagination-active .pagination.menu {\n  padding: 0 !important;\n  font-size: 14px;\n  background: transparent !important;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  flex-wrap: wrap;\n  border: none;\n  margin: 0 5px;\n}\n.gswpts_default-style.gswpts_default-style .default-pagination-active .pagination.menu > *:first-child {\n  border-radius: 0.28571429rem 0px 0px 0.28571429rem;\n}\n.gswpts_default-style.gswpts_default-style .default-pagination-active .pagination.menu > *:last-child {\n  border-radius: 0px 0.28571429rem 0.28571429rem 0px 0px;\n}\n.gswpts_default-style.gswpts_default-style .default-pagination-active .pagination.menu > *:hover {\n  background-color: rgba(0, 0, 0, 0.03);\n}\n@media screen and (max-width: 991px) {\n  .gswpts_default-style.gswpts_default-style .default-pagination-active .pagination.menu > * {\n    padding: 4px 12px !important;\n  }\n}\n@media screen and (max-width: 770px) {\n  .gswpts_default-style.gswpts_default-style .default-pagination-active .pagination.menu > * {\n    padding: 1px 9px !important;\n  }\n}\n@media screen and (max-width: 420px) {\n  .gswpts_default-style.gswpts_default-style .default-pagination-active .pagination.menu > * {\n    padding: 1px 6px !important;\n    font-size: 12px;\n  }\n}\n.gswpts_default-style.gswpts_default-style .default-pagination-active .pagination.menu a {\n  text-decoration: none;\n}\n.gswpts_default-style.gswpts_default-style .default-pagination-active .pagination.menu .active {\n  background-color: var(--pagination-colors);\n  color: #ffffff;\n}\n.gswpts_default-style.gswpts_default-style .default-pagination-active .paginate_button,\n.gswpts_default-style.gswpts_default-style .default-pagination-active .paginate_button.disabled,\n.gswpts_default-style.gswpts_default-style .default-pagination-active .ellipsis {\n  font-size: 14px;\n  border: none;\n  margin: 0;\n  padding: 9px 16px;\n  font-weight: bold;\n  color: #828282;\n  background: transparent;\n  border: 1px solid #E0E0E0;\n  text-decoration: none;\n  border-color: rgba(179, 179, 179, 0.3607843137);\n}\n.gswpts_default-style.gswpts_default-style .default-pagination-active .paginate_button:hover,\n.gswpts_default-style.gswpts_default-style .default-pagination-active .paginate_button.disabled:hover,\n.gswpts_default-style.gswpts_default-style .default-pagination-active .ellipsis:hover {\n  background-color: rgba(0, 0, 0, 0.03);\n  border-color: rgba(179,179,179,0.36078);\n  color: rgba(56, 13, 13, 0.787) !important;\n}\n@media screen and (max-width: 770px) {\n  .gswpts_default-style.gswpts_default-style .default-pagination-active .paginate_button,\n.gswpts_default-style.gswpts_default-style .default-pagination-active .paginate_button.disabled,\n.gswpts_default-style.gswpts_default-style .default-pagination-active .ellipsis {\n    padding: 6px 9px !important;\n  }\n}\n@media screen and (max-width: 420px) {\n  .gswpts_default-style.gswpts_default-style .default-pagination-active .paginate_button,\n.gswpts_default-style.gswpts_default-style .default-pagination-active .paginate_button.disabled,\n.gswpts_default-style.gswpts_default-style .default-pagination-active .ellipsis {\n    padding: 3px 6px !important;\n    font-size: 12px;\n  }\n}\n.gswpts_default-style.gswpts_default-style .paginate_button.item:nth-child(n+5):not(.next):not(.active):not(.disabled):not(:nth-last-child(-n+2)) {\n  display: none;\n}\n\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 {\n  --header-bg-color: #000;\n  --header-text-color: #ffffff;\n  --body-bg-color: #000;\n  --body-text-color: #ffffff;\n  --hover-bg-color: #504949;\n  --pagination-colors: #000;\n}\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 table thead th,\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 table tbody tr td {\n  background-color: var(--header-bg-color);\n  color: var(--header-text-color);\n  border: none;\n}\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 table tbody tr td {\n  background-color: var(--body-bg-color);\n  color: var(--body-text-color);\n}\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 table th.thead-item.expanded_style {\n  text-align: left;\n}\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 table thead th {\n  border: none;\n}\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 table thead tr:hover td,\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 table thead tr:hover th,\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 table tbody tr:hover td,\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 table tbody tr:hover th {\n  background-color: var(--hover-bg-color);\n}\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 table a {\n  color: orange;\n}\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 table a:hover {\n  color: #2ecc40;\n}\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 table .sorting.sorting.sorting::after {\n  color: #fff;\n}\n@media screen and (max-width: 768px) {\n  .gswpts_style-4.gswpts_style-4.gswpts_style-4.collapse_style .sorting.sorting.sorting::after {\n    margin-right: 8px;\n  }\n}\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 .simple-pagination-active .pagination.menu {\n  padding: 0 !important;\n  font-size: 14px;\n  background: transparent !important;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  flex-wrap: wrap;\n  border: none;\n  margin: 0 5px;\n}\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 .simple-pagination-active .pagination.menu > *:hover {\n  background-color: rgba(0, 0, 0, 0.03);\n}\n@media screen and (max-width: 991px) {\n  .gswpts_style-4.gswpts_style-4.gswpts_style-4 .simple-pagination-active .pagination.menu > * {\n    padding: 4px 12px !important;\n  }\n}\n@media screen and (max-width: 770px) {\n  .gswpts_style-4.gswpts_style-4.gswpts_style-4 .simple-pagination-active .pagination.menu > * {\n    padding: 1px 9px !important;\n  }\n}\n@media screen and (max-width: 420px) {\n  .gswpts_style-4.gswpts_style-4.gswpts_style-4 .simple-pagination-active .pagination.menu > * {\n    padding: 1px 6px !important;\n    font-size: 12px;\n  }\n}\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 .simple-pagination-active .pagination.menu a {\n  text-decoration: none;\n}\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 .simple-pagination-active .pagination.menu .active {\n  background-color: var(--pagination-colors);\n  color: #ffffff;\n}\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 .simple-pagination-active .paginate_button,\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 .simple-pagination-active .paginate_button.disabled,\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 .simple-pagination-active .ellipsis {\n  font-size: 14px;\n  border: none;\n  margin: 0;\n  padding: 9px 16px;\n  font-weight: bold;\n}\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 .simple-pagination-active .paginate_button:hover,\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 .simple-pagination-active .paginate_button.disabled:hover,\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 .simple-pagination-active .ellipsis:hover {\n  background-color: rgba(0, 0, 0, 0.03);\n  border-color: rgba(179,179,179,0.36078);\n  color: rgba(56, 13, 13, 0.787) !important;\n}\n@media screen and (max-width: 770px) {\n  .gswpts_style-4.gswpts_style-4.gswpts_style-4 .simple-pagination-active .paginate_button,\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 .simple-pagination-active .paginate_button.disabled,\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 .simple-pagination-active .ellipsis {\n    padding: 6px 9px !important;\n  }\n}\n@media screen and (max-width: 420px) {\n  .gswpts_style-4.gswpts_style-4.gswpts_style-4 .simple-pagination-active .paginate_button,\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 .simple-pagination-active .paginate_button.disabled,\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 .simple-pagination-active .ellipsis {\n    padding: 3px 6px !important;\n    font-size: 12px;\n  }\n}\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 #bottom_options #create_tables_paginate#create_tables_paginate {\n  margin-left: 40%;\n}\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 .paginate_button.item:nth-child(n+5):not(.next):not(.active):not(.disabled):not(:nth-last-child(-n+2)) {\n  display: none;\n}\n\n.gswpts_tables_container table {\n  border-collapse: collapse;\n  border-spacing: 0;\n}\n.gswpts_tables_container table td,\n.gswpts_tables_container table th {\n  padding: 0.7em 1em;\n}\n.gswpts_tables_container .swptls-backend-summary.swptls-key-takeaways,\n.gswpts_tables_container .swptls-backend-summary-display.swptls-key-takeaways {\n  background: #f8f9fa;\n  border: 1px solid #e9ecef;\n  border-radius: 8px;\n  padding: 20px;\n  margin: 20px 0;\n  box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);\n}\n.gswpts_tables_container .swptls-backend-summary.swptls-key-takeaways .swptls-summary-title,\n.gswpts_tables_container .swptls-backend-summary-display.swptls-key-takeaways .swptls-summary-title {\n  color: #2c3e50;\n  font-size: 1.2em;\n  font-weight: 600;\n  margin: 0 0 15px 0;\n  padding: 0;\n  display: flex;\n  align-items: center;\n}\n.gswpts_tables_container .swptls-backend-summary.swptls-key-takeaways .swptls-summary-title .summary-icon,\n.gswpts_tables_container .swptls-backend-summary-display.swptls-key-takeaways .swptls-summary-title .summary-icon {\n  margin-right: 8px;\n  font-size: 1.1em;\n}\n.gswpts_tables_container .swptls-backend-summary.swptls-key-takeaways .swptls-summary-title:before,\n.gswpts_tables_container .swptls-backend-summary-display.swptls-key-takeaways .swptls-summary-title:before {\n  content: \"🔍\";\n  margin-right: 8px;\n  font-size: 1.1em;\n}\n.gswpts_tables_container .swptls-backend-summary.swptls-key-takeaways .swptls-summary-content,\n.gswpts_tables_container .swptls-backend-summary-display.swptls-key-takeaways .swptls-summary-content {\n  color: #495057;\n  line-height: 1.6;\n  font-size: 0.95em;\n}\n.gswpts_tables_container .swptls-backend-summary.swptls-key-takeaways .swptls-summary-content p,\n.gswpts_tables_container .swptls-backend-summary-display.swptls-key-takeaways .swptls-summary-content p {\n  margin: 0 0 10px 0;\n}\n.gswpts_tables_container .swptls-backend-summary.swptls-key-takeaways .swptls-summary-content p:last-child,\n.gswpts_tables_container .swptls-backend-summary-display.swptls-key-takeaways .swptls-summary-content p:last-child {\n  margin-bottom: 0;\n}\n.gswpts_tables_container .swptls-backend-summary.swptls-key-takeaways .swptls-summary-content strong,\n.gswpts_tables_container .swptls-backend-summary-display.swptls-key-takeaways .swptls-summary-content strong {\n  color: #2c3e50;\n  font-weight: 600;\n}\n.gswpts_tables_container .swptls-backend-summary.swptls-key-takeaways .swptls-summary-content em,\n.gswpts_tables_container .swptls-backend-summary-display.swptls-key-takeaways .swptls-summary-content em {\n  font-style: italic;\n  color: #6c757d;\n}\n.gswpts_style-4 .gswpts_tables_container .swptls-backend-summary.swptls-key-takeaways,\n.gswpts_style-4 .gswpts_tables_container .swptls-backend-summary-display.swptls-key-takeaways {\n  background: #2c3e50;\n  border-color: #34495e;\n}\n.gswpts_style-4 .gswpts_tables_container .swptls-backend-summary.swptls-key-takeaways .swptls-summary-title,\n.gswpts_style-4 .gswpts_tables_container .swptls-backend-summary-display.swptls-key-takeaways .swptls-summary-title {\n  color: #ecf0f1;\n}\n.gswpts_style-4 .gswpts_tables_container .swptls-backend-summary.swptls-key-takeaways .swptls-summary-content,\n.gswpts_style-4 .gswpts_tables_container .swptls-backend-summary-display.swptls-key-takeaways .swptls-summary-content {\n  color: #bdc3c7;\n}\n.gswpts_style-4 .gswpts_tables_container .swptls-backend-summary.swptls-key-takeaways .swptls-summary-content strong,\n.gswpts_style-4 .gswpts_tables_container .swptls-backend-summary-display.swptls-key-takeaways .swptls-summary-content strong {\n  color: #ecf0f1;\n}\n.gswpts_style-4 .gswpts_tables_container .swptls-backend-summary.swptls-key-takeaways .swptls-summary-content em,\n.gswpts_style-4 .gswpts_tables_container .swptls-backend-summary-display.swptls-key-takeaways .swptls-summary-content em {\n  color: #95a5a6;\n}", "",{"version":3,"sources":["webpack://./assets/src/Styles/Frontend/frontend.scss","webpack://./assets/src/Styles/Frontend/Parts/_create_tab.scss","webpack://./assets/src/Styles/Frontend/Parts/_mixin.scss"],"names":[],"mappings":"AAAA,gBAAgB;AAEhB,iBAAA;ACAA;EAqEI;;KAAA;ADjEJ;ACFI;EACI,kBAAA;EAEA,gBAAA;EACA,eAAA;EACA,aAAA;EACA,eAAA;ADGR;ACDQ;EACI,kBAAA;EACA,MAAA;EACA,aAAA;ADGZ;ACDQ;EACI,cAAA;EACA,iBAAA;EACA,0BAAA;EACA,gCAAA;EACA,iBAAA;EACA,iBAAA;EAEA,gBAnBc;EAoBd,eAAA;EACA,kBAAA;EACA,QAAA;EACA,gCAAA;ADEZ;ACDY;EACI,mBAAA;ADGhB;ACCQ;EACI,QAAA;EACA,gBAAA;EACA,mBAtCC;EAuCD,WAAA;ADCZ;ACGI;EACI,kBAAA;EACA,UAAA;EACA,WAAA;EACA,4BAAA;EACA,SAAA;ADDR;ACGQ;EACI,SAAA;EACA,UAAA;ADDZ;ACII;EACI,mBAAA;EACA,UAAA;EACA,YAAA;ADFR;ACKI;EACI,yBAAA;KAAA,sBAAA;MAAA,qBAAA;UAAA,iBAAA;ADHR;ACMI;EACI,aAAA;EACA,uBAAA;EACA,2BAAA;ADJR;ACWI;EACI,gBAAA;EACA,gBAAA;ADTR;ACYI;EACI,aAAA;ADVR;ACaI;EACI,cAAA;ADXR;ACcI;EACI,gCAAA;ADZR;ACcI;EACI,gBAAA;ADZR;ACeI;EACI,mBAAA;ADbR;ACgBI;EACI,aAAA;EACA,8BAAA;ADdR;ACeQ;EACI,gBAAA;EACA,gBAAA;ADbZ;ACeY;EACI,gBAAA;EACA,eAAA;ADbhB;ACgBY;EACI,gBAAA;EACA,kBAAA;ADdhB;ACmBI;EACI;IACI,kBAAA;IACA,0BAAA;EDjBV;AACF;ACoBI;EACI;IACI,kBAAA;EDlBV;ECoBU;IACI,eAAA;EDlBd;ECqBM;IACI,kBAAA;IACA,0BAAA;EDnBV;AACF;;AA9GA;EEkCI;;iCAAA;EAGA;;kBAAA;EAgBA;;kBAAA;EAeA;;kBAAA;EAYA;;kBAAA;EAsBA;;kBAAA;EAGA,qBAAA;EAkFA;;uBAAA;EAgBA,8BAAA;EAKA;;iCAAA;EAGA;;uBAAA;EAyBA,eAAA;EA+BA,aAAA;EAkCA,SAAA;EA2CA;;uBAAA;EAWA,UAAA;EAiBA,WAAA;EACA,UAAA;EAQA,mBAAA;EASA,iBAAA;EAQA;;uBAAA;EAmCA,QAAA;EAMA,UAAA;EAWA,cAAA;EAWA;;uBAAA;EAGA,aAAA;EAsBA,YAAA;EAsBA,gBAAA;EAsBA,cAAA;EAmBA,YAAA;EAsBA,cAAA;EAsBA,cAAA;EAsBA,OAAA;EAmBA;;kBAAA;EAqBA;;iCAAA;EAGA;;uBAAA;EAiBA;;uBAAA;EAkBA;;uBAAA;EAmDA;;kBAAA;EAeA;;uBAAA;EAqEA,aAAA;EAoBA,4BAAA;EA+CA,gBAAA;EAoBA;;kBAAA;EAUA,iBAAA;EAkBA,iBAAA;EAOA,kBAAA;EAqDA,kBAAA;EAOA;;kBAAA;EAGA,uDAAA;EAiBA;;kBAAA;EAYA;;uBAAA;EAmCA,aAAA;EASA;;uBAAA;EAGA,aAAA;EAUA,iBAAA;EASA,iBAAA;EAgBA,WAAA;EAyBA,iBAAA;EA2BA,iBAAA;EAuCA;;uBAAA;EAoGA,2BAAA;EAqDA;;uBAAA;EAGA,gBAAA;EA4CA,UAAA;EA2CA,aAAA;EA0CA,mBAAA;EA0CA,eAAA;EA4CA,UAAA;EA2CA,aAAA;EA0CA,mBAAA;EA0CA,gBAAA;EA4CA,UAAA;EA2CA,aAAA;EA0CA,mBAAA;EA0CA,eAAA;EA4CA,UAAA;EA2CA,aAAA;EA0CA,mBAAA;EA0CA,gBAAA;EA4CA,UAAA;EA2CA,aAAA;EA0CA,mBAAA;EA0CA,iBAAA;EA4CA,UAAA;EA2CA,aAAA;EA0CA,mBAAA;EA0CA,eAAA;EA4CA,UAAA;EA2CA,aAAA;EA0CA,mBAAA;EA0CA,iBAAA;EA4CA,UAAA;EA2CA,aAAA;EA0CA,mBAAA;EA0CA,iBAAA;EA4CA,UAAA;EA2CA,aAAA;EA0CA,mBAAA;EA0CA,cAAA;EA4CA,UAAA;EA2CA,aAAA;EA0CA,mBAAA;EA0CA,eAAA;EA4CA,UAAA;EA2CA,aAAA;EA0CA,mBAAA;EA0CA,gBAAA;EA4CA,UAAA;EA2CA,aAAA;EA0CA,mBAAA;EA0CA,iBAAA;EA4CA,UAAA;EA2CA,aAAA;EA0CA,mBAAA;EA0CA;;uBAAA;EAGA,mBAAA;EA4CA,UAAA;EA2CA,aAAA;EA0CA,mBAAA;EA0CA;;uBAAA;EAGA,aAAA;EA4CA,UAAA;EA2CA,aAAA;EA0CA,mBAAA;EA0CA;;mBAAA;EAGA,aAAA;EA4CA,UAAA;EA2CA;;mBAAA;EAGA,aAAA;EA4CA,UAAA;EA2CA;;iCAAA;EAqBA,aAAA;EASA,mBAAA;EA6BA,oBAAA;EAijBA;;wBAAA;EAGA,0CAAA;EAaA;;iCAAA;EAGA;;wBAAA;EAaA;;wBAAA;EAYA;;wBAAA;EAmCA;;wBAAA;EA2BA;;wBAAA;EAWA,sBAAA;EAaA,8BAAA;EAaA;;iCAAA;EAGA;;wBAAA;EAYA,qBAAA;EAeA,yBAAA;EAqBA;;wBAAA;EA8CA,oBAAA;EAiBA,UAAA;EAKA;;wBAAA;EAGA,mBAAA;EAcA,0BAAA;EAgBA,2BAAA;EAgBA,iBAAA;EAQA,8BAAA;EAaA,iBAAA;EAaA,2BAAA;EAWA;;wBAAA;EAuBA,oBAAA;EAmBA,gBAAA;EAKA,mBAAA;EAmBA,gBAAA;EAKA;;wBAAA;EAGA,aAAA;EAKA;;wBAAA;EAaA;;wBAAA;EA18BA;;GAAA;EAsDA,qEAAA;EA8FA,kBAAA;EAaA,iBAAA;EAYA,iBAAA;EAoBA,qBAAA;EAyBA,UAAA;EAyDA;;uBAAA;EAGA,8BAAA;EAKA,iBAAA;EAaA,4BAAA;EAaA;;iCAAA;EAGA;;uBAAA;EAUA;;iCAAA;EAmBA;;iCAAA;EAGA;;uBAAA;EAGA,WAAA;EAyDA,gBAAA;EAyCA;;uBAAA;EAeA;;uBAAA;EAkBA,oBAAA;EFrlJA,cAAA;EACA,kBAAA;EACA,4BAAA;EAgBA;;;;;;;;;;;;;;;;;;;;;;;;;;;KAAA;AAqaJ;AElcI;EACI,eAAA;EACA,qBAAA;EACA,eAAA;EACA,aAAA;EACA,YAAA;EACA,wBAAA;EACA,wBAAA;EACA,yBAAA;EACA,mEAAA;EACA,0BAAA;EAEA,gBAAA;EACA,oBAAA;EACA,iBAAA;EACA,iBAAA;EACA,gBAAA;EACA,kBAAA;EACA,kBAAA;EACA,qBAAA;EACA,4BAAA;EAGA,2FAAA;EACA,yBAAA;EACA,sBAAA;EACA,qBAAA;EACA,iBAAA;EAKA,sHAAA;EAIA,eAAA;EACA,wCAAA;AF8bR;AErbI;EACI,yBAAA;EACA,sBAAA;EAGA,2FAAA;EACA,yBAAA;AFsbR;AEnbI;EACI,aAAA;AFqbR;AE/aI;EACI,yBAAA;EACA,yBAAA;EACA,+BAAA;EAEA,yBAAA;AFibR;AE9aI;EACI,aAAA;AFgbR;AE1aI;;EAEI,yBAAA;EACA,oBAAA;EACA,yBAAA;EAEA,mDAAA;AF4aR;AEtaI;EACI,yBAAA;EACA,sBAAA;EAEA,6CAAA;EACA,0BAAA;AFwaR;AEraI;EACI,yBAAA;EACA,sBAAA;EACA,0BAAA;AFuaR;AEpaI;EACI,yBAAA;EACA,sBAAA;AFsaR;AE/ZI;EACI,kBAAA;EACA,eAAA;EACA,4BAAA;EACA,6BAAA;EACA,UAAA;EACA,oBAAA;EAEA,4CAAA;AFiaR;AE9ZI;EACI,kBAAA;EACA,WAAA;EACA,QAAA;EACA,SAAA;EACA,2CAAA;EACA,mBAAA;EACA,oBAAA;EACA,qBAAA;EACA,uCAAA;AFgaR;AE7ZI;EACI,kBAAA;EACA,WAAA;EACA,QAAA;EACA,SAAA;EACA,2CAAA;EACA,mBAAA;EACA,oBAAA;EACA,0CAAA;EACA,kCAAA;EACA,2CAAA;EACA,mCAAA;EACA,qBAAA;EACA,6CAAA;EACA,mBAAA;EACA,mBAAA;EAEA,uCAAA;AF+ZR;AE5ZI;EACI,6BAAA;EAEA,gBAAA;AF8ZR;AE3ZI;EACI;IAEI,uBAAA;EF6ZV;EE1ZM;IAEI,yBAAA;EF4ZV;AACF;AEzZI;EACI;IAEI,uBAAA;EF2ZV;EExZM;IAEI,yBAAA;EF0ZV;AACF;AEvZI;EACI,gCAAA;AFyZR;AEtZI;EACI,yBAAA;AFwZR;AElZI;;;;;EAKI,eAAA;EACA,wBAAA;EACA,iCAAA;EAEA,2BAAA;EACA,+BAAA;AFoZR;AEhZI;EACI,mCAAA;AFkZR;AEzYI;EACI,kBAAA;EACA,gBAAA;EACA,6BAAA;EACA,sBAAA;EACA,UAAA;AF2YR;AExYI;EACI,+BAAA;AF0YR;AEvYI;EACI,kBAAA;EACA,mBAAA;AFyYR;AEtYI;EACI,kBAAA;EACA,WAAA;AFwYR;AEpYI;;EAGI,8BAAA;AFsYR;AEnYI;EACI,UAAA;EACA,SAAA;AFqYR;AElYI;EACI,QAAA;EACA,UAAA;EACA,YAAA;EACA,kBAAA;AFoYR;AEjYI;;EAEI,UAAA;EACA,WAAA;AFmYR;AEhYI;;EAEI,UAAA;EACA,SAAA;AFkYR;AE9XI;;EAII,8CAAA;AFiYR;AE7XI;EAEI,yBAAA;EACA,WAAA;AF+XR;AE5XI;EACI,SAAA;EACA,QAAA;EACA,WAAA;AF8XR;AE3XI;;EAGI,2BAAA;EACA,WAAA;AF6XR;AE1XI;;EAEI,QAAA;EACA,WAAA;AF4XR;AExXI;;EAII,kDAAA;AF2XR;AEvXI;EACI,UAAA;EACA,WAAA;EACA,UAAA;EAEA,mBAAA;AFyXR;AEtXI;EACI,UAAA;EACA,QAAA;EACA,WAAA;EAEA,qBAAA;AFwXR;AErXI;;EAEI,UAAA;EACA,WAAA;EACA,UAAA;EAEA,sBAAA;AFuXR;AEpXI;;EAEI,QAAA;EACA,WAAA;EACA,UAAA;EAEA,mBAAA;AFsXR;AEhXI;EAEI,oDAAA;EACA,4BAAA;EACA,cAAA;EACA,4BAAA;AFkXR;AE9WI;EACI,wBAAA;AFgXR;AE7WI;EACI,gBAAA;AF+WR;AE5WI;EACI,wBAAA;AF8WR;AE3WI;EACI,eAAA;AF6WR;AExWI;EACI,mBAAA;EAEA,oDAAA;EACA,yBAAA;AF0WR;AEtWI;;EAEI,mBAAA;EAEA,oDAAA;EACA,yBAAA;AFwWR;AEpWI;EACI,mBAAA;EAEA,oDAAA;EACA,yBAAA;AFsWR;AEhWI;EAGI,oBAAA;EAIA,mBAAA;EACA,2BAAA;EACA,uBAAA;EACA,uBAAA;EAEA,2BAAA;AFkWR;AE/VI;EACI,WAAA;AFiWR;AE9VI;EAGI,aAAA;EAGA,mBAAA;EACA,mCAAA;EACA,WAAA;EACA,cAAA;EACA,oCAAA;AFgWR;AE5VI;EACI,aAAA;EACA,cAAA;AF8VR;AE1VI;EACI,4BAAA;EACA,+BAAA;AF4VR;AEzVI;EACI,2BAAA;EACA,8BAAA;AF2VR;AEvVI;EACI,2BAAA;EACA,8BAAA;AFyVR;AEtVI;EACI,4BAAA;EACA,+BAAA;AFwVR;AEjVI;EACI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;EAEA,wDAAA;AFmVR;AEhVI;EACI,yBAAA;EACA,cAAA;EACA,iBAAA;AFkVR;AE/UI;EACI,yBAAA;EACA,cAAA;EACA,iBAAA;AFiVR;AE7UI;EACI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;EAEA,wDAAA;AF+UR;AE5UI;EACI,yBAAA;EACA,cAAA;EACA,iBAAA;AF8UR;AE3UI;EACI,yBAAA;EACA,cAAA;EACA,iBAAA;AF6UR;AEzUI;EACI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;EAEA,wDAAA;AF2UR;AExUI;EACI,yBAAA;EACA,cAAA;EACA,iBAAA;AF0UR;AEvUI;EACI,yBAAA;EACA,cAAA;EACA,iBAAA;AFyUR;AErUI;EACI,yBAAA;EACA,cAAA;EACA,iBAAA;AFuUR;AEpUI;EACI,yBAAA;EACA,cAAA;EACA,iBAAA;AFsUR;AEnUI;EACI,yBAAA;EACA,cAAA;EACA,iBAAA;AFqUR;AEjUI;EACI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;EAEA,wDAAA;AFmUR;AEhUI;EACI,yBAAA;EACA,cAAA;EACA,iBAAA;AFkUR;AE/TI;EACI,yBAAA;EACA,cAAA;EACA,iBAAA;AFiUR;AE7TI;EACI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;EAEA,wDAAA;AF+TR;AE5TI;EACI,yBAAA;EACA,cAAA;EACA,iBAAA;AF8TR;AE3TI;EACI,yBAAA;EACA,cAAA;EACA,iBAAA;AF6TR;AEzTI;EACI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;EAEA,wDAAA;AF2TR;AExTI;EACI,yBAAA;EACA,cAAA;EACA,iBAAA;AF0TR;AEvTI;EACI,yBAAA;EACA,cAAA;EACA,iBAAA;AFyTR;AErTI;EACI,yBAAA;EACA,cAAA;EACA,sBAAA;EAEA,wDAAA;AFuTR;AEpTI;EACI,yBAAA;EACA,cAAA;AFsTR;AEnTI;EACI,yBAAA;EACA,cAAA;AFqTR;AE/SI;EACI,oBAAA;EACA,YAAA;EACA,0CAAA;EAEA,6BAAA;EACA,kBAAA;EACA,SAAA;AFiTR;AE9SI;EACI,0CAAA;AFgTR;AE7SI;EACI,0CAAA;AF+SR;AEtSI;;EAEI,WAAA;EACA,gBAAA;EACA,oBAAA;AFwSR;AErSI;;EAEI,YAAA;EACA,iBAAA;EACA,mBAAA;AFuSR;AEjSI;;EAEI,0CAAA;AFmSR;AEhSI;;EAEI,+CAAA;AFkSR;AE/RI;;EAEI,+CAAA;AFiSR;AE3RI;;;EAGI,wBAAA;AF6RR;AE1RI;;;EAGI,wBAAA;AF4RR;AEzRI;;;EAGI,wBAAA;AF2RR;AExRI;;;EAGI,eAAA;AF0RR;AEvRI;;;EAGI,wBAAA;AFyRR;AEtRI;;;EAGI,wBAAA;AFwRR;AErRI;;;EAGI,wBAAA;AFuRR;AEpRI;;;EAGI,wBAAA;AFsRR;AEhRI;;EAEI,+CAAA;AFkRR;AE/QI;;EAEI,YAAA;EACA,sBAAA;EACA,mBAAA;AFiRR;AE3QI;;EAEI,uCAAA;EACA,oCAAA;EACA,mBAAA;EACA,4BAAA;EACA,oBAAA;EACA,4BAAA;EAEA,wDAAA;AF6QR;AE1QI;EAEI,gBAAA;EACA,wCAAA;EACA,4BAAA;AF4QR;AEzQI;EACI,kBAAA;AF2QR;AExQI;;EAEI,8BAAA;EACA,oCAAA;EAGA,sGAAA;AFyQR;AErQI;;EAEI,8BAAA;EACA,oCAAA;EAGA,sGAAA;AFsQR;AElQI;;EAEI,8BAAA;EACA,oCAAA;EAGA,mGAAA;AFmQR;AE/PI;;EAEI,0CAAA;EAEA,yBAAA;EACA,qCAAA;AFiQR;AE9PI;;EAEI,qCAAA;AFgQR;AE5PI;EAGI,4GAAA;AF6PR;AEzPI;EAGI,yGAAA;AF0PR;AEtPI;EAEI,yBAAA;AFwPR;AEpPI;;EAEI,wCAAA;EACA,yBAAA;EAEA,qEAAA;AFsPR;AEnPI;;EAEI,yBAAA;EAEA,oDAAA;AFqPR;AElPI;;EAEI,yBAAA;EAEA,oDAAA;AFoPR;AEjPI;;EAEI,sDAAA;EACA,yBAAA;EAEA,qEAAA;AFmPR;AEhPI;;EAEI,2CAAA;EACA,cAAA;EACA,iBAAA;EAEA,0DAAA;AFkPR;AE/OI;;EAEI,2CAAA;EAEA,oDAAA;AFiPR;AE7OI;EACI,6CAAA;EAEA,gBAAA;AF+OR;AE5OI;EACI,iBAAA;AF8OR;AE3OI;EACI,sBAAA;EACA,4CAAA;AF6OR;AE1OI;EACI,qBAAA;AF4OR;AEtOI;;EAEI,kBAAA;EACA,qCAAA;EACA,+BAAA;AFwOR;AEpOI;;EAEI,kBAAA;EACA,YAAA;EACA,cAAA;EACA,kBAAA;EACA,+BAAA;EACA,kCAAA;EACA,kBAAA;EACA,WAAA;EACA,mBAAA;EACA,qCAAA;EACA,SAAA;EAEA,8CAAA;AFsOR;AElOI;;EAEI,QAAA;EACA,SAAA;AFoOR;AEhOI;EACI,sCAAA;EACA,8BAAA;AFkOR;AE/NI;EACI,UAAA;EACA,UAAA;EACA,kBAAA;EACA,gCAAA;EACA,mCAAA;EAEA,6CAAA;AFiOR;AE9NI;;;;EAII,cAAA;EACA,kBAAA;EACA,WAAA;EACA,QAAA;EACA,kBAAA;EAEA,2BAAA;AFgOR;AE7NI;EACI,kBAAA;AF+NR;AE5NI;EACI,qCAAA;EACA,wCAAA;AF8NR;AE3NI;EACI,sCAAA;EACA,yCAAA;AF6NR;AE1NI;EACI,kBAAA;EACA,qCAAA;AF4NR;AEzNI;EACI,kBAAA;EACA,wCAAA;AF2NR;AEvNI;;EAEI,8BAAA;EACA,+BAAA;AFyNR;AElNI;;;EAGI,oCAAA;EAEA,2BAAA;EACA,iBAAA;EACA,yBAAA;AFoNR;AEjNI;EACI,oCAAA;EACA,iBAAA;EACA,yBAAA;AFmNR;AE7MI;EACI,mBAAA;AF+MR;AE5MI;EACI,UAAA;EACA,wBAAA;AF8MR;AExMI;EACI,kBAAA;EACA,YAAA;EACA,oBAAA;EACA,UAAA;AF0MR;AEvMI;EACI,kBAAA;EACA,kBAAA;EACA,qBAAA;EACA,aAAA;EACA,QAAA;EACA,SAAA;EACA,yBAAA;EACA,iBAAA;EACA,yBAAA;EACA,0BAAA;EACA,mBAAA;EACA,oBAAA;EACA,yBAAA;EACA,yBAAA;EACA,kBAAA;EACA,iBAAA;EAEA,6CAAA;AFyMR;AEtMI;EACI,wBAAA;AFwMR;AEpMI;EACI,qBAAA;AFsMR;AEnMI;EACI,aAAA;AFqMR;AE9LI;EACI,kBAAA;EACA,cAAA;EACA,WAAA;EACA,kBAAA;EAEA,6DAAA;AFgMR;AE5LI;EACI,kDAAA;AF8LR;AE3LI;EACI,kDAAA;AF6LR;AEzLI;EACI,qBAAA;EACA,iBAAA;EACA,iBAAA;EACA,qBAAA;EACA,kDAAA;AF2LR;AExLI;EACI,qBAAA;EACA,gBAAA;EACA,oBAAA;EACA,kDAAA;AF0LR;AEtLI;EACI,kBAAA;EAGA,aAAA;EACA,kBAAA;EACA,sBAAA;EACA,UAAA;EACA,iBAAA;EACA,kBAAA;AFwLR;AErLI;EACI,WAAA;AFuLR;AEpLI;EACI,kBAAA;AFsLR;AEnLI;EACI,kBAAA;AFqLR;AEjLI;EACI,mBAAA;EACA,kDAAA;AFmLR;AEhLI;EACI,wCAAA;AFkLR;AE/KI;EACI,wCAAA;AFiLR;AE9KI;EACI,gBAAA;EACA,kDAAA;AFgLR;AE7KI;EACI,wCAAA;AF+KR;AE5KI;EACI,wCAAA;AF8KR;AE1KI;EAGI,oBAAA;EACA,iBAAA;EACA,iBAAA;EACA,kDAAA;AF4KR;AEzKI;EACI,iBAAA;EACA,wCAAA;AF2KR;AExKI;EACI,iBAAA;EACA,wCAAA;AF0KR;AEvKI;EAGI,oBAAA;EACA,gBAAA;EACA,kBAAA;EACA,kDAAA;AFyKR;AEtKI;EACI,iBAAA;EACA,wCAAA;AFwKR;AErKI;EACI,iBAAA;EACA,wCAAA;AFuKR;AEjKI;;EAEI,WAAA;AFmKR;AEhKI;EACI,cAAA;AFkKR;AE/JI;EACI,WAAA;AFiKR;AE9JI;EACI,UAAA;AFgKR;AE7JI;EACI,WAAA;AF+JR;AE5JI;EACI,cAAA;AF8JR;AE3JI;EACI,WAAA;AF6JR;AE1JI;EACI,UAAA;AF4JR;AEzJI;EACI,WAAA;AF2JR;AExJI;EACI,UAAA;AF0JR;AEvJI;EACI,WAAA;AFyJR;AEtJI;EACI,cAAA;AFwJR;AErJI;EACI,WAAA;AFuJR;AEpJI;EACI,cAAA;AFsJR;AEnJI;EACI,WAAA;AFqJR;AElJI;EACI,YAAA;AFoJR;AEjJI;EACI,WAAA;AFmJR;AEhJI;EACI,aAAA;AFkJR;AE/II;EACI,WAAA;AFiJR;AE9II;EACI,UAAA;AFgJR;AE7II;EACI,WAAA;AF+IR;AE5II;EACI,YAAA;AF8IR;AE3II;EACI,WAAA;AF6IR;AE1II;EACI,cAAA;AF4IR;AExII;;EAII,aAAA;EACA,WAAA;AF0IR;AEvII;EACI,WAAA;AFyIR;AEtII;EACI,eAAA;AFwIR;AErII;EACI,WAAA;AFuIR;AEpII;EACI,WAAA;AFsIR;AEnII;EACI,eAAA;AFqIR;AElII;EACI,eAAA;AFoIR;AEjII;EACI,aAAA;AFmIR;AEhII;EACI,cAAA;AFkIR;AE/HI;EACI,WAAA;AFiIR;AE9HI;EACI,aAAA;AFgIR;AE7HI;EACI,eAAA;AF+HR;AExHI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;AF0HR;AEvHI;EAEI,wDAAA;AFyHR;AEtHI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFwHR;AErHI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFuHR;AEpHI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFsHR;AEnHI;;;;EAII,yBAAA;EACA,cAAA;EACA,iBAAA;AFqHR;AEjHI;;EAGI,oDAAA;EACA,yBAAA;AFmHR;AEhHI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFkHR;AE/GI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFiHR;AE9GI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFgHR;AE7GI;;EAGI,oDAAA;EACA,yBAAA;AF+GR;AE5GI;EACI,iBAAA;AF8GR;AE1GI;;EAEI,6BAAA;EAEA,oDAAA;EACA,cAAA;AF4GR;AEzGI;;;;;;;;EASI,2BAAA;EACA,cAAA;AF2GR;AExGI;;EAEI,yBAAA;AF0GR;AEvGI;;EAEI,yBAAA;AFyGR;AEtGI;;EAEI,yBAAA;AFwGR;AErGI;;EAEI,yBAAA;AFuGR;AEnGI;;;EAGI,6BAAA;EAEA,qEAAA;EACA,yBAAA;AFqGR;AElGI;;;EAII,oDAAA;EACA,yBAAA;AFoGR;AEjGI;;;EAII,oDAAA;EACA,yBAAA;AFmGR;AEhGI;;;EAII,oDAAA;EACA,yBAAA;AFkGR;AE/FI;;;EAII,oDAAA;EACA,yBAAA;AFiGR;AE7FI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;AF+FR;AE5FI;EAEI,wDAAA;AF8FR;AE3FI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AF6FR;AE1FI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AF4FR;AEzFI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AF2FR;AExFI;;;;EAII,yBAAA;EACA,cAAA;EACA,iBAAA;AF0FR;AEtFI;;EAGI,oDAAA;EACA,yBAAA;AFwFR;AErFI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFuFR;AEpFI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFsFR;AEnFI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFqFR;AElFI;;EAGI,oDAAA;EACA,yBAAA;AFoFR;AEjFI;EACI,iBAAA;AFmFR;AE/EI;;EAEI,6BAAA;EAEA,oDAAA;EACA,cAAA;AFiFR;AE9EI;;;;;;;;EASI,2BAAA;EACA,yBAAA;AFgFR;AE7EI;;EAEI,yBAAA;AF+ER;AE5EI;;EAEI,yBAAA;AF8ER;AE3EI;;EAEI,yBAAA;AF6ER;AE1EI;;EAEI,yBAAA;AF4ER;AExEI;;;EAGI,6BAAA;EAEA,qEAAA;EACA,yBAAA;AF0ER;AEvEI;;;EAII,oDAAA;EACA,yBAAA;AFyER;AEtEI;;;EAII,oDAAA;EACA,yBAAA;AFwER;AErEI;;;EAII,oDAAA;EACA,yBAAA;AFuER;AEpEI;;;EAII,oDAAA;EACA,yBAAA;AFsER;AElEI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;AFoER;AEjEI;EAEI,wDAAA;AFmER;AEhEI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFkER;AE/DI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFiER;AE9DI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFgER;AE7DI;;;;EAII,yBAAA;EACA,cAAA;EACA,iBAAA;AF+DR;AE3DI;;EAGI,oDAAA;EACA,yBAAA;AF6DR;AE1DI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AF4DR;AEzDI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AF2DR;AExDI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AF0DR;AEvDI;;EAGI,oDAAA;EACA,yBAAA;AFyDR;AEtDI;EACI,iBAAA;AFwDR;AEpDI;;EAEI,6BAAA;EAEA,oDAAA;EACA,cAAA;AFsDR;AEnDI;;;;;;;;EASI,2BAAA;EACA,cAAA;AFqDR;AElDI;;EAEI,yBAAA;AFoDR;AEjDI;;EAEI,yBAAA;AFmDR;AEhDI;;EAEI,yBAAA;AFkDR;AE/CI;;EAEI,yBAAA;AFiDR;AE7CI;;;EAGI,6BAAA;EAEA,qEAAA;EACA,yBAAA;AF+CR;AE5CI;;;EAII,oDAAA;EACA,yBAAA;AF8CR;AE3CI;;;EAII,oDAAA;EACA,yBAAA;AF6CR;AE1CI;;;EAII,oDAAA;EACA,yBAAA;AF4CR;AEzCI;;;EAII,oDAAA;EACA,yBAAA;AF2CR;AEvCI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;AFyCR;AEtCI;EAEI,wDAAA;AFwCR;AErCI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFuCR;AEpCI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFsCR;AEnCI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFqCR;AElCI;;;;EAII,yBAAA;EACA,cAAA;EACA,iBAAA;AFoCR;AEhCI;;EAGI,oDAAA;EACA,yBAAA;AFkCR;AE/BI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFiCR;AE9BI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFgCR;AE7BI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AF+BR;AE5BI;;EAGI,oDAAA;EACA,yBAAA;AF8BR;AE3BI;EACI,iBAAA;AF6BR;AEzBI;;EAEI,6BAAA;EAEA,oDAAA;EACA,cAAA;AF2BR;AExBI;;;;;;;;EASI,2BAAA;EACA,cAAA;AF0BR;AEvBI;;EAEI,yBAAA;AFyBR;AEtBI;;EAEI,yBAAA;AFwBR;AErBI;;EAEI,yBAAA;AFuBR;AEpBI;;EAEI,yBAAA;AFsBR;AElBI;;;EAGI,6BAAA;EAEA,qEAAA;EACA,yBAAA;AFoBR;AEjBI;;;EAII,oDAAA;EACA,yBAAA;AFmBR;AEhBI;;;EAII,oDAAA;EACA,yBAAA;AFkBR;AEfI;;;EAII,oDAAA;EACA,yBAAA;AFiBR;AEdI;;;EAII,oDAAA;EACA,yBAAA;AFgBR;AEZI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;AFcR;AEXI;EAEI,wDAAA;AFaR;AEVI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFYR;AETI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFWR;AERI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFUR;AEPI;;;;EAII,yBAAA;EACA,cAAA;EACA,iBAAA;AFSR;AELI;;EAGI,oDAAA;EACA,yBAAA;AFOR;AEJI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFMR;AEHI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFKR;AEFI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFIR;AEDI;;EAGI,oDAAA;EACA,yBAAA;AFGR;AEAI;EACI,iBAAA;AFER;AEEI;;EAEI,6BAAA;EAEA,oDAAA;EACA,cAAA;AFAR;AEGI;;;;;;;;EASI,2BAAA;EACA,cAAA;AFDR;AEII;;EAEI,yBAAA;AFFR;AEKI;;EAEI,yBAAA;AFHR;AEMI;;EAEI,yBAAA;AFJR;AEOI;;EAEI,yBAAA;AFLR;AESI;;;EAGI,6BAAA;EAEA,qEAAA;EACA,yBAAA;AFPR;AEUI;;;EAII,oDAAA;EACA,yBAAA;AFRR;AEWI;;;EAII,oDAAA;EACA,yBAAA;AFTR;AEYI;;;EAII,oDAAA;EACA,yBAAA;AFVR;AEaI;;;EAII,oDAAA;EACA,yBAAA;AFXR;AEeI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;AFbR;AEgBI;EAEI,wDAAA;AFdR;AEiBI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFfR;AEkBI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFhBR;AEmBI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFjBR;AEoBI;;;;EAII,yBAAA;EACA,cAAA;EACA,iBAAA;AFlBR;AEsBI;;EAGI,oDAAA;EACA,yBAAA;AFpBR;AEuBI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFrBR;AEwBI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFtBR;AEyBI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFvBR;AE0BI;;EAGI,oDAAA;EACA,yBAAA;AFxBR;AE2BI;EACI,iBAAA;AFzBR;AE6BI;;EAEI,6BAAA;EAEA,oDAAA;EACA,cAAA;AF3BR;AE8BI;;;;;;;;EASI,2BAAA;EACA,cAAA;AF5BR;AE+BI;;EAEI,yBAAA;AF7BR;AEgCI;;EAEI,yBAAA;AF9BR;AEiCI;;EAEI,yBAAA;AF/BR;AEkCI;;EAEI,yBAAA;AFhCR;AEoCI;;;EAGI,6BAAA;EAEA,qEAAA;EACA,yBAAA;AFlCR;AEqCI;;;EAII,oDAAA;EACA,yBAAA;AFnCR;AEsCI;;;EAII,oDAAA;EACA,yBAAA;AFpCR;AEuCI;;;EAII,oDAAA;EACA,yBAAA;AFrCR;AEwCI;;;EAII,oDAAA;EACA,yBAAA;AFtCR;AE0CI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;AFxCR;AE2CI;EAEI,wDAAA;AFzCR;AE4CI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AF1CR;AE6CI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AF3CR;AE8CI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AF5CR;AE+CI;;;;EAII,yBAAA;EACA,cAAA;EACA,iBAAA;AF7CR;AEiDI;;EAGI,oDAAA;EACA,yBAAA;AF/CR;AEkDI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFhDR;AEmDI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFjDR;AEoDI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFlDR;AEqDI;;EAGI,oDAAA;EACA,yBAAA;AFnDR;AEsDI;EACI,iBAAA;AFpDR;AEwDI;;EAEI,6BAAA;EAEA,oDAAA;EACA,cAAA;AFtDR;AEyDI;;;;;;;;EASI,2BAAA;EACA,cAAA;AFvDR;AE0DI;;EAEI,yBAAA;AFxDR;AE2DI;;EAEI,yBAAA;AFzDR;AE4DI;;EAEI,yBAAA;AF1DR;AE6DI;;EAEI,yBAAA;AF3DR;AE+DI;;;EAGI,6BAAA;EAEA,qEAAA;EACA,yBAAA;AF7DR;AEgEI;;;EAII,oDAAA;EACA,yBAAA;AF9DR;AEiEI;;;EAII,oDAAA;EACA,yBAAA;AF/DR;AEkEI;;;EAII,oDAAA;EACA,yBAAA;AFhER;AEmEI;;;EAII,oDAAA;EACA,yBAAA;AFjER;AEqEI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;AFnER;AEsEI;EAEI,wDAAA;AFpER;AEuEI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFrER;AEwEI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFtER;AEyEI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFvER;AE0EI;;;;EAII,yBAAA;EACA,cAAA;EACA,iBAAA;AFxER;AE4EI;;EAGI,oDAAA;EACA,yBAAA;AF1ER;AE6EI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AF3ER;AE8EI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AF5ER;AE+EI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AF7ER;AEgFI;;EAGI,oDAAA;EACA,yBAAA;AF9ER;AEiFI;EACI,iBAAA;AF/ER;AEmFI;;EAEI,6BAAA;EAEA,oDAAA;EACA,cAAA;AFjFR;AEoFI;;;;;;;;EASI,2BAAA;EACA,cAAA;AFlFR;AEqFI;;EAEI,yBAAA;AFnFR;AEsFI;;EAEI,yBAAA;AFpFR;AEuFI;;EAEI,yBAAA;AFrFR;AEwFI;;EAEI,yBAAA;AFtFR;AE0FI;;;EAGI,6BAAA;EAEA,qEAAA;EACA,yBAAA;AFxFR;AE2FI;;;EAII,oDAAA;EACA,yBAAA;AFzFR;AE4FI;;;EAII,oDAAA;EACA,yBAAA;AF1FR;AE6FI;;;EAII,oDAAA;EACA,yBAAA;AF3FR;AE8FI;;;EAII,oDAAA;EACA,yBAAA;AF5FR;AEgGI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;AF9FR;AEiGI;EAEI,wDAAA;AF/FR;AEkGI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFhGR;AEmGI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFjGR;AEoGI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFlGR;AEqGI;;;;EAII,yBAAA;EACA,cAAA;EACA,iBAAA;AFnGR;AEuGI;;EAGI,oDAAA;EACA,yBAAA;AFrGR;AEwGI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFtGR;AEyGI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFvGR;AE0GI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFxGR;AE2GI;;EAGI,oDAAA;EACA,yBAAA;AFzGR;AE4GI;EACI,iBAAA;AF1GR;AE8GI;;EAEI,6BAAA;EAEA,oDAAA;EACA,cAAA;AF5GR;AE+GI;;;;;;;;EASI,2BAAA;EACA,cAAA;AF7GR;AEgHI;;EAEI,yBAAA;AF9GR;AEiHI;;EAEI,yBAAA;AF/GR;AEkHI;;EAEI,yBAAA;AFhHR;AEmHI;;EAEI,yBAAA;AFjHR;AEqHI;;;EAGI,6BAAA;EAEA,qEAAA;EACA,yBAAA;AFnHR;AEsHI;;;EAII,oDAAA;EACA,yBAAA;AFpHR;AEuHI;;;EAII,oDAAA;EACA,yBAAA;AFrHR;AEwHI;;;EAII,oDAAA;EACA,yBAAA;AFtHR;AEyHI;;;EAII,oDAAA;EACA,yBAAA;AFvHR;AE2HI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;AFzHR;AE4HI;EAEI,wDAAA;AF1HR;AE6HI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AF3HR;AE8HI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AF5HR;AE+HI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AF7HR;AEgII;;;;EAII,yBAAA;EACA,cAAA;EACA,iBAAA;AF9HR;AEkII;;EAGI,oDAAA;EACA,yBAAA;AFhIR;AEmII;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFjIR;AEoII;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFlIR;AEqII;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFnIR;AEsII;;EAGI,oDAAA;EACA,yBAAA;AFpIR;AEuII;EACI,iBAAA;AFrIR;AEyII;;EAEI,6BAAA;EAEA,oDAAA;EACA,cAAA;AFvIR;AE0II;;;;;;;;EASI,2BAAA;EACA,cAAA;AFxIR;AE2II;;EAEI,yBAAA;AFzIR;AE4II;;EAEI,yBAAA;AF1IR;AE6II;;EAEI,yBAAA;AF3IR;AE8II;;EAEI,yBAAA;AF5IR;AEgJI;;;EAGI,6BAAA;EAEA,qEAAA;EACA,yBAAA;AF9IR;AEiJI;;;EAII,oDAAA;EACA,yBAAA;AF/IR;AEkJI;;;EAII,oDAAA;EACA,yBAAA;AFhJR;AEmJI;;;EAII,oDAAA;EACA,yBAAA;AFjJR;AEoJI;;;EAII,oDAAA;EACA,yBAAA;AFlJR;AEsJI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;AFpJR;AEuJI;EAEI,wDAAA;AFrJR;AEwJI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFtJR;AEyJI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFvJR;AE0JI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFxJR;AE2JI;;;;EAII,yBAAA;EACA,cAAA;EACA,iBAAA;AFzJR;AE6JI;;EAGI,oDAAA;EACA,yBAAA;AF3JR;AE8JI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AF5JR;AE+JI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AF7JR;AEgKI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AF9JR;AEiKI;;EAGI,oDAAA;EACA,yBAAA;AF/JR;AEkKI;EACI,iBAAA;AFhKR;AEoKI;;EAEI,6BAAA;EAEA,oDAAA;EACA,cAAA;AFlKR;AEqKI;;;;;;;;EASI,2BAAA;EACA,yBAAA;AFnKR;AEsKI;;EAEI,yBAAA;AFpKR;AEuKI;;EAEI,yBAAA;AFrKR;AEwKI;;EAEI,yBAAA;AFtKR;AEyKI;;EAEI,yBAAA;AFvKR;AE2KI;;;EAGI,6BAAA;EAEA,qEAAA;EACA,yBAAA;AFzKR;AE4KI;;;EAII,oDAAA;EACA,yBAAA;AF1KR;AE6KI;;;EAII,oDAAA;EACA,yBAAA;AF3KR;AE8KI;;;EAII,oDAAA;EACA,yBAAA;AF5KR;AE+KI;;;EAII,oDAAA;EACA,yBAAA;AF7KR;AEiLI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;AF/KR;AEkLI;EAEI,wDAAA;AFhLR;AEmLI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFjLR;AEoLI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFlLR;AEqLI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFnLR;AEsLI;;;;EAII,yBAAA;EACA,cAAA;EACA,iBAAA;AFpLR;AEwLI;;EAGI,oDAAA;EACA,yBAAA;AFtLR;AEyLI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFvLR;AE0LI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFxLR;AE2LI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFzLR;AE4LI;;EAGI,oDAAA;EACA,yBAAA;AF1LR;AE6LI;EACI,iBAAA;AF3LR;AE+LI;;EAEI,6BAAA;EAEA,oDAAA;EACA,cAAA;AF7LR;AEgMI;;;;;;;;EASI,2BAAA;EACA,yBAAA;AF9LR;AEiMI;;EAEI,yBAAA;AF/LR;AEkMI;;EAEI,yBAAA;AFhMR;AEmMI;;EAEI,yBAAA;AFjMR;AEoMI;;EAEI,yBAAA;AFlMR;AEsMI;;;EAGI,6BAAA;EAEA,qEAAA;EACA,yBAAA;AFpMR;AEuMI;;;EAII,oDAAA;EACA,yBAAA;AFrMR;AEwMI;;;EAII,oDAAA;EACA,yBAAA;AFtMR;AEyMI;;;EAII,oDAAA;EACA,yBAAA;AFvMR;AE0MI;;;EAII,oDAAA;EACA,yBAAA;AFxMR;AE4MI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;AF1MR;AE6MI;EAEI,wDAAA;AF3MR;AE8MI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AF5MR;AE+MI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AF7MR;AEgNI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AF9MR;AEiNI;;;;EAII,yBAAA;EACA,cAAA;EACA,iBAAA;AF/MR;AEmNI;;EAGI,oDAAA;EACA,yBAAA;AFjNR;AEoNI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFlNR;AEqNI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFnNR;AEsNI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFpNR;AEuNI;;EAGI,oDAAA;EACA,yBAAA;AFrNR;AEwNI;EACI,iBAAA;AFtNR;AE0NI;;EAEI,6BAAA;EAEA,oDAAA;EACA,cAAA;AFxNR;AE2NI;;;;;;;;EASI,2BAAA;EACA,yBAAA;AFzNR;AE4NI;;EAEI,yBAAA;AF1NR;AE6NI;;EAEI,yBAAA;AF3NR;AE8NI;;EAEI,yBAAA;AF5NR;AE+NI;;EAEI,yBAAA;AF7NR;AEiOI;;;EAGI,6BAAA;EAEA,qEAAA;EACA,yBAAA;AF/NR;AEkOI;;;EAII,oDAAA;EACA,yBAAA;AFhOR;AEmOI;;;EAII,oDAAA;EACA,yBAAA;AFjOR;AEoOI;;;EAII,oDAAA;EACA,yBAAA;AFlOR;AEqOI;;;EAII,oDAAA;EACA,yBAAA;AFnOR;AE0OI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;AFxOR;AE2OI;EAEI,wDAAA;AFzOR;AE4OI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AF1OR;AE6OI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AF3OR;AE8OI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AF5OR;AE+OI;;;;EAII,yBAAA;EACA,cAAA;EACA,iBAAA;AF7OR;AEiPI;;EAGI,oDAAA;EACA,yBAAA;AF/OR;AEkPI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFhPR;AEmPI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFjPR;AEoPI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFlPR;AEqPI;;EAGI,oDAAA;EACA,yBAAA;AFnPR;AEsPI;EACI,iBAAA;AFpPR;AEwPI;;EAEI,6BAAA;EAEA,oDAAA;EACA,cAAA;AFtPR;AEyPI;;;;;;;;EASI,2BAAA;EACA,cAAA;AFvPR;AE0PI;;EAEI,yBAAA;AFxPR;AE2PI;;EAEI,yBAAA;AFzPR;AE4PI;;EAEI,yBAAA;AF1PR;AE6PI;;EAEI,yBAAA;AF3PR;AE+PI;;;EAGI,6BAAA;EAEA,qEAAA;EACA,yBAAA;AF7PR;AEgQI;;;EAII,oDAAA;EACA,yBAAA;AF9PR;AEiQI;;;EAII,oDAAA;EACA,yBAAA;AF/PR;AEkQI;;;EAII,oDAAA;EACA,yBAAA;AFhQR;AEmQI;;;EAII,oDAAA;EACA,yBAAA;AFjQR;AEwQI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;AFtQR;AEyQI;EAEI,wDAAA;AFvQR;AE0QI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFxQR;AE2QI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFzQR;AE4QI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AF1QR;AE6QI;;;;EAII,yBAAA;EACA,cAAA;EACA,iBAAA;AF3QR;AE+QI;;EAGI,oDAAA;EACA,yBAAA;AF7QR;AEgRI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AF9QR;AEiRI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AF/QR;AEkRI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AFhRR;AEmRI;;EAGI,oDAAA;EACA,yBAAA;AFjRR;AEoRI;EACI,iBAAA;AFlRR;AEsRI;;EAEI,6BAAA;EAEA,oDAAA;EACA,cAAA;AFpRR;AEuRI;;;;;;;;EASI,2BAAA;EACA,cAAA;AFrRR;AEwRI;;EAEI,yBAAA;AFtRR;AEyRI;;EAEI,yBAAA;AFvRR;AE0RI;;EAEI,yBAAA;AFxRR;AE2RI;;EAEI,yBAAA;AFzRR;AE6RI;;;EAGI,6BAAA;EAEA,qEAAA;EACA,yBAAA;AF3RR;AE8RI;;;EAII,oDAAA;EACA,yBAAA;AF5RR;AE+RI;;;EAII,oDAAA;EACA,yBAAA;AF7RR;AEgSI;;;EAII,oDAAA;EACA,yBAAA;AF9RR;AEiSI;;;EAII,oDAAA;EACA,yBAAA;AF/RR;AEsSI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;AFpSR;AEuSI;EAEI,wDAAA;AFrSR;AEwSI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFtSR;AEySI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFvSR;AE0SI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFxSR;AE2SI;;;;EAII,yBAAA;EACA,cAAA;EACA,iBAAA;AFzSR;AE6SI;;EAGI,oDAAA;EACA,yBAAA;AF3SR;AE8SI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AF5SR;AE+SI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AF7SR;AEgTI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AF9SR;AEiTI;;EAGI,oDAAA;EACA,yBAAA;AF/SR;AEkTI;EACI,iBAAA;AFhTR;AEuTI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;EACA,sBAAA;AFrTR;AEwTI;EAEI,wDAAA;AFtTR;AEyTI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFvTR;AE0TI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFxTR;AE2TI;;EAEI,yBAAA;EACA,cAAA;EACA,iBAAA;AFzTR;AE4TI;;;;EAII,yBAAA;EACA,cAAA;EACA,iBAAA;AF1TR;AE8TI;;EAGI,oDAAA;EACA,yBAAA;AF5TR;AE+TI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AF7TR;AEgUI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AF9TR;AEiUI;;EAEI,kCAAA;EAEA,oDAAA;EACA,yBAAA;AF/TR;AEkUI;;EAGI,oDAAA;EACA,yBAAA;AFhUR;AEmUI;EACI,iBAAA;AFjUR;AEuUI;EAGI,oBAAA;EAIA,mBAAA;EACA,cAAA;EACA,wBAAA;EACA,0BAAA;AFrUR;AEwUI;EAEI,gBAAA;AFtUR;AE0UI;EACI,YAAA;EACA,cAAA;EACA,SAAA;EACA,WAAA;EACA,kBAAA;AFxUR;AE4UI;EAGI,cAAA;EACA,WAAA;EACA,kBAAA;EACA,uBAAA;AF1UR;AE6UI;;EAII,2FAAA;AF5UR;AE+UI;EACI,iBAAA;EACA,gBAAA;EACA,qCAAA;EACA,wCAAA;AF7UR;AEgVI;EACI,sCAAA;EACA,yCAAA;AF9UR;AEkVI;EAGI,oBAAA;EAIA,sBAAA;AFhVR;AEmVI;EACI,cAAA;EACA,WAAA;EACA,WAAA;EACA,uBAAA;EAEA,gBAAA;EACA,kBAAA;AFjVR;AEoVI;EACI,qCAAA;EACA,sCAAA;AFlVR;AEqVI;EACI,kBAAA;EACA,wCAAA;EACA,yCAAA;AFnVR;AEsVI;EACI,4BAAA;AFpVR;AEk0BI;EACI,kBAAA;EACA,mBAAA;EACA,kBAAA;EAGA,oBAAA;EACA,0BAAA;AFh0BR;AEm0BI;EACI,WAAA;EACA,eAAA;EAGA,cAAA;EACA,aAAA;EACA,mDAAA;EACA,gBAAA;EACA,yBAAA;EACA,mEAAA;EACA,yBAAA;EACA,mBAAA;EACA,wCAAA;EACA,0BAAA;EACA,4BAAA;EAGA,wDAAA;EAGA,gBAAA;AFj0BR;AEw0BI;EACI,gCAAA;AFt0BR;AEy0BI;EACI,gCAAA;AFv0BR;AE00BI;EACI,gCAAA;AFx0BR;AEi1BI;;EAEI,aAAA;AF/0BR;AEk1BI;;EAEI,oBAAA;AFh1BR;AEs1BI;;EAEI,gCAAA;EACA,mBAAA;EACA,0BAAA;EAEA,gBAAA;AFp1BR;AE01BI;EACI,kBAAA;EACA,WAAA;EACA,QAAA;EACA,SAAA;EACA,2CAAA;EACA,mBAAA;EACA,oBAAA;EACA,qBAAA;EACA,sCAAA;AFx1BR;AE21BI;EACI,kBAAA;EACA,WAAA;EACA,QAAA;EACA,SAAA;EACA,2CAAA;EACA,mBAAA;EACA,oBAAA;EACA,0CAAA;EACA,kCAAA;EACA,2CAAA;EACA,mCAAA;EACA,qBAAA;EACA,6CAAA;EACA,mBAAA;EACA,mBAAA;EAEA,uCAAA;AFz1BR;AE+1BI;;EAEI,qBAAA;EACA,mBAAA;EACA,yBAAA;EAEA,gBAAA;AF71BR;AEg2BI;;EAEI,gCAAA;AF91BR;AEi2BI;;EAEI,gCAAA;AF/1BR;AEk2BI;;EAEI,gCAAA;AFh2BR;AEs2BI;EACI,yBAAA;EACA,qBAAA;EACA,cAAA;EAEA,gBAAA;AFp2BR;AEw2BI;EACI,cAAA;AFt2BR;AEy2BI;EACI,cAAA;AFv2BR;AE02BI;EACI,yBAAA;AFx2BR;AE42BI;EACI,cAAA;AF12BR;AE62BI;EACI,cAAA;AF32BR;AE82BI;EACI,yBAAA;AF52BR;AEq3BI;EACI,oCAAA;EACA,wCAAA;EACA,uBAAA;EAEA,2BAAA;EACA,6BAAA;AFn3BR;AEu3BI;EACI,YAAA;AFr3BR;AEw3BI;EACI,4BAAA;EACA,6BAAA;AFt3BR;AEy3BI;EACI,4BAAA;EACA,6BAAA;AFv3BR;AE23BI;EACI,cAAA;AFz3BR;AE43BI;EACI,cAAA;AF13BR;AE63BI;EACI,+BAAA;AF33BR;AE83BI;EACI,+BAAA;AF53BR;AE+3BI;EACI,+BAAA;AF73BR;AEm4BI;EACI,eAAA;EACA,kBAAA;EACA,cAAA;EACA,kBAAA;EACA,QAAA;EACA,UAAA;EACA,WAAA;EACA,YAAA;EACA,mBAAA;EACA,YAAA;EACA,kDAAA;EAEA,6BAAA;AFj4BR;AEo4BI;EACI,oBAAA;AFl4BR;AEq4BI;EACI,sCAAA;AFn4BR;AEs4BI;;EAEI,OAAA;EACA,kBAAA;EACA,kBAAA;EACA,QAAA;EACA,WAAA;EACA,kBAAA;AFp4BR;AEu4BI;EACI,eAAA;AFr4BR;AEw4BI;EACI,WAAA;EACA,YAAA;AFt4BR;AE04BI;EACI,WAAA;EACA,SAAA;EACA,kDAAA;AFx4BR;AE24BI;EACI,WAAA;EACA,WAAA;AFz4BR;AE44BI;EACI,qCAAA;EACA,6BAAA;AF14BR;AE84BI;EACI,UAAA;AF54BR;AEm5BI;EAGI,cAAA;EACA,SAAA;EACA,cAAA;AFj5BR;AEo5BI;EACI,yBAAA;EACA,4BAAA;AFl5BR;AEs5BI;EACI,4BAAA;EACA,+BAAA;AFp5BR;AEu5BI;EACI,2BAAA;EACA,8BAAA;EACA,8BAAA;AFr5BR;AEw5BI;EACI,0BAAA;AFt5BR;AE05BI;EACI,uCAAA;EACA,0CAAA;EACA,0CAAA;AFx5BR;AE25BI;EACI,2BAAA;EACA,8BAAA;AFz5BR;AE45BI;EACI,sCAAA;AF15BR;AE85BI;EACI,QAAA;EACA,UAAA;EACA,uBAAA;EACA,wCAAA;AF55BR;AEg6BI;EACI,+BAAA;AF95BR;AEi6BI;EACI,gCAAA;AF/5BR;AEk6BI;EACI,oBAAA;AFh6BR;AEo6BI;EACI,8BAAA;AFl6BR;AEq6BI;EACI,+BAAA;AFn6BR;AEs6BI;EACI,mBAAA;AFp6BR;AEw6BI;EACI,QAAA;EACA,UAAA;AFt6BR;AEy6BI;EACI,WAAA;EACA,SAAA;AFv6BR;AE66BI;;EAII,aAAA;EAGA,mBAAA;EAGA,cAAA;AF36BR;AE86BI;;EAEI,yBAAA;EACA,4BAAA;EACA,SAAA;AF56BR;AEg7BI;EACI,uCAAA;EACA,0CAAA;EACA,0CAAA;AF96BR;AEi7BI;;;EAGI,kBAAA;AF/6BR;AEk7BI;;;EAGI,kDAAA;AFh7BR;AEo7BI;EACI,sCAAA;AFl7BR;AEs7BI;EACI,sCAAA;EACA,yCAAA;EACA,yCAAA;AFp7BR;AEu7BI;;;EAGI,kBAAA;AFr7BR;AEw7BI;;;EAGI,kDAAA;AFt7BR;AE07BI;EACI,qCAAA;AFx7BR;AE+7BI;EACI,YAAA;AF77BR;AEm8BI;EAGI,aAAA;AFj8BR;AEo8BI;EACI,qBAAA;AFl8BR;AEw8BI;EACI,uBAAA;AFt8BR;AEy8BI;EACI,uBAAA;AFv8BR;AE08BI;EACI,cAAA;AFx8BR;AE28BI;EACI,uBAAA;AFz8BR;AE48BI;EACI,uBAAA;AF18BR;AE68BI;EACI,uBAAA;AF38BR;AE88BI;EACI,uBAAA;AF58BR;AEvBI;EACI,SAAA;AFyBR;AEtBI;;EAEI,kBAAA;AFwBR;AErBI;;;;;;EAMI,mBAAA;AFuBR;AEpBI;;;;;;EAMI,kBAAA;EACA,UAAA;EACA,cAAA;EACA,kBAAA;EACA,QAAA;EACA,2BAAA;AFsBR;AEnBI;;EAEI,aAAA;EACA,6BAAA;EACA,gBAAA;AFqBR;AElBI;;EAEI,aAAA;EACA,gBAAA;AFoBR;AEjBI;;EAEI,aAAA;EACA,gBAAA;AFmBR;AEfI;;EAEI,aAAA;AFiBR;AEfI;;EAEI,aAAA;AFiBR;AEdI;;EAEI,aAAA;AFgBR;AEZI;;EAGI,uBAAA;AFcR;AEXI;;EAEI,kBAAA;AFaR;AEVI;;EAEI,mBAAA;AFYR;AETI;EACI,sBAAA;EACA,oBAAA;AFWR;AERI;EACI,YAAA;AFUR;AEPI;EACI,kBAAA;AFSR;AENI;EACI,iBAAA;EACA,mBAAA;AFQR;AELI;EACI,kBAAA;EACA,QAAA;EACA,SAAA;EACA,YAAA;EACA,mBAAA;EACA,kBAAA;AFOR;AEJI;EACI,UAAA;AFMR;AEHI;EACI,6BAAA;EACA,4BAAA;EACA,mBAAA;AFKR;AEFI;;;EAGI,aAAA;AFIR;AEDI;EACI,gBAAA;EACA,gBAAA;EACA,sBAAA;AFGR;AEAI;EACI,wBAAA;AFER;AECI;EACI,0BAAA;EACA,yBAAA;EACA,gBAAA;AFCR;AEMI;EACI,aAAA;EACA,kBAAA;EACA,QAAA;EACA,SAAA;EACA,WAAA;EACA,kBAAA;EACA,aAAA;EAEA,4CAAA;AFJR;AEQI;EACI,kBAAA;EACA,WAAA;EACA,OAAA;EACA,SAAA;EACA,WAAA;EACA,YAAA;EACA,qBAAA;EACA,sCAAA;AFNR;AEUI;EACI,kBAAA;EACA,WAAA;EACA,OAAA;EACA,SAAA;EACA,WAAA;EACA,YAAA;EACA,qCAAA;EACA,6BAAA;EACA,2CAAA;EACA,mCAAA;EACA,qBAAA;EACA,6CAAA;EACA,mBAAA;EACA,mBAAA;EAEA,uCAAA;AFRR;AEYI;EACI;IAEI,uBAAA;EFVV;EEaM;IAEI,yBAAA;EFXV;AACF;AEcI;EACI;IAEI,uBAAA;EFZV;EEeM;IAEI,yBAAA;EFbV;AACF;AEiBI;;EAEI,WAAA;EACA,YAAA;EACA,2BAAA;AFfR;AEkBI;;EAEI,oBAAA;EACA,qBAAA;EACA,kCAAA;AFhBR;AEmBI;;EAEI,oBAAA;EACA,qBAAA;EACA,kCAAA;AFjBR;AEoBI;;EAEI,oBAAA;EACA,qBAAA;EACA,kCAAA;AFlBR;AEqBI;;EAEI,oBAAA;EACA,qBAAA;EACA,kCAAA;AFnBR;AEsBI;;EAEI,oBAAA;EACA,qBAAA;EACA,kCAAA;AFpBR;AEuBI;;EAEI,oBAAA;EACA,qBAAA;EACA,kCAAA;AFrBR;AEwBI;;EAEI,oBAAA;EACA,qBAAA;EACA,kCAAA;AFtBR;AE6BI;EACI,cAAA;AF3BR;AE+BI;EACI,+BAAA;AF7BR;AEgCI;EACI,uCAAA;AF9BR;AEiCI;EACI,6CAAA;AF/BR;AEmCI;EACI,0BAAA;AFjCR;AEoCI;EACI,gCAAA;AFlCR;AEqCI;EACI,6CAAA;AFnCR;AE4CI;EACI,sBAAA;EACA,uBAAA;EACA,kBAAA;EACA,kBAAA;AF1CR;AEgDI;EACI,4BAAA;EACA,gCAAA;EACA,wBAAA;AF9CR;AEiDI;;EAEI,cAAA;AF/CR;AEkDI;;EAEI,aAAA;AFhDR;AE0DI;;EAEI,WAAA;EACA,YAAA;EACA,uBAAA;AFxDR;AE2DI;;EAEI,oBAAA;EACA,qBAAA;EACA,uBAAA;AFzDR;AE4DI;;EAEI,oBAAA;EACA,qBAAA;EACA,uBAAA;AF1DR;AE6DI;;EAEI,oBAAA;EACA,qBAAA;EACA,cAAA;AF3DR;AE8DI;;EAEI,oBAAA;EACA,qBAAA;EACA,uBAAA;AF5DR;AE+DI;;EAEI,oBAAA;EACA,qBAAA;EACA,uBAAA;AF7DR;AEgEI;;EAEI,oBAAA;EACA,qBAAA;EACA,uBAAA;AF9DR;AEiEI;;EAEI,oBAAA;EACA,qBAAA;EACA,uBAAA;AF/DR;AEmEI;EACI,eAAA;EACA,0BAAA;AFjER;AEoEI;EACI,wBAAA;EACA,0BAAA;AFlER;AEqEI;EACI,wBAAA;EACA,mBAAA;AFnER;AEsEI;EACI,wBAAA;EACA,0BAAA;AFpER;AEuEI;EACI,wBAAA;EACA,0BAAA;AFrER;AEwEI;EACI,wBAAA;EACA,mBAAA;AFtER;AEyEI;EACI,wBAAA;EACA,0BAAA;AFvER;AE0EI;EACI,wBAAA;EACA,0BAAA;AFxER;AE8EI;EACI,+BAAA;AF5ER;AE+EI;EACI,uCAAA;AF7ER;AEgFI;EACI,yBAAA;AF9ER;AEoFI;EACI,kBAAA;EACA,sBAAA;EACA,WAAA;EACA,SAAA;EACA,QAAA;EAEA,eAAA;AFlFR;AEqFI;;EAEI,qBAAA;AFnFR;AEuFI;;EAEI,cAAA;EACA,iBAAA;EACA,kBAAA;AFrFR;AAjgJI;EACI,WAAA;EACA,iBAAA;AAmgJR;AAhgJI;EACI,WAAA;EACA,gBAAA;EACA,kBAAA;EACA,4CAAA;EACA,kCAAA;AAkgJR;AAh+II;EACI,aAAA;EACA,yBAAA;EACA,eAAA;EACA,SAAA;AAk+IR;AAh+IQ;;EAEI,0BAAA;EACA,aAAA;EACA,iBAAA;AAk+IZ;AAh+IY;;EACI,4BAAA;AAm+IhB;AA/9IQ;EACI,gGAAA;AAi+IZ;AA79IQ;EACI,gGAAA;AA+9IZ;AA59IQ;EACI,+FAAA;AA89IZ;AA39IQ;EACI,+FAAA;AA69IZ;AA19IQ;EACI,gGAAA;AA49IZ;AAz9IQ;EACI,+FAAA;AA29IZ;AAx9IQ;EACI,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,YAAA;EACA,mBAAA;AA09IZ;AAv9IQ;EACI,aAAA;AAy9IZ;AAn9II;EACI,WAAA;AAq9IR;AAl9II;EACI,aAAA;EACA,8BAAA;EACA,mBAAA;EACA,qBAAA;AAo9IR;AAl9IQ;EACI,kBAAA;AAo9IZ;AAj9IQ;EACI,iBAAA;AAm9IZ;AA/8IQ;EACI,aAAA;EACA,SAAA;AAi9IZ;AA/8IY;EACI,kBAAA;AAi9IhB;AA58IQ;EACI,kCAAA;AA88IZ;AA38IQ;EA7BJ;IA8BQ,kCAAA;EA88IV;AACF;AA38II;EACI,aAAA;EACA,8BAAA;EACA,mBAAA;EACA,gBAAA;AA68IR;AA38IQ;EACI,yBAAA;EACA,kBAAA;AA68IZ;AAt8IQ;EACI,WAAA;AAw8IZ;AAr8IQ;EACI,aAAA;EACA,8BAAA;EACA,mBAAA;EAEA,qBAAA;AAs8IZ;AAp8IY;EACI,kBAAA;AAs8IhB;AAn8IY;EACI,iBAAA;AAq8IhB;AAl8IY;EACI,kCAAA;AAo8IhB;AA/7IQ;EACI,YAAA;EACA,oBAAA;AAi8IZ;AA97IQ;EACI,aAAA;EACA,8BAAA;EACA,mBAAA;EACA,gBAAA;EAYA;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;KAAA;EA2DA;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;KAAA;AA0+IZ;AA/iJY;EACI,yBAAA;EACA,kBAAA;AAijJhB;AA9iJY;EACI,iBAAA;EACA,cAAA;AAgjJhB;AAr7II;EACI;IACI,aAAA;IACA,eAAA;IACA,8BAAA;EAu7IV;EAr7IU;IACI,0BAAA;IACA,cAAA;EAu7Id;EAn7IM;IACI,iCAAA;IACA,kCAAA;IACA,kCAAA;EAq7IV;EAn7IU;IACI,yBAAA;IACA,qBAAA;EAq7Id;EA76Ic;IACI,kCAAA;EA+6IlB;AACF;AAz6II;EACI;IACI,aAAA;IACA,eAAA;IACA,8BAAA;EA26IV;EAz6IU;IACI,0BAAA;IACA,cAAA;EA26Id;EAv6IM;IACI,iCAAA;IACA,kCAAA;IACA,8BAAA;EAy6IV;EAv6IU;IACI,yBAAA;IACA,oBAAA;EAy6Id;EAt6IU;IACI,oBAAA;IACA,0BAAA;EAw6Id;AACF;AAp6II;EAEQ;IACI,mBAAA;EAq6Id;AACF;;AA/5IA;;;;;;;;;;;;;GAAA;AAgBA;;;;;;;;;;;;;;;;;;;;;;;;;;;GAAA;AAmCQ;EACI;;IACI,aAAA;EA05Id;EAt5Ic;;IACI,kBAAA;EAy5IlB;AACF;AAp5IQ;EAGI;;IACI,aAAA;EAq5Id;EAl5IU;;IACI,aAAA;EAq5Id;EAl5IU;;IACI,aAAA;EAq5Id;EA/4Ic;;IACI,kBAAA;EAk5IlB;EA94IU;;IACI,kBAAA;EAi5Id;AACF;;AA14IA;EACI,aAAA;AA64IJ;;AA14IA;EACI,WAAA;AA64IJ;AA34II;;EAEI,gBAAA;EACA,qBAAA;EACA,gBAAA;AA64IR;AA34IQ;;EACI,gBAAA;AA84IZ;AA14II;EACI,gBAAA;EACA,gBAAA;EACA,mBAAA;EACA,iBAAA;AA44IR;AAz4II;EACI,gBAAA;EACA,gBAAA;EACA,mBAAA;EACA,mBAAA;EACA,YAAA;AA24IR;AAx4II;EACI,gBAAA;EACA,qBAAA;EACA,mBAAA;EACA,iBAAA;AA04IR;AAx4IQ;EACI,eAAA;AA04IZ;AAt4II;EACI,aAAA;AAw4IR;;AAp4IA;;EAEI,qBAAA;AAu4IJ;;AAp4IA;EACI,qBAAA;AAu4IJ;;AAx3IA;EAEI,0BAAA;EACA,4BAAA;EACA,6BAAA;EAEA,wBAAA;EACA,gCAAA;EACA,+BAAA;EAEA,uBAAA;EACA,4BAAA;AAw3IJ;AAr3II;EACI,gBAAA;AAu3IR;AAp3II;;EAEI,YAAA;EACA,4CAAA;EACA,sCAAA;AAs3IR;AAn3II;EACI,YAAA;AAq3IR;AAl3II;EACI,cAAA;AAo3IR;AA35II;EACI;IACI,iBAAA;EA65IV;AACF;AAh3II;EACI,iBAAA;EACA,cAAA;AAk3IR;AA/2II;EACI,qBAAA;EACA,eAAA;EACA,kCAAA;EACA,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,eAAA;EACA,YAAA;EACA,aAAA;AAi3IR;AA52IY;EACI,kDAAA;AA82IhB;AA32IY;EACI,sDAAA;AA62IhB;AA12IY;EACI,qCAAA;AA42IhB;AAz2IY;EAdJ;IAeQ,4BAAA;EA42Id;AACF;AA12IY;EAlBJ;IAmBQ,2BAAA;EA62Id;AACF;AA32IY;EAtBJ;IAuBQ,2BAAA;IACA,eAAA;EA82Id;AACF;AA12IQ;EACI,qBAAA;AA42IZ;AAz2IQ;EACI,0CAAA;EACA,cAAA;AA22IZ;AAv2II;;;EAGI,eAAA;EACA,YAAA;EACA,SAAA;EACA,iBAAA;EACA,iBAAA;EACA,cAAA;EACA,uBAAA;EACA,yBAAA;EACA,qBAAA;EACA,+CAAA;AAy2IR;AAv2IQ;;;EACI,qCAAA;EACA,uCAAA;EACA,yCAAA;AA22IZ;AAx2IQ;EApBJ;;;IAqBQ,2BAAA;EA62IV;AACF;AA32IQ;EAxBJ;;;IAyBQ,2BAAA;IACA,eAAA;EAg3IV;AACF;AA32II;EACI,aAAA;AA62IR;;AAr2IA;EAEI,uBAAA;EACA,4BAAA;EAEA,qBAAA;EACA,0BAAA;EAEA,yBAAA;EACA,yBAAA;AAq2IJ;AAj2IQ;;EAGI,wCAAA;EACA,+BAAA;EACA,YAAA;AAk2IZ;AA71IQ;EACI,sCAAA;EACA,6BAAA;AA+1IZ;AA51IQ;EACI,gBAAA;AA81IZ;AA31IQ;EACI,YAAA;AA61IZ;AAt1IgB;;;;EAEI,uCAAA;AA01IpB;AAr1IQ;EACI,aAAA;AAu1IZ;AAr1IY;EACI,cAAA;AAu1IhB;AAn1IQ;EACI,WAAA;AAq1IZ;AA9hJI;EACI;IACI,iBAAA;EAgiJV;AACF;AAl1II;EACI,qBAAA;EACA,eAAA;EACA,kCAAA;EACA,aAAA;EACA,uBAAA;EACA,mBAAA;EACA,eAAA;EACA,YAAA;EACA,aAAA;AAo1IR;AA/0IY;EACI,qCAAA;AAi1IhB;AA90IY;EANJ;IAOQ,4BAAA;EAi1Id;AACF;AA/0IY;EAVJ;IAWQ,2BAAA;EAk1Id;AACF;AAh1IY;EAdJ;IAeQ,2BAAA;IACA,eAAA;EAm1Id;AACF;AA/0IQ;EACI,qBAAA;AAi1IZ;AA90IQ;EACI,0CAAA;EACA,cAAA;AAg1IZ;AA50II;;;EAGI,eAAA;EACA,YAAA;EACA,SAAA;EACA,iBAAA;EACA,iBAAA;AA80IR;AA50IQ;;;EACI,qCAAA;EACA,uCAAA;EACA,yCAAA;AAg1IZ;AA70IQ;EAfJ;;;IAgBQ,2BAAA;EAk1IV;AACF;AAh1IQ;EAnBJ;;;IAoBQ,2BAAA;IACA,eAAA;EAq1IV;AACF;AAj1II;EACI,gBAAA;AAm1IR;AAh1II;EACI,aAAA;AAk1IR;;AA10II;EACI,yBAAA;EACA,iBAAA;AA60IR;AA30IQ;;EAEI,kBAAA;AA60IZ;AAx0II;;EAEI,mBAAA;EACA,yBAAA;EACA,kBAAA;EACA,aAAA;EACA,cAAA;EACA,wCAAA;AA00IR;AAx0IQ;;EACI,cAAA;EACA,gBAAA;EACA,gBAAA;EACA,kBAAA;EACA,UAAA;EACA,aAAA;EACA,mBAAA;AA20IZ;AAz0IY;;EACI,iBAAA;EACA,gBAAA;AA40IhB;AAz0IY;;EACI,aAAA;EACA,iBAAA;EACA,gBAAA;AA40IhB;AAx0IQ;;EACI,cAAA;EACA,gBAAA;EACA,iBAAA;AA20IZ;AAz0IY;;EACI,kBAAA;AA40IhB;AA10IgB;;EACI,gBAAA;AA60IpB;AAz0IY;;EACI,cAAA;EACA,gBAAA;AA40IhB;AAz0IY;;EACI,kBAAA;EACA,cAAA;AA40IhB;AAv0IQ;;EACI,mBAAA;EACA,qBAAA;AA00IZ;AAx0IY;;EACI,cAAA;AA20IhB;AAx0IY;;EACI,cAAA;AA20IhB;AAz0IgB;;EACI,cAAA;AA40IpB;AAz0IgB;;EACI,cAAA;AA40IpB","sourcesContent":["@use \"./Parts/mixin\";\r\n\r\n/* End of mixin */\r\n\r\n@import \"./Parts/create_tab\";\r\n// @use \"./Parts/mixin\";\r\n\r\n.gswpts_tables_container {\r\n    @include mixin.button_style;\r\n    @include mixin.input_style;\r\n    @include mixin.datatable_semantic;\r\n    @include mixin.loader_style;\r\n    margin: 30px 0;\r\n    position: relative;\r\n    padding: 30px 0px !important;\r\n\r\n    .gswpts_table_loader {\r\n        width: 100%;\r\n        min-height: 200px;\r\n    }\r\n\r\n    select {\r\n        width: 65px;\r\n        padding: 1px 2px;\r\n        border-radius: 5px;\r\n        border: 1px solid #00000033 !important;\r\n        background: transparent !important;\r\n    }\r\n\r\n    // OLD STYLE FOR BUTTONS\r\n    /* .dt-buttons {\r\n        display: flex;\r\n        justify-content: flex-end;\r\n        margin-top: 5px;\r\n        gap: 10px;\r\n\r\n        button {\r\n            font-size: 13px !important;\r\n            margin: 0 6px;\r\n            margin-right: 5px;\r\n\r\n            &:hover img {\r\n                filter: brightness(0.1);\r\n            }\r\n        }\r\n\r\n        span {\r\n            display: flex;\r\n            justify-content: center;\r\n            align-items: center;\r\n            height: 21px;\r\n            white-space: nowrap;\r\n        }\r\n\r\n        .export_btns {\r\n            display: none;\r\n        }\r\n    } */\r\n\r\n    // New Style for buttons with different color on hover export icons\r\n    .dt-buttons {\r\n        display: flex;\r\n        justify-content: flex-end;\r\n        margin-top: 5px;\r\n        gap: 10px;\r\n\r\n        button,\r\n        a {\r\n            font-size: 13px !important;\r\n            margin: 0 6px;\r\n            margin-right: 5px;\r\n\r\n            img {\r\n                transition: filter 0.3s ease;\r\n            }\r\n        }\r\n\r\n        .json_btn:hover img {\r\n            filter: invert(42%) sepia(96%) saturate(1808%) hue-rotate(192deg) brightness(99%) contrast(101%);\r\n\r\n        }\r\n\r\n        .csv_btn:hover img {\r\n            filter: invert(56%) sepia(88%) saturate(1486%) hue-rotate(141deg) brightness(94%) contrast(101%);\r\n        }\r\n\r\n        .excel_btn:hover img {\r\n            filter: invert(48%) sepia(79%) saturate(2476%) hue-rotate(133deg) brightness(91%) contrast(97%);\r\n        }\r\n\r\n        .print_btn:hover img {\r\n            filter: invert(40%) sepia(97%) saturate(1809%) hue-rotate(201deg) brightness(96%) contrast(96%);\r\n        }\r\n\r\n        .copy_btn:hover img {\r\n            filter: invert(26%) sepia(96%) saturate(3668%) hue-rotate(265deg) brightness(85%) contrast(107%);\r\n        }\r\n\r\n        .pdf_btn:hover img {\r\n            filter: invert(43%) sepia(84%) saturate(1644%) hue-rotate(347deg) brightness(95%) contrast(91%);\r\n        }\r\n\r\n        span {\r\n            display: flex;\r\n            justify-content: center;\r\n            align-items: center;\r\n            height: 21px;\r\n            white-space: nowrap;\r\n        }\r\n\r\n        .export_btns {\r\n            display: none;\r\n        }\r\n    }\r\n\r\n\r\n\r\n    table {\r\n        width: 100%;\r\n    }\r\n\r\n    .filtering_input {\r\n        display: flex;\r\n        justify-content: space-between;\r\n        align-items: center;\r\n        margin: 15px 0 25px 0;\r\n\r\n        #create_tables_length {\r\n            margin-right: auto;\r\n        }\r\n\r\n        #create_tables_filter {\r\n            margin-left: auto;\r\n        }\r\n\r\n        // Search by press \r\n        .searchBypress {\r\n            display: flex;\r\n            gap: 10px;\r\n\r\n            button.ui.button.search-by-press {\r\n                padding: 10px 15px;\r\n            }\r\n        }\r\n\r\n\r\n        input {\r\n            background: transparent !important;\r\n        }\r\n\r\n        @media screen and (max-width: 540px) {\r\n            align-items: flex-start !important;\r\n        }\r\n    }\r\n\r\n    .bottom_options {\r\n        display: flex;\r\n        justify-content: space-between;\r\n        align-items: center;\r\n        margin-top: 20px;\r\n\r\n        .dataTables_info {\r\n            padding-top: 0 !important;\r\n            margin-right: auto;\r\n        }\r\n\r\n\r\n    }\r\n\r\n    .gswpts_tables_content {\r\n        table {\r\n            width: 100%;\r\n        }\r\n\r\n        .filtering_input {\r\n            display: flex;\r\n            justify-content: space-between;\r\n            align-items: center;\r\n            // margin: 15px 0 5px 0;\r\n            margin: 15px 0 25px 0;\r\n\r\n            #create_tables_length {\r\n                margin-right: auto;\r\n            }\r\n\r\n            #create_tables_filter {\r\n                margin-left: auto;\r\n            }\r\n\r\n            input {\r\n                background: transparent !important;\r\n            }\r\n        }\r\n\r\n        // Checkbox disable \r\n        input.flexsync-checkbox {\r\n            cursor: none;\r\n            pointer-events: none;\r\n        }\r\n\r\n        .bottom_options {\r\n            display: flex;\r\n            justify-content: space-between;\r\n            align-items: center;\r\n            margin-top: 10px;\r\n\r\n            .dataTables_info {\r\n                padding-top: 0 !important;\r\n                margin-right: auto;\r\n            }\r\n\r\n            #create_tables_paginate {\r\n                margin-left: auto;\r\n                padding: 0 5px;\r\n            }\r\n\r\n            /* .default-pagination-active,\r\n            .default-preset-pagination-active {\r\n                .pagination.menu {\r\n                    padding: 0 !important;\r\n                    font-size: 14px;\r\n                    background: transparent !important;\r\n                    display: flex;\r\n                    justify-content: center;\r\n                    align-items: center;\r\n                    flex-wrap: wrap;\r\n                    border: none;\r\n                    margin: 0 5px;\r\n\r\n                    &>* {\r\n                        padding: 9px 16px;\r\n                        border: 1px solid #a9a1a13d;\r\n                \r\n                        &:first-child {\r\n                            border-radius: 0.28571429rem 0px 0px 0.28571429rem;\r\n                        }\r\n\r\n                        &:last-child {\r\n                            border-radius: 0px 0.28571429rem 0.28571429rem 0px 0px;\r\n                        }\r\n\r\n                        font-weight: bold;\r\n                        color: rgba(56, 13, 13, 0.787);\r\n\r\n                        &:hover {\r\n                            background-color: rgba(0, 0, 0, 0.03);\r\n                        }\r\n\r\n                        @media screen and (max-width: 991px) {\r\n                            padding: 4px 12px !important;\r\n                        }\r\n\r\n                        @media screen and (max-width: 770px) {\r\n                            padding: 2px 9px !important;\r\n                        }\r\n\r\n                        @media screen and (max-width: 420px) {\r\n                            padding: 1px 6px !important;\r\n                            font-size: 12px;\r\n                        }\r\n                    }\r\n\r\n                    a {\r\n                        text-decoration: none;\r\n                    }\r\n\r\n                    .active {\r\n                        // background-color: #b3b3b35c;\r\n                        background-color: #2F80ED;\r\n                        color: #fff;\r\n                    }\r\n                }\r\n            } */\r\n\r\n            // New Pagination \r\n            /* .modern-pagination-active,\r\n            .simple-pagination-active,\r\n            .tailwind-pagination-active,\r\n            .outlined-pagination-active {\r\n                .pagination.menu {\r\n                    padding: 0 !important;\r\n                    font-size: 14px;\r\n                    background: transparent !important;\r\n                    display: flex;\r\n                    justify-content: center;\r\n                    align-items: center;\r\n                    flex-wrap: wrap;\r\n                    border: none;\r\n                    margin: 0 5px;\r\n\r\n                    &>* {\r\n                        padding: 9px 16px;\r\n\r\n                        &:first-child {\r\n                            border-radius: 0.28571429rem 0px 0px 0.28571429rem;\r\n                        }\r\n\r\n                        &:last-child {\r\n                            border-radius: 0px 0.28571429rem 0.28571429rem 0px 0px;\r\n                        }\r\n\r\n                        font-weight: bold;\r\n                        color: rgba(56, 13, 13, 0.787);\r\n\r\n                        &:hover {\r\n                            background-color: rgba(0, 0, 0, 0.03);\r\n                        }\r\n\r\n                        @media screen and (max-width: 991px) {\r\n                            padding: 4px 12px !important;\r\n                        }\r\n\r\n                        @media screen and (max-width: 770px) {\r\n                            padding: 2px 9px !important;\r\n                        }\r\n\r\n                        @media screen and (max-width: 420px) {\r\n                            padding: 1px 6px !important;\r\n                            font-size: 12px;\r\n                        }\r\n                    }\r\n\r\n                    a {\r\n                        text-decoration: none;\r\n                    }\r\n\r\n                    .active {\r\n                        background-color: #b3b3b35c;\r\n                    }\r\n                }\r\n            } */\r\n\r\n\r\n        }\r\n    }\r\n\r\n    @media screen and (max-width: 540px) {\r\n        .dt-buttons {\r\n            display: flex;\r\n            flex-wrap: wrap;\r\n            justify-content: space-between;\r\n\r\n            button {\r\n                font-size: 10px !important;\r\n                margin: 10px 0;\r\n            }\r\n        }\r\n\r\n        .filtering_input {\r\n            flex-direction: column !important;\r\n            align-items: flex-start !important;\r\n            justify-content: center !important;\r\n\r\n            div {\r\n                margin: 10px 0 !important;\r\n                padding: 0 !important;\r\n            }\r\n        }\r\n\r\n        .gswpts_tables_content {\r\n\r\n            .dataTables_wrapper {\r\n\r\n                .filtering_input {\r\n                    align-items: flex-start !important;\r\n                }\r\n            }\r\n        }\r\n\r\n    }\r\n\r\n    @media screen and (max-width: 700px) {\r\n        .dt-buttons {\r\n            display: flex;\r\n            flex-wrap: wrap;\r\n            justify-content: space-between;\r\n\r\n            button {\r\n                font-size: 12px !important;\r\n                margin: 10px 0;\r\n            }\r\n        }\r\n\r\n        .bottom_options {\r\n            flex-direction: column !important;\r\n            justify-content: center !important;\r\n            align-items: center !important;\r\n\r\n            .dataTables_info {\r\n                padding-top: 0 !important;\r\n                margin: 0 !important;\r\n            }\r\n\r\n            #create_tables_paginate {\r\n                margin: 0 !important;\r\n                margin-top: 8px !important;\r\n            }\r\n        }\r\n    }\r\n\r\n    @media screen and (max-width: 768px) {\r\n        &.collapse_style {\r\n            table .expanded_style {\r\n                white-space: normal;\r\n            }\r\n        }\r\n    }\r\n}\r\n\r\n// Orginal one \r\n/* .gswpts_tables_container,\r\n.gswpts_tables_container {\r\n    .gswpts_tables {\r\n        .hidden-row {\r\n            display: none;\r\n        }\r\n\r\n        .hidden-cell {\r\n            .cell_div {\r\n                visibility: hidden;\r\n            }\r\n        }\r\n    }\r\n} */\r\n\r\n// New one \r\n/* .gswpts_tables_container,\r\n.gswpts_tables_container {\r\n    .gswpts_tables {\r\n        .hidden-row {\r\n            display: none;\r\n        }\r\n\r\n        .hidden-cell {\r\n            .cell_div {\r\n                visibility: hidden;\r\n            }\r\n        }\r\n    }\r\n\r\n    // Use to hide row and cell in mobile \r\n    @media screen and (max-width: 540px) {\r\n\r\n        .gswpts_rows.hidden-row-mobile {\r\n            display: none;\r\n        }\r\n\r\n        .gswpts_rows.hidden-cell-mobile {\r\n            .cell_div {\r\n                visibility: hidden;\r\n            }\r\n        }\r\n    }\r\n} */\r\n\r\n// Update one first scss for hide also this below code added on pro plugin \r\n.gswpts_tables_container,\r\n.gswpts_tables_container {\r\n    .gswpts_tables {\r\n\r\n        // Apply styles for desktop/large screens\r\n        @media screen and (min-width: 541px) {\r\n            .hidden-row {\r\n                display: none;\r\n            }\r\n\r\n            .hidden-cell {\r\n                .cell_div {\r\n                    visibility: hidden;\r\n                }\r\n            }\r\n        }\r\n\r\n        // Apply styles for mobile and tablet screens\r\n        @media screen and (max-width: 540px) {\r\n\r\n            //Row\r\n            .hidden-row-mobile {\r\n                display: none;\r\n            }\r\n\r\n            .gswpts_rows.hidden-row-mobile {\r\n                display: none;\r\n            }\r\n\r\n            tr.gswpts_rows.hidden-row-mobile {\r\n                display: none;\r\n            }\r\n\r\n\r\n            // Cell \r\n            .hidden-cell-mobile {\r\n                .cell_div {\r\n                    visibility: hidden;\r\n                }\r\n            }\r\n\r\n            .gswpts_rows td.hidden-cell-mobile .cell_div {\r\n                visibility: hidden;\r\n            }\r\n\r\n        }\r\n    }\r\n}\r\n\r\n\r\n.swptls-table-title.hidden {\r\n    display: none;\r\n}\r\n\r\ntable.dataTable.table.gswpts_tables {\r\n    width: 100%;\r\n\r\n    th,\r\n    td {\r\n        max-width: 200px;\r\n        overflow-wrap: break-word;\r\n        min-height: 25px;\r\n\r\n        img {\r\n            max-width: unset;\r\n        }\r\n    }\r\n\r\n    .expanded_style {\r\n        max-width: unset;\r\n        overflow-wrap: unset;\r\n        white-space: nowrap;\r\n        overflow-x: unset;\r\n    }\r\n\r\n    .clip_style {\r\n        max-width: 200px;\r\n        overflow-wrap: unset;\r\n        white-space: nowrap;\r\n        overflow-x: overlay;\r\n        height: 30px;\r\n    }\r\n\r\n    .wrap_style {\r\n        max-width: 200px;\r\n        overflow-wrap: break-word;\r\n        white-space: normal;\r\n        overflow-x: unset;\r\n\r\n        img {\r\n            max-width: 100%;\r\n        }\r\n    }\r\n\r\n    th:focus {\r\n        outline: none;\r\n    }\r\n}\r\n\r\n.pdf_btn.button.dt-button:hover img,\r\n.gswpts_tables_container .ui.inverted.red.button.pdf_btn:hover img {\r\n    filter: brightness(0);\r\n}\r\n\r\n.pdf_btn.button:hover img {\r\n    filter: brightness(0);\r\n}\r\n\r\n\r\n// Default Theme \r\n@mixin sorting-icon {\r\n    @media screen and (max-width: 768px) {\r\n        .sorting.sorting.sorting::after {\r\n            margin-right: 8px;\r\n        }\r\n    }\r\n}\r\n\r\n// Default Style - default-style = new name: Simple\r\n// Default style new implemented\r\n.gswpts_default-style.gswpts_default-style {\r\n\r\n    --header-bg-color: #ffffff;\r\n    --header-text-color: #000000;\r\n    --header-text-alignment: left;\r\n\r\n    --body-bg-color: #ffffff;\r\n    --body-text-color-col-1: #333333;\r\n    --body-text-color-rest: #6B7280;\r\n\r\n    --border-color: #e0e5f6;\r\n    --pagination-colors: #828282;\r\n\r\n\r\n    th.thead-item {\r\n        text-align: left;\r\n    }\r\n\r\n    th,\r\n    td {\r\n        border: none;\r\n        border-bottom: 2px solid var(--border-color);\r\n        background-color: var(--body-bg-color);\r\n    }\r\n\r\n    table.ui.celled.display {\r\n        border: none;\r\n    }\r\n\r\n    .sorting.sorting.sorting::after {\r\n        color: #a1a1a1;\r\n    }\r\n\r\n    &.collapse_style {\r\n        @include sorting-icon;\r\n    }\r\n\r\n\r\n    // Frontend table pagination default ==  Pagination for default \r\n    #create_tables_paginate {\r\n        margin-left: auto;\r\n        padding: 0 5px;\r\n    }\r\n\r\n    .default-pagination-active .pagination.menu {\r\n        padding: 0 !important;\r\n        font-size: 14px;\r\n        background: transparent !important;\r\n        display: flex;\r\n        justify-content: center;\r\n        align-items: center;\r\n        flex-wrap: wrap;\r\n        border: none;\r\n        margin: 0 5px;\r\n\r\n        // Pagination \r\n        &>* {\r\n\r\n            &:first-child {\r\n                border-radius: 0.28571429rem 0px 0px 0.28571429rem;\r\n            }\r\n\r\n            &:last-child {\r\n                border-radius: 0px 0.28571429rem 0.28571429rem 0px 0px;\r\n            }\r\n\r\n            &:hover {\r\n                background-color: rgba(0, 0, 0, 0.03);\r\n            }\r\n\r\n            @media screen and (max-width: 991px) {\r\n                padding: 4px 12px !important;\r\n            }\r\n\r\n            @media screen and (max-width: 770px) {\r\n                padding: 1px 9px !important;\r\n            }\r\n\r\n            @media screen and (max-width: 420px) {\r\n                padding: 1px 6px !important;\r\n                font-size: 12px;\r\n            }\r\n\r\n        }\r\n\r\n        a {\r\n            text-decoration: none;\r\n        }\r\n\r\n        .active {\r\n            background-color: var(--pagination-colors);\r\n            color: #ffffff;\r\n        }\r\n    }\r\n\r\n    .default-pagination-active .paginate_button,\r\n    .default-pagination-active .paginate_button.disabled,\r\n    .default-pagination-active .ellipsis {\r\n        font-size: 14px;\r\n        border: none;\r\n        margin: 0;\r\n        padding: 9px 16px;\r\n        font-weight: bold;\r\n        color: #828282;\r\n        background: transparent;\r\n        border: 1px solid #E0E0E0;\r\n        text-decoration: none;\r\n        border-color: rgba(179, 179, 179, 0.3607843137);\r\n\r\n        &:hover {\r\n            background-color: rgba(0, 0, 0, 0.03);\r\n            border-color: #b3b3b35c;\r\n            color: rgba(56, 13, 13, .787) !important; // Get the jquery color \r\n        }\r\n\r\n        @media screen and (max-width: 770px) {\r\n            padding: 6px 9px !important;\r\n        }\r\n\r\n        @media screen and (max-width: 420px) {\r\n            padding: 3px 6px !important;\r\n            font-size: 12px;\r\n        }\r\n\r\n    }\r\n\r\n    // Fix this pagination globally for all theme frontend \r\n    .paginate_button.item:nth-child(n+5):not(.next):not(.active):not(.disabled):not(:nth-last-child(-n+2)) {\r\n        display: none;\r\n    }\r\n\r\n}\r\n\r\n\r\n//Dark Table - style-4 : new name: Simple on dark | Its alose added in _frontend.scss top 21 line\r\n//Dark Table - Style 4\r\n.gswpts_style-4.gswpts_style-4.gswpts_style-4 {\r\n\r\n    --header-bg-color: #000;\r\n    --header-text-color: #ffffff;\r\n\r\n    --body-bg-color: #000;\r\n    --body-text-color: #ffffff;\r\n\r\n    --hover-bg-color: #504949;\r\n    --pagination-colors: #000;\r\n\r\n    table {\r\n\r\n        thead th,\r\n        // Only header \r\n        tbody tr td {\r\n            background-color: var(--header-bg-color);\r\n            color: var(--header-text-color);\r\n            border: none;\r\n\r\n        }\r\n\r\n        // Full body \r\n        tbody tr td {\r\n            background-color: var(--body-bg-color);\r\n            color: var(--body-text-color);\r\n        }\r\n\r\n        th.thead-item.expanded_style {\r\n            text-align: left;\r\n        }\r\n\r\n        thead th {\r\n            border: none;\r\n        }\r\n\r\n        thead,\r\n        tbody {\r\n            tr:hover {\r\n\r\n                td,\r\n                th {\r\n                    background-color: var(--hover-bg-color);\r\n                }\r\n            }\r\n        }\r\n\r\n        a {\r\n            color: orange;\r\n\r\n            &:hover {\r\n                color: #2ecc40;\r\n            }\r\n        }\r\n\r\n        .sorting.sorting.sorting::after {\r\n            color: #fff;\r\n        }\r\n    }\r\n\r\n    &.collapse_style {\r\n        @include sorting-icon;\r\n    }\r\n\r\n    .simple-pagination-active .pagination.menu {\r\n        padding: 0 !important;\r\n        font-size: 14px;\r\n        background: transparent !important;\r\n        display: flex;\r\n        justify-content: center;\r\n        align-items: center;\r\n        flex-wrap: wrap;\r\n        border: none;\r\n        margin: 0 5px;\r\n\r\n        // Pagination \r\n        &>* {\r\n\r\n            &:hover {\r\n                background-color: rgba(0, 0, 0, 0.03);\r\n            }\r\n\r\n            @media screen and (max-width: 991px) {\r\n                padding: 4px 12px !important;\r\n            }\r\n\r\n            @media screen and (max-width: 770px) {\r\n                padding: 1px 9px !important;\r\n            }\r\n\r\n            @media screen and (max-width: 420px) {\r\n                padding: 1px 6px !important;\r\n                font-size: 12px;\r\n            }\r\n\r\n        }\r\n\r\n        a {\r\n            text-decoration: none;\r\n        }\r\n\r\n        .active {\r\n            background-color: var(--pagination-colors);\r\n            color: #ffffff;\r\n        }\r\n    }\r\n\r\n    .simple-pagination-active .paginate_button,\r\n    .simple-pagination-active .paginate_button.disabled,\r\n    .simple-pagination-active .ellipsis {\r\n        font-size: 14px;\r\n        border: none;\r\n        margin: 0;\r\n        padding: 9px 16px;\r\n        font-weight: bold;\r\n\r\n        &:hover {\r\n            background-color: rgba(0, 0, 0, 0.03);\r\n            border-color: #b3b3b35c;\r\n            color: rgba(56, 13, 13, .787) !important; // Get the jquery color \r\n        }\r\n\r\n        @media screen and (max-width: 770px) {\r\n            padding: 6px 9px !important;\r\n        }\r\n\r\n        @media screen and (max-width: 420px) {\r\n            padding: 3px 6px !important;\r\n            font-size: 12px;\r\n        }\r\n\r\n    }\r\n\r\n    #bottom_options #create_tables_paginate#create_tables_paginate {\r\n        margin-left: 40%;\r\n    }\r\n\r\n    .paginate_button.item:nth-child(n+5):not(.next):not(.active):not(.disabled):not(:nth-last-child(-n+2)) {\r\n        display: none;\r\n    }\r\n\r\n}\r\n\r\n// Theme Based support \r\n// Spectra and all other Theme \r\n.gswpts_tables_container {\r\n    table {\r\n        border-collapse: collapse;\r\n        border-spacing: 0;\r\n\r\n        td,\r\n        th {\r\n            padding: 0.7em 1em;\r\n        }\r\n    }\r\n\r\n    // Backend AI Summary Display Styling\r\n    .swptls-backend-summary.swptls-key-takeaways,\r\n    .swptls-backend-summary-display.swptls-key-takeaways {\r\n        background: #f8f9fa;\r\n        border: 1px solid #e9ecef;\r\n        border-radius: 8px;\r\n        padding: 20px;\r\n        margin: 20px 0;\r\n        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);\r\n\r\n        .swptls-summary-title {\r\n            color: #2c3e50;\r\n            font-size: 1.2em;\r\n            font-weight: 600;\r\n            margin: 0 0 15px 0;\r\n            padding: 0;\r\n            display: flex;\r\n            align-items: center;\r\n\r\n            .summary-icon {\r\n                margin-right: 8px;\r\n                font-size: 1.1em;\r\n            }\r\n\r\n            &:before {\r\n                content: \"🔍\";\r\n                margin-right: 8px;\r\n                font-size: 1.1em;\r\n            }\r\n        }\r\n\r\n        .swptls-summary-content {\r\n            color: #495057;\r\n            line-height: 1.6;\r\n            font-size: 0.95em;\r\n\r\n            p {\r\n                margin: 0 0 10px 0;\r\n\r\n                &:last-child {\r\n                    margin-bottom: 0;\r\n                }\r\n            }\r\n\r\n            strong {\r\n                color: #2c3e50;\r\n                font-weight: 600;\r\n            }\r\n\r\n            em {\r\n                font-style: italic;\r\n                color: #6c757d;\r\n            }\r\n        }\r\n\r\n        // Dark theme support\r\n        .gswpts_style-4 & {\r\n            background: #2c3e50;\r\n            border-color: #34495e;\r\n\r\n            .swptls-summary-title {\r\n                color: #ecf0f1;\r\n            }\r\n\r\n            .swptls-summary-content {\r\n                color: #bdc3c7;\r\n\r\n                strong {\r\n                    color: #ecf0f1;\r\n                }\r\n\r\n                em {\r\n                    color: #95a5a6;\r\n                }\r\n            }\r\n        }\r\n    }\r\n\r\n}","$link-color: #2ecc40;\r\n\r\n.create_tab_content {\r\n\r\n    .tabs {\r\n        position: relative;\r\n        $tabs-base-color: #fff;\r\n        list-style: none;\r\n        padding-left: 0;\r\n        display: flex;\r\n        flex-wrap: wrap;\r\n\r\n        input[type=\"radio\"] {\r\n            position: absolute;\r\n            top: 0;\r\n            left: -9999px;\r\n        }\r\n        label {\r\n            display: block;\r\n            padding: 8px 21px;\r\n            border-radius: 5px 5px 0 0;\r\n            border-bottom: 2px solid $link-color;\r\n            font-size: 1.2rem;\r\n            font-weight: bold;\r\n            // text-transform: capitalize;\r\n            background: $tabs-base-color;\r\n            cursor: pointer;\r\n            position: relative;\r\n            top: 4px;\r\n            transition: all 0.2s ease-in-out;\r\n            &:hover {\r\n                background: rgb(231, 235, 217);\r\n            }\r\n        }\r\n\r\n        [id^=\"tab\"]:checked + label {\r\n            top: 4px;\r\n            padding-top: 7px;\r\n            background: $link-color;\r\n            color: #fff;\r\n        }\r\n    }\r\n\r\n    .tab-content {\r\n        visibility: hidden;\r\n        opacity: 0;\r\n        width: 100%;\r\n        transition: all 0.1s ease-in;\r\n        height: 0;\r\n\r\n        .gswpts_tables_container {\r\n            margin: 0;\r\n            padding: 0;\r\n        }\r\n    }\r\n    .tab-content.active {\r\n        visibility: visible;\r\n        opacity: 1;\r\n        height: auto;\r\n    }\r\n\r\n    .unselectable {\r\n        user-select: none;\r\n    }\r\n\r\n    .hidden_tab_name {\r\n        display: none;\r\n        width: 110px !important;\r\n        padding: 6px 4px !important;\r\n    }\r\n\r\n    /* .tab_page_name {\r\n        text-transform: capitalize;\r\n    } */\r\n\r\n    .tab_name_label.active {\r\n        padding: 8px 5px;\r\n        transition: none;\r\n    }\r\n\r\n    .tab_name_label.active .tab_page_name {\r\n        display: none;\r\n    }\r\n\r\n    .tab_name_label.active .hidden_tab_name {\r\n        display: block;\r\n    }\r\n\r\n    .tab_name_label.active_transition {\r\n        transition: all 0.2s ease-in-out;\r\n    }\r\n    .tab_name_label.deactivate_transition {\r\n        transition: none;\r\n    }\r\n\r\n    .tab_name_box {\r\n        margin-bottom: 1rem;\r\n    }\r\n\r\n    .tabs_container.reverse {\r\n        display: flex;\r\n        flex-direction: column-reverse;\r\n        .tabs {\r\n            margin-bottom: 0;\r\n            margin-top: 1rem;\r\n\r\n            li {\r\n                margin-bottom: 0;\r\n                margin-top: 6px;\r\n            }\r\n\r\n            .tab_name_label {\r\n                margin-bottom: 0;\r\n                margin-top: 0.5rem;\r\n            }\r\n        }\r\n    }\r\n\r\n    @media screen and (max-width: 770px) {\r\n        .tab_right_side {\r\n            margin-top: 1.5rem;\r\n            padding-left: 0 !important;\r\n        }\r\n    }\r\n    \r\n    @media screen and (max-width: 680px) {\r\n        .tabs {\r\n            grid-row-gap: 10px;\r\n\r\n            li {\r\n                flex: 1 1 100px;\r\n            }\r\n        }\r\n        .tab_right_side {\r\n            margin-top: 1.5rem;\r\n            padding-left: 0 !important;\r\n        }\r\n    }\r\n}\r\n","@mixin button_style {\r\n    .ui.button {\r\n        cursor: pointer;\r\n        display: inline-block;\r\n        min-height: 1em;\r\n        outline: none;\r\n        border: none;\r\n        vertical-align: baseline;\r\n        background: #e0e1e2 none;\r\n        color: rgba(0, 0, 0, 0.6);\r\n        font-family: \"Lato\", \"Helvetica Neue\", Arial, Helvetica, sans-serif;\r\n        margin: 0em 0.25em 0em 0em;\r\n        // padding: 8px 12px;\r\n        padding: 3px 3px;\r\n        text-transform: none;\r\n        text-shadow: none;\r\n        font-weight: bold;\r\n        line-height: 1em;\r\n        font-style: normal;\r\n        text-align: center;\r\n        text-decoration: none;\r\n        border-radius: 0.28571429rem;\r\n        -webkit-box-shadow: 0px 0px 0px 1px transparent inset,\r\n            0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0px 0px 1px transparent inset, 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        -webkit-user-select: none;\r\n        -moz-user-select: none;\r\n        -ms-user-select: none;\r\n        user-select: none;\r\n        -webkit-transition: opacity 0.1s ease, background-color 0.1s ease, color 0.1s ease,\r\n            background 0.1s ease, -webkit-box-shadow 0.1s ease;\r\n        transition: opacity 0.1s ease, background-color 0.1s ease, color 0.1s ease,\r\n            background 0.1s ease, -webkit-box-shadow 0.1s ease;\r\n        transition: opacity 0.1s ease, background-color 0.1s ease, color 0.1s ease,\r\n            box-shadow 0.1s ease, background 0.1s ease;\r\n        transition: opacity 0.1s ease, background-color 0.1s ease, color 0.1s ease,\r\n            box-shadow 0.1s ease, background 0.1s ease, -webkit-box-shadow 0.1s ease;\r\n        will-change: \"\";\r\n        -webkit-tap-highlight-color: transparent;\r\n    }\r\n\r\n    /*******************************\r\n            States\r\n*******************************/\r\n    /*--------------\r\n      Hover\r\n---------------*/\r\n    .ui.button:hover {\r\n        background-color: #cacbcd;\r\n        background-image: none;\r\n        -webkit-box-shadow: 0px 0px 0px 1px transparent inset,\r\n            0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0px 0px 1px transparent inset, 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        color: rgba(0, 0, 0, 0.8);\r\n    }\r\n\r\n    .ui.button:hover .icon {\r\n        opacity: 0.85;\r\n    }\r\n\r\n    /*--------------\r\n      Focus\r\n---------------*/\r\n    .ui.button:focus {\r\n        background-color: #cacbcd;\r\n        color: rgba(0, 0, 0, 0.8);\r\n        background-image: \"\" !important;\r\n        -webkit-box-shadow: \"\" !important;\r\n        box-shadow: \"\" !important;\r\n    }\r\n\r\n    .ui.button:focus .icon {\r\n        opacity: 0.85;\r\n    }\r\n\r\n    /*--------------\r\n      Down\r\n---------------*/\r\n    .ui.button:active,\r\n    .ui.active.button:active {\r\n        background-color: #babbbc;\r\n        background-image: \"\";\r\n        color: rgba(0, 0, 0, 0.9);\r\n        -webkit-box-shadow: 0px 0px 0px 1px transparent inset, none;\r\n        box-shadow: 0px 0px 0px 1px transparent inset, none;\r\n    }\r\n\r\n    /*--------------\r\n     Active\r\n---------------*/\r\n    .ui.active.button {\r\n        background-color: #c0c1c2;\r\n        background-image: none;\r\n        -webkit-box-shadow: 0px 0px 0px 1px transparent inset;\r\n        box-shadow: 0px 0px 0px 1px transparent inset;\r\n        color: rgba(0, 0, 0, 0.95);\r\n    }\r\n\r\n    .ui.active.button:hover {\r\n        background-color: #c0c1c2;\r\n        background-image: none;\r\n        color: rgba(0, 0, 0, 0.95);\r\n    }\r\n\r\n    .ui.active.button:active {\r\n        background-color: #c0c1c2;\r\n        background-image: none;\r\n    }\r\n\r\n    /*--------------\r\n    Loading\r\n---------------*/\r\n    /* Specificity hack */\r\n    .ui.loading.loading.loading.loading.loading.loading.button {\r\n        position: relative;\r\n        cursor: default;\r\n        text-shadow: none !important;\r\n        color: transparent !important;\r\n        opacity: 1;\r\n        pointer-events: auto;\r\n        -webkit-transition: all 0s linear, opacity 0.1s ease;\r\n        transition: all 0s linear, opacity 0.1s ease;\r\n    }\r\n\r\n    .ui.loading.button:before {\r\n        position: absolute;\r\n        content: \"\";\r\n        top: 50%;\r\n        left: 50%;\r\n        margin: -0.64285714em 0em 0em -0.64285714em;\r\n        width: 1.28571429em;\r\n        height: 1.28571429em;\r\n        border-radius: 500rem;\r\n        border: 0.2em solid rgba(0, 0, 0, 0.15);\r\n    }\r\n\r\n    .ui.loading.button:after {\r\n        position: absolute;\r\n        content: \"\";\r\n        top: 50%;\r\n        left: 50%;\r\n        margin: -0.64285714em 0em 0em -0.64285714em;\r\n        width: 1.28571429em;\r\n        height: 1.28571429em;\r\n        -webkit-animation: button-spin 0.6s linear;\r\n        animation: button-spin 0.6s linear;\r\n        -webkit-animation-iteration-count: infinite;\r\n        animation-iteration-count: infinite;\r\n        border-radius: 500rem;\r\n        border-color: #ffffff transparent transparent;\r\n        border-style: solid;\r\n        border-width: 0.2em;\r\n        -webkit-box-shadow: 0px 0px 0px 1px transparent;\r\n        box-shadow: 0px 0px 0px 1px transparent;\r\n    }\r\n\r\n    .ui.labeled.icon.loading.button .icon {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: none;\r\n        box-shadow: none;\r\n    }\r\n\r\n    @-webkit-keyframes button-spin {\r\n        from {\r\n            -webkit-transform: rotate(0deg);\r\n            transform: rotate(0deg);\r\n        }\r\n\r\n        to {\r\n            -webkit-transform: rotate(360deg);\r\n            transform: rotate(360deg);\r\n        }\r\n    }\r\n\r\n    @keyframes button-spin {\r\n        from {\r\n            -webkit-transform: rotate(0deg);\r\n            transform: rotate(0deg);\r\n        }\r\n\r\n        to {\r\n            -webkit-transform: rotate(360deg);\r\n            transform: rotate(360deg);\r\n        }\r\n    }\r\n\r\n    .ui.basic.loading.button:not(.inverted):before {\r\n        border-color: rgba(0, 0, 0, 0.1);\r\n    }\r\n\r\n    .ui.basic.loading.button:not(.inverted):after {\r\n        border-top-color: #767676;\r\n    }\r\n\r\n    /*-------------------\r\n      Disabled\r\n--------------------*/\r\n    .ui.buttons .disabled.button,\r\n    .ui.disabled.button,\r\n    .ui.button:disabled,\r\n    .ui.disabled.button:hover,\r\n    .ui.disabled.active.button {\r\n        cursor: default;\r\n        opacity: 0.45 !important;\r\n        background-image: none !important;\r\n        -webkit-box-shadow: none !important;\r\n        box-shadow: none !important;\r\n        pointer-events: none !important;\r\n    }\r\n\r\n    /* Basic Group With Disabled */\r\n    .ui.basic.buttons .ui.disabled.button {\r\n        border-color: rgba(34, 36, 38, 0.5);\r\n    }\r\n\r\n    /*******************************\r\n             Types\r\n*******************************/\r\n    /*-------------------\r\n       Animated\r\n--------------------*/\r\n    .ui.animated.button {\r\n        position: relative;\r\n        overflow: hidden;\r\n        padding-right: 0em !important;\r\n        vertical-align: middle;\r\n        z-index: 1;\r\n    }\r\n\r\n    .ui.animated.button .content {\r\n        will-change: transform, opacity;\r\n    }\r\n\r\n    .ui.animated.button .visible.content {\r\n        position: relative;\r\n        margin-right: 1.5em;\r\n    }\r\n\r\n    .ui.animated.button .hidden.content {\r\n        position: absolute;\r\n        width: 100%;\r\n    }\r\n\r\n    /* Horizontal */\r\n    .ui.animated.button .visible.content,\r\n    .ui.animated.button .hidden.content {\r\n        -webkit-transition: right 0.3s ease 0s;\r\n        transition: right 0.3s ease 0s;\r\n    }\r\n\r\n    .ui.animated.button .visible.content {\r\n        left: auto;\r\n        right: 0%;\r\n    }\r\n\r\n    .ui.animated.button .hidden.content {\r\n        top: 50%;\r\n        left: auto;\r\n        right: -100%;\r\n        margin-top: -0.5em;\r\n    }\r\n\r\n    .ui.animated.button:focus .visible.content,\r\n    .ui.animated.button:hover .visible.content {\r\n        left: auto;\r\n        right: 200%;\r\n    }\r\n\r\n    .ui.animated.button:focus .hidden.content,\r\n    .ui.animated.button:hover .hidden.content {\r\n        left: auto;\r\n        right: 0%;\r\n    }\r\n\r\n    /* Vertical */\r\n    .ui.vertical.animated.button .visible.content,\r\n    .ui.vertical.animated.button .hidden.content {\r\n        -webkit-transition: top 0.3s ease, -webkit-transform 0.3s ease;\r\n        transition: top 0.3s ease, -webkit-transform 0.3s ease;\r\n        transition: top 0.3s ease, transform 0.3s ease;\r\n        transition: top 0.3s ease, transform 0.3s ease, -webkit-transform 0.3s ease;\r\n    }\r\n\r\n    .ui.vertical.animated.button .visible.content {\r\n        -webkit-transform: translateY(0%);\r\n        transform: translateY(0%);\r\n        right: auto;\r\n    }\r\n\r\n    .ui.vertical.animated.button .hidden.content {\r\n        top: -50%;\r\n        left: 0%;\r\n        right: auto;\r\n    }\r\n\r\n    .ui.vertical.animated.button:focus .visible.content,\r\n    .ui.vertical.animated.button:hover .visible.content {\r\n        -webkit-transform: translateY(200%);\r\n        transform: translateY(200%);\r\n        right: auto;\r\n    }\r\n\r\n    .ui.vertical.animated.button:focus .hidden.content,\r\n    .ui.vertical.animated.button:hover .hidden.content {\r\n        top: 50%;\r\n        right: auto;\r\n    }\r\n\r\n    /* Fade */\r\n    .ui.fade.animated.button .visible.content,\r\n    .ui.fade.animated.button .hidden.content {\r\n        -webkit-transition: opacity 0.3s ease, -webkit-transform 0.3s ease;\r\n        transition: opacity 0.3s ease, -webkit-transform 0.3s ease;\r\n        transition: opacity 0.3s ease, transform 0.3s ease;\r\n        transition: opacity 0.3s ease, transform 0.3s ease, -webkit-transform 0.3s ease;\r\n    }\r\n\r\n    .ui.fade.animated.button .visible.content {\r\n        left: auto;\r\n        right: auto;\r\n        opacity: 1;\r\n        -webkit-transform: scale(1);\r\n        transform: scale(1);\r\n    }\r\n\r\n    .ui.fade.animated.button .hidden.content {\r\n        opacity: 0;\r\n        left: 0%;\r\n        right: auto;\r\n        -webkit-transform: scale(1.5);\r\n        transform: scale(1.5);\r\n    }\r\n\r\n    .ui.fade.animated.button:focus .visible.content,\r\n    .ui.fade.animated.button:hover .visible.content {\r\n        left: auto;\r\n        right: auto;\r\n        opacity: 0;\r\n        -webkit-transform: scale(0.75);\r\n        transform: scale(0.75);\r\n    }\r\n\r\n    .ui.fade.animated.button:focus .hidden.content,\r\n    .ui.fade.animated.button:hover .hidden.content {\r\n        left: 0%;\r\n        right: auto;\r\n        opacity: 1;\r\n        -webkit-transform: scale(1);\r\n        transform: scale(1);\r\n    }\r\n\r\n    /*-------------------\r\n       Inverted\r\n--------------------*/\r\n    .ui.inverted.button {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ffffff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ffffff inset !important;\r\n        background: transparent none;\r\n        color: #ffffff;\r\n        text-shadow: none !important;\r\n    }\r\n\r\n    /* Group */\r\n    .ui.inverted.buttons .button {\r\n        margin: 0px 0px 0px -2px;\r\n    }\r\n\r\n    .ui.inverted.buttons .button:first-child {\r\n        margin-left: 0em;\r\n    }\r\n\r\n    .ui.inverted.vertical.buttons .button {\r\n        margin: 0px 0px -2px 0px;\r\n    }\r\n\r\n    .ui.inverted.vertical.buttons .button:first-child {\r\n        margin-top: 0em;\r\n    }\r\n\r\n    /* States */\r\n    /* Hover */\r\n    .ui.inverted.button:hover {\r\n        background: #ffffff;\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ffffff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ffffff inset !important;\r\n        color: rgba(0, 0, 0, 0.8);\r\n    }\r\n\r\n    /* Active / Focus */\r\n    .ui.inverted.button:focus,\r\n    .ui.inverted.button.active {\r\n        background: #ffffff;\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ffffff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ffffff inset !important;\r\n        color: rgba(0, 0, 0, 0.8);\r\n    }\r\n\r\n    /* Active Focus */\r\n    .ui.inverted.button.active:focus {\r\n        background: #dcddde;\r\n        -webkit-box-shadow: 0px 0px 0px 2px #dcddde inset !important;\r\n        box-shadow: 0px 0px 0px 2px #dcddde inset !important;\r\n        color: rgba(0, 0, 0, 0.8);\r\n    }\r\n\r\n    /*-------------------\r\n    Labeled Button\r\n--------------------*/\r\n    .ui.labeled.button:not(.icon) {\r\n        display: -webkit-inline-box;\r\n        display: -ms-inline-flexbox;\r\n        display: inline-flex;\r\n        -webkit-box-orient: horizontal;\r\n        -webkit-box-direction: normal;\r\n        -ms-flex-direction: row;\r\n        flex-direction: row;\r\n        background: none !important;\r\n        padding: 0px !important;\r\n        border: none !important;\r\n        -webkit-box-shadow: none !important;\r\n        box-shadow: none !important;\r\n    }\r\n\r\n    .ui.labeled.button>.button {\r\n        margin: 0px;\r\n    }\r\n\r\n    .ui.labeled.button>.label {\r\n        display: -webkit-box;\r\n        display: -ms-flexbox;\r\n        display: flex;\r\n        -webkit-box-align: center;\r\n        -ms-flex-align: center;\r\n        align-items: center;\r\n        margin: 0px 0px 0px -1px !important;\r\n        padding: \"\";\r\n        font-size: 1em;\r\n        border-color: rgba(34, 36, 38, 0.15);\r\n    }\r\n\r\n    /* Tag */\r\n    .ui.labeled.button>.tag.label:before {\r\n        width: 1.85em;\r\n        height: 1.85em;\r\n    }\r\n\r\n    /* Right */\r\n    .ui.labeled.button:not([class*=\"left labeled\"])>.button {\r\n        border-top-right-radius: 0px;\r\n        border-bottom-right-radius: 0px;\r\n    }\r\n\r\n    .ui.labeled.button:not([class*=\"left labeled\"])>.label {\r\n        border-top-left-radius: 0px;\r\n        border-bottom-left-radius: 0px;\r\n    }\r\n\r\n    /* Left Side */\r\n    .ui[class*=\"left labeled\"].button>.button {\r\n        border-top-left-radius: 0px;\r\n        border-bottom-left-radius: 0px;\r\n    }\r\n\r\n    .ui[class*=\"left labeled\"].button>.label {\r\n        border-top-right-radius: 0px;\r\n        border-bottom-right-radius: 0px;\r\n    }\r\n\r\n    /*-------------------\r\n       Social\r\n--------------------*/\r\n    /* Facebook */\r\n    .ui.facebook.button {\r\n        background-color: #3b5998;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.facebook.button:hover {\r\n        background-color: #304d8a;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.facebook.button:active {\r\n        background-color: #2d4373;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* Twitter */\r\n    .ui.twitter.button {\r\n        background-color: #55acee;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.twitter.button:hover {\r\n        background-color: #35a2f4;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.twitter.button:active {\r\n        background-color: #2795e9;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* Google Plus */\r\n    .ui.google.plus.button {\r\n        background-color: #dd4b39;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.google.plus.button:hover {\r\n        background-color: #e0321c;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.google.plus.button:active {\r\n        background-color: #c23321;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* Linked In */\r\n    .ui.linkedin.button {\r\n        background-color: #1f88be;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.linkedin.button:hover {\r\n        background-color: #147baf;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.linkedin.button:active {\r\n        background-color: #186992;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* YouTube */\r\n    .ui.youtube.button {\r\n        background-color: #ff0000;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.youtube.button:hover {\r\n        background-color: #e60000;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.youtube.button:active {\r\n        background-color: #cc0000;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* Instagram */\r\n    .ui.instagram.button {\r\n        background-color: #49769c;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.instagram.button:hover {\r\n        background-color: #3d698e;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.instagram.button:active {\r\n        background-color: #395c79;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* Pinterest */\r\n    .ui.pinterest.button {\r\n        background-color: #bd081c;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.pinterest.button:hover {\r\n        background-color: #ac0013;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.pinterest.button:active {\r\n        background-color: #8c0615;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* VK */\r\n    .ui.vk.button {\r\n        background-color: #4d7198;\r\n        color: #ffffff;\r\n        background-image: none;\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.vk.button:hover {\r\n        background-color: #41648a;\r\n        color: #ffffff;\r\n    }\r\n\r\n    .ui.vk.button:active {\r\n        background-color: #3c5876;\r\n        color: #ffffff;\r\n    }\r\n\r\n    /*--------------\r\n     Icon\r\n---------------*/\r\n    .ui.button>.icon:not(.button) {\r\n        height: 0.85714286em;\r\n        opacity: 0.8;\r\n        margin: 0em 0.42857143em 0em -0.21428571em;\r\n        -webkit-transition: opacity 0.1s ease;\r\n        transition: opacity 0.1s ease;\r\n        vertical-align: \"\";\r\n        color: \"\";\r\n    }\r\n\r\n    .ui.button:not(.icon)>.icon:not(.button):not(.dropdown) {\r\n        margin: 0em 0.42857143em 0em -0.21428571em;\r\n    }\r\n\r\n    .ui.button:not(.icon)>.right.icon:not(.button):not(.dropdown) {\r\n        margin: 0em -0.21428571em 0em 0.42857143em;\r\n    }\r\n\r\n    /*******************************\r\n           Variations\r\n*******************************/\r\n    /*-------------------\r\n       Floated\r\n--------------------*/\r\n    .ui[class*=\"left floated\"].buttons,\r\n    .ui[class*=\"left floated\"].button {\r\n        float: left;\r\n        margin-left: 0em;\r\n        margin-right: 0.25em;\r\n    }\r\n\r\n    .ui[class*=\"right floated\"].buttons,\r\n    .ui[class*=\"right floated\"].button {\r\n        float: right;\r\n        margin-right: 0em;\r\n        margin-left: 0.25em;\r\n    }\r\n\r\n    /*-------------------\r\n       Compact\r\n--------------------*/\r\n    .ui.compact.buttons .button,\r\n    .ui.compact.button {\r\n        padding: 0.58928571em 1.125em 0.58928571em;\r\n    }\r\n\r\n    .ui.compact.icon.buttons .button,\r\n    .ui.compact.icon.button {\r\n        padding: 0.58928571em 0.58928571em 0.58928571em;\r\n    }\r\n\r\n    .ui.compact.labeled.icon.buttons .button,\r\n    .ui.compact.labeled.icon.button {\r\n        padding: 0.58928571em 3.69642857em 0.58928571em;\r\n    }\r\n\r\n    /*-------------------\r\n        Sizes\r\n--------------------*/\r\n    .ui.mini.buttons .button,\r\n    .ui.mini.buttons .or,\r\n    .ui.mini.button {\r\n        font-size: 0.78571429rem;\r\n    }\r\n\r\n    .ui.tiny.buttons .button,\r\n    .ui.tiny.buttons .or,\r\n    .ui.tiny.button {\r\n        font-size: 0.85714286rem;\r\n    }\r\n\r\n    .ui.small.buttons .button,\r\n    .ui.small.buttons .or,\r\n    .ui.small.button {\r\n        font-size: 0.92857143rem;\r\n    }\r\n\r\n    .ui.buttons .button,\r\n    .ui.buttons .or,\r\n    .ui.button {\r\n        font-size: 1rem;\r\n    }\r\n\r\n    .ui.large.buttons .button,\r\n    .ui.large.buttons .or,\r\n    .ui.large.button {\r\n        font-size: 1.14285714rem;\r\n    }\r\n\r\n    .ui.big.buttons .button,\r\n    .ui.big.buttons .or,\r\n    .ui.big.button {\r\n        font-size: 1.28571429rem;\r\n    }\r\n\r\n    .ui.huge.buttons .button,\r\n    .ui.huge.buttons .or,\r\n    .ui.huge.button {\r\n        font-size: 1.42857143rem;\r\n    }\r\n\r\n    .ui.massive.buttons .button,\r\n    .ui.massive.buttons .or,\r\n    .ui.massive.button {\r\n        font-size: 1.71428571rem;\r\n    }\r\n\r\n    /*--------------\r\n    Icon Only\r\n---------------*/\r\n    .ui.icon.buttons .button,\r\n    .ui.icon.button {\r\n        padding: 0.78571429em 0.78571429em 0.78571429em;\r\n    }\r\n\r\n    .ui.icon.buttons .button>.icon,\r\n    .ui.icon.button>.icon {\r\n        opacity: 0.9;\r\n        margin: 0em !important;\r\n        vertical-align: top;\r\n    }\r\n\r\n    /*-------------------\r\n        Basic\r\n--------------------*/\r\n    .ui.basic.buttons .button,\r\n    .ui.basic.button {\r\n        background: transparent none !important;\r\n        color: rgba(0, 0, 0, 0.6) !important;\r\n        font-weight: normal;\r\n        border-radius: 0.28571429rem;\r\n        text-transform: none;\r\n        text-shadow: none !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0px 0px 1px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.basic.buttons {\r\n        -webkit-box-shadow: none;\r\n        box-shadow: none;\r\n        border: 1px solid rgba(34, 36, 38, 0.15);\r\n        border-radius: 0.28571429rem;\r\n    }\r\n\r\n    .ui.basic.buttons .button {\r\n        border-radius: 0em;\r\n    }\r\n\r\n    .ui.basic.buttons .button:hover,\r\n    .ui.basic.button:hover {\r\n        background: #ffffff !important;\r\n        color: rgba(0, 0, 0, 0.8) !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px rgba(34, 36, 38, 0.35) inset,\r\n            0px 0px 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0px 0px 1px rgba(34, 36, 38, 0.35) inset,\r\n            0px 0px 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.basic.buttons .button:focus,\r\n    .ui.basic.button:focus {\r\n        background: #ffffff !important;\r\n        color: rgba(0, 0, 0, 0.8) !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px rgba(34, 36, 38, 0.35) inset,\r\n            0px 0px 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0px 0px 1px rgba(34, 36, 38, 0.35) inset,\r\n            0px 0px 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.basic.buttons .button:active,\r\n    .ui.basic.button:active {\r\n        background: #f8f8f8 !important;\r\n        color: rgba(0, 0, 0, 0.9) !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px rgba(0, 0, 0, 0.15) inset,\r\n            0px 1px 4px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0px 0px 1px rgba(0, 0, 0, 0.15) inset,\r\n            0px 1px 4px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.basic.buttons .active.button,\r\n    .ui.basic.active.button {\r\n        background: rgba(0, 0, 0, 0.05) !important;\r\n        -webkit-box-shadow: \"\" !important;\r\n        box-shadow: \"\" !important;\r\n        color: rgba(0, 0, 0, 0.95) !important;\r\n    }\r\n\r\n    .ui.basic.buttons .active.button:hover,\r\n    .ui.basic.active.button:hover {\r\n        background-color: rgba(0, 0, 0, 0.05);\r\n    }\r\n\r\n    /* Vertical */\r\n    .ui.basic.buttons .button:hover {\r\n        -webkit-box-shadow: 0px 0px 0px 1px rgba(34, 36, 38, 0.35) inset,\r\n            0px 0px 0px 0px rgba(34, 36, 38, 0.15) inset inset;\r\n        box-shadow: 0px 0px 0px 1px rgba(34, 36, 38, 0.35) inset,\r\n            0px 0px 0px 0px rgba(34, 36, 38, 0.15) inset inset;\r\n    }\r\n\r\n    .ui.basic.buttons .button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 1px rgba(0, 0, 0, 0.15) inset,\r\n            0px 1px 4px 0px rgba(34, 36, 38, 0.15) inset inset;\r\n        box-shadow: 0px 0px 0px 1px rgba(0, 0, 0, 0.15) inset,\r\n            0px 1px 4px 0px rgba(34, 36, 38, 0.15) inset inset;\r\n    }\r\n\r\n    .ui.basic.buttons .active.button {\r\n        -webkit-box-shadow: \"\" !important;\r\n        box-shadow: \"\" !important;\r\n    }\r\n\r\n    /* Standard Basic Inverted */\r\n    .ui.basic.inverted.buttons .button,\r\n    .ui.basic.inverted.button {\r\n        background-color: transparent !important;\r\n        color: #f9fafb !important;\r\n        -webkit-box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n    }\r\n\r\n    .ui.basic.inverted.buttons .button:hover,\r\n    .ui.basic.inverted.button:hover {\r\n        color: #ffffff !important;\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ffffff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ffffff inset !important;\r\n    }\r\n\r\n    .ui.basic.inverted.buttons .button:focus,\r\n    .ui.basic.inverted.button:focus {\r\n        color: #ffffff !important;\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ffffff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ffffff inset !important;\r\n    }\r\n\r\n    .ui.basic.inverted.buttons .button:active,\r\n    .ui.basic.inverted.button:active {\r\n        background-color: rgba(255, 255, 255, 0.08) !important;\r\n        color: #ffffff !important;\r\n        -webkit-box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.9) inset !important;\r\n        box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.9) inset !important;\r\n    }\r\n\r\n    .ui.basic.inverted.buttons .active.button,\r\n    .ui.basic.inverted.active.button {\r\n        background-color: rgba(255, 255, 255, 0.08);\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        -webkit-box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.7) inset;\r\n        box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.7) inset;\r\n    }\r\n\r\n    .ui.basic.inverted.buttons .active.button:hover,\r\n    .ui.basic.inverted.active.button:hover {\r\n        background-color: rgba(255, 255, 255, 0.15);\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ffffff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ffffff inset !important;\r\n    }\r\n\r\n    /* Basic Group */\r\n    .ui.basic.buttons .button {\r\n        border-left: 1px solid rgba(34, 36, 38, 0.15);\r\n        -webkit-box-shadow: none;\r\n        box-shadow: none;\r\n    }\r\n\r\n    .ui.basic.vertical.buttons .button {\r\n        border-left: none;\r\n    }\r\n\r\n    .ui.basic.vertical.buttons .button {\r\n        border-left-width: 0px;\r\n        border-top: 1px solid rgba(34, 36, 38, 0.15);\r\n    }\r\n\r\n    .ui.basic.vertical.buttons .button:first-child {\r\n        border-top-width: 0px;\r\n    }\r\n\r\n    /*--------------\r\n  Labeled Icon\r\n---------------*/\r\n    .ui.labeled.icon.buttons .button,\r\n    .ui.labeled.icon.button {\r\n        position: relative;\r\n        padding-left: 4.07142857em !important;\r\n        padding-right: 1.5em !important;\r\n    }\r\n\r\n    /* Left Labeled */\r\n    .ui.labeled.icon.buttons>.button>.icon,\r\n    .ui.labeled.icon.button>.icon {\r\n        position: absolute;\r\n        height: 100%;\r\n        line-height: 1;\r\n        border-radius: 0px;\r\n        border-top-left-radius: inherit;\r\n        border-bottom-left-radius: inherit;\r\n        text-align: center;\r\n        margin: 0em;\r\n        width: 2.57142857em;\r\n        background-color: rgba(0, 0, 0, 0.05);\r\n        color: \"\";\r\n        -webkit-box-shadow: -1px 0px 0px 0px transparent inset;\r\n        box-shadow: -1px 0px 0px 0px transparent inset;\r\n    }\r\n\r\n    /* Left Labeled */\r\n    .ui.labeled.icon.buttons>.button>.icon,\r\n    .ui.labeled.icon.button>.icon {\r\n        top: 0em;\r\n        left: 0em;\r\n    }\r\n\r\n    /* Right Labeled */\r\n    .ui[class*=\"right labeled\"].icon.button {\r\n        padding-right: 4.07142857em !important;\r\n        padding-left: 1.5em !important;\r\n    }\r\n\r\n    .ui[class*=\"right labeled\"].icon.button>.icon {\r\n        left: auto;\r\n        right: 0em;\r\n        border-radius: 0px;\r\n        border-top-right-radius: inherit;\r\n        border-bottom-right-radius: inherit;\r\n        -webkit-box-shadow: 1px 0px 0px 0px transparent inset;\r\n        box-shadow: 1px 0px 0px 0px transparent inset;\r\n    }\r\n\r\n    .ui.labeled.icon.buttons>.button>.icon:before,\r\n    .ui.labeled.icon.button>.icon:before,\r\n    .ui.labeled.icon.buttons>.button>.icon:after,\r\n    .ui.labeled.icon.button>.icon:after {\r\n        display: block;\r\n        position: absolute;\r\n        width: 100%;\r\n        top: 50%;\r\n        text-align: center;\r\n        -webkit-transform: translateY(-50%);\r\n        transform: translateY(-50%);\r\n    }\r\n\r\n    .ui.labeled.icon.buttons .button>.icon {\r\n        border-radius: 0em;\r\n    }\r\n\r\n    .ui.labeled.icon.buttons .button:first-child>.icon {\r\n        border-top-left-radius: 0.28571429rem;\r\n        border-bottom-left-radius: 0.28571429rem;\r\n    }\r\n\r\n    .ui.labeled.icon.buttons .button:last-child>.icon {\r\n        border-top-right-radius: 0.28571429rem;\r\n        border-bottom-right-radius: 0.28571429rem;\r\n    }\r\n\r\n    .ui.vertical.labeled.icon.buttons .button:first-child>.icon {\r\n        border-radius: 0em;\r\n        border-top-left-radius: 0.28571429rem;\r\n    }\r\n\r\n    .ui.vertical.labeled.icon.buttons .button:last-child>.icon {\r\n        border-radius: 0em;\r\n        border-bottom-left-radius: 0.28571429rem;\r\n    }\r\n\r\n    /* Fluid Labeled */\r\n    .ui.fluid[class*=\"left labeled\"].icon.button,\r\n    .ui.fluid[class*=\"right labeled\"].icon.button {\r\n        padding-left: 1.5em !important;\r\n        padding-right: 1.5em !important;\r\n    }\r\n\r\n    /*--------------\r\n     Toggle\r\n---------------*/\r\n    /* Toggle (Modifies active state to give affordances) */\r\n    .ui.toggle.buttons .active.button,\r\n    .ui.buttons .button.toggle.active,\r\n    .ui.button.toggle.active {\r\n        background-color: #21ba45 !important;\r\n        -webkit-box-shadow: none !important;\r\n        box-shadow: none !important;\r\n        text-shadow: none;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    .ui.button.toggle.active:hover {\r\n        background-color: #16ab39 !important;\r\n        text-shadow: none;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    /*--------------\r\n    Circular\r\n---------------*/\r\n    .ui.circular.button {\r\n        border-radius: 10em;\r\n    }\r\n\r\n    .ui.circular.button>.icon {\r\n        width: 1em;\r\n        vertical-align: baseline;\r\n    }\r\n\r\n    /*-------------------\r\n      Or Buttons\r\n--------------------*/\r\n    .ui.buttons .or {\r\n        position: relative;\r\n        width: 0.3em;\r\n        height: 2.57142857em;\r\n        z-index: 3;\r\n    }\r\n\r\n    .ui.buttons .or:before {\r\n        position: absolute;\r\n        text-align: center;\r\n        border-radius: 500rem;\r\n        content: \"or\";\r\n        top: 50%;\r\n        left: 50%;\r\n        background-color: #ffffff;\r\n        text-shadow: none;\r\n        margin-top: -0.89285714em;\r\n        margin-left: -0.89285714em;\r\n        width: 1.78571429em;\r\n        height: 1.78571429em;\r\n        line-height: 1.78571429em;\r\n        color: rgba(0, 0, 0, 0.4);\r\n        font-style: normal;\r\n        font-weight: bold;\r\n        -webkit-box-shadow: 0px 0px 0px 1px transparent inset;\r\n        box-shadow: 0px 0px 0px 1px transparent inset;\r\n    }\r\n\r\n    .ui.buttons .or[data-text]:before {\r\n        content: attr(data-text);\r\n    }\r\n\r\n    /* Fluid Or */\r\n    .ui.fluid.buttons .or {\r\n        width: 0em !important;\r\n    }\r\n\r\n    .ui.fluid.buttons .or:after {\r\n        display: none;\r\n    }\r\n\r\n    /*-------------------\r\n       Attached\r\n--------------------*/\r\n    /* Singular */\r\n    .ui.attached.button {\r\n        position: relative;\r\n        display: block;\r\n        margin: 0em;\r\n        border-radius: 0em;\r\n        -webkit-box-shadow: 0px 0px 0px 1px rgba(34, 36, 38, 0.15) !important;\r\n        box-shadow: 0px 0px 0px 1px rgba(34, 36, 38, 0.15) !important;\r\n    }\r\n\r\n    /* Top / Bottom */\r\n    .ui.attached.top.button {\r\n        border-radius: 0.28571429rem 0.28571429rem 0em 0em;\r\n    }\r\n\r\n    .ui.attached.bottom.button {\r\n        border-radius: 0em 0em 0.28571429rem 0.28571429rem;\r\n    }\r\n\r\n    /* Left / Right */\r\n    .ui.left.attached.button {\r\n        display: inline-block;\r\n        border-left: none;\r\n        text-align: right;\r\n        padding-right: 0.75em;\r\n        border-radius: 0.28571429rem 0em 0em 0.28571429rem;\r\n    }\r\n\r\n    .ui.right.attached.button {\r\n        display: inline-block;\r\n        text-align: left;\r\n        padding-left: 0.75em;\r\n        border-radius: 0em 0.28571429rem 0.28571429rem 0em;\r\n    }\r\n\r\n    /* Plural */\r\n    .ui.attached.buttons {\r\n        position: relative;\r\n        display: -webkit-box;\r\n        display: -ms-flexbox;\r\n        display: flex;\r\n        border-radius: 0em;\r\n        width: auto !important;\r\n        z-index: 2;\r\n        margin-left: -1px;\r\n        margin-right: -1px;\r\n    }\r\n\r\n    .ui.attached.buttons .button {\r\n        margin: 0em;\r\n    }\r\n\r\n    .ui.attached.buttons .button:first-child {\r\n        border-radius: 0em;\r\n    }\r\n\r\n    .ui.attached.buttons .button:last-child {\r\n        border-radius: 0em;\r\n    }\r\n\r\n    /* Top / Bottom */\r\n    .ui[class*=\"top attached\"].buttons {\r\n        margin-bottom: -1px;\r\n        border-radius: 0.28571429rem 0.28571429rem 0em 0em;\r\n    }\r\n\r\n    .ui[class*=\"top attached\"].buttons .button:first-child {\r\n        border-radius: 0.28571429rem 0em 0em 0em;\r\n    }\r\n\r\n    .ui[class*=\"top attached\"].buttons .button:last-child {\r\n        border-radius: 0em 0.28571429rem 0em 0em;\r\n    }\r\n\r\n    .ui[class*=\"bottom attached\"].buttons {\r\n        margin-top: -1px;\r\n        border-radius: 0em 0em 0.28571429rem 0.28571429rem;\r\n    }\r\n\r\n    .ui[class*=\"bottom attached\"].buttons .button:first-child {\r\n        border-radius: 0em 0em 0em 0.28571429rem;\r\n    }\r\n\r\n    .ui[class*=\"bottom attached\"].buttons .button:last-child {\r\n        border-radius: 0em 0em 0.28571429rem 0em;\r\n    }\r\n\r\n    /* Left / Right */\r\n    .ui[class*=\"left attached\"].buttons {\r\n        display: -webkit-inline-box;\r\n        display: -ms-inline-flexbox;\r\n        display: inline-flex;\r\n        margin-right: 0em;\r\n        margin-left: -1px;\r\n        border-radius: 0em 0.28571429rem 0.28571429rem 0em;\r\n    }\r\n\r\n    .ui[class*=\"left attached\"].buttons .button:first-child {\r\n        margin-left: -1px;\r\n        border-radius: 0em 0.28571429rem 0em 0em;\r\n    }\r\n\r\n    .ui[class*=\"left attached\"].buttons .button:last-child {\r\n        margin-left: -1px;\r\n        border-radius: 0em 0em 0.28571429rem 0em;\r\n    }\r\n\r\n    .ui[class*=\"right attached\"].buttons {\r\n        display: -webkit-inline-box;\r\n        display: -ms-inline-flexbox;\r\n        display: inline-flex;\r\n        margin-left: 0em;\r\n        margin-right: -1px;\r\n        border-radius: 0.28571429rem 0em 0em 0.28571429rem;\r\n    }\r\n\r\n    .ui[class*=\"right attached\"].buttons .button:first-child {\r\n        margin-left: -1px;\r\n        border-radius: 0.28571429rem 0em 0em 0em;\r\n    }\r\n\r\n    .ui[class*=\"right attached\"].buttons .button:last-child {\r\n        margin-left: -1px;\r\n        border-radius: 0em 0em 0em 0.28571429rem;\r\n    }\r\n\r\n    /*-------------------\r\n        Fluid\r\n--------------------*/\r\n    .ui.fluid.buttons,\r\n    .ui.fluid.button {\r\n        width: 100%;\r\n    }\r\n\r\n    .ui.fluid.button {\r\n        display: block;\r\n    }\r\n\r\n    .ui.two.buttons {\r\n        width: 100%;\r\n    }\r\n\r\n    .ui.two.buttons>.button {\r\n        width: 50%;\r\n    }\r\n\r\n    .ui.three.buttons {\r\n        width: 100%;\r\n    }\r\n\r\n    .ui.three.buttons>.button {\r\n        width: 33.333%;\r\n    }\r\n\r\n    .ui.four.buttons {\r\n        width: 100%;\r\n    }\r\n\r\n    .ui.four.buttons>.button {\r\n        width: 25%;\r\n    }\r\n\r\n    .ui.five.buttons {\r\n        width: 100%;\r\n    }\r\n\r\n    .ui.five.buttons>.button {\r\n        width: 20%;\r\n    }\r\n\r\n    .ui.six.buttons {\r\n        width: 100%;\r\n    }\r\n\r\n    .ui.six.buttons>.button {\r\n        width: 16.666%;\r\n    }\r\n\r\n    .ui.seven.buttons {\r\n        width: 100%;\r\n    }\r\n\r\n    .ui.seven.buttons>.button {\r\n        width: 14.285%;\r\n    }\r\n\r\n    .ui.eight.buttons {\r\n        width: 100%;\r\n    }\r\n\r\n    .ui.eight.buttons>.button {\r\n        width: 12.5%;\r\n    }\r\n\r\n    .ui.nine.buttons {\r\n        width: 100%;\r\n    }\r\n\r\n    .ui.nine.buttons>.button {\r\n        width: 11.11%;\r\n    }\r\n\r\n    .ui.ten.buttons {\r\n        width: 100%;\r\n    }\r\n\r\n    .ui.ten.buttons>.button {\r\n        width: 10%;\r\n    }\r\n\r\n    .ui.eleven.buttons {\r\n        width: 100%;\r\n    }\r\n\r\n    .ui.eleven.buttons>.button {\r\n        width: 9.09%;\r\n    }\r\n\r\n    .ui.twelve.buttons {\r\n        width: 100%;\r\n    }\r\n\r\n    .ui.twelve.buttons>.button {\r\n        width: 8.3333%;\r\n    }\r\n\r\n    /* Fluid Vertical Buttons */\r\n    .ui.fluid.vertical.buttons,\r\n    .ui.fluid.vertical.buttons>.button {\r\n        display: -webkit-box;\r\n        display: -ms-flexbox;\r\n        display: flex;\r\n        width: auto;\r\n    }\r\n\r\n    .ui.two.vertical.buttons>.button {\r\n        height: 50%;\r\n    }\r\n\r\n    .ui.three.vertical.buttons>.button {\r\n        height: 33.333%;\r\n    }\r\n\r\n    .ui.four.vertical.buttons>.button {\r\n        height: 25%;\r\n    }\r\n\r\n    .ui.five.vertical.buttons>.button {\r\n        height: 20%;\r\n    }\r\n\r\n    .ui.six.vertical.buttons>.button {\r\n        height: 16.666%;\r\n    }\r\n\r\n    .ui.seven.vertical.buttons>.button {\r\n        height: 14.285%;\r\n    }\r\n\r\n    .ui.eight.vertical.buttons>.button {\r\n        height: 12.5%;\r\n    }\r\n\r\n    .ui.nine.vertical.buttons>.button {\r\n        height: 11.11%;\r\n    }\r\n\r\n    .ui.ten.vertical.buttons>.button {\r\n        height: 10%;\r\n    }\r\n\r\n    .ui.eleven.vertical.buttons>.button {\r\n        height: 9.09%;\r\n    }\r\n\r\n    .ui.twelve.vertical.buttons>.button {\r\n        height: 8.3333%;\r\n    }\r\n\r\n    /*-------------------\r\n       Colors\r\n--------------------*/\r\n    /*--- Black ---*/\r\n    .ui.black.buttons .button,\r\n    .ui.black.button {\r\n        background-color: #1b1c1d;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n    }\r\n\r\n    .ui.black.button {\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.black.buttons .button:hover,\r\n    .ui.black.button:hover {\r\n        background-color: #27292a;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.black.buttons .button:focus,\r\n    .ui.black.button:focus {\r\n        background-color: #2f3032;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.black.buttons .button:active,\r\n    .ui.black.button:active {\r\n        background-color: #343637;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.black.buttons .active.button,\r\n    .ui.black.buttons .active.button:active,\r\n    .ui.black.active.button,\r\n    .ui.black.button .active.button:active {\r\n        background-color: #0f0f10;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* Basic */\r\n    .ui.basic.black.buttons .button,\r\n    .ui.basic.black.button {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #1b1c1d inset !important;\r\n        box-shadow: 0px 0px 0px 1px #1b1c1d inset !important;\r\n        color: #1b1c1d !important;\r\n    }\r\n\r\n    .ui.basic.black.buttons .button:hover,\r\n    .ui.basic.black.button:hover {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #27292a inset !important;\r\n        box-shadow: 0px 0px 0px 1px #27292a inset !important;\r\n        color: #27292a !important;\r\n    }\r\n\r\n    .ui.basic.black.buttons .button:focus,\r\n    .ui.basic.black.button:focus {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #2f3032 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #2f3032 inset !important;\r\n        color: #27292a !important;\r\n    }\r\n\r\n    .ui.basic.black.buttons .active.button,\r\n    .ui.basic.black.active.button {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #0f0f10 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #0f0f10 inset !important;\r\n        color: #343637 !important;\r\n    }\r\n\r\n    .ui.basic.black.buttons .button:active,\r\n    .ui.basic.black.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #343637 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #343637 inset !important;\r\n        color: #343637 !important;\r\n    }\r\n\r\n    .ui.buttons:not(.vertical)>.basic.black.button:not(:first-child) {\r\n        margin-left: -1px;\r\n    }\r\n\r\n    /* Inverted */\r\n    .ui.inverted.black.buttons .button,\r\n    .ui.inverted.black.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px #d4d4d5 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #d4d4d5 inset !important;\r\n        color: #ffffff;\r\n    }\r\n\r\n    .ui.inverted.black.buttons .button:hover,\r\n    .ui.inverted.black.button:hover,\r\n    .ui.inverted.black.buttons .button:focus,\r\n    .ui.inverted.black.button:focus,\r\n    .ui.inverted.black.buttons .button.active,\r\n    .ui.inverted.black.button.active,\r\n    .ui.inverted.black.buttons .button:active,\r\n    .ui.inverted.black.button:active {\r\n        -webkit-box-shadow: none !important;\r\n        box-shadow: none !important;\r\n        color: #ffffff;\r\n    }\r\n\r\n    .ui.inverted.black.buttons .button:hover,\r\n    .ui.inverted.black.button:hover {\r\n        background-color: #000000;\r\n    }\r\n\r\n    .ui.inverted.black.buttons .button:focus,\r\n    .ui.inverted.black.button:focus {\r\n        background-color: #000000;\r\n    }\r\n\r\n    .ui.inverted.black.buttons .active.button,\r\n    .ui.inverted.black.active.button {\r\n        background-color: #000000;\r\n    }\r\n\r\n    .ui.inverted.black.buttons .button:active,\r\n    .ui.inverted.black.button:active {\r\n        background-color: #000000;\r\n    }\r\n\r\n    /* Inverted Basic */\r\n    .ui.inverted.black.basic.buttons .button,\r\n    .ui.inverted.black.buttons .basic.button,\r\n    .ui.inverted.black.basic.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    .ui.inverted.black.basic.buttons .button:hover,\r\n    .ui.inverted.black.buttons .basic.button:hover,\r\n    .ui.inverted.black.basic.button:hover {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #000000 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #000000 inset !important;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    .ui.inverted.black.basic.buttons .button:focus,\r\n    .ui.inverted.black.basic.buttons .button:focus,\r\n    .ui.inverted.black.basic.button:focus {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #000000 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #000000 inset !important;\r\n        color: #545454 !important;\r\n    }\r\n\r\n    .ui.inverted.black.basic.buttons .active.button,\r\n    .ui.inverted.black.buttons .basic.active.button,\r\n    .ui.inverted.black.basic.active.button {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #000000 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #000000 inset !important;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    .ui.inverted.black.basic.buttons .button:active,\r\n    .ui.inverted.black.buttons .basic.button:active,\r\n    .ui.inverted.black.basic.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #000000 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #000000 inset !important;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    /*--- Grey ---*/\r\n    .ui.grey.buttons .button,\r\n    .ui.grey.button {\r\n        background-color: #767676;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n    }\r\n\r\n    .ui.grey.button {\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.grey.buttons .button:hover,\r\n    .ui.grey.button:hover {\r\n        background-color: #838383;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.grey.buttons .button:focus,\r\n    .ui.grey.button:focus {\r\n        background-color: #8a8a8a;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.grey.buttons .button:active,\r\n    .ui.grey.button:active {\r\n        background-color: #909090;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.grey.buttons .active.button,\r\n    .ui.grey.buttons .active.button:active,\r\n    .ui.grey.active.button,\r\n    .ui.grey.button .active.button:active {\r\n        background-color: #696969;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* Basic */\r\n    .ui.basic.grey.buttons .button,\r\n    .ui.basic.grey.button {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #767676 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #767676 inset !important;\r\n        color: #767676 !important;\r\n    }\r\n\r\n    .ui.basic.grey.buttons .button:hover,\r\n    .ui.basic.grey.button:hover {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #838383 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #838383 inset !important;\r\n        color: #838383 !important;\r\n    }\r\n\r\n    .ui.basic.grey.buttons .button:focus,\r\n    .ui.basic.grey.button:focus {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #8a8a8a inset !important;\r\n        box-shadow: 0px 0px 0px 1px #8a8a8a inset !important;\r\n        color: #838383 !important;\r\n    }\r\n\r\n    .ui.basic.grey.buttons .active.button,\r\n    .ui.basic.grey.active.button {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #696969 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #696969 inset !important;\r\n        color: #909090 !important;\r\n    }\r\n\r\n    .ui.basic.grey.buttons .button:active,\r\n    .ui.basic.grey.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #909090 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #909090 inset !important;\r\n        color: #909090 !important;\r\n    }\r\n\r\n    .ui.buttons:not(.vertical)>.basic.grey.button:not(:first-child) {\r\n        margin-left: -1px;\r\n    }\r\n\r\n    /* Inverted */\r\n    .ui.inverted.grey.buttons .button,\r\n    .ui.inverted.grey.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px #d4d4d5 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #d4d4d5 inset !important;\r\n        color: #ffffff;\r\n    }\r\n\r\n    .ui.inverted.grey.buttons .button:hover,\r\n    .ui.inverted.grey.button:hover,\r\n    .ui.inverted.grey.buttons .button:focus,\r\n    .ui.inverted.grey.button:focus,\r\n    .ui.inverted.grey.buttons .button.active,\r\n    .ui.inverted.grey.button.active,\r\n    .ui.inverted.grey.buttons .button:active,\r\n    .ui.inverted.grey.button:active {\r\n        -webkit-box-shadow: none !important;\r\n        box-shadow: none !important;\r\n        color: rgba(0, 0, 0, 0.6);\r\n    }\r\n\r\n    .ui.inverted.grey.buttons .button:hover,\r\n    .ui.inverted.grey.button:hover {\r\n        background-color: #cfd0d2;\r\n    }\r\n\r\n    .ui.inverted.grey.buttons .button:focus,\r\n    .ui.inverted.grey.button:focus {\r\n        background-color: #c7c9cb;\r\n    }\r\n\r\n    .ui.inverted.grey.buttons .active.button,\r\n    .ui.inverted.grey.active.button {\r\n        background-color: #cfd0d2;\r\n    }\r\n\r\n    .ui.inverted.grey.buttons .button:active,\r\n    .ui.inverted.grey.button:active {\r\n        background-color: #c2c4c5;\r\n    }\r\n\r\n    /* Inverted Basic */\r\n    .ui.inverted.grey.basic.buttons .button,\r\n    .ui.inverted.grey.buttons .basic.button,\r\n    .ui.inverted.grey.basic.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    .ui.inverted.grey.basic.buttons .button:hover,\r\n    .ui.inverted.grey.buttons .basic.button:hover,\r\n    .ui.inverted.grey.basic.button:hover {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #cfd0d2 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #cfd0d2 inset !important;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    .ui.inverted.grey.basic.buttons .button:focus,\r\n    .ui.inverted.grey.basic.buttons .button:focus,\r\n    .ui.inverted.grey.basic.button:focus {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #c7c9cb inset !important;\r\n        box-shadow: 0px 0px 0px 2px #c7c9cb inset !important;\r\n        color: #dcddde !important;\r\n    }\r\n\r\n    .ui.inverted.grey.basic.buttons .active.button,\r\n    .ui.inverted.grey.buttons .basic.active.button,\r\n    .ui.inverted.grey.basic.active.button {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #cfd0d2 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #cfd0d2 inset !important;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    .ui.inverted.grey.basic.buttons .button:active,\r\n    .ui.inverted.grey.buttons .basic.button:active,\r\n    .ui.inverted.grey.basic.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #c2c4c5 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #c2c4c5 inset !important;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    /*--- Brown ---*/\r\n    .ui.brown.buttons .button,\r\n    .ui.brown.button {\r\n        background-color: #a5673f;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n    }\r\n\r\n    .ui.brown.button {\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.brown.buttons .button:hover,\r\n    .ui.brown.button:hover {\r\n        background-color: #975b33;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.brown.buttons .button:focus,\r\n    .ui.brown.button:focus {\r\n        background-color: #90532b;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.brown.buttons .button:active,\r\n    .ui.brown.button:active {\r\n        background-color: #805031;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.brown.buttons .active.button,\r\n    .ui.brown.buttons .active.button:active,\r\n    .ui.brown.active.button,\r\n    .ui.brown.button .active.button:active {\r\n        background-color: #995a31;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* Basic */\r\n    .ui.basic.brown.buttons .button,\r\n    .ui.basic.brown.button {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #a5673f inset !important;\r\n        box-shadow: 0px 0px 0px 1px #a5673f inset !important;\r\n        color: #a5673f !important;\r\n    }\r\n\r\n    .ui.basic.brown.buttons .button:hover,\r\n    .ui.basic.brown.button:hover {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #975b33 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #975b33 inset !important;\r\n        color: #975b33 !important;\r\n    }\r\n\r\n    .ui.basic.brown.buttons .button:focus,\r\n    .ui.basic.brown.button:focus {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #90532b inset !important;\r\n        box-shadow: 0px 0px 0px 1px #90532b inset !important;\r\n        color: #975b33 !important;\r\n    }\r\n\r\n    .ui.basic.brown.buttons .active.button,\r\n    .ui.basic.brown.active.button {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #995a31 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #995a31 inset !important;\r\n        color: #805031 !important;\r\n    }\r\n\r\n    .ui.basic.brown.buttons .button:active,\r\n    .ui.basic.brown.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #805031 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #805031 inset !important;\r\n        color: #805031 !important;\r\n    }\r\n\r\n    .ui.buttons:not(.vertical)>.basic.brown.button:not(:first-child) {\r\n        margin-left: -1px;\r\n    }\r\n\r\n    /* Inverted */\r\n    .ui.inverted.brown.buttons .button,\r\n    .ui.inverted.brown.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px #d67c1c inset !important;\r\n        box-shadow: 0px 0px 0px 2px #d67c1c inset !important;\r\n        color: #d67c1c;\r\n    }\r\n\r\n    .ui.inverted.brown.buttons .button:hover,\r\n    .ui.inverted.brown.button:hover,\r\n    .ui.inverted.brown.buttons .button:focus,\r\n    .ui.inverted.brown.button:focus,\r\n    .ui.inverted.brown.buttons .button.active,\r\n    .ui.inverted.brown.button.active,\r\n    .ui.inverted.brown.buttons .button:active,\r\n    .ui.inverted.brown.button:active {\r\n        -webkit-box-shadow: none !important;\r\n        box-shadow: none !important;\r\n        color: #ffffff;\r\n    }\r\n\r\n    .ui.inverted.brown.buttons .button:hover,\r\n    .ui.inverted.brown.button:hover {\r\n        background-color: #c86f11;\r\n    }\r\n\r\n    .ui.inverted.brown.buttons .button:focus,\r\n    .ui.inverted.brown.button:focus {\r\n        background-color: #c16808;\r\n    }\r\n\r\n    .ui.inverted.brown.buttons .active.button,\r\n    .ui.inverted.brown.active.button {\r\n        background-color: #cc6f0d;\r\n    }\r\n\r\n    .ui.inverted.brown.buttons .button:active,\r\n    .ui.inverted.brown.button:active {\r\n        background-color: #a96216;\r\n    }\r\n\r\n    /* Inverted Basic */\r\n    .ui.inverted.brown.basic.buttons .button,\r\n    .ui.inverted.brown.buttons .basic.button,\r\n    .ui.inverted.brown.basic.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    .ui.inverted.brown.basic.buttons .button:hover,\r\n    .ui.inverted.brown.buttons .basic.button:hover,\r\n    .ui.inverted.brown.basic.button:hover {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #c86f11 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #c86f11 inset !important;\r\n        color: #d67c1c !important;\r\n    }\r\n\r\n    .ui.inverted.brown.basic.buttons .button:focus,\r\n    .ui.inverted.brown.basic.buttons .button:focus,\r\n    .ui.inverted.brown.basic.button:focus {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #c16808 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #c16808 inset !important;\r\n        color: #d67c1c !important;\r\n    }\r\n\r\n    .ui.inverted.brown.basic.buttons .active.button,\r\n    .ui.inverted.brown.buttons .basic.active.button,\r\n    .ui.inverted.brown.basic.active.button {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #cc6f0d inset !important;\r\n        box-shadow: 0px 0px 0px 2px #cc6f0d inset !important;\r\n        color: #d67c1c !important;\r\n    }\r\n\r\n    .ui.inverted.brown.basic.buttons .button:active,\r\n    .ui.inverted.brown.buttons .basic.button:active,\r\n    .ui.inverted.brown.basic.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #a96216 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #a96216 inset !important;\r\n        color: #d67c1c !important;\r\n    }\r\n\r\n    /*--- Blue ---*/\r\n    .ui.blue.buttons .button,\r\n    .ui.blue.button {\r\n        background-color: #2185d0;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n    }\r\n\r\n    .ui.blue.button {\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.blue.buttons .button:hover,\r\n    .ui.blue.button:hover {\r\n        background-color: #1678c2;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.blue.buttons .button:focus,\r\n    .ui.blue.button:focus {\r\n        background-color: #0d71bb;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.blue.buttons .button:active,\r\n    .ui.blue.button:active {\r\n        background-color: #1a69a4;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.blue.buttons .active.button,\r\n    .ui.blue.buttons .active.button:active,\r\n    .ui.blue.active.button,\r\n    .ui.blue.button .active.button:active {\r\n        background-color: #1279c6;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* Basic */\r\n    .ui.basic.blue.buttons .button,\r\n    .ui.basic.blue.button {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #2185d0 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #2185d0 inset !important;\r\n        color: #2185d0 !important;\r\n    }\r\n\r\n    .ui.basic.blue.buttons .button:hover,\r\n    .ui.basic.blue.button:hover {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #1678c2 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #1678c2 inset !important;\r\n        color: #1678c2 !important;\r\n    }\r\n\r\n    .ui.basic.blue.buttons .button:focus,\r\n    .ui.basic.blue.button:focus {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #0d71bb inset !important;\r\n        box-shadow: 0px 0px 0px 1px #0d71bb inset !important;\r\n        color: #1678c2 !important;\r\n    }\r\n\r\n    .ui.basic.blue.buttons .active.button,\r\n    .ui.basic.blue.active.button {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #1279c6 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #1279c6 inset !important;\r\n        color: #1a69a4 !important;\r\n    }\r\n\r\n    .ui.basic.blue.buttons .button:active,\r\n    .ui.basic.blue.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #1a69a4 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #1a69a4 inset !important;\r\n        color: #1a69a4 !important;\r\n    }\r\n\r\n    .ui.buttons:not(.vertical)>.basic.blue.button:not(:first-child) {\r\n        margin-left: -1px;\r\n    }\r\n\r\n    /* Inverted */\r\n    .ui.inverted.blue.buttons .button,\r\n    .ui.inverted.blue.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px #54c8ff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #54c8ff inset !important;\r\n        color: #54c8ff;\r\n    }\r\n\r\n    .ui.inverted.blue.buttons .button:hover,\r\n    .ui.inverted.blue.button:hover,\r\n    .ui.inverted.blue.buttons .button:focus,\r\n    .ui.inverted.blue.button:focus,\r\n    .ui.inverted.blue.buttons .button.active,\r\n    .ui.inverted.blue.button.active,\r\n    .ui.inverted.blue.buttons .button:active,\r\n    .ui.inverted.blue.button:active {\r\n        -webkit-box-shadow: none !important;\r\n        box-shadow: none !important;\r\n        color: #ffffff;\r\n    }\r\n\r\n    .ui.inverted.blue.buttons .button:hover,\r\n    .ui.inverted.blue.button:hover {\r\n        background-color: #3ac0ff;\r\n    }\r\n\r\n    .ui.inverted.blue.buttons .button:focus,\r\n    .ui.inverted.blue.button:focus {\r\n        background-color: #2bbbff;\r\n    }\r\n\r\n    .ui.inverted.blue.buttons .active.button,\r\n    .ui.inverted.blue.active.button {\r\n        background-color: #3ac0ff;\r\n    }\r\n\r\n    .ui.inverted.blue.buttons .button:active,\r\n    .ui.inverted.blue.button:active {\r\n        background-color: #21b8ff;\r\n    }\r\n\r\n    /* Inverted Basic */\r\n    .ui.inverted.blue.basic.buttons .button,\r\n    .ui.inverted.blue.buttons .basic.button,\r\n    .ui.inverted.blue.basic.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    .ui.inverted.blue.basic.buttons .button:hover,\r\n    .ui.inverted.blue.buttons .basic.button:hover,\r\n    .ui.inverted.blue.basic.button:hover {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #3ac0ff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #3ac0ff inset !important;\r\n        color: #54c8ff !important;\r\n    }\r\n\r\n    .ui.inverted.blue.basic.buttons .button:focus,\r\n    .ui.inverted.blue.basic.buttons .button:focus,\r\n    .ui.inverted.blue.basic.button:focus {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #2bbbff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #2bbbff inset !important;\r\n        color: #54c8ff !important;\r\n    }\r\n\r\n    .ui.inverted.blue.basic.buttons .active.button,\r\n    .ui.inverted.blue.buttons .basic.active.button,\r\n    .ui.inverted.blue.basic.active.button {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #3ac0ff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #3ac0ff inset !important;\r\n        color: #54c8ff !important;\r\n    }\r\n\r\n    .ui.inverted.blue.basic.buttons .button:active,\r\n    .ui.inverted.blue.buttons .basic.button:active,\r\n    .ui.inverted.blue.basic.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #21b8ff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #21b8ff inset !important;\r\n        color: #54c8ff !important;\r\n    }\r\n\r\n    /*--- Green ---*/\r\n    .ui.green.buttons .button,\r\n    .ui.green.button {\r\n        background-color: #21ba45;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n    }\r\n\r\n    .ui.green.button {\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.green.buttons .button:hover,\r\n    .ui.green.button:hover {\r\n        background-color: #16ab39;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.green.buttons .button:focus,\r\n    .ui.green.button:focus {\r\n        background-color: #0ea432;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.green.buttons .button:active,\r\n    .ui.green.button:active {\r\n        background-color: #198f35;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.green.buttons .active.button,\r\n    .ui.green.buttons .active.button:active,\r\n    .ui.green.active.button,\r\n    .ui.green.button .active.button:active {\r\n        background-color: #13ae38;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* Basic */\r\n    .ui.basic.green.buttons .button,\r\n    .ui.basic.green.button {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #21ba45 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #21ba45 inset !important;\r\n        color: #21ba45 !important;\r\n    }\r\n\r\n    .ui.basic.green.buttons .button:hover,\r\n    .ui.basic.green.button:hover {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #16ab39 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #16ab39 inset !important;\r\n        color: #16ab39 !important;\r\n    }\r\n\r\n    .ui.basic.green.buttons .button:focus,\r\n    .ui.basic.green.button:focus {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #0ea432 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #0ea432 inset !important;\r\n        color: #16ab39 !important;\r\n    }\r\n\r\n    .ui.basic.green.buttons .active.button,\r\n    .ui.basic.green.active.button {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #13ae38 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #13ae38 inset !important;\r\n        color: #198f35 !important;\r\n    }\r\n\r\n    .ui.basic.green.buttons .button:active,\r\n    .ui.basic.green.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #198f35 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #198f35 inset !important;\r\n        color: #198f35 !important;\r\n    }\r\n\r\n    .ui.buttons:not(.vertical)>.basic.green.button:not(:first-child) {\r\n        margin-left: -1px;\r\n    }\r\n\r\n    /* Inverted */\r\n    .ui.inverted.green.buttons .button,\r\n    .ui.inverted.green.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px #2ecc40 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #2ecc40 inset !important;\r\n        color: #2ecc40;\r\n    }\r\n\r\n    .ui.inverted.green.buttons .button:hover,\r\n    .ui.inverted.green.button:hover,\r\n    .ui.inverted.green.buttons .button:focus,\r\n    .ui.inverted.green.button:focus,\r\n    .ui.inverted.green.buttons .button.active,\r\n    .ui.inverted.green.button.active,\r\n    .ui.inverted.green.buttons .button:active,\r\n    .ui.inverted.green.button:active {\r\n        -webkit-box-shadow: none !important;\r\n        box-shadow: none !important;\r\n        color: #ffffff;\r\n    }\r\n\r\n    .ui.inverted.green.buttons .button:hover,\r\n    .ui.inverted.green.button:hover {\r\n        background-color: #22be34;\r\n    }\r\n\r\n    .ui.inverted.green.buttons .button:focus,\r\n    .ui.inverted.green.button:focus {\r\n        background-color: #19b82b;\r\n    }\r\n\r\n    .ui.inverted.green.buttons .active.button,\r\n    .ui.inverted.green.active.button {\r\n        background-color: #1fc231;\r\n    }\r\n\r\n    .ui.inverted.green.buttons .button:active,\r\n    .ui.inverted.green.button:active {\r\n        background-color: #25a233;\r\n    }\r\n\r\n    /* Inverted Basic */\r\n    .ui.inverted.green.basic.buttons .button,\r\n    .ui.inverted.green.buttons .basic.button,\r\n    .ui.inverted.green.basic.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    .ui.inverted.green.basic.buttons .button:hover,\r\n    .ui.inverted.green.buttons .basic.button:hover,\r\n    .ui.inverted.green.basic.button:hover {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #22be34 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #22be34 inset !important;\r\n        color: #2ecc40 !important;\r\n    }\r\n\r\n    .ui.inverted.green.basic.buttons .button:focus,\r\n    .ui.inverted.green.basic.buttons .button:focus,\r\n    .ui.inverted.green.basic.button:focus {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #19b82b inset !important;\r\n        box-shadow: 0px 0px 0px 2px #19b82b inset !important;\r\n        color: #2ecc40 !important;\r\n    }\r\n\r\n    .ui.inverted.green.basic.buttons .active.button,\r\n    .ui.inverted.green.buttons .basic.active.button,\r\n    .ui.inverted.green.basic.active.button {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #1fc231 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #1fc231 inset !important;\r\n        color: #2ecc40 !important;\r\n    }\r\n\r\n    .ui.inverted.green.basic.buttons .button:active,\r\n    .ui.inverted.green.buttons .basic.button:active,\r\n    .ui.inverted.green.basic.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #25a233 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #25a233 inset !important;\r\n        color: #2ecc40 !important;\r\n    }\r\n\r\n    /*--- Orange ---*/\r\n    .ui.orange.buttons .button,\r\n    .ui.orange.button {\r\n        background-color: #f2711c;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n    }\r\n\r\n    .ui.orange.button {\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.orange.buttons .button:hover,\r\n    .ui.orange.button:hover {\r\n        background-color: #f26202;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.orange.buttons .button:focus,\r\n    .ui.orange.button:focus {\r\n        background-color: #e55b00;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.orange.buttons .button:active,\r\n    .ui.orange.button:active {\r\n        background-color: #cf590c;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.orange.buttons .active.button,\r\n    .ui.orange.buttons .active.button:active,\r\n    .ui.orange.active.button,\r\n    .ui.orange.button .active.button:active {\r\n        background-color: #f56100;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* Basic */\r\n    .ui.basic.orange.buttons .button,\r\n    .ui.basic.orange.button {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #f2711c inset !important;\r\n        box-shadow: 0px 0px 0px 1px #f2711c inset !important;\r\n        color: #f2711c !important;\r\n    }\r\n\r\n    .ui.basic.orange.buttons .button:hover,\r\n    .ui.basic.orange.button:hover {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #f26202 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #f26202 inset !important;\r\n        color: #f26202 !important;\r\n    }\r\n\r\n    .ui.basic.orange.buttons .button:focus,\r\n    .ui.basic.orange.button:focus {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #e55b00 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #e55b00 inset !important;\r\n        color: #f26202 !important;\r\n    }\r\n\r\n    .ui.basic.orange.buttons .active.button,\r\n    .ui.basic.orange.active.button {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #f56100 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #f56100 inset !important;\r\n        color: #cf590c !important;\r\n    }\r\n\r\n    .ui.basic.orange.buttons .button:active,\r\n    .ui.basic.orange.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #cf590c inset !important;\r\n        box-shadow: 0px 0px 0px 1px #cf590c inset !important;\r\n        color: #cf590c !important;\r\n    }\r\n\r\n    .ui.buttons:not(.vertical)>.basic.orange.button:not(:first-child) {\r\n        margin-left: -1px;\r\n    }\r\n\r\n    /* Inverted */\r\n    .ui.inverted.orange.buttons .button,\r\n    .ui.inverted.orange.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ff851b inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ff851b inset !important;\r\n        color: #ff851b;\r\n    }\r\n\r\n    .ui.inverted.orange.buttons .button:hover,\r\n    .ui.inverted.orange.button:hover,\r\n    .ui.inverted.orange.buttons .button:focus,\r\n    .ui.inverted.orange.button:focus,\r\n    .ui.inverted.orange.buttons .button.active,\r\n    .ui.inverted.orange.button.active,\r\n    .ui.inverted.orange.buttons .button:active,\r\n    .ui.inverted.orange.button:active {\r\n        -webkit-box-shadow: none !important;\r\n        box-shadow: none !important;\r\n        color: #ffffff;\r\n    }\r\n\r\n    .ui.inverted.orange.buttons .button:hover,\r\n    .ui.inverted.orange.button:hover {\r\n        background-color: #ff7701;\r\n    }\r\n\r\n    .ui.inverted.orange.buttons .button:focus,\r\n    .ui.inverted.orange.button:focus {\r\n        background-color: #f17000;\r\n    }\r\n\r\n    .ui.inverted.orange.buttons .active.button,\r\n    .ui.inverted.orange.active.button {\r\n        background-color: #ff7701;\r\n    }\r\n\r\n    .ui.inverted.orange.buttons .button:active,\r\n    .ui.inverted.orange.button:active {\r\n        background-color: #e76b00;\r\n    }\r\n\r\n    /* Inverted Basic */\r\n    .ui.inverted.orange.basic.buttons .button,\r\n    .ui.inverted.orange.buttons .basic.button,\r\n    .ui.inverted.orange.basic.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    .ui.inverted.orange.basic.buttons .button:hover,\r\n    .ui.inverted.orange.buttons .basic.button:hover,\r\n    .ui.inverted.orange.basic.button:hover {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ff7701 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ff7701 inset !important;\r\n        color: #ff851b !important;\r\n    }\r\n\r\n    .ui.inverted.orange.basic.buttons .button:focus,\r\n    .ui.inverted.orange.basic.buttons .button:focus,\r\n    .ui.inverted.orange.basic.button:focus {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #f17000 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #f17000 inset !important;\r\n        color: #ff851b !important;\r\n    }\r\n\r\n    .ui.inverted.orange.basic.buttons .active.button,\r\n    .ui.inverted.orange.buttons .basic.active.button,\r\n    .ui.inverted.orange.basic.active.button {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ff7701 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ff7701 inset !important;\r\n        color: #ff851b !important;\r\n    }\r\n\r\n    .ui.inverted.orange.basic.buttons .button:active,\r\n    .ui.inverted.orange.buttons .basic.button:active,\r\n    .ui.inverted.orange.basic.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #e76b00 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #e76b00 inset !important;\r\n        color: #ff851b !important;\r\n    }\r\n\r\n    /*--- Pink ---*/\r\n    .ui.pink.buttons .button,\r\n    .ui.pink.button {\r\n        background-color: #e03997;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n    }\r\n\r\n    .ui.pink.button {\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.pink.buttons .button:hover,\r\n    .ui.pink.button:hover {\r\n        background-color: #e61a8d;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.pink.buttons .button:focus,\r\n    .ui.pink.button:focus {\r\n        background-color: #e10f85;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.pink.buttons .button:active,\r\n    .ui.pink.button:active {\r\n        background-color: #c71f7e;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.pink.buttons .active.button,\r\n    .ui.pink.buttons .active.button:active,\r\n    .ui.pink.active.button,\r\n    .ui.pink.button .active.button:active {\r\n        background-color: #ea158d;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* Basic */\r\n    .ui.basic.pink.buttons .button,\r\n    .ui.basic.pink.button {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #e03997 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #e03997 inset !important;\r\n        color: #e03997 !important;\r\n    }\r\n\r\n    .ui.basic.pink.buttons .button:hover,\r\n    .ui.basic.pink.button:hover {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #e61a8d inset !important;\r\n        box-shadow: 0px 0px 0px 1px #e61a8d inset !important;\r\n        color: #e61a8d !important;\r\n    }\r\n\r\n    .ui.basic.pink.buttons .button:focus,\r\n    .ui.basic.pink.button:focus {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #e10f85 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #e10f85 inset !important;\r\n        color: #e61a8d !important;\r\n    }\r\n\r\n    .ui.basic.pink.buttons .active.button,\r\n    .ui.basic.pink.active.button {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #ea158d inset !important;\r\n        box-shadow: 0px 0px 0px 1px #ea158d inset !important;\r\n        color: #c71f7e !important;\r\n    }\r\n\r\n    .ui.basic.pink.buttons .button:active,\r\n    .ui.basic.pink.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #c71f7e inset !important;\r\n        box-shadow: 0px 0px 0px 1px #c71f7e inset !important;\r\n        color: #c71f7e !important;\r\n    }\r\n\r\n    .ui.buttons:not(.vertical)>.basic.pink.button:not(:first-child) {\r\n        margin-left: -1px;\r\n    }\r\n\r\n    /* Inverted */\r\n    .ui.inverted.pink.buttons .button,\r\n    .ui.inverted.pink.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ff8edf inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ff8edf inset !important;\r\n        color: #ff8edf;\r\n    }\r\n\r\n    .ui.inverted.pink.buttons .button:hover,\r\n    .ui.inverted.pink.button:hover,\r\n    .ui.inverted.pink.buttons .button:focus,\r\n    .ui.inverted.pink.button:focus,\r\n    .ui.inverted.pink.buttons .button.active,\r\n    .ui.inverted.pink.button.active,\r\n    .ui.inverted.pink.buttons .button:active,\r\n    .ui.inverted.pink.button:active {\r\n        -webkit-box-shadow: none !important;\r\n        box-shadow: none !important;\r\n        color: #ffffff;\r\n    }\r\n\r\n    .ui.inverted.pink.buttons .button:hover,\r\n    .ui.inverted.pink.button:hover {\r\n        background-color: #ff74d8;\r\n    }\r\n\r\n    .ui.inverted.pink.buttons .button:focus,\r\n    .ui.inverted.pink.button:focus {\r\n        background-color: #ff65d3;\r\n    }\r\n\r\n    .ui.inverted.pink.buttons .active.button,\r\n    .ui.inverted.pink.active.button {\r\n        background-color: #ff74d8;\r\n    }\r\n\r\n    .ui.inverted.pink.buttons .button:active,\r\n    .ui.inverted.pink.button:active {\r\n        background-color: #ff5bd1;\r\n    }\r\n\r\n    /* Inverted Basic */\r\n    .ui.inverted.pink.basic.buttons .button,\r\n    .ui.inverted.pink.buttons .basic.button,\r\n    .ui.inverted.pink.basic.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    .ui.inverted.pink.basic.buttons .button:hover,\r\n    .ui.inverted.pink.buttons .basic.button:hover,\r\n    .ui.inverted.pink.basic.button:hover {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ff74d8 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ff74d8 inset !important;\r\n        color: #ff8edf !important;\r\n    }\r\n\r\n    .ui.inverted.pink.basic.buttons .button:focus,\r\n    .ui.inverted.pink.basic.buttons .button:focus,\r\n    .ui.inverted.pink.basic.button:focus {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ff65d3 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ff65d3 inset !important;\r\n        color: #ff8edf !important;\r\n    }\r\n\r\n    .ui.inverted.pink.basic.buttons .active.button,\r\n    .ui.inverted.pink.buttons .basic.active.button,\r\n    .ui.inverted.pink.basic.active.button {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ff74d8 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ff74d8 inset !important;\r\n        color: #ff8edf !important;\r\n    }\r\n\r\n    .ui.inverted.pink.basic.buttons .button:active,\r\n    .ui.inverted.pink.buttons .basic.button:active,\r\n    .ui.inverted.pink.basic.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ff5bd1 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ff5bd1 inset !important;\r\n        color: #ff8edf !important;\r\n    }\r\n\r\n    /*--- Violet ---*/\r\n    .ui.violet.buttons .button,\r\n    .ui.violet.button {\r\n        background-color: #6435c9;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n    }\r\n\r\n    .ui.violet.button {\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.violet.buttons .button:hover,\r\n    .ui.violet.button:hover {\r\n        background-color: #5829bb;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.violet.buttons .button:focus,\r\n    .ui.violet.button:focus {\r\n        background-color: #4f20b5;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.violet.buttons .button:active,\r\n    .ui.violet.button:active {\r\n        background-color: #502aa1;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.violet.buttons .active.button,\r\n    .ui.violet.buttons .active.button:active,\r\n    .ui.violet.active.button,\r\n    .ui.violet.button .active.button:active {\r\n        background-color: #5626bf;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* Basic */\r\n    .ui.basic.violet.buttons .button,\r\n    .ui.basic.violet.button {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #6435c9 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #6435c9 inset !important;\r\n        color: #6435c9 !important;\r\n    }\r\n\r\n    .ui.basic.violet.buttons .button:hover,\r\n    .ui.basic.violet.button:hover {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #5829bb inset !important;\r\n        box-shadow: 0px 0px 0px 1px #5829bb inset !important;\r\n        color: #5829bb !important;\r\n    }\r\n\r\n    .ui.basic.violet.buttons .button:focus,\r\n    .ui.basic.violet.button:focus {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #4f20b5 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #4f20b5 inset !important;\r\n        color: #5829bb !important;\r\n    }\r\n\r\n    .ui.basic.violet.buttons .active.button,\r\n    .ui.basic.violet.active.button {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #5626bf inset !important;\r\n        box-shadow: 0px 0px 0px 1px #5626bf inset !important;\r\n        color: #502aa1 !important;\r\n    }\r\n\r\n    .ui.basic.violet.buttons .button:active,\r\n    .ui.basic.violet.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #502aa1 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #502aa1 inset !important;\r\n        color: #502aa1 !important;\r\n    }\r\n\r\n    .ui.buttons:not(.vertical)>.basic.violet.button:not(:first-child) {\r\n        margin-left: -1px;\r\n    }\r\n\r\n    /* Inverted */\r\n    .ui.inverted.violet.buttons .button,\r\n    .ui.inverted.violet.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px #a291fb inset !important;\r\n        box-shadow: 0px 0px 0px 2px #a291fb inset !important;\r\n        color: #a291fb;\r\n    }\r\n\r\n    .ui.inverted.violet.buttons .button:hover,\r\n    .ui.inverted.violet.button:hover,\r\n    .ui.inverted.violet.buttons .button:focus,\r\n    .ui.inverted.violet.button:focus,\r\n    .ui.inverted.violet.buttons .button.active,\r\n    .ui.inverted.violet.button.active,\r\n    .ui.inverted.violet.buttons .button:active,\r\n    .ui.inverted.violet.button:active {\r\n        -webkit-box-shadow: none !important;\r\n        box-shadow: none !important;\r\n        color: #ffffff;\r\n    }\r\n\r\n    .ui.inverted.violet.buttons .button:hover,\r\n    .ui.inverted.violet.button:hover {\r\n        background-color: #8a73ff;\r\n    }\r\n\r\n    .ui.inverted.violet.buttons .button:focus,\r\n    .ui.inverted.violet.button:focus {\r\n        background-color: #7d64ff;\r\n    }\r\n\r\n    .ui.inverted.violet.buttons .active.button,\r\n    .ui.inverted.violet.active.button {\r\n        background-color: #8a73ff;\r\n    }\r\n\r\n    .ui.inverted.violet.buttons .button:active,\r\n    .ui.inverted.violet.button:active {\r\n        background-color: #7860f9;\r\n    }\r\n\r\n    /* Inverted Basic */\r\n    .ui.inverted.violet.basic.buttons .button,\r\n    .ui.inverted.violet.buttons .basic.button,\r\n    .ui.inverted.violet.basic.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    .ui.inverted.violet.basic.buttons .button:hover,\r\n    .ui.inverted.violet.buttons .basic.button:hover,\r\n    .ui.inverted.violet.basic.button:hover {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #8a73ff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #8a73ff inset !important;\r\n        color: #a291fb !important;\r\n    }\r\n\r\n    .ui.inverted.violet.basic.buttons .button:focus,\r\n    .ui.inverted.violet.basic.buttons .button:focus,\r\n    .ui.inverted.violet.basic.button:focus {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #7d64ff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #7d64ff inset !important;\r\n        color: #a291fb !important;\r\n    }\r\n\r\n    .ui.inverted.violet.basic.buttons .active.button,\r\n    .ui.inverted.violet.buttons .basic.active.button,\r\n    .ui.inverted.violet.basic.active.button {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #8a73ff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #8a73ff inset !important;\r\n        color: #a291fb !important;\r\n    }\r\n\r\n    .ui.inverted.violet.basic.buttons .button:active,\r\n    .ui.inverted.violet.buttons .basic.button:active,\r\n    .ui.inverted.violet.basic.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #7860f9 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #7860f9 inset !important;\r\n        color: #a291fb !important;\r\n    }\r\n\r\n    /*--- Purple ---*/\r\n    .ui.purple.buttons .button,\r\n    .ui.purple.button {\r\n        background-color: #a333c8;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n    }\r\n\r\n    .ui.purple.button {\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.purple.buttons .button:hover,\r\n    .ui.purple.button:hover {\r\n        background-color: #9627ba;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.purple.buttons .button:focus,\r\n    .ui.purple.button:focus {\r\n        background-color: #8f1eb4;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.purple.buttons .button:active,\r\n    .ui.purple.button:active {\r\n        background-color: #82299f;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.purple.buttons .active.button,\r\n    .ui.purple.buttons .active.button:active,\r\n    .ui.purple.active.button,\r\n    .ui.purple.button .active.button:active {\r\n        background-color: #9724be;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* Basic */\r\n    .ui.basic.purple.buttons .button,\r\n    .ui.basic.purple.button {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #a333c8 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #a333c8 inset !important;\r\n        color: #a333c8 !important;\r\n    }\r\n\r\n    .ui.basic.purple.buttons .button:hover,\r\n    .ui.basic.purple.button:hover {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #9627ba inset !important;\r\n        box-shadow: 0px 0px 0px 1px #9627ba inset !important;\r\n        color: #9627ba !important;\r\n    }\r\n\r\n    .ui.basic.purple.buttons .button:focus,\r\n    .ui.basic.purple.button:focus {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #8f1eb4 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #8f1eb4 inset !important;\r\n        color: #9627ba !important;\r\n    }\r\n\r\n    .ui.basic.purple.buttons .active.button,\r\n    .ui.basic.purple.active.button {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #9724be inset !important;\r\n        box-shadow: 0px 0px 0px 1px #9724be inset !important;\r\n        color: #82299f !important;\r\n    }\r\n\r\n    .ui.basic.purple.buttons .button:active,\r\n    .ui.basic.purple.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #82299f inset !important;\r\n        box-shadow: 0px 0px 0px 1px #82299f inset !important;\r\n        color: #82299f !important;\r\n    }\r\n\r\n    .ui.buttons:not(.vertical)>.basic.purple.button:not(:first-child) {\r\n        margin-left: -1px;\r\n    }\r\n\r\n    /* Inverted */\r\n    .ui.inverted.purple.buttons .button,\r\n    .ui.inverted.purple.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px #dc73ff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #dc73ff inset !important;\r\n        color: #dc73ff;\r\n    }\r\n\r\n    .ui.inverted.purple.buttons .button:hover,\r\n    .ui.inverted.purple.button:hover,\r\n    .ui.inverted.purple.buttons .button:focus,\r\n    .ui.inverted.purple.button:focus,\r\n    .ui.inverted.purple.buttons .button.active,\r\n    .ui.inverted.purple.button.active,\r\n    .ui.inverted.purple.buttons .button:active,\r\n    .ui.inverted.purple.button:active {\r\n        -webkit-box-shadow: none !important;\r\n        box-shadow: none !important;\r\n        color: #ffffff;\r\n    }\r\n\r\n    .ui.inverted.purple.buttons .button:hover,\r\n    .ui.inverted.purple.button:hover {\r\n        background-color: #d65aff;\r\n    }\r\n\r\n    .ui.inverted.purple.buttons .button:focus,\r\n    .ui.inverted.purple.button:focus {\r\n        background-color: #d24aff;\r\n    }\r\n\r\n    .ui.inverted.purple.buttons .active.button,\r\n    .ui.inverted.purple.active.button {\r\n        background-color: #d65aff;\r\n    }\r\n\r\n    .ui.inverted.purple.buttons .button:active,\r\n    .ui.inverted.purple.button:active {\r\n        background-color: #cf40ff;\r\n    }\r\n\r\n    /* Inverted Basic */\r\n    .ui.inverted.purple.basic.buttons .button,\r\n    .ui.inverted.purple.buttons .basic.button,\r\n    .ui.inverted.purple.basic.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    .ui.inverted.purple.basic.buttons .button:hover,\r\n    .ui.inverted.purple.buttons .basic.button:hover,\r\n    .ui.inverted.purple.basic.button:hover {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #d65aff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #d65aff inset !important;\r\n        color: #dc73ff !important;\r\n    }\r\n\r\n    .ui.inverted.purple.basic.buttons .button:focus,\r\n    .ui.inverted.purple.basic.buttons .button:focus,\r\n    .ui.inverted.purple.basic.button:focus {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #d24aff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #d24aff inset !important;\r\n        color: #dc73ff !important;\r\n    }\r\n\r\n    .ui.inverted.purple.basic.buttons .active.button,\r\n    .ui.inverted.purple.buttons .basic.active.button,\r\n    .ui.inverted.purple.basic.active.button {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #d65aff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #d65aff inset !important;\r\n        color: #dc73ff !important;\r\n    }\r\n\r\n    .ui.inverted.purple.basic.buttons .button:active,\r\n    .ui.inverted.purple.buttons .basic.button:active,\r\n    .ui.inverted.purple.basic.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #cf40ff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #cf40ff inset !important;\r\n        color: #dc73ff !important;\r\n    }\r\n\r\n    /*--- Red ---*/\r\n    .ui.red.buttons .button,\r\n    .ui.red.button {\r\n        background-color: #db2828;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n    }\r\n\r\n    .ui.red.button {\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.red.buttons .button:hover,\r\n    .ui.red.button:hover {\r\n        background-color: #d01919;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.red.buttons .button:focus,\r\n    .ui.red.button:focus {\r\n        background-color: #ca1010;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.red.buttons .button:active,\r\n    .ui.red.button:active {\r\n        background-color: #b21e1e;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.red.buttons .active.button,\r\n    .ui.red.buttons .active.button:active,\r\n    .ui.red.active.button,\r\n    .ui.red.button .active.button:active {\r\n        background-color: #d41515;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* Basic */\r\n    .ui.basic.red.buttons .button,\r\n    .ui.basic.red.button {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #db2828 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #db2828 inset !important;\r\n        color: #db2828 !important;\r\n    }\r\n\r\n    .ui.basic.red.buttons .button:hover,\r\n    .ui.basic.red.button:hover {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #d01919 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #d01919 inset !important;\r\n        color: #d01919 !important;\r\n    }\r\n\r\n    .ui.basic.red.buttons .button:focus,\r\n    .ui.basic.red.button:focus {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #ca1010 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #ca1010 inset !important;\r\n        color: #d01919 !important;\r\n    }\r\n\r\n    .ui.basic.red.buttons .active.button,\r\n    .ui.basic.red.active.button {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #d41515 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #d41515 inset !important;\r\n        color: #b21e1e !important;\r\n    }\r\n\r\n    .ui.basic.red.buttons .button:active,\r\n    .ui.basic.red.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #b21e1e inset !important;\r\n        box-shadow: 0px 0px 0px 1px #b21e1e inset !important;\r\n        color: #b21e1e !important;\r\n    }\r\n\r\n    .ui.buttons:not(.vertical)>.basic.red.button:not(:first-child) {\r\n        margin-left: -1px;\r\n    }\r\n\r\n    /* Inverted */\r\n    .ui.inverted.red.buttons .button,\r\n    .ui.inverted.red.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ff695e inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ff695e inset !important;\r\n        color: #ff695e;\r\n    }\r\n\r\n    .ui.inverted.red.buttons .button:hover,\r\n    .ui.inverted.red.button:hover,\r\n    .ui.inverted.red.buttons .button:focus,\r\n    .ui.inverted.red.button:focus,\r\n    .ui.inverted.red.buttons .button.active,\r\n    .ui.inverted.red.button.active,\r\n    .ui.inverted.red.buttons .button:active,\r\n    .ui.inverted.red.button:active {\r\n        -webkit-box-shadow: none !important;\r\n        box-shadow: none !important;\r\n        color: #ffffff;\r\n    }\r\n\r\n    .ui.inverted.red.buttons .button:hover,\r\n    .ui.inverted.red.button:hover {\r\n        background-color: #ff5144;\r\n    }\r\n\r\n    .ui.inverted.red.buttons .button:focus,\r\n    .ui.inverted.red.button:focus {\r\n        background-color: #ff4335;\r\n    }\r\n\r\n    .ui.inverted.red.buttons .active.button,\r\n    .ui.inverted.red.active.button {\r\n        background-color: #ff5144;\r\n    }\r\n\r\n    .ui.inverted.red.buttons .button:active,\r\n    .ui.inverted.red.button:active {\r\n        background-color: #ff392b;\r\n    }\r\n\r\n    /* Inverted Basic */\r\n    .ui.inverted.red.basic.buttons .button,\r\n    .ui.inverted.red.buttons .basic.button,\r\n    .ui.inverted.red.basic.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    .ui.inverted.red.basic.buttons .button:hover,\r\n    .ui.inverted.red.buttons .basic.button:hover,\r\n    .ui.inverted.red.basic.button:hover {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ff5144 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ff5144 inset !important;\r\n        color: #ff695e !important;\r\n    }\r\n\r\n    .ui.inverted.red.basic.buttons .button:focus,\r\n    .ui.inverted.red.basic.buttons .button:focus,\r\n    .ui.inverted.red.basic.button:focus {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ff4335 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ff4335 inset !important;\r\n        color: #ff695e !important;\r\n    }\r\n\r\n    .ui.inverted.red.basic.buttons .active.button,\r\n    .ui.inverted.red.buttons .basic.active.button,\r\n    .ui.inverted.red.basic.active.button {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ff5144 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ff5144 inset !important;\r\n        color: #ff695e !important;\r\n    }\r\n\r\n    .ui.inverted.red.basic.buttons .button:active,\r\n    .ui.inverted.red.buttons .basic.button:active,\r\n    .ui.inverted.red.basic.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ff392b inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ff392b inset !important;\r\n        color: #ff695e !important;\r\n    }\r\n\r\n    /*--- Teal ---*/\r\n    .ui.teal.buttons .button,\r\n    .ui.teal.button {\r\n        background-color: #00b5ad;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n    }\r\n\r\n    .ui.teal.button {\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.teal.buttons .button:hover,\r\n    .ui.teal.button:hover {\r\n        background-color: #009c95;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.teal.buttons .button:focus,\r\n    .ui.teal.button:focus {\r\n        background-color: #008c86;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.teal.buttons .button:active,\r\n    .ui.teal.button:active {\r\n        background-color: #00827c;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.teal.buttons .active.button,\r\n    .ui.teal.buttons .active.button:active,\r\n    .ui.teal.active.button,\r\n    .ui.teal.button .active.button:active {\r\n        background-color: #009c95;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* Basic */\r\n    .ui.basic.teal.buttons .button,\r\n    .ui.basic.teal.button {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #00b5ad inset !important;\r\n        box-shadow: 0px 0px 0px 1px #00b5ad inset !important;\r\n        color: #00b5ad !important;\r\n    }\r\n\r\n    .ui.basic.teal.buttons .button:hover,\r\n    .ui.basic.teal.button:hover {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #009c95 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #009c95 inset !important;\r\n        color: #009c95 !important;\r\n    }\r\n\r\n    .ui.basic.teal.buttons .button:focus,\r\n    .ui.basic.teal.button:focus {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #008c86 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #008c86 inset !important;\r\n        color: #009c95 !important;\r\n    }\r\n\r\n    .ui.basic.teal.buttons .active.button,\r\n    .ui.basic.teal.active.button {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #009c95 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #009c95 inset !important;\r\n        color: #00827c !important;\r\n    }\r\n\r\n    .ui.basic.teal.buttons .button:active,\r\n    .ui.basic.teal.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #00827c inset !important;\r\n        box-shadow: 0px 0px 0px 1px #00827c inset !important;\r\n        color: #00827c !important;\r\n    }\r\n\r\n    .ui.buttons:not(.vertical)>.basic.teal.button:not(:first-child) {\r\n        margin-left: -1px;\r\n    }\r\n\r\n    /* Inverted */\r\n    .ui.inverted.teal.buttons .button,\r\n    .ui.inverted.teal.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px #6dffff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #6dffff inset !important;\r\n        color: #6dffff;\r\n    }\r\n\r\n    .ui.inverted.teal.buttons .button:hover,\r\n    .ui.inverted.teal.button:hover,\r\n    .ui.inverted.teal.buttons .button:focus,\r\n    .ui.inverted.teal.button:focus,\r\n    .ui.inverted.teal.buttons .button.active,\r\n    .ui.inverted.teal.button.active,\r\n    .ui.inverted.teal.buttons .button:active,\r\n    .ui.inverted.teal.button:active {\r\n        -webkit-box-shadow: none !important;\r\n        box-shadow: none !important;\r\n        color: rgba(0, 0, 0, 0.6);\r\n    }\r\n\r\n    .ui.inverted.teal.buttons .button:hover,\r\n    .ui.inverted.teal.button:hover {\r\n        background-color: #54ffff;\r\n    }\r\n\r\n    .ui.inverted.teal.buttons .button:focus,\r\n    .ui.inverted.teal.button:focus {\r\n        background-color: #44ffff;\r\n    }\r\n\r\n    .ui.inverted.teal.buttons .active.button,\r\n    .ui.inverted.teal.active.button {\r\n        background-color: #54ffff;\r\n    }\r\n\r\n    .ui.inverted.teal.buttons .button:active,\r\n    .ui.inverted.teal.button:active {\r\n        background-color: #3affff;\r\n    }\r\n\r\n    /* Inverted Basic */\r\n    .ui.inverted.teal.basic.buttons .button,\r\n    .ui.inverted.teal.buttons .basic.button,\r\n    .ui.inverted.teal.basic.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    .ui.inverted.teal.basic.buttons .button:hover,\r\n    .ui.inverted.teal.buttons .basic.button:hover,\r\n    .ui.inverted.teal.basic.button:hover {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #54ffff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #54ffff inset !important;\r\n        color: #6dffff !important;\r\n    }\r\n\r\n    .ui.inverted.teal.basic.buttons .button:focus,\r\n    .ui.inverted.teal.basic.buttons .button:focus,\r\n    .ui.inverted.teal.basic.button:focus {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #44ffff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #44ffff inset !important;\r\n        color: #6dffff !important;\r\n    }\r\n\r\n    .ui.inverted.teal.basic.buttons .active.button,\r\n    .ui.inverted.teal.buttons .basic.active.button,\r\n    .ui.inverted.teal.basic.active.button {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #54ffff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #54ffff inset !important;\r\n        color: #6dffff !important;\r\n    }\r\n\r\n    .ui.inverted.teal.basic.buttons .button:active,\r\n    .ui.inverted.teal.buttons .basic.button:active,\r\n    .ui.inverted.teal.basic.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #3affff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #3affff inset !important;\r\n        color: #6dffff !important;\r\n    }\r\n\r\n    /*--- Olive ---*/\r\n    .ui.olive.buttons .button,\r\n    .ui.olive.button {\r\n        background-color: #b5cc18;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n    }\r\n\r\n    .ui.olive.button {\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.olive.buttons .button:hover,\r\n    .ui.olive.button:hover {\r\n        background-color: #a7bd0d;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.olive.buttons .button:focus,\r\n    .ui.olive.button:focus {\r\n        background-color: #a0b605;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.olive.buttons .button:active,\r\n    .ui.olive.button:active {\r\n        background-color: #8d9e13;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.olive.buttons .active.button,\r\n    .ui.olive.buttons .active.button:active,\r\n    .ui.olive.active.button,\r\n    .ui.olive.button .active.button:active {\r\n        background-color: #aac109;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* Basic */\r\n    .ui.basic.olive.buttons .button,\r\n    .ui.basic.olive.button {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #b5cc18 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #b5cc18 inset !important;\r\n        color: #b5cc18 !important;\r\n    }\r\n\r\n    .ui.basic.olive.buttons .button:hover,\r\n    .ui.basic.olive.button:hover {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #a7bd0d inset !important;\r\n        box-shadow: 0px 0px 0px 1px #a7bd0d inset !important;\r\n        color: #a7bd0d !important;\r\n    }\r\n\r\n    .ui.basic.olive.buttons .button:focus,\r\n    .ui.basic.olive.button:focus {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #a0b605 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #a0b605 inset !important;\r\n        color: #a7bd0d !important;\r\n    }\r\n\r\n    .ui.basic.olive.buttons .active.button,\r\n    .ui.basic.olive.active.button {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #aac109 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #aac109 inset !important;\r\n        color: #8d9e13 !important;\r\n    }\r\n\r\n    .ui.basic.olive.buttons .button:active,\r\n    .ui.basic.olive.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #8d9e13 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #8d9e13 inset !important;\r\n        color: #8d9e13 !important;\r\n    }\r\n\r\n    .ui.buttons:not(.vertical)>.basic.olive.button:not(:first-child) {\r\n        margin-left: -1px;\r\n    }\r\n\r\n    /* Inverted */\r\n    .ui.inverted.olive.buttons .button,\r\n    .ui.inverted.olive.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px #d9e778 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #d9e778 inset !important;\r\n        color: #d9e778;\r\n    }\r\n\r\n    .ui.inverted.olive.buttons .button:hover,\r\n    .ui.inverted.olive.button:hover,\r\n    .ui.inverted.olive.buttons .button:focus,\r\n    .ui.inverted.olive.button:focus,\r\n    .ui.inverted.olive.buttons .button.active,\r\n    .ui.inverted.olive.button.active,\r\n    .ui.inverted.olive.buttons .button:active,\r\n    .ui.inverted.olive.button:active {\r\n        -webkit-box-shadow: none !important;\r\n        box-shadow: none !important;\r\n        color: rgba(0, 0, 0, 0.6);\r\n    }\r\n\r\n    .ui.inverted.olive.buttons .button:hover,\r\n    .ui.inverted.olive.button:hover {\r\n        background-color: #d8ea5c;\r\n    }\r\n\r\n    .ui.inverted.olive.buttons .button:focus,\r\n    .ui.inverted.olive.button:focus {\r\n        background-color: #daef47;\r\n    }\r\n\r\n    .ui.inverted.olive.buttons .active.button,\r\n    .ui.inverted.olive.active.button {\r\n        background-color: #daed59;\r\n    }\r\n\r\n    .ui.inverted.olive.buttons .button:active,\r\n    .ui.inverted.olive.button:active {\r\n        background-color: #cddf4d;\r\n    }\r\n\r\n    /* Inverted Basic */\r\n    .ui.inverted.olive.basic.buttons .button,\r\n    .ui.inverted.olive.buttons .basic.button,\r\n    .ui.inverted.olive.basic.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    .ui.inverted.olive.basic.buttons .button:hover,\r\n    .ui.inverted.olive.buttons .basic.button:hover,\r\n    .ui.inverted.olive.basic.button:hover {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #d8ea5c inset !important;\r\n        box-shadow: 0px 0px 0px 2px #d8ea5c inset !important;\r\n        color: #d9e778 !important;\r\n    }\r\n\r\n    .ui.inverted.olive.basic.buttons .button:focus,\r\n    .ui.inverted.olive.basic.buttons .button:focus,\r\n    .ui.inverted.olive.basic.button:focus {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #daef47 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #daef47 inset !important;\r\n        color: #d9e778 !important;\r\n    }\r\n\r\n    .ui.inverted.olive.basic.buttons .active.button,\r\n    .ui.inverted.olive.buttons .basic.active.button,\r\n    .ui.inverted.olive.basic.active.button {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #daed59 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #daed59 inset !important;\r\n        color: #d9e778 !important;\r\n    }\r\n\r\n    .ui.inverted.olive.basic.buttons .button:active,\r\n    .ui.inverted.olive.buttons .basic.button:active,\r\n    .ui.inverted.olive.basic.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #cddf4d inset !important;\r\n        box-shadow: 0px 0px 0px 2px #cddf4d inset !important;\r\n        color: #d9e778 !important;\r\n    }\r\n\r\n    /*--- Yellow ---*/\r\n    .ui.yellow.buttons .button,\r\n    .ui.yellow.button {\r\n        background-color: #fbbd08;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n    }\r\n\r\n    .ui.yellow.button {\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.yellow.buttons .button:hover,\r\n    .ui.yellow.button:hover {\r\n        background-color: #eaae00;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.yellow.buttons .button:focus,\r\n    .ui.yellow.button:focus {\r\n        background-color: #daa300;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.yellow.buttons .button:active,\r\n    .ui.yellow.button:active {\r\n        background-color: #cd9903;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.yellow.buttons .active.button,\r\n    .ui.yellow.buttons .active.button:active,\r\n    .ui.yellow.active.button,\r\n    .ui.yellow.button .active.button:active {\r\n        background-color: #eaae00;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* Basic */\r\n    .ui.basic.yellow.buttons .button,\r\n    .ui.basic.yellow.button {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #fbbd08 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #fbbd08 inset !important;\r\n        color: #fbbd08 !important;\r\n    }\r\n\r\n    .ui.basic.yellow.buttons .button:hover,\r\n    .ui.basic.yellow.button:hover {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #eaae00 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #eaae00 inset !important;\r\n        color: #eaae00 !important;\r\n    }\r\n\r\n    .ui.basic.yellow.buttons .button:focus,\r\n    .ui.basic.yellow.button:focus {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #daa300 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #daa300 inset !important;\r\n        color: #eaae00 !important;\r\n    }\r\n\r\n    .ui.basic.yellow.buttons .active.button,\r\n    .ui.basic.yellow.active.button {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #eaae00 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #eaae00 inset !important;\r\n        color: #cd9903 !important;\r\n    }\r\n\r\n    .ui.basic.yellow.buttons .button:active,\r\n    .ui.basic.yellow.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #cd9903 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #cd9903 inset !important;\r\n        color: #cd9903 !important;\r\n    }\r\n\r\n    .ui.buttons:not(.vertical)>.basic.yellow.button:not(:first-child) {\r\n        margin-left: -1px;\r\n    }\r\n\r\n    /* Inverted */\r\n    .ui.inverted.yellow.buttons .button,\r\n    .ui.inverted.yellow.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ffe21f inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ffe21f inset !important;\r\n        color: #ffe21f;\r\n    }\r\n\r\n    .ui.inverted.yellow.buttons .button:hover,\r\n    .ui.inverted.yellow.button:hover,\r\n    .ui.inverted.yellow.buttons .button:focus,\r\n    .ui.inverted.yellow.button:focus,\r\n    .ui.inverted.yellow.buttons .button.active,\r\n    .ui.inverted.yellow.button.active,\r\n    .ui.inverted.yellow.buttons .button:active,\r\n    .ui.inverted.yellow.button:active {\r\n        -webkit-box-shadow: none !important;\r\n        box-shadow: none !important;\r\n        color: rgba(0, 0, 0, 0.6);\r\n    }\r\n\r\n    .ui.inverted.yellow.buttons .button:hover,\r\n    .ui.inverted.yellow.button:hover {\r\n        background-color: #ffdf05;\r\n    }\r\n\r\n    .ui.inverted.yellow.buttons .button:focus,\r\n    .ui.inverted.yellow.button:focus {\r\n        background-color: #f5d500;\r\n    }\r\n\r\n    .ui.inverted.yellow.buttons .active.button,\r\n    .ui.inverted.yellow.active.button {\r\n        background-color: #ffdf05;\r\n    }\r\n\r\n    .ui.inverted.yellow.buttons .button:active,\r\n    .ui.inverted.yellow.button:active {\r\n        background-color: #ebcd00;\r\n    }\r\n\r\n    /* Inverted Basic */\r\n    .ui.inverted.yellow.basic.buttons .button,\r\n    .ui.inverted.yellow.buttons .basic.button,\r\n    .ui.inverted.yellow.basic.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    .ui.inverted.yellow.basic.buttons .button:hover,\r\n    .ui.inverted.yellow.buttons .basic.button:hover,\r\n    .ui.inverted.yellow.basic.button:hover {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ffdf05 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ffdf05 inset !important;\r\n        color: #ffe21f !important;\r\n    }\r\n\r\n    .ui.inverted.yellow.basic.buttons .button:focus,\r\n    .ui.inverted.yellow.basic.buttons .button:focus,\r\n    .ui.inverted.yellow.basic.button:focus {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #f5d500 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #f5d500 inset !important;\r\n        color: #ffe21f !important;\r\n    }\r\n\r\n    .ui.inverted.yellow.basic.buttons .active.button,\r\n    .ui.inverted.yellow.buttons .basic.active.button,\r\n    .ui.inverted.yellow.basic.active.button {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ffdf05 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ffdf05 inset !important;\r\n        color: #ffe21f !important;\r\n    }\r\n\r\n    .ui.inverted.yellow.basic.buttons .button:active,\r\n    .ui.inverted.yellow.buttons .basic.button:active,\r\n    .ui.inverted.yellow.basic.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #ebcd00 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #ebcd00 inset !important;\r\n        color: #ffe21f !important;\r\n    }\r\n\r\n    /*-------------------\r\n       Primary\r\n--------------------*/\r\n    /*--- Standard ---*/\r\n    .ui.primary.buttons .button,\r\n    .ui.primary.button {\r\n        background-color: #2185d0;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n    }\r\n\r\n    .ui.primary.button {\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.primary.buttons .button:hover,\r\n    .ui.primary.button:hover {\r\n        background-color: #1678c2;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.primary.buttons .button:focus,\r\n    .ui.primary.button:focus {\r\n        background-color: #0d71bb;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.primary.buttons .button:active,\r\n    .ui.primary.button:active {\r\n        background-color: #1a69a4;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.primary.buttons .active.button,\r\n    .ui.primary.buttons .active.button:active,\r\n    .ui.primary.active.button,\r\n    .ui.primary.button .active.button:active {\r\n        background-color: #1279c6;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* Basic */\r\n    .ui.basic.primary.buttons .button,\r\n    .ui.basic.primary.button {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #2185d0 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #2185d0 inset !important;\r\n        color: #2185d0 !important;\r\n    }\r\n\r\n    .ui.basic.primary.buttons .button:hover,\r\n    .ui.basic.primary.button:hover {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #1678c2 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #1678c2 inset !important;\r\n        color: #1678c2 !important;\r\n    }\r\n\r\n    .ui.basic.primary.buttons .button:focus,\r\n    .ui.basic.primary.button:focus {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #0d71bb inset !important;\r\n        box-shadow: 0px 0px 0px 1px #0d71bb inset !important;\r\n        color: #1678c2 !important;\r\n    }\r\n\r\n    .ui.basic.primary.buttons .active.button,\r\n    .ui.basic.primary.active.button {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #1279c6 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #1279c6 inset !important;\r\n        color: #1a69a4 !important;\r\n    }\r\n\r\n    .ui.basic.primary.buttons .button:active,\r\n    .ui.basic.primary.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #1a69a4 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #1a69a4 inset !important;\r\n        color: #1a69a4 !important;\r\n    }\r\n\r\n    .ui.buttons:not(.vertical)>.basic.primary.button:not(:first-child) {\r\n        margin-left: -1px;\r\n    }\r\n\r\n    /* Inverted */\r\n    .ui.inverted.primary.buttons .button,\r\n    .ui.inverted.primary.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px #54c8ff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #54c8ff inset !important;\r\n        color: #54c8ff;\r\n    }\r\n\r\n    .ui.inverted.primary.buttons .button:hover,\r\n    .ui.inverted.primary.button:hover,\r\n    .ui.inverted.primary.buttons .button:focus,\r\n    .ui.inverted.primary.button:focus,\r\n    .ui.inverted.primary.buttons .button.active,\r\n    .ui.inverted.primary.button.active,\r\n    .ui.inverted.primary.buttons .button:active,\r\n    .ui.inverted.primary.button:active {\r\n        -webkit-box-shadow: none !important;\r\n        box-shadow: none !important;\r\n        color: #ffffff;\r\n    }\r\n\r\n    .ui.inverted.primary.buttons .button:hover,\r\n    .ui.inverted.primary.button:hover {\r\n        background-color: #3ac0ff;\r\n    }\r\n\r\n    .ui.inverted.primary.buttons .button:focus,\r\n    .ui.inverted.primary.button:focus {\r\n        background-color: #2bbbff;\r\n    }\r\n\r\n    .ui.inverted.primary.buttons .active.button,\r\n    .ui.inverted.primary.active.button {\r\n        background-color: #3ac0ff;\r\n    }\r\n\r\n    .ui.inverted.primary.buttons .button:active,\r\n    .ui.inverted.primary.button:active {\r\n        background-color: #21b8ff;\r\n    }\r\n\r\n    /* Inverted Basic */\r\n    .ui.inverted.primary.basic.buttons .button,\r\n    .ui.inverted.primary.buttons .basic.button,\r\n    .ui.inverted.primary.basic.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    .ui.inverted.primary.basic.buttons .button:hover,\r\n    .ui.inverted.primary.buttons .basic.button:hover,\r\n    .ui.inverted.primary.basic.button:hover {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #3ac0ff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #3ac0ff inset !important;\r\n        color: #54c8ff !important;\r\n    }\r\n\r\n    .ui.inverted.primary.basic.buttons .button:focus,\r\n    .ui.inverted.primary.basic.buttons .button:focus,\r\n    .ui.inverted.primary.basic.button:focus {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #2bbbff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #2bbbff inset !important;\r\n        color: #54c8ff !important;\r\n    }\r\n\r\n    .ui.inverted.primary.basic.buttons .active.button,\r\n    .ui.inverted.primary.buttons .basic.active.button,\r\n    .ui.inverted.primary.basic.active.button {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #3ac0ff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #3ac0ff inset !important;\r\n        color: #54c8ff !important;\r\n    }\r\n\r\n    .ui.inverted.primary.basic.buttons .button:active,\r\n    .ui.inverted.primary.buttons .basic.button:active,\r\n    .ui.inverted.primary.basic.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #21b8ff inset !important;\r\n        box-shadow: 0px 0px 0px 2px #21b8ff inset !important;\r\n        color: #54c8ff !important;\r\n    }\r\n\r\n    /*-------------------\r\n      Secondary\r\n--------------------*/\r\n    /* Standard */\r\n    .ui.secondary.buttons .button,\r\n    .ui.secondary.button {\r\n        background-color: #1b1c1d;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n    }\r\n\r\n    .ui.secondary.button {\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.secondary.buttons .button:hover,\r\n    .ui.secondary.button:hover {\r\n        background-color: #27292a;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.secondary.buttons .button:focus,\r\n    .ui.secondary.button:focus {\r\n        background-color: #2e3032;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.secondary.buttons .button:active,\r\n    .ui.secondary.button:active {\r\n        background-color: #343637;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.secondary.buttons .active.button,\r\n    .ui.secondary.buttons .active.button:active,\r\n    .ui.secondary.active.button,\r\n    .ui.secondary.button .active.button:active {\r\n        background-color: #27292a;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* Basic */\r\n    .ui.basic.secondary.buttons .button,\r\n    .ui.basic.secondary.button {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #1b1c1d inset !important;\r\n        box-shadow: 0px 0px 0px 1px #1b1c1d inset !important;\r\n        color: #1b1c1d !important;\r\n    }\r\n\r\n    .ui.basic.secondary.buttons .button:hover,\r\n    .ui.basic.secondary.button:hover {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #27292a inset !important;\r\n        box-shadow: 0px 0px 0px 1px #27292a inset !important;\r\n        color: #27292a !important;\r\n    }\r\n\r\n    .ui.basic.secondary.buttons .button:focus,\r\n    .ui.basic.secondary.button:focus {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #2e3032 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #2e3032 inset !important;\r\n        color: #27292a !important;\r\n    }\r\n\r\n    .ui.basic.secondary.buttons .active.button,\r\n    .ui.basic.secondary.active.button {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #27292a inset !important;\r\n        box-shadow: 0px 0px 0px 1px #27292a inset !important;\r\n        color: #343637 !important;\r\n    }\r\n\r\n    .ui.basic.secondary.buttons .button:active,\r\n    .ui.basic.secondary.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #343637 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #343637 inset !important;\r\n        color: #343637 !important;\r\n    }\r\n\r\n    .ui.buttons:not(.vertical)>.basic.primary.button:not(:first-child) {\r\n        margin-left: -1px;\r\n    }\r\n\r\n    /* Inverted */\r\n    .ui.inverted.secondary.buttons .button,\r\n    .ui.inverted.secondary.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px #545454 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #545454 inset !important;\r\n        color: #545454;\r\n    }\r\n\r\n    .ui.inverted.secondary.buttons .button:hover,\r\n    .ui.inverted.secondary.button:hover,\r\n    .ui.inverted.secondary.buttons .button:focus,\r\n    .ui.inverted.secondary.button:focus,\r\n    .ui.inverted.secondary.buttons .button.active,\r\n    .ui.inverted.secondary.button.active,\r\n    .ui.inverted.secondary.buttons .button:active,\r\n    .ui.inverted.secondary.button:active {\r\n        -webkit-box-shadow: none !important;\r\n        box-shadow: none !important;\r\n        color: #ffffff;\r\n    }\r\n\r\n    .ui.inverted.secondary.buttons .button:hover,\r\n    .ui.inverted.secondary.button:hover {\r\n        background-color: #616161;\r\n    }\r\n\r\n    .ui.inverted.secondary.buttons .button:focus,\r\n    .ui.inverted.secondary.button:focus {\r\n        background-color: #686868;\r\n    }\r\n\r\n    .ui.inverted.secondary.buttons .active.button,\r\n    .ui.inverted.secondary.active.button {\r\n        background-color: #616161;\r\n    }\r\n\r\n    .ui.inverted.secondary.buttons .button:active,\r\n    .ui.inverted.secondary.button:active {\r\n        background-color: #6e6e6e;\r\n    }\r\n\r\n    /* Inverted Basic */\r\n    .ui.inverted.secondary.basic.buttons .button,\r\n    .ui.inverted.secondary.buttons .basic.button,\r\n    .ui.inverted.secondary.basic.button {\r\n        background-color: transparent;\r\n        -webkit-box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.5) inset !important;\r\n        color: #ffffff !important;\r\n    }\r\n\r\n    .ui.inverted.secondary.basic.buttons .button:hover,\r\n    .ui.inverted.secondary.buttons .basic.button:hover,\r\n    .ui.inverted.secondary.basic.button:hover {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #616161 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #616161 inset !important;\r\n        color: #545454 !important;\r\n    }\r\n\r\n    .ui.inverted.secondary.basic.buttons .button:focus,\r\n    .ui.inverted.secondary.basic.buttons .button:focus,\r\n    .ui.inverted.secondary.basic.button:focus {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #686868 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #686868 inset !important;\r\n        color: #545454 !important;\r\n    }\r\n\r\n    .ui.inverted.secondary.basic.buttons .active.button,\r\n    .ui.inverted.secondary.buttons .basic.active.button,\r\n    .ui.inverted.secondary.basic.active.button {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #616161 inset !important;\r\n        box-shadow: 0px 0px 0px 2px #616161 inset !important;\r\n        color: #545454 !important;\r\n    }\r\n\r\n    .ui.inverted.secondary.basic.buttons .button:active,\r\n    .ui.inverted.secondary.buttons .basic.button:active,\r\n    .ui.inverted.secondary.basic.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 2px #6e6e6e inset !important;\r\n        box-shadow: 0px 0px 0px 2px #6e6e6e inset !important;\r\n        color: #545454 !important;\r\n    }\r\n\r\n    /*---------------\r\n    Positive\r\n----------------*/\r\n    /* Standard */\r\n    .ui.positive.buttons .button,\r\n    .ui.positive.button {\r\n        background-color: #21ba45;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n    }\r\n\r\n    .ui.positive.button {\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.positive.buttons .button:hover,\r\n    .ui.positive.button:hover {\r\n        background-color: #16ab39;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.positive.buttons .button:focus,\r\n    .ui.positive.button:focus {\r\n        background-color: #0ea432;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.positive.buttons .button:active,\r\n    .ui.positive.button:active {\r\n        background-color: #198f35;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.positive.buttons .active.button,\r\n    .ui.positive.buttons .active.button:active,\r\n    .ui.positive.active.button,\r\n    .ui.positive.button .active.button:active {\r\n        background-color: #13ae38;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* Basic */\r\n    .ui.basic.positive.buttons .button,\r\n    .ui.basic.positive.button {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #21ba45 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #21ba45 inset !important;\r\n        color: #21ba45 !important;\r\n    }\r\n\r\n    .ui.basic.positive.buttons .button:hover,\r\n    .ui.basic.positive.button:hover {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #16ab39 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #16ab39 inset !important;\r\n        color: #16ab39 !important;\r\n    }\r\n\r\n    .ui.basic.positive.buttons .button:focus,\r\n    .ui.basic.positive.button:focus {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #0ea432 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #0ea432 inset !important;\r\n        color: #16ab39 !important;\r\n    }\r\n\r\n    .ui.basic.positive.buttons .active.button,\r\n    .ui.basic.positive.active.button {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #13ae38 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #13ae38 inset !important;\r\n        color: #198f35 !important;\r\n    }\r\n\r\n    .ui.basic.positive.buttons .button:active,\r\n    .ui.basic.positive.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #198f35 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #198f35 inset !important;\r\n        color: #198f35 !important;\r\n    }\r\n\r\n    .ui.buttons:not(.vertical)>.basic.primary.button:not(:first-child) {\r\n        margin-left: -1px;\r\n    }\r\n\r\n    /*---------------\r\n     Negative\r\n----------------*/\r\n    /* Standard */\r\n    .ui.negative.buttons .button,\r\n    .ui.negative.button {\r\n        background-color: #db2828;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n        background-image: none;\r\n    }\r\n\r\n    .ui.negative.button {\r\n        -webkit-box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.negative.buttons .button:hover,\r\n    .ui.negative.button:hover {\r\n        background-color: #d01919;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.negative.buttons .button:focus,\r\n    .ui.negative.button:focus {\r\n        background-color: #ca1010;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.negative.buttons .button:active,\r\n    .ui.negative.button:active {\r\n        background-color: #b21e1e;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    .ui.negative.buttons .active.button,\r\n    .ui.negative.buttons .active.button:active,\r\n    .ui.negative.active.button,\r\n    .ui.negative.button .active.button:active {\r\n        background-color: #d41515;\r\n        color: #ffffff;\r\n        text-shadow: none;\r\n    }\r\n\r\n    /* Basic */\r\n    .ui.basic.negative.buttons .button,\r\n    .ui.basic.negative.button {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #db2828 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #db2828 inset !important;\r\n        color: #db2828 !important;\r\n    }\r\n\r\n    .ui.basic.negative.buttons .button:hover,\r\n    .ui.basic.negative.button:hover {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #d01919 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #d01919 inset !important;\r\n        color: #d01919 !important;\r\n    }\r\n\r\n    .ui.basic.negative.buttons .button:focus,\r\n    .ui.basic.negative.button:focus {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #ca1010 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #ca1010 inset !important;\r\n        color: #d01919 !important;\r\n    }\r\n\r\n    .ui.basic.negative.buttons .active.button,\r\n    .ui.basic.negative.active.button {\r\n        background: transparent !important;\r\n        -webkit-box-shadow: 0px 0px 0px 1px #d41515 inset !important;\r\n        box-shadow: 0px 0px 0px 1px #d41515 inset !important;\r\n        color: #b21e1e !important;\r\n    }\r\n\r\n    .ui.basic.negative.buttons .button:active,\r\n    .ui.basic.negative.button:active {\r\n        -webkit-box-shadow: 0px 0px 0px 1px #b21e1e inset !important;\r\n        box-shadow: 0px 0px 0px 1px #b21e1e inset !important;\r\n        color: #b21e1e !important;\r\n    }\r\n\r\n    .ui.buttons:not(.vertical)>.basic.primary.button:not(:first-child) {\r\n        margin-left: -1px;\r\n    }\r\n\r\n    /*******************************\r\n            Groups\r\n*******************************/\r\n    .ui.buttons {\r\n        display: -webkit-inline-box;\r\n        display: -ms-inline-flexbox;\r\n        display: inline-flex;\r\n        -webkit-box-orient: horizontal;\r\n        -webkit-box-direction: normal;\r\n        -ms-flex-direction: row;\r\n        flex-direction: row;\r\n        font-size: 0em;\r\n        vertical-align: baseline;\r\n        margin: 0em 0.25em 0em 0em;\r\n    }\r\n\r\n    .ui.buttons:not(.basic):not(.inverted) {\r\n        -webkit-box-shadow: none;\r\n        box-shadow: none;\r\n    }\r\n\r\n    /* Clearfix */\r\n    .ui.buttons:after {\r\n        content: \".\";\r\n        display: block;\r\n        height: 0;\r\n        clear: both;\r\n        visibility: hidden;\r\n    }\r\n\r\n    /* Standard Group */\r\n    .ui.buttons .button {\r\n        -webkit-box-flex: 1;\r\n        -ms-flex: 1 0 auto;\r\n        flex: 1 0 auto;\r\n        margin: 0em;\r\n        border-radius: 0em;\r\n        margin: 0px 0px 0px 0px;\r\n    }\r\n\r\n    .ui.buttons>.ui.button:not(.basic):not(.inverted),\r\n    .ui.buttons:not(.basic):not(.inverted)>.button {\r\n        -webkit-box-shadow: 0px 0px 0px 1px transparent inset,\r\n            0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n        box-shadow: 0px 0px 0px 1px transparent inset, 0px 0em 0px 0px rgba(34, 36, 38, 0.15) inset;\r\n    }\r\n\r\n    .ui.buttons .button:first-child {\r\n        border-left: none;\r\n        margin-left: 0em;\r\n        border-top-left-radius: 0.28571429rem;\r\n        border-bottom-left-radius: 0.28571429rem;\r\n    }\r\n\r\n    .ui.buttons .button:last-child {\r\n        border-top-right-radius: 0.28571429rem;\r\n        border-bottom-right-radius: 0.28571429rem;\r\n    }\r\n\r\n    /* Vertical  Style */\r\n    .ui.vertical.buttons {\r\n        display: -webkit-inline-box;\r\n        display: -ms-inline-flexbox;\r\n        display: inline-flex;\r\n        -webkit-box-orient: vertical;\r\n        -webkit-box-direction: normal;\r\n        -ms-flex-direction: column;\r\n        flex-direction: column;\r\n    }\r\n\r\n    .ui.vertical.buttons .button {\r\n        display: block;\r\n        float: none;\r\n        width: 100%;\r\n        margin: 0px 0px 0px 0px;\r\n        -webkit-box-shadow: none;\r\n        box-shadow: none;\r\n        border-radius: 0em;\r\n    }\r\n\r\n    .ui.vertical.buttons .button:first-child {\r\n        border-top-left-radius: 0.28571429rem;\r\n        border-top-right-radius: 0.28571429rem;\r\n    }\r\n\r\n    .ui.vertical.buttons .button:last-child {\r\n        margin-bottom: 0px;\r\n        border-bottom-left-radius: 0.28571429rem;\r\n        border-bottom-right-radius: 0.28571429rem;\r\n    }\r\n\r\n    .ui.vertical.buttons .button:only-child {\r\n        border-radius: 0.28571429rem;\r\n    }\r\n}\r\n\r\n@mixin datatable_semantic {\r\n\r\n    /*\r\n * Styling for DataTables with Semantic UI\r\n */\r\n    table.dataTable.table {\r\n        margin: 0;\r\n    }\r\n\r\n    table.dataTable.table thead th,\r\n    table.dataTable.table thead td {\r\n        position: relative;\r\n    }\r\n\r\n    table.dataTable.table thead th.sorting,\r\n    table.dataTable.table thead th.sorting_asc,\r\n    table.dataTable.table thead th.sorting_desc,\r\n    table.dataTable.table thead td.sorting,\r\n    table.dataTable.table thead td.sorting_asc,\r\n    table.dataTable.table thead td.sorting_desc {\r\n        padding-right: 30px;\r\n    }\r\n\r\n    table.dataTable.table thead th.sorting:after,\r\n    table.dataTable.table thead th.sorting_asc:after,\r\n    table.dataTable.table thead th.sorting_desc:after,\r\n    table.dataTable.table thead td.sorting:after,\r\n    table.dataTable.table thead td.sorting_asc:after,\r\n    table.dataTable.table thead td.sorting_desc:after {\r\n        position: absolute;\r\n        right: 8px;\r\n        display: block;\r\n        font-family: Icons;\r\n        top: 50%;\r\n        transform: translateY(-50%);\r\n    }\r\n\r\n    table.dataTable.table thead th.sorting:after,\r\n    table.dataTable.table thead td.sorting:after {\r\n        content: \" \\21C5\";\r\n        color: #5d5b5f8f;\r\n        font-size: 0.8em;\r\n    }\r\n\r\n    table.dataTable.table thead th.sorting_asc:after,\r\n    table.dataTable.table thead td.sorting_asc:after {\r\n        content: \" \\25B2\";\r\n        font-size: 0.9em;\r\n    }\r\n\r\n    table.dataTable.table thead th.sorting_desc:after,\r\n    table.dataTable.table thead td.sorting_desc:after {\r\n        content: \" \\25BC\";\r\n        font-size: 0.9em;\r\n    }\r\n\r\n    /* Manual add : - Hide sorting and its icons for th and td elements */\r\n    table.dataTable.table thead th.sorting-icon-hidden::after,\r\n    table.dataTable.table thead td.sorting-icon-hidden::after {\r\n        display: none;\r\n    }\r\n    table.dataTable.table thead th.sorting-icon-hidden.sorting_asc::after,\r\n    table.dataTable.table thead td.sorting-icon-hidden.sorting_asc::after {\r\n        display: none;\r\n    }\r\n    \r\n    table.dataTable.table thead th.sorting-icon-hidden.sorting_desc::after,\r\n    table.dataTable.table thead td.sorting-icon-hidden.sorting_desc::after {\r\n        display: none;\r\n    }\r\n    \r\n\r\n    table.dataTable.table td,\r\n    table.dataTable.table th {\r\n        -webkit-box-sizing: content-box;\r\n        box-sizing: content-box;\r\n    }\r\n\r\n    table.dataTable.table td.dataTables_empty,\r\n    table.dataTable.table th.dataTables_empty {\r\n        text-align: center;\r\n    }\r\n\r\n    table.dataTable.table.nowrap th,\r\n    table.dataTable.table.nowrap td {\r\n        white-space: nowrap;\r\n    }\r\n\r\n    div.dataTables_wrapper div.dataTables_length select {\r\n        vertical-align: middle;\r\n        min-height: 2.7142em;\r\n    }\r\n\r\n    div.dataTables_wrapper div.dataTables_length .ui.selection.dropdown {\r\n        min-width: 0;\r\n    }\r\n\r\n    div.dataTables_wrapper div.dataTables_filter span.input {\r\n        margin-left: 0.5em;\r\n    }\r\n\r\n    div.dataTables_wrapper div.dataTables_info {\r\n        padding-top: 13px;\r\n        white-space: nowrap;\r\n    }\r\n\r\n    div.dataTables_wrapper div.dataTables_processing {\r\n        position: absolute;\r\n        top: 50%;\r\n        left: 50%;\r\n        width: 200px;\r\n        margin-left: -100px;\r\n        text-align: center;\r\n    }\r\n\r\n    div.dataTables_wrapper div.row.dt-table {\r\n        padding: 0;\r\n    }\r\n\r\n    div.dataTables_wrapper div.dataTables_scrollHead table.dataTable {\r\n        border-bottom-right-radius: 0;\r\n        border-bottom-left-radius: 0;\r\n        border-bottom: none;\r\n    }\r\n\r\n    div.dataTables_wrapper div.dataTables_scrollBody thead .sorting:after,\r\n    div.dataTables_wrapper div.dataTables_scrollBody thead .sorting_asc:after,\r\n    div.dataTables_wrapper div.dataTables_scrollBody thead .sorting_desc:after {\r\n        display: none;\r\n    }\r\n\r\n    div.dataTables_wrapper div.dataTables_scrollBody table.dataTable {\r\n        border-radius: 0;\r\n        border-top: none;\r\n        border-bottom-width: 0;\r\n    }\r\n\r\n    div.dataTables_wrapper div.dataTables_scrollBody table.dataTable.no-footer {\r\n        border-bottom-width: 1px;\r\n    }\r\n\r\n    div.dataTables_wrapper div.dataTables_scrollFoot table.dataTable {\r\n        border-top-right-radius: 0;\r\n        border-top-left-radius: 0;\r\n        border-top: none;\r\n    }\r\n}\r\n\r\n@mixin loader_style {\r\n\r\n    /* Standard Size */\r\n    .ui.loader {\r\n        display: none;\r\n        position: absolute;\r\n        top: 50%;\r\n        left: 50%;\r\n        margin: 0px;\r\n        text-align: center;\r\n        z-index: 1000;\r\n        -webkit-transform: translateX(-50%) translateY(-50%);\r\n        transform: translateX(-50%) translateY(-50%);\r\n    }\r\n\r\n    /* Static Shape */\r\n    .ui.loader:before {\r\n        position: absolute;\r\n        content: \"\";\r\n        top: 0%;\r\n        left: 50%;\r\n        width: 100%;\r\n        height: 100%;\r\n        border-radius: 500rem;\r\n        border: 0.2em solid rgba(0, 0, 0, 0.1);\r\n    }\r\n\r\n    /* Active Shape */\r\n    .ui.loader:after {\r\n        position: absolute;\r\n        content: \"\";\r\n        top: 0%;\r\n        left: 50%;\r\n        width: 100%;\r\n        height: 100%;\r\n        -webkit-animation: loader 0.6s linear;\r\n        animation: loader 0.6s linear;\r\n        -webkit-animation-iteration-count: infinite;\r\n        animation-iteration-count: infinite;\r\n        border-radius: 500rem;\r\n        border-color: #767676 transparent transparent;\r\n        border-style: solid;\r\n        border-width: 0.2em;\r\n        -webkit-box-shadow: 0px 0px 0px 1px transparent;\r\n        box-shadow: 0px 0px 0px 1px transparent;\r\n    }\r\n\r\n    /* Active Animation */\r\n    @-webkit-keyframes loader {\r\n        from {\r\n            -webkit-transform: rotate(0deg);\r\n            transform: rotate(0deg);\r\n        }\r\n\r\n        to {\r\n            -webkit-transform: rotate(360deg);\r\n            transform: rotate(360deg);\r\n        }\r\n    }\r\n\r\n    @keyframes loader {\r\n        from {\r\n            -webkit-transform: rotate(0deg);\r\n            transform: rotate(0deg);\r\n        }\r\n\r\n        to {\r\n            -webkit-transform: rotate(360deg);\r\n            transform: rotate(360deg);\r\n        }\r\n    }\r\n\r\n    /* Sizes */\r\n    .ui.mini.loader:before,\r\n    .ui.mini.loader:after {\r\n        width: 1rem;\r\n        height: 1rem;\r\n        margin: 0em 0em 0em -0.5rem;\r\n    }\r\n\r\n    .ui.tiny.loader:before,\r\n    .ui.tiny.loader:after {\r\n        width: 1.14285714rem;\r\n        height: 1.14285714rem;\r\n        margin: 0em 0em 0em -0.57142857rem;\r\n    }\r\n\r\n    .ui.small.loader:before,\r\n    .ui.small.loader:after {\r\n        width: 1.71428571rem;\r\n        height: 1.71428571rem;\r\n        margin: 0em 0em 0em -0.85714286rem;\r\n    }\r\n\r\n    .ui.loader:before,\r\n    .ui.loader:after {\r\n        width: 2.28571429rem;\r\n        height: 2.28571429rem;\r\n        margin: 0em 0em 0em -1.14285714rem;\r\n    }\r\n\r\n    .ui.large.loader:before,\r\n    .ui.large.loader:after {\r\n        width: 3.42857143rem;\r\n        height: 3.42857143rem;\r\n        margin: 0em 0em 0em -1.71428571rem;\r\n    }\r\n\r\n    .ui.big.loader:before,\r\n    .ui.big.loader:after {\r\n        width: 3.71428571rem;\r\n        height: 3.71428571rem;\r\n        margin: 0em 0em 0em -1.85714286rem;\r\n    }\r\n\r\n    .ui.huge.loader:before,\r\n    .ui.huge.loader:after {\r\n        width: 4.14285714rem;\r\n        height: 4.14285714rem;\r\n        margin: 0em 0em 0em -2.07142857rem;\r\n    }\r\n\r\n    .ui.massive.loader:before,\r\n    .ui.massive.loader:after {\r\n        width: 4.57142857rem;\r\n        height: 4.57142857rem;\r\n        margin: 0em 0em 0em -2.28571429rem;\r\n    }\r\n\r\n    /*-------------------\r\n      Coupling\r\n--------------------*/\r\n    /* Show inside active dimmer */\r\n    .ui.dimmer .loader {\r\n        display: block;\r\n    }\r\n\r\n    /* Black Dimmer */\r\n    .ui.dimmer .ui.loader {\r\n        color: rgba(255, 255, 255, 0.9);\r\n    }\r\n\r\n    .ui.dimmer .ui.loader:before {\r\n        border-color: rgba(255, 255, 255, 0.15);\r\n    }\r\n\r\n    .ui.dimmer .ui.loader:after {\r\n        border-color: #ffffff transparent transparent;\r\n    }\r\n\r\n    /* White Dimmer (Inverted) */\r\n    .ui.inverted.dimmer .ui.loader {\r\n        color: rgba(0, 0, 0, 0.87);\r\n    }\r\n\r\n    .ui.inverted.dimmer .ui.loader:before {\r\n        border-color: rgba(0, 0, 0, 0.1);\r\n    }\r\n\r\n    .ui.inverted.dimmer .ui.loader:after {\r\n        border-color: #767676 transparent transparent;\r\n    }\r\n\r\n    /*******************************\r\n             Types\r\n*******************************/\r\n    /*-------------------\r\n        Text\r\n--------------------*/\r\n    .ui.text.loader {\r\n        width: auto !important;\r\n        height: auto !important;\r\n        text-align: center;\r\n        font-style: normal;\r\n    }\r\n\r\n    /*******************************\r\n            States\r\n*******************************/\r\n    .ui.indeterminate.loader:after {\r\n        animation-direction: reverse;\r\n        -webkit-animation-duration: 1.2s;\r\n        animation-duration: 1.2s;\r\n    }\r\n\r\n    .ui.loader.active,\r\n    .ui.loader.visible {\r\n        display: block;\r\n    }\r\n\r\n    .ui.loader.disabled,\r\n    .ui.loader.hidden {\r\n        display: none;\r\n    }\r\n\r\n    /*******************************\r\n            Variations\r\n*******************************/\r\n    /*-------------------\r\n        Sizes\r\n--------------------*/\r\n    /* Loader */\r\n    .ui.inverted.dimmer .ui.mini.loader,\r\n    .ui.mini.loader {\r\n        width: 1rem;\r\n        height: 1rem;\r\n        font-size: 0.78571429em;\r\n    }\r\n\r\n    .ui.inverted.dimmer .ui.tiny.loader,\r\n    .ui.tiny.loader {\r\n        width: 1.14285714rem;\r\n        height: 1.14285714rem;\r\n        font-size: 0.85714286em;\r\n    }\r\n\r\n    .ui.inverted.dimmer .ui.small.loader,\r\n    .ui.small.loader {\r\n        width: 1.71428571rem;\r\n        height: 1.71428571rem;\r\n        font-size: 0.92857143em;\r\n    }\r\n\r\n    .ui.inverted.dimmer .ui.loader,\r\n    .ui.loader {\r\n        width: 2.28571429rem;\r\n        height: 2.28571429rem;\r\n        font-size: 1em;\r\n    }\r\n\r\n    .ui.inverted.dimmer .ui.large.loader,\r\n    .ui.large.loader {\r\n        width: 3.42857143rem;\r\n        height: 3.42857143rem;\r\n        font-size: 1.14285714em;\r\n    }\r\n\r\n    .ui.inverted.dimmer .ui.big.loader,\r\n    .ui.big.loader {\r\n        width: 3.71428571rem;\r\n        height: 3.71428571rem;\r\n        font-size: 1.28571429em;\r\n    }\r\n\r\n    .ui.inverted.dimmer .ui.huge.loader,\r\n    .ui.huge.loader {\r\n        width: 4.14285714rem;\r\n        height: 4.14285714rem;\r\n        font-size: 1.42857143em;\r\n    }\r\n\r\n    .ui.inverted.dimmer .ui.massive.loader,\r\n    .ui.massive.loader {\r\n        width: 4.57142857rem;\r\n        height: 4.57142857rem;\r\n        font-size: 1.71428571em;\r\n    }\r\n\r\n    /* Text Loader */\r\n    .ui.mini.text.loader {\r\n        min-width: 1rem;\r\n        padding-top: 1.78571429rem;\r\n    }\r\n\r\n    .ui.tiny.text.loader {\r\n        min-width: 1.14285714rem;\r\n        padding-top: 1.92857143rem;\r\n    }\r\n\r\n    .ui.small.text.loader {\r\n        min-width: 1.71428571rem;\r\n        padding-top: 2.5rem;\r\n    }\r\n\r\n    .ui.text.loader {\r\n        min-width: 2.28571429rem;\r\n        padding-top: 3.07142857rem;\r\n    }\r\n\r\n    .ui.large.text.loader {\r\n        min-width: 3.42857143rem;\r\n        padding-top: 4.21428571rem;\r\n    }\r\n\r\n    .ui.big.text.loader {\r\n        min-width: 3.71428571rem;\r\n        padding-top: 4.5rem;\r\n    }\r\n\r\n    .ui.huge.text.loader {\r\n        min-width: 4.14285714rem;\r\n        padding-top: 4.92857143rem;\r\n    }\r\n\r\n    .ui.massive.text.loader {\r\n        min-width: 4.57142857rem;\r\n        padding-top: 5.35714286rem;\r\n    }\r\n\r\n    /*-------------------\r\n       Inverted\r\n--------------------*/\r\n    .ui.inverted.loader {\r\n        color: rgba(255, 255, 255, 0.9);\r\n    }\r\n\r\n    .ui.inverted.loader:before {\r\n        border-color: rgba(255, 255, 255, 0.15);\r\n    }\r\n\r\n    .ui.inverted.loader:after {\r\n        border-top-color: #ffffff;\r\n    }\r\n\r\n    /*-------------------\r\n       Inline\r\n--------------------*/\r\n    .ui.inline.loader {\r\n        position: relative;\r\n        vertical-align: middle;\r\n        margin: 0em;\r\n        left: 0em;\r\n        top: 0em;\r\n        -webkit-transform: none;\r\n        transform: none;\r\n    }\r\n\r\n    .ui.inline.loader.active,\r\n    .ui.inline.loader.visible {\r\n        display: inline-block;\r\n    }\r\n\r\n    /* Centered Inline */\r\n    .ui.centered.inline.loader.active,\r\n    .ui.centered.inline.loader.visible {\r\n        display: block;\r\n        margin-left: auto;\r\n        margin-right: auto;\r\n    }\r\n}\r\n\r\n@mixin input_style {\r\n    .ui.input {\r\n        position: relative;\r\n        font-weight: normal;\r\n        font-style: normal;\r\n        display: -webkit-inline-box;\r\n        display: -ms-inline-flexbox;\r\n        display: inline-flex;\r\n        color: rgba(0, 0, 0, 0.87);\r\n    }\r\n\r\n    .ui.input>input {\r\n        margin: 0em;\r\n        max-width: 100%;\r\n        -webkit-box-flex: 1;\r\n        -ms-flex: 1 0 auto;\r\n        flex: 1 0 auto;\r\n        outline: none;\r\n        -webkit-tap-highlight-color: rgba(255, 255, 255, 0);\r\n        text-align: left;\r\n        line-height: 1.21428571em;\r\n        font-family: \"Lato\", \"Helvetica Neue\", Arial, Helvetica, sans-serif;\r\n        padding: 0.67857143em 1em;\r\n        background: #ffffff;\r\n        border: 1px solid rgba(34, 36, 38, 0.15);\r\n        color: rgba(0, 0, 0, 0.87);\r\n        border-radius: 0.28571429rem;\r\n        -webkit-transition: border-color 0.1s ease, -webkit-box-shadow 0.1s ease;\r\n        transition: border-color 0.1s ease, -webkit-box-shadow 0.1s ease;\r\n        transition: box-shadow 0.1s ease, border-color 0.1s ease;\r\n        transition: box-shadow 0.1s ease, border-color 0.1s ease, -webkit-box-shadow 0.1s ease;\r\n        -webkit-box-shadow: none;\r\n        box-shadow: none;\r\n    }\r\n\r\n    /*--------------------\r\n      Placeholder\r\n---------------------*/\r\n    /* browsers require these rules separate */\r\n    .ui.input>input::-webkit-input-placeholder {\r\n        color: rgba(191, 191, 191, 0.87);\r\n    }\r\n\r\n    .ui.input>input::-moz-placeholder {\r\n        color: rgba(191, 191, 191, 0.87);\r\n    }\r\n\r\n    .ui.input>input:-ms-input-placeholder {\r\n        color: rgba(191, 191, 191, 0.87);\r\n    }\r\n\r\n    /*******************************\r\n            States\r\n*******************************/\r\n    /*--------------------\r\n        Disabled\r\n---------------------*/\r\n    .ui.disabled.input,\r\n    .ui.input:not(.disabled) input[disabled] {\r\n        opacity: 0.45;\r\n    }\r\n\r\n    .ui.disabled.input>input,\r\n    .ui.input:not(.disabled) input[disabled] {\r\n        pointer-events: none;\r\n    }\r\n\r\n    /*--------------------\r\n        Active\r\n---------------------*/\r\n    .ui.input>input:active,\r\n    .ui.input.down input {\r\n        border-color: rgba(0, 0, 0, 0.3);\r\n        background: #fafafa;\r\n        color: rgba(0, 0, 0, 0.87);\r\n        -webkit-box-shadow: none;\r\n        box-shadow: none;\r\n    }\r\n\r\n    /*--------------------\r\n       Loading\r\n---------------------*/\r\n    .ui.loading.loading.input>i.icon:before {\r\n        position: absolute;\r\n        content: \"\";\r\n        top: 50%;\r\n        left: 50%;\r\n        margin: -0.64285714em 0em 0em -0.64285714em;\r\n        width: 1.28571429em;\r\n        height: 1.28571429em;\r\n        border-radius: 500rem;\r\n        border: 0.2em solid rgba(0, 0, 0, 0.1);\r\n    }\r\n\r\n    .ui.loading.loading.input>i.icon:after {\r\n        position: absolute;\r\n        content: \"\";\r\n        top: 50%;\r\n        left: 50%;\r\n        margin: -0.64285714em 0em 0em -0.64285714em;\r\n        width: 1.28571429em;\r\n        height: 1.28571429em;\r\n        -webkit-animation: button-spin 0.6s linear;\r\n        animation: button-spin 0.6s linear;\r\n        -webkit-animation-iteration-count: infinite;\r\n        animation-iteration-count: infinite;\r\n        border-radius: 500rem;\r\n        border-color: #767676 transparent transparent;\r\n        border-style: solid;\r\n        border-width: 0.2em;\r\n        -webkit-box-shadow: 0px 0px 0px 1px transparent;\r\n        box-shadow: 0px 0px 0px 1px transparent;\r\n    }\r\n\r\n    /*--------------------\r\n        Focus\r\n---------------------*/\r\n    .ui.input.focus>input,\r\n    .ui.input>input:focus {\r\n        border-color: #85b7d9;\r\n        background: #ffffff;\r\n        color: rgba(0, 0, 0, 0.8);\r\n        -webkit-box-shadow: none;\r\n        box-shadow: none;\r\n    }\r\n\r\n    .ui.input.focus>input::-webkit-input-placeholder,\r\n    .ui.input>input:focus::-webkit-input-placeholder {\r\n        color: rgba(115, 115, 115, 0.87);\r\n    }\r\n\r\n    .ui.input.focus>input::-moz-placeholder,\r\n    .ui.input>input:focus::-moz-placeholder {\r\n        color: rgba(115, 115, 115, 0.87);\r\n    }\r\n\r\n    .ui.input.focus>input:-ms-input-placeholder,\r\n    .ui.input>input:focus:-ms-input-placeholder {\r\n        color: rgba(115, 115, 115, 0.87);\r\n    }\r\n\r\n    /*--------------------\r\n        Error\r\n---------------------*/\r\n    .ui.input.error>input {\r\n        background-color: #fff6f6;\r\n        border-color: #e0b4b4;\r\n        color: #9f3a38;\r\n        -webkit-box-shadow: none;\r\n        box-shadow: none;\r\n    }\r\n\r\n    /* Error Placeholder */\r\n    .ui.input.error>input::-webkit-input-placeholder {\r\n        color: #e7bdbc;\r\n    }\r\n\r\n    .ui.input.error>input::-moz-placeholder {\r\n        color: #e7bdbc;\r\n    }\r\n\r\n    .ui.input.error>input:-ms-input-placeholder {\r\n        color: #e7bdbc !important;\r\n    }\r\n\r\n    /* Focused Error Placeholder */\r\n    .ui.input.error>input:focus::-webkit-input-placeholder {\r\n        color: #da9796;\r\n    }\r\n\r\n    .ui.input.error>input:focus::-moz-placeholder {\r\n        color: #da9796;\r\n    }\r\n\r\n    .ui.input.error>input:focus:-ms-input-placeholder {\r\n        color: #da9796 !important;\r\n    }\r\n\r\n    /*******************************\r\n           Variations\r\n*******************************/\r\n    /*--------------------\r\n      Transparent\r\n---------------------*/\r\n    .ui.transparent.input>input {\r\n        border-color: transparent !important;\r\n        background-color: transparent !important;\r\n        padding: 0em !important;\r\n        -webkit-box-shadow: none !important;\r\n        box-shadow: none !important;\r\n        border-radius: 0px !important;\r\n    }\r\n\r\n    /* Transparent Icon */\r\n    .ui.transparent.icon.input>i.icon {\r\n        width: 1.1em;\r\n    }\r\n\r\n    .ui.transparent.icon.input>input {\r\n        padding-left: 0em !important;\r\n        padding-right: 2em !important;\r\n    }\r\n\r\n    .ui.transparent[class*=\"left icon\"].input>input {\r\n        padding-left: 2em !important;\r\n        padding-right: 0em !important;\r\n    }\r\n\r\n    /* Transparent Inverted */\r\n    .ui.transparent.inverted.input {\r\n        color: #ffffff;\r\n    }\r\n\r\n    .ui.transparent.inverted.input>input {\r\n        color: inherit;\r\n    }\r\n\r\n    .ui.transparent.inverted.input>input::-webkit-input-placeholder {\r\n        color: rgba(255, 255, 255, 0.5);\r\n    }\r\n\r\n    .ui.transparent.inverted.input>input::-moz-placeholder {\r\n        color: rgba(255, 255, 255, 0.5);\r\n    }\r\n\r\n    .ui.transparent.inverted.input>input:-ms-input-placeholder {\r\n        color: rgba(255, 255, 255, 0.5);\r\n    }\r\n\r\n    /*--------------------\r\n         Icon\r\n---------------------*/\r\n    .ui.icon.input>i.icon {\r\n        cursor: default;\r\n        position: absolute;\r\n        line-height: 1;\r\n        text-align: center;\r\n        top: 0px;\r\n        right: 0px;\r\n        margin: 0em;\r\n        height: 100%;\r\n        width: 2.67142857em;\r\n        opacity: 0.5;\r\n        border-radius: 0em 0.28571429rem 0.28571429rem 0em;\r\n        -webkit-transition: opacity 0.3s ease;\r\n        transition: opacity 0.3s ease;\r\n    }\r\n\r\n    .ui.icon.input>i.icon:not(.link) {\r\n        pointer-events: none;\r\n    }\r\n\r\n    .ui.icon.input>input {\r\n        padding-right: 2.67142857em !important;\r\n    }\r\n\r\n    .ui.icon.input>i.icon:before,\r\n    .ui.icon.input>i.icon:after {\r\n        left: 0;\r\n        position: absolute;\r\n        text-align: center;\r\n        top: 50%;\r\n        width: 100%;\r\n        margin-top: -0.5em;\r\n    }\r\n\r\n    .ui.icon.input>i.link.icon {\r\n        cursor: pointer;\r\n    }\r\n\r\n    .ui.icon.input>i.circular.icon {\r\n        top: 0.35em;\r\n        right: 0.5em;\r\n    }\r\n\r\n    /* Left Icon Input */\r\n    .ui[class*=\"left icon\"].input>i.icon {\r\n        right: auto;\r\n        left: 1px;\r\n        border-radius: 0.28571429rem 0em 0em 0.28571429rem;\r\n    }\r\n\r\n    .ui[class*=\"left icon\"].input>i.circular.icon {\r\n        right: auto;\r\n        left: 0.5em;\r\n    }\r\n\r\n    .ui[class*=\"left icon\"].input>input {\r\n        padding-left: 2.67142857em !important;\r\n        padding-right: 1em !important;\r\n    }\r\n\r\n    /* Focus */\r\n    .ui.icon.input>input:focus~i.icon {\r\n        opacity: 1;\r\n    }\r\n\r\n    /*--------------------\r\n        Labeled\r\n---------------------*/\r\n    /* Adjacent Label */\r\n    .ui.labeled.input>.label {\r\n        -webkit-box-flex: 0;\r\n        -ms-flex: 0 0 auto;\r\n        flex: 0 0 auto;\r\n        margin: 0;\r\n        font-size: 1em;\r\n    }\r\n\r\n    .ui.labeled.input>.label:not(.corner) {\r\n        padding-top: 0.78571429em;\r\n        padding-bottom: 0.78571429em;\r\n    }\r\n\r\n    /* Regular Label on Left */\r\n    .ui.labeled.input:not([class*=\"corner labeled\"]) .label:first-child {\r\n        border-top-right-radius: 0px;\r\n        border-bottom-right-radius: 0px;\r\n    }\r\n\r\n    .ui.labeled.input:not([class*=\"corner labeled\"]) .label:first-child+input {\r\n        border-top-left-radius: 0px;\r\n        border-bottom-left-radius: 0px;\r\n        border-left-color: transparent;\r\n    }\r\n\r\n    .ui.labeled.input:not([class*=\"corner labeled\"]) .label:first-child+input:focus {\r\n        border-left-color: #85b7d9;\r\n    }\r\n\r\n    /* Regular Label on Right */\r\n    .ui[class*=\"right labeled\"].input>input {\r\n        border-top-right-radius: 0px !important;\r\n        border-bottom-right-radius: 0px !important;\r\n        border-right-color: transparent !important;\r\n    }\r\n\r\n    .ui[class*=\"right labeled\"].input>input+.label {\r\n        border-top-left-radius: 0px;\r\n        border-bottom-left-radius: 0px;\r\n    }\r\n\r\n    .ui[class*=\"right labeled\"].input>input:focus {\r\n        border-right-color: #85b7d9 !important;\r\n    }\r\n\r\n    /* Corner Label */\r\n    .ui.labeled.input .corner.label {\r\n        top: 1px;\r\n        right: 1px;\r\n        font-size: 0.64285714em;\r\n        border-radius: 0em 0.28571429rem 0em 0em;\r\n    }\r\n\r\n    /* Spacing with corner label */\r\n    .ui[class*=\"corner labeled\"]:not([class*=\"left corner labeled\"]).labeled.input>input {\r\n        padding-right: 2.5em !important;\r\n    }\r\n\r\n    .ui[class*=\"corner labeled\"].icon.input:not([class*=\"left corner labeled\"])>input {\r\n        padding-right: 3.25em !important;\r\n    }\r\n\r\n    .ui[class*=\"corner labeled\"].icon.input:not([class*=\"left corner labeled\"])>.icon {\r\n        margin-right: 1.25em;\r\n    }\r\n\r\n    /* Left Labeled */\r\n    .ui[class*=\"left corner labeled\"].labeled.input>input {\r\n        padding-left: 2.5em !important;\r\n    }\r\n\r\n    .ui[class*=\"left corner labeled\"].icon.input>input {\r\n        padding-left: 3.25em !important;\r\n    }\r\n\r\n    .ui[class*=\"left corner labeled\"].icon.input>.icon {\r\n        margin-left: 1.25em;\r\n    }\r\n\r\n    /* Corner Label Position  */\r\n    .ui.input>.ui.corner.label {\r\n        top: 1px;\r\n        right: 1px;\r\n    }\r\n\r\n    .ui.input>.ui.left.corner.label {\r\n        right: auto;\r\n        left: 1px;\r\n    }\r\n\r\n    /*--------------------\r\n        Action\r\n---------------------*/\r\n    .ui.action.input>.button,\r\n    .ui.action.input>.buttons {\r\n        display: -webkit-box;\r\n        display: -ms-flexbox;\r\n        display: flex;\r\n        -webkit-box-align: center;\r\n        -ms-flex-align: center;\r\n        align-items: center;\r\n        -webkit-box-flex: 0;\r\n        -ms-flex: 0 0 auto;\r\n        flex: 0 0 auto;\r\n    }\r\n\r\n    .ui.action.input>.button,\r\n    .ui.action.input>.buttons>.button {\r\n        padding-top: 0.78571429em;\r\n        padding-bottom: 0.78571429em;\r\n        margin: 0;\r\n    }\r\n\r\n    /* Button on Right */\r\n    .ui.action.input:not([class*=\"left action\"])>input {\r\n        border-top-right-radius: 0px !important;\r\n        border-bottom-right-radius: 0px !important;\r\n        border-right-color: transparent !important;\r\n    }\r\n\r\n    .ui.action.input:not([class*=\"left action\"])>.dropdown:not(:first-child),\r\n    .ui.action.input:not([class*=\"left action\"])>.button:not(:first-child),\r\n    .ui.action.input:not([class*=\"left action\"])>.buttons:not(:first-child)>.button {\r\n        border-radius: 0px;\r\n    }\r\n\r\n    .ui.action.input:not([class*=\"left action\"])>.dropdown:last-child,\r\n    .ui.action.input:not([class*=\"left action\"])>.button:last-child,\r\n    .ui.action.input:not([class*=\"left action\"])>.buttons:last-child>.button {\r\n        border-radius: 0px 0.28571429rem 0.28571429rem 0px;\r\n    }\r\n\r\n    /* Input Focus */\r\n    .ui.action.input:not([class*=\"left action\"])>input:focus {\r\n        border-right-color: #85b7d9 !important;\r\n    }\r\n\r\n    /* Button on Left */\r\n    .ui[class*=\"left action\"].input>input {\r\n        border-top-left-radius: 0px !important;\r\n        border-bottom-left-radius: 0px !important;\r\n        border-left-color: transparent !important;\r\n    }\r\n\r\n    .ui[class*=\"left action\"].input>.dropdown,\r\n    .ui[class*=\"left action\"].input>.button,\r\n    .ui[class*=\"left action\"].input>.buttons>.button {\r\n        border-radius: 0px;\r\n    }\r\n\r\n    .ui[class*=\"left action\"].input>.dropdown:first-child,\r\n    .ui[class*=\"left action\"].input>.button:first-child,\r\n    .ui[class*=\"left action\"].input>.buttons:first-child>.button {\r\n        border-radius: 0.28571429rem 0px 0px 0.28571429rem;\r\n    }\r\n\r\n    /* Input Focus */\r\n    .ui[class*=\"left action\"].input>input:focus {\r\n        border-left-color: #85b7d9 !important;\r\n    }\r\n\r\n    /*--------------------\r\n       Inverted\r\n---------------------*/\r\n    /* Standard */\r\n    .ui.inverted.input>input {\r\n        border: none;\r\n    }\r\n\r\n    /*--------------------\r\n        Fluid\r\n---------------------*/\r\n    .ui.fluid.input {\r\n        display: -webkit-box;\r\n        display: -ms-flexbox;\r\n        display: flex;\r\n    }\r\n\r\n    .ui.fluid.input>input {\r\n        width: 0px !important;\r\n    }\r\n\r\n    /*--------------------\r\n        Size\r\n---------------------*/\r\n    .ui.mini.input {\r\n        font-size: 0.78571429em;\r\n    }\r\n\r\n    .ui.small.input {\r\n        font-size: 0.92857143em;\r\n    }\r\n\r\n    .ui.input {\r\n        font-size: 1em;\r\n    }\r\n\r\n    .ui.large.input {\r\n        font-size: 1.14285714em;\r\n    }\r\n\r\n    .ui.big.input {\r\n        font-size: 1.28571429em;\r\n    }\r\n\r\n    .ui.huge.input {\r\n        font-size: 1.42857143em;\r\n    }\r\n\r\n    .ui.massive.input {\r\n        font-size: 1.71428571em;\r\n    }\r\n}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/runtime/api.js":
/*!*****************************************************!*\
  !*** ./node_modules/css-loader/dist/runtime/api.js ***!
  \*****************************************************/
/***/ ((module) => {

"use strict";


/*
  MIT License http://www.opensource.org/licenses/mit-license.php
  Author Tobias Koppers @sokra
*/
module.exports = function (cssWithMappingToString) {
  var list = []; // return the list of modules as css string

  list.toString = function toString() {
    return this.map(function (item) {
      var content = "";
      var needLayer = typeof item[5] !== "undefined";

      if (item[4]) {
        content += "@supports (".concat(item[4], ") {");
      }

      if (item[2]) {
        content += "@media ".concat(item[2], " {");
      }

      if (needLayer) {
        content += "@layer".concat(item[5].length > 0 ? " ".concat(item[5]) : "", " {");
      }

      content += cssWithMappingToString(item);

      if (needLayer) {
        content += "}";
      }

      if (item[2]) {
        content += "}";
      }

      if (item[4]) {
        content += "}";
      }

      return content;
    }).join("");
  }; // import a list of modules into the list


  list.i = function i(modules, media, dedupe, supports, layer) {
    if (typeof modules === "string") {
      modules = [[null, modules, undefined]];
    }

    var alreadyImportedModules = {};

    if (dedupe) {
      for (var k = 0; k < this.length; k++) {
        var id = this[k][0];

        if (id != null) {
          alreadyImportedModules[id] = true;
        }
      }
    }

    for (var _k = 0; _k < modules.length; _k++) {
      var item = [].concat(modules[_k]);

      if (dedupe && alreadyImportedModules[item[0]]) {
        continue;
      }

      if (typeof layer !== "undefined") {
        if (typeof item[5] === "undefined") {
          item[5] = layer;
        } else {
          item[1] = "@layer".concat(item[5].length > 0 ? " ".concat(item[5]) : "", " {").concat(item[1], "}");
          item[5] = layer;
        }
      }

      if (media) {
        if (!item[2]) {
          item[2] = media;
        } else {
          item[1] = "@media ".concat(item[2], " {").concat(item[1], "}");
          item[2] = media;
        }
      }

      if (supports) {
        if (!item[4]) {
          item[4] = "".concat(supports);
        } else {
          item[1] = "@supports (".concat(item[4], ") {").concat(item[1], "}");
          item[4] = supports;
        }
      }

      list.push(item);
    }
  };

  return list;
};

/***/ }),

/***/ "./node_modules/css-loader/dist/runtime/sourceMaps.js":
/*!************************************************************!*\
  !*** ./node_modules/css-loader/dist/runtime/sourceMaps.js ***!
  \************************************************************/
/***/ ((module) => {

"use strict";


module.exports = function (item) {
  var content = item[1];
  var cssMapping = item[3];

  if (!cssMapping) {
    return content;
  }

  if (typeof btoa === "function") {
    var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(cssMapping))));
    var data = "sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(base64);
    var sourceMapping = "/*# ".concat(data, " */");
    var sourceURLs = cssMapping.sources.map(function (source) {
      return "/*# sourceURL=".concat(cssMapping.sourceRoot || "").concat(source, " */");
    });
    return [content].concat(sourceURLs).concat([sourceMapping]).join("\n");
  }

  return [content].join("\n");
};

/***/ }),

/***/ "./assets/src/Styles/Frontend/ai-summary.scss":
/*!****************************************************!*\
  !*** ./assets/src/Styles/Frontend/ai-summary.scss ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_1_use_3_ai_summary_scss__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!../../../../node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[1].use[3]!./ai-summary.scss */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[1].use[3]!./assets/src/Styles/Frontend/ai-summary.scss");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());

      options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
    
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_1_use_3_ai_summary_scss__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_1_use_3_ai_summary_scss__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_1_use_3_ai_summary_scss__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_1_use_3_ai_summary_scss__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./assets/src/Styles/Frontend/frontend.scss":
/*!**************************************************!*\
  !*** ./assets/src/Styles/Frontend/frontend.scss ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_1_use_3_frontend_scss__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!../../../../node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[1].use[3]!./frontend.scss */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[1].use[3]!./assets/src/Styles/Frontend/frontend.scss");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());

      options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
    
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_1_use_3_frontend_scss__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_1_use_3_frontend_scss__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_1_use_3_frontend_scss__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_1_use_3_frontend_scss__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js":
/*!****************************************************************************!*\
  !*** ./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js ***!
  \****************************************************************************/
/***/ ((module) => {

"use strict";


var stylesInDOM = [];

function getIndexByIdentifier(identifier) {
  var result = -1;

  for (var i = 0; i < stylesInDOM.length; i++) {
    if (stylesInDOM[i].identifier === identifier) {
      result = i;
      break;
    }
  }

  return result;
}

function modulesToDom(list, options) {
  var idCountMap = {};
  var identifiers = [];

  for (var i = 0; i < list.length; i++) {
    var item = list[i];
    var id = options.base ? item[0] + options.base : item[0];
    var count = idCountMap[id] || 0;
    var identifier = "".concat(id, " ").concat(count);
    idCountMap[id] = count + 1;
    var indexByIdentifier = getIndexByIdentifier(identifier);
    var obj = {
      css: item[1],
      media: item[2],
      sourceMap: item[3],
      supports: item[4],
      layer: item[5]
    };

    if (indexByIdentifier !== -1) {
      stylesInDOM[indexByIdentifier].references++;
      stylesInDOM[indexByIdentifier].updater(obj);
    } else {
      var updater = addElementStyle(obj, options);
      options.byIndex = i;
      stylesInDOM.splice(i, 0, {
        identifier: identifier,
        updater: updater,
        references: 1
      });
    }

    identifiers.push(identifier);
  }

  return identifiers;
}

function addElementStyle(obj, options) {
  var api = options.domAPI(options);
  api.update(obj);

  var updater = function updater(newObj) {
    if (newObj) {
      if (newObj.css === obj.css && newObj.media === obj.media && newObj.sourceMap === obj.sourceMap && newObj.supports === obj.supports && newObj.layer === obj.layer) {
        return;
      }

      api.update(obj = newObj);
    } else {
      api.remove();
    }
  };

  return updater;
}

module.exports = function (list, options) {
  options = options || {};
  list = list || [];
  var lastIdentifiers = modulesToDom(list, options);
  return function update(newList) {
    newList = newList || [];

    for (var i = 0; i < lastIdentifiers.length; i++) {
      var identifier = lastIdentifiers[i];
      var index = getIndexByIdentifier(identifier);
      stylesInDOM[index].references--;
    }

    var newLastIdentifiers = modulesToDom(newList, options);

    for (var _i = 0; _i < lastIdentifiers.length; _i++) {
      var _identifier = lastIdentifiers[_i];

      var _index = getIndexByIdentifier(_identifier);

      if (stylesInDOM[_index].references === 0) {
        stylesInDOM[_index].updater();

        stylesInDOM.splice(_index, 1);
      }
    }

    lastIdentifiers = newLastIdentifiers;
  };
};

/***/ }),

/***/ "./node_modules/style-loader/dist/runtime/insertBySelector.js":
/*!********************************************************************!*\
  !*** ./node_modules/style-loader/dist/runtime/insertBySelector.js ***!
  \********************************************************************/
/***/ ((module) => {

"use strict";


var memo = {};
/* istanbul ignore next  */

function getTarget(target) {
  if (typeof memo[target] === "undefined") {
    var styleTarget = document.querySelector(target); // Special case to return head of iframe instead of iframe itself

    if (window.HTMLIFrameElement && styleTarget instanceof window.HTMLIFrameElement) {
      try {
        // This will throw an exception if access to iframe is blocked
        // due to cross-origin restrictions
        styleTarget = styleTarget.contentDocument.head;
      } catch (e) {
        // istanbul ignore next
        styleTarget = null;
      }
    }

    memo[target] = styleTarget;
  }

  return memo[target];
}
/* istanbul ignore next  */


function insertBySelector(insert, style) {
  var target = getTarget(insert);

  if (!target) {
    throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");
  }

  target.appendChild(style);
}

module.exports = insertBySelector;

/***/ }),

/***/ "./node_modules/style-loader/dist/runtime/insertStyleElement.js":
/*!**********************************************************************!*\
  !*** ./node_modules/style-loader/dist/runtime/insertStyleElement.js ***!
  \**********************************************************************/
/***/ ((module) => {

"use strict";


/* istanbul ignore next  */
function insertStyleElement(options) {
  var element = document.createElement("style");
  options.setAttributes(element, options.attributes);
  options.insert(element, options.options);
  return element;
}

module.exports = insertStyleElement;

/***/ }),

/***/ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js ***!
  \**********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


/* istanbul ignore next  */
function setAttributesWithoutAttributes(styleElement) {
  var nonce =  true ? __webpack_require__.nc : 0;

  if (nonce) {
    styleElement.setAttribute("nonce", nonce);
  }
}

module.exports = setAttributesWithoutAttributes;

/***/ }),

/***/ "./node_modules/style-loader/dist/runtime/styleDomAPI.js":
/*!***************************************************************!*\
  !*** ./node_modules/style-loader/dist/runtime/styleDomAPI.js ***!
  \***************************************************************/
/***/ ((module) => {

"use strict";


/* istanbul ignore next  */
function apply(styleElement, options, obj) {
  var css = "";

  if (obj.supports) {
    css += "@supports (".concat(obj.supports, ") {");
  }

  if (obj.media) {
    css += "@media ".concat(obj.media, " {");
  }

  var needLayer = typeof obj.layer !== "undefined";

  if (needLayer) {
    css += "@layer".concat(obj.layer.length > 0 ? " ".concat(obj.layer) : "", " {");
  }

  css += obj.css;

  if (needLayer) {
    css += "}";
  }

  if (obj.media) {
    css += "}";
  }

  if (obj.supports) {
    css += "}";
  }

  var sourceMap = obj.sourceMap;

  if (sourceMap && typeof btoa !== "undefined") {
    css += "\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))), " */");
  } // For old IE

  /* istanbul ignore if  */


  options.styleTagTransform(css, styleElement, options.options);
}

function removeStyleElement(styleElement) {
  // istanbul ignore if
  if (styleElement.parentNode === null) {
    return false;
  }

  styleElement.parentNode.removeChild(styleElement);
}
/* istanbul ignore next  */


function domAPI(options) {
  var styleElement = options.insertStyleElement(options);
  return {
    update: function update(obj) {
      apply(styleElement, options, obj);
    },
    remove: function remove() {
      removeStyleElement(styleElement);
    }
  };
}

module.exports = domAPI;

/***/ }),

/***/ "./node_modules/style-loader/dist/runtime/styleTagTransform.js":
/*!*********************************************************************!*\
  !*** ./node_modules/style-loader/dist/runtime/styleTagTransform.js ***!
  \*********************************************************************/
/***/ ((module) => {

"use strict";


/* istanbul ignore next  */
function styleTagTransform(css, styleElement) {
  if (styleElement.styleSheet) {
    styleElement.styleSheet.cssText = css;
  } else {
    while (styleElement.firstChild) {
      styleElement.removeChild(styleElement.firstChild);
    }

    styleElement.appendChild(document.createTextNode(css));
  }
}

module.exports = styleTagTransform;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			id: moduleId,
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be in strict mode.
(() => {
"use strict";
/*!****************************************!*\
  !*** ./assets/src/scripts/frontend.js ***!
  \****************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Styles_Frontend_frontend_scss__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Styles/Frontend/frontend.scss */ "./assets/src/Styles/Frontend/frontend.scss");
/* harmony import */ var _Styles_Frontend_ai_summary_scss__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Styles/Frontend/ai-summary.scss */ "./assets/src/Styles/Frontend/ai-summary.scss");
/* harmony import */ var _Chunk_Frontend_data_tables_async__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Chunk/Frontend/data_tables_async */ "./assets/src/scripts/Chunk/Frontend/data_tables_async.js");
/* harmony import */ var _Chunk_Frontend_data_table_default__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Chunk/Frontend/data_table_default */ "./assets/src/scripts/Chunk/Frontend/data_table_default.js");
/* harmony import */ var _Chunk_Frontend_create_tab__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Chunk/Frontend/create_tab */ "./assets/src/scripts/Chunk/Frontend/create_tab.js");
/* harmony import */ var _Chunk_Frontend_create_tab__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_Chunk_Frontend_create_tab__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _chunk_frontend_ai_summary__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./chunk/frontend/ai_summary */ "./assets/src/scripts/chunk/frontend/ai_summary.js");
/* harmony import */ var _chunk_frontend_ai_summary__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_chunk_frontend_ai_summary__WEBPACK_IMPORTED_MODULE_5__);






})();

/******/ })()
;
//# sourceMappingURL=frontend.min.js.map