<?php

class SPDSGVOConstants
{
    const CATEGORY_SLUG_STATISTICS = 'statistics';
    const CATEGORY_SLUG_TARGETING = 'targeting';
    const CATEGORY_SLUG_EMBEDDINGS = 'embeddings';
    const CATEGORY_SLUG_LIVECHAT = 'live-chat';
    const CATEGORY_SLUG_CHATBOTS = 'chat-bots';
    const CATEGORY_SLUG_PLUGINS = 'plugins';
    const CATEGORY_SLUG_MANDATORY = 'necessary';
    const CATEGORY_SLUG_TAGMANAGER = 'tagmanager';



    const LEGAL_WEB_BASE_URL = "https://www.legalweb.io";
    const LEGAL_WEB_TEXT_SERVICE_URL = 'https://www.legalweb.io/textservice/textService.php';
    const LEGAL_WEB_TEXT_SERVICE_VERSION = '1';

    const CCOKIE_NAME = 'sp_dsgvo_cookie_settings';
    const CCOKIE_NAME_INTEGRATION = 'sp_dsgvo_integration_settings';

    const OPTIONS_PREFIX = "sp_dsgvo_";

    public static function getSecurityServices()
    {
        return array('local-security-question' => 'Eine lokale Sicherheitsabfrage',
            'google-recaptcha' => 'Google reCAPTCHA',
            'other' => 'Sonstige');
    }

    public static function getCDNServers()
    {
        return array('akamai-cdn' => 'Akamai CDN',
            'aws-cloudfront-cdn' => 'AWS Cloudfront CDN',
            'azure-cdn' => 'Azure CDN',
            'bunny-cdn' => 'Bunny CDN',
            'cachefly' => 'CacheFly',
            'cdn-net' => 'CDN.NET',
            'cdn-77' => 'CDN 77',
            'cloudflare' => 'Cloudflare CDN',
            'fastly-cdn' => 'Fastly CDN',
            'google-cloud' => 'Google Cloud CDN',
            'g-core-labs-cdn' => 'G-Core Labs CDN',
            'key-cdn' => 'Key CDN',
            'medianova' => 'Medianova',
            'ovh-cdn' => 'OVH CDN',
            'stackpath' => 'StackPath',
            'other' => __('Other Server','shapepress-dsvgo')
        );
    }

    public static function getHostingProvider()
    {
        return array (
            'eins-und-eins-ionos-se' => '1&1 IONOS SE',
            'einsblue' => '1blu',
            'amazon-aws' => 'Amazon AWS',
            'alfahosting' => 'Alfahosting',
            'all-inkl' => 'All-inkl.com',
            'awardspace' => 'Awardspace',
            'bluehost' => 'Bluehost',
            'contabo' => 'Contabo',
            'dogado' => 'Dogado',
            'domainfactory' => 'domainfactory GmbH',
            'dzwi' => 'DWZI GmbH',
            'easyname' => 'easyname',
            'godaddy' => 'GoDaddy',
            'hetzner' => 'Hetzner Online GmbH',
            'host-europe' => 'Host Europe GmbH',
            'host-profis' => 'HostProfis ISP Telekom GmbH',
            'kinsta' => 'Kinsta',
            'lima-city' => 'Lima City',
            'magenta' => 'Magenta-/ T-Mobile Austria GmbH',
            'mittwald' => 'Mittwald CM Service GmbH & Co. KG',
            'microsoft-azure' => 'Microsoft Azure',
            'netcup' => 'Netcup',
            'ovh' => 'OVH',
            'platform-sh' => 'platformSH',
            'rackspace' => 'Rackspace',
            'raidboxes' => 'Raidboxes',
            'schlundtech' => 'Schlundtech',
            'siteground' => 'SiteGround',
            'strato' => 'Strato',
            'telekom-austria' => 'Telekom Austria AG',
            'uniteddomains' => 'UnitedDomains',
            'vautron' => 'Vautron Rechenzentrum AG',
            'webgo' => 'webgo',
            'worldfouryou' => 'World4You Internet Services GmbH',
            //'wix' => 'wix.com',
            'zap-hosting' => 'ZAP-Hosting',
            'other' => __('Other Provider','shapepress-dsvgo')
        );
    }

    public static function getFontServices()
    {
        return array(//'google-fonts' => 'Google Fonts',
        'adobe-fonts' => 'Adobe Fonts',
        'fontawesome' => 'Font Awesome',
        'fonts-com' => 'Fonts.com');
    }

    public static function getPaymentProvider()
    {
        return array (
            'cash' => __('Cash','shapepress-dsgvo'),
            'cod' => __('Cash on delivery','shapepress-dsgvo'),
            'bank-transfer' => __('Bank Transfer','shapepress-dsgvo'),
            'ein-und-eins' => '1 & 1 ipayment',
            'amazon-pay' => 'Amazon Pay',
            'apple-pay' => 'Apple Pay',
            'arvato' => 'Arvato Infoscore',
            'bs-card-service' => 'B+S Card Services',
            'commdoo' => 'Commdoo',
            'concardis' => 'Concardis',
            'deutsche-card-services' => 'Deutsche Card Services',
            'docdata-payments' => 'Docdata Payments',
            'easycash' => 'Easycash',
            'easypay' => 'Easypay',
            'ecardon' => 'Ecardon',
            'eos' => 'EOS',
            'google-pay' => 'Google Pay',
            'heidelpay' => 'Heidelpay',
            'hobex' => 'Hobex',
            'klarna' => 'Klarna',
            'girosolution' => 'Girosolution',
            'micropayment' => 'Micropayment',
            'mpay' => 'mPay24',
            'novalnet' => 'Novalnet',
            'paymorrow' => 'Paymorrow',
            'payone' => 'PAYONE',
            'paypal' => 'PayPal',
            'secupay' => 'Secupay',
            'stripe' => 'Stripe',
            'telecash' => 'Telecash',
            'vr-pay-virtuell' => 'VR-Pay Virtuell',
            'wirecard' => 'Wirecard',
        );
    }

    public static function getNewsletterIntegrations()
    {
        return array(
            'own' => __('By own web/email server','shapepress-dsvgo'),
            'aweber' => 'AWeber',
            'active-campaign' => 'ActiveCampaign',
            'clever-research' => 'CleverReach',
            'klick-tipp' => 'Klick-tipp',
            'mail-chimp' => 'MailChimp',
            'mail-jet' => 'Mailjet',
            'mailpoet' => 'MailPoet',
            'newsletter-2-go' => 'newslettertwogo',
            'rapid-mail' => 'Rapidmail',
            'other' => __('Other','shapepress-dsvgo')
        );
    }


    public static function getCountries()
    {
        return array(
            'AF' => __('Afghanistan', 'shapepress-dsgvo'),
            'AX' => __('&#197;land Islands', 'shapepress-dsgvo'),
            'AL' => __('Albania', 'shapepress-dsgvo'),
            'DZ' => __('Algeria', 'shapepress-dsgvo'),
            'AS' => __('American Samoa', 'shapepress-dsgvo'),
            'AD' => __('Andorra', 'shapepress-dsgvo'),
            'AO' => __('Angola', 'shapepress-dsgvo'),
            'AI' => __('Anguilla', 'shapepress-dsgvo'),
            'AQ' => __('Antarctica', 'shapepress-dsgvo'),
            'AG' => __('Antigua and Barbuda', 'shapepress-dsgvo'),
            'AR' => __('Argentina', 'shapepress-dsgvo'),
            'AM' => __('Armenia', 'shapepress-dsgvo'),
            'AW' => __('Aruba', 'shapepress-dsgvo'),
            'AU' => __('Australia', 'shapepress-dsgvo'),
            'AT' => __('Austria', 'shapepress-dsgvo'),
            'AZ' => __('Azerbaijan', 'shapepress-dsgvo'),
            'BS' => __('Bahamas', 'shapepress-dsgvo'),
            'BH' => __('Bahrain', 'shapepress-dsgvo'),
            'BD' => __('Bangladesh', 'shapepress-dsgvo'),
            'BB' => __('Barbados', 'shapepress-dsgvo'),
            'BY' => __('Belarus', 'shapepress-dsgvo'),
            'BE' => __('Belgium', 'shapepress-dsgvo'),
            'PW' => __('Belau', 'shapepress-dsgvo'),
            'BZ' => __('Belize', 'shapepress-dsgvo'),
            'BJ' => __('Benin', 'shapepress-dsgvo'),
            'BM' => __('Bermuda', 'shapepress-dsgvo'),
            'BT' => __('Bhutan', 'shapepress-dsgvo'),
            'BO' => __('Bolivia', 'shapepress-dsgvo'),
            'BQ' => __('Bonaire, Saint Eustatius and Saba', 'shapepress-dsgvo'),
            'BA' => __('Bosnia and Herzegovina', 'shapepress-dsgvo'),
            'BW' => __('Botswana', 'shapepress-dsgvo'),
            'BV' => __('Bouvet Island', 'shapepress-dsgvo'),
            'BR' => __('Brazil', 'shapepress-dsgvo'),
            'IO' => __('British Indian Ocean Territory', 'shapepress-dsgvo'),
            'BN' => __('Brunei', 'shapepress-dsgvo'),
            'BG' => __('Bulgaria', 'shapepress-dsgvo'),
            'BF' => __('Burkina Faso', 'shapepress-dsgvo'),
            'BI' => __('Burundi', 'shapepress-dsgvo'),
            'KH' => __('Cambodia', 'shapepress-dsgvo'),
            'CM' => __('Cameroon', 'shapepress-dsgvo'),
            'CA' => __('Canada', 'shapepress-dsgvo'),
            'CV' => __('Cape Verde', 'shapepress-dsgvo'),
            'KY' => __('Cayman Islands', 'shapepress-dsgvo'),
            'CF' => __('Central African Republic', 'shapepress-dsgvo'),
            'TD' => __('Chad', 'shapepress-dsgvo'),
            'CL' => __('Chile', 'shapepress-dsgvo'),
            'CN' => __('China', 'shapepress-dsgvo'),
            'CX' => __('Christmas Island', 'shapepress-dsgvo'),
            'CC' => __('Cocos (Keeling) Islands', 'shapepress-dsgvo'),
            'CO' => __('Colombia', 'shapepress-dsgvo'),
            'KM' => __('Comoros', 'shapepress-dsgvo'),
            'CG' => __('Congo (Brazzaville)', 'shapepress-dsgvo'),
            'CD' => __('Congo (Kinshasa)', 'shapepress-dsgvo'),
            'CK' => __('Cook Islands', 'shapepress-dsgvo'),
            'CR' => __('Costa Rica', 'shapepress-dsgvo'),
            'HR' => __('Croatia', 'shapepress-dsgvo'),
            'CU' => __('Cuba', 'shapepress-dsgvo'),
            'CW' => __('Cura&ccedil;ao', 'shapepress-dsgvo'),
            'CY' => __('Cyprus', 'shapepress-dsgvo'),
            'CZ' => __('Czech Republic', 'shapepress-dsgvo'),
            'DK' => __('Denmark', 'shapepress-dsgvo'),
            'DJ' => __('Djibouti', 'shapepress-dsgvo'),
            'DM' => __('Dominica', 'shapepress-dsgvo'),
            'DO' => __('Dominican Republic', 'shapepress-dsgvo'),
            'EC' => __('Ecuador', 'shapepress-dsgvo'),
            'EG' => __('Egypt', 'shapepress-dsgvo'),
            'SV' => __('El Salvador', 'shapepress-dsgvo'),
            'GQ' => __('Equatorial Guinea', 'shapepress-dsgvo'),
            'ER' => __('Eritrea', 'shapepress-dsgvo'),
            'EE' => __('Estonia', 'shapepress-dsgvo'),
            'ET' => __('Ethiopia', 'shapepress-dsgvo'),
            'FK' => __('Falkland Islands', 'shapepress-dsgvo'),
            'FO' => __('Faroe Islands', 'shapepress-dsgvo'),
            'FJ' => __('Fiji', 'shapepress-dsgvo'),
            'FI' => __('Finland', 'shapepress-dsgvo'),
            'FR' => __('France', 'shapepress-dsgvo'),
            'GF' => __('French Guiana', 'shapepress-dsgvo'),
            'PF' => __('French Polynesia', 'shapepress-dsgvo'),
            'TF' => __('French Southern Territories', 'shapepress-dsgvo'),
            'GA' => __('Gabon', 'shapepress-dsgvo'),
            'GM' => __('Gambia', 'shapepress-dsgvo'),
            'GE' => __('Georgia', 'shapepress-dsgvo'),
            'DE' => __('Germany', 'shapepress-dsgvo'),
            'GH' => __('Ghana', 'shapepress-dsgvo'),
            'GI' => __('Gibraltar', 'shapepress-dsgvo'),
            'GR' => __('Greece', 'shapepress-dsgvo'),
            'GL' => __('Greenland', 'shapepress-dsgvo'),
            'GD' => __('Grenada', 'shapepress-dsgvo'),
            'GP' => __('Guadeloupe', 'shapepress-dsgvo'),
            'GU' => __('Guam', 'shapepress-dsgvo'),
            'GT' => __('Guatemala', 'shapepress-dsgvo'),
            'GG' => __('Guernsey', 'shapepress-dsgvo'),
            'GN' => __('Guinea', 'shapepress-dsgvo'),
            'GW' => __('Guinea-Bissau', 'shapepress-dsgvo'),
            'GY' => __('Guyana', 'shapepress-dsgvo'),
            'HT' => __('Haiti', 'shapepress-dsgvo'),
            'HM' => __('Heard Island and McDonald Islands', 'shapepress-dsgvo'),
            'HN' => __('Honduras', 'shapepress-dsgvo'),
            'HK' => __('Hong Kong', 'shapepress-dsgvo'),
            'HU' => __('Hungary', 'shapepress-dsgvo'),
            'IS' => __('Iceland', 'shapepress-dsgvo'),
            'IN' => __('India', 'shapepress-dsgvo'),
            'ID' => __('Indonesia', 'shapepress-dsgvo'),
            'IR' => __('Iran', 'shapepress-dsgvo'),
            'IQ' => __('Iraq', 'shapepress-dsgvo'),
            'IE' => __('Ireland', 'shapepress-dsgvo'),
            'IM' => __('Isle of Man', 'shapepress-dsgvo'),
            'IL' => __('Israel', 'shapepress-dsgvo'),
            'IT' => __('Italy', 'shapepress-dsgvo'),
            'CI' => __('Ivory Coast', 'shapepress-dsgvo'),
            'JM' => __('Jamaica', 'shapepress-dsgvo'),
            'JP' => __('Japan', 'shapepress-dsgvo'),
            'JE' => __('Jersey', 'shapepress-dsgvo'),
            'JO' => __('Jordan', 'shapepress-dsgvo'),
            'KZ' => __('Kazakhstan', 'shapepress-dsgvo'),
            'KE' => __('Kenya', 'shapepress-dsgvo'),
            'KI' => __('Kiribati', 'shapepress-dsgvo'),
            'KW' => __('Kuwait', 'shapepress-dsgvo'),
            'KG' => __('Kyrgyzstan', 'shapepress-dsgvo'),
            'LA' => __('Laos', 'shapepress-dsgvo'),
            'LV' => __('Latvia', 'shapepress-dsgvo'),
            'LB' => __('Lebanon', 'shapepress-dsgvo'),
            'LS' => __('Lesotho', 'shapepress-dsgvo'),
            'LR' => __('Liberia', 'shapepress-dsgvo'),
            'LY' => __('Libya', 'shapepress-dsgvo'),
            'LI' => __('Liechtenstein', 'shapepress-dsgvo'),
            'LT' => __('Lithuania', 'shapepress-dsgvo'),
            'LU' => __('Luxembourg', 'shapepress-dsgvo'),
            'MO' => __('Macao', 'shapepress-dsgvo'),
            'MK' => __('North Macedonia', 'shapepress-dsgvo'),
            'MG' => __('Madagascar', 'shapepress-dsgvo'),
            'MW' => __('Malawi', 'shapepress-dsgvo'),
            'MY' => __('Malaysia', 'shapepress-dsgvo'),
            'MV' => __('Maldives', 'shapepress-dsgvo'),
            'ML' => __('Mali', 'shapepress-dsgvo'),
            'MT' => __('Malta', 'shapepress-dsgvo'),
            'MH' => __('Marshall Islands', 'shapepress-dsgvo'),
            'MQ' => __('Martinique', 'shapepress-dsgvo'),
            'MR' => __('Mauritania', 'shapepress-dsgvo'),
            'MU' => __('Mauritius', 'shapepress-dsgvo'),
            'YT' => __('Mayotte', 'shapepress-dsgvo'),
            'MX' => __('Mexico', 'shapepress-dsgvo'),
            'FM' => __('Micronesia', 'shapepress-dsgvo'),
            'MD' => __('Moldova', 'shapepress-dsgvo'),
            'MC' => __('Monaco', 'shapepress-dsgvo'),
            'MN' => __('Mongolia', 'shapepress-dsgvo'),
            'ME' => __('Montenegro', 'shapepress-dsgvo'),
            'MS' => __('Montserrat', 'shapepress-dsgvo'),
            'MA' => __('Morocco', 'shapepress-dsgvo'),
            'MZ' => __('Mozambique', 'shapepress-dsgvo'),
            'MM' => __('Myanmar', 'shapepress-dsgvo'),
            'NA' => __('Namibia', 'shapepress-dsgvo'),
            'NR' => __('Nauru', 'shapepress-dsgvo'),
            'NP' => __('Nepal', 'shapepress-dsgvo'),
            'NL' => __('Netherlands', 'shapepress-dsgvo'),
            'NC' => __('New Caledonia', 'shapepress-dsgvo'),
            'NZ' => __('New Zealand', 'shapepress-dsgvo'),
            'NI' => __('Nicaragua', 'shapepress-dsgvo'),
            'NE' => __('Niger', 'shapepress-dsgvo'),
            'NG' => __('Nigeria', 'shapepress-dsgvo'),
            'NU' => __('Niue', 'shapepress-dsgvo'),
            'NF' => __('Norfolk Island', 'shapepress-dsgvo'),
            'MP' => __('Northern Mariana Islands', 'shapepress-dsgvo'),
            'KP' => __('North Korea', 'shapepress-dsgvo'),
            'NO' => __('Norway', 'shapepress-dsgvo'),
            'OM' => __('Oman', 'shapepress-dsgvo'),
            'PK' => __('Pakistan', 'shapepress-dsgvo'),
            'PS' => __('Palestinian Territory', 'shapepress-dsgvo'),
            'PA' => __('Panama', 'shapepress-dsgvo'),
            'PG' => __('Papua New Guinea', 'shapepress-dsgvo'),
            'PY' => __('Paraguay', 'shapepress-dsgvo'),
            'PE' => __('Peru', 'shapepress-dsgvo'),
            'PH' => __('Philippines', 'shapepress-dsgvo'),
            'PN' => __('Pitcairn', 'shapepress-dsgvo'),
            'PL' => __('Poland', 'shapepress-dsgvo'),
            'PT' => __('Portugal', 'shapepress-dsgvo'),
            'PR' => __('Puerto Rico', 'shapepress-dsgvo'),
            'QA' => __('Qatar', 'shapepress-dsgvo'),
            'RE' => __('Reunion', 'shapepress-dsgvo'),
            'RO' => __('Romania', 'shapepress-dsgvo'),
            'RU' => __('Russia', 'shapepress-dsgvo'),
            'RW' => __('Rwanda', 'shapepress-dsgvo'),
            'BL' => __('Saint Barth&eacute;lemy', 'shapepress-dsgvo'),
            'SH' => __('Saint Helena', 'shapepress-dsgvo'),
            'KN' => __('Saint Kitts and Nevis', 'shapepress-dsgvo'),
            'LC' => __('Saint Lucia', 'shapepress-dsgvo'),
            'MF' => __('Saint Martin (French part)', 'shapepress-dsgvo'),
            'SX' => __('Saint Martin (Dutch part)', 'shapepress-dsgvo'),
            'PM' => __('Saint Pierre and Miquelon', 'shapepress-dsgvo'),
            'VC' => __('Saint Vincent and the Grenadines', 'shapepress-dsgvo'),
            'SM' => __('San Marino', 'shapepress-dsgvo'),
            'ST' => __('S&atilde;o Tom&eacute; and Pr&iacute;ncipe', 'shapepress-dsgvo'),
            'SA' => __('Saudi Arabia', 'shapepress-dsgvo'),
            'SN' => __('Senegal', 'shapepress-dsgvo'),
            'RS' => __('Serbia', 'shapepress-dsgvo'),
            'SC' => __('Seychelles', 'shapepress-dsgvo'),
            'SL' => __('Sierra Leone', 'shapepress-dsgvo'),
            'SG' => __('Singapore', 'shapepress-dsgvo'),
            'SK' => __('Slovakia', 'shapepress-dsgvo'),
            'SI' => __('Slovenia', 'shapepress-dsgvo'),
            'SB' => __('Solomon Islands', 'shapepress-dsgvo'),
            'SO' => __('Somalia', 'shapepress-dsgvo'),
            'ZA' => __('South Africa', 'shapepress-dsgvo'),
            'GS' => __('South Georgia/Sandwich Islands', 'shapepress-dsgvo'),
            'KR' => __('South Korea', 'shapepress-dsgvo'),
            'SS' => __('South Sudan', 'shapepress-dsgvo'),
            'ES' => __('Spain', 'shapepress-dsgvo'),
            'LK' => __('Sri Lanka', 'shapepress-dsgvo'),
            'SD' => __('Sudan', 'shapepress-dsgvo'),
            'SR' => __('Suriname', 'shapepress-dsgvo'),
            'SJ' => __('Svalbard and Jan Mayen', 'shapepress-dsgvo'),
            'SZ' => __('Swaziland', 'shapepress-dsgvo'),
            'SE' => __('Sweden', 'shapepress-dsgvo'),
            'CH' => __('Switzerland', 'shapepress-dsgvo'),
            'SY' => __('Syria', 'shapepress-dsgvo'),
            'TW' => __('Taiwan', 'shapepress-dsgvo'),
            'TJ' => __('Tajikistan', 'shapepress-dsgvo'),
            'TZ' => __('Tanzania', 'shapepress-dsgvo'),
            'TH' => __('Thailand', 'shapepress-dsgvo'),
            'TL' => __('Timor-Leste', 'shapepress-dsgvo'),
            'TG' => __('Togo', 'shapepress-dsgvo'),
            'TK' => __('Tokelau', 'shapepress-dsgvo'),
            'TO' => __('Tonga', 'shapepress-dsgvo'),
            'TT' => __('Trinidad and Tobago', 'shapepress-dsgvo'),
            'TN' => __('Tunisia', 'shapepress-dsgvo'),
            'TR' => __('Turkey', 'shapepress-dsgvo'),
            'TM' => __('Turkmenistan', 'shapepress-dsgvo'),
            'TC' => __('Turks and Caicos Islands', 'shapepress-dsgvo'),
            'TV' => __('Tuvalu', 'shapepress-dsgvo'),
            'UG' => __('Uganda', 'shapepress-dsgvo'),
            'UA' => __('Ukraine', 'shapepress-dsgvo'),
            'AE' => __('United Arab Emirates', 'shapepress-dsgvo'),
            'GB' => __('United Kingdom (UK)', 'shapepress-dsgvo'),
            'US' => __('United States (US)', 'shapepress-dsgvo'),
            'UM' => __('United States (US) Minor Outlying Islands', 'shapepress-dsgvo'),
            'UY' => __('Uruguay', 'shapepress-dsgvo'),
            'UZ' => __('Uzbekistan', 'shapepress-dsgvo'),
            'VU' => __('Vanuatu', 'shapepress-dsgvo'),
            'VA' => __('Vatican', 'shapepress-dsgvo'),
            'VE' => __('Venezuela', 'shapepress-dsgvo'),
            'VN' => __('Vietnam', 'shapepress-dsgvo'),
            'VG' => __('Virgin Islands (British)', 'shapepress-dsgvo'),
            'VI' => __('Virgin Islands (US)', 'shapepress-dsgvo'),
            'WF' => __('Wallis and Futuna', 'shapepress-dsgvo'),
            'EH' => __('Western Sahara', 'shapepress-dsgvo'),
            'WS' => __('Samoa', 'shapepress-dsgvo'),
            'YE' => __('Yemen', 'shapepress-dsgvo'),
            'ZM' => __('Zambia', 'shapepress-dsgvo'),
            'ZW' => __('Zimbabwe', 'shapepress-dsgvo'),
        );

    }

    public static function getTagManager()
    {
        return array('google-tagmanager' => 'Google TagManager',
            'matomo-tagmanager' => 'Matomo TagManager');
    }

    public static function getWayOfIntegrationModes()
    {
        return array('on-premises' => __('I host it on the same server as this page', 'shapepress-dsgvo'),
            'cloud' => __("It's remote included (online/cloud)", 'shapepress-dsgvo'),
            'by-agency' => __('I connect it to an server of an agency', 'shapepress-dsgvo'));
    }
}