<?php
/*
 * Plugin Name:       Shapely Companion
 * Plugin URI:        https://colorlib.com/wp/themes/shapely/
 * Description:       Shapely Companion is a companion plugin for Shapely theme.
 * Version:           1.2.10
 * Author:            Colorlib
 * Author URI:        https://colorlib.com
 * License:           GPL-2.0+
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       shapely-companion
 * Domain Path:       /languages
 */

if ( ! defined( 'WPINC' ) ) {
	die;
}

define( 'SHAPELY_COMPANION', '1.2.10' );

/**
 * Initialize widgets and theme compatibility check.
 */
function shapely_companion_setup() {
	$current_theme = wp_get_theme();
	$current_parent = $current_theme->parent();

	if ( 'Shapely' == $current_theme->get( 'Name' ) || ( $current_parent && 'Shapely' == $current_parent->get( 'Name' ) ) ) {
		/**
		 * Load the Widgets
		 */
		require_once plugin_dir_path( __FILE__ ) . 'inc/shapely-widgets.php';
	}
}
add_action( 'after_setup_theme', 'shapely_companion_setup' );

/**
 * Initialize the plugin logic.
 */
function shapely_companion_init() {
	/**
	 * Load the Dashboard Widget
	 */
	require_once plugin_dir_path( __FILE__ ) . 'inc/epsilon-dashboard/class-epsilon-dashboard.php';

	/**
	 * The helper method to run the class
	 *
	 * @return Epsilon_Dashboard
	 */
	function shapely_companion_dashboard_widget() {
		$epsilon_dashboard_args = array(
			'widget_title' => esc_html__( 'From our blog', 'shapely-companion' ),
			'feed_url'  => array( 'https://colorlib.com/wp/feed/' ),
		);
		return Epsilon_Dashboard::instance( $epsilon_dashboard_args );
	}

	/**
	 * Setup the dashboard widget.
	 */
	function shapely_companion_setup_dashboard_widget() {
		shapely_companion_dashboard_widget();
	}
	add_action( 'wp_dashboard_setup', 'shapely_companion_setup_dashboard_widget' );

	$current_theme = wp_get_theme();
	$current_parent = $current_theme->parent();

	if ( 'Shapely' == $current_theme->get( 'Name' ) || ( $current_parent && 'Shapely' == $current_parent->get( 'Name' ) ) ) {
		/**
		 * Load Enqueues
		 */
		require_once plugin_dir_path( __FILE__ ) . '/inc/shapely-enqueues.php';

		/**
		 * Load Helper
		 */
		require_once plugin_dir_path( __FILE__ ) . '/inc/shapely-helper.php';

		/**
		 * Load Import Demo Content Functionality
		 */
		require_once plugin_dir_path( __FILE__ ) . '/inc/shapely-demo-content.php';

		/**
		 * Load Nav Menu Functionality
		 */
		require_once plugin_dir_path( __FILE__ ) . '/inc/shapely-navmenu.php';

		/**
		 * Load Metabox for Portfolio
		 */
		if ( class_exists( 'Jetpack' ) && Jetpack::is_module_active( 'custom-content-types' ) ) {
			$jetpack_portfolio = get_option( 'jetpack_portfolio' );
			if ( $jetpack_portfolio ) {
				require_once plugin_dir_path( __FILE__ ) . '/inc/shapely-metabox.php';
			}
		}
	} else {
		add_action( 'admin_notices', 'shapely_companion_admin_notice', 99 );
		function shapely_companion_admin_notice() {
		?>
			<div class="notice-warning notice">
				<p><?php printf( wp_kses_post( __( 'In order to use the <strong>Shapely Companion</strong> plugin you have to also install the %1$sShapely Theme%2$s', 'shapely-companion' ) ), '<a href="https://wordpress.org/themes/shapely/" target="_blank">', '</a>' ); ?></p>
			</div>
			<?php
		}
	}
}
add_action( 'init', 'shapely_companion_init' );


