<?php
if ( ! headers_sent() ) {
	status_header( $args['response'] );
	nocache_headers();
}

if( ! empty( $args['blocked_login'] ) ) {
	// translators: Constructing the login title.
    $login_title = sprintf( __( '%1$s &lsaquo; %2$s &#8212; WordPress' ), 'Log In', get_bloginfo( 'name', 'display' ) );

    /**
     * Filters the title tag content for login page.
     *
     * @since 4.9.0
     *
     * @param string $login_title The page title, with extra context added.
     * @param string $title       The original page title.
     */
    $login_title = apply_filters( 'login_title', $login_title, $title );

    ?><!DOCTYPE html>
    <html <?php language_attributes(); ?>>
    <head>
        <meta http-equiv="Content-Type" content="<?php bloginfo( 'html_type' ); ?>; charset=<?php bloginfo( 'charset' ); ?>" />
        <title><?php echo esc_html( $login_title ); ?></title>
        <?php

    wp_enqueue_style( 'login' );
}
?>

	<link href="https://fonts.googleapis.com/css?family=Open+Sans:400,700|Roboto:400,700" rel="stylesheet">
</head>

<style>
	* {
		box-sizing: border-box;
		-moz-box-sizing: border-box;
		-webkit-tap-highlight-color: transparent;
	}
	
	body {
		margin: 0!important;
		background: none!important;
		padding: 0;
		height: 100%;
		-webkit-text-size-adjust: 100%;
	}
	
	.fit-wide {
		position: relative;
		overflow: hidden;
		max-width: 1240px;
		margin: 0 auto;
		padding-top: 60px;
		padding-bottom: 60px;
		padding-left: 20px;
		padding-right: 20px;
	}
	
	.background-wrap { position: relative; }
	.background-wrap.cloud-blue { background-color: #b0e0e9; }
	.background-wrap.white { background-color: #fff; }
	
	.title { 
		position: relative; 
		text-align: center;
		margin: 20px auto 10px;
	}
	.title--regular { font-family: 'Roboto', Arial, sans-serif; }
	.title--size-large { font-size: 36px; line-height: 46px; }
	.title--size-semimedium { font-size: 20px; line-height: 28px; }
	.title--weight-normal { font-weight: 400; }
	.title--weight-bold { font-weight: 700; }
	
	.title--subtitle { 
		padding-bottom: 40px; 
		font-family: 'Open Sans', Arial ,sans-serif; 
		text-align: center;
	}
	
	.error h1,
	.error p { color: #226d7a; }
	.error--bg__cover {
		position: absolute;
		width: 100%;
	}
	
	.error--shape__clouds svg {
		display: block;
	}
	
	.abstract-half-dot--circle {
		z-index: 0;
		position: absolute;
		left: 15em;
		right: 0;
		width: 300px;
		height: 300px;
		margin: 0 auto;
	}
	.icon-graphic {
		z-index: 1;
		position: relative;
		width: 300px;
		height: 300px;
		margin: 0 auto;
	}
	
	@media screen and (max-width: 767px), screen and (max-device-width: 767px) {
		.error--bg__cover { display: none; }
		.abstract-half-dot--circle { left: 0; }
	}
</style>
	
<body>

	<div id="container">
		<section class="error content background-wrap cloud-blue">
			<div class="fit-wide">
				<div class="error--bg__cover">
					<svg id="bc788931-585e-4b6c-9d43-67a2624b36c2" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1240 340"><title>400_401_403_bgr</title><path d="M377.166,20.484a9.971,9.971,0,0,1-7.251-3.106h0a10.011,10.011,0,1,1,7.251,3.106Zm0-17.992A8,8,0,0,0,371.364,16h0a8,8,0,1,0,5.8-13.508Z" fill="#226d7a"/><path d="M155.567,86.685c-.087,0-.173,0-.26,0a9.927,9.927,0,1,1,.26,0Zm-.011-18a7.947,7.947,0,1,0,.208,0Z" fill="#226d7a"/><path d="M1046.567,164.685c-.087,0-.173,0-.26,0a9.924,9.924,0,1,1,.26,0Zm-.011-18a8,8,0,0,0-5.794,13.511h0a8,8,0,1,0,6-13.509Z" fill="#226d7a"/><path d="M395.976,213a.994.994,0,0,1-.416-.091L370.2,201.287a1,1,0,0,1-.192-1.7l20.758-15.9a1,1,0,0,1,1.594.629l4.607,27.516a1,1,0,0,1-.986,1.165Zm-23.437-12.836L394.678,210.3l-4.021-24.018Z" fill="#226d7a"/><path d="M884.877,213.014a1,1,0,0,1-1-1.022l.57-26.139a1,1,0,0,1,1.488-.852l24.356,13.608a1,1,0,0,1-.038,1.766l-24.927,12.532A.989.989,0,0,1,884.877,213.014Zm1.534-25.456-.5,22.816,21.757-10.939Z" fill="#226d7a"/><path d="M1045.949,57.528a1,1,0,0,1-.865-.5l-14-24.135a1,1,0,0,1,.827-1.5l26.128-.989a1.025,1.025,0,0,1,.875.453,1,1,0,0,1,.063.982L1046.85,56.963a1,1,0,0,1-.863.564Zm-12.3-24.2L1045.868,54.4l10.59-21.929Z" fill="#226d7a"/><path d="M158.43,275.516a1,1,0,0,1-.472-1.882l27.929-14.914a1,1,0,0,1,.942,1.764L158.9,275.4A.993.993,0,0,1,158.43,275.516Z" fill="#226d7a"/><path d="M148.583,295.276a1,1,0,0,1-.473-1.882l44.154-23.577a1,1,0,1,1,.943,1.763l-44.154,23.577A1,1,0,0,1,148.583,295.276Z" fill="#226d7a"/><path d="M1023.25,339.512a1,1,0,0,1-.884-.529c-3.191-5.988.771-13.269,6.113-17.83,4.788-4.085,9.926-6.422,14.762-6.766,1.569-6.323,5.924-11.651,8.309-14.2,11.746-12.542,27.444-18.876,42.021-16.94a1,1,0,0,1-.263,1.983c-13.92-1.85-28.992,4.25-40.3,16.324-2.184,2.332-6.146,7.151-7.7,12.807.331.017.66.043.987.08,3.41.378,7.616,2.213,9.192,6.227a7.69,7.69,0,0,1-.845,6.882,5.421,5.421,0,0,1-4.373,2.573h-.085c-3.284,0-5.744-3.046-6.732-6.089a16.747,16.747,0,0,1-.612-7.608c-4.252.443-8.785,2.594-13.066,6.246-4.58,3.909-8.3,10.386-5.645,15.366a1,1,0,0,1-.412,1.354A1.012,1.012,0,0,1,1023.25,339.512Zm21.626-23.164a14.931,14.931,0,0,0,.481,7.072c.745,2.292,2.555,4.726,4.883,4.7a3.485,3.485,0,0,0,2.742-1.686,5.715,5.715,0,0,0,.647-5.038c-1.251-3.185-4.722-4.656-7.552-4.97C1045.681,316.387,1045.279,316.359,1044.876,316.348Z" fill="#1e6d7a"/></svg>
				</div>
				<div>
					<div class="abstract-half-dot--circle">
						<svg id="a57f7293-9654-4013-9c82-7cad22fc3689" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 300 298.181"><title>circle_dots</title><polygon points="145.742 133.848 147.581 131.734 145.742 129.621 143.904 131.734 145.742 133.848" fill="#fff"/><polygon points="145.742 122.041 147.581 119.928 145.742 117.814 143.904 119.928 145.742 122.041" fill="#fff"/><polygon points="145.742 110.235 147.581 108.122 145.742 106.008 143.904 108.122 145.742 110.235" fill="#fff"/><polygon points="145.742 98.429 147.581 96.316 145.742 94.202 143.904 96.316 145.742 98.429" fill="#fff"/><polygon points="145.742 86.624 147.581 84.51 145.742 82.396 143.904 84.51 145.742 86.624" fill="#fff"/><polygon points="156.015 129.621 154.177 131.734 156.015 133.848 157.854 131.734 156.015 129.621" fill="#fff"/><polygon points="156.015 117.814 154.177 119.928 156.015 122.041 157.854 119.928 156.015 117.814" fill="#fff"/><polygon points="156.015 106.008 154.177 108.122 156.015 110.235 157.854 108.122 156.015 106.008" fill="#fff"/><polygon points="156.015 94.202 154.177 96.316 156.015 98.429 157.854 96.316 156.015 94.202" fill="#fff"/><polygon points="156.015 82.396 154.177 84.51 156.015 86.624 157.854 84.51 156.015 82.396" fill="#fff"/><polygon points="166.288 129.621 164.45 131.734 166.288 133.848 168.13 131.734 166.288 129.621" fill="#fff"/><polygon points="166.288 117.814 164.45 119.928 166.288 122.041 168.13 119.928 166.288 117.814" fill="#fff"/><polygon points="166.288 106.008 164.45 108.122 166.288 110.235 168.13 108.122 166.288 106.008" fill="#fff"/><polygon points="166.288 94.202 164.45 96.316 166.288 98.429 168.13 96.316 166.288 94.202" fill="#fff"/><polygon points="168.128 84.51 166.288 82.396 164.45 84.51 166.288 86.624 168.128 84.51" fill="#fff"/><polygon points="176.563 129.621 174.724 131.734 176.563 133.848 178.401 131.734 176.563 129.621" fill="#fff"/><polygon points="176.563 117.814 174.724 119.928 176.563 122.041 178.401 119.928 176.563 117.814" fill="#fff"/><polygon points="176.563 106.008 174.724 108.122 176.563 110.235 178.401 108.122 176.563 106.008" fill="#fff"/><polygon points="176.563 94.202 174.724 96.316 176.563 98.429 178.401 96.316 176.563 94.202" fill="#fff"/><polygon points="176.563 82.396 174.724 84.51 176.563 86.624 178.401 84.51 176.563 82.396" fill="#fff"/><polygon points="186.835 129.621 184.997 131.734 186.835 133.848 188.674 131.734 186.835 129.621" fill="#fff"/><polygon points="186.835 117.814 184.997 119.928 186.835 122.041 188.674 119.928 186.835 117.814" fill="#fff"/><polygon points="186.835 106.008 184.997 108.122 186.835 110.235 188.674 108.122 186.835 106.008" fill="#fff"/><polygon points="186.835 94.202 184.997 96.316 186.835 98.429 188.674 96.316 186.835 94.202" fill="#fff"/><polygon points="186.835 82.396 184.997 84.51 186.835 86.624 188.674 84.51 186.835 82.396" fill="#fff"/><polygon points="197.11 129.621 195.268 131.734 197.11 133.848 198.948 131.734 197.11 129.621" fill="#fff"/><polygon points="197.11 117.814 195.268 119.928 197.11 122.041 198.948 119.928 197.11 117.814" fill="#fff"/><polygon points="197.11 106.008 195.268 108.122 197.11 110.235 198.948 108.122 197.11 106.008" fill="#fff"/><polygon points="197.11 94.202 195.268 96.316 197.11 98.429 198.948 96.316 197.11 94.202" fill="#fff"/><polygon points="197.11 82.396 195.27 84.51 197.11 86.624 198.948 84.51 197.11 82.396" fill="#fff"/><polygon points="207.383 129.621 205.545 131.734 207.383 133.848 209.221 131.734 207.383 129.621" fill="#fff"/><polygon points="207.383 117.814 205.545 119.928 207.383 122.041 209.221 119.928 207.383 117.814" fill="#fff"/><polygon points="207.383 106.008 205.545 108.122 207.383 110.235 209.221 108.122 207.383 106.008" fill="#fff"/><polygon points="207.383 94.202 205.545 96.316 207.383 98.429 209.221 96.316 207.383 94.202" fill="#fff"/><polygon points="207.383 82.396 205.545 84.51 207.383 86.624 209.221 84.51 207.383 82.396" fill="#fff"/><polygon points="217.656 129.621 215.817 131.734 217.656 133.848 219.497 131.734 217.656 129.621" fill="#fff"/><polygon points="217.656 117.814 215.817 119.928 217.656 122.041 219.497 119.928 217.656 117.814" fill="#fff"/><polygon points="217.656 106.008 215.817 108.122 217.656 110.235 219.497 108.122 217.656 106.008" fill="#fff"/><polygon points="217.656 94.202 215.817 96.316 217.656 98.429 219.497 96.316 217.656 94.202" fill="#fff"/><polygon points="219.496 84.51 217.656 82.396 215.817 84.51 217.656 86.624 219.496 84.51" fill="#fff"/><polygon points="227.93 129.621 226.092 131.734 227.93 133.848 229.769 131.734 227.93 129.621" fill="#fff"/><polygon points="227.93 117.814 226.092 119.928 227.93 122.041 229.769 119.928 227.93 117.814" fill="#fff"/><polygon points="227.93 106.008 226.092 108.122 227.93 110.235 229.769 108.122 227.93 106.008" fill="#fff"/><polygon points="227.93 94.202 226.092 96.316 227.93 98.429 229.769 96.316 227.93 94.202" fill="#fff"/><polygon points="227.93 82.396 226.092 84.51 227.93 86.624 229.769 84.51 227.93 82.396" fill="#fff"/><polygon points="238.203 129.621 236.365 131.734 238.203 133.848 240.042 131.734 238.203 129.621" fill="#fff"/><polygon points="238.203 117.814 236.365 119.928 238.203 122.041 240.042 119.928 238.203 117.814" fill="#fff"/><polygon points="238.203 106.008 236.365 108.122 238.203 110.235 240.042 108.122 238.203 106.008" fill="#fff"/><polygon points="238.203 94.202 236.365 96.316 238.203 98.429 240.042 96.316 238.203 94.202" fill="#fff"/><polygon points="238.203 82.396 236.365 84.51 238.203 86.624 240.042 84.51 238.203 82.396" fill="#fff"/><polygon points="248.478 133.848 250.316 131.734 248.478 129.621 246.636 131.734 248.478 133.848" fill="#fff"/><polygon points="248.478 122.041 250.316 119.928 248.478 117.814 246.636 119.928 248.478 122.041" fill="#fff"/><polygon points="248.478 110.235 250.316 108.122 248.478 106.008 246.636 108.122 248.478 110.235" fill="#fff"/><polygon points="248.478 98.429 250.316 96.316 248.478 94.202 246.636 96.316 248.478 98.429" fill="#fff"/><polygon points="246.638 84.51 248.478 86.624 250.316 84.51 248.478 82.396 246.638 84.51" fill="#fff"/><polygon points="258.751 129.621 256.912 131.734 258.751 133.848 260.589 131.734 258.751 129.621" fill="#fff"/><polygon points="258.751 117.814 256.912 119.928 258.751 122.041 260.589 119.928 258.751 117.814" fill="#fff"/><polygon points="258.751 106.008 256.912 108.122 258.751 110.235 260.589 108.122 258.751 106.008" fill="#fff"/><polygon points="258.751 94.202 256.912 96.316 258.751 98.429 260.589 96.316 258.751 94.202" fill="#fff"/><polygon points="258.751 82.396 256.912 84.51 258.751 86.624 260.589 84.51 258.751 82.396" fill="#fff"/><polygon points="269.023 129.621 267.185 131.734 269.023 133.848 270.865 131.734 269.023 129.621" fill="#fff"/><polygon points="269.023 117.814 267.185 119.928 269.023 122.041 270.865 119.928 269.023 117.814" fill="#fff"/><polygon points="269.023 106.008 267.185 108.122 269.023 110.235 270.865 108.122 269.023 106.008" fill="#fff"/><polygon points="269.023 94.202 267.185 96.316 269.023 98.429 270.865 96.316 269.023 94.202" fill="#fff"/><polygon points="270.863 84.51 269.023 82.396 267.185 84.51 269.023 86.624 270.863 84.51" fill="#fff"/><polygon points="145.742 75.064 147.581 72.95 145.742 70.837 143.904 72.95 145.742 75.064" fill="#fff"/><polygon points="145.742 63.258 147.581 61.144 145.742 59.031 143.904 61.144 145.742 63.258" fill="#fff"/><polygon points="145.742 51.452 147.581 49.338 145.742 47.225 143.904 49.338 145.742 51.452" fill="#fff"/><polygon points="145.742 39.646 147.581 37.532 145.742 35.419 143.904 37.532 145.742 39.646" fill="#fff"/><polygon points="145.742 27.84 147.581 25.726 145.742 23.612 143.904 25.726 145.742 27.84" fill="#fff"/><polygon points="147.581 13.92 145.742 11.806 143.904 13.92 145.742 16.033 147.581 13.92" fill="#fff"/><polygon points="143.904 2.114 145.742 4.227 147.581 2.114 145.742 0 143.904 2.114" fill="#fff"/><polygon points="156.015 70.837 154.177 72.95 156.015 75.064 157.854 72.95 156.015 70.837" fill="#fff"/><polygon points="156.015 59.031 154.177 61.144 156.015 63.258 157.854 61.144 156.015 59.031" fill="#fff"/><polygon points="156.015 47.225 154.177 49.338 156.015 51.452 157.854 49.338 156.015 47.225" fill="#fff"/><polygon points="156.015 35.419 154.177 37.532 156.015 39.646 157.854 37.532 156.015 35.419" fill="#fff"/><polygon points="156.015 23.612 154.177 25.726 156.015 27.84 157.854 25.726 156.015 23.612" fill="#fff"/><polygon points="156.015 11.806 154.177 13.92 156.015 16.033 157.854 13.92 156.015 11.806" fill="#fff"/><polygon points="156.015 0 154.177 2.114 156.015 4.227 157.854 2.114 156.015 0" fill="#fff"/><polygon points="166.288 70.837 164.45 72.95 166.288 75.064 168.13 72.95 166.288 70.837" fill="#fff"/><polygon points="166.288 59.031 164.45 61.144 166.288 63.258 168.13 61.144 166.288 59.031" fill="#fff"/><polygon points="166.288 47.225 164.45 49.338 166.288 51.452 168.13 49.338 166.288 47.225" fill="#fff"/><polygon points="166.288 35.419 164.45 37.532 166.288 39.646 168.13 37.532 166.288 35.419" fill="#fff"/><polygon points="166.288 23.612 164.45 25.726 166.288 27.84 168.13 25.726 166.288 23.612" fill="#fff"/><polygon points="166.288 11.806 164.45 13.92 166.288 16.033 168.13 13.92 166.288 11.806" fill="#fff"/><polygon points="166.288 0 164.45 2.114 166.288 4.227 168.13 2.114 166.288 0" fill="#fff"/><polygon points="176.563 70.837 174.724 72.95 176.563 75.064 178.401 72.95 176.563 70.837" fill="#fff"/><polygon points="176.563 59.031 174.724 61.144 176.563 63.258 178.401 61.144 176.563 59.031" fill="#fff"/><polygon points="176.563 47.225 174.724 49.338 176.563 51.452 178.401 49.338 176.563 47.225" fill="#fff"/><polygon points="176.563 35.419 174.724 37.532 176.563 39.646 178.401 37.532 176.563 35.419" fill="#fff"/><polygon points="176.563 23.612 174.724 25.726 176.563 27.84 178.401 25.726 176.563 23.612" fill="#fff"/><polygon points="176.563 11.806 174.724 13.92 176.563 16.033 178.401 13.92 176.563 11.806" fill="#fff"/><polygon points="176.563 0 174.724 2.114 176.563 4.227 178.401 2.114 176.563 0" fill="#fff"/><polygon points="186.835 70.837 184.997 72.95 186.835 75.064 188.674 72.95 186.835 70.837" fill="#fff"/><polygon points="186.835 59.031 184.997 61.144 186.835 63.258 188.674 61.144 186.835 59.031" fill="#fff"/><polygon points="186.835 47.225 184.997 49.338 186.835 51.452 188.674 49.338 186.835 47.225" fill="#fff"/><polygon points="186.835 35.419 184.997 37.532 186.835 39.646 188.674 37.532 186.835 35.419" fill="#fff"/><polygon points="186.835 23.612 184.997 25.726 186.835 27.84 188.674 25.726 186.835 23.612" fill="#fff"/><polygon points="186.835 11.806 184.997 13.92 186.835 16.033 188.674 13.92 186.835 11.806" fill="#fff"/><path d="M186.835,4.227l1.839-2.113-.31-.356c-.826-.225-1.651-.45-2.483-.661L185,2.114Z" fill="#fff"/><polygon points="197.11 70.837 195.268 72.95 197.11 75.064 198.948 72.95 197.11 70.837" fill="#fff"/><polygon points="197.11 59.031 195.268 61.144 197.11 63.258 198.948 61.144 197.11 59.031" fill="#fff"/><polygon points="197.11 47.225 195.268 49.338 197.11 51.452 198.948 49.338 197.11 47.225" fill="#fff"/><polygon points="197.11 35.419 195.268 37.532 197.11 39.646 198.948 37.532 197.11 35.419" fill="#fff"/><polygon points="197.11 23.612 195.268 25.726 197.11 27.84 198.948 25.726 197.11 23.612" fill="#fff"/><polygon points="197.11 11.806 195.268 13.92 197.11 16.033 198.948 13.92 197.11 11.806" fill="#fff"/><polygon points="207.383 70.837 205.545 72.95 207.383 75.064 209.221 72.95 207.383 70.837" fill="#fff"/><polygon points="207.383 59.031 205.545 61.144 207.383 63.258 209.221 61.144 207.383 59.031" fill="#fff"/><polygon points="207.383 47.225 205.545 49.338 207.383 51.452 209.221 49.338 207.383 47.225" fill="#fff"/><polygon points="207.383 35.419 205.545 37.532 207.383 39.646 209.221 37.532 207.383 35.419" fill="#fff"/><polygon points="207.383 23.612 205.545 25.726 207.383 27.84 209.221 25.726 207.383 23.612" fill="#fff"/><polygon points="207.383 11.806 205.545 13.92 207.383 16.033 209.221 13.92 207.383 11.806" fill="#fff"/><polygon points="217.656 70.837 215.817 72.95 217.656 75.064 219.497 72.95 217.656 70.837" fill="#fff"/><polygon points="217.656 59.031 215.817 61.144 217.656 63.258 219.497 61.144 217.656 59.031" fill="#fff"/><polygon points="217.656 47.225 215.817 49.338 217.656 51.452 219.497 49.338 217.656 47.225" fill="#fff"/><polygon points="217.656 35.419 215.817 37.532 217.656 39.646 219.497 37.532 217.656 35.419" fill="#fff"/><polygon points="217.656 23.612 215.817 25.726 217.656 27.84 219.497 25.726 217.656 23.612" fill="#fff"/><path d="M217.656,16.033l1.753-2.011c-.842-.445-1.685-.887-2.535-1.317l-1.057,1.215Z" fill="#fff"/><polygon points="227.93 70.837 226.092 72.95 227.93 75.064 229.769 72.95 227.93 70.837" fill="#fff"/><polygon points="227.93 59.031 226.092 61.144 227.93 63.258 229.769 61.144 227.93 59.031" fill="#fff"/><polygon points="227.93 47.225 226.092 49.338 227.93 51.452 229.769 49.338 227.93 47.225" fill="#fff"/><polygon points="227.93 35.419 226.092 37.532 227.93 39.646 229.769 37.532 227.93 35.419" fill="#fff"/><polygon points="227.93 23.612 226.092 25.726 227.93 27.84 229.769 25.726 227.93 23.612" fill="#fff"/><polygon points="238.203 70.837 236.365 72.95 238.203 75.064 240.042 72.95 238.203 70.837" fill="#fff"/><polygon points="238.203 59.031 236.365 61.144 238.203 63.258 240.042 61.144 238.203 59.031" fill="#fff"/><polygon points="238.203 47.225 236.365 49.338 238.203 51.452 240.042 49.338 238.203 47.225" fill="#fff"/><polygon points="238.203 35.419 236.365 37.532 238.203 39.646 240.042 37.532 238.203 35.419" fill="#fff"/><path d="M236.365,25.726,238.2,27.84l1.084-1.246c-.744-.555-1.5-1.1-2.25-1.641Z" fill="#fff"/><polygon points="248.478 75.064 250.316 72.95 248.478 70.837 246.636 72.95 248.478 75.064" fill="#fff"/><polygon points="248.478 63.258 250.316 61.144 248.478 59.031 246.636 61.144 248.478 63.258" fill="#fff"/><polygon points="250.316 49.338 248.478 47.225 246.636 49.338 248.478 51.452 250.316 49.338" fill="#fff"/><polygon points="246.636 37.532 248.478 39.646 250.316 37.532 248.478 35.419 246.636 37.532" fill="#fff"/><polygon points="258.751 70.837 256.912 72.95 258.751 75.064 260.589 72.95 258.751 70.837" fill="#fff"/><polygon points="258.751 59.031 256.912 61.144 258.751 63.258 260.589 61.144 258.751 59.031" fill="#fff"/><polygon points="258.751 47.225 256.912 49.338 258.751 51.452 260.589 49.338 258.751 47.225" fill="#fff"/><polygon points="269.023 70.837 267.185 72.95 269.023 75.064 270.865 72.95 269.023 70.837" fill="#fff"/><polygon points="269.023 59.031 267.185 61.144 269.023 63.258 270.865 61.144 269.023 59.031" fill="#fff"/><polygon points="279.445 129.621 277.607 131.734 279.445 133.848 281.284 131.734 279.445 129.621" fill="#fff"/><polygon points="279.445 117.814 277.607 119.928 279.445 122.041 281.284 119.928 279.445 117.814" fill="#fff"/><polygon points="279.445 106.008 277.607 108.122 279.445 110.235 281.284 108.122 279.445 106.008" fill="#fff"/><polygon points="279.445 94.202 277.607 96.316 279.445 98.429 281.284 96.316 279.445 94.202" fill="#fff"/><polygon points="279.445 82.396 277.607 84.51 279.445 86.624 281.284 84.51 279.445 82.396" fill="#fff"/><polygon points="289.718 129.621 287.88 131.734 289.718 133.848 291.56 131.734 289.718 129.621" fill="#fff"/><polygon points="289.718 117.814 287.88 119.928 289.718 122.041 291.56 119.928 289.718 117.814" fill="#fff"/><polygon points="289.718 106.008 287.88 108.122 289.718 110.235 291.56 108.122 289.718 106.008" fill="#fff"/><path d="M287.88,96.316l1.838,2.113,1.515-1.739c-.151-.422-.3-.846-.451-1.267L289.718,94.2Z" fill="#fff"/><path d="M299.092,130.656l-.938,1.078,1.192,1.37Q299.229,131.877,299.092,130.656Z" fill="#fff"/><path d="M279.445,75.064l1.241-1.427q-.721-1.278-1.466-2.541l-1.613,1.854Z" fill="#fff"/><polygon points="1.838 129.621 0 131.734 1.838 133.848 3.677 131.734 1.838 129.621" fill="#fff"/><polygon points="1.838 117.814 0 119.928 1.838 122.041 3.677 119.928 1.838 117.814" fill="#fff"/><path d="M1.838,110.235l1.839-2.113-1.534-1.764q-.456,1.6-.876,3.22Z" fill="#fff"/><polygon points="12.113 129.621 10.271 131.734 12.113 133.848 13.951 131.734 12.113 129.621" fill="#fff"/><polygon points="12.113 117.814 10.271 119.928 12.113 122.041 13.951 119.928 12.113 117.814" fill="#fff"/><polygon points="12.113 106.008 10.271 108.122 12.113 110.235 13.951 108.122 12.113 106.008" fill="#fff"/><polygon points="12.113 94.202 10.271 96.316 12.113 98.429 13.951 96.316 12.113 94.202" fill="#fff"/><polygon points="12.113 82.396 10.273 84.51 12.113 86.624 13.951 84.51 12.113 82.396" fill="#fff"/><polygon points="22.533 129.621 20.695 131.734 22.533 133.848 24.371 131.734 22.533 129.621" fill="#fff"/><polygon points="22.533 117.814 20.695 119.928 22.533 122.041 24.371 119.928 22.533 117.814" fill="#fff"/><polygon points="22.533 106.008 20.695 108.122 22.533 110.235 24.371 108.122 22.533 106.008" fill="#fff"/><polygon points="22.533 94.202 20.695 96.316 22.533 98.429 24.371 96.316 22.533 94.202" fill="#fff"/><polygon points="22.533 82.396 20.695 84.51 22.533 86.624 24.371 84.51 22.533 82.396" fill="#fff"/><polygon points="32.808 129.621 30.966 131.734 32.808 133.848 34.646 131.734 32.808 129.621" fill="#fff"/><polygon points="32.808 117.814 30.966 119.928 32.808 122.041 34.646 119.928 32.808 117.814" fill="#fff"/><polygon points="32.808 106.008 30.966 108.122 32.808 110.235 34.646 108.122 32.808 106.008" fill="#fff"/><polygon points="32.808 94.202 30.966 96.316 32.808 98.429 34.646 96.316 32.808 94.202" fill="#fff"/><polygon points="32.808 82.396 30.968 84.51 32.808 86.624 34.646 84.51 32.808 82.396" fill="#fff"/><polygon points="43.08 129.621 41.242 131.734 43.08 133.848 44.919 131.734 43.08 129.621" fill="#fff"/><polygon points="43.08 117.814 41.242 119.928 43.08 122.041 44.919 119.928 43.08 117.814" fill="#fff"/><polygon points="43.08 106.008 41.242 108.122 43.08 110.235 44.919 108.122 43.08 106.008" fill="#fff"/><polygon points="43.08 94.202 41.242 96.316 43.08 98.429 44.919 96.316 43.08 94.202" fill="#fff"/><polygon points="43.08 82.396 41.242 84.51 43.08 86.624 44.919 84.51 43.08 82.396" fill="#fff"/><polygon points="53.353 129.621 51.515 131.734 53.353 133.848 55.195 131.734 53.353 129.621" fill="#fff"/><polygon points="53.353 117.814 51.515 119.928 53.353 122.041 55.195 119.928 53.353 117.814" fill="#fff"/><polygon points="53.353 106.008 51.515 108.122 53.353 110.235 55.195 108.122 53.353 106.008" fill="#fff"/><polygon points="53.353 94.202 51.515 96.316 53.353 98.429 55.195 96.316 53.353 94.202" fill="#fff"/><polygon points="55.193 84.51 53.353 82.396 51.515 84.51 53.353 86.624 55.193 84.51" fill="#fff"/><polygon points="63.628 129.621 61.789 131.734 63.628 133.848 65.466 131.734 63.628 129.621" fill="#fff"/><polygon points="63.628 117.814 61.789 119.928 63.628 122.041 65.466 119.928 63.628 117.814" fill="#fff"/><polygon points="63.628 106.008 61.789 108.122 63.628 110.235 65.466 108.122 63.628 106.008" fill="#fff"/><polygon points="63.628 94.202 61.789 96.316 63.628 98.429 65.466 96.316 63.628 94.202" fill="#fff"/><polygon points="63.628 82.396 61.789 84.51 63.628 86.624 65.466 84.51 63.628 82.396" fill="#fff"/><polygon points="73.901 129.621 72.062 131.734 73.901 133.848 75.739 131.734 73.901 129.621" fill="#fff"/><polygon points="73.901 117.814 72.062 119.928 73.901 122.041 75.739 119.928 73.901 117.814" fill="#fff"/><polygon points="73.901 106.008 72.062 108.122 73.901 110.235 75.739 108.122 73.901 106.008" fill="#fff"/><polygon points="73.901 94.202 72.062 96.316 73.901 98.429 75.739 96.316 73.901 94.202" fill="#fff"/><polygon points="73.901 82.396 72.062 84.51 73.901 86.624 75.739 84.51 73.901 82.396" fill="#fff"/><polygon points="84.174 129.621 82.335 131.734 84.174 133.848 86.015 131.734 84.174 129.621" fill="#fff"/><polygon points="84.174 117.814 82.335 119.928 84.174 122.041 86.015 119.928 84.174 117.814" fill="#fff"/><polygon points="84.174 106.008 82.335 108.122 84.174 110.235 86.015 108.122 84.174 106.008" fill="#fff"/><polygon points="84.174 94.202 82.335 96.316 84.174 98.429 86.015 96.316 84.174 94.202" fill="#fff"/><polygon points="86.014 84.51 84.174 82.396 82.335 84.51 84.174 86.624 86.014 84.51" fill="#fff"/><polygon points="94.448 129.621 92.61 131.734 94.448 133.848 96.286 131.734 94.448 129.621" fill="#fff"/><polygon points="94.448 117.814 92.61 119.928 94.448 122.041 96.286 119.928 94.448 117.814" fill="#fff"/><polygon points="94.448 106.008 92.61 108.122 94.448 110.235 96.286 108.122 94.448 106.008" fill="#fff"/><polygon points="94.448 94.202 92.61 96.316 94.448 98.429 96.286 96.316 94.448 94.202" fill="#fff"/><polygon points="94.448 82.396 92.61 84.51 94.448 86.624 96.286 84.51 94.448 82.396" fill="#fff"/><polygon points="104.721 129.621 102.883 131.734 104.721 133.848 106.559 131.734 104.721 129.621" fill="#fff"/><polygon points="104.721 117.814 102.883 119.928 104.721 122.041 106.559 119.928 104.721 117.814" fill="#fff"/><polygon points="104.721 106.008 102.883 108.122 104.721 110.235 106.559 108.122 104.721 106.008" fill="#fff"/><polygon points="104.721 94.202 102.883 96.316 104.721 98.429 106.559 96.316 104.721 94.202" fill="#fff"/><polygon points="104.721 82.396 102.883 84.51 104.721 86.624 106.559 84.51 104.721 82.396" fill="#fff"/><polygon points="114.996 129.621 113.154 131.734 114.996 133.848 116.834 131.734 114.996 129.621" fill="#fff"/><polygon points="114.996 117.814 113.154 119.928 114.996 122.041 116.834 119.928 114.996 117.814" fill="#fff"/><polygon points="114.996 106.008 113.154 108.122 114.996 110.235 116.834 108.122 114.996 106.008" fill="#fff"/><polygon points="114.996 94.202 113.154 96.316 114.996 98.429 116.834 96.316 114.996 94.202" fill="#fff"/><polygon points="114.996 82.396 113.156 84.51 114.996 86.624 116.834 84.51 114.996 82.396" fill="#fff"/><polygon points="125.268 133.848 127.107 131.734 125.268 129.621 123.43 131.734 125.268 133.848" fill="#fff"/><polygon points="125.268 122.041 127.107 119.928 125.268 117.814 123.43 119.928 125.268 122.041" fill="#fff"/><polygon points="125.268 110.235 127.107 108.122 125.268 106.008 123.43 108.122 125.268 110.235" fill="#fff"/><polygon points="125.268 98.429 127.107 96.316 125.268 94.202 123.43 96.316 125.268 98.429" fill="#fff"/><polygon points="125.268 86.624 127.107 84.51 125.268 82.396 123.43 84.51 125.268 86.624" fill="#fff"/><polygon points="135.541 133.848 137.383 131.734 135.541 129.621 133.703 131.734 135.541 133.848" fill="#fff"/><polygon points="135.541 122.041 137.383 119.928 135.541 117.814 133.703 119.928 135.541 122.041" fill="#fff"/><polygon points="135.541 110.235 137.383 108.122 135.541 106.008 133.703 108.122 135.541 110.235" fill="#fff"/><polygon points="135.541 98.429 137.383 96.316 135.541 94.202 133.703 96.316 135.541 98.429" fill="#fff"/><polygon points="135.541 86.624 137.381 84.51 135.541 82.396 133.703 84.51 135.541 86.624" fill="#fff"/><polygon points="22.533 70.837 20.695 72.95 22.533 75.064 24.371 72.95 22.533 70.837" fill="#fff"/><path d="M22.533,63.258l1.838-2.114-.387-.445c-.55.779-1.1,1.559-1.634,2.349Z" fill="#fff"/><polygon points="32.808 70.837 30.966 72.95 32.808 75.064 34.646 72.95 32.808 70.837" fill="#fff"/><polygon points="32.808 59.031 30.966 61.144 32.808 63.258 34.646 61.144 32.808 59.031" fill="#fff"/><path d="M32.808,51.452l1.838-2.114-.9-1.037c-.616.7-1.222,1.416-1.825,2.132Z" fill="#fff"/><polygon points="43.08 70.837 41.242 72.95 43.08 75.064 44.919 72.95 43.08 70.837" fill="#fff"/><polygon points="43.08 59.031 41.242 61.144 43.08 63.258 44.919 61.144 43.08 59.031" fill="#fff"/><polygon points="43.08 47.225 41.242 49.338 43.08 51.452 44.919 49.338 43.08 47.225" fill="#fff"/><path d="M43.08,39.646l1.839-2.114-.342-.393q-1.016.947-2.015,1.911Z" fill="#fff"/><polygon points="53.353 70.837 51.515 72.95 53.353 75.064 55.195 72.95 53.353 70.837" fill="#fff"/><polygon points="53.353 59.031 51.515 61.144 53.353 63.258 55.195 61.144 53.353 59.031" fill="#fff"/><polygon points="53.353 47.225 51.515 49.338 53.353 51.452 55.195 49.338 53.353 47.225" fill="#fff"/><polygon points="53.353 35.419 51.515 37.532 53.353 39.646 55.195 37.532 53.353 35.419" fill="#fff"/><polygon points="63.628 70.837 61.789 72.95 63.628 75.064 65.466 72.95 63.628 70.837" fill="#fff"/><polygon points="63.628 59.031 61.789 61.144 63.628 63.258 65.466 61.144 63.628 59.031" fill="#fff"/><polygon points="63.628 47.225 61.789 49.338 63.628 51.452 65.466 49.338 63.628 47.225" fill="#fff"/><polygon points="63.628 35.419 61.789 37.532 63.628 39.646 65.466 37.532 63.628 35.419" fill="#fff"/><polygon points="63.628 23.612 61.789 25.726 63.628 27.84 65.466 25.726 63.628 23.612" fill="#fff"/><polygon points="73.901 70.837 72.062 72.95 73.901 75.064 75.739 72.95 73.901 70.837" fill="#fff"/><polygon points="73.901 59.031 72.062 61.144 73.901 63.258 75.739 61.144 73.901 59.031" fill="#fff"/><polygon points="73.901 47.225 72.062 49.338 73.901 51.452 75.739 49.338 73.901 47.225" fill="#fff"/><polygon points="73.901 35.419 72.062 37.532 73.901 39.646 75.739 37.532 73.901 35.419" fill="#fff"/><polygon points="73.901 23.612 72.062 25.726 73.901 27.84 75.739 25.726 73.901 23.612" fill="#fff"/><path d="M73.9,16.033l.476-.547c-.214.119-.429.237-.642.357Z" fill="#fff"/><polygon points="84.174 70.837 82.335 72.95 84.174 75.064 86.015 72.95 84.174 70.837" fill="#fff"/><polygon points="84.174 59.031 82.335 61.144 84.174 63.258 86.015 61.144 84.174 59.031" fill="#fff"/><polygon points="84.174 47.225 82.335 49.338 84.174 51.452 86.015 49.338 84.174 47.225" fill="#fff"/><polygon points="84.174 35.419 82.335 37.532 84.174 39.646 86.015 37.532 84.174 35.419" fill="#fff"/><polygon points="84.174 23.612 82.335 25.726 84.174 27.84 86.015 25.726 84.174 23.612" fill="#fff"/><polygon points="84.174 11.806 82.335 13.92 84.174 16.033 86.015 13.92 84.174 11.806" fill="#fff"/><polygon points="94.448 70.837 92.61 72.95 94.448 75.064 96.286 72.95 94.448 70.837" fill="#fff"/><polygon points="94.448 59.031 92.61 61.144 94.448 63.258 96.286 61.144 94.448 59.031" fill="#fff"/><polygon points="94.448 47.225 92.61 49.338 94.448 51.452 96.286 49.338 94.448 47.225" fill="#fff"/><polygon points="94.448 35.419 92.61 37.532 94.448 39.646 96.286 37.532 94.448 35.419" fill="#fff"/><polygon points="94.448 23.612 92.61 25.726 94.448 27.84 96.286 25.726 94.448 23.612" fill="#fff"/><polygon points="94.448 11.806 92.61 13.92 94.448 16.033 96.286 13.92 94.448 11.806" fill="#fff"/><polygon points="104.721 70.837 102.883 72.95 104.721 75.064 106.559 72.95 104.721 70.837" fill="#fff"/><polygon points="104.721 59.031 102.883 61.144 104.721 63.258 106.559 61.144 104.721 59.031" fill="#fff"/><polygon points="104.721 47.225 102.883 49.338 104.721 51.452 106.559 49.338 104.721 47.225" fill="#fff"/><polygon points="104.721 35.419 102.883 37.532 104.721 39.646 106.559 37.532 104.721 35.419" fill="#fff"/><polygon points="104.721 23.612 102.883 25.726 104.721 27.84 106.559 25.726 104.721 23.612" fill="#fff"/><polygon points="104.721 11.806 102.883 13.92 104.721 16.033 106.559 13.92 104.721 11.806" fill="#fff"/><path d="M104.721,4.227l1.759-2.022c-.937.266-1.868.545-2.8.828Z" fill="#fff"/><polygon points="114.996 70.837 113.154 72.95 114.996 75.064 116.834 72.95 114.996 70.837" fill="#fff"/><polygon points="114.996 59.031 113.154 61.144 114.996 63.258 116.834 61.144 114.996 59.031" fill="#fff"/><polygon points="114.996 47.225 113.154 49.338 114.996 51.452 116.834 49.338 114.996 47.225" fill="#fff"/><polygon points="114.996 35.419 113.154 37.532 114.996 39.646 116.834 37.532 114.996 35.419" fill="#fff"/><polygon points="114.996 23.612 113.154 25.726 114.996 27.84 116.834 25.726 114.996 23.612" fill="#fff"/><polygon points="114.996 11.806 113.154 13.92 114.996 16.033 116.834 13.92 114.996 11.806" fill="#fff"/><path d="M113.154,2.114,115,4.227l1.838-2.113-1.8-2.066-.1.023Z" fill="#fff"/><polygon points="125.268 75.064 127.107 72.95 125.268 70.837 123.43 72.95 125.268 75.064" fill="#fff"/><polygon points="125.268 63.258 127.107 61.144 125.268 59.031 123.43 61.144 125.268 63.258" fill="#fff"/><polygon points="125.268 51.452 127.107 49.338 125.268 47.225 123.43 49.338 125.268 51.452" fill="#fff"/><polygon points="125.268 39.646 127.107 37.532 125.268 35.419 123.43 37.532 125.268 39.646" fill="#fff"/><polygon points="125.268 27.84 127.107 25.726 125.268 23.612 123.43 25.726 125.268 27.84" fill="#fff"/><polygon points="125.268 16.033 127.107 13.92 125.268 11.806 123.43 13.92 125.268 16.033" fill="#fff"/><polygon points="127.107 2.114 125.268 0 123.43 2.114 125.268 4.227 127.107 2.114" fill="#fff"/><polygon points="135.541 75.064 137.383 72.95 135.541 70.837 133.703 72.95 135.541 75.064" fill="#fff"/><polygon points="135.541 63.258 137.383 61.144 135.541 59.031 133.703 61.144 135.541 63.258" fill="#fff"/><polygon points="135.541 51.452 137.383 49.338 135.541 47.225 133.703 49.338 135.541 51.452" fill="#fff"/><polygon points="135.541 39.646 137.383 37.532 135.541 35.419 133.703 37.532 135.541 39.646" fill="#fff"/><polygon points="135.541 27.84 137.383 25.726 135.541 23.612 133.703 25.726 135.541 27.84" fill="#fff"/><polygon points="135.541 16.033 137.383 13.92 135.541 11.806 133.703 13.92 135.541 16.033" fill="#fff"/><polygon points="137.383 2.114 135.541 0 133.703 2.114 135.541 4.227 137.383 2.114" fill="#fff"/><polygon points="145.742 286.348 147.581 284.234 145.742 282.121 143.904 284.234 145.742 286.348" fill="#fff"/><polygon points="145.742 274.542 147.581 272.428 145.742 270.315 143.904 272.428 145.742 274.542" fill="#fff"/><polygon points="145.742 262.736 147.581 260.622 145.742 258.509 143.904 260.622 145.742 262.736" fill="#fff"/><polygon points="145.742 250.929 147.581 248.815 145.742 246.702 143.904 248.815 145.742 250.929" fill="#fff"/><polygon points="145.742 239.123 147.581 237.01 145.742 234.896 143.904 237.01 145.742 239.123" fill="#fff"/><polygon points="154.177 284.234 156.015 286.348 157.854 284.234 156.015 282.121 154.177 284.234" fill="#fff"/><polygon points="156.015 270.315 154.177 272.428 156.015 274.542 157.854 272.428 156.015 270.315" fill="#fff"/><polygon points="156.015 258.509 154.177 260.622 156.015 262.736 157.854 260.622 156.015 258.509" fill="#fff"/><polygon points="156.015 246.702 154.177 248.815 156.015 250.929 157.854 248.815 156.015 246.702" fill="#fff"/><polygon points="156.015 234.896 154.177 237.01 156.015 239.123 157.854 237.01 156.015 234.896" fill="#fff"/><polygon points="164.45 284.234 166.288 286.348 168.13 284.234 166.288 282.121 164.45 284.234" fill="#fff"/><polygon points="166.288 270.315 164.45 272.428 166.288 274.542 168.13 272.428 166.288 270.315" fill="#fff"/><polygon points="166.288 258.509 164.45 260.622 166.288 262.736 168.13 260.622 166.288 258.509" fill="#fff"/><polygon points="166.288 246.702 164.45 248.815 166.288 250.929 168.13 248.815 166.288 246.702" fill="#fff"/><polygon points="166.288 234.896 164.45 237.01 166.288 239.123 168.13 237.01 166.288 234.896" fill="#fff"/><polygon points="174.724 284.234 176.563 286.348 178.401 284.234 176.563 282.121 174.724 284.234" fill="#fff"/><polygon points="176.563 270.315 174.724 272.428 176.563 274.542 178.401 272.428 176.563 270.315" fill="#fff"/><polygon points="176.563 258.509 174.724 260.622 176.563 262.736 178.401 260.622 176.563 258.509" fill="#fff"/><polygon points="176.563 246.702 174.724 248.815 176.563 250.929 178.401 248.815 176.563 246.702" fill="#fff"/><polygon points="176.563 234.896 174.724 237.01 176.563 239.123 178.401 237.01 176.563 234.896" fill="#fff"/><polygon points="184.997 284.234 186.835 286.348 188.674 284.234 186.835 282.121 184.997 284.234" fill="#fff"/><polygon points="186.835 270.315 184.997 272.428 186.835 274.542 188.674 272.428 186.835 270.315" fill="#fff"/><polygon points="186.835 258.509 184.997 260.622 186.835 262.736 188.674 260.622 186.835 258.509" fill="#fff"/><polygon points="186.835 246.702 184.997 248.815 186.835 250.929 188.674 248.815 186.835 246.702" fill="#fff"/><polygon points="186.835 234.896 184.997 237.01 186.835 239.123 188.674 237.01 186.835 234.896" fill="#fff"/><polygon points="195.268 284.234 197.11 286.348 198.948 284.234 197.11 282.121 195.268 284.234" fill="#fff"/><polygon points="197.11 270.315 195.268 272.428 197.11 274.542 198.948 272.428 197.11 270.315" fill="#fff"/><polygon points="197.11 258.509 195.268 260.622 197.11 262.736 198.948 260.622 197.11 258.509" fill="#fff"/><polygon points="197.11 246.702 195.268 248.815 197.11 250.929 198.948 248.815 197.11 246.702" fill="#fff"/><polygon points="197.11 234.896 195.268 237.01 197.11 239.123 198.948 237.01 197.11 234.896" fill="#fff"/><polygon points="205.545 284.234 207.383 286.348 209.221 284.234 207.383 282.121 205.545 284.234" fill="#fff"/><polygon points="207.383 270.315 205.545 272.428 207.383 274.542 209.221 272.428 207.383 270.315" fill="#fff"/><polygon points="207.383 258.509 205.545 260.622 207.383 262.736 209.221 260.622 207.383 258.509" fill="#fff"/><polygon points="207.383 246.702 205.545 248.815 207.383 250.929 209.221 248.815 207.383 246.702" fill="#fff"/><polygon points="207.383 234.896 205.545 237.01 207.383 239.123 209.221 237.01 207.383 234.896" fill="#fff"/><polygon points="215.817 272.428 217.656 274.542 219.497 272.428 217.656 270.315 215.817 272.428" fill="#fff"/><polygon points="217.656 258.509 215.817 260.622 217.656 262.736 219.497 260.622 217.656 258.509" fill="#fff"/><polygon points="217.656 246.702 215.817 248.815 217.656 250.929 219.497 248.815 217.656 246.702" fill="#fff"/><polygon points="217.656 234.896 215.817 237.01 217.656 239.123 219.497 237.01 217.656 234.896" fill="#fff"/><polygon points="226.092 272.428 227.93 274.542 229.769 272.428 227.93 270.315 226.092 272.428" fill="#fff"/><polygon points="227.93 258.509 226.092 260.622 227.93 262.736 229.769 260.622 227.93 258.509" fill="#fff"/><polygon points="227.93 246.702 226.092 248.815 227.93 250.929 229.769 248.815 227.93 246.702" fill="#fff"/><polygon points="227.93 234.896 226.092 237.01 227.93 239.123 229.769 237.01 227.93 234.896" fill="#fff"/><polygon points="236.365 260.622 238.203 262.736 240.042 260.622 238.203 258.509 236.365 260.622" fill="#fff"/><polygon points="238.203 246.702 236.365 248.815 238.203 250.929 240.042 248.815 238.203 246.702" fill="#fff"/><polygon points="238.203 234.896 236.365 237.01 238.203 239.123 240.042 237.01 238.203 234.896" fill="#fff"/><path d="M248.478,258.509l-1.842,2.113.929,1.067c.7-.6,1.391-1.22,2.081-1.837Z" fill="#fff"/><polygon points="248.478 250.929 250.316 248.815 248.478 246.702 246.636 248.815 248.478 250.929" fill="#fff"/><polygon points="248.478 239.123 250.316 237.01 248.478 234.896 246.636 237.01 248.478 239.123" fill="#fff"/><polygon points="260.589 248.815 258.751 246.702 256.912 248.815 258.751 250.929 260.589 248.815" fill="#fff"/><polygon points="256.912 237.01 258.751 239.123 260.589 237.01 258.751 234.896 256.912 237.01" fill="#fff"/><path d="M269.023,234.9l-1.838,2.114,1.766,2.03q.864-1.126,1.707-2.268Z" fill="#fff"/><polygon points="145.742 227.565 147.581 225.451 145.742 223.337 143.904 225.451 145.742 227.565" fill="#fff"/><polygon points="145.742 215.759 147.581 213.645 145.742 211.531 143.904 213.645 145.742 215.759" fill="#fff"/><polygon points="145.742 203.952 147.581 201.838 145.742 199.725 143.904 201.838 145.742 203.952" fill="#fff"/><polygon points="145.742 192.146 147.581 190.032 145.742 187.919 143.904 190.032 145.742 192.146" fill="#fff"/><polygon points="145.742 180.34 147.581 178.226 145.742 176.113 143.904 178.226 145.742 180.34" fill="#fff"/><polygon points="145.742 168.534 147.581 166.42 145.742 164.307 143.904 166.42 145.742 168.534" fill="#fff"/><polygon points="145.742 156.727 147.581 154.614 145.742 152.5 143.904 154.614 145.742 156.727" fill="#fff"/><polygon points="145.742 144.921 147.581 142.808 145.742 140.694 143.904 142.808 145.742 144.921" fill="#fff"/><polygon points="156.015 223.337 154.177 225.451 156.015 227.565 157.854 225.451 156.015 223.337" fill="#fff"/><polygon points="156.015 211.531 154.177 213.645 156.015 215.759 157.854 213.645 156.015 211.531" fill="#fff"/><polygon points="156.015 199.725 154.177 201.838 156.015 203.952 157.854 201.838 156.015 199.725" fill="#fff"/><polygon points="156.015 187.919 154.177 190.032 156.015 192.146 157.854 190.032 156.015 187.919" fill="#fff"/><polygon points="156.015 176.113 154.177 178.226 156.015 180.34 157.854 178.226 156.015 176.113" fill="#fff"/><polygon points="156.015 164.307 154.177 166.42 156.015 168.534 157.854 166.42 156.015 164.307" fill="#fff"/><polygon points="156.015 152.5 154.177 154.614 156.015 156.727 157.854 154.614 156.015 152.5" fill="#fff"/><polygon points="156.015 140.694 154.177 142.808 156.015 144.921 157.854 142.808 156.015 140.694" fill="#fff"/><polygon points="168.128 225.451 166.288 223.337 164.45 225.451 166.288 227.565 168.128 225.451" fill="#fff"/><polygon points="166.288 211.531 164.45 213.645 166.288 215.759 168.13 213.645 166.288 211.531" fill="#fff"/><polygon points="166.288 199.725 164.45 201.838 166.288 203.952 168.13 201.838 166.288 199.725" fill="#fff"/><polygon points="166.288 187.919 164.45 190.032 166.288 192.146 168.13 190.032 166.288 187.919" fill="#fff"/><polygon points="166.288 176.113 164.45 178.226 166.288 180.34 168.13 178.226 166.288 176.113" fill="#fff"/><polygon points="166.288 164.307 164.45 166.42 166.288 168.534 168.13 166.42 166.288 164.307" fill="#fff"/><polygon points="166.288 152.5 164.45 154.614 166.288 156.727 168.13 154.614 166.288 152.5" fill="#fff"/><polygon points="166.288 140.694 164.45 142.808 166.288 144.921 168.13 142.808 166.288 140.694" fill="#fff"/><polygon points="176.563 223.337 174.724 225.451 176.563 227.565 178.401 225.451 176.563 223.337" fill="#fff"/><polygon points="176.563 211.531 174.724 213.645 176.563 215.759 178.401 213.645 176.563 211.531" fill="#fff"/><polygon points="176.563 199.725 174.724 201.838 176.563 203.952 178.401 201.838 176.563 199.725" fill="#fff"/><polygon points="176.563 187.919 174.724 190.032 176.563 192.146 178.401 190.032 176.563 187.919" fill="#fff"/><polygon points="176.563 176.113 174.724 178.226 176.563 180.34 178.401 178.226 176.563 176.113" fill="#fff"/><polygon points="176.563 164.307 174.724 166.42 176.563 168.534 178.401 166.42 176.563 164.307" fill="#fff"/><polygon points="176.563 152.5 174.724 154.614 176.563 156.727 178.401 154.614 176.563 152.5" fill="#fff"/><polygon points="176.563 140.694 174.724 142.808 176.563 144.921 178.401 142.808 176.563 140.694" fill="#fff"/><polygon points="186.835 223.337 184.997 225.451 186.835 227.565 188.674 225.451 186.835 223.337" fill="#fff"/><polygon points="186.835 211.531 184.997 213.645 186.835 215.759 188.674 213.645 186.835 211.531" fill="#fff"/><polygon points="186.835 199.725 184.997 201.838 186.835 203.952 188.674 201.838 186.835 199.725" fill="#fff"/><polygon points="186.835 187.919 184.997 190.032 186.835 192.146 188.674 190.032 186.835 187.919" fill="#fff"/><polygon points="186.835 176.113 184.997 178.226 186.835 180.34 188.674 178.226 186.835 176.113" fill="#fff"/><polygon points="186.835 164.307 184.997 166.42 186.835 168.534 188.674 166.42 186.835 164.307" fill="#fff"/><polygon points="186.835 152.5 184.997 154.614 186.835 156.727 188.674 154.614 186.835 152.5" fill="#fff"/><polygon points="186.835 140.694 184.997 142.808 186.835 144.921 188.674 142.808 186.835 140.694" fill="#fff"/><polygon points="197.11 223.337 195.27 225.451 197.11 227.565 198.948 225.451 197.11 223.337" fill="#fff"/><polygon points="197.11 211.531 195.268 213.645 197.11 215.759 198.948 213.645 197.11 211.531" fill="#fff"/><polygon points="197.11 199.725 195.268 201.838 197.11 203.952 198.948 201.838 197.11 199.725" fill="#fff"/><polygon points="197.11 187.919 195.268 190.032 197.11 192.146 198.948 190.032 197.11 187.919" fill="#fff"/><polygon points="197.11 176.113 195.268 178.226 197.11 180.34 198.948 178.226 197.11 176.113" fill="#fff"/><polygon points="197.11 164.307 195.268 166.42 197.11 168.534 198.948 166.42 197.11 164.307" fill="#fff"/><polygon points="197.11 152.5 195.268 154.614 197.11 156.727 198.948 154.614 197.11 152.5" fill="#fff"/><polygon points="197.11 140.694 195.268 142.808 197.11 144.921 198.948 142.808 197.11 140.694" fill="#fff"/><polygon points="207.383 223.337 205.545 225.451 207.383 227.565 209.221 225.451 207.383 223.337" fill="#fff"/><polygon points="207.383 211.531 205.545 213.645 207.383 215.759 209.221 213.645 207.383 211.531" fill="#fff"/><polygon points="207.383 199.725 205.545 201.838 207.383 203.952 209.221 201.838 207.383 199.725" fill="#fff"/><polygon points="207.383 187.919 205.545 190.032 207.383 192.146 209.221 190.032 207.383 187.919" fill="#fff"/><polygon points="207.383 176.113 205.545 178.226 207.383 180.34 209.221 178.226 207.383 176.113" fill="#fff"/><polygon points="207.383 164.307 205.545 166.42 207.383 168.534 209.221 166.42 207.383 164.307" fill="#fff"/><polygon points="207.383 152.5 205.545 154.614 207.383 156.727 209.221 154.614 207.383 152.5" fill="#fff"/><polygon points="207.383 140.694 205.545 142.808 207.383 144.921 209.221 142.808 207.383 140.694" fill="#fff"/><polygon points="219.496 225.451 217.656 223.337 215.817 225.451 217.656 227.565 219.496 225.451" fill="#fff"/><polygon points="217.656 211.531 215.817 213.645 217.656 215.759 219.497 213.645 217.656 211.531" fill="#fff"/><polygon points="217.656 199.725 215.817 201.838 217.656 203.952 219.497 201.838 217.656 199.725" fill="#fff"/><polygon points="217.656 187.919 215.817 190.032 217.656 192.146 219.497 190.032 217.656 187.919" fill="#fff"/><polygon points="217.656 176.113 215.817 178.226 217.656 180.34 219.497 178.226 217.656 176.113" fill="#fff"/><polygon points="217.656 164.307 215.817 166.42 217.656 168.534 219.497 166.42 217.656 164.307" fill="#fff"/><polygon points="217.656 152.5 215.817 154.614 217.656 156.727 219.497 154.614 217.656 152.5" fill="#fff"/><polygon points="217.656 140.694 215.817 142.808 217.656 144.921 219.497 142.808 217.656 140.694" fill="#fff"/><polygon points="227.93 223.337 226.092 225.451 227.93 227.565 229.769 225.451 227.93 223.337" fill="#fff"/><polygon points="227.93 211.531 226.092 213.645 227.93 215.759 229.769 213.645 227.93 211.531" fill="#fff"/><polygon points="227.93 199.725 226.092 201.838 227.93 203.952 229.769 201.838 227.93 199.725" fill="#fff"/><polygon points="227.93 187.919 226.092 190.032 227.93 192.146 229.769 190.032 227.93 187.919" fill="#fff"/><polygon points="227.93 176.113 226.092 178.226 227.93 180.34 229.769 178.226 227.93 176.113" fill="#fff"/><polygon points="227.93 164.307 226.092 166.42 227.93 168.534 229.769 166.42 227.93 164.307" fill="#fff"/><polygon points="227.93 152.5 226.092 154.614 227.93 156.727 229.769 154.614 227.93 152.5" fill="#fff"/><polygon points="227.93 140.694 226.092 142.808 227.93 144.921 229.769 142.808 227.93 140.694" fill="#fff"/><polygon points="238.203 223.337 236.365 225.451 238.203 227.565 240.042 225.451 238.203 223.337" fill="#fff"/><polygon points="238.203 211.531 236.365 213.645 238.203 215.759 240.042 213.645 238.203 211.531" fill="#fff"/><polygon points="238.203 199.725 236.365 201.838 238.203 203.952 240.042 201.838 238.203 199.725" fill="#fff"/><polygon points="238.203 187.919 236.365 190.032 238.203 192.146 240.042 190.032 238.203 187.919" fill="#fff"/><polygon points="238.203 176.113 236.365 178.226 238.203 180.34 240.042 178.226 238.203 176.113" fill="#fff"/><polygon points="238.203 164.307 236.365 166.42 238.203 168.534 240.042 166.42 238.203 164.307" fill="#fff"/><polygon points="238.203 152.5 236.365 154.614 238.203 156.727 240.042 154.614 238.203 152.5" fill="#fff"/><polygon points="238.203 140.694 236.365 142.808 238.203 144.921 240.042 142.808 238.203 140.694" fill="#fff"/><polygon points="246.638 225.451 248.478 227.565 250.316 225.451 248.478 223.337 246.638 225.451" fill="#fff"/><polygon points="248.478 215.759 250.316 213.645 248.478 211.531 246.636 213.645 248.478 215.759" fill="#fff"/><polygon points="248.478 203.952 250.316 201.838 248.478 199.725 246.636 201.838 248.478 203.952" fill="#fff"/><polygon points="248.478 192.146 250.316 190.032 248.478 187.919 246.636 190.032 248.478 192.146" fill="#fff"/><polygon points="248.478 180.34 250.316 178.226 248.478 176.113 246.636 178.226 248.478 180.34" fill="#fff"/><polygon points="248.478 168.534 250.316 166.42 248.478 164.307 246.636 166.42 248.478 168.534" fill="#fff"/><polygon points="248.478 156.727 250.316 154.614 248.478 152.5 246.636 154.614 248.478 156.727" fill="#fff"/><polygon points="248.478 144.921 250.316 142.808 248.478 140.694 246.636 142.808 248.478 144.921" fill="#fff"/><polygon points="258.751 223.337 256.912 225.451 258.751 227.565 260.589 225.451 258.751 223.337" fill="#fff"/><polygon points="258.751 211.531 256.912 213.645 258.751 215.759 260.589 213.645 258.751 211.531" fill="#fff"/><polygon points="258.751 199.725 256.912 201.838 258.751 203.952 260.589 201.838 258.751 199.725" fill="#fff"/><polygon points="258.751 187.919 256.912 190.032 258.751 192.146 260.589 190.032 258.751 187.919" fill="#fff"/><polygon points="258.751 176.113 256.912 178.226 258.751 180.34 260.589 178.226 258.751 176.113" fill="#fff"/><polygon points="258.751 164.307 256.912 166.42 258.751 168.534 260.589 166.42 258.751 164.307" fill="#fff"/><polygon points="258.751 152.5 256.912 154.614 258.751 156.727 260.589 154.614 258.751 152.5" fill="#fff"/><polygon points="258.751 140.694 256.912 142.808 258.751 144.921 260.589 142.808 258.751 140.694" fill="#fff"/><polygon points="267.185 225.451 269.023 227.565 270.863 225.451 269.023 223.337 267.185 225.451" fill="#fff"/><polygon points="269.023 211.531 267.185 213.645 269.023 215.759 270.865 213.645 269.023 211.531" fill="#fff"/><polygon points="269.023 199.725 267.185 201.838 269.023 203.952 270.865 201.838 269.023 199.725" fill="#fff"/><polygon points="269.023 187.919 267.185 190.032 269.023 192.146 270.865 190.032 269.023 187.919" fill="#fff"/><polygon points="269.023 176.113 267.185 178.226 269.023 180.34 270.865 178.226 269.023 176.113" fill="#fff"/><polygon points="269.023 164.307 267.185 166.42 269.023 168.534 270.865 166.42 269.023 164.307" fill="#fff"/><polygon points="269.023 152.5 267.185 154.614 269.023 156.727 270.865 154.614 269.023 152.5" fill="#fff"/><polygon points="269.023 140.694 267.185 142.808 269.023 144.921 270.865 142.808 269.023 140.694" fill="#fff"/><path d="M279.445,223.337l-1.838,2.114.384.442c.508-.83,1-1.669,1.5-2.51Z" fill="#fff"/><polygon points="277.607 213.645 279.445 215.759 281.284 213.645 279.445 211.531 277.607 213.645" fill="#fff"/><polygon points="279.445 199.725 277.607 201.838 279.445 203.952 281.284 201.838 279.445 199.725" fill="#fff"/><polygon points="279.445 187.919 277.607 190.032 279.445 192.146 281.284 190.032 279.445 187.919" fill="#fff"/><polygon points="279.445 176.113 277.607 178.226 279.445 180.34 281.284 178.226 279.445 176.113" fill="#fff"/><polygon points="279.445 164.307 277.607 166.42 279.445 168.534 281.284 166.42 279.445 164.307" fill="#fff"/><polygon points="279.445 152.5 277.607 154.614 279.445 156.727 281.284 154.614 279.445 152.5" fill="#fff"/><polygon points="279.445 140.694 277.607 142.808 279.445 144.921 281.284 142.808 279.445 140.694" fill="#fff"/><path d="M289.718,199.725l-1.838,2.113,1.385,1.593c.389-.969.764-1.946,1.134-2.925Z" fill="#fff"/><polygon points="287.88 190.032 289.718 192.146 291.56 190.032 289.718 187.919 287.88 190.032" fill="#fff"/><polygon points="289.718 176.113 287.88 178.226 289.718 180.34 291.56 178.226 289.718 176.113" fill="#fff"/><polygon points="289.718 164.307 287.88 166.42 289.718 168.534 291.56 166.42 289.718 164.307" fill="#fff"/><polygon points="289.718 152.5 287.88 154.614 289.718 156.727 291.56 154.614 289.718 152.5" fill="#fff"/><polygon points="289.718 140.694 287.88 142.808 289.718 144.921 291.56 142.808 289.718 140.694" fill="#fff"/><path d="M298.154,166.42l.6.691c.07-.534.131-1.071.195-1.606Z" fill="#fff"/><path d="M298.154,154.614l1.6,1.843q.114-1.94.18-3.893Z" fill="#fff"/><path d="M298.154,142.808l1.839,2.113.007-.008q-.035-2.051-.122-4.087Z" fill="#fff"/><path d="M2.024,188.133c.267.952.547,1.9.832,2.843l.821-.944Z" fill="#fff"/><polygon points="3.677 178.226 1.838 176.113 0 178.226 1.838 180.34 3.677 178.226" fill="#fff"/><polygon points="0 166.42 1.838 168.534 3.677 166.42 1.838 164.307 0 166.42" fill="#fff"/><polygon points="1.838 152.5 0 154.614 1.838 156.727 3.677 154.614 1.838 152.5" fill="#fff"/><polygon points="1.838 140.694 0 142.808 1.838 144.921 3.677 142.808 1.838 140.694" fill="#fff"/><path d="M12.113,211.531l-.883,1.014c.434.9.882,1.8,1.334,2.7l1.387-1.595Z" fill="#fff"/><polygon points="10.271 201.838 12.113 203.952 13.951 201.838 12.113 199.725 10.271 201.838" fill="#fff"/><polygon points="12.113 187.919 10.271 190.032 12.113 192.146 13.951 190.032 12.113 187.919" fill="#fff"/><polygon points="12.113 176.113 10.271 178.226 12.113 180.34 13.951 178.226 12.113 176.113" fill="#fff"/><polygon points="12.113 164.307 10.271 166.42 12.113 168.534 13.951 166.42 12.113 164.307" fill="#fff"/><polygon points="12.113 152.5 10.271 154.614 12.113 156.727 13.951 154.614 12.113 152.5" fill="#fff"/><polygon points="12.113 140.694 10.271 142.808 12.113 144.921 13.951 142.808 12.113 140.694" fill="#fff"/><polygon points="30.966 237.01 32.808 239.123 34.646 237.01 32.808 234.896 30.966 237.01" fill="#fff"/><polygon points="44.919 248.815 43.08 246.702 41.242 248.815 43.08 250.929 44.919 248.815" fill="#fff"/><polygon points="41.242 237.01 43.08 239.123 44.919 237.01 43.08 234.896 41.242 237.01" fill="#fff"/><polygon points="51.515 260.622 53.353 262.736 55.195 260.622 53.353 258.509 51.515 260.622" fill="#fff"/><polygon points="53.353 246.702 51.515 248.815 53.353 250.929 55.195 248.815 53.353 246.702" fill="#fff"/><polygon points="53.353 234.896 51.515 237.01 53.353 239.123 55.195 237.01 53.353 234.896" fill="#fff"/><path d="M63.628,270.315l-1.4,1.609q1.152.791,2.32,1.56l.918-1.056Z" fill="#fff"/><polygon points="61.789 260.622 63.628 262.736 65.466 260.622 63.628 258.509 61.789 260.622" fill="#fff"/><polygon points="63.628 246.702 61.789 248.815 63.628 250.929 65.466 248.815 63.628 246.702" fill="#fff"/><polygon points="63.628 234.896 61.789 237.01 63.628 239.123 65.466 237.01 63.628 234.896" fill="#fff"/><polygon points="72.062 272.428 73.901 274.542 75.739 272.428 73.901 270.315 72.062 272.428" fill="#fff"/><polygon points="73.901 258.509 72.062 260.622 73.901 262.736 75.739 260.622 73.901 258.509" fill="#fff"/><polygon points="73.901 246.702 72.062 248.815 73.901 250.929 75.739 248.815 73.901 246.702" fill="#fff"/><polygon points="73.901 234.896 72.062 237.01 73.901 239.123 75.739 237.01 73.901 234.896" fill="#fff"/><path d="M84.174,282.121l-1.428,1.641q1.3.621,2.62,1.217l.649-.745Z" fill="#fff"/><polygon points="82.335 272.428 84.174 274.542 86.015 272.428 84.174 270.315 82.335 272.428" fill="#fff"/><polygon points="84.174 258.509 82.335 260.622 84.174 262.736 86.015 260.622 84.174 258.509" fill="#fff"/><polygon points="84.174 246.702 82.335 248.815 84.174 250.929 86.015 248.815 84.174 246.702" fill="#fff"/><polygon points="84.174 234.896 82.335 237.01 84.174 239.123 86.015 237.01 84.174 234.896" fill="#fff"/><polygon points="92.61 284.234 94.448 286.348 96.286 284.234 94.448 282.121 92.61 284.234" fill="#fff"/><polygon points="94.448 270.315 92.61 272.428 94.448 274.542 96.286 272.428 94.448 270.315" fill="#fff"/><polygon points="94.448 258.509 92.61 260.622 94.448 262.736 96.286 260.622 94.448 258.509" fill="#fff"/><polygon points="94.448 246.702 92.61 248.815 94.448 250.929 96.286 248.815 94.448 246.702" fill="#fff"/><polygon points="94.448 234.896 92.61 237.01 94.448 239.123 96.286 237.01 94.448 234.896" fill="#fff"/><polygon points="102.883 284.234 104.721 286.348 106.559 284.234 104.721 282.121 102.883 284.234" fill="#fff"/><polygon points="104.721 270.315 102.883 272.428 104.721 274.542 106.559 272.428 104.721 270.315" fill="#fff"/><polygon points="104.721 258.509 102.883 260.622 104.721 262.736 106.559 260.622 104.721 258.509" fill="#fff"/><polygon points="104.721 246.702 102.883 248.815 104.721 250.929 106.559 248.815 104.721 246.702" fill="#fff"/><polygon points="104.721 234.896 102.883 237.01 104.721 239.123 106.559 237.01 104.721 234.896" fill="#fff"/><polygon points="113.154 284.234 114.996 286.348 116.834 284.234 114.996 282.121 113.154 284.234" fill="#fff"/><polygon points="114.996 270.315 113.154 272.428 114.996 274.542 116.834 272.428 114.996 270.315" fill="#fff"/><polygon points="114.996 258.509 113.154 260.622 114.996 262.736 116.834 260.622 114.996 258.509" fill="#fff"/><polygon points="114.996 246.702 113.154 248.815 114.996 250.929 116.834 248.815 114.996 246.702" fill="#fff"/><polygon points="114.996 234.896 113.154 237.01 114.996 239.123 116.834 237.01 114.996 234.896" fill="#fff"/><polygon points="125.268 286.348 127.107 284.234 125.268 282.121 123.43 284.234 125.268 286.348" fill="#fff"/><polygon points="125.268 274.542 127.107 272.428 125.268 270.315 123.43 272.428 125.268 274.542" fill="#fff"/><polygon points="125.268 262.736 127.107 260.622 125.268 258.509 123.43 260.622 125.268 262.736" fill="#fff"/><polygon points="125.268 250.929 127.107 248.815 125.268 246.702 123.43 248.815 125.268 250.929" fill="#fff"/><polygon points="125.268 239.123 127.107 237.01 125.268 234.896 123.43 237.01 125.268 239.123" fill="#fff"/><polygon points="135.541 286.348 137.383 284.234 135.541 282.121 133.703 284.234 135.541 286.348" fill="#fff"/><polygon points="135.541 274.542 137.383 272.428 135.541 270.315 133.703 272.428 135.541 274.542" fill="#fff"/><polygon points="135.541 262.736 137.383 260.622 135.541 258.509 133.703 260.622 135.541 262.736" fill="#fff"/><polygon points="135.541 250.929 137.383 248.815 135.541 246.702 133.703 248.815 135.541 250.929" fill="#fff"/><polygon points="135.541 239.123 137.383 237.01 135.541 234.896 133.703 237.01 135.541 239.123" fill="#fff"/><polygon points="20.695 225.451 22.533 227.565 24.371 225.451 22.533 223.337 20.695 225.451" fill="#fff"/><polygon points="22.533 211.531 20.695 213.645 22.533 215.759 24.371 213.645 22.533 211.531" fill="#fff"/><polygon points="22.533 199.725 20.695 201.838 22.533 203.952 24.371 201.838 22.533 199.725" fill="#fff"/><polygon points="22.533 187.919 20.695 190.032 22.533 192.146 24.371 190.032 22.533 187.919" fill="#fff"/><polygon points="22.533 176.113 20.695 178.226 22.533 180.34 24.371 178.226 22.533 176.113" fill="#fff"/><polygon points="22.533 164.307 20.695 166.42 22.533 168.534 24.371 166.42 22.533 164.307" fill="#fff"/><polygon points="22.533 152.5 20.695 154.614 22.533 156.727 24.371 154.614 22.533 152.5" fill="#fff"/><polygon points="22.533 140.694 20.695 142.808 22.533 144.921 24.371 142.808 22.533 140.694" fill="#fff"/><polygon points="32.808 223.337 30.968 225.451 32.808 227.565 34.646 225.451 32.808 223.337" fill="#fff"/><polygon points="32.808 211.531 30.966 213.645 32.808 215.759 34.646 213.645 32.808 211.531" fill="#fff"/><polygon points="32.808 199.725 30.966 201.838 32.808 203.952 34.646 201.838 32.808 199.725" fill="#fff"/><polygon points="32.808 187.919 30.966 190.032 32.808 192.146 34.646 190.032 32.808 187.919" fill="#fff"/><polygon points="32.808 176.113 30.966 178.226 32.808 180.34 34.646 178.226 32.808 176.113" fill="#fff"/><polygon points="32.808 164.307 30.966 166.42 32.808 168.534 34.646 166.42 32.808 164.307" fill="#fff"/><polygon points="32.808 152.5 30.966 154.614 32.808 156.727 34.646 154.614 32.808 152.5" fill="#fff"/><polygon points="32.808 140.694 30.966 142.808 32.808 144.921 34.646 142.808 32.808 140.694" fill="#fff"/><polygon points="43.08 223.337 41.242 225.451 43.08 227.565 44.919 225.451 43.08 223.337" fill="#fff"/><polygon points="43.08 211.531 41.242 213.645 43.08 215.759 44.919 213.645 43.08 211.531" fill="#fff"/><polygon points="43.08 199.725 41.242 201.838 43.08 203.952 44.919 201.838 43.08 199.725" fill="#fff"/><polygon points="43.08 187.919 41.242 190.032 43.08 192.146 44.919 190.032 43.08 187.919" fill="#fff"/><polygon points="43.08 176.113 41.242 178.226 43.08 180.34 44.919 178.226 43.08 176.113" fill="#fff"/><polygon points="43.08 164.307 41.242 166.42 43.08 168.534 44.919 166.42 43.08 164.307" fill="#fff"/><polygon points="43.08 152.5 41.242 154.614 43.08 156.727 44.919 154.614 43.08 152.5" fill="#fff"/><polygon points="43.08 140.694 41.242 142.808 43.08 144.921 44.919 142.808 43.08 140.694" fill="#fff"/><polygon points="55.193 225.451 53.353 223.337 51.515 225.451 53.353 227.565 55.193 225.451" fill="#fff"/><polygon points="53.353 211.531 51.515 213.645 53.353 215.759 55.195 213.645 53.353 211.531" fill="#fff"/><polygon points="53.353 199.725 51.515 201.838 53.353 203.952 55.195 201.838 53.353 199.725" fill="#fff"/><polygon points="53.353 187.919 51.515 190.032 53.353 192.146 55.195 190.032 53.353 187.919" fill="#fff"/><polygon points="53.353 176.113 51.515 178.226 53.353 180.34 55.195 178.226 53.353 176.113" fill="#fff"/><polygon points="53.353 164.307 51.515 166.42 53.353 168.534 55.195 166.42 53.353 164.307" fill="#fff"/><polygon points="53.353 152.5 51.515 154.614 53.353 156.727 55.195 154.614 53.353 152.5" fill="#fff"/><polygon points="53.353 140.694 51.515 142.808 53.353 144.921 55.195 142.808 53.353 140.694" fill="#fff"/><polygon points="63.628 223.337 61.789 225.451 63.628 227.565 65.466 225.451 63.628 223.337" fill="#fff"/><polygon points="63.628 211.531 61.789 213.645 63.628 215.759 65.466 213.645 63.628 211.531" fill="#fff"/><polygon points="63.628 199.725 61.789 201.838 63.628 203.952 65.466 201.838 63.628 199.725" fill="#fff"/><polygon points="63.628 187.919 61.789 190.032 63.628 192.146 65.466 190.032 63.628 187.919" fill="#fff"/><polygon points="63.628 176.113 61.789 178.226 63.628 180.34 65.466 178.226 63.628 176.113" fill="#fff"/><polygon points="63.628 164.307 61.789 166.42 63.628 168.534 65.466 166.42 63.628 164.307" fill="#fff"/><polygon points="63.628 152.5 61.789 154.614 63.628 156.727 65.466 154.614 63.628 152.5" fill="#fff"/><polygon points="63.628 140.694 61.789 142.808 63.628 144.921 65.466 142.808 63.628 140.694" fill="#fff"/><polygon points="73.901 223.337 72.062 225.451 73.901 227.565 75.739 225.451 73.901 223.337" fill="#fff"/><polygon points="73.901 211.531 72.062 213.645 73.901 215.759 75.739 213.645 73.901 211.531" fill="#fff"/><polygon points="73.901 199.725 72.062 201.838 73.901 203.952 75.739 201.838 73.901 199.725" fill="#fff"/><polygon points="73.901 187.919 72.062 190.032 73.901 192.146 75.739 190.032 73.901 187.919" fill="#fff"/><polygon points="73.901 176.113 72.062 178.226 73.901 180.34 75.739 178.226 73.901 176.113" fill="#fff"/><polygon points="73.901 164.307 72.062 166.42 73.901 168.534 75.739 166.42 73.901 164.307" fill="#fff"/><polygon points="73.901 152.5 72.062 154.614 73.901 156.727 75.739 154.614 73.901 152.5" fill="#fff"/><polygon points="73.901 140.694 72.062 142.808 73.901 144.921 75.739 142.808 73.901 140.694" fill="#fff"/><polygon points="86.014 225.451 84.174 223.337 82.335 225.451 84.174 227.565 86.014 225.451" fill="#fff"/><polygon points="84.174 211.531 82.335 213.645 84.174 215.759 86.015 213.645 84.174 211.531" fill="#fff"/><polygon points="84.174 199.725 82.335 201.838 84.174 203.952 86.015 201.838 84.174 199.725" fill="#fff"/><polygon points="84.174 187.919 82.335 190.032 84.174 192.146 86.015 190.032 84.174 187.919" fill="#fff"/><polygon points="84.174 176.113 82.335 178.226 84.174 180.34 86.015 178.226 84.174 176.113" fill="#fff"/><polygon points="84.174 164.307 82.335 166.42 84.174 168.534 86.015 166.42 84.174 164.307" fill="#fff"/><polygon points="84.174 152.5 82.335 154.614 84.174 156.727 86.015 154.614 84.174 152.5" fill="#fff"/><polygon points="84.174 140.694 82.335 142.808 84.174 144.921 86.015 142.808 84.174 140.694" fill="#fff"/><polygon points="94.448 223.337 92.61 225.451 94.448 227.565 96.286 225.451 94.448 223.337" fill="#fff"/><polygon points="94.448 211.531 92.61 213.645 94.448 215.759 96.286 213.645 94.448 211.531" fill="#fff"/><polygon points="94.448 199.725 92.61 201.838 94.448 203.952 96.286 201.838 94.448 199.725" fill="#fff"/><polygon points="94.448 187.919 92.61 190.032 94.448 192.146 96.286 190.032 94.448 187.919" fill="#fff"/><polygon points="94.448 176.113 92.61 178.226 94.448 180.34 96.286 178.226 94.448 176.113" fill="#fff"/><polygon points="94.448 164.307 92.61 166.42 94.448 168.534 96.286 166.42 94.448 164.307" fill="#fff"/><polygon points="94.448 152.5 92.61 154.614 94.448 156.727 96.286 154.614 94.448 152.5" fill="#fff"/><polygon points="94.448 140.694 92.61 142.808 94.448 144.921 96.286 142.808 94.448 140.694" fill="#fff"/><polygon points="104.721 223.337 102.883 225.451 104.721 227.565 106.559 225.451 104.721 223.337" fill="#fff"/><polygon points="104.721 211.531 102.883 213.645 104.721 215.759 106.559 213.645 104.721 211.531" fill="#fff"/><polygon points="104.721 199.725 102.883 201.838 104.721 203.952 106.559 201.838 104.721 199.725" fill="#fff"/><polygon points="104.721 187.919 102.883 190.032 104.721 192.146 106.559 190.032 104.721 187.919" fill="#fff"/><polygon points="104.721 176.113 102.883 178.226 104.721 180.34 106.559 178.226 104.721 176.113" fill="#fff"/><polygon points="104.721 164.307 102.883 166.42 104.721 168.534 106.559 166.42 104.721 164.307" fill="#fff"/><polygon points="104.721 152.5 102.883 154.614 104.721 156.727 106.559 154.614 104.721 152.5" fill="#fff"/><polygon points="104.721 140.694 102.883 142.808 104.721 144.921 106.559 142.808 104.721 140.694" fill="#fff"/><polygon points="114.996 223.337 113.156 225.451 114.996 227.565 116.834 225.451 114.996 223.337" fill="#fff"/><polygon points="114.996 211.531 113.154 213.645 114.996 215.759 116.834 213.645 114.996 211.531" fill="#fff"/><polygon points="114.996 199.725 113.154 201.838 114.996 203.952 116.834 201.838 114.996 199.725" fill="#fff"/><polygon points="114.996 187.919 113.154 190.032 114.996 192.146 116.834 190.032 114.996 187.919" fill="#fff"/><polygon points="114.996 176.113 113.154 178.226 114.996 180.34 116.834 178.226 114.996 176.113" fill="#fff"/><polygon points="114.996 164.307 113.154 166.42 114.996 168.534 116.834 166.42 114.996 164.307" fill="#fff"/><polygon points="114.996 152.5 113.154 154.614 114.996 156.727 116.834 154.614 114.996 152.5" fill="#fff"/><polygon points="114.996 140.694 113.154 142.808 114.996 144.921 116.834 142.808 114.996 140.694" fill="#fff"/><polygon points="125.268 227.565 127.107 225.451 125.268 223.337 123.43 225.451 125.268 227.565" fill="#fff"/><polygon points="125.268 215.759 127.107 213.645 125.268 211.531 123.43 213.645 125.268 215.759" fill="#fff"/><polygon points="125.268 203.952 127.107 201.838 125.268 199.725 123.43 201.838 125.268 203.952" fill="#fff"/><polygon points="125.268 192.146 127.107 190.032 125.268 187.919 123.43 190.032 125.268 192.146" fill="#fff"/><polygon points="125.268 180.34 127.107 178.226 125.268 176.113 123.43 178.226 125.268 180.34" fill="#fff"/><polygon points="125.268 168.534 127.107 166.42 125.268 164.307 123.43 166.42 125.268 168.534" fill="#fff"/><polygon points="125.268 156.727 127.107 154.614 125.268 152.5 123.43 154.614 125.268 156.727" fill="#fff"/><polygon points="125.268 144.921 127.107 142.808 125.268 140.694 123.43 142.808 125.268 144.921" fill="#fff"/><polygon points="135.541 227.565 137.381 225.451 135.541 223.337 133.703 225.451 135.541 227.565" fill="#fff"/><polygon points="135.541 215.759 137.383 213.645 135.541 211.531 133.703 213.645 135.541 215.759" fill="#fff"/><polygon points="135.541 203.952 137.383 201.838 135.541 199.725 133.703 201.838 135.541 203.952" fill="#fff"/><polygon points="135.541 192.146 137.383 190.032 135.541 187.919 133.703 190.032 135.541 192.146" fill="#fff"/><polygon points="135.541 180.34 137.383 178.226 135.541 176.113 133.703 178.226 135.541 180.34" fill="#fff"/><polygon points="135.541 168.534 137.383 166.42 135.541 164.307 133.703 166.42 135.541 168.534" fill="#fff"/><polygon points="135.541 156.727 137.383 154.614 135.541 152.5 133.703 154.614 135.541 156.727" fill="#fff"/><polygon points="135.541 144.921 137.383 142.808 135.541 140.694 133.703 142.808 135.541 144.921" fill="#fff"/><polygon points="145.742 298.181 147.581 296.068 145.742 293.955 143.904 296.068 145.742 298.181" fill="#fff"/><polygon points="157.854 296.068 156.015 293.955 154.177 296.068 156.015 298.181 157.854 296.068" fill="#fff"/><path d="M166.288,293.955l-1.838,2.113,1.255,1.443c.432-.049.865-.094,1.295-.147l1.13-1.3Z" fill="#fff"/><path d="M176.563,293.955l-1.839,2.113.113.13c1.058-.186,2.11-.387,3.159-.595Z" fill="#fff"/><path d="M115,293.955l-.67.768c.547.125,1.1.239,1.649.357Z" fill="#fff"/><path d="M125.268,293.955l-1.838,2.113.431.5q1.239.2,2.486.379l.76-.874Z" fill="#fff"/><path d="M135.541,293.955l-1.838,2.113,1.65,1.9.35.031,1.68-1.928Z" fill="#fff"/></svg>
					</div>
					<div class="icon-graphic">
						<svg id="e1fc6299-5359-43f7-a8b6-5c08fe891dd8" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 300 300"><title>401_403_graphic</title><polygon points="247.096 211.2 262.596 195.6 262.596 65.5 247.096 50 52.896 50 37.396 65.5 37.396 195.6 52.896 211.2 247.096 211.2" fill="#e4f5fa"/><path d="M263.6,65.5a.91.91,0,0,0-.3-.7L247.8,49.3a.912.912,0,0,0-.7-.3H52.9a.915.915,0,0,0-.7.3L36.7,64.8a1.092,1.092,0,0,0-.3.7V195.6a.915.915,0,0,0,.3.7l15.5,15.5a.905.905,0,0,0,.7.3h72.9L117.7,249H105.4a1,1,0,0,0,0,2h89.3a1,1,0,0,0,0-2H182.5l-8.1-36.8h72.7a.9.9,0,0,0,.7-.3l15.5-15.5c.1-.1.2-.2.2-.3a.6.6,0,0,0,.1-.4ZM53.3,51H246.6l14.9,14.9V194.6H38.4V65.9ZM180.5,249H119.8l2.6-11.8h55.5Zm-3.1-13.8H122.8l5.1-23h44.5Zm69.3-25H53.3L39.8,196.6H260.2Z" fill="#226d7a"/><rect x="74.796" y="62.1" width="150.5" height="112" fill="#fff"/><circle cx="90.496" cy="74.4" r="3.5" fill="#226d7a"/><circle cx="100.996" cy="74.4" r="3.5" fill="#226d7a"/><circle cx="111.496" cy="74.4" r="3.5" fill="#226d7a"/><path d="M225.3,61.1H74.8a.947.947,0,0,0-1,.887h0a.71.71,0,0,0,0,.113v112a.945.945,0,0,0,.885,1h0a1.084,1.084,0,0,0,.114,0H225.3a.945.945,0,0,0,1-.886,1.084,1.084,0,0,0,0-.114V62.1A1,1,0,0,0,225.3,61.1Zm-1,2V85.6H75.8V63.1ZM75.8,173.1V87.6H224.3v85.5Z" fill="#226d7a"/><rect x="122.796" y="128.2" width="54.5" height="56.9" fill="#22b8d1"/><path d="M177.3,127.2H170V114a20,20,0,0,0-40,0v13.2h-7.3a.948.948,0,0,0-1,.887,1.065,1.065,0,0,0,0,.113v56.9a.945.945,0,0,0,.887,1h0a1.065,1.065,0,0,0,.113,0h54.5a.945.945,0,0,0,1-.886.723.723,0,0,0,0-.114V128.2a.916.916,0,0,0-.828-1H177.3ZM132.1,114a18,18,0,0,1,36,0v13.2h-2.7V114a15.2,15.2,0,0,0-30.4,0v13.2h-2.7V114Zm31.1,13.2H136.8V114a13.2,13.2,0,0,1,26.4,0Zm-39.4,15.1h19.3V145H123.8Zm0,28.4h19.3v2.7H123.8Zm0-9.5h19.3v2.7H123.8Zm0-9.5h19.3v2.7H123.8Zm52.5,32.4H123.8v-8.7h20.3a.945.945,0,0,0,1-.886,1.084,1.084,0,0,0,0-.114v-4.7a.944.944,0,0,0-.886-1h0a1.065,1.065,0,0,0-.113,0H123.8V166h20.3a.945.945,0,0,0,1-.886,1.084,1.084,0,0,0,0-.114v-4.7a.944.944,0,0,0-.886-1h0a1.065,1.065,0,0,0-.113,0H123.8v-2.7h20.3a.945.945,0,0,0,1-.886,1.084,1.084,0,0,0,0-.114v-4.7a.944.944,0,0,0-.886-1h0a1.065,1.065,0,0,0-.113,0H123.8V147h20.3a.945.945,0,0,0,1-.886,1.084,1.084,0,0,0,0-.114v-4.7a.944.944,0,0,0-.886-1h0a1.065,1.065,0,0,0-.113,0H123.8v-11h52.4Z" fill="#226d7a"/></svg>
					</div>
				</div>
				
				<h1 class="title title--regular title--size-large title--weight-bold"><?php echo esc_html( $title ); ?></h1>
				<p>&nbsp;</p>
				<p class ="title title--subtitle title--size-semimedium title--weight-normal"><?php echo esc_html( $message ); ?></p>
			</div>
			<div class="error--shape__clouds">
				<svg id="f95fc14d-9eb7-4d11-bcb9-651fb6dd69f0" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 2074.144 292.377"><title>clouds_shape</title><path d="M2034.093,187.309a40.338,40.338,0,0,0-6.537.579,57.445,57.445,0,0,0-101.344-53.826,39.917,39.917,0,0,0-53.631-9.69,57.478,57.478,0,0,0-76.107-65.161c.019-.589.045-1.175.045-1.767a57.443,57.443,0,1,0-114.885,0,58.165,58.165,0,0,0,.412,6.781,39.929,39.929,0,0,0-62.076,39.726,57.431,57.431,0,0,0-89.212,45.7,57.427,57.427,0,0,0-52.738,8.725,39.97,39.97,0,0,0-68.167-16.906c.043-.757.114-1.507.114-2.276a40.049,40.049,0,0,0-65.428-30.986,57.445,57.445,0,0,0-113.6,12.12c0,1.258.055,2.5.134,3.739a39.956,39.956,0,0,0-36.784,6.689,40.715,40.715,0,0,0,.212-4.139A40.019,40.019,0,0,0,1132.73,93a57.443,57.443,0,0,0-106.758-39.516,40.05,40.05,0,0,0-79.081,4.36,40.116,40.116,0,0,0-38.16.022c0-.139.011-.277.011-.417a57.443,57.443,0,1,0-114.474,6.781,39.929,39.929,0,0,0-62.076,39.726,57.431,57.431,0,0,0-89.212,45.7,57.427,57.427,0,0,0-52.738,8.725,39.97,39.97,0,0,0-68.167-16.906c.043-.757.114-1.507.114-2.276a40.049,40.049,0,0,0-65.428-30.986,57.445,57.445,0,0,0-113.6,12.12c0,1.258.055,2.5.134,3.739a39.956,39.956,0,0,0-36.784,6.689,40.715,40.715,0,0,0,.212-4.139A40.019,40.019,0,0,0,244.952,93,57.443,57.443,0,0,0,138.194,53.479a40.05,40.05,0,0,0-79.081,4.36A40.066,40.066,0,0,0,0,93.074v199.3H2074.144V227.363A40.052,40.052,0,0,0,2034.093,187.309Z" fill="#fff"/></svg>
			</div>
		</section>
	</div>
</body>
</html>